/*****************************************************************************/

/*
 *      gentbl.c  --  Linux soundcard HF FSK driver,
 *                    Table generator.
 *
 *      Copyright (C) 1997  Thomas Sailer (sailer@ife.ee.ethz.ch)
 *        Swiss Federal Institute of Technology (ETH), Electronics Lab
 *
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation; either version 2 of the License, or
 *      (at your option) any later version.
 *
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 *
 *      You should have received a copy of the GNU General Public License
 *      along with this program; if not, write to the Free Software
 *      Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *
 */

/*****************************************************************************/
      
#include "hfmodem.h"
#include <math.h>
#include <stdio.h>

/* --------------------------------------------------------------------- */

#ifndef FREQ_SPACE
#define FREQ_SPACE 1275
#endif

#ifndef FREQ_MARK
#define FREQ_MARK  1475
#endif

#define SINTABBITS  9
#define SINTABSIZE  (1<<SINTABBITS)

/* --------------------------------------------------------------------- */

static void gensintbl(void)
{
	int i;

	printf("#define SINTABBITS %d\n#define SINTABSIZE  (1<<SINTABBITS)\n"
	       "\nstatic short isintab[SINTABSIZE+SINTABSIZE/4] = {\n\t", SINTABBITS);
	for (i = 0; i < (SINTABSIZE+SINTABSIZE/4); i++) {
		printf("%6d", (int)(32767.0 * sin(2.0 * M_PI / SINTABSIZE * i)));
		if (i < (SINTABSIZE+SINTABSIZE/4)-1) {
			if ((i & 7) == 7)
				printf(",\n\t");
			else
				printf(",");
		}
	}
	printf("\n};\n\n#ifdef CONFIG_HFMODEM_FLOAT\n\n"
	       "static float fsintab[SINTABSIZE+SINTABSIZE/4] = {\n\t");
	for (i = 0; i < (SINTABSIZE+SINTABSIZE/4); i++) {
		printf("%12.9f", sin(2.0 * M_PI / SINTABSIZE * i));
		if (i < (SINTABSIZE+SINTABSIZE/4)-1) {
			if ((i & 3) == 3)
				printf(",\n\t");
			else
				printf(",");
		}
	}
	printf("\n};\n\n#endif /* CONFIG_HFMODEM_FLOAT */\n\n");
}

/* --------------------------------------------------------------------- */

static void gencoeff(void)
{
	static const unsigned short phinc[2] = { 
		(FREQ_SPACE*0x10000+(HFMODEM_SRATE/2))/HFMODEM_SRATE,
		(FREQ_MARK*0x10000+(HFMODEM_SRATE/2))/HFMODEM_SRATE
	};
	int i, j, k;
	unsigned int ph;


	printf("/* space frequency %d, mark frequency %d */\n"
	       "static struct hfmodem_ioctl_fsk_params fsk_par = {\n\t"
	       "{ 0x%04x, 0x%04x }, {{{\n\t\t", FREQ_SPACE, FREQ_MARK, phinc[0], phinc[1]);
	for (i = 0; i < 2; i++) {
		for (j = 0; j < 2; j++) {
			ph = j ? 0xc000 : 0;
			for (k = 0; k < HFMODEM_MAXCORRLEN; k++, ph += phinc[i]) {
				printf("%10.7f", cos(M_PI * (ph & 0xffff) / 32768.0));
				if (k < HFMODEM_MAXCORRLEN-1) {
					if ((k & 3) == 3)
						printf(",\n\t\t");
					else
						printf(",");
				}
			}
			if (!j)
				printf("\n\t}, {\n\t\t");
		}
		if (!i)
			printf("\n\t}}, {{\n\t\t");
	}
	printf("\n\t}}}\n};\n");
}

/* --------------------------------------------------------------------- */

int main(int argc, char *argv[])
{
	printf("/*\n * This file is automatically generated by %s, DO NOT EDIT!\n*/\n\n",
	       argv[0]);
	gensintbl();
	exit(0);
}

/* --------------------------------------------------------------------- */

