/*****************************************************************************/

/*
 *      rxtx.c  --  routines for file selection,receiving, storing, sending
 *	and text macro management
 * 	for the simple HF terminal program.
 *
 *      Copyright (C) 1996  Thomas Sailer (sailer@ife.ee.ethz.ch)
 *        Swiss Federal Institute of Technology (ETH), Electronics Lab
 *	modified 2000-2004 by Axel Krause & Gnther Montag (dl4mge@darc.de).
 *
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation; either version 2 of the License, or
 *      (at your option) any later version.
 *
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 *
 *      You should have received a copy of the GNU General Public License
 *      along with this program; if not, write to the Free Software
 *      Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *
 */

/*****************************************************************************/

#include "hft.h"
#include "rxtx.h"

#ifndef DEBUG
#define DEBUG printf("%s: function %s still running at line %d...\n", \
__FILE__, __FUNCTION__,  __LINE__);

#define D DEBUG
#endif /* DEBUG */

/* --------------------------------------------------------------------- */

int autorx_on = 0, autotx_on = 0;
int beacon_on = 0, beaconcount = 0, fixbeacon = 0;
int qrt_pending = 0;
char specialfile[256], rxfilehead[256], rxfilefoot[256]; 
char beaconbuffer[MAXKEY], keytext[MAXKEY];
const char *fixmagic = 
"	* * * * * * *	YOUR MAGIC KEYS: 	* * * * * * * \n"
"[B] 		will transmit the text as BEACON. (Stop it with <Alt>b.)\n"
"[MYCALL] [OP] [QTH] [LOC] [RIG] [PWR] [ANT] [WWW]\n"
"		will be replaced by your entries from 'Personal Edit'.\n"
"[TIME]		will print a timestamp.\n"
"[ACALL] (Amtor), [PCALL] = [CALL] (Pactor + RTTY), [GCALL] (Gtor)\n"
"		is your QSO-Partner's call, taken from 'Parameters'.\n"
"[LTIME] [LCALL] [LNAME] [LQTH] [LRSTIN] [LRSTOUT] [LNOTES] [LMODE] [LBAND]\n"
"		will be replaced by the corresponding fielod of last log entry.\n"
"You can use 'Strg-X, Strg-C, Strg-V to cut, copy and insert from one window to another.\n"
"To use the fixtexts, press Shift-F<number> or click the text macro buttons. Have a lot of fun!";
FILE *rxfile;

/* --------------------------------------------------------------- */

void transmit(const char *fmt, ... )
{
// transmits text, e.g. to be used for automatic messages in mailbox mode...
	unsigned int len;
        va_list args;
	char text[256];
	char v;
	int l;
	GtkText *txt;
		
	if (!fmt || !(len = strlen(fmt)))
	    return;

	memset (text, 0, sizeof(text));
        va_start(args, fmt);
	vsnprintf(text, sizeof(text), fmt, args);	
        va_end(args);

	autotx();
	txt = GTK_TEXT(gtk_object_get_data(GTK_OBJECT(wmain), "textedit"));
	gtk_text_insert(txt, radiofont, NULL, NULL, text, strlen(text));
//	display_status("transmitting text %s", text);
	edit_newline();
	for(l = 0; l < strlen(text); l++) {
	    v = text[l];
	    edit_addchar(v);
	}	
	edit_newline();
	return;				
}

/* --------------------------------------------------------------- */

void create_rxfilehead()
{
    timequery();
    rxfilehead[0] = 0;
    sprintf(rxfilehead, "\n* * * * Start of received data by hfterm * * * *\n"
	"OP: %s \nGMT: %s \n\n", params.pactor.mycall, gmt);
    //display_status( "rx file head prepared: %s \n", rxfilehead);
}

/* --------------------------------------------------------------- */

void create_rxfilefoot()
{
    timequery();
    rxfilefoot[0] = 0;
    sprintf(rxfilefoot, "\n\n* * * * End of received data by hfterm * * * *\n"
	"OP: %s \nGMT: %s \n", params.pactor.mycall, gmt);
    //display_status( "rx file foot prepared: %s \n", rxfilehead);
}

/* --------------------------------------------------------------- */

void textinsert(char *filename, GtkText *text)
  {
  	FILE *fi;
  	char buf[16];
  	if ((radiofont = gdk_font_load("7x13")) == NULL)
	    display_status("simple font 7x13 could not be loaded.");
  	fi = fopen(filename, "r");
  	if(fi == NULL)
  	  {
  	    display_status( "file %s can not be opened.\n", filename);
	    return;
	  }
  	while ( !feof(fi) )
	  {
            memset(buf, 0, sizeof(buf));
	    fgets(buf, 15, fi);
	    gtk_text_insert(text, radiofont, NULL, NULL, buf, -1);
	 }
  	fclose(fi);				
 }

/* --------------------------------------------------------------- */

void parse(char* magic, char* bragitem)
{
/* parses fixtexts for macros. Uncomment fprintfs to see ho it 
   works, its greaaat, from scratch by dl4mge -----------------------*/
// if you change this, change char fixmagic, see above
    if(strstr(keytext, magic) != 0)
    {
	char a[2048];
	char *c;
	while(strstr(keytext, magic) != 0)
	{
	  memset(a, 0, sizeof(a));
	  c =  strstr(keytext, magic);
//	  display_status( "\n\na anfangs\n%s", a); 
//	  display_status( "\ngefunden: %d\n", c - keytext); 
	  strncpy(a, keytext, (c - keytext));
//	  display_status( "\n\na nach 1. Teil\n%s", a); 
	  strcat(a, bragitem);
//	  display_status( "\n\na nach brag\n%s", a); 
	  strcat(a, c + strlen(magic));
//	  display_status( "\n\na nach 2. Teil\n%s", a);
	  strcpy(keytext, a);
//	  printf("\nkeytext:\n%s", keytext);
	}
    }
    return;
}

/* --------------------------------------------------------------- */

void fixtext_send(int fixnr)
{
/* calls parse function for call, rig, ant etc. 
   Also if the fixtext is to be transmitted as beacon, 
   it has to be parsed before every transmit,
   because it may contain a timestamp ! -------------------------------------*/
	int i = fixnr, l, fixlength;
	char v, *fixtext, fixtextname[8];
	GtkText *txt;
		
	sprintf(fixtextname, "text%hu", i);
	fixlength = gtk_text_get_length
	    (GTK_TEXT(gtk_object_get_data
		(GTK_OBJECT(Wfixtext), fixtextname)));
	fixtext = gtk_editable_get_chars
	    (GTK_EDITABLE(gtk_object_get_data
		(GTK_OBJECT(Wfixtext), fixtextname)), 0, fixlength);
		
	if (fixlength > 0)
	{
	  timequery();
	  strcpy(keytext, fixtext);
	  parse("[CALL]", params.pactor.destcall);
          parse("[PCALL]", params.pactor.destcall);
          parse("[ACALL]", params.amtor.destcall);
          parse("[GCALL]", params.gtor.destcall);
          parse("[MYCALL]", brag.call);
          parse("[OP]", brag.op);
          parse("[QTH]", brag.qth);
          parse("[LOC]", brag.loc);
          parse("[RIG]", brag.rig);
          parse("[PWR]", brag.pwr);
          parse("[ANT]", brag.ant);
          parse("[WWW]", brag.www);
          parse("[TIME]", gmt);
          if (lb.logsize != 0) {
          	parse ("[LTIME]", lb.line[lb.logsize].time);
          	parse ("[LCALL]", lb.line[lb.logsize].call);
          	parse ("[LNAME]", lb.line[lb.logsize].name);
          	parse ("[LQTH]", lb.line[lb.logsize].qth);
          	parse ("[LRSTIN]", lb.line[lb.logsize].rstin);
          	parse ("[LRSTOUT]", lb.line[lb.logsize].rstout);
          	parse ("[LNOTES]", lb.line[lb.logsize].notes);
          	parse ("[LMODE]", lb.line[lb.logsize].mode);
          	parse ("[LBAND]", lb.line[lb.logsize].band);
          	display_status("I replaced magic keys [L...] from log entry Nr. %d", lb.logsize);
          }
          else {
          	display_status
		    ("did not parse magic keys from macro concerning log,\n"
          	    "because no log entry was specified");
          }
	  if ( strstr(keytext, "[B]") ) {
	      display_status("[B] magic key in fixtext -> beacon");
              parse("[B]", " ");
	      fixbeacon = i;
	      beacon_on = 1;
	      autotx();     
	      autorx_on = 1; 
	     // beacon_fixtext_prepare();
	  }
/*
//	no use now, autotx / rx is now default
	  if ( strstr(keytext, "[TX]") ) {
	      display_status("[TX] magic key in fixtext -> autotx");
              parse("[TX]", " ");
	      autotx();
	  }
	  if ( strstr(keytext, "[RX]") ) {
	      autorx_on = 1;
	      parse("[RX]", " ");
	      display_status("[RX] magic key in fixtext -> autorx after tx.");
	  }
*/
	  txt = GTK_TEXT(gtk_object_get_data(GTK_OBJECT(wmain), "textedit"));
	  gtk_text_insert(txt, radiofont, NULL, NULL, keytext, strlen(keytext));
	  
	  display_status("transmitting fixtext %hu",  i);
	  edit_newline();
	  for(l = 0; l < strlen(keytext); l++)
	  {
	    	v = keytext[l];
	    	edit_addchar(v);
	  }	
	  edit_newline();
	}
	return;				
}

/* --------------------------------------------------------------- */

void fixtext_read()
{
/* - 12 Fix - Texte einlesen ----------------------------------------*/
	FILE *fix;
	int i; 
	char fixfilename[32], fixtextname[8], buf[16];
	for (i = 1; i < 13; i++)
	{
		sprintf(fixfilename, "hf/fix.%02hu", i);
		sprintf(fixtextname, "text%hu", i);
		fix = fopen(fixfilename, "r");
		if(fix == NULL)
		{
		  display_status( "fixtextfile %s can not be opened.\n", fixfilename);
		  break;
		}
		
		while ( !feof(fix) )
		{
			memset(buf, 0, sizeof(buf));
			fgets(buf, 15, fix);
			gtk_text_insert ((GTK_TEXT(gtk_object_get_data(GTK_OBJECT(Wfixtext), fixtextname))) , NULL, NULL, NULL, buf, -1);
		}
		fclose(fix);				
	}
}	
  
/* --------------------------------------------------------------- */

void fixtext_store()
{
/* - 12 Fix - Texte speichern ---------------------------------------*/
	FILE *fix;
	int i, fixlength;
	char *fixtext, fixfilename[32], fixtextname[8];

	for (i = 1; i < 13; i++)
	{
  	  sprintf(fixfilename, "hf/fix.%02hu", i);
	  sprintf(fixtextname, "text%hu", i);
	  fix = fopen(fixfilename, "w");
	  if(fix == NULL)
	  {
	    display_status( "fixtextfile %s can not be opened.\n", fixfilename);
	    return;
	  }
	  fixlength = gtk_text_get_length(GTK_TEXT(gtk_object_get_data(GTK_OBJECT(Wfixtext), fixtextname)));
	  fixtext = gtk_editable_get_chars(GTK_EDITABLE(gtk_object_get_data(GTK_OBJECT(Wfixtext), fixtextname)), 0, fixlength);
	  if (fixlength > 0)
	  {
	    if ( (fwrite(fixtext, fixlength, 1, fix)) != 1)
	    {
	      display_status("Error in writing fixtextfile %s\n", fixfilename);
	      return;
	    }  
	    fclose(fix);				
	  }
	}
}

/* --------------------------------------------------------------- */

void file_send()
{
/* Datei senden, ohne Parserfunktion -------------------------------------------------*/
	FILE *txfile;
	char c = 0;
	GtkText *txt;

	txt = GTK_TEXT(gtk_object_get_data(GTK_OBJECT(wmain), "textedit"));
	fileselection_dialog("choose file for transmit ...");
	txfile = fopen(specialfile, "r");
	if(txfile == NULL) {
	    display_status("transmit file %s can not be opened.", specialfile);
	    return;
	}
	display_status("starting transmission of file %s ...", specialfile);
	edit_newline();
	while (1) {
	    c = fgetc(txfile);      
	    if (!feof(txfile)) {
	    	gtk_text_insert(txt, radiofont, NULL, NULL, &c, 1);
    	    edit_addchar(c);
    	    }
    	    else break;
	}	
	edit_newline();
	fclose (txfile);
	display_status("transmission of file %s complete.", specialfile);
	return;				
}

/* --------------------------------------------------------------- */

void beacon_file_prepare()
{
/* prepare beacon with fileselection dialog ----------------------------------------------*/
	FILE *beaconfile;
	char c = 0;
	int buffercount = 0;

	memset(beaconbuffer, 0, sizeof(beaconbuffer));
	fileselection_dialog
	    ("select small (<512 characters) file for beacon text ...");
	beaconfile = fopen(specialfile, "r");
	if(beaconfile == NULL) {
	    display_status("beacon file %s can not be opened.", specialfile);
	    return;
	}
	display_status
	    ("will read (part of) beaconfile %s into buffer", specialfile);
	display_status("empty buffer contains: \n%s", beaconbuffer);
	
	while (buffercount < sizeof(beaconbuffer) - 1) {
	    c = fgetc(beaconfile);
    	    if (!feof(beaconfile)) {
		beaconbuffer[buffercount] = c;
		buffercount++;
	    }
	    else break;
    	}
//	while ( !feof(beaconfile) ){
//	fgets(beaconbuffer, sizeof(beaconbuffer), beaconfile);
//	}
	fclose(beaconfile);				
	display_status
	    ("have read (part of) beaconfile %s into buffer", specialfile);
	display_status("buffer contains now: \n%s", beaconbuffer);
	display_status("Will start beacon tx from file %s ...\n"
		"You can stop the beacon with <Alt>b .", specialfile);
//	autorx_on = 1;
//	beacon_send();
}			

/* --------------------------------------------------------------- */

void beacon_fixtext_prepare()
{
/* prepare beacon with fixtext ----------------------------------------------*/
/* not used, found better way */
	memset(beaconbuffer, 0, sizeof(beaconbuffer));
	strcpy(beaconbuffer, keytext);
	display_status
	    ("copied parsed fixtext into beaconbuffer.\n"
	    "Starting beacon transmission of fixtext.\n"
	    "You can stop the beacon with <Alt>b.");
	beacon_on = 1;
	autorx_on = 1;
//	beacon_send();
}			

/* --------------------------------------------------------------- */

void beacon_send() {
	GtkText *txt = NULL;			
	int l;
	char v = 0;

	if (fixbeacon) {
	// a fixtext with the [B] magic key is the beacon text
	    autorx_on = 1;
	    autotx();
	    fixtext_send(fixbeacon);
	}
	else if (beaconbuffer[0]) {
	    // else: the before selected file has been read into beaconbuffer
	    txt = GTK_TEXT(gtk_object_get_data(GTK_OBJECT(wmain), "textedit"));
	    gtk_text_insert 
		(txt, NULL, NULL, NULL, beaconbuffer, strlen(beaconbuffer));
	    autotx();
	    for(l = 0; l < strlen(beaconbuffer); l++) {
		v = beaconbuffer[l];
		edit_addchar(v);
	    } 
	}
	else {
	    display_status("no beacon text prepared!\n"
			   "You can select a fixtext with the [B] magic key as beacon text,\n"
			   "or you can select a file with <Alt>B.");
	    return;
	}	
	autorx_on = 1;
	beaconcount++;
	display_status("Beacon count: %d ...", beaconcount);
	if (beaconcount % 10 == 0) {
	    display_status("Beacon tx is active !"
			"Please do not disturb your ham friends and "
			"do not let your rig unattended !\n"
			"You can stop the beacon with <Alt>b !");
	}
}

/* --------------------------------------------------------------- */

void beacon_stop() {
	autorx();
	display_status("Beacon transmission stopped.");
	display_status("after %d transmissions", beaconcount);
	beaconcount = 0;
	fixbeacon = 0; // resets nr. of fixtext last sent as beacon
		       // so next time beacon is again the first selected file
	return;				
}

/* --------------------------------------------------------------- */

void rx_routine_store_prepare()
{
/* - Rx - Text vorbereiten   --------------------------------------------*/
	//if you want many rxfiles:
	//sprintf(rxfilename, "hf/hfrx.%hu", getpid());
	//or maybe instead of getpid do something with timestamp / gmt
	char *rxfilename =  "hf/hfrx";

	if (rxfile_ready) return;

	remove("hf/hfrx.old.01");
  	rename("hf/hfrx.old.02", "hf/hfrx.old.01");	  
  	rename("hf/hfrx.old.03", "hf/hfrx.old.02");
	rename("hf/hfrx.old.04", "hf/hfrx.old.03");	  
  	rename("hf/hfrx.old.05", "hf/hfrx.old.04");
	rename("hf/hfrx", "hf/hfrx.old.05");	  
	create_rxfilehead();
	rxfile = fopen(rxfilename, "w");
	if(rxfile == NULL) {
	    display_status("rx-file %s can not be opened first time.\n", rxfilename);
	    return;
	}
	if ( (fwrite(rxfilehead, strlen(rxfilehead), 1, rxfile)) != 1) {
    	    display_status
		("Error in writing head lines to new routine rx-file %s\n", 
		rxfilename);
	    errprintf(SEV_WARNING,
		"Error in writing head lines to new routine rx-file %s\n", 
		rxfilename);
        return;
	}
	fclose(rxfile);
	// open rxfile for append for duration of whole program
	// hope so quicker and prevent crashes in pactor rx when lot of rx
	rxfile = fopen(rxfilename, "a");
	if(rxfile == NULL)
	  {
	    display_status("rx-file %s can not be opened.\n", rxfilename);
	    errprintf(SEV_WARNING,
		"Error in opening routine rx-file %s for appending data\n", 
		rxfilename);
	    return;
	  }
	display_status("rx-file %s is opened for rx data\n", rxfilename);
	rxfile_ready = 1;
}

/* --------------------------------------------------------------- */

void rx_routine_store_part()
{
/* - Rx - Text bei laufendem Programm teilweise (hier: halb) speichern ------*/
	char *rxfilename =  "hf/hfrx";
	char *rxtxt;
	int rxlength = 0;
	rxlength = gtk_text_get_length(GTK_TEXT
	    (gtk_object_get_data(GTK_OBJECT(wmain), 
	    "textmain")));
	rxtxt = gtk_editable_get_chars(GTK_EDITABLE
	    (gtk_object_get_data(GTK_OBJECT(wmain), 
	    "textmain")), 0, rxlength);
	if ( (fwrite(rxtxt, MAXRX / 2 -1, 1, rxfile)) != 1)
	  {
	    display_status
		("Error in writing to rx-file %s\n", rxfilename);
	    errprintf(SEV_WARNING, 
		"Error in writing to rx-file %s\n", rxfilename);
	    return;
	  }
//	fwrite("\n", strlen("\n"), 1, rxfile);
//	fclose(rxfile);	
//	display_status("Older half of Rx Data stored in ~/hf/hfrx\n");
	return;
}

/* --------------------------------------------------------------- */

void rx_routine_store_rest()
{
/* - Rx - Text vor Beenden speichern ---------------------------------------*/
	char *rxfilename =  "hf/hfrx";
	char *rxtxt;
	GtkText *txt;
	int rxlength, i;

	txt = GTK_TEXT(gtk_object_get_data(GTK_OBJECT(wmain),"textmain"));
	rxlength = gtk_text_get_length(GTK_TEXT
	    (gtk_object_get_data(GTK_OBJECT(wmain), 
	    "textmain")));

	if (rxlength > 0)
	{
	    if (! rxfile_ready) {
		//display_status("rx data file not yet prepared. Will do it...");
		//errprintf
		//    (SEV_INFO, "rx data file not yet prepared. Will do it...\n");
		rx_routine_store_prepare();
		//display_status("... done.");
		//errprintf
		//    (SEV_INFO, "... done.\n");
		
	    }
	    gtk_text_freeze(txt);
	    rxtxt = gtk_editable_get_chars(GTK_EDITABLE
		(gtk_object_get_data(GTK_OBJECT(wmain), 
	    	"textmain")), 0, rxlength);
	    if ( (i = fwrite(rxtxt, rxlength -1, 1, rxfile)) != 1) {
		//display_status
		//    ("Error in final writing to rx-file %s", rxfilename);
		errprintf
		    (SEV_WARNING, "Error in final writing to rx-file %s\n", 
		    rxfilename);
		return;
	    }
	    //display_status
	//	("final writing to rx-file %s: rxlength %d, written %d bytes", 
	//	rxfilename, rxlength, i);
	    create_rxfilefoot();	
	    fwrite(rxfilefoot, strlen(rxfilefoot), 1, rxfile);
	    fclose(rxfile);	
	    //display_status( "Rest of Rx Data stored in %s\n", rxfilename);
	    //errprintf
	    //	(SEV_INFO, "Rest of Rx Data stored in rx-file %s\n", 
	    //	    rxfilename);
	    return;
	} else {
	    //errprintf
	    //	(SEV_INFO,  "You had no rx - you get no rx-file.\n");
	    return;
	}  
}

/* --------------------------------------------------------------- */

/* - fileselection universal---------------------------------------------- */

void fileselection_dialog(char *title)
{
	GtkWidget *filedialog;
//there should be defined global in this file a char specialfile[256]; 
//long array because maybe with path.
	memset(specialfile, 0, sizeof(specialfile));	
//	display_status("specialfilereset  o.k.: %s\n", specialfile);
	filedialog = gtk_file_selection_new(title);
	gtk_window_set_modal(GTK_WINDOW(filedialog), TRUE);
		gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(filedialog)->ok_button),
	    "clicked", (GtkSignalFunc) fileselection, filedialog);
	gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(filedialog)->cancel_button),
	    "clicked", (GtkSignalFunc) fileselection_cancel, filedialog);
	gtk_signal_connect(GTK_OBJECT(filedialog),
	    "destroy", (GtkSignalFunc) fileselection_cancel, filedialog);
//	display_status( "widget filedialog created.\n");
//	display_status("widget filedialog created.\n");
	gtk_widget_show(filedialog);
//	display_status("after showing file selection menu \n");
//	display_status( "after showing file selection menu \n");
	gtk_main();
//	display_status("after gtk-main \n");
//	display_status( "after gtk-main \n");
//	display_status( "specialfile still o.k.: %s\n", specialfile);
//	display_status("specialfile still o.k.: %s\n", specialfile);
}

/* --------------------------------------------------------------- */

void fileselection(GtkWidget *widget, GtkWidget * filedialog)
{
	char *selectedname = NULL;
		
	selectedname = gtk_file_selection_get_filename(GTK_FILE_SELECTION(filedialog));
//	display_status( "fileselection o.k.: %s\n", selectedname);
	if ((strlen(selectedname) > 0) && (strlen(selectedname) < 64))  {
	    display_status("filename length between 1 and 64, o.k.: %s", selectedname);
	    sleep (1);
	    if (selectedname[strlen(selectedname) -1] == 47) {
	 	//sleep(1);   
		display_status("You selected %s, it's a directory! Try again!", 
		    selectedname);
	    }
	    else {
	        //display_status("You selected %s, o.k.", selectedname);
	        strcpy(specialfile, selectedname); 
	        display_status("You selected %s, o.k.", specialfile);
	    }
	}
	gtk_widget_destroy(filedialog);
   	gtk_main_quit();
}

void fileselection_cancel(GtkWidget *widget, GtkWidget * filedialog)
{
    gtk_widget_destroy(filedialog);
    gtk_main_quit();
}

/* - fileselection ------------------------------------------------------- */

/* --------------------------------------------------------------- */

void rx_demand_store()
{
/* - Dateiauswahlmen zum Speichern des Rx-Testes -------------------------*/
    GtkText *txt;
    FILE *rxfile;
    char *rxtxt = NULL;
    int rxlength = 0;
    
    txt = GTK_TEXT(gtk_object_get_data(GTK_OBJECT(wmain),"textmain"));
    rxlength = gtk_text_get_length(GTK_TEXT(gtk_object_get_data(GTK_OBJECT(wmain), 
	"textmain")));
    if (rxlength == 0) {
    	// this no no stuff for test of display_status.....
	display_status("You had %s rx - you can get %s rx-file.", "no", "no");
    	return;
    }
    else {
    	display_status("You received something ... choose a file...");
	fileselection_dialog("Save rx input as file ...");
    }
    if (specialfile[0] == 0) {
    	display_status(	"rxfilename %s not yet specified.\n", specialfile);
        return;
    }
    display_status( "rx-file %s has been prepared.\n", specialfile);
    display_status("rx-file %s has been prepared.", specialfile);
    rxfile = fopen(specialfile, "w");
    if (rxfile == NULL){
        display_status(	"rx-file %s can not be opened.\n", specialfile);
        return;
    }
    gtk_text_freeze(txt);
    rxlength = gtk_text_get_length(GTK_TEXT(gtk_object_get_data(GTK_OBJECT(wmain), 
	"textmain")));
    rxtxt = gtk_editable_get_chars(GTK_EDITABLE(gtk_object_get_data(GTK_OBJECT(wmain), 
	"textmain")), 0, rxlength);
    create_rxfilehead();
    if ( (fwrite(rxfilehead, strlen(rxfilehead), 1, rxfile)) != 1) {
        display_status(	
	    "Error in writing head lines to choosen rx-file %s\n", 
	    specialfile);
        return;
    }
    if ( (fwrite(rxtxt, rxlength, 1, rxfile)) != 1) {
        display_status(	
	    "Error in writing rx-text to choosen rx-file %s\n", 
	    specialfile);
        return;
    }
    create_rxfilefoot();
    if ( fwrite(rxfilefoot, strlen(rxfilefoot), 1, rxfile)!= 1) {
        display_status(	
	    "Error in writing rx-text to choosen rx-file %s\n", 
	    specialfile);
        return;
    }
    fclose(rxfile);	
    gtk_text_thaw(txt);
    display_status("rx-file %s has been written.", specialfile);
    display_status( "Rx Data stored in %s\n", specialfile);    
    return;
}	

/* --------------------------------------------------------------- */

void userrx() 
{
    // user rx / tx beats autorx/tx, so reset the auto functions
    //display_status("rx on demand -> resetting auto rx and tx");
    //errprintf((SEV_INFO, "rx on demand -> resetting auto rx and tx");
	way = RX;
	autorx_on = 0;
	autotx_on = 0;
}

/* --------------------------------------------------------------- */

void usertx() 
{
// user rx / tx beats autorx/tx, so reset the auto functions
//display_status("tx on demand -> resetting auto rx and tx");
//errprintf((SEV_INFO, "tx on demand -> resetting auto rx and tx");
	way = TX;
	autorx_on = 0;
	autotx_on = 0;
}

/* --------------------------------------------------------------- */

void autotx()
{
/* automatic transmit function;
 * used from callbacks.c: on_text_keypres_event
 * and by the mailbox functions
 */
	struct hfapp_msg msg;
	int fittingtx = 0;

	if (autotx_on == 1) return;
	if (way == TX) return;

	autorx_on = 1;
	autotx_on = 1;	
	
	switch (lastrx) {

	    case HFAPP_MSG_MODE_IRS:
	    case HFAPP_MSG_STATE_PACTOR_IRS:
	    case HFAPP_MSG_STATE_AMTOR_IRS:
	    case HFAPP_MSG_STATE_GTOR_IRS:
	    case HFAPP_MSG_STATE_PACTOR_ARQ_SLAVECONNECT:
	    case HFAPP_MSG_STATE_AMTOR_ARQ_SLAVECONNECT:
	    case HFAPP_MSG_STATE_GTOR_ARQ_SLAVECONNECT:
		fittingtx = HFAPP_MSG_MODE_ISS;
		display_status ("autotx: switch slaveconnect or IRS -> ISS"); 
		break;

	    case HFAPP_MSG_START_PACTOR_STANDBY: 
		fittingtx = HFAPP_MSG_START_PACTOR_FEQ;
		display_status ("autotx: switch to Pactor FEC"); 
		break;

	//    case HFAPP_MSG_MODE_QRT: 
	//	fittingtx = 0;  
	//	display_status("last command was QRT. No autotx possible.");
	//	return;
	//	break;


	    case HFAPP_MSG_STATE_AMTOR_COLFEC_RX:
		fittingtx = HFAPP_MSG_START_AMTOR_COLFEQ;
		display_status ("autotx: switch to Amtor COLFEC"); 
		break;
		
	    case HFAPP_MSG_STATE_AMTOR_FEC_CONNECT:
	    case HFAPP_MSG_STATE_AMTOR_SELFEC_RX:	
		//fitttingtx = HFAPP_MSG_START_AMTOR_SELFEC; gibts nicht
		fittingtx = HFAPP_MSG_MODE_ISS; 
		display_status ("autotx: switch to ISS"); 
		break;
		

	    case HFAPP_MSG_START_RTTY_RX:
	    case HFAPP_MSG_STATE_RTTY_RX:
		fittingtx = HFAPP_MSG_START_RTTY_TX;
		display_status ("autotx: switch to RTTY TX"); 
		break;

	    default:
		fittingtx = lasttx;
		if ( fittingtx == 0 ) {   
		    display_status("error finding auto rx mode: %d", fittingtx);
		    return;
		}
		break;
	}
	
	msg.hdr.err = htonl(ERR_NOERR);
	msg.hdr.len = htonl(0);
	msg.hdr.type = htonl(fittingtx);
	msg_send(&msg);
 	//display_status("AUTO TRANSMIT LAST TX MODE: %d", fittingtx);
	lasttx = fittingtx;
	autorx_on = 1;
	autotx_on = 1;	
	way = TX;
	return;
}

/* --------------------------------------------------------------- */

void autorx()
{
	struct hfapp_msg msg;
	int fittingrx;

	if (way	== RX) return;
	if (autorx_on == 0) {
	    display_status ("autorx_on = 0. No autorx."); 
	    return;
	} 
	//display_status ("autorx_on = 1. Preparing autorx function."); 
	//errprintf(SEV_INFO, "autorx_on = 1. Preparing autorx function."); 
	
        switch (lasttx) {
	    case HFAPP_MSG_MODE_ISS:
	    case HFAPP_MSG_STATE_PACTOR_ISS:
	    case HFAPP_MSG_STATE_AMTOR_ISS:
	    case HFAPP_MSG_STATE_GTOR_ISS:
	    case HFAPP_MSG_STATE_AMTOR_ARQ_MASTERCONNECT:
	    case HFAPP_MSG_STATE_GTOR_ARQ_MASTERCONNECT:
		fittingrx = HFAPP_MSG_MODE_IRS;
		display_status ("autorx: switch to IRS"); 
		break;

	    case HFAPP_MSG_START_PACTOR_FEQ: 
	    case HFAPP_MSG_STATE_PACTOR_ARQ_DISCONNECT:
		fittingrx = HFAPP_MSG_START_PACTOR_STANDBY;
		display_status ("autorx: switch to Pactor Standby"); 
		break;

	    case HFAPP_MSG_MODE_QRT:
	    case HFAPP_MSG_START_AMTOR_COLFEQ:
	    case HFAPP_MSG_START_AMTOR_SELFEQ:
	    case HFAPP_MSG_STATE_AMTOR_FEC_CONNECT:
	    case HFAPP_MSG_STATE_AMTOR_FEC_DISCONNECT:
	    case HFAPP_MSG_STATE_AMTOR_ARQ_DISCONNECT:
	    case HFAPP_MSG_STATE_GTOR_ARQ_DISCONNECT:
		fittingrx =  HFAPP_MSG_START_STANDBY;
		display_status ("autorx: switch to Standby"); 
		break;

	    case HFAPP_MSG_START_RTTY_TX:
	    case HFAPP_MSG_STATE_RTTY_TX:
		fittingrx = HFAPP_MSG_START_RTTY_RX;
		display_status ("autorx: switch to RTTX RX"); 
//		errprintf(SEV_INFO, "autorx: switch to RTTX RX\n"); 
		break;
		
	    default:
	    	fittingrx = lastrx;
//		display_status ("autorx: switch back to last used RX mode"); 		
		if ( fittingrx == 0 ) {   
		    display_status("error in finding last rx mode: %d", 
			fittingrx);
		    errprintf(SEV_WARNING, 
			"autorx: error finding last rx mode: %d", fittingrx); 
    		    fittingrx =  HFAPP_MSG_START_STANDBY;
		    display_status 
			("but because autorx should always work "
			"we switch to Pactor/Amtor/Gtor Standby"); 
		}
		break;
	}

/* 
 * trial: send QRT msg
 
	msg.hdr.err = htonl(ERR_NOERR);
	msg.hdr.len = htonl(0);
	msg.hdr.type = htonl(HFAPP_MSG_MODE_QRT);
	msg_send(&msg);
	display_status("QRT");
*/

/* 
 *  switch to the fittingrx mode by sending a msg
 */

	msg.hdr.err = htonl(ERR_NOERR);
	msg.hdr.len = htonl(0);
	msg.hdr.type = htonl(fittingrx);
	msg_send(&msg);
	//display_status("AUTO RECEIVE MODE: %d", fittingrx);
	//errprintf(SEV_INFO, "autorx: auto rx mode %d", fittingrx); 
	lastrx = fittingrx;
	userrx();
	return;
}

/* --------------------------------------------------------------------- */

void qrt() {
	struct hfapp_msg msg;

	msg.hdr.err = htonl(ERR_NOERR);
	msg.hdr.len = htonl(0);
	msg.hdr.type = htonl(HFAPP_MSG_MODE_QRT);
	msg_send(&msg);
	display_status("automatic QRT.");
	lasttx = HFAPP_MSG_MODE_QRT;
	qrt_pending = 0;
}

/* --------------------------------------------------------------------- */
