/*
 * Hexxagon board game.
 * Copyright (C) 2001 Erik Jonsson.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * Email erik@nesqi.homeip.net
 * 
 */

#ifndef _RENDERING_H
#define _RENDERING_H

#define BOARD_WIDTH  569
#define BOARD_HEIGHT 638

#include <gtk/gtk.h>

int init_board_graphics();
void clear_board();
void render_thinking();
int get_cell_from_pos(int x, int y);
void find_all_cells();
void render_piece_to_board(int no, int pl);
void render_digit_to_board(int dig, int x, int y);
void draw_rgb_to_board(guchar *src, int x, int y, int w, int h);
void fill_cell(int no, int color);
void reset_cell(int no);

#endif //_RENDERING_H
