#
# ***** BEGIN LICENSE BLOCK *****
# Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
# 
# The contents of this file, and the files included with this file,
# are subject to the current version of the RealNetworks Public
# Source License (the "RPSL") available at
# http://www.helixcommunity.org/content/rpsl unless you have licensed
# the file under the current version of the RealNetworks Community
# Source License (the "RCSL") available at
# http://www.helixcommunity.org/content/rcsl, in which case the RCSL
# will apply. You may also obtain the license terms directly from
# RealNetworks.  You may not use this file except in compliance with
# the RPSL or, if you have a valid RCSL with RealNetworks applicable
# to this file, the RCSL.  Please see the applicable RPSL or RCSL for
# the rights, obligations and limitations governing use of the
# contents of the file.
# 
# Alternatively, the contents of this file may be used under the
# terms of the GNU General Public License Version 2 or later (the
# "GPL") in which case the provisions of the GPL are applicable
# instead of those above. If you wish to allow use of your version of
# this file only under the terms of the GPL, and not to allow others
# to use your version of this file under the terms of either the RPSL
# or RCSL, indicate your decision by deleting the provisions above
# and replace them with the notice and other provisions required by
# the GPL. If you do not delete the provisions above, a recipient may
# use your version of this file under the terms of any one of the
# RPSL, the RCSL or the GPL.
# 
# This file is part of the Helix DNA Technology. RealNetworks is the
# developer of the Original Code and owns the copyrights in the
# portions it created.
# 
# This file, and the files included with this file, is distributed
# and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
# KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
# ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
# OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
# ENJOYMENT OR NON-INFRINGEMENT.
# 
# Technology Compatibility Kit Test Suite(s) Location:
#    http://www.helixcommunity.org/content/tck
# 
# Contributor(s): Stanislav Brabec <sbrabec@suse.cz>
#                 Nicholas Hart <nhart@real.com>
#                 Ryan Gammon <rgammon@real.com>
# 
# ***** END LICENSE BLOCK *****
# 

# Please submit bugfixes or comments via http://www.suse.de/feedback/

# norootforbuild
# neededforbuild  gnome-filesystem gnome-icon-theme update-desktop-files shared-mime-info libxml2 glib2

BuildRequires: aaa_base acl attr bash bzip2 coreutils cpio cpp cracklib cvs cyrus-sasl db devs diffutils e2fsprogs file filesystem fillup findutils gawk glibc glibc-devel glibc-locale gpm grep groff gzip info insserv kbd less libacl libattr libgcc libselinux libstdc++ libxcrypt make man mktemp module-init-tools net-tools netcfg openldap2-client openssl pam pam-modules patch permissions popt procinfo procps psmisc pwdutils readline sed strace syslogd sysvinit tar tcpd timezone unzip util-linux vim binutils gcc gdbm gnome-filesystem gnome-icon-theme perl rpm update-desktop-files

Name:           RealPlayer
%define _translations de es fr it ja ko pt_BR zh_CN zh_TW 
License:        RPSL
Group:          Productivity/Multimedia/Video/Players
Provides:       rvplayer
Obsoletes:      rvplayer, G2player, RealOne
PreReq:         /bin/rm shared-mime-info
Requires:       gnome-icon-theme
Autoreqprov:    on
Version:        10.0.1
Release:        5
Summary:        RealPlayer 10 for Linux
URL:            http://www.real.com/linux
Source:         install.bz2
Patch1:         RealPlayer-desktop.patch
Patch2:         RealPlayer-helixlibs.patch
Requires:       gtk2
BuildRoot:      %{_tmppath}/%{name}-%{version}-build

# This spec file is tri-licensed as GPL, RCSL, and RPSL.
# The original version of this file has a license block to this effect.
# There is a bug in the SuSE build system. It may replace the license
# block with a SuSE-specific copyright -- this header is not correct.
# Please submit all modifications back to dev@player.helixcommunity.org
# under the terms of the GPL/RPSL.

%description
RealPlayer is a media player providing solid media playback locally 
and via streaming. It plays RealAudio, RealVideo, MP3, 3GPP Video, 
Flash, SMIL 2.0, JPEG, GIF, PNG, RealPix and RealText and 
more. The RealPlayer 10 for Linux builds on top of the popular 
GPL/RPSL Helix Player 1.0.

%prep
%setup -c

%patch1 -p1 -b .desktop
%patch2 -p1 -b .helixlibs

%build

%install
rm -rf $RPM_BUILD_ROOT
mkdir -p $RPM_BUILD_ROOT/usr/%_lib/browser-plugins
mkdir -p $RPM_BUILD_ROOT/opt/mozilla/lib/plugins
mkdir -p $RPM_BUILD_ROOT/opt/gnome/share/icons/hicolor/{16x16,32x32,48x48,192x192}/{apps,mimetypes}
mkdir -p $RPM_BUILD_ROOT/usr/share/mime/packages
mkdir -p $RPM_BUILD_ROOT/usr/share/applications
mkdir -p $RPM_BUILD_ROOT/usr/share/pixmaps
mkdir -p $RPM_BUILD_ROOT/opt/gnome/share/mime-info
mkdir -p $RPM_BUILD_ROOT/opt/gnome/share/application-registry
mkdir -p $RPM_BUILD_ROOT/usr/bin
mkdir -p $RPM_BUILD_ROOT/usr/%_lib/RealPlayer10
mkdir -p $RPM_BUILD_ROOT/usr/%_lib/RealPlayer10/share
cp -a ./codecs $RPM_BUILD_ROOT/usr/%_lib/RealPlayer10
cp -a ./common $RPM_BUILD_ROOT/usr/%_lib/RealPlayer10
cp -a ./plugins $RPM_BUILD_ROOT/usr/%_lib/RealPlayer10
cp -a ./share/default $RPM_BUILD_ROOT/usr/%_lib/RealPlayer10/share
cp -a ./share/realplay $RPM_BUILD_ROOT/usr/%_lib/RealPlayer10/share
cp ./README $RPM_BUILD_ROOT/usr/%_lib/RealPlayer10
cp ./LICENSE $RPM_BUILD_ROOT/usr/%_lib/RealPlayer10

for LANGUAGE in %{_translations}; do
    mkdir -p $RPM_BUILD_ROOT/usr/share/locale/$LANGUAGE/LC_MESSAGES
    mkdir -p $RPM_BUILD_ROOT/usr/%_lib/RealPlayer10/share/locale/$LANGUAGE
    cp "./share/locale/$LANGUAGE/player.mo" "$RPM_BUILD_ROOT/usr/share/locale/$LANGUAGE/LC_MESSAGES/realplay.mo"
    cp "./share/locale/$LANGUAGE/widget.mo" "$RPM_BUILD_ROOT/usr/share/locale/$LANGUAGE/LC_MESSAGES/libgtkhx.mo"
    cp "./share/locale/$LANGUAGE/README" "$RPM_BUILD_ROOT/usr/%_lib/RealPlayer10/share/locale/$LANGUAGE"
    cp "./share/locale/$LANGUAGE/LICENSE" "$RPM_BUILD_ROOT/usr/%_lib/RealPlayer10/share/locale/$LANGUAGE"
done

for SIZE in "48x48" "192x192" ; do
    for MIME in \
        "application-ram"     \
        "application-rpm"     \
	"application-rm"      \
	"text-realtext"	      \
        "audio-mp4"           \
        "audio-ra"            \
        "video-rv" ; do
        ICON="./share/icons/mime-${MIME}_$SIZE.png"
        cp "$ICON" "$RPM_BUILD_ROOT/opt/gnome/share/icons/hicolor/$SIZE/mimetypes/realplay-${MIME}.png"
    done
done

install -p -m644 ./share/realplay.png $RPM_BUILD_ROOT/usr/share/pixmaps
install -p -m644 ./share/realplay.desktop $RPM_BUILD_ROOT/usr/share/applications
install -p -m644 ./share/realplay.xml $RPM_BUILD_ROOT/usr/share/mime/packages/realplay.xml
install -p -m644 ./share/realplay.applications $RPM_BUILD_ROOT/opt/gnome/share/application-registry
install -p -m644 ./share/realplay.keys $RPM_BUILD_ROOT/opt/gnome/share/mime-info
install -p -m644 ./share/realplay.mime $RPM_BUILD_ROOT/opt/gnome/share/mime-info

cp ./mozilla/nphelix.so $RPM_BUILD_ROOT/usr/%_lib/browser-plugins
cp ./mozilla/nphelix.xpt $RPM_BUILD_ROOT/usr/%_lib/browser-plugins

cp ./realplay.bin $RPM_BUILD_ROOT/usr/%_lib/RealPlayer10
cp ./realplay $RPM_BUILD_ROOT/usr/bin

%suse_update_desktop_file -i realplay X-SuSE-Core-Multimedia

%clean
rm -rf %buildroot

%pre
# Remove obsolete file from old version (up to SuSE Linux 9.0).
rm -f /usr/%_lib/RealPlayer8/mimeinstall.log
rmdir /usr/%_lib/RealPlayer8 2>/dev/null || true

%post
/usr/bin/update-mime-database /usr/share/mime > /dev/null

%postun
/usr/bin/update-mime-database /usr/share/mime > /dev/null

%files
%defattr(-,root,root)
%doc README LICENSE
/usr/%_lib/RealPlayer10
/usr/%_lib/browser-plugins/*
/opt/mozilla/lib/plugins/
/usr/share/applications/*.desktop
/opt/gnome/share/icons/hicolor/*/*/*.png
/usr/share/mime/packages/*.*
/usr/share/pixmaps/*.png
/usr/share/locale/*/LC_MESSAGES/*
/usr/bin/realplay
/opt/gnome/share/mime-info/*.*
/opt/gnome/share/application-registry/*.applications

%changelog
* Fri Sep 24 2004 Ryan Gammon <rgammon@real.com> 
- Add release notes and eula

* Thu Sep 23 2004 Ryan Gammon <rgammon@real.com> 
- Remove icons that are covered in NLD's desktop
- Add icons for realtext and rm

* Mon Sep 20 2004 Ryan Gammon <rgammon@real.com> 
- Merging in changes from Stanislav:
- The neededforbuild stuff
- A comment about the license block
- re-add application-registry
- x-realplay.xml -> realplay.xml
- uncomment %clean section
- Use %doc
- Remove the mime patch, as this stuff is getting merged in for 1.0.1

* Fri Sep 17 2004 Ryan Gammon <rgammon@real.com> 
- Changing hicolor icon path to /opt/gnome/share/icons/hicolor
- Removed links in /opt/mozilla/lib/plugin
- Moved realplay.xml to /usr/share/mime/packages
- Added update-mime-database pre- and post-installs
- Added all available translated languages
- Added gnome-icon-theme to Requires
- Added .keys, .mime to /usr/share/mime-info
- Apply a patch to sanitize .mime, .xml

* Thu Sep 16 2004 Ryan Gammon <rgammon@real.com> 
- Merging nhart's real.com spec file with sbrabec's SUSE/NLD spec file 
- to create a spec file (hopefully) compatible with both our build 
- systems.
