/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: hxbin.h,v 1.1.10.5 2004/07/09 01:48:31 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

/*
  HXBin is somewhat similar to GtkAlignment, with a couple of
  differences:
  - It can only contain a HXPlayer widget 
  - It doesn't display frames around things
  - If the ideal size of the contained HXPlayer is smaller than
    the size of the HXBin, don't stretch it to fit.
  - Provides an unflickering background (backing window), unlike the
    GtkFixed that was being used before.

  It also fixes some set_size_request/size_allocate ugliness, and
  gives us a place to put some layout code that might be useful
  to others.
 */

#ifndef __HX_BIN_H__
#define __HX_BIN_H__

#include <gdk/gdk.h>
#include <gtk/gtkbin.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


#define HX_TYPE_BIN                  (hx_bin_get_type ())
#define HX_BIN(obj)                  (G_TYPE_CHECK_INSTANCE_CAST ((obj), HX_TYPE_BIN, HXBin))
#define HX_BIN_CLASS(klass)          (G_TYPE_CHECK_CLASS_CAST ((klass), HX_TYPE_BIN, HXBinClass))
#define HX_IS_BIN(obj)               (G_TYPE_CHECK_INSTANCE_TYPE ((obj), HX_TYPE_BIN))
#define HX_IS_BIN_CLASS(klass)       (G_TYPE_CHECK_CLASS_TYPE ((klass), HX_TYPE_BIN))
#define HX_BIN_GET_CLASS(obj)        (G_TYPE_INSTANCE_GET_CLASS ((obj), HX_TYPE_BIN, HXBinClass))


typedef struct _HXBin       HXBin;
typedef struct _HXBinClass  HXBinClass;

struct _HXBin
{
    GtkBin widget;
    gboolean maintain_aspect_ratio;
    gboolean stretch_to_fit;
    gint player_ideal_size_changed_handler;
};

struct _HXBinClass
{
    GtkBinClass parent_class;
};

GType      hx_bin_get_type                (void) G_GNUC_CONST;
GtkWidget* hx_bin_new                     (void);

/* Aspect ratio is maintained by default */
void       hx_bin_maintain_aspect_ratio   (HXBin*    bin,
                                           gboolean  enable);
void       hx_bin_stretch_to_fit          (HXBin*   bin,
                                           gboolean enable);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __HX_BIN_H__ */
