/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: clipdetails.cpp,v 1.1.2.4.2.1 2004/09/14 01:38:48 rggammon Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#include "clipdetails.h"

#include "commonapp.h"

#include <string.h>

typedef struct
{
    GladeXML* xml;
    HXPlayer* player;
    guint handler;

    GtkWidget* url_label;
    GtkWidget* title_label;
    GtkWidget* author_label;
    GtkWidget* copyright_label;
    GtkWidget* abstract_label;
    GtkWidget* description_label;
    GtkWidget* keywords_label;
    
} HXClipDetailsDialog;

static void
clip_details_label_size_request(GtkWidget* widget, GtkRequisition* req)
{
    /* Truncate the labels. */
    req->width = 1;
}

static void
update_clip_info(HXClipDetailsDialog* dialog)
{
    const gchar* url;
    GValue value;
    gboolean result;
    const gchar* prop;

    memset(&value, 0, sizeof(value));
    
    url = hx_player_get_url(dialog->player);    
    gtk_label_set_text(GTK_LABEL(dialog->url_label), url? url: "");    
    
    result = hx_player_get_statistic(dialog->player, "title", &value);
    if(result)
    {
        prop = g_value_get_string(&value);
        gtk_label_set_text(GTK_LABEL(dialog->title_label), prop);
        g_value_unset(&value);            
    }

    result = hx_player_get_statistic(dialog->player, "author", &value);
    if(result)
    {
        prop = g_value_get_string(&value);
        gtk_label_set_text(GTK_LABEL(dialog->author_label), prop);
        g_value_unset(&value);            
    }

    result = hx_player_get_statistic(dialog->player, "copyright", &value);
    if(result)
    {
        prop = g_value_get_string(&value);
        gtk_label_set_text(GTK_LABEL(dialog->copyright_label), prop);
        g_value_unset(&value);            
    }

    result = hx_player_get_statistic(dialog->player, "abstract", &value);
    if(result)
    {
        prop = g_value_get_string(&value);
        gtk_label_set_text(GTK_LABEL(dialog->abstract_label), prop);
        g_value_unset(&value);            
    }

    result = hx_player_get_statistic(dialog->player, "description", &value);
    if(result)
    {
        prop = g_value_get_string(&value);
        gtk_label_set_text(GTK_LABEL(dialog->description_label), prop);
        g_value_unset(&value);            
    }

    result = hx_player_get_statistic(dialog->player, "keywords", &value);
    if(result)
    {
        prop = g_value_get_string(&value);
        gtk_label_set_text(GTK_LABEL(dialog->keywords_label), prop);
        g_value_unset(&value);            
    }
}

static void
hcdd_destroy (GtkWidget* /* widget */,
             HXClipDetailsDialog* info)
{
    g_signal_handler_disconnect(G_OBJECT (info->player), info->handler);
    glade_xml_destroy (info->xml);

    g_free(info);
}

GtkDialog*
hxplay_clip_details_dialog_new(HXPlayer* player)
{
    GladeXML* xml;
    GtkWidget* dialog;
    gchar* filename;
    HXClipDetailsDialog* info = NULL;

    filename = hxcommon_locate_file("clipdetails.glade");
    xml = glade_xml_new (filename, NULL, NULL);
    g_free(filename);
    g_return_val_if_fail(xml != NULL, NULL);

    info = g_new0(HXClipDetailsDialog, 1);

    info->xml = xml;
    info->player = player;
    
    /* Launch the dialog */
    dialog = glade_xml_get_widget (xml, "hxplayer_clip_details_dialog");

    info->url_label         = glade_xml_get_widget (xml, "hcdd_url");
    info->title_label       = glade_xml_get_widget (xml, "hcdd_title");
    info->author_label      = glade_xml_get_widget (xml, "hcdd_author");
    info->copyright_label   = glade_xml_get_widget (xml, "hcdd_copyright");
    info->abstract_label    = glade_xml_get_widget (xml, "hcdd_abstract");
    info->description_label = glade_xml_get_widget (xml, "hcdd_description");
    info->keywords_label    = glade_xml_get_widget (xml, "hcdd_keywords");

    g_signal_connect(info->url_label, "size-request",
                     G_CALLBACK(clip_details_label_size_request),
                     NULL);
    
    g_signal_connect(info->title_label, "size-request",
                     G_CALLBACK(clip_details_label_size_request),
                     NULL);
    
    g_signal_connect(info->author_label, "size-request",
                     G_CALLBACK(clip_details_label_size_request),
                     NULL);
    
    g_signal_connect(info->copyright_label, "size-request",
                     G_CALLBACK(clip_details_label_size_request),
                     NULL);
    
    g_signal_connect(info->abstract_label, "size-request",
                     G_CALLBACK(clip_details_label_size_request),
                     NULL);
    
    g_signal_connect(info->description_label, "size-request",
                     G_CALLBACK(clip_details_label_size_request),
                     NULL);

    g_signal_connect(info->keywords_label, "size-request",
                     G_CALLBACK(clip_details_label_size_request),
                     NULL);

    update_clip_info(info);

    info->handler = g_signal_connect_swapped (G_OBJECT (player), "groups_changed",
                                              GTK_SIGNAL_FUNC (update_clip_info),
                                              info);

    g_signal_connect (G_OBJECT (dialog), "destroy",
                      G_CALLBACK (hcdd_destroy),
                      info);
    
    return GTK_DIALOG(dialog);
}
