/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits.compress;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.Logger;
import nom.tam.fits.FitsException;
import nom.tam.fits.compress.ICompressProvider;
import nom.tam.util.LoggerHelper;

public final class CompressionManager {
    private static final String BZIP2_EXTENTION = ".bz2";
    private static final String COMPRESS_EXTENTION = ".Z";
    private static final String GZIP_EXTENTION = ".gz";
    public static final int ONE_MEGABYTE = 0x100000;
    private static final Logger LOG = LoggerHelper.getLogger(CompressionManager.class);

    private CompressionManager() {
    }

    public static InputStream decompress(InputStream compressed) throws FitsException {
        BufferedInputStream pb = new BufferedInputStream(compressed, 0x100000);
        pb.mark(2);
        int mag1 = -1;
        int mag2 = -1;
        try {
            mag1 = pb.read();
            mag2 = pb.read();
            pb.reset();
            ICompressProvider selectedProvider = CompressionManager.selectCompressionProvider(mag1, mag2);
            if (selectedProvider != null) {
                return selectedProvider.decompress(pb);
            }
            return pb;
        }
        catch (IOException e) {
            throw new FitsException("Unable to analyze input stream", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isCompressed(File file) {
        InputStream fis = null;
        try {
            if (file.exists()) {
                fis = new FileInputStream(file);
                int mag1 = fis.read();
                int mag2 = fis.read();
                fis.close();
                boolean bl = CompressionManager.selectCompressionProvider(mag1, mag2) != null;
                return bl;
            }
        }
        catch (IOException e) {
            LOG.log(Level.FINEST, "Error while checking if file " + file + " is compressed", e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    LOG.log(Level.FINEST, "could not close stream", e);
                }
            }
        }
        return false;
    }

    public static boolean isCompressed(String filename) {
        if (filename == null) {
            return false;
        }
        File test = new File(filename);
        if (test.exists()) {
            return CompressionManager.isCompressed(test);
        }
        int len = filename.length();
        return len > 2 && (filename.substring(len - GZIP_EXTENTION.length()).equalsIgnoreCase(GZIP_EXTENTION) || filename.substring(len - COMPRESS_EXTENTION.length()).equals(COMPRESS_EXTENTION) || filename.substring(len - BZIP2_EXTENTION.length()).equals(BZIP2_EXTENTION));
    }

    private static ICompressProvider selectCompressionProvider(int mag1, int mag2) {
        return CompressionManager.nextCompressionProvider(mag1, mag2, null);
    }

    protected static ICompressProvider nextCompressionProvider(int mag1, int mag2, ICompressProvider old) {
        ICompressProvider selectedProvider = null;
        int priority = 0;
        int maxPriority = Integer.MAX_VALUE;
        if (old != null) {
            maxPriority = old.priority();
        }
        ServiceLoader<ICompressProvider> compressionProviders = ServiceLoader.load(ICompressProvider.class, Thread.currentThread().getContextClassLoader());
        for (ICompressProvider provider : compressionProviders) {
            if (provider.priority() <= Math.max(0, priority) || provider.priority() >= maxPriority || provider == old || !provider.provides(mag1, mag2)) continue;
            priority = provider.priority();
            selectedProvider = provider;
        }
        return selectedProvider;
    }
}

