// Cycle table for Falcon instructions
// All cycles are given for 4 cycles bus

// Head, Tail, I-Cache Case (r/p/w), No-Cache Case (r/p/w), Instruction


#ifndef FALCON030_CYCLES_H
#define FALCON030_CYCLES


struct falcon_cycles_t {
	int head;
	int tail;
	int cache_cycles;
	int cache_cycles_r; 
	int cache_cycles_p; 
	int cache_cycles_w; 
	int noncache_cycles;
	int noncache_cycles_r; 
	int noncache_cycles_p; 
	int noncache_cycles_w; 
};

static const struct falcon_cycles_t table_falcon_cycles [] = {
/*0   */	{6,	0,	 4,0,0,0,	 8,0,2,0},	// ORI.B #<data>.W,Dn
/*1   */	{1,	2,	10,1,0,1,	16,1,2,1},	// ORI.B #<data>.W,(An)
/*2   */	{2,	2,	12,1,0,1,	17,1,2,1},	// ORI.B #<data>.W,(An)+
/*3   */	{2,	3,	11,1,0,1,	16,1,2,1},	// ORI.B #<data>.W,-(An)
/*4   */	{2,	1,	11,1,0,1,	17,1,2,1},	// ORI.B #<data>.W,(d16,An)
/*5   */	{8,	3,	15,1,0,1,	22,1,3,1},	// ORI.B #<data>.W,(d8,An,Xn)
/*6   */	{4,	3,	13,1,0,1,	18,1,2,1},	// ORI.B #<data>.W,(xxx).W
/*7   */	{3,	1,	13,1,0,1,	21,1,3,1},	// ORI.B #<data>.W,(xxx).L
/*8   */	{4,	0,	12,0,0,0,	18,0,2,0},	// ORI.B #<data>.W, SR
/*9   */	{6,	0,	 4,0,0,0,	 8,0,2,0},	// ORI.W #<data>.W,Dn
/*10  */	{1,	2,	10,1,0,1,	16,1,2,1},	// ORI.W #<data>.W,(An)
/*11  */	{2,	2,	12,1,0,1,	17,1,2,1},	// ORI.W #<data>.W,(An)+
/*12  */	{2,	3,	11,1,0,1,	16,1,2,1},	// ORI.W #<data>.W,-(An)
/*13  */	{2,	1,	11,1,0,1,	17,1,2,1},	// ORI.W #<data>.W,(d16,An)
/*14  */	{8,	3,	15,1,0,1,	22,1,3,1},	// ORI.W #<data>.W,(d8,An,Xn)
/*15  */	{4,	3,	13,1,0,1,	18,1,2,1},	// ORI.W #<data>.W,(xxx).W
/*16  */	{3,	1,	13,1,0,1,	21,1,3,1},	// ORI.W #<data>.W,(xxx).L
/*17  */	{4,	0,	12,0,0,0,	18,0,2,0},	// ORI.W #<data>.W, SR
/*18  */	{8,	0,	 6,0,0,0,	10,0,2,0},	// ORI.L #<data>.L,Dn
/*19  */	{1,	1,	19,1,0,1,	25,1,2,1},	// ORI.L #<data>.L,(An)
/*20  */	{4,	2,	22,1,0,1,	27,1,2,1},	// ORI.L #<data>.L,(An)+
/*21  */	{2,	1,	19,1,0,1,	25,1,2,1},	// ORI.L #<data>.L,-(An)
/*22  */	{4,	1,	21,1,0,1,	30,1,3,1},	// ORI.L #<data>.L,(d16,An)
/*23  */	{8,	3,	25,1,0,1,	32,1,3,1},	// ORI.L #<data>.L,(d8,An,Xn)
/*24  */	{6,	3,	23,1,0,1,	30,1,3,1},	// ORI.L #<data>.L,(xxx).W
/*25  */	{5,	1,	23,1,0,1,	31,1,3,1},	// ORI.L #<data>.L,(xxx).L
/*26  */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// CHK2.B #<data>.W,(An)	(See CHK2 table below)
/*27  */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// CHK2.B #<data>.W,(d16,An)	(See CHK2 table below)
/*28  */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// CHK2.B #<data>.W,(d8,An,Xn)	(See CHK2 table below)
/*29  */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// CHK2.B #<data>.W,(xxx).W	(See CHK2 table below)
/*30  */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// CHK2.B #<data>.W,(xxx).L	(See CHK2 table below)
/*31  */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// CHK2.B #<data>.W,(d16,PC)	(See CHK2 table below)
/*32  */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// CHK2.B #<data>.W,(d8,PC,Xn)	(See CHK2 table below)
/*33  */	{4,	0,	 4,0,0,0,	 6,0,1,0},	// BTST.L Dn,Dn
/*34  */	{2,	0,	14,2,0,0,	16,2,1,0},	// MVPMR.W (d16,An),Dn
/*35  */	{1,	1,	 9,1,0,0,	11,1,1,0},	// BTST.B Dn,(An)
/*36  */	{0,	1,	 9,1,0,0,	11,1,1,0},	// BTST.B Dn,(An)+
/*37  */	{2,	2,	10,1,0,0,	12,1,1,0},	// BTST.B Dn,-(An)
/*38  */	{2,	2,	10,1,0,0,	14,1,2,0},	// BTST.B Dn,(d16,An)
/*39  */	{4,	2,	12,1,0,0,	16,1,2,0},	// BTST.B Dn,(d8,An,Xn)
/*40  */	{2,	2,	10,1,0,0,	14,1,2,0},	// BTST.B Dn,(xxx).W
/*41  */	{1,	0,	10,1,0,0,	15,1,2,0},	// BTST.B Dn,(xxx).L
/*42  */	{2,	2,	10,1,0,0,	14,1,2,0},	// BTST.B Dn,(d16,PC)
/*43  */	{4,	2,	12,1,0,0,	16,1,2,0},	// BTST.B Dn,(d8,PC,Xn)
/*44  */	{2,	0,	 6,0,0,0,	10,0,2,0},	// BTST.B Dn,#<data>.B
/*45  */	{6,	0,	 6,0,0,0,	 8,0,1,0},	// BCHG.L Dn,Dn
/*46  */	{2,	0,	38,4,0,0,	40,4,1,0},	// MVPMR.L (d16,An),Dn
/*47  */	{1,	1,	13,1,0,1,	15,1,1,1},	// BCHG.B Dn,(An)
/*48  */	{0,	1,	13,1,0,1,	15,1,1,1},	// BCHG.B Dn,(An)+
/*49  */	{2,	2,	14,1,0,1,	16,1,1,1},	// BCHG.B Dn,-(An)
/*50  */	{2,	2,	14,1,0,1,	18,1,2,1},	// BCHG.B Dn,(d16,An)
/*51  */	{4,	2,	16,1,0,1,	20,1,2,1},	// BCHG.B Dn,(d8,An,Xn)
/*52  */	{2,	2,	14,1,0,1,	18,1,2,1},	// BCHG.B Dn,(xxx).W
/*53  */	{1,	0,	14,1,0,1,	19,1,2,1},	// BCHG.B Dn,(xxx).L
/*54  */	{2,	2,	14,1,0,1,	18,1,2,1},	// BCHG.B Dn,(d16,PC)
/*55  */	{4,	2,	16,1,0,1,	20,1,2,1},	// BCHG.B Dn,(d8,PC,Xn)
/*56  */	{6,	0,	 6,0,0,0,	 8,0,1,0},	// BCLR.L Dn,Dn
/*57  */	{4,	0,	14,0,0,2,	16,0,1,2},	// MVPRM.W Dn,(d16,An)
/*58  */	{1,	1,	13,1,0,1,	15,1,1,1},	// BCLR.B Dn,(An)
/*59  */	{0,	1,	13,1,0,1,	15,1,1,1},	// BCLR.B Dn,(An)+
/*60  */	{2,	2,	14,1,0,1,	16,1,1,1},	// BCLR.B Dn,-(An)
/*61  */	{2,	2,	14,1,0,1,	18,1,2,1},	// BCLR.B Dn,(d16,An)
/*62  */	{4,	2,	16,1,0,1,	20,1,2,1},	// BCLR.B Dn,(d8,An,Xn)
/*63  */	{2,	2,	14,1,0,1,	18,1,2,1},	// BCLR.B Dn,(xxx).W
/*64  */	{1,	0,	14,1,0,1,	19,1,2,1},	// BCLR.B Dn,(xxx).L
/*65  */	{2,	2,	14,1,0,1,	18,1,2,1},	// BCLR.B Dn,(d16,PC)
/*66  */	{4,	2,	16,1,0,1,	20,1,2,1},	// BCLR.B Dn,(d8,PC,Xn)
/*67  */	{6,	0,	 6,0,0,0,	 8,0,1,0},	// BSET.L Dn,Dn
/*68  */	{4,	0,	38,0,0,4,	40,0,1,4},	// MVPRM.L Dn,(d16,An)
/*69  */	{1,	1,	13,1,0,1,	15,1,1,1},	// BSET.B Dn,(An)
/*70  */	{0,	1,	13,1,0,1,	15,1,1,1},	// BSET.B Dn,(An)+
/*71  */	{2,	2,	14,1,0,1,	16,1,1,1},	// BSET.B Dn,-(An)
/*72  */	{2,	2,	14,1,0,1,	18,1,2,1},	// BSET.B Dn,(d16,An)
/*73  */	{4,	2,	16,1,0,1,	20,1,2,1},	// BSET.B Dn,(d8,An,Xn)
/*74  */	{2,	2,	14,1,0,1,	18,1,2,1},	// BSET.B Dn,(xxx).W
/*75  */	{1,	0,	14,1,0,1,	19,1,2,1},	// BSET.B Dn,(xxx).L
/*76  */	{2,	2,	14,1,0,1,	18,1,2,1},	// BSET.B Dn,(d16,PC)
/*77  */	{4,	2,	16,1,0,1,	20,1,2,1},	// BSET.B Dn,(d8,PC,Xn)
/*78  */	{6,	0,	 4,0,0,0,	 8,0,2,0},	// ANDI.B #<data>.W,Dn
/*79  */	{1,	2,	10,1,0,1,	16,1,2,1},	// ANDI.B #<data>.W,(An)
/*80  */	{2,	2,	12,1,0,1,	17,1,2,1},	// ANDI.B #<data>.W,(An)+
/*81  */	{2,	3,	11,1,0,1,	16,1,2,1},	// ANDI.B #<data>.W,-(An)
/*82  */	{2,	1,	11,1,0,1,	17,1,2,1},	// ANDI.B #<data>.W,(d16,An)
/*83  */	{6,	3,	15,1,0,1,	22,1,3,1},	// ANDI.B #<data>.W,(d8,An,Xn)
/*84  */	{4,	3,	13,1,0,1,	18,1,2,1},	// ANDI.B #<data>.W,(xxx).W
/*85  */	{3,	1,	13,1,0,1,	21,1,3,1},	// ANDI.B #<data>.W,(xxx).L
/*86  */	{4,	0,	12,0,0,0,	18,0,2,0},	// ANDI.B #<data>.W, SR
/*87  */	{6,	0,	 4,0,0,0,	 8,0,2,0},	// ANDI.W #<data>.W,Dn
/*88  */	{1,	2,	10,1,0,1,	16,1,2,1},	// ANDI.W #<data>.W,(An)
/*89  */	{2,	2,	12,1,0,1,	17,1,2,1},	// ANDI.W #<data>.W,(An)+
/*90  */	{2,	3,	11,1,0,1,	16,1,2,1},	// ANDI.W #<data>.W,-(An)
/*91  */	{2,	1,	11,1,0,1,	17,1,2,1},	// ANDI.W #<data>.W,(d16,An)
/*92  */	{6,	3,	15,1,0,1,	22,1,3,1},	// ANDI.W #<data>.W,(d8,An,Xn)
/*93  */	{4,	3,	13,1,0,1,	18,1,2,1},	// ANDI.W #<data>.W,(xxx).W
/*94  */	{3,	1,	13,1,0,1,	21,1,3,1},	// ANDI.W #<data>.W,(xxx).L
/*95  */	{4,	0,	12,0,0,0,	18,0,2,0},	// ANDI.W #<data>.W, SR
/*96  */	{8,	0,	 6,0,0,0,	10,0,2,0},	// ANDI.L #<data>.L,Dn
/*97  */	{1,	1,	19,1,0,1,	25,1,2,1},	// ANDI.L #<data>.L,(An)
/*98  */	{4,	2,	22,1,0,1,	27,1,2,1},	// ANDI.L #<data>.L,(An)+
/*99  */	{2,	1,	19,1,0,1,	25,1,2,1},	// ANDI.L #<data>.L,-(An)
/*100 */	{4,	1,	21,1,0,1,	30,1,3,1},	// ANDI.L #<data>.L,(d16,An)
/*101 */	{8,	3,	25,1,0,1,	32,1,3,1},	// ANDI.L #<data>.L,(d8,An,Xn)
/*102 */	{6,	3,	23,1,0,1,	30,1,3,1},	// ANDI.L #<data>.L,(xxx).W
/*103 */	{5,	1,	23,1,0,1,	31,1,3,1},	// ANDI.L #<data>.L,(xxx).L
/*104 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// CHK2.W #<data>.W,(An)	(See CHK2 table below)
/*105 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// CHK2.W #<data>.W,(d16,An)	(See CHK2 table below)
/*106 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// CHK2.W #<data>.W,(d8,An,Xn)	(See CHK2 table below)
/*107 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// CHK2.W #<data>.W,(xxx).W	(See CHK2 table below)
/*108 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// CHK2.W #<data>.W,(xxx).L	(See CHK2 table below)
/*109 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// CHK2.W #<data>.W,(d16,PC)	(See CHK2 table below)
/*110 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// CHK2.W #<data>.W,(d8,PC,Xn)	(See CHK2 table below)
/*111 */	{6,	0,	 4,0,0,0,	 8,0,2,0},	// SUBI.B #<data>.W,Dn
/*112 */	{1,	2,	10,1,0,1,	16,1,2,1},	// SUBI.B #<data>.W,(An)
/*113 */	{2,	2,	12,1,0,1,	17,1,2,1},	// SUBI.B #<data>.W,(An)+
/*114 */	{2,	3,	11,1,0,1,	16,1,2,1},	// SUBI.B #<data>.W,-(An)
/*115 */	{2,	1,	11,1,0,1,	17,1,2,1},	// SUBI.B #<data>.W,(d16,An)
/*116 */	{6,	3,	15,1,0,1,	22,1,3,1},	// SUBI.B #<data>.W,(d8,An,Xn)
/*117 */	{4,	3,	13,1,0,1,	18,1,2,1},	// SUBI.B #<data>.W,(xxx).W
/*118 */	{3,	1,	13,1,0,1,	21,1,3,1},	// SUBI.B #<data>.W,(xxx).L
/*119 */	{6,	0,	 4,0,0,0,	 8,0,2,0},	// SUBI.W #<data>.W,Dn
/*120 */	{1,	2,	10,1,0,1,	16,1,2,1},	// SUBI.W #<data>.W,(An)
/*121 */	{2,	2,	12,1,0,1,	17,1,2,1},	// SUBI.W #<data>.W,(An)+
/*122 */	{2,	3,	11,1,0,1,	16,1,2,1},	// SUBI.W #<data>.W,-(An)
/*123 */	{2,	1,	11,1,0,1,	17,1,2,1},	// SUBI.W #<data>.W,(d16,An)
/*124 */	{6,	3,	15,1,0,1,	22,1,3,1},	// SUBI.W #<data>.W,(d8,An,Xn)
/*125 */	{4,	3,	13,1,0,1,	18,1,2,1},	// SUBI.W #<data>.W,(xxx).W
/*126 */	{3,	1,	13,1,0,1,	21,1,3,1},	// SUBI.W #<data>.W,(xxx).L
/*127 */	{8,	0,	 6,0,0,0,	10,0,2,0},	// SUBI.L #<data>.L,Dn
/*128 */	{1,	1,	19,1,0,1,	25,1,2,1},	// SUBI.L #<data>.L,(An)
/*129 */	{4,	2,	22,1,0,1,	27,1,2,1},	// SUBI.L #<data>.L,(An)+
/*130 */	{2,	1,	19,1,0,1,	25,1,2,1},	// SUBI.L #<data>.L,-(An)
/*131 */	{4,	1,	21,1,0,1,	30,1,3,1},	// SUBI.L #<data>.L,(d16,An)
/*132 */	{8,	3,	25,1,0,1,	32,1,3,1},	// SUBI.L #<data>.L,(d8,An,Xn)
/*133 */	{6,	3,	23,1,0,1,	30,1,3,1},	// SUBI.L #<data>.L,(xxx).W
/*134 */	{5,	1,	23,1,0,1,	31,1,3,1},	// SUBI.L #<data>.L,(xxx).L
/*135 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// CHK2.L #<data>.W,(An)	(See CHK2 table below)
/*136 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// CHK2.L #<data>.W,(d16,An)	(See CHK2 table below)
/*137 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// CHK2.L #<data>.W,(d8,An,Xn)	(See CHK2 table below)
/*138 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// CHK2.L #<data>.W,(xxx).W	(See CHK2 table below)
/*139 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// CHK2.L #<data>.W,(xxx).L	(See CHK2 table below)
/*140 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// CHK2.L #<data>.W,(d16,PC)	(See CHK2 table below)
/*141 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// CHK2.L #<data>.W,(d8,PC,Xn)	(See CHK2 table below)
/*142 */	{6,	0,	 4,0,0,0,	 8,0,2,0},	// ADDI.B #<data>.W,Dn
/*143 */	{1,	2,	10,1,0,1,	16,1,2,1},	// ADDI.B #<data>.W,(An)
/*144 */	{2,	2,	12,1,0,1,	17,1,2,1},	// ADDI.B #<data>.W,(An)+
/*145 */	{2,	3,	11,1,0,1,	16,1,2,1},	// ADDI.B #<data>.W,-(An)
/*146 */	{2,	1,	11,1,0,1,	17,1,2,1},	// ADDI.B #<data>.W,(d16,An)
/*147 */	{6,	3,	15,1,0,1,	22,1,3,1},	// ADDI.B #<data>.W,(d8,An,Xn)
/*148 */	{4,	3,	13,1,0,1,	18,1,2,1},	// ADDI.B #<data>.W,(xxx).W
/*149 */	{3,	1,	13,1,0,1,	21,1,3,1},	// ADDI.B #<data>.W,(xxx).L
/*150 */	{6,	0,	 4,0,0,0,	 8,0,2,0},	// ADDI.W #<data>.W,Dn
/*151 */	{1,	2,	10,1,0,1,	16,1,2,1},	// ADDI.W #<data>.W,(An)
/*152 */	{2,	2,	12,1,0,1,	17,1,2,1},	// ADDI.W #<data>.W,(An)+
/*153 */	{2,	3,	11,1,0,1,	16,1,2,1},	// ADDI.W #<data>.W,-(An)
/*154 */	{2,	1,	11,1,0,1,	17,1,2,1},	// ADDI.W #<data>.W,(d16,An)
/*155 */	{6,	3,	15,1,0,1,	22,1,3,1},	// ADDI.W #<data>.W,(d8,An,Xn)
/*156 */	{4,	3,	13,1,0,1,	18,1,2,1},	// ADDI.W #<data>.W,(xxx).W
/*157 */	{3,	1,	13,1,0,1,	21,1,3,1},	// ADDI.W #<data>.W,(xxx).L
/*158 */	{8,	0,	 6,0,0,0,	10,0,2,0},	// ADDI.L #<data>.L,Dn
/*159 */	{1,	1,	19,1,0,1,	25,1,2,1},	// ADDI.L #<data>.L,(An)
/*160 */	{4,	2,	22,1,0,1,	27,1,2,1},	// ADDI.L #<data>.L,(An)+
/*161 */	{2,	1,	19,1,0,1,	25,1,2,1},	// ADDI.L #<data>.L,-(An)
/*162 */	{4,	1,	21,1,0,1,	30,1,3,1},	// ADDI.L #<data>.L,(d16,An)
/*163 */	{8,	3,	25,1,0,1,	32,1,3,1},	// ADDI.L #<data>.L,(d8,An,Xn)
/*164 */	{6,	3,	23,1,0,1,	30,1,3,1},	// ADDI.L #<data>.L,(xxx).W
/*165 */	{5,	1,	23,1,0,1,	31,1,3,1},	// ADDI.L #<data>.L,(xxx).L
/*166 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// RTM.L Dn			/* Not present in 68030 */
/*167 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// RTM.L An			/* Not present in 68030 */
/*168 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// CALLM.L (An)			/* Not present in 68030 */
/*169 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// CALLM.L (d16,An)		/* Not present in 68030 */
/*170 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// CALLM.L (d8,An,Xn)		/* Not present in 68030 */
/*171 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// CALLM.L (xxx).W		/* Not present in 68030 */
/*172 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// CALLM.L (xxx).L		/* Not present in 68030 */
/*173 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// CALLM.L (d16,PC)		/* Not present in 68030 */
/*174 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// CALLM.L (d8,PC,Xn)		/* Not present in 68030 */
/*175 */	{4,	0,	 4,0,0,0,	 6,0,1,0},	// BTST.L #<data>.W,Dn
/*176 */	{1,	1,	 9,1,0,0,	14,1,2,0},	// BTST.B #<data>.W,(An)
/*177 */	{2,	1,	11,1,0,0,	15,1,2,0},	// BTST.B #<data>.W,(An)+
/*178 */	{2,	2,	10,1,0,0,	14,1,2,0},	// BTST.B #<data>.W,-(An)
/*179 */	{2,	0,	10,1,0,0,	15,1,2,0},	// BTST.B #<data>.W,(d16,An)
/*180 */	{6,	2,	14,1,0,0,	20,1,3,0},	// BTST.B #<data>.W,(d8,An,Xn)
/*181 */	{4,	2,	12,1,0,0,	16,1,2,0},	// BTST.B #<data>.W,(xxx).W
/*182 */	{3,	0,	12,1,0,0,	19,1,3,0},	// BTST.B #<data>.W,(xxx).L
/*183 */	{2,	0,	10,1,0,0,	15,1,2,0},	// BTST.B #<data>.W,(d16,PC)
/*184 */	{6,	2,	14,1,0,0,	20,1,3,0},	// BTST.B #<data>.W,(d8,PC,Xn)
/*185 */	{4,	2,	12,1,0,0,	16,1,2,0},	// BTST.B #<data>.W,#<data>.B	/* Strange OPCODE, value guessed */
/*186 */	{6,	0,	 6,0,0,0,	 8,0,1,0},	// BCHG.L #<data>.W,Dn
/*187 */	{1,	1,	13,1,0,1,	18,1,2,1},	// BCHG.B #<data>.W,(An)
/*188 */	{2,	1,	15,1,0,1,	19,1,2,1},	// BCHG.B #<data>.W,(An)+
/*189 */	{2,	2,	14,1,0,1,	18,1,2,1},	// BCHG.B #<data>.W,-(An)
/*190 */	{2,	0,	14,1,0,1,	19,1,2,1},	// BCHG.B #<data>.W,(d16,An)
/*191 */	{6,	2,	18,1,0,1,	24,1,3,1},	// BCHG.B #<data>.W,(d8,An,Xn)
/*192 */	{4,	2,	16,1,0,1,	20,1,2,1},	// BCHG.B #<data>.W,(xxx).W
/*193 */	{3,	0,	16,1,0,1,	23,1,3,1},	// BCHG.B #<data>.W,(xxx).L
/*194 */	{2,	0,	14,1,0,1,	19,1,2,1},	// BCHG.B #<data>.W,(d16,PC)
/*195 */	{6,	2,	18,1,0,1,	24,1,3,1},	// BCHG.B #<data>.W,(d8,PC,Xn)
/*196 */	{6,	0,	 6,0,0,0,	 8,0,1,0},	// BCLR.L #<data>.W,Dn
/*197 */	{1,	1,	13,1,0,1,	18,1,2,1},	// BCLR.B #<data>.W,(An)
/*198 */	{2,	1,	15,1,0,1,	19,1,2,1},	// BCLR.B #<data>.W,(An)+
/*199 */	{2,	2,	14,1,0,1,	18,1,2,1},	// BCLR.B #<data>.W,-(An)
/*200 */	{2,	0,	14,1,0,1,	19,1,2,1},	// BCLR.B #<data>.W,(d16,An)
/*201 */	{6,	2,	18,1,0,1,	24,1,3,1},	// BCLR.B #<data>.W,(d8,An,Xn)
/*202 */	{4,	2,	16,1,0,1,	20,1,2,1},	// BCLR.B #<data>.W,(xxx).W
/*203 */	{3,	0,	16,1,0,1,	23,1,3,1},	// BCLR.B #<data>.W,(xxx).L
/*204 */	{2,	0,	14,1,0,1,	19,1,2,1},	// BCLR.B #<data>.W,(d16,PC)
/*205 */	{6,	2,	18,1,0,1,	24,1,3,1},	// BCLR.B #<data>.W,(d8,PC,Xn)
/*206 */	{6,	0,	 6,0,0,0,	 8,0,1,0},	// BSET.L #<data>.W,Dn
/*207 */	{1,	1,	13,1,0,1,	18,1,2,1},	// BSET.B #<data>.W,(An)
/*208 */	{2,	1,	15,1,0,1,	19,1,2,1},	// BSET.B #<data>.W,(An)+
/*209 */	{2,	2,	14,1,0,1,	18,1,2,1},	// BSET.B #<data>.W,-(An)
/*210 */	{2,	0,	14,1,0,1,	19,1,2,1},	// BSET.B #<data>.W,(d16,An)
/*211 */	{6,	2,	18,1,0,1,	24,1,3,1},	// BSET.B #<data>.W,(d8,An,Xn)
/*212 */	{4,	2,	16,1,0,1,	20,1,2,1},	// BSET.B #<data>.W,(xxx).W
/*213 */	{3,	0,	16,1,0,1,	23,1,3,1},	// BSET.B #<data>.W,(xxx).L
/*214 */	{2,	0,	14,1,0,1,	19,1,2,1},	// BSET.B #<data>.W,(d16,PC)
/*215 */	{6,	2,	18,1,0,1,	24,1,3,1},	// BSET.B #<data>.W,(d8,PC,Xn)
/*216 */	{6,	0,	 4,0,0,0,	 8,0,2,0},	// EORI.B #<data>.W,Dn
/*217 */	{1,	2,	10,1,0,1,	16,1,2,1},	// EORI.B #<data>.W,(An)
/*218 */	{2,	2,	12,1,0,1,	17,1,2,1},	// EORI.B #<data>.W,(An)+
/*219 */	{2,	3,	11,1,0,1,	16,1,2,1},	// EORI.B #<data>.W,-(An)
/*220 */	{2,	1,	11,1,0,1,	17,1,2,1},	// EORI.B #<data>.W,(d16,An)
/*221 */	{6,	3,	15,1,0,1,	22,1,3,1},	// EORI.B #<data>.W,(d8,An,Xn)
/*222 */	{4,	3,	13,1,0,1,	18,1,2,1},	// EORI.B #<data>.W,(xxx).W
/*223 */	{3,	1,	13,1,0,1,	21,1,3,1},	// EORI.B #<data>.W,(xxx).L
/*224 */	{4,	0,	12,0,0,0,	18,0,2,0},	// EORI.B #<data>.W, SR
/*225 */	{6,	0,	 4,0,0,0,	 8,0,2,0},	// EORI.W #<data>.W,Dn
/*226 */	{1,	2,	10,1,0,1,	16,1,2,1},	// EORI.W #<data>.W,(An)
/*227 */	{2,	2,	12,1,0,1,	17,1,2,1},	// EORI.W #<data>.W,(An)+
/*228 */	{2,	3,	11,1,0,1,	16,1,2,1},	// EORI.W #<data>.W,-(An)
/*229 */	{2,	1,	11,1,0,1,	17,1,2,1},	// EORI.W #<data>.W,(d16,An)
/*230 */	{6,	3,	15,1,0,1,	22,1,3,1},	// EORI.W #<data>.W,(d8,An,Xn)
/*231 */	{4,	3,	13,1,0,1,	18,1,2,1},	// EORI.W #<data>.W,(xxx).W
/*232 */	{3,	1,	13,1,0,1,	21,1,3,1},	// EORI.W #<data>.W,(xxx).L
/*233 */	{4,	0,	12,0,0,0,	18,0,2,0},	// EORI.W #<data>.W, SR
/*234 */	{8,	0,	 6,0,0,0,	10,0,2,0},	// EORI.L #<data>.L,Dn
/*235 */	{1,	1,	19,1,0,1,	25,1,2,1},	// EORI.L #<data>.L,(An)
/*236 */	{4,	2,	22,1,0,1,	27,1,2,1},	// EORI.L #<data>.L,(An)+
/*237 */	{2,	1,	19,1,0,1,	25,1,2,1},	// EORI.L #<data>.L,-(An)
/*238 */	{4,	1,	21,1,0,1,	30,1,3,1},	// EORI.L #<data>.L,(d16,An)
/*239 */	{8,	3,	25,1,0,1,	32,1,3,1},	// EORI.L #<data>.L,(d8,An,Xn)
/*240 */	{6,	3,	23,1,0,1,	30,1,3,1},	// EORI.L #<data>.L,(xxx).W
/*241 */	{5,	1,	23,1,0,1,	31,1,3,1},	// EORI.L #<data>.L,(xxx).L
/*242 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// CAS.B #<data>.W,(An)		(See CAS table below)
/*243 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// CAS.B #<data>.W,(An)+	(See CAS table below)
/*244 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// CAS.B #<data>.W,-(An)	(See CAS table below)
/*245 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// CAS.B #<data>.W,(d16,An)	(See CAS table below)
/*246 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// CAS.B #<data>.W,(d8,An,Xn)	(See CAS table below)
/*247 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// CAS.B #<data>.W,(xxx).W	(See CAS table below)
/*248 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// CAS.B #<data>.W,(xxx).L	(See CAS table below)
/*249 */	{6,	0,	 4,0,0,0,	 8,0,2,0},	// CMPI.B #<data>.B,Dn
/*250 */	{1,	1,	 7,1,0,0,	12,1,2,0},	// CMPI.B #<data>.W,(An)
/*251 */	{2,	1,	 9,1,0,0,	13,1,2,0},	// CMPI.B #<data>.W,(An)+
/*252 */	{2,	2,	 8,1,0,0,	12,1,2,0},	// CMPI.B #<data>.W,-(An)
/*253 */	{2,	0,	 8,1,0,0,	13,1,2,0},	// CMPI.B #<data>.W,(d16,An)
/*254 */	{6,	2,	12,1,0,0,	18,1,3,0},	// CMPI.B #<data>.W,(d8,An,Xn)
/*255 */	{4,	2,	10,1,0,0,	14,1,2,0},	// CMPI.B #<data>.W,(xxx).W
/*256 */	{3,	0,	10,1,0,0,	17,1,3,0},	// CMPI.B #<data>.W,(xxx).L
/*257 */	{2,	0,	 8,1,0,0,	13,1,2,0},	// CMPI.B #<data>.W,(d16,PC)
/*258 */	{6,	2,	12,1,0,0,	18,1,3,0},	// CMPI.B #<data>.W,(d8,PC,Xn)
/*259 */	{6,	0,	 4,0,0,0,	 8,0,2,0},	// CMPI.W #<data>.W,Dn
/*260 */	{1,	1,	 7,1,0,0,	12,1,2,0},	// CMPI.W #<data>.W,(An)
/*261 */	{2,	1,	 9,1,0,0,	13,1,2,0},	// CMPI.W #<data>.W,(An)+
/*262 */	{2,	2,	 8,1,0,0,	12,1,2,0},	// CMPI.W #<data>.W,-(An)
/*263 */	{2,	0,	 8,1,0,0,	13,1,2,0},	// CMPI.W #<data>.W,(d16,An)
/*264 */	{6,	2,	12,1,0,0,	18,1,3,0},	// CMPI.W #<data>.W,(d8,An,Xn)
/*265 */	{4,	2,	10,1,0,0,	14,1,2,0},	// CMPI.W #<data>.W,(xxx).W
/*266 */	{3,	0,	10,1,0,0,	17,1,3,0},	// CMPI.W #<data>.W,(xxx).L
/*267 */	{2,	0,	 8,1,0,0,	13,1,2,0},	// CMPI.W #<data>.W,(d16,PC)
/*268 */	{6,	2,	12,1,0,0,	18,1,3,0},	// CMPI.W #<data>.W,(d8,PC,Xn)
/*269 */	{8,	0,	 6,0,0,0,	10,0,2,0},	// CMPI.L #<data>.L,Dn
/*270 */	{1,	0,	12,1,0,0,	17,1,2,0},	// CMPI.L #<data>.L,(An)
/*271 */	{4,	1,	15,1,0,0,	19,1,2,0},	// CMPI.L #<data>.L,(An)+
/*272 */	{2,	0,	12,1,0,0,	17,1,2,0},	// CMPI.L #<data>.L,-(An)
/*273 */	{4,	0,	14,1,0,0,	22,1,3,0},	// CMPI.L #<data>.L,(d16,An)
/*274 */	{8,	2,	18,1,0,0,	24,1,3,0},	// CMPI.L #<data>.L,(d8,An,Xn)
/*275 */	{6,	2,	16,1,0,0,	22,1,3,0},	// CMPI.L #<data>.L,(xxx).W
/*276 */	{5,	0,	16,1,0,0,	23,1,3,0},	// CMPI.L #<data>.L,(xxx).L
/*277 */	{4,	0,	14,1,0,0,	22,1,3,0},	// CMPI.L #<data>.L,(d16,PC)
/*278 */	{8,	2,	18,1,0,0,	24,1,3,0},	// CMPI.L #<data>.L,(d8,PC,Xn)
/*279 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// CAS.W #<data>.W,(An)		(See CAS table below)
/*280 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// CAS.W #<data>.W,(An)+	(See CAS table below)
/*281 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// CAS.W #<data>.W,-(An)	(See CAS table below)
/*282 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// CAS.W #<data>.W,(d16,An)	(See CAS table below)
/*283 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// CAS.W #<data>.W,(d8,An,Xn)	(See CAS table below)
/*284 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// CAS.W #<data>.W,(xxx).W	(See CAS table below)
/*285 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// CAS.W #<data>.W,(xxx).L	(See CAS table below)
/*286 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// CAS2.W #<data>.L		(See CAS2 table below)
/*287 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// MOVES.B #<data>.W,(An)		(See MOVES table below)
/*288 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// MOVES.B #<data>.W,(An)+		(See MOVES table below)
/*289 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// MOVES.B #<data>.W,-(An)		(See MOVES table below)
/*290 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// MOVES.B #<data>.W,(d16,An)		(See MOVES table below)
/*291 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// MOVES.B #<data>.W,(d8,An,Xn)		(See MOVES table below)
/*292 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// MOVES.B #<data>.W,(xxx).W		(See MOVES table below)
/*293 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// MOVES.B #<data>.W,(xxx).L		(See MOVES table below)
/*294 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// MOVES.W #<data>.W,(An)		(See MOVES table below)
/*295 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// MOVES.W #<data>.W,(An)+		(See MOVES table below)
/*296 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// MOVES.W #<data>.W,-(An)		(See MOVES table below)
/*297 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// MOVES.W #<data>.W,(d16,An)		(See MOVES table below)
/*298 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// MOVES.W #<data>.W,(d8,An,Xn)		(See MOVES table below)
/*299 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// MOVES.W #<data>.W,(xxx).W		(See MOVES table below)
/*300 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// MOVES.W #<data>.W,(xxx).L		(See MOVES table below)
/*301 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// MOVES.L #<data>.W,(An)		(See MOVES table below)
/*302 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// MOVES.L #<data>.W,(An)+		(See MOVES table below)
/*303 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// MOVES.L #<data>.W,-(An)		(See MOVES table below)
/*304 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// MOVES.L #<data>.W,(d16,An)		(See MOVES table below)
/*305 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// MOVES.L #<data>.W,(d8,An,Xn)		(See MOVES table below)
/*306 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// MOVES.L #<data>.W,(xxx).W		(See MOVES table below)
/*307 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// MOVES.L #<data>.W,(xxx).L		(See MOVES table below)
/*308 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// CAS.L #<data>.W,(An)		(See CAS table below)
/*309 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// CAS.L #<data>.W,(An)+	(See CAS table below)
/*310 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// CAS.L #<data>.W,-(An)	(See CAS table below)
/*311 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// CAS.L #<data>.W,(d16,An)	(See CAS table below)
/*312 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// CAS.L #<data>.W,(d8,An,Xn)	(See CAS table below)
/*313 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// CAS.L #<data>.W,(xxx).W	(See CAS table below)
/*314 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// CAS.L #<data>.W,(xxx).L	(See CAS table below)
/*315 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// CAS2.L #<data>.L		(See CAS2 table below)
/*316 */	{2,	0,	 2,0,0,0,	 4,0,1,0},	// MOVE.B Dn,Dn
/*317 */	{1,	1,	 7,1,0,0,	 9,1,1,0},	// MOVE.B (An),Dn
/*318 */	{0,	1,	 7,1,0,0,	 9,1,1,0},	// MOVE.B (An)+,Dn
/*319 */	{2,	2,	 8,1,0,0,	10,1,1,0},	// MOVE.B -(An),Dn
/*320 */	{2,	2,	 8,1,0,0,	12,1,1,0},	// MOVE.B (d16,An),Dn
/*321 */	{4,	2,	10,1,0,0,	14,1,2,0},	// MOVE.B (d8,An,Xn),Dn
/*322 */	{2,	2,	 8,1,0,0,	12,1,2,0},	// MOVE.B (xxx).W,Dn
/*323 */	{1,	0,	 8,1,0,0,	13,1,2,0},	// MOVE.B (xxx).L,Dn
/*324 */	{2,	2,	 8,1,0,0,	12,1,2,0},	// MOVE.B (d16,PC),Dn
/*325 */	{4,	2,	10,1,0,0,	14,1,2,0},	// MOVE.B (d8,PC,Xn),Dn
/*326 */	{2,	0,	 4,0,0,0,	 8,0,2,0},	// MOVE.B #<data>.B,Dn
/*327 */	{0,	1,	 5,0,0,1,	 8,0,1,1},	// MOVE.B Dn,(An)
/*328 */	{3,	1,	11,1,0,1,	14,1,1,1},	// MOVE.B (An),(An)
/*329 */	{2,	1,	11,1,0,1,	14,1,1,1},	// MOVE.B (An)+,(An)
/*330 */	{4,	2,	12,1,0,1,	15,1,1,1},	// MOVE.B -(An),(An)
/*331 */	{4,	2,	12,1,0,1,	17,1,2,1},	// MOVE.B (d16,An),(An)
/*332 */	{6,	2,	14,1,0,1,	19,1,2,1},	// MOVE.B (d8,An,Xn),(An)
/*333 */	{4,	2,	12,1,0,1,	17,1,2,1},	// MOVE.B (xxx).W,(An)
/*334 */	{3,	0,	12,1,0,1,	18,1,2,1},	// MOVE.B (xxx).L,(An)
/*335 */	{4,	2,	12,1,0,1,	17,1,2,1},	// MOVE.B (d16,PC),(An)
/*336 */	{6,	2,	14,1,0,1,	19,1,2,1},	// MOVE.B (d8,PC,Xn),(An)
/*337 */	{4,	0,	 8,0,0,1,	13,0,2,1},	// MOVE.B #<data>.B,(An)
/*338 */	{0,	1,	 5,0,0,1,	 8,0,1,1},	// MOVE.B Dn,(An)+
/*339 */	{3,	1,	11,1,0,1,	14,1,1,1},	// MOVE.B (An),(An)+
/*340 */	{2,	1,	11,1,0,1,	14,1,1,1},	// MOVE.B (An)+,(An)+
/*341 */	{4,	2,	12,1,0,1,	15,1,1,1},	// MOVE.B -(An),(An)+
/*342 */	{4,	2,	12,1,0,1,	17,1,2,1},	// MOVE.B (d16,An),(An)+
/*343 */	{6,	2,	14,1,0,1,	19,1,2,1},	// MOVE.B (d8,An,Xn),(An)+
/*344 */	{4,	2,	12,1,0,1,	17,1,2,1},	// MOVE.B (xxx).W,(An)+
/*345 */	{3,	0,	12,1,0,1,	18,1,2,1},	// MOVE.B (xxx).L,(An)+
/*346 */	{4,	2,	12,1,0,1,	17,1,2,1},	// MOVE.B (d16,PC),(An)+
/*347 */	{6,	2,	14,1,0,1,	19,1,2,1},	// MOVE.B (d8,PC,Xn),(An)+
/*348 */	{4,	0,	 8,0,0,1,	13,0,2,1},	// MOVE.B #<data>.B,(An)+
/*349 */	{0,	2,	 6,0,0,1,	 8,0,1,1},	// MOVE.B Dn,-(An)
/*350 */	{3,	1,	11,1,0,1,	14,1,1,1},	// MOVE.B (An),-(An)
/*351 */	{2,	1,	11,1,0,1,	14,1,1,1},	// MOVE.B (An)+,-(An)
/*352 */	{4,	2,	12,1,0,1,	15,1,1,1},	// MOVE.B -(An),-(An)
/*353 */	{4,	2,	12,1,0,1,	17,1,2,1},	// MOVE.B (d16,An),-(An)
/*354 */	{6,	2,	14,1,0,1,	19,1,2,1},	// MOVE.B (d8,An,Xn),-(An)
/*355 */	{4,	2,	12,1,0,1,	17,1,2,1},	// MOVE.B (xxx).W,-(An)
/*356 */	{3,	0,	12,1,0,1,	18,1,2,1},	// MOVE.B (xxx).L,-(An)
/*357 */	{4,	2,	12,1,0,1,	17,1,2,1},	// MOVE.B (d16,PC),-(An)
/*358 */	{6,	2,	14,1,0,1,	19,1,2,1},	// MOVE.B (d8,PC,Xn),-(An)
/*359 */	{4,	0,	 8,0,0,1,	13,0,2,1},	// MOVE.B #<data>.B,-(An)
/*360 */	{2,	0,	 6,0,0,1,	 9,0,1,1},	// MOVE.B Dn,(d16,An)
/*361 */	{3,	1,	11,1,0,1,	14,1,1,1},	// MOVE.B (An),(d16,An)
/*362 */	{2,	1,	11,1,0,1,	14,1,1,1},	// MOVE.B (An)+,(d16,An)
/*363 */	{4,	2,	12,1,0,1,	15,1,1,1},	// MOVE.B -(An),(d16,An)
/*364 */	{4,	2,	12,1,0,1,	17,1,2,1},	// MOVE.B (d16,An),(d16,An)
/*365 */	{6,	2,	14,1,0,1,	19,1,2,1},	// MOVE.B (d8,An,Xn),(d16,An)
/*366 */	{4,	2,	12,1,0,1,	17,1,2,1},	// MOVE.B (xxx).W,(d16,An)
/*367 */	{3,	0,	12,1,0,1,	18,1,2,1},	// MOVE.B (xxx).L,(d16,An)
/*368 */	{4,	2,	12,1,0,1,	17,1,2,1},	// MOVE.B (d16,PC),(d16,An)
/*369 */	{6,	2,	14,1,0,1,	19,1,2,1},	// MOVE.B (d8,PC,Xn),(d16,An)
/*370 */	{4,	0,	 8,0,0,1,	13,0,2,1},	// MOVE.B #<data>.B,(d16,An)
/*371 */	{4,	0,	 8,0,0,1,	11,0,1,1},	// MOVE.B Dn,(d8,An,Xn)
/*372 */	{5,	1,	13,1,0,1,	16,1,1,1},	// MOVE.B (An),(d8,An,Xn)
/*373 */	{4,	1,	13,1,0,1,	16,1,1,1},	// MOVE.B (An)+,(d8,An,Xn)
/*374 */	{6,	2,	14,1,0,1,	17,1,1,1},	// MOVE.B -(An),(d8,An,Xn)
/*375 */	{6,	2,	14,1,0,1,	19,1,2,1},	// MOVE.B (d16,An),(d8,An,Xn)
/*376 */	{8,	2,	12,1,0,1,	13,1,2,1},	// MOVE.B (d8,An,Xn),(d8,An,Xn)
/*377 */	{6,	2,	14,1,0,1,	19,1,2,1},	// MOVE.B (xxx).W,(d8,An,Xn)
/*378 */	{5,	0,	14,1,0,1,	20,1,2,1},	// MOVE.B (xxx).L,(d8,An,Xn)
/*379 */	{6,	2,	14,1,0,1,	19,1,2,1},	// MOVE.B (d16,PC),(d8,An,Xn)
/*380 */	{8,	2,	12,1,0,1,	13,1,2,1},	// MOVE.B (d8,PC,Xn),(d8,An,Xn)
/*381 */	{6,	0,	10,0,0,1,	15,0,2,1},	// MOVE.B #<data>.B,(d8,An,Xn)
/*382 */	{4,	0,	 8,0,0,1,	11,0,1,1},	// MOVE.B Dn,(xxx).W
/*383 */	{5,	1,	13,1,0,1,	16,1,1,1},	// MOVE.B (An),(xxx).W
/*384 */	{4,	1,	13,1,0,1,	16,1,1,1},	// MOVE.B (An)+,(xxx).W
/*385 */	{6,	2,	14,1,0,1,	17,1,1,1},	// MOVE.B -(An),(xxx).W
/*386 */	{6,	2,	14,1,0,1,	19,1,2,1},	// MOVE.B (d16,An),(xxx).W
/*387 */	{8,	2,	12,1,0,1,	13,1,2,1},	// MOVE.B (d8,An,Xn),(xxx).W
/*388 */	{6,	2,	14,1,0,1,	19,1,2,1},	// MOVE.B (xxx).W,(xxx).W
/*389 */	{5,	0,	14,1,0,1,	20,1,2,1},	// MOVE.B (xxx).L,(xxx).W
/*390 */	{6,	2,	14,1,0,1,	19,1,2,1},	// MOVE.B (d16,PC),(xxx).W
/*391 */	{8,	2,	12,1,0,1,	13,1,2,1},	// MOVE.B (d8,PC,Xn),(xxx).W
/*392 */	{6,	0,	10,0,0,1,	15,0,2,1},	// MOVE.B #<data>.B,(xxx).W
/*393 */	{0,	0,	 8,0,0,1,	13,0,2,1},	// MOVE.B Dn,(xxx).L
/*394 */	{1,	1,	13,1,0,1,	18,1,2,1},	// MOVE.B (An),(xxx).L
/*395 */	{0,	1,	13,1,0,1,	18,1,2,1},	// MOVE.B (An)+,(xxx).L
/*396 */	{2,	2,	14,1,0,1,	19,1,2,1},	// MOVE.B -(An),(xxx).L
/*397 */	{2,	2,	14,1,0,1,	21,1,3,1},	// MOVE.B (d16,An),(xxx).L
/*398 */	{4,	2,	16,1,0,1,	23,1,3,1},	// MOVE.B (d8,An,Xn),(xxx).L
/*399 */	{2,	2,	14,1,0,1,	21,1,3,1},	// MOVE.B (xxx).W,(xxx).L
/*400 */	{1,	0,	14,1,0,1,	22,1,3,1},	// MOVE.B (xxx).L,(xxx).L
/*401 */	{2,	2,	14,1,0,1,	21,1,3,1},	// MOVE.B (d16,PC),(xxx).L
/*402 */	{4,	2,	16,1,0,1,	23,1,3,1},	// MOVE.B (d8,PC,Xn),(xxx).L
/*403 */	{2,	0,	10,0,0,1,	17,0,3,1},	// MOVE.B #<data>.B,(xxx).L
/*404 */	{2,	0,	 2,0,0,0,	 4,0,1,0},	// MOVE.L Dn,Dn
/*405 */	{2,	0,	 2,0,0,0,	 4,0,1,0},	// MOVE.L An,Dn
/*406 */	{1,	1,	11,1,0,0,	13,1,1,0},	// MOVE.L (An),Dn
/*407 */	{0,	1,	11,1,0,0,	13,1,1,0},	// MOVE.L (An)+,Dn
/*408 */	{2,	2,	12,1,0,0,	14,1,1,0},	// MOVE.L -(An),Dn
/*409 */	{2,	2,	12,1,0,0,	16,1,1,0},	// MOVE.L (d16,An),Dn
/*410 */	{4,	2,	14,1,0,0,	18,1,2,0},	// MOVE.L (d8,An,Xn),Dn
/*411 */	{2,	2,	12,1,0,0,	16,1,2,0},	// MOVE.L (xxx).W,Dn
/*412 */	{1,	0,	12,1,0,0,	17,1,2,0},	// MOVE.L (xxx).L,Dn
/*413 */	{2,	2,	12,1,0,0,	16,1,2,0},	// MOVE.L (d16,PC),Dn
/*414 */	{4,	2,	14,1,0,0,	18,1,2,0},	// MOVE.L (d8,PC,Xn),Dn
/*415 */	{4,	0,	 6,0,0,0,	10,0,2,0},	// MOVE.L #<data>.L,Dn
/*416 */	{2,	0,	 2,0,0,0,	 4,0,1,0},	// MOVEA.L Dn,An
/*417 */	{2,	0,	 2,0,0,0,	 4,0,1,0},	// MOVEA.L An,An
/*418 */	{1,	1,	11,1,0,0,	13,1,1,0},	// MOVEA.L (An),An
/*419 */	{0,	1,	11,1,0,0,	13,1,1,0},	// MOVEA.L (An)+,An
/*420 */	{2,	2,	12,1,0,0,	14,1,1,0},	// MOVEA.L -(An),An
/*421 */	{2,	2,	12,1,0,0,	16,1,1,0},	// MOVEA.L (d16,An),An
/*422 */	{4,	2,	14,1,0,0,	18,1,2,0},	// MOVEA.L (d8,An,Xn),An
/*423 */	{2,	2,	12,1,0,0,	16,1,2,0},	// MOVEA.L (xxx).W,An
/*424 */	{1,	0,	12,1,0,0,	17,1,2,0},	// MOVEA.L (xxx).L,An
/*425 */	{2,	2,	12,1,0,0,	16,1,2,0},	// MOVEA.L (d16,PC),An
/*426 */	{4,	2,	14,1,0,0,	18,1,2,0},	// MOVEA.L (d8,PC,Xn),An
/*427 */	{4,	0,	 6,0,0,0,	10,0,2,0},	// MOVEA.L #<data>.L,An
/*428 */	{0,	1,	 9,0,0,1,	12,0,1,1},	// MOVE.L Dn,(An)
/*429 */	{0,	1,	 9,0,0,1,	12,0,1,1},	// MOVE.L An,(An)
/*430 */	{3,	1,	19,1,0,1,	22,1,1,1},	// MOVE.L (An),(An)
/*431 */	{2,	1,	19,1,0,1,	22,1,1,1},	// MOVE.L (An)+,(An)
/*432 */	{4,	2,	20,1,0,1,	25,1,1,1},	// MOVE.L -(An),(An)
/*433 */	{4,	2,	20,1,0,1,	25,1,2,1},	// MOVE.L (d16,An),(An)
/*434 */	{6,	2,	22,1,0,1,	27,1,2,1},	// MOVE.L (d8,An,Xn),(An)
/*435 */	{4,	2,	20,1,0,1,	25,1,2,1},	// MOVE.L (xxx).W,(An)
/*436 */	{3,	0,	20,1,0,1,	26,1,2,1},	// MOVE.L (xxx).L,(An)
/*437 */	{4,	2,	20,1,0,1,	25,1,2,1},	// MOVE.L (d16,PC),(An)
/*438 */	{6,	2,	22,1,0,1,	27,1,2,1},	// MOVE.L (d8,PC,Xn),(An)
/*439 */	{6,	0,	14,0,0,1,	19,0,2,1},	// MOVE.L #<data>.L,(An)
/*440 */	{0,	1,	 9,0,0,1,	12,0,1,1},	// MOVE.L Dn,(An)+
/*441 */	{0,	1,	 9,0,0,1,	12,0,1,1},	// MOVE.L An,(An)+
/*442 */	{3,	1,	19,1,0,1,	22,1,1,1},	// MOVE.L (An),(An)+
/*443 */	{2,	1,	19,1,0,1,	22,1,1,1},	// MOVE.L (An)+,(An)+
/*444 */	{4,	2,	20,1,0,1,	25,1,1,1},	// MOVE.L -(An),(An)+
/*445 */	{4,	2,	20,1,0,1,	25,1,2,1},	// MOVE.L (d16,An),(An)+
/*446 */	{6,	2,	22,1,0,1,	27,1,2,1},	// MOVE.L (d8,An,Xn),(An)+
/*447 */	{4,	2,	20,1,0,1,	25,1,2,1},	// MOVE.L (xxx).W,(An)+
/*448 */	{3,	0,	20,1,0,1,	26,1,2,1},	// MOVE.L (xxx).L,(An)+
/*449 */	{4,	2,	20,1,0,1,	25,1,2,1},	// MOVE.L (d16,PC),(An)+
/*450 */	{6,	2,	22,1,0,1,	27,1,2,1},	// MOVE.L (d8,PC,Xn),(An)+
/*451 */	{6,	0,	14,0,0,1,	19,0,2,1},	// MOVE.L #<data>.L,(An)+
/*452 */	{0,	2,	10,0,0,1,	12,0,1,1},	// MOVE.L Dn,-(An)
/*453 */	{0,	2,	10,0,0,1,	12,0,1,1},	// MOVE.L An,-(An)
/*454 */	{3,	1,	19,1,0,1,	22,1,1,1},	// MOVE.L (An),-(An)
/*455 */	{2,	1,	19,1,0,1,	22,1,1,1},	// MOVE.L (An)+,-(An)
/*456 */	{4,	2,	20,1,0,1,	25,1,1,1},	// MOVE.L -(An),-(An)
/*457 */	{4,	2,	20,1,0,1,	25,1,2,1},	// MOVE.L (d16,An),-(An)
/*458 */	{6,	2,	22,1,0,1,	27,1,2,1},	// MOVE.L (d8,An,Xn),-(An)
/*459 */	{4,	2,	20,1,0,1,	25,1,2,1},	// MOVE.L (xxx).W,-(An)
/*460 */	{3,	0,	20,1,0,1,	26,1,2,1},	// MOVE.L (xxx).L,-(An)
/*461 */	{4,	2,	20,1,0,1,	25,1,2,1},	// MOVE.L (d16,PC),-(An)
/*462 */	{6,	2,	22,1,0,1,	27,1,2,1},	// MOVE.L (d8,PC,Xn),-(An)
/*463 */	{6,	0,	14,0,0,1,	19,0,2,1},	// MOVE.L #<data>.L,-(An)
/*464 */	{2,	0,	10,0,0,1,	13,0,1,1},	// MOVE.L Dn,(d16,An)
/*465 */	{2,	0,	10,0,0,1,	13,0,1,1},	// MOVE.L An,(d16,An)
/*466 */	{3,	1,	19,1,0,1,	22,1,1,1},	// MOVE.L (An),(d16,An)
/*467 */	{2,	1,	19,1,0,1,	22,1,1,1},	// MOVE.L (An)+,(d16,An)
/*468 */	{4,	2,	20,1,0,1,	25,1,1,1},	// MOVE.L -(An),(d16,An)
/*469 */	{4,	2,	20,1,0,1,	25,1,2,1},	// MOVE.L (d16,An),(d16,An)
/*470 */	{6,	2,	22,1,0,1,	27,1,2,1},	// MOVE.L (d8,An,Xn),(d16,An)
/*471 */	{4,	2,	20,1,0,1,	25,1,2,1},	// MOVE.L (xxx).W,(d16,An)
/*472 */	{3,	0,	20,1,0,1,	26,1,2,1},	// MOVE.L (xxx).L,(d16,An)
/*473 */	{4,	2,	20,1,0,1,	25,1,2,1},	// MOVE.L (d16,PC),(d16,An)
/*474 */	{6,	2,	22,1,0,1,	27,1,2,1},	// MOVE.L (d8,PC,Xn),(d16,An)
/*475 */	{6,	0,	14,0,0,1,	19,0,2,1},	// MOVE.L #<data>.L,(d16,An)
/*476 */	{4,	0,	12,0,0,1,	15,0,1,1},	// MOVE.L Dn,(d8,An,Xn)
/*477 */	{4,	0,	12,0,0,1,	15,0,1,1},	// MOVE.L An,(d8,An,Xn)
/*478 */	{5,	1,	21,1,0,1,	24,1,1,1},	// MOVE.L (An),(d8,An,Xn)
/*479 */	{4,	1,	21,1,0,1,	24,1,1,1},	// MOVE.L (An)+,(d8,An,Xn)
/*480 */	{6,	2,	22,1,0,1,	25,1,1,1},	// MOVE.L -(An),(d8,An,Xn)
/*481 */	{6,	2,	22,1,0,1,	27,1,2,1},	// MOVE.L (d16,An),(d8,An,Xn)
/*482 */	{8,	2,	24,1,0,1,	29,1,2,1},	// MOVE.L (d8,An,Xn),(d8,An,Xn)
/*483 */	{6,	2,	22,1,0,1,	27,1,2,1},	// MOVE.L (xxx).W,(d8,An,Xn)
/*484 */	{5,	0,	22,1,0,1,	28,1,2,1},	// MOVE.L (xxx).L,(d8,An,Xn)
/*485 */	{6,	2,	22,1,0,1,	27,1,2,1},	// MOVE.L (d16,PC),(d8,An,Xn)
/*486 */	{8,	2,	24,1,0,1,	29,1,2,1},	// MOVE.L (d8,PC,Xn),(d8,An,Xn)
/*487 */	{8,	0,	16,0,0,1,	21,0,2,1},	// MOVE.L #<data>.L,(d8,An,Xn)
/*488 */	{2,	0,	10,0,0,1,	13,0,1,1},	// MOVE.L Dn,(xxx).W
/*489 */	{2,	0,	10,0,0,1,	13,0,1,1},	// MOVE.L An,(xxx).W
/*490 */	{3,	1,	19,1,0,1,	22,1,1,1},	// MOVE.L (An),(xxx).W
/*491 */	{2,	1,	19,1,0,1,	22,1,1,1},	// MOVE.L (An)+,(xxx).W
/*492 */	{4,	2,	20,1,0,1,	25,1,1,1},	// MOVE.L -(An),(xxx).W
/*493 */	{4,	2,	20,1,0,1,	25,1,2,1},	// MOVE.L (d16,An),(xxx).W
/*494 */	{6,	2,	22,1,0,1,	27,1,2,1},	// MOVE.L (d8,An,Xn),(xxx).W
/*495 */	{4,	2,	20,1,0,1,	25,1,2,1},	// MOVE.L (xxx).W,(xxx).W
/*496 */	{3,	0,	20,1,0,1,	26,1,2,1},	// MOVE.L (xxx).L,(xxx).W
/*497 */	{4,	2,	20,1,0,1,	25,1,2,1},	// MOVE.L (d16,PC),(xxx).W
/*498 */	{6,	2,	22,1,0,1,	27,1,2,1},	// MOVE.L (d8,PC,Xn),(xxx).W
/*499 */	{6,	0,	14,0,0,1,	19,0,2,1},	// MOVE.L #<data>.L,(xxx).W
/*500 */	{0,	0,	12,0,0,1,	17,0,2,1},	// MOVE.L Dn,(xxx).L
/*501 */	{0,	0,	12,0,0,1,	17,0,2,1},	// MOVE.L An,(xxx).L
/*502 */	{1,	1,	21,1,0,1,	26,1,2,1},	// MOVE.L (An),(xxx).L
/*503 */	{0,	1,	21,1,0,1,	26,1,2,1},	// MOVE.L (An)+,(xxx).L
/*504 */	{2,	2,	22,1,0,1,	27,1,2,1},	// MOVE.L -(An),(xxx).L
/*505 */	{2,	2,	22,1,0,1,	29,1,3,1},	// MOVE.L (d16,An),(xxx).L
/*506 */	{4,	2,	24,1,0,1,	31,1,3,1},	// MOVE.L (d8,An,Xn),(xxx).L
/*507 */	{2,	2,	22,1,0,1,	29,1,3,1},	// MOVE.L (xxx).W,(xxx).L
/*508 */	{1,	0,	22,1,0,1,	30,1,3,1},	// MOVE.L (xxx).L,(xxx).L
/*509 */	{2,	2,	22,1,0,1,	29,1,3,1},	// MOVE.L (d16,PC),(xxx).L
/*510 */	{4,	2,	24,1,0,1,	31,1,3,1},	// MOVE.L (d8,PC,Xn),(xxx).L
/*511 */	{4,	0,	16,0,0,1,	23,0,3,1},	// MOVE.L #<data>.L,(xxx).L
/*512 */	{2,	0,	 2,0,0,0,	 4,0,1,0},	// MOVE.W Dn,Dn
/*513 */	{2,	0,	 2,0,0,0,	 4,0,1,0},	// MOVE.W An,Dn
/*514 */	{1,	1,	 7,1,0,0,	 9,1,1,0},	// MOVE.W (An),Dn
/*515 */	{0,	1,	 7,1,0,0,	 9,1,1,0},	// MOVE.W (An)+,Dn
/*516 */	{2,	2,	 8,1,0,0,	10,1,1,0},	// MOVE.W -(An),Dn
/*517 */	{2,	2,	 8,1,0,0,	12,1,1,0},	// MOVE.W (d16,An),Dn
/*518 */	{4,	2,	10,1,0,0,	14,1,2,0},	// MOVE.W (d8,An,Xn),Dn
/*519 */	{2,	2,	 8,1,0,0,	12,1,2,0},	// MOVE.W (xxx).W,Dn
/*520 */	{1,	0,	 8,1,0,0,	13,1,2,0},	// MOVE.W (xxx).L,Dn
/*521 */	{2,	2,	 8,1,0,0,	12,1,2,0},	// MOVE.W (d16,PC),Dn
/*522 */	{4,	2,	10,1,0,0,	14,1,2,0},	// MOVE.W (d8,PC,Xn),Dn
/*523 */	{2,	0,	 4,0,0,0,	 8,0,2,0},	// MOVE.W #<data>.W,Dn
/*524 */	{2,	0,	 2,0,0,0,	 4,0,1,0},	// MOVEA.W Dn,An
/*525 */	{2,	0,	 2,0,0,0,	 4,0,1,0},	// MOVEA.W An,An
/*526 */	{1,	1,	 7,1,0,0,	 9,1,1,0},	// MOVEA.W (An),An
/*527 */	{0,	1,	 7,1,0,0,	 9,1,1,0},	// MOVEA.W (An)+,An
/*528 */	{2,	2,	 8,1,0,0,	10,1,1,0},	// MOVEA.W -(An),An
/*529 */	{2,	2,	 8,1,0,0,	12,1,2,0},	// MOVEA.W (d16,An),An
/*530 */	{4,	2,	10,1,0,0,	14,1,2,0},	// MOVEA.W (d8,An,Xn),An
/*531 */	{2,	2,	 8,1,0,0,	12,1,2,0},	// MOVEA.W (xxx).W,An
/*532 */	{1,	0,	 8,1,0,0,	13,1,2,0},	// MOVEA.W (xxx).L,An
/*533 */	{2,	2,	 8,1,0,0,	12,1,2,0},	// MOVEA.W (d16,PC),An
/*534 */	{4,	2,	10,1,0,0,	14,1,2,0},	// MOVEA.W (d8,PC,Xn),An
/*535 */	{2,	0,	 4,0,0,0,	 8,0,2,0},	// MOVEA.W #<data>.W,An
/*536 */	{0,	1,	 5,0,0,1,	 8,0,1,1},	// MOVE.W Dn,(An)
/*537 */	{0,	1,	 5,0,0,1,	 8,0,1,1},	// MOVE.W An,(An)
/*538 */	{3,	1,	11,1,0,1,	14,1,1,1},	// MOVE.W (An),(An)
/*539 */	{2,	1,	11,1,0,1,	14,1,1,1},	// MOVE.W (An)+,(An)
/*540 */	{4,	2,	12,1,0,1,	15,1,1,1},	// MOVE.W -(An),(An)
/*541 */	{4,	2,	12,1,0,1,	17,1,2,1},	// MOVE.W (d16,An),(An)
/*542 */	{6,	2,	14,1,0,1,	19,1,2,1},	// MOVE.W (d8,An,Xn),(An)
/*543 */	{4,	2,	12,1,0,1,	17,1,2,1},	// MOVE.W (xxx).W,(An)
/*544 */	{3,	0,	12,1,0,1,	18,1,2,1},	// MOVE.W (xxx).L,(An)
/*545 */	{4,	2,	12,1,0,1,	17,1,2,1},	// MOVE.W (d16,PC),(An)
/*546 */	{6,	2,	14,1,0,1,	19,1,2,1},	// MOVE.W (d8,PC,Xn),(An)
/*547 */	{4,	0,	 8,0,0,1,	13,0,2,1},	// MOVE.W #<data>.W,(An)
/*548 */	{0,	1,	 5,0,0,1,	 8,0,1,1},	// MOVE.W Dn,(An)+
/*549 */	{0,	1,	 5,0,0,1,	 8,0,1,1},	// MOVE.W An,(An)+
/*550 */	{3,	1,	11,1,0,1,	14,1,1,1},	// MOVE.W (An),(An)+
/*551 */	{2,	1,	11,1,0,1,	14,1,1,1},	// MOVE.W (An)+,(An)+
/*552 */	{4,	2,	12,1,0,1,	15,1,1,1},	// MOVE.W -(An),(An)+
/*553 */	{4,	2,	12,1,0,1,	17,1,2,1},	// MOVE.W (d16,An),(An)+
/*554 */	{6,	2,	14,1,0,1,	19,1,2,1},	// MOVE.W (d8,An,Xn),(An)+
/*555 */	{4,	2,	12,1,0,1,	17,1,2,1},	// MOVE.W (xxx).W,(An)+
/*556 */	{3,	0,	12,1,0,1,	18,1,2,1},	// MOVE.W (xxx).L,(An)+
/*557 */	{4,	2,	12,1,0,1,	17,1,2,1},	// MOVE.W (d16,PC),(An)+
/*558 */	{6,	2,	14,1,0,1,	19,1,2,1},	// MOVE.W (d8,PC,Xn),(An)+
/*559 */	{4,	0,	 8,0,0,1,	13,0,2,1},	// MOVE.W #<data>.W,(An)+
/*560 */	{0,	2,	 6,0,0,1,	 8,0,1,1},	// MOVE.W Dn,-(An)
/*561 */	{0,	2,	 6,0,0,1,	 8,0,1,1},	// MOVE.W An,-(An)
/*562 */	{3,	1,	11,1,0,1,	14,1,1,1},	// MOVE.W (An),-(An)
/*563 */	{2,	1,	11,1,0,1,	14,1,1,1},	// MOVE.W (An)+,-(An)
/*564 */	{4,	2,	12,1,0,1,	15,1,1,1},	// MOVE.W -(An),-(An)
/*565 */	{4,	2,	12,1,0,1,	17,1,2,1},	// MOVE.W (d16,An),-(An)
/*566 */	{6,	2,	14,1,0,1,	19,1,2,1},	// MOVE.W (d8,An,Xn),-(An)
/*567 */	{4,	2,	12,1,0,1,	17,1,2,1},	// MOVE.W (xxx).W,-(An)
/*568 */	{3,	0,	12,1,0,1,	18,1,2,1},	// MOVE.W (xxx).L,-(An)
/*569 */	{4,	2,	12,1,0,1,	17,1,2,1},	// MOVE.W (d16,PC),-(An)
/*570 */	{6,	2,	14,1,0,1,	19,1,2,1},	// MOVE.W (d8,PC,Xn),-(An)
/*571 */	{4,	0,	 8,0,0,1,	13,0,2,1},	// MOVE.W #<data>.W,-(An)
/*572 */	{2,	0,	 6,0,0,1,	 9,0,1,1},	// MOVE.W Dn,(d16,An)
/*573 */	{2,	0,	 6,0,0,1,	 9,0,1,1},	// MOVE.W An,(d16,An)
/*574 */	{3,	1,	11,1,0,1,	14,1,1,1},	// MOVE.W (An),(d16,An)
/*575 */	{2,	1,	11,1,0,1,	14,1,1,1},	// MOVE.W (An)+,(d16,An)
/*576 */	{4,	2,	12,1,0,1,	15,1,1,1},	// MOVE.W -(An),(d16,An)
/*577 */	{4,	2,	12,1,0,1,	17,1,2,1},	// MOVE.W (d16,An),(d16,An)
/*578 */	{6,	2,	14,1,0,1,	19,1,2,1},	// MOVE.W (d8,An,Xn),(d16,An)
/*579 */	{4,	2,	12,1,0,1,	17,1,2,1},	// MOVE.W (xxx).W,(d16,An)
/*580 */	{3,	0,	12,1,0,1,	18,1,2,1},	// MOVE.W (xxx).L,(d16,An)
/*581 */	{4,	2,	12,1,0,1,	17,1,2,1},	// MOVE.W (d16,PC),(d16,An)
/*582 */	{6,	2,	14,1,0,1,	19,1,2,1},	// MOVE.W (d8,PC,Xn),(d16,An)
/*583 */	{4,	0,	 8,0,0,1,	13,0,2,1},	// MOVE.W #<data>.W,(d16,An)
/*584 */	{4,	0,	 8,0,0,1,	11,0,1,1},	// MOVE.W Dn,(d8,An,Xn)
/*585 */	{4,	0,	 8,0,0,1,	11,0,1,1},	// MOVE.W An,(d8,An,Xn)
/*586 */	{5,	1,	13,1,0,1,	16,1,1,1},	// MOVE.W (An),(d8,An,Xn)
/*587 */	{4,	1,	13,1,0,1,	16,1,1,1},	// MOVE.W (An)+,(d8,An,Xn)
/*588 */	{6,	2,	14,1,0,1,	17,1,1,1},	// MOVE.W -(An),(d8,An,Xn)
/*589 */	{6,	2,	14,1,0,1,	19,1,2,1},	// MOVE.W (d16,An),(d8,An,Xn)
/*590 */	{8,	2,	12,1,0,1,	13,1,2,1},	// MOVE.W (d8,An,Xn),(d8,An,Xn)
/*591 */	{6,	2,	14,1,0,1,	19,1,2,1},	// MOVE.W (xxx).W,(d8,An,Xn)
/*592 */	{5,	0,	14,1,0,1,	20,1,2,1},	// MOVE.W (xxx).L,(d8,An,Xn)
/*593 */	{6,	2,	14,1,0,1,	19,1,2,1},	// MOVE.W (d16,PC),(d8,An,Xn)
/*594 */	{8,	2,	12,1,0,1,	13,1,2,1},	// MOVE.W (d8,PC,Xn),(d8,An,Xn)
/*595 */	{6,	0,	10,0,0,1,	15,0,2,1},	// MOVE.W #<data>.W,(d8,An,Xn)
/*596 */	{4,	0,	 8,0,0,1,	11,0,1,1},	// MOVE.W Dn,(xxx).W
/*597 */	{4,	0,	 8,0,0,1,	11,0,1,1},	// MOVE.W An,(xxx).W
/*598 */	{5,	1,	13,1,0,1,	16,1,1,1},	// MOVE.W (An),(xxx).W
/*599 */	{4,	1,	13,1,0,1,	16,1,1,1},	// MOVE.W (An)+,(xxx).W
/*600 */	{6,	2,	14,1,0,1,	17,1,1,1},	// MOVE.W -(An),(xxx).W
/*601 */	{6,	2,	14,1,0,1,	19,1,2,1},	// MOVE.W (d16,An),(xxx).W
/*602 */	{8,	2,	12,1,0,1,	13,1,2,1},	// MOVE.W (d8,An,Xn),(xxx).W
/*603 */	{6,	2,	14,1,0,1,	19,1,2,1},	// MOVE.W (xxx).W,(xxx).W
/*604 */	{5,	0,	14,1,0,1,	20,1,2,1},	// MOVE.W (xxx).L,(xxx).W
/*605 */	{6,	2,	14,1,0,1,	19,1,2,1},	// MOVE.W (d16,PC),(xxx).W
/*606 */	{8,	2,	12,1,0,1,	13,1,2,1},	// MOVE.W (d8,PC,Xn),(xxx).W
/*607 */	{6,	0,	10,0,0,1,	15,0,2,1},	// MOVE.W #<data>.W,(xxx).W
/*608 */	{0,	0,	 8,0,0,1,	13,0,2,1},	// MOVE.W Dn,(xxx).L
/*609 */	{0,	0,	 8,0,0,1,	13,0,2,1},	// MOVE.W An,(xxx).L
/*610 */	{1,	1,	13,1,0,1,	18,1,2,1},	// MOVE.W (An),(xxx).L
/*611 */	{0,	1,	13,1,0,1,	18,1,2,1},	// MOVE.W (An)+,(xxx).L
/*612 */	{2,	2,	14,1,0,1,	19,1,2,1},	// MOVE.W -(An),(xxx).L
/*613 */	{2,	2,	14,1,0,1,	21,1,3,1},	// MOVE.W (d16,An),(xxx).L
/*614 */	{4,	2,	16,1,0,1,	23,1,3,1},	// MOVE.W (d8,An,Xn),(xxx).L
/*615 */	{2,	2,	14,1,0,1,	21,1,3,1},	// MOVE.W (xxx).W,(xxx).L
/*616 */	{1,	0,	14,1,0,1,	22,1,3,1},	// MOVE.W (xxx).L,(xxx).L
/*617 */	{2,	2,	14,1,0,1,	21,1,3,1},	// MOVE.W (d16,PC),(xxx).L
/*618 */	{4,	2,	16,1,0,1,	23,1,3,1},	// MOVE.W (d8,PC,Xn),(xxx).L
/*619 */	{2,	0,	10,0,0,1,	17,0,3,1},	// MOVE.W #<data>.W,(xxx).L
/*620 */	{2,	0,	 2,0,0,0,	 4,0,1,0},	// NEGX.B Dn
/*621 */	{1,	2,	10,1,0,1,	13,1,1,1},	// NEGX.B (An)
/*622 */	{0,	2,	10,1,0,1,	13,1,1,1},	// NEGX.B (An)+
/*623 */	{2,	3,	11,1,0,1,	14,1,1,1},	// NEGX.B -(An)
/*624 */	{2,	3,	11,1,0,1,	16,1,2,1},	// NEGX.B (d16,An)
/*625 */	{4,	3,	13,1,0,1,	18,1,2,1},	// NEGX.B (d8,An,Xn)
/*626 */	{2,	3,	11,1,0,1,	16,1,2,1},	// NEGX.B (xxx).W
/*627 */	{1,	1,	11,1,0,1,	17,1,2,1},	// NEGX.B (xxx).L
/*628 */	{2,	0,	 2,0,0,0,	 4,0,1,0},	// NEGX.W Dn
/*629 */	{1,	2,	10,1,0,1,	13,1,1,1},	// NEGX.W (An)
/*630 */	{0,	2,	10,1,0,1,	13,1,1,1},	// NEGX.W (An)+
/*631 */	{2,	3,	11,1,0,1,	14,1,1,1},	// NEGX.W -(An)
/*632 */	{2,	3,	11,1,0,1,	16,1,2,1},	// NEGX.W (d16,An)
/*633 */	{4,	3,	13,1,0,1,	18,1,2,1},	// NEGX.W (d8,An,Xn)
/*634 */	{2,	3,	11,1,0,1,	16,1,2,1},	// NEGX.W (xxx).W
/*635 */	{1,	1,	11,1,0,1,	17,1,2,1},	// NEGX.W (xxx).L
/*636 */	{2,	0,	 2,0,0,0,	 4,0,1,0},	// NEGX.L Dn
/*637 */	{1,	2,	18,1,0,1,	21,1,1,1},	// NEGX.L (An)
/*638 */	{0,	2,	18,1,0,1,	21,1,1,1},	// NEGX.L (An)+
/*639 */	{2,	3,	19,1,0,1,	22,1,1,1},	// NEGX.L -(An)
/*640 */	{2,	3,	19,1,0,1,	24,1,2,1},	// NEGX.L (d16,An)
/*641 */	{4,	3,	21,1,0,1,	26,1,2,1},	// NEGX.L (d8,An,Xn)
/*642 */	{2,	3,	19,1,0,1,	24,1,2,1},	// NEGX.L (xxx).W
/*643 */	{1,	1,	19,1,0,1,	25,1,2,1},	// NEGX.L (xxx).L
/*644 */	{2,	0,	 4,0,0,0,	 6,0,1,0},	// MOVE.W SR,Dn
/*645 */	{3,	1,	11,1,0,1,	14,1,1,1},	// MOVE.W SR,(An)
/*646 */	{2,	1,	11,1,0,1,	14,1,1,1},	// MOVE.W SR,(An)+
/*647 */	{4,	2,	12,1,0,1,	15,1,1,1},	// MOVE.W SR,-(An)
/*648 */	{4,	2,	12,1,0,1,	17,1,2,1},	// MOVE.W SR,(d16,An)
/*649 */	{6,	2,	14,1,0,1,	19,1,2,1},	// MOVE.W SR,(d8,An,Xn)
/*650 */	{4,	2,	12,1,0,1,	17,1,2,1},	// MOVE.W SR,(xxx).W
/*651 */	{3,	0,	12,1,0,1,	18,1,2,1},	// MOVE.W SR,(xxx).L
/*652 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// CHK.L Dn,Dn		(See CHK table below)
/*653 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// CHK.L (An),Dn	(See CHK table below)
/*654 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// CHK.L (An)+,Dn	(See CHK table below)
/*655 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// CHK.L -(An),Dn	(See CHK table below)
/*656 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// CHK.L (d16,An),Dn	(See CHK table below)
/*657 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// CHK.L (d8,An,Xn),Dn	(See CHK table below)
/*658 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// CHK.L (xxx).W,Dn	(See CHK table below)
/*659 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// CHK.L (xxx).L,Dn	(See CHK table below)
/*660 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// CHK.L (d16,PC),Dn	(See CHK table below)
/*661 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// CHK.L (d8,PC,Xn),Dn	(See CHK table below)
/*662 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// CHK.L #<data>.L,Dn	(See CHK table below)
/*663 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// CHK.W Dn,Dn		(See CHK table below)
/*664 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// CHK.W (An),Dn	(See CHK table below)
/*665 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// CHK.W (An)+,Dn	(See CHK table below)
/*666 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// CHK.W -(An),Dn	(See CHK table below)
/*667 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// CHK.W (d16,An),Dn	(See CHK table below)
/*668 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// CHK.W (d8,An,Xn),Dn	(See CHK table below)
/*669 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// CHK.W (xxx).W,Dn	(See CHK table below)
/*670 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// CHK.W (xxx).L,Dn	(See CHK table below)
/*671 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// CHK.W (d16,PC),Dn	(See CHK table below)
/*672 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// CHK.W (d8,PC,Xn),Dn	(See CHK table below)
/*673 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// CHK.W #<data>.W,Dn	(See CHK table below)
/*674 */	{6,	0,	 4,0,0,0,	 6,0,1,0},	// LEA.L (An),An
/*675 */	{6,	0,	 4,0,0,0,	 8,0,2,0},	// LEA.L (d16,An),An
/*676 */	{8,	0,	 6,0,0,0,	10,0,2,0},	// LEA.L (d8,An,Xn),An
/*677 */	{6,	0,	 4,0,0,0,	 8,0,2,0},	// LEA.L (xxx).W,An
/*678 */	{8,	0,	 6,0,0,0,	10,0,2,0},	// LEA.L (xxx).L,An
/*679 */	{6,	0,	 4,0,0,0,	 8,0,2,0},	// LEA.L (d16,PC),An
/*680 */	{8,	0,	 6,0,0,0,	10,0,2,0},	// LEA.L (d8,PC,Xn),An
/*681 */	{2,	0,	 2,0,0,0,	 4,0,1,0},	// CLR.B Dn
/*682 */	{2,	1,	 7,0,0,1,	10,0,1,1},	// CLR.B (An)
/*683 */	{0,	1,	 7,0,0,1,	10,0,1,1},	// CLR.B (An)+
/*684 */	{2,	1,	 7,0,0,1,	10,0,1,1},	// CLR.B -(An)
/*685 */	{2,	1,	 7,0,0,1,	12,0,2,1},	// CLR.B (d16,An)
/*686 */	{4,	1,	 9,0,0,1,	14,0,2,1},	// CLR.B (d8,An,Xn)
/*687 */	{2,	1,	 7,0,0,1,	12,0,2,1},	// CLR.B (xxx).W
/*688 */	{4,	1,	 9,0,0,1,	14,0,2,1},	// CLR.B (xxx).L
/*689 */	{2,	0,	 2,0,0,0,	 4,0,1,0},	// CLR.W Dn
/*690 */	{2,	1,	 7,0,0,1,	10,0,1,1},	// CLR.W (An)
/*691 */	{0,	1,	 7,0,0,1,	10,0,1,1},	// CLR.W (An)+
/*692 */	{2,	1,	 7,0,0,1,	10,0,1,1},	// CLR.W -(An)
/*693 */	{2,	1,	 7,0,0,1,	12,0,2,1},	// CLR.W (d16,An)
/*694 */	{4,	1,	 9,0,0,1,	14,0,2,1},	// CLR.W (d8,An,Xn)
/*695 */	{2,	1,	 7,0,0,1,	12,0,2,1},	// CLR.W (xxx).W
/*696 */	{4,	1,	 9,0,0,1,	14,0,2,1},	// CLR.W (xxx).L
/*697 */	{2,	0,	 2,0,0,0,	 4,0,1,0},	// CLR.L Dn
/*698 */	{2,	1,	11,0,0,1,	14,0,1,1},	// CLR.L (An)
/*699 */	{0,	1,	11,0,0,1,	14,0,1,1},	// CLR.L (An)+
/*700 */	{2,	1,	11,0,0,1,	14,0,1,1},	// CLR.L -(An)
/*701 */	{2,	1,	11,0,0,1,	16,0,2,1},	// CLR.L (d16,An)
/*702 */	{4,	1,	13,0,0,1,	18,0,2,1},	// CLR.L (d8,An,Xn)
/*703 */	{2,	1,	11,0,0,1,	16,0,2,1},	// CLR.L (xxx).W
/*704 */	{4,	1,	13,0,0,1,	18,0,2,1},	// CLR.L (xxx).L
/*705 */	{2,	0,	 4,0,0,0,	 6,0,1,0},	// MOVE.B SR,Dn
/*706 */	{3,	1,	11,1,0,1,	14,1,1,1},	// MOVE.B SR,(An)
/*707 */	{2,	1,	11,1,0,1,	14,1,1,1},	// MOVE.B SR,(An)+
/*708 */	{4,	2,	12,1,0,1,	15,1,1,1},	// MOVE.B SR,-(An)
/*709 */	{4,	2,	12,1,0,1,	17,1,2,1},	// MOVE.B SR,(d16,An)
/*710 */	{6,	2,	14,1,0,1,	19,1,2,1},	// MOVE.B SR,(d8,An,Xn)
/*711 */	{4,	2,	12,1,0,1,	17,1,2,1},	// MOVE.B SR,(xxx).W
/*712 */	{3,	0,	12,1,0,1,	18,1,2,1},	// MOVE.B SR,(xxx).L
/*713 */	{2,	0,	 2,0,0,0,	 4,0,1,0},	// NEG.B Dn
/*714 */	{1,	2,	10,1,0,1,	13,1,1,1},	// NEG.B (An)
/*715 */	{0,	2,	10,1,0,1,	13,1,1,1},	// NEG.B (An)+
/*716 */	{2,	3,	11,1,0,1,	14,1,1,1},	// NEG.B -(An)
/*717 */	{2,	3,	11,1,0,1,	16,1,2,1},	// NEG.B (d16,An)
/*718 */	{4,	3,	13,1,0,1,	18,1,2,1},	// NEG.B (d8,An,Xn)
/*719 */	{2,	3,	11,1,0,1,	16,1,2,1},	// NEG.B (xxx).W
/*720 */	{1,	1,	11,1,0,1,	17,1,2,1},	// NEG.B (xxx).L
/*721 */	{2,	0,	 2,0,0,0,	 4,0,1,0},	// NEG.W Dn
/*722 */	{1,	2,	10,1,0,1,	13,1,1,1},	// NEG.W (An)
/*723 */	{0,	2,	10,1,0,1,	13,1,1,1},	// NEG.W (An)+
/*724 */	{2,	3,	11,1,0,1,	14,1,1,1},	// NEG.W -(An)
/*725 */	{2,	3,	11,1,0,1,	16,1,2,1},	// NEG.W (d16,An)
/*726 */	{4,	3,	13,1,0,1,	18,1,2,1},	// NEG.W (d8,An,Xn)
/*727 */	{2,	3,	11,1,0,1,	16,1,2,1},	// NEG.W (xxx).W
/*728 */	{1,	1,	11,1,0,1,	17,1,2,1},	// NEG.W (xxx).L
/*729 */	{2,	0,	 2,0,0,0,	 4,0,1,0},	// NEG.L Dn
/*730 */	{1,	2,	18,1,0,1,	21,1,1,1},	// NEG.L (An)
/*731 */	{0,	2,	18,1,0,1,	21,1,1,1},	// NEG.L (An)+
/*732 */	{2,	3,	19,1,0,1,	22,1,1,1},	// NEG.L -(An)
/*733 */	{2,	3,	19,1,0,1,	24,1,2,1},	// NEG.L (d16,An)
/*734 */	{4,	3,	21,1,0,1,	26,1,2,1},	// NEG.L (d8,An,Xn)
/*735 */	{2,	3,	19,1,0,1,	24,1,2,1},	// NEG.L (xxx).W
/*736 */	{1,	1,	19,1,0,1,	25,1,2,1},	// NEG.L (xxx).L
/*737 */	{0,	0,	 8,0,0,0,	14,0,2,0},	// MOVE.B Dn,SR
/*738 */	{1,	1,	13,1,0,0,	19,1,2,0},	// MOVE.B (An),SR
/*739 */	{0,	1,	13,1,0,0,	19,1,2,0},	// MOVE.B (An)+,SR
/*740 */	{2,	2,	14,1,0,0,	20,1,2,0},	// MOVE.B -(An),SR
/*741 */	{2,	2,	14,1,0,0,	22,1,3,0},	// MOVE.B (d16,An),SR
/*742 */	{4,	2,	16,1,0,0,	24,1,3,0},	// MOVE.B (d8,An,Xn),SR
/*743 */	{2,	2,	14,1,0,0,	22,1,3,0},	// MOVE.B (xxx).W,SR
/*744 */	{1,	0,	14,1,0,0,	23,1,3,0},	// MOVE.B (xxx).L,SR
/*745 */	{2,	2,	14,1,0,0,	22,1,3,0},	// MOVE.B (d16,PC),SR
/*746 */	{4,	2,	16,1,0,0,	24,1,3,0},	// MOVE.B (d8,PC,Xn),SR
/*747 */	{2,	0,	10,0,0,0,	18,0,3,0},	// MOVE.B #<data>.B,SR
/*748 */	{2,	0,	 2,0,0,0,	 4,0,1,0},	// NOT.B Dn
/*749 */	{1,	2,	10,1,0,1,	13,1,1,1},	// NOT.B (An)
/*750 */	{0,	2,	10,1,0,1,	13,1,1,1},	// NOT.B (An)+
/*751 */	{2,	3,	11,1,0,1,	14,1,1,1},	// NOT.B -(An)
/*752 */	{2,	3,	11,1,0,1,	16,1,2,1},	// NOT.B (d16,An)
/*753 */	{4,	3,	13,1,0,1,	18,1,2,1},	// NOT.B (d8,An,Xn)
/*754 */	{2,	3,	11,1,0,1,	16,1,2,1},	// NOT.B (xxx).W
/*755 */	{1,	1,	11,1,0,1,	17,1,2,1},	// NOT.B (xxx).L
/*756 */	{2,	0,	 2,0,0,0,	 4,0,1,0},	// NOT.W Dn
/*757 */	{1,	2,	10,1,0,1,	13,1,1,1},	// NOT.W (An)
/*758 */	{0,	2,	10,1,0,1,	13,1,1,1},	// NOT.W (An)+
/*759 */	{2,	3,	11,1,0,1,	14,1,1,1},	// NOT.W -(An)
/*760 */	{2,	3,	11,1,0,1,	16,1,2,1},	// NOT.W (d16,An)
/*761 */	{4,	3,	13,1,0,1,	18,1,2,1},	// NOT.W (d8,An,Xn)
/*762 */	{2,	3,	11,1,0,1,	16,1,2,1},	// NOT.W (xxx).W
/*763 */	{1,	1,	11,1,0,1,	17,1,2,1},	// NOT.W (xxx).L
/*764 */	{2,	0,	 2,0,0,0,	 4,0,1,0},	// NOT.L Dn
/*765 */	{1,	2,	18,1,0,1,	21,1,1,1},	// NOT.L (An)
/*766 */	{0,	2,	18,1,0,1,	21,1,1,1},	// NOT.L (An)+
/*767 */	{2,	3,	19,1,0,1,	22,1,1,1},	// NOT.L -(An)
/*768 */	{2,	3,	19,1,0,1,	24,1,2,1},	// NOT.L (d16,An)
/*769 */	{4,	3,	21,1,0,1,	26,1,2,1},	// NOT.L (d8,An,Xn)
/*770 */	{2,	3,	19,1,0,1,	24,1,2,1},	// NOT.L (xxx).W
/*771 */	{1,	1,	19,1,0,1,	25,1,2,1},	// NOT.L (xxx).L
/*772 */	{0,	0,	 8,0,0,0,	14,0,2,0},	// MOVE.W Dn,SR
/*773 */	{1,	1,	13,1,0,0,	19,1,2,0},	// MOVE.W (An),SR
/*774 */	{0,	1,	13,1,0,0,	19,1,2,0},	// MOVE.W (An)+,SR
/*775 */	{2,	2,	14,1,0,0,	20,1,2,0},	// MOVE.W -(An),SR
/*776 */	{2,	2,	14,1,0,0,	22,1,3,0},	// MOVE.W (d16,An),SR
/*777 */	{4,	2,	16,1,0,0,	24,1,3,0},	// MOVE.W (d8,An,Xn),SR
/*778 */	{2,	2,	14,1,0,0,	22,1,3,0},	// MOVE.W (xxx).W,SR
/*779 */	{1,	0,	14,1,0,0,	23,1,3,0},	// MOVE.W (xxx).L,SR
/*780 */	{2,	2,	14,1,0,0,	22,1,3,0},	// MOVE.W (d16,PC),SR
/*781 */	{4,	2,	16,1,0,0,	24,1,3,0},	// MOVE.W (d8,PC,Xn),SR
/*782 */	{2,	0,	10,0,0,0,	18,0,3,0},	// MOVE.W #<data>.W,SR
/*783 */	{0,	0,	 6,0,0,0,	 8,0,1,0},	// NBCD.B Dn
/*784 */	{2,	0,	12,0,0,1,	17,0,2,1},	// LINK.L An,#<data>.L
/*785 */	{1,	1,	13,1,0,1,	15,1,1,1},	// NBCD.B (An)	(value guessed (not in motorola 68030UM doc))
/*786 */	{0,	1,	13,1,0,1,	15,1,1,1},	// NBCD.B (An)+	(value guessed (not in motorola 68030UM doc))
/*787 */	{2,	2,	14,1,0,1,	16,1,1,1},	// NBCD.B -(An)	(value guessed (not in motorola 68030UM doc))
/*788 */	{2,	2,	14,1,0,1,	18,1,2,1},	// NBCD.B (d16,An)	(value guessed (not in motorola 68030UM doc))
/*789 */	{4,	2,	16,1,0,1,	20,1,2,1},	// NBCD.B (d8,An,Xn)	(value guessed (not in motorola 68030UM doc))
/*790 */	{2,	2,	14,1,0,1,	18,1,2,1},	// NBCD.B (xxx).W	(value guessed (not in motorola 68030UM doc))
/*791 */	{1,	0,	14,1,0,1,	19,1,2,1},	// NBCD.B (xxx).L	(value guessed (not in motorola 68030UM doc))
/*792 */	{4,	0,	 4,0,0,0,	 6,0,1,0},	// SWAP.W Dn
/*793 */	{1,	0,	15,1,0,0,	15,1,0,0},	// BKPTQ.L #<data>
/*794 */	{2,	2,	12,0,0,1,	14,0,1,1},	// PEA.L (An)
/*795 */	{2,	2,	12,0,0,1,	16,0,2,1},	// PEA.L (d16,An)
/*796 */	{4,	2,	14,0,0,1,	18,0,2,1},	// PEA.L (d8,An,Xn)
/*797 */	{2,	2,	12,0,0,1,	16,0,2,1},	// PEA.L (xxx).W
/*798 */	{4,	2,	14,0,0,1,	18,0,2,1},	// PEA.L (xxx).L
/*799 */	{2,	2,	12,0,0,1,	16,0,2,1},	// PEA.L (d16,PC)
/*800 */	{4,	2,	14,0,0,1,	18,0,2,1},	// PEA.L (d8,PC,Xn)
/*801 */	{4,	0,	 4,0,0,0,	 6,0,1,0},	// EXT.W Dn
/*802 */	{6,	0,	 6,0,0,0,	10,0,2,0},	// MVMLE.W #<data>.W,(An)	(+2n(0,0,n), +2n(0,0,n) taken into account into gencpu.c)
/*803 */	{6,	0,	 6,0,0,0,	10,0,2,0},	// MVMLE.W #<data>.W,-(An)	(+2n(0,0,n), +2n(0,0,n) taken into account into gencpu.c)
/*804 */	{8,	0,	 8,0,0,0,	12,0,2,0},	// MVMLE.W #<data>.W,(d16,An)	(+2n(0,0,n), +2n(0,0,n) taken into account into gencpu.c)
/*805 */	{10,	0,	10,0,0,0,	16,0,3,0},	// MVMLE.W #<data>.W,(d8,An,Xn)	(+2n(0,0,n), +2n(0,0,n) taken into account into gencpu.c)
/*806 */	{8,	0,	 8,0,0,0,	12,0,2,0},	// MVMLE.W #<data>.W,(xxx).W	(+2n(0,0,n), +2n(0,0,n) taken into account into gencpu.c)
/*807 */	{10,	0,	10,0,0,0,	16,0,3,0},	// MVMLE.W #<data>.W,(xxx).L	(+2n(0,0,n), +2n(0,0,n) taken into account into gencpu.c)
/*808 */	{4,	0,	 4,0,0,0,	 6,0,1,0},	// EXT.L Dn
/*809 */	{8,	0,	 8,0,0,0,	12,0,2,0},	// MVMLE.L #<data>.W,(An)	(+2n(0,0,n), +2n(0,0,n) taken into account into gencpu.c)
/*810 */	{8,	0,	 8,0,0,0,	12,0,2,0},	// MVMLE.L #<data>.W,-(An)	(+2n(0,0,n), +2n(0,0,n) taken into account into gencpu.c)
/*811 */	{10,	0,	10,0,0,0,	17,0,3,0},	// MVMLE.L #<data>.W,(d16,An)	(+2n(0,0,n), +2n(0,0,n) taken into account into gencpu.c)
/*812 */	{12,	0,	12,0,0,0,	18,0,3,0},	// MVMLE.L #<data>.W,(d8,An,Xn)	(+2n(0,0,n), +2n(0,0,n) taken into account into gencpu.c)
/*813 */	{10,	0,	10,0,0,0,	16,0,3,0},	// MVMLE.L #<data>.W,(xxx).W	(+2n(0,0,n), +2n(0,0,n) taken into account into gencpu.c)
/*814 */	{12,	0,	12,0,0,0,	18,0,3,0},	// MVMLE.L #<data>.W,(xxx).L	(+2n(0,0,n), +2n(0,0,n) taken into account into gencpu.c)
/*815 */	{4,	0,	 4,0,0,0,	 6,0,1,0},	// EXT.B Dn
/*816 */	{0,	0,	 2,0,0,0,	 4,0,1,0},	// TST.B Dn
/*817 */	{1,	1,	 7,1,0,0,	 9,1,1,0},	// TST.B (An)
/*818 */	{0,	1,	 7,1,0,0,	 9,1,1,0},	// TST.B (An)+
/*819 */	{2,	2,	 8,1,0,0,	10,1,1,0},	// TST.B -(An)
/*820 */	{2,	2,	 8,1,0,0,	12,1,2,0},	// TST.B (d16,An)
/*821 */	{4,	2,	10,1,0,0,	14,1,2,0},	// TST.B (d8,An,Xn)
/*822 */	{2,	2,	 8,1,0,0,	12,1,2,0},	// TST.B (xxx).W
/*823 */	{1,	0,	 8,1,0,0,	13,1,2,0},	// TST.B (xxx).L
/*824 */	{2,	2,	 8,1,0,0,	12,1,2,0},	// TST.B (d16,PC)
/*825 */	{4,	2,	10,1,0,0,	14,1,2,0},	// TST.B (d8,PC,Xn)
/*826 */	{2,	0,	 4,0,0,0,	 8,0,2,0},	// TST.B #<data>.B
/*827 */	{0,	0,	 2,0,0,0,	 4,0,1,0},	// TST.W Dn
/*828 */	{0,	0,	 2,0,0,0,	 4,0,1,0},	// TST.W An
/*829 */	{1,	1,	 7,1,0,0,	 9,1,1,0},	// TST.W (An)
/*830 */	{0,	1,	 7,1,0,0,	 9,1,1,0},	// TST.W (An)+
/*831 */	{2,	2,	 8,1,0,0,	10,1,1,0},	// TST.W -(An)
/*832 */	{2,	2,	 8,1,0,0,	12,1,2,0},	// TST.W (d16,An)
/*833 */	{4,	2,	10,1,0,0,	14,1,2,0},	// TST.W (d8,An,Xn)
/*834 */	{2,	2,	 8,1,0,0,	12,1,2,0},	// TST.W (xxx).W
/*835 */	{1,	0,	 8,1,0,0,	13,1,2,0},	// TST.W (xxx).L
/*836 */	{2,	2,	 8,1,0,0,	12,1,2,0},	// TST.W (d16,PC)
/*837 */	{4,	2,	10,1,0,0,	14,1,2,0},	// TST.W (d8,PC,Xn)
/*838 */	{2,	0,	 4,0,0,0,	 8,0,2,0},	// TST.W #<data>.W
/*839 */	{0,	0,	 2,0,0,0,	 4,0,1,0},	// TST.L Dn
/*840 */	{0,	0,	 2,0,0,0,	 4,0,1,0},	// TST.L An
/*841 */	{1,	1,	11,1,0,0,	13,1,1,0},	// TST.L (An)
/*842 */	{0,	1,	11,1,0,0,	13,1,1,0},	// TST.L (An)+
/*843 */	{2,	2,	12,1,0,0,	14,1,1,0},	// TST.L -(An)
/*844 */	{2,	2,	12,1,0,0,	16,1,2,0},	// TST.L (d16,An)
/*845 */	{4,	2,	14,1,0,0,	18,1,2,0},	// TST.L (d8,An,Xn)
/*846 */	{2,	2,	12,1,0,0,	16,1,2,0},	// TST.L (xxx).W
/*847 */	{1,	0,	12,1,0,0,	17,1,2,0},	// TST.L (xxx).L
/*848 */	{2,	2,	12,1,0,0,	16,1,2,0},	// TST.L (d16,PC)
/*849 */	{4,	2,	14,1,0,0,	18,1,2,0},	// TST.L (d8,PC,Xn)
/*850 */	{4,	0,	 6,0,0,0,	10,0,2,0},	// TST.L #<data>.L
/*851 */	{4,	0,	 4,0,0,0,	 6,0,1,0},	// TAS.B Dn
/*852 */	{8,	0,	18,1,0,1,	20,1,1,1},	// TAS.B (An)
/*853 */	{3,	0,	18,1,0,1,	20,1,1,1},	// TAS.B (An)+
/*854 */	{8,	0,	18,1,0,1,	20,1,1,1},	// TAS.B -(An)
/*855 */	{8,	0,	18,1,0,1,	22,1,2,1},	// TAS.B (d16,An)
/*856 */	{10,	0,	20,1,0,1,	24,1,2,1},	// TAS.B (d8,An,Xn)
/*857 */	{8,	0,	18,1,0,1,	22,1,2,1},	// TAS.B (xxx).W
/*858 */	{10,	0,	20,1,0,1,	24,1,2,1},	// TAS.B (xxx).L
/*859 */	{8,	0,	48,0,0,0,	52,0,2,0},	// MULL.L #<data>.W,Dn			(Max Value)
/*860 */	{3,	0,	54,1,0,0,	59,1,2,0},	// MULL.L #<data>.W,(An)		(Max Value)
/*861 */	{6,	1,	57,1,0,0,	61,1,2,0},	// MULL.L #<data>.W,(An)+		(Max Value)
/*862 */	{4,	0,	54,1,0,0,	59,1,2,0},	// MULL.L #<data>.W,-(An)		(Max Value)
/*863 */	{6,	0,	56,1,0,0,	64,1,3,0},	// MULL.L #<data>.W,(d16,An)		(Max Value)
/*864 */	{10,	2,	60,1,0,0,	66,1,3,0},	// MULL.L #<data>.W,(d8,An,Xn)		(Max Value)
/*865 */	{8,	2,	58,1,0,0,	64,1,3,0},	// MULL.L #<data>.W,(xxx).W		(Max Value)
/*866 */	{7,	0,	58,1,0,0,	65,1,3,0},	// MULL.L #<data>.W,(xxx).L		(Max Value)
/*867 */	{6,	0,	56,1,0,0,	64,1,3,0},	// MULL.L #<data>.W,(d16,PC)		(Max Value)
/*868 */	{10,	2,	60,1,0,0,	66,1,3,0},	// MULL.L #<data>.W,(d8,PC,Xn)		(Max Value)
/*869 */	{10,	0,	50,0,0,0,	56,0,3,0},	// MULL.L #<data>.W,#<data>.L		(Max Value)
/*870 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// DIVL.L #<data>.W,Dn			(See DIVL table below)(Max Value)
/*871 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// DIVL.L #<data>.W,(An)		(See DIVL table below)(Max Value)
/*872 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// DIVL.L #<data>.W,(An)+		(See DIVL table below)(Max Value)
/*873 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// DIVL.L #<data>.W,-(An)		(See DIVL table below)(Max Value)
/*874 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// DIVL.L #<data>.W,(d16,An)		(See DIVL table below)(Max Value)
/*875 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// DIVL.L #<data>.W,(d8,An,Xn)		(See DIVL table below)(Max Value)
/*876 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// DIVL.L #<data>.W,(xxx).W		(See DIVL table below)(Max Value)
/*877 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// DIVL.L #<data>.W,(xxx).L		(See DIVL table below)(Max Value)
/*878 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// DIVL.L #<data>.W,(d16,PC)		(See DIVL table below)(Max Value)
/*879 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// DIVL.L #<data>.W,(d8,PC,Xn)		(See DIVL table below)(Max Value)
/*880 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// DIVL.L #<data>.W,#<data>.L		(See DIVL table below)(Max Value)
/*881 */	{6,	0,	10,0,0,0,	14,0,2,0},	// MVMEL.W #<data>.W,(An)	(+4n(n,0,0), +4n(n,0,0) taken into account into gencpu.c)
/*882 */	{6,	0,	12,0,0,0,	16,0,2,0},	// MVMEL.W #<data>.W,(An)+	(+4n(n,0,0), +4n(n,0,0) taken into account into gencpu.c)
/*883 */	{8,	0,	12,0,0,0,	16,0,2,0},	// MVMEL.W #<data>.W,(d16,An)	(+4n(n,0,0), +4n(n,0,0) taken into account into gencpu.c)
/*884 */	{10,	0,	14,0,0,0,	20,0,3,0},	// MVMEL.W #<data>.W,(d8,An,Xn)	(+4n(n,0,0), +4n(n,0,0) taken into account into gencpu.c)
/*885 */	{8,	0,	12,0,0,0,	16,0,2,0},	// MVMEL.W #<data>.W,(xxx).W	(+4n(n,0,0), +4n(n,0,0) taken into account into gencpu.c)
/*886 */	{10,	0,	14,0,0,0,	20,0,3,0},	// MVMEL.W #<data>.W,(xxx).L	(+4n(n,0,0), +4n(n,0,0) taken into account into gencpu.c)
/*887 */	{8,	0,	12,0,0,0,	16,0,2,0},	// MVMEL.W #<data>.W,(d16,PC)	(+4n(n,0,0), +4n(n,0,0) taken into account into gencpu.c)
/*888 */	{10,	0,	14,0,0,0,	20,0,3,0},	// MVMEL.W #<data>.W,(d8,PC,Xn)	(+4n(n,0,0), +4n(n,0,0) taken into account into gencpu.c)
/*889 */	{8,	0,	12,0,0,0,	16,0,2,0},	// MVMEL.L #<data>.W,(An)	(+4n(n,0,0), +4n(n,0,0) taken into account into gencpu.c)
/*890 */	{6,	0,	14,0,0,0,	18,0,2,0},	// MVMEL.L #<data>.W,(An)+	(+4n(n,0,0), +4n(n,0,0) taken into account into gencpu.c)
/*891 */	{10,	0,	14,0,0,0,	20,0,3,0},	// MVMEL.L #<data>.W,(d16,An)	(+4n(n,0,0), +4n(n,0,0) taken into account into gencpu.c)
/*892 */	{12,	0,	16,0,0,0,	22,0,3,0},	// MVMEL.L #<data>.W,(d8,An,Xn)	(+4n(n,0,0), +4n(n,0,0) taken into account into gencpu.c)
/*893 */	{10,	0,	14,0,0,0,	20,0,3,0},	// MVMEL.L #<data>.W,(xxx).W	(+4n(n,0,0), +4n(n,0,0) taken into account into gencpu.c)
/*894 */	{12,	0,	16,0,0,0,	22,0,3,0},	// MVMEL.L #<data>.W,(xxx).L	(+4n(n,0,0), +4n(n,0,0) taken into account into gencpu.c)
/*895 */	{10,	0,	14,0,0,0,	20,0,3,0},	// MVMEL.L #<data>.W,(d16,PC)	(+4n(n,0,0), +4n(n,0,0) taken into account into gencpu.c)
/*896 */	{12,	0,	16,0,0,0,	22,0,3,0},	// MVMEL.L #<data>.W,(d8,PC,Xn)	(+4n(n,0,0), +4n(n,0,0) taken into account into gencpu.c)
/*897 */	{0,	0,	28,1,0,4,	34,1,2,4},	// TRAPQ.L #<data>
/*898 */	{0,	0,	 6,0,0,1,	 9,0,1,1},	// LINK.W An,#<data>.W
/*899 */	{0,	0,	 7,1,0,0,	 9,1,1,0},	// UNLK.L An
/*900 */	{4,	0,	 4,0,0,0,	 6,0,1,0},	// MOVE An,USP.L
/*901 */	{4,	0,	 4,0,0,0,	 6,0,1,0},	// MOVE USP.L,An
/*902 */	{0,	0,	518,0,0,0,	520,0,1,0}, 	// RESET.L 
/*903 */	{0,	0,	 2,0,0,0,	 4,0,1,0},	// NOP.L 
/*904 */	{0,	0,	 8,0,0,0,	12,0,2,0},	// STOP.L #<data>.W
/*905 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// RTE.L			(See RTE table below) 
/*906 */	{2,	0,	12,1,0,0,	18,1,2,0},	// RTD.L #<data>.W
/*907 */	{1,	0,	11,1,0,0,	17,1,2,0},	// RTS.L 
/*908 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// TRAPV.L			(See TRAPV table below)
/*909 */	{1,	0,	16,2,0,0,	22,2,2,0},	// RTR.L 
/*910 */	{6,	0,	 6,0,0,0,	 8,0,1,0},	// MOVEC2.L #<data>.W
/*911 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// MOVE2C.L #<data>.W		(See MOVEC table below)
/*912 */	{2,	0,	12,0,0,1,	19,0,2,1},	// JSR.L (An)
/*913 */	{4,	0,	14,0,0,1,	21,0,2,1},	// JSR.L (d16,An)
/*914 */	{6,	0,	16,0,0,1,	23,0,2,1},	// JSR.L (d8,An,Xn)
/*915 */	{2,	0,	12,0,0,1,	19,0,2,1},	// JSR.L (xxx).W
/*916 */	{2,	0,	12,0,0,1,	19,0,2,1},	// JSR.L (xxx).L
/*917 */	{4,	0,	14,0,0,1,	21,0,2,1},	// JSR.L (d16,PC)
/*918 */	{6,	0,	16,0,0,1,	23,0,2,1},	// JSR.L (d8,PC,Xn)
/*919 */	{10,	0,	 6,0,0,0,	12,0,2,0},	// JMP.L (An)
/*920 */	{12,	0,	 8,0,0,0,	14,0,2,0},	// JMP.L (d16,An)
/*921 */	{14,	0,	10,0,0,0,	16,0,2,0},	// JMP.L (d8,An,Xn)
/*922 */	{10,	0,	 6,0,0,0,	12,0,2,0},	// JMP.L (xxx).W
/*923 */	{10,	0,	 6,0,0,0,	12,0,2,0},	// JMP.L (xxx).L
/*924 */	{12,	0,	 8,0,0,0,	14,0,2,0},	// JMP.L (d16,PC)
/*925 */	{14,	0,	10,0,0,0,	16,0,2,0},	// JMP.L (d8,PC,Xn)
/*926 */	{2,	0,	 2,0,0,0,	 4,0,1,0},	// ADDQ.B #<data>,Dn
/*927 */	{1,	2,	10,1,0,1,	13,1,1,1},	// ADDQ.B #<data>,(An)
/*928 */	{0,	2,	10,1,0,1,	13,1,1,1},	// ADDQ.B #<data>,(An)+
/*929 */	{2,	3,	11,1,0,1,	14,1,1,1},	// ADDQ.B #<data>,-(An)
/*930 */	{2,	3,	11,1,0,1,	16,1,2,1},	// ADDQ.B #<data>,(d16,An)
/*931 */	{4,	3,	13,1,0,1,	18,1,2,1},	// ADDQ.B #<data>,(d8,An,Xn)
/*932 */	{2,	3,	11,1,0,1,	16,1,2,1},	// ADDQ.B #<data>,(xxx).W
/*933 */	{1,	1,	11,1,0,1,	17,1,2,1},	// ADDQ.B #<data>,(xxx).L
/*934 */	{2,	0,	 2,0,0,0,	 4,0,1,0},	// ADDQ.W #<data>,Dn
/*935 */	{2,	0,	 2,0,0,0,	 4,0,1,0},	// ADDAQ.W #<data>,An
/*936 */	{1,	2,	10,1,0,1,	13,1,1,1},	// ADDQ.W #<data>,(An)
/*937 */	{0,	2,	10,1,0,1,	13,1,1,1},	// ADDQ.W #<data>,(An)+
/*938 */	{2,	3,	11,1,0,1,	14,1,1,1},	// ADDQ.W #<data>,-(An)
/*939 */	{2,	3,	11,1,0,1,	16,1,2,1},	// ADDQ.W #<data>,(d16,An)
/*940 */	{4,	3,	13,1,0,1,	18,1,2,1},	// ADDQ.W #<data>,(d8,An,Xn)
/*941 */	{2,	3,	11,1,0,1,	16,1,2,1},	// ADDQ.W #<data>,(xxx).W
/*942 */	{1,	1,	11,1,0,1,	17,1,2,1},	// ADDQ.W #<data>,(xxx).L
/*943 */	{2,	0,	 2,0,0,0,	 4,0,1,0},	// ADDQ.L #<data>,Dn
/*944 */	{2,	0,	 2,0,0,0,	 4,0,1,0},	// ADDAQ.L #<data>,An
/*945 */	{1,	2,	18,1,0,1,	21,1,1,1},	// ADDQ.L #<data>,(An)
/*946 */	{0,	2,	18,1,0,1,	21,1,1,1},	// ADDQ.L #<data>,(An)+
/*947 */	{2,	3,	19,1,0,1,	22,1,1,1},	// ADDQ.L #<data>,-(An)
/*948 */	{2,	3,	19,1,0,1,	24,1,2,1},	// ADDQ.L #<data>,(d16,An)
/*949 */	{4,	3,	21,1,0,1,	26,1,2,1},	// ADDQ.L #<data>,(d8,An,Xn)
/*950 */	{2,	3,	19,1,0,1,	24,1,2,1},	// ADDQ.L #<data>,(xxx).W
/*951 */	{1,	1,	19,1,0,1,	25,1,2,1},	// ADDQ.L #<data>,(xxx).L
/*952 */	{4,	0,	 4,0,0,0,	 6,0,1,0},	// Scc.B Dn
/*953 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// DBcc.W Dn,#<data>.W		(See DBcc table below)
/*954 */	{2,	1,	 9,0,0,1,	11,0,1,1},	// Scc.B (An)
/*955 */	{0,	1,	 9,0,0,1,	11,0,1,1},	// Scc.B (An)+
/*956 */	{2,	1,	 9,0,0,1,	11,0,1,1},	// Scc.B -(An)
/*957 */	{2,	1,	 9,0,0,1,	13,0,2,1},	// Scc.B (d16,An)
/*958 */	{4,	1,	11,0,0,1,	15,0,2,1},	// Scc.B (d8,An,Xn)
/*959 */	{2,	1,	 9,0,0,1,	13,0,2,1},	// Scc.B (xxx).W
/*960 */	{4,	1,	11,0,0,1,	15,0,2,1},	// Scc.B (xxx).L
/*961 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// TRAPcc.L #<data>.W		(See TRAPCC.W table below)
/*962 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// TRAPcc.L #<data>.L		(See TRAPCC.L table below)
/*963 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// TRAPcc.L 			(See TRAPCC table below)
/*964 */	{2,	0,	 2,0,0,0,	 4,0,1,0},	// SUBQ.B #<data>,Dn
/*965 */	{1,	2,	10,1,0,1,	13,1,1,1},	// SUBQ.B #<data>,(An)
/*966 */	{0,	2,	10,1,0,1,	13,1,1,1},	// SUBQ.B #<data>,(An)+
/*967 */	{2,	3,	11,1,0,1,	14,1,1,1},	// SUBQ.B #<data>,-(An)
/*968 */	{2,	3,	11,1,0,1,	16,1,2,1},	// SUBQ.B #<data>,(d16,An)
/*969 */	{4,	3,	13,1,0,1,	18,1,2,1},	// SUBQ.B #<data>,(d8,An,Xn)
/*970 */	{2,	3,	11,1,0,1,	16,1,2,1},	// SUBQ.B #<data>,(xxx).W
/*971 */	{1,	1,	11,1,0,1,	17,1,2,1},	// SUBQ.B #<data>,(xxx).L
/*972 */	{2,	0,	 2,0,0,0,	 4,0,1,0},	// SUBQ.W #<data>,Dn
/*973 */	{2,	0,	 2,0,0,0,	 4,0,1,0},	// SUBAQ.W #<data>,An
/*974 */	{1,	2,	10,1,0,1,	13,1,1,1},	// SUBQ.W #<data>,(An)
/*975 */	{0,	2,	10,1,0,1,	13,1,1,1},	// SUBQ.W #<data>,(An)+
/*976 */	{2,	3,	11,1,0,1,	14,1,1,1},	// SUBQ.W #<data>,-(An)
/*977 */	{2,	3,	11,1,0,1,	16,1,2,1},	// SUBQ.W #<data>,(d16,An)
/*978 */	{4,	3,	13,1,0,1,	18,1,2,1},	// SUBQ.W #<data>,(d8,An,Xn)
/*979 */	{2,	3,	11,1,0,1,	16,1,2,1},	// SUBQ.W #<data>,(xxx).W
/*980 */	{1,	1,	11,1,0,1,	17,1,2,1},	// SUBQ.W #<data>,(xxx).L
/*981 */	{2,	0,	 2,0,0,0,	 4,0,1,0},	// SUBQ.L #<data>,Dn
/*982 */	{2,	0,	 2,0,0,0,	 4,0,1,0},	// SUBAQ.L #<data>,An
/*983 */	{1,	2,	18,1,0,1,	21,1,1,1},	// SUBQ.L #<data>,(An)
/*984 */	{0,	2,	18,1,0,1,	21,1,1,1},	// SUBQ.L #<data>,(An)+
/*985 */	{2,	3,	19,1,0,1,	22,1,1,1},	// SUBQ.L #<data>,-(An)
/*986 */	{2,	3,	19,1,0,1,	24,1,2,1},	// SUBQ.L #<data>,(d16,An)
/*987 */	{4,	3,	21,1,0,1,	26,1,2,1},	// SUBQ.L #<data>,(d8,An,Xn)
/*988 */	{2,	3,	19,1,0,1,	24,1,2,1},	// SUBQ.L #<data>,(xxx).W
/*989 */	{1,	1,	19,1,0,1,	25,1,2,1},	// SUBQ.L #<data>,(xxx).L
/*990 */	{4,	0,	 4,0,0,0,	 6,0,1,0},	// Scc.B Dn
/*991 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// DBcc.W Dn,#<data>.W		(See DBcc table below)
/*992 */	{2,	1,	 9,0,0,1,	11,0,1,1},	// Scc.B (An)
/*993 */	{0,	1,	 9,0,0,1,	11,0,1,1},	// Scc.B (An)+
/*994 */	{2,	1,	 9,0,0,1,	11,0,1,1},	// Scc.B -(An)
/*995 */	{2,	1,	 9,0,0,1,	13,0,2,1},	// Scc.B (d16,An)
/*996 */	{4,	1,	11,0,0,1,	15,0,2,1},	// Scc.B (d8,An,Xn)
/*997 */	{2,	1,	 9,0,0,1,	13,0,2,1},	// Scc.B (xxx).W
/*998 */	{4,	1,	11,0,0,1,	15,0,2,1},	// Scc.B (xxx).L
/*999 */	{0,	0,	 0,0,0,0,	 0,0,0,0},	// TRAPcc.L #<data>.W		(See TRAPCC.W table below)
/*1000*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// TRAPcc.L #<data>.L		(See TRAPCC.L table below)
/*1001*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// TRAPcc.L 			(See TRAPCC table below)
/*1002*/	{4,	0,	 4,0,0,0,	 6,0,1,0},	// Scc.B Dn
/*1003*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// DBcc.W Dn,#<data>.W		(See DBcc table below)
/*1004*/	{2,	1,	 9,0,0,1,	11,0,1,1},	// Scc.B (An)
/*1005*/	{0,	1,	 9,0,0,1,	11,0,1,1},	// Scc.B (An)+
/*1006*/	{2,	1,	 9,0,0,1,	11,0,1,1},	// Scc.B -(An)
/*1007*/	{2,	1,	 9,0,0,1,	13,0,2,1},	// Scc.B (d16,An)
/*1008*/	{4,	1,	11,0,0,1,	15,0,2,1},	// Scc.B (d8,An,Xn)
/*1009*/	{2,	1,	 9,0,0,1,	13,0,2,1},	// Scc.B (xxx).W
/*1010*/	{4,	1,	11,0,0,1,	15,0,2,1},	// Scc.B (xxx).L
/*1011*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// TRAPcc.L #<data>.W		(See TRAPCC.W table below)
/*1012*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// TRAPcc.L #<data>.L		(See TRAPCC.L table below)
/*1013*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// TRAPcc.L 			(See TRAPCC table below)
/*1014*/	{4,	0,	 4,0,0,0,	 6,0,1,0},	// Scc.B Dn
/*1015*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// DBcc.W Dn,#<data>.W		(See DBcc table below)
/*1016*/	{2,	1,	 9,0,0,1,	11,0,1,1},	// Scc.B (An)
/*1017*/	{0,	1,	 9,0,0,1,	11,0,1,1},	// Scc.B (An)+
/*1018*/	{2,	1,	 9,0,0,1,	11,0,1,1},	// Scc.B -(An)
/*1019*/	{2,	1,	 9,0,0,1,	13,0,2,1},	// Scc.B (d16,An)
/*1020*/	{4,	1,	11,0,0,1,	15,0,2,1},	// Scc.B (d8,An,Xn)
/*1021*/	{2,	1,	 9,0,0,1,	13,0,2,1},	// Scc.B (xxx).W
/*1022*/	{4,	1,	11,0,0,1,	15,0,2,1},	// Scc.B (xxx).L
/*1023*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// TRAPcc.L #<data>.W		(See TRAPCC.W table below)
/*1024*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// TRAPcc.L #<data>.L		(See TRAPCC.L table below)
/*1025*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// TRAPcc.L 			(See TRAPCC table below)
/*1026*/	{4,	0,	 4,0,0,0,	 6,0,1,0},	// Scc.B Dn
/*1027*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// DBcc.W Dn,#<data>.W		(See DBcc table below)
/*1028*/	{2,	1,	 9,0,0,1,	11,0,1,1},	// Scc.B (An)
/*1029*/	{0,	1,	 9,0,0,1,	11,0,1,1},	// Scc.B (An)+
/*1030*/	{2,	1,	 9,0,0,1,	11,0,1,1},	// Scc.B -(An)
/*1031*/	{2,	1,	 9,0,0,1,	13,0,2,1},	// Scc.B (d16,An)
/*1032*/	{4,	1,	11,0,0,1,	15,0,2,1},	// Scc.B (d8,An,Xn)
/*1033*/	{2,	1,	 9,0,0,1,	13,0,2,1},	// Scc.B (xxx).W
/*1034*/	{4,	1,	11,0,0,1,	15,0,2,1},	// Scc.B (xxx).L
/*1035*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// TRAPcc.L #<data>.W		(See TRAPCC.W table below)
/*1036*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// TRAPcc.L #<data>.L		(See TRAPCC.L table below)
/*1037*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// TRAPcc.L 			(See TRAPCC table below)
/*1038*/	{4,	0,	 4,0,0,0,	 6,0,1,0},	// Scc.B Dn
/*1039*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// DBcc.W Dn,#<data>.W		(See DBcc table below)
/*1040*/	{2,	1,	 9,0,0,1,	11,0,1,1},	// Scc.B (An)
/*1041*/	{0,	1,	 9,0,0,1,	11,0,1,1},	// Scc.B (An)+
/*1042*/	{2,	1,	 9,0,0,1,	11,0,1,1},	// Scc.B -(An)
/*1043*/	{2,	1,	 9,0,0,1,	13,0,2,1},	// Scc.B (d16,An)
/*1044*/	{4,	1,	11,0,0,1,	15,0,2,1},	// Scc.B (d8,An,Xn)
/*1045*/	{2,	1,	 9,0,0,1,	13,0,2,1},	// Scc.B (xxx).W
/*1046*/	{4,	1,	11,0,0,1,	15,0,2,1},	// Scc.B (xxx).L
/*1047*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// TRAPcc.L #<data>.W		(See TRAPCC.W table below)
/*1048*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// TRAPcc.L #<data>.L		(See TRAPCC.L table below)
/*1049*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// TRAPcc.L 			(See TRAPCC table below)
/*1050*/	{4,	0,	 4,0,0,0,	 6,0,1,0},	// Scc.B Dn
/*1051*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// DBcc.W Dn,#<data>.W		(See DBcc table below)
/*1052*/	{2,	1,	 9,0,0,1,	11,0,1,1},	// Scc.B (An)
/*1053*/	{0,	1,	 9,0,0,1,	11,0,1,1},	// Scc.B (An)+
/*1054*/	{2,	1,	 9,0,0,1,	11,0,1,1},	// Scc.B -(An)
/*1055*/	{2,	1,	 9,0,0,1,	13,0,2,1},	// Scc.B (d16,An)
/*1056*/	{4,	1,	11,0,0,1,	15,0,2,1},	// Scc.B (d8,An,Xn)
/*1057*/	{2,	1,	 9,0,0,1,	13,0,2,1},	// Scc.B (xxx).W
/*1058*/	{4,	1,	11,0,0,1,	15,0,2,1},	// Scc.B (xxx).L
/*1059*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// TRAPcc.L #<data>.W		(See TRAPCC.W table below)
/*1060*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// TRAPcc.L #<data>.L		(See TRAPCC.L table below)
/*1061*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// TRAPcc.L 			(See TRAPCC table below)
/*1062*/	{4,	0,	 4,0,0,0,	 6,0,1,0},	// Scc.B Dn
/*1063*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// DBcc.W Dn,#<data>.W		(See DBcc table below)
/*1064*/	{2,	1,	 9,0,0,1,	11,0,1,1},	// Scc.B (An)
/*1065*/	{0,	1,	 9,0,0,1,	11,0,1,1},	// Scc.B (An)+
/*1066*/	{2,	1,	 9,0,0,1,	11,0,1,1},	// Scc.B -(An)
/*1067*/	{2,	1,	 9,0,0,1,	13,0,2,1},	// Scc.B (d16,An)
/*1068*/	{4,	1,	11,0,0,1,	15,0,2,1},	// Scc.B (d8,An,Xn)
/*1069*/	{2,	1,	 9,0,0,1,	13,0,2,1},	// Scc.B (xxx).W
/*1070*/	{4,	1,	11,0,0,1,	15,0,2,1},	// Scc.B (xxx).L
/*1071*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// TRAPcc.L #<data>.W		(See TRAPCC.W table below)
/*1072*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// TRAPcc.L #<data>.L		(See TRAPCC.L table below)
/*1073*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// TRAPcc.L 			(See TRAPCC table below)
/*1074*/	{4,	0,	 4,0,0,0,	 6,0,1,0},	// Scc.B Dn
/*1075*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// DBcc.W Dn,#<data>.W		(See DBcc table below)
/*1076*/	{2,	1,	 9,0,0,1,	11,0,1,1},	// Scc.B (An)
/*1077*/	{0,	1,	 9,0,0,1,	11,0,1,1},	// Scc.B (An)+
/*1078*/	{2,	1,	 9,0,0,1,	11,0,1,1},	// Scc.B -(An)
/*1079*/	{2,	1,	 9,0,0,1,	13,0,2,1},	// Scc.B (d16,An)
/*1080*/	{4,	1,	11,0,0,1,	15,0,2,1},	// Scc.B (d8,An,Xn)
/*1081*/	{2,	1,	 9,0,0,1,	13,0,2,1},	// Scc.B (xxx).W
/*1082*/	{4,	1,	11,0,0,1,	15,0,2,1},	// Scc.B (xxx).L
/*1083*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// TRAPcc.L #<data>.W		(See TRAPCC.W table below)
/*1084*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// TRAPcc.L #<data>.L		(See TRAPCC.L table below)
/*1085*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// TRAPcc.L 			(See TRAPCC table below)
/*1086*/	{4,	0,	 4,0,0,0,	 6,0,1,0},	// Scc.B Dn
/*1087*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// DBcc.W Dn,#<data>.W		(See DBcc table below)
/*1088*/	{2,	1,	 9,0,0,1,	11,0,1,1},	// Scc.B (An)
/*1089*/	{0,	1,	 9,0,0,1,	11,0,1,1},	// Scc.B (An)+
/*1090*/	{2,	1,	 9,0,0,1,	11,0,1,1},	// Scc.B -(An)
/*1091*/	{2,	1,	 9,0,0,1,	13,0,2,1},	// Scc.B (d16,An)
/*1092*/	{4,	1,	11,0,0,1,	15,0,2,1},	// Scc.B (d8,An,Xn)
/*1093*/	{2,	1,	 9,0,0,1,	13,0,2,1},	// Scc.B (xxx).W
/*1094*/	{4,	1,	11,0,0,1,	15,0,2,1},	// Scc.B (xxx).L
/*1095*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// TRAPcc.L #<data>.W		(See TRAPCC.W table below)
/*1096*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// TRAPcc.L #<data>.L		(See TRAPCC.L table below)
/*1097*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// TRAPcc.L 			(See TRAPCC table below)
/*1098*/	{4,	0,	 4,0,0,0,	 6,0,1,0},	// Scc.B Dn
/*1099*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// DBcc.W Dn,#<data>.W		(See DBcc table below)
/*1100*/	{2,	1,	 9,0,0,1,	11,0,1,1},	// Scc.B (An)
/*1101*/	{0,	1,	 9,0,0,1,	11,0,1,1},	// Scc.B (An)+
/*1102*/	{2,	1,	 9,0,0,1,	11,0,1,1},	// Scc.B -(An)
/*1103*/	{2,	1,	 9,0,0,1,	13,0,2,1},	// Scc.B (d16,An)
/*1104*/	{4,	1,	11,0,0,1,	15,0,2,1},	// Scc.B (d8,An,Xn)
/*1105*/	{2,	1,	 9,0,0,1,	13,0,2,1},	// Scc.B (xxx).W
/*1106*/	{4,	1,	11,0,0,1,	15,0,2,1},	// Scc.B (xxx).L
/*1107*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// TRAPcc.L #<data>.W		(See TRAPCC.W table below)
/*1108*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// TRAPcc.L #<data>.L		(See TRAPCC.L table below)
/*1109*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// TRAPcc.L 			(See TRAPCC table below)
/*1110*/	{4,	0,	 4,0,0,0,	 6,0,1,0},	// Scc.B Dn
/*1111*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// DBcc.W Dn,#<data>.W		(See DBcc table below)
/*1112*/	{2,	1,	 9,0,0,1,	11,0,1,1},	// Scc.B (An)
/*1113*/	{0,	1,	 9,0,0,1,	11,0,1,1},	// Scc.B (An)+
/*1114*/	{2,	1,	 9,0,0,1,	11,0,1,1},	// Scc.B -(An)
/*1115*/	{2,	1,	 9,0,0,1,	13,0,2,1},	// Scc.B (d16,An)
/*1116*/	{4,	1,	11,0,0,1,	15,0,2,1},	// Scc.B (d8,An,Xn)
/*1117*/	{2,	1,	 9,0,0,1,	13,0,2,1},	// Scc.B (xxx).W
/*1118*/	{4,	1,	11,0,0,1,	15,0,2,1},	// Scc.B (xxx).L
/*1119*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// TRAPcc.L #<data>.W		(See TRAPCC.W table below)
/*1120*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// TRAPcc.L #<data>.L		(See TRAPCC.L table below)
/*1121*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// TRAPcc.L 			(See TRAPCC table below)
/*1122*/	{4,	0,	 4,0,0,0,	 6,0,1,0},	// Scc.B Dn
/*1123*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// DBcc.W Dn,#<data>.W		(See DBcc table below)
/*1124*/	{2,	1,	 9,0,0,1,	11,0,1,1},	// Scc.B (An)
/*1125*/	{0,	1,	 9,0,0,1,	11,0,1,1},	// Scc.B (An)+
/*1126*/	{2,	1,	 9,0,0,1,	11,0,1,1},	// Scc.B -(An)
/*1127*/	{2,	1,	 9,0,0,1,	13,0,2,1},	// Scc.B (d16,An)
/*1128*/	{4,	1,	11,0,0,1,	15,0,2,1},	// Scc.B (d8,An,Xn)
/*1129*/	{2,	1,	 9,0,0,1,	13,0,2,1},	// Scc.B (xxx).W
/*1130*/	{4,	1,	11,0,0,1,	15,0,2,1},	// Scc.B (xxx).L
/*1131*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// TRAPcc.L #<data>.W		(See TRAPCC.W table below)
/*1132*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// TRAPcc.L #<data>.L		(See TRAPCC.L table below)
/*1133*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// TRAPcc.L 			(See TRAPCC table below)
/*1134*/	{4,	0,	 4,0,0,0,	 6,0,1,0},	// Scc.B Dn
/*1135*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// DBcc.W Dn,#<data>.W		(See DBcc table below)
/*1136*/	{2,	1,	 9,0,0,1,	11,0,1,1},	// Scc.B (An)
/*1137*/	{0,	1,	 9,0,0,1,	11,0,1,1},	// Scc.B (An)+
/*1138*/	{2,	1,	 9,0,0,1,	11,0,1,1},	// Scc.B -(An)
/*1139*/	{2,	1,	 9,0,0,1,	13,0,2,1},	// Scc.B (d16,An)
/*1140*/	{4,	1,	11,0,0,1,	15,0,2,1},	// Scc.B (d8,An,Xn)
/*1141*/	{2,	1,	 9,0,0,1,	13,0,2,1},	// Scc.B (xxx).W
/*1142*/	{4,	1,	11,0,0,1,	15,0,2,1},	// Scc.B (xxx).L
/*1143*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// TRAPcc.L #<data>.W		(See TRAPCC.W table below)
/*1144*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// TRAPcc.L #<data>.L		(See TRAPCC.L table below)
/*1145*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// TRAPcc.L 			(See TRAPCC table below)
/*1146*/	{4,	0,	 4,0,0,0,	 6,0,1,0},	// Scc.B Dn
/*1147*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// DBcc.W Dn,#<data>.W		(See DBcc table below)
/*1148*/	{2,	1,	 9,0,0,1,	11,0,1,1},	// Scc.B (An)
/*1149*/	{0,	1,	 9,0,0,1,	11,0,1,1},	// Scc.B (An)+
/*1150*/	{2,	1,	 9,0,0,1,	11,0,1,1},	// Scc.B -(An)
/*1151*/	{2,	1,	 9,0,0,1,	13,0,2,1},	// Scc.B (d16,An)
/*1152*/	{4,	1,	11,0,0,1,	15,0,2,1},	// Scc.B (d8,An,Xn)
/*1153*/	{2,	1,	 9,0,0,1,	13,0,2,1},	// Scc.B (xxx).W
/*1154*/	{4,	1,	11,0,0,1,	15,0,2,1},	// Scc.B (xxx).L
/*1155*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// TRAPcc.L #<data>.W		(See TRAPCC.W table below)
/*1156*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// TRAPcc.L #<data>.L		(See TRAPCC.L table below)
/*1157*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// TRAPcc.L 			(See TRAPCC table below)
/*1158*/	{4,	0,	 4,0,0,0,	 6,0,1,0},	// Scc.B Dn
/*1159*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// DBcc.W Dn,#<data>.W		(See DBcc table below)
/*1160*/	{2,	1,	 9,0,0,1,	11,0,1,1},	// Scc.B (An)
/*1161*/	{0,	1,	 9,0,0,1,	11,0,1,1},	// Scc.B (An)+
/*1162*/	{2,	1,	 9,0,0,1,	11,0,1,1},	// Scc.B -(An)
/*1163*/	{2,	1,	 9,0,0,1,	13,0,2,1},	// Scc.B (d16,An)
/*1164*/	{4,	1,	11,0,0,1,	15,0,2,1},	// Scc.B (d8,An,Xn)
/*1165*/	{2,	1,	 9,0,0,1,	13,0,2,1},	// Scc.B (xxx).W
/*1166*/	{4,	1,	11,0,0,1,	15,0,2,1},	// Scc.B (xxx).L
/*1167*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// TRAPcc.L #<data>.W		(See TRAPCC.W table below)
/*1168*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// TRAPcc.L #<data>.L		(See TRAPCC.L table below)
/*1169*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// TRAPcc.L 			(See TRAPCC table below)
/*1170*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// Bcc.W #<data>.W		(See Bcc table below)
/*1171*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// BccQ.B #<data>		(See Bcc table below)
/*1172*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// Bcc.L #<data>.L		(See Bcc table below)
/*1173*/	{2,	0,	 8,0,0,1,	15,0,2,1},	// BSR.W #<data>.W
/*1174*/	{2,	0,	 8,0,0,1,	15,0,2,1},	// BSRQ.B #<data>
/*1175*/	{2,	0,	12,0,0,1,	19,0,2,1},	// BSR.L #<data>.L
/*1176*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// Bcc.W #<data>.W		(See Bcc table below)
/*1177*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// BccQ.B #<data>		(See Bcc table below)
/*1178*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// Bcc.L #<data>.L		(See Bcc table below)
/*1179*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// Bcc.W #<data>.W		(See Bcc table below)
/*1180*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// BccQ.B #<data>		(See Bcc table below)
/*1181*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// Bcc.L #<data>.L		(See Bcc table below)
/*1182*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// Bcc.W #<data>.W		(See Bcc table below)
/*1183*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// BccQ.B #<data>		(See Bcc table below)
/*1184*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// Bcc.L #<data>.L		(See Bcc table below)
/*1185*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// Bcc.W #<data>.W		(See Bcc table below)
/*1186*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// BccQ.B #<data>		(See Bcc table below)
/*1187*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// Bcc.L #<data>.L		(See Bcc table below)
/*1188*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// Bcc.W #<data>.W		(See Bcc table below)
/*1189*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// BccQ.B #<data>		(See Bcc table below)
/*1190*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// Bcc.L #<data>.L		(See Bcc table below)
/*1191*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// Bcc.W #<data>.W		(See Bcc table below)
/*1192*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// BccQ.B #<data>		(See Bcc table below)
/*1193*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// Bcc.L #<data>.L		(See Bcc table below)
/*1194*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// Bcc.W #<data>.W		(See Bcc table below)
/*1195*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// BccQ.B #<data>		(See Bcc table below)
/*1196*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// Bcc.L #<data>.L		(See Bcc table below)
/*1197*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// Bcc.W #<data>.W		(See Bcc table below)
/*1198*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// BccQ.B #<data>		(See Bcc table below)
/*1199*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// Bcc.L #<data>.L		(See Bcc table below)
/*1200*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// Bcc.W #<data>.W		(See Bcc table below)
/*1201*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// BccQ.B #<data>		(See Bcc table below)
/*1202*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// Bcc.L #<data>.L		(See Bcc table below)
/*1203*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// Bcc.W #<data>.W		(See Bcc table below)
/*1204*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// BccQ.B #<data>		(See Bcc table below)
/*1205*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// Bcc.L #<data>.L		(See Bcc table below)
/*1206*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// Bcc.W #<data>.W		(See Bcc table below)
/*1207*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// BccQ.B #<data>		(See Bcc table below)
/*1208*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// Bcc.L #<data>.L		(See Bcc table below)
/*1209*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// Bcc.W #<data>.W		(See Bcc table below)
/*1210*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// BccQ.B #<data>		(See Bcc table below)
/*1211*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// Bcc.L #<data>.L		(See Bcc table below)
/*1212*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// Bcc.W #<data>.W		(See Bcc table below)
/*1213*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// BccQ.B #<data>		(See Bcc table below)
/*1214*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// Bcc.L #<data>.L		(See Bcc table below)
/*1215*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// Bcc.W #<data>.W		(See Bcc table below)
/*1216*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// BccQ.B #<data>		(See Bcc table below)
/*1217*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// Bcc.L #<data>.L		(See Bcc table below)
/*1218*/	{2,	0,	 2,0,0,0,	 4,0,1,0},	// MOVEQ.L #<data>,Dn
/*1219*/	{2,	0,	 2,0,0,0,	 4,0,1,0},	// OR.B Dn,Dn
/*1220*/	{1,	1,	 7,1,0,0,	 9,1,1,0},	// OR.B (An),Dn
/*1221*/	{0,	1,	 7,1,0,0,	 9,1,1,0},	// OR.B (An)+,Dn
/*1222*/	{2,	2,	 8,1,0,0,	10,1,1,0},	// OR.B -(An),Dn
/*1223*/	{2,	2,	 8,1,0,0,	12,1,1,0},	// OR.B (d16,An),Dn
/*1224*/	{4,	2,	10,1,0,0,	14,1,2,0},	// OR.B (d8,An,Xn),Dn
/*1225*/	{2,	2,	 8,1,0,0,	12,1,2,0},	// OR.B (xxx).W,Dn
/*1226*/	{1,	0,	 8,1,0,0,	13,1,2,0},	// OR.B (xxx).L,Dn
/*1227*/	{2,	2,	 8,1,0,0,	12,1,2,0},	// OR.B (d16,PC),Dn
/*1228*/	{4,	2,	10,1,0,0,	14,1,2,0},	// OR.B (d8,PC,Xn),Dn
/*1229*/	{2,	0,	 4,0,0,0,	 8,0,2,0},	// OR.B #<data>.B,Dn
/*1230*/	{2,	0,	 2,0,0,0,	 4,0,1,0},	// OR.W Dn,Dn
/*1231*/	{1,	1,	 7,1,0,0,	 9,1,1,0},	// OR.W (An),Dn
/*1232*/	{0,	1,	 7,1,0,0,	 9,1,1,0},	// OR.W (An)+,Dn
/*1233*/	{2,	2,	 8,1,0,0,	10,1,1,0},	// OR.W -(An),Dn
/*1234*/	{2,	2,	 8,1,0,0,	12,1,1,0},	// OR.W (d16,An),Dn
/*1235*/	{4,	2,	10,1,0,0,	14,1,2,0},	// OR.W (d8,An,Xn),Dn
/*1236*/	{2,	2,	 8,1,0,0,	12,1,2,0},	// OR.W (xxx).W,Dn
/*1237*/	{1,	0,	 8,1,0,0,	13,1,2,0},	// OR.W (xxx).L,Dn
/*1238*/	{2,	2,	 8,1,0,0,	12,1,2,0},	// OR.W (d16,PC),Dn
/*1239*/	{4,	2,	10,1,0,0,	14,1,2,0},	// OR.W (d8,PC,Xn),Dn
/*1240*/	{2,	0,	 4,0,0,0,	 8,0,2,0},	// OR.W #<data>.W,Dn
/*1241*/	{2,	0,	 2,0,0,0,	 4,0,1,0},	// OR.L Dn,Dn
/*1242*/	{1,	1,	11,1,0,0,	13,1,1,0},	// OR.L (An),Dn
/*1243*/	{0,	1,	11,1,0,0,	13,1,1,0},	// OR.L (An)+,Dn
/*1244*/	{2,	2,	12,1,0,0,	14,1,1,0},	// OR.L -(An),Dn
/*1245*/	{2,	2,	12,1,0,0,	16,1,2,0},	// OR.L (d16,An),Dn
/*1246*/	{4,	2,	14,1,0,0,	18,1,2,0},	// OR.L (d8,An,Xn),Dn
/*1247*/	{2,	2,	12,1,0,0,	16,1,2,0},	// OR.L (xxx).W,Dn
/*1248*/	{1,	0,	12,1,0,0,	17,1,2,0},	// OR.L (xxx).L,Dn
/*1249*/	{2,	2,	12,1,0,0,	16,1,2,0},	// OR.L (d16,PC),Dn
/*1250*/	{4,	2,	14,1,0,0,	18,1,2,0},	// OR.L (d8,PC,Xn),Dn
/*1251*/	{4,	0,	 6,0,0,0,	10,0,2,0},	// OR.L #<data>.L,Dn
/*1252*/	{2,	0,	44,0,0,0,	46,0,1,0},	// DIVU.W Dn,Dn			(Max Value)
/*1253*/	{1,	1,	49,1,0,0,	51,1,1,0},	// DIVU.W (An),Dn		(Max Value)
/*1254*/	{0,	1,	49,1,0,0,	51,1,1,0},	// DIVU.W (An)+,Dn		(Max Value)
/*1255*/	{2,	2,	50,1,0,0,	52,1,1,0},	// DIVU.W -(An),Dn		(Max Value)
/*1256*/	{2,	2,	50,1,0,0,	54,1,2,0},	// DIVU.W (d16,An),Dn		(Max Value)
/*1257*/	{4,	2,	52,1,0,0,	56,1,2,0},	// DIVU.W (d8,An,Xn),Dn		(Max Value)
/*1258*/	{2,	2,	50,1,0,0,	54,1,2,0},	// DIVU.W (xxx).W,Dn		(Max Value)
/*1259*/	{1,	0,	50,1,0,0,	55,1,2,0},	// DIVU.W (xxx).L,Dn		(Max Value)
/*1260*/	{2,	2,	50,1,0,0,	54,1,2,0},	// DIVU.W (d16,PC),Dn		(Max Value)
/*1261*/	{4,	2,	52,1,0,0,	56,1,2,0},	// DIVU.W (d8,PC,Xn),Dn		(Max Value)
/*1262*/	{2,	0,	46,0,0,0,	50,0,2,0},	// DIVU.W #<data>.W,Dn		(Max Value)
/*1263*/	{0,	0,	 4,0,0,0,	 6,0,1,0},	// SBCD.B Dn,Dn
/*1264*/	{2,	1,	19,2,0,1,	22,2,1,1},	// SBCD.B -(An),-(An)
/*1265*/	{1,	2,	10,1,0,1,	13,1,1,1},	// OR.B Dn,(An)
/*1266*/	{0,	2,	10,1,0,1,	13,1,1,1},	// OR.B Dn,(An)+
/*1267*/	{2,	3,	11,1,0,1,	14,1,1,1},	// OR.B Dn,-(An)
/*1268*/	{2,	3,	11,1,0,1,	16,1,2,1},	// OR.B Dn,(d16,An)
/*1269*/	{4,	3,	13,1,0,1,	18,1,2,1},	// OR.B Dn,(d8,An,Xn)
/*1270*/	{2,	3,	11,1,0,1,	16,1,2,1},	// OR.B Dn,(xxx).W
/*1271*/	{1,	1,	11,1,0,1,	17,1,2,1},	// OR.B Dn,(xxx).L
/*1272*/	{6,	0,	 6,0,0,0,	 8,0,1,0},	// PACK.L Dn,Dn
/*1273*/	{2,	1,	23,1,0,1,	25,1,1,1},	// PACK.L -(An),-(An)
/*1274*/	{1,	2,	10,1,0,1,	13,1,1,1},	// OR.W Dn,(An)
/*1275*/	{0,	2,	10,1,0,1,	13,1,1,1},	// OR.W Dn,(An)+
/*1276*/	{2,	3,	11,1,0,1,	14,1,1,1},	// OR.W Dn,-(An)
/*1277*/	{2,	3,	11,1,0,1,	16,1,2,1},	// OR.W Dn,(d16,An)
/*1278*/	{4,	3,	13,1,0,1,	18,1,2,1},	// OR.W Dn,(d8,An,Xn)
/*1279*/	{2,	3,	11,1,0,1,	16,1,2,1},	// OR.W Dn,(xxx).W
/*1280*/	{1,	1,	11,1,0,1,	17,1,2,1},	// OR.W Dn,(xxx).L
/*1281*/	{8,	0,	 8,0,0,0,	10,0,1,0},	// UNPK.L Dn,Dn
/*1282*/	{2,	1,	23,1,0,1,	25,1,1,1},	// UNPK.L -(An),-(An)
/*1283*/	{1,	2,	18,1,0,1,	21,1,1,1},	// OR.L Dn,(An)
/*1284*/	{0,	2,	18,1,0,1,	21,1,1,1},	// OR.L Dn,(An)+
/*1285*/	{2,	3,	19,1,0,1,	22,1,1,1},	// OR.L Dn,-(An)
/*1286*/	{2,	3,	19,1,0,1,	24,1,2,1},	// OR.L Dn,(d16,An)
/*1287*/	{4,	3,	21,1,0,1,	26,1,2,1},	// OR.L Dn,(d8,An,Xn)
/*1288*/	{2,	3,	19,1,0,1,	24,1,2,1},	// OR.L Dn,(xxx).W
/*1289*/	{1,	1,	19,1,0,1,	25,1,2,1},	// OR.L Dn,(xxx).L
/*1290*/	{2,	0,	56,0,0,0,	58,0,1,0},	// DIVS.W Dn,Dn			(Max Value)
/*1291*/	{1,	1,	61,1,0,0,	63,1,1,0},	// DIVS.W (An),Dn		(Max Value)
/*1292*/	{0,	1,	61,1,0,0,	63,1,1,0},	// DIVS.W (An)+,Dn		(Max Value)
/*1293*/	{2,	2,	62,1,0,0,	64,1,1,0},	// DIVS.W -(An),Dn		(Max Value)
/*1294*/	{2,	2,	62,1,0,0,	66,1,2,0},	// DIVS.W (d16,An),Dn		(Max Value)
/*1295*/	{4,	2,	64,1,0,0,	68,1,2,0},	// DIVS.W (d8,An,Xn),Dn		(Max Value)
/*1296*/	{2,	2,	62,1,0,0,	66,1,2,0},	// DIVS.W (xxx).W,Dn		(Max Value)
/*1297*/	{1,	0,	62,1,0,0,	67,1,2,0},	// DIVS.W (xxx).L,Dn		(Max Value)
/*1298*/	{2,	2,	62,1,0,0,	66,1,2,0},	// DIVS.W (d16,PC),Dn		(Max Value)
/*1299*/	{4,	2,	64,1,0,0,	68,1,2,0},	// DIVS.W (d8,PC,Xn),Dn		(Max Value)
/*1300*/	{2,	0,	58,0,0,0,	62,0,2,0},	// DIVS.W #<data>.W,Dn		(Max Value)
/*1301*/	{2,	0,	 2,0,0,0,	 4,0,1,0},	// SUB.B Dn,Dn
/*1302*/	{1,	1,	 7,1,0,0,	 9,1,1,0},	// SUB.B (An),Dn
/*1303*/	{0,	1,	 7,1,0,0,	 9,1,1,0},	// SUB.B (An)+,Dn
/*1304*/	{2,	2,	 8,1,0,0,	10,1,1,0},	// SUB.B -(An),Dn
/*1305*/	{2,	2,	 8,1,0,0,	12,1,1,0},	// SUB.B (d16,An),Dn
/*1306*/	{4,	2,	10,1,0,0,	14,1,2,0},	// SUB.B (d8,An,Xn),Dn
/*1307*/	{2,	2,	 8,1,0,0,	12,1,2,0},	// SUB.B (xxx).W,Dn
/*1308*/	{1,	0,	 8,1,0,0,	13,1,2,0},	// SUB.B (xxx).L,Dn
/*1309*/	{2,	2,	 8,1,0,0,	12,1,2,0},	// SUB.B (d16,PC),Dn
/*1310*/	{4,	2,	10,1,0,0,	14,1,2,0},	// SUB.B (d8,PC,Xn),Dn
/*1311*/	{2,	0,	 4,0,0,0,	 8,0,2,0},	// SUB.B #<data>.B,Dn
/*1312*/	{2,	0,	 2,0,0,0,	 4,0,1,0},	// SUB.W Dn,Dn
/*1313*/	{2,	0,	 2,0,0,0,	 4,0,1,0},	// SUB.W An,Dn
/*1314*/	{1,	1,	 7,1,0,0,	 9,1,1,0},	// SUB.W (An),Dn
/*1315*/	{0,	1,	 7,1,0,0,	 9,1,1,0},	// SUB.W (An)+,Dn
/*1316*/	{2,	2,	 8,1,0,0,	10,1,1,0},	// SUB.W -(An),Dn
/*1317*/	{2,	2,	 8,1,0,0,	12,1,1,0},	// SUB.W (d16,An),Dn
/*1318*/	{4,	2,	10,1,0,0,	14,1,2,0},	// SUB.W (d8,An,Xn),Dn
/*1319*/	{2,	2,	 8,1,0,0,	12,1,2,0},	// SUB.W (xxx).W,Dn
/*1320*/	{1,	0,	 8,1,0,0,	13,1,2,0},	// SUB.W (xxx).L,Dn
/*1321*/	{2,	2,	 8,1,0,0,	12,1,2,0},	// SUB.W (d16,PC),Dn
/*1322*/	{4,	2,	10,1,0,0,	14,1,2,0},	// SUB.W (d8,PC,Xn),Dn
/*1323*/	{2,	0,	 4,0,0,0,	 8,0,2,0},	// SUB.W #<data>.W,Dn
/*1324*/	{2,	0,	 2,0,0,0,	 4,0,1,0},	// SUB.L Dn,Dn
/*1325*/	{2,	0,	 2,0,0,0,	 4,0,1,0},	// SUB.L An,Dn
/*1326*/	{1,	1,	11,1,0,0,	13,1,1,0},	// SUB.L (An),Dn
/*1327*/	{0,	1,	11,1,0,0,	13,1,1,0},	// SUB.L (An)+,Dn
/*1328*/	{2,	2,	12,1,0,0,	14,1,1,0},	// SUB.L -(An),Dn
/*1329*/	{2,	2,	12,1,0,0,	16,1,2,0},	// SUB.L (d16,An),Dn
/*1330*/	{4,	2,	14,1,0,0,	18,1,2,0},	// SUB.L (d8,An,Xn),Dn
/*1331*/	{2,	2,	12,1,0,0,	16,1,2,0},	// SUB.L (xxx).W,Dn
/*1332*/	{1,	0,	12,1,0,0,	17,1,2,0},	// SUB.L (xxx).L,Dn
/*1333*/	{2,	2,	12,1,0,0,	16,1,2,0},	// SUB.L (d16,PC),Dn
/*1334*/	{4,	2,	14,1,0,0,	18,1,2,0},	// SUB.L (d8,PC,Xn),Dn
/*1335*/	{4,	0,	 6,0,0,0,	10,0,2,0},	// SUB.L #<data>.L,Dn
/*1336*/	{4,	0,	 4,0,0,0,	 6,0,1,0},	// SUBA.W Dn,An
/*1337*/	{4,	0,	 4,0,0,0,	 6,0,1,0},	// SUBA.W An,An
/*1338*/	{1,	1,	 9,1,0,0,	11,1,1,0},	// SUBA.W (An),An
/*1339*/	{0,	1,	 9,1,0,0,	11,1,1,0},	// SUBA.W (An)+,An
/*1340*/	{2,	2,	10,1,0,0,	12,1,1,0},	// SUBA.W -(An),An
/*1341*/	{2,	2,	10,1,0,0,	14,1,2,0},	// SUBA.W (d16,An),An
/*1342*/	{4,	2,	12,1,0,0,	16,1,2,0},	// SUBA.W (d8,An,Xn),An
/*1343*/	{2,	2,	10,1,0,0,	14,1,2,0},	// SUBA.W (xxx).W,An
/*1344*/	{1,	0,	10,1,0,0,	15,1,2,0},	// SUBA.W (xxx).L,An
/*1345*/	{2,	2,	10,1,0,0,	14,1,2,0},	// SUBA.W (d16,PC),An
/*1346*/	{4,	2,	12,1,0,0,	16,1,2,0},	// SUBA.W (d8,PC,Xn),An
/*1347*/	{2,	0,	 6,0,0,0,	10,0,2,0},	// SUBA.W #<data>.W,An
/*1348*/	{2,	0,	 2,0,0,0,	 4,0,1,0},	// SUBX.B Dn,Dn
/*1349*/	{2,	1,	15,2,0,1,	18,2,1,1},	// SUBX.B -(An),-(An)
/*1350*/	{1,	2,	10,1,0,1,	13,1,1,1},	// SUB.B Dn,(An)
/*1351*/	{0,	2,	10,1,0,1,	13,1,1,1},	// SUB.B Dn,(An)+
/*1352*/	{2,	3,	11,1,0,1,	14,1,1,1},	// SUB.B Dn,-(An)
/*1353*/	{2,	3,	11,1,0,1,	16,1,2,1},	// SUB.B Dn,(d16,An)
/*1354*/	{4,	3,	13,1,0,1,	18,1,2,1},	// SUB.B Dn,(d8,An,Xn)
/*1355*/	{2,	3,	11,1,0,1,	16,1,2,1},	// SUB.B Dn,(xxx).W
/*1356*/	{1,	1,	11,1,0,1,	17,1,2,1},	// SUB.B Dn,(xxx).L
/*1357*/	{2,	0,	 2,0,0,0,	 4,0,1,0},	// SUBX.W Dn,Dn
/*1358*/	{2,	1,	15,2,0,1,	18,2,1,1},	// SUBX.W -(An),-(An)
/*1359*/	{1,	2,	10,1,0,1,	13,1,1,1},	// SUB.W Dn,(An)
/*1360*/	{0,	2,	10,1,0,1,	13,1,1,1},	// SUB.W Dn,(An)+
/*1361*/	{2,	3,	11,1,0,1,	14,1,1,1},	// SUB.W Dn,-(An)
/*1362*/	{2,	3,	11,1,0,1,	16,1,2,1},	// SUB.W Dn,(d16,An)
/*1363*/	{4,	3,	13,1,0,1,	18,1,2,1},	// SUB.W Dn,(d8,An,Xn)
/*1364*/	{2,	3,	11,1,0,1,	16,1,2,1},	// SUB.W Dn,(xxx).W
/*1365*/	{1,	1,	11,1,0,1,	17,1,2,1},	// SUB.W Dn,(xxx).L
/*1366*/	{2,	0,	 2,0,0,0,	 4,0,1,0},	// SUBX.L Dn,Dn
/*1367*/	{2,	1,	27,2,0,1,	30,2,1,1},	// SUBX.L -(An),-(An)
/*1368*/	{1,	2,	18,1,0,1,	21,1,1,1},	// SUB.L Dn,(An)
/*1369*/	{0,	2,	18,1,0,1,	21,1,1,1},	// SUB.L Dn,(An)+
/*1370*/	{2,	3,	19,1,0,1,	22,1,1,1},	// SUB.L Dn,-(An)
/*1371*/	{2,	3,	19,1,0,1,	24,1,2,1},	// SUB.L Dn,(d16,An)
/*1372*/	{4,	3,	21,1,0,1,	26,1,2,1},	// SUB.L Dn,(d8,An,Xn)
/*1373*/	{2,	3,	19,1,0,1,	24,1,2,1},	// SUB.L Dn,(xxx).W
/*1374*/	{1,	1,	19,1,0,1,	25,1,2,1},	// SUB.L Dn,(xxx).L
/*1375*/	{2,	0,	 2,0,0,0,	 4,0,1,0},	// SUBA.L Dn,An
/*1376*/	{2,	0,	 2,0,0,0,	 4,0,1,0},	// SUBA.L An,An
/*1377*/	{1,	1,	11,1,0,0,	13,1,1,0},	// SUBA.L (An),An
/*1378*/	{0,	1,	11,1,0,0,	13,1,1,0},	// SUBA.L (An)+,An
/*1379*/	{2,	2,	12,1,0,0,	14,1,1,0},	// SUBA.L -(An),An
/*1380*/	{2,	2,	12,1,0,0,	16,1,2,0},	// SUBA.L (d16,An),An
/*1381*/	{4,	2,	14,1,0,0,	18,1,2,0},	// SUBA.L (d8,An,Xn),An
/*1382*/	{2,	2,	12,1,0,0,	16,1,2,0},	// SUBA.L (xxx).W,An
/*1383*/	{1,	0,	12,1,0,0,	17,1,2,0},	// SUBA.L (xxx).L,An
/*1384*/	{2,	2,	12,1,0,0,	16,1,2,0},	// SUBA.L (d16,PC),An
/*1385*/	{4,	2,	14,1,0,0,	18,1,2,0},	// SUBA.L (d8,PC,Xn),An
/*1386*/	{4,	0,	 6,0,0,0,	10,0,2,0},	// SUBA.L #<data>.L,An
/*1387*/	{2,	0,	 2,0,0,0,	 4,0,1,0},	// CMP.B Dn,Dn
/*1388*/	{1,	1,	 7,1,0,0,	 9,1,1,0},	// CMP.B (An),Dn
/*1389*/	{0,	1,	 7,1,0,0,	 9,1,1,0},	// CMP.B (An)+,Dn
/*1390*/	{2,	2,	 8,1,0,0,	10,1,1,0},	// CMP.B -(An),Dn
/*1391*/	{2,	2,	 8,1,0,0,	12,1,2,0},	// CMP.B (d16,An),Dn
/*1392*/	{4,	2,	10,1,0,0,	14,1,2,0},	// CMP.B (d8,An,Xn),Dn
/*1393*/	{2,	2,	 8,1,0,0,	12,1,2,0},	// CMP.B (xxx).W,Dn
/*1394*/	{1,	0,	 8,1,0,0,	13,1,2,0},	// CMP.B (xxx).L,Dn
/*1395*/	{2,	2,	 8,1,0,0,	12,1,2,0},	// CMP.B (d16,PC),Dn
/*1396*/	{4,	2,	10,1,0,0,	14,1,2,0},	// CMP.B (d8,PC,Xn),Dn
/*1397*/	{2,	0,	 4,0,0,0,	 8,0,2,0},	// CMP.B #<data>.B,Dn
/*1398*/	{2,	0,	 2,0,0,0,	 4,0,1,0},	// CMP.W Dn,Dn
/*1399*/	{2,	0,	 2,0,0,0,	 4,0,1,0},	// CMP.W An,Dn
/*1400*/	{1,	1,	 7,1,0,0,	 9,1,1,0},	// CMP.W (An),Dn
/*1401*/	{0,	1,	 7,1,0,0,	 9,1,1,0},	// CMP.W (An)+,Dn
/*1402*/	{2,	2,	 8,1,0,0,	10,1,1,0},	// CMP.W -(An),Dn
/*1403*/	{2,	2,	 8,1,0,0,	12,1,2,0},	// CMP.W (d16,An),Dn
/*1404*/	{4,	2,	10,1,0,0,	14,1,2,0},	// CMP.W (d8,An,Xn),Dn
/*1405*/	{2,	2,	 8,1,0,0,	12,1,2,0},	// CMP.W (xxx).W,Dn
/*1406*/	{1,	0,	 8,1,0,0,	13,1,2,0},	// CMP.W (xxx).L,Dn
/*1407*/	{2,	2,	 8,1,0,0,	12,1,2,0},	// CMP.W (d16,PC),Dn
/*1408*/	{4,	2,	10,1,0,0,	14,1,2,0},	// CMP.W (d8,PC,Xn),Dn
/*1409*/	{2,	0,	 4,0,0,0,	 8,0,2,0},	// CMP.W #<data>.W,Dn
/*1410*/	{2,	0,	 2,0,0,0,	 4,0,1,0},	// CMP.L Dn,Dn
/*1411*/	{2,	0,	 2,0,0,0,	 4,0,1,0},	// CMP.L An,Dn
/*1412*/	{1,	1,	11,1,0,0,	13,1,1,0},	// CMP.L (An),Dn
/*1413*/	{0,	1,	11,1,0,0,	13,1,1,0},	// CMP.L (An)+,Dn
/*1414*/	{2,	2,	12,1,0,0,	14,1,1,0},	// CMP.L -(An),Dn
/*1415*/	{2,	2,	12,1,0,0,	16,1,2,0},	// CMP.L (d16,An),Dn
/*1416*/	{4,	2,	14,1,0,0,	18,1,2,0},	// CMP.L (d8,An,Xn),Dn
/*1417*/	{2,	2,	12,1,0,0,	16,1,2,0},	// CMP.L (xxx).W,Dn
/*1418*/	{1,	0,	12,1,0,0,	17,1,2,0},	// CMP.L (xxx).L,Dn
/*1419*/	{2,	2,	12,1,0,0,	16,1,2,0},	// CMP.L (d16,PC),Dn
/*1420*/	{4,	2,	14,1,0,0,	18,1,2,0},	// CMP.L (d8,PC,Xn),Dn
/*1421*/	{4,	0,	 6,0,0,0,	10,0,2,0},	// CMP.L #<data>.L,Dn
/*1422*/	{4,	0,	 4,0,0,0,	 6,0,1,0},	// CMPA.W Dn,An
/*1423*/	{4,	0,	 4,0,0,0,	 6,0,1,0},	// CMPA.W An,An
/*1424*/	{1,	1,	 9,1,0,0,	11,1,1,0},	// CMPA.W (An),An
/*1425*/	{0,	1,	 9,1,0,0,	11,1,1,0},	// CMPA.W (An)+,An
/*1426*/	{2,	2,	10,1,0,0,	12,1,1,0},	// CMPA.W -(An),An
/*1427*/	{2,	2,	10,1,0,0,	14,1,2,0},	// CMPA.W (d16,An),An
/*1428*/	{4,	2,	12,1,0,0,	16,1,2,0},	// CMPA.W (d8,An,Xn),An
/*1429*/	{2,	2,	10,1,0,0,	14,1,2,0},	// CMPA.W (xxx).W,An
/*1430*/	{1,	0,	10,1,0,0,	15,1,2,0},	// CMPA.W (xxx).L,An
/*1431*/	{2,	2,	10,1,0,0,	14,1,2,0},	// CMPA.W (d16,PC),An
/*1432*/	{4,	2,	12,1,0,0,	16,1,2,0},	// CMPA.W (d8,PC,Xn),An
/*1433*/	{2,	0,	 6,0,0,0,	10,0,2,0},	// CMPA.W #<data>.W,An
/*1434*/	{2,	0,	 2,0,0,0,	 4,0,1,0},	// EOR.B Dn,Dn
/*1435*/	{0,	0,	12,2,0,0,	14,2,1,0},	// CMPM.B (An)+,(An)+
/*1436*/	{1,	2,	10,1,0,1,	13,1,1,1},	// EOR.B Dn,(An)
/*1437*/	{0,	2,	10,1,0,1,	13,1,1,1},	// EOR.B Dn,(An)+
/*1438*/	{2,	3,	11,1,0,1,	14,1,1,1},	// EOR.B Dn,-(An)
/*1439*/	{2,	3,	11,1,0,1,	16,1,2,1},	// EOR.B Dn,(d16,An)
/*1440*/	{4,	3,	13,1,0,1,	18,1,2,1},	// EOR.B Dn,(d8,An,Xn)
/*1441*/	{2,	3,	11,1,0,1,	16,1,2,1},	// EOR.B Dn,(xxx).W
/*1442*/	{1,	1,	11,1,0,1,	17,1,2,1},	// EOR.B Dn,(xxx).L
/*1443*/	{2,	0,	 2,0,0,0,	 4,0,1,0},	// EOR.W Dn,Dn
/*1444*/	{0,	0,	12,2,0,0,	14,2,1,0},	// CMPM.W (An)+,(An)+
/*1445*/	{1,	2,	10,1,0,1,	13,1,1,1},	// EOR.W Dn,(An)
/*1446*/	{0,	2,	10,1,0,1,	13,1,1,1},	// EOR.W Dn,(An)+
/*1447*/	{2,	3,	11,1,0,1,	14,1,1,1},	// EOR.W Dn,-(An)
/*1448*/	{2,	3,	11,1,0,1,	16,1,2,1},	// EOR.W Dn,(d16,An)
/*1449*/	{4,	3,	13,1,0,1,	18,1,2,1},	// EOR.W Dn,(d8,An,Xn)
/*1450*/	{2,	3,	11,1,0,1,	16,1,2,1},	// EOR.W Dn,(xxx).W
/*1451*/	{1,	1,	11,1,0,1,	17,1,2,1},	// EOR.W Dn,(xxx).L
/*1452*/	{2,	0,	 2,0,0,0,	 4,0,1,0},	// EOR.L Dn,Dn
/*1453*/	{0,	0,	20,2,0,0,	24,2,1,0},	// CMPM.L (An)+,(An)+
/*1454*/	{1,	2,	18,1,0,1,	21,1,1,1},	// EOR.L Dn,(An)
/*1455*/	{0,	2,	18,1,0,1,	21,1,1,1},	// EOR.L Dn,(An)+
/*1456*/	{2,	3,	19,1,0,1,	22,1,1,1},	// EOR.L Dn,-(An)
/*1457*/	{2,	3,	19,1,0,1,	24,1,2,1},	// EOR.L Dn,(d16,An)
/*1458*/	{4,	3,	21,1,0,1,	26,1,2,1},	// EOR.L Dn,(d8,An,Xn)
/*1459*/	{2,	3,	19,1,0,1,	24,1,2,1},	// EOR.L Dn,(xxx).W
/*1460*/	{1,	1,	19,1,0,1,	25,1,2,1},	// EOR.L Dn,(xxx).L
/*1461*/	{4,	0,	 4,0,0,0,	 6,0,1,0},	// CMPA.L Dn,An
/*1462*/	{4,	0,	 4,0,0,0,	 6,0,1,0},	// CMPA.L An,An
/*1463*/	{1,	1,	13,1,0,0,	15,1,1,0},	// CMPA.L (An),An
/*1464*/	{0,	1,	13,1,0,0,	15,1,1,0},	// CMPA.L (An)+,An
/*1465*/	{2,	2,	14,1,0,0,	16,1,1,0},	// CMPA.L -(An),An
/*1466*/	{2,	2,	14,1,0,0,	18,1,2,0},	// CMPA.L (d16,An),An
/*1467*/	{4,	2,	16,1,0,0,	20,1,2,0},	// CMPA.L (d8,An,Xn),An
/*1468*/	{2,	2,	14,1,0,0,	18,1,2,0},	// CMPA.L (xxx).W,An
/*1469*/	{1,	0,	14,1,0,0,	19,1,2,0},	// CMPA.L (xxx).L,An
/*1470*/	{2,	2,	14,1,0,0,	18,1,2,0},	// CMPA.L (d16,PC),An
/*1471*/	{4,	2,	16,1,0,0,	20,1,2,0},	// CMPA.L (d8,PC,Xn),An
/*1472*/	{4,	0,	 8,0,0,0,	12,0,2,0},	// CMPA.L #<data>.L,An
/*1473*/	{2,	0,	 2,0,0,0,	 4,0,1,0},	// AND.B Dn,Dn
/*1474*/	{1,	1,	 7,1,0,0,	 9,1,1,0},	// AND.B (An),Dn
/*1475*/	{0,	1,	 7,1,0,0,	 9,1,1,0},	// AND.B (An)+,Dn
/*1476*/	{2,	2,	 8,1,0,0,	10,1,1,0},	// AND.B -(An),Dn
/*1477*/	{2,	2,	 8,1,0,0,	12,1,1,0},	// AND.B (d16,An),Dn
/*1478*/	{4,	2,	10,1,0,0,	14,1,2,0},	// AND.B (d8,An,Xn),Dn
/*1479*/	{2,	2,	 8,1,0,0,	12,1,2,0},	// AND.B (xxx).W,Dn
/*1480*/	{1,	0,	 8,1,0,0,	13,1,2,0},	// AND.B (xxx).L,Dn
/*1481*/	{2,	2,	 8,1,0,0,	12,1,2,0},	// AND.B (d16,PC),Dn
/*1482*/	{4,	2,	10,1,0,0,	14,1,2,0},	// AND.B (d8,PC,Xn),Dn
/*1483*/	{2,	0,	 4,0,0,0,	 8,0,2,0},	// AND.B #<data>.B,Dn
/*1484*/	{2,	0,	 2,0,0,0,	 4,0,1,0},	// AND.W Dn,Dn
/*1485*/	{1,	1,	 7,1,0,0,	 9,1,1,0},	// AND.W (An),Dn
/*1486*/	{0,	1,	 7,1,0,0,	 9,1,1,0},	// AND.W (An)+,Dn
/*1487*/	{2,	2,	 8,1,0,0,	10,1,1,0},	// AND.W -(An),Dn
/*1488*/	{2,	2,	 8,1,0,0,	12,1,1,0},	// AND.W (d16,An),Dn
/*1489*/	{4,	2,	10,1,0,0,	14,1,2,0},	// AND.W (d8,An,Xn),Dn
/*1490*/	{2,	2,	 8,1,0,0,	12,1,2,0},	// AND.W (xxx).W,Dn
/*1491*/	{1,	0,	 8,1,0,0,	13,1,2,0},	// AND.W (xxx).L,Dn
/*1492*/	{2,	2,	 8,1,0,0,	12,1,2,0},	// AND.W (d16,PC),Dn
/*1493*/	{4,	2,	10,1,0,0,	14,1,2,0},	// AND.W (d8,PC,Xn),Dn
/*1494*/	{2,	0,	 4,0,0,0,	 8,0,2,0},	// AND.W #<data>.W,Dn
/*1495*/	{2,	0,	 2,0,0,0,	 4,0,1,0},	// AND.L Dn,Dn
/*1496*/	{1,	1,	11,1,0,0,	13,1,1,0},	// AND.L (An),Dn
/*1497*/	{0,	1,	11,1,0,0,	13,1,1,0},	// AND.L (An)+,Dn
/*1498*/	{2,	2,	12,1,0,0,	14,1,1,0},	// AND.L -(An),Dn
/*1499*/	{2,	2,	12,1,0,0,	16,1,2,0},	// AND.L (d16,An),Dn
/*1500*/	{4,	2,	14,1,0,0,	18,1,2,0},	// AND.L (d8,An,Xn),Dn
/*1501*/	{2,	2,	12,1,0,0,	16,1,2,0},	// AND.L (xxx).W,Dn
/*1502*/	{1,	0,	12,1,0,0,	17,1,2,0},	// AND.L (xxx).L,Dn
/*1503*/	{2,	2,	12,1,0,0,	16,1,2,0},	// AND.L (d16,PC),Dn
/*1504*/	{4,	2,	14,1,0,0,	18,1,2,0},	// AND.L (d8,PC,Xn),Dn
/*1505*/	{4,	0,	 6,0,0,0,	10,0,2,0},	// AND.L #<data>.L,Dn
/*1506*/	{2,	0,	28,0,0,0,	30,0,1,0},	// MULU.W Dn,Dn			(Max Value)
/*1507*/	{3,	1,	33,1,0,0,	35,1,1,0},	// MULU.W (An),Dn		(Max Value)
/*1508*/	{2,	1,	33,1,0,0,	35,1,1,0},	// MULU.W (An)+,Dn		(Max Value)
/*1509*/	{4,	2,	34,1,0,0,	36,1,1,0},	// MULU.W -(An),Dn		(Max Value)
/*1510*/	{4,	1,	34,1,0,0,	38,1,2,0},	// MULU.W (d16,An),Dn		(Max Value)
/*1511*/	{6,	2,	36,1,0,0,	40,1,2,0},	// MULU.W (d8,An,Xn),Dn		(Max Value)
/*1512*/	{4,	2,	34,1,0,0,	38,1,2,0},	// MULU.W (xxx).W,Dn		(Max Value)
/*1513*/	{3,	0,	34,1,0,0,	39,1,2,0},	// MULU.W (xxx).L,Dn		(Max Value)
/*1514*/	{4,	1,	34,1,0,0,	38,1,2,0},	// MULU.W (d16,PC),Dn		(Max Value)
/*1515*/	{6,	2,	36,1,0,0,	40,1,2,0},	// MULU.W (d8,PC,Xn),Dn		(Max Value)
/*1516*/	{4,	0,	30,0,0,0,	38,0,2,0},	// MULU.W #<data>.W,Dn		(Max Value)
/*1517*/	{0,	0,	 4,0,0,0,	 6,0,1,0},	// ABCD.B Dn,Dn
/*1518*/	{2,	1,	19,2,0,1,	22,2,1,1},	// ABCD.B -(An),-(An)
/*1519*/	{1,	2,	10,1,0,1,	13,1,1,1},	// AND.B Dn,(An)
/*1520*/	{0,	2,	10,1,0,1,	13,1,1,1},	// AND.B Dn,(An)+
/*1521*/	{2,	3,	11,1,0,1,	14,1,1,1},	// AND.B Dn,-(An)
/*1522*/	{2,	3,	11,1,0,1,	16,1,2,1},	// AND.B Dn,(d16,An)
/*1523*/	{4,	3,	13,1,0,1,	18,1,2,1},	// AND.B Dn,(d8,An,Xn)
/*1524*/	{2,	3,	11,1,0,1,	16,1,2,1},	// AND.B Dn,(xxx).W
/*1525*/	{1,	1,	11,1,0,1,	17,1,2,1},	// AND.B Dn,(xxx).L
/*1526*/	{4,	0,	 4,0,0,0,	 6,0,1,0},	// EXG.L Dn,Dn
/*1527*/	{4,	0,	 4,0,0,0,	 6,0,1,0},	// EXG.L An,An
/*1528*/	{1,	2,	10,1,0,1,	13,1,1,1},	// AND.W Dn,(An)
/*1529*/	{0,	2,	10,1,0,1,	13,1,1,1},	// AND.W Dn,(An)+
/*1530*/	{2,	3,	11,1,0,1,	14,1,1,1},	// AND.W Dn,-(An)
/*1531*/	{2,	3,	11,1,0,1,	16,1,2,1},	// AND.W Dn,(d16,An)
/*1532*/	{4,	3,	13,1,0,1,	18,1,2,1},	// AND.W Dn,(d8,An,Xn)
/*1533*/	{2,	3,	11,1,0,1,	16,1,2,1},	// AND.W Dn,(xxx).W
/*1534*/	{1,	1,	11,1,0,1,	17,1,2,1},	// AND.W Dn,(xxx).L
/*1535*/	{4,	0,	 4,0,0,0,	 6,0,1,0},	// EXG.L Dn,An
/*1536*/	{1,	2,	18,1,0,1,	21,1,1,1},	// AND.L Dn,(An)
/*1537*/	{0,	2,	18,1,0,1,	21,1,1,1},	// AND.L Dn,(An)+
/*1538*/	{2,	3,	19,1,0,1,	22,1,1,1},	// AND.L Dn,-(An)
/*1539*/	{2,	3,	19,1,0,1,	24,1,2,1},	// AND.L Dn,(d16,An)
/*1540*/	{4,	3,	21,1,0,1,	26,1,2,1},	// AND.L Dn,(d8,An,Xn)
/*1541*/	{2,	3,	19,1,0,1,	24,1,2,1},	// AND.L Dn,(xxx).W
/*1542*/	{1,	1,	19,1,0,1,	25,1,2,1},	// AND.L Dn,(xxx).L
/*1543*/	{2,	0,	28,0,0,0,	30,0,1,0},	// MULS.W Dn,Dn			(Max Value)
/*1544*/	{3,	1,	33,1,0,0,	35,1,1,0},	// MULS.W (An),Dn		(Max Value)
/*1545*/	{2,	1,	33,1,0,0,	35,1,1,0},	// MULS.W (An)+,Dn		(Max Value)
/*1546*/	{4,	2,	34,1,0,0,	36,1,1,0},	// MULS.W -(An),Dn		(Max Value)
/*1547*/	{4,	1,	34,1,0,0,	38,1,2,0},	// MULS.W (d16,An),Dn		(Max Value)
/*1548*/	{6,	2,	36,1,0,0,	40,1,2,0},	// MULS.W (d8,An,Xn),Dn		(Max Value)
/*1549*/	{4,	2,	34,1,0,0,	38,1,2,0},	// MULS.W (xxx).W,Dn		(Max Value)
/*1550*/	{3,	0,	34,1,0,0,	39,1,2,0},	// MULS.W (xxx).L,Dn		(Max Value)
/*1551*/	{4,	1,	34,1,0,0,	38,1,2,0},	// MULS.W (d16,PC),Dn		(Max Value)
/*1552*/	{6,	2,	36,1,0,0,	40,1,2,0},	// MULS.W (d8,PC,Xn),Dn		(Max Value)
/*1553*/	{4,	0,	30,0,0,0,	38,0,2,0},	// MULS.W #<data>.W,Dn		(Max Value)
/*1554*/	{2,	0,	 2,0,0,0,	 4,0,1,0},	// ADD.B Dn,Dn
/*1555*/	{1,	1,	 7,1,0,0,	 9,1,1,0},	// ADD.B (An),Dn
/*1556*/	{0,	1,	 7,1,0,0,	 9,1,1,0},	// ADD.B (An)+,Dn
/*1557*/	{2,	2,	 8,1,0,0,	10,1,1,0},	// ADD.B -(An),Dn
/*1558*/	{2,	2,	 8,1,0,0,	12,1,1,0},	// ADD.B (d16,An),Dn
/*1559*/	{4,	2,	10,1,0,0,	14,1,2,0},	// ADD.B (d8,An,Xn),Dn
/*1560*/	{2,	2,	 8,1,0,0,	12,1,2,0},	// ADD.B (xxx).W,Dn
/*1561*/	{1,	0,	 8,1,0,0,	13,1,2,0},	// ADD.B (xxx).L,Dn
/*1562*/	{2,	2,	 8,1,0,0,	12,1,2,0},	// ADD.B (d16,PC),Dn
/*1563*/	{4,	2,	10,1,0,0,	14,1,2,0},	// ADD.B (d8,PC,Xn),Dn
/*1564*/	{2,	0,	 4,0,0,0,	 8,0,2,0},	// ADD.B #<data>.B,Dn
/*1565*/	{2,	0,	 2,0,0,0,	 4,0,1,0},	// ADD.W Dn,Dn
/*1566*/	{2,	0,	 2,0,0,0,	 4,0,1,0},	// ADD.W An,Dn
/*1567*/	{1,	1,	 7,1,0,0,	 9,1,1,0},	// ADD.W (An),Dn
/*1568*/	{0,	1,	 7,1,0,0,	 9,1,1,0},	// ADD.W (An)+,Dn
/*1569*/	{2,	2,	 8,1,0,0,	10,1,1,0},	// ADD.W -(An),Dn
/*1570*/	{2,	2,	 8,1,0,0,	12,1,1,0},	// ADD.W (d16,An),Dn
/*1571*/	{4,	2,	10,1,0,0,	14,1,2,0},	// ADD.W (d8,An,Xn),Dn
/*1572*/	{2,	2,	 8,1,0,0,	12,1,2,0},	// ADD.W (xxx).W,Dn
/*1573*/	{1,	0,	 8,1,0,0,	13,1,2,0},	// ADD.W (xxx).L,Dn
/*1574*/	{2,	2,	 8,1,0,0,	12,1,2,0},	// ADD.W (d16,PC),Dn
/*1575*/	{4,	2,	10,1,0,0,	14,1,2,0},	// ADD.W (d8,PC,Xn),Dn
/*1576*/	{2,	0,	 4,0,0,0,	 8,0,2,0},	// ADD.W #<data>.W,Dn
/*1577*/	{2,	0,	 2,0,0,0,	 4,0,1,0},	// ADD.L Dn,Dn
/*1578*/	{2,	0,	 2,0,0,0,	 4,0,1,0},	// ADD.L An,Dn
/*1579*/	{1,	1,	11,1,0,0,	13,1,1,0},	// ADD.L (An),Dn
/*1580*/	{0,	1,	11,1,0,0,	13,1,1,0},	// ADD.L (An)+,Dn
/*1581*/	{2,	2,	12,1,0,0,	14,1,1,0},	// ADD.L -(An),Dn
/*1582*/	{2,	2,	12,1,0,0,	16,1,2,0},	// ADD.L (d16,An),Dn
/*1583*/	{4,	2,	14,1,0,0,	18,1,2,0},	// ADD.L (d8,An,Xn),Dn
/*1584*/	{2,	2,	12,1,0,0,	16,1,2,0},	// ADD.L (xxx).W,Dn
/*1585*/	{1,	0,	12,1,0,0,	17,1,2,0},	// ADD.L (xxx).L,Dn
/*1586*/	{2,	2,	12,1,0,0,	16,1,2,0},	// ADD.L (d16,PC),Dn
/*1587*/	{4,	2,	14,1,0,0,	18,1,2,0},	// ADD.L (d8,PC,Xn),Dn
/*1588*/	{4,	0,	 6,0,0,0,	10,0,2,0},	// ADD.L #<data>.L,Dn
/*1589*/	{4,	0,	 4,0,0,0,	 6,0,1,0},	// ADDA.W Dn,An
/*1590*/	{4,	0,	 4,0,0,0,	 6,0,1,0},	// ADDA.W An,An
/*1591*/	{1,	1,	 9,1,0,0,	11,1,1,0},	// ADDA.W (An),An
/*1592*/	{0,	1,	 9,1,0,0,	11,1,1,0},	// ADDA.W (An)+,An
/*1593*/	{2,	2,	10,1,0,0,	12,1,1,0},	// ADDA.W -(An),An
/*1594*/	{2,	2,	10,1,0,0,	14,1,2,0},	// ADDA.W (d16,An),An
/*1595*/	{4,	2,	12,1,0,0,	16,1,2,0},	// ADDA.W (d8,An,Xn),An
/*1596*/	{2,	2,	10,1,0,0,	14,1,2,0},	// ADDA.W (xxx).W,An
/*1597*/	{1,	0,	10,1,0,0,	15,1,2,0},	// ADDA.W (xxx).L,An
/*1598*/	{2,	2,	10,1,0,0,	14,1,2,0},	// ADDA.W (d16,PC),An
/*1599*/	{4,	2,	12,1,0,0,	16,1,2,0},	// ADDA.W (d8,PC,Xn),An
/*1600*/	{2,	0,	 6,0,0,0,	10,0,2,0},	// ADDA.W #<data>.W,An
/*1601*/	{2,	0,	 2,0,0,0,	 4,0,1,0},	// ADDX.B Dn,Dn
/*1602*/	{2,	1,	15,2,0,1,	18,2,1,1},	// ADDX.B -(An),-(An)
/*1603*/	{1,	2,	10,1,0,1,	13,1,1,1},	// ADD.B Dn,(An)
/*1604*/	{0,	2,	10,1,0,1,	13,1,1,1},	// ADD.B Dn,(An)+
/*1605*/	{2,	3,	11,1,0,1,	14,1,1,1},	// ADD.B Dn,-(An)
/*1606*/	{2,	3,	11,1,0,1,	16,1,2,1},	// ADD.B Dn,(d16,An)
/*1607*/	{4,	3,	13,1,0,1,	18,1,2,1},	// ADD.B Dn,(d8,An,Xn)
/*1608*/	{2,	3,	11,1,0,1,	16,1,2,1},	// ADD.B Dn,(xxx).W
/*1609*/	{1,	1,	11,1,0,1,	17,1,2,1},	// ADD.B Dn,(xxx).L
/*1610*/	{2,	0,	 2,0,0,0,	 4,0,1,0},	// ADDX.W Dn,Dn
/*1611*/	{2,	1,	15,2,0,1,	18,2,1,1},	// ADDX.W -(An),-(An)
/*1612*/	{1,	2,	10,1,0,1,	13,1,1,1},	// ADD.W Dn,(An)
/*1613*/	{0,	2,	10,1,0,1,	13,1,1,1},	// ADD.W Dn,(An)+
/*1614*/	{2,	3,	11,1,0,1,	14,1,1,1},	// ADD.W Dn,-(An)
/*1615*/	{2,	3,	11,1,0,1,	16,1,2,1},	// ADD.W Dn,(d16,An)
/*1616*/	{4,	3,	13,1,0,1,	18,1,2,1},	// ADD.W Dn,(d8,An,Xn)
/*1617*/	{2,	3,	11,1,0,1,	16,1,2,1},	// ADD.W Dn,(xxx).W
/*1618*/	{1,	1,	11,1,0,1,	17,1,2,1},	// ADD.W Dn,(xxx).L
/*1619*/	{2,	0,	 2,0,0,0,	 4,0,1,0},	// ADDX.L Dn,Dn
/*1620*/	{2,	1,	27,2,0,1,	30,2,1,1},	// ADDX.L -(An),-(An)
/*1621*/	{1,	2,	18,1,0,1,	21,1,1,1},	// ADD.L Dn,(An)
/*1622*/	{0,	2,	18,1,0,1,	21,1,1,1},	// ADD.L Dn,(An)+
/*1623*/	{2,	3,	19,1,0,1,	22,1,1,1},	// ADD.L Dn,-(An)
/*1624*/	{2,	3,	19,1,0,1,	24,1,2,1},	// ADD.L Dn,(d16,An)
/*1625*/	{4,	3,	21,1,0,1,	26,1,2,1},	// ADD.L Dn,(d8,An,Xn)
/*1626*/	{2,	3,	19,1,0,1,	24,1,2,1},	// ADD.L Dn,(xxx).W
/*1627*/	{1,	1,	19,1,0,1,	25,1,2,1},	// ADD.L Dn,(xxx).L
/*1628*/	{2,	0,	 2,0,0,0,	 4,0,1,0},	// ADDA.L Dn,An
/*1629*/	{2,	0,	 2,0,0,0,	 4,0,1,0},	// ADDA.L An,An
/*1630*/	{1,	1,	11,1,0,0,	13,1,1,0},	// ADDA.L (An),An
/*1631*/	{0,	1,	11,1,0,0,	13,1,1,0},	// ADDA.L (An)+,An
/*1632*/	{2,	2,	12,1,0,0,	14,1,1,0},	// ADDA.L -(An),An
/*1633*/	{2,	2,	12,1,0,0,	16,1,2,0},	// ADDA.L (d16,An),An
/*1634*/	{4,	2,	14,1,0,0,	18,1,2,0},	// ADDA.L (d8,An,Xn),An
/*1635*/	{2,	2,	12,1,0,0,	16,1,2,0},	// ADDA.L (xxx).W,An
/*1636*/	{1,	0,	12,1,0,0,	17,1,2,0},	// ADDA.L (xxx).L,An
/*1637*/	{2,	2,	12,1,0,0,	16,1,2,0},	// ADDA.L (d16,PC),An
/*1638*/	{4,	2,	14,1,0,0,	18,1,2,0},	// ADDA.L (d8,PC,Xn),An
/*1639*/	{4,	0,	 6,0,0,0,	10,0,2,0},	// ADDA.L #<data>.L,An
/*1640*/	{4,	0,	 4,0,0,0,	 6,0,1,0},	// ASRQ.B #<data>,Dn
/*1641*/	{4,	0,	 4,0,0,0,	 6,0,1,0},	// LSRQ.B #<data>,Dn
/*1642*/	{4,	0,	 4,0,0,0,	 6,0,1,0},	// ROXRQ.B #<data>,Dn	(value guessed (not in motorola 68030UM doc))
/*1643*/	{4,	0,	 6,0,0,0,	 8,0,1,0},	// RORQ.B #<data>,Dn
/*1644*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// ASR.B Dn,Dn		(See ASR table below)
/*1645*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// LSR.B Dn,Dn		(See LSD table below)
/*1646*/	{10,	0,	12,0,0,0,	14,0,1,0},	// ROXR.B Dn,Dn
/*1647*/	{6,	0,	 8,0,0,0,	10,0,1,0},	// ROR.B Dn,Dn
/*1648*/	{4,	0,	 4,0,0,0,	 6,0,1,0},	// ASRQ.W #<data>,Dn
/*1649*/	{4,	0,	 4,0,0,0,	 6,0,1,0},	// LSRQ.W #<data>,Dn
/*1650*/	{4,	0,	 4,0,0,0,	 6,0,1,0},	// ROXRQ.W #<data>,Dn	(value guessed (not in motorola 68030UM doc))
/*1651*/	{4,	0,	 6,0,0,0,	 8,0,1,0},	// RORQ.W #<data>,Dn
/*1652*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// ASR.W Dn,Dn		(See ASR table below)
/*1653*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// LSR.W Dn,Dn		(See LSD table below)
/*1654*/	{10,	0,	12,0,0,0,	14,0,1,0},	// ROXR.W Dn,Dn
/*1655*/	{6,	0,	 8,0,0,0,	10,0,1,0},	// ROR.W Dn,Dn
/*1656*/	{4,	0,	 4,0,0,0,	 6,0,1,0},	// ASRQ.L #<data>,Dn
/*1657*/	{4,	0,	 4,0,0,0,	 6,0,1,0},	// LSRQ.L #<data>,Dn
/*1658*/	{4,	0,	 4,0,0,0,	 6,0,1,0},	// ROXRQ.L #<data>,Dn	(value guessed (not in motorola 68030UM doc))
/*1659*/	{4,	0,	 6,0,0,0,	 8,0,1,0},	// RORQ.L #<data>,Dn
/*1660*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// ASR.L Dn,Dn		(See ASR table below)
/*1661*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// LSR.L Dn,Dn		(See LSD table below)
/*1662*/	{10,	0,	12,0,0,0,	14,0,1,0},	// ROXR.L Dn,Dn
/*1663*/	{6,	0,	 8,0,0,0,	10,0,1,0},	// ROR.L Dn,Dn
/*1664*/	{1,	1,	11,1,0,1,	13,1,1,1},	// ASRW.W (An)
/*1665*/	{0,	1,	11,1,0,1,	13,1,1,1},	// ASRW.W (An)+
/*1666*/	{2,	2,	12,1,0,1,	14,1,1,1},	// ASRW.W -(An)
/*1667*/	{2,	2,	12,1,0,1,	16,1,2,1},	// ASRW.W (d16,An)
/*1668*/	{4,	2,	14,1,0,1,	18,1,2,1},	// ASRW.W (d8,An,Xn)
/*1669*/	{2,	2,	12,1,0,1,	16,1,2,1},	// ASRW.W (xxx).W
/*1670*/	{1,	0,	12,1,0,1,	17,1,2,1},	// ASRW.W (xxx).L
/*1671*/	{2,	0,	 6,0,0,0,	 8,0,1,0},	// ASLQ.B #<data>,Dn
/*1672*/	{4,	0,	 4,0,0,0,	 6,0,1,0},	// LSLQ.B #<data>,Dn
/*1673*/	{4,	0,	 4,0,0,0,	 6,0,1,0},	// ROXLQ.B #<data>,Dn	(value guessed (not in motorola 68030UM doc))
/*1674*/	{4,	0,	 6,0,0,0,	 8,0,1,0},	// ROLQ.B #<data>,Dn
/*1675*/	{4,	0,	 8,0,0,0,	10,0,1,0},	// ASL.B Dn,Dn
/*1676*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// LSL.B Dn,Dn		(See LSD table below)
/*1677*/	{10,	0,	12,0,0,0,	14,0,1,0},	// ROXL.B Dn,Dn
/*1678*/	{6,	0,	 8,0,0,0,	10,0,1,0},	// ROL.B Dn,Dn
/*1679*/	{2,	0,	 6,0,0,0,	 8,0,1,0},	// ASLQ.W #<data>,Dn
/*1680*/	{4,	0,	 4,0,0,0,	 6,0,1,0},	// LSLQ.W #<data>,Dn
/*1681*/	{4,	0,	 4,0,0,0,	 6,0,1,0},	// ROXLQ.W #<data>,Dn	(value guessed (not in motorola 68030UM doc))
/*1682*/	{4,	0,	 6,0,0,0,	 8,0,1,0},	// ROLQ.W #<data>,Dn
/*1683*/	{4,	0,	 8,0,0,0,	10,0,1,0},	// ASL.W Dn,Dn
/*1684*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// LSL.W Dn,Dn		(See LSD table below)
/*1685*/	{10,	0,	12,0,0,0,	14,0,1,0},	// ROXL.W Dn,Dn
/*1686*/	{6,	0,	 8,0,0,0,	10,0,1,0},	// ROL.W Dn,Dn
/*1687*/	{2,	0,	 6,0,0,0,	 8,0,1,0},	// ASLQ.L #<data>,Dn
/*1688*/	{4,	0,	 4,0,0,0,	 6,0,1,0},	// LSLQ.L #<data>,Dn
/*1689*/	{4,	0,	 4,0,0,0,	 6,0,1,0},	// ROXLQ.L #<data>,Dn	(value guessed (not in motorola 68030UM doc))
/*1690*/	{4,	0,	 6,0,0,0,	 8,0,1,0},	// ROLQ.L #<data>,Dn
/*1691*/	{4,	0,	 8,0,0,0,	10,0,1,0},	// ASL.L Dn,Dn
/*1692*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// LSL.L Dn,Dn		(See LSD table below)
/*1693*/	{10,	0,	12,0,0,0,	14,0,1,0},	// ROXL.L Dn,Dn
/*1694*/	{6,	0,	 8,0,0,0,	10,0,1,0},	// ROL.L Dn,Dn
/*1695*/	{1,	1,	13,1,0,1,	15,1,1,1},	// ASLW.W (An)
/*1696*/	{0,	1,	13,1,0,1,	15,1,1,1},	// ASLW.W (An)+
/*1697*/	{2,	2,	14,1,0,1,	16,1,1,1},	// ASLW.W -(An)
/*1698*/	{2,	2,	14,1,0,1,	18,1,2,1},	// ASLW.W (d16,An)
/*1699*/	{4,	2,	16,1,0,1,	20,1,2,1},	// ASLW.W (d8,An,Xn)
/*1700*/	{2,	2,	14,1,0,1,	18,1,2,1},	// ASLW.W (xxx).W
/*1701*/	{1,	0,	14,1,0,1,	19,1,2,1},	// ASLW.W (xxx).L
/*1702*/	{1,	1,	11,1,0,1,	13,1,1,1},	// LSRW.W (An)
/*1703*/	{0,	1,	11,1,0,1,	13,1,1,1},	// LSRW.W (An)+
/*1704*/	{2,	2,	12,1,0,1,	14,1,1,1},	// LSRW.W -(An)
/*1705*/	{2,	2,	12,1,0,1,	16,1,2,1},	// LSRW.W (d16,An)
/*1706*/	{4,	2,	14,1,0,1,	18,1,2,1},	// LSRW.W (d8,An,Xn)
/*1707*/	{2,	2,	12,1,0,1,	16,1,2,1},	// LSRW.W (xxx).W
/*1708*/	{1,	0,	12,1,0,1,	17,1,2,1},	// LSRW.W (xxx).L
/*1709*/	{1,	1,	11,1,0,1,	13,1,1,1},	// LSLW.W (An)
/*1710*/	{0,	1,	11,1,0,1,	13,1,1,1},	// LSLW.W (An)+
/*1711*/	{2,	2,	12,1,0,1,	14,1,1,1},	// LSLW.W -(An)
/*1712*/	{2,	2,	12,1,0,1,	16,1,2,1},	// LSLW.W (d16,An)
/*1713*/	{4,	2,	14,1,0,1,	18,1,2,1},	// LSLW.W (d8,An,Xn)
/*1714*/	{2,	2,	12,1,0,1,	16,1,2,1},	// LSLW.W (xxx).W
/*1715*/	{1,	0,	12,1,0,1,	17,1,2,1},	// LSLW.W (xxx).L
/*1716*/	{1,	1,	 9,1,0,0,	11,1,1,0},	// ROXRW.W (An)
/*1717*/	{0,	1,	 9,1,0,0,	11,1,1,0},	// ROXRW.W (An)+
/*1718*/	{2,	2,	10,1,0,0,	12,1,1,0},	// ROXRW.W -(An)
/*1719*/	{2,	2,	10,1,0,0,	14,1,2,0},	// ROXRW.W (d16,An)
/*1720*/	{4,	2,	12,1,0,0,	16,1,2,0},	// ROXRW.W (d8,An,Xn)
/*1721*/	{2,	2,	10,1,0,0,	14,1,2,0},	// ROXRW.W (xxx).W
/*1722*/	{1,	0,	10,1,0,0,	15,1,2,0},	// ROXRW.W (xxx).L
/*1723*/	{1,	1,	 9,1,0,0,	11,1,1,0},	// ROXLW.W (An)
/*1724*/	{0,	1,	 9,1,0,0,	11,1,1,0},	// ROXLW.W (An)+
/*1725*/	{2,	2,	10,1,0,0,	12,1,1,0},	// ROXLW.W -(An)
/*1726*/	{2,	2,	10,1,0,0,	14,1,2,0},	// ROXLW.W (d16,An)
/*1727*/	{4,	2,	12,1,0,0,	16,1,2,0},	// ROXLW.W (d8,An,Xn)
/*1728*/	{2,	2,	10,1,0,0,	14,1,2,0},	// ROXLW.W (xxx).W
/*1729*/	{1,	0,	10,1,0,0,	15,1,2,0},	// ROXLW.W (xxx).L
/*1730*/	{1,	1,	13,1,0,1,	15,1,1,1},	// RORW.W (An)
/*1731*/	{0,	1,	13,1,0,1,	15,1,1,1},	// RORW.W (An)+
/*1732*/	{2,	2,	14,1,0,1,	16,1,1,1},	// RORW.W -(An)
/*1733*/	{2,	2,	14,1,0,1,	18,1,2,1},	// RORW.W (d16,An)
/*1734*/	{4,	2,	16,1,0,1,	20,1,2,1},	// RORW.W (d8,An,Xn)
/*1735*/	{2,	2,	14,1,0,1,	18,1,2,1},	// RORW.W (xxx).W
/*1736*/	{1,	0,	14,1,0,1,	19,1,2,1},	// RORW.W (xxx).L
/*1737*/	{1,	1,	13,1,0,1,	15,1,1,1},	// ROLW.W (An)
/*1738*/	{0,	1,	13,1,0,1,	15,1,1,1},	// ROLW.W (An)+
/*1739*/	{2,	2,	14,1,0,1,	16,1,1,1},	// ROLW.W -(An)
/*1740*/	{2,	2,	14,1,0,1,	18,1,2,1},	// ROLW.W (d16,An)
/*1741*/	{4,	2,	16,1,0,1,	20,1,2,1},	// ROLW.W (d8,An,Xn)
/*1742*/	{2,	2,	14,1,0,1,	18,1,2,1},	// ROLW.W (xxx).W
/*1743*/	{1,	0,	14,1,0,1,	19,1,2,1},	// ROLW.W (xxx).L
/*1744*/	{8,	0,	 8,0,0,0,	10,0,1,0},	// BFTST.L #<data>.W,Dn
/*1745*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// BFTST.L #<data>.W,(An)		(See BFTST table below)
/*1746*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// BFTST.L #<data>.W,(d16,An)		(See BFTST table below)
/*1747*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// BFTST.L #<data>.W,(d8,An,Xn)		(See BFTST table below)
/*1748*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// BFTST.L #<data>.W,(xxx).W		(See BFTST table below)
/*1749*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// BFTST.L #<data>.W,(xxx).L		(See BFTST table below)
/*1750*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// BFTST.L #<data>.W,(d16,PC)		(See BFTST table below)
/*1751*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// BFTST.L #<data>.W,(d8,PC,Xn)		(See BFTST table below)
/*1752*/	{10,	0,	10,0,0,0,	12,0,1,0},	// BFEXTU.L #<data>.W,Dn
/*1753*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// BFEXTU.L #<data>.W,(An)		(See BFEXTU table below)
/*1754*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// BFEXTU.L #<data>.W,(d16,An)		(See BFEXTU table below)
/*1755*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// BFEXTU.L #<data>.W,(d8,An,Xn)	(See BFEXTU table below)
/*1756*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// BFEXTU.L #<data>.W,(xxx).W		(See BFEXTU table below)
/*1757*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// BFEXTU.L #<data>.W,(xxx).L		(See BFEXTU table below)
/*1758*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// BFEXTU.L #<data>.W,(d16,PC)		(See BFEXTU table below)
/*1759*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// BFEXTU.L #<data>.W,(d8,PC,Xn)	(See BFEXTU table below)
/*1760*/	{14,	0,	14,0,0,0,	16,0,1,0},	// BFCHG.L #<data>.W,Dn
/*1761*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// BFCHG.L #<data>.W,(An)		(See BFCHG table below)
/*1762*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// BFCHG.L #<data>.W,(d16,An)		(See BFCHG table below)
/*1763*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// BFCHG.L #<data>.W,(d8,An,Xn)		(See BFCHG table below)
/*1764*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// BFCHG.L #<data>.W,(xxx).W		(See BFCHG table below)
/*1765*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// BFCHG.L #<data>.W,(xxx).L		(See BFCHG table below)
/*1766*/	{10,	0,	10,0,0,0,	12,0,1,0},	// BFEXTS.L #<data>.W,Dn
/*1767*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// BFEXTS.L #<data>.W,(An)		(See BFEXTS table below)
/*1768*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// BFEXTS.L #<data>.W,(d16,An)		(See BFEXTS table below)
/*1769*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// BFEXTS.L #<data>.W,(d8,An,Xn)	(See BFEXTS table below)
/*1770*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// BFEXTS.L #<data>.W,(xxx).W		(See BFEXTS table below)
/*1771*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// BFEXTS.L #<data>.W,(xxx).L		(See BFEXTS table below)
/*1772*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// BFEXTS.L #<data>.W,(d16,PC)		(See BFEXTS table below)
/*1773*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// BFEXTS.L #<data>.W,(d8,PC,Xn)	(See BFEXTS table below)
/*1774*/	{14,	0,	14,0,0,0,	16,0,1,0},	// BFCLR.L #<data>.W,Dn
/*1775*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// BFCLR.L #<data>.W,(An)		(See BFCLR table below)
/*1776*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// BFCLR.L #<data>.W,(d16,An)		(See BFEXTS table below)
/*1777*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// BFCLR.L #<data>.W,(d8,An,Xn)		(See BFEXTS table below)
/*1778*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// BFCLR.L #<data>.W,(xxx).W		(See BFEXTS table below)
/*1779*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// BFCLR.L #<data>.W,(xxx).L		(See BFEXTS table below)
/*1780*/	{20,	0,	20,0,0,0,	22,0,1,0},	// BFFFO.L #<data>.W,Dn
/*1781*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// BFFFO.L #<data>.W,(An)		(See BFFFO table below)
/*1782*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// BFFFO.L #<data>.W,(d16,An)		(See BFFFO table below)
/*1783*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// BFFFO.L #<data>.W,(d8,An,Xn)		(See BFFFO table below)
/*1784*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// BFFFO.L #<data>.W,(xxx).W		(See BFFFO table below)
/*1785*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// BFFFO.L #<data>.W,(xxx).L		(See BFFFO table below)
/*1786*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// BFFFO.L #<data>.W,(d16,PC)		(See BFFFO table below)
/*1787*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// BFFFO.L #<data>.W,(d8,PC,Xn)		(See BFFFO table below)
/*1788*/	{14,	0,	14,0,0,0,	16,0,1,0},	// BFSET.L #<data>.W,Dn
/*1789*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// BFSET.L #<data>.W,(An)		(See BFSET table below)
/*1790*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// BFSET.L #<data>.W,(d16,An)		(See BFSET table below)
/*1791*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// BFSET.L #<data>.W,(d8,An,Xn)		(See BFSET table below)
/*1792*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// BFSET.L #<data>.W,(xxx).W		(See BFSET table below)
/*1793*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// BFSET.L #<data>.W,(xxx).L		(See BFSET table below)
/*1794*/	{12,	0,	12,0,0,0,	14,0,1,0},	// BFINS.L #<data>.W,Dn
/*1795*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// BFINS.L #<data>.W,(An)		(See BFINS table below)
/*1796*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// BFINS.L #<data>.W,(d16,An)		(See BFINS table below)
/*1797*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// BFINS.L #<data>.W,(d8,An,Xn)		(See BFINS table below)
/*1798*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// BFINS.L #<data>.W,(xxx).W		(See BFINS table below)
/*1799*/	{0,	0,	 0,0,0,0,	 0,0,0,0},	// BFINS.L #<data>.W,(xxx).L		(See BFINS table below)
/*1800*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// MMUOP030.L Dn,#<data>.W
/*1801*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// MMUOP030.L An,#<data>.W
/*1802*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// MMUOP030.L (An),#<data>.W
/*1803*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// MMUOP030.L (d16,An),#<data>.W
/*1804*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// MMUOP030.L (d8,An,Xn),#<data>.W
/*1805*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// MMUOP030.L (xxx).W,#<data>.W
/*1806*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// MMUOP030.L (xxx).L,#<data>.W
/*1807*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// FPP.L #<data>.W,Dn
/*1808*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// FPP.L #<data>.W,An
/*1809*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// FPP.L #<data>.W,(An)
/*1810*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// FPP.L #<data>.W,(An)+
/*1811*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// FPP.L #<data>.W,-(An)
/*1812*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// FPP.L #<data>.W,(d16,An)
/*1813*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// FPP.L #<data>.W,(d8,An,Xn)
/*1814*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// FPP.L #<data>.W,(xxx).W
/*1815*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// FPP.L #<data>.W,(xxx).L
/*1816*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// FPP.L #<data>.W,(d16,PC)
/*1817*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// FPP.L #<data>.W,(d8,PC,Xn)
/*1818*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// FPP.L #<data>.W,#<data>.L
/*1819*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// FScc.L #<data>.W,Dn
/*1820*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// FDBcc.L #<data>.W,Dn
/*1821*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// FScc.L #<data>.W,(An)
/*1822*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// FScc.L #<data>.W,(An)+
/*1823*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// FScc.L #<data>.W,-(An)
/*1824*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// FScc.L #<data>.W,(d16,An)
/*1825*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// FScc.L #<data>.W,(d8,An,Xn)
/*1826*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// FScc.L #<data>.W,(xxx).W
/*1827*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// FScc.L #<data>.W,(xxx).L
/*1828*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// FTRAPcc.L #<data>.W
/*1829*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// FTRAPcc.L #<data>.L
/*1830*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// FTRAPcc.L 
/*1831*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// FBccQ.L #<data>,#<data>.W
/*1832*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// FBccQ.L #<data>,#<data>.L
/*1833*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// FSAVE.L (An)
/*1834*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// FSAVE.L -(An)
/*1835*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// FSAVE.L (d16,An)
/*1836*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// FSAVE.L (d8,An,Xn)
/*1837*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// FSAVE.L (xxx).W
/*1838*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// FSAVE.L (xxx).L
/*1839*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// FRESTORE.L (An)
/*1840*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// FRESTORE.L (An)+
/*1841*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// FRESTORE.L (d16,An)
/*1842*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// FRESTORE.L (d8,An,Xn)
/*1843*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// FRESTORE.L (xxx).W
/*1844*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// FRESTORE.L (xxx).L
/*1845*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// FRESTORE.L (d16,PC)
/*1846*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// FRESTORE.L (d8,PC,Xn)
/*1847*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// CINVLQ.L #<data>,An
/*1848*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// CINVPQ.L #<data>,An
/*1849*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// CINVAQ.L #<data>
/*1850*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// CINVAQ.L #<data>
/*1851*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// CINVAQ.L #<data>
/*1852*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// CINVAQ.L #<data>
/*1853*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// CINVAQ.L #<data>
/*1854*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// CINVAQ.L #<data>
/*1855*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// CINVAQ.L #<data>
/*1856*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// CINVAQ.L #<data>
/*1857*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// CPUSHLQ.L #<data>,An
/*1858*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// CPUSHPQ.L #<data>,An
/*1859*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// CPUSHAQ.L #<data>
/*1860*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// CPUSHAQ.L #<data>
/*1861*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// CPUSHAQ.L #<data>
/*1862*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// CPUSHAQ.L #<data>
/*1863*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// CPUSHAQ.L #<data>
/*1864*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// CPUSHAQ.L #<data>
/*1865*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// CPUSHAQ.L #<data>
/*1866*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// CPUSHAQ.L #<data>
/*1867*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// PFLUSHN.L (An)
/*1868*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// PFLUSH.L (An)
/*1869*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// PFLUSHAN.L (An)
/*1870*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// PFLUSHA.L (An)
/*1871*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// PTESTR.L (An)
/*1872*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// PTESTW.L (An)
/*1873*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// PLPAR.L (An)
/*1874*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// PLPAW.L (An)
/*1875*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// MOVE16.L (An)+,(xxx).L
/*1876*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// MOVE16.L (xxx).L,(An)+
/*1877*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// MOVE16.L (An),(xxx).L
/*1878*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// MOVE16.L (xxx).L,(An)
/*1879*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// MOVE16.L (An)+,(An)+
/*1880*/	{6,	0,	 20,0,1,0,	22,0,1,0},	// LPSTOP.L #<data>.W
/*1881*/	{0,	0,	 6,0,0,0,	 8,0,1,0},	// NBCD.B Dn	(value guessed (not in motorola 68030UM doc))
/*1882*/	{1,	1,	13,1,0,1,	15,1,1,1},	// NBCD.B (An)	(value guessed (not in motorola 68030UM doc))
/*1883*/	{0,	1,	13,1,0,1,	15,1,1,1},	// NBCD.B (An)+	(value guessed (not in motorola 68030UM doc))
/*1884*/	{2,	2,	14,1,0,1,	16,1,1,1},	// NBCD.B -(An)	(value guessed (not in motorola 68030UM doc))
/*1885*/	{2,	2,	14,1,0,1,	18,1,2,1},	// NBCD.B (d16,An)	(value guessed (not in motorola 68030UM doc))
/*1886*/	{4,	2,	16,1,0,1,	20,1,2,1},	// NBCD.B (d8,An,Xn)	(value guessed (not in motorola 68030UM doc))
/*1887*/	{2,	2,	14,1,0,1,	18,1,2,1},	// NBCD.B (xxx).W	(value guessed (not in motorola 68030UM doc))
/*1888*/	{1,	0,	14,1,0,1,	19,1,2,1},	// NBCD.B (xxx).L	(value guessed (not in motorola 68030UM doc))
/*1889*/	{0,	0,	 4,0,0,0,	 6,0,1,0},	// SBCD.B Dn,Dn
/*1890*/	{2,	1,	19,2,0,1,	22,2,1,1},	// SBCD.B -(An),-(An)
/*1891*/	{0,	0,	 4,0,0,0,	 6,0,1,0},	// ABCD.B Dn,Dn
/*1892*/	{2,	1,	19,2,0,1,	22,2,1,1}	// ABCD.B -(An),-(An)
};


/** 
  Cycles table for CHK2.BW instruction. 
  First column is for no exception case, 2nd column is for the exception taken case
  */
static const struct falcon_cycles_t table_falcon_cycles_CHK2_BW [] = {
	{3,	1,	25,2,0,0,	30,2,2,0}, {3,	1,	57,3,0,4,	68,3,4,4},	// CHK2.BW #<data>.W,(An)
	{4,	0,	26,2,0,0,	31,2,2,0}, {4,	0,	58,3,0,4,	69,3,4,4},	// CHK2.BW #<data>.W,(d16,An)
	{8,	2,	30,2,0,0,	36,2,3,0}, {8,	2,	62,3,0,4,	74,3,5,4},	// CHK2.BW #<data>.W,(d8,An,Xn)
	{6,	2,	28,2,0,0,	32,2,2,0}, {6,	2,	60,3,0,4,	70,3,4,4},	// CHK2.BW #<data>.W,(xxx).W
	{5,	0,	28,2,0,0,	35,2,3,0}, {5,	0,	60,3,0,4,	73,3,5,4},	// CHK2.BW #<data>.W,(xxx).L
	{4,	0,	26,2,0,0,	31,2,2,0}, {4,	0,	58,3,0,4,	69,3,4,4},	// CHK2.BW #<data>.W,(d16,PC)
	{8,	2,	30,2,0,0,	36,2,3,0}, {8,	2,	62,3,0,4,	74,3,5,4}	// CHK2.BW #<data>.W,(d8,PC,Xn)
};

/** 
  Cycles table for CHK2.L instruction. 
  First column is for no exception case, 2nd column is for the exception taken case
  */
static const struct falcon_cycles_t table_falcon_cycles_CHK2_L [] = {
	{3,	0,	34,2,0,0,	39,2,2,0}, {3,	0,	86,3,0,4,	97,3,4,4},	// CHK2.L #<data>.W,(An)
	{6,	0,	36,2,0,0,	44,2,3,0}, {6,	0,	88,3,0,4,	102,3,5,4},	// CHK2.L #<data>.W,(d16,An)
	{10,	2,	40,2,0,0,	46,2,3,0}, {10,	2,	92,3,0,4,	104,3,5,4},	// CHK2.L #<data>.W,(d8,An,Xn)
	{8,	2,	38,2,0,0,	44,2,3,0}, {8,	2,	90,3,0,4,	102,3,5,4},	// CHK2.L #<data>.W,(xxx).W
	{7,	0,	38,2,0,0,	45,2,3,0}, {7,	0,	90,3,0,4,	103,3,5,4},	// CHK2.L #<data>.W,(xxx).L
	{6,	0,	36,2,0,0,	44,2,3,0}, {6,	0,	88,3,0,4,	102,3,5,4},	// CHK2.L #<data>.W,(d16,PC)
	{10,	2,	40,2,0,0,	46,2,3,0}, {10,	2,	92,3,0,4,	104,3,5,4}	// CHK2.L #<data>.W,(d8,PC,Xn)
};

/** 
  Cycles table for CHK.L instruction. 
  First column is for no exception case, 2nd column is for the exception taken case
  */
static const struct falcon_cycles_t table_falcon_cycles_CHK_L [] = {
	{8,	0,	 8,0,0,0,	10,0,1,0},	{4,	0,	58,1,0,4,	66,1,3,4},// CHK.L Dn,Dn
	{1,	1,	17,1,0,0,	19,1,1,0},	{1,	1,	67,2,0,4,	75,2,3,4},// CHK.L (An),Dn
	{0,	1,	17,1,0,0,	19,1,1,0},	{0,	1,	67,2,0,4,	75,2,3,4},// CHK.L (An)+,Dn
	{2,	2,	18,1,0,0,	20,1,1,0},	{2,	2,	68,2,0,4,	76,2,3,4},// CHK.L -(An),Dn
	{2,	2,	18,1,0,0,	22,1,2,0},	{2,	2,	68,2,0,4,	78,2,4,4},// CHK.L (d16,An),Dn
	{4,	2,	20,1,0,0,	24,1,2,0},	{4,	2,	70,2,0,4,	80,2,4,4},// CHK.L (d8,An,Xn),Dn
	{2,	2,	18,1,0,0,	22,1,2,0},	{2,	2,	68,2,0,4,	78,2,4,4},// CHK.L (xxx).W,Dn
	{1,	0,	18,1,0,0,	23,1,2,0},	{1,	0,	68,2,0,4,	79,2,4,4},// CHK.L (xxx).L,Dn
	{2,	2,	18,1,0,0,	22,1,2,0},	{2,	2,	68,2,0,4,	78,2,4,4},// CHK.L (d16,PC),Dn
	{4,	2,	20,1,0,0,	24,1,2,0},	{4,	2,	70,2,0,4,	80,2,4,4},// CHK.L (d8,PC,Xn),Dn
	{4,	0,	12,0,0,0,	16,0,2,0},	{4,	0,	62,1,0,4,	72,1,4,4} // CHK.L #<data>.L,Dn
};

/** 
  Cycles table for CHK.W  instruction. 
  First column is for no exception case, 2nd column is for the exception taken case
  */
static const struct falcon_cycles_t table_falcon_cycles_CHK_W [] = {
	{8,	0,	 8,0,0,0,	10,0,1,0},	{4,	0,	38,1,0,4,	46,1,3,4},// CHK.W Dn,Dn
	{1,	1,	13,1,0,0,	15,1,1,0},	{1,	1,	43,2,0,4,	51,2,3,4},// CHK.W (An),Dn
	{0,	1,	13,1,0,0,	15,1,1,0},	{0,	1,	43,2,0,4,	51,2,3,4},// CHK.W (An)+,Dn
	{2,	2,	14,1,0,0,	16,1,1,0},	{2,	2,	44,2,0,4,	52,2,3,4},// CHK.W -(An),Dn
	{2,	2,	14,1,0,0,	18,1,2,0},	{2,	2,	44,2,0,4,	54,2,4,4},// CHK.W (d16,An),Dn
	{4,	2,	16,1,0,0,	20,1,2,0},	{4,	2,	46,2,0,4,	56,2,4,4},// CHK.W (d8,An,Xn),Dn
	{2,	2,	14,1,0,0,	18,1,2,0},	{2,	2,	44,2,0,4,	54,2,4,4},// CHK.W (xxx).W,Dn
	{1,	0,	14,1,0,0,	19,1,2,0},	{1,	0,	44,2,0,4,	55,2,4,4},// CHK.W (xxx).L,Dn
	{2,	2,	14,1,0,0,	18,1,2,0},	{2,	2,	44,2,0,4,	54,2,4,4},// CHK.W (d16,PC),Dn
	{4,	2,	16,1,0,0,	20,1,2,0},	{4,	2,	46,2,0,4,	56,2,4,4},// CHK.W (d8,PC,Xn),Dn
	{2,	0,	10,0,0,0,	14,0,2,0},	{2,	0,	40,1,0,4,	50,1,4,4} // CHK.W #<data>.W,Dn
};

/** 
  Cycles table for CAS.BW  instruction. 
  First column is for succesful compare case, 2nd column is for unsuccesful compare case
  */
static const struct falcon_cycles_t table_falcon_cycles_CAS_BW [] = {
	{4,	0,	19,1,0,1,	23,1,2,1}, {4,	0,	15,1,0,0,	19,1,2,0},	// CAS.BW #<data>.W,(An)
	{3,	0,	21,1,0,1,	25,1,2,1}, {3,	0,	17,1,0,0,	21,1,2,0},	// CAS.BW #<data>.W,(An)+
	{4,	0,	19,1,0,1,	23,1,2,1}, {4,	0,	15,1,0,0,	19,1,2,0},	// CAS.BW #<data>.W,-(An)
	{6,	0,	21,1,0,1,	25,1,2,1}, {6,	0,	17,1,0,0,	21,1,2,0},	// CAS.BW #<data>.W,(d16,An)
	{8,	0,	23,1,0,1,	29,1,3,1}, {8,	0,	19,1,0,0,	25,1,3,0},	// CAS.BW #<data>.W,(d8,An,Xn)
	{6,	0,	21,1,0,1,	25,1,2,1}, {6,	0,	17,1,0,0,	21,1,2,0},	// CAS.BW #<data>.W,(xxx).W
	{8,	0,	23,1,0,1,	29,1,3,1}, {8,	0,	19,1,0,0,	25,1,3,0}	// CAS.BW #<data>.W,(xxx).L
};

/** 
  Cycles table for CAS.L  instruction. 
  First column is for succesful compare case, 2nd column is for unsuccesful compare case
  */
static const struct falcon_cycles_t table_falcon_cycles_CAS_L [] = {
	{6,	0,	29,1,0,1,	33,1,2,1}, {6,	0,	21,1,0,0,	25,1,2,0},	// CAS.L #<data>.W,(An)
	{5,	0,	31,1,0,1,	35,1,2,1}, {5,	0,	23,1,0,0,	27,1,2,0},	// CAS.L #<data>.W,(An)+
	{6,	0,	29,1,0,1,	33,1,2,1}, {6,	0,	21,1,0,0,	25,1,2,0},	// CAS.L #<data>.W,-(An)
	{8,	0,	31,1,0,1,	38,1,3,1}, {8,	0,	23,1,0,0,	30,1,3,0},	// CAS.L #<data>.W,(d16,An)
	{10,	0,	33,1,0,1,	39,1,3,1}, {10,	0,	25,1,0,0,	31,1,3,0},	// CAS.L #<data>.W,(d8,An,Xn)
	{8,	0,	31,1,0,1,	37,1,3,1}, {8,	0,	23,1,0,0,	29,1,3,0},	// CAS.L #<data>.W,(xxx).W
	{10,	0,	33,1,0,1,	39,1,3,1}, {10,	0,	25,1,0,0,	31,1,3,0}	// CAS.L #<data>.W,(xxx).L
};

/** 
  Cycles table for CAS2.W  instruction. 
  The table indicates Maximum time.
  */
static const struct falcon_cycles_t table_falcon_cycles_CAS2_W [] = {
	{2,	0,	32,2,0,2,	38,2,2,2},	// CAS2.W #<data>.L (succesful compare)
	{2,	0,	28,2,0,0,	32,2,2,0}	// CAS2.W #<data>.L (unsuccesful compare)
};

/** 
  Cycles table for CAS2.L  instruction. 
  The table indicates Maximum time.
  */
static const struct falcon_cycles_t table_falcon_cycles_CAS2_L [] = {
	{2,	0,	48,2,0,2,	54,2,2,2},	// CAS2.L #<data>.L (succesful compare)
	{2,	0,	36,2,0,0,	40,2,2,0}	// CAS2.L #<data>.L (unsuccesful compare)
};

/** 
  Cycles table for RTE  instruction. 
  */
static const struct falcon_cycles_t table_falcon_cycles_RTE [] = {
	{1,	0,	26,4,0,0,	32,4,2,0},	// RTE.L (Normal four Word)
	{1,	0,	26,4,0,0,	32,4,2,0},	// RTE.L (six Word)
	{1,	0,	20,4,0,0,	20,4,0,0},	// RTE.L (throwaway)
	{1,	0,	40,7,0,0,	44,7,2,0},	// RTE.L (coprocessor)
	{1,	0,	56,10,0,0,	60,10,2,0},	// RTE.L (short fault)
	{1,	0,	126,25,0,0,	120,25,2,0}	// RTE.L (long fault)
};

/** 
  Cycles table for Bcc  instruction. 
  */
static const struct falcon_cycles_t table_falcon_cycles_Bcc [] = {
	{6,	0,	 6,0,0,0,	12,0,2,0},	// Bcc (taken)
	{4,	0,	 4,0,0,0,	 6,0,1,0},	// Bcc.B (not taken)
	{6,	0,	 6,0,0,0,	 8,0,1,0},	// Bcc.W (not taken)
	{6,	0,	 6,0,0,0,	12,0,2,0}	// Bcc.L (not taken)
};

/** 
  Cycles table for DBcc  instruction. 
  */
static const struct falcon_cycles_t table_falcon_cycles_DBcc [] = {
	{6,	0,	 6,0,0,0,	12,0,2,0},	// DBcc (cc = false, count not expired)
	{10,	0,	10,0,0,0,	19,0,3,0},	// DBcc (cc = false, count expired)
	{6,	0,	 6,0,0,0,	10,0,1,0}	// DBcc (cc = true)
};

/** 
  Cycles table for TRAPcc  instruction. 
  */
static const struct falcon_cycles_t table_falcon_cycles_TRAPcc [] = {
	{2,	0,	34,1,0,5,	40,1,2,5},	// TRAPcc (trap)
	{4,	0,	 4,0,0,0,	 6,0,1,0}	// TRAPcc (no trap)
};

/** 
  Cycles table for TRAPcc.W  instruction. 
  */
static const struct falcon_cycles_t table_falcon_cycles_TRAPcc_W [] = {
	{5,	0,	36,1,0,5,	44,1,3,5},	// TRAPcc.W (trap)
	{6,	0,	 6,0,0,0,	 8,0,1,0}	// TRAPcc.W (no trap)
};

/** 
  Cycles table for TRAPcc.L  instruction. 
  */
static const struct falcon_cycles_t table_falcon_cycles_TRAPcc_L [] = {
	{6,	0,	62,1,0,5,	70,1,3,5},	// TRAPcc.L (trap)
	{8,	0,	 8,0,0,0,	12,0,2,0}	// TRAPcc.L (no trap)
};

/** 
  Cycles table for TRAPV  instruction. 
  */
static const struct falcon_cycles_t table_falcon_cycles_TRAPV [] = {
	{2,	0,	34,1,0,5,	40,1,2,5},	// TRAPV (trap)
	{4,	0,	 4,0,0,0,	 6,0,1,0}	// TRAPV (no trap)
};

/** 
  Cycles table for DIVU.L instruction. 
  The table indicates Maximum time.
  */
static const struct falcon_cycles_t table_falcon_cycles_DIVU_L [] = {
	{14,	0,	82,0,0,0,	86,0,2,0},	// DIVU.L #<data>.W,Dn
	{1,	0,	88,1,0,0,	93,1,2,0},	// DIVU.L #<data>.W,(An)
	{4,	1,	91,1,0,0,	95,1,2,0},	// DIVU.L #<data>.W,(An)+
	{2,	0,	88,1,0,0,	93,1,2,0},	// DIVU.L #<data>.W,-(An)
	{4,	0,	90,1,0,0,	98,1,3,0},	// DIVU.L #<data>.W,(d16,An)
	{8,	2,	94,1,0,0,	100,1,3,0},	// DIVU.L #<data>.W,(d8,An,Xn)
	{6,	2,	92,1,0,0,	99,1,3,0},	// DIVU.L #<data>.W,(xxx).W
	{5,	0,	92,1,0,0,	98,1,3,0},	// DIVU.L #<data>.W,(xxx).L
	{4,	0,	90,1,0,0,	98,1,3,0},	// DIVU.L #<data>.W,(d16,PC)
	{8,	2,	94,1,0,0,	100,1,3,0},	// DIVU.L #<data>.W,(d8,PC,Xn)
	{6,	0,	84,0,0,0,	90,0,3,0}	// DIVU.L #<data>.W,#<data>.L
};

/** 
  Cycles table for DIVS.L instruction. 
  The table indicates Maximum time.
  */
static const struct falcon_cycles_t table_falcon_cycles_DIVS_L [] = {
	{16,	0,	94,0,0,0,	98,0,2,0},	// DIVS.L #<data>.W,Dn
	{1,	0,	100,1,0,0,	105,1,2,0},	// DIVS.L #<data>.W,(An)
	{4,	1,	103,1,0,0,	107,1,2,0},	// DIVS.L #<data>.W,(An)+
	{2,	0,	100,1,0,0,	105,1,2,0},	// DIVS.L #<data>.W,-(An)
	{4,	0,	102,1,0,0,	110,1,3,0},	// DIVS.L #<data>.W,(d16,An)
	{8,	2,	106,1,0,0,	112,1,3,0},	// DIVS.L #<data>.W,(d8,An,Xn)
	{6,	2,	104,1,0,0,	110,1,3,0},	// DIVS.L #<data>.W,(xxx).W
	{5,	0,	104,1,0,0,	111,1,3,0},	// DIVS.L #<data>.W,(xxx).L
	{4,	0,	102,1,0,0,	110,1,3,0},	// DIVS.L #<data>.W,(d16,PC)
	{8,	2,	106,1,0,0,	112,1,3,0},	// DIVS.L #<data>.W,(d8,PC,Xn)
	{6,	0,	96,0,0,0,	102,0,3,0}	// DIVS.L #<data>.W,#<data>.L
};

/** 
  Cycles table for BFTST Mem instruction. 
  First column is for Mem < 5bits case, 2nd column is for Mem = 5bits case
  */
static const struct falcon_cycles_t table_falcon_cycles_BFTST_Mem [] = {
	{14,	0,	14,1,0,0,	18,1,2,0},	{14,	0,	20,2,0,0,	24,2,2,0},	// BFTST.L #<data>.W,(An)
	{16,	0,	16,1,0,0,	20,1,2,0},	{16,	0,	22,2,0,0,	26,2,2,0},	// BFTST.L #<data>.W,(d16,An)
	{18,	0,	18,1,0,0,	24,1,3,0},	{18,	0,	24,2,0,0,	30,2,3,0},	// BFTST.L #<data>.W,(d8,An,Xn)
	{16,	0,	16,1,0,0,	20,1,2,0},	{16,	0,	22,2,0,0,	26,2,2,0},	// BFTST.L #<data>.W,(xxx).W
	{18,	0,	18,1,0,0,	24,1,3,0},	{18,	0,	24,2,0,0,	30,2,3,0},	// BFTST.L #<data>.W,(xxx).L
	{16,	0,	16,1,0,0,	20,1,2,0},	{16,	0,	22,2,0,0,	26,2,2,0},	// BFTST.L #<data>.W,(d16,PC)
	{18,	0,	18,1,0,0,	24,1,3,0},	{18,	0,	24,2,0,0,	30,2,3,0}	// BFTST.L #<data>.W,(d8,PC,Xn)
};

/** 
  Cycles table for BFEXTU Mem instruction. 
  First column is for Mem < 5bits case, 2nd column is for Mem = 5bits case
  */
static const struct falcon_cycles_t table_falcon_cycles_BFEXTU_Mem [] = {
	{14,	0,	16,1,0,0,	20,1,2,0},	{14,	0,	24,2,0,0,	28,2,2,0},	// BFEXTU.L #<data>.W,(An)
	{16,	0,	18,1,0,0,	22,1,2,0},	{16,	0,	26,2,0,0,	30,2,2,0},	// BFEXTU.L #<data>.W,(d16,An)
	{18,	0,	20,1,0,0,	26,1,3,0},	{18,	0,	28,2,0,0,	34,2,3,0},	// BFEXTU.L #<data>.W,(d8,An,Xn)
	{16,	0,	18,1,0,0,	22,1,2,0},	{16,	0,	26,2,0,0,	30,2,2,0},	// BFEXTU.L #<data>.W,(xxx).W
	{18,	0,	20,1,0,0,	26,1,3,0},	{18,	0,	28,2,0,0,	34,2,3,0},	// BFEXTU.L #<data>.W,(xxx).L
	{16,	0,	18,1,0,0,	22,1,2,0},	{16,	0,	26,2,0,0,	30,2,2,0},	// BFEXTU.L #<data>.W,(d16,PC)
	{18,	0,	20,1,0,0,	26,1,3,0},	{18,	0,	28,2,0,0,	34,2,3,0}	// BFEXTU.L #<data>.W,(d8,PC,Xn)
};
	
/** 
  Cycles table for BFCHG Mem instruction. 
  First column is for Mem < 5bits case, 2nd column is for Mem = 5bits case
  */
static const struct falcon_cycles_t table_falcon_cycles_BFCHG_Mem [] = {
	{14,	0,	20,1,0,1,	24,1,2,1},	{14,	0,	32,2,0,2,	36,2,2,2},	// BFCHG.L #<data>.W,(An)
	{16,	0,	22,1,0,1,	26,1,2,1},	{16,	0,	34,2,0,2,	38,2,2,2},	// BFCHG.L #<data>.W,(d16,An)
	{18,	0,	24,1,0,1,	30,1,3,1},	{18,	0,	36,2,0,2,	42,2,3,2},	// BFCHG.L #<data>.W,(d8,An,Xn)
	{16,	0,	22,1,0,1,	26,1,2,1},	{16,	0,	34,2,0,2,	38,2,2,2},	// BFCHG.L #<data>.W,(xxx).W
	{18,	0,	24,1,0,1,	30,1,3,1},	{18,	0,	36,2,0,2,	42,2,3,2}	// BFCHG.L #<data>.W,(xxx).L
};
	
/** 
  Cycles table for BFEXTS Mem instruction. 
  First column is for Mem < 5bits case, 2nd column is for Mem = 5bits case
  */
static const struct falcon_cycles_t table_falcon_cycles_BFEXTS_Mem [] = {
	{14,	0,	16,1,0,0,	20,1,2,0},	{14,	0,	24,2,0,0,	28,2,2,0},	// BFEXTS.L #<data>.W,(An)
	{16,	0,	18,1,0,0,	22,1,2,0},	{16,	0,	26,2,0,0,	30,2,2,0},	// BFEXTS.L #<data>.W,(d16,An)
	{18,	0,	20,1,0,0,	26,1,3,0},	{18,	0,	28,2,0,0,	34,2,3,0},	// BFEXTS.L #<data>.W,(d8,An,Xn)
	{16,	0,	18,1,0,0,	22,1,2,0},	{16,	0,	26,2,0,0,	30,2,2,0},	// BFEXTS.L #<data>.W,(xxx).W
	{18,	0,	20,1,0,0,	26,1,3,0},	{18,	0,	28,2,0,0,	34,2,3,0},	// BFEXTS.L #<data>.W,(xxx).L
	{16,	0,	18,1,0,0,	22,1,2,0},	{16,	0,	26,2,0,0,	30,2,2,0},	// BFEXTS.L #<data>.W,(d16,PC)
	{18,	0,	20,1,0,0,	26,1,3,0},	{18,	0,	28,2,0,0,	34,2,3,0}	// BFEXTS.L #<data>.W,(d8,PC,Xn)
};

/** 
  Cycles table for BFCLR Mem instruction. 
  First column is for Mem < 5bits case, 2nd column is for Mem = 5bits case
  */
static const struct falcon_cycles_t table_falcon_cycles_BFCLR_Mem [] = {
	{14,	0,	20,1,0,1,	24,1,2,1},	{14,	0,	32,2,0,2,	36,2,2,2},	// BFCLR.L #<data>.W,(An)
	{16,	0,	22,1,0,1,	26,1,2,1},	{16,	0,	34,2,0,2,	38,2,2,2},	// BFCLR.L #<data>.W,(d16,An)
	{18,	0,	24,1,0,1,	30,1,3,1},	{18,	0,	36,2,0,2,	42,2,3,2},	// BFCLR.L #<data>.W,(d8,An,Xn)
	{16,	0,	22,1,0,1,	26,1,2,1},	{16,	0,	34,2,0,2,	38,2,2,2},	// BFCLR.L #<data>.W,(xxx).W
	{18,	0,	24,1,0,1,	30,1,3,1},	{18,	0,	36,2,0,2,	42,2,3,2}	// BFCLR.L #<data>.W,(xxx).L
};

/** 
  Cycles table for BFFFO Mem instruction. 
  First column is for Mem < 5bits case, 2nd column is for Mem = 5bits case
  */
static const struct falcon_cycles_t table_falcon_cycles_BFFFO_Mem [] = {
	{14,	0,	26,1,0,0,	30,1,2,0},	{14,	0,	34,2,0,0,	38,2,2,0},	// BFFFO.L #<data>.W,(An)
	{16,	0,	28,1,0,0,	32,1,2,0},	{16,	0,	36,2,0,0,	40,2,2,0},	// BFFFO.L #<data>.W,(d16,An)
	{18,	0,	30,1,0,0,	36,1,3,0},	{18,	0,	38,2,0,0,	44,2,3,0},	// BFFFO.L #<data>.W,(d8,An,Xn)
	{16,	0,	28,1,0,0,	32,1,2,0},	{16,	0,	36,2,0,0,	40,2,2,0},	// BFFFO.L #<data>.W,(xxx).W
	{18,	0,	30,1,0,0,	36,1,3,0},	{18,	0,	38,2,0,0,	44,2,3,0},	// BFFFO.L #<data>.W,(xxx).L
	{16,	0,	28,1,0,0,	32,1,2,0},	{16,	0,	36,2,0,0,	40,2,2,0},	// BFFFO.L #<data>.W,(d16,PC)
	{18,	0,	30,1,0,0,	36,1,3,0},	{18,	0,	38,2,0,0,	44,2,3,0}	// BFFFO.L #<data>.W,(d8,PC,Xn)
};

/** 
  Cycles table for BFSET Mem instruction. 
  First column is for Mem < 5bits case, 2nd column is for Mem = 5bits case
  */
static const struct falcon_cycles_t table_falcon_cycles_BFSET_Mem [] = {
	{14,	0,	20,1,0,1,	24,1,2,1},	{14,	0,	32,2,0,2,	36,2,2,2},	// BFSET.L #<data>.W,(An)
	{16,	0,	22,1,0,1,	26,1,2,1},	{16,	0,	34,2,0,2,	38,2,2,2},	// BFSET.L #<data>.W,(d16,An)
	{18,	0,	24,1,0,1,	30,1,3,1},	{18,	0,	36,2,0,2,	42,2,3,2},	// BFSET.L #<data>.W,(d8,An,Xn)
	{16,	0,	22,1,0,1,	26,1,2,1},	{16,	0,	34,2,0,2,	38,2,2,2},	// BFSET.L #<data>.W,(xxx).W
	{18,	0,	24,1,0,1,	30,1,3,1},	{18,	0,	36,2,0,2,	42,2,3,2}	// BFSET.L #<data>.W,(xxx).L
};

/** 
  Cycles table for BFINS Mem instruction. 
  First column is for Mem < 5bits case, 2nd column is for Mem = 5bits case
  */
static const struct falcon_cycles_t table_falcon_cycles_BFINS_Mem [] = {
	{14,	0,	18,1,0,1,	22,1,2,1},	{14,	0,	28,2,0,2,	32,2,2,2},	// BFINS.L #<data>.W,(An)
	{16,	0,	20,1,0,1,	24,1,2,1},	{16,	0,	30,2,0,2,	34,2,2,2},	// BFINS.L #<data>.W,(d16,An)
	{18,	0,	22,1,0,1,	28,1,3,1},	{18,	0,	32,2,0,2,	38,2,3,2},	// BFINS.L #<data>.W,(d8,An,Xn)
	{16,	0,	20,1,0,1,	24,1,2,1},	{16,	0,	30,2,0,2,	34,2,2,2},	// BFINS.L #<data>.W,(xxx).W
	{18,	0,	22,1,0,1,	28,1,3,1},	{18,	0,	32,2,0,2,	38,2,3,2}	// BFINS.L #<data>.W,(xxx).L
};

/** 
  Cycles table for LSD Dx,Dy instruction. 
  LSD can be LSR or LSL. 
  */
static const struct falcon_cycles_t table_falcon_cycles_LSD [] = {
	{6,	0,	 6,0,0,0,	 8,0,1,0},	// LSD.[B/W/L] Dn,Dn	(shift count is less than or equal to the size of data)
	{8,	0,	 8,0,0,0,	10,0,1,0}	// LSD.[B/W/L] Dn,Dn	(shift count is greater than size of data)
};

/** 
  Cycles table for ASR Dx,Dy instructions. 
  */
static const struct falcon_cycles_t table_falcon_cycles_ASR [] = {
	{6,	0,	 6,0,0,0,	 8,0,1,0},	// ASR.[B/W/L] Dn,Dn	(shift count is less than or equal to the size of data)
	{10,	0,	10,0,0,0,	12,0,1,0}	// ASR.[B/W/L] Dn,Dn	(shift count is greater than size of data)
};

/** 
  Cycles table for MOVEC Rn,Cr-[A/B] instructions. 
  */
static const struct falcon_cycles_t table_falcon_cycles_MOVEC [] = {
	{6,	0,	 6,0,0,0,	 8,0,1,0},	// MOVEC.L Rn,CR-A	(Control Registers USP,VBR, CAAR,MSP, and ISP)
	{4,	0,	12,0,0,0,	14,0,1,0}	// MOVEC.L Rn,CR-B	(Control Registers SFC, DFC,and CACR)
};


/** 
  Cycles table for MOVES Ea,Rn instructions. 
  */
static const struct falcon_cycles_t table_falcon_cycles_MOVES_EA_RN [] = {
	{8,	0,	11,1,0,0,	15,1,2,0},	//MOVES.B #<data>.W,(An)		
	{5,	0,	13,1,0,0,	17,1,2,0},	//MOVES.B #<data>.W,(An)+		
	{8,	0,	11,1,0,0,	15,1,2,0},	//MOVES.B #<data>.W,-(An)		
	{10,	0,	13,1,0,0,	17,1,2,0},	//MOVES.B #<data>.W,(d16,An)		
	{12,	0,	15,1,0,0,	21,1,3,0},	//MOVES.B #<data>.W,(d8,An,Xn)	
	{10,	0,	13,1,0,0,	17,1,2,0},	//MOVES.B #<data>.W,(xxx).W		
	{12,	0,	15,1,0,0,	21,1,3,0},	//MOVES.B #<data>.W,(xxx).L		
	{8,	0,	11,1,0,0,	15,1,2,0},	//MOVES.W #<data>.W,(An)		
	{5,	0,	13,1,0,0,	17,1,2,0},	//MOVES.W #<data>.W,(An)+		
	{8,	0,	11,1,0,0,	15,1,2,0},	//MOVES.W #<data>.W,-(An)		
	{10,	0,	13,1,0,0,	17,1,2,0},	//MOVES.W #<data>.W,(d16,An)		
	{12,	0,	15,1,0,0,	21,1,3,0},	//MOVES.W #<data>.W,(d8,An,Xn)	
	{10,	0,	13,1,0,0,	17,1,2,0},	//MOVES.W #<data>.W,(xxx).W		
	{12,	0,	15,1,0,0,	21,1,3,0},	//MOVES.W #<data>.W,(xxx).L		
	{10,	0,	17,1,0,0,	21,1,2,0},	//MOVES.L #<data>.W,(An)		
	{7,	0,	19,1,0,0,	23,1,2,0},	//MOVES.L #<data>.W,(An)+		
	{10,	0,	17,1,0,0,	21,1,2,0},	//MOVES.L #<data>.W,-(An)		
	{12,	0,	19,1,0,0,	26,1,2,0},	//MOVES.L #<data>.W,(d16,An)		
	{14,	0,	21,1,0,0,	27,1,3,0},	//MOVES.L #<data>.W,(d8,An,Xn)	
	{12,	0,	19,1,0,0,	25,1,2,0},	//MOVES.L #<data>.W,(xxx).W		
	{14,	0,	21,1,0,0,	27,1,3,0}	//MOVES.L #<data>.W,(xxx).L		
};

/** 
  Cycles table for MOVES Rn,Ea instructions. 
  */
static const struct falcon_cycles_t table_falcon_cycles_MOVES_RN_EA [] = {
	{6,	1,	 9,0,0,1,	14,0,2,1},	//MOVES.B #<data>.W,(An)		
	{4,	1,	11,0,0,1,	16,0,2,1},	//MOVES.B #<data>.W,(An)+		
	{6,	1,	 9,0,0,1,	14,0,2,1},	//MOVES.B #<data>.W,-(An)		
	{8,	1,	11,0,0,1,	16,0,2,1},	//MOVES.B #<data>.W,(d16,An)		
	{10,	1,	13,0,0,1,	20,0,3,1},	//MOVES.B #<data>.W,(d8,An,Xn)	
	{8,	1,	11,0,0,1,	16,0,2,1},	//MOVES.B #<data>.W,(xxx).W		
	{10,	1,	13,0,0,1,	20,0,3,1},	//MOVES.B #<data>.W,(xxx).L		
	{6,	1,	 9,0,0,1,	14,0,2,1},	//MOVES.W #<data>.W,(An)		
	{4,	1,	11,0,0,1,	16,0,2,1},	//MOVES.W #<data>.W,(An)+		
	{6,	1,	 9,0,0,1,	14,0,2,1},	//MOVES.W #<data>.W,-(An)		
	{8,	1,	11,0,0,1,	16,0,2,1},	//MOVES.W #<data>.W,(d16,An)		
	{10,	1,	13,0,0,1,	20,0,3,1},	//MOVES.W #<data>.W,(d8,An,Xn)	
	{8,	1,	11,0,0,1,	16,0,2,1},	//MOVES.W #<data>.W,(xxx).W		
	{10,	1,	13,0,0,1,	20,0,3,1},	//MOVES.W #<data>.W,(xxx).L		
	{8,	1,	15,0,0,1,	20,0,2,1},	//MOVES.L #<data>.W,(An)		
	{6,	1,	17,0,0,1,	22,0,2,1},	//MOVES.L #<data>.W,(An)+		
	{8,	1,	15,0,0,1,	20,0,2,1},	//MOVES.L #<data>.W,-(An)		
	{10,	1,	17,0,0,1,	25,0,2,1},	//MOVES.L #<data>.W,(d16,An)		
	{12,	1,	19,0,0,1,	26,0,3,1},	//MOVES.L #<data>.W,(d8,An,Xn)	
	{10,	1,	17,0,0,1,	24,0,3,1},	//MOVES.L #<data>.W,(xxx).W		
	{12,	1,	19,0,0,1,	26,0,3,1}	//MOVES.L #<data>.W,(xxx).L		
};

/** 
  Cycles table for 68030 internal timings. 
  */
static const struct falcon_cycles_t table_falcon_cycles_68030_internal [] = {
	{1,	0,	11,1,0,0,	11,1,0,0},	// BKPT
	{0,	0,	35,2,0,4,	40,2,2,4},	// Interrupt (I-Stack)
	{0,	0,	53,2,0,8,	48,2,2,8},	// Interrupt (M-Stack)
	{0,	0,	518,0,0,0,	520,0,1,0},	// RESET instruction
	{0,	0,	 8,0,0,0,	12,0,2,0},	// STOP
	{0,	0,	34,1,0,5,	40,1,2,5},	// TRACE
	{0,	0,	28,1,0,4,	34,1,2,4},	// Illegal instruction
	{0,	0,	28,1,0,4,	34,1,2,4},	// A-Line Trap
	{0,	0,	28,1,0,4,	34,1,2,4},	// F-Line Trap
	{0,	0,	28,1,0,4,	34,1,2,4},	// Privilege Violation
	{0,	0,	58,1,0,10,	64,1,2,10},	// Bus Cycle Fault (Short)
	{0,	0,	102,1,0,24,	168,1,2,24}	// Bus Cycle Fault (Long)
};

#endif
