#include "art.h"
#include "parentset.h"
#include "artutils.h"

FileOffset
nextChild (ParentSet* ps)
{
  FileOffset node=0;
  do { node = childSearch(ps); } while (!node);
  return node;
		/* check termination conditions.... */
}

FileOffset
childSearch (ParentSet* ps)
{
  unsigned char c; int err;
  FileOffset parent, node = q_position;
  if (hat_interrupted) return 3;
  err = q_read(&c,sizeof(unsigned char),1,HatFileSeq);
  if (err!=1) return 1;	/* Assume EOF */
  switch (lower5(c)) {	/* lower 5 bits identify the TraceType */
    case ExpApp:
    case ExpValueApp:
    case ExpValueUse:
    case ExpConstUse:
    case ExpProjection:
    case ExpConstDef:
    case ExpGuard:
    case ExpCase:
    case ExpIf:
    case ExpFieldUpdate:
    case ExpHidden:
    case ExpForward:
    case ExpDoStmt:
        parent = q_skipNode(c);
        if (elemParentSet(parent,ps)) return node; else return 0;
        break;
    default:
        q_skipNode(c); return 0; break;
  }
}

