module Text.Show
  ( ShowS                -- String -> String
  , Show
      ( showsPrec        -- :: Int -> a -> ShowS
      , show             -- :: a   -> String
      , showList         -- :: [a] -> ShowS 
      )
  , shows                -- :: (Show a) => a -> ShowS
  , showChar             -- :: Char -> ShowS
  , showString           -- :: String -> ShowS
  , showParen            -- :: Bool -> ShowS -> ShowS
  , showListWith         -- :: (a -> ShowS) -> [a] -> ShowS 
  ) where

import Prelude

showListWith :: (a -> ShowS) -> [a] -> ShowS 
showListWith _     []     s = "[]" ++ s
showListWith showx (x:xs) s = '[' : showx x (showl xs)
  where
    showl []     = ']' : s
    showl (y:ys) = ',' : showx y (showl ys)
