module Hat.Data.Monoid (Monoid(..)) where

import qualified Hat.PreludeBasic 
import qualified Prelude 
import Hat.Hack 
import qualified Hat.Hat as T 
import Hat.Hat  (WrapVal(wrapVal))
import Hat.Prelude 

class Monoid a
  where
  
  gmempty :: T.RefSrcPos -> T.RefExp -> T.R a
  
  gmappend :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun a (T.Fun a a))
  
  gmconcat :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun (T.List a) a)
  
  gmconcat pmconcat p = T.uconstUse pmconcat p smconcat
  
  smconcat =
    T.uconstDef T.mkRoot a44v9v44v38mconcat
      (\ p ->
        T.uap2 T.mkNoSrcPos p (gfoldr T.mkNoSrcPos p) (gmappend T.mkNoSrcPos p)
          (gmempty T.mkNoSrcPos p))
  
  smempty :: T.R a
  
  smappend :: T.R (T.Fun a (T.Fun a a))
  
  smconcat :: T.R (T.Fun (T.List a) a)
  

instance Monoid ((T.List a))
  where
  
  gmempty pmempty p = T.uconstUse pmempty p smempty
  
  smempty =
    T.uconstDef T.mkRoot a49v9v49v20mempty
      (\ p -> T.con0 T.mkNoSrcPos p T.List T.aList)
  
  gmappend pmappend p = T.uconstUse pmappend p smappend
  
  smappend =
    T.uconstDef T.mkRoot a50v9v50v21mappend (\ p -> (T.mkNoSrcPos !++ p))
  

instance Monoid ((T.Fun a a))
  where
  
  gmempty pmempty p = T.uconstUse pmempty p smempty
  
  smempty = T.uconstDef T.mkRoot a53v9v53v20mempty (\ p -> gid T.mkNoSrcPos p)
  
  gmappend pmappend p = T.uconstUse pmappend p smappend
  
  smappend =
    T.uconstDef T.mkRoot a54v9v54v20mappend (\ p -> (T.mkNoSrcPos !. p))
  

instance Monoid (T.Tuple0)
  where
  
  gmempty pmempty p = T.uconstUse pmempty p smempty
  
  smempty =
    T.uconstDef T.mkRoot a58v9v58v27mempty
      (\ p -> T.con0 T.mkNoSrcPos p T.Tuple0 T.aTuple0)
  
  gmappend pmappend p =
    T.ufun2 a59v12v59v18mappend pmappend p hmappend
    where
    
    hmappend _ _ p = T.con0 T.mkNoSrcPos p T.Tuple0 T.aTuple0
    
  
  gmconcat pmconcat p =
    T.ufun1 a60v9v60v27mconcat pmconcat p hmconcat
    where
    
    hmconcat _ p = T.con0 T.mkNoSrcPos p T.Tuple0 T.aTuple0
    
  

tData_Monoid = T.mkModule "Data.Monoid" "Data/Monoid.hs" Prelude.False

a44v9v44v38mconcat =
  T.mkVariable tData_Monoid 440009 440038 3 0 "mconcat" Prelude.False

a49v9v49v20mempty =
  T.mkVariable tData_Monoid 490009 490020 3 0 "mempty" Prelude.False

a50v9v50v21mappend =
  T.mkVariable tData_Monoid 500009 500021 3 0 "mappend" Prelude.False

a53v9v53v20mempty =
  T.mkVariable tData_Monoid 530009 530020 3 0 "mempty" Prelude.False

a54v9v54v20mappend =
  T.mkVariable tData_Monoid 540009 540020 3 0 "mappend" Prelude.False

a58v9v58v27mempty =
  T.mkVariable tData_Monoid 580009 580027 3 0 "mempty" Prelude.False

a59v12v59v18mappend =
  T.mkVariable tData_Monoid 590012 590018 3 2 "mappend" Prelude.False

a60v9v60v27mconcat =
  T.mkVariable tData_Monoid 600009 600027 3 1 "mconcat" Prelude.False
