module Hat.Data.Complex
  (Complex((:+)),(+:+),grealPart,arealPart,hrealPart,gimagPart,aimagPart
    ,himagPart,gconjugate,aconjugate,hconjugate,gmkPolar,amkPolar,hmkPolar,gcis
    ,acis,hcis,gpolar,apolar,hpolar,gmagnitude,amagnitude,hmagnitude,gphase
    ,aphase,hphase) where

import qualified Hat.PreludeBasic 
import qualified Prelude 
import Hat.Hack 
import qualified Hat.Hat as T 
import Hat.Hat  (WrapVal(wrapVal))
import Hat.Prelude 

data RealFloat a => Complex a = (:+) !(T.R a) !(T.R a)

instance RealFloat a => T.WrapVal ((Complex a))
  where
  
  wrapVal pwrapVal (kwrapVal@((T.R _ z1wrapVal) :+ (T.R _ z2wrapVal))) p =
    T.R kwrapVal (T.mkValueApp2 p pwrapVal (+:+) z1wrapVal z2wrapVal)
  

instance (RealFloat a,Eq a) => Eq ((Complex a))
  where
  
  (!==) (%==) p =
    T.ufun2 (+%$=+!=%$=+#==) (%==) p (*==)
    where
    
    (*==) (T.R (fy1 :+ fy2) _) (T.R (fy3 :+ fy4) _) p =
      T.uwrapForward p
        (((T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos Hat.Prelude.!== p) fy1 fy3)
            Hat.Prelude.*&&
            (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos Hat.Prelude.!== p) fy2 fy4)) p)
    (*==) _ _ p = T.con0 T.mkNoSrcPos p Hat.Prelude.False Hat.Prelude.aFalse
    
  

instance (RealFloat a,Read a) => Read ((Complex a))
  where
  
  greadsPrec preadsPrec p =
    T.ufun1 a32v64v32v67readsPrec preadsPrec p hreadsPrec
    where
    
    hreadsPrec fy1 p =
      T.uwrapForward p
        (Hat.Prelude.hreadParen
          (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos Hat.Prelude.!> p) fy1
            (T.uap1 T.mkNoSrcPos p
              (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
              (T.conInteger T.mkNoSrcPos p 6)))
          (T.uap2 T.mkNoSrcPos p (Hat.PreludeBasic.gthenAp T.mkNoSrcPos p)
            (T.uwrapForward p
              (Hat.PreludeBasic.hthenLex
                (T.uap2 T.mkNoSrcPos p (Hat.PreludeBasic.gthenAp T.mkNoSrcPos p)
                  (T.uap1 T.mkNoSrcPos p
                    (Hat.PreludeBasic.gyield T.mkNoSrcPos p)
                    (T.pa0 (:+) T.cn2 T.mkNoSrcPos p (+:+)))
                  (T.uap1 T.mkNoSrcPos p (Hat.Prelude.greadsPrec T.mkNoSrcPos p)
                    (T.uap1 T.mkNoSrcPos p
                      (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
                      (T.conInteger T.mkNoSrcPos p 7))))
                (T.fromLitString T.mkNoSrcPos p ":+") p))
            (T.uap1 T.mkNoSrcPos p (Hat.Prelude.greadsPrec T.mkNoSrcPos p)
              (T.uap1 T.mkNoSrcPos p
                (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
                (T.conInteger T.mkNoSrcPos p 7)))) p)
    
  

instance (RealFloat a,Show a) => Show ((Complex a))
  where
  
  gshowsPrec pshowsPrec p =
    T.ufun2 a32v70v32v73showsPrec pshowsPrec p hshowsPrec
    where
    
    hshowsPrec fy1 (T.R (fy2 :+ fy3) _) p =
      T.uwrapForward p
        (Hat.Prelude.hshowParen
          (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos Hat.Prelude.!> p) fy1
            (T.uap1 T.mkNoSrcPos p
              (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
              (T.conInteger T.mkNoSrcPos p 6)))
          (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos Hat.Prelude.!. p)
            (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos Hat.Prelude.!. p)
              (T.uap2 T.mkNoSrcPos p (Hat.Prelude.gshowsPrec T.mkNoSrcPos p)
                (T.uap1 T.mkNoSrcPos p
                  (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
                  (T.conInteger T.mkNoSrcPos p 7)) fy2)
              (T.uap1 T.mkNoSrcPos p (Hat.Prelude.gshowString T.mkNoSrcPos p)
                (T.fromLitString T.mkNoSrcPos p " :+ ")))
            (T.uap2 T.mkNoSrcPos p (Hat.Prelude.gshowsPrec T.mkNoSrcPos p)
              (T.uap1 T.mkNoSrcPos p
                (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
                (T.conInteger T.mkNoSrcPos p 7)) fy3)) p)
    hshowsPrec _ _ p = T.fatal p
    
  

grealPart,gimagPart ::
  RealFloat a => T.RefSrcPos -> T.RefExp -> T.R (T.Fun (Complex a) a)

hrealPart :: RealFloat a => (T.R (Complex a)) -> T.RefExp -> T.R a

himagPart :: RealFloat a => (T.R (Complex a)) -> T.RefExp -> T.R a

grealPart prealPart p = T.ufun1 arealPart prealPart p hrealPart

hrealPart (T.R (fx :+ _) _) p = T.projection T.mkNoSrcPos p fx
hrealPart _ p = T.fatal p

gimagPart pimagPart p = T.ufun1 aimagPart pimagPart p himagPart

himagPart (T.R (_ :+ fy) _) p = T.projection T.mkNoSrcPos p fy
himagPart _ p = T.fatal p

gconjugate ::
  RealFloat a => T.RefSrcPos -> T.RefExp -> T.R (T.Fun (Complex a) (Complex a))

hconjugate :: RealFloat a => (T.R (Complex a)) -> T.RefExp -> T.R (Complex a)

gconjugate pconjugate p = T.ufun1 aconjugate pconjugate p hconjugate

hconjugate (T.R (fx :+ fy) _) p =
  T.con2 T.mkNoSrcPos p (:+) (+:+) fx
    (T.uap1 T.mkNoSrcPos p (Hat.Prelude.gnegate T.mkNoSrcPos p) fy)
hconjugate _ p = T.fatal p

gmkPolar ::
  RealFloat a => T.RefSrcPos -> T.RefExp -> T.R (T.Fun a (T.Fun a (Complex a)))

hmkPolar :: RealFloat a => (T.R a) -> (T.R a) -> T.RefExp -> T.R (Complex a)

gmkPolar pmkPolar p = T.ufun2 amkPolar pmkPolar p hmkPolar

hmkPolar fr ftheta p =
  T.con2 T.mkNoSrcPos p (:+) (+:+)
    (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !* p) fr
      (T.uap1 T.mkNoSrcPos p (gcos T.mkNoSrcPos p) ftheta))
    (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !* p) fr
      (T.uap1 T.mkNoSrcPos p (gsin T.mkNoSrcPos p) ftheta))

gcis :: RealFloat a => T.RefSrcPos -> T.RefExp -> T.R (T.Fun a (Complex a))

hcis :: RealFloat a => (T.R a) -> T.RefExp -> T.R (Complex a)

gcis pcis p = T.ufun1 acis pcis p hcis

hcis ftheta p =
  T.con2 T.mkNoSrcPos p (:+) (+:+)
    (T.uap1 T.mkNoSrcPos p (gcos T.mkNoSrcPos p) ftheta)
    (T.uap1 T.mkNoSrcPos p (gsin T.mkNoSrcPos p) ftheta)

gpolar ::
  RealFloat a =>
  T.RefSrcPos -> T.RefExp -> T.R (T.Fun (Complex a) (T.Tuple2 a a))

hpolar :: RealFloat a => (T.R (Complex a)) -> T.RefExp -> T.R (T.Tuple2 a a)

gpolar ppolar p = T.ufun1 apolar ppolar p hpolar

hpolar fz p =
  T.con2 T.mkNoSrcPos p T.Tuple2 T.aTuple2 (T.uwrapForward p (hmagnitude fz p))
    (T.uwrapForward p (hphase fz p))

gmagnitude ::
  RealFloat a => T.RefSrcPos -> T.RefExp -> T.R (T.Fun (Complex a) a)

hmagnitude :: RealFloat a => (T.R (Complex a)) -> T.RefExp -> T.R a

gmagnitude pmagnitude p = T.ufun1 amagnitude pmagnitude p hmagnitude

hmagnitude (T.R (fx :+ fy) _) p =
  T.uap2 T.mkNoSrcPos p (gscaleFloat T.mkNoSrcPos p) (gk T.mkNoSrcPos p)
    (T.uap1 T.mkNoSrcPos p (gsqrt T.mkNoSrcPos p)
      (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !+ p)
        (T.uwrapForward p
          (((T.uap2 T.mkNoSrcPos p (gscaleFloat T.mkNoSrcPos p)
                (gmk T.mkNoSrcPos p) fx)
              *^
              (T.uap1 T.mkNoSrcPos p
                  (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
                  (T.conInteger T.mkNoSrcPos p 2)
                :: T.R Int)) p))
        (T.uwrapForward p
          (((T.uap2 T.mkNoSrcPos p (gscaleFloat T.mkNoSrcPos p)
                (gmk T.mkNoSrcPos p) fy)
              *^
              (T.uap1 T.mkNoSrcPos p
                  (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
                  (T.conInteger T.mkNoSrcPos p 2)
                :: T.R Int)) p))))
  where
  
  gk pk p = T.uconstUse pk p sk
  
  sk =
    T.uconstDef p a57v27v57v59k
      (\ p ->
        T.uap2 T.mkNoSrcPos p (gmax T.mkNoSrcPos p)
          (T.uap1 T.mkNoSrcPos p (gexponent T.mkNoSrcPos p) fx)
          (T.uap1 T.mkNoSrcPos p (gexponent T.mkNoSrcPos p) fy))
  
  gmk pmk p = T.uconstUse pmk p smk
  
  smk =
    T.uconstDef p a58v27v58v34mk
      (\ p ->
        T.uap1 T.mkNoSrcPos p (Hat.Prelude.gnegate T.mkNoSrcPos p)
          (gk T.mkNoSrcPos p))
  
hmagnitude _ p = T.fatal p

gphase :: RealFloat a => T.RefSrcPos -> T.RefExp -> T.R (T.Fun (Complex a) a)

hphase :: RealFloat a => (T.R (Complex a)) -> T.RefExp -> T.R a

gphase pphase p = T.ufun1 aphase pphase p hphase

hphase (z1phase@(T.R (fv61v8v61v8n :+ v61v13v61v13n) _)) p =
  T.ucguard
    (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos Hat.Prelude.!== p) fv61v8v61v8n
      (T.uap1 T.mkNoSrcPos p (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
        (T.conInteger T.mkNoSrcPos p 0))) (h v61v13v61v13n p)
    (y1phase z1phase p)
  where
  
  h fv61v13v61v13n p =
    T.ucguard
      (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos Hat.Prelude.!== p) fv61v13v61v13n
        (T.uap1 T.mkNoSrcPos p (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
          (T.conInteger T.mkNoSrcPos p 0))) (h p) (y1phase z1phase p)
    where
    
    h p =
      T.uap1 T.mkNoSrcPos p (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
        (T.conInteger T.mkNoSrcPos p 0)
    h p = y1phase z1phase p
    
  h _ p = y1phase z1phase p
  
hphase z1phase p = y1phase z1phase p

y1phase (T.R (fx :+ fy) _) p =
  T.uap2 T.mkNoSrcPos p (gatan2 T.mkNoSrcPos p) fy fx
y1phase _ p = T.fatal p

instance RealFloat a => Num ((Complex a))
  where
  
  (!+) (%+) p =
    T.ufun2 (++>=#$=+>=#$+) (%+) p (*+)
    where
    
    (*+) (T.R (fx :+ fy) _) (T.R (fx' :+ fy') _) p =
      T.con2 T.mkNoSrcPos p (:+) (+:+)
        (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !+ p) fx fx')
        (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !+ p) fy fy')
    (*+) _ _ p = T.fatal p
    
  
  (!-) (%-) p =
    T.ufun2 (+^!=#$=^!=#$-) (%-) p (*-)
    where
    
    (*-) (T.R (fx :+ fy) _) (T.R (fx' :+ fy') _) p =
      T.con2 T.mkNoSrcPos p (:+) (+:+)
        (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !- p) fx fx')
        (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !- p) fy fy')
    (*-) _ _ p = T.fatal p
    
  
  (!*) (%*) p =
    T.ufun2 (+^#=#$=^#=#$*) (%*) p (**)
    where
    
    (**) (T.R (fx :+ fy) _) (T.R (fx' :+ fy') _) p =
      T.con2 T.mkNoSrcPos p (:+) (+:+)
        (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !- p)
          (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !* p) fx fx')
          (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !* p) fy fy'))
        (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !+ p)
          (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !* p) fx fy')
          (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !* p) fy fx'))
    (**) _ _ p = T.fatal p
    
  
  gnegate pnegate p =
    T.ufun1 a72v5v72v47negate pnegate p hnegate
    where
    
    hnegate (T.R (fx :+ fy) _) p =
      T.con2 T.mkNoSrcPos p (:+) (+:+)
        (T.uap1 T.mkNoSrcPos p (gnegate T.mkNoSrcPos p) fx)
        (T.uap1 T.mkNoSrcPos p (gnegate T.mkNoSrcPos p) fy)
    hnegate _ p = T.fatal p
    
  
  gabs pabs p =
    T.ufun1 a73v5v73v43abs pabs p habs
    where
    
    habs fz p =
      T.con2 T.mkNoSrcPos p (:+) (+:+) (T.uwrapForward p (hmagnitude fz p))
        (T.uap1 T.mkNoSrcPos p (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
          (T.conInteger T.mkNoSrcPos p 0))
    
  
  gsignum psignum p =
    T.ufun1 a74v5v75v60signum psignum p hsignum
    where
    
    hsignum fv74v12v74v12n p =
      T.ucguard
        (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos Hat.Prelude.!== p) fv74v12v74v12n
          (T.uap1 T.mkNoSrcPos p (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
            (T.conInteger T.mkNoSrcPos p 0))) (h p) (y1signum fv74v12v74v12n p)
      where
      
      h p =
        T.uap1 T.mkNoSrcPos p (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
          (T.conInteger T.mkNoSrcPos p 0)
      h p = y1signum fv74v12v74v12n p
      
    hsignum fv74v12v74v12n p = y1signum fv74v12v74v12n p
    
    y1signum (fz@(T.R (fx :+ fy) _)) p =
      T.con2 T.mkNoSrcPos p (:+) (+:+)
        (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !/ p) fx (gr T.mkNoSrcPos p))
        (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !/ p) fy (gr T.mkNoSrcPos p))
      where
      
      gr pr p = T.uconstUse pr p sr
      
      sr =
        T.uconstDef p a75v46v75v60r (\ p -> T.uwrapForward p (hmagnitude fz p))
      
    y1signum _ p = T.fatal p
    
  
  gfromInteger pfromInteger p =
    T.ufun1 a76v5v76v45fromInteger pfromInteger p hfromInteger
    where
    
    hfromInteger fn p =
      T.con2 T.mkNoSrcPos p (:+) (+:+)
        (T.uap1 T.mkNoSrcPos p (gfromInteger T.mkNoSrcPos p) fn)
        (T.uap1 T.mkNoSrcPos p (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
          (T.conInteger T.mkNoSrcPos p 0))
    
  

instance RealFloat a => Fractional ((Complex a))
  where
  
  (!/) (%/) p =
    T.ufun2 (+^>=#$=^>=#$/) (%/) p (*/)
    where
    
    (*/) (T.R (fx :+ fy) _) (T.R (fx' :+ fy') _) p =
      T.con2 T.mkNoSrcPos p (:+) (+:+)
        (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !/ p)
          (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !+ p)
            (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !* p) fx (gx'' T.mkNoSrcPos p))
            (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !* p) fy
              (gy'' T.mkNoSrcPos p))) (gd T.mkNoSrcPos p))
        (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !/ p)
          (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !- p)
            (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !* p) fy (gx'' T.mkNoSrcPos p))
            (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !* p) fx
              (gy'' T.mkNoSrcPos p))) (gd T.mkNoSrcPos p))
      where
      
      gx'' px'' p = T.uconstUse px'' p sx''
      
      sx'' =
        T.uconstDef p a80v34v80v54x''
          (\ p ->
            T.uap2 T.mkNoSrcPos p (gscaleFloat T.mkNoSrcPos p)
              (gk T.mkNoSrcPos p) fx')
      
      gy'' py'' p = T.uconstUse py'' p sy''
      
      sy'' =
        T.uconstDef p a81v34v81v54y''
          (\ p ->
            T.uap2 T.mkNoSrcPos p (gscaleFloat T.mkNoSrcPos p)
              (gk T.mkNoSrcPos p) fy')
      
      gk pk p = T.uconstUse pk p sk
      
      sk =
        T.uconstDef p a82v34v82v71k
          (\ p ->
            T.uap1 T.mkNoSrcPos p (Hat.Prelude.gnegate T.mkNoSrcPos p)
              (T.uap2 T.mkNoSrcPos p (gmax T.mkNoSrcPos p)
                (T.uap1 T.mkNoSrcPos p (gexponent T.mkNoSrcPos p) fx')
                (T.uap1 T.mkNoSrcPos p (gexponent T.mkNoSrcPos p) fy')))
      
      gd pd p = T.uconstUse pd p sd
      
      sd =
        T.uconstDef p a83v34v83v54d
          (\ p ->
            T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !+ p)
              (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !* p) fx'
                (gx'' T.mkNoSrcPos p))
              (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !* p) fy'
                (gy'' T.mkNoSrcPos p)))
      
    (*/) _ _ p = T.fatal p
    
  
  gfromRational pfromRational p =
    T.ufun1 a85v5v85v46fromRational pfromRational p hfromRational
    where
    
    hfromRational fa p =
      T.con2 T.mkNoSrcPos p (:+) (+:+)
        (T.uap1 T.mkNoSrcPos p (gfromRational T.mkNoSrcPos p) fa)
        (T.uap1 T.mkNoSrcPos p (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
          (T.conInteger T.mkNoSrcPos p 0))
    
  

instance RealFloat a => Floating ((Complex a))
  where
  
  gpi ppi p = T.uconstUse ppi p spi
  
  spi =
    T.uconstDef T.mkRoot a88v5v88v29pi
      (\ p ->
        T.con2 T.mkNoSrcPos p (:+) (+:+) (gpi T.mkNoSrcPos p)
          (T.uap1 T.mkNoSrcPos p (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
            (T.conInteger T.mkNoSrcPos p 0)))
  
  gexp pexp p =
    T.ufun1 a89v5v90v40exp pexp p hexp
    where
    
    hexp (T.R (fx :+ fy) _) p =
      T.con2 T.mkNoSrcPos p (:+) (+:+)
        (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !* p) (gexpx T.mkNoSrcPos p)
          (T.uap1 T.mkNoSrcPos p (gcos T.mkNoSrcPos p) fy))
        (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !* p) (gexpx T.mkNoSrcPos p)
          (T.uap1 T.mkNoSrcPos p (gsin T.mkNoSrcPos p) fy))
      where
      
      gexpx pexpx p = T.uconstUse pexpx p sexpx
      
      sexpx =
        T.uconstDef p a90v29v90v40expx
          (\ p -> T.uap1 T.mkNoSrcPos p (gexp T.mkNoSrcPos p) fx)
      
    hexp _ p = T.fatal p
    
  
  glog plog p =
    T.ufun1 a91v5v91v50log plog p hlog
    where
    
    hlog fz p =
      T.con2 T.mkNoSrcPos p (:+) (+:+)
        (T.uap1 T.mkNoSrcPos p (glog T.mkNoSrcPos p)
          (T.uwrapForward p (hmagnitude fz p))) (T.uwrapForward p (hphase fz p))
    
  
  gsqrt psqrt p =
    T.ufun1 a93v5v97v67sqrt psqrt p hsqrt
    where
    
    hsqrt fv93v10v93v10n p =
      T.ucguard
        (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos Hat.Prelude.!== p) fv93v10v93v10n
          (T.uap1 T.mkNoSrcPos p (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
            (T.conInteger T.mkNoSrcPos p 0))) (h p) (y1sqrt fv93v10v93v10n p)
      where
      
      h p =
        T.uap1 T.mkNoSrcPos p (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
          (T.conInteger T.mkNoSrcPos p 0)
      h p = y1sqrt fv93v10v93v10n p
      
    hsqrt fv93v10v93v10n p = y1sqrt fv93v10v93v10n p
    
    y1sqrt (fz@(T.R (fx :+ fy) _)) p =
      T.con2 T.mkNoSrcPos p (:+) (+:+) (gu T.mkNoSrcPos p)
        (T.ucif p
          (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !< p) fy
            (T.uap1 T.mkNoSrcPos p
              (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
              (T.conInteger T.mkNoSrcPos p 0)))
          (T.uap1 T.mkNoSrcPos p (Hat.Prelude.gnegate T.mkNoSrcPos p)
            (gv T.mkNoSrcPos p)) (gv T.mkNoSrcPos p))
      where
      
      gu pu p = T.uconstUse pu p su
      
      gv pu p = T.uconstUse pu p sv
      
      j95v29v95v33u =
        case
          T.ucif p
            (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !< p) fx
              (T.uap1 T.mkNoSrcPos p
                (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
                (T.conInteger T.mkNoSrcPos p 0)))
            (T.con2 T.mkNoSrcPos p T.Tuple2 T.aTuple2 (gv' T.mkNoSrcPos p)
              (gu' T.mkNoSrcPos p))
            (T.con2 T.mkNoSrcPos p T.Tuple2 T.aTuple2 (gu' T.mkNoSrcPos p)
              (gv' T.mkNoSrcPos p)) of
          T.R (T.Tuple2 fu fv) ku -> (ku,fu,fv)
          _ -> T.fatal p
      
      su =
        T.uconstDef p a95v30v95v30u
          (\ _ -> case j95v29v95v33u of (ku,fu,fv) -> fu)
      
      sv =
        T.uconstDef p a95v32v95v32v
          (\ _ -> case j95v29v95v33u of (ku,fu,fv) -> fv)
      
      gv' pv' p = T.uconstUse pv' p sv'
      
      sv' =
        T.uconstDef p a96v29v96v49v'
          (\ p ->
            T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !/ p)
              (T.uap1 T.mkNoSrcPos p (gabs T.mkNoSrcPos p) fy)
              (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !* p) (gu' T.mkNoSrcPos p)
                (T.uap1 T.mkNoSrcPos p
                  (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
                  (T.conInteger T.mkNoSrcPos p 2))))
      
      gu' pu' p = T.uconstUse pu' p su'
      
      su' =
        T.uconstDef p a97v29v97v67u'
          (\ p ->
            T.uap1 T.mkNoSrcPos p (gsqrt T.mkNoSrcPos p)
              (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !/ p)
                (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !+ p)
                  (T.uwrapForward p (hmagnitude fz p))
                  (T.uap1 T.mkNoSrcPos p (gabs T.mkNoSrcPos p) fx))
                (T.uap1 T.mkNoSrcPos p
                  (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
                  (T.conInteger T.mkNoSrcPos p 2))))
      
    y1sqrt _ p = T.fatal p
    
  
  gsin psin p =
    T.ufun1 a99v5v99v54sin psin p hsin
    where
    
    hsin (T.R (fx :+ fy) _) p =
      T.con2 T.mkNoSrcPos p (:+) (+:+)
        (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !* p)
          (T.uap1 T.mkNoSrcPos p (gsin T.mkNoSrcPos p) fx)
          (T.uap1 T.mkNoSrcPos p (gcosh T.mkNoSrcPos p) fy))
        (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !* p)
          (T.uap1 T.mkNoSrcPos p (gcos T.mkNoSrcPos p) fx)
          (T.uap1 T.mkNoSrcPos p (gsinh T.mkNoSrcPos p) fy))
    hsin _ p = T.fatal p
    
  
  gcos pcos p =
    T.ufun1 a100v5v100v57cos pcos p hcos
    where
    
    hcos (T.R (fx :+ fy) _) p =
      T.con2 T.mkNoSrcPos p (:+) (+:+)
        (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !* p)
          (T.uap1 T.mkNoSrcPos p (gcos T.mkNoSrcPos p) fx)
          (T.uap1 T.mkNoSrcPos p (gcosh T.mkNoSrcPos p) fy))
        (T.uap1 T.mkNoSrcPos p (Hat.Prelude.gnegate T.mkNoSrcPos p)
          (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !* p)
            (T.uap1 T.mkNoSrcPos p (gsin T.mkNoSrcPos p) fx)
            (T.uap1 T.mkNoSrcPos p (gsinh T.mkNoSrcPos p) fy)))
    hcos _ p = T.fatal p
    
  
  gtan ptan p =
    T.ufun1 a101v5v105v42tan ptan p htan
    where
    
    htan (T.R (fx :+ fy) _) p =
      T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !/ p)
        (T.con2 T.mkNoSrcPos p (:+) (+:+)
          (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !* p) (gsinx T.mkNoSrcPos p)
            (gcoshy T.mkNoSrcPos p))
          (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !* p) (gcosx T.mkNoSrcPos p)
            (gsinhy T.mkNoSrcPos p)))
        (T.con2 T.mkNoSrcPos p (:+) (+:+)
          (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !* p) (gcosx T.mkNoSrcPos p)
            (gcoshy T.mkNoSrcPos p))
          (T.uap1 T.mkNoSrcPos p (Hat.Prelude.gnegate T.mkNoSrcPos p)
            (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !* p) (gsinx T.mkNoSrcPos p)
              (gsinhy T.mkNoSrcPos p))))
      where
      
      gsinx psinx p = T.uconstUse psinx p ssinx
      
      ssinx =
        T.uconstDef p a102v29v102v41sinx
          (\ p -> T.uap1 T.mkNoSrcPos p (gsin T.mkNoSrcPos p) fx)
      
      gcosx pcosx p = T.uconstUse pcosx p scosx
      
      scosx =
        T.uconstDef p a103v29v103v41cosx
          (\ p -> T.uap1 T.mkNoSrcPos p (gcos T.mkNoSrcPos p) fx)
      
      gsinhy psinhy p = T.uconstUse psinhy p ssinhy
      
      ssinhy =
        T.uconstDef p a104v29v104v42sinhy
          (\ p -> T.uap1 T.mkNoSrcPos p (gsinh T.mkNoSrcPos p) fy)
      
      gcoshy pcoshy p = T.uconstUse pcoshy p scoshy
      
      scoshy =
        T.uconstDef p a105v29v105v42coshy
          (\ p -> T.uap1 T.mkNoSrcPos p (gcosh T.mkNoSrcPos p) fy)
      
    htan _ p = T.fatal p
    
  
  gsinh psinh p =
    T.ufun1 a107v5v107v55sinh psinh p hsinh
    where
    
    hsinh (T.R (fx :+ fy) _) p =
      T.con2 T.mkNoSrcPos p (:+) (+:+)
        (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !* p)
          (T.uap1 T.mkNoSrcPos p (gcos T.mkNoSrcPos p) fy)
          (T.uap1 T.mkNoSrcPos p (gsinh T.mkNoSrcPos p) fx))
        (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !* p)
          (T.uap1 T.mkNoSrcPos p (gsin T.mkNoSrcPos p) fy)
          (T.uap1 T.mkNoSrcPos p (gcosh T.mkNoSrcPos p) fx))
    hsinh _ p = T.fatal p
    
  
  gcosh pcosh p =
    T.ufun1 a108v5v108v54cosh pcosh p hcosh
    where
    
    hcosh (T.R (fx :+ fy) _) p =
      T.con2 T.mkNoSrcPos p (:+) (+:+)
        (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !* p)
          (T.uap1 T.mkNoSrcPos p (gcos T.mkNoSrcPos p) fy)
          (T.uap1 T.mkNoSrcPos p (gcosh T.mkNoSrcPos p) fx))
        (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !* p)
          (T.uap1 T.mkNoSrcPos p (gsin T.mkNoSrcPos p) fy)
          (T.uap1 T.mkNoSrcPos p (gsinh T.mkNoSrcPos p) fx))
    hcosh _ p = T.fatal p
    
  
  gtanh ptanh p =
    T.ufun1 a109v5v113v42tanh ptanh p htanh
    where
    
    htanh (T.R (fx :+ fy) _) p =
      T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !/ p)
        (T.con2 T.mkNoSrcPos p (:+) (+:+)
          (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !* p) (gcosy T.mkNoSrcPos p)
            (gsinhx T.mkNoSrcPos p))
          (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !* p) (gsiny T.mkNoSrcPos p)
            (gcoshx T.mkNoSrcPos p)))
        (T.con2 T.mkNoSrcPos p (:+) (+:+)
          (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !* p) (gcosy T.mkNoSrcPos p)
            (gcoshx T.mkNoSrcPos p))
          (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !* p) (gsiny T.mkNoSrcPos p)
            (gsinhx T.mkNoSrcPos p)))
      where
      
      gsiny psiny p = T.uconstUse psiny p ssiny
      
      ssiny =
        T.uconstDef p a110v29v110v41siny
          (\ p -> T.uap1 T.mkNoSrcPos p (gsin T.mkNoSrcPos p) fy)
      
      gcosy pcosy p = T.uconstUse pcosy p scosy
      
      scosy =
        T.uconstDef p a111v29v111v41cosy
          (\ p -> T.uap1 T.mkNoSrcPos p (gcos T.mkNoSrcPos p) fy)
      
      gsinhx psinhx p = T.uconstUse psinhx p ssinhx
      
      ssinhx =
        T.uconstDef p a112v29v112v42sinhx
          (\ p -> T.uap1 T.mkNoSrcPos p (gsinh T.mkNoSrcPos p) fx)
      
      gcoshx pcoshx p = T.uconstUse pcoshx p scoshx
      
      scoshx =
        T.uconstDef p a113v29v113v42coshx
          (\ p -> T.uap1 T.mkNoSrcPos p (gcosh T.mkNoSrcPos p) fx)
      
    htanh _ p = T.fatal p
    
  
  gasin pasin p =
    T.ufun1 a115v5v116v70asin pasin p hasin
    where
    
    hasin (fz@(T.R (fx :+ fy) _)) p =
      T.con2 T.mkNoSrcPos p (:+) (+:+) (gy' T.mkNoSrcPos p)
        (T.uap1 T.mkNoSrcPos p (Hat.Prelude.gnegate T.mkNoSrcPos p)
          (gx' T.mkNoSrcPos p))
      where
      
      gx' px' p = T.uconstUse px' p sx'
      
      gy' px' p = T.uconstUse px' p sy'
      
      j116v31v116v36x' =
        case
          T.uap1 T.mkNoSrcPos p (glog T.mkNoSrcPos p)
            (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !+ p)
              (T.con2 T.mkNoSrcPos p (:+) (+:+)
                (T.uap1 T.mkNoSrcPos p (Hat.Prelude.gnegate T.mkNoSrcPos p) fy)
                (T.projection T.mkNoSrcPos p fx))
              (T.uap1 T.mkNoSrcPos p (gsqrt T.mkNoSrcPos p)
                (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !- p)
                  (T.uap1 T.mkNoSrcPos p
                    (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
                    (T.conInteger T.mkNoSrcPos p 1))
                  (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !* p) fz fz)))) of
          T.R (fx' :+ fy') kx' -> (kx',fx',fy')
          _ -> T.fatal p
      
      sx' =
        T.uconstDef p a116v31v116v32x'
          (\ _ -> case j116v31v116v36x' of (kx',fx',fy') -> fx')
      
      sy' =
        T.uconstDef p a116v35v116v36y'
          (\ _ -> case j116v31v116v36x' of (kx',fx',fy') -> fy')
      
    hasin _ p = T.fatal p
    
  
  gacos pacos p =
    T.ufun1 a117v5v119v54acos pacos p hacos
    where
    
    hacos fz p =
      T.con2 T.mkNoSrcPos p (:+) (+:+) (gy'' T.mkNoSrcPos p)
        (T.uap1 T.mkNoSrcPos p (Hat.Prelude.gnegate T.mkNoSrcPos p)
          (gx'' T.mkNoSrcPos p))
      where
      
      gx'' px'' p = T.uconstUse px'' p sx''
      
      gy'' px'' p = T.uconstUse px'' p sy''
      
      j118v30v118v37x'' =
        case
          T.uap1 T.mkNoSrcPos p (glog T.mkNoSrcPos p)
            (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !+ p) fz
              (T.con2 T.mkNoSrcPos p (:+) (+:+)
                (T.uap1 T.mkNoSrcPos p (Hat.Prelude.gnegate T.mkNoSrcPos p)
                  (gy' T.mkNoSrcPos p)) (gx' T.mkNoSrcPos p))) of
          T.R (fx'' :+ fy'') kx'' -> (kx'',fx'',fy'')
          _ -> T.fatal p
      
      sx'' =
        T.uconstDef p a118v30v118v32x''
          (\ _ -> case j118v30v118v37x'' of (kx'',fx'',fy'') -> fx'')
      
      sy'' =
        T.uconstDef p a118v35v118v37y''
          (\ _ -> case j118v30v118v37x'' of (kx'',fx'',fy'') -> fy'')
      
      gx' px' p = T.uconstUse px' p sx'
      
      gy' px' p = T.uconstUse px' p sy'
      
      j119v30v119v35x' =
        case
          T.uap1 T.mkNoSrcPos p (gsqrt T.mkNoSrcPos p)
            (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !- p)
              (T.uap1 T.mkNoSrcPos p
                (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
                (T.conInteger T.mkNoSrcPos p 1))
              (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !* p) fz fz)) of
          T.R (fx' :+ fy') kx' -> (kx',fx',fy')
          _ -> T.fatal p
      
      sx' =
        T.uconstDef p a119v30v119v31x'
          (\ _ -> case j119v30v119v35x' of (kx',fx',fy') -> fx')
      
      sy' =
        T.uconstDef p a119v34v119v35y'
          (\ _ -> case j119v30v119v35x' of (kx',fx',fy') -> fy')
      
    
  
  gatan patan p =
    T.ufun1 a120v5v121v68atan patan p hatan
    where
    
    hatan (fz@(T.R (fx :+ fy) _)) p =
      T.con2 T.mkNoSrcPos p (:+) (+:+) (gy' T.mkNoSrcPos p)
        (T.uap1 T.mkNoSrcPos p (Hat.Prelude.gnegate T.mkNoSrcPos p)
          (gx' T.mkNoSrcPos p))
      where
      
      gx' px' p = T.uconstUse px' p sx'
      
      gy' px' p = T.uconstUse px' p sy'
      
      j121v30v121v35x' =
        case
          T.uap1 T.mkNoSrcPos p (glog T.mkNoSrcPos p)
            (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !/ p)
              (T.con2 T.mkNoSrcPos p (:+) (+:+)
                (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !- p)
                  (T.uap1 T.mkNoSrcPos p
                    (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
                    (T.conInteger T.mkNoSrcPos p 1)) fy)
                (T.projection T.mkNoSrcPos p fx))
              (T.uap1 T.mkNoSrcPos p (gsqrt T.mkNoSrcPos p)
                (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !+ p)
                  (T.uap1 T.mkNoSrcPos p
                    (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
                    (T.conInteger T.mkNoSrcPos p 1))
                  (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !* p) fz fz)))) of
          T.R (fx' :+ fy') kx' -> (kx',fx',fy')
          _ -> T.fatal p
      
      sx' =
        T.uconstDef p a121v30v121v31x'
          (\ _ -> case j121v30v121v35x' of (kx',fx',fy') -> fx')
      
      sy' =
        T.uconstDef p a121v34v121v35y'
          (\ _ -> case j121v30v121v35x' of (kx',fx',fy') -> fy')
      
    hatan _ p = T.fatal p
    
  
  gasinh pasinh p =
    T.ufun1 a123v5v123v42asinh pasinh p hasinh
    where
    
    hasinh fz p =
      T.uap1 T.mkNoSrcPos p (glog T.mkNoSrcPos p)
        (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !+ p) fz
          (T.uap1 T.mkNoSrcPos p (gsqrt T.mkNoSrcPos p)
            (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !+ p)
              (T.uap1 T.mkNoSrcPos p
                (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
                (T.conInteger T.mkNoSrcPos p 1))
              (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !* p) fz fz))))
    
  
  gacosh pacosh p =
    T.ufun1 a124v5v124v55acosh pacosh p hacosh
    where
    
    hacosh fz p =
      T.uap1 T.mkNoSrcPos p (glog T.mkNoSrcPos p)
        (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !+ p) fz
          (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !* p)
            (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !+ p) fz
              (T.uap1 T.mkNoSrcPos p
                (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
                (T.conInteger T.mkNoSrcPos p 1)))
            (T.uap1 T.mkNoSrcPos p (gsqrt T.mkNoSrcPos p)
              (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !/ p)
                (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !- p) fz
                  (T.uap1 T.mkNoSrcPos p
                    (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
                    (T.conInteger T.mkNoSrcPos p 1)))
                (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !+ p) fz
                  (T.uap1 T.mkNoSrcPos p
                    (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
                    (T.conInteger T.mkNoSrcPos p 1)))))))
    
  
  gatanh patanh p =
    T.ufun1 a125v5v125v46atanh patanh p hatanh
    where
    
    hatanh fz p =
      T.uap1 T.mkNoSrcPos p (glog T.mkNoSrcPos p)
        (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !/ p)
          (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !+ p)
            (T.uap1 T.mkNoSrcPos p
              (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
              (T.conInteger T.mkNoSrcPos p 1)) fz)
          (T.uap1 T.mkNoSrcPos p (gsqrt T.mkNoSrcPos p)
            (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !- p)
              (T.uap1 T.mkNoSrcPos p
                (Hat.PreludeBasic.gfromInteger T.mkNoSrcPos p)
                (T.conInteger T.mkNoSrcPos p 1))
              (T.uap2 T.mkNoSrcPos p (T.mkNoSrcPos !* p) fz fz))))
    
  

tData_Complex = T.mkModule "Data.Complex" "Data/Complex.hs" Prelude.False

(+:+) = T.mkConstructor tData_Complex 320043 320044 24 2 ":+"

(+%$=+!=%$=+#==) =
  T.mkVariable tData_Complex 320060 320061 3 2 "==" Prelude.False

a32v64v32v67readsPrec =
  T.mkVariable tData_Complex 320064 320067 3 1 "readsPrec" Prelude.False

a32v70v32v73showsPrec =
  T.mkVariable tData_Complex 320070 320073 3 2 "showsPrec" Prelude.False

arealPart =
  T.mkVariable tData_Complex 390001 390022 3 1 "realPart" Prelude.False

aimagPart =
  T.mkVariable tData_Complex 400001 400022 3 1 "imagPart" Prelude.False

aconjugate =
  T.mkVariable tData_Complex 430001 430028 3 1 "conjugate" Prelude.False

amkPolar = T.mkVariable tData_Complex 460001 460050 3 2 "mkPolar" Prelude.False

acis = T.mkVariable tData_Complex 490001 490042 3 1 "cis" Prelude.False

apolar = T.mkVariable tData_Complex 520001 520042 3 1 "polar" Prelude.False

amagnitude =
  T.mkVariable tData_Complex 550001 580034 3 1 "magnitude" Prelude.False

aphase = T.mkVariable tData_Complex 610001 620028 3 1 "phase" Prelude.False

(++>=#$=+>=#$+) =
  T.mkVariable tData_Complex 690012 690012 26 2 "+" Prelude.False

(+^!=#$=^!=#$-) =
  T.mkVariable tData_Complex 700012 700012 26 2 "-" Prelude.False

(+^#=#$=^#=#$*) =
  T.mkVariable tData_Complex 710012 710012 30 2 "*" Prelude.False

a72v5v72v47negate =
  T.mkVariable tData_Complex 720005 720047 3 1 "negate" Prelude.False

a73v5v73v43abs =
  T.mkVariable tData_Complex 730005 730043 3 1 "abs" Prelude.False

a74v5v75v60signum =
  T.mkVariable tData_Complex 740005 750060 3 1 "signum" Prelude.False

a76v5v76v45fromInteger =
  T.mkVariable tData_Complex 760005 760045 3 1 "fromInteger" Prelude.False

(+^>=#$=^>=#$/) =
  T.mkVariable tData_Complex 790012 790012 30 2 "/" Prelude.False

a85v5v85v46fromRational =
  T.mkVariable tData_Complex 850005 850046 3 1 "fromRational" Prelude.False

a88v5v88v29pi = T.mkVariable tData_Complex 880005 880029 3 0 "pi" Prelude.False

a89v5v90v40exp =
  T.mkVariable tData_Complex 890005 900040 3 1 "exp" Prelude.False

a91v5v91v50log =
  T.mkVariable tData_Complex 910005 910050 3 1 "log" Prelude.False

a93v5v97v67sqrt =
  T.mkVariable tData_Complex 930005 970067 3 1 "sqrt" Prelude.False

a99v5v99v54sin =
  T.mkVariable tData_Complex 990005 990054 3 1 "sin" Prelude.False

a100v5v100v57cos =
  T.mkVariable tData_Complex 1000005 1000057 3 1 "cos" Prelude.False

a101v5v105v42tan =
  T.mkVariable tData_Complex 1010005 1050042 3 1 "tan" Prelude.False

a107v5v107v55sinh =
  T.mkVariable tData_Complex 1070005 1070055 3 1 "sinh" Prelude.False

a108v5v108v54cosh =
  T.mkVariable tData_Complex 1080005 1080054 3 1 "cosh" Prelude.False

a109v5v113v42tanh =
  T.mkVariable tData_Complex 1090005 1130042 3 1 "tanh" Prelude.False

a115v5v116v70asin =
  T.mkVariable tData_Complex 1150005 1160070 3 1 "asin" Prelude.False

a117v5v119v54acos =
  T.mkVariable tData_Complex 1170005 1190054 3 1 "acos" Prelude.False

a120v5v121v68atan =
  T.mkVariable tData_Complex 1200005 1210068 3 1 "atan" Prelude.False

a123v5v123v42asinh =
  T.mkVariable tData_Complex 1230005 1230042 3 1 "asinh" Prelude.False

a124v5v124v55acosh =
  T.mkVariable tData_Complex 1240005 1240055 3 1 "acosh" Prelude.False

a125v5v125v46atanh =
  T.mkVariable tData_Complex 1250005 1250046 3 1 "atanh" Prelude.False

a57v27v57v59k = T.mkVariable tData_Complex 570027 570059 3 0 "k" Prelude.True

a58v27v58v34mk = T.mkVariable tData_Complex 580027 580034 3 0 "mk" Prelude.True

a75v46v75v60r = T.mkVariable tData_Complex 750046 750060 3 0 "r" Prelude.True

a80v34v80v54x'' =
  T.mkVariable tData_Complex 800034 800054 3 0 "x''" Prelude.True

a81v34v81v54y'' =
  T.mkVariable tData_Complex 810034 810054 3 0 "y''" Prelude.True

a82v34v82v71k = T.mkVariable tData_Complex 820034 820071 3 0 "k" Prelude.True

a83v34v83v54d = T.mkVariable tData_Complex 830034 830054 3 0 "d" Prelude.True

a90v29v90v40expx =
  T.mkVariable tData_Complex 900029 900040 3 0 "expx" Prelude.True

a95v30v95v30u = T.mkVariable tData_Complex 950030 950030 3 0 "u" Prelude.True

a95v32v95v32v = T.mkVariable tData_Complex 950032 950032 3 0 "v" Prelude.True

a96v29v96v49v' = T.mkVariable tData_Complex 960029 960049 3 0 "v'" Prelude.True

a97v29v97v67u' = T.mkVariable tData_Complex 970029 970067 3 0 "u'" Prelude.True

a102v29v102v41sinx =
  T.mkVariable tData_Complex 1020029 1020041 3 0 "sinx" Prelude.True

a103v29v103v41cosx =
  T.mkVariable tData_Complex 1030029 1030041 3 0 "cosx" Prelude.True

a104v29v104v42sinhy =
  T.mkVariable tData_Complex 1040029 1040042 3 0 "sinhy" Prelude.True

a105v29v105v42coshy =
  T.mkVariable tData_Complex 1050029 1050042 3 0 "coshy" Prelude.True

a110v29v110v41siny =
  T.mkVariable tData_Complex 1100029 1100041 3 0 "siny" Prelude.True

a111v29v111v41cosy =
  T.mkVariable tData_Complex 1110029 1110041 3 0 "cosy" Prelude.True

a112v29v112v42sinhx =
  T.mkVariable tData_Complex 1120029 1120042 3 0 "sinhx" Prelude.True

a113v29v113v42coshx =
  T.mkVariable tData_Complex 1130029 1130042 3 0 "coshx" Prelude.True

a116v31v116v32x' =
  T.mkVariable tData_Complex 1160031 1160032 3 0 "x'" Prelude.True

a116v35v116v36y' =
  T.mkVariable tData_Complex 1160035 1160036 3 0 "y'" Prelude.True

a118v30v118v32x'' =
  T.mkVariable tData_Complex 1180030 1180032 3 0 "x''" Prelude.True

a118v35v118v37y'' =
  T.mkVariable tData_Complex 1180035 1180037 3 0 "y''" Prelude.True

a119v30v119v31x' =
  T.mkVariable tData_Complex 1190030 1190031 3 0 "x'" Prelude.True

a119v34v119v35y' =
  T.mkVariable tData_Complex 1190034 1190035 3 0 "y'" Prelude.True

a121v30v121v31x' =
  T.mkVariable tData_Complex 1210030 1210031 3 0 "x'" Prelude.True

a121v34v121v35y' =
  T.mkVariable tData_Complex 1210034 1210035 3 0 "y'" Prelude.True
