module Hat.Foreign.BuiltinTypes
  ( Ptr,        aPtr,        toPtr,        fromPtr
  , FunPtr,     aFunPtr,     toFunPtr,     fromFunPtr
  , StablePtr,  aStablePtr,  toStablePtr,  fromStablePtr
  , ForeignPtr, aForeignPtr, toForeignPtr, fromForeignPtr
  ) where

import qualified Foreign.Ptr
import qualified Foreign.StablePtr
import qualified Foreign.ForeignPtr
import Hat.Hat as T
import Hat.Prelude
#if __GLASGOW_HASKELL__
import GHC.Base (unsafeCoerce#)
unsafeCoerce = GHC.Base.unsafeCoerce#
#elif __NHC__
import NonStdUnsafeCoerce (unsafeCoerce)
#endif


newtype Ptr a        = Ptr        (Foreign.Ptr.Ptr               (R a))
newtype FunPtr a     = FunPtr     (Foreign.Ptr.FunPtr            (R a))
newtype StablePtr a  = StablePtr  (Foreign.StablePtr.StablePtr   (R a))
newtype ForeignPtr a = ForeignPtr (Foreign.ForeignPtr.ForeignPtr (R a))

aPtr, aFunPtr, aStablePtr, aForeignPtr :: RefAtom
aPtr        = mkAbstract "Ptr"
aFunPtr     = mkAbstract "FunPtr"
aStablePtr  = mkAbstract "StablePtr"
aForeignPtr = mkAbstract "ForeignPtr"

toPtr :: (RefExp -> R a -> b) -> RefExp -> R (Ptr a) -> Foreign.Ptr.Ptr b
toPtr f h (R (Ptr e) _) = fakemap (f h) e

fromPtr :: (RefExp -> a -> R b) -> RefExp -> Foreign.Ptr.Ptr a -> R (Ptr b)
fromPtr f h e = R (Ptr (fakemap (f h) e))
                  (T.mkValueUse h mkNoSrcPos aPtr)

toFunPtr :: (RefExp -> R a -> b)
            -> RefExp -> R (FunPtr a) -> Foreign.Ptr.FunPtr b
toFunPtr f h (R (FunPtr e) _) = fakemap (f h) e

fromFunPtr :: (RefExp -> a -> R b)
              -> RefExp -> Foreign.Ptr.FunPtr a -> R (FunPtr b)
fromFunPtr f h e = R (FunPtr (fakemap (f h) e))
                  (T.mkValueUse h mkNoSrcPos aFunPtr)

toStablePtr :: (RefExp -> R a -> b)
               -> RefExp -> R (StablePtr a) -> Foreign.StablePtr.StablePtr b
toStablePtr f h (R (StablePtr e) _) = fakemap (f h) e

fromStablePtr :: (RefExp -> a -> R b)
                 -> RefExp -> Foreign.StablePtr.StablePtr a -> R (StablePtr b)
fromStablePtr f h e = R (StablePtr (fakemap (f h) e))
                  (T.mkValueUse h mkNoSrcPos aStablePtr)

toForeignPtr :: (RefExp -> R a -> b)
                -> RefExp -> R (ForeignPtr a) -> Foreign.ForeignPtr.ForeignPtr b
toForeignPtr f h (R (ForeignPtr e) _) = fakemap (f h) e

fromForeignPtr :: (RefExp -> a -> R b) -> RefExp
                  -> Foreign.ForeignPtr.ForeignPtr a -> R (ForeignPtr b)
fromForeignPtr f h e = R (ForeignPtr (fakemap (f h) e))
                         (T.mkValueUse h mkNoSrcPos aForeignPtr)


fakemap :: (a -> b) -> c a -> c b
fakemap f e = unsafeCoerce e

