import Control.Applicative ((<|>))
import Control.Monad (forM_, MonadPlus(mzero))
import Data.Char (isDigit, isLetter)
import Data.List (foldl')
import System.Environment (getArgs)
import qualified Data.Attoparsec.Char8 as AB
import qualified Data.Attoparsec.Text as A
import qualified Data.ByteString.Char8 as B
import qualified Data.Text as T
import qualified Data.Text.IO as T
import qualified Data.Text.Read as TR
import qualified Text.ParserCombinators.Parsec as P

attoparsec_builtin args = do
  forM_ args $ \arg -> do
    input <- B.readFile arg
    case AB.parse (AB.many1 (AB.char '#' >> p)) input `AB.feed` B.empty of
      AB.Done _ xs -> print (sum xs :: Double)
      what        -> print what
 where
  p = AB.double

----------------------------------------------------------------------

attoparsec_text_builtin args = do
  forM_ args $ \arg -> do
    input <- T.readFile arg
    case A.parse (A.many1 (A.char '#' >> p)) input `A.feed` T.empty of
      A.Done _ xs -> print (sum xs :: Double)
      what        -> print what
 where
  p = A.double

----------------------------------------------------------------------

attoparsec_text_laforge args = do
  forM_ args $ \arg -> do
    input <- T.readFile arg
    case A.parse (A.many1 (A.char '#' >> p)) input `A.feed` T.empty of
      A.Done _ xs -> print (sum xs :: Double)
      what        -> print what
 where
  p = do
   i <- A.takeWhile isDigit
   f <- A.option T.empty (A.char '.' >> A.takeWhile1 isDigit)
   if (T.null i && T.null f)
     then mzero
     else return $ fromIntegral (dec i) +
                   fromIntegral (dec f) / fromIntegral (10 ^ (T.length f))
   where
   dec = T.foldl' (\acc c -> acc * 10 + fromEnum c - 48) 0

attoparsec_text_laforge_discarding args = do
  forM_ args $ \arg -> do
    input <- T.readFile arg
    case A.parse (A.many1 (A.char '#' >> p)) input `A.feed` T.empty of
      A.Done _ xs -> print (length xs)
      what        -> print what
 where
  p = do
   i <- A.takeWhile isDigit
   f <- A.option T.empty (A.char '.' >> A.takeWhile1 isDigit)
   return ()

----------------------------------------------------------------------

parsec_laforge args =
  forM_ args $ \arg -> do
    input <- readFile arg
    case P.parse (P.many1 (P.char '#' >> p)) "" input of
      Left err -> print err
      Right xs -> print (sum xs :: Double)
 where
  p = do
   i <- P.many P.digit
   f <- P.option "" (P.char '.' >> P.many1 P.digit)
   if (null i && null f)
     then mzero
     else return $ fromIntegral (dec i) +
                   fromIntegral (dec f) / fromIntegral (10 ^ (length f))
   where
   dec = foldl' (\acc c -> acc * 10 + fromEnum c - 48) 0

parsec_laforge_discarding args =
  forM_ args $ \arg -> do
    input <- readFile arg
    case P.parse (P.many1 (P.char '#' >> p)) "" input of
      Left err -> print err
      Right xs -> print (length xs :: Int)
 where
  p = do
   i <- P.many P.digit
   f <- P.option "" (P.char '.' >> P.many1 P.digit)
   return ()

----------------------------------------------------------------------

main = do
  args <- getArgs
  case args of
    ("attoparsec_builtin":xs) -> attoparsec_builtin xs
    ("attoparsec_text_builtin":xs) -> attoparsec_text_builtin xs
    ("attoparsec_text_laforge":xs) -> attoparsec_text_laforge xs
    ("attoparsec_text_laforge_discarding":xs) -> attoparsec_text_laforge_discarding xs
    ("parsec_laforge":xs) -> parsec_laforge xs
    ("parsec_laforge_discarding":xs) -> parsec_laforge_discarding xs
    [] -> do
      putStrLn "Usage: ... [attoparsec_text_builtin|attoparsec_text_laforge|parsec_laforge] inputs"
      putStrLn "Usage: ... [attoparsec_text_laforge_discarding|parsec_laforge_discarding] inputs"
