/*
 * happydigger - program for cataloging archaeological finds
 * Copyright (C) 2004, 2005, 2007 Joop Stakenborg <pg4i@amsat.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 */

#include <gtk/gtk.h>
#include <stdlib.h>
#include "utils.h"
#include "db.h"

extern GtkWidget *window;

gboolean
on_listwindow_delete_event             (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
	GtkWidget *handlebox;

	handlebox = lookup_widget (window, "handlebox1");
	gtk_widget_show (handlebox);
	return FALSE;
}

/* a row is selected, update the record window */
void
on_list_select_row (GtkTreeSelection *selection, gpointer user_data)
{
	GtkWidget *entrywidget;
	GtkTreeModel *model;
	GtkTreeIter iter;
	gchar *entry;

	if (gtk_tree_selection_get_selected (selection, &model, &iter))
	{
		/* get record number and show the record */
		gtk_tree_model_get (model, &iter, 0, &entry, -1);
		load_from_db (atoi(entry));
		entrywidget = lookup_widget (window, "entry");
		gtk_entry_set_text (GTK_ENTRY(entrywidget), entry);
	}
}
