/**
 *
 * @file     xmmsctrl.c
 * @author   Aleix Conchillo Flaque <aleix@member.fsf.org>
 * @date     Thu Aug 07, 2003 21:16
 * @brief    XMMS GNOME applet control functions
 *
 * $Id$
 *
 * @if copyright
 *
 * Copyright (C) 2003 Aleix Conchillo Flaque
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * @endif
 */

#include "xmmsctrl.h"

#include "callbacks.h"
#include "interface.h"

#include <xmms/xmmsctrl.h>

#include <stdlib.h>
#include <math.h>
#include <time.h>


/* This function has been copied from the gkrellmms plugin. */
void
xmms_start(XMMSData *xmms)
{
    static gchar *exec_cmd = "xmms";
    static gchar *msg_error = _("Sorry, unable to launch XMMS.");
    gint timer;
    time_t lt;

    if (xmms_remote_is_running(xmms->session))
    {
        return;
    }

    gchar *exec_this = g_strdup_printf("%s > /dev/null 2>&1 &", exec_cmd);

    if (system(exec_this))
    {
        gui_show_error(xmms, msg_error);
    }

    timer = time(&lt);
    while (!xmms_remote_is_running(xmms->session) && ((time(&lt) - timer) < 4))
    {
        usleep(0);
    }

    if (xmms_remote_is_running(xmms->session))
    {
        xmms_remote_main_win_toggle(xmms->session, FALSE);
        xmms_remote_pl_win_toggle(xmms->session, FALSE);
        xmms_remote_eq_win_toggle(xmms->session, FALSE);
    }
    else
    {
        gui_show_error(xmms, msg_error);
    }
}

void
xmms_prev(XMMSData *xmms)
{
    if (xmms_remote_is_running(xmms->session))
    {
        xmms_remote_playlist_prev(xmms->session);
    }
    gui_update(xmms);
}

void
xmms_play_pause(XMMSData *xmms)
{
    if (!xmms_remote_is_running(xmms->session))
    {
        xmms_start(xmms);
    }

    if (xmms_remote_is_running(xmms->session))
    {
        if (xmms_remote_is_playing(xmms->session)
            && !xmms_remote_is_paused(xmms->session))
        {
            xmms_remote_pause(xmms->session);
        }
        else
        {
            xmms_remote_play(xmms->session);
        }
    }

    gui_update(xmms);
}

void
xmms_stop(XMMSData *xmms)
{
    if (xmms_remote_is_running(xmms->session))
    {
        xmms_remote_stop(xmms->session);
    }
    gui_update(xmms);
}

void
xmms_next(XMMSData *xmms)
{
    if (xmms_remote_is_running(xmms->session))
    {
        xmms_remote_playlist_next(xmms->session);
    }
    gui_update(xmms);
}

void
xmms_eject(XMMSData *xmms)
{
    if (xmms_remote_is_running(xmms->session))
    {
        xmms_remote_eject(xmms->session);
    }
    gui_update(xmms);
}

void
xmms_seek(XMMSData *xmms, gdouble t)
{
    if (xmms_remote_is_running(xmms->session))
    {
        gint pos;
        gint new_time;
        gint total_time;

        pos = xmms_remote_get_playlist_pos(xmms->session);
        total_time = xmms_remote_get_playlist_time(xmms->session, pos);
        new_time = ceil(total_time * t) - 1;
        xmms_remote_jump_to_time(xmms->session, new_time);
    }
    gui_update(xmms);
}

void
xmms_main_win(XMMSData *xmms)
{
    if (xmms_remote_is_running(xmms->session))
    {
        xmms_remote_main_win_toggle(xmms->session,
                                    !xmms_remote_is_main_win(xmms->session));
    }
}

void
xmms_pl_win(XMMSData *xmms)
{
    if (xmms_remote_is_running(xmms->session))
    {
        xmms_remote_pl_win_toggle(xmms->session,
                                  !xmms_remote_is_pl_win(xmms->session));
    }
}

void
xmms_eq_win(XMMSData *xmms)
{
    if (xmms_remote_is_running(xmms->session))
    {
        xmms_remote_eq_win_toggle(xmms->session,
                                  !xmms_remote_is_eq_win(xmms->session));
    }
}

void
xmms_show_hide(XMMSData *xmms)
{
    if (xmms_remote_is_running(xmms->session))
    {
        gboolean show_hide;

        show_hide = !(xmms_remote_is_main_win(xmms->session)
                      | xmms_remote_is_pl_win(xmms->session)
                      | xmms_remote_is_eq_win(xmms->session));

        xmms_remote_main_win_toggle(xmms->session, show_hide);
        xmms_remote_pl_win_toggle(xmms->session, show_hide);
        xmms_remote_eq_win_toggle(xmms->session, show_hide);
    }
}
