/*
 * Copyright (C) 2002-2005 the xine-project
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 * $Id: log_window.c,v 1.18 2005/06/02 22:16:52 dsalt Exp $
 *
 * log window implementation
 */

#include "globals.h"

#include <X11/Xlib.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <glib.h>
#include <stdio.h>
#include <string.h>

#include "log_window.h"
#include "utils.h"

#define MAX_TEXT 100

static GtkWidget *win;
static GtkTextView *texts[MAX_TEXT];
static gboolean is_visible;

static void update_log_window () {

  int i;

  for (i = 0; i < xine_get_log_section_count (xine); ++i)
  {
    int j;
    char **log;
    GtkTextBuffer *buffer = gtk_text_view_get_buffer (texts[i]);
    GtkTextIter start, end;

    gtk_text_buffer_get_start_iter (buffer, &start);
    gtk_text_buffer_get_end_iter (buffer, &end);
    gtk_text_buffer_delete (buffer, &start, &end);

    log = (char **) xine_get_log (xine, i);

    if (log)
      for (j = 0; log[j]; ++j)
	gtk_text_buffer_insert (buffer, &end, log[j], -1);
  }
}

static void response_cb (GtkDialog *dbox, int response, gpointer data)
{
  switch (response)
  {
  case GTK_RESPONSE_YES:
    update_log_window ();
    break;
  default:
    is_visible = FALSE;
    gtk_widget_hide (win);
  }
}

static JSBool js_log_show (JSContext *cx, JSObject *obj, uintN argc, 
			   jsval *argv, jsval *rval) {

  /* se_t *se = (se_t *) JS_GetContextPrivate(cx); */

  se_log_fncall ("log_show");

  log_window_show ();
  
  return JS_TRUE;
}

void log_window_init () {

  GtkWidget *tabs, *label;
  int        i;
  const char *const *names;

  is_visible = FALSE;

  /* 
   * window 
   */

  win = gtk_dialog_new_with_buttons (_("xine engine log output"), NULL, 0,
				GTK_STOCK_REFRESH, GTK_RESPONSE_YES,
				GTK_STOCK_CLOSE, GTK_RESPONSE_DELETE_EVENT,
				NULL);
  g_signal_connect (G_OBJECT(win), "response", G_CALLBACK (response_cb), NULL);
  gtk_window_set_default_size (GTK_WINDOW (win), 640, 400);
  hide_on_delete (win, &is_visible);

  /*
   * notebook
   */

  tabs = gtk_notebook_new();

  names = xine_get_log_names (xine);
  for (i=0; i<xine_get_log_section_count (xine); i++) {

    GtkWidget *scroller;

    label = gtk_label_new (names[i]);
    texts[i] = GTK_TEXT_VIEW(gtk_text_view_new ());
    gtk_text_view_set_editable (texts[i], FALSE);
    gtk_text_view_set_cursor_visible (texts[i], FALSE);
    gtk_text_view_set_left_margin (texts[i], 2);
    gtk_text_view_set_right_margin (texts[i], 2);

    scroller = gtk_scrolled_window_new (NULL, NULL);
    gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scroller),
				    GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
    gtk_scrolled_window_add_with_viewport (GTK_SCROLLED_WINDOW (scroller),
					   GTK_WIDGET(texts[i]));

    gtk_notebook_append_page (GTK_NOTEBOOK (tabs),
			      scroller, label);
  }
  gtk_box_pack_start (GTK_BOX(GTK_DIALOG(win)->vbox), tabs, TRUE, TRUE, 2);

  /* script engine functions */

  se_defun (gse, NULL, "log_show", js_log_show, 0, 0,
	    SE_GROUP_DIALOGUE, NULL, NULL);
}

void log_window_show (void) {

  if (is_visible) {
    is_visible = FALSE;
    gtk_widget_hide (win);
  } else {
    is_visible = TRUE;
    window_show (win, NULL);
    update_log_window ();
  }
}



