#include <stddef.h>

#include <stdlib.h>

#define GD_HAVE_LONG_LONG
#include "runtime.h"

#include <math.h>

extern descriptor_t dylanZtrue;	/* #t */

#define obj_True dylanZtrue.heapptr
extern descriptor_t dylanZfalse;	/* #f */

#define obj_False dylanZfalse.heapptr

#define GENERAL_ENTRY(func) \
    ((entry_t)SLOT(func, void *, 8))
#define GENERIC_ENTRY(func) \
    ((entry_t)SLOT(func, void *, 32))

#define GD_CTASSERT(name, x) \
    typedef char gd_assert_ ## name[(x) ? 1 : -1];
#define GD_VERIFY_SIZE_ASSUMPTION(name, type, size)\
    GD_CTASSERT(size_ ## name, sizeof(type) == (size))
#define GD_VERIFY_ALIGN_ASSUMPTION(name, type, align)\
    typedef struct { char c; type x; } \
      gd_align_ ## name; \
    GD_CTASSERT(align_ ## name, offsetof(gd_align_ ## name, x) == (align))

GD_VERIFY_SIZE_ASSUMPTION(general, descriptor_t, 8);
GD_VERIFY_ALIGN_ASSUMPTION(general, descriptor_t, 4);
GD_VERIFY_SIZE_ASSUMPTION(heap, heapptr_t, 4);
GD_VERIFY_ALIGN_ASSUMPTION(heap, heapptr_t, 4);
GD_VERIFY_SIZE_ASSUMPTION(boolean, int, 4);
GD_VERIFY_ALIGN_ASSUMPTION(boolean, int, 4);
GD_VERIFY_SIZE_ASSUMPTION(long_long, long long, 8);
GD_VERIFY_ALIGN_ASSUMPTION(long_long, long long, 4);
GD_VERIFY_SIZE_ASSUMPTION(long, long, 4);
GD_VERIFY_ALIGN_ASSUMPTION(long, long, 4);
GD_VERIFY_SIZE_ASSUMPTION(int, int, 4);
GD_VERIFY_ALIGN_ASSUMPTION(int, int, 4);
GD_VERIFY_SIZE_ASSUMPTION(uint, unsigned int, 4);
GD_VERIFY_ALIGN_ASSUMPTION(uint, unsigned int, 4);
GD_VERIFY_SIZE_ASSUMPTION(short, short, 2);
GD_VERIFY_ALIGN_ASSUMPTION(short, short, 2);
GD_VERIFY_SIZE_ASSUMPTION(ushort, unsigned short, 2);
GD_VERIFY_ALIGN_ASSUMPTION(ushort, unsigned short, 2);
GD_VERIFY_SIZE_ASSUMPTION(float, float, 4);
GD_VERIFY_ALIGN_ASSUMPTION(float, float, 4);
GD_VERIFY_SIZE_ASSUMPTION(double, double, 8);
GD_VERIFY_ALIGN_ASSUMPTION(double, double, 4);
GD_VERIFY_SIZE_ASSUMPTION(long_double, long double, 12);
GD_VERIFY_ALIGN_ASSUMPTION(long_double, long double, 4);
GD_VERIFY_SIZE_ASSUMPTION(ptr, void *, 4);
GD_VERIFY_ALIGN_ASSUMPTION(ptr, void *, 4);

/* Top level form. */

#include ".//sockets-helper.h"

/* form at {<known-source-location> 0x08b9eb68,
   source: {<source-file> 0x08920948, name: "macros.dylan"},
   start-line: 743,
   start-column: 54,
   end-line: 743,
   end-column: 64} */
void networkZLINE_743(descriptor_t *orig_sp)
{
    descriptor_t *cluster_0_top;


    /* #line 743 "./macros.dylan" */
    return;
}


/* Define Constant <nfds-t> */

/* <nfds-t> is <integer> */


/* Define Class <pollfd> */

/* <pollfd> is <pollfd> */

extern void dylanZdylan_visceraZmissing_required_init_keyword_error_FUN(descriptor_t *orig_sp, heapptr_t A0, heapptr_t A1);	/* missing-required-init-keyword-error */

extern struct heapobj SYM_pointer_HEAP;

extern struct heapobj networkZnetwork_internalZCLS_pollfd_HEAP;

/* maker for <pollfd> */
void * networkZnetwork_internalZCLS_pollfd_MAKER_FUN(descriptor_t *orig_sp, void * A_pointer /* pointer */, int A_pointer_suppliedQUERY /* pointer-supplied? */)
{
    descriptor_t *cluster_0_top;


    /* #line 7 "./sockets-api.dylan" */
    if (A_pointer_suppliedQUERY) {
	return A_pointer;
    }
    else {
	/* missing-required-init-keyword-error */
	dylanZdylan_visceraZmissing_required_init_keyword_error_FUN(orig_sp, &SYM_pointer_HEAP, &networkZnetwork_internalZCLS_pollfd_HEAP);
	not_reached();
    }
}

extern struct heapobj dylanZdylan_visceraZCLS_symbol_HEAP;

extern struct heapobj dylanZdylan_visceraZCLS_raw_pointer_HEAP;

extern void dylanZdylan_visceraZtype_error_with_location_FUN(descriptor_t *orig_sp, descriptor_t A0, heapptr_t A1, descriptor_t A2);	/* type-error-with-location */

extern struct heapobj networkZstr_ROOT;

extern descriptor_t networkZliteral;	/* proxy for <pollfd> */

extern void dylanZdylan_visceraZodd_number_of_keywordSLASHvalue_arguments_error_FUN(descriptor_t *orig_sp);	/* odd-number-of-keyword/value-arguments-error */

/* general-entry for maker for <pollfd> */
descriptor_t * networkZnetwork_internalZCLS_pollfd_MAKER_GENERAL(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    void * L_pointer; /* pointer */
    int L_pointer_suppliedQUERY; /* pointer-supplied? */
    long L_index; /* index */
    descriptor_t L_temp; /* temp */
    descriptor_t L_value; /* value */
    descriptor_t L_temp_2;
    descriptor_t L_temp_3;
    void * L_result0; /* result0 */
    descriptor_t L_temp_4;

    /* #line {Class <unknown-source-location>} */

    /* #line 126 "./cmp.dylan" */

    /* #line 209 "./num.dylan" */
    if (((A_nargs & 1) == 0)) {
	/* #line {Class <unknown-source-location>} */
	L_args = ((void *)(orig_sp - A_nargs));
	L_pointer = 0;
	L_pointer_suppliedQUERY = FALSE;
	L_index = (A_nargs - 2);
	while (1) {
	    if ((L_index < 0)) {
		goto block0;
	    }
	    else {
		L_temp = (((descriptor_t *)L_args)[L_index]);

		/* #line 386 "./condition.dylan" */
		if ((&dylanZdylan_visceraZCLS_symbol_HEAP == SLOT(L_temp.heapptr, heapptr_t, 0))) {
		    /* #line {Class <unknown-source-location>} */
		    L_value = (((descriptor_t *)L_args)[(L_index + 1)]);
		    if ((L_temp.heapptr == &SYM_pointer_HEAP)) {

			/* #line 386 "./condition.dylan" */
			if ((&dylanZdylan_visceraZCLS_raw_pointer_HEAP == SLOT(L_value.heapptr, heapptr_t, 0))) {
			    /* #line {Class <unknown-source-location>} */
			    L_pointer = L_value.dataword.ptr;
			    L_pointer_suppliedQUERY = TRUE;
			}
			else {

			    /* #line 389 "./condition.dylan" */
			    L_temp_2.heapptr = &networkZstr_ROOT;
			    L_temp_2.dataword.l = 0;
			    /* type-error-with-location */
			    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_value, &dylanZdylan_visceraZCLS_raw_pointer_HEAP, L_temp_2);
			    not_reached();
			}
		    }
		    /* #line {Class <unknown-source-location>} */
		    L_index = (L_index - 2);
		}
		else {

		    /* #line 389 "./condition.dylan" */
		    L_temp_3.heapptr = &networkZstr_ROOT;
		    L_temp_3.dataword.l = 0;
		    /* type-error-with-location */
		    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp, &dylanZdylan_visceraZCLS_symbol_HEAP, L_temp_3);
		    not_reached();
		}
	    }
	}
      block0:;
	/* #line {Class <unknown-source-location>} */
	orig_sp = L_args;
	/* maker for <pollfd> */
	L_result0 = networkZnetwork_internalZCLS_pollfd_MAKER_FUN(orig_sp, L_pointer, L_pointer_suppliedQUERY);
	L_temp_4.heapptr = networkZliteral.heapptr;
	L_temp_4.dataword.ptr = L_result0;
	orig_sp[0] = L_temp_4;
	return orig_sp + 1;
    }
    else {
	/* odd-number-of-keyword/value-arguments-error */
	dylanZdylan_visceraZodd_number_of_keywordSLASHvalue_arguments_error_FUN(orig_sp);
	not_reached();
    }
}


/* Define Sealed Domain make (singleton(<pollfd>)) */


/* {Implicit} Define Generic get-fd */

/* get-fd is get-fd */


/* Define Method get-fd{<pollfd>} */

/* get-fd{<pollfd>} */
long networkZnetwork_internalZget_fd_METH(descriptor_t *orig_sp, void * A_ptr /* ptr */, heapptr_t A1)
{
    descriptor_t *cluster_0_top;


    /* #line 198 "./melange.dylan" */

    /* #line 91 "./rawptr.dylan" */
    return (*(long *)((char *)A_ptr + 0 ));
}

extern descriptor_t networkZliteral_2;	/* proxy for <integer> */

/* generic-entry for get-fd{<pollfd>} */
descriptor_t * networkZnetwork_internalZget_fd_METH_GENERIC(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    descriptor_t L_arg; /* arg */
    void * L_arg_2; /* arg */
    long L_result0; /* result0 */
    descriptor_t L_temp;

    /* #line {Class <unknown-source-location>} */
    L_args = ((void *)(orig_sp - 1));
    L_arg = (((descriptor_t *)L_args)[0]);
    L_arg_2 = L_arg.dataword.ptr;
    orig_sp = L_args;
    /* get-fd{<pollfd>} */
    L_result0 = networkZnetwork_internalZget_fd_METH(orig_sp, L_arg_2, A_next_method_info);
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* {Implicit} Define Generic get-fd-setter */

/* get-fd-setter is get-fd-setter */


/* Define Method get-fd-setter{<integer>, <pollfd>} */

/* get-fd-setter{<integer>, <pollfd>} */
long networkZnetwork_internalZget_fd_setter_METH(descriptor_t *orig_sp, long A_value /* value */, void * A_ptr /* ptr */, heapptr_t A2)
{
    descriptor_t *cluster_0_top;


    /* #line 97 "./rawptr.dylan" */
    *(long *)((char *)A_ptr + 0) = A_value;
    return A_value;
}

/* generic-entry for get-fd-setter{<integer>, <pollfd>} */
descriptor_t * networkZnetwork_internalZget_fd_setter_METH_GENERIC(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    descriptor_t L_arg; /* arg */
    descriptor_t L_arg_2; /* arg */
    long L_arg_3; /* arg */
    void * L_arg_4; /* arg */
    long L_result0; /* result0 */
    descriptor_t L_temp;

    /* #line {Class <unknown-source-location>} */
    L_args = ((void *)(orig_sp - 2));
    L_arg = (((descriptor_t *)L_args)[0]);
    L_arg_2 = (((descriptor_t *)L_args)[1]);
    L_arg_3 = L_arg.dataword.l;
    L_arg_4 = L_arg_2.dataword.ptr;
    orig_sp = L_args;
    /* get-fd-setter{<integer>, <pollfd>} */
    L_result0 = networkZnetwork_internalZget_fd_setter_METH(orig_sp, L_arg_3, L_arg_4, A_next_method_info);
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* {Implicit} Define Generic get-events */

/* get-events is get-events */


/* Define Method get-events{<pollfd>} */

/* get-events{<pollfd>} */
long networkZnetwork_internalZget_events_METH(descriptor_t *orig_sp, void * A_ptr /* ptr */, heapptr_t A1)
{
    descriptor_t *cluster_0_top;


    /* #line 172 "./melange.dylan" */

    /* #line 91 "./rawptr.dylan" */
    return (*(short *)((char *)A_ptr + 4 ));
}

/* generic-entry for get-events{<pollfd>} */
descriptor_t * networkZnetwork_internalZget_events_METH_GENERIC(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    descriptor_t L_arg; /* arg */
    void * L_arg_2; /* arg */
    long L_result0; /* result0 */
    descriptor_t L_temp;

    /* #line {Class <unknown-source-location>} */
    L_args = ((void *)(orig_sp - 1));
    L_arg = (((descriptor_t *)L_args)[0]);
    L_arg_2 = L_arg.dataword.ptr;
    orig_sp = L_args;
    /* get-events{<pollfd>} */
    L_result0 = networkZnetwork_internalZget_events_METH(orig_sp, L_arg_2, A_next_method_info);
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* {Implicit} Define Generic get-events-setter */

/* get-events-setter is get-events-setter */


/* Define Method get-events-setter{<integer>, <pollfd>} */

/* get-events-setter{<integer>, <pollfd>} */
long networkZnetwork_internalZget_events_setter_METH(descriptor_t *orig_sp, long A_value /* value */, void * A_ptr /* ptr */, heapptr_t A2)
{
    descriptor_t *cluster_0_top;


    /* #line 97 "./rawptr.dylan" */
    *(short *)((char *)A_ptr + 4) = A_value;
    return A_value;
}

/* generic-entry for get-events-setter{<integer>, <pollfd>} */
descriptor_t * networkZnetwork_internalZget_events_setter_METH_GENERIC(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    descriptor_t L_arg; /* arg */
    descriptor_t L_arg_2; /* arg */
    long L_arg_3; /* arg */
    void * L_arg_4; /* arg */
    long L_result0; /* result0 */
    descriptor_t L_temp;

    /* #line {Class <unknown-source-location>} */
    L_args = ((void *)(orig_sp - 2));
    L_arg = (((descriptor_t *)L_args)[0]);
    L_arg_2 = (((descriptor_t *)L_args)[1]);
    L_arg_3 = L_arg.dataword.l;
    L_arg_4 = L_arg_2.dataword.ptr;
    orig_sp = L_args;
    /* get-events-setter{<integer>, <pollfd>} */
    L_result0 = networkZnetwork_internalZget_events_setter_METH(orig_sp, L_arg_3, L_arg_4, A_next_method_info);
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* {Implicit} Define Generic get-revents */

/* get-revents is get-revents */


/* Define Method get-revents{<pollfd>} */

/* get-revents{<pollfd>} */
long networkZnetwork_internalZget_revents_METH(descriptor_t *orig_sp, void * A_ptr /* ptr */, heapptr_t A1)
{
    descriptor_t *cluster_0_top;


    /* #line 172 "./melange.dylan" */

    /* #line 91 "./rawptr.dylan" */
    return (*(short *)((char *)A_ptr + 6 ));
}

/* generic-entry for get-revents{<pollfd>} */
descriptor_t * networkZnetwork_internalZget_revents_METH_GENERIC(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    descriptor_t L_arg; /* arg */
    void * L_arg_2; /* arg */
    long L_result0; /* result0 */
    descriptor_t L_temp;

    /* #line {Class <unknown-source-location>} */
    L_args = ((void *)(orig_sp - 1));
    L_arg = (((descriptor_t *)L_args)[0]);
    L_arg_2 = L_arg.dataword.ptr;
    orig_sp = L_args;
    /* get-revents{<pollfd>} */
    L_result0 = networkZnetwork_internalZget_revents_METH(orig_sp, L_arg_2, A_next_method_info);
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* {Implicit} Define Generic get-revents-setter */

/* get-revents-setter is get-revents-setter */


/* Define Method get-revents-setter{<integer>, <pollfd>} */

/* get-revents-setter{<integer>, <pollfd>} */
long networkZnetwork_internalZget_revents_setter_METH(descriptor_t *orig_sp, long A_value /* value */, void * A_ptr /* ptr */, heapptr_t A2)
{
    descriptor_t *cluster_0_top;


    /* #line 97 "./rawptr.dylan" */
    *(short *)((char *)A_ptr + 6) = A_value;
    return A_value;
}

/* generic-entry for get-revents-setter{<integer>, <pollfd>} */
descriptor_t * networkZnetwork_internalZget_revents_setter_METH_GENERIC(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    descriptor_t L_arg; /* arg */
    descriptor_t L_arg_2; /* arg */
    long L_arg_3; /* arg */
    void * L_arg_4; /* arg */
    long L_result0; /* result0 */
    descriptor_t L_temp;

    /* #line {Class <unknown-source-location>} */
    L_args = ((void *)(orig_sp - 2));
    L_arg = (((descriptor_t *)L_args)[0]);
    L_arg_2 = (((descriptor_t *)L_args)[1]);
    L_arg_3 = L_arg.dataword.l;
    L_arg_4 = L_arg_2.dataword.ptr;
    orig_sp = L_args;
    /* get-revents-setter{<integer>, <pollfd>} */
    L_result0 = networkZnetwork_internalZget_revents_setter_METH(orig_sp, L_arg_3, L_arg_4, A_next_method_info);
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* Define Method pointer-value{<pollfd>} */

extern descriptor_t * dylanZdylan_visceraZgf_call_FUN(descriptor_t *orig_sp, heapptr_t A0, long A1);	/* gf-call */

extern struct heapobj dylanZdylan_visceraZV_HEAP;

struct mv_result_0 {
    heapptr_t R0;
    heapptr_t R1;
};

extern struct mv_result_0 dylanZdylan_visceraZgf_call_lookup_FUN(descriptor_t *orig_sp, heapptr_t A0, long A1);	/* gf-call-lookup */

extern struct heapobj dylanZdylan_visceraZPLUS_HEAP;

extern struct heapobj networkZstr_ROOT_2;

/* pointer-value{<pollfd>} */
void * networkZnetwork_internalZpointer_value_METH(descriptor_t *orig_sp, void * A_value /* value */, heapptr_t A_next_method_info /* next-method-info */, heapptr_t A_rest /* rest */, descriptor_t A_index /* index */)
{
    descriptor_t *cluster_0_top;
    descriptor_t L_temp;
    descriptor_t L_arg1; /* arg1 */
    descriptor_t L_temp_2;
    descriptor_t L_temp_3; /* temp */
    descriptor_t L_temp_4;


    /* #line 45 "./sockets-api.dylan" */
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = 8;
    orig_sp[0] = A_index;
    orig_sp[1] = L_temp;
    /* * */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZV_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_arg1 = (orig_sp == cluster_0_top ? dylanZfalse : orig_sp[0]);

    /* #line 45 "./sockets-api.dylan" */
    L_temp_2.heapptr = networkZliteral.heapptr;
    L_temp_2.dataword.ptr = A_value;
    orig_sp[0] = L_temp_2;
    orig_sp[1] = L_arg1;
    /* + */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZPLUS_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_temp_3 = (orig_sp == cluster_0_top ? dylanZfalse : orig_sp[0]);

    /* #line 386 "./condition.dylan" */
    if ((&networkZnetwork_internalZCLS_pollfd_HEAP == SLOT(L_temp_3.heapptr, heapptr_t, 0))) {

	/* #line 45 "./sockets-api.dylan" */
	return L_temp_3.dataword.ptr;
    }
    else {

	/* #line 389 "./condition.dylan" */
	L_temp_4.heapptr = &networkZstr_ROOT_2;
	L_temp_4.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp_3, &networkZnetwork_internalZCLS_pollfd_HEAP, L_temp_4);
	not_reached();
    }
}

extern heapptr_t dylanZdylan_visceraZmake_rest_arg_FUN(descriptor_t *orig_sp, void * A0, long A1);	/* make-rest-arg */

extern struct heapobj SYM_index_HEAP;

/* generic-entry for pointer-value{<pollfd>} */
descriptor_t * networkZnetwork_internalZpointer_value_METH_GENERIC(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    descriptor_t L_arg; /* arg */
    heapptr_t L_rest; /* rest */
    void * L_arg_2; /* arg */
    descriptor_t L_index; /* index */
    long L_index_2; /* index */
    descriptor_t L_key; /* key */
    descriptor_t L_value; /* value */
    void * L_result0; /* result0 */
    descriptor_t L_temp;

    /* #line {Class <unknown-source-location>} */
    L_args = ((void *)(orig_sp - A_nargs));
    L_arg = (((descriptor_t *)L_args)[0]);
    L_rest = dylanZdylan_visceraZmake_rest_arg_FUN(orig_sp, (descriptor_t *)L_args + 1, A_nargs - 1);
    L_arg_2 = L_arg.dataword.ptr;
    L_index.heapptr = networkZliteral_2.heapptr;
    L_index.dataword.l = 0;
    L_index_2 = (A_nargs - 2);
    while (1) {
	if ((L_index_2 < 1)) {
	    goto block0;
	}
	else {
	    L_key = (((descriptor_t *)L_args)[L_index_2]);
	    L_value = (((descriptor_t *)L_args)[(L_index_2 + 1)]);
	    if ((L_key.heapptr == &SYM_index_HEAP)) {
		L_index = L_value;
	    }
	    L_index_2 = (L_index_2 - 2);
	}
    }
  block0:;
    orig_sp = L_args;
    /* pointer-value{<pollfd>} */
    L_result0 = networkZnetwork_internalZpointer_value_METH(orig_sp, L_arg_2, A_next_method_info, L_rest, L_index);
    L_temp.heapptr = networkZliteral.heapptr;
    L_temp.dataword.ptr = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* Define Method content-size{subclass(<pollfd>)} */

/* content-size{subclass(<pollfd>)} */
long networkZnetwork_internalZcontent_size_METH(descriptor_t *orig_sp, heapptr_t A0, heapptr_t A1)
{

    return 8;
}

/* generic-entry for content-size{subclass(<pollfd>)} */
descriptor_t * networkZnetwork_internalZcontent_size_METH_GENERIC(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    long L_result0; /* result0 */
    descriptor_t L_temp;

    orig_sp = ((void *)(orig_sp - 1));
    /* content-size{subclass(<pollfd>)} */
    L_result0 = networkZnetwork_internalZcontent_size_METH(orig_sp, &networkZnetwork_internalZCLS_pollfd_HEAP, A_next_method_info);
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* {Implicit} Define Generic poll */

/* poll is poll */


/* Define Method poll{<pollfd>, <integer>, <integer>} */

/* poll{<pollfd>, <integer>, <integer>} */
long networkZnetwork_internalZpoll_METH(descriptor_t *orig_sp, void * A_arg1 /* arg1 */, long A_arg2 /* arg2 */, long A_arg3 /* arg3 */, heapptr_t A3)
{
    descriptor_t *cluster_0_top;
    long L_result_value; /* result-value */


    /* #line 56 "./sockets-api.dylan" */

    /* #line 735 "./macros.dylan" */
    L_result_value = poll(A_arg1, A_arg2, A_arg3);
    return L_result_value;
}

/* generic-entry for poll{<pollfd>, <integer>, <integer>} */
descriptor_t * networkZnetwork_internalZpoll_METH_GENERIC(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    descriptor_t L_arg; /* arg */
    descriptor_t L_arg_2; /* arg */
    descriptor_t L_arg_3; /* arg */
    void * L_arg_4; /* arg */
    long L_arg_5; /* arg */
    long L_arg_6; /* arg */
    long L_result0; /* result0 */
    descriptor_t L_temp;

    /* #line {Class <unknown-source-location>} */
    L_args = ((void *)(orig_sp - 3));
    L_arg = (((descriptor_t *)L_args)[0]);
    L_arg_2 = (((descriptor_t *)L_args)[1]);
    L_arg_3 = (((descriptor_t *)L_args)[2]);
    L_arg_4 = L_arg.dataword.ptr;
    L_arg_5 = L_arg_2.dataword.l;
    L_arg_6 = L_arg_3.dataword.l;
    orig_sp = L_args;
    /* poll{<pollfd>, <integer>, <integer>} */
    L_result0 = networkZnetwork_internalZpoll_METH(orig_sp, L_arg_4, L_arg_5, L_arg_6, A_next_method_info);
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* Define Constant $_SYS-POLL-H */

/* $_SYS-POLL-H is 1 */


/* Define Constant $POLLIN */

/* $POLLIN is 1 */


/* Define Constant $POLLPRI */

/* $POLLPRI is 2 */


/* Define Constant $POLLOUT */

/* $POLLOUT is 4 */


/* Define Constant $POLLERR */

/* $POLLERR is 8 */


/* Define Constant $POLLHUP */

/* $POLLHUP is 16 */


/* Define Constant $POLLNVAL */

/* $POLLNVAL is 32 */


/* Define Constant $_FEATURES-H */

/* $_FEATURES-H is 1 */


/* Define Constant $__USE-ANSI */

/* $__USE-ANSI is 1 */


/* Define Constant $_BSD-SOURCE */

/* $_BSD-SOURCE is 1 */


/* Define Constant $_SVID-SOURCE */

/* $_SVID-SOURCE is 1 */


/* Define Constant $_POSIX-SOURCE */

/* $_POSIX-SOURCE is 1 */


/* Define Constant $_POSIX-C-SOURCE */

/* $_POSIX-C-SOURCE is 199506 */


/* Define Constant $__USE-POSIX */

/* $__USE-POSIX is 1 */


/* Define Constant $__USE-POSIX2 */

/* $__USE-POSIX2 is 1 */


/* Define Constant $__USE-POSIX199309 */

/* $__USE-POSIX199309 is 1 */


/* Define Constant $__USE-POSIX199506 */

/* $__USE-POSIX199506 is 1 */


/* Define Constant $__USE-MISC */

/* $__USE-MISC is 1 */


/* Define Constant $__USE-BSD */

/* $__USE-BSD is 1 */


/* Define Constant $__USE-SVID */

/* $__USE-SVID is 1 */


/* Define Constant $__STDC-IEC-559-- */

/* $__STDC-IEC-559-- is 1 */


/* Define Constant $__STDC-IEC-559-COMPLEX-- */

/* $__STDC-IEC-559-COMPLEX-- is 1 */


/* Define Constant $__STDC-ISO-10646-- */

/* $__STDC-ISO-10646-- is 200009 */


/* Define Constant $__GNU-LIBRARY-- */

/* $__GNU-LIBRARY-- is 6 */


/* Define Constant $__GLIBC-- */

/* $__GLIBC-- is 2 */


/* Define Constant $__GLIBC-MINOR-- */

/* $__GLIBC-MINOR-- is 3 */


/* Define Constant $_SYS-CDEFS-H */

/* $_SYS-CDEFS-H is 1 */


/* Define Constant <__signed> */

/* <__signed> is <integer> */


/* Define Constant <__ptr-t> */

/* <__ptr-t> is <machine-pointer> */


/* Define Constant <__long-double-t> */

/* <__long-double-t> is <extended-float> */


/* Define Class <unsigned-char*> */

/* <unsigned-char*> is <unsigned-char*> */

extern struct heapobj networkZnetwork_internalZCLS_unsigned_charV_HEAP;

/* maker for <unsigned-char*> */
void * networkZnetwork_internalZCLS_unsigned_charV_MAKER_FUN(descriptor_t *orig_sp, void * A_pointer /* pointer */, int A_pointer_suppliedQUERY /* pointer-supplied? */)
{
    descriptor_t *cluster_0_top;


    /* #line 120 "./sockets-api.dylan" */
    if (A_pointer_suppliedQUERY) {
	return A_pointer;
    }
    else {
	/* missing-required-init-keyword-error */
	dylanZdylan_visceraZmissing_required_init_keyword_error_FUN(orig_sp, &SYM_pointer_HEAP, &networkZnetwork_internalZCLS_unsigned_charV_HEAP);
	not_reached();
    }
}

extern descriptor_t networkZliteral_3;	/* proxy for <unsigned-char*> */

/* general-entry for maker for <unsigned-char*> */
descriptor_t * networkZnetwork_internalZCLS_unsigned_charV_MAKER_GENERAL(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    void * L_pointer; /* pointer */
    int L_pointer_suppliedQUERY; /* pointer-supplied? */
    long L_index; /* index */
    descriptor_t L_temp; /* temp */
    descriptor_t L_value; /* value */
    descriptor_t L_temp_2;
    descriptor_t L_temp_3;
    void * L_result0; /* result0 */
    descriptor_t L_temp_4;

    /* #line {Class <unknown-source-location>} */

    /* #line 126 "./cmp.dylan" */

    /* #line 209 "./num.dylan" */
    if (((A_nargs & 1) == 0)) {
	/* #line {Class <unknown-source-location>} */
	L_args = ((void *)(orig_sp - A_nargs));
	L_pointer = 0;
	L_pointer_suppliedQUERY = FALSE;
	L_index = (A_nargs - 2);
	while (1) {
	    if ((L_index < 0)) {
		goto block0;
	    }
	    else {
		L_temp = (((descriptor_t *)L_args)[L_index]);

		/* #line 386 "./condition.dylan" */
		if ((&dylanZdylan_visceraZCLS_symbol_HEAP == SLOT(L_temp.heapptr, heapptr_t, 0))) {
		    /* #line {Class <unknown-source-location>} */
		    L_value = (((descriptor_t *)L_args)[(L_index + 1)]);
		    if ((L_temp.heapptr == &SYM_pointer_HEAP)) {

			/* #line 386 "./condition.dylan" */
			if ((&dylanZdylan_visceraZCLS_raw_pointer_HEAP == SLOT(L_value.heapptr, heapptr_t, 0))) {
			    /* #line {Class <unknown-source-location>} */
			    L_pointer = L_value.dataword.ptr;
			    L_pointer_suppliedQUERY = TRUE;
			}
			else {

			    /* #line 389 "./condition.dylan" */
			    L_temp_2.heapptr = &networkZstr_ROOT;
			    L_temp_2.dataword.l = 0;
			    /* type-error-with-location */
			    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_value, &dylanZdylan_visceraZCLS_raw_pointer_HEAP, L_temp_2);
			    not_reached();
			}
		    }
		    /* #line {Class <unknown-source-location>} */
		    L_index = (L_index - 2);
		}
		else {

		    /* #line 389 "./condition.dylan" */
		    L_temp_3.heapptr = &networkZstr_ROOT;
		    L_temp_3.dataword.l = 0;
		    /* type-error-with-location */
		    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp, &dylanZdylan_visceraZCLS_symbol_HEAP, L_temp_3);
		    not_reached();
		}
	    }
	}
      block0:;
	/* #line {Class <unknown-source-location>} */
	orig_sp = L_args;
	/* maker for <unsigned-char*> */
	L_result0 = networkZnetwork_internalZCLS_unsigned_charV_MAKER_FUN(orig_sp, L_pointer, L_pointer_suppliedQUERY);
	L_temp_4.heapptr = networkZliteral_3.heapptr;
	L_temp_4.dataword.ptr = L_result0;
	orig_sp[0] = L_temp_4;
	return orig_sp + 1;
    }
    else {
	/* odd-number-of-keyword/value-arguments-error */
	dylanZdylan_visceraZodd_number_of_keywordSLASHvalue_arguments_error_FUN(orig_sp);
	not_reached();
    }
}


/* Define Sealed Domain make (singleton(<unsigned-char*>)) */


/* Define Method pointer-value{<unsigned-char*>} */

extern struct heapobj dylanZdylan_visceraZCLS_integer_HEAP;

extern struct heapobj networkZstr_ROOT_3;

/* pointer-value{<unsigned-char*>} */
long networkZnetwork_internalZpointer_value_METH_2(descriptor_t *orig_sp, descriptor_t A_ptr /* ptr */, heapptr_t A_next_method_info /* next-method-info */, heapptr_t A_rest /* rest */, descriptor_t A_index /* index */)
{
    descriptor_t *cluster_0_top;
    descriptor_t L_temp;
    descriptor_t L_arg2; /* arg2 */
    descriptor_t L_temp_2;


    /* #line 127 "./sockets-api.dylan" */
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = 1;
    orig_sp[0] = A_index;
    orig_sp[1] = L_temp;
    /* * */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZV_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_arg2 = (orig_sp == cluster_0_top ? dylanZfalse : orig_sp[0]);

    /* #line 386 "./condition.dylan" */
    if ((&dylanZdylan_visceraZCLS_integer_HEAP == SLOT(L_arg2.heapptr, heapptr_t, 0))) {

	/* #line 127 "./sockets-api.dylan" */

	/* #line 159 "./melange.dylan" */

	/* #line 91 "./rawptr.dylan" */
	return (*(unsigned char *)((char *)A_ptr.dataword.ptr + L_arg2.dataword.l ));
    }
    else {

	/* #line 389 "./condition.dylan" */
	L_temp_2.heapptr = &networkZstr_ROOT_3;
	L_temp_2.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_arg2, &dylanZdylan_visceraZCLS_integer_HEAP, L_temp_2);
	not_reached();
    }
}

/* generic-entry for pointer-value{<unsigned-char*>} */
descriptor_t * networkZnetwork_internalZpointer_value_METH_GENERIC_2(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    descriptor_t L_arg; /* arg */
    heapptr_t L_rest; /* rest */
    descriptor_t L_arg_2; /* arg */
    descriptor_t L_index; /* index */
    long L_index_2; /* index */
    descriptor_t L_key; /* key */
    descriptor_t L_value; /* value */
    long L_result0; /* result0 */
    descriptor_t L_temp;

    /* #line {Class <unknown-source-location>} */
    L_args = ((void *)(orig_sp - A_nargs));
    L_arg = (((descriptor_t *)L_args)[0]);
    L_rest = dylanZdylan_visceraZmake_rest_arg_FUN(orig_sp, (descriptor_t *)L_args + 1, A_nargs - 1);
    L_arg_2 = L_arg;
    L_index.heapptr = networkZliteral_2.heapptr;
    L_index.dataword.l = 0;
    L_index_2 = (A_nargs - 2);
    while (1) {
	if ((L_index_2 < 1)) {
	    goto block0;
	}
	else {
	    L_key = (((descriptor_t *)L_args)[L_index_2]);
	    L_value = (((descriptor_t *)L_args)[(L_index_2 + 1)]);
	    if ((L_key.heapptr == &SYM_index_HEAP)) {
		L_index = L_value;
	    }
	    L_index_2 = (L_index_2 - 2);
	}
    }
  block0:;
    orig_sp = L_args;
    /* pointer-value{<unsigned-char*>} */
    L_result0 = networkZnetwork_internalZpointer_value_METH_2(orig_sp, L_arg_2, A_next_method_info, L_rest, L_index);
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* Define Method pointer-value-setter{<integer>, <unsigned-char*>} */

/* pointer-value-setter{<integer>, <unsigned-char*>} */
long networkZnetwork_internalZpointer_value_setter_METH(descriptor_t *orig_sp, long A_value /* value */, descriptor_t A_ptr /* ptr */, heapptr_t A_next_method_info /* next-method-info */, heapptr_t A_rest /* rest */, descriptor_t A_index /* index */)
{
    descriptor_t *cluster_0_top;
    descriptor_t L_temp;
    descriptor_t L_arg3; /* arg3 */
    descriptor_t L_temp_2;


    /* #line 133 "./sockets-api.dylan" */
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = 1;
    orig_sp[0] = A_index;
    orig_sp[1] = L_temp;
    /* * */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZV_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_arg3 = (orig_sp == cluster_0_top ? dylanZfalse : orig_sp[0]);

    /* #line 386 "./condition.dylan" */
    if ((&dylanZdylan_visceraZCLS_integer_HEAP == SLOT(L_arg3.heapptr, heapptr_t, 0))) {
	/* #line {Class <unknown-source-location>} */

	/* #line 97 "./rawptr.dylan" */
	*(unsigned char *)((char *)A_ptr.dataword.ptr + L_arg3.dataword.l) = A_value;
	return A_value;
    }
    else {

	/* #line 389 "./condition.dylan" */
	L_temp_2.heapptr = &networkZstr_ROOT;
	L_temp_2.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_arg3, &dylanZdylan_visceraZCLS_integer_HEAP, L_temp_2);
	not_reached();
    }
}

/* generic-entry for pointer-value-setter{<integer>, <unsigned-char*>} */
descriptor_t * networkZnetwork_internalZpointer_value_setter_METH_GENERIC(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    descriptor_t L_arg; /* arg */
    descriptor_t L_arg_2; /* arg */
    heapptr_t L_rest; /* rest */
    long L_arg_3; /* arg */
    descriptor_t L_arg_4; /* arg */
    descriptor_t L_index; /* index */
    long L_index_2; /* index */
    descriptor_t L_key; /* key */
    descriptor_t L_value; /* value */
    long L_result0; /* result0 */
    descriptor_t L_temp;

    /* #line {Class <unknown-source-location>} */
    L_args = ((void *)(orig_sp - A_nargs));
    L_arg = (((descriptor_t *)L_args)[0]);
    L_arg_2 = (((descriptor_t *)L_args)[1]);
    L_rest = dylanZdylan_visceraZmake_rest_arg_FUN(orig_sp, (descriptor_t *)L_args + 2, A_nargs - 2);
    L_arg_3 = L_arg.dataword.l;
    L_arg_4 = L_arg_2;
    L_index.heapptr = networkZliteral_2.heapptr;
    L_index.dataword.l = 0;
    L_index_2 = (A_nargs - 2);
    while (1) {
	if ((L_index_2 < 2)) {
	    goto block0;
	}
	else {
	    L_key = (((descriptor_t *)L_args)[L_index_2]);
	    L_value = (((descriptor_t *)L_args)[(L_index_2 + 1)]);
	    if ((L_key.heapptr == &SYM_index_HEAP)) {
		L_index = L_value;
	    }
	    L_index_2 = (L_index_2 - 2);
	}
    }
  block0:;
    orig_sp = L_args;
    /* pointer-value-setter{<integer>, <unsigned-char*>} */
    L_result0 = networkZnetwork_internalZpointer_value_setter_METH(orig_sp, L_arg_3, L_arg_4, A_next_method_info, L_rest, L_index);
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* Define Method content-size{subclass(<unsigned-char*>)} */

/* content-size{subclass(<unsigned-char*>)} */
long networkZnetwork_internalZcontent_size_METH_2(descriptor_t *orig_sp, heapptr_t A0, heapptr_t A1)
{

    return 1;
}

/* generic-entry for content-size{subclass(<unsigned-char*>)} */
descriptor_t * networkZnetwork_internalZcontent_size_METH_GENERIC_2(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    descriptor_t L_arg; /* arg */
    heapptr_t L_arg_2; /* arg */
    long L_result0; /* result0 */
    descriptor_t L_temp;

    L_args = ((void *)(orig_sp - 1));
    L_arg = (((descriptor_t *)L_args)[0]);
    L_arg_2 = L_arg.heapptr;
    orig_sp = L_args;
    /* content-size{subclass(<unsigned-char*>)} */
    L_result0 = networkZnetwork_internalZcontent_size_METH_2(orig_sp, L_arg_2, A_next_method_info);
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* Define Class <unsigned-char<@14>> */

/* <unsigned-char<@14>> is <unsigned-char<@14>> */

extern struct heapobj networkZnetwork_internalZCLS_unsigned_charLESSX4014GREATER_HEAP;

/* maker for <unsigned-char<@14>> */
void * networkZnetwork_internalZCLS_unsigned_charLESSX4014GREATER_MAKER_FUN(descriptor_t *orig_sp, void * A_pointer /* pointer */, int A_pointer_suppliedQUERY /* pointer-supplied? */)
{
    descriptor_t *cluster_0_top;


    /* #line 141 "./sockets-api.dylan" */
    if (A_pointer_suppliedQUERY) {
	return A_pointer;
    }
    else {
	/* missing-required-init-keyword-error */
	dylanZdylan_visceraZmissing_required_init_keyword_error_FUN(orig_sp, &SYM_pointer_HEAP, &networkZnetwork_internalZCLS_unsigned_charLESSX4014GREATER_HEAP);
	not_reached();
    }
}

extern descriptor_t networkZliteral_4;	/* proxy for <unsigned-char<@14>> */

/* general-entry for maker for <unsigned-char<@14>> */
descriptor_t * networkZnetwork_internalZCLS_unsigned_charLESSX4014GREATER_MAKER_GENERAL(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    void * L_pointer; /* pointer */
    int L_pointer_suppliedQUERY; /* pointer-supplied? */
    long L_index; /* index */
    descriptor_t L_temp; /* temp */
    descriptor_t L_value; /* value */
    descriptor_t L_temp_2;
    descriptor_t L_temp_3;
    void * L_result0; /* result0 */
    descriptor_t L_temp_4;

    /* #line {Class <unknown-source-location>} */

    /* #line 126 "./cmp.dylan" */

    /* #line 209 "./num.dylan" */
    if (((A_nargs & 1) == 0)) {
	/* #line {Class <unknown-source-location>} */
	L_args = ((void *)(orig_sp - A_nargs));
	L_pointer = 0;
	L_pointer_suppliedQUERY = FALSE;
	L_index = (A_nargs - 2);
	while (1) {
	    if ((L_index < 0)) {
		goto block0;
	    }
	    else {
		L_temp = (((descriptor_t *)L_args)[L_index]);

		/* #line 386 "./condition.dylan" */
		if ((&dylanZdylan_visceraZCLS_symbol_HEAP == SLOT(L_temp.heapptr, heapptr_t, 0))) {
		    /* #line {Class <unknown-source-location>} */
		    L_value = (((descriptor_t *)L_args)[(L_index + 1)]);
		    if ((L_temp.heapptr == &SYM_pointer_HEAP)) {

			/* #line 386 "./condition.dylan" */
			if ((&dylanZdylan_visceraZCLS_raw_pointer_HEAP == SLOT(L_value.heapptr, heapptr_t, 0))) {
			    /* #line {Class <unknown-source-location>} */
			    L_pointer = L_value.dataword.ptr;
			    L_pointer_suppliedQUERY = TRUE;
			}
			else {

			    /* #line 389 "./condition.dylan" */
			    L_temp_2.heapptr = &networkZstr_ROOT;
			    L_temp_2.dataword.l = 0;
			    /* type-error-with-location */
			    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_value, &dylanZdylan_visceraZCLS_raw_pointer_HEAP, L_temp_2);
			    not_reached();
			}
		    }
		    /* #line {Class <unknown-source-location>} */
		    L_index = (L_index - 2);
		}
		else {

		    /* #line 389 "./condition.dylan" */
		    L_temp_3.heapptr = &networkZstr_ROOT;
		    L_temp_3.dataword.l = 0;
		    /* type-error-with-location */
		    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp, &dylanZdylan_visceraZCLS_symbol_HEAP, L_temp_3);
		    not_reached();
		}
	    }
	}
      block0:;
	/* #line {Class <unknown-source-location>} */
	orig_sp = L_args;
	/* maker for <unsigned-char<@14>> */
	L_result0 = networkZnetwork_internalZCLS_unsigned_charLESSX4014GREATER_MAKER_FUN(orig_sp, L_pointer, L_pointer_suppliedQUERY);
	L_temp_4.heapptr = networkZliteral_4.heapptr;
	L_temp_4.dataword.ptr = L_result0;
	orig_sp[0] = L_temp_4;
	return orig_sp + 1;
    }
    else {
	/* odd-number-of-keyword/value-arguments-error */
	dylanZdylan_visceraZodd_number_of_keywordSLASHvalue_arguments_error_FUN(orig_sp);
	not_reached();
    }
}


/* Define Sealed Domain make (singleton(<unsigned-char<@14>>)) */


/* Define Method content-size{singleton(<unsigned-char<@14>>)} */

/* content-size{singleton(<unsigned-char<@14>>)} */
long networkZnetwork_internalZcontent_size_METH_3(descriptor_t *orig_sp, heapptr_t A0, heapptr_t A1)
{

    return 14;
}

/* generic-entry for content-size{singleton(<unsigned-char<@14>>)} */
descriptor_t * networkZnetwork_internalZcontent_size_METH_GENERIC_3(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    long L_result0; /* result0 */
    descriptor_t L_temp;

    orig_sp = ((void *)(orig_sp - 1));
    /* content-size{singleton(<unsigned-char<@14>>)} */
    L_result0 = networkZnetwork_internalZcontent_size_METH_3(orig_sp, &networkZnetwork_internalZCLS_unsigned_charLESSX4014GREATER_HEAP, A_next_method_info);
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* Define Class <osockaddr> */

/* <osockaddr> is <osockaddr> */

extern struct heapobj networkZnetwork_internalZCLS_osockaddr_HEAP;

/* maker for <osockaddr> */
void * networkZnetwork_internalZCLS_osockaddr_MAKER_FUN(descriptor_t *orig_sp, void * A_pointer /* pointer */, int A_pointer_suppliedQUERY /* pointer-supplied? */)
{
    descriptor_t *cluster_0_top;


    /* #line 149 "./sockets-api.dylan" */
    if (A_pointer_suppliedQUERY) {
	return A_pointer;
    }
    else {
	/* missing-required-init-keyword-error */
	dylanZdylan_visceraZmissing_required_init_keyword_error_FUN(orig_sp, &SYM_pointer_HEAP, &networkZnetwork_internalZCLS_osockaddr_HEAP);
	not_reached();
    }
}

extern descriptor_t networkZliteral_5;	/* proxy for <osockaddr> */

/* general-entry for maker for <osockaddr> */
descriptor_t * networkZnetwork_internalZCLS_osockaddr_MAKER_GENERAL(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    void * L_pointer; /* pointer */
    int L_pointer_suppliedQUERY; /* pointer-supplied? */
    long L_index; /* index */
    descriptor_t L_temp; /* temp */
    descriptor_t L_value; /* value */
    descriptor_t L_temp_2;
    descriptor_t L_temp_3;
    void * L_result0; /* result0 */
    descriptor_t L_temp_4;

    /* #line {Class <unknown-source-location>} */

    /* #line 126 "./cmp.dylan" */

    /* #line 209 "./num.dylan" */
    if (((A_nargs & 1) == 0)) {
	/* #line {Class <unknown-source-location>} */
	L_args = ((void *)(orig_sp - A_nargs));
	L_pointer = 0;
	L_pointer_suppliedQUERY = FALSE;
	L_index = (A_nargs - 2);
	while (1) {
	    if ((L_index < 0)) {
		goto block0;
	    }
	    else {
		L_temp = (((descriptor_t *)L_args)[L_index]);

		/* #line 386 "./condition.dylan" */
		if ((&dylanZdylan_visceraZCLS_symbol_HEAP == SLOT(L_temp.heapptr, heapptr_t, 0))) {
		    /* #line {Class <unknown-source-location>} */
		    L_value = (((descriptor_t *)L_args)[(L_index + 1)]);
		    if ((L_temp.heapptr == &SYM_pointer_HEAP)) {

			/* #line 386 "./condition.dylan" */
			if ((&dylanZdylan_visceraZCLS_raw_pointer_HEAP == SLOT(L_value.heapptr, heapptr_t, 0))) {
			    /* #line {Class <unknown-source-location>} */
			    L_pointer = L_value.dataword.ptr;
			    L_pointer_suppliedQUERY = TRUE;
			}
			else {

			    /* #line 389 "./condition.dylan" */
			    L_temp_2.heapptr = &networkZstr_ROOT;
			    L_temp_2.dataword.l = 0;
			    /* type-error-with-location */
			    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_value, &dylanZdylan_visceraZCLS_raw_pointer_HEAP, L_temp_2);
			    not_reached();
			}
		    }
		    /* #line {Class <unknown-source-location>} */
		    L_index = (L_index - 2);
		}
		else {

		    /* #line 389 "./condition.dylan" */
		    L_temp_3.heapptr = &networkZstr_ROOT;
		    L_temp_3.dataword.l = 0;
		    /* type-error-with-location */
		    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp, &dylanZdylan_visceraZCLS_symbol_HEAP, L_temp_3);
		    not_reached();
		}
	    }
	}
      block0:;
	/* #line {Class <unknown-source-location>} */
	orig_sp = L_args;
	/* maker for <osockaddr> */
	L_result0 = networkZnetwork_internalZCLS_osockaddr_MAKER_FUN(orig_sp, L_pointer, L_pointer_suppliedQUERY);
	L_temp_4.heapptr = networkZliteral_5.heapptr;
	L_temp_4.dataword.ptr = L_result0;
	orig_sp[0] = L_temp_4;
	return orig_sp + 1;
    }
    else {
	/* odd-number-of-keyword/value-arguments-error */
	dylanZdylan_visceraZodd_number_of_keywordSLASHvalue_arguments_error_FUN(orig_sp);
	not_reached();
    }
}


/* Define Sealed Domain make (singleton(<osockaddr>)) */


/* {Implicit} Define Generic get-sa-family */

/* get-sa-family is get-sa-family */


/* Define Method get-sa-family{<osockaddr>} */

/* get-sa-family{<osockaddr>} */
long networkZnetwork_internalZget_sa_family_METH(descriptor_t *orig_sp, void * A_ptr /* ptr */, heapptr_t A1)
{
    descriptor_t *cluster_0_top;


    /* #line 185 "./melange.dylan" */

    /* #line 91 "./rawptr.dylan" */
    return (*(unsigned short *)((char *)A_ptr + 0 ));
}


/* {Implicit} Define Generic get-sa-family-setter */

/* get-sa-family-setter is get-sa-family-setter */


/* Define Method get-sa-family-setter{<integer>, <osockaddr>} */

/* get-sa-family-setter{<integer>, <osockaddr>} */
long networkZnetwork_internalZget_sa_family_setter_METH(descriptor_t *orig_sp, long A_value /* value */, void * A_ptr /* ptr */, heapptr_t A2)
{
    descriptor_t *cluster_0_top;

    /* #line {Class <unknown-source-location>} */

    /* #line 97 "./rawptr.dylan" */
    *(unsigned short *)((char *)A_ptr + 0) = A_value;
    return A_value;
}


/* {Implicit} Define Generic get-sa-data */

/* get-sa-data is get-sa-data */


/* Define Method get-sa-data{<osockaddr>} */

extern descriptor_t networkZliteral_6;	/* proxy for <raw-pointer> */

extern struct heapobj dylanZdylan_visceraZas_HEAP;

extern int dylanZdylan_visceraZPCTsubtypeQUERY_METH(descriptor_t *orig_sp, heapptr_t A0, heapptr_t A1, heapptr_t A2);	/* %subtype?{<class>, <class>} */

extern struct heapobj melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP;

extern struct heapobj dylanZliteral_ROOT_2;

extern struct heapobj networkZstr_ROOT_4;

extern struct heapobj networkZstr_ROOT_5;

/* get-sa-data{<osockaddr>} */
void * networkZnetwork_internalZget_sa_data_METH(descriptor_t *orig_sp, void * A_ptr /* ptr */, heapptr_t A1)
{
    descriptor_t *cluster_0_top;
    descriptor_t L_temp;
    descriptor_t L_temp_2;
    descriptor_t L_temp_3;
    descriptor_t L_temp_4; /* temp */
    int L_condition; /* condition */
    descriptor_t L_temp_5;
    descriptor_t L_temp_6; /* temp */
    descriptor_t L_temp_7;
    descriptor_t L_temp_8;

    /* #line {Class <unknown-source-location>} */

    /* #line 49 "./object.dylan" */
    L_temp.heapptr = networkZliteral_5.heapptr;
    L_temp.dataword.ptr = A_ptr;

    /* #line 324 "./melange.dylan" */

    /* #line 324 "./melange.dylan" */

    /* #line 324 "./melange.dylan" */
    L_temp_2.heapptr = SLOT(L_temp.heapptr, heapptr_t, 0);
    L_temp_2.dataword.l = 0;
    L_temp_3.heapptr = networkZliteral_6.heapptr;
    L_temp_3.dataword.ptr = ((void *)((char *)A_ptr + 2));
    orig_sp[0] = L_temp_2;
    orig_sp[1] = L_temp_3;
    /* as */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZas_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_temp_4 = orig_sp[0];

    /* #line 49 "./object.dylan" */

    /* #line 386 "./condition.dylan" */
    /* %subtype?{<class>, <class>} */
    L_condition = dylanZdylan_visceraZPCTsubtypeQUERY_METH(orig_sp, SLOT(L_temp_4.heapptr, heapptr_t, 0), &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP, &dylanZliteral_ROOT_2);
    if (L_condition) {

	/* #line 324 "./melange.dylan" */

	/* #line 166 "./sockets-api.dylan" */
	L_temp_5.heapptr = &networkZnetwork_internalZCLS_unsigned_charLESSX4014GREATER_HEAP;
	L_temp_5.dataword.l = 0;
	orig_sp[0] = L_temp_5;
	orig_sp[1] = L_temp_4;
	/* as */
	{
	  struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZas_HEAP, 2);
	  heapptr_t L_meth = L_temp.R0;
	  heapptr_t L_next_info = L_temp.R1;
	  cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
	}
	L_temp_6 = orig_sp[0];

	/* #line 386 "./condition.dylan" */
	if ((&networkZnetwork_internalZCLS_unsigned_charLESSX4014GREATER_HEAP == SLOT(L_temp_6.heapptr, heapptr_t, 0))) {

	    /* #line 166 "./sockets-api.dylan" */
	    return L_temp_6.dataword.ptr;
	}
	else {

	    /* #line 389 "./condition.dylan" */
	    L_temp_7.heapptr = &networkZstr_ROOT_4;
	    L_temp_7.dataword.l = 0;
	    /* type-error-with-location */
	    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp_6, &networkZnetwork_internalZCLS_unsigned_charLESSX4014GREATER_HEAP, L_temp_7);
	    not_reached();
	}
    }
    else {
	L_temp_8.heapptr = &networkZstr_ROOT_5;
	L_temp_8.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp_4, &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP, L_temp_8);
	not_reached();
    }
}

/* generic-entry for get-sa-data{<osockaddr>} */
descriptor_t * networkZnetwork_internalZget_sa_data_METH_GENERIC(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    descriptor_t L_arg; /* arg */
    void * L_arg_2; /* arg */
    void * L_result0; /* result0 */
    descriptor_t L_temp;

    /* #line {Class <unknown-source-location>} */
    L_args = ((void *)(orig_sp - 1));
    L_arg = (((descriptor_t *)L_args)[0]);
    L_arg_2 = L_arg.dataword.ptr;
    orig_sp = L_args;
    /* get-sa-data{<osockaddr>} */
    L_result0 = networkZnetwork_internalZget_sa_data_METH(orig_sp, L_arg_2, A_next_method_info);
    L_temp.heapptr = networkZliteral_4.heapptr;
    L_temp.dataword.ptr = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* Define Method pointer-value{<osockaddr>} */

extern struct heapobj networkZstr_ROOT_6;

/* pointer-value{<osockaddr>} */
void * networkZnetwork_internalZpointer_value_METH_3(descriptor_t *orig_sp, void * A_value /* value */, heapptr_t A_next_method_info /* next-method-info */, heapptr_t A_rest /* rest */, descriptor_t A_index /* index */)
{
    descriptor_t *cluster_0_top;
    descriptor_t L_temp;
    descriptor_t L_arg1; /* arg1 */
    descriptor_t L_temp_2;
    descriptor_t L_temp_3; /* temp */
    descriptor_t L_temp_4;


    /* #line 170 "./sockets-api.dylan" */
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = 16;
    orig_sp[0] = A_index;
    orig_sp[1] = L_temp;
    /* * */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZV_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_arg1 = (orig_sp == cluster_0_top ? dylanZfalse : orig_sp[0]);

    /* #line 170 "./sockets-api.dylan" */
    L_temp_2.heapptr = networkZliteral_5.heapptr;
    L_temp_2.dataword.ptr = A_value;
    orig_sp[0] = L_temp_2;
    orig_sp[1] = L_arg1;
    /* + */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZPLUS_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_temp_3 = (orig_sp == cluster_0_top ? dylanZfalse : orig_sp[0]);

    /* #line 386 "./condition.dylan" */
    if ((&networkZnetwork_internalZCLS_osockaddr_HEAP == SLOT(L_temp_3.heapptr, heapptr_t, 0))) {

	/* #line 170 "./sockets-api.dylan" */
	return L_temp_3.dataword.ptr;
    }
    else {

	/* #line 389 "./condition.dylan" */
	L_temp_4.heapptr = &networkZstr_ROOT_6;
	L_temp_4.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp_3, &networkZnetwork_internalZCLS_osockaddr_HEAP, L_temp_4);
	not_reached();
    }
}

/* generic-entry for pointer-value{<osockaddr>} */
descriptor_t * networkZnetwork_internalZpointer_value_METH_GENERIC_3(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    descriptor_t L_arg; /* arg */
    heapptr_t L_rest; /* rest */
    void * L_arg_2; /* arg */
    descriptor_t L_index; /* index */
    long L_index_2; /* index */
    descriptor_t L_key; /* key */
    descriptor_t L_value; /* value */
    void * L_result0; /* result0 */
    descriptor_t L_temp;

    /* #line {Class <unknown-source-location>} */
    L_args = ((void *)(orig_sp - A_nargs));
    L_arg = (((descriptor_t *)L_args)[0]);
    L_rest = dylanZdylan_visceraZmake_rest_arg_FUN(orig_sp, (descriptor_t *)L_args + 1, A_nargs - 1);
    L_arg_2 = L_arg.dataword.ptr;
    L_index.heapptr = networkZliteral_2.heapptr;
    L_index.dataword.l = 0;
    L_index_2 = (A_nargs - 2);
    while (1) {
	if ((L_index_2 < 1)) {
	    goto block0;
	}
	else {
	    L_key = (((descriptor_t *)L_args)[L_index_2]);
	    L_value = (((descriptor_t *)L_args)[(L_index_2 + 1)]);
	    if ((L_key.heapptr == &SYM_index_HEAP)) {
		L_index = L_value;
	    }
	    L_index_2 = (L_index_2 - 2);
	}
    }
  block0:;
    orig_sp = L_args;
    /* pointer-value{<osockaddr>} */
    L_result0 = networkZnetwork_internalZpointer_value_METH_3(orig_sp, L_arg_2, A_next_method_info, L_rest, L_index);
    L_temp.heapptr = networkZliteral_5.heapptr;
    L_temp.dataword.ptr = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* Define Method content-size{subclass(<osockaddr>)} */

/* content-size{subclass(<osockaddr>)} */
long networkZnetwork_internalZcontent_size_METH_4(descriptor_t *orig_sp, heapptr_t A0, heapptr_t A1)
{

    return 16;
}

/* generic-entry for content-size{subclass(<osockaddr>)} */
descriptor_t * networkZnetwork_internalZcontent_size_METH_GENERIC_4(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    long L_result0; /* result0 */
    descriptor_t L_temp;

    orig_sp = ((void *)(orig_sp - 1));
    /* content-size{subclass(<osockaddr>)} */
    L_result0 = networkZnetwork_internalZcontent_size_METH_4(orig_sp, &networkZnetwork_internalZCLS_osockaddr_HEAP, A_next_method_info);
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* Define Constant <anonymous-87> */

/* <anonymous-87> allocated as networkZnetwork_internalZCLS_anonymous_87 */


/* Define Constant $SHUT-RD */

/* $SHUT-RD is 0 */


/* Define Constant $SHUT-WR */

/* $SHUT-WR is 1 */


/* Define Constant $SHUT-RDWR */

/* $SHUT-RDWR is 2 */


/* {Implicit} Define Generic socket */

/* socket is socket */


/* Define Method socket{<integer>, <integer>, <integer>} */

/* socket{<integer>, <integer>, <integer>} */
long networkZnetwork_internalZsocket_METH(descriptor_t *orig_sp, long A_arg1 /* arg1 */, long A_arg2 /* arg2 */, long A_arg3 /* arg3 */, heapptr_t A3)
{
    descriptor_t *cluster_0_top;
    long L_result_value; /* result-value */


    /* #line 735 "./macros.dylan" */
    L_result_value = socket(A_arg1, A_arg2, A_arg3);
    return L_result_value;
}

/* generic-entry for socket{<integer>, <integer>, <integer>} */
descriptor_t * networkZnetwork_internalZsocket_METH_GENERIC(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    descriptor_t L_arg; /* arg */
    descriptor_t L_arg_2; /* arg */
    descriptor_t L_arg_3; /* arg */
    long L_arg_4; /* arg */
    long L_arg_5; /* arg */
    long L_arg_6; /* arg */
    long L_result0; /* result0 */
    descriptor_t L_temp;

    /* #line {Class <unknown-source-location>} */
    L_args = ((void *)(orig_sp - 3));
    L_arg = (((descriptor_t *)L_args)[0]);
    L_arg_2 = (((descriptor_t *)L_args)[1]);
    L_arg_3 = (((descriptor_t *)L_args)[2]);
    L_arg_4 = L_arg.dataword.l;
    L_arg_5 = L_arg_2.dataword.l;
    L_arg_6 = L_arg_3.dataword.l;
    orig_sp = L_args;
    /* socket{<integer>, <integer>, <integer>} */
    L_result0 = networkZnetwork_internalZsocket_METH(orig_sp, L_arg_4, L_arg_5, L_arg_6, A_next_method_info);
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* Define Class <int*> */

/* <int*> is <int*> */

extern struct heapobj networkZnetwork_internalZCLS_intV_HEAP;

/* maker for <int*> */
void * networkZnetwork_internalZCLS_intV_MAKER_FUN(descriptor_t *orig_sp, void * A_pointer /* pointer */, int A_pointer_suppliedQUERY /* pointer-supplied? */)
{
    descriptor_t *cluster_0_top;


    /* #line 190 "./sockets-api.dylan" */
    if (A_pointer_suppliedQUERY) {
	return A_pointer;
    }
    else {
	/* missing-required-init-keyword-error */
	dylanZdylan_visceraZmissing_required_init_keyword_error_FUN(orig_sp, &SYM_pointer_HEAP, &networkZnetwork_internalZCLS_intV_HEAP);
	not_reached();
    }
}

extern descriptor_t networkZliteral_7;	/* proxy for <int*> */

/* general-entry for maker for <int*> */
descriptor_t * networkZnetwork_internalZCLS_intV_MAKER_GENERAL(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    void * L_pointer; /* pointer */
    int L_pointer_suppliedQUERY; /* pointer-supplied? */
    long L_index; /* index */
    descriptor_t L_temp; /* temp */
    descriptor_t L_value; /* value */
    descriptor_t L_temp_2;
    descriptor_t L_temp_3;
    void * L_result0; /* result0 */
    descriptor_t L_temp_4;

    /* #line {Class <unknown-source-location>} */

    /* #line 126 "./cmp.dylan" */

    /* #line 209 "./num.dylan" */
    if (((A_nargs & 1) == 0)) {
	/* #line {Class <unknown-source-location>} */
	L_args = ((void *)(orig_sp - A_nargs));
	L_pointer = 0;
	L_pointer_suppliedQUERY = FALSE;
	L_index = (A_nargs - 2);
	while (1) {
	    if ((L_index < 0)) {
		goto block0;
	    }
	    else {
		L_temp = (((descriptor_t *)L_args)[L_index]);

		/* #line 386 "./condition.dylan" */
		if ((&dylanZdylan_visceraZCLS_symbol_HEAP == SLOT(L_temp.heapptr, heapptr_t, 0))) {
		    /* #line {Class <unknown-source-location>} */
		    L_value = (((descriptor_t *)L_args)[(L_index + 1)]);
		    if ((L_temp.heapptr == &SYM_pointer_HEAP)) {

			/* #line 386 "./condition.dylan" */
			if ((&dylanZdylan_visceraZCLS_raw_pointer_HEAP == SLOT(L_value.heapptr, heapptr_t, 0))) {
			    /* #line {Class <unknown-source-location>} */
			    L_pointer = L_value.dataword.ptr;
			    L_pointer_suppliedQUERY = TRUE;
			}
			else {

			    /* #line 389 "./condition.dylan" */
			    L_temp_2.heapptr = &networkZstr_ROOT;
			    L_temp_2.dataword.l = 0;
			    /* type-error-with-location */
			    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_value, &dylanZdylan_visceraZCLS_raw_pointer_HEAP, L_temp_2);
			    not_reached();
			}
		    }
		    /* #line {Class <unknown-source-location>} */
		    L_index = (L_index - 2);
		}
		else {

		    /* #line 389 "./condition.dylan" */
		    L_temp_3.heapptr = &networkZstr_ROOT;
		    L_temp_3.dataword.l = 0;
		    /* type-error-with-location */
		    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp, &dylanZdylan_visceraZCLS_symbol_HEAP, L_temp_3);
		    not_reached();
		}
	    }
	}
      block0:;
	/* #line {Class <unknown-source-location>} */
	orig_sp = L_args;
	/* maker for <int*> */
	L_result0 = networkZnetwork_internalZCLS_intV_MAKER_FUN(orig_sp, L_pointer, L_pointer_suppliedQUERY);
	L_temp_4.heapptr = networkZliteral_7.heapptr;
	L_temp_4.dataword.ptr = L_result0;
	orig_sp[0] = L_temp_4;
	return orig_sp + 1;
    }
    else {
	/* odd-number-of-keyword/value-arguments-error */
	dylanZdylan_visceraZodd_number_of_keywordSLASHvalue_arguments_error_FUN(orig_sp);
	not_reached();
    }
}


/* Define Sealed Domain make (singleton(<int*>)) */


/* Define Method pointer-value{<int*>} */

extern struct heapobj networkZstr_ROOT_7;

/* pointer-value{<int*>} */
long networkZnetwork_internalZpointer_value_METH_4(descriptor_t *orig_sp, descriptor_t A_ptr /* ptr */, heapptr_t A_next_method_info /* next-method-info */, heapptr_t A_rest /* rest */, descriptor_t A_index /* index */)
{
    descriptor_t *cluster_0_top;
    descriptor_t L_temp;
    descriptor_t L_arg2; /* arg2 */
    descriptor_t L_temp_2;


    /* #line 197 "./sockets-api.dylan" */
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = 4;
    orig_sp[0] = A_index;
    orig_sp[1] = L_temp;
    /* * */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZV_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_arg2 = (orig_sp == cluster_0_top ? dylanZfalse : orig_sp[0]);

    /* #line 386 "./condition.dylan" */
    if ((&dylanZdylan_visceraZCLS_integer_HEAP == SLOT(L_arg2.heapptr, heapptr_t, 0))) {

	/* #line 197 "./sockets-api.dylan" */

	/* #line 198 "./melange.dylan" */

	/* #line 91 "./rawptr.dylan" */
	return (*(long *)((char *)A_ptr.dataword.ptr + L_arg2.dataword.l ));
    }
    else {

	/* #line 389 "./condition.dylan" */
	L_temp_2.heapptr = &networkZstr_ROOT_7;
	L_temp_2.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_arg2, &dylanZdylan_visceraZCLS_integer_HEAP, L_temp_2);
	not_reached();
    }
}

/* generic-entry for pointer-value{<int*>} */
descriptor_t * networkZnetwork_internalZpointer_value_METH_GENERIC_4(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    descriptor_t L_arg; /* arg */
    heapptr_t L_rest; /* rest */
    descriptor_t L_arg_2; /* arg */
    descriptor_t L_index; /* index */
    long L_index_2; /* index */
    descriptor_t L_key; /* key */
    descriptor_t L_value; /* value */
    long L_result0; /* result0 */
    descriptor_t L_temp;

    /* #line {Class <unknown-source-location>} */
    L_args = ((void *)(orig_sp - A_nargs));
    L_arg = (((descriptor_t *)L_args)[0]);
    L_rest = dylanZdylan_visceraZmake_rest_arg_FUN(orig_sp, (descriptor_t *)L_args + 1, A_nargs - 1);
    L_arg_2 = L_arg;
    L_index.heapptr = networkZliteral_2.heapptr;
    L_index.dataword.l = 0;
    L_index_2 = (A_nargs - 2);
    while (1) {
	if ((L_index_2 < 1)) {
	    goto block0;
	}
	else {
	    L_key = (((descriptor_t *)L_args)[L_index_2]);
	    L_value = (((descriptor_t *)L_args)[(L_index_2 + 1)]);
	    if ((L_key.heapptr == &SYM_index_HEAP)) {
		L_index = L_value;
	    }
	    L_index_2 = (L_index_2 - 2);
	}
    }
  block0:;
    orig_sp = L_args;
    /* pointer-value{<int*>} */
    L_result0 = networkZnetwork_internalZpointer_value_METH_4(orig_sp, L_arg_2, A_next_method_info, L_rest, L_index);
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* Define Method pointer-value-setter{<integer>, <int*>} */

/* pointer-value-setter{<integer>, <int*>} */
long networkZnetwork_internalZpointer_value_setter_METH_2(descriptor_t *orig_sp, long A_value /* value */, descriptor_t A_ptr /* ptr */, heapptr_t A_next_method_info /* next-method-info */, heapptr_t A_rest /* rest */, descriptor_t A_index /* index */)
{
    descriptor_t *cluster_0_top;
    descriptor_t L_temp;
    descriptor_t L_arg3; /* arg3 */
    descriptor_t L_temp_2;


    /* #line 203 "./sockets-api.dylan" */
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = 4;
    orig_sp[0] = A_index;
    orig_sp[1] = L_temp;
    /* * */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZV_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_arg3 = (orig_sp == cluster_0_top ? dylanZfalse : orig_sp[0]);

    /* #line 386 "./condition.dylan" */
    if ((&dylanZdylan_visceraZCLS_integer_HEAP == SLOT(L_arg3.heapptr, heapptr_t, 0))) {
	/* #line {Class <unknown-source-location>} */

	/* #line 97 "./rawptr.dylan" */
	*(long *)((char *)A_ptr.dataword.ptr + L_arg3.dataword.l) = A_value;
	return A_value;
    }
    else {

	/* #line 389 "./condition.dylan" */
	L_temp_2.heapptr = &networkZstr_ROOT;
	L_temp_2.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_arg3, &dylanZdylan_visceraZCLS_integer_HEAP, L_temp_2);
	not_reached();
    }
}

/* generic-entry for pointer-value-setter{<integer>, <int*>} */
descriptor_t * networkZnetwork_internalZpointer_value_setter_METH_GENERIC_2(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    descriptor_t L_arg; /* arg */
    descriptor_t L_arg_2; /* arg */
    heapptr_t L_rest; /* rest */
    long L_arg_3; /* arg */
    descriptor_t L_arg_4; /* arg */
    descriptor_t L_index; /* index */
    long L_index_2; /* index */
    descriptor_t L_key; /* key */
    descriptor_t L_value; /* value */
    long L_result0; /* result0 */
    descriptor_t L_temp;

    /* #line {Class <unknown-source-location>} */
    L_args = ((void *)(orig_sp - A_nargs));
    L_arg = (((descriptor_t *)L_args)[0]);
    L_arg_2 = (((descriptor_t *)L_args)[1]);
    L_rest = dylanZdylan_visceraZmake_rest_arg_FUN(orig_sp, (descriptor_t *)L_args + 2, A_nargs - 2);
    L_arg_3 = L_arg.dataword.l;
    L_arg_4 = L_arg_2;
    L_index.heapptr = networkZliteral_2.heapptr;
    L_index.dataword.l = 0;
    L_index_2 = (A_nargs - 2);
    while (1) {
	if ((L_index_2 < 2)) {
	    goto block0;
	}
	else {
	    L_key = (((descriptor_t *)L_args)[L_index_2]);
	    L_value = (((descriptor_t *)L_args)[(L_index_2 + 1)]);
	    if ((L_key.heapptr == &SYM_index_HEAP)) {
		L_index = L_value;
	    }
	    L_index_2 = (L_index_2 - 2);
	}
    }
  block0:;
    orig_sp = L_args;
    /* pointer-value-setter{<integer>, <int*>} */
    L_result0 = networkZnetwork_internalZpointer_value_setter_METH_2(orig_sp, L_arg_3, L_arg_4, A_next_method_info, L_rest, L_index);
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* Define Method content-size{subclass(<int*>)} */

/* content-size{subclass(<int*>)} */
long networkZnetwork_internalZcontent_size_METH_5(descriptor_t *orig_sp, heapptr_t A0, heapptr_t A1)
{

    return 4;
}

/* generic-entry for content-size{subclass(<int*>)} */
descriptor_t * networkZnetwork_internalZcontent_size_METH_GENERIC_5(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    descriptor_t L_arg; /* arg */
    heapptr_t L_arg_2; /* arg */
    long L_result0; /* result0 */
    descriptor_t L_temp;

    L_args = ((void *)(orig_sp - 1));
    L_arg = (((descriptor_t *)L_args)[0]);
    L_arg_2 = L_arg.heapptr;
    orig_sp = L_args;
    /* content-size{subclass(<int*>)} */
    L_result0 = networkZnetwork_internalZcontent_size_METH_5(orig_sp, L_arg_2, A_next_method_info);
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* Define Class <int<@2>> */

/* <int<@2>> is <int<@2>> */

extern struct heapobj networkZnetwork_internalZCLS_intLESSX402GREATER_HEAP;

/* maker for <int<@2>> */
void * networkZnetwork_internalZCLS_intLESSX402GREATER_MAKER_FUN(descriptor_t *orig_sp, void * A_pointer /* pointer */, int A_pointer_suppliedQUERY /* pointer-supplied? */)
{
    descriptor_t *cluster_0_top;


    /* #line 211 "./sockets-api.dylan" */
    if (A_pointer_suppliedQUERY) {
	return A_pointer;
    }
    else {
	/* missing-required-init-keyword-error */
	dylanZdylan_visceraZmissing_required_init_keyword_error_FUN(orig_sp, &SYM_pointer_HEAP, &networkZnetwork_internalZCLS_intLESSX402GREATER_HEAP);
	not_reached();
    }
}

extern descriptor_t networkZliteral_8;	/* proxy for <int<@2>> */

/* general-entry for maker for <int<@2>> */
descriptor_t * networkZnetwork_internalZCLS_intLESSX402GREATER_MAKER_GENERAL(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    void * L_pointer; /* pointer */
    int L_pointer_suppliedQUERY; /* pointer-supplied? */
    long L_index; /* index */
    descriptor_t L_temp; /* temp */
    descriptor_t L_value; /* value */
    descriptor_t L_temp_2;
    descriptor_t L_temp_3;
    void * L_result0; /* result0 */
    descriptor_t L_temp_4;

    /* #line {Class <unknown-source-location>} */

    /* #line 126 "./cmp.dylan" */

    /* #line 209 "./num.dylan" */
    if (((A_nargs & 1) == 0)) {
	/* #line {Class <unknown-source-location>} */
	L_args = ((void *)(orig_sp - A_nargs));
	L_pointer = 0;
	L_pointer_suppliedQUERY = FALSE;
	L_index = (A_nargs - 2);
	while (1) {
	    if ((L_index < 0)) {
		goto block0;
	    }
	    else {
		L_temp = (((descriptor_t *)L_args)[L_index]);

		/* #line 386 "./condition.dylan" */
		if ((&dylanZdylan_visceraZCLS_symbol_HEAP == SLOT(L_temp.heapptr, heapptr_t, 0))) {
		    /* #line {Class <unknown-source-location>} */
		    L_value = (((descriptor_t *)L_args)[(L_index + 1)]);
		    if ((L_temp.heapptr == &SYM_pointer_HEAP)) {

			/* #line 386 "./condition.dylan" */
			if ((&dylanZdylan_visceraZCLS_raw_pointer_HEAP == SLOT(L_value.heapptr, heapptr_t, 0))) {
			    /* #line {Class <unknown-source-location>} */
			    L_pointer = L_value.dataword.ptr;
			    L_pointer_suppliedQUERY = TRUE;
			}
			else {

			    /* #line 389 "./condition.dylan" */
			    L_temp_2.heapptr = &networkZstr_ROOT;
			    L_temp_2.dataword.l = 0;
			    /* type-error-with-location */
			    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_value, &dylanZdylan_visceraZCLS_raw_pointer_HEAP, L_temp_2);
			    not_reached();
			}
		    }
		    /* #line {Class <unknown-source-location>} */
		    L_index = (L_index - 2);
		}
		else {

		    /* #line 389 "./condition.dylan" */
		    L_temp_3.heapptr = &networkZstr_ROOT;
		    L_temp_3.dataword.l = 0;
		    /* type-error-with-location */
		    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp, &dylanZdylan_visceraZCLS_symbol_HEAP, L_temp_3);
		    not_reached();
		}
	    }
	}
      block0:;
	/* #line {Class <unknown-source-location>} */
	orig_sp = L_args;
	/* maker for <int<@2>> */
	L_result0 = networkZnetwork_internalZCLS_intLESSX402GREATER_MAKER_FUN(orig_sp, L_pointer, L_pointer_suppliedQUERY);
	L_temp_4.heapptr = networkZliteral_8.heapptr;
	L_temp_4.dataword.ptr = L_result0;
	orig_sp[0] = L_temp_4;
	return orig_sp + 1;
    }
    else {
	/* odd-number-of-keyword/value-arguments-error */
	dylanZdylan_visceraZodd_number_of_keywordSLASHvalue_arguments_error_FUN(orig_sp);
	not_reached();
    }
}


/* Define Sealed Domain make (singleton(<int<@2>>)) */


/* Define Method content-size{singleton(<int<@2>>)} */

/* content-size{singleton(<int<@2>>)} */
long networkZnetwork_internalZcontent_size_METH_6(descriptor_t *orig_sp, heapptr_t A0, heapptr_t A1)
{

    return 2;
}

/* generic-entry for content-size{singleton(<int<@2>>)} */
descriptor_t * networkZnetwork_internalZcontent_size_METH_GENERIC_6(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    long L_result0; /* result0 */
    descriptor_t L_temp;

    orig_sp = ((void *)(orig_sp - 1));
    /* content-size{singleton(<int<@2>>)} */
    L_result0 = networkZnetwork_internalZcontent_size_METH_6(orig_sp, &networkZnetwork_internalZCLS_intLESSX402GREATER_HEAP, A_next_method_info);
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* {Implicit} Define Generic socketpair */

/* socketpair is socketpair */


/* Define Method socketpair{<integer>, <integer>, <integer>, <int<@2>>} */

/* socketpair{<integer>, <integer>, <integer>, <int<@2>>} */
long networkZnetwork_internalZsocketpair_METH(descriptor_t *orig_sp, long A_arg1 /* arg1 */, long A_arg2 /* arg2 */, long A_arg3 /* arg3 */, void * A_arg4 /* arg4 */, heapptr_t A4)
{
    descriptor_t *cluster_0_top;
    long L_result_value; /* result-value */


    /* #line 223 "./sockets-api.dylan" */

    /* #line 735 "./macros.dylan" */
    L_result_value = socketpair(A_arg1, A_arg2, A_arg3, A_arg4);
    return L_result_value;
}


/* Define Constant <sa-family-t> */

/* <sa-family-t> is <integer> */


/* Define Class <c-char-vector> */

/* <c-char-vector> is <c-char-vector> */

extern struct heapobj networkZnetwork_internalZCLS_c_char_vector_HEAP;

/* maker for <c-char-vector> */
void * networkZnetwork_internalZCLS_c_char_vector_MAKER_FUN(descriptor_t *orig_sp, void * A_pointer /* pointer */, int A_pointer_suppliedQUERY /* pointer-supplied? */)
{
    descriptor_t *cluster_0_top;


    /* #line 229 "./sockets-api.dylan" */
    if (A_pointer_suppliedQUERY) {
	return A_pointer;
    }
    else {
	/* missing-required-init-keyword-error */
	dylanZdylan_visceraZmissing_required_init_keyword_error_FUN(orig_sp, &SYM_pointer_HEAP, &networkZnetwork_internalZCLS_c_char_vector_HEAP);
	not_reached();
    }
}

extern descriptor_t networkZliteral_9;	/* proxy for <c-char-vector> */

/* general-entry for maker for <c-char-vector> */
descriptor_t * networkZnetwork_internalZCLS_c_char_vector_MAKER_GENERAL(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    void * L_pointer; /* pointer */
    int L_pointer_suppliedQUERY; /* pointer-supplied? */
    long L_index; /* index */
    descriptor_t L_temp; /* temp */
    descriptor_t L_value; /* value */
    descriptor_t L_temp_2;
    descriptor_t L_temp_3;
    void * L_result0; /* result0 */
    descriptor_t L_temp_4;

    /* #line {Class <unknown-source-location>} */

    /* #line 126 "./cmp.dylan" */

    /* #line 209 "./num.dylan" */
    if (((A_nargs & 1) == 0)) {
	/* #line {Class <unknown-source-location>} */
	L_args = ((void *)(orig_sp - A_nargs));
	L_pointer = 0;
	L_pointer_suppliedQUERY = FALSE;
	L_index = (A_nargs - 2);
	while (1) {
	    if ((L_index < 0)) {
		goto block0;
	    }
	    else {
		L_temp = (((descriptor_t *)L_args)[L_index]);

		/* #line 386 "./condition.dylan" */
		if ((&dylanZdylan_visceraZCLS_symbol_HEAP == SLOT(L_temp.heapptr, heapptr_t, 0))) {
		    /* #line {Class <unknown-source-location>} */
		    L_value = (((descriptor_t *)L_args)[(L_index + 1)]);
		    if ((L_temp.heapptr == &SYM_pointer_HEAP)) {

			/* #line 386 "./condition.dylan" */
			if ((&dylanZdylan_visceraZCLS_raw_pointer_HEAP == SLOT(L_value.heapptr, heapptr_t, 0))) {
			    /* #line {Class <unknown-source-location>} */
			    L_pointer = L_value.dataword.ptr;
			    L_pointer_suppliedQUERY = TRUE;
			}
			else {

			    /* #line 389 "./condition.dylan" */
			    L_temp_2.heapptr = &networkZstr_ROOT;
			    L_temp_2.dataword.l = 0;
			    /* type-error-with-location */
			    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_value, &dylanZdylan_visceraZCLS_raw_pointer_HEAP, L_temp_2);
			    not_reached();
			}
		    }
		    /* #line {Class <unknown-source-location>} */
		    L_index = (L_index - 2);
		}
		else {

		    /* #line 389 "./condition.dylan" */
		    L_temp_3.heapptr = &networkZstr_ROOT;
		    L_temp_3.dataword.l = 0;
		    /* type-error-with-location */
		    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp, &dylanZdylan_visceraZCLS_symbol_HEAP, L_temp_3);
		    not_reached();
		}
	    }
	}
      block0:;
	/* #line {Class <unknown-source-location>} */
	orig_sp = L_args;
	/* maker for <c-char-vector> */
	L_result0 = networkZnetwork_internalZCLS_c_char_vector_MAKER_FUN(orig_sp, L_pointer, L_pointer_suppliedQUERY);
	L_temp_4.heapptr = networkZliteral_9.heapptr;
	L_temp_4.dataword.ptr = L_result0;
	orig_sp[0] = L_temp_4;
	return orig_sp + 1;
    }
    else {
	/* odd-number-of-keyword/value-arguments-error */
	dylanZdylan_visceraZodd_number_of_keywordSLASHvalue_arguments_error_FUN(orig_sp);
	not_reached();
    }
}


/* Define Sealed Domain make (singleton(<c-char-vector>)) */


/* Define Method pointer-value{<c-char-vector>} */

extern struct heapobj networkZstr_ROOT_8;

/* pointer-value{<c-char-vector>} */
long networkZnetwork_internalZpointer_value_METH_5(descriptor_t *orig_sp, descriptor_t A_ptr /* ptr */, heapptr_t A_next_method_info /* next-method-info */, heapptr_t A_rest /* rest */, descriptor_t A_index /* index */)
{
    descriptor_t *cluster_0_top;
    descriptor_t L_temp;
    descriptor_t L_arg2; /* arg2 */
    descriptor_t L_temp_2;


    /* #line 236 "./sockets-api.dylan" */
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = 1;
    orig_sp[0] = A_index;
    orig_sp[1] = L_temp;
    /* * */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZV_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_arg2 = (orig_sp == cluster_0_top ? dylanZfalse : orig_sp[0]);

    /* #line 386 "./condition.dylan" */
    if ((&dylanZdylan_visceraZCLS_integer_HEAP == SLOT(L_arg2.heapptr, heapptr_t, 0))) {

	/* #line 236 "./sockets-api.dylan" */

	/* #line 146 "./melange.dylan" */

	/* #line 91 "./rawptr.dylan" */
	return (*(signed char *)((char *)A_ptr.dataword.ptr + L_arg2.dataword.l ));
    }
    else {

	/* #line 389 "./condition.dylan" */
	L_temp_2.heapptr = &networkZstr_ROOT_8;
	L_temp_2.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_arg2, &dylanZdylan_visceraZCLS_integer_HEAP, L_temp_2);
	not_reached();
    }
}

/* generic-entry for pointer-value{<c-char-vector>} */
descriptor_t * networkZnetwork_internalZpointer_value_METH_GENERIC_5(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    descriptor_t L_arg; /* arg */
    heapptr_t L_rest; /* rest */
    descriptor_t L_arg_2; /* arg */
    descriptor_t L_index; /* index */
    long L_index_2; /* index */
    descriptor_t L_key; /* key */
    descriptor_t L_value; /* value */
    long L_result0; /* result0 */
    descriptor_t L_temp;

    /* #line {Class <unknown-source-location>} */
    L_args = ((void *)(orig_sp - A_nargs));
    L_arg = (((descriptor_t *)L_args)[0]);
    L_rest = dylanZdylan_visceraZmake_rest_arg_FUN(orig_sp, (descriptor_t *)L_args + 1, A_nargs - 1);
    L_arg_2 = L_arg;
    L_index.heapptr = networkZliteral_2.heapptr;
    L_index.dataword.l = 0;
    L_index_2 = (A_nargs - 2);
    while (1) {
	if ((L_index_2 < 1)) {
	    goto block0;
	}
	else {
	    L_key = (((descriptor_t *)L_args)[L_index_2]);
	    L_value = (((descriptor_t *)L_args)[(L_index_2 + 1)]);
	    if ((L_key.heapptr == &SYM_index_HEAP)) {
		L_index = L_value;
	    }
	    L_index_2 = (L_index_2 - 2);
	}
    }
  block0:;
    orig_sp = L_args;
    /* pointer-value{<c-char-vector>} */
    L_result0 = networkZnetwork_internalZpointer_value_METH_5(orig_sp, L_arg_2, A_next_method_info, L_rest, L_index);
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* Define Method pointer-value-setter{<integer>, <c-char-vector>} */

/* pointer-value-setter{<integer>, <c-char-vector>} */
long networkZnetwork_internalZpointer_value_setter_METH_3(descriptor_t *orig_sp, long A_value /* value */, descriptor_t A_ptr /* ptr */, heapptr_t A_next_method_info /* next-method-info */, heapptr_t A_rest /* rest */, descriptor_t A_index /* index */)
{
    descriptor_t *cluster_0_top;
    descriptor_t L_temp;
    descriptor_t L_arg3; /* arg3 */
    descriptor_t L_temp_2;


    /* #line 242 "./sockets-api.dylan" */
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = 1;
    orig_sp[0] = A_index;
    orig_sp[1] = L_temp;
    /* * */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZV_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_arg3 = (orig_sp == cluster_0_top ? dylanZfalse : orig_sp[0]);

    /* #line 386 "./condition.dylan" */
    if ((&dylanZdylan_visceraZCLS_integer_HEAP == SLOT(L_arg3.heapptr, heapptr_t, 0))) {
	/* #line {Class <unknown-source-location>} */

	/* #line 97 "./rawptr.dylan" */
	*(signed char *)((char *)A_ptr.dataword.ptr + L_arg3.dataword.l) = A_value;
	return A_value;
    }
    else {

	/* #line 389 "./condition.dylan" */
	L_temp_2.heapptr = &networkZstr_ROOT;
	L_temp_2.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_arg3, &dylanZdylan_visceraZCLS_integer_HEAP, L_temp_2);
	not_reached();
    }
}

/* generic-entry for pointer-value-setter{<integer>, <c-char-vector>} */
descriptor_t * networkZnetwork_internalZpointer_value_setter_METH_GENERIC_3(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    descriptor_t L_arg; /* arg */
    descriptor_t L_arg_2; /* arg */
    heapptr_t L_rest; /* rest */
    long L_arg_3; /* arg */
    descriptor_t L_arg_4; /* arg */
    descriptor_t L_index; /* index */
    long L_index_2; /* index */
    descriptor_t L_key; /* key */
    descriptor_t L_value; /* value */
    long L_result0; /* result0 */
    descriptor_t L_temp;

    /* #line {Class <unknown-source-location>} */
    L_args = ((void *)(orig_sp - A_nargs));
    L_arg = (((descriptor_t *)L_args)[0]);
    L_arg_2 = (((descriptor_t *)L_args)[1]);
    L_rest = dylanZdylan_visceraZmake_rest_arg_FUN(orig_sp, (descriptor_t *)L_args + 2, A_nargs - 2);
    L_arg_3 = L_arg.dataword.l;
    L_arg_4 = L_arg_2;
    L_index.heapptr = networkZliteral_2.heapptr;
    L_index.dataword.l = 0;
    L_index_2 = (A_nargs - 2);
    while (1) {
	if ((L_index_2 < 2)) {
	    goto block0;
	}
	else {
	    L_key = (((descriptor_t *)L_args)[L_index_2]);
	    L_value = (((descriptor_t *)L_args)[(L_index_2 + 1)]);
	    if ((L_key.heapptr == &SYM_index_HEAP)) {
		L_index = L_value;
	    }
	    L_index_2 = (L_index_2 - 2);
	}
    }
  block0:;
    orig_sp = L_args;
    /* pointer-value-setter{<integer>, <c-char-vector>} */
    L_result0 = networkZnetwork_internalZpointer_value_setter_METH_3(orig_sp, L_arg_3, L_arg_4, A_next_method_info, L_rest, L_index);
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* Define Method content-size{subclass(<c-char-vector>)} */

/* content-size{subclass(<c-char-vector>)} */
long networkZnetwork_internalZcontent_size_METH_7(descriptor_t *orig_sp, heapptr_t A0, heapptr_t A1)
{

    return 1;
}

/* generic-entry for content-size{subclass(<c-char-vector>)} */
descriptor_t * networkZnetwork_internalZcontent_size_METH_GENERIC_7(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    descriptor_t L_arg; /* arg */
    heapptr_t L_arg_2; /* arg */
    long L_result0; /* result0 */
    descriptor_t L_temp;

    L_args = ((void *)(orig_sp - 1));
    L_arg = (((descriptor_t *)L_args)[0]);
    L_arg_2 = L_arg.heapptr;
    orig_sp = L_args;
    /* content-size{subclass(<c-char-vector>)} */
    L_result0 = networkZnetwork_internalZcontent_size_METH_7(orig_sp, L_arg_2, A_next_method_info);
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* Define Class <char<@14>> */

/* <char<@14>> is <char<@14>> */

extern struct heapobj networkZnetwork_internalZCLS_charLESSX4014GREATER_HEAP;

/* maker for <char<@14>> */
void * networkZnetwork_internalZCLS_charLESSX4014GREATER_MAKER_FUN(descriptor_t *orig_sp, void * A_pointer /* pointer */, int A_pointer_suppliedQUERY /* pointer-supplied? */)
{
    descriptor_t *cluster_0_top;


    /* #line 250 "./sockets-api.dylan" */
    if (A_pointer_suppliedQUERY) {
	return A_pointer;
    }
    else {
	/* missing-required-init-keyword-error */
	dylanZdylan_visceraZmissing_required_init_keyword_error_FUN(orig_sp, &SYM_pointer_HEAP, &networkZnetwork_internalZCLS_charLESSX4014GREATER_HEAP);
	not_reached();
    }
}

extern descriptor_t networkZliteral_10;	/* proxy for <char<@14>> */

/* general-entry for maker for <char<@14>> */
descriptor_t * networkZnetwork_internalZCLS_charLESSX4014GREATER_MAKER_GENERAL(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    void * L_pointer; /* pointer */
    int L_pointer_suppliedQUERY; /* pointer-supplied? */
    long L_index; /* index */
    descriptor_t L_temp; /* temp */
    descriptor_t L_value; /* value */
    descriptor_t L_temp_2;
    descriptor_t L_temp_3;
    void * L_result0; /* result0 */
    descriptor_t L_temp_4;

    /* #line {Class <unknown-source-location>} */

    /* #line 126 "./cmp.dylan" */

    /* #line 209 "./num.dylan" */
    if (((A_nargs & 1) == 0)) {
	/* #line {Class <unknown-source-location>} */
	L_args = ((void *)(orig_sp - A_nargs));
	L_pointer = 0;
	L_pointer_suppliedQUERY = FALSE;
	L_index = (A_nargs - 2);
	while (1) {
	    if ((L_index < 0)) {
		goto block0;
	    }
	    else {
		L_temp = (((descriptor_t *)L_args)[L_index]);

		/* #line 386 "./condition.dylan" */
		if ((&dylanZdylan_visceraZCLS_symbol_HEAP == SLOT(L_temp.heapptr, heapptr_t, 0))) {
		    /* #line {Class <unknown-source-location>} */
		    L_value = (((descriptor_t *)L_args)[(L_index + 1)]);
		    if ((L_temp.heapptr == &SYM_pointer_HEAP)) {

			/* #line 386 "./condition.dylan" */
			if ((&dylanZdylan_visceraZCLS_raw_pointer_HEAP == SLOT(L_value.heapptr, heapptr_t, 0))) {
			    /* #line {Class <unknown-source-location>} */
			    L_pointer = L_value.dataword.ptr;
			    L_pointer_suppliedQUERY = TRUE;
			}
			else {

			    /* #line 389 "./condition.dylan" */
			    L_temp_2.heapptr = &networkZstr_ROOT;
			    L_temp_2.dataword.l = 0;
			    /* type-error-with-location */
			    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_value, &dylanZdylan_visceraZCLS_raw_pointer_HEAP, L_temp_2);
			    not_reached();
			}
		    }
		    /* #line {Class <unknown-source-location>} */
		    L_index = (L_index - 2);
		}
		else {

		    /* #line 389 "./condition.dylan" */
		    L_temp_3.heapptr = &networkZstr_ROOT;
		    L_temp_3.dataword.l = 0;
		    /* type-error-with-location */
		    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp, &dylanZdylan_visceraZCLS_symbol_HEAP, L_temp_3);
		    not_reached();
		}
	    }
	}
      block0:;
	/* #line {Class <unknown-source-location>} */
	orig_sp = L_args;
	/* maker for <char<@14>> */
	L_result0 = networkZnetwork_internalZCLS_charLESSX4014GREATER_MAKER_FUN(orig_sp, L_pointer, L_pointer_suppliedQUERY);
	L_temp_4.heapptr = networkZliteral_10.heapptr;
	L_temp_4.dataword.ptr = L_result0;
	orig_sp[0] = L_temp_4;
	return orig_sp + 1;
    }
    else {
	/* odd-number-of-keyword/value-arguments-error */
	dylanZdylan_visceraZodd_number_of_keywordSLASHvalue_arguments_error_FUN(orig_sp);
	not_reached();
    }
}


/* Define Sealed Domain make (singleton(<char<@14>>)) */


/* Define Method content-size{singleton(<char<@14>>)} */

/* content-size{singleton(<char<@14>>)} */
long networkZnetwork_internalZcontent_size_METH_8(descriptor_t *orig_sp, heapptr_t A0, heapptr_t A1)
{

    return 14;
}

/* generic-entry for content-size{singleton(<char<@14>>)} */
descriptor_t * networkZnetwork_internalZcontent_size_METH_GENERIC_8(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    long L_result0; /* result0 */
    descriptor_t L_temp;

    orig_sp = ((void *)(orig_sp - 1));
    /* content-size{singleton(<char<@14>>)} */
    L_result0 = networkZnetwork_internalZcontent_size_METH_8(orig_sp, &networkZnetwork_internalZCLS_charLESSX4014GREATER_HEAP, A_next_method_info);
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* Define Class <sockaddr> */

/* <sockaddr> is <sockaddr> */

extern struct heapobj networkZnetwork_internalZCLS_sockaddr_HEAP;

/* maker for <sockaddr> */
void * networkZnetwork_internalZCLS_sockaddr_MAKER_FUN(descriptor_t *orig_sp, void * A_pointer /* pointer */, int A_pointer_suppliedQUERY /* pointer-supplied? */)
{
    descriptor_t *cluster_0_top;


    /* #line 258 "./sockets-api.dylan" */
    if (A_pointer_suppliedQUERY) {
	return A_pointer;
    }
    else {
	/* missing-required-init-keyword-error */
	dylanZdylan_visceraZmissing_required_init_keyword_error_FUN(orig_sp, &SYM_pointer_HEAP, &networkZnetwork_internalZCLS_sockaddr_HEAP);
	not_reached();
    }
}

extern descriptor_t networkZliteral_11;	/* proxy for <sockaddr> */

/* general-entry for maker for <sockaddr> */
descriptor_t * networkZnetwork_internalZCLS_sockaddr_MAKER_GENERAL(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    void * L_pointer; /* pointer */
    int L_pointer_suppliedQUERY; /* pointer-supplied? */
    long L_index; /* index */
    descriptor_t L_temp; /* temp */
    descriptor_t L_value; /* value */
    descriptor_t L_temp_2;
    descriptor_t L_temp_3;
    void * L_result0; /* result0 */
    descriptor_t L_temp_4;

    /* #line {Class <unknown-source-location>} */

    /* #line 126 "./cmp.dylan" */

    /* #line 209 "./num.dylan" */
    if (((A_nargs & 1) == 0)) {
	/* #line {Class <unknown-source-location>} */
	L_args = ((void *)(orig_sp - A_nargs));
	L_pointer = 0;
	L_pointer_suppliedQUERY = FALSE;
	L_index = (A_nargs - 2);
	while (1) {
	    if ((L_index < 0)) {
		goto block0;
	    }
	    else {
		L_temp = (((descriptor_t *)L_args)[L_index]);

		/* #line 386 "./condition.dylan" */
		if ((&dylanZdylan_visceraZCLS_symbol_HEAP == SLOT(L_temp.heapptr, heapptr_t, 0))) {
		    /* #line {Class <unknown-source-location>} */
		    L_value = (((descriptor_t *)L_args)[(L_index + 1)]);
		    if ((L_temp.heapptr == &SYM_pointer_HEAP)) {

			/* #line 386 "./condition.dylan" */
			if ((&dylanZdylan_visceraZCLS_raw_pointer_HEAP == SLOT(L_value.heapptr, heapptr_t, 0))) {
			    /* #line {Class <unknown-source-location>} */
			    L_pointer = L_value.dataword.ptr;
			    L_pointer_suppliedQUERY = TRUE;
			}
			else {

			    /* #line 389 "./condition.dylan" */
			    L_temp_2.heapptr = &networkZstr_ROOT;
			    L_temp_2.dataword.l = 0;
			    /* type-error-with-location */
			    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_value, &dylanZdylan_visceraZCLS_raw_pointer_HEAP, L_temp_2);
			    not_reached();
			}
		    }
		    /* #line {Class <unknown-source-location>} */
		    L_index = (L_index - 2);
		}
		else {

		    /* #line 389 "./condition.dylan" */
		    L_temp_3.heapptr = &networkZstr_ROOT;
		    L_temp_3.dataword.l = 0;
		    /* type-error-with-location */
		    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp, &dylanZdylan_visceraZCLS_symbol_HEAP, L_temp_3);
		    not_reached();
		}
	    }
	}
      block0:;
	/* #line {Class <unknown-source-location>} */
	orig_sp = L_args;
	/* maker for <sockaddr> */
	L_result0 = networkZnetwork_internalZCLS_sockaddr_MAKER_FUN(orig_sp, L_pointer, L_pointer_suppliedQUERY);
	L_temp_4.heapptr = networkZliteral_11.heapptr;
	L_temp_4.dataword.ptr = L_result0;
	orig_sp[0] = L_temp_4;
	return orig_sp + 1;
    }
    else {
	/* odd-number-of-keyword/value-arguments-error */
	dylanZdylan_visceraZodd_number_of_keywordSLASHvalue_arguments_error_FUN(orig_sp);
	not_reached();
    }
}


/* Define Sealed Domain make (singleton(<sockaddr>)) */


/* Define Method get-sa-family{<sockaddr>} */

/* get-sa-family{<sockaddr>} */
long networkZnetwork_internalZget_sa_family_METH_2(descriptor_t *orig_sp, descriptor_t A_ptr /* ptr */, heapptr_t A1)
{
    descriptor_t *cluster_0_top;


    /* #line 185 "./melange.dylan" */

    /* #line 91 "./rawptr.dylan" */
    return (*(unsigned short *)((char *)A_ptr.dataword.ptr + 0 ));
}


/* Define Method get-sa-family-setter{<integer>, <sockaddr>} */

/* get-sa-family-setter{<integer>, <sockaddr>} */
long networkZnetwork_internalZget_sa_family_setter_METH_2(descriptor_t *orig_sp, long A_value /* value */, descriptor_t A_ptr /* ptr */, heapptr_t A2)
{
    descriptor_t *cluster_0_top;

    /* #line {Class <unknown-source-location>} */

    /* #line 97 "./rawptr.dylan" */
    *(unsigned short *)((char *)A_ptr.dataword.ptr + 0) = A_value;
    return A_value;
}


/* Define Method get-sa-data{<sockaddr>} */

extern struct heapobj networkZstr_ROOT_9;

/* get-sa-data{<sockaddr>} */
void * networkZnetwork_internalZget_sa_data_METH_2(descriptor_t *orig_sp, descriptor_t A_ptr /* ptr */, heapptr_t A1)
{
    descriptor_t *cluster_0_top;
    descriptor_t L_temp;
    descriptor_t L_temp_2;
    descriptor_t L_temp_3; /* temp */
    int L_condition; /* condition */
    descriptor_t L_temp_4;
    descriptor_t L_temp_5; /* temp */
    descriptor_t L_temp_6;
    descriptor_t L_temp_7;

    /* #line {Class <unknown-source-location>} */

    /* #line 49 "./object.dylan" */

    /* #line 324 "./melange.dylan" */

    /* #line 324 "./melange.dylan" */

    /* #line 324 "./melange.dylan" */
    L_temp.heapptr = SLOT(A_ptr.heapptr, heapptr_t, 0);
    L_temp.dataword.l = 0;
    L_temp_2.heapptr = networkZliteral_6.heapptr;
    L_temp_2.dataword.ptr = ((void *)((char *)A_ptr.dataword.ptr + 2));
    orig_sp[0] = L_temp;
    orig_sp[1] = L_temp_2;
    /* as */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZas_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_temp_3 = orig_sp[0];

    /* #line 49 "./object.dylan" */

    /* #line 386 "./condition.dylan" */
    /* %subtype?{<class>, <class>} */
    L_condition = dylanZdylan_visceraZPCTsubtypeQUERY_METH(orig_sp, SLOT(L_temp_3.heapptr, heapptr_t, 0), &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP, &dylanZliteral_ROOT_2);
    if (L_condition) {

	/* #line 324 "./melange.dylan" */

	/* #line 275 "./sockets-api.dylan" */
	L_temp_4.heapptr = &networkZnetwork_internalZCLS_charLESSX4014GREATER_HEAP;
	L_temp_4.dataword.l = 0;
	orig_sp[0] = L_temp_4;
	orig_sp[1] = L_temp_3;
	/* as */
	{
	  struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZas_HEAP, 2);
	  heapptr_t L_meth = L_temp.R0;
	  heapptr_t L_next_info = L_temp.R1;
	  cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
	}
	L_temp_5 = orig_sp[0];

	/* #line 386 "./condition.dylan" */
	if ((&networkZnetwork_internalZCLS_charLESSX4014GREATER_HEAP == SLOT(L_temp_5.heapptr, heapptr_t, 0))) {

	    /* #line 275 "./sockets-api.dylan" */
	    return L_temp_5.dataword.ptr;
	}
	else {

	    /* #line 389 "./condition.dylan" */
	    L_temp_6.heapptr = &networkZstr_ROOT_9;
	    L_temp_6.dataword.l = 0;
	    /* type-error-with-location */
	    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp_5, &networkZnetwork_internalZCLS_charLESSX4014GREATER_HEAP, L_temp_6);
	    not_reached();
	}
    }
    else {
	L_temp_7.heapptr = &networkZstr_ROOT_5;
	L_temp_7.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp_3, &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP, L_temp_7);
	not_reached();
    }
}

/* generic-entry for get-sa-data{<sockaddr>} */
descriptor_t * networkZnetwork_internalZget_sa_data_METH_GENERIC_2(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    descriptor_t L_arg; /* arg */
    descriptor_t L_arg_2; /* arg */
    void * L_result0; /* result0 */
    descriptor_t L_temp;

    /* #line {Class <unknown-source-location>} */
    L_args = ((void *)(orig_sp - 1));
    L_arg = (((descriptor_t *)L_args)[0]);
    L_arg_2 = L_arg;
    orig_sp = L_args;
    /* get-sa-data{<sockaddr>} */
    L_result0 = networkZnetwork_internalZget_sa_data_METH_2(orig_sp, L_arg_2, A_next_method_info);
    L_temp.heapptr = networkZliteral_10.heapptr;
    L_temp.dataword.ptr = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* Define Method pointer-value{<sockaddr>} */

extern struct heapobj networkZnetwork_internalZCLS_sockaddr_in_HEAP;

extern struct heapobj networkZstr_ROOT_10;

/* pointer-value{<sockaddr>} */
descriptor_t networkZnetwork_internalZpointer_value_METH_6(descriptor_t *orig_sp, descriptor_t A_value /* value */, heapptr_t A_next_method_info /* next-method-info */, heapptr_t A_rest /* rest */, descriptor_t A_index /* index */)
{
    descriptor_t *cluster_0_top;
    descriptor_t L_temp;
    descriptor_t L_arg1; /* arg1 */
    descriptor_t L_temp_2; /* temp */
    heapptr_t L_PCTobject_class; /* %object-class */
    int L_temp_3; /* temp */
    descriptor_t L_temp_4;


    /* #line 279 "./sockets-api.dylan" */
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = 16;
    orig_sp[0] = A_index;
    orig_sp[1] = L_temp;
    /* * */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZV_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_arg1 = (orig_sp == cluster_0_top ? dylanZfalse : orig_sp[0]);

    /* #line 279 "./sockets-api.dylan" */
    orig_sp[0] = A_value;
    orig_sp[1] = L_arg1;
    /* + */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZPLUS_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_temp_2 = (orig_sp == cluster_0_top ? dylanZfalse : orig_sp[0]);

    /* #line 386 "./condition.dylan" */
    L_PCTobject_class = SLOT(L_temp_2.heapptr, heapptr_t, 0);
    if ((&networkZnetwork_internalZCLS_sockaddr_in_HEAP == L_PCTobject_class)) {
	L_temp_3 = TRUE;
    }
    else {
	L_temp_3 = (&networkZnetwork_internalZCLS_sockaddr_HEAP == L_PCTobject_class);
    }
    if (L_temp_3) {

	/* #line 279 "./sockets-api.dylan" */
	return L_temp_2;
    }
    else {

	/* #line 389 "./condition.dylan" */
	L_temp_4.heapptr = &networkZstr_ROOT_10;
	L_temp_4.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp_2, &networkZnetwork_internalZCLS_sockaddr_HEAP, L_temp_4);
	not_reached();
    }
}

/* generic-entry for pointer-value{<sockaddr>} */
descriptor_t * networkZnetwork_internalZpointer_value_METH_GENERIC_6(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    descriptor_t L_arg; /* arg */
    heapptr_t L_rest; /* rest */
    descriptor_t L_arg_2; /* arg */
    descriptor_t L_index; /* index */
    long L_index_2; /* index */
    descriptor_t L_key; /* key */
    descriptor_t L_value; /* value */
    descriptor_t L_result0; /* result0 */

    /* #line {Class <unknown-source-location>} */
    L_args = ((void *)(orig_sp - A_nargs));
    L_arg = (((descriptor_t *)L_args)[0]);
    L_rest = dylanZdylan_visceraZmake_rest_arg_FUN(orig_sp, (descriptor_t *)L_args + 1, A_nargs - 1);
    L_arg_2 = L_arg;
    L_index.heapptr = networkZliteral_2.heapptr;
    L_index.dataword.l = 0;
    L_index_2 = (A_nargs - 2);
    while (1) {
	if ((L_index_2 < 1)) {
	    goto block0;
	}
	else {
	    L_key = (((descriptor_t *)L_args)[L_index_2]);
	    L_value = (((descriptor_t *)L_args)[(L_index_2 + 1)]);
	    if ((L_key.heapptr == &SYM_index_HEAP)) {
		L_index = L_value;
	    }
	    L_index_2 = (L_index_2 - 2);
	}
    }
  block0:;
    orig_sp = L_args;
    /* pointer-value{<sockaddr>} */
    L_result0 = networkZnetwork_internalZpointer_value_METH_6(orig_sp, L_arg_2, A_next_method_info, L_rest, L_index);
    orig_sp[0] = L_result0;
    return orig_sp + 1;
}


/* Define Method content-size{subclass(<sockaddr>)} */

/* content-size{subclass(<sockaddr>)} */
long networkZnetwork_internalZcontent_size_METH_9(descriptor_t *orig_sp, heapptr_t A0, heapptr_t A1)
{

    return 16;
}

/* generic-entry for content-size{subclass(<sockaddr>)} */
descriptor_t * networkZnetwork_internalZcontent_size_METH_GENERIC_9(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    descriptor_t L_arg; /* arg */
    heapptr_t L_arg_2; /* arg */
    long L_result0; /* result0 */
    descriptor_t L_temp;

    L_args = ((void *)(orig_sp - 1));
    L_arg = (((descriptor_t *)L_args)[0]);
    L_arg_2 = L_arg.heapptr;
    orig_sp = L_args;
    /* content-size{subclass(<sockaddr>)} */
    L_result0 = networkZnetwork_internalZcontent_size_METH_9(orig_sp, L_arg_2, A_next_method_info);
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* Define Constant <__socklen-t> */

/* <__socklen-t> is <integer> */


/* Define Constant <socklen-t> */

/* <socklen-t> is <integer> */


/* {Implicit} Define Generic bind */

/* bind is bind */


/* Define Method bind{<integer>, <sockaddr>, <integer>} */

/* bind{<integer>, <sockaddr>, <integer>} */
long networkZnetwork_internalZbind_METH(descriptor_t *orig_sp, long A_arg1 /* arg1 */, descriptor_t A_arg2 /* arg2 */, long A_arg3 /* arg3 */, heapptr_t A3)
{
    descriptor_t *cluster_0_top;
    long L_result_value; /* result-value */


    /* #line 294 "./sockets-api.dylan" */

    /* #line 735 "./macros.dylan" */
    L_result_value = bind(A_arg1, A_arg2.dataword.ptr, A_arg3);
    return L_result_value;
}


/* Define Class <socklen-t*> */

/* <socklen-t*> is <socklen-t*> */

extern struct heapobj networkZnetwork_internalZCLS_socklen_tV_HEAP;

/* maker for <socklen-t*> */
void * networkZnetwork_internalZCLS_socklen_tV_MAKER_FUN(descriptor_t *orig_sp, void * A_pointer /* pointer */, int A_pointer_suppliedQUERY /* pointer-supplied? */)
{
    descriptor_t *cluster_0_top;


    /* #line 298 "./sockets-api.dylan" */
    if (A_pointer_suppliedQUERY) {
	return A_pointer;
    }
    else {
	/* missing-required-init-keyword-error */
	dylanZdylan_visceraZmissing_required_init_keyword_error_FUN(orig_sp, &SYM_pointer_HEAP, &networkZnetwork_internalZCLS_socklen_tV_HEAP);
	not_reached();
    }
}

extern descriptor_t networkZliteral_12;	/* proxy for <socklen-t*> */

/* general-entry for maker for <socklen-t*> */
descriptor_t * networkZnetwork_internalZCLS_socklen_tV_MAKER_GENERAL(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    void * L_pointer; /* pointer */
    int L_pointer_suppliedQUERY; /* pointer-supplied? */
    long L_index; /* index */
    descriptor_t L_temp; /* temp */
    descriptor_t L_value; /* value */
    descriptor_t L_temp_2;
    descriptor_t L_temp_3;
    void * L_result0; /* result0 */
    descriptor_t L_temp_4;

    /* #line {Class <unknown-source-location>} */

    /* #line 126 "./cmp.dylan" */

    /* #line 209 "./num.dylan" */
    if (((A_nargs & 1) == 0)) {
	/* #line {Class <unknown-source-location>} */
	L_args = ((void *)(orig_sp - A_nargs));
	L_pointer = 0;
	L_pointer_suppliedQUERY = FALSE;
	L_index = (A_nargs - 2);
	while (1) {
	    if ((L_index < 0)) {
		goto block0;
	    }
	    else {
		L_temp = (((descriptor_t *)L_args)[L_index]);

		/* #line 386 "./condition.dylan" */
		if ((&dylanZdylan_visceraZCLS_symbol_HEAP == SLOT(L_temp.heapptr, heapptr_t, 0))) {
		    /* #line {Class <unknown-source-location>} */
		    L_value = (((descriptor_t *)L_args)[(L_index + 1)]);
		    if ((L_temp.heapptr == &SYM_pointer_HEAP)) {

			/* #line 386 "./condition.dylan" */
			if ((&dylanZdylan_visceraZCLS_raw_pointer_HEAP == SLOT(L_value.heapptr, heapptr_t, 0))) {
			    /* #line {Class <unknown-source-location>} */
			    L_pointer = L_value.dataword.ptr;
			    L_pointer_suppliedQUERY = TRUE;
			}
			else {

			    /* #line 389 "./condition.dylan" */
			    L_temp_2.heapptr = &networkZstr_ROOT;
			    L_temp_2.dataword.l = 0;
			    /* type-error-with-location */
			    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_value, &dylanZdylan_visceraZCLS_raw_pointer_HEAP, L_temp_2);
			    not_reached();
			}
		    }
		    /* #line {Class <unknown-source-location>} */
		    L_index = (L_index - 2);
		}
		else {

		    /* #line 389 "./condition.dylan" */
		    L_temp_3.heapptr = &networkZstr_ROOT;
		    L_temp_3.dataword.l = 0;
		    /* type-error-with-location */
		    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp, &dylanZdylan_visceraZCLS_symbol_HEAP, L_temp_3);
		    not_reached();
		}
	    }
	}
      block0:;
	/* #line {Class <unknown-source-location>} */
	orig_sp = L_args;
	/* maker for <socklen-t*> */
	L_result0 = networkZnetwork_internalZCLS_socklen_tV_MAKER_FUN(orig_sp, L_pointer, L_pointer_suppliedQUERY);
	L_temp_4.heapptr = networkZliteral_12.heapptr;
	L_temp_4.dataword.ptr = L_result0;
	orig_sp[0] = L_temp_4;
	return orig_sp + 1;
    }
    else {
	/* odd-number-of-keyword/value-arguments-error */
	dylanZdylan_visceraZodd_number_of_keywordSLASHvalue_arguments_error_FUN(orig_sp);
	not_reached();
    }
}


/* Define Sealed Domain make (singleton(<socklen-t*>)) */


/* Define Method pointer-value{<socklen-t*>} */

extern struct heapobj networkZstr_ROOT_11;

/* pointer-value{<socklen-t*>} */
long networkZnetwork_internalZpointer_value_METH_7(descriptor_t *orig_sp, void * A_ptr /* ptr */, heapptr_t A_next_method_info /* next-method-info */, heapptr_t A_rest /* rest */, descriptor_t A_index /* index */)
{
    descriptor_t *cluster_0_top;
    descriptor_t L_temp;
    descriptor_t L_arg2; /* arg2 */
    descriptor_t L_temp_2;


    /* #line 305 "./sockets-api.dylan" */
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = 4;
    orig_sp[0] = A_index;
    orig_sp[1] = L_temp;
    /* * */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZV_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_arg2 = (orig_sp == cluster_0_top ? dylanZfalse : orig_sp[0]);

    /* #line 386 "./condition.dylan" */
    if ((&dylanZdylan_visceraZCLS_integer_HEAP == SLOT(L_arg2.heapptr, heapptr_t, 0))) {

	/* #line 305 "./sockets-api.dylan" */

	/* #line 211 "./melange.dylan" */

	/* #line 91 "./rawptr.dylan" */
	return (*(long *)((char *)A_ptr + L_arg2.dataword.l ));
    }
    else {

	/* #line 389 "./condition.dylan" */
	L_temp_2.heapptr = &networkZstr_ROOT_11;
	L_temp_2.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_arg2, &dylanZdylan_visceraZCLS_integer_HEAP, L_temp_2);
	not_reached();
    }
}

/* generic-entry for pointer-value{<socklen-t*>} */
descriptor_t * networkZnetwork_internalZpointer_value_METH_GENERIC_7(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    descriptor_t L_arg; /* arg */
    heapptr_t L_rest; /* rest */
    void * L_arg_2; /* arg */
    descriptor_t L_index; /* index */
    long L_index_2; /* index */
    descriptor_t L_key; /* key */
    descriptor_t L_value; /* value */
    long L_result0; /* result0 */
    descriptor_t L_temp;

    /* #line {Class <unknown-source-location>} */
    L_args = ((void *)(orig_sp - A_nargs));
    L_arg = (((descriptor_t *)L_args)[0]);
    L_rest = dylanZdylan_visceraZmake_rest_arg_FUN(orig_sp, (descriptor_t *)L_args + 1, A_nargs - 1);
    L_arg_2 = L_arg.dataword.ptr;
    L_index.heapptr = networkZliteral_2.heapptr;
    L_index.dataword.l = 0;
    L_index_2 = (A_nargs - 2);
    while (1) {
	if ((L_index_2 < 1)) {
	    goto block0;
	}
	else {
	    L_key = (((descriptor_t *)L_args)[L_index_2]);
	    L_value = (((descriptor_t *)L_args)[(L_index_2 + 1)]);
	    if ((L_key.heapptr == &SYM_index_HEAP)) {
		L_index = L_value;
	    }
	    L_index_2 = (L_index_2 - 2);
	}
    }
  block0:;
    orig_sp = L_args;
    /* pointer-value{<socklen-t*>} */
    L_result0 = networkZnetwork_internalZpointer_value_METH_7(orig_sp, L_arg_2, A_next_method_info, L_rest, L_index);
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* Define Method pointer-value-setter{<integer>, <socklen-t*>} */

/* pointer-value-setter{<integer>, <socklen-t*>} */
long networkZnetwork_internalZpointer_value_setter_METH_4(descriptor_t *orig_sp, long A_value /* value */, void * A_ptr /* ptr */, heapptr_t A_next_method_info /* next-method-info */, heapptr_t A_rest /* rest */, descriptor_t A_index /* index */)
{
    descriptor_t *cluster_0_top;
    descriptor_t L_temp;
    descriptor_t L_arg3; /* arg3 */
    descriptor_t L_temp_2;


    /* #line 311 "./sockets-api.dylan" */
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = 4;
    orig_sp[0] = A_index;
    orig_sp[1] = L_temp;
    /* * */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZV_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_arg3 = (orig_sp == cluster_0_top ? dylanZfalse : orig_sp[0]);

    /* #line 386 "./condition.dylan" */
    if ((&dylanZdylan_visceraZCLS_integer_HEAP == SLOT(L_arg3.heapptr, heapptr_t, 0))) {
	/* #line {Class <unknown-source-location>} */

	/* #line 97 "./rawptr.dylan" */
	*(long *)((char *)A_ptr + L_arg3.dataword.l) = A_value;
	return A_value;
    }
    else {

	/* #line 389 "./condition.dylan" */
	L_temp_2.heapptr = &networkZstr_ROOT;
	L_temp_2.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_arg3, &dylanZdylan_visceraZCLS_integer_HEAP, L_temp_2);
	not_reached();
    }
}

/* generic-entry for pointer-value-setter{<integer>, <socklen-t*>} */
descriptor_t * networkZnetwork_internalZpointer_value_setter_METH_GENERIC_4(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    descriptor_t L_arg; /* arg */
    descriptor_t L_arg_2; /* arg */
    heapptr_t L_rest; /* rest */
    long L_arg_3; /* arg */
    void * L_arg_4; /* arg */
    descriptor_t L_index; /* index */
    long L_index_2; /* index */
    descriptor_t L_key; /* key */
    descriptor_t L_value; /* value */
    long L_result0; /* result0 */
    descriptor_t L_temp;

    /* #line {Class <unknown-source-location>} */
    L_args = ((void *)(orig_sp - A_nargs));
    L_arg = (((descriptor_t *)L_args)[0]);
    L_arg_2 = (((descriptor_t *)L_args)[1]);
    L_rest = dylanZdylan_visceraZmake_rest_arg_FUN(orig_sp, (descriptor_t *)L_args + 2, A_nargs - 2);
    L_arg_3 = L_arg.dataword.l;
    L_arg_4 = L_arg_2.dataword.ptr;
    L_index.heapptr = networkZliteral_2.heapptr;
    L_index.dataword.l = 0;
    L_index_2 = (A_nargs - 2);
    while (1) {
	if ((L_index_2 < 2)) {
	    goto block0;
	}
	else {
	    L_key = (((descriptor_t *)L_args)[L_index_2]);
	    L_value = (((descriptor_t *)L_args)[(L_index_2 + 1)]);
	    if ((L_key.heapptr == &SYM_index_HEAP)) {
		L_index = L_value;
	    }
	    L_index_2 = (L_index_2 - 2);
	}
    }
  block0:;
    orig_sp = L_args;
    /* pointer-value-setter{<integer>, <socklen-t*>} */
    L_result0 = networkZnetwork_internalZpointer_value_setter_METH_4(orig_sp, L_arg_3, L_arg_4, A_next_method_info, L_rest, L_index);
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* Define Method content-size{subclass(<socklen-t*>)} */

/* content-size{subclass(<socklen-t*>)} */
long networkZnetwork_internalZcontent_size_METH_10(descriptor_t *orig_sp, heapptr_t A0, heapptr_t A1)
{

    return 4;
}

/* generic-entry for content-size{subclass(<socklen-t*>)} */
descriptor_t * networkZnetwork_internalZcontent_size_METH_GENERIC_10(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    long L_result0; /* result0 */
    descriptor_t L_temp;

    orig_sp = ((void *)(orig_sp - 1));
    /* content-size{subclass(<socklen-t*>)} */
    L_result0 = networkZnetwork_internalZcontent_size_METH_10(orig_sp, &networkZnetwork_internalZCLS_socklen_tV_HEAP, A_next_method_info);
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* {Implicit} Define Generic getsockname */

/* getsockname is getsockname */


/* Define Method getsockname{<integer>, <sockaddr>, <socklen-t*>} */

/* getsockname{<integer>, <sockaddr>, <socklen-t*>} */
long networkZnetwork_internalZgetsockname_METH(descriptor_t *orig_sp, long A_arg1 /* arg1 */, descriptor_t A_arg2 /* arg2 */, void * A_arg3 /* arg3 */, heapptr_t A3)
{
    descriptor_t *cluster_0_top;
    long L_result_value; /* result-value */


    /* #line 323 "./sockets-api.dylan" */

    /* #line 323 "./sockets-api.dylan" */

    /* #line 735 "./macros.dylan" */
    L_result_value = getsockname(A_arg1, A_arg2.dataword.ptr, A_arg3);
    return L_result_value;
}


/* {Implicit} Define Generic connect */

/* connect is connect */


/* Define Method connect{<integer>, <sockaddr>, <integer>} */

/* connect{<integer>, <sockaddr>, <integer>} */
long networkZnetwork_internalZconnect_METH(descriptor_t *orig_sp, long A_arg1 /* arg1 */, descriptor_t A_arg2 /* arg2 */, long A_arg3 /* arg3 */, heapptr_t A3)
{
    descriptor_t *cluster_0_top;
    long L_result_value; /* result-value */

    /* #line {Class <unknown-source-location>} */

    /* #line 331 "./sockets-api.dylan" */

    /* #line 735 "./macros.dylan" */
    L_result_value = connect(A_arg1, A_arg2.dataword.ptr, A_arg3);
    return L_result_value;
}

/* generic-entry for connect{<integer>, <sockaddr>, <integer>} */
descriptor_t * networkZnetwork_internalZconnect_METH_GENERIC(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    descriptor_t L_arg; /* arg */
    descriptor_t L_arg_2; /* arg */
    descriptor_t L_arg_3; /* arg */
    long L_arg_4; /* arg */
    descriptor_t L_arg_5; /* arg */
    long L_arg_6; /* arg */
    long L_result0; /* result0 */
    descriptor_t L_temp;

    /* #line {Class <unknown-source-location>} */
    L_args = ((void *)(orig_sp - 3));
    L_arg = (((descriptor_t *)L_args)[0]);
    L_arg_2 = (((descriptor_t *)L_args)[1]);
    L_arg_3 = (((descriptor_t *)L_args)[2]);
    L_arg_4 = L_arg.dataword.l;
    L_arg_5 = L_arg_2;
    L_arg_6 = L_arg_3.dataword.l;
    orig_sp = L_args;
    /* connect{<integer>, <sockaddr>, <integer>} */
    L_result0 = networkZnetwork_internalZconnect_METH(orig_sp, L_arg_4, L_arg_5, L_arg_6, A_next_method_info);
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* {Implicit} Define Generic getpeername */

/* getpeername is getpeername */


/* Define Method getpeername{<integer>, <sockaddr>, <socklen-t*>} */

/* getpeername{<integer>, <sockaddr>, <socklen-t*>} */
long networkZnetwork_internalZgetpeername_METH(descriptor_t *orig_sp, long A_arg1 /* arg1 */, descriptor_t A_arg2 /* arg2 */, void * A_arg3 /* arg3 */, heapptr_t A3)
{
    descriptor_t *cluster_0_top;
    long L_result_value; /* result-value */


    /* #line 339 "./sockets-api.dylan" */

    /* #line 339 "./sockets-api.dylan" */

    /* #line 735 "./macros.dylan" */
    L_result_value = getpeername(A_arg1, A_arg2.dataword.ptr, A_arg3);
    return L_result_value;
}


/* Define Constant <__ssize-t> */

/* <__ssize-t> is <integer> */


/* Define Constant <ssize-t> */

/* <ssize-t> is <integer> */


/* Define Constant <size-t> */

/* <size-t> is <integer> */


/* {Implicit} Define Generic send */

/* send is send */


/* Define Method send{<integer>, <machine-pointer>, <integer>, <integer>} */

/* send{<integer>, <machine-pointer>, <integer>, <integer>} */
long networkZnetwork_internalZsend_METH(descriptor_t *orig_sp, long A_arg1 /* arg1 */, void * A_arg2 /* arg2 */, long A_arg3 /* arg3 */, long A_arg4 /* arg4 */, heapptr_t A4)
{
    descriptor_t *cluster_0_top;
    long L_result_value; /* result-value */

    /* #line {Class <unknown-source-location>} */

    /* #line 353 "./sockets-api.dylan" */

    /* #line 735 "./macros.dylan" */
    L_result_value = send(A_arg1, A_arg2, A_arg3, A_arg4);
    return L_result_value;
}


/* {Implicit} Define Generic recv */

/* recv is recv */


/* Define Method recv{<integer>, <machine-pointer>, <integer>, <integer>} */

/* recv{<integer>, <machine-pointer>, <integer>, <integer>} */
long networkZnetwork_internalZrecv_METH(descriptor_t *orig_sp, long A_arg1 /* arg1 */, void * A_arg2 /* arg2 */, long A_arg3 /* arg3 */, long A_arg4 /* arg4 */, heapptr_t A4)
{
    descriptor_t *cluster_0_top;
    long L_result_value; /* result-value */

    /* #line {Class <unknown-source-location>} */

    /* #line 361 "./sockets-api.dylan" */

    /* #line 735 "./macros.dylan" */
    L_result_value = recv(A_arg1, A_arg2, A_arg3, A_arg4);
    return L_result_value;
}


/* {Implicit} Define Generic sendto */

/* sendto is sendto */


/* Define Method sendto{<integer>, <byte-string>, <integer>, <integer>, <sockaddr>, <integer>} */

extern struct heapobj melange_supportZmelange_supportZCLS_c_string_HEAP;

extern struct heapobj melange_supportZmelange_supportZexport_value_HEAP;

extern struct heapobj networkZstr_ROOT_12;

/* sendto{<integer>, <byte-string>, <integer>, <integer>, <sockaddr>, <integer>} */
long networkZnetwork_internalZsendto_METH(descriptor_t *orig_sp, long A_arg1 /* arg1 */, heapptr_t A_arg2 /* arg2 */, long A_arg3 /* arg3 */, long A_arg4 /* arg4 */, descriptor_t A_arg5 /* arg5 */, long A_arg6 /* arg6 */, heapptr_t A6)
{
    descriptor_t *cluster_0_top;
    descriptor_t L_temp;
    descriptor_t L_temp_2;
    descriptor_t L_argument; /* argument */
    int L_condition; /* condition */
    long L_result_value; /* result-value */
    descriptor_t L_temp_3;

    /* #line {Class <unknown-source-location>} */

    /* #line 369 "./sockets-api.dylan" */
    L_temp.heapptr = &melange_supportZmelange_supportZCLS_c_string_HEAP;
    L_temp.dataword.l = 0;
    L_temp_2.heapptr = A_arg2;
    L_temp_2.dataword.l = 0;
    orig_sp[0] = L_temp;
    orig_sp[1] = L_temp_2;
    /* export-value */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &melange_supportZmelange_supportZexport_value_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_argument = orig_sp[0];

    /* #line 49 "./object.dylan" */

    /* #line 386 "./condition.dylan" */
    /* %subtype?{<class>, <class>} */
    L_condition = dylanZdylan_visceraZPCTsubtypeQUERY_METH(orig_sp, SLOT(L_argument.heapptr, heapptr_t, 0), &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP, &dylanZliteral_ROOT_2);
    if (L_condition) {

	/* #line 369 "./sockets-api.dylan" */

	/* #line 369 "./sockets-api.dylan" */

	/* #line 735 "./macros.dylan" */
	L_result_value = sendto(A_arg1, L_argument.dataword.ptr, A_arg3, A_arg4, A_arg5.dataword.ptr, A_arg6);
	return L_result_value;
    }
    else {

	/* #line 389 "./condition.dylan" */
	L_temp_3.heapptr = &networkZstr_ROOT_12;
	L_temp_3.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_argument, &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP, L_temp_3);
	not_reached();
    }
}

/* generic-entry for sendto{<integer>, <byte-string>, <integer>, <integer>, <sockaddr>, <integer>} */
descriptor_t * networkZnetwork_internalZsendto_METH_GENERIC(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    descriptor_t L_arg; /* arg */
    descriptor_t L_arg_2; /* arg */
    descriptor_t L_arg_3; /* arg */
    descriptor_t L_arg_4; /* arg */
    descriptor_t L_arg_5; /* arg */
    descriptor_t L_arg_6; /* arg */
    long L_arg_7; /* arg */
    heapptr_t L_arg_8; /* arg */
    long L_arg_9; /* arg */
    long L_arg_10; /* arg */
    descriptor_t L_arg_11; /* arg */
    long L_arg_12; /* arg */
    long L_result0; /* result0 */
    descriptor_t L_temp;

    /* #line {Class <unknown-source-location>} */
    L_args = ((void *)(orig_sp - 6));
    L_arg = (((descriptor_t *)L_args)[0]);
    L_arg_2 = (((descriptor_t *)L_args)[1]);
    L_arg_3 = (((descriptor_t *)L_args)[2]);
    L_arg_4 = (((descriptor_t *)L_args)[3]);
    L_arg_5 = (((descriptor_t *)L_args)[4]);
    L_arg_6 = (((descriptor_t *)L_args)[5]);
    L_arg_7 = L_arg.dataword.l;
    L_arg_8 = L_arg_2.heapptr;
    L_arg_9 = L_arg_3.dataword.l;
    L_arg_10 = L_arg_4.dataword.l;
    L_arg_11 = L_arg_5;
    L_arg_12 = L_arg_6.dataword.l;
    orig_sp = L_args;
    /* sendto{<integer>, <byte-string>, <integer>, <integer>, <sockaddr>, <integer>} */
    L_result0 = networkZnetwork_internalZsendto_METH(orig_sp, L_arg_7, L_arg_8, L_arg_9, L_arg_10, L_arg_11, L_arg_12, A_next_method_info);
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* {Implicit} Define Generic recvfrom */

/* recvfrom is recvfrom */


/* Define Method recvfrom{<integer>, <machine-pointer>, <integer>, <integer>, <sockaddr>, <socklen-t*>} */

/* recvfrom{<integer>, <machine-pointer>, <integer>, <integer>, <sockaddr>, <socklen-t*>} */
long networkZnetwork_internalZrecvfrom_METH(descriptor_t *orig_sp, long A_arg1 /* arg1 */, void * A_arg2 /* arg2 */, long A_arg3 /* arg3 */, long A_arg4 /* arg4 */, descriptor_t A_arg5 /* arg5 */, void * A_arg6 /* arg6 */, heapptr_t A6)
{
    descriptor_t *cluster_0_top;
    long L_result_value; /* result-value */


    /* #line 377 "./sockets-api.dylan" */

    /* #line 377 "./sockets-api.dylan" */

    /* #line 377 "./sockets-api.dylan" */

    /* #line 735 "./macros.dylan" */
    L_result_value = recvfrom(A_arg1, A_arg2, A_arg3, A_arg4, A_arg5.dataword.ptr, A_arg6);
    return L_result_value;
}


/* Define Class <iovec> */

/* <iovec> is <iovec> */

extern struct heapobj networkZnetwork_internalZCLS_iovec_HEAP;

/* maker for <iovec> */
void * networkZnetwork_internalZCLS_iovec_MAKER_FUN(descriptor_t *orig_sp, void * A_pointer /* pointer */, int A_pointer_suppliedQUERY /* pointer-supplied? */)
{
    descriptor_t *cluster_0_top;


    /* #line 381 "./sockets-api.dylan" */
    if (A_pointer_suppliedQUERY) {
	return A_pointer;
    }
    else {
	/* missing-required-init-keyword-error */
	dylanZdylan_visceraZmissing_required_init_keyword_error_FUN(orig_sp, &SYM_pointer_HEAP, &networkZnetwork_internalZCLS_iovec_HEAP);
	not_reached();
    }
}

extern descriptor_t networkZliteral_13;	/* proxy for <iovec> */

/* general-entry for maker for <iovec> */
descriptor_t * networkZnetwork_internalZCLS_iovec_MAKER_GENERAL(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    void * L_pointer; /* pointer */
    int L_pointer_suppliedQUERY; /* pointer-supplied? */
    long L_index; /* index */
    descriptor_t L_temp; /* temp */
    descriptor_t L_value; /* value */
    descriptor_t L_temp_2;
    descriptor_t L_temp_3;
    void * L_result0; /* result0 */
    descriptor_t L_temp_4;

    /* #line {Class <unknown-source-location>} */

    /* #line 126 "./cmp.dylan" */

    /* #line 209 "./num.dylan" */
    if (((A_nargs & 1) == 0)) {
	/* #line {Class <unknown-source-location>} */
	L_args = ((void *)(orig_sp - A_nargs));
	L_pointer = 0;
	L_pointer_suppliedQUERY = FALSE;
	L_index = (A_nargs - 2);
	while (1) {
	    if ((L_index < 0)) {
		goto block0;
	    }
	    else {
		L_temp = (((descriptor_t *)L_args)[L_index]);

		/* #line 386 "./condition.dylan" */
		if ((&dylanZdylan_visceraZCLS_symbol_HEAP == SLOT(L_temp.heapptr, heapptr_t, 0))) {
		    /* #line {Class <unknown-source-location>} */
		    L_value = (((descriptor_t *)L_args)[(L_index + 1)]);
		    if ((L_temp.heapptr == &SYM_pointer_HEAP)) {

			/* #line 386 "./condition.dylan" */
			if ((&dylanZdylan_visceraZCLS_raw_pointer_HEAP == SLOT(L_value.heapptr, heapptr_t, 0))) {
			    /* #line {Class <unknown-source-location>} */
			    L_pointer = L_value.dataword.ptr;
			    L_pointer_suppliedQUERY = TRUE;
			}
			else {

			    /* #line 389 "./condition.dylan" */
			    L_temp_2.heapptr = &networkZstr_ROOT;
			    L_temp_2.dataword.l = 0;
			    /* type-error-with-location */
			    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_value, &dylanZdylan_visceraZCLS_raw_pointer_HEAP, L_temp_2);
			    not_reached();
			}
		    }
		    /* #line {Class <unknown-source-location>} */
		    L_index = (L_index - 2);
		}
		else {

		    /* #line 389 "./condition.dylan" */
		    L_temp_3.heapptr = &networkZstr_ROOT;
		    L_temp_3.dataword.l = 0;
		    /* type-error-with-location */
		    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp, &dylanZdylan_visceraZCLS_symbol_HEAP, L_temp_3);
		    not_reached();
		}
	    }
	}
      block0:;
	/* #line {Class <unknown-source-location>} */
	orig_sp = L_args;
	/* maker for <iovec> */
	L_result0 = networkZnetwork_internalZCLS_iovec_MAKER_FUN(orig_sp, L_pointer, L_pointer_suppliedQUERY);
	L_temp_4.heapptr = networkZliteral_13.heapptr;
	L_temp_4.dataword.ptr = L_result0;
	orig_sp[0] = L_temp_4;
	return orig_sp + 1;
    }
    else {
	/* odd-number-of-keyword/value-arguments-error */
	dylanZdylan_visceraZodd_number_of_keywordSLASHvalue_arguments_error_FUN(orig_sp);
	not_reached();
    }
}


/* Define Sealed Domain make (singleton(<iovec>)) */


/* {Implicit} Define Generic get-iov-base */

/* get-iov-base is get-iov-base */


/* Define Method get-iov-base{<iovec>} */

extern struct heapobj melange_supportZmelange_supportZCLS_machine_pointer_HEAP;

extern struct heapobj networkZstr_ROOT_13;

extern struct heapobj networkZstr_ROOT_14;

/* get-iov-base{<iovec>} */
void * networkZnetwork_internalZget_iov_base_METH(descriptor_t *orig_sp, void * A_ptr /* ptr */, heapptr_t A1)
{
    descriptor_t *cluster_0_top;
    descriptor_t L_temp;
    descriptor_t L_temp_2;
    descriptor_t L_temp_3; /* temp */
    int L_condition; /* condition */
    descriptor_t L_result; /* result */
    descriptor_t L_temp_4;
    descriptor_t L_temp_5;


    /* #line 290 "./melange.dylan" */

    /* #line 91 "./rawptr.dylan" */

    /* #line 290 "./melange.dylan" */
    L_temp.heapptr = &melange_supportZmelange_supportZCLS_machine_pointer_HEAP;
    L_temp.dataword.l = 0;
    L_temp_2.heapptr = networkZliteral_6.heapptr;
    L_temp_2.dataword.ptr = (*(void * *)((char *)A_ptr + 0 ));
    orig_sp[0] = L_temp;
    orig_sp[1] = L_temp_2;
    /* as */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZas_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_temp_3 = orig_sp[0];

    /* #line 49 "./object.dylan" */

    /* #line 386 "./condition.dylan" */
    /* %subtype?{<class>, <class>} */
    L_condition = dylanZdylan_visceraZPCTsubtypeQUERY_METH(orig_sp, SLOT(L_temp_3.heapptr, heapptr_t, 0), &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP, &dylanZliteral_ROOT_2);
    if (L_condition) {

	/* #line 290 "./melange.dylan" */
	L_result = L_temp_3;

	/* #line 386 "./condition.dylan" */
	if ((&melange_supportZmelange_supportZCLS_machine_pointer_HEAP == SLOT(L_result.heapptr, heapptr_t, 0))) {

	    /* #line 387 "./sockets-api.dylan" */
	    return L_result.dataword.ptr;
	}
	else {

	    /* #line 389 "./condition.dylan" */
	    L_temp_4.heapptr = &networkZstr_ROOT_13;
	    L_temp_4.dataword.l = 0;
	    /* type-error-with-location */
	    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_result, &melange_supportZmelange_supportZCLS_machine_pointer_HEAP, L_temp_4);
	    not_reached();
	}
    }
    else {
	L_temp_5.heapptr = &networkZstr_ROOT_14;
	L_temp_5.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp_3, &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP, L_temp_5);
	not_reached();
    }
}


/* {Implicit} Define Generic get-iov-base-setter */

/* get-iov-base-setter is get-iov-base-setter */


/* Define Method get-iov-base-setter{<machine-pointer>, <iovec>} */

/* get-iov-base-setter{<machine-pointer>, <iovec>} */
void * networkZnetwork_internalZget_iov_base_setter_METH(descriptor_t *orig_sp, void * A_value /* value */, void * A_ptr /* ptr */, heapptr_t A2)
{
    descriptor_t *cluster_0_top;

    /* #line {Class <unknown-source-location>} */

    /* #line 299 "./melange.dylan" */
    /* #line {Class <unknown-source-location>} */

    /* #line 97 "./rawptr.dylan" */
    *(void * *)((char *)A_ptr + 0) = A_value;
    return A_value;
}


/* {Implicit} Define Generic get-iov-len */

/* get-iov-len is get-iov-len */


/* Define Method get-iov-len{<iovec>} */

/* get-iov-len{<iovec>} */
long networkZnetwork_internalZget_iov_len_METH(descriptor_t *orig_sp, void * A_ptr /* ptr */, heapptr_t A1)
{
    descriptor_t *cluster_0_top;

    /* #line {Class <unknown-source-location>} */

    /* #line 211 "./melange.dylan" */

    /* #line 91 "./rawptr.dylan" */
    return (*(long *)((char *)A_ptr + 4 ));
}


/* {Implicit} Define Generic get-iov-len-setter */

/* get-iov-len-setter is get-iov-len-setter */


/* Define Method get-iov-len-setter{<integer>, <iovec>} */

/* get-iov-len-setter{<integer>, <iovec>} */
long networkZnetwork_internalZget_iov_len_setter_METH(descriptor_t *orig_sp, long A_value /* value */, void * A_ptr /* ptr */, heapptr_t A2)
{
    descriptor_t *cluster_0_top;

    /* #line {Class <unknown-source-location>} */

    /* #line 97 "./rawptr.dylan" */
    *(long *)((char *)A_ptr + 4) = A_value;
    return A_value;
}


/* Define Method pointer-value{<iovec>} */

extern struct heapobj networkZstr_ROOT_15;

/* pointer-value{<iovec>} */
void * networkZnetwork_internalZpointer_value_METH_8(descriptor_t *orig_sp, void * A_value /* value */, heapptr_t A_next_method_info /* next-method-info */, heapptr_t A_rest /* rest */, descriptor_t A_index /* index */)
{
    descriptor_t *cluster_0_top;
    descriptor_t L_temp;
    descriptor_t L_arg1; /* arg1 */
    descriptor_t L_temp_2;
    descriptor_t L_temp_3; /* temp */
    descriptor_t L_temp_4;

    /* #line {Class <unknown-source-location>} */

    /* #line 408 "./sockets-api.dylan" */
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = 8;
    orig_sp[0] = A_index;
    orig_sp[1] = L_temp;
    /* * */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZV_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_arg1 = (orig_sp == cluster_0_top ? dylanZfalse : orig_sp[0]);

    /* #line 408 "./sockets-api.dylan" */
    L_temp_2.heapptr = networkZliteral_13.heapptr;
    L_temp_2.dataword.ptr = A_value;
    orig_sp[0] = L_temp_2;
    orig_sp[1] = L_arg1;
    /* + */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZPLUS_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_temp_3 = (orig_sp == cluster_0_top ? dylanZfalse : orig_sp[0]);

    /* #line 386 "./condition.dylan" */
    if ((&networkZnetwork_internalZCLS_iovec_HEAP == SLOT(L_temp_3.heapptr, heapptr_t, 0))) {

	/* #line 408 "./sockets-api.dylan" */
	return L_temp_3.dataword.ptr;
    }
    else {

	/* #line 389 "./condition.dylan" */
	L_temp_4.heapptr = &networkZstr_ROOT_15;
	L_temp_4.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp_3, &networkZnetwork_internalZCLS_iovec_HEAP, L_temp_4);
	not_reached();
    }
}

/* generic-entry for pointer-value{<iovec>} */
descriptor_t * networkZnetwork_internalZpointer_value_METH_GENERIC_8(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    descriptor_t L_arg; /* arg */
    heapptr_t L_rest; /* rest */
    void * L_arg_2; /* arg */
    descriptor_t L_index; /* index */
    long L_index_2; /* index */
    descriptor_t L_key; /* key */
    descriptor_t L_value; /* value */
    void * L_result0; /* result0 */
    descriptor_t L_temp;

    /* #line {Class <unknown-source-location>} */
    L_args = ((void *)(orig_sp - A_nargs));
    L_arg = (((descriptor_t *)L_args)[0]);
    L_rest = dylanZdylan_visceraZmake_rest_arg_FUN(orig_sp, (descriptor_t *)L_args + 1, A_nargs - 1);
    L_arg_2 = L_arg.dataword.ptr;
    L_index.heapptr = networkZliteral_2.heapptr;
    L_index.dataword.l = 0;
    L_index_2 = (A_nargs - 2);
    while (1) {
	if ((L_index_2 < 1)) {
	    goto block0;
	}
	else {
	    L_key = (((descriptor_t *)L_args)[L_index_2]);
	    L_value = (((descriptor_t *)L_args)[(L_index_2 + 1)]);
	    if ((L_key.heapptr == &SYM_index_HEAP)) {
		L_index = L_value;
	    }
	    L_index_2 = (L_index_2 - 2);
	}
    }
  block0:;
    orig_sp = L_args;
    /* pointer-value{<iovec>} */
    L_result0 = networkZnetwork_internalZpointer_value_METH_8(orig_sp, L_arg_2, A_next_method_info, L_rest, L_index);
    L_temp.heapptr = networkZliteral_13.heapptr;
    L_temp.dataword.ptr = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* Define Method content-size{subclass(<iovec>)} */

/* content-size{subclass(<iovec>)} */
long networkZnetwork_internalZcontent_size_METH_11(descriptor_t *orig_sp, heapptr_t A0, heapptr_t A1)
{

    return 8;
}

/* generic-entry for content-size{subclass(<iovec>)} */
descriptor_t * networkZnetwork_internalZcontent_size_METH_GENERIC_11(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    long L_result0; /* result0 */
    descriptor_t L_temp;

    orig_sp = ((void *)(orig_sp - 1));
    /* content-size{subclass(<iovec>)} */
    L_result0 = networkZnetwork_internalZcontent_size_METH_11(orig_sp, &networkZnetwork_internalZCLS_iovec_HEAP, A_next_method_info);
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* Define Class <msghdr> */

/* <msghdr> is <msghdr> */

extern struct heapobj networkZnetwork_internalZCLS_msghdr_HEAP;

/* maker for <msghdr> */
void * networkZnetwork_internalZCLS_msghdr_MAKER_FUN(descriptor_t *orig_sp, void * A_pointer /* pointer */, int A_pointer_suppliedQUERY /* pointer-supplied? */)
{
    descriptor_t *cluster_0_top;


    /* #line 415 "./sockets-api.dylan" */
    if (A_pointer_suppliedQUERY) {
	return A_pointer;
    }
    else {
	/* missing-required-init-keyword-error */
	dylanZdylan_visceraZmissing_required_init_keyword_error_FUN(orig_sp, &SYM_pointer_HEAP, &networkZnetwork_internalZCLS_msghdr_HEAP);
	not_reached();
    }
}

extern descriptor_t networkZliteral_14;	/* proxy for <msghdr> */

/* general-entry for maker for <msghdr> */
descriptor_t * networkZnetwork_internalZCLS_msghdr_MAKER_GENERAL(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    void * L_pointer; /* pointer */
    int L_pointer_suppliedQUERY; /* pointer-supplied? */
    long L_index; /* index */
    descriptor_t L_temp; /* temp */
    descriptor_t L_value; /* value */
    descriptor_t L_temp_2;
    descriptor_t L_temp_3;
    void * L_result0; /* result0 */
    descriptor_t L_temp_4;

    /* #line {Class <unknown-source-location>} */

    /* #line 126 "./cmp.dylan" */

    /* #line 209 "./num.dylan" */
    if (((A_nargs & 1) == 0)) {
	/* #line {Class <unknown-source-location>} */
	L_args = ((void *)(orig_sp - A_nargs));
	L_pointer = 0;
	L_pointer_suppliedQUERY = FALSE;
	L_index = (A_nargs - 2);
	while (1) {
	    if ((L_index < 0)) {
		goto block0;
	    }
	    else {
		L_temp = (((descriptor_t *)L_args)[L_index]);

		/* #line 386 "./condition.dylan" */
		if ((&dylanZdylan_visceraZCLS_symbol_HEAP == SLOT(L_temp.heapptr, heapptr_t, 0))) {
		    /* #line {Class <unknown-source-location>} */
		    L_value = (((descriptor_t *)L_args)[(L_index + 1)]);
		    if ((L_temp.heapptr == &SYM_pointer_HEAP)) {

			/* #line 386 "./condition.dylan" */
			if ((&dylanZdylan_visceraZCLS_raw_pointer_HEAP == SLOT(L_value.heapptr, heapptr_t, 0))) {
			    /* #line {Class <unknown-source-location>} */
			    L_pointer = L_value.dataword.ptr;
			    L_pointer_suppliedQUERY = TRUE;
			}
			else {

			    /* #line 389 "./condition.dylan" */
			    L_temp_2.heapptr = &networkZstr_ROOT;
			    L_temp_2.dataword.l = 0;
			    /* type-error-with-location */
			    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_value, &dylanZdylan_visceraZCLS_raw_pointer_HEAP, L_temp_2);
			    not_reached();
			}
		    }
		    /* #line {Class <unknown-source-location>} */
		    L_index = (L_index - 2);
		}
		else {

		    /* #line 389 "./condition.dylan" */
		    L_temp_3.heapptr = &networkZstr_ROOT;
		    L_temp_3.dataword.l = 0;
		    /* type-error-with-location */
		    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp, &dylanZdylan_visceraZCLS_symbol_HEAP, L_temp_3);
		    not_reached();
		}
	    }
	}
      block0:;
	/* #line {Class <unknown-source-location>} */
	orig_sp = L_args;
	/* maker for <msghdr> */
	L_result0 = networkZnetwork_internalZCLS_msghdr_MAKER_FUN(orig_sp, L_pointer, L_pointer_suppliedQUERY);
	L_temp_4.heapptr = networkZliteral_14.heapptr;
	L_temp_4.dataword.ptr = L_result0;
	orig_sp[0] = L_temp_4;
	return orig_sp + 1;
    }
    else {
	/* odd-number-of-keyword/value-arguments-error */
	dylanZdylan_visceraZodd_number_of_keywordSLASHvalue_arguments_error_FUN(orig_sp);
	not_reached();
    }
}


/* Define Sealed Domain make (singleton(<msghdr>)) */


/* {Implicit} Define Generic get-msg-name */

/* get-msg-name is get-msg-name */


/* Define Method get-msg-name{<msghdr>} */

extern struct heapobj networkZstr_ROOT_16;

/* get-msg-name{<msghdr>} */
void * networkZnetwork_internalZget_msg_name_METH(descriptor_t *orig_sp, void * A_ptr /* ptr */, heapptr_t A1)
{
    descriptor_t *cluster_0_top;
    descriptor_t L_temp;
    descriptor_t L_temp_2;
    descriptor_t L_temp_3; /* temp */
    int L_condition; /* condition */
    descriptor_t L_result; /* result */
    descriptor_t L_temp_4;
    descriptor_t L_temp_5;


    /* #line 290 "./melange.dylan" */

    /* #line 91 "./rawptr.dylan" */

    /* #line 290 "./melange.dylan" */
    L_temp.heapptr = &melange_supportZmelange_supportZCLS_machine_pointer_HEAP;
    L_temp.dataword.l = 0;
    L_temp_2.heapptr = networkZliteral_6.heapptr;
    L_temp_2.dataword.ptr = (*(void * *)((char *)A_ptr + 0 ));
    orig_sp[0] = L_temp;
    orig_sp[1] = L_temp_2;
    /* as */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZas_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_temp_3 = orig_sp[0];

    /* #line 49 "./object.dylan" */

    /* #line 386 "./condition.dylan" */
    /* %subtype?{<class>, <class>} */
    L_condition = dylanZdylan_visceraZPCTsubtypeQUERY_METH(orig_sp, SLOT(L_temp_3.heapptr, heapptr_t, 0), &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP, &dylanZliteral_ROOT_2);
    if (L_condition) {

	/* #line 290 "./melange.dylan" */
	L_result = L_temp_3;

	/* #line 386 "./condition.dylan" */
	if ((&melange_supportZmelange_supportZCLS_machine_pointer_HEAP == SLOT(L_result.heapptr, heapptr_t, 0))) {

	    /* #line 421 "./sockets-api.dylan" */
	    return L_result.dataword.ptr;
	}
	else {

	    /* #line 389 "./condition.dylan" */
	    L_temp_4.heapptr = &networkZstr_ROOT_16;
	    L_temp_4.dataword.l = 0;
	    /* type-error-with-location */
	    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_result, &melange_supportZmelange_supportZCLS_machine_pointer_HEAP, L_temp_4);
	    not_reached();
	}
    }
    else {
	L_temp_5.heapptr = &networkZstr_ROOT_14;
	L_temp_5.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp_3, &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP, L_temp_5);
	not_reached();
    }
}


/* {Implicit} Define Generic get-msg-name-setter */

/* get-msg-name-setter is get-msg-name-setter */


/* Define Method get-msg-name-setter{<machine-pointer>, <msghdr>} */

/* get-msg-name-setter{<machine-pointer>, <msghdr>} */
void * networkZnetwork_internalZget_msg_name_setter_METH(descriptor_t *orig_sp, void * A_value /* value */, void * A_ptr /* ptr */, heapptr_t A2)
{
    descriptor_t *cluster_0_top;

    /* #line {Class <unknown-source-location>} */

    /* #line 299 "./melange.dylan" */
    /* #line {Class <unknown-source-location>} */

    /* #line 97 "./rawptr.dylan" */
    *(void * *)((char *)A_ptr + 0) = A_value;
    return A_value;
}


/* {Implicit} Define Generic get-msg-namelen */

/* get-msg-namelen is get-msg-namelen */


/* Define Method get-msg-namelen{<msghdr>} */

/* get-msg-namelen{<msghdr>} */
long networkZnetwork_internalZget_msg_namelen_METH(descriptor_t *orig_sp, void * A_ptr /* ptr */, heapptr_t A1)
{
    descriptor_t *cluster_0_top;

    /* #line {Class <unknown-source-location>} */

    /* #line 211 "./melange.dylan" */

    /* #line 91 "./rawptr.dylan" */
    return (*(long *)((char *)A_ptr + 4 ));
}


/* {Implicit} Define Generic get-msg-namelen-setter */

/* get-msg-namelen-setter is get-msg-namelen-setter */


/* Define Method get-msg-namelen-setter{<integer>, <msghdr>} */

/* get-msg-namelen-setter{<integer>, <msghdr>} */
long networkZnetwork_internalZget_msg_namelen_setter_METH(descriptor_t *orig_sp, long A_value /* value */, void * A_ptr /* ptr */, heapptr_t A2)
{
    descriptor_t *cluster_0_top;

    /* #line {Class <unknown-source-location>} */

    /* #line 97 "./rawptr.dylan" */
    *(long *)((char *)A_ptr + 4) = A_value;
    return A_value;
}


/* {Implicit} Define Generic get-msg-iov */

/* get-msg-iov is get-msg-iov */


/* Define Method get-msg-iov{<msghdr>} */

extern struct heapobj networkZstr_ROOT_17;

/* get-msg-iov{<msghdr>} */
void * networkZnetwork_internalZget_msg_iov_METH(descriptor_t *orig_sp, void * A_ptr /* ptr */, heapptr_t A1)
{
    descriptor_t *cluster_0_top;
    descriptor_t L_temp;
    descriptor_t L_temp_2;
    descriptor_t L_temp_3; /* temp */
    int L_condition; /* condition */
    descriptor_t L_result; /* result */
    descriptor_t L_temp_4;
    descriptor_t L_temp_5;

    /* #line {Class <unknown-source-location>} */

    /* #line 290 "./melange.dylan" */

    /* #line 91 "./rawptr.dylan" */

    /* #line 290 "./melange.dylan" */
    L_temp.heapptr = &networkZnetwork_internalZCLS_iovec_HEAP;
    L_temp.dataword.l = 0;
    L_temp_2.heapptr = networkZliteral_6.heapptr;
    L_temp_2.dataword.ptr = (*(void * *)((char *)A_ptr + 8 ));
    orig_sp[0] = L_temp;
    orig_sp[1] = L_temp_2;
    /* as */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZas_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_temp_3 = orig_sp[0];

    /* #line 49 "./object.dylan" */

    /* #line 386 "./condition.dylan" */
    /* %subtype?{<class>, <class>} */
    L_condition = dylanZdylan_visceraZPCTsubtypeQUERY_METH(orig_sp, SLOT(L_temp_3.heapptr, heapptr_t, 0), &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP, &dylanZliteral_ROOT_2);
    if (L_condition) {

	/* #line 290 "./melange.dylan" */
	L_result = L_temp_3;

	/* #line 386 "./condition.dylan" */
	if ((&networkZnetwork_internalZCLS_iovec_HEAP == SLOT(L_result.heapptr, heapptr_t, 0))) {

	    /* #line 443 "./sockets-api.dylan" */
	    return L_result.dataword.ptr;
	}
	else {

	    /* #line 389 "./condition.dylan" */
	    L_temp_4.heapptr = &networkZstr_ROOT_17;
	    L_temp_4.dataword.l = 0;
	    /* type-error-with-location */
	    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_result, &networkZnetwork_internalZCLS_iovec_HEAP, L_temp_4);
	    not_reached();
	}
    }
    else {
	L_temp_5.heapptr = &networkZstr_ROOT_14;
	L_temp_5.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp_3, &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP, L_temp_5);
	not_reached();
    }
}


/* {Implicit} Define Generic get-msg-iov-setter */

/* get-msg-iov-setter is get-msg-iov-setter */


/* Define Method get-msg-iov-setter{<iovec>, <msghdr>} */

/* get-msg-iov-setter{<iovec>, <msghdr>} */
void * networkZnetwork_internalZget_msg_iov_setter_METH(descriptor_t *orig_sp, void * A_value /* value */, void * A_ptr /* ptr */, heapptr_t A2)
{
    descriptor_t *cluster_0_top;

    /* #line {Class <unknown-source-location>} */

    /* #line 299 "./melange.dylan" */
    /* #line {Class <unknown-source-location>} */

    /* #line 97 "./rawptr.dylan" */
    *(void * *)((char *)A_ptr + 8) = A_value;
    return A_value;
}


/* {Implicit} Define Generic get-msg-iovlen */

/* get-msg-iovlen is get-msg-iovlen */


/* Define Method get-msg-iovlen{<msghdr>} */

/* get-msg-iovlen{<msghdr>} */
long networkZnetwork_internalZget_msg_iovlen_METH(descriptor_t *orig_sp, void * A_ptr /* ptr */, heapptr_t A1)
{
    descriptor_t *cluster_0_top;

    /* #line {Class <unknown-source-location>} */

    /* #line 211 "./melange.dylan" */

    /* #line 91 "./rawptr.dylan" */
    return (*(long *)((char *)A_ptr + 12 ));
}


/* {Implicit} Define Generic get-msg-iovlen-setter */

/* get-msg-iovlen-setter is get-msg-iovlen-setter */


/* Define Method get-msg-iovlen-setter{<integer>, <msghdr>} */

/* get-msg-iovlen-setter{<integer>, <msghdr>} */
long networkZnetwork_internalZget_msg_iovlen_setter_METH(descriptor_t *orig_sp, long A_value /* value */, void * A_ptr /* ptr */, heapptr_t A2)
{
    descriptor_t *cluster_0_top;

    /* #line {Class <unknown-source-location>} */

    /* #line 97 "./rawptr.dylan" */
    *(long *)((char *)A_ptr + 12) = A_value;
    return A_value;
}


/* {Implicit} Define Generic get-msg-control */

/* get-msg-control is get-msg-control */


/* Define Method get-msg-control{<msghdr>} */

extern struct heapobj networkZstr_ROOT_18;

/* get-msg-control{<msghdr>} */
void * networkZnetwork_internalZget_msg_control_METH(descriptor_t *orig_sp, void * A_ptr /* ptr */, heapptr_t A1)
{
    descriptor_t *cluster_0_top;
    descriptor_t L_temp;
    descriptor_t L_temp_2;
    descriptor_t L_temp_3; /* temp */
    int L_condition; /* condition */
    descriptor_t L_result; /* result */
    descriptor_t L_temp_4;
    descriptor_t L_temp_5;

    /* #line {Class <unknown-source-location>} */

    /* #line 290 "./melange.dylan" */

    /* #line 91 "./rawptr.dylan" */

    /* #line 290 "./melange.dylan" */
    L_temp.heapptr = &melange_supportZmelange_supportZCLS_machine_pointer_HEAP;
    L_temp.dataword.l = 0;
    L_temp_2.heapptr = networkZliteral_6.heapptr;
    L_temp_2.dataword.ptr = (*(void * *)((char *)A_ptr + 16 ));
    orig_sp[0] = L_temp;
    orig_sp[1] = L_temp_2;
    /* as */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZas_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_temp_3 = orig_sp[0];

    /* #line 49 "./object.dylan" */

    /* #line 386 "./condition.dylan" */
    /* %subtype?{<class>, <class>} */
    L_condition = dylanZdylan_visceraZPCTsubtypeQUERY_METH(orig_sp, SLOT(L_temp_3.heapptr, heapptr_t, 0), &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP, &dylanZliteral_ROOT_2);
    if (L_condition) {

	/* #line 290 "./melange.dylan" */
	L_result = L_temp_3;

	/* #line 386 "./condition.dylan" */
	if ((&melange_supportZmelange_supportZCLS_machine_pointer_HEAP == SLOT(L_result.heapptr, heapptr_t, 0))) {

	    /* #line 465 "./sockets-api.dylan" */
	    return L_result.dataword.ptr;
	}
	else {

	    /* #line 389 "./condition.dylan" */
	    L_temp_4.heapptr = &networkZstr_ROOT_18;
	    L_temp_4.dataword.l = 0;
	    /* type-error-with-location */
	    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_result, &melange_supportZmelange_supportZCLS_machine_pointer_HEAP, L_temp_4);
	    not_reached();
	}
    }
    else {
	L_temp_5.heapptr = &networkZstr_ROOT_14;
	L_temp_5.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp_3, &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP, L_temp_5);
	not_reached();
    }
}


/* {Implicit} Define Generic get-msg-control-setter */

/* get-msg-control-setter is get-msg-control-setter */


/* Define Method get-msg-control-setter{<machine-pointer>, <msghdr>} */

/* get-msg-control-setter{<machine-pointer>, <msghdr>} */
void * networkZnetwork_internalZget_msg_control_setter_METH(descriptor_t *orig_sp, void * A_value /* value */, void * A_ptr /* ptr */, heapptr_t A2)
{
    descriptor_t *cluster_0_top;

    /* #line {Class <unknown-source-location>} */

    /* #line 299 "./melange.dylan" */
    /* #line {Class <unknown-source-location>} */

    /* #line 97 "./rawptr.dylan" */
    *(void * *)((char *)A_ptr + 16) = A_value;
    return A_value;
}


/* {Implicit} Define Generic get-msg-controllen */

/* get-msg-controllen is get-msg-controllen */


/* Define Method get-msg-controllen{<msghdr>} */

/* get-msg-controllen{<msghdr>} */
long networkZnetwork_internalZget_msg_controllen_METH(descriptor_t *orig_sp, void * A_ptr /* ptr */, heapptr_t A1)
{
    descriptor_t *cluster_0_top;

    /* #line {Class <unknown-source-location>} */

    /* #line 211 "./melange.dylan" */

    /* #line 91 "./rawptr.dylan" */
    return (*(long *)((char *)A_ptr + 20 ));
}


/* {Implicit} Define Generic get-msg-controllen-setter */

/* get-msg-controllen-setter is get-msg-controllen-setter */


/* Define Method get-msg-controllen-setter{<integer>, <msghdr>} */

/* get-msg-controllen-setter{<integer>, <msghdr>} */
long networkZnetwork_internalZget_msg_controllen_setter_METH(descriptor_t *orig_sp, long A_value /* value */, void * A_ptr /* ptr */, heapptr_t A2)
{
    descriptor_t *cluster_0_top;

    /* #line {Class <unknown-source-location>} */

    /* #line 97 "./rawptr.dylan" */
    *(long *)((char *)A_ptr + 20) = A_value;
    return A_value;
}


/* {Implicit} Define Generic get-msg-flags */

/* get-msg-flags is get-msg-flags */


/* Define Method get-msg-flags{<msghdr>} */

/* get-msg-flags{<msghdr>} */
long networkZnetwork_internalZget_msg_flags_METH(descriptor_t *orig_sp, void * A_ptr /* ptr */, heapptr_t A1)
{
    descriptor_t *cluster_0_top;

    /* #line {Class <unknown-source-location>} */

    /* #line 198 "./melange.dylan" */

    /* #line 91 "./rawptr.dylan" */
    return (*(long *)((char *)A_ptr + 24 ));
}


/* {Implicit} Define Generic get-msg-flags-setter */

/* get-msg-flags-setter is get-msg-flags-setter */


/* Define Method get-msg-flags-setter{<integer>, <msghdr>} */

/* get-msg-flags-setter{<integer>, <msghdr>} */
long networkZnetwork_internalZget_msg_flags_setter_METH(descriptor_t *orig_sp, long A_value /* value */, void * A_ptr /* ptr */, heapptr_t A2)
{
    descriptor_t *cluster_0_top;

    /* #line {Class <unknown-source-location>} */

    /* #line 97 "./rawptr.dylan" */
    *(long *)((char *)A_ptr + 24) = A_value;
    return A_value;
}


/* Define Method pointer-value{<msghdr>} */

extern struct heapobj networkZstr_ROOT_19;

/* pointer-value{<msghdr>} */
void * networkZnetwork_internalZpointer_value_METH_9(descriptor_t *orig_sp, void * A_value /* value */, heapptr_t A_next_method_info /* next-method-info */, heapptr_t A_rest /* rest */, descriptor_t A_index /* index */)
{
    descriptor_t *cluster_0_top;
    descriptor_t L_temp;
    descriptor_t L_arg1; /* arg1 */
    descriptor_t L_temp_2;
    descriptor_t L_temp_3; /* temp */
    descriptor_t L_temp_4;

    /* #line {Class <unknown-source-location>} */

    /* #line 497 "./sockets-api.dylan" */
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = 28;
    orig_sp[0] = A_index;
    orig_sp[1] = L_temp;
    /* * */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZV_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_arg1 = (orig_sp == cluster_0_top ? dylanZfalse : orig_sp[0]);

    /* #line 497 "./sockets-api.dylan" */
    L_temp_2.heapptr = networkZliteral_14.heapptr;
    L_temp_2.dataword.ptr = A_value;
    orig_sp[0] = L_temp_2;
    orig_sp[1] = L_arg1;
    /* + */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZPLUS_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_temp_3 = (orig_sp == cluster_0_top ? dylanZfalse : orig_sp[0]);

    /* #line 386 "./condition.dylan" */
    if ((&networkZnetwork_internalZCLS_msghdr_HEAP == SLOT(L_temp_3.heapptr, heapptr_t, 0))) {

	/* #line 497 "./sockets-api.dylan" */
	return L_temp_3.dataword.ptr;
    }
    else {

	/* #line 389 "./condition.dylan" */
	L_temp_4.heapptr = &networkZstr_ROOT_19;
	L_temp_4.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp_3, &networkZnetwork_internalZCLS_msghdr_HEAP, L_temp_4);
	not_reached();
    }
}

/* generic-entry for pointer-value{<msghdr>} */
descriptor_t * networkZnetwork_internalZpointer_value_METH_GENERIC_9(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    descriptor_t L_arg; /* arg */
    heapptr_t L_rest; /* rest */
    void * L_arg_2; /* arg */
    descriptor_t L_index; /* index */
    long L_index_2; /* index */
    descriptor_t L_key; /* key */
    descriptor_t L_value; /* value */
    void * L_result0; /* result0 */
    descriptor_t L_temp;

    /* #line {Class <unknown-source-location>} */
    L_args = ((void *)(orig_sp - A_nargs));
    L_arg = (((descriptor_t *)L_args)[0]);
    L_rest = dylanZdylan_visceraZmake_rest_arg_FUN(orig_sp, (descriptor_t *)L_args + 1, A_nargs - 1);
    L_arg_2 = L_arg.dataword.ptr;
    L_index.heapptr = networkZliteral_2.heapptr;
    L_index.dataword.l = 0;
    L_index_2 = (A_nargs - 2);
    while (1) {
	if ((L_index_2 < 1)) {
	    goto block0;
	}
	else {
	    L_key = (((descriptor_t *)L_args)[L_index_2]);
	    L_value = (((descriptor_t *)L_args)[(L_index_2 + 1)]);
	    if ((L_key.heapptr == &SYM_index_HEAP)) {
		L_index = L_value;
	    }
	    L_index_2 = (L_index_2 - 2);
	}
    }
  block0:;
    orig_sp = L_args;
    /* pointer-value{<msghdr>} */
    L_result0 = networkZnetwork_internalZpointer_value_METH_9(orig_sp, L_arg_2, A_next_method_info, L_rest, L_index);
    L_temp.heapptr = networkZliteral_14.heapptr;
    L_temp.dataword.ptr = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* Define Method content-size{subclass(<msghdr>)} */

/* content-size{subclass(<msghdr>)} */
long networkZnetwork_internalZcontent_size_METH_12(descriptor_t *orig_sp, heapptr_t A0, heapptr_t A1)
{

    return 28;
}

/* generic-entry for content-size{subclass(<msghdr>)} */
descriptor_t * networkZnetwork_internalZcontent_size_METH_GENERIC_12(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    long L_result0; /* result0 */
    descriptor_t L_temp;

    orig_sp = ((void *)(orig_sp - 1));
    /* content-size{subclass(<msghdr>)} */
    L_result0 = networkZnetwork_internalZcontent_size_METH_12(orig_sp, &networkZnetwork_internalZCLS_msghdr_HEAP, A_next_method_info);
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* {Implicit} Define Generic sendmsg */

/* sendmsg is sendmsg */


/* Define Method sendmsg{<integer>, <msghdr>, <integer>} */

/* sendmsg{<integer>, <msghdr>, <integer>} */
long networkZnetwork_internalZsendmsg_METH(descriptor_t *orig_sp, long A_arg1 /* arg1 */, void * A_arg2 /* arg2 */, long A_arg3 /* arg3 */, heapptr_t A3)
{
    descriptor_t *cluster_0_top;
    long L_result_value; /* result-value */


    /* #line 508 "./sockets-api.dylan" */

    /* #line 735 "./macros.dylan" */
    L_result_value = sendmsg(A_arg1, A_arg2, A_arg3);
    return L_result_value;
}


/* {Implicit} Define Generic recvmsg */

/* recvmsg is recvmsg */


/* Define Method recvmsg{<integer>, <msghdr>, <integer>} */

/* recvmsg{<integer>, <msghdr>, <integer>} */
long networkZnetwork_internalZrecvmsg_METH(descriptor_t *orig_sp, long A_arg1 /* arg1 */, void * A_arg2 /* arg2 */, long A_arg3 /* arg3 */, heapptr_t A3)
{
    descriptor_t *cluster_0_top;
    long L_result_value; /* result-value */

    /* #line {Class <unknown-source-location>} */

    /* #line 516 "./sockets-api.dylan" */

    /* #line 735 "./macros.dylan" */
    L_result_value = recvmsg(A_arg1, A_arg2, A_arg3);
    return L_result_value;
}


/* {Implicit} Define Generic getsockopt */

/* getsockopt is getsockopt */


/* Define Method getsockopt{<integer>, <integer>, <integer>, <machine-pointer>, <socklen-t*>} */

/* getsockopt{<integer>, <integer>, <integer>, <machine-pointer>, <socklen-t*>} */
long networkZnetwork_internalZgetsockopt_METH(descriptor_t *orig_sp, long A_arg1 /* arg1 */, long A_arg2 /* arg2 */, long A_arg3 /* arg3 */, void * A_arg4 /* arg4 */, void * A_arg5 /* arg5 */, heapptr_t A5)
{
    descriptor_t *cluster_0_top;
    long L_result_value; /* result-value */

    /* #line {Class <unknown-source-location>} */

    /* #line 524 "./sockets-api.dylan" */

    /* #line 524 "./sockets-api.dylan" */

    /* #line 735 "./macros.dylan" */
    L_result_value = getsockopt(A_arg1, A_arg2, A_arg3, A_arg4, A_arg5);
    return L_result_value;
}


/* {Implicit} Define Generic setsockopt */

/* setsockopt is setsockopt */


/* Define Method setsockopt{<integer>, <integer>, <integer>, <machine-pointer>, <integer>} */

/* setsockopt{<integer>, <integer>, <integer>, <machine-pointer>, <integer>} */
long networkZnetwork_internalZsetsockopt_METH(descriptor_t *orig_sp, long A_arg1 /* arg1 */, long A_arg2 /* arg2 */, long A_arg3 /* arg3 */, void * A_arg4 /* arg4 */, long A_arg5 /* arg5 */, heapptr_t A5)
{
    descriptor_t *cluster_0_top;
    long L_result_value; /* result-value */

    /* #line {Class <unknown-source-location>} */

    /* #line 532 "./sockets-api.dylan" */

    /* #line 735 "./macros.dylan" */
    L_result_value = setsockopt(A_arg1, A_arg2, A_arg3, A_arg4, A_arg5);
    return L_result_value;
}


/* {Implicit} Define Generic listen */

/* listen is listen */


/* Define Method listen{<integer>, <integer>} */

/* listen{<integer>, <integer>} */
long networkZnetwork_internalZlisten_METH(descriptor_t *orig_sp, long A_arg1 /* arg1 */, long A_arg2 /* arg2 */, heapptr_t A2)
{
    descriptor_t *cluster_0_top;
    long L_result_value; /* result-value */

    /* #line {Class <unknown-source-location>} */

    /* #line 735 "./macros.dylan" */
    L_result_value = listen(A_arg1, A_arg2);
    return L_result_value;
}


/* {Implicit} Define Generic accept */

/* accept is accept */


/* Define Method accept{<integer>, <sockaddr>, <socklen-t*>} */

/* accept{<integer>, <sockaddr>, <socklen-t*>} */
long networkZnetwork_internalZaccept_METH(descriptor_t *orig_sp, long A_arg1 /* arg1 */, descriptor_t A_arg2 /* arg2 */, void * A_arg3 /* arg3 */, heapptr_t A3)
{
    descriptor_t *cluster_0_top;
    long L_result_value; /* result-value */

    /* #line {Class <unknown-source-location>} */

    /* #line 548 "./sockets-api.dylan" */

    /* #line 548 "./sockets-api.dylan" */

    /* #line 735 "./macros.dylan" */
    L_result_value = accept(A_arg1, A_arg2.dataword.ptr, A_arg3);
    return L_result_value;
}


/* {Implicit} Define Generic shutdown */

/* shutdown is shutdown */


/* Define Method shutdown{<integer>, <integer>} */

/* shutdown{<integer>, <integer>} */
long networkZnetwork_internalZshutdown_METH(descriptor_t *orig_sp, long A_arg1 /* arg1 */, long A_arg2 /* arg2 */, heapptr_t A2)
{
    descriptor_t *cluster_0_top;
    long L_result_value; /* result-value */

    /* #line {Class <unknown-source-location>} */

    /* #line 735 "./macros.dylan" */
    L_result_value = shutdown(A_arg1, A_arg2);
    return L_result_value;
}


/* {Implicit} Define Generic isfdtype */

/* isfdtype is isfdtype */


/* Define Method isfdtype{<integer>, <integer>} */

/* isfdtype{<integer>, <integer>} */
long networkZnetwork_internalZisfdtype_METH(descriptor_t *orig_sp, long A_arg1 /* arg1 */, long A_arg2 /* arg2 */, heapptr_t A2)
{
    descriptor_t *cluster_0_top;
    long L_result_value; /* result-value */

    /* #line {Class <unknown-source-location>} */

    /* #line 735 "./macros.dylan" */
    L_result_value = isfdtype(A_arg1, A_arg2);
    return L_result_value;
}


/* Define Constant $_SYS-SOCKET-H */

/* $_SYS-SOCKET-H is 1 */


/* Define Constant <__SOCKADDR-ARG> */

/* <__SOCKADDR-ARG> is <sockaddr> */


/* Define Constant <__CONST-SOCKADDR-ARG> */

/* <__CONST-SOCKADDR-ARG> is <sockaddr> */


/* Define Constant <__socket-type> */

/* <__socket-type> allocated as networkZnetwork_internalZCLS_X_X_socket_type */


/* Define Constant $SOCK-STREAM */

/* $SOCK-STREAM is 1 */


/* Define Constant $SOCK-DGRAM */

/* $SOCK-DGRAM is 2 */


/* Define Constant $SOCK-RAW */

/* $SOCK-RAW is 3 */


/* Define Constant $SOCK-RDM */

/* $SOCK-RDM is 4 */


/* Define Constant $SOCK-SEQPACKET */

/* $SOCK-SEQPACKET is 5 */


/* Define Constant $SOCK-PACKET */

/* $SOCK-PACKET is 10 */


/* Define Constant <__uint32-t> */

/* <__uint32-t> is <integer> */


/* Define Class <char<@120>> */

/* <char<@120>> is <char<@120>> */

extern struct heapobj networkZnetwork_internalZCLS_charLESSX40120GREATER_HEAP;

/* maker for <char<@120>> */
void * networkZnetwork_internalZCLS_charLESSX40120GREATER_MAKER_FUN(descriptor_t *orig_sp, void * A_pointer /* pointer */, int A_pointer_suppliedQUERY /* pointer-supplied? */)
{
    descriptor_t *cluster_0_top;


    /* #line 584 "./sockets-api.dylan" */
    if (A_pointer_suppliedQUERY) {
	return A_pointer;
    }
    else {
	/* missing-required-init-keyword-error */
	dylanZdylan_visceraZmissing_required_init_keyword_error_FUN(orig_sp, &SYM_pointer_HEAP, &networkZnetwork_internalZCLS_charLESSX40120GREATER_HEAP);
	not_reached();
    }
}

extern descriptor_t networkZliteral_15;	/* proxy for <char<@120>> */

/* general-entry for maker for <char<@120>> */
descriptor_t * networkZnetwork_internalZCLS_charLESSX40120GREATER_MAKER_GENERAL(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    void * L_pointer; /* pointer */
    int L_pointer_suppliedQUERY; /* pointer-supplied? */
    long L_index; /* index */
    descriptor_t L_temp; /* temp */
    descriptor_t L_value; /* value */
    descriptor_t L_temp_2;
    descriptor_t L_temp_3;
    void * L_result0; /* result0 */
    descriptor_t L_temp_4;

    /* #line {Class <unknown-source-location>} */

    /* #line 126 "./cmp.dylan" */

    /* #line 209 "./num.dylan" */
    if (((A_nargs & 1) == 0)) {
	/* #line {Class <unknown-source-location>} */
	L_args = ((void *)(orig_sp - A_nargs));
	L_pointer = 0;
	L_pointer_suppliedQUERY = FALSE;
	L_index = (A_nargs - 2);
	while (1) {
	    if ((L_index < 0)) {
		goto block0;
	    }
	    else {
		L_temp = (((descriptor_t *)L_args)[L_index]);

		/* #line 386 "./condition.dylan" */
		if ((&dylanZdylan_visceraZCLS_symbol_HEAP == SLOT(L_temp.heapptr, heapptr_t, 0))) {
		    /* #line {Class <unknown-source-location>} */
		    L_value = (((descriptor_t *)L_args)[(L_index + 1)]);
		    if ((L_temp.heapptr == &SYM_pointer_HEAP)) {

			/* #line 386 "./condition.dylan" */
			if ((&dylanZdylan_visceraZCLS_raw_pointer_HEAP == SLOT(L_value.heapptr, heapptr_t, 0))) {
			    /* #line {Class <unknown-source-location>} */
			    L_pointer = L_value.dataword.ptr;
			    L_pointer_suppliedQUERY = TRUE;
			}
			else {

			    /* #line 389 "./condition.dylan" */
			    L_temp_2.heapptr = &networkZstr_ROOT;
			    L_temp_2.dataword.l = 0;
			    /* type-error-with-location */
			    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_value, &dylanZdylan_visceraZCLS_raw_pointer_HEAP, L_temp_2);
			    not_reached();
			}
		    }
		    /* #line {Class <unknown-source-location>} */
		    L_index = (L_index - 2);
		}
		else {

		    /* #line 389 "./condition.dylan" */
		    L_temp_3.heapptr = &networkZstr_ROOT;
		    L_temp_3.dataword.l = 0;
		    /* type-error-with-location */
		    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp, &dylanZdylan_visceraZCLS_symbol_HEAP, L_temp_3);
		    not_reached();
		}
	    }
	}
      block0:;
	/* #line {Class <unknown-source-location>} */
	orig_sp = L_args;
	/* maker for <char<@120>> */
	L_result0 = networkZnetwork_internalZCLS_charLESSX40120GREATER_MAKER_FUN(orig_sp, L_pointer, L_pointer_suppliedQUERY);
	L_temp_4.heapptr = networkZliteral_15.heapptr;
	L_temp_4.dataword.ptr = L_result0;
	orig_sp[0] = L_temp_4;
	return orig_sp + 1;
    }
    else {
	/* odd-number-of-keyword/value-arguments-error */
	dylanZdylan_visceraZodd_number_of_keywordSLASHvalue_arguments_error_FUN(orig_sp);
	not_reached();
    }
}


/* Define Sealed Domain make (singleton(<char<@120>>)) */


/* Define Method content-size{singleton(<char<@120>>)} */

/* content-size{singleton(<char<@120>>)} */
long networkZnetwork_internalZcontent_size_METH_13(descriptor_t *orig_sp, heapptr_t A0, heapptr_t A1)
{

    return 120;
}

/* generic-entry for content-size{singleton(<char<@120>>)} */
descriptor_t * networkZnetwork_internalZcontent_size_METH_GENERIC_13(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    long L_result0; /* result0 */
    descriptor_t L_temp;

    orig_sp = ((void *)(orig_sp - 1));
    /* content-size{singleton(<char<@120>>)} */
    L_result0 = networkZnetwork_internalZcontent_size_METH_13(orig_sp, &networkZnetwork_internalZCLS_charLESSX40120GREATER_HEAP, A_next_method_info);
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* Define Class <sockaddr-storage> */

/* <sockaddr-storage> is <sockaddr-storage> */

extern struct heapobj networkZnetwork_internalZCLS_sockaddr_storage_HEAP;

/* maker for <sockaddr-storage> */
void * networkZnetwork_internalZCLS_sockaddr_storage_MAKER_FUN(descriptor_t *orig_sp, void * A_pointer /* pointer */, int A_pointer_suppliedQUERY /* pointer-supplied? */)
{
    descriptor_t *cluster_0_top;


    /* #line 592 "./sockets-api.dylan" */
    if (A_pointer_suppliedQUERY) {
	return A_pointer;
    }
    else {
	/* missing-required-init-keyword-error */
	dylanZdylan_visceraZmissing_required_init_keyword_error_FUN(orig_sp, &SYM_pointer_HEAP, &networkZnetwork_internalZCLS_sockaddr_storage_HEAP);
	not_reached();
    }
}

extern descriptor_t networkZliteral_16;	/* proxy for <sockaddr-storage> */

/* general-entry for maker for <sockaddr-storage> */
descriptor_t * networkZnetwork_internalZCLS_sockaddr_storage_MAKER_GENERAL(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    void * L_pointer; /* pointer */
    int L_pointer_suppliedQUERY; /* pointer-supplied? */
    long L_index; /* index */
    descriptor_t L_temp; /* temp */
    descriptor_t L_value; /* value */
    descriptor_t L_temp_2;
    descriptor_t L_temp_3;
    void * L_result0; /* result0 */
    descriptor_t L_temp_4;

    /* #line {Class <unknown-source-location>} */

    /* #line 126 "./cmp.dylan" */

    /* #line 209 "./num.dylan" */
    if (((A_nargs & 1) == 0)) {
	/* #line {Class <unknown-source-location>} */
	L_args = ((void *)(orig_sp - A_nargs));
	L_pointer = 0;
	L_pointer_suppliedQUERY = FALSE;
	L_index = (A_nargs - 2);
	while (1) {
	    if ((L_index < 0)) {
		goto block0;
	    }
	    else {
		L_temp = (((descriptor_t *)L_args)[L_index]);

		/* #line 386 "./condition.dylan" */
		if ((&dylanZdylan_visceraZCLS_symbol_HEAP == SLOT(L_temp.heapptr, heapptr_t, 0))) {
		    /* #line {Class <unknown-source-location>} */
		    L_value = (((descriptor_t *)L_args)[(L_index + 1)]);
		    if ((L_temp.heapptr == &SYM_pointer_HEAP)) {

			/* #line 386 "./condition.dylan" */
			if ((&dylanZdylan_visceraZCLS_raw_pointer_HEAP == SLOT(L_value.heapptr, heapptr_t, 0))) {
			    /* #line {Class <unknown-source-location>} */
			    L_pointer = L_value.dataword.ptr;
			    L_pointer_suppliedQUERY = TRUE;
			}
			else {

			    /* #line 389 "./condition.dylan" */
			    L_temp_2.heapptr = &networkZstr_ROOT;
			    L_temp_2.dataword.l = 0;
			    /* type-error-with-location */
			    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_value, &dylanZdylan_visceraZCLS_raw_pointer_HEAP, L_temp_2);
			    not_reached();
			}
		    }
		    /* #line {Class <unknown-source-location>} */
		    L_index = (L_index - 2);
		}
		else {

		    /* #line 389 "./condition.dylan" */
		    L_temp_3.heapptr = &networkZstr_ROOT;
		    L_temp_3.dataword.l = 0;
		    /* type-error-with-location */
		    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp, &dylanZdylan_visceraZCLS_symbol_HEAP, L_temp_3);
		    not_reached();
		}
	    }
	}
      block0:;
	/* #line {Class <unknown-source-location>} */
	orig_sp = L_args;
	/* maker for <sockaddr-storage> */
	L_result0 = networkZnetwork_internalZCLS_sockaddr_storage_MAKER_FUN(orig_sp, L_pointer, L_pointer_suppliedQUERY);
	L_temp_4.heapptr = networkZliteral_16.heapptr;
	L_temp_4.dataword.ptr = L_result0;
	orig_sp[0] = L_temp_4;
	return orig_sp + 1;
    }
    else {
	/* odd-number-of-keyword/value-arguments-error */
	dylanZdylan_visceraZodd_number_of_keywordSLASHvalue_arguments_error_FUN(orig_sp);
	not_reached();
    }
}


/* Define Sealed Domain make (singleton(<sockaddr-storage>)) */


/* {Implicit} Define Generic get-ss-family */

/* get-ss-family is get-ss-family */


/* Define Method get-ss-family{<sockaddr-storage>} */

/* get-ss-family{<sockaddr-storage>} */
long networkZnetwork_internalZget_ss_family_METH(descriptor_t *orig_sp, void * A_ptr /* ptr */, heapptr_t A1)
{
    descriptor_t *cluster_0_top;


    /* #line 185 "./melange.dylan" */

    /* #line 91 "./rawptr.dylan" */
    return (*(unsigned short *)((char *)A_ptr + 0 ));
}


/* {Implicit} Define Generic get-ss-family-setter */

/* get-ss-family-setter is get-ss-family-setter */


/* Define Method get-ss-family-setter{<integer>, <sockaddr-storage>} */

/* get-ss-family-setter{<integer>, <sockaddr-storage>} */
long networkZnetwork_internalZget_ss_family_setter_METH(descriptor_t *orig_sp, long A_value /* value */, void * A_ptr /* ptr */, heapptr_t A2)
{
    descriptor_t *cluster_0_top;

    /* #line {Class <unknown-source-location>} */

    /* #line 97 "./rawptr.dylan" */
    *(unsigned short *)((char *)A_ptr + 0) = A_value;
    return A_value;
}


/* {Implicit} Define Generic get-__ss-align */

/* get-__ss-align is get-__ss-align */


/* Define Method get-__ss-align{<sockaddr-storage>} */

/* get-__ss-align{<sockaddr-storage>} */
long networkZnetwork_internalZget_X_X_ss_align_METH(descriptor_t *orig_sp, void * A_ptr /* ptr */, heapptr_t A1)
{
    descriptor_t *cluster_0_top;

    /* #line {Class <unknown-source-location>} */

    /* #line 211 "./melange.dylan" */

    /* #line 91 "./rawptr.dylan" */
    return (*(long *)((char *)A_ptr + 4 ));
}


/* {Implicit} Define Generic get-__ss-align-setter */

/* get-__ss-align-setter is get-__ss-align-setter */


/* Define Method get-__ss-align-setter{<integer>, <sockaddr-storage>} */

/* get-__ss-align-setter{<integer>, <sockaddr-storage>} */
long networkZnetwork_internalZget_X_X_ss_align_setter_METH(descriptor_t *orig_sp, long A_value /* value */, void * A_ptr /* ptr */, heapptr_t A2)
{
    descriptor_t *cluster_0_top;

    /* #line {Class <unknown-source-location>} */

    /* #line 97 "./rawptr.dylan" */
    *(long *)((char *)A_ptr + 4) = A_value;
    return A_value;
}


/* {Implicit} Define Generic get-__ss-padding */

/* get-__ss-padding is get-__ss-padding */


/* Define Method get-__ss-padding{<sockaddr-storage>} */

extern struct heapobj networkZstr_ROOT_20;

/* get-__ss-padding{<sockaddr-storage>} */
void * networkZnetwork_internalZget_X_X_ss_padding_METH(descriptor_t *orig_sp, void * A_ptr /* ptr */, heapptr_t A1)
{
    descriptor_t *cluster_0_top;
    descriptor_t L_temp;
    descriptor_t L_temp_2;
    descriptor_t L_temp_3;
    descriptor_t L_temp_4; /* temp */
    int L_condition; /* condition */
    descriptor_t L_temp_5;
    descriptor_t L_temp_6; /* temp */
    descriptor_t L_temp_7;
    descriptor_t L_temp_8;

    /* #line {Class <unknown-source-location>} */

    /* #line 49 "./object.dylan" */
    L_temp.heapptr = networkZliteral_16.heapptr;
    L_temp.dataword.ptr = A_ptr;

    /* #line 324 "./melange.dylan" */

    /* #line 324 "./melange.dylan" */

    /* #line 324 "./melange.dylan" */
    L_temp_2.heapptr = SLOT(L_temp.heapptr, heapptr_t, 0);
    L_temp_2.dataword.l = 0;
    L_temp_3.heapptr = networkZliteral_6.heapptr;
    L_temp_3.dataword.ptr = ((void *)((char *)A_ptr + 8));
    orig_sp[0] = L_temp_2;
    orig_sp[1] = L_temp_3;
    /* as */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZas_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_temp_4 = orig_sp[0];

    /* #line 49 "./object.dylan" */

    /* #line 386 "./condition.dylan" */
    /* %subtype?{<class>, <class>} */
    L_condition = dylanZdylan_visceraZPCTsubtypeQUERY_METH(orig_sp, SLOT(L_temp_4.heapptr, heapptr_t, 0), &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP, &dylanZliteral_ROOT_2);
    if (L_condition) {

	/* #line 324 "./melange.dylan" */

	/* #line 620 "./sockets-api.dylan" */
	L_temp_5.heapptr = &networkZnetwork_internalZCLS_charLESSX40120GREATER_HEAP;
	L_temp_5.dataword.l = 0;
	orig_sp[0] = L_temp_5;
	orig_sp[1] = L_temp_4;
	/* as */
	{
	  struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZas_HEAP, 2);
	  heapptr_t L_meth = L_temp.R0;
	  heapptr_t L_next_info = L_temp.R1;
	  cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
	}
	L_temp_6 = orig_sp[0];

	/* #line 386 "./condition.dylan" */
	if ((&networkZnetwork_internalZCLS_charLESSX40120GREATER_HEAP == SLOT(L_temp_6.heapptr, heapptr_t, 0))) {

	    /* #line 620 "./sockets-api.dylan" */
	    return L_temp_6.dataword.ptr;
	}
	else {

	    /* #line 389 "./condition.dylan" */
	    L_temp_7.heapptr = &networkZstr_ROOT_20;
	    L_temp_7.dataword.l = 0;
	    /* type-error-with-location */
	    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp_6, &networkZnetwork_internalZCLS_charLESSX40120GREATER_HEAP, L_temp_7);
	    not_reached();
	}
    }
    else {
	L_temp_8.heapptr = &networkZstr_ROOT_5;
	L_temp_8.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp_4, &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP, L_temp_8);
	not_reached();
    }
}


/* Define Method pointer-value{<sockaddr-storage>} */

extern struct heapobj networkZstr_ROOT_21;

/* pointer-value{<sockaddr-storage>} */
void * networkZnetwork_internalZpointer_value_METH_10(descriptor_t *orig_sp, void * A_value /* value */, heapptr_t A_next_method_info /* next-method-info */, heapptr_t A_rest /* rest */, descriptor_t A_index /* index */)
{
    descriptor_t *cluster_0_top;
    descriptor_t L_temp;
    descriptor_t L_arg1; /* arg1 */
    descriptor_t L_temp_2;
    descriptor_t L_temp_3; /* temp */
    descriptor_t L_temp_4;

    /* #line {Class <unknown-source-location>} */

    /* #line 624 "./sockets-api.dylan" */
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = 128;
    orig_sp[0] = A_index;
    orig_sp[1] = L_temp;
    /* * */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZV_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_arg1 = (orig_sp == cluster_0_top ? dylanZfalse : orig_sp[0]);

    /* #line 624 "./sockets-api.dylan" */
    L_temp_2.heapptr = networkZliteral_16.heapptr;
    L_temp_2.dataword.ptr = A_value;
    orig_sp[0] = L_temp_2;
    orig_sp[1] = L_arg1;
    /* + */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZPLUS_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_temp_3 = (orig_sp == cluster_0_top ? dylanZfalse : orig_sp[0]);

    /* #line 386 "./condition.dylan" */
    if ((&networkZnetwork_internalZCLS_sockaddr_storage_HEAP == SLOT(L_temp_3.heapptr, heapptr_t, 0))) {

	/* #line 624 "./sockets-api.dylan" */
	return L_temp_3.dataword.ptr;
    }
    else {

	/* #line 389 "./condition.dylan" */
	L_temp_4.heapptr = &networkZstr_ROOT_21;
	L_temp_4.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp_3, &networkZnetwork_internalZCLS_sockaddr_storage_HEAP, L_temp_4);
	not_reached();
    }
}

/* generic-entry for pointer-value{<sockaddr-storage>} */
descriptor_t * networkZnetwork_internalZpointer_value_METH_GENERIC_10(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    descriptor_t L_arg; /* arg */
    heapptr_t L_rest; /* rest */
    void * L_arg_2; /* arg */
    descriptor_t L_index; /* index */
    long L_index_2; /* index */
    descriptor_t L_key; /* key */
    descriptor_t L_value; /* value */
    void * L_result0; /* result0 */
    descriptor_t L_temp;

    /* #line {Class <unknown-source-location>} */
    L_args = ((void *)(orig_sp - A_nargs));
    L_arg = (((descriptor_t *)L_args)[0]);
    L_rest = dylanZdylan_visceraZmake_rest_arg_FUN(orig_sp, (descriptor_t *)L_args + 1, A_nargs - 1);
    L_arg_2 = L_arg.dataword.ptr;
    L_index.heapptr = networkZliteral_2.heapptr;
    L_index.dataword.l = 0;
    L_index_2 = (A_nargs - 2);
    while (1) {
	if ((L_index_2 < 1)) {
	    goto block0;
	}
	else {
	    L_key = (((descriptor_t *)L_args)[L_index_2]);
	    L_value = (((descriptor_t *)L_args)[(L_index_2 + 1)]);
	    if ((L_key.heapptr == &SYM_index_HEAP)) {
		L_index = L_value;
	    }
	    L_index_2 = (L_index_2 - 2);
	}
    }
  block0:;
    orig_sp = L_args;
    /* pointer-value{<sockaddr-storage>} */
    L_result0 = networkZnetwork_internalZpointer_value_METH_10(orig_sp, L_arg_2, A_next_method_info, L_rest, L_index);
    L_temp.heapptr = networkZliteral_16.heapptr;
    L_temp.dataword.ptr = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* Define Method content-size{subclass(<sockaddr-storage>)} */

/* content-size{subclass(<sockaddr-storage>)} */
long networkZnetwork_internalZcontent_size_METH_14(descriptor_t *orig_sp, heapptr_t A0, heapptr_t A1)
{

    return 128;
}

/* generic-entry for content-size{subclass(<sockaddr-storage>)} */
descriptor_t * networkZnetwork_internalZcontent_size_METH_GENERIC_14(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    long L_result0; /* result0 */
    descriptor_t L_temp;

    orig_sp = ((void *)(orig_sp - 1));
    /* content-size{subclass(<sockaddr-storage>)} */
    L_result0 = networkZnetwork_internalZcontent_size_METH_14(orig_sp, &networkZnetwork_internalZCLS_sockaddr_storage_HEAP, A_next_method_info);
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* Define Constant <anonymous-14> */

/* <anonymous-14> allocated as networkZnetwork_internalZCLS_anonymous_14 */


/* Define Constant $MSG-OOB */

/* $MSG-OOB is 1 */


/* Define Constant $MSG-PEEK */

/* $MSG-PEEK is 2 */


/* Define Constant $MSG-DONTROUTE */

/* $MSG-DONTROUTE is 4 */


/* Define Constant $MSG-CTRUNC */

/* $MSG-CTRUNC is 8 */


/* Define Constant $MSG-PROXY */

/* $MSG-PROXY is 16 */


/* Define Constant $MSG-TRUNC */

/* $MSG-TRUNC is 32 */


/* Define Constant $MSG-DONTWAIT */

/* $MSG-DONTWAIT is 64 */


/* Define Constant $MSG-EOR */

/* $MSG-EOR is 128 */


/* Define Constant $MSG-WAITALL */

/* $MSG-WAITALL is 256 */


/* Define Constant $MSG-FIN */

/* $MSG-FIN is 512 */


/* Define Constant $MSG-SYN */

/* $MSG-SYN is 1024 */


/* Define Constant $MSG-CONFIRM */

/* $MSG-CONFIRM is 2048 */


/* Define Constant $MSG-RST */

/* $MSG-RST is 4096 */


/* Define Constant $MSG-ERRQUEUE */

/* $MSG-ERRQUEUE is 8192 */


/* Define Constant $MSG-NOSIGNAL */

/* $MSG-NOSIGNAL is 16384 */


/* Define Constant $MSG-MORE */

/* $MSG-MORE is 32768 */


/* Define Class <cmsghdr> */

/* <cmsghdr> is <cmsghdr> */

extern struct heapobj networkZnetwork_internalZCLS_cmsghdr_HEAP;

/* maker for <cmsghdr> */
void * networkZnetwork_internalZCLS_cmsghdr_MAKER_FUN(descriptor_t *orig_sp, void * A_pointer /* pointer */, int A_pointer_suppliedQUERY /* pointer-supplied? */)
{
    descriptor_t *cluster_0_top;


    /* #line 649 "./sockets-api.dylan" */
    if (A_pointer_suppliedQUERY) {
	return A_pointer;
    }
    else {
	/* missing-required-init-keyword-error */
	dylanZdylan_visceraZmissing_required_init_keyword_error_FUN(orig_sp, &SYM_pointer_HEAP, &networkZnetwork_internalZCLS_cmsghdr_HEAP);
	not_reached();
    }
}

extern descriptor_t networkZliteral_17;	/* proxy for <cmsghdr> */

/* general-entry for maker for <cmsghdr> */
descriptor_t * networkZnetwork_internalZCLS_cmsghdr_MAKER_GENERAL(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    void * L_pointer; /* pointer */
    int L_pointer_suppliedQUERY; /* pointer-supplied? */
    long L_index; /* index */
    descriptor_t L_temp; /* temp */
    descriptor_t L_value; /* value */
    descriptor_t L_temp_2;
    descriptor_t L_temp_3;
    void * L_result0; /* result0 */
    descriptor_t L_temp_4;

    /* #line {Class <unknown-source-location>} */

    /* #line 126 "./cmp.dylan" */

    /* #line 209 "./num.dylan" */
    if (((A_nargs & 1) == 0)) {
	/* #line {Class <unknown-source-location>} */
	L_args = ((void *)(orig_sp - A_nargs));
	L_pointer = 0;
	L_pointer_suppliedQUERY = FALSE;
	L_index = (A_nargs - 2);
	while (1) {
	    if ((L_index < 0)) {
		goto block0;
	    }
	    else {
		L_temp = (((descriptor_t *)L_args)[L_index]);

		/* #line 386 "./condition.dylan" */
		if ((&dylanZdylan_visceraZCLS_symbol_HEAP == SLOT(L_temp.heapptr, heapptr_t, 0))) {
		    /* #line {Class <unknown-source-location>} */
		    L_value = (((descriptor_t *)L_args)[(L_index + 1)]);
		    if ((L_temp.heapptr == &SYM_pointer_HEAP)) {

			/* #line 386 "./condition.dylan" */
			if ((&dylanZdylan_visceraZCLS_raw_pointer_HEAP == SLOT(L_value.heapptr, heapptr_t, 0))) {
			    /* #line {Class <unknown-source-location>} */
			    L_pointer = L_value.dataword.ptr;
			    L_pointer_suppliedQUERY = TRUE;
			}
			else {

			    /* #line 389 "./condition.dylan" */
			    L_temp_2.heapptr = &networkZstr_ROOT;
			    L_temp_2.dataword.l = 0;
			    /* type-error-with-location */
			    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_value, &dylanZdylan_visceraZCLS_raw_pointer_HEAP, L_temp_2);
			    not_reached();
			}
		    }
		    /* #line {Class <unknown-source-location>} */
		    L_index = (L_index - 2);
		}
		else {

		    /* #line 389 "./condition.dylan" */
		    L_temp_3.heapptr = &networkZstr_ROOT;
		    L_temp_3.dataword.l = 0;
		    /* type-error-with-location */
		    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp, &dylanZdylan_visceraZCLS_symbol_HEAP, L_temp_3);
		    not_reached();
		}
	    }
	}
      block0:;
	/* #line {Class <unknown-source-location>} */
	orig_sp = L_args;
	/* maker for <cmsghdr> */
	L_result0 = networkZnetwork_internalZCLS_cmsghdr_MAKER_FUN(orig_sp, L_pointer, L_pointer_suppliedQUERY);
	L_temp_4.heapptr = networkZliteral_17.heapptr;
	L_temp_4.dataword.ptr = L_result0;
	orig_sp[0] = L_temp_4;
	return orig_sp + 1;
    }
    else {
	/* odd-number-of-keyword/value-arguments-error */
	dylanZdylan_visceraZodd_number_of_keywordSLASHvalue_arguments_error_FUN(orig_sp);
	not_reached();
    }
}


/* Define Sealed Domain make (singleton(<cmsghdr>)) */


/* {Implicit} Define Generic get-cmsg-len */

/* get-cmsg-len is get-cmsg-len */


/* Define Method get-cmsg-len{<cmsghdr>} */

/* get-cmsg-len{<cmsghdr>} */
long networkZnetwork_internalZget_cmsg_len_METH(descriptor_t *orig_sp, void * A_ptr /* ptr */, heapptr_t A1)
{
    descriptor_t *cluster_0_top;


    /* #line 211 "./melange.dylan" */

    /* #line 91 "./rawptr.dylan" */
    return (*(long *)((char *)A_ptr + 0 ));
}


/* {Implicit} Define Generic get-cmsg-len-setter */

/* get-cmsg-len-setter is get-cmsg-len-setter */


/* Define Method get-cmsg-len-setter{<integer>, <cmsghdr>} */

/* get-cmsg-len-setter{<integer>, <cmsghdr>} */
long networkZnetwork_internalZget_cmsg_len_setter_METH(descriptor_t *orig_sp, long A_value /* value */, void * A_ptr /* ptr */, heapptr_t A2)
{
    descriptor_t *cluster_0_top;

    /* #line {Class <unknown-source-location>} */

    /* #line 97 "./rawptr.dylan" */
    *(long *)((char *)A_ptr + 0) = A_value;
    return A_value;
}


/* {Implicit} Define Generic get-cmsg-level */

/* get-cmsg-level is get-cmsg-level */


/* Define Method get-cmsg-level{<cmsghdr>} */

/* get-cmsg-level{<cmsghdr>} */
long networkZnetwork_internalZget_cmsg_level_METH(descriptor_t *orig_sp, void * A_ptr /* ptr */, heapptr_t A1)
{
    descriptor_t *cluster_0_top;

    /* #line {Class <unknown-source-location>} */

    /* #line 198 "./melange.dylan" */

    /* #line 91 "./rawptr.dylan" */
    return (*(long *)((char *)A_ptr + 4 ));
}


/* {Implicit} Define Generic get-cmsg-level-setter */

/* get-cmsg-level-setter is get-cmsg-level-setter */


/* Define Method get-cmsg-level-setter{<integer>, <cmsghdr>} */

/* get-cmsg-level-setter{<integer>, <cmsghdr>} */
long networkZnetwork_internalZget_cmsg_level_setter_METH(descriptor_t *orig_sp, long A_value /* value */, void * A_ptr /* ptr */, heapptr_t A2)
{
    descriptor_t *cluster_0_top;

    /* #line {Class <unknown-source-location>} */

    /* #line 97 "./rawptr.dylan" */
    *(long *)((char *)A_ptr + 4) = A_value;
    return A_value;
}


/* {Implicit} Define Generic get-cmsg-type */

/* get-cmsg-type is get-cmsg-type */


/* Define Method get-cmsg-type{<cmsghdr>} */

/* get-cmsg-type{<cmsghdr>} */
long networkZnetwork_internalZget_cmsg_type_METH(descriptor_t *orig_sp, void * A_ptr /* ptr */, heapptr_t A1)
{
    descriptor_t *cluster_0_top;

    /* #line {Class <unknown-source-location>} */

    /* #line 198 "./melange.dylan" */

    /* #line 91 "./rawptr.dylan" */
    return (*(long *)((char *)A_ptr + 8 ));
}


/* {Implicit} Define Generic get-cmsg-type-setter */

/* get-cmsg-type-setter is get-cmsg-type-setter */


/* Define Method get-cmsg-type-setter{<integer>, <cmsghdr>} */

/* get-cmsg-type-setter{<integer>, <cmsghdr>} */
long networkZnetwork_internalZget_cmsg_type_setter_METH(descriptor_t *orig_sp, long A_value /* value */, void * A_ptr /* ptr */, heapptr_t A2)
{
    descriptor_t *cluster_0_top;

    /* #line {Class <unknown-source-location>} */

    /* #line 97 "./rawptr.dylan" */
    *(long *)((char *)A_ptr + 8) = A_value;
    return A_value;
}


/* Define Method pointer-value{<cmsghdr>} */

extern struct heapobj networkZstr_ROOT_22;

/* pointer-value{<cmsghdr>} */
void * networkZnetwork_internalZpointer_value_METH_11(descriptor_t *orig_sp, void * A_value /* value */, heapptr_t A_next_method_info /* next-method-info */, heapptr_t A_rest /* rest */, descriptor_t A_index /* index */)
{
    descriptor_t *cluster_0_top;
    descriptor_t L_temp;
    descriptor_t L_arg1; /* arg1 */
    descriptor_t L_temp_2;
    descriptor_t L_temp_3; /* temp */
    descriptor_t L_temp_4;

    /* #line {Class <unknown-source-location>} */

    /* #line 687 "./sockets-api.dylan" */
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = 12;
    orig_sp[0] = A_index;
    orig_sp[1] = L_temp;
    /* * */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZV_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_arg1 = (orig_sp == cluster_0_top ? dylanZfalse : orig_sp[0]);

    /* #line 687 "./sockets-api.dylan" */
    L_temp_2.heapptr = networkZliteral_17.heapptr;
    L_temp_2.dataword.ptr = A_value;
    orig_sp[0] = L_temp_2;
    orig_sp[1] = L_arg1;
    /* + */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZPLUS_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_temp_3 = (orig_sp == cluster_0_top ? dylanZfalse : orig_sp[0]);

    /* #line 386 "./condition.dylan" */
    if ((&networkZnetwork_internalZCLS_cmsghdr_HEAP == SLOT(L_temp_3.heapptr, heapptr_t, 0))) {

	/* #line 687 "./sockets-api.dylan" */
	return L_temp_3.dataword.ptr;
    }
    else {

	/* #line 389 "./condition.dylan" */
	L_temp_4.heapptr = &networkZstr_ROOT_22;
	L_temp_4.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp_3, &networkZnetwork_internalZCLS_cmsghdr_HEAP, L_temp_4);
	not_reached();
    }
}

/* generic-entry for pointer-value{<cmsghdr>} */
descriptor_t * networkZnetwork_internalZpointer_value_METH_GENERIC_11(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    descriptor_t L_arg; /* arg */
    heapptr_t L_rest; /* rest */
    void * L_arg_2; /* arg */
    descriptor_t L_index; /* index */
    long L_index_2; /* index */
    descriptor_t L_key; /* key */
    descriptor_t L_value; /* value */
    void * L_result0; /* result0 */
    descriptor_t L_temp;

    /* #line {Class <unknown-source-location>} */
    L_args = ((void *)(orig_sp - A_nargs));
    L_arg = (((descriptor_t *)L_args)[0]);
    L_rest = dylanZdylan_visceraZmake_rest_arg_FUN(orig_sp, (descriptor_t *)L_args + 1, A_nargs - 1);
    L_arg_2 = L_arg.dataword.ptr;
    L_index.heapptr = networkZliteral_2.heapptr;
    L_index.dataword.l = 0;
    L_index_2 = (A_nargs - 2);
    while (1) {
	if ((L_index_2 < 1)) {
	    goto block0;
	}
	else {
	    L_key = (((descriptor_t *)L_args)[L_index_2]);
	    L_value = (((descriptor_t *)L_args)[(L_index_2 + 1)]);
	    if ((L_key.heapptr == &SYM_index_HEAP)) {
		L_index = L_value;
	    }
	    L_index_2 = (L_index_2 - 2);
	}
    }
  block0:;
    orig_sp = L_args;
    /* pointer-value{<cmsghdr>} */
    L_result0 = networkZnetwork_internalZpointer_value_METH_11(orig_sp, L_arg_2, A_next_method_info, L_rest, L_index);
    L_temp.heapptr = networkZliteral_17.heapptr;
    L_temp.dataword.ptr = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* Define Method content-size{subclass(<cmsghdr>)} */

/* content-size{subclass(<cmsghdr>)} */
long networkZnetwork_internalZcontent_size_METH_15(descriptor_t *orig_sp, heapptr_t A0, heapptr_t A1)
{

    return 12;
}

/* generic-entry for content-size{subclass(<cmsghdr>)} */
descriptor_t * networkZnetwork_internalZcontent_size_METH_GENERIC_15(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    long L_result0; /* result0 */
    descriptor_t L_temp;

    orig_sp = ((void *)(orig_sp - 1));
    /* content-size{subclass(<cmsghdr>)} */
    L_result0 = networkZnetwork_internalZcontent_size_METH_15(orig_sp, &networkZnetwork_internalZCLS_cmsghdr_HEAP, A_next_method_info);
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* {Implicit} Define Generic __cmsg-nxthdr */

/* __cmsg-nxthdr is __cmsg-nxthdr */


/* Define Method __cmsg-nxthdr{<msghdr>, <cmsghdr>} */

extern heapptr_t dylanZdylan_visceraZCLS_simple_object_vector_MAKER_FUN(descriptor_t *orig_sp, long A0, descriptor_t A1);	/* maker for <simple-object-vector> */

extern descriptor_t melange_supportZmelange_supportZmake_METH(descriptor_t *orig_sp, heapptr_t A0, heapptr_t A1, heapptr_t A2, long A3, descriptor_t A4, long A5);	/* make{subclass(<statically-typed-pointer>)} */

extern struct heapobj networkZliteral_ROOT;

extern struct heapobj networkZstr_ROOT_23;

/* __cmsg-nxthdr{<msghdr>, <cmsghdr>} */
void * networkZnetwork_internalZX_X_cmsg_nxthdr_METH(descriptor_t *orig_sp, void * A_arg1 /* arg1 */, void * A_arg2 /* arg2 */, heapptr_t A2)
{
    descriptor_t *cluster_0_top;
    void * L_result_value; /* result-value */
    heapptr_t L_instance; /* instance */
    descriptor_t L_temp;
    descriptor_t L_temp_2;
    descriptor_t L_temp_3;
    descriptor_t L_result_value_2; /* result-value */
    descriptor_t L_temp_4;


    /* #line 698 "./sockets-api.dylan" */

    /* #line 698 "./sockets-api.dylan" */

    /* #line 735 "./macros.dylan" */
    L_result_value = __cmsg_nxthdr(A_arg1, A_arg2);

    /* #line 699 "./sockets-api.dylan" */
    /* maker for <simple-object-vector> */
    L_instance = dylanZdylan_visceraZCLS_simple_object_vector_MAKER_FUN(orig_sp, 2, dylanZfalse);
    L_temp.heapptr = &SYM_pointer_HEAP;
    L_temp.dataword.l = 0;
    SLOT(L_instance, descriptor_t, 8 + 0 * sizeof(descriptor_t)) = L_temp;
    L_temp_2.heapptr = networkZliteral_6.heapptr;
    L_temp_2.dataword.ptr = L_result_value;
    SLOT(L_instance, descriptor_t, 8 + 1 * sizeof(descriptor_t)) = L_temp_2;
    L_temp_3.heapptr = networkZliteral_6.heapptr;
    L_temp_3.dataword.ptr = L_result_value;
    /* make{subclass(<statically-typed-pointer>)} */
    L_result_value_2 = melange_supportZmelange_supportZmake_METH(orig_sp, &networkZnetwork_internalZCLS_cmsghdr_HEAP, &networkZliteral_ROOT, L_instance, 0, L_temp_3, 1);

    /* #line 386 "./condition.dylan" */
    if ((&networkZnetwork_internalZCLS_cmsghdr_HEAP == SLOT(L_result_value_2.heapptr, heapptr_t, 0))) {

	/* #line 700 "./sockets-api.dylan" */
	return L_result_value_2.dataword.ptr;
    }
    else {

	/* #line 389 "./condition.dylan" */
	L_temp_4.heapptr = &networkZstr_ROOT_23;
	L_temp_4.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_result_value_2, &networkZnetwork_internalZCLS_cmsghdr_HEAP, L_temp_4);
	not_reached();
    }
}


/* Define Constant <anonymous-16> */

/* <anonymous-16> allocated as networkZnetwork_internalZCLS_anonymous_16 */


/* Define Constant $SCM-RIGHTS */

/* $SCM-RIGHTS is 1 */


/* Define Constant $SCM-CREDENTIALS */

/* $SCM-CREDENTIALS is 2 */


/* Define Constant $__SCM-CONNECT */

/* $__SCM-CONNECT is 3 */


/* Define Constant <__pid-t> */

/* <__pid-t> is <integer> */


/* Define Constant <pid-t> */

/* <pid-t> is <integer> */


/* Define Constant <__uid-t> */

/* <__uid-t> is <integer> */


/* Define Constant <uid-t> */

/* <uid-t> is <integer> */


/* Define Constant <__gid-t> */

/* <__gid-t> is <integer> */


/* Define Constant <gid-t> */

/* <gid-t> is <integer> */


/* Define Class <ucred> */

/* <ucred> is <ucred> */

extern struct heapobj networkZnetwork_internalZCLS_ucred_HEAP;

/* maker for <ucred> */
void * networkZnetwork_internalZCLS_ucred_MAKER_FUN(descriptor_t *orig_sp, void * A_pointer /* pointer */, int A_pointer_suppliedQUERY /* pointer-supplied? */)
{
    descriptor_t *cluster_0_top;


    /* #line 720 "./sockets-api.dylan" */
    if (A_pointer_suppliedQUERY) {
	return A_pointer;
    }
    else {
	/* missing-required-init-keyword-error */
	dylanZdylan_visceraZmissing_required_init_keyword_error_FUN(orig_sp, &SYM_pointer_HEAP, &networkZnetwork_internalZCLS_ucred_HEAP);
	not_reached();
    }
}

extern descriptor_t networkZliteral_18;	/* proxy for <ucred> */

/* general-entry for maker for <ucred> */
descriptor_t * networkZnetwork_internalZCLS_ucred_MAKER_GENERAL(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    void * L_pointer; /* pointer */
    int L_pointer_suppliedQUERY; /* pointer-supplied? */
    long L_index; /* index */
    descriptor_t L_temp; /* temp */
    descriptor_t L_value; /* value */
    descriptor_t L_temp_2;
    descriptor_t L_temp_3;
    void * L_result0; /* result0 */
    descriptor_t L_temp_4;

    /* #line {Class <unknown-source-location>} */

    /* #line 126 "./cmp.dylan" */

    /* #line 209 "./num.dylan" */
    if (((A_nargs & 1) == 0)) {
	/* #line {Class <unknown-source-location>} */
	L_args = ((void *)(orig_sp - A_nargs));
	L_pointer = 0;
	L_pointer_suppliedQUERY = FALSE;
	L_index = (A_nargs - 2);
	while (1) {
	    if ((L_index < 0)) {
		goto block0;
	    }
	    else {
		L_temp = (((descriptor_t *)L_args)[L_index]);

		/* #line 386 "./condition.dylan" */
		if ((&dylanZdylan_visceraZCLS_symbol_HEAP == SLOT(L_temp.heapptr, heapptr_t, 0))) {
		    /* #line {Class <unknown-source-location>} */
		    L_value = (((descriptor_t *)L_args)[(L_index + 1)]);
		    if ((L_temp.heapptr == &SYM_pointer_HEAP)) {

			/* #line 386 "./condition.dylan" */
			if ((&dylanZdylan_visceraZCLS_raw_pointer_HEAP == SLOT(L_value.heapptr, heapptr_t, 0))) {
			    /* #line {Class <unknown-source-location>} */
			    L_pointer = L_value.dataword.ptr;
			    L_pointer_suppliedQUERY = TRUE;
			}
			else {

			    /* #line 389 "./condition.dylan" */
			    L_temp_2.heapptr = &networkZstr_ROOT;
			    L_temp_2.dataword.l = 0;
			    /* type-error-with-location */
			    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_value, &dylanZdylan_visceraZCLS_raw_pointer_HEAP, L_temp_2);
			    not_reached();
			}
		    }
		    /* #line {Class <unknown-source-location>} */
		    L_index = (L_index - 2);
		}
		else {

		    /* #line 389 "./condition.dylan" */
		    L_temp_3.heapptr = &networkZstr_ROOT;
		    L_temp_3.dataword.l = 0;
		    /* type-error-with-location */
		    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp, &dylanZdylan_visceraZCLS_symbol_HEAP, L_temp_3);
		    not_reached();
		}
	    }
	}
      block0:;
	/* #line {Class <unknown-source-location>} */
	orig_sp = L_args;
	/* maker for <ucred> */
	L_result0 = networkZnetwork_internalZCLS_ucred_MAKER_FUN(orig_sp, L_pointer, L_pointer_suppliedQUERY);
	L_temp_4.heapptr = networkZliteral_18.heapptr;
	L_temp_4.dataword.ptr = L_result0;
	orig_sp[0] = L_temp_4;
	return orig_sp + 1;
    }
    else {
	/* odd-number-of-keyword/value-arguments-error */
	dylanZdylan_visceraZodd_number_of_keywordSLASHvalue_arguments_error_FUN(orig_sp);
	not_reached();
    }
}


/* Define Sealed Domain make (singleton(<ucred>)) */


/* {Implicit} Define Generic get-pid */

/* get-pid is get-pid */


/* Define Method get-pid{<ucred>} */

/* get-pid{<ucred>} */
long networkZnetwork_internalZget_pid_METH(descriptor_t *orig_sp, void * A_ptr /* ptr */, heapptr_t A1)
{
    descriptor_t *cluster_0_top;


    /* #line 198 "./melange.dylan" */

    /* #line 91 "./rawptr.dylan" */
    return (*(long *)((char *)A_ptr + 0 ));
}


/* {Implicit} Define Generic get-pid-setter */

/* get-pid-setter is get-pid-setter */


/* Define Method get-pid-setter{<integer>, <ucred>} */

/* get-pid-setter{<integer>, <ucred>} */
long networkZnetwork_internalZget_pid_setter_METH(descriptor_t *orig_sp, long A_value /* value */, void * A_ptr /* ptr */, heapptr_t A2)
{
    descriptor_t *cluster_0_top;

    /* #line {Class <unknown-source-location>} */

    /* #line 97 "./rawptr.dylan" */
    *(long *)((char *)A_ptr + 0) = A_value;
    return A_value;
}


/* {Implicit} Define Generic get-uid */

/* get-uid is get-uid */


/* Define Method get-uid{<ucred>} */

/* get-uid{<ucred>} */
long networkZnetwork_internalZget_uid_METH(descriptor_t *orig_sp, void * A_ptr /* ptr */, heapptr_t A1)
{
    descriptor_t *cluster_0_top;

    /* #line {Class <unknown-source-location>} */

    /* #line 211 "./melange.dylan" */

    /* #line 91 "./rawptr.dylan" */
    return (*(long *)((char *)A_ptr + 4 ));
}


/* {Implicit} Define Generic get-uid-setter */

/* get-uid-setter is get-uid-setter */


/* Define Method get-uid-setter{<integer>, <ucred>} */

/* get-uid-setter{<integer>, <ucred>} */
long networkZnetwork_internalZget_uid_setter_METH(descriptor_t *orig_sp, long A_value /* value */, void * A_ptr /* ptr */, heapptr_t A2)
{
    descriptor_t *cluster_0_top;

    /* #line {Class <unknown-source-location>} */

    /* #line 97 "./rawptr.dylan" */
    *(long *)((char *)A_ptr + 4) = A_value;
    return A_value;
}


/* {Implicit} Define Generic get-gid */

/* get-gid is get-gid */


/* Define Method get-gid{<ucred>} */

/* get-gid{<ucred>} */
long networkZnetwork_internalZget_gid_METH(descriptor_t *orig_sp, void * A_ptr /* ptr */, heapptr_t A1)
{
    descriptor_t *cluster_0_top;

    /* #line {Class <unknown-source-location>} */

    /* #line 211 "./melange.dylan" */

    /* #line 91 "./rawptr.dylan" */
    return (*(long *)((char *)A_ptr + 8 ));
}


/* {Implicit} Define Generic get-gid-setter */

/* get-gid-setter is get-gid-setter */


/* Define Method get-gid-setter{<integer>, <ucred>} */

/* get-gid-setter{<integer>, <ucred>} */
long networkZnetwork_internalZget_gid_setter_METH(descriptor_t *orig_sp, long A_value /* value */, void * A_ptr /* ptr */, heapptr_t A2)
{
    descriptor_t *cluster_0_top;

    /* #line {Class <unknown-source-location>} */

    /* #line 97 "./rawptr.dylan" */
    *(long *)((char *)A_ptr + 8) = A_value;
    return A_value;
}


/* Define Method pointer-value{<ucred>} */

extern struct heapobj networkZstr_ROOT_24;

/* pointer-value{<ucred>} */
void * networkZnetwork_internalZpointer_value_METH_12(descriptor_t *orig_sp, void * A_value /* value */, heapptr_t A_next_method_info /* next-method-info */, heapptr_t A_rest /* rest */, descriptor_t A_index /* index */)
{
    descriptor_t *cluster_0_top;
    descriptor_t L_temp;
    descriptor_t L_arg1; /* arg1 */
    descriptor_t L_temp_2;
    descriptor_t L_temp_3; /* temp */
    descriptor_t L_temp_4;

    /* #line {Class <unknown-source-location>} */

    /* #line 758 "./sockets-api.dylan" */
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = 12;
    orig_sp[0] = A_index;
    orig_sp[1] = L_temp;
    /* * */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZV_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_arg1 = (orig_sp == cluster_0_top ? dylanZfalse : orig_sp[0]);

    /* #line 758 "./sockets-api.dylan" */
    L_temp_2.heapptr = networkZliteral_18.heapptr;
    L_temp_2.dataword.ptr = A_value;
    orig_sp[0] = L_temp_2;
    orig_sp[1] = L_arg1;
    /* + */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZPLUS_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_temp_3 = (orig_sp == cluster_0_top ? dylanZfalse : orig_sp[0]);

    /* #line 386 "./condition.dylan" */
    if ((&networkZnetwork_internalZCLS_ucred_HEAP == SLOT(L_temp_3.heapptr, heapptr_t, 0))) {

	/* #line 758 "./sockets-api.dylan" */
	return L_temp_3.dataword.ptr;
    }
    else {

	/* #line 389 "./condition.dylan" */
	L_temp_4.heapptr = &networkZstr_ROOT_24;
	L_temp_4.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp_3, &networkZnetwork_internalZCLS_ucred_HEAP, L_temp_4);
	not_reached();
    }
}

/* generic-entry for pointer-value{<ucred>} */
descriptor_t * networkZnetwork_internalZpointer_value_METH_GENERIC_12(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    descriptor_t L_arg; /* arg */
    heapptr_t L_rest; /* rest */
    void * L_arg_2; /* arg */
    descriptor_t L_index; /* index */
    long L_index_2; /* index */
    descriptor_t L_key; /* key */
    descriptor_t L_value; /* value */
    void * L_result0; /* result0 */
    descriptor_t L_temp;

    /* #line {Class <unknown-source-location>} */
    L_args = ((void *)(orig_sp - A_nargs));
    L_arg = (((descriptor_t *)L_args)[0]);
    L_rest = dylanZdylan_visceraZmake_rest_arg_FUN(orig_sp, (descriptor_t *)L_args + 1, A_nargs - 1);
    L_arg_2 = L_arg.dataword.ptr;
    L_index.heapptr = networkZliteral_2.heapptr;
    L_index.dataword.l = 0;
    L_index_2 = (A_nargs - 2);
    while (1) {
	if ((L_index_2 < 1)) {
	    goto block0;
	}
	else {
	    L_key = (((descriptor_t *)L_args)[L_index_2]);
	    L_value = (((descriptor_t *)L_args)[(L_index_2 + 1)]);
	    if ((L_key.heapptr == &SYM_index_HEAP)) {
		L_index = L_value;
	    }
	    L_index_2 = (L_index_2 - 2);
	}
    }
  block0:;
    orig_sp = L_args;
    /* pointer-value{<ucred>} */
    L_result0 = networkZnetwork_internalZpointer_value_METH_12(orig_sp, L_arg_2, A_next_method_info, L_rest, L_index);
    L_temp.heapptr = networkZliteral_18.heapptr;
    L_temp.dataword.ptr = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* Define Method content-size{subclass(<ucred>)} */

/* content-size{subclass(<ucred>)} */
long networkZnetwork_internalZcontent_size_METH_16(descriptor_t *orig_sp, heapptr_t A0, heapptr_t A1)
{

    return 12;
}

/* generic-entry for content-size{subclass(<ucred>)} */
descriptor_t * networkZnetwork_internalZcontent_size_METH_GENERIC_16(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    long L_result0; /* result0 */
    descriptor_t L_temp;

    orig_sp = ((void *)(orig_sp - 1));
    /* content-size{subclass(<ucred>)} */
    L_result0 = networkZnetwork_internalZcontent_size_METH_16(orig_sp, &networkZnetwork_internalZCLS_ucred_HEAP, A_next_method_info);
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* Define Class <linger> */

/* <linger> is <linger> */

extern struct heapobj networkZnetwork_internalZCLS_linger_HEAP;

/* maker for <linger> */
void * networkZnetwork_internalZCLS_linger_MAKER_FUN(descriptor_t *orig_sp, void * A_pointer /* pointer */, int A_pointer_suppliedQUERY /* pointer-supplied? */)
{
    descriptor_t *cluster_0_top;


    /* #line 765 "./sockets-api.dylan" */
    if (A_pointer_suppliedQUERY) {
	return A_pointer;
    }
    else {
	/* missing-required-init-keyword-error */
	dylanZdylan_visceraZmissing_required_init_keyword_error_FUN(orig_sp, &SYM_pointer_HEAP, &networkZnetwork_internalZCLS_linger_HEAP);
	not_reached();
    }
}

extern descriptor_t networkZliteral_19;	/* proxy for <linger> */

/* general-entry for maker for <linger> */
descriptor_t * networkZnetwork_internalZCLS_linger_MAKER_GENERAL(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    void * L_pointer; /* pointer */
    int L_pointer_suppliedQUERY; /* pointer-supplied? */
    long L_index; /* index */
    descriptor_t L_temp; /* temp */
    descriptor_t L_value; /* value */
    descriptor_t L_temp_2;
    descriptor_t L_temp_3;
    void * L_result0; /* result0 */
    descriptor_t L_temp_4;

    /* #line {Class <unknown-source-location>} */

    /* #line 126 "./cmp.dylan" */

    /* #line 209 "./num.dylan" */
    if (((A_nargs & 1) == 0)) {
	/* #line {Class <unknown-source-location>} */
	L_args = ((void *)(orig_sp - A_nargs));
	L_pointer = 0;
	L_pointer_suppliedQUERY = FALSE;
	L_index = (A_nargs - 2);
	while (1) {
	    if ((L_index < 0)) {
		goto block0;
	    }
	    else {
		L_temp = (((descriptor_t *)L_args)[L_index]);

		/* #line 386 "./condition.dylan" */
		if ((&dylanZdylan_visceraZCLS_symbol_HEAP == SLOT(L_temp.heapptr, heapptr_t, 0))) {
		    /* #line {Class <unknown-source-location>} */
		    L_value = (((descriptor_t *)L_args)[(L_index + 1)]);
		    if ((L_temp.heapptr == &SYM_pointer_HEAP)) {

			/* #line 386 "./condition.dylan" */
			if ((&dylanZdylan_visceraZCLS_raw_pointer_HEAP == SLOT(L_value.heapptr, heapptr_t, 0))) {
			    /* #line {Class <unknown-source-location>} */
			    L_pointer = L_value.dataword.ptr;
			    L_pointer_suppliedQUERY = TRUE;
			}
			else {

			    /* #line 389 "./condition.dylan" */
			    L_temp_2.heapptr = &networkZstr_ROOT;
			    L_temp_2.dataword.l = 0;
			    /* type-error-with-location */
			    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_value, &dylanZdylan_visceraZCLS_raw_pointer_HEAP, L_temp_2);
			    not_reached();
			}
		    }
		    /* #line {Class <unknown-source-location>} */
		    L_index = (L_index - 2);
		}
		else {

		    /* #line 389 "./condition.dylan" */
		    L_temp_3.heapptr = &networkZstr_ROOT;
		    L_temp_3.dataword.l = 0;
		    /* type-error-with-location */
		    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp, &dylanZdylan_visceraZCLS_symbol_HEAP, L_temp_3);
		    not_reached();
		}
	    }
	}
      block0:;
	/* #line {Class <unknown-source-location>} */
	orig_sp = L_args;
	/* maker for <linger> */
	L_result0 = networkZnetwork_internalZCLS_linger_MAKER_FUN(orig_sp, L_pointer, L_pointer_suppliedQUERY);
	L_temp_4.heapptr = networkZliteral_19.heapptr;
	L_temp_4.dataword.ptr = L_result0;
	orig_sp[0] = L_temp_4;
	return orig_sp + 1;
    }
    else {
	/* odd-number-of-keyword/value-arguments-error */
	dylanZdylan_visceraZodd_number_of_keywordSLASHvalue_arguments_error_FUN(orig_sp);
	not_reached();
    }
}


/* Define Sealed Domain make (singleton(<linger>)) */


/* {Implicit} Define Generic get-l-onoff */

/* get-l-onoff is get-l-onoff */


/* Define Method get-l-onoff{<linger>} */

/* get-l-onoff{<linger>} */
long networkZnetwork_internalZget_l_onoff_METH(descriptor_t *orig_sp, void * A_ptr /* ptr */, heapptr_t A1)
{
    descriptor_t *cluster_0_top;


    /* #line 198 "./melange.dylan" */

    /* #line 91 "./rawptr.dylan" */
    return (*(long *)((char *)A_ptr + 0 ));
}


/* {Implicit} Define Generic get-l-onoff-setter */

/* get-l-onoff-setter is get-l-onoff-setter */


/* Define Method get-l-onoff-setter{<integer>, <linger>} */

/* get-l-onoff-setter{<integer>, <linger>} */
long networkZnetwork_internalZget_l_onoff_setter_METH(descriptor_t *orig_sp, long A_value /* value */, void * A_ptr /* ptr */, heapptr_t A2)
{
    descriptor_t *cluster_0_top;

    /* #line {Class <unknown-source-location>} */

    /* #line 97 "./rawptr.dylan" */
    *(long *)((char *)A_ptr + 0) = A_value;
    return A_value;
}


/* {Implicit} Define Generic get-l-linger */

/* get-l-linger is get-l-linger */


/* Define Method get-l-linger{<linger>} */

/* get-l-linger{<linger>} */
long networkZnetwork_internalZget_l_linger_METH(descriptor_t *orig_sp, void * A_ptr /* ptr */, heapptr_t A1)
{
    descriptor_t *cluster_0_top;

    /* #line {Class <unknown-source-location>} */

    /* #line 198 "./melange.dylan" */

    /* #line 91 "./rawptr.dylan" */
    return (*(long *)((char *)A_ptr + 4 ));
}


/* {Implicit} Define Generic get-l-linger-setter */

/* get-l-linger-setter is get-l-linger-setter */


/* Define Method get-l-linger-setter{<integer>, <linger>} */

/* get-l-linger-setter{<integer>, <linger>} */
long networkZnetwork_internalZget_l_linger_setter_METH(descriptor_t *orig_sp, long A_value /* value */, void * A_ptr /* ptr */, heapptr_t A2)
{
    descriptor_t *cluster_0_top;

    /* #line {Class <unknown-source-location>} */

    /* #line 97 "./rawptr.dylan" */
    *(long *)((char *)A_ptr + 4) = A_value;
    return A_value;
}


/* Define Method pointer-value{<linger>} */

extern struct heapobj networkZstr_ROOT_25;

/* pointer-value{<linger>} */
void * networkZnetwork_internalZpointer_value_METH_13(descriptor_t *orig_sp, void * A_value /* value */, heapptr_t A_next_method_info /* next-method-info */, heapptr_t A_rest /* rest */, descriptor_t A_index /* index */)
{
    descriptor_t *cluster_0_top;
    descriptor_t L_temp;
    descriptor_t L_arg1; /* arg1 */
    descriptor_t L_temp_2;
    descriptor_t L_temp_3; /* temp */
    descriptor_t L_temp_4;

    /* #line {Class <unknown-source-location>} */

    /* #line 792 "./sockets-api.dylan" */
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = 8;
    orig_sp[0] = A_index;
    orig_sp[1] = L_temp;
    /* * */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZV_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_arg1 = (orig_sp == cluster_0_top ? dylanZfalse : orig_sp[0]);

    /* #line 792 "./sockets-api.dylan" */
    L_temp_2.heapptr = networkZliteral_19.heapptr;
    L_temp_2.dataword.ptr = A_value;
    orig_sp[0] = L_temp_2;
    orig_sp[1] = L_arg1;
    /* + */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZPLUS_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_temp_3 = (orig_sp == cluster_0_top ? dylanZfalse : orig_sp[0]);

    /* #line 386 "./condition.dylan" */
    if ((&networkZnetwork_internalZCLS_linger_HEAP == SLOT(L_temp_3.heapptr, heapptr_t, 0))) {

	/* #line 792 "./sockets-api.dylan" */
	return L_temp_3.dataword.ptr;
    }
    else {

	/* #line 389 "./condition.dylan" */
	L_temp_4.heapptr = &networkZstr_ROOT_25;
	L_temp_4.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp_3, &networkZnetwork_internalZCLS_linger_HEAP, L_temp_4);
	not_reached();
    }
}

/* generic-entry for pointer-value{<linger>} */
descriptor_t * networkZnetwork_internalZpointer_value_METH_GENERIC_13(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    descriptor_t L_arg; /* arg */
    heapptr_t L_rest; /* rest */
    void * L_arg_2; /* arg */
    descriptor_t L_index; /* index */
    long L_index_2; /* index */
    descriptor_t L_key; /* key */
    descriptor_t L_value; /* value */
    void * L_result0; /* result0 */
    descriptor_t L_temp;

    /* #line {Class <unknown-source-location>} */
    L_args = ((void *)(orig_sp - A_nargs));
    L_arg = (((descriptor_t *)L_args)[0]);
    L_rest = dylanZdylan_visceraZmake_rest_arg_FUN(orig_sp, (descriptor_t *)L_args + 1, A_nargs - 1);
    L_arg_2 = L_arg.dataword.ptr;
    L_index.heapptr = networkZliteral_2.heapptr;
    L_index.dataword.l = 0;
    L_index_2 = (A_nargs - 2);
    while (1) {
	if ((L_index_2 < 1)) {
	    goto block0;
	}
	else {
	    L_key = (((descriptor_t *)L_args)[L_index_2]);
	    L_value = (((descriptor_t *)L_args)[(L_index_2 + 1)]);
	    if ((L_key.heapptr == &SYM_index_HEAP)) {
		L_index = L_value;
	    }
	    L_index_2 = (L_index_2 - 2);
	}
    }
  block0:;
    orig_sp = L_args;
    /* pointer-value{<linger>} */
    L_result0 = networkZnetwork_internalZpointer_value_METH_13(orig_sp, L_arg_2, A_next_method_info, L_rest, L_index);
    L_temp.heapptr = networkZliteral_19.heapptr;
    L_temp.dataword.ptr = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* Define Method content-size{subclass(<linger>)} */

/* content-size{subclass(<linger>)} */
long networkZnetwork_internalZcontent_size_METH_17(descriptor_t *orig_sp, heapptr_t A0, heapptr_t A1)
{

    return 8;
}

/* generic-entry for content-size{subclass(<linger>)} */
descriptor_t * networkZnetwork_internalZcontent_size_METH_GENERIC_17(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    long L_result0; /* result0 */
    descriptor_t L_temp;

    orig_sp = ((void *)(orig_sp - 1));
    /* content-size{subclass(<linger>)} */
    L_result0 = networkZnetwork_internalZcontent_size_METH_17(orig_sp, &networkZnetwork_internalZCLS_linger_HEAP, A_next_method_info);
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* Define Constant $PF-UNSPEC */

/* $PF-UNSPEC is 0 */


/* Define Constant $PF-LOCAL */

/* $PF-LOCAL is 1 */


/* Define Constant $PF-UNIX */

/* $PF-UNIX is 1 */


/* Define Constant $PF-FILE */

/* $PF-FILE is 1 */


/* Define Constant $PF-INET */

/* $PF-INET is 2 */


/* Define Constant $PF-AX25 */

/* $PF-AX25 is 3 */


/* Define Constant $PF-IPX */

/* $PF-IPX is 4 */


/* Define Constant $PF-APPLETALK */

/* $PF-APPLETALK is 5 */


/* Define Constant $PF-NETROM */

/* $PF-NETROM is 6 */


/* Define Constant $PF-BRIDGE */

/* $PF-BRIDGE is 7 */


/* Define Constant $PF-ATMPVC */

/* $PF-ATMPVC is 8 */


/* Define Constant $PF-X25 */

/* $PF-X25 is 9 */


/* Define Constant $PF-INET6 */

/* $PF-INET6 is 10 */


/* Define Constant $PF-ROSE */

/* $PF-ROSE is 11 */


/* Define Constant $PF-DE-Cnet */

/* $PF-DE-Cnet is 12 */


/* Define Constant $PF-NETBEUI */

/* $PF-NETBEUI is 13 */


/* Define Constant $PF-SECURITY */

/* $PF-SECURITY is 14 */


/* Define Constant $PF-KEY */

/* $PF-KEY is 15 */


/* Define Constant $PF-NETLINK */

/* $PF-NETLINK is 16 */


/* Define Constant $PF-ROUTE */

/* $PF-ROUTE is 16 */


/* Define Constant $PF-PACKET */

/* $PF-PACKET is 17 */


/* Define Constant $PF-ASH */

/* $PF-ASH is 18 */


/* Define Constant $PF-ECONET */

/* $PF-ECONET is 19 */


/* Define Constant $PF-ATMSVC */

/* $PF-ATMSVC is 20 */


/* Define Constant $PF-SNA */

/* $PF-SNA is 22 */


/* Define Constant $PF-IRDA */

/* $PF-IRDA is 23 */


/* Define Constant $PF-PPPOX */

/* $PF-PPPOX is 24 */


/* Define Constant $PF-WANPIPE */

/* $PF-WANPIPE is 25 */


/* Define Constant $PF-BLUETOOTH */

/* $PF-BLUETOOTH is 31 */


/* Define Constant $PF-MAX */

/* $PF-MAX is 32 */


/* Define Constant $AF-UNSPEC */

/* $AF-UNSPEC is 0 */


/* Define Constant $AF-LOCAL */

/* $AF-LOCAL is 1 */


/* Define Constant $AF-UNIX */

/* $AF-UNIX is 1 */


/* Define Constant $AF-FILE */

/* $AF-FILE is 1 */


/* Define Constant $AF-INET */

/* $AF-INET is 2 */


/* Define Constant $AF-AX25 */

/* $AF-AX25 is 3 */


/* Define Constant $AF-IPX */

/* $AF-IPX is 4 */


/* Define Constant $AF-APPLETALK */

/* $AF-APPLETALK is 5 */


/* Define Constant $AF-NETROM */

/* $AF-NETROM is 6 */


/* Define Constant $AF-BRIDGE */

/* $AF-BRIDGE is 7 */


/* Define Constant $AF-ATMPVC */

/* $AF-ATMPVC is 8 */


/* Define Constant $AF-X25 */

/* $AF-X25 is 9 */


/* Define Constant $AF-INET6 */

/* $AF-INET6 is 10 */


/* Define Constant $AF-ROSE */

/* $AF-ROSE is 11 */


/* Define Constant $AF-DE-Cnet */

/* $AF-DE-Cnet is 12 */


/* Define Constant $AF-NETBEUI */

/* $AF-NETBEUI is 13 */


/* Define Constant $AF-SECURITY */

/* $AF-SECURITY is 14 */


/* Define Constant $AF-KEY */

/* $AF-KEY is 15 */


/* Define Constant $AF-NETLINK */

/* $AF-NETLINK is 16 */


/* Define Constant $AF-ROUTE */

/* $AF-ROUTE is 16 */


/* Define Constant $AF-PACKET */

/* $AF-PACKET is 17 */


/* Define Constant $AF-ASH */

/* $AF-ASH is 18 */


/* Define Constant $AF-ECONET */

/* $AF-ECONET is 19 */


/* Define Constant $AF-ATMSVC */

/* $AF-ATMSVC is 20 */


/* Define Constant $AF-SNA */

/* $AF-SNA is 22 */


/* Define Constant $AF-IRDA */

/* $AF-IRDA is 23 */


/* Define Constant $AF-PPPOX */

/* $AF-PPPOX is 24 */


/* Define Constant $AF-WANPIPE */

/* $AF-WANPIPE is 25 */


/* Define Constant $AF-BLUETOOTH */

/* $AF-BLUETOOTH is 31 */


/* Define Constant $AF-MAX */

/* $AF-MAX is 32 */


/* Define Constant $SOL-RAW */

/* $SOL-RAW is 255 */


/* Define Constant $SOL-DECNET */

/* $SOL-DECNET is 261 */


/* Define Constant $SOL-X25 */

/* $SOL-X25 is 262 */


/* Define Constant $SOL-PACKET */

/* $SOL-PACKET is 263 */


/* Define Constant $SOL-ATM */

/* $SOL-ATM is 264 */


/* Define Constant $SOL-AAL */

/* $SOL-AAL is 265 */


/* Define Constant $SOL-IRDA */

/* $SOL-IRDA is 266 */


/* Define Constant $SOMAXCONN */

/* $SOMAXCONN is 128 */


/* Define Constant <__ss-aligntype> */

/* <__ss-aligntype> is <integer> */


/* Define Constant $_SS-SIZE */

/* $_SS-SIZE is 128 */


/* Define Constant $_SS-PADSIZE */

/* $_SS-PADSIZE is 120 */


/* Define Constant $SOL-SOCKET */

/* $SOL-SOCKET is 1 */


/* Define Constant $SO-DEBUG */

/* $SO-DEBUG is 1 */


/* Define Constant $SO-REUSEADDR */

/* $SO-REUSEADDR is 2 */


/* Define Constant $SO-TYPE */

/* $SO-TYPE is 3 */


/* Define Constant $SO-ERROR */

/* $SO-ERROR is 4 */


/* Define Constant $SO-DONTROUTE */

/* $SO-DONTROUTE is 5 */


/* Define Constant $SO-BROADCAST */

/* $SO-BROADCAST is 6 */


/* Define Constant $SO-SNDBUF */

/* $SO-SNDBUF is 7 */


/* Define Constant $SO-RCVBUF */

/* $SO-RCVBUF is 8 */


/* Define Constant $SO-KEEPALIVE */

/* $SO-KEEPALIVE is 9 */


/* Define Constant $SO-OOBINLINE */

/* $SO-OOBINLINE is 10 */


/* Define Constant $SO-NO-CHECK */

/* $SO-NO-CHECK is 11 */


/* Define Constant $SO-PRIORITY */

/* $SO-PRIORITY is 12 */


/* Define Constant $SO-LINGER */

/* $SO-LINGER is 13 */


/* Define Constant $SO-BSDCOMPAT */

/* $SO-BSDCOMPAT is 14 */


/* Define Constant $SO-PASSCRED */

/* $SO-PASSCRED is 16 */


/* Define Constant $SO-PEERCRED */

/* $SO-PEERCRED is 17 */


/* Define Constant $SO-RCVLOWAT */

/* $SO-RCVLOWAT is 18 */


/* Define Constant $SO-SNDLOWAT */

/* $SO-SNDLOWAT is 19 */


/* Define Constant $SO-RCVTIMEO */

/* $SO-RCVTIMEO is 20 */


/* Define Constant $SO-SNDTIMEO */

/* $SO-SNDTIMEO is 21 */


/* Define Constant $SO-SECURITY-AUTHENTICATION */

/* $SO-SECURITY-AUTHENTICATION is 22 */


/* Define Constant $SO-SECURITY-ENCRYPTION-TRANSPORT */

/* $SO-SECURITY-ENCRYPTION-TRANSPORT is 23 */


/* Define Constant $SO-SECURITY-ENCRYPTION-NETWORK */

/* $SO-SECURITY-ENCRYPTION-NETWORK is 24 */


/* Define Constant $SO-BINDTODEVICE */

/* $SO-BINDTODEVICE is 25 */


/* Define Constant $SO-ATTACH-FILTER */

/* $SO-ATTACH-FILTER is 26 */


/* Define Constant $SO-DETACH-FILTER */

/* $SO-DETACH-FILTER is 27 */


/* Define Constant $SO-PEERNAME */

/* $SO-PEERNAME is 28 */


/* Define Constant $SO-TIMESTAMP */

/* $SO-TIMESTAMP is 29 */


/* Define Constant $SCM-TIMESTAMP */

/* $SCM-TIMESTAMP is 29 */


/* Define Constant $SO-ACCEPTCONN */

/* $SO-ACCEPTCONN is 30 */


/* Define Constant $FIOSETOWN */

/* $FIOSETOWN is 35073 */


/* Define Constant $SIOCSPGRP */

/* $SIOCSPGRP is 35074 */


/* Define Constant $FIOGETOWN */

/* $FIOGETOWN is 35075 */


/* Define Constant $SIOCGPGRP */

/* $SIOCGPGRP is 35076 */


/* Define Constant $SIOCATMARK */

/* $SIOCATMARK is 35077 */


/* Define Constant $SIOCGSTAMP */

/* $SIOCGSTAMP is 35078 */


/* Define Constant $_BITS-SOCKADDR-H */

/* $_BITS-SOCKADDR-H is 1 */


/* Define Constant $__SOCKADDR-COMMON-SIZE */

/* $__SOCKADDR-COMMON-SIZE is 2 */


/* Define Constant <__u-char> */

/* <__u-char> is <integer> */


/* Define Constant <u-char> */

/* <u-char> is <integer> */


/* Define Constant <__u-short> */

/* <__u-short> is <integer> */


/* Define Constant <u-short> */

/* <u-short> is <integer> */


/* Define Constant <__u-int> */

/* <__u-int> is <integer> */


/* Define Constant <u-int> */

/* <u-int> is <integer> */


/* Define Constant <__u-long> */

/* <__u-long> is <integer> */


/* Define Constant <u-long> */

/* <u-long> is <integer> */


/* Define Class <long*> */

/* <long*> is <long*> */

extern struct heapobj networkZnetwork_internalZCLS_longV_HEAP;

/* maker for <long*> */
void * networkZnetwork_internalZCLS_longV_MAKER_FUN(descriptor_t *orig_sp, void * A_pointer /* pointer */, int A_pointer_suppliedQUERY /* pointer-supplied? */)
{
    descriptor_t *cluster_0_top;


    /* #line 1035 "./sockets-api.dylan" */
    if (A_pointer_suppliedQUERY) {
	return A_pointer;
    }
    else {
	/* missing-required-init-keyword-error */
	dylanZdylan_visceraZmissing_required_init_keyword_error_FUN(orig_sp, &SYM_pointer_HEAP, &networkZnetwork_internalZCLS_longV_HEAP);
	not_reached();
    }
}

extern descriptor_t networkZliteral_20;	/* proxy for <long*> */

/* general-entry for maker for <long*> */
descriptor_t * networkZnetwork_internalZCLS_longV_MAKER_GENERAL(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    void * L_pointer; /* pointer */
    int L_pointer_suppliedQUERY; /* pointer-supplied? */
    long L_index; /* index */
    descriptor_t L_temp; /* temp */
    descriptor_t L_value; /* value */
    descriptor_t L_temp_2;
    descriptor_t L_temp_3;
    void * L_result0; /* result0 */
    descriptor_t L_temp_4;

    /* #line {Class <unknown-source-location>} */

    /* #line 126 "./cmp.dylan" */

    /* #line 209 "./num.dylan" */
    if (((A_nargs & 1) == 0)) {
	/* #line {Class <unknown-source-location>} */
	L_args = ((void *)(orig_sp - A_nargs));
	L_pointer = 0;
	L_pointer_suppliedQUERY = FALSE;
	L_index = (A_nargs - 2);
	while (1) {
	    if ((L_index < 0)) {
		goto block0;
	    }
	    else {
		L_temp = (((descriptor_t *)L_args)[L_index]);

		/* #line 386 "./condition.dylan" */
		if ((&dylanZdylan_visceraZCLS_symbol_HEAP == SLOT(L_temp.heapptr, heapptr_t, 0))) {
		    /* #line {Class <unknown-source-location>} */
		    L_value = (((descriptor_t *)L_args)[(L_index + 1)]);
		    if ((L_temp.heapptr == &SYM_pointer_HEAP)) {

			/* #line 386 "./condition.dylan" */
			if ((&dylanZdylan_visceraZCLS_raw_pointer_HEAP == SLOT(L_value.heapptr, heapptr_t, 0))) {
			    /* #line {Class <unknown-source-location>} */
			    L_pointer = L_value.dataword.ptr;
			    L_pointer_suppliedQUERY = TRUE;
			}
			else {

			    /* #line 389 "./condition.dylan" */
			    L_temp_2.heapptr = &networkZstr_ROOT;
			    L_temp_2.dataword.l = 0;
			    /* type-error-with-location */
			    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_value, &dylanZdylan_visceraZCLS_raw_pointer_HEAP, L_temp_2);
			    not_reached();
			}
		    }
		    /* #line {Class <unknown-source-location>} */
		    L_index = (L_index - 2);
		}
		else {

		    /* #line 389 "./condition.dylan" */
		    L_temp_3.heapptr = &networkZstr_ROOT;
		    L_temp_3.dataword.l = 0;
		    /* type-error-with-location */
		    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp, &dylanZdylan_visceraZCLS_symbol_HEAP, L_temp_3);
		    not_reached();
		}
	    }
	}
      block0:;
	/* #line {Class <unknown-source-location>} */
	orig_sp = L_args;
	/* maker for <long*> */
	L_result0 = networkZnetwork_internalZCLS_longV_MAKER_FUN(orig_sp, L_pointer, L_pointer_suppliedQUERY);
	L_temp_4.heapptr = networkZliteral_20.heapptr;
	L_temp_4.dataword.ptr = L_result0;
	orig_sp[0] = L_temp_4;
	return orig_sp + 1;
    }
    else {
	/* odd-number-of-keyword/value-arguments-error */
	dylanZdylan_visceraZodd_number_of_keywordSLASHvalue_arguments_error_FUN(orig_sp);
	not_reached();
    }
}


/* Define Sealed Domain make (singleton(<long*>)) */


/* Define Method pointer-value{<long*>} */

extern struct heapobj networkZstr_ROOT_26;

/* pointer-value{<long*>} */
long networkZnetwork_internalZpointer_value_METH_14(descriptor_t *orig_sp, descriptor_t A_ptr /* ptr */, heapptr_t A_next_method_info /* next-method-info */, heapptr_t A_rest /* rest */, descriptor_t A_index /* index */)
{
    descriptor_t *cluster_0_top;
    descriptor_t L_temp;
    descriptor_t L_arg2; /* arg2 */
    descriptor_t L_temp_2;


    /* #line 1042 "./sockets-api.dylan" */
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = 4;
    orig_sp[0] = A_index;
    orig_sp[1] = L_temp;
    /* * */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZV_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_arg2 = (orig_sp == cluster_0_top ? dylanZfalse : orig_sp[0]);

    /* #line 386 "./condition.dylan" */
    if ((&dylanZdylan_visceraZCLS_integer_HEAP == SLOT(L_arg2.heapptr, heapptr_t, 0))) {

	/* #line 1042 "./sockets-api.dylan" */

	/* #line 198 "./melange.dylan" */

	/* #line 91 "./rawptr.dylan" */
	return (*(long *)((char *)A_ptr.dataword.ptr + L_arg2.dataword.l ));
    }
    else {

	/* #line 389 "./condition.dylan" */
	L_temp_2.heapptr = &networkZstr_ROOT_26;
	L_temp_2.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_arg2, &dylanZdylan_visceraZCLS_integer_HEAP, L_temp_2);
	not_reached();
    }
}

/* generic-entry for pointer-value{<long*>} */
descriptor_t * networkZnetwork_internalZpointer_value_METH_GENERIC_14(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    descriptor_t L_arg; /* arg */
    heapptr_t L_rest; /* rest */
    descriptor_t L_arg_2; /* arg */
    descriptor_t L_index; /* index */
    long L_index_2; /* index */
    descriptor_t L_key; /* key */
    descriptor_t L_value; /* value */
    long L_result0; /* result0 */
    descriptor_t L_temp;

    /* #line {Class <unknown-source-location>} */
    L_args = ((void *)(orig_sp - A_nargs));
    L_arg = (((descriptor_t *)L_args)[0]);
    L_rest = dylanZdylan_visceraZmake_rest_arg_FUN(orig_sp, (descriptor_t *)L_args + 1, A_nargs - 1);
    L_arg_2 = L_arg;
    L_index.heapptr = networkZliteral_2.heapptr;
    L_index.dataword.l = 0;
    L_index_2 = (A_nargs - 2);
    while (1) {
	if ((L_index_2 < 1)) {
	    goto block0;
	}
	else {
	    L_key = (((descriptor_t *)L_args)[L_index_2]);
	    L_value = (((descriptor_t *)L_args)[(L_index_2 + 1)]);
	    if ((L_key.heapptr == &SYM_index_HEAP)) {
		L_index = L_value;
	    }
	    L_index_2 = (L_index_2 - 2);
	}
    }
  block0:;
    orig_sp = L_args;
    /* pointer-value{<long*>} */
    L_result0 = networkZnetwork_internalZpointer_value_METH_14(orig_sp, L_arg_2, A_next_method_info, L_rest, L_index);
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* Define Method pointer-value-setter{<integer>, <long*>} */

/* pointer-value-setter{<integer>, <long*>} */
long networkZnetwork_internalZpointer_value_setter_METH_5(descriptor_t *orig_sp, long A_value /* value */, descriptor_t A_ptr /* ptr */, heapptr_t A_next_method_info /* next-method-info */, heapptr_t A_rest /* rest */, descriptor_t A_index /* index */)
{
    descriptor_t *cluster_0_top;
    descriptor_t L_temp;
    descriptor_t L_arg3; /* arg3 */
    descriptor_t L_temp_2;


    /* #line 1048 "./sockets-api.dylan" */
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = 4;
    orig_sp[0] = A_index;
    orig_sp[1] = L_temp;
    /* * */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZV_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_arg3 = (orig_sp == cluster_0_top ? dylanZfalse : orig_sp[0]);

    /* #line 386 "./condition.dylan" */
    if ((&dylanZdylan_visceraZCLS_integer_HEAP == SLOT(L_arg3.heapptr, heapptr_t, 0))) {
	/* #line {Class <unknown-source-location>} */

	/* #line 97 "./rawptr.dylan" */
	*(long *)((char *)A_ptr.dataword.ptr + L_arg3.dataword.l) = A_value;
	return A_value;
    }
    else {

	/* #line 389 "./condition.dylan" */
	L_temp_2.heapptr = &networkZstr_ROOT;
	L_temp_2.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_arg3, &dylanZdylan_visceraZCLS_integer_HEAP, L_temp_2);
	not_reached();
    }
}

/* generic-entry for pointer-value-setter{<integer>, <long*>} */
descriptor_t * networkZnetwork_internalZpointer_value_setter_METH_GENERIC_5(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    descriptor_t L_arg; /* arg */
    descriptor_t L_arg_2; /* arg */
    heapptr_t L_rest; /* rest */
    long L_arg_3; /* arg */
    descriptor_t L_arg_4; /* arg */
    descriptor_t L_index; /* index */
    long L_index_2; /* index */
    descriptor_t L_key; /* key */
    descriptor_t L_value; /* value */
    long L_result0; /* result0 */
    descriptor_t L_temp;

    /* #line {Class <unknown-source-location>} */
    L_args = ((void *)(orig_sp - A_nargs));
    L_arg = (((descriptor_t *)L_args)[0]);
    L_arg_2 = (((descriptor_t *)L_args)[1]);
    L_rest = dylanZdylan_visceraZmake_rest_arg_FUN(orig_sp, (descriptor_t *)L_args + 2, A_nargs - 2);
    L_arg_3 = L_arg.dataword.l;
    L_arg_4 = L_arg_2;
    L_index.heapptr = networkZliteral_2.heapptr;
    L_index.dataword.l = 0;
    L_index_2 = (A_nargs - 2);
    while (1) {
	if ((L_index_2 < 2)) {
	    goto block0;
	}
	else {
	    L_key = (((descriptor_t *)L_args)[L_index_2]);
	    L_value = (((descriptor_t *)L_args)[(L_index_2 + 1)]);
	    if ((L_key.heapptr == &SYM_index_HEAP)) {
		L_index = L_value;
	    }
	    L_index_2 = (L_index_2 - 2);
	}
    }
  block0:;
    orig_sp = L_args;
    /* pointer-value-setter{<integer>, <long*>} */
    L_result0 = networkZnetwork_internalZpointer_value_setter_METH_5(orig_sp, L_arg_3, L_arg_4, A_next_method_info, L_rest, L_index);
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* Define Method content-size{subclass(<long*>)} */

/* content-size{subclass(<long*>)} */
long networkZnetwork_internalZcontent_size_METH_18(descriptor_t *orig_sp, heapptr_t A0, heapptr_t A1)
{

    return 4;
}

/* generic-entry for content-size{subclass(<long*>)} */
descriptor_t * networkZnetwork_internalZcontent_size_METH_GENERIC_18(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    descriptor_t L_arg; /* arg */
    heapptr_t L_arg_2; /* arg */
    long L_result0; /* result0 */
    descriptor_t L_temp;

    L_args = ((void *)(orig_sp - 1));
    L_arg = (((descriptor_t *)L_args)[0]);
    L_arg_2 = L_arg.heapptr;
    orig_sp = L_args;
    /* content-size{subclass(<long*>)} */
    L_result0 = networkZnetwork_internalZcontent_size_METH_18(orig_sp, L_arg_2, A_next_method_info);
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* Define Class <long<@2>> */

/* <long<@2>> is <long<@2>> */

extern struct heapobj networkZnetwork_internalZCLS_longLESSX402GREATER_HEAP;

/* maker for <long<@2>> */
void * networkZnetwork_internalZCLS_longLESSX402GREATER_MAKER_FUN(descriptor_t *orig_sp, void * A_pointer /* pointer */, int A_pointer_suppliedQUERY /* pointer-supplied? */)
{
    descriptor_t *cluster_0_top;


    /* #line 1056 "./sockets-api.dylan" */
    if (A_pointer_suppliedQUERY) {
	return A_pointer;
    }
    else {
	/* missing-required-init-keyword-error */
	dylanZdylan_visceraZmissing_required_init_keyword_error_FUN(orig_sp, &SYM_pointer_HEAP, &networkZnetwork_internalZCLS_longLESSX402GREATER_HEAP);
	not_reached();
    }
}

extern descriptor_t networkZliteral_21;	/* proxy for <long<@2>> */

/* general-entry for maker for <long<@2>> */
descriptor_t * networkZnetwork_internalZCLS_longLESSX402GREATER_MAKER_GENERAL(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    void * L_pointer; /* pointer */
    int L_pointer_suppliedQUERY; /* pointer-supplied? */
    long L_index; /* index */
    descriptor_t L_temp; /* temp */
    descriptor_t L_value; /* value */
    descriptor_t L_temp_2;
    descriptor_t L_temp_3;
    void * L_result0; /* result0 */
    descriptor_t L_temp_4;

    /* #line {Class <unknown-source-location>} */

    /* #line 126 "./cmp.dylan" */

    /* #line 209 "./num.dylan" */
    if (((A_nargs & 1) == 0)) {
	/* #line {Class <unknown-source-location>} */
	L_args = ((void *)(orig_sp - A_nargs));
	L_pointer = 0;
	L_pointer_suppliedQUERY = FALSE;
	L_index = (A_nargs - 2);
	while (1) {
	    if ((L_index < 0)) {
		goto block0;
	    }
	    else {
		L_temp = (((descriptor_t *)L_args)[L_index]);

		/* #line 386 "./condition.dylan" */
		if ((&dylanZdylan_visceraZCLS_symbol_HEAP == SLOT(L_temp.heapptr, heapptr_t, 0))) {
		    /* #line {Class <unknown-source-location>} */
		    L_value = (((descriptor_t *)L_args)[(L_index + 1)]);
		    if ((L_temp.heapptr == &SYM_pointer_HEAP)) {

			/* #line 386 "./condition.dylan" */
			if ((&dylanZdylan_visceraZCLS_raw_pointer_HEAP == SLOT(L_value.heapptr, heapptr_t, 0))) {
			    /* #line {Class <unknown-source-location>} */
			    L_pointer = L_value.dataword.ptr;
			    L_pointer_suppliedQUERY = TRUE;
			}
			else {

			    /* #line 389 "./condition.dylan" */
			    L_temp_2.heapptr = &networkZstr_ROOT;
			    L_temp_2.dataword.l = 0;
			    /* type-error-with-location */
			    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_value, &dylanZdylan_visceraZCLS_raw_pointer_HEAP, L_temp_2);
			    not_reached();
			}
		    }
		    /* #line {Class <unknown-source-location>} */
		    L_index = (L_index - 2);
		}
		else {

		    /* #line 389 "./condition.dylan" */
		    L_temp_3.heapptr = &networkZstr_ROOT;
		    L_temp_3.dataword.l = 0;
		    /* type-error-with-location */
		    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp, &dylanZdylan_visceraZCLS_symbol_HEAP, L_temp_3);
		    not_reached();
		}
	    }
	}
      block0:;
	/* #line {Class <unknown-source-location>} */
	orig_sp = L_args;
	/* maker for <long<@2>> */
	L_result0 = networkZnetwork_internalZCLS_longLESSX402GREATER_MAKER_FUN(orig_sp, L_pointer, L_pointer_suppliedQUERY);
	L_temp_4.heapptr = networkZliteral_21.heapptr;
	L_temp_4.dataword.ptr = L_result0;
	orig_sp[0] = L_temp_4;
	return orig_sp + 1;
    }
    else {
	/* odd-number-of-keyword/value-arguments-error */
	dylanZdylan_visceraZodd_number_of_keywordSLASHvalue_arguments_error_FUN(orig_sp);
	not_reached();
    }
}


/* Define Sealed Domain make (singleton(<long<@2>>)) */


/* Define Method content-size{singleton(<long<@2>>)} */

/* content-size{singleton(<long<@2>>)} */
long networkZnetwork_internalZcontent_size_METH_19(descriptor_t *orig_sp, heapptr_t A0, heapptr_t A1)
{

    return 2;
}

/* generic-entry for content-size{singleton(<long<@2>>)} */
descriptor_t * networkZnetwork_internalZcontent_size_METH_GENERIC_19(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    long L_result0; /* result0 */
    descriptor_t L_temp;

    orig_sp = ((void *)(orig_sp - 1));
    /* content-size{singleton(<long<@2>>)} */
    L_result0 = networkZnetwork_internalZcontent_size_METH_19(orig_sp, &networkZnetwork_internalZCLS_longLESSX402GREATER_HEAP, A_next_method_info);
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* Define Class <__quad-t> */

/* <__quad-t> is <__quad-t> */

extern struct heapobj networkZnetwork_internalZCLS_X_X_quad_t_HEAP;

/* maker for <__quad-t> */
void * networkZnetwork_internalZCLS_X_X_quad_t_MAKER_FUN(descriptor_t *orig_sp, void * A_pointer /* pointer */, int A_pointer_suppliedQUERY /* pointer-supplied? */)
{
    descriptor_t *cluster_0_top;


    /* #line 1064 "./sockets-api.dylan" */
    if (A_pointer_suppliedQUERY) {
	return A_pointer;
    }
    else {
	/* missing-required-init-keyword-error */
	dylanZdylan_visceraZmissing_required_init_keyword_error_FUN(orig_sp, &SYM_pointer_HEAP, &networkZnetwork_internalZCLS_X_X_quad_t_HEAP);
	not_reached();
    }
}

extern descriptor_t networkZliteral_22;	/* proxy for <__quad-t> */

/* general-entry for maker for <__quad-t> */
descriptor_t * networkZnetwork_internalZCLS_X_X_quad_t_MAKER_GENERAL(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    void * L_pointer; /* pointer */
    int L_pointer_suppliedQUERY; /* pointer-supplied? */
    long L_index; /* index */
    descriptor_t L_temp; /* temp */
    descriptor_t L_value; /* value */
    descriptor_t L_temp_2;
    descriptor_t L_temp_3;
    void * L_result0; /* result0 */
    descriptor_t L_temp_4;

    /* #line {Class <unknown-source-location>} */

    /* #line 126 "./cmp.dylan" */

    /* #line 209 "./num.dylan" */
    if (((A_nargs & 1) == 0)) {
	/* #line {Class <unknown-source-location>} */
	L_args = ((void *)(orig_sp - A_nargs));
	L_pointer = 0;
	L_pointer_suppliedQUERY = FALSE;
	L_index = (A_nargs - 2);
	while (1) {
	    if ((L_index < 0)) {
		goto block0;
	    }
	    else {
		L_temp = (((descriptor_t *)L_args)[L_index]);

		/* #line 386 "./condition.dylan" */
		if ((&dylanZdylan_visceraZCLS_symbol_HEAP == SLOT(L_temp.heapptr, heapptr_t, 0))) {
		    /* #line {Class <unknown-source-location>} */
		    L_value = (((descriptor_t *)L_args)[(L_index + 1)]);
		    if ((L_temp.heapptr == &SYM_pointer_HEAP)) {

			/* #line 386 "./condition.dylan" */
			if ((&dylanZdylan_visceraZCLS_raw_pointer_HEAP == SLOT(L_value.heapptr, heapptr_t, 0))) {
			    /* #line {Class <unknown-source-location>} */
			    L_pointer = L_value.dataword.ptr;
			    L_pointer_suppliedQUERY = TRUE;
			}
			else {

			    /* #line 389 "./condition.dylan" */
			    L_temp_2.heapptr = &networkZstr_ROOT;
			    L_temp_2.dataword.l = 0;
			    /* type-error-with-location */
			    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_value, &dylanZdylan_visceraZCLS_raw_pointer_HEAP, L_temp_2);
			    not_reached();
			}
		    }
		    /* #line {Class <unknown-source-location>} */
		    L_index = (L_index - 2);
		}
		else {

		    /* #line 389 "./condition.dylan" */
		    L_temp_3.heapptr = &networkZstr_ROOT;
		    L_temp_3.dataword.l = 0;
		    /* type-error-with-location */
		    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp, &dylanZdylan_visceraZCLS_symbol_HEAP, L_temp_3);
		    not_reached();
		}
	    }
	}
      block0:;
	/* #line {Class <unknown-source-location>} */
	orig_sp = L_args;
	/* maker for <__quad-t> */
	L_result0 = networkZnetwork_internalZCLS_X_X_quad_t_MAKER_FUN(orig_sp, L_pointer, L_pointer_suppliedQUERY);
	L_temp_4.heapptr = networkZliteral_22.heapptr;
	L_temp_4.dataword.ptr = L_result0;
	orig_sp[0] = L_temp_4;
	return orig_sp + 1;
    }
    else {
	/* odd-number-of-keyword/value-arguments-error */
	dylanZdylan_visceraZodd_number_of_keywordSLASHvalue_arguments_error_FUN(orig_sp);
	not_reached();
    }
}


/* Define Sealed Domain make (singleton(<__quad-t>)) */


/* {Implicit} Define Generic get-__val */

/* get-__val is get-__val */


/* Define Method get-__val{<__quad-t>} */

extern struct heapobj networkZstr_ROOT_27;

/* get-__val{<__quad-t>} */
void * networkZnetwork_internalZget_X_X_val_METH(descriptor_t *orig_sp, void * A_ptr /* ptr */, heapptr_t A1)
{
    descriptor_t *cluster_0_top;
    descriptor_t L_temp;
    descriptor_t L_temp_2;
    descriptor_t L_temp_3;
    descriptor_t L_temp_4; /* temp */
    int L_condition; /* condition */
    descriptor_t L_temp_5;
    descriptor_t L_temp_6; /* temp */
    descriptor_t L_temp_7;
    descriptor_t L_temp_8;


    /* #line 49 "./object.dylan" */
    L_temp.heapptr = networkZliteral_22.heapptr;
    L_temp.dataword.ptr = A_ptr;

    /* #line 324 "./melange.dylan" */

    /* #line 324 "./melange.dylan" */

    /* #line 324 "./melange.dylan" */
    L_temp_2.heapptr = SLOT(L_temp.heapptr, heapptr_t, 0);
    L_temp_2.dataword.l = 0;
    L_temp_3.heapptr = networkZliteral_6.heapptr;
    L_temp_3.dataword.ptr = ((void *)((char *)A_ptr + 0));
    orig_sp[0] = L_temp_2;
    orig_sp[1] = L_temp_3;
    /* as */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZas_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_temp_4 = orig_sp[0];

    /* #line 49 "./object.dylan" */

    /* #line 386 "./condition.dylan" */
    /* %subtype?{<class>, <class>} */
    L_condition = dylanZdylan_visceraZPCTsubtypeQUERY_METH(orig_sp, SLOT(L_temp_4.heapptr, heapptr_t, 0), &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP, &dylanZliteral_ROOT_2);
    if (L_condition) {

	/* #line 324 "./melange.dylan" */

	/* #line 1070 "./sockets-api.dylan" */
	L_temp_5.heapptr = &networkZnetwork_internalZCLS_longLESSX402GREATER_HEAP;
	L_temp_5.dataword.l = 0;
	orig_sp[0] = L_temp_5;
	orig_sp[1] = L_temp_4;
	/* as */
	{
	  struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZas_HEAP, 2);
	  heapptr_t L_meth = L_temp.R0;
	  heapptr_t L_next_info = L_temp.R1;
	  cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
	}
	L_temp_6 = orig_sp[0];

	/* #line 386 "./condition.dylan" */
	if ((&networkZnetwork_internalZCLS_longLESSX402GREATER_HEAP == SLOT(L_temp_6.heapptr, heapptr_t, 0))) {

	    /* #line 1070 "./sockets-api.dylan" */
	    return L_temp_6.dataword.ptr;
	}
	else {

	    /* #line 389 "./condition.dylan" */
	    L_temp_7.heapptr = &networkZstr_ROOT_27;
	    L_temp_7.dataword.l = 0;
	    /* type-error-with-location */
	    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp_6, &networkZnetwork_internalZCLS_longLESSX402GREATER_HEAP, L_temp_7);
	    not_reached();
	}
    }
    else {
	L_temp_8.heapptr = &networkZstr_ROOT_5;
	L_temp_8.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp_4, &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP, L_temp_8);
	not_reached();
    }
}


/* Define Method pointer-value{<__quad-t>} */

extern struct heapobj networkZstr_ROOT_28;

/* pointer-value{<__quad-t>} */
void * networkZnetwork_internalZpointer_value_METH_15(descriptor_t *orig_sp, void * A_value /* value */, heapptr_t A_next_method_info /* next-method-info */, heapptr_t A_rest /* rest */, descriptor_t A_index /* index */)
{
    descriptor_t *cluster_0_top;
    descriptor_t L_temp;
    descriptor_t L_arg1; /* arg1 */
    descriptor_t L_temp_2;
    descriptor_t L_temp_3; /* temp */
    descriptor_t L_temp_4;

    /* #line {Class <unknown-source-location>} */

    /* #line 1074 "./sockets-api.dylan" */
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = 8;
    orig_sp[0] = A_index;
    orig_sp[1] = L_temp;
    /* * */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZV_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_arg1 = (orig_sp == cluster_0_top ? dylanZfalse : orig_sp[0]);

    /* #line 1074 "./sockets-api.dylan" */
    L_temp_2.heapptr = networkZliteral_22.heapptr;
    L_temp_2.dataword.ptr = A_value;
    orig_sp[0] = L_temp_2;
    orig_sp[1] = L_arg1;
    /* + */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZPLUS_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_temp_3 = (orig_sp == cluster_0_top ? dylanZfalse : orig_sp[0]);

    /* #line 386 "./condition.dylan" */
    if ((&networkZnetwork_internalZCLS_X_X_quad_t_HEAP == SLOT(L_temp_3.heapptr, heapptr_t, 0))) {

	/* #line 1074 "./sockets-api.dylan" */
	return L_temp_3.dataword.ptr;
    }
    else {

	/* #line 389 "./condition.dylan" */
	L_temp_4.heapptr = &networkZstr_ROOT_28;
	L_temp_4.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp_3, &networkZnetwork_internalZCLS_X_X_quad_t_HEAP, L_temp_4);
	not_reached();
    }
}

/* generic-entry for pointer-value{<__quad-t>} */
descriptor_t * networkZnetwork_internalZpointer_value_METH_GENERIC_15(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    descriptor_t L_arg; /* arg */
    heapptr_t L_rest; /* rest */
    void * L_arg_2; /* arg */
    descriptor_t L_index; /* index */
    long L_index_2; /* index */
    descriptor_t L_key; /* key */
    descriptor_t L_value; /* value */
    void * L_result0; /* result0 */
    descriptor_t L_temp;

    /* #line {Class <unknown-source-location>} */
    L_args = ((void *)(orig_sp - A_nargs));
    L_arg = (((descriptor_t *)L_args)[0]);
    L_rest = dylanZdylan_visceraZmake_rest_arg_FUN(orig_sp, (descriptor_t *)L_args + 1, A_nargs - 1);
    L_arg_2 = L_arg.dataword.ptr;
    L_index.heapptr = networkZliteral_2.heapptr;
    L_index.dataword.l = 0;
    L_index_2 = (A_nargs - 2);
    while (1) {
	if ((L_index_2 < 1)) {
	    goto block0;
	}
	else {
	    L_key = (((descriptor_t *)L_args)[L_index_2]);
	    L_value = (((descriptor_t *)L_args)[(L_index_2 + 1)]);
	    if ((L_key.heapptr == &SYM_index_HEAP)) {
		L_index = L_value;
	    }
	    L_index_2 = (L_index_2 - 2);
	}
    }
  block0:;
    orig_sp = L_args;
    /* pointer-value{<__quad-t>} */
    L_result0 = networkZnetwork_internalZpointer_value_METH_15(orig_sp, L_arg_2, A_next_method_info, L_rest, L_index);
    L_temp.heapptr = networkZliteral_22.heapptr;
    L_temp.dataword.ptr = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* Define Method content-size{subclass(<__quad-t>)} */

/* content-size{subclass(<__quad-t>)} */
long networkZnetwork_internalZcontent_size_METH_20(descriptor_t *orig_sp, heapptr_t A0, heapptr_t A1)
{

    return 8;
}

/* generic-entry for content-size{subclass(<__quad-t>)} */
descriptor_t * networkZnetwork_internalZcontent_size_METH_GENERIC_20(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    long L_result0; /* result0 */
    descriptor_t L_temp;

    orig_sp = ((void *)(orig_sp - 1));
    /* content-size{subclass(<__quad-t>)} */
    L_result0 = networkZnetwork_internalZcontent_size_METH_20(orig_sp, &networkZnetwork_internalZCLS_X_X_quad_t_HEAP, A_next_method_info);
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* Define Constant <quad-t> */

/* <quad-t> is <__quad-t> */


/* Define Class <__u-long*> */

/* <__u-long*> is <__u-long*> */

extern struct heapobj networkZnetwork_internalZCLS_X_X_u_longV_HEAP;

/* maker for <__u-long*> */
void * networkZnetwork_internalZCLS_X_X_u_longV_MAKER_FUN(descriptor_t *orig_sp, void * A_pointer /* pointer */, int A_pointer_suppliedQUERY /* pointer-supplied? */)
{
    descriptor_t *cluster_0_top;


    /* #line 1083 "./sockets-api.dylan" */
    if (A_pointer_suppliedQUERY) {
	return A_pointer;
    }
    else {
	/* missing-required-init-keyword-error */
	dylanZdylan_visceraZmissing_required_init_keyword_error_FUN(orig_sp, &SYM_pointer_HEAP, &networkZnetwork_internalZCLS_X_X_u_longV_HEAP);
	not_reached();
    }
}

extern descriptor_t networkZliteral_23;	/* proxy for <__u-long*> */

/* general-entry for maker for <__u-long*> */
descriptor_t * networkZnetwork_internalZCLS_X_X_u_longV_MAKER_GENERAL(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    void * L_pointer; /* pointer */
    int L_pointer_suppliedQUERY; /* pointer-supplied? */
    long L_index; /* index */
    descriptor_t L_temp; /* temp */
    descriptor_t L_value; /* value */
    descriptor_t L_temp_2;
    descriptor_t L_temp_3;
    void * L_result0; /* result0 */
    descriptor_t L_temp_4;

    /* #line {Class <unknown-source-location>} */

    /* #line 126 "./cmp.dylan" */

    /* #line 209 "./num.dylan" */
    if (((A_nargs & 1) == 0)) {
	/* #line {Class <unknown-source-location>} */
	L_args = ((void *)(orig_sp - A_nargs));
	L_pointer = 0;
	L_pointer_suppliedQUERY = FALSE;
	L_index = (A_nargs - 2);
	while (1) {
	    if ((L_index < 0)) {
		goto block0;
	    }
	    else {
		L_temp = (((descriptor_t *)L_args)[L_index]);

		/* #line 386 "./condition.dylan" */
		if ((&dylanZdylan_visceraZCLS_symbol_HEAP == SLOT(L_temp.heapptr, heapptr_t, 0))) {
		    /* #line {Class <unknown-source-location>} */
		    L_value = (((descriptor_t *)L_args)[(L_index + 1)]);
		    if ((L_temp.heapptr == &SYM_pointer_HEAP)) {

			/* #line 386 "./condition.dylan" */
			if ((&dylanZdylan_visceraZCLS_raw_pointer_HEAP == SLOT(L_value.heapptr, heapptr_t, 0))) {
			    /* #line {Class <unknown-source-location>} */
			    L_pointer = L_value.dataword.ptr;
			    L_pointer_suppliedQUERY = TRUE;
			}
			else {

			    /* #line 389 "./condition.dylan" */
			    L_temp_2.heapptr = &networkZstr_ROOT;
			    L_temp_2.dataword.l = 0;
			    /* type-error-with-location */
			    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_value, &dylanZdylan_visceraZCLS_raw_pointer_HEAP, L_temp_2);
			    not_reached();
			}
		    }
		    /* #line {Class <unknown-source-location>} */
		    L_index = (L_index - 2);
		}
		else {

		    /* #line 389 "./condition.dylan" */
		    L_temp_3.heapptr = &networkZstr_ROOT;
		    L_temp_3.dataword.l = 0;
		    /* type-error-with-location */
		    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp, &dylanZdylan_visceraZCLS_symbol_HEAP, L_temp_3);
		    not_reached();
		}
	    }
	}
      block0:;
	/* #line {Class <unknown-source-location>} */
	orig_sp = L_args;
	/* maker for <__u-long*> */
	L_result0 = networkZnetwork_internalZCLS_X_X_u_longV_MAKER_FUN(orig_sp, L_pointer, L_pointer_suppliedQUERY);
	L_temp_4.heapptr = networkZliteral_23.heapptr;
	L_temp_4.dataword.ptr = L_result0;
	orig_sp[0] = L_temp_4;
	return orig_sp + 1;
    }
    else {
	/* odd-number-of-keyword/value-arguments-error */
	dylanZdylan_visceraZodd_number_of_keywordSLASHvalue_arguments_error_FUN(orig_sp);
	not_reached();
    }
}


/* Define Sealed Domain make (singleton(<__u-long*>)) */


/* Define Method pointer-value{<__u-long*>} */

extern struct heapobj networkZstr_ROOT_29;

/* pointer-value{<__u-long*>} */
long networkZnetwork_internalZpointer_value_METH_16(descriptor_t *orig_sp, descriptor_t A_ptr /* ptr */, heapptr_t A_next_method_info /* next-method-info */, heapptr_t A_rest /* rest */, descriptor_t A_index /* index */)
{
    descriptor_t *cluster_0_top;
    descriptor_t L_temp;
    descriptor_t L_arg2; /* arg2 */
    descriptor_t L_temp_2;


    /* #line 1090 "./sockets-api.dylan" */
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = 4;
    orig_sp[0] = A_index;
    orig_sp[1] = L_temp;
    /* * */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZV_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_arg2 = (orig_sp == cluster_0_top ? dylanZfalse : orig_sp[0]);

    /* #line 386 "./condition.dylan" */
    if ((&dylanZdylan_visceraZCLS_integer_HEAP == SLOT(L_arg2.heapptr, heapptr_t, 0))) {

	/* #line 1090 "./sockets-api.dylan" */

	/* #line 211 "./melange.dylan" */

	/* #line 91 "./rawptr.dylan" */
	return (*(long *)((char *)A_ptr.dataword.ptr + L_arg2.dataword.l ));
    }
    else {

	/* #line 389 "./condition.dylan" */
	L_temp_2.heapptr = &networkZstr_ROOT_29;
	L_temp_2.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_arg2, &dylanZdylan_visceraZCLS_integer_HEAP, L_temp_2);
	not_reached();
    }
}

/* generic-entry for pointer-value{<__u-long*>} */
descriptor_t * networkZnetwork_internalZpointer_value_METH_GENERIC_16(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    descriptor_t L_arg; /* arg */
    heapptr_t L_rest; /* rest */
    descriptor_t L_arg_2; /* arg */
    descriptor_t L_index; /* index */
    long L_index_2; /* index */
    descriptor_t L_key; /* key */
    descriptor_t L_value; /* value */
    long L_result0; /* result0 */
    descriptor_t L_temp;

    /* #line {Class <unknown-source-location>} */
    L_args = ((void *)(orig_sp - A_nargs));
    L_arg = (((descriptor_t *)L_args)[0]);
    L_rest = dylanZdylan_visceraZmake_rest_arg_FUN(orig_sp, (descriptor_t *)L_args + 1, A_nargs - 1);
    L_arg_2 = L_arg;
    L_index.heapptr = networkZliteral_2.heapptr;
    L_index.dataword.l = 0;
    L_index_2 = (A_nargs - 2);
    while (1) {
	if ((L_index_2 < 1)) {
	    goto block0;
	}
	else {
	    L_key = (((descriptor_t *)L_args)[L_index_2]);
	    L_value = (((descriptor_t *)L_args)[(L_index_2 + 1)]);
	    if ((L_key.heapptr == &SYM_index_HEAP)) {
		L_index = L_value;
	    }
	    L_index_2 = (L_index_2 - 2);
	}
    }
  block0:;
    orig_sp = L_args;
    /* pointer-value{<__u-long*>} */
    L_result0 = networkZnetwork_internalZpointer_value_METH_16(orig_sp, L_arg_2, A_next_method_info, L_rest, L_index);
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* Define Method pointer-value-setter{<integer>, <__u-long*>} */

/* pointer-value-setter{<integer>, <__u-long*>} */
long networkZnetwork_internalZpointer_value_setter_METH_6(descriptor_t *orig_sp, long A_value /* value */, descriptor_t A_ptr /* ptr */, heapptr_t A_next_method_info /* next-method-info */, heapptr_t A_rest /* rest */, descriptor_t A_index /* index */)
{
    descriptor_t *cluster_0_top;
    descriptor_t L_temp;
    descriptor_t L_arg3; /* arg3 */
    descriptor_t L_temp_2;


    /* #line 1096 "./sockets-api.dylan" */
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = 4;
    orig_sp[0] = A_index;
    orig_sp[1] = L_temp;
    /* * */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZV_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_arg3 = (orig_sp == cluster_0_top ? dylanZfalse : orig_sp[0]);

    /* #line 386 "./condition.dylan" */
    if ((&dylanZdylan_visceraZCLS_integer_HEAP == SLOT(L_arg3.heapptr, heapptr_t, 0))) {
	/* #line {Class <unknown-source-location>} */

	/* #line 97 "./rawptr.dylan" */
	*(long *)((char *)A_ptr.dataword.ptr + L_arg3.dataword.l) = A_value;
	return A_value;
    }
    else {

	/* #line 389 "./condition.dylan" */
	L_temp_2.heapptr = &networkZstr_ROOT;
	L_temp_2.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_arg3, &dylanZdylan_visceraZCLS_integer_HEAP, L_temp_2);
	not_reached();
    }
}

/* generic-entry for pointer-value-setter{<integer>, <__u-long*>} */
descriptor_t * networkZnetwork_internalZpointer_value_setter_METH_GENERIC_6(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    descriptor_t L_arg; /* arg */
    descriptor_t L_arg_2; /* arg */
    heapptr_t L_rest; /* rest */
    long L_arg_3; /* arg */
    descriptor_t L_arg_4; /* arg */
    descriptor_t L_index; /* index */
    long L_index_2; /* index */
    descriptor_t L_key; /* key */
    descriptor_t L_value; /* value */
    long L_result0; /* result0 */
    descriptor_t L_temp;

    /* #line {Class <unknown-source-location>} */
    L_args = ((void *)(orig_sp - A_nargs));
    L_arg = (((descriptor_t *)L_args)[0]);
    L_arg_2 = (((descriptor_t *)L_args)[1]);
    L_rest = dylanZdylan_visceraZmake_rest_arg_FUN(orig_sp, (descriptor_t *)L_args + 2, A_nargs - 2);
    L_arg_3 = L_arg.dataword.l;
    L_arg_4 = L_arg_2;
    L_index.heapptr = networkZliteral_2.heapptr;
    L_index.dataword.l = 0;
    L_index_2 = (A_nargs - 2);
    while (1) {
	if ((L_index_2 < 2)) {
	    goto block0;
	}
	else {
	    L_key = (((descriptor_t *)L_args)[L_index_2]);
	    L_value = (((descriptor_t *)L_args)[(L_index_2 + 1)]);
	    if ((L_key.heapptr == &SYM_index_HEAP)) {
		L_index = L_value;
	    }
	    L_index_2 = (L_index_2 - 2);
	}
    }
  block0:;
    orig_sp = L_args;
    /* pointer-value-setter{<integer>, <__u-long*>} */
    L_result0 = networkZnetwork_internalZpointer_value_setter_METH_6(orig_sp, L_arg_3, L_arg_4, A_next_method_info, L_rest, L_index);
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* Define Method content-size{subclass(<__u-long*>)} */

/* content-size{subclass(<__u-long*>)} */
long networkZnetwork_internalZcontent_size_METH_21(descriptor_t *orig_sp, heapptr_t A0, heapptr_t A1)
{

    return 4;
}

/* generic-entry for content-size{subclass(<__u-long*>)} */
descriptor_t * networkZnetwork_internalZcontent_size_METH_GENERIC_21(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    descriptor_t L_arg; /* arg */
    heapptr_t L_arg_2; /* arg */
    long L_result0; /* result0 */
    descriptor_t L_temp;

    L_args = ((void *)(orig_sp - 1));
    L_arg = (((descriptor_t *)L_args)[0]);
    L_arg_2 = L_arg.heapptr;
    orig_sp = L_args;
    /* content-size{subclass(<__u-long*>)} */
    L_result0 = networkZnetwork_internalZcontent_size_METH_21(orig_sp, L_arg_2, A_next_method_info);
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* Define Class <__u-long<@2>> */

/* <__u-long<@2>> is <__u-long<@2>> */

extern struct heapobj networkZnetwork_internalZCLS_X_X_u_longLESSX402GREATER_HEAP;

/* maker for <__u-long<@2>> */
void * networkZnetwork_internalZCLS_X_X_u_longLESSX402GREATER_MAKER_FUN(descriptor_t *orig_sp, void * A_pointer /* pointer */, int A_pointer_suppliedQUERY /* pointer-supplied? */)
{
    descriptor_t *cluster_0_top;


    /* #line 1104 "./sockets-api.dylan" */
    if (A_pointer_suppliedQUERY) {
	return A_pointer;
    }
    else {
	/* missing-required-init-keyword-error */
	dylanZdylan_visceraZmissing_required_init_keyword_error_FUN(orig_sp, &SYM_pointer_HEAP, &networkZnetwork_internalZCLS_X_X_u_longLESSX402GREATER_HEAP);
	not_reached();
    }
}

extern descriptor_t networkZliteral_24;	/* proxy for <__u-long<@2>> */

/* general-entry for maker for <__u-long<@2>> */
descriptor_t * networkZnetwork_internalZCLS_X_X_u_longLESSX402GREATER_MAKER_GENERAL(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    void * L_pointer; /* pointer */
    int L_pointer_suppliedQUERY; /* pointer-supplied? */
    long L_index; /* index */
    descriptor_t L_temp; /* temp */
    descriptor_t L_value; /* value */
    descriptor_t L_temp_2;
    descriptor_t L_temp_3;
    void * L_result0; /* result0 */
    descriptor_t L_temp_4;

    /* #line {Class <unknown-source-location>} */

    /* #line 126 "./cmp.dylan" */

    /* #line 209 "./num.dylan" */
    if (((A_nargs & 1) == 0)) {
	/* #line {Class <unknown-source-location>} */
	L_args = ((void *)(orig_sp - A_nargs));
	L_pointer = 0;
	L_pointer_suppliedQUERY = FALSE;
	L_index = (A_nargs - 2);
	while (1) {
	    if ((L_index < 0)) {
		goto block0;
	    }
	    else {
		L_temp = (((descriptor_t *)L_args)[L_index]);

		/* #line 386 "./condition.dylan" */
		if ((&dylanZdylan_visceraZCLS_symbol_HEAP == SLOT(L_temp.heapptr, heapptr_t, 0))) {
		    /* #line {Class <unknown-source-location>} */
		    L_value = (((descriptor_t *)L_args)[(L_index + 1)]);
		    if ((L_temp.heapptr == &SYM_pointer_HEAP)) {

			/* #line 386 "./condition.dylan" */
			if ((&dylanZdylan_visceraZCLS_raw_pointer_HEAP == SLOT(L_value.heapptr, heapptr_t, 0))) {
			    /* #line {Class <unknown-source-location>} */
			    L_pointer = L_value.dataword.ptr;
			    L_pointer_suppliedQUERY = TRUE;
			}
			else {

			    /* #line 389 "./condition.dylan" */
			    L_temp_2.heapptr = &networkZstr_ROOT;
			    L_temp_2.dataword.l = 0;
			    /* type-error-with-location */
			    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_value, &dylanZdylan_visceraZCLS_raw_pointer_HEAP, L_temp_2);
			    not_reached();
			}
		    }
		    /* #line {Class <unknown-source-location>} */
		    L_index = (L_index - 2);
		}
		else {

		    /* #line 389 "./condition.dylan" */
		    L_temp_3.heapptr = &networkZstr_ROOT;
		    L_temp_3.dataword.l = 0;
		    /* type-error-with-location */
		    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp, &dylanZdylan_visceraZCLS_symbol_HEAP, L_temp_3);
		    not_reached();
		}
	    }
	}
      block0:;
	/* #line {Class <unknown-source-location>} */
	orig_sp = L_args;
	/* maker for <__u-long<@2>> */
	L_result0 = networkZnetwork_internalZCLS_X_X_u_longLESSX402GREATER_MAKER_FUN(orig_sp, L_pointer, L_pointer_suppliedQUERY);
	L_temp_4.heapptr = networkZliteral_24.heapptr;
	L_temp_4.dataword.ptr = L_result0;
	orig_sp[0] = L_temp_4;
	return orig_sp + 1;
    }
    else {
	/* odd-number-of-keyword/value-arguments-error */
	dylanZdylan_visceraZodd_number_of_keywordSLASHvalue_arguments_error_FUN(orig_sp);
	not_reached();
    }
}


/* Define Sealed Domain make (singleton(<__u-long<@2>>)) */


/* Define Method content-size{singleton(<__u-long<@2>>)} */

/* content-size{singleton(<__u-long<@2>>)} */
long networkZnetwork_internalZcontent_size_METH_22(descriptor_t *orig_sp, heapptr_t A0, heapptr_t A1)
{

    return 2;
}

/* generic-entry for content-size{singleton(<__u-long<@2>>)} */
descriptor_t * networkZnetwork_internalZcontent_size_METH_GENERIC_22(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    long L_result0; /* result0 */
    descriptor_t L_temp;

    orig_sp = ((void *)(orig_sp - 1));
    /* content-size{singleton(<__u-long<@2>>)} */
    L_result0 = networkZnetwork_internalZcontent_size_METH_22(orig_sp, &networkZnetwork_internalZCLS_X_X_u_longLESSX402GREATER_HEAP, A_next_method_info);
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* Define Class <__u-quad-t> */

/* <__u-quad-t> is <__u-quad-t> */

extern struct heapobj networkZnetwork_internalZCLS_X_X_u_quad_t_HEAP;

/* maker for <__u-quad-t> */
void * networkZnetwork_internalZCLS_X_X_u_quad_t_MAKER_FUN(descriptor_t *orig_sp, void * A_pointer /* pointer */, int A_pointer_suppliedQUERY /* pointer-supplied? */)
{
    descriptor_t *cluster_0_top;


    /* #line 1112 "./sockets-api.dylan" */
    if (A_pointer_suppliedQUERY) {
	return A_pointer;
    }
    else {
	/* missing-required-init-keyword-error */
	dylanZdylan_visceraZmissing_required_init_keyword_error_FUN(orig_sp, &SYM_pointer_HEAP, &networkZnetwork_internalZCLS_X_X_u_quad_t_HEAP);
	not_reached();
    }
}

extern descriptor_t networkZliteral_25;	/* proxy for <__u-quad-t> */

/* general-entry for maker for <__u-quad-t> */
descriptor_t * networkZnetwork_internalZCLS_X_X_u_quad_t_MAKER_GENERAL(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    void * L_pointer; /* pointer */
    int L_pointer_suppliedQUERY; /* pointer-supplied? */
    long L_index; /* index */
    descriptor_t L_temp; /* temp */
    descriptor_t L_value; /* value */
    descriptor_t L_temp_2;
    descriptor_t L_temp_3;
    void * L_result0; /* result0 */
    descriptor_t L_temp_4;

    /* #line {Class <unknown-source-location>} */

    /* #line 126 "./cmp.dylan" */

    /* #line 209 "./num.dylan" */
    if (((A_nargs & 1) == 0)) {
	/* #line {Class <unknown-source-location>} */
	L_args = ((void *)(orig_sp - A_nargs));
	L_pointer = 0;
	L_pointer_suppliedQUERY = FALSE;
	L_index = (A_nargs - 2);
	while (1) {
	    if ((L_index < 0)) {
		goto block0;
	    }
	    else {
		L_temp = (((descriptor_t *)L_args)[L_index]);

		/* #line 386 "./condition.dylan" */
		if ((&dylanZdylan_visceraZCLS_symbol_HEAP == SLOT(L_temp.heapptr, heapptr_t, 0))) {
		    /* #line {Class <unknown-source-location>} */
		    L_value = (((descriptor_t *)L_args)[(L_index + 1)]);
		    if ((L_temp.heapptr == &SYM_pointer_HEAP)) {

			/* #line 386 "./condition.dylan" */
			if ((&dylanZdylan_visceraZCLS_raw_pointer_HEAP == SLOT(L_value.heapptr, heapptr_t, 0))) {
			    /* #line {Class <unknown-source-location>} */
			    L_pointer = L_value.dataword.ptr;
			    L_pointer_suppliedQUERY = TRUE;
			}
			else {

			    /* #line 389 "./condition.dylan" */
			    L_temp_2.heapptr = &networkZstr_ROOT;
			    L_temp_2.dataword.l = 0;
			    /* type-error-with-location */
			    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_value, &dylanZdylan_visceraZCLS_raw_pointer_HEAP, L_temp_2);
			    not_reached();
			}
		    }
		    /* #line {Class <unknown-source-location>} */
		    L_index = (L_index - 2);
		}
		else {

		    /* #line 389 "./condition.dylan" */
		    L_temp_3.heapptr = &networkZstr_ROOT;
		    L_temp_3.dataword.l = 0;
		    /* type-error-with-location */
		    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp, &dylanZdylan_visceraZCLS_symbol_HEAP, L_temp_3);
		    not_reached();
		}
	    }
	}
      block0:;
	/* #line {Class <unknown-source-location>} */
	orig_sp = L_args;
	/* maker for <__u-quad-t> */
	L_result0 = networkZnetwork_internalZCLS_X_X_u_quad_t_MAKER_FUN(orig_sp, L_pointer, L_pointer_suppliedQUERY);
	L_temp_4.heapptr = networkZliteral_25.heapptr;
	L_temp_4.dataword.ptr = L_result0;
	orig_sp[0] = L_temp_4;
	return orig_sp + 1;
    }
    else {
	/* odd-number-of-keyword/value-arguments-error */
	dylanZdylan_visceraZodd_number_of_keywordSLASHvalue_arguments_error_FUN(orig_sp);
	not_reached();
    }
}


/* Define Sealed Domain make (singleton(<__u-quad-t>)) */


/* Define Method get-__val{<__u-quad-t>} */

extern struct heapobj networkZstr_ROOT_30;

/* get-__val{<__u-quad-t>} */
void * networkZnetwork_internalZget_X_X_val_METH_2(descriptor_t *orig_sp, void * A_ptr /* ptr */, heapptr_t A1)
{
    descriptor_t *cluster_0_top;
    descriptor_t L_temp;
    descriptor_t L_temp_2;
    descriptor_t L_temp_3;
    descriptor_t L_temp_4; /* temp */
    int L_condition; /* condition */
    descriptor_t L_temp_5;
    descriptor_t L_temp_6; /* temp */
    descriptor_t L_temp_7;
    descriptor_t L_temp_8;


    /* #line 49 "./object.dylan" */
    L_temp.heapptr = networkZliteral_25.heapptr;
    L_temp.dataword.ptr = A_ptr;

    /* #line 324 "./melange.dylan" */

    /* #line 324 "./melange.dylan" */

    /* #line 324 "./melange.dylan" */
    L_temp_2.heapptr = SLOT(L_temp.heapptr, heapptr_t, 0);
    L_temp_2.dataword.l = 0;
    L_temp_3.heapptr = networkZliteral_6.heapptr;
    L_temp_3.dataword.ptr = ((void *)((char *)A_ptr + 0));
    orig_sp[0] = L_temp_2;
    orig_sp[1] = L_temp_3;
    /* as */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZas_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_temp_4 = orig_sp[0];

    /* #line 49 "./object.dylan" */

    /* #line 386 "./condition.dylan" */
    /* %subtype?{<class>, <class>} */
    L_condition = dylanZdylan_visceraZPCTsubtypeQUERY_METH(orig_sp, SLOT(L_temp_4.heapptr, heapptr_t, 0), &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP, &dylanZliteral_ROOT_2);
    if (L_condition) {

	/* #line 324 "./melange.dylan" */

	/* #line 1118 "./sockets-api.dylan" */
	L_temp_5.heapptr = &networkZnetwork_internalZCLS_X_X_u_longLESSX402GREATER_HEAP;
	L_temp_5.dataword.l = 0;
	orig_sp[0] = L_temp_5;
	orig_sp[1] = L_temp_4;
	/* as */
	{
	  struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZas_HEAP, 2);
	  heapptr_t L_meth = L_temp.R0;
	  heapptr_t L_next_info = L_temp.R1;
	  cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
	}
	L_temp_6 = orig_sp[0];

	/* #line 386 "./condition.dylan" */
	if ((&networkZnetwork_internalZCLS_X_X_u_longLESSX402GREATER_HEAP == SLOT(L_temp_6.heapptr, heapptr_t, 0))) {

	    /* #line 1118 "./sockets-api.dylan" */
	    return L_temp_6.dataword.ptr;
	}
	else {

	    /* #line 389 "./condition.dylan" */
	    L_temp_7.heapptr = &networkZstr_ROOT_30;
	    L_temp_7.dataword.l = 0;
	    /* type-error-with-location */
	    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp_6, &networkZnetwork_internalZCLS_X_X_u_longLESSX402GREATER_HEAP, L_temp_7);
	    not_reached();
	}
    }
    else {
	L_temp_8.heapptr = &networkZstr_ROOT_5;
	L_temp_8.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp_4, &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP, L_temp_8);
	not_reached();
    }
}


/* Define Method pointer-value{<__u-quad-t>} */

extern struct heapobj networkZstr_ROOT_31;

/* pointer-value{<__u-quad-t>} */
void * networkZnetwork_internalZpointer_value_METH_17(descriptor_t *orig_sp, void * A_value /* value */, heapptr_t A_next_method_info /* next-method-info */, heapptr_t A_rest /* rest */, descriptor_t A_index /* index */)
{
    descriptor_t *cluster_0_top;
    descriptor_t L_temp;
    descriptor_t L_arg1; /* arg1 */
    descriptor_t L_temp_2;
    descriptor_t L_temp_3; /* temp */
    descriptor_t L_temp_4;

    /* #line {Class <unknown-source-location>} */

    /* #line 1122 "./sockets-api.dylan" */
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = 8;
    orig_sp[0] = A_index;
    orig_sp[1] = L_temp;
    /* * */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZV_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_arg1 = (orig_sp == cluster_0_top ? dylanZfalse : orig_sp[0]);

    /* #line 1122 "./sockets-api.dylan" */
    L_temp_2.heapptr = networkZliteral_25.heapptr;
    L_temp_2.dataword.ptr = A_value;
    orig_sp[0] = L_temp_2;
    orig_sp[1] = L_arg1;
    /* + */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZPLUS_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_temp_3 = (orig_sp == cluster_0_top ? dylanZfalse : orig_sp[0]);

    /* #line 386 "./condition.dylan" */
    if ((&networkZnetwork_internalZCLS_X_X_u_quad_t_HEAP == SLOT(L_temp_3.heapptr, heapptr_t, 0))) {

	/* #line 1122 "./sockets-api.dylan" */
	return L_temp_3.dataword.ptr;
    }
    else {

	/* #line 389 "./condition.dylan" */
	L_temp_4.heapptr = &networkZstr_ROOT_31;
	L_temp_4.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp_3, &networkZnetwork_internalZCLS_X_X_u_quad_t_HEAP, L_temp_4);
	not_reached();
    }
}

/* generic-entry for pointer-value{<__u-quad-t>} */
descriptor_t * networkZnetwork_internalZpointer_value_METH_GENERIC_17(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    descriptor_t L_arg; /* arg */
    heapptr_t L_rest; /* rest */
    void * L_arg_2; /* arg */
    descriptor_t L_index; /* index */
    long L_index_2; /* index */
    descriptor_t L_key; /* key */
    descriptor_t L_value; /* value */
    void * L_result0; /* result0 */
    descriptor_t L_temp;

    /* #line {Class <unknown-source-location>} */
    L_args = ((void *)(orig_sp - A_nargs));
    L_arg = (((descriptor_t *)L_args)[0]);
    L_rest = dylanZdylan_visceraZmake_rest_arg_FUN(orig_sp, (descriptor_t *)L_args + 1, A_nargs - 1);
    L_arg_2 = L_arg.dataword.ptr;
    L_index.heapptr = networkZliteral_2.heapptr;
    L_index.dataword.l = 0;
    L_index_2 = (A_nargs - 2);
    while (1) {
	if ((L_index_2 < 1)) {
	    goto block0;
	}
	else {
	    L_key = (((descriptor_t *)L_args)[L_index_2]);
	    L_value = (((descriptor_t *)L_args)[(L_index_2 + 1)]);
	    if ((L_key.heapptr == &SYM_index_HEAP)) {
		L_index = L_value;
	    }
	    L_index_2 = (L_index_2 - 2);
	}
    }
  block0:;
    orig_sp = L_args;
    /* pointer-value{<__u-quad-t>} */
    L_result0 = networkZnetwork_internalZpointer_value_METH_17(orig_sp, L_arg_2, A_next_method_info, L_rest, L_index);
    L_temp.heapptr = networkZliteral_25.heapptr;
    L_temp.dataword.ptr = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* Define Method content-size{subclass(<__u-quad-t>)} */

/* content-size{subclass(<__u-quad-t>)} */
long networkZnetwork_internalZcontent_size_METH_23(descriptor_t *orig_sp, heapptr_t A0, heapptr_t A1)
{

    return 8;
}

/* generic-entry for content-size{subclass(<__u-quad-t>)} */
descriptor_t * networkZnetwork_internalZcontent_size_METH_GENERIC_23(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    long L_result0; /* result0 */
    descriptor_t L_temp;

    orig_sp = ((void *)(orig_sp - 1));
    /* content-size{subclass(<__u-quad-t>)} */
    L_result0 = networkZnetwork_internalZcontent_size_METH_23(orig_sp, &networkZnetwork_internalZCLS_X_X_u_quad_t_HEAP, A_next_method_info);
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* Define Constant <u-quad-t> */

/* <u-quad-t> is <__u-quad-t> */


/* Define Class <__fsid-t> */

/* <__fsid-t> is <__fsid-t> */

extern struct heapobj networkZnetwork_internalZCLS_X_X_fsid_t_HEAP;

/* maker for <__fsid-t> */
void * networkZnetwork_internalZCLS_X_X_fsid_t_MAKER_FUN(descriptor_t *orig_sp, void * A_pointer /* pointer */, int A_pointer_suppliedQUERY /* pointer-supplied? */)
{
    descriptor_t *cluster_0_top;


    /* #line 1131 "./sockets-api.dylan" */
    if (A_pointer_suppliedQUERY) {
	return A_pointer;
    }
    else {
	/* missing-required-init-keyword-error */
	dylanZdylan_visceraZmissing_required_init_keyword_error_FUN(orig_sp, &SYM_pointer_HEAP, &networkZnetwork_internalZCLS_X_X_fsid_t_HEAP);
	not_reached();
    }
}

extern descriptor_t networkZliteral_26;	/* proxy for <__fsid-t> */

/* general-entry for maker for <__fsid-t> */
descriptor_t * networkZnetwork_internalZCLS_X_X_fsid_t_MAKER_GENERAL(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    void * L_pointer; /* pointer */
    int L_pointer_suppliedQUERY; /* pointer-supplied? */
    long L_index; /* index */
    descriptor_t L_temp; /* temp */
    descriptor_t L_value; /* value */
    descriptor_t L_temp_2;
    descriptor_t L_temp_3;
    void * L_result0; /* result0 */
    descriptor_t L_temp_4;

    /* #line {Class <unknown-source-location>} */

    /* #line 126 "./cmp.dylan" */

    /* #line 209 "./num.dylan" */
    if (((A_nargs & 1) == 0)) {
	/* #line {Class <unknown-source-location>} */
	L_args = ((void *)(orig_sp - A_nargs));
	L_pointer = 0;
	L_pointer_suppliedQUERY = FALSE;
	L_index = (A_nargs - 2);
	while (1) {
	    if ((L_index < 0)) {
		goto block0;
	    }
	    else {
		L_temp = (((descriptor_t *)L_args)[L_index]);

		/* #line 386 "./condition.dylan" */
		if ((&dylanZdylan_visceraZCLS_symbol_HEAP == SLOT(L_temp.heapptr, heapptr_t, 0))) {
		    /* #line {Class <unknown-source-location>} */
		    L_value = (((descriptor_t *)L_args)[(L_index + 1)]);
		    if ((L_temp.heapptr == &SYM_pointer_HEAP)) {

			/* #line 386 "./condition.dylan" */
			if ((&dylanZdylan_visceraZCLS_raw_pointer_HEAP == SLOT(L_value.heapptr, heapptr_t, 0))) {
			    /* #line {Class <unknown-source-location>} */
			    L_pointer = L_value.dataword.ptr;
			    L_pointer_suppliedQUERY = TRUE;
			}
			else {

			    /* #line 389 "./condition.dylan" */
			    L_temp_2.heapptr = &networkZstr_ROOT;
			    L_temp_2.dataword.l = 0;
			    /* type-error-with-location */
			    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_value, &dylanZdylan_visceraZCLS_raw_pointer_HEAP, L_temp_2);
			    not_reached();
			}
		    }
		    /* #line {Class <unknown-source-location>} */
		    L_index = (L_index - 2);
		}
		else {

		    /* #line 389 "./condition.dylan" */
		    L_temp_3.heapptr = &networkZstr_ROOT;
		    L_temp_3.dataword.l = 0;
		    /* type-error-with-location */
		    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp, &dylanZdylan_visceraZCLS_symbol_HEAP, L_temp_3);
		    not_reached();
		}
	    }
	}
      block0:;
	/* #line {Class <unknown-source-location>} */
	orig_sp = L_args;
	/* maker for <__fsid-t> */
	L_result0 = networkZnetwork_internalZCLS_X_X_fsid_t_MAKER_FUN(orig_sp, L_pointer, L_pointer_suppliedQUERY);
	L_temp_4.heapptr = networkZliteral_26.heapptr;
	L_temp_4.dataword.ptr = L_result0;
	orig_sp[0] = L_temp_4;
	return orig_sp + 1;
    }
    else {
	/* odd-number-of-keyword/value-arguments-error */
	dylanZdylan_visceraZodd_number_of_keywordSLASHvalue_arguments_error_FUN(orig_sp);
	not_reached();
    }
}


/* Define Sealed Domain make (singleton(<__fsid-t>)) */


/* Define Method get-__val{<__fsid-t>} */

extern struct heapobj networkZstr_ROOT_32;

/* get-__val{<__fsid-t>} */
void * networkZnetwork_internalZget_X_X_val_METH_3(descriptor_t *orig_sp, void * A_ptr /* ptr */, heapptr_t A1)
{
    descriptor_t *cluster_0_top;
    descriptor_t L_temp;
    descriptor_t L_temp_2;
    descriptor_t L_temp_3;
    descriptor_t L_temp_4; /* temp */
    int L_condition; /* condition */
    descriptor_t L_temp_5;
    descriptor_t L_temp_6; /* temp */
    descriptor_t L_temp_7;
    descriptor_t L_temp_8;


    /* #line 49 "./object.dylan" */
    L_temp.heapptr = networkZliteral_26.heapptr;
    L_temp.dataword.ptr = A_ptr;

    /* #line 324 "./melange.dylan" */

    /* #line 324 "./melange.dylan" */

    /* #line 324 "./melange.dylan" */
    L_temp_2.heapptr = SLOT(L_temp.heapptr, heapptr_t, 0);
    L_temp_2.dataword.l = 0;
    L_temp_3.heapptr = networkZliteral_6.heapptr;
    L_temp_3.dataword.ptr = ((void *)((char *)A_ptr + 0));
    orig_sp[0] = L_temp_2;
    orig_sp[1] = L_temp_3;
    /* as */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZas_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_temp_4 = orig_sp[0];

    /* #line 49 "./object.dylan" */

    /* #line 386 "./condition.dylan" */
    /* %subtype?{<class>, <class>} */
    L_condition = dylanZdylan_visceraZPCTsubtypeQUERY_METH(orig_sp, SLOT(L_temp_4.heapptr, heapptr_t, 0), &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP, &dylanZliteral_ROOT_2);
    if (L_condition) {

	/* #line 324 "./melange.dylan" */

	/* #line 1137 "./sockets-api.dylan" */
	L_temp_5.heapptr = &networkZnetwork_internalZCLS_intLESSX402GREATER_HEAP;
	L_temp_5.dataword.l = 0;
	orig_sp[0] = L_temp_5;
	orig_sp[1] = L_temp_4;
	/* as */
	{
	  struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZas_HEAP, 2);
	  heapptr_t L_meth = L_temp.R0;
	  heapptr_t L_next_info = L_temp.R1;
	  cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
	}
	L_temp_6 = orig_sp[0];

	/* #line 386 "./condition.dylan" */
	if ((&networkZnetwork_internalZCLS_intLESSX402GREATER_HEAP == SLOT(L_temp_6.heapptr, heapptr_t, 0))) {

	    /* #line 1137 "./sockets-api.dylan" */
	    return L_temp_6.dataword.ptr;
	}
	else {

	    /* #line 389 "./condition.dylan" */
	    L_temp_7.heapptr = &networkZstr_ROOT_32;
	    L_temp_7.dataword.l = 0;
	    /* type-error-with-location */
	    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp_6, &networkZnetwork_internalZCLS_intLESSX402GREATER_HEAP, L_temp_7);
	    not_reached();
	}
    }
    else {
	L_temp_8.heapptr = &networkZstr_ROOT_5;
	L_temp_8.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp_4, &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP, L_temp_8);
	not_reached();
    }
}


/* Define Method pointer-value{<__fsid-t>} */

extern struct heapobj networkZstr_ROOT_33;

/* pointer-value{<__fsid-t>} */
void * networkZnetwork_internalZpointer_value_METH_18(descriptor_t *orig_sp, void * A_value /* value */, heapptr_t A_next_method_info /* next-method-info */, heapptr_t A_rest /* rest */, descriptor_t A_index /* index */)
{
    descriptor_t *cluster_0_top;
    descriptor_t L_temp;
    descriptor_t L_arg1; /* arg1 */
    descriptor_t L_temp_2;
    descriptor_t L_temp_3; /* temp */
    descriptor_t L_temp_4;

    /* #line {Class <unknown-source-location>} */

    /* #line 1141 "./sockets-api.dylan" */
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = 8;
    orig_sp[0] = A_index;
    orig_sp[1] = L_temp;
    /* * */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZV_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_arg1 = (orig_sp == cluster_0_top ? dylanZfalse : orig_sp[0]);

    /* #line 1141 "./sockets-api.dylan" */
    L_temp_2.heapptr = networkZliteral_26.heapptr;
    L_temp_2.dataword.ptr = A_value;
    orig_sp[0] = L_temp_2;
    orig_sp[1] = L_arg1;
    /* + */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZPLUS_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_temp_3 = (orig_sp == cluster_0_top ? dylanZfalse : orig_sp[0]);

    /* #line 386 "./condition.dylan" */
    if ((&networkZnetwork_internalZCLS_X_X_fsid_t_HEAP == SLOT(L_temp_3.heapptr, heapptr_t, 0))) {

	/* #line 1141 "./sockets-api.dylan" */
	return L_temp_3.dataword.ptr;
    }
    else {

	/* #line 389 "./condition.dylan" */
	L_temp_4.heapptr = &networkZstr_ROOT_33;
	L_temp_4.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp_3, &networkZnetwork_internalZCLS_X_X_fsid_t_HEAP, L_temp_4);
	not_reached();
    }
}

/* generic-entry for pointer-value{<__fsid-t>} */
descriptor_t * networkZnetwork_internalZpointer_value_METH_GENERIC_18(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    descriptor_t L_arg; /* arg */
    heapptr_t L_rest; /* rest */
    void * L_arg_2; /* arg */
    descriptor_t L_index; /* index */
    long L_index_2; /* index */
    descriptor_t L_key; /* key */
    descriptor_t L_value; /* value */
    void * L_result0; /* result0 */
    descriptor_t L_temp;

    /* #line {Class <unknown-source-location>} */
    L_args = ((void *)(orig_sp - A_nargs));
    L_arg = (((descriptor_t *)L_args)[0]);
    L_rest = dylanZdylan_visceraZmake_rest_arg_FUN(orig_sp, (descriptor_t *)L_args + 1, A_nargs - 1);
    L_arg_2 = L_arg.dataword.ptr;
    L_index.heapptr = networkZliteral_2.heapptr;
    L_index.dataword.l = 0;
    L_index_2 = (A_nargs - 2);
    while (1) {
	if ((L_index_2 < 1)) {
	    goto block0;
	}
	else {
	    L_key = (((descriptor_t *)L_args)[L_index_2]);
	    L_value = (((descriptor_t *)L_args)[(L_index_2 + 1)]);
	    if ((L_key.heapptr == &SYM_index_HEAP)) {
		L_index = L_value;
	    }
	    L_index_2 = (L_index_2 - 2);
	}
    }
  block0:;
    orig_sp = L_args;
    /* pointer-value{<__fsid-t>} */
    L_result0 = networkZnetwork_internalZpointer_value_METH_18(orig_sp, L_arg_2, A_next_method_info, L_rest, L_index);
    L_temp.heapptr = networkZliteral_26.heapptr;
    L_temp.dataword.ptr = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* Define Method content-size{subclass(<__fsid-t>)} */

/* content-size{subclass(<__fsid-t>)} */
long networkZnetwork_internalZcontent_size_METH_24(descriptor_t *orig_sp, heapptr_t A0, heapptr_t A1)
{

    return 8;
}

/* generic-entry for content-size{subclass(<__fsid-t>)} */
descriptor_t * networkZnetwork_internalZcontent_size_METH_GENERIC_24(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    long L_result0; /* result0 */
    descriptor_t L_temp;

    orig_sp = ((void *)(orig_sp - 1));
    /* content-size{subclass(<__fsid-t>)} */
    L_result0 = networkZnetwork_internalZcontent_size_METH_24(orig_sp, &networkZnetwork_internalZCLS_X_X_fsid_t_HEAP, A_next_method_info);
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* Define Constant <fsid-t> */

/* <fsid-t> is <__fsid-t> */


/* Define Constant <__off64-t> */

/* <__off64-t> is <double-integer> */


/* Define Constant <__loff-t> */

/* <__loff-t> is <double-integer> */


/* Define Constant <loff-t> */

/* <loff-t> is <double-integer> */


/* Define Constant <__ino-t> */

/* <__ino-t> is <integer> */


/* Define Constant <ino-t> */

/* <ino-t> is <integer> */


/* Define Constant <__dev-t> */

/* <__dev-t> is <double-integer> */


/* Define Constant <dev-t> */

/* <dev-t> is <double-integer> */


/* Define Constant <__mode-t> */

/* <__mode-t> is <integer> */


/* Define Constant <mode-t> */

/* <mode-t> is <integer> */


/* Define Constant <__nlink-t> */

/* <__nlink-t> is <integer> */


/* Define Constant <nlink-t> */

/* <nlink-t> is <integer> */


/* Define Constant <__off-t> */

/* <__off-t> is <integer> */


/* Define Constant <off-t> */

/* <off-t> is <integer> */


/* Define Constant <__id-t> */

/* <__id-t> is <integer> */


/* Define Constant <id-t> */

/* <id-t> is <integer> */


/* Define Constant <__daddr-t> */

/* <__daddr-t> is <integer> */


/* Define Constant <daddr-t> */

/* <daddr-t> is <integer> */


/* Define Constant <__caddr-t> */

/* <__caddr-t> is <c-char-vector> */


/* Define Constant <caddr-t> */

/* <caddr-t> is <c-char-vector> */


/* Define Constant <__key-t> */

/* <__key-t> is <integer> */


/* Define Constant <key-t> */

/* <key-t> is <integer> */


/* Define Constant <ulong> */

/* <ulong> is <integer> */


/* Define Constant <ushort> */

/* <ushort> is <integer> */


/* Define Constant <uint> */

/* <uint> is <integer> */


/* Define Constant <u-int8-t> */

/* <u-int8-t> is <integer> */


/* Define Constant <u-int16-t> */

/* <u-int16-t> is <integer> */


/* Define Constant <u-int32-t> */

/* <u-int32-t> is <integer> */


/* Define Constant <register-t> */

/* <register-t> is <integer> */


/* Define Constant <__blkcnt-t> */

/* <__blkcnt-t> is <integer> */


/* Define Constant <blkcnt-t> */

/* <blkcnt-t> is <integer> */


/* Define Constant <__fsblkcnt-t> */

/* <__fsblkcnt-t> is <integer> */


/* Define Constant <fsblkcnt-t> */

/* <fsblkcnt-t> is <integer> */


/* Define Constant <__fsfilcnt-t> */

/* <__fsfilcnt-t> is <integer> */


/* Define Constant <fsfilcnt-t> */

/* <fsfilcnt-t> is <integer> */


/* Define Constant $_SYS-TYPES-H */

/* $_SYS-TYPES-H is 1 */


/* Define Constant $__BIT-TYPES-DEFINED-- */

/* $__BIT-TYPES-DEFINED-- is 1 */


/* Define Constant <__atomic-lock-t> */

/* <__atomic-lock-t> is <integer> */


/* Define Class <_pthread-fastlock> */

/* <_pthread-fastlock> is <_pthread-fastlock> */

extern struct heapobj networkZnetwork_internalZCLS_X_pthread_fastlock_HEAP;

/* maker for <_pthread-fastlock> */
void * networkZnetwork_internalZCLS_X_pthread_fastlock_MAKER_FUN(descriptor_t *orig_sp, void * A_pointer /* pointer */, int A_pointer_suppliedQUERY /* pointer-supplied? */)
{
    descriptor_t *cluster_0_top;


    /* #line 1224 "./sockets-api.dylan" */
    if (A_pointer_suppliedQUERY) {
	return A_pointer;
    }
    else {
	/* missing-required-init-keyword-error */
	dylanZdylan_visceraZmissing_required_init_keyword_error_FUN(orig_sp, &SYM_pointer_HEAP, &networkZnetwork_internalZCLS_X_pthread_fastlock_HEAP);
	not_reached();
    }
}

extern descriptor_t networkZliteral_27;	/* proxy for <_pthread-fastlock> */

/* general-entry for maker for <_pthread-fastlock> */
descriptor_t * networkZnetwork_internalZCLS_X_pthread_fastlock_MAKER_GENERAL(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    void * L_pointer; /* pointer */
    int L_pointer_suppliedQUERY; /* pointer-supplied? */
    long L_index; /* index */
    descriptor_t L_temp; /* temp */
    descriptor_t L_value; /* value */
    descriptor_t L_temp_2;
    descriptor_t L_temp_3;
    void * L_result0; /* result0 */
    descriptor_t L_temp_4;

    /* #line {Class <unknown-source-location>} */

    /* #line 126 "./cmp.dylan" */

    /* #line 209 "./num.dylan" */
    if (((A_nargs & 1) == 0)) {
	/* #line {Class <unknown-source-location>} */
	L_args = ((void *)(orig_sp - A_nargs));
	L_pointer = 0;
	L_pointer_suppliedQUERY = FALSE;
	L_index = (A_nargs - 2);
	while (1) {
	    if ((L_index < 0)) {
		goto block0;
	    }
	    else {
		L_temp = (((descriptor_t *)L_args)[L_index]);

		/* #line 386 "./condition.dylan" */
		if ((&dylanZdylan_visceraZCLS_symbol_HEAP == SLOT(L_temp.heapptr, heapptr_t, 0))) {
		    /* #line {Class <unknown-source-location>} */
		    L_value = (((descriptor_t *)L_args)[(L_index + 1)]);
		    if ((L_temp.heapptr == &SYM_pointer_HEAP)) {

			/* #line 386 "./condition.dylan" */
			if ((&dylanZdylan_visceraZCLS_raw_pointer_HEAP == SLOT(L_value.heapptr, heapptr_t, 0))) {
			    /* #line {Class <unknown-source-location>} */
			    L_pointer = L_value.dataword.ptr;
			    L_pointer_suppliedQUERY = TRUE;
			}
			else {

			    /* #line 389 "./condition.dylan" */
			    L_temp_2.heapptr = &networkZstr_ROOT;
			    L_temp_2.dataword.l = 0;
			    /* type-error-with-location */
			    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_value, &dylanZdylan_visceraZCLS_raw_pointer_HEAP, L_temp_2);
			    not_reached();
			}
		    }
		    /* #line {Class <unknown-source-location>} */
		    L_index = (L_index - 2);
		}
		else {

		    /* #line 389 "./condition.dylan" */
		    L_temp_3.heapptr = &networkZstr_ROOT;
		    L_temp_3.dataword.l = 0;
		    /* type-error-with-location */
		    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp, &dylanZdylan_visceraZCLS_symbol_HEAP, L_temp_3);
		    not_reached();
		}
	    }
	}
      block0:;
	/* #line {Class <unknown-source-location>} */
	orig_sp = L_args;
	/* maker for <_pthread-fastlock> */
	L_result0 = networkZnetwork_internalZCLS_X_pthread_fastlock_MAKER_FUN(orig_sp, L_pointer, L_pointer_suppliedQUERY);
	L_temp_4.heapptr = networkZliteral_27.heapptr;
	L_temp_4.dataword.ptr = L_result0;
	orig_sp[0] = L_temp_4;
	return orig_sp + 1;
    }
    else {
	/* odd-number-of-keyword/value-arguments-error */
	dylanZdylan_visceraZodd_number_of_keywordSLASHvalue_arguments_error_FUN(orig_sp);
	not_reached();
    }
}


/* Define Sealed Domain make (singleton(<_pthread-fastlock>)) */


/* {Implicit} Define Generic get-__status */

/* get-__status is get-__status */


/* Define Method get-__status{<_pthread-fastlock>} */

/* get-__status{<_pthread-fastlock>} */
long networkZnetwork_internalZget_X_X_status_METH(descriptor_t *orig_sp, void * A_ptr /* ptr */, heapptr_t A1)
{
    descriptor_t *cluster_0_top;


    /* #line 198 "./melange.dylan" */

    /* #line 91 "./rawptr.dylan" */
    return (*(long *)((char *)A_ptr + 0 ));
}


/* {Implicit} Define Generic get-__status-setter */

/* get-__status-setter is get-__status-setter */


/* Define Method get-__status-setter{<integer>, <_pthread-fastlock>} */

/* get-__status-setter{<integer>, <_pthread-fastlock>} */
long networkZnetwork_internalZget_X_X_status_setter_METH(descriptor_t *orig_sp, long A_value /* value */, void * A_ptr /* ptr */, heapptr_t A2)
{
    descriptor_t *cluster_0_top;

    /* #line {Class <unknown-source-location>} */

    /* #line 97 "./rawptr.dylan" */
    *(long *)((char *)A_ptr + 0) = A_value;
    return A_value;
}


/* {Implicit} Define Generic get-__spinlock */

/* get-__spinlock is get-__spinlock */


/* Define Method get-__spinlock{<_pthread-fastlock>} */

/* get-__spinlock{<_pthread-fastlock>} */
long networkZnetwork_internalZget_X_X_spinlock_METH(descriptor_t *orig_sp, void * A_ptr /* ptr */, heapptr_t A1)
{
    descriptor_t *cluster_0_top;

    /* #line {Class <unknown-source-location>} */

    /* #line 198 "./melange.dylan" */

    /* #line 91 "./rawptr.dylan" */
    return (*(long *)((char *)A_ptr + 4 ));
}


/* {Implicit} Define Generic get-__spinlock-setter */

/* get-__spinlock-setter is get-__spinlock-setter */


/* Define Method get-__spinlock-setter{<integer>, <_pthread-fastlock>} */

/* get-__spinlock-setter{<integer>, <_pthread-fastlock>} */
long networkZnetwork_internalZget_X_X_spinlock_setter_METH(descriptor_t *orig_sp, long A_value /* value */, void * A_ptr /* ptr */, heapptr_t A2)
{
    descriptor_t *cluster_0_top;

    /* #line {Class <unknown-source-location>} */

    /* #line 97 "./rawptr.dylan" */
    *(long *)((char *)A_ptr + 4) = A_value;
    return A_value;
}


/* Define Method pointer-value{<_pthread-fastlock>} */

extern struct heapobj networkZstr_ROOT_34;

/* pointer-value{<_pthread-fastlock>} */
void * networkZnetwork_internalZpointer_value_METH_19(descriptor_t *orig_sp, void * A_value /* value */, heapptr_t A_next_method_info /* next-method-info */, heapptr_t A_rest /* rest */, descriptor_t A_index /* index */)
{
    descriptor_t *cluster_0_top;
    descriptor_t L_temp;
    descriptor_t L_arg1; /* arg1 */
    descriptor_t L_temp_2;
    descriptor_t L_temp_3; /* temp */
    descriptor_t L_temp_4;

    /* #line {Class <unknown-source-location>} */

    /* #line 1251 "./sockets-api.dylan" */
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = 8;
    orig_sp[0] = A_index;
    orig_sp[1] = L_temp;
    /* * */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZV_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_arg1 = (orig_sp == cluster_0_top ? dylanZfalse : orig_sp[0]);

    /* #line 1251 "./sockets-api.dylan" */
    L_temp_2.heapptr = networkZliteral_27.heapptr;
    L_temp_2.dataword.ptr = A_value;
    orig_sp[0] = L_temp_2;
    orig_sp[1] = L_arg1;
    /* + */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZPLUS_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_temp_3 = (orig_sp == cluster_0_top ? dylanZfalse : orig_sp[0]);

    /* #line 386 "./condition.dylan" */
    if ((&networkZnetwork_internalZCLS_X_pthread_fastlock_HEAP == SLOT(L_temp_3.heapptr, heapptr_t, 0))) {

	/* #line 1251 "./sockets-api.dylan" */
	return L_temp_3.dataword.ptr;
    }
    else {

	/* #line 389 "./condition.dylan" */
	L_temp_4.heapptr = &networkZstr_ROOT_34;
	L_temp_4.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp_3, &networkZnetwork_internalZCLS_X_pthread_fastlock_HEAP, L_temp_4);
	not_reached();
    }
}

/* generic-entry for pointer-value{<_pthread-fastlock>} */
descriptor_t * networkZnetwork_internalZpointer_value_METH_GENERIC_19(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    descriptor_t L_arg; /* arg */
    heapptr_t L_rest; /* rest */
    void * L_arg_2; /* arg */
    descriptor_t L_index; /* index */
    long L_index_2; /* index */
    descriptor_t L_key; /* key */
    descriptor_t L_value; /* value */
    void * L_result0; /* result0 */
    descriptor_t L_temp;

    /* #line {Class <unknown-source-location>} */
    L_args = ((void *)(orig_sp - A_nargs));
    L_arg = (((descriptor_t *)L_args)[0]);
    L_rest = dylanZdylan_visceraZmake_rest_arg_FUN(orig_sp, (descriptor_t *)L_args + 1, A_nargs - 1);
    L_arg_2 = L_arg.dataword.ptr;
    L_index.heapptr = networkZliteral_2.heapptr;
    L_index.dataword.l = 0;
    L_index_2 = (A_nargs - 2);
    while (1) {
	if ((L_index_2 < 1)) {
	    goto block0;
	}
	else {
	    L_key = (((descriptor_t *)L_args)[L_index_2]);
	    L_value = (((descriptor_t *)L_args)[(L_index_2 + 1)]);
	    if ((L_key.heapptr == &SYM_index_HEAP)) {
		L_index = L_value;
	    }
	    L_index_2 = (L_index_2 - 2);
	}
    }
  block0:;
    orig_sp = L_args;
    /* pointer-value{<_pthread-fastlock>} */
    L_result0 = networkZnetwork_internalZpointer_value_METH_19(orig_sp, L_arg_2, A_next_method_info, L_rest, L_index);
    L_temp.heapptr = networkZliteral_27.heapptr;
    L_temp.dataword.ptr = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* Define Method content-size{subclass(<_pthread-fastlock>)} */

/* content-size{subclass(<_pthread-fastlock>)} */
long networkZnetwork_internalZcontent_size_METH_25(descriptor_t *orig_sp, heapptr_t A0, heapptr_t A1)
{

    return 8;
}

/* generic-entry for content-size{subclass(<_pthread-fastlock>)} */
descriptor_t * networkZnetwork_internalZcontent_size_METH_GENERIC_25(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    long L_result0; /* result0 */
    descriptor_t L_temp;

    orig_sp = ((void *)(orig_sp - 1));
    /* content-size{subclass(<_pthread-fastlock>)} */
    L_result0 = networkZnetwork_internalZcontent_size_METH_25(orig_sp, &networkZnetwork_internalZCLS_X_pthread_fastlock_HEAP, A_next_method_info);
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* Define Class <_pthread-descr-struct> */

/* <_pthread-descr-struct> is <_pthread-descr-struct> */

extern struct heapobj networkZnetwork_internalZCLS_X_pthread_descr_struct_HEAP;

/* maker for <_pthread-descr-struct> */
void * networkZnetwork_internalZCLS_X_pthread_descr_struct_MAKER_FUN(descriptor_t *orig_sp, void * A_pointer /* pointer */, int A_pointer_suppliedQUERY /* pointer-supplied? */)
{
    descriptor_t *cluster_0_top;


    /* #line 1258 "./sockets-api.dylan" */
    if (A_pointer_suppliedQUERY) {
	return A_pointer;
    }
    else {
	/* missing-required-init-keyword-error */
	dylanZdylan_visceraZmissing_required_init_keyword_error_FUN(orig_sp, &SYM_pointer_HEAP, &networkZnetwork_internalZCLS_X_pthread_descr_struct_HEAP);
	not_reached();
    }
}

extern descriptor_t networkZliteral_28;	/* proxy for <_pthread-descr-struct> */

/* general-entry for maker for <_pthread-descr-struct> */
descriptor_t * networkZnetwork_internalZCLS_X_pthread_descr_struct_MAKER_GENERAL(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    void * L_pointer; /* pointer */
    int L_pointer_suppliedQUERY; /* pointer-supplied? */
    long L_index; /* index */
    descriptor_t L_temp; /* temp */
    descriptor_t L_value; /* value */
    descriptor_t L_temp_2;
    descriptor_t L_temp_3;
    void * L_result0; /* result0 */
    descriptor_t L_temp_4;

    /* #line {Class <unknown-source-location>} */

    /* #line 126 "./cmp.dylan" */

    /* #line 209 "./num.dylan" */
    if (((A_nargs & 1) == 0)) {
	/* #line {Class <unknown-source-location>} */
	L_args = ((void *)(orig_sp - A_nargs));
	L_pointer = 0;
	L_pointer_suppliedQUERY = FALSE;
	L_index = (A_nargs - 2);
	while (1) {
	    if ((L_index < 0)) {
		goto block0;
	    }
	    else {
		L_temp = (((descriptor_t *)L_args)[L_index]);

		/* #line 386 "./condition.dylan" */
		if ((&dylanZdylan_visceraZCLS_symbol_HEAP == SLOT(L_temp.heapptr, heapptr_t, 0))) {
		    /* #line {Class <unknown-source-location>} */
		    L_value = (((descriptor_t *)L_args)[(L_index + 1)]);
		    if ((L_temp.heapptr == &SYM_pointer_HEAP)) {

			/* #line 386 "./condition.dylan" */
			if ((&dylanZdylan_visceraZCLS_raw_pointer_HEAP == SLOT(L_value.heapptr, heapptr_t, 0))) {
			    /* #line {Class <unknown-source-location>} */
			    L_pointer = L_value.dataword.ptr;
			    L_pointer_suppliedQUERY = TRUE;
			}
			else {

			    /* #line 389 "./condition.dylan" */
			    L_temp_2.heapptr = &networkZstr_ROOT;
			    L_temp_2.dataword.l = 0;
			    /* type-error-with-location */
			    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_value, &dylanZdylan_visceraZCLS_raw_pointer_HEAP, L_temp_2);
			    not_reached();
			}
		    }
		    /* #line {Class <unknown-source-location>} */
		    L_index = (L_index - 2);
		}
		else {

		    /* #line 389 "./condition.dylan" */
		    L_temp_3.heapptr = &networkZstr_ROOT;
		    L_temp_3.dataword.l = 0;
		    /* type-error-with-location */
		    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp, &dylanZdylan_visceraZCLS_symbol_HEAP, L_temp_3);
		    not_reached();
		}
	    }
	}
      block0:;
	/* #line {Class <unknown-source-location>} */
	orig_sp = L_args;
	/* maker for <_pthread-descr-struct> */
	L_result0 = networkZnetwork_internalZCLS_X_pthread_descr_struct_MAKER_FUN(orig_sp, L_pointer, L_pointer_suppliedQUERY);
	L_temp_4.heapptr = networkZliteral_28.heapptr;
	L_temp_4.dataword.ptr = L_result0;
	orig_sp[0] = L_temp_4;
	return orig_sp + 1;
    }
    else {
	/* odd-number-of-keyword/value-arguments-error */
	dylanZdylan_visceraZodd_number_of_keywordSLASHvalue_arguments_error_FUN(orig_sp);
	not_reached();
    }
}


/* Define Sealed Domain make (singleton(<_pthread-descr-struct>)) */


/* Define Method pointer-value{<_pthread-descr-struct>} */

extern struct heapobj networkZstr_ROOT_35;

/* pointer-value{<_pthread-descr-struct>} */
void * networkZnetwork_internalZpointer_value_METH_20(descriptor_t *orig_sp, void * A_value /* value */, heapptr_t A_next_method_info /* next-method-info */, heapptr_t A_rest /* rest */, descriptor_t A_index /* index */)
{
    descriptor_t *cluster_0_top;
    descriptor_t L_temp;
    descriptor_t L_arg1; /* arg1 */
    descriptor_t L_temp_2;
    descriptor_t L_temp_3; /* temp */
    descriptor_t L_temp_4;


    /* #line 1263 "./sockets-api.dylan" */
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = 0;
    orig_sp[0] = A_index;
    orig_sp[1] = L_temp;
    /* * */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZV_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_arg1 = (orig_sp == cluster_0_top ? dylanZfalse : orig_sp[0]);

    /* #line 1263 "./sockets-api.dylan" */
    L_temp_2.heapptr = networkZliteral_28.heapptr;
    L_temp_2.dataword.ptr = A_value;
    orig_sp[0] = L_temp_2;
    orig_sp[1] = L_arg1;
    /* + */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZPLUS_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_temp_3 = (orig_sp == cluster_0_top ? dylanZfalse : orig_sp[0]);

    /* #line 386 "./condition.dylan" */
    if ((&networkZnetwork_internalZCLS_X_pthread_descr_struct_HEAP == SLOT(L_temp_3.heapptr, heapptr_t, 0))) {

	/* #line 1263 "./sockets-api.dylan" */
	return L_temp_3.dataword.ptr;
    }
    else {

	/* #line 389 "./condition.dylan" */
	L_temp_4.heapptr = &networkZstr_ROOT_35;
	L_temp_4.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp_3, &networkZnetwork_internalZCLS_X_pthread_descr_struct_HEAP, L_temp_4);
	not_reached();
    }
}

/* generic-entry for pointer-value{<_pthread-descr-struct>} */
descriptor_t * networkZnetwork_internalZpointer_value_METH_GENERIC_20(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    descriptor_t L_arg; /* arg */
    heapptr_t L_rest; /* rest */
    void * L_arg_2; /* arg */
    descriptor_t L_index; /* index */
    long L_index_2; /* index */
    descriptor_t L_key; /* key */
    descriptor_t L_value; /* value */
    void * L_result0; /* result0 */
    descriptor_t L_temp;

    /* #line {Class <unknown-source-location>} */
    L_args = ((void *)(orig_sp - A_nargs));
    L_arg = (((descriptor_t *)L_args)[0]);
    L_rest = dylanZdylan_visceraZmake_rest_arg_FUN(orig_sp, (descriptor_t *)L_args + 1, A_nargs - 1);
    L_arg_2 = L_arg.dataword.ptr;
    L_index.heapptr = networkZliteral_2.heapptr;
    L_index.dataword.l = 0;
    L_index_2 = (A_nargs - 2);
    while (1) {
	if ((L_index_2 < 1)) {
	    goto block0;
	}
	else {
	    L_key = (((descriptor_t *)L_args)[L_index_2]);
	    L_value = (((descriptor_t *)L_args)[(L_index_2 + 1)]);
	    if ((L_key.heapptr == &SYM_index_HEAP)) {
		L_index = L_value;
	    }
	    L_index_2 = (L_index_2 - 2);
	}
    }
  block0:;
    orig_sp = L_args;
    /* pointer-value{<_pthread-descr-struct>} */
    L_result0 = networkZnetwork_internalZpointer_value_METH_20(orig_sp, L_arg_2, A_next_method_info, L_rest, L_index);
    L_temp.heapptr = networkZliteral_28.heapptr;
    L_temp.dataword.ptr = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* Define Method content-size{subclass(<_pthread-descr-struct>)} */

/* content-size{subclass(<_pthread-descr-struct>)} */
long networkZnetwork_internalZcontent_size_METH_26(descriptor_t *orig_sp, heapptr_t A0, heapptr_t A1)
{

    return 0;
}

/* generic-entry for content-size{subclass(<_pthread-descr-struct>)} */
descriptor_t * networkZnetwork_internalZcontent_size_METH_GENERIC_26(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    long L_result0; /* result0 */
    descriptor_t L_temp;

    orig_sp = ((void *)(orig_sp - 1));
    /* content-size{subclass(<_pthread-descr-struct>)} */
    L_result0 = networkZnetwork_internalZcontent_size_METH_26(orig_sp, &networkZnetwork_internalZCLS_X_pthread_descr_struct_HEAP, A_next_method_info);
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* Define Constant <_pthread-descr> */

/* <_pthread-descr> is <_pthread-descr-struct> */


/* Define Class <__sched-param> */

/* <__sched-param> is <__sched-param> */

extern struct heapobj networkZnetwork_internalZCLS_X_X_sched_param_HEAP;

/* maker for <__sched-param> */
void * networkZnetwork_internalZCLS_X_X_sched_param_MAKER_FUN(descriptor_t *orig_sp, void * A_pointer /* pointer */, int A_pointer_suppliedQUERY /* pointer-supplied? */)
{
    descriptor_t *cluster_0_top;


    /* #line 1272 "./sockets-api.dylan" */
    if (A_pointer_suppliedQUERY) {
	return A_pointer;
    }
    else {
	/* missing-required-init-keyword-error */
	dylanZdylan_visceraZmissing_required_init_keyword_error_FUN(orig_sp, &SYM_pointer_HEAP, &networkZnetwork_internalZCLS_X_X_sched_param_HEAP);
	not_reached();
    }
}

extern descriptor_t networkZliteral_29;	/* proxy for <__sched-param> */

/* general-entry for maker for <__sched-param> */
descriptor_t * networkZnetwork_internalZCLS_X_X_sched_param_MAKER_GENERAL(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    void * L_pointer; /* pointer */
    int L_pointer_suppliedQUERY; /* pointer-supplied? */
    long L_index; /* index */
    descriptor_t L_temp; /* temp */
    descriptor_t L_value; /* value */
    descriptor_t L_temp_2;
    descriptor_t L_temp_3;
    void * L_result0; /* result0 */
    descriptor_t L_temp_4;

    /* #line {Class <unknown-source-location>} */

    /* #line 126 "./cmp.dylan" */

    /* #line 209 "./num.dylan" */
    if (((A_nargs & 1) == 0)) {
	/* #line {Class <unknown-source-location>} */
	L_args = ((void *)(orig_sp - A_nargs));
	L_pointer = 0;
	L_pointer_suppliedQUERY = FALSE;
	L_index = (A_nargs - 2);
	while (1) {
	    if ((L_index < 0)) {
		goto block0;
	    }
	    else {
		L_temp = (((descriptor_t *)L_args)[L_index]);

		/* #line 386 "./condition.dylan" */
		if ((&dylanZdylan_visceraZCLS_symbol_HEAP == SLOT(L_temp.heapptr, heapptr_t, 0))) {
		    /* #line {Class <unknown-source-location>} */
		    L_value = (((descriptor_t *)L_args)[(L_index + 1)]);
		    if ((L_temp.heapptr == &SYM_pointer_HEAP)) {

			/* #line 386 "./condition.dylan" */
			if ((&dylanZdylan_visceraZCLS_raw_pointer_HEAP == SLOT(L_value.heapptr, heapptr_t, 0))) {
			    /* #line {Class <unknown-source-location>} */
			    L_pointer = L_value.dataword.ptr;
			    L_pointer_suppliedQUERY = TRUE;
			}
			else {

			    /* #line 389 "./condition.dylan" */
			    L_temp_2.heapptr = &networkZstr_ROOT;
			    L_temp_2.dataword.l = 0;
			    /* type-error-with-location */
			    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_value, &dylanZdylan_visceraZCLS_raw_pointer_HEAP, L_temp_2);
			    not_reached();
			}
		    }
		    /* #line {Class <unknown-source-location>} */
		    L_index = (L_index - 2);
		}
		else {

		    /* #line 389 "./condition.dylan" */
		    L_temp_3.heapptr = &networkZstr_ROOT;
		    L_temp_3.dataword.l = 0;
		    /* type-error-with-location */
		    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp, &dylanZdylan_visceraZCLS_symbol_HEAP, L_temp_3);
		    not_reached();
		}
	    }
	}
      block0:;
	/* #line {Class <unknown-source-location>} */
	orig_sp = L_args;
	/* maker for <__sched-param> */
	L_result0 = networkZnetwork_internalZCLS_X_X_sched_param_MAKER_FUN(orig_sp, L_pointer, L_pointer_suppliedQUERY);
	L_temp_4.heapptr = networkZliteral_29.heapptr;
	L_temp_4.dataword.ptr = L_result0;
	orig_sp[0] = L_temp_4;
	return orig_sp + 1;
    }
    else {
	/* odd-number-of-keyword/value-arguments-error */
	dylanZdylan_visceraZodd_number_of_keywordSLASHvalue_arguments_error_FUN(orig_sp);
	not_reached();
    }
}


/* Define Sealed Domain make (singleton(<__sched-param>)) */


/* {Implicit} Define Generic get-__sched-priority */

/* get-__sched-priority is get-__sched-priority */


/* Define Method get-__sched-priority{<__sched-param>} */

/* get-__sched-priority{<__sched-param>} */
long networkZnetwork_internalZget_X_X_sched_priority_METH(descriptor_t *orig_sp, void * A_ptr /* ptr */, heapptr_t A1)
{
    descriptor_t *cluster_0_top;


    /* #line 198 "./melange.dylan" */

    /* #line 91 "./rawptr.dylan" */
    return (*(long *)((char *)A_ptr + 0 ));
}


/* {Implicit} Define Generic get-__sched-priority-setter */

/* get-__sched-priority-setter is get-__sched-priority-setter */


/* Define Method get-__sched-priority-setter{<integer>, <__sched-param>} */

/* get-__sched-priority-setter{<integer>, <__sched-param>} */
long networkZnetwork_internalZget_X_X_sched_priority_setter_METH(descriptor_t *orig_sp, long A_value /* value */, void * A_ptr /* ptr */, heapptr_t A2)
{
    descriptor_t *cluster_0_top;

    /* #line {Class <unknown-source-location>} */

    /* #line 97 "./rawptr.dylan" */
    *(long *)((char *)A_ptr + 0) = A_value;
    return A_value;
}


/* Define Method pointer-value{<__sched-param>} */

extern struct heapobj networkZstr_ROOT_36;

/* pointer-value{<__sched-param>} */
void * networkZnetwork_internalZpointer_value_METH_21(descriptor_t *orig_sp, void * A_value /* value */, heapptr_t A_next_method_info /* next-method-info */, heapptr_t A_rest /* rest */, descriptor_t A_index /* index */)
{
    descriptor_t *cluster_0_top;
    descriptor_t L_temp;
    descriptor_t L_arg1; /* arg1 */
    descriptor_t L_temp_2;
    descriptor_t L_temp_3; /* temp */
    descriptor_t L_temp_4;

    /* #line {Class <unknown-source-location>} */

    /* #line 1288 "./sockets-api.dylan" */
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = 4;
    orig_sp[0] = A_index;
    orig_sp[1] = L_temp;
    /* * */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZV_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_arg1 = (orig_sp == cluster_0_top ? dylanZfalse : orig_sp[0]);

    /* #line 1288 "./sockets-api.dylan" */
    L_temp_2.heapptr = networkZliteral_29.heapptr;
    L_temp_2.dataword.ptr = A_value;
    orig_sp[0] = L_temp_2;
    orig_sp[1] = L_arg1;
    /* + */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZPLUS_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_temp_3 = (orig_sp == cluster_0_top ? dylanZfalse : orig_sp[0]);

    /* #line 386 "./condition.dylan" */
    if ((&networkZnetwork_internalZCLS_X_X_sched_param_HEAP == SLOT(L_temp_3.heapptr, heapptr_t, 0))) {

	/* #line 1288 "./sockets-api.dylan" */
	return L_temp_3.dataword.ptr;
    }
    else {

	/* #line 389 "./condition.dylan" */
	L_temp_4.heapptr = &networkZstr_ROOT_36;
	L_temp_4.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp_3, &networkZnetwork_internalZCLS_X_X_sched_param_HEAP, L_temp_4);
	not_reached();
    }
}

/* generic-entry for pointer-value{<__sched-param>} */
descriptor_t * networkZnetwork_internalZpointer_value_METH_GENERIC_21(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    descriptor_t L_arg; /* arg */
    heapptr_t L_rest; /* rest */
    void * L_arg_2; /* arg */
    descriptor_t L_index; /* index */
    long L_index_2; /* index */
    descriptor_t L_key; /* key */
    descriptor_t L_value; /* value */
    void * L_result0; /* result0 */
    descriptor_t L_temp;

    /* #line {Class <unknown-source-location>} */
    L_args = ((void *)(orig_sp - A_nargs));
    L_arg = (((descriptor_t *)L_args)[0]);
    L_rest = dylanZdylan_visceraZmake_rest_arg_FUN(orig_sp, (descriptor_t *)L_args + 1, A_nargs - 1);
    L_arg_2 = L_arg.dataword.ptr;
    L_index.heapptr = networkZliteral_2.heapptr;
    L_index.dataword.l = 0;
    L_index_2 = (A_nargs - 2);
    while (1) {
	if ((L_index_2 < 1)) {
	    goto block0;
	}
	else {
	    L_key = (((descriptor_t *)L_args)[L_index_2]);
	    L_value = (((descriptor_t *)L_args)[(L_index_2 + 1)]);
	    if ((L_key.heapptr == &SYM_index_HEAP)) {
		L_index = L_value;
	    }
	    L_index_2 = (L_index_2 - 2);
	}
    }
  block0:;
    orig_sp = L_args;
    /* pointer-value{<__sched-param>} */
    L_result0 = networkZnetwork_internalZpointer_value_METH_21(orig_sp, L_arg_2, A_next_method_info, L_rest, L_index);
    L_temp.heapptr = networkZliteral_29.heapptr;
    L_temp.dataword.ptr = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* Define Method content-size{subclass(<__sched-param>)} */

/* content-size{subclass(<__sched-param>)} */
long networkZnetwork_internalZcontent_size_METH_27(descriptor_t *orig_sp, heapptr_t A0, heapptr_t A1)
{

    return 4;
}

/* generic-entry for content-size{subclass(<__sched-param>)} */
descriptor_t * networkZnetwork_internalZcontent_size_METH_GENERIC_27(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    long L_result0; /* result0 */
    descriptor_t L_temp;

    orig_sp = ((void *)(orig_sp - 1));
    /* content-size{subclass(<__sched-param>)} */
    L_result0 = networkZnetwork_internalZcontent_size_METH_27(orig_sp, &networkZnetwork_internalZCLS_X_X_sched_param_HEAP, A_next_method_info);
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* Define Class <__pthread-attr-s> */

/* <__pthread-attr-s> is <__pthread-attr-s> */

extern struct heapobj networkZnetwork_internalZCLS_X_X_pthread_attr_s_HEAP;

/* maker for <__pthread-attr-s> */
void * networkZnetwork_internalZCLS_X_X_pthread_attr_s_MAKER_FUN(descriptor_t *orig_sp, void * A_pointer /* pointer */, int A_pointer_suppliedQUERY /* pointer-supplied? */)
{
    descriptor_t *cluster_0_top;


    /* #line 1295 "./sockets-api.dylan" */
    if (A_pointer_suppliedQUERY) {
	return A_pointer;
    }
    else {
	/* missing-required-init-keyword-error */
	dylanZdylan_visceraZmissing_required_init_keyword_error_FUN(orig_sp, &SYM_pointer_HEAP, &networkZnetwork_internalZCLS_X_X_pthread_attr_s_HEAP);
	not_reached();
    }
}

extern descriptor_t networkZliteral_30;	/* proxy for <__pthread-attr-s> */

/* general-entry for maker for <__pthread-attr-s> */
descriptor_t * networkZnetwork_internalZCLS_X_X_pthread_attr_s_MAKER_GENERAL(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    void * L_pointer; /* pointer */
    int L_pointer_suppliedQUERY; /* pointer-supplied? */
    long L_index; /* index */
    descriptor_t L_temp; /* temp */
    descriptor_t L_value; /* value */
    descriptor_t L_temp_2;
    descriptor_t L_temp_3;
    void * L_result0; /* result0 */
    descriptor_t L_temp_4;

    /* #line {Class <unknown-source-location>} */

    /* #line 126 "./cmp.dylan" */

    /* #line 209 "./num.dylan" */
    if (((A_nargs & 1) == 0)) {
	/* #line {Class <unknown-source-location>} */
	L_args = ((void *)(orig_sp - A_nargs));
	L_pointer = 0;
	L_pointer_suppliedQUERY = FALSE;
	L_index = (A_nargs - 2);
	while (1) {
	    if ((L_index < 0)) {
		goto block0;
	    }
	    else {
		L_temp = (((descriptor_t *)L_args)[L_index]);

		/* #line 386 "./condition.dylan" */
		if ((&dylanZdylan_visceraZCLS_symbol_HEAP == SLOT(L_temp.heapptr, heapptr_t, 0))) {
		    /* #line {Class <unknown-source-location>} */
		    L_value = (((descriptor_t *)L_args)[(L_index + 1)]);
		    if ((L_temp.heapptr == &SYM_pointer_HEAP)) {

			/* #line 386 "./condition.dylan" */
			if ((&dylanZdylan_visceraZCLS_raw_pointer_HEAP == SLOT(L_value.heapptr, heapptr_t, 0))) {
			    /* #line {Class <unknown-source-location>} */
			    L_pointer = L_value.dataword.ptr;
			    L_pointer_suppliedQUERY = TRUE;
			}
			else {

			    /* #line 389 "./condition.dylan" */
			    L_temp_2.heapptr = &networkZstr_ROOT;
			    L_temp_2.dataword.l = 0;
			    /* type-error-with-location */
			    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_value, &dylanZdylan_visceraZCLS_raw_pointer_HEAP, L_temp_2);
			    not_reached();
			}
		    }
		    /* #line {Class <unknown-source-location>} */
		    L_index = (L_index - 2);
		}
		else {

		    /* #line 389 "./condition.dylan" */
		    L_temp_3.heapptr = &networkZstr_ROOT;
		    L_temp_3.dataword.l = 0;
		    /* type-error-with-location */
		    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp, &dylanZdylan_visceraZCLS_symbol_HEAP, L_temp_3);
		    not_reached();
		}
	    }
	}
      block0:;
	/* #line {Class <unknown-source-location>} */
	orig_sp = L_args;
	/* maker for <__pthread-attr-s> */
	L_result0 = networkZnetwork_internalZCLS_X_X_pthread_attr_s_MAKER_FUN(orig_sp, L_pointer, L_pointer_suppliedQUERY);
	L_temp_4.heapptr = networkZliteral_30.heapptr;
	L_temp_4.dataword.ptr = L_result0;
	orig_sp[0] = L_temp_4;
	return orig_sp + 1;
    }
    else {
	/* odd-number-of-keyword/value-arguments-error */
	dylanZdylan_visceraZodd_number_of_keywordSLASHvalue_arguments_error_FUN(orig_sp);
	not_reached();
    }
}


/* Define Sealed Domain make (singleton(<__pthread-attr-s>)) */


/* {Implicit} Define Generic get-__detachstate */

/* get-__detachstate is get-__detachstate */


/* Define Method get-__detachstate{<__pthread-attr-s>} */

/* get-__detachstate{<__pthread-attr-s>} */
long networkZnetwork_internalZget_X_X_detachstate_METH(descriptor_t *orig_sp, void * A_ptr /* ptr */, heapptr_t A1)
{
    descriptor_t *cluster_0_top;


    /* #line 198 "./melange.dylan" */

    /* #line 91 "./rawptr.dylan" */
    return (*(long *)((char *)A_ptr + 0 ));
}


/* {Implicit} Define Generic get-__detachstate-setter */

/* get-__detachstate-setter is get-__detachstate-setter */


/* Define Method get-__detachstate-setter{<integer>, <__pthread-attr-s>} */

/* get-__detachstate-setter{<integer>, <__pthread-attr-s>} */
long networkZnetwork_internalZget_X_X_detachstate_setter_METH(descriptor_t *orig_sp, long A_value /* value */, void * A_ptr /* ptr */, heapptr_t A2)
{
    descriptor_t *cluster_0_top;

    /* #line {Class <unknown-source-location>} */

    /* #line 97 "./rawptr.dylan" */
    *(long *)((char *)A_ptr + 0) = A_value;
    return A_value;
}


/* {Implicit} Define Generic get-__schedpolicy */

/* get-__schedpolicy is get-__schedpolicy */


/* Define Method get-__schedpolicy{<__pthread-attr-s>} */

/* get-__schedpolicy{<__pthread-attr-s>} */
long networkZnetwork_internalZget_X_X_schedpolicy_METH(descriptor_t *orig_sp, void * A_ptr /* ptr */, heapptr_t A1)
{
    descriptor_t *cluster_0_top;

    /* #line {Class <unknown-source-location>} */

    /* #line 198 "./melange.dylan" */

    /* #line 91 "./rawptr.dylan" */
    return (*(long *)((char *)A_ptr + 4 ));
}


/* {Implicit} Define Generic get-__schedpolicy-setter */

/* get-__schedpolicy-setter is get-__schedpolicy-setter */


/* Define Method get-__schedpolicy-setter{<integer>, <__pthread-attr-s>} */

/* get-__schedpolicy-setter{<integer>, <__pthread-attr-s>} */
long networkZnetwork_internalZget_X_X_schedpolicy_setter_METH(descriptor_t *orig_sp, long A_value /* value */, void * A_ptr /* ptr */, heapptr_t A2)
{
    descriptor_t *cluster_0_top;

    /* #line {Class <unknown-source-location>} */

    /* #line 97 "./rawptr.dylan" */
    *(long *)((char *)A_ptr + 4) = A_value;
    return A_value;
}


/* {Implicit} Define Generic get-__schedparam */

/* get-__schedparam is get-__schedparam */


/* Define Method get-__schedparam{<__pthread-attr-s>} */

extern struct heapobj networkZstr_ROOT_37;

/* get-__schedparam{<__pthread-attr-s>} */
void * networkZnetwork_internalZget_X_X_schedparam_METH(descriptor_t *orig_sp, void * A_ptr /* ptr */, heapptr_t A1)
{
    descriptor_t *cluster_0_top;
    descriptor_t L_temp;
    descriptor_t L_temp_2;
    descriptor_t L_temp_3;
    descriptor_t L_temp_4; /* temp */
    int L_condition; /* condition */
    descriptor_t L_temp_5;
    descriptor_t L_temp_6; /* temp */
    descriptor_t L_temp_7;
    descriptor_t L_temp_8;

    /* #line {Class <unknown-source-location>} */

    /* #line 49 "./object.dylan" */
    L_temp.heapptr = networkZliteral_30.heapptr;
    L_temp.dataword.ptr = A_ptr;

    /* #line 324 "./melange.dylan" */

    /* #line 324 "./melange.dylan" */

    /* #line 324 "./melange.dylan" */
    L_temp_2.heapptr = SLOT(L_temp.heapptr, heapptr_t, 0);
    L_temp_2.dataword.l = 0;
    L_temp_3.heapptr = networkZliteral_6.heapptr;
    L_temp_3.dataword.ptr = ((void *)((char *)A_ptr + 8));
    orig_sp[0] = L_temp_2;
    orig_sp[1] = L_temp_3;
    /* as */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZas_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_temp_4 = orig_sp[0];

    /* #line 49 "./object.dylan" */

    /* #line 386 "./condition.dylan" */
    /* %subtype?{<class>, <class>} */
    L_condition = dylanZdylan_visceraZPCTsubtypeQUERY_METH(orig_sp, SLOT(L_temp_4.heapptr, heapptr_t, 0), &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP, &dylanZliteral_ROOT_2);
    if (L_condition) {

	/* #line 324 "./melange.dylan" */

	/* #line 1323 "./sockets-api.dylan" */
	L_temp_5.heapptr = &networkZnetwork_internalZCLS_X_X_sched_param_HEAP;
	L_temp_5.dataword.l = 0;
	orig_sp[0] = L_temp_5;
	orig_sp[1] = L_temp_4;
	/* as */
	{
	  struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZas_HEAP, 2);
	  heapptr_t L_meth = L_temp.R0;
	  heapptr_t L_next_info = L_temp.R1;
	  cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
	}
	L_temp_6 = orig_sp[0];

	/* #line 386 "./condition.dylan" */
	if ((&networkZnetwork_internalZCLS_X_X_sched_param_HEAP == SLOT(L_temp_6.heapptr, heapptr_t, 0))) {

	    /* #line 1323 "./sockets-api.dylan" */
	    return L_temp_6.dataword.ptr;
	}
	else {

	    /* #line 389 "./condition.dylan" */
	    L_temp_7.heapptr = &networkZstr_ROOT_37;
	    L_temp_7.dataword.l = 0;
	    /* type-error-with-location */
	    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp_6, &networkZnetwork_internalZCLS_X_X_sched_param_HEAP, L_temp_7);
	    not_reached();
	}
    }
    else {
	L_temp_8.heapptr = &networkZstr_ROOT_5;
	L_temp_8.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp_4, &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP, L_temp_8);
	not_reached();
    }
}


/* {Implicit} Define Generic get-__inheritsched */

/* get-__inheritsched is get-__inheritsched */


/* Define Method get-__inheritsched{<__pthread-attr-s>} */

/* get-__inheritsched{<__pthread-attr-s>} */
long networkZnetwork_internalZget_X_X_inheritsched_METH(descriptor_t *orig_sp, void * A_ptr /* ptr */, heapptr_t A1)
{
    descriptor_t *cluster_0_top;

    /* #line {Class <unknown-source-location>} */

    /* #line 198 "./melange.dylan" */

    /* #line 91 "./rawptr.dylan" */
    return (*(long *)((char *)A_ptr + 12 ));
}


/* {Implicit} Define Generic get-__inheritsched-setter */

/* get-__inheritsched-setter is get-__inheritsched-setter */


/* Define Method get-__inheritsched-setter{<integer>, <__pthread-attr-s>} */

/* get-__inheritsched-setter{<integer>, <__pthread-attr-s>} */
long networkZnetwork_internalZget_X_X_inheritsched_setter_METH(descriptor_t *orig_sp, long A_value /* value */, void * A_ptr /* ptr */, heapptr_t A2)
{
    descriptor_t *cluster_0_top;

    /* #line {Class <unknown-source-location>} */

    /* #line 97 "./rawptr.dylan" */
    *(long *)((char *)A_ptr + 12) = A_value;
    return A_value;
}


/* {Implicit} Define Generic get-__scope */

/* get-__scope is get-__scope */


/* Define Method get-__scope{<__pthread-attr-s>} */

/* get-__scope{<__pthread-attr-s>} */
long networkZnetwork_internalZget_X_X_scope_METH(descriptor_t *orig_sp, void * A_ptr /* ptr */, heapptr_t A1)
{
    descriptor_t *cluster_0_top;

    /* #line {Class <unknown-source-location>} */

    /* #line 198 "./melange.dylan" */

    /* #line 91 "./rawptr.dylan" */
    return (*(long *)((char *)A_ptr + 16 ));
}


/* {Implicit} Define Generic get-__scope-setter */

/* get-__scope-setter is get-__scope-setter */


/* Define Method get-__scope-setter{<integer>, <__pthread-attr-s>} */

/* get-__scope-setter{<integer>, <__pthread-attr-s>} */
long networkZnetwork_internalZget_X_X_scope_setter_METH(descriptor_t *orig_sp, long A_value /* value */, void * A_ptr /* ptr */, heapptr_t A2)
{
    descriptor_t *cluster_0_top;

    /* #line {Class <unknown-source-location>} */

    /* #line 97 "./rawptr.dylan" */
    *(long *)((char *)A_ptr + 16) = A_value;
    return A_value;
}


/* {Implicit} Define Generic get-__guardsize */

/* get-__guardsize is get-__guardsize */


/* Define Method get-__guardsize{<__pthread-attr-s>} */

/* get-__guardsize{<__pthread-attr-s>} */
long networkZnetwork_internalZget_X_X_guardsize_METH(descriptor_t *orig_sp, void * A_ptr /* ptr */, heapptr_t A1)
{
    descriptor_t *cluster_0_top;

    /* #line {Class <unknown-source-location>} */

    /* #line 211 "./melange.dylan" */

    /* #line 91 "./rawptr.dylan" */
    return (*(long *)((char *)A_ptr + 20 ));
}


/* {Implicit} Define Generic get-__guardsize-setter */

/* get-__guardsize-setter is get-__guardsize-setter */


/* Define Method get-__guardsize-setter{<integer>, <__pthread-attr-s>} */

/* get-__guardsize-setter{<integer>, <__pthread-attr-s>} */
long networkZnetwork_internalZget_X_X_guardsize_setter_METH(descriptor_t *orig_sp, long A_value /* value */, void * A_ptr /* ptr */, heapptr_t A2)
{
    descriptor_t *cluster_0_top;

    /* #line {Class <unknown-source-location>} */

    /* #line 97 "./rawptr.dylan" */
    *(long *)((char *)A_ptr + 20) = A_value;
    return A_value;
}


/* {Implicit} Define Generic get-__stackaddr-set */

/* get-__stackaddr-set is get-__stackaddr-set */


/* Define Method get-__stackaddr-set{<__pthread-attr-s>} */

/* get-__stackaddr-set{<__pthread-attr-s>} */
long networkZnetwork_internalZget_X_X_stackaddr_set_METH(descriptor_t *orig_sp, void * A_ptr /* ptr */, heapptr_t A1)
{
    descriptor_t *cluster_0_top;

    /* #line {Class <unknown-source-location>} */

    /* #line 198 "./melange.dylan" */

    /* #line 91 "./rawptr.dylan" */
    return (*(long *)((char *)A_ptr + 24 ));
}


/* {Implicit} Define Generic get-__stackaddr-set-setter */

/* get-__stackaddr-set-setter is get-__stackaddr-set-setter */


/* Define Method get-__stackaddr-set-setter{<integer>, <__pthread-attr-s>} */

/* get-__stackaddr-set-setter{<integer>, <__pthread-attr-s>} */
long networkZnetwork_internalZget_X_X_stackaddr_set_setter_METH(descriptor_t *orig_sp, long A_value /* value */, void * A_ptr /* ptr */, heapptr_t A2)
{
    descriptor_t *cluster_0_top;

    /* #line {Class <unknown-source-location>} */

    /* #line 97 "./rawptr.dylan" */
    *(long *)((char *)A_ptr + 24) = A_value;
    return A_value;
}


/* {Implicit} Define Generic get-__stackaddr */

/* get-__stackaddr is get-__stackaddr */


/* Define Method get-__stackaddr{<__pthread-attr-s>} */

extern struct heapobj networkZstr_ROOT_38;

/* get-__stackaddr{<__pthread-attr-s>} */
void * networkZnetwork_internalZget_X_X_stackaddr_METH(descriptor_t *orig_sp, void * A_ptr /* ptr */, heapptr_t A1)
{
    descriptor_t *cluster_0_top;
    descriptor_t L_temp;
    descriptor_t L_temp_2;
    descriptor_t L_temp_3; /* temp */
    int L_condition; /* condition */
    descriptor_t L_result; /* result */
    descriptor_t L_temp_4;
    descriptor_t L_temp_5;

    /* #line {Class <unknown-source-location>} */

    /* #line 290 "./melange.dylan" */

    /* #line 91 "./rawptr.dylan" */

    /* #line 290 "./melange.dylan" */
    L_temp.heapptr = &melange_supportZmelange_supportZCLS_machine_pointer_HEAP;
    L_temp.dataword.l = 0;
    L_temp_2.heapptr = networkZliteral_6.heapptr;
    L_temp_2.dataword.ptr = (*(void * *)((char *)A_ptr + 28 ));
    orig_sp[0] = L_temp;
    orig_sp[1] = L_temp_2;
    /* as */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZas_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_temp_3 = orig_sp[0];

    /* #line 49 "./object.dylan" */

    /* #line 386 "./condition.dylan" */
    /* %subtype?{<class>, <class>} */
    L_condition = dylanZdylan_visceraZPCTsubtypeQUERY_METH(orig_sp, SLOT(L_temp_3.heapptr, heapptr_t, 0), &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP, &dylanZliteral_ROOT_2);
    if (L_condition) {

	/* #line 290 "./melange.dylan" */
	L_result = L_temp_3;

	/* #line 386 "./condition.dylan" */
	if ((&melange_supportZmelange_supportZCLS_machine_pointer_HEAP == SLOT(L_result.heapptr, heapptr_t, 0))) {

	    /* #line 1372 "./sockets-api.dylan" */
	    return L_result.dataword.ptr;
	}
	else {

	    /* #line 389 "./condition.dylan" */
	    L_temp_4.heapptr = &networkZstr_ROOT_38;
	    L_temp_4.dataword.l = 0;
	    /* type-error-with-location */
	    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_result, &melange_supportZmelange_supportZCLS_machine_pointer_HEAP, L_temp_4);
	    not_reached();
	}
    }
    else {
	L_temp_5.heapptr = &networkZstr_ROOT_14;
	L_temp_5.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp_3, &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP, L_temp_5);
	not_reached();
    }
}


/* {Implicit} Define Generic get-__stackaddr-setter */

/* get-__stackaddr-setter is get-__stackaddr-setter */


/* Define Method get-__stackaddr-setter{<machine-pointer>, <__pthread-attr-s>} */

/* get-__stackaddr-setter{<machine-pointer>, <__pthread-attr-s>} */
void * networkZnetwork_internalZget_X_X_stackaddr_setter_METH(descriptor_t *orig_sp, void * A_value /* value */, void * A_ptr /* ptr */, heapptr_t A2)
{
    descriptor_t *cluster_0_top;

    /* #line {Class <unknown-source-location>} */

    /* #line 299 "./melange.dylan" */
    /* #line {Class <unknown-source-location>} */

    /* #line 97 "./rawptr.dylan" */
    *(void * *)((char *)A_ptr + 28) = A_value;
    return A_value;
}


/* {Implicit} Define Generic get-__stacksize */

/* get-__stacksize is get-__stacksize */


/* Define Method get-__stacksize{<__pthread-attr-s>} */

/* get-__stacksize{<__pthread-attr-s>} */
long networkZnetwork_internalZget_X_X_stacksize_METH(descriptor_t *orig_sp, void * A_ptr /* ptr */, heapptr_t A1)
{
    descriptor_t *cluster_0_top;

    /* #line {Class <unknown-source-location>} */

    /* #line 211 "./melange.dylan" */

    /* #line 91 "./rawptr.dylan" */
    return (*(long *)((char *)A_ptr + 32 ));
}


/* {Implicit} Define Generic get-__stacksize-setter */

/* get-__stacksize-setter is get-__stacksize-setter */


/* Define Method get-__stacksize-setter{<integer>, <__pthread-attr-s>} */

/* get-__stacksize-setter{<integer>, <__pthread-attr-s>} */
long networkZnetwork_internalZget_X_X_stacksize_setter_METH(descriptor_t *orig_sp, long A_value /* value */, void * A_ptr /* ptr */, heapptr_t A2)
{
    descriptor_t *cluster_0_top;

    /* #line {Class <unknown-source-location>} */

    /* #line 97 "./rawptr.dylan" */
    *(long *)((char *)A_ptr + 32) = A_value;
    return A_value;
}


/* Define Method pointer-value{<__pthread-attr-s>} */

extern struct heapobj networkZstr_ROOT_39;

/* pointer-value{<__pthread-attr-s>} */
void * networkZnetwork_internalZpointer_value_METH_22(descriptor_t *orig_sp, void * A_value /* value */, heapptr_t A_next_method_info /* next-method-info */, heapptr_t A_rest /* rest */, descriptor_t A_index /* index */)
{
    descriptor_t *cluster_0_top;
    descriptor_t L_temp;
    descriptor_t L_arg1; /* arg1 */
    descriptor_t L_temp_2;
    descriptor_t L_temp_3; /* temp */
    descriptor_t L_temp_4;

    /* #line {Class <unknown-source-location>} */

    /* #line 1393 "./sockets-api.dylan" */
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = 36;
    orig_sp[0] = A_index;
    orig_sp[1] = L_temp;
    /* * */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZV_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_arg1 = (orig_sp == cluster_0_top ? dylanZfalse : orig_sp[0]);

    /* #line 1393 "./sockets-api.dylan" */
    L_temp_2.heapptr = networkZliteral_30.heapptr;
    L_temp_2.dataword.ptr = A_value;
    orig_sp[0] = L_temp_2;
    orig_sp[1] = L_arg1;
    /* + */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZPLUS_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_temp_3 = (orig_sp == cluster_0_top ? dylanZfalse : orig_sp[0]);

    /* #line 386 "./condition.dylan" */
    if ((&networkZnetwork_internalZCLS_X_X_pthread_attr_s_HEAP == SLOT(L_temp_3.heapptr, heapptr_t, 0))) {

	/* #line 1393 "./sockets-api.dylan" */
	return L_temp_3.dataword.ptr;
    }
    else {

	/* #line 389 "./condition.dylan" */
	L_temp_4.heapptr = &networkZstr_ROOT_39;
	L_temp_4.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp_3, &networkZnetwork_internalZCLS_X_X_pthread_attr_s_HEAP, L_temp_4);
	not_reached();
    }
}

/* generic-entry for pointer-value{<__pthread-attr-s>} */
descriptor_t * networkZnetwork_internalZpointer_value_METH_GENERIC_22(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    descriptor_t L_arg; /* arg */
    heapptr_t L_rest; /* rest */
    void * L_arg_2; /* arg */
    descriptor_t L_index; /* index */
    long L_index_2; /* index */
    descriptor_t L_key; /* key */
    descriptor_t L_value; /* value */
    void * L_result0; /* result0 */
    descriptor_t L_temp;

    /* #line {Class <unknown-source-location>} */
    L_args = ((void *)(orig_sp - A_nargs));
    L_arg = (((descriptor_t *)L_args)[0]);
    L_rest = dylanZdylan_visceraZmake_rest_arg_FUN(orig_sp, (descriptor_t *)L_args + 1, A_nargs - 1);
    L_arg_2 = L_arg.dataword.ptr;
    L_index.heapptr = networkZliteral_2.heapptr;
    L_index.dataword.l = 0;
    L_index_2 = (A_nargs - 2);
    while (1) {
	if ((L_index_2 < 1)) {
	    goto block0;
	}
	else {
	    L_key = (((descriptor_t *)L_args)[L_index_2]);
	    L_value = (((descriptor_t *)L_args)[(L_index_2 + 1)]);
	    if ((L_key.heapptr == &SYM_index_HEAP)) {
		L_index = L_value;
	    }
	    L_index_2 = (L_index_2 - 2);
	}
    }
  block0:;
    orig_sp = L_args;
    /* pointer-value{<__pthread-attr-s>} */
    L_result0 = networkZnetwork_internalZpointer_value_METH_22(orig_sp, L_arg_2, A_next_method_info, L_rest, L_index);
    L_temp.heapptr = networkZliteral_30.heapptr;
    L_temp.dataword.ptr = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* Define Method content-size{subclass(<__pthread-attr-s>)} */

/* content-size{subclass(<__pthread-attr-s>)} */
long networkZnetwork_internalZcontent_size_METH_28(descriptor_t *orig_sp, heapptr_t A0, heapptr_t A1)
{

    return 36;
}

/* generic-entry for content-size{subclass(<__pthread-attr-s>)} */
descriptor_t * networkZnetwork_internalZcontent_size_METH_GENERIC_28(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    long L_result0; /* result0 */
    descriptor_t L_temp;

    orig_sp = ((void *)(orig_sp - 1));
    /* content-size{subclass(<__pthread-attr-s>)} */
    L_result0 = networkZnetwork_internalZcontent_size_METH_28(orig_sp, &networkZnetwork_internalZCLS_X_X_pthread_attr_s_HEAP, A_next_method_info);
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* Define Constant <pthread-attr-t> */

/* <pthread-attr-t> is <__pthread-attr-s> */


/* Define Class <pthread-cond-t> */

/* <pthread-cond-t> is <pthread-cond-t> */

extern struct heapobj networkZnetwork_internalZCLS_pthread_cond_t_HEAP;

/* maker for <pthread-cond-t> */
void * networkZnetwork_internalZCLS_pthread_cond_t_MAKER_FUN(descriptor_t *orig_sp, void * A_pointer /* pointer */, int A_pointer_suppliedQUERY /* pointer-supplied? */)
{
    descriptor_t *cluster_0_top;


    /* #line 1402 "./sockets-api.dylan" */
    if (A_pointer_suppliedQUERY) {
	return A_pointer;
    }
    else {
	/* missing-required-init-keyword-error */
	dylanZdylan_visceraZmissing_required_init_keyword_error_FUN(orig_sp, &SYM_pointer_HEAP, &networkZnetwork_internalZCLS_pthread_cond_t_HEAP);
	not_reached();
    }
}

extern descriptor_t networkZliteral_31;	/* proxy for <pthread-cond-t> */

/* general-entry for maker for <pthread-cond-t> */
descriptor_t * networkZnetwork_internalZCLS_pthread_cond_t_MAKER_GENERAL(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    void * L_pointer; /* pointer */
    int L_pointer_suppliedQUERY; /* pointer-supplied? */
    long L_index; /* index */
    descriptor_t L_temp; /* temp */
    descriptor_t L_value; /* value */
    descriptor_t L_temp_2;
    descriptor_t L_temp_3;
    void * L_result0; /* result0 */
    descriptor_t L_temp_4;

    /* #line {Class <unknown-source-location>} */

    /* #line 126 "./cmp.dylan" */

    /* #line 209 "./num.dylan" */
    if (((A_nargs & 1) == 0)) {
	/* #line {Class <unknown-source-location>} */
	L_args = ((void *)(orig_sp - A_nargs));
	L_pointer = 0;
	L_pointer_suppliedQUERY = FALSE;
	L_index = (A_nargs - 2);
	while (1) {
	    if ((L_index < 0)) {
		goto block0;
	    }
	    else {
		L_temp = (((descriptor_t *)L_args)[L_index]);

		/* #line 386 "./condition.dylan" */
		if ((&dylanZdylan_visceraZCLS_symbol_HEAP == SLOT(L_temp.heapptr, heapptr_t, 0))) {
		    /* #line {Class <unknown-source-location>} */
		    L_value = (((descriptor_t *)L_args)[(L_index + 1)]);
		    if ((L_temp.heapptr == &SYM_pointer_HEAP)) {

			/* #line 386 "./condition.dylan" */
			if ((&dylanZdylan_visceraZCLS_raw_pointer_HEAP == SLOT(L_value.heapptr, heapptr_t, 0))) {
			    /* #line {Class <unknown-source-location>} */
			    L_pointer = L_value.dataword.ptr;
			    L_pointer_suppliedQUERY = TRUE;
			}
			else {

			    /* #line 389 "./condition.dylan" */
			    L_temp_2.heapptr = &networkZstr_ROOT;
			    L_temp_2.dataword.l = 0;
			    /* type-error-with-location */
			    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_value, &dylanZdylan_visceraZCLS_raw_pointer_HEAP, L_temp_2);
			    not_reached();
			}
		    }
		    /* #line {Class <unknown-source-location>} */
		    L_index = (L_index - 2);
		}
		else {

		    /* #line 389 "./condition.dylan" */
		    L_temp_3.heapptr = &networkZstr_ROOT;
		    L_temp_3.dataword.l = 0;
		    /* type-error-with-location */
		    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp, &dylanZdylan_visceraZCLS_symbol_HEAP, L_temp_3);
		    not_reached();
		}
	    }
	}
      block0:;
	/* #line {Class <unknown-source-location>} */
	orig_sp = L_args;
	/* maker for <pthread-cond-t> */
	L_result0 = networkZnetwork_internalZCLS_pthread_cond_t_MAKER_FUN(orig_sp, L_pointer, L_pointer_suppliedQUERY);
	L_temp_4.heapptr = networkZliteral_31.heapptr;
	L_temp_4.dataword.ptr = L_result0;
	orig_sp[0] = L_temp_4;
	return orig_sp + 1;
    }
    else {
	/* odd-number-of-keyword/value-arguments-error */
	dylanZdylan_visceraZodd_number_of_keywordSLASHvalue_arguments_error_FUN(orig_sp);
	not_reached();
    }
}


/* Define Sealed Domain make (singleton(<pthread-cond-t>)) */


/* {Implicit} Define Generic get-__c-lock */

/* get-__c-lock is get-__c-lock */


/* Define Method get-__c-lock{<pthread-cond-t>} */

extern struct heapobj networkZstr_ROOT_40;

/* get-__c-lock{<pthread-cond-t>} */
void * networkZnetwork_internalZget_X_X_c_lock_METH(descriptor_t *orig_sp, void * A_ptr /* ptr */, heapptr_t A1)
{
    descriptor_t *cluster_0_top;
    descriptor_t L_temp;
    descriptor_t L_temp_2;
    descriptor_t L_temp_3;
    descriptor_t L_temp_4; /* temp */
    int L_condition; /* condition */
    descriptor_t L_temp_5;
    descriptor_t L_temp_6; /* temp */
    descriptor_t L_temp_7;
    descriptor_t L_temp_8;


    /* #line 49 "./object.dylan" */
    L_temp.heapptr = networkZliteral_31.heapptr;
    L_temp.dataword.ptr = A_ptr;

    /* #line 324 "./melange.dylan" */

    /* #line 324 "./melange.dylan" */

    /* #line 324 "./melange.dylan" */
    L_temp_2.heapptr = SLOT(L_temp.heapptr, heapptr_t, 0);
    L_temp_2.dataword.l = 0;
    L_temp_3.heapptr = networkZliteral_6.heapptr;
    L_temp_3.dataword.ptr = ((void *)((char *)A_ptr + 0));
    orig_sp[0] = L_temp_2;
    orig_sp[1] = L_temp_3;
    /* as */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZas_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_temp_4 = orig_sp[0];

    /* #line 49 "./object.dylan" */

    /* #line 386 "./condition.dylan" */
    /* %subtype?{<class>, <class>} */
    L_condition = dylanZdylan_visceraZPCTsubtypeQUERY_METH(orig_sp, SLOT(L_temp_4.heapptr, heapptr_t, 0), &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP, &dylanZliteral_ROOT_2);
    if (L_condition) {

	/* #line 324 "./melange.dylan" */

	/* #line 1408 "./sockets-api.dylan" */
	L_temp_5.heapptr = &networkZnetwork_internalZCLS_X_pthread_fastlock_HEAP;
	L_temp_5.dataword.l = 0;
	orig_sp[0] = L_temp_5;
	orig_sp[1] = L_temp_4;
	/* as */
	{
	  struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZas_HEAP, 2);
	  heapptr_t L_meth = L_temp.R0;
	  heapptr_t L_next_info = L_temp.R1;
	  cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
	}
	L_temp_6 = orig_sp[0];

	/* #line 386 "./condition.dylan" */
	if ((&networkZnetwork_internalZCLS_X_pthread_fastlock_HEAP == SLOT(L_temp_6.heapptr, heapptr_t, 0))) {

	    /* #line 1408 "./sockets-api.dylan" */
	    return L_temp_6.dataword.ptr;
	}
	else {

	    /* #line 389 "./condition.dylan" */
	    L_temp_7.heapptr = &networkZstr_ROOT_40;
	    L_temp_7.dataword.l = 0;
	    /* type-error-with-location */
	    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp_6, &networkZnetwork_internalZCLS_X_pthread_fastlock_HEAP, L_temp_7);
	    not_reached();
	}
    }
    else {
	L_temp_8.heapptr = &networkZstr_ROOT_5;
	L_temp_8.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp_4, &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP, L_temp_8);
	not_reached();
    }
}


/* {Implicit} Define Generic get-__c-waiting */

/* get-__c-waiting is get-__c-waiting */


/* Define Method get-__c-waiting{<pthread-cond-t>} */

extern struct heapobj networkZstr_ROOT_41;

/* get-__c-waiting{<pthread-cond-t>} */
void * networkZnetwork_internalZget_X_X_c_waiting_METH(descriptor_t *orig_sp, void * A_ptr /* ptr */, heapptr_t A1)
{
    descriptor_t *cluster_0_top;
    descriptor_t L_temp;
    descriptor_t L_temp_2;
    descriptor_t L_temp_3; /* temp */
    int L_condition; /* condition */
    descriptor_t L_result; /* result */
    descriptor_t L_temp_4;
    descriptor_t L_temp_5;

    /* #line {Class <unknown-source-location>} */

    /* #line 290 "./melange.dylan" */

    /* #line 91 "./rawptr.dylan" */

    /* #line 290 "./melange.dylan" */
    L_temp.heapptr = &networkZnetwork_internalZCLS_X_pthread_descr_struct_HEAP;
    L_temp.dataword.l = 0;
    L_temp_2.heapptr = networkZliteral_6.heapptr;
    L_temp_2.dataword.ptr = (*(void * *)((char *)A_ptr + 8 ));
    orig_sp[0] = L_temp;
    orig_sp[1] = L_temp_2;
    /* as */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZas_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_temp_3 = orig_sp[0];

    /* #line 49 "./object.dylan" */

    /* #line 386 "./condition.dylan" */
    /* %subtype?{<class>, <class>} */
    L_condition = dylanZdylan_visceraZPCTsubtypeQUERY_METH(orig_sp, SLOT(L_temp_3.heapptr, heapptr_t, 0), &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP, &dylanZliteral_ROOT_2);
    if (L_condition) {

	/* #line 290 "./melange.dylan" */
	L_result = L_temp_3;

	/* #line 386 "./condition.dylan" */
	if ((&networkZnetwork_internalZCLS_X_pthread_descr_struct_HEAP == SLOT(L_result.heapptr, heapptr_t, 0))) {

	    /* #line 1413 "./sockets-api.dylan" */
	    return L_result.dataword.ptr;
	}
	else {

	    /* #line 389 "./condition.dylan" */
	    L_temp_4.heapptr = &networkZstr_ROOT_41;
	    L_temp_4.dataword.l = 0;
	    /* type-error-with-location */
	    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_result, &networkZnetwork_internalZCLS_X_pthread_descr_struct_HEAP, L_temp_4);
	    not_reached();
	}
    }
    else {
	L_temp_5.heapptr = &networkZstr_ROOT_14;
	L_temp_5.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp_3, &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP, L_temp_5);
	not_reached();
    }
}


/* {Implicit} Define Generic get-__c-waiting-setter */

/* get-__c-waiting-setter is get-__c-waiting-setter */


/* Define Method get-__c-waiting-setter{<_pthread-descr-struct>, <pthread-cond-t>} */

/* get-__c-waiting-setter{<_pthread-descr-struct>, <pthread-cond-t>} */
void * networkZnetwork_internalZget_X_X_c_waiting_setter_METH(descriptor_t *orig_sp, void * A_value /* value */, void * A_ptr /* ptr */, heapptr_t A2)
{
    descriptor_t *cluster_0_top;

    /* #line {Class <unknown-source-location>} */

    /* #line 299 "./melange.dylan" */
    /* #line {Class <unknown-source-location>} */

    /* #line 97 "./rawptr.dylan" */
    *(void * *)((char *)A_ptr + 8) = A_value;
    return A_value;
}


/* Define Method pointer-value{<pthread-cond-t>} */

extern struct heapobj networkZstr_ROOT_42;

/* pointer-value{<pthread-cond-t>} */
void * networkZnetwork_internalZpointer_value_METH_23(descriptor_t *orig_sp, void * A_value /* value */, heapptr_t A_next_method_info /* next-method-info */, heapptr_t A_rest /* rest */, descriptor_t A_index /* index */)
{
    descriptor_t *cluster_0_top;
    descriptor_t L_temp;
    descriptor_t L_arg1; /* arg1 */
    descriptor_t L_temp_2;
    descriptor_t L_temp_3; /* temp */
    descriptor_t L_temp_4;

    /* #line {Class <unknown-source-location>} */

    /* #line 1423 "./sockets-api.dylan" */
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = 12;
    orig_sp[0] = A_index;
    orig_sp[1] = L_temp;
    /* * */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZV_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_arg1 = (orig_sp == cluster_0_top ? dylanZfalse : orig_sp[0]);

    /* #line 1423 "./sockets-api.dylan" */
    L_temp_2.heapptr = networkZliteral_31.heapptr;
    L_temp_2.dataword.ptr = A_value;
    orig_sp[0] = L_temp_2;
    orig_sp[1] = L_arg1;
    /* + */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZPLUS_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_temp_3 = (orig_sp == cluster_0_top ? dylanZfalse : orig_sp[0]);

    /* #line 386 "./condition.dylan" */
    if ((&networkZnetwork_internalZCLS_pthread_cond_t_HEAP == SLOT(L_temp_3.heapptr, heapptr_t, 0))) {

	/* #line 1423 "./sockets-api.dylan" */
	return L_temp_3.dataword.ptr;
    }
    else {

	/* #line 389 "./condition.dylan" */
	L_temp_4.heapptr = &networkZstr_ROOT_42;
	L_temp_4.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp_3, &networkZnetwork_internalZCLS_pthread_cond_t_HEAP, L_temp_4);
	not_reached();
    }
}

/* generic-entry for pointer-value{<pthread-cond-t>} */
descriptor_t * networkZnetwork_internalZpointer_value_METH_GENERIC_23(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    descriptor_t L_arg; /* arg */
    heapptr_t L_rest; /* rest */
    void * L_arg_2; /* arg */
    descriptor_t L_index; /* index */
    long L_index_2; /* index */
    descriptor_t L_key; /* key */
    descriptor_t L_value; /* value */
    void * L_result0; /* result0 */
    descriptor_t L_temp;

    /* #line {Class <unknown-source-location>} */
    L_args = ((void *)(orig_sp - A_nargs));
    L_arg = (((descriptor_t *)L_args)[0]);
    L_rest = dylanZdylan_visceraZmake_rest_arg_FUN(orig_sp, (descriptor_t *)L_args + 1, A_nargs - 1);
    L_arg_2 = L_arg.dataword.ptr;
    L_index.heapptr = networkZliteral_2.heapptr;
    L_index.dataword.l = 0;
    L_index_2 = (A_nargs - 2);
    while (1) {
	if ((L_index_2 < 1)) {
	    goto block0;
	}
	else {
	    L_key = (((descriptor_t *)L_args)[L_index_2]);
	    L_value = (((descriptor_t *)L_args)[(L_index_2 + 1)]);
	    if ((L_key.heapptr == &SYM_index_HEAP)) {
		L_index = L_value;
	    }
	    L_index_2 = (L_index_2 - 2);
	}
    }
  block0:;
    orig_sp = L_args;
    /* pointer-value{<pthread-cond-t>} */
    L_result0 = networkZnetwork_internalZpointer_value_METH_23(orig_sp, L_arg_2, A_next_method_info, L_rest, L_index);
    L_temp.heapptr = networkZliteral_31.heapptr;
    L_temp.dataword.ptr = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* Define Method content-size{subclass(<pthread-cond-t>)} */

/* content-size{subclass(<pthread-cond-t>)} */
long networkZnetwork_internalZcontent_size_METH_29(descriptor_t *orig_sp, heapptr_t A0, heapptr_t A1)
{

    return 12;
}

/* generic-entry for content-size{subclass(<pthread-cond-t>)} */
descriptor_t * networkZnetwork_internalZcontent_size_METH_GENERIC_29(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    long L_result0; /* result0 */
    descriptor_t L_temp;

    orig_sp = ((void *)(orig_sp - 1));
    /* content-size{subclass(<pthread-cond-t>)} */
    L_result0 = networkZnetwork_internalZcontent_size_METH_29(orig_sp, &networkZnetwork_internalZCLS_pthread_cond_t_HEAP, A_next_method_info);
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* Define Class <pthread-condattr-t> */

/* <pthread-condattr-t> is <pthread-condattr-t> */

extern struct heapobj networkZnetwork_internalZCLS_pthread_condattr_t_HEAP;

/* maker for <pthread-condattr-t> */
void * networkZnetwork_internalZCLS_pthread_condattr_t_MAKER_FUN(descriptor_t *orig_sp, void * A_pointer /* pointer */, int A_pointer_suppliedQUERY /* pointer-supplied? */)
{
    descriptor_t *cluster_0_top;


    /* #line 1430 "./sockets-api.dylan" */
    if (A_pointer_suppliedQUERY) {
	return A_pointer;
    }
    else {
	/* missing-required-init-keyword-error */
	dylanZdylan_visceraZmissing_required_init_keyword_error_FUN(orig_sp, &SYM_pointer_HEAP, &networkZnetwork_internalZCLS_pthread_condattr_t_HEAP);
	not_reached();
    }
}

extern descriptor_t networkZliteral_32;	/* proxy for <pthread-condattr-t> */

/* general-entry for maker for <pthread-condattr-t> */
descriptor_t * networkZnetwork_internalZCLS_pthread_condattr_t_MAKER_GENERAL(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    void * L_pointer; /* pointer */
    int L_pointer_suppliedQUERY; /* pointer-supplied? */
    long L_index; /* index */
    descriptor_t L_temp; /* temp */
    descriptor_t L_value; /* value */
    descriptor_t L_temp_2;
    descriptor_t L_temp_3;
    void * L_result0; /* result0 */
    descriptor_t L_temp_4;

    /* #line {Class <unknown-source-location>} */

    /* #line 126 "./cmp.dylan" */

    /* #line 209 "./num.dylan" */
    if (((A_nargs & 1) == 0)) {
	/* #line {Class <unknown-source-location>} */
	L_args = ((void *)(orig_sp - A_nargs));
	L_pointer = 0;
	L_pointer_suppliedQUERY = FALSE;
	L_index = (A_nargs - 2);
	while (1) {
	    if ((L_index < 0)) {
		goto block0;
	    }
	    else {
		L_temp = (((descriptor_t *)L_args)[L_index]);

		/* #line 386 "./condition.dylan" */
		if ((&dylanZdylan_visceraZCLS_symbol_HEAP == SLOT(L_temp.heapptr, heapptr_t, 0))) {
		    /* #line {Class <unknown-source-location>} */
		    L_value = (((descriptor_t *)L_args)[(L_index + 1)]);
		    if ((L_temp.heapptr == &SYM_pointer_HEAP)) {

			/* #line 386 "./condition.dylan" */
			if ((&dylanZdylan_visceraZCLS_raw_pointer_HEAP == SLOT(L_value.heapptr, heapptr_t, 0))) {
			    /* #line {Class <unknown-source-location>} */
			    L_pointer = L_value.dataword.ptr;
			    L_pointer_suppliedQUERY = TRUE;
			}
			else {

			    /* #line 389 "./condition.dylan" */
			    L_temp_2.heapptr = &networkZstr_ROOT;
			    L_temp_2.dataword.l = 0;
			    /* type-error-with-location */
			    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_value, &dylanZdylan_visceraZCLS_raw_pointer_HEAP, L_temp_2);
			    not_reached();
			}
		    }
		    /* #line {Class <unknown-source-location>} */
		    L_index = (L_index - 2);
		}
		else {

		    /* #line 389 "./condition.dylan" */
		    L_temp_3.heapptr = &networkZstr_ROOT;
		    L_temp_3.dataword.l = 0;
		    /* type-error-with-location */
		    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp, &dylanZdylan_visceraZCLS_symbol_HEAP, L_temp_3);
		    not_reached();
		}
	    }
	}
      block0:;
	/* #line {Class <unknown-source-location>} */
	orig_sp = L_args;
	/* maker for <pthread-condattr-t> */
	L_result0 = networkZnetwork_internalZCLS_pthread_condattr_t_MAKER_FUN(orig_sp, L_pointer, L_pointer_suppliedQUERY);
	L_temp_4.heapptr = networkZliteral_32.heapptr;
	L_temp_4.dataword.ptr = L_result0;
	orig_sp[0] = L_temp_4;
	return orig_sp + 1;
    }
    else {
	/* odd-number-of-keyword/value-arguments-error */
	dylanZdylan_visceraZodd_number_of_keywordSLASHvalue_arguments_error_FUN(orig_sp);
	not_reached();
    }
}


/* Define Sealed Domain make (singleton(<pthread-condattr-t>)) */


/* {Implicit} Define Generic get-__dummy */

/* get-__dummy is get-__dummy */


/* Define Method get-__dummy{<pthread-condattr-t>} */

/* get-__dummy{<pthread-condattr-t>} */
long networkZnetwork_internalZget_X_X_dummy_METH(descriptor_t *orig_sp, void * A_ptr /* ptr */, heapptr_t A1)
{
    descriptor_t *cluster_0_top;


    /* #line 198 "./melange.dylan" */

    /* #line 91 "./rawptr.dylan" */
    return (*(long *)((char *)A_ptr + 0 ));
}


/* {Implicit} Define Generic get-__dummy-setter */

/* get-__dummy-setter is get-__dummy-setter */


/* Define Method get-__dummy-setter{<integer>, <pthread-condattr-t>} */

/* get-__dummy-setter{<integer>, <pthread-condattr-t>} */
long networkZnetwork_internalZget_X_X_dummy_setter_METH(descriptor_t *orig_sp, long A_value /* value */, void * A_ptr /* ptr */, heapptr_t A2)
{
    descriptor_t *cluster_0_top;

    /* #line {Class <unknown-source-location>} */

    /* #line 97 "./rawptr.dylan" */
    *(long *)((char *)A_ptr + 0) = A_value;
    return A_value;
}


/* Define Method pointer-value{<pthread-condattr-t>} */

extern struct heapobj networkZstr_ROOT_43;

/* pointer-value{<pthread-condattr-t>} */
void * networkZnetwork_internalZpointer_value_METH_24(descriptor_t *orig_sp, void * A_value /* value */, heapptr_t A_next_method_info /* next-method-info */, heapptr_t A_rest /* rest */, descriptor_t A_index /* index */)
{
    descriptor_t *cluster_0_top;
    descriptor_t L_temp;
    descriptor_t L_arg1; /* arg1 */
    descriptor_t L_temp_2;
    descriptor_t L_temp_3; /* temp */
    descriptor_t L_temp_4;

    /* #line {Class <unknown-source-location>} */

    /* #line 1446 "./sockets-api.dylan" */
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = 4;
    orig_sp[0] = A_index;
    orig_sp[1] = L_temp;
    /* * */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZV_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_arg1 = (orig_sp == cluster_0_top ? dylanZfalse : orig_sp[0]);

    /* #line 1446 "./sockets-api.dylan" */
    L_temp_2.heapptr = networkZliteral_32.heapptr;
    L_temp_2.dataword.ptr = A_value;
    orig_sp[0] = L_temp_2;
    orig_sp[1] = L_arg1;
    /* + */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZPLUS_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_temp_3 = (orig_sp == cluster_0_top ? dylanZfalse : orig_sp[0]);

    /* #line 386 "./condition.dylan" */
    if ((&networkZnetwork_internalZCLS_pthread_condattr_t_HEAP == SLOT(L_temp_3.heapptr, heapptr_t, 0))) {

	/* #line 1446 "./sockets-api.dylan" */
	return L_temp_3.dataword.ptr;
    }
    else {

	/* #line 389 "./condition.dylan" */
	L_temp_4.heapptr = &networkZstr_ROOT_43;
	L_temp_4.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp_3, &networkZnetwork_internalZCLS_pthread_condattr_t_HEAP, L_temp_4);
	not_reached();
    }
}

/* generic-entry for pointer-value{<pthread-condattr-t>} */
descriptor_t * networkZnetwork_internalZpointer_value_METH_GENERIC_24(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    descriptor_t L_arg; /* arg */
    heapptr_t L_rest; /* rest */
    void * L_arg_2; /* arg */
    descriptor_t L_index; /* index */
    long L_index_2; /* index */
    descriptor_t L_key; /* key */
    descriptor_t L_value; /* value */
    void * L_result0; /* result0 */
    descriptor_t L_temp;

    /* #line {Class <unknown-source-location>} */
    L_args = ((void *)(orig_sp - A_nargs));
    L_arg = (((descriptor_t *)L_args)[0]);
    L_rest = dylanZdylan_visceraZmake_rest_arg_FUN(orig_sp, (descriptor_t *)L_args + 1, A_nargs - 1);
    L_arg_2 = L_arg.dataword.ptr;
    L_index.heapptr = networkZliteral_2.heapptr;
    L_index.dataword.l = 0;
    L_index_2 = (A_nargs - 2);
    while (1) {
	if ((L_index_2 < 1)) {
	    goto block0;
	}
	else {
	    L_key = (((descriptor_t *)L_args)[L_index_2]);
	    L_value = (((descriptor_t *)L_args)[(L_index_2 + 1)]);
	    if ((L_key.heapptr == &SYM_index_HEAP)) {
		L_index = L_value;
	    }
	    L_index_2 = (L_index_2 - 2);
	}
    }
  block0:;
    orig_sp = L_args;
    /* pointer-value{<pthread-condattr-t>} */
    L_result0 = networkZnetwork_internalZpointer_value_METH_24(orig_sp, L_arg_2, A_next_method_info, L_rest, L_index);
    L_temp.heapptr = networkZliteral_32.heapptr;
    L_temp.dataword.ptr = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* Define Method content-size{subclass(<pthread-condattr-t>)} */

/* content-size{subclass(<pthread-condattr-t>)} */
long networkZnetwork_internalZcontent_size_METH_30(descriptor_t *orig_sp, heapptr_t A0, heapptr_t A1)
{

    return 4;
}

/* generic-entry for content-size{subclass(<pthread-condattr-t>)} */
descriptor_t * networkZnetwork_internalZcontent_size_METH_GENERIC_30(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    long L_result0; /* result0 */
    descriptor_t L_temp;

    orig_sp = ((void *)(orig_sp - 1));
    /* content-size{subclass(<pthread-condattr-t>)} */
    L_result0 = networkZnetwork_internalZcontent_size_METH_30(orig_sp, &networkZnetwork_internalZCLS_pthread_condattr_t_HEAP, A_next_method_info);
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* Define Constant <pthread-key-t> */

/* <pthread-key-t> is <integer> */


/* Define Class <pthread-mutex-t> */

/* <pthread-mutex-t> is <pthread-mutex-t> */

extern struct heapobj networkZnetwork_internalZCLS_pthread_mutex_t_HEAP;

/* maker for <pthread-mutex-t> */
void * networkZnetwork_internalZCLS_pthread_mutex_t_MAKER_FUN(descriptor_t *orig_sp, void * A_pointer /* pointer */, int A_pointer_suppliedQUERY /* pointer-supplied? */)
{
    descriptor_t *cluster_0_top;


    /* #line 1455 "./sockets-api.dylan" */
    if (A_pointer_suppliedQUERY) {
	return A_pointer;
    }
    else {
	/* missing-required-init-keyword-error */
	dylanZdylan_visceraZmissing_required_init_keyword_error_FUN(orig_sp, &SYM_pointer_HEAP, &networkZnetwork_internalZCLS_pthread_mutex_t_HEAP);
	not_reached();
    }
}

extern descriptor_t networkZliteral_33;	/* proxy for <pthread-mutex-t> */

/* general-entry for maker for <pthread-mutex-t> */
descriptor_t * networkZnetwork_internalZCLS_pthread_mutex_t_MAKER_GENERAL(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    void * L_pointer; /* pointer */
    int L_pointer_suppliedQUERY; /* pointer-supplied? */
    long L_index; /* index */
    descriptor_t L_temp; /* temp */
    descriptor_t L_value; /* value */
    descriptor_t L_temp_2;
    descriptor_t L_temp_3;
    void * L_result0; /* result0 */
    descriptor_t L_temp_4;

    /* #line {Class <unknown-source-location>} */

    /* #line 126 "./cmp.dylan" */

    /* #line 209 "./num.dylan" */
    if (((A_nargs & 1) == 0)) {
	/* #line {Class <unknown-source-location>} */
	L_args = ((void *)(orig_sp - A_nargs));
	L_pointer = 0;
	L_pointer_suppliedQUERY = FALSE;
	L_index = (A_nargs - 2);
	while (1) {
	    if ((L_index < 0)) {
		goto block0;
	    }
	    else {
		L_temp = (((descriptor_t *)L_args)[L_index]);

		/* #line 386 "./condition.dylan" */
		if ((&dylanZdylan_visceraZCLS_symbol_HEAP == SLOT(L_temp.heapptr, heapptr_t, 0))) {
		    /* #line {Class <unknown-source-location>} */
		    L_value = (((descriptor_t *)L_args)[(L_index + 1)]);
		    if ((L_temp.heapptr == &SYM_pointer_HEAP)) {

			/* #line 386 "./condition.dylan" */
			if ((&dylanZdylan_visceraZCLS_raw_pointer_HEAP == SLOT(L_value.heapptr, heapptr_t, 0))) {
			    /* #line {Class <unknown-source-location>} */
			    L_pointer = L_value.dataword.ptr;
			    L_pointer_suppliedQUERY = TRUE;
			}
			else {

			    /* #line 389 "./condition.dylan" */
			    L_temp_2.heapptr = &networkZstr_ROOT;
			    L_temp_2.dataword.l = 0;
			    /* type-error-with-location */
			    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_value, &dylanZdylan_visceraZCLS_raw_pointer_HEAP, L_temp_2);
			    not_reached();
			}
		    }
		    /* #line {Class <unknown-source-location>} */
		    L_index = (L_index - 2);
		}
		else {

		    /* #line 389 "./condition.dylan" */
		    L_temp_3.heapptr = &networkZstr_ROOT;
		    L_temp_3.dataword.l = 0;
		    /* type-error-with-location */
		    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp, &dylanZdylan_visceraZCLS_symbol_HEAP, L_temp_3);
		    not_reached();
		}
	    }
	}
      block0:;
	/* #line {Class <unknown-source-location>} */
	orig_sp = L_args;
	/* maker for <pthread-mutex-t> */
	L_result0 = networkZnetwork_internalZCLS_pthread_mutex_t_MAKER_FUN(orig_sp, L_pointer, L_pointer_suppliedQUERY);
	L_temp_4.heapptr = networkZliteral_33.heapptr;
	L_temp_4.dataword.ptr = L_result0;
	orig_sp[0] = L_temp_4;
	return orig_sp + 1;
    }
    else {
	/* odd-number-of-keyword/value-arguments-error */
	dylanZdylan_visceraZodd_number_of_keywordSLASHvalue_arguments_error_FUN(orig_sp);
	not_reached();
    }
}


/* Define Sealed Domain make (singleton(<pthread-mutex-t>)) */


/* {Implicit} Define Generic get-__m-reserved */

/* get-__m-reserved is get-__m-reserved */


/* Define Method get-__m-reserved{<pthread-mutex-t>} */

/* get-__m-reserved{<pthread-mutex-t>} */
long networkZnetwork_internalZget_X_X_m_reserved_METH(descriptor_t *orig_sp, void * A_ptr /* ptr */, heapptr_t A1)
{
    descriptor_t *cluster_0_top;


    /* #line 198 "./melange.dylan" */

    /* #line 91 "./rawptr.dylan" */
    return (*(long *)((char *)A_ptr + 0 ));
}


/* {Implicit} Define Generic get-__m-reserved-setter */

/* get-__m-reserved-setter is get-__m-reserved-setter */


/* Define Method get-__m-reserved-setter{<integer>, <pthread-mutex-t>} */

/* get-__m-reserved-setter{<integer>, <pthread-mutex-t>} */
long networkZnetwork_internalZget_X_X_m_reserved_setter_METH(descriptor_t *orig_sp, long A_value /* value */, void * A_ptr /* ptr */, heapptr_t A2)
{
    descriptor_t *cluster_0_top;

    /* #line {Class <unknown-source-location>} */

    /* #line 97 "./rawptr.dylan" */
    *(long *)((char *)A_ptr + 0) = A_value;
    return A_value;
}


/* {Implicit} Define Generic get-__m-count */

/* get-__m-count is get-__m-count */


/* Define Method get-__m-count{<pthread-mutex-t>} */

/* get-__m-count{<pthread-mutex-t>} */
long networkZnetwork_internalZget_X_X_m_count_METH(descriptor_t *orig_sp, void * A_ptr /* ptr */, heapptr_t A1)
{
    descriptor_t *cluster_0_top;

    /* #line {Class <unknown-source-location>} */

    /* #line 198 "./melange.dylan" */

    /* #line 91 "./rawptr.dylan" */
    return (*(long *)((char *)A_ptr + 4 ));
}


/* {Implicit} Define Generic get-__m-count-setter */

/* get-__m-count-setter is get-__m-count-setter */


/* Define Method get-__m-count-setter{<integer>, <pthread-mutex-t>} */

/* get-__m-count-setter{<integer>, <pthread-mutex-t>} */
long networkZnetwork_internalZget_X_X_m_count_setter_METH(descriptor_t *orig_sp, long A_value /* value */, void * A_ptr /* ptr */, heapptr_t A2)
{
    descriptor_t *cluster_0_top;

    /* #line {Class <unknown-source-location>} */

    /* #line 97 "./rawptr.dylan" */
    *(long *)((char *)A_ptr + 4) = A_value;
    return A_value;
}


/* {Implicit} Define Generic get-__m-owner */

/* get-__m-owner is get-__m-owner */


/* Define Method get-__m-owner{<pthread-mutex-t>} */

extern struct heapobj networkZstr_ROOT_44;

/* get-__m-owner{<pthread-mutex-t>} */
void * networkZnetwork_internalZget_X_X_m_owner_METH(descriptor_t *orig_sp, void * A_ptr /* ptr */, heapptr_t A1)
{
    descriptor_t *cluster_0_top;
    descriptor_t L_temp;
    descriptor_t L_temp_2;
    descriptor_t L_temp_3; /* temp */
    int L_condition; /* condition */
    descriptor_t L_result; /* result */
    descriptor_t L_temp_4;
    descriptor_t L_temp_5;

    /* #line {Class <unknown-source-location>} */

    /* #line 290 "./melange.dylan" */

    /* #line 91 "./rawptr.dylan" */

    /* #line 290 "./melange.dylan" */
    L_temp.heapptr = &networkZnetwork_internalZCLS_X_pthread_descr_struct_HEAP;
    L_temp.dataword.l = 0;
    L_temp_2.heapptr = networkZliteral_6.heapptr;
    L_temp_2.dataword.ptr = (*(void * *)((char *)A_ptr + 8 ));
    orig_sp[0] = L_temp;
    orig_sp[1] = L_temp_2;
    /* as */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZas_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_temp_3 = orig_sp[0];

    /* #line 49 "./object.dylan" */

    /* #line 386 "./condition.dylan" */
    /* %subtype?{<class>, <class>} */
    L_condition = dylanZdylan_visceraZPCTsubtypeQUERY_METH(orig_sp, SLOT(L_temp_3.heapptr, heapptr_t, 0), &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP, &dylanZliteral_ROOT_2);
    if (L_condition) {

	/* #line 290 "./melange.dylan" */
	L_result = L_temp_3;

	/* #line 386 "./condition.dylan" */
	if ((&networkZnetwork_internalZCLS_X_pthread_descr_struct_HEAP == SLOT(L_result.heapptr, heapptr_t, 0))) {

	    /* #line 1483 "./sockets-api.dylan" */
	    return L_result.dataword.ptr;
	}
	else {

	    /* #line 389 "./condition.dylan" */
	    L_temp_4.heapptr = &networkZstr_ROOT_44;
	    L_temp_4.dataword.l = 0;
	    /* type-error-with-location */
	    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_result, &networkZnetwork_internalZCLS_X_pthread_descr_struct_HEAP, L_temp_4);
	    not_reached();
	}
    }
    else {
	L_temp_5.heapptr = &networkZstr_ROOT_14;
	L_temp_5.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp_3, &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP, L_temp_5);
	not_reached();
    }
}


/* {Implicit} Define Generic get-__m-owner-setter */

/* get-__m-owner-setter is get-__m-owner-setter */


/* Define Method get-__m-owner-setter{<_pthread-descr-struct>, <pthread-mutex-t>} */

/* get-__m-owner-setter{<_pthread-descr-struct>, <pthread-mutex-t>} */
void * networkZnetwork_internalZget_X_X_m_owner_setter_METH(descriptor_t *orig_sp, void * A_value /* value */, void * A_ptr /* ptr */, heapptr_t A2)
{
    descriptor_t *cluster_0_top;

    /* #line {Class <unknown-source-location>} */

    /* #line 299 "./melange.dylan" */
    /* #line {Class <unknown-source-location>} */

    /* #line 97 "./rawptr.dylan" */
    *(void * *)((char *)A_ptr + 8) = A_value;
    return A_value;
}


/* {Implicit} Define Generic get-__m-kind */

/* get-__m-kind is get-__m-kind */


/* Define Method get-__m-kind{<pthread-mutex-t>} */

/* get-__m-kind{<pthread-mutex-t>} */
long networkZnetwork_internalZget_X_X_m_kind_METH(descriptor_t *orig_sp, void * A_ptr /* ptr */, heapptr_t A1)
{
    descriptor_t *cluster_0_top;

    /* #line {Class <unknown-source-location>} */

    /* #line 198 "./melange.dylan" */

    /* #line 91 "./rawptr.dylan" */
    return (*(long *)((char *)A_ptr + 12 ));
}


/* {Implicit} Define Generic get-__m-kind-setter */

/* get-__m-kind-setter is get-__m-kind-setter */


/* Define Method get-__m-kind-setter{<integer>, <pthread-mutex-t>} */

/* get-__m-kind-setter{<integer>, <pthread-mutex-t>} */
long networkZnetwork_internalZget_X_X_m_kind_setter_METH(descriptor_t *orig_sp, long A_value /* value */, void * A_ptr /* ptr */, heapptr_t A2)
{
    descriptor_t *cluster_0_top;

    /* #line {Class <unknown-source-location>} */

    /* #line 97 "./rawptr.dylan" */
    *(long *)((char *)A_ptr + 12) = A_value;
    return A_value;
}


/* {Implicit} Define Generic get-__m-lock */

/* get-__m-lock is get-__m-lock */


/* Define Method get-__m-lock{<pthread-mutex-t>} */

extern struct heapobj networkZstr_ROOT_45;

/* get-__m-lock{<pthread-mutex-t>} */
void * networkZnetwork_internalZget_X_X_m_lock_METH(descriptor_t *orig_sp, void * A_ptr /* ptr */, heapptr_t A1)
{
    descriptor_t *cluster_0_top;
    descriptor_t L_temp;
    descriptor_t L_temp_2;
    descriptor_t L_temp_3;
    descriptor_t L_temp_4; /* temp */
    int L_condition; /* condition */
    descriptor_t L_temp_5;
    descriptor_t L_temp_6; /* temp */
    descriptor_t L_temp_7;
    descriptor_t L_temp_8;

    /* #line {Class <unknown-source-location>} */

    /* #line 49 "./object.dylan" */
    L_temp.heapptr = networkZliteral_33.heapptr;
    L_temp.dataword.ptr = A_ptr;

    /* #line 324 "./melange.dylan" */

    /* #line 324 "./melange.dylan" */

    /* #line 324 "./melange.dylan" */
    L_temp_2.heapptr = SLOT(L_temp.heapptr, heapptr_t, 0);
    L_temp_2.dataword.l = 0;
    L_temp_3.heapptr = networkZliteral_6.heapptr;
    L_temp_3.dataword.ptr = ((void *)((char *)A_ptr + 16));
    orig_sp[0] = L_temp_2;
    orig_sp[1] = L_temp_3;
    /* as */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZas_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_temp_4 = orig_sp[0];

    /* #line 49 "./object.dylan" */

    /* #line 386 "./condition.dylan" */
    /* %subtype?{<class>, <class>} */
    L_condition = dylanZdylan_visceraZPCTsubtypeQUERY_METH(orig_sp, SLOT(L_temp_4.heapptr, heapptr_t, 0), &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP, &dylanZliteral_ROOT_2);
    if (L_condition) {

	/* #line 324 "./melange.dylan" */

	/* #line 1505 "./sockets-api.dylan" */
	L_temp_5.heapptr = &networkZnetwork_internalZCLS_X_pthread_fastlock_HEAP;
	L_temp_5.dataword.l = 0;
	orig_sp[0] = L_temp_5;
	orig_sp[1] = L_temp_4;
	/* as */
	{
	  struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZas_HEAP, 2);
	  heapptr_t L_meth = L_temp.R0;
	  heapptr_t L_next_info = L_temp.R1;
	  cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
	}
	L_temp_6 = orig_sp[0];

	/* #line 386 "./condition.dylan" */
	if ((&networkZnetwork_internalZCLS_X_pthread_fastlock_HEAP == SLOT(L_temp_6.heapptr, heapptr_t, 0))) {

	    /* #line 1505 "./sockets-api.dylan" */
	    return L_temp_6.dataword.ptr;
	}
	else {

	    /* #line 389 "./condition.dylan" */
	    L_temp_7.heapptr = &networkZstr_ROOT_45;
	    L_temp_7.dataword.l = 0;
	    /* type-error-with-location */
	    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp_6, &networkZnetwork_internalZCLS_X_pthread_fastlock_HEAP, L_temp_7);
	    not_reached();
	}
    }
    else {
	L_temp_8.heapptr = &networkZstr_ROOT_5;
	L_temp_8.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp_4, &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP, L_temp_8);
	not_reached();
    }
}


/* Define Method pointer-value{<pthread-mutex-t>} */

extern struct heapobj networkZstr_ROOT_46;

/* pointer-value{<pthread-mutex-t>} */
void * networkZnetwork_internalZpointer_value_METH_25(descriptor_t *orig_sp, void * A_value /* value */, heapptr_t A_next_method_info /* next-method-info */, heapptr_t A_rest /* rest */, descriptor_t A_index /* index */)
{
    descriptor_t *cluster_0_top;
    descriptor_t L_temp;
    descriptor_t L_arg1; /* arg1 */
    descriptor_t L_temp_2;
    descriptor_t L_temp_3; /* temp */
    descriptor_t L_temp_4;

    /* #line {Class <unknown-source-location>} */

    /* #line 1509 "./sockets-api.dylan" */
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = 24;
    orig_sp[0] = A_index;
    orig_sp[1] = L_temp;
    /* * */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZV_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_arg1 = (orig_sp == cluster_0_top ? dylanZfalse : orig_sp[0]);

    /* #line 1509 "./sockets-api.dylan" */
    L_temp_2.heapptr = networkZliteral_33.heapptr;
    L_temp_2.dataword.ptr = A_value;
    orig_sp[0] = L_temp_2;
    orig_sp[1] = L_arg1;
    /* + */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZPLUS_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_temp_3 = (orig_sp == cluster_0_top ? dylanZfalse : orig_sp[0]);

    /* #line 386 "./condition.dylan" */
    if ((&networkZnetwork_internalZCLS_pthread_mutex_t_HEAP == SLOT(L_temp_3.heapptr, heapptr_t, 0))) {

	/* #line 1509 "./sockets-api.dylan" */
	return L_temp_3.dataword.ptr;
    }
    else {

	/* #line 389 "./condition.dylan" */
	L_temp_4.heapptr = &networkZstr_ROOT_46;
	L_temp_4.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp_3, &networkZnetwork_internalZCLS_pthread_mutex_t_HEAP, L_temp_4);
	not_reached();
    }
}

/* generic-entry for pointer-value{<pthread-mutex-t>} */
descriptor_t * networkZnetwork_internalZpointer_value_METH_GENERIC_25(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    descriptor_t L_arg; /* arg */
    heapptr_t L_rest; /* rest */
    void * L_arg_2; /* arg */
    descriptor_t L_index; /* index */
    long L_index_2; /* index */
    descriptor_t L_key; /* key */
    descriptor_t L_value; /* value */
    void * L_result0; /* result0 */
    descriptor_t L_temp;

    /* #line {Class <unknown-source-location>} */
    L_args = ((void *)(orig_sp - A_nargs));
    L_arg = (((descriptor_t *)L_args)[0]);
    L_rest = dylanZdylan_visceraZmake_rest_arg_FUN(orig_sp, (descriptor_t *)L_args + 1, A_nargs - 1);
    L_arg_2 = L_arg.dataword.ptr;
    L_index.heapptr = networkZliteral_2.heapptr;
    L_index.dataword.l = 0;
    L_index_2 = (A_nargs - 2);
    while (1) {
	if ((L_index_2 < 1)) {
	    goto block0;
	}
	else {
	    L_key = (((descriptor_t *)L_args)[L_index_2]);
	    L_value = (((descriptor_t *)L_args)[(L_index_2 + 1)]);
	    if ((L_key.heapptr == &SYM_index_HEAP)) {
		L_index = L_value;
	    }
	    L_index_2 = (L_index_2 - 2);
	}
    }
  block0:;
    orig_sp = L_args;
    /* pointer-value{<pthread-mutex-t>} */
    L_result0 = networkZnetwork_internalZpointer_value_METH_25(orig_sp, L_arg_2, A_next_method_info, L_rest, L_index);
    L_temp.heapptr = networkZliteral_33.heapptr;
    L_temp.dataword.ptr = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* Define Method content-size{subclass(<pthread-mutex-t>)} */

/* content-size{subclass(<pthread-mutex-t>)} */
long networkZnetwork_internalZcontent_size_METH_31(descriptor_t *orig_sp, heapptr_t A0, heapptr_t A1)
{

    return 24;
}

/* generic-entry for content-size{subclass(<pthread-mutex-t>)} */
descriptor_t * networkZnetwork_internalZcontent_size_METH_GENERIC_31(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    long L_result0; /* result0 */
    descriptor_t L_temp;

    orig_sp = ((void *)(orig_sp - 1));
    /* content-size{subclass(<pthread-mutex-t>)} */
    L_result0 = networkZnetwork_internalZcontent_size_METH_31(orig_sp, &networkZnetwork_internalZCLS_pthread_mutex_t_HEAP, A_next_method_info);
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* Define Class <pthread-mutexattr-t> */

/* <pthread-mutexattr-t> is <pthread-mutexattr-t> */

extern struct heapobj networkZnetwork_internalZCLS_pthread_mutexattr_t_HEAP;

/* maker for <pthread-mutexattr-t> */
void * networkZnetwork_internalZCLS_pthread_mutexattr_t_MAKER_FUN(descriptor_t *orig_sp, void * A_pointer /* pointer */, int A_pointer_suppliedQUERY /* pointer-supplied? */)
{
    descriptor_t *cluster_0_top;


    /* #line 1516 "./sockets-api.dylan" */
    if (A_pointer_suppliedQUERY) {
	return A_pointer;
    }
    else {
	/* missing-required-init-keyword-error */
	dylanZdylan_visceraZmissing_required_init_keyword_error_FUN(orig_sp, &SYM_pointer_HEAP, &networkZnetwork_internalZCLS_pthread_mutexattr_t_HEAP);
	not_reached();
    }
}

extern descriptor_t networkZliteral_34;	/* proxy for <pthread-mutexattr-t> */

/* general-entry for maker for <pthread-mutexattr-t> */
descriptor_t * networkZnetwork_internalZCLS_pthread_mutexattr_t_MAKER_GENERAL(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    void * L_pointer; /* pointer */
    int L_pointer_suppliedQUERY; /* pointer-supplied? */
    long L_index; /* index */
    descriptor_t L_temp; /* temp */
    descriptor_t L_value; /* value */
    descriptor_t L_temp_2;
    descriptor_t L_temp_3;
    void * L_result0; /* result0 */
    descriptor_t L_temp_4;

    /* #line {Class <unknown-source-location>} */

    /* #line 126 "./cmp.dylan" */

    /* #line 209 "./num.dylan" */
    if (((A_nargs & 1) == 0)) {
	/* #line {Class <unknown-source-location>} */
	L_args = ((void *)(orig_sp - A_nargs));
	L_pointer = 0;
	L_pointer_suppliedQUERY = FALSE;
	L_index = (A_nargs - 2);
	while (1) {
	    if ((L_index < 0)) {
		goto block0;
	    }
	    else {
		L_temp = (((descriptor_t *)L_args)[L_index]);

		/* #line 386 "./condition.dylan" */
		if ((&dylanZdylan_visceraZCLS_symbol_HEAP == SLOT(L_temp.heapptr, heapptr_t, 0))) {
		    /* #line {Class <unknown-source-location>} */
		    L_value = (((descriptor_t *)L_args)[(L_index + 1)]);
		    if ((L_temp.heapptr == &SYM_pointer_HEAP)) {

			/* #line 386 "./condition.dylan" */
			if ((&dylanZdylan_visceraZCLS_raw_pointer_HEAP == SLOT(L_value.heapptr, heapptr_t, 0))) {
			    /* #line {Class <unknown-source-location>} */
			    L_pointer = L_value.dataword.ptr;
			    L_pointer_suppliedQUERY = TRUE;
			}
			else {

			    /* #line 389 "./condition.dylan" */
			    L_temp_2.heapptr = &networkZstr_ROOT;
			    L_temp_2.dataword.l = 0;
			    /* type-error-with-location */
			    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_value, &dylanZdylan_visceraZCLS_raw_pointer_HEAP, L_temp_2);
			    not_reached();
			}
		    }
		    /* #line {Class <unknown-source-location>} */
		    L_index = (L_index - 2);
		}
		else {

		    /* #line 389 "./condition.dylan" */
		    L_temp_3.heapptr = &networkZstr_ROOT;
		    L_temp_3.dataword.l = 0;
		    /* type-error-with-location */
		    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp, &dylanZdylan_visceraZCLS_symbol_HEAP, L_temp_3);
		    not_reached();
		}
	    }
	}
      block0:;
	/* #line {Class <unknown-source-location>} */
	orig_sp = L_args;
	/* maker for <pthread-mutexattr-t> */
	L_result0 = networkZnetwork_internalZCLS_pthread_mutexattr_t_MAKER_FUN(orig_sp, L_pointer, L_pointer_suppliedQUERY);
	L_temp_4.heapptr = networkZliteral_34.heapptr;
	L_temp_4.dataword.ptr = L_result0;
	orig_sp[0] = L_temp_4;
	return orig_sp + 1;
    }
    else {
	/* odd-number-of-keyword/value-arguments-error */
	dylanZdylan_visceraZodd_number_of_keywordSLASHvalue_arguments_error_FUN(orig_sp);
	not_reached();
    }
}


/* Define Sealed Domain make (singleton(<pthread-mutexattr-t>)) */


/* {Implicit} Define Generic get-__mutexkind */

/* get-__mutexkind is get-__mutexkind */


/* Define Method get-__mutexkind{<pthread-mutexattr-t>} */

/* get-__mutexkind{<pthread-mutexattr-t>} */
long networkZnetwork_internalZget_X_X_mutexkind_METH(descriptor_t *orig_sp, void * A_ptr /* ptr */, heapptr_t A1)
{
    descriptor_t *cluster_0_top;


    /* #line 198 "./melange.dylan" */

    /* #line 91 "./rawptr.dylan" */
    return (*(long *)((char *)A_ptr + 0 ));
}


/* {Implicit} Define Generic get-__mutexkind-setter */

/* get-__mutexkind-setter is get-__mutexkind-setter */


/* Define Method get-__mutexkind-setter{<integer>, <pthread-mutexattr-t>} */

/* get-__mutexkind-setter{<integer>, <pthread-mutexattr-t>} */
long networkZnetwork_internalZget_X_X_mutexkind_setter_METH(descriptor_t *orig_sp, long A_value /* value */, void * A_ptr /* ptr */, heapptr_t A2)
{
    descriptor_t *cluster_0_top;

    /* #line {Class <unknown-source-location>} */

    /* #line 97 "./rawptr.dylan" */
    *(long *)((char *)A_ptr + 0) = A_value;
    return A_value;
}


/* Define Method pointer-value{<pthread-mutexattr-t>} */

extern struct heapobj networkZstr_ROOT_47;

/* pointer-value{<pthread-mutexattr-t>} */
void * networkZnetwork_internalZpointer_value_METH_26(descriptor_t *orig_sp, void * A_value /* value */, heapptr_t A_next_method_info /* next-method-info */, heapptr_t A_rest /* rest */, descriptor_t A_index /* index */)
{
    descriptor_t *cluster_0_top;
    descriptor_t L_temp;
    descriptor_t L_arg1; /* arg1 */
    descriptor_t L_temp_2;
    descriptor_t L_temp_3; /* temp */
    descriptor_t L_temp_4;

    /* #line {Class <unknown-source-location>} */

    /* #line 1532 "./sockets-api.dylan" */
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = 4;
    orig_sp[0] = A_index;
    orig_sp[1] = L_temp;
    /* * */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZV_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_arg1 = (orig_sp == cluster_0_top ? dylanZfalse : orig_sp[0]);

    /* #line 1532 "./sockets-api.dylan" */
    L_temp_2.heapptr = networkZliteral_34.heapptr;
    L_temp_2.dataword.ptr = A_value;
    orig_sp[0] = L_temp_2;
    orig_sp[1] = L_arg1;
    /* + */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZPLUS_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_temp_3 = (orig_sp == cluster_0_top ? dylanZfalse : orig_sp[0]);

    /* #line 386 "./condition.dylan" */
    if ((&networkZnetwork_internalZCLS_pthread_mutexattr_t_HEAP == SLOT(L_temp_3.heapptr, heapptr_t, 0))) {

	/* #line 1532 "./sockets-api.dylan" */
	return L_temp_3.dataword.ptr;
    }
    else {

	/* #line 389 "./condition.dylan" */
	L_temp_4.heapptr = &networkZstr_ROOT_47;
	L_temp_4.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp_3, &networkZnetwork_internalZCLS_pthread_mutexattr_t_HEAP, L_temp_4);
	not_reached();
    }
}

/* generic-entry for pointer-value{<pthread-mutexattr-t>} */
descriptor_t * networkZnetwork_internalZpointer_value_METH_GENERIC_26(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    descriptor_t L_arg; /* arg */
    heapptr_t L_rest; /* rest */
    void * L_arg_2; /* arg */
    descriptor_t L_index; /* index */
    long L_index_2; /* index */
    descriptor_t L_key; /* key */
    descriptor_t L_value; /* value */
    void * L_result0; /* result0 */
    descriptor_t L_temp;

    /* #line {Class <unknown-source-location>} */
    L_args = ((void *)(orig_sp - A_nargs));
    L_arg = (((descriptor_t *)L_args)[0]);
    L_rest = dylanZdylan_visceraZmake_rest_arg_FUN(orig_sp, (descriptor_t *)L_args + 1, A_nargs - 1);
    L_arg_2 = L_arg.dataword.ptr;
    L_index.heapptr = networkZliteral_2.heapptr;
    L_index.dataword.l = 0;
    L_index_2 = (A_nargs - 2);
    while (1) {
	if ((L_index_2 < 1)) {
	    goto block0;
	}
	else {
	    L_key = (((descriptor_t *)L_args)[L_index_2]);
	    L_value = (((descriptor_t *)L_args)[(L_index_2 + 1)]);
	    if ((L_key.heapptr == &SYM_index_HEAP)) {
		L_index = L_value;
	    }
	    L_index_2 = (L_index_2 - 2);
	}
    }
  block0:;
    orig_sp = L_args;
    /* pointer-value{<pthread-mutexattr-t>} */
    L_result0 = networkZnetwork_internalZpointer_value_METH_26(orig_sp, L_arg_2, A_next_method_info, L_rest, L_index);
    L_temp.heapptr = networkZliteral_34.heapptr;
    L_temp.dataword.ptr = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* Define Method content-size{subclass(<pthread-mutexattr-t>)} */

/* content-size{subclass(<pthread-mutexattr-t>)} */
long networkZnetwork_internalZcontent_size_METH_32(descriptor_t *orig_sp, heapptr_t A0, heapptr_t A1)
{

    return 4;
}

/* generic-entry for content-size{subclass(<pthread-mutexattr-t>)} */
descriptor_t * networkZnetwork_internalZcontent_size_METH_GENERIC_32(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    long L_result0; /* result0 */
    descriptor_t L_temp;

    orig_sp = ((void *)(orig_sp - 1));
    /* content-size{subclass(<pthread-mutexattr-t>)} */
    L_result0 = networkZnetwork_internalZcontent_size_METH_32(orig_sp, &networkZnetwork_internalZCLS_pthread_mutexattr_t_HEAP, A_next_method_info);
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* Define Constant <pthread-once-t> */

/* <pthread-once-t> is <integer> */


/* Define Constant <pthread-t> */

/* <pthread-t> is <integer> */


/* Define Constant $_BITS-PTHREADTYPES-H */

/* $_BITS-PTHREADTYPES-H is 1 */


/* Define Constant $__defined-schedparam */

/* $__defined-schedparam is 1 */


/* Define Constant $_SYS-SYSMACROS-H */

/* $_SYS-SYSMACROS-H is 1 */


/* Define Constant $_ENDIAN-H */

/* $_ENDIAN-H is 1 */


/* Define Constant $__LITTLE-ENDIAN */

/* $__LITTLE-ENDIAN is 1234 */


/* Define Constant $__BIG-ENDIAN */

/* $__BIG-ENDIAN is 4321 */


/* Define Constant $__PDP-ENDIAN */

/* $__PDP-ENDIAN is 3412 */


/* Define Constant $__FLOAT-WORD-ORDER */

/* $__FLOAT-WORD-ORDER is 1234 */


/* Define Constant $LITTLE-ENDIAN */

/* $LITTLE-ENDIAN is 1234 */


/* Define Constant $BIG-ENDIAN */

/* $BIG-ENDIAN is 4321 */


/* Define Constant $PDP-ENDIAN */

/* $PDP-ENDIAN is 3412 */


/* Define Constant $BYTE-ORDER */

/* $BYTE-ORDER is 1234 */


/* Define Constant $__BYTE-ORDER */

/* $__BYTE-ORDER is 1234 */


/* Define Class <unsigned-long*> */

/* <unsigned-long*> is <unsigned-long*> */

extern struct heapobj networkZnetwork_internalZCLS_unsigned_longV_HEAP;

/* maker for <unsigned-long*> */
void * networkZnetwork_internalZCLS_unsigned_longV_MAKER_FUN(descriptor_t *orig_sp, void * A_pointer /* pointer */, int A_pointer_suppliedQUERY /* pointer-supplied? */)
{
    descriptor_t *cluster_0_top;


    /* #line 1569 "./sockets-api.dylan" */
    if (A_pointer_suppliedQUERY) {
	return A_pointer;
    }
    else {
	/* missing-required-init-keyword-error */
	dylanZdylan_visceraZmissing_required_init_keyword_error_FUN(orig_sp, &SYM_pointer_HEAP, &networkZnetwork_internalZCLS_unsigned_longV_HEAP);
	not_reached();
    }
}

extern descriptor_t networkZliteral_35;	/* proxy for <unsigned-long*> */

/* general-entry for maker for <unsigned-long*> */
descriptor_t * networkZnetwork_internalZCLS_unsigned_longV_MAKER_GENERAL(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    void * L_pointer; /* pointer */
    int L_pointer_suppliedQUERY; /* pointer-supplied? */
    long L_index; /* index */
    descriptor_t L_temp; /* temp */
    descriptor_t L_value; /* value */
    descriptor_t L_temp_2;
    descriptor_t L_temp_3;
    void * L_result0; /* result0 */
    descriptor_t L_temp_4;

    /* #line {Class <unknown-source-location>} */

    /* #line 126 "./cmp.dylan" */

    /* #line 209 "./num.dylan" */
    if (((A_nargs & 1) == 0)) {
	/* #line {Class <unknown-source-location>} */
	L_args = ((void *)(orig_sp - A_nargs));
	L_pointer = 0;
	L_pointer_suppliedQUERY = FALSE;
	L_index = (A_nargs - 2);
	while (1) {
	    if ((L_index < 0)) {
		goto block0;
	    }
	    else {
		L_temp = (((descriptor_t *)L_args)[L_index]);

		/* #line 386 "./condition.dylan" */
		if ((&dylanZdylan_visceraZCLS_symbol_HEAP == SLOT(L_temp.heapptr, heapptr_t, 0))) {
		    /* #line {Class <unknown-source-location>} */
		    L_value = (((descriptor_t *)L_args)[(L_index + 1)]);
		    if ((L_temp.heapptr == &SYM_pointer_HEAP)) {

			/* #line 386 "./condition.dylan" */
			if ((&dylanZdylan_visceraZCLS_raw_pointer_HEAP == SLOT(L_value.heapptr, heapptr_t, 0))) {
			    /* #line {Class <unknown-source-location>} */
			    L_pointer = L_value.dataword.ptr;
			    L_pointer_suppliedQUERY = TRUE;
			}
			else {

			    /* #line 389 "./condition.dylan" */
			    L_temp_2.heapptr = &networkZstr_ROOT;
			    L_temp_2.dataword.l = 0;
			    /* type-error-with-location */
			    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_value, &dylanZdylan_visceraZCLS_raw_pointer_HEAP, L_temp_2);
			    not_reached();
			}
		    }
		    /* #line {Class <unknown-source-location>} */
		    L_index = (L_index - 2);
		}
		else {

		    /* #line 389 "./condition.dylan" */
		    L_temp_3.heapptr = &networkZstr_ROOT;
		    L_temp_3.dataword.l = 0;
		    /* type-error-with-location */
		    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp, &dylanZdylan_visceraZCLS_symbol_HEAP, L_temp_3);
		    not_reached();
		}
	    }
	}
      block0:;
	/* #line {Class <unknown-source-location>} */
	orig_sp = L_args;
	/* maker for <unsigned-long*> */
	L_result0 = networkZnetwork_internalZCLS_unsigned_longV_MAKER_FUN(orig_sp, L_pointer, L_pointer_suppliedQUERY);
	L_temp_4.heapptr = networkZliteral_35.heapptr;
	L_temp_4.dataword.ptr = L_result0;
	orig_sp[0] = L_temp_4;
	return orig_sp + 1;
    }
    else {
	/* odd-number-of-keyword/value-arguments-error */
	dylanZdylan_visceraZodd_number_of_keywordSLASHvalue_arguments_error_FUN(orig_sp);
	not_reached();
    }
}


/* Define Sealed Domain make (singleton(<unsigned-long*>)) */


/* Define Method pointer-value{<unsigned-long*>} */

extern struct heapobj networkZstr_ROOT_48;

/* pointer-value{<unsigned-long*>} */
long networkZnetwork_internalZpointer_value_METH_27(descriptor_t *orig_sp, descriptor_t A_ptr /* ptr */, heapptr_t A_next_method_info /* next-method-info */, heapptr_t A_rest /* rest */, descriptor_t A_index /* index */)
{
    descriptor_t *cluster_0_top;
    descriptor_t L_temp;
    descriptor_t L_arg2; /* arg2 */
    descriptor_t L_temp_2;


    /* #line 1576 "./sockets-api.dylan" */
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = 4;
    orig_sp[0] = A_index;
    orig_sp[1] = L_temp;
    /* * */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZV_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_arg2 = (orig_sp == cluster_0_top ? dylanZfalse : orig_sp[0]);

    /* #line 386 "./condition.dylan" */
    if ((&dylanZdylan_visceraZCLS_integer_HEAP == SLOT(L_arg2.heapptr, heapptr_t, 0))) {

	/* #line 1576 "./sockets-api.dylan" */

	/* #line 211 "./melange.dylan" */

	/* #line 91 "./rawptr.dylan" */
	return (*(long *)((char *)A_ptr.dataword.ptr + L_arg2.dataword.l ));
    }
    else {

	/* #line 389 "./condition.dylan" */
	L_temp_2.heapptr = &networkZstr_ROOT_48;
	L_temp_2.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_arg2, &dylanZdylan_visceraZCLS_integer_HEAP, L_temp_2);
	not_reached();
    }
}

/* generic-entry for pointer-value{<unsigned-long*>} */
descriptor_t * networkZnetwork_internalZpointer_value_METH_GENERIC_27(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    descriptor_t L_arg; /* arg */
    heapptr_t L_rest; /* rest */
    descriptor_t L_arg_2; /* arg */
    descriptor_t L_index; /* index */
    long L_index_2; /* index */
    descriptor_t L_key; /* key */
    descriptor_t L_value; /* value */
    long L_result0; /* result0 */
    descriptor_t L_temp;

    /* #line {Class <unknown-source-location>} */
    L_args = ((void *)(orig_sp - A_nargs));
    L_arg = (((descriptor_t *)L_args)[0]);
    L_rest = dylanZdylan_visceraZmake_rest_arg_FUN(orig_sp, (descriptor_t *)L_args + 1, A_nargs - 1);
    L_arg_2 = L_arg;
    L_index.heapptr = networkZliteral_2.heapptr;
    L_index.dataword.l = 0;
    L_index_2 = (A_nargs - 2);
    while (1) {
	if ((L_index_2 < 1)) {
	    goto block0;
	}
	else {
	    L_key = (((descriptor_t *)L_args)[L_index_2]);
	    L_value = (((descriptor_t *)L_args)[(L_index_2 + 1)]);
	    if ((L_key.heapptr == &SYM_index_HEAP)) {
		L_index = L_value;
	    }
	    L_index_2 = (L_index_2 - 2);
	}
    }
  block0:;
    orig_sp = L_args;
    /* pointer-value{<unsigned-long*>} */
    L_result0 = networkZnetwork_internalZpointer_value_METH_27(orig_sp, L_arg_2, A_next_method_info, L_rest, L_index);
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* Define Method pointer-value-setter{<integer>, <unsigned-long*>} */

/* pointer-value-setter{<integer>, <unsigned-long*>} */
long networkZnetwork_internalZpointer_value_setter_METH_7(descriptor_t *orig_sp, long A_value /* value */, descriptor_t A_ptr /* ptr */, heapptr_t A_next_method_info /* next-method-info */, heapptr_t A_rest /* rest */, descriptor_t A_index /* index */)
{
    descriptor_t *cluster_0_top;
    descriptor_t L_temp;
    descriptor_t L_arg3; /* arg3 */
    descriptor_t L_temp_2;


    /* #line 1582 "./sockets-api.dylan" */
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = 4;
    orig_sp[0] = A_index;
    orig_sp[1] = L_temp;
    /* * */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZV_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_arg3 = (orig_sp == cluster_0_top ? dylanZfalse : orig_sp[0]);

    /* #line 386 "./condition.dylan" */
    if ((&dylanZdylan_visceraZCLS_integer_HEAP == SLOT(L_arg3.heapptr, heapptr_t, 0))) {
	/* #line {Class <unknown-source-location>} */

	/* #line 97 "./rawptr.dylan" */
	*(long *)((char *)A_ptr.dataword.ptr + L_arg3.dataword.l) = A_value;
	return A_value;
    }
    else {

	/* #line 389 "./condition.dylan" */
	L_temp_2.heapptr = &networkZstr_ROOT;
	L_temp_2.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_arg3, &dylanZdylan_visceraZCLS_integer_HEAP, L_temp_2);
	not_reached();
    }
}

/* generic-entry for pointer-value-setter{<integer>, <unsigned-long*>} */
descriptor_t * networkZnetwork_internalZpointer_value_setter_METH_GENERIC_7(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    descriptor_t L_arg; /* arg */
    descriptor_t L_arg_2; /* arg */
    heapptr_t L_rest; /* rest */
    long L_arg_3; /* arg */
    descriptor_t L_arg_4; /* arg */
    descriptor_t L_index; /* index */
    long L_index_2; /* index */
    descriptor_t L_key; /* key */
    descriptor_t L_value; /* value */
    long L_result0; /* result0 */
    descriptor_t L_temp;

    /* #line {Class <unknown-source-location>} */
    L_args = ((void *)(orig_sp - A_nargs));
    L_arg = (((descriptor_t *)L_args)[0]);
    L_arg_2 = (((descriptor_t *)L_args)[1]);
    L_rest = dylanZdylan_visceraZmake_rest_arg_FUN(orig_sp, (descriptor_t *)L_args + 2, A_nargs - 2);
    L_arg_3 = L_arg.dataword.l;
    L_arg_4 = L_arg_2;
    L_index.heapptr = networkZliteral_2.heapptr;
    L_index.dataword.l = 0;
    L_index_2 = (A_nargs - 2);
    while (1) {
	if ((L_index_2 < 2)) {
	    goto block0;
	}
	else {
	    L_key = (((descriptor_t *)L_args)[L_index_2]);
	    L_value = (((descriptor_t *)L_args)[(L_index_2 + 1)]);
	    if ((L_key.heapptr == &SYM_index_HEAP)) {
		L_index = L_value;
	    }
	    L_index_2 = (L_index_2 - 2);
	}
    }
  block0:;
    orig_sp = L_args;
    /* pointer-value-setter{<integer>, <unsigned-long*>} */
    L_result0 = networkZnetwork_internalZpointer_value_setter_METH_7(orig_sp, L_arg_3, L_arg_4, A_next_method_info, L_rest, L_index);
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* Define Method content-size{subclass(<unsigned-long*>)} */

/* content-size{subclass(<unsigned-long*>)} */
long networkZnetwork_internalZcontent_size_METH_33(descriptor_t *orig_sp, heapptr_t A0, heapptr_t A1)
{

    return 4;
}

/* generic-entry for content-size{subclass(<unsigned-long*>)} */
descriptor_t * networkZnetwork_internalZcontent_size_METH_GENERIC_33(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    descriptor_t L_arg; /* arg */
    heapptr_t L_arg_2; /* arg */
    long L_result0; /* result0 */
    descriptor_t L_temp;

    L_args = ((void *)(orig_sp - 1));
    L_arg = (((descriptor_t *)L_args)[0]);
    L_arg_2 = L_arg.heapptr;
    orig_sp = L_args;
    /* content-size{subclass(<unsigned-long*>)} */
    L_result0 = networkZnetwork_internalZcontent_size_METH_33(orig_sp, L_arg_2, A_next_method_info);
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* Define Class <unsigned-long<@32>> */

/* <unsigned-long<@32>> is <unsigned-long<@32>> */

extern struct heapobj networkZnetwork_internalZCLS_unsigned_longLESSX4032GREATER_HEAP;

/* maker for <unsigned-long<@32>> */
void * networkZnetwork_internalZCLS_unsigned_longLESSX4032GREATER_MAKER_FUN(descriptor_t *orig_sp, void * A_pointer /* pointer */, int A_pointer_suppliedQUERY /* pointer-supplied? */)
{
    descriptor_t *cluster_0_top;


    /* #line 1590 "./sockets-api.dylan" */
    if (A_pointer_suppliedQUERY) {
	return A_pointer;
    }
    else {
	/* missing-required-init-keyword-error */
	dylanZdylan_visceraZmissing_required_init_keyword_error_FUN(orig_sp, &SYM_pointer_HEAP, &networkZnetwork_internalZCLS_unsigned_longLESSX4032GREATER_HEAP);
	not_reached();
    }
}

extern descriptor_t networkZliteral_36;	/* proxy for <unsigned-long<@32>> */

/* general-entry for maker for <unsigned-long<@32>> */
descriptor_t * networkZnetwork_internalZCLS_unsigned_longLESSX4032GREATER_MAKER_GENERAL(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    void * L_pointer; /* pointer */
    int L_pointer_suppliedQUERY; /* pointer-supplied? */
    long L_index; /* index */
    descriptor_t L_temp; /* temp */
    descriptor_t L_value; /* value */
    descriptor_t L_temp_2;
    descriptor_t L_temp_3;
    void * L_result0; /* result0 */
    descriptor_t L_temp_4;

    /* #line {Class <unknown-source-location>} */

    /* #line 126 "./cmp.dylan" */

    /* #line 209 "./num.dylan" */
    if (((A_nargs & 1) == 0)) {
	/* #line {Class <unknown-source-location>} */
	L_args = ((void *)(orig_sp - A_nargs));
	L_pointer = 0;
	L_pointer_suppliedQUERY = FALSE;
	L_index = (A_nargs - 2);
	while (1) {
	    if ((L_index < 0)) {
		goto block0;
	    }
	    else {
		L_temp = (((descriptor_t *)L_args)[L_index]);

		/* #line 386 "./condition.dylan" */
		if ((&dylanZdylan_visceraZCLS_symbol_HEAP == SLOT(L_temp.heapptr, heapptr_t, 0))) {
		    /* #line {Class <unknown-source-location>} */
		    L_value = (((descriptor_t *)L_args)[(L_index + 1)]);
		    if ((L_temp.heapptr == &SYM_pointer_HEAP)) {

			/* #line 386 "./condition.dylan" */
			if ((&dylanZdylan_visceraZCLS_raw_pointer_HEAP == SLOT(L_value.heapptr, heapptr_t, 0))) {
			    /* #line {Class <unknown-source-location>} */
			    L_pointer = L_value.dataword.ptr;
			    L_pointer_suppliedQUERY = TRUE;
			}
			else {

			    /* #line 389 "./condition.dylan" */
			    L_temp_2.heapptr = &networkZstr_ROOT;
			    L_temp_2.dataword.l = 0;
			    /* type-error-with-location */
			    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_value, &dylanZdylan_visceraZCLS_raw_pointer_HEAP, L_temp_2);
			    not_reached();
			}
		    }
		    /* #line {Class <unknown-source-location>} */
		    L_index = (L_index - 2);
		}
		else {

		    /* #line 389 "./condition.dylan" */
		    L_temp_3.heapptr = &networkZstr_ROOT;
		    L_temp_3.dataword.l = 0;
		    /* type-error-with-location */
		    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp, &dylanZdylan_visceraZCLS_symbol_HEAP, L_temp_3);
		    not_reached();
		}
	    }
	}
      block0:;
	/* #line {Class <unknown-source-location>} */
	orig_sp = L_args;
	/* maker for <unsigned-long<@32>> */
	L_result0 = networkZnetwork_internalZCLS_unsigned_longLESSX4032GREATER_MAKER_FUN(orig_sp, L_pointer, L_pointer_suppliedQUERY);
	L_temp_4.heapptr = networkZliteral_36.heapptr;
	L_temp_4.dataword.ptr = L_result0;
	orig_sp[0] = L_temp_4;
	return orig_sp + 1;
    }
    else {
	/* odd-number-of-keyword/value-arguments-error */
	dylanZdylan_visceraZodd_number_of_keywordSLASHvalue_arguments_error_FUN(orig_sp);
	not_reached();
    }
}


/* Define Sealed Domain make (singleton(<unsigned-long<@32>>)) */


/* Define Method content-size{singleton(<unsigned-long<@32>>)} */

/* content-size{singleton(<unsigned-long<@32>>)} */
long networkZnetwork_internalZcontent_size_METH_34(descriptor_t *orig_sp, heapptr_t A0, heapptr_t A1)
{

    return 32;
}

/* generic-entry for content-size{singleton(<unsigned-long<@32>>)} */
descriptor_t * networkZnetwork_internalZcontent_size_METH_GENERIC_34(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    long L_result0; /* result0 */
    descriptor_t L_temp;

    orig_sp = ((void *)(orig_sp - 1));
    /* content-size{singleton(<unsigned-long<@32>>)} */
    L_result0 = networkZnetwork_internalZcontent_size_METH_34(orig_sp, &networkZnetwork_internalZCLS_unsigned_longLESSX4032GREATER_HEAP, A_next_method_info);
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* Define Class <__sigset-t> */

/* <__sigset-t> is <__sigset-t> */

extern struct heapobj networkZnetwork_internalZCLS_X_X_sigset_t_HEAP;

/* maker for <__sigset-t> */
void * networkZnetwork_internalZCLS_X_X_sigset_t_MAKER_FUN(descriptor_t *orig_sp, void * A_pointer /* pointer */, int A_pointer_suppliedQUERY /* pointer-supplied? */)
{
    descriptor_t *cluster_0_top;


    /* #line 1598 "./sockets-api.dylan" */
    if (A_pointer_suppliedQUERY) {
	return A_pointer;
    }
    else {
	/* missing-required-init-keyword-error */
	dylanZdylan_visceraZmissing_required_init_keyword_error_FUN(orig_sp, &SYM_pointer_HEAP, &networkZnetwork_internalZCLS_X_X_sigset_t_HEAP);
	not_reached();
    }
}

extern descriptor_t networkZliteral_37;	/* proxy for <__sigset-t> */

/* general-entry for maker for <__sigset-t> */
descriptor_t * networkZnetwork_internalZCLS_X_X_sigset_t_MAKER_GENERAL(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    void * L_pointer; /* pointer */
    int L_pointer_suppliedQUERY; /* pointer-supplied? */
    long L_index; /* index */
    descriptor_t L_temp; /* temp */
    descriptor_t L_value; /* value */
    descriptor_t L_temp_2;
    descriptor_t L_temp_3;
    void * L_result0; /* result0 */
    descriptor_t L_temp_4;

    /* #line {Class <unknown-source-location>} */

    /* #line 126 "./cmp.dylan" */

    /* #line 209 "./num.dylan" */
    if (((A_nargs & 1) == 0)) {
	/* #line {Class <unknown-source-location>} */
	L_args = ((void *)(orig_sp - A_nargs));
	L_pointer = 0;
	L_pointer_suppliedQUERY = FALSE;
	L_index = (A_nargs - 2);
	while (1) {
	    if ((L_index < 0)) {
		goto block0;
	    }
	    else {
		L_temp = (((descriptor_t *)L_args)[L_index]);

		/* #line 386 "./condition.dylan" */
		if ((&dylanZdylan_visceraZCLS_symbol_HEAP == SLOT(L_temp.heapptr, heapptr_t, 0))) {
		    /* #line {Class <unknown-source-location>} */
		    L_value = (((descriptor_t *)L_args)[(L_index + 1)]);
		    if ((L_temp.heapptr == &SYM_pointer_HEAP)) {

			/* #line 386 "./condition.dylan" */
			if ((&dylanZdylan_visceraZCLS_raw_pointer_HEAP == SLOT(L_value.heapptr, heapptr_t, 0))) {
			    /* #line {Class <unknown-source-location>} */
			    L_pointer = L_value.dataword.ptr;
			    L_pointer_suppliedQUERY = TRUE;
			}
			else {

			    /* #line 389 "./condition.dylan" */
			    L_temp_2.heapptr = &networkZstr_ROOT;
			    L_temp_2.dataword.l = 0;
			    /* type-error-with-location */
			    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_value, &dylanZdylan_visceraZCLS_raw_pointer_HEAP, L_temp_2);
			    not_reached();
			}
		    }
		    /* #line {Class <unknown-source-location>} */
		    L_index = (L_index - 2);
		}
		else {

		    /* #line 389 "./condition.dylan" */
		    L_temp_3.heapptr = &networkZstr_ROOT;
		    L_temp_3.dataword.l = 0;
		    /* type-error-with-location */
		    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp, &dylanZdylan_visceraZCLS_symbol_HEAP, L_temp_3);
		    not_reached();
		}
	    }
	}
      block0:;
	/* #line {Class <unknown-source-location>} */
	orig_sp = L_args;
	/* maker for <__sigset-t> */
	L_result0 = networkZnetwork_internalZCLS_X_X_sigset_t_MAKER_FUN(orig_sp, L_pointer, L_pointer_suppliedQUERY);
	L_temp_4.heapptr = networkZliteral_37.heapptr;
	L_temp_4.dataword.ptr = L_result0;
	orig_sp[0] = L_temp_4;
	return orig_sp + 1;
    }
    else {
	/* odd-number-of-keyword/value-arguments-error */
	dylanZdylan_visceraZodd_number_of_keywordSLASHvalue_arguments_error_FUN(orig_sp);
	not_reached();
    }
}


/* Define Sealed Domain make (singleton(<__sigset-t>)) */


/* Define Method get-__val{<__sigset-t>} */

extern struct heapobj networkZstr_ROOT_49;

/* get-__val{<__sigset-t>} */
void * networkZnetwork_internalZget_X_X_val_METH_4(descriptor_t *orig_sp, void * A_ptr /* ptr */, heapptr_t A1)
{
    descriptor_t *cluster_0_top;
    descriptor_t L_temp;
    descriptor_t L_temp_2;
    descriptor_t L_temp_3;
    descriptor_t L_temp_4; /* temp */
    int L_condition; /* condition */
    descriptor_t L_temp_5;
    descriptor_t L_temp_6; /* temp */
    descriptor_t L_temp_7;
    descriptor_t L_temp_8;


    /* #line 49 "./object.dylan" */
    L_temp.heapptr = networkZliteral_37.heapptr;
    L_temp.dataword.ptr = A_ptr;

    /* #line 324 "./melange.dylan" */

    /* #line 324 "./melange.dylan" */

    /* #line 324 "./melange.dylan" */
    L_temp_2.heapptr = SLOT(L_temp.heapptr, heapptr_t, 0);
    L_temp_2.dataword.l = 0;
    L_temp_3.heapptr = networkZliteral_6.heapptr;
    L_temp_3.dataword.ptr = ((void *)((char *)A_ptr + 0));
    orig_sp[0] = L_temp_2;
    orig_sp[1] = L_temp_3;
    /* as */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZas_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_temp_4 = orig_sp[0];

    /* #line 49 "./object.dylan" */

    /* #line 386 "./condition.dylan" */
    /* %subtype?{<class>, <class>} */
    L_condition = dylanZdylan_visceraZPCTsubtypeQUERY_METH(orig_sp, SLOT(L_temp_4.heapptr, heapptr_t, 0), &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP, &dylanZliteral_ROOT_2);
    if (L_condition) {

	/* #line 324 "./melange.dylan" */

	/* #line 1604 "./sockets-api.dylan" */
	L_temp_5.heapptr = &networkZnetwork_internalZCLS_unsigned_longLESSX4032GREATER_HEAP;
	L_temp_5.dataword.l = 0;
	orig_sp[0] = L_temp_5;
	orig_sp[1] = L_temp_4;
	/* as */
	{
	  struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZas_HEAP, 2);
	  heapptr_t L_meth = L_temp.R0;
	  heapptr_t L_next_info = L_temp.R1;
	  cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
	}
	L_temp_6 = orig_sp[0];

	/* #line 386 "./condition.dylan" */
	if ((&networkZnetwork_internalZCLS_unsigned_longLESSX4032GREATER_HEAP == SLOT(L_temp_6.heapptr, heapptr_t, 0))) {

	    /* #line 1604 "./sockets-api.dylan" */
	    return L_temp_6.dataword.ptr;
	}
	else {

	    /* #line 389 "./condition.dylan" */
	    L_temp_7.heapptr = &networkZstr_ROOT_49;
	    L_temp_7.dataword.l = 0;
	    /* type-error-with-location */
	    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp_6, &networkZnetwork_internalZCLS_unsigned_longLESSX4032GREATER_HEAP, L_temp_7);
	    not_reached();
	}
    }
    else {
	L_temp_8.heapptr = &networkZstr_ROOT_5;
	L_temp_8.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp_4, &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP, L_temp_8);
	not_reached();
    }
}


/* Define Method pointer-value{<__sigset-t>} */

extern struct heapobj networkZstr_ROOT_50;

/* pointer-value{<__sigset-t>} */
void * networkZnetwork_internalZpointer_value_METH_28(descriptor_t *orig_sp, void * A_value /* value */, heapptr_t A_next_method_info /* next-method-info */, heapptr_t A_rest /* rest */, descriptor_t A_index /* index */)
{
    descriptor_t *cluster_0_top;
    descriptor_t L_temp;
    descriptor_t L_arg1; /* arg1 */
    descriptor_t L_temp_2;
    descriptor_t L_temp_3; /* temp */
    descriptor_t L_temp_4;

    /* #line {Class <unknown-source-location>} */

    /* #line 1608 "./sockets-api.dylan" */
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = 128;
    orig_sp[0] = A_index;
    orig_sp[1] = L_temp;
    /* * */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZV_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_arg1 = (orig_sp == cluster_0_top ? dylanZfalse : orig_sp[0]);

    /* #line 1608 "./sockets-api.dylan" */
    L_temp_2.heapptr = networkZliteral_37.heapptr;
    L_temp_2.dataword.ptr = A_value;
    orig_sp[0] = L_temp_2;
    orig_sp[1] = L_arg1;
    /* + */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZPLUS_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_temp_3 = (orig_sp == cluster_0_top ? dylanZfalse : orig_sp[0]);

    /* #line 386 "./condition.dylan" */
    if ((&networkZnetwork_internalZCLS_X_X_sigset_t_HEAP == SLOT(L_temp_3.heapptr, heapptr_t, 0))) {

	/* #line 1608 "./sockets-api.dylan" */
	return L_temp_3.dataword.ptr;
    }
    else {

	/* #line 389 "./condition.dylan" */
	L_temp_4.heapptr = &networkZstr_ROOT_50;
	L_temp_4.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp_3, &networkZnetwork_internalZCLS_X_X_sigset_t_HEAP, L_temp_4);
	not_reached();
    }
}

/* generic-entry for pointer-value{<__sigset-t>} */
descriptor_t * networkZnetwork_internalZpointer_value_METH_GENERIC_28(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    descriptor_t L_arg; /* arg */
    heapptr_t L_rest; /* rest */
    void * L_arg_2; /* arg */
    descriptor_t L_index; /* index */
    long L_index_2; /* index */
    descriptor_t L_key; /* key */
    descriptor_t L_value; /* value */
    void * L_result0; /* result0 */
    descriptor_t L_temp;

    /* #line {Class <unknown-source-location>} */
    L_args = ((void *)(orig_sp - A_nargs));
    L_arg = (((descriptor_t *)L_args)[0]);
    L_rest = dylanZdylan_visceraZmake_rest_arg_FUN(orig_sp, (descriptor_t *)L_args + 1, A_nargs - 1);
    L_arg_2 = L_arg.dataword.ptr;
    L_index.heapptr = networkZliteral_2.heapptr;
    L_index.dataword.l = 0;
    L_index_2 = (A_nargs - 2);
    while (1) {
	if ((L_index_2 < 1)) {
	    goto block0;
	}
	else {
	    L_key = (((descriptor_t *)L_args)[L_index_2]);
	    L_value = (((descriptor_t *)L_args)[(L_index_2 + 1)]);
	    if ((L_key.heapptr == &SYM_index_HEAP)) {
		L_index = L_value;
	    }
	    L_index_2 = (L_index_2 - 2);
	}
    }
  block0:;
    orig_sp = L_args;
    /* pointer-value{<__sigset-t>} */
    L_result0 = networkZnetwork_internalZpointer_value_METH_28(orig_sp, L_arg_2, A_next_method_info, L_rest, L_index);
    L_temp.heapptr = networkZliteral_37.heapptr;
    L_temp.dataword.ptr = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* Define Method content-size{subclass(<__sigset-t>)} */

/* content-size{subclass(<__sigset-t>)} */
long networkZnetwork_internalZcontent_size_METH_35(descriptor_t *orig_sp, heapptr_t A0, heapptr_t A1)
{

    return 128;
}

/* generic-entry for content-size{subclass(<__sigset-t>)} */
descriptor_t * networkZnetwork_internalZcontent_size_METH_GENERIC_35(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    long L_result0; /* result0 */
    descriptor_t L_temp;

    orig_sp = ((void *)(orig_sp - 1));
    /* content-size{subclass(<__sigset-t>)} */
    L_result0 = networkZnetwork_internalZcontent_size_METH_35(orig_sp, &networkZnetwork_internalZCLS_X_X_sigset_t_HEAP, A_next_method_info);
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* Define Constant <sigset-t> */

/* <sigset-t> is <__sigset-t> */


/* Define Constant <__suseconds-t> */

/* <__suseconds-t> is <integer> */


/* Define Constant <suseconds-t> */

/* <suseconds-t> is <integer> */


/* Define Constant <__fd-mask> */

/* <__fd-mask> is <integer> */


/* Define Class <__fd-mask*> */

/* <__fd-mask*> is <__fd-mask*> */

extern struct heapobj networkZnetwork_internalZCLS_X_X_fd_maskV_HEAP;

/* maker for <__fd-mask*> */
void * networkZnetwork_internalZCLS_X_X_fd_maskV_MAKER_FUN(descriptor_t *orig_sp, void * A_pointer /* pointer */, int A_pointer_suppliedQUERY /* pointer-supplied? */)
{
    descriptor_t *cluster_0_top;


    /* #line 1623 "./sockets-api.dylan" */
    if (A_pointer_suppliedQUERY) {
	return A_pointer;
    }
    else {
	/* missing-required-init-keyword-error */
	dylanZdylan_visceraZmissing_required_init_keyword_error_FUN(orig_sp, &SYM_pointer_HEAP, &networkZnetwork_internalZCLS_X_X_fd_maskV_HEAP);
	not_reached();
    }
}

extern descriptor_t networkZliteral_38;	/* proxy for <__fd-mask*> */

/* general-entry for maker for <__fd-mask*> */
descriptor_t * networkZnetwork_internalZCLS_X_X_fd_maskV_MAKER_GENERAL(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    void * L_pointer; /* pointer */
    int L_pointer_suppliedQUERY; /* pointer-supplied? */
    long L_index; /* index */
    descriptor_t L_temp; /* temp */
    descriptor_t L_value; /* value */
    descriptor_t L_temp_2;
    descriptor_t L_temp_3;
    void * L_result0; /* result0 */
    descriptor_t L_temp_4;

    /* #line {Class <unknown-source-location>} */

    /* #line 126 "./cmp.dylan" */

    /* #line 209 "./num.dylan" */
    if (((A_nargs & 1) == 0)) {
	/* #line {Class <unknown-source-location>} */
	L_args = ((void *)(orig_sp - A_nargs));
	L_pointer = 0;
	L_pointer_suppliedQUERY = FALSE;
	L_index = (A_nargs - 2);
	while (1) {
	    if ((L_index < 0)) {
		goto block0;
	    }
	    else {
		L_temp = (((descriptor_t *)L_args)[L_index]);

		/* #line 386 "./condition.dylan" */
		if ((&dylanZdylan_visceraZCLS_symbol_HEAP == SLOT(L_temp.heapptr, heapptr_t, 0))) {
		    /* #line {Class <unknown-source-location>} */
		    L_value = (((descriptor_t *)L_args)[(L_index + 1)]);
		    if ((L_temp.heapptr == &SYM_pointer_HEAP)) {

			/* #line 386 "./condition.dylan" */
			if ((&dylanZdylan_visceraZCLS_raw_pointer_HEAP == SLOT(L_value.heapptr, heapptr_t, 0))) {
			    /* #line {Class <unknown-source-location>} */
			    L_pointer = L_value.dataword.ptr;
			    L_pointer_suppliedQUERY = TRUE;
			}
			else {

			    /* #line 389 "./condition.dylan" */
			    L_temp_2.heapptr = &networkZstr_ROOT;
			    L_temp_2.dataword.l = 0;
			    /* type-error-with-location */
			    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_value, &dylanZdylan_visceraZCLS_raw_pointer_HEAP, L_temp_2);
			    not_reached();
			}
		    }
		    /* #line {Class <unknown-source-location>} */
		    L_index = (L_index - 2);
		}
		else {

		    /* #line 389 "./condition.dylan" */
		    L_temp_3.heapptr = &networkZstr_ROOT;
		    L_temp_3.dataword.l = 0;
		    /* type-error-with-location */
		    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp, &dylanZdylan_visceraZCLS_symbol_HEAP, L_temp_3);
		    not_reached();
		}
	    }
	}
      block0:;
	/* #line {Class <unknown-source-location>} */
	orig_sp = L_args;
	/* maker for <__fd-mask*> */
	L_result0 = networkZnetwork_internalZCLS_X_X_fd_maskV_MAKER_FUN(orig_sp, L_pointer, L_pointer_suppliedQUERY);
	L_temp_4.heapptr = networkZliteral_38.heapptr;
	L_temp_4.dataword.ptr = L_result0;
	orig_sp[0] = L_temp_4;
	return orig_sp + 1;
    }
    else {
	/* odd-number-of-keyword/value-arguments-error */
	dylanZdylan_visceraZodd_number_of_keywordSLASHvalue_arguments_error_FUN(orig_sp);
	not_reached();
    }
}


/* Define Sealed Domain make (singleton(<__fd-mask*>)) */


/* Define Method pointer-value{<__fd-mask*>} */

extern struct heapobj networkZstr_ROOT_51;

/* pointer-value{<__fd-mask*>} */
long networkZnetwork_internalZpointer_value_METH_29(descriptor_t *orig_sp, descriptor_t A_ptr /* ptr */, heapptr_t A_next_method_info /* next-method-info */, heapptr_t A_rest /* rest */, descriptor_t A_index /* index */)
{
    descriptor_t *cluster_0_top;
    descriptor_t L_temp;
    descriptor_t L_arg2; /* arg2 */
    descriptor_t L_temp_2;


    /* #line 1630 "./sockets-api.dylan" */
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = 4;
    orig_sp[0] = A_index;
    orig_sp[1] = L_temp;
    /* * */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZV_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_arg2 = (orig_sp == cluster_0_top ? dylanZfalse : orig_sp[0]);

    /* #line 386 "./condition.dylan" */
    if ((&dylanZdylan_visceraZCLS_integer_HEAP == SLOT(L_arg2.heapptr, heapptr_t, 0))) {

	/* #line 1630 "./sockets-api.dylan" */

	/* #line 198 "./melange.dylan" */

	/* #line 91 "./rawptr.dylan" */
	return (*(long *)((char *)A_ptr.dataword.ptr + L_arg2.dataword.l ));
    }
    else {

	/* #line 389 "./condition.dylan" */
	L_temp_2.heapptr = &networkZstr_ROOT_51;
	L_temp_2.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_arg2, &dylanZdylan_visceraZCLS_integer_HEAP, L_temp_2);
	not_reached();
    }
}

/* generic-entry for pointer-value{<__fd-mask*>} */
descriptor_t * networkZnetwork_internalZpointer_value_METH_GENERIC_29(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    descriptor_t L_arg; /* arg */
    heapptr_t L_rest; /* rest */
    descriptor_t L_arg_2; /* arg */
    descriptor_t L_index; /* index */
    long L_index_2; /* index */
    descriptor_t L_key; /* key */
    descriptor_t L_value; /* value */
    long L_result0; /* result0 */
    descriptor_t L_temp;

    /* #line {Class <unknown-source-location>} */
    L_args = ((void *)(orig_sp - A_nargs));
    L_arg = (((descriptor_t *)L_args)[0]);
    L_rest = dylanZdylan_visceraZmake_rest_arg_FUN(orig_sp, (descriptor_t *)L_args + 1, A_nargs - 1);
    L_arg_2 = L_arg;
    L_index.heapptr = networkZliteral_2.heapptr;
    L_index.dataword.l = 0;
    L_index_2 = (A_nargs - 2);
    while (1) {
	if ((L_index_2 < 1)) {
	    goto block0;
	}
	else {
	    L_key = (((descriptor_t *)L_args)[L_index_2]);
	    L_value = (((descriptor_t *)L_args)[(L_index_2 + 1)]);
	    if ((L_key.heapptr == &SYM_index_HEAP)) {
		L_index = L_value;
	    }
	    L_index_2 = (L_index_2 - 2);
	}
    }
  block0:;
    orig_sp = L_args;
    /* pointer-value{<__fd-mask*>} */
    L_result0 = networkZnetwork_internalZpointer_value_METH_29(orig_sp, L_arg_2, A_next_method_info, L_rest, L_index);
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* Define Method pointer-value-setter{<integer>, <__fd-mask*>} */

/* pointer-value-setter{<integer>, <__fd-mask*>} */
long networkZnetwork_internalZpointer_value_setter_METH_8(descriptor_t *orig_sp, long A_value /* value */, descriptor_t A_ptr /* ptr */, heapptr_t A_next_method_info /* next-method-info */, heapptr_t A_rest /* rest */, descriptor_t A_index /* index */)
{
    descriptor_t *cluster_0_top;
    descriptor_t L_temp;
    descriptor_t L_arg3; /* arg3 */
    descriptor_t L_temp_2;


    /* #line 1636 "./sockets-api.dylan" */
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = 4;
    orig_sp[0] = A_index;
    orig_sp[1] = L_temp;
    /* * */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZV_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_arg3 = (orig_sp == cluster_0_top ? dylanZfalse : orig_sp[0]);

    /* #line 386 "./condition.dylan" */
    if ((&dylanZdylan_visceraZCLS_integer_HEAP == SLOT(L_arg3.heapptr, heapptr_t, 0))) {
	/* #line {Class <unknown-source-location>} */

	/* #line 97 "./rawptr.dylan" */
	*(long *)((char *)A_ptr.dataword.ptr + L_arg3.dataword.l) = A_value;
	return A_value;
    }
    else {

	/* #line 389 "./condition.dylan" */
	L_temp_2.heapptr = &networkZstr_ROOT;
	L_temp_2.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_arg3, &dylanZdylan_visceraZCLS_integer_HEAP, L_temp_2);
	not_reached();
    }
}

/* generic-entry for pointer-value-setter{<integer>, <__fd-mask*>} */
descriptor_t * networkZnetwork_internalZpointer_value_setter_METH_GENERIC_8(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    descriptor_t L_arg; /* arg */
    descriptor_t L_arg_2; /* arg */
    heapptr_t L_rest; /* rest */
    long L_arg_3; /* arg */
    descriptor_t L_arg_4; /* arg */
    descriptor_t L_index; /* index */
    long L_index_2; /* index */
    descriptor_t L_key; /* key */
    descriptor_t L_value; /* value */
    long L_result0; /* result0 */
    descriptor_t L_temp;

    /* #line {Class <unknown-source-location>} */
    L_args = ((void *)(orig_sp - A_nargs));
    L_arg = (((descriptor_t *)L_args)[0]);
    L_arg_2 = (((descriptor_t *)L_args)[1]);
    L_rest = dylanZdylan_visceraZmake_rest_arg_FUN(orig_sp, (descriptor_t *)L_args + 2, A_nargs - 2);
    L_arg_3 = L_arg.dataword.l;
    L_arg_4 = L_arg_2;
    L_index.heapptr = networkZliteral_2.heapptr;
    L_index.dataword.l = 0;
    L_index_2 = (A_nargs - 2);
    while (1) {
	if ((L_index_2 < 2)) {
	    goto block0;
	}
	else {
	    L_key = (((descriptor_t *)L_args)[L_index_2]);
	    L_value = (((descriptor_t *)L_args)[(L_index_2 + 1)]);
	    if ((L_key.heapptr == &SYM_index_HEAP)) {
		L_index = L_value;
	    }
	    L_index_2 = (L_index_2 - 2);
	}
    }
  block0:;
    orig_sp = L_args;
    /* pointer-value-setter{<integer>, <__fd-mask*>} */
    L_result0 = networkZnetwork_internalZpointer_value_setter_METH_8(orig_sp, L_arg_3, L_arg_4, A_next_method_info, L_rest, L_index);
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* Define Method content-size{subclass(<__fd-mask*>)} */

/* content-size{subclass(<__fd-mask*>)} */
long networkZnetwork_internalZcontent_size_METH_36(descriptor_t *orig_sp, heapptr_t A0, heapptr_t A1)
{

    return 4;
}

/* generic-entry for content-size{subclass(<__fd-mask*>)} */
descriptor_t * networkZnetwork_internalZcontent_size_METH_GENERIC_36(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    descriptor_t L_arg; /* arg */
    heapptr_t L_arg_2; /* arg */
    long L_result0; /* result0 */
    descriptor_t L_temp;

    L_args = ((void *)(orig_sp - 1));
    L_arg = (((descriptor_t *)L_args)[0]);
    L_arg_2 = L_arg.heapptr;
    orig_sp = L_args;
    /* content-size{subclass(<__fd-mask*>)} */
    L_result0 = networkZnetwork_internalZcontent_size_METH_36(orig_sp, L_arg_2, A_next_method_info);
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* Define Class <__fd-mask<@32>> */

/* <__fd-mask<@32>> is <__fd-mask<@32>> */

extern struct heapobj networkZnetwork_internalZCLS_X_X_fd_maskLESSX4032GREATER_HEAP;

/* maker for <__fd-mask<@32>> */
void * networkZnetwork_internalZCLS_X_X_fd_maskLESSX4032GREATER_MAKER_FUN(descriptor_t *orig_sp, void * A_pointer /* pointer */, int A_pointer_suppliedQUERY /* pointer-supplied? */)
{
    descriptor_t *cluster_0_top;


    /* #line 1644 "./sockets-api.dylan" */
    if (A_pointer_suppliedQUERY) {
	return A_pointer;
    }
    else {
	/* missing-required-init-keyword-error */
	dylanZdylan_visceraZmissing_required_init_keyword_error_FUN(orig_sp, &SYM_pointer_HEAP, &networkZnetwork_internalZCLS_X_X_fd_maskLESSX4032GREATER_HEAP);
	not_reached();
    }
}

extern descriptor_t networkZliteral_39;	/* proxy for <__fd-mask<@32>> */

/* general-entry for maker for <__fd-mask<@32>> */
descriptor_t * networkZnetwork_internalZCLS_X_X_fd_maskLESSX4032GREATER_MAKER_GENERAL(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    void * L_pointer; /* pointer */
    int L_pointer_suppliedQUERY; /* pointer-supplied? */
    long L_index; /* index */
    descriptor_t L_temp; /* temp */
    descriptor_t L_value; /* value */
    descriptor_t L_temp_2;
    descriptor_t L_temp_3;
    void * L_result0; /* result0 */
    descriptor_t L_temp_4;

    /* #line {Class <unknown-source-location>} */

    /* #line 126 "./cmp.dylan" */

    /* #line 209 "./num.dylan" */
    if (((A_nargs & 1) == 0)) {
	/* #line {Class <unknown-source-location>} */
	L_args = ((void *)(orig_sp - A_nargs));
	L_pointer = 0;
	L_pointer_suppliedQUERY = FALSE;
	L_index = (A_nargs - 2);
	while (1) {
	    if ((L_index < 0)) {
		goto block0;
	    }
	    else {
		L_temp = (((descriptor_t *)L_args)[L_index]);

		/* #line 386 "./condition.dylan" */
		if ((&dylanZdylan_visceraZCLS_symbol_HEAP == SLOT(L_temp.heapptr, heapptr_t, 0))) {
		    /* #line {Class <unknown-source-location>} */
		    L_value = (((descriptor_t *)L_args)[(L_index + 1)]);
		    if ((L_temp.heapptr == &SYM_pointer_HEAP)) {

			/* #line 386 "./condition.dylan" */
			if ((&dylanZdylan_visceraZCLS_raw_pointer_HEAP == SLOT(L_value.heapptr, heapptr_t, 0))) {
			    /* #line {Class <unknown-source-location>} */
			    L_pointer = L_value.dataword.ptr;
			    L_pointer_suppliedQUERY = TRUE;
			}
			else {

			    /* #line 389 "./condition.dylan" */
			    L_temp_2.heapptr = &networkZstr_ROOT;
			    L_temp_2.dataword.l = 0;
			    /* type-error-with-location */
			    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_value, &dylanZdylan_visceraZCLS_raw_pointer_HEAP, L_temp_2);
			    not_reached();
			}
		    }
		    /* #line {Class <unknown-source-location>} */
		    L_index = (L_index - 2);
		}
		else {

		    /* #line 389 "./condition.dylan" */
		    L_temp_3.heapptr = &networkZstr_ROOT;
		    L_temp_3.dataword.l = 0;
		    /* type-error-with-location */
		    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp, &dylanZdylan_visceraZCLS_symbol_HEAP, L_temp_3);
		    not_reached();
		}
	    }
	}
      block0:;
	/* #line {Class <unknown-source-location>} */
	orig_sp = L_args;
	/* maker for <__fd-mask<@32>> */
	L_result0 = networkZnetwork_internalZCLS_X_X_fd_maskLESSX4032GREATER_MAKER_FUN(orig_sp, L_pointer, L_pointer_suppliedQUERY);
	L_temp_4.heapptr = networkZliteral_39.heapptr;
	L_temp_4.dataword.ptr = L_result0;
	orig_sp[0] = L_temp_4;
	return orig_sp + 1;
    }
    else {
	/* odd-number-of-keyword/value-arguments-error */
	dylanZdylan_visceraZodd_number_of_keywordSLASHvalue_arguments_error_FUN(orig_sp);
	not_reached();
    }
}


/* Define Sealed Domain make (singleton(<__fd-mask<@32>>)) */


/* Define Method content-size{singleton(<__fd-mask<@32>>)} */

/* content-size{singleton(<__fd-mask<@32>>)} */
long networkZnetwork_internalZcontent_size_METH_37(descriptor_t *orig_sp, heapptr_t A0, heapptr_t A1)
{

    return 32;
}

/* generic-entry for content-size{singleton(<__fd-mask<@32>>)} */
descriptor_t * networkZnetwork_internalZcontent_size_METH_GENERIC_37(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    long L_result0; /* result0 */
    descriptor_t L_temp;

    orig_sp = ((void *)(orig_sp - 1));
    /* content-size{singleton(<__fd-mask<@32>>)} */
    L_result0 = networkZnetwork_internalZcontent_size_METH_37(orig_sp, &networkZnetwork_internalZCLS_X_X_fd_maskLESSX4032GREATER_HEAP, A_next_method_info);
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* Define Class <fd-set> */

/* <fd-set> is <fd-set> */

extern struct heapobj networkZnetwork_internalZCLS_fd_set_HEAP;

/* maker for <fd-set> */
void * networkZnetwork_internalZCLS_fd_set_MAKER_FUN(descriptor_t *orig_sp, void * A_pointer /* pointer */, int A_pointer_suppliedQUERY /* pointer-supplied? */)
{
    descriptor_t *cluster_0_top;


    /* #line 1652 "./sockets-api.dylan" */
    if (A_pointer_suppliedQUERY) {
	return A_pointer;
    }
    else {
	/* missing-required-init-keyword-error */
	dylanZdylan_visceraZmissing_required_init_keyword_error_FUN(orig_sp, &SYM_pointer_HEAP, &networkZnetwork_internalZCLS_fd_set_HEAP);
	not_reached();
    }
}

extern descriptor_t networkZliteral_40;	/* proxy for <fd-set> */

/* general-entry for maker for <fd-set> */
descriptor_t * networkZnetwork_internalZCLS_fd_set_MAKER_GENERAL(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    void * L_pointer; /* pointer */
    int L_pointer_suppliedQUERY; /* pointer-supplied? */
    long L_index; /* index */
    descriptor_t L_temp; /* temp */
    descriptor_t L_value; /* value */
    descriptor_t L_temp_2;
    descriptor_t L_temp_3;
    void * L_result0; /* result0 */
    descriptor_t L_temp_4;

    /* #line {Class <unknown-source-location>} */

    /* #line 126 "./cmp.dylan" */

    /* #line 209 "./num.dylan" */
    if (((A_nargs & 1) == 0)) {
	/* #line {Class <unknown-source-location>} */
	L_args = ((void *)(orig_sp - A_nargs));
	L_pointer = 0;
	L_pointer_suppliedQUERY = FALSE;
	L_index = (A_nargs - 2);
	while (1) {
	    if ((L_index < 0)) {
		goto block0;
	    }
	    else {
		L_temp = (((descriptor_t *)L_args)[L_index]);

		/* #line 386 "./condition.dylan" */
		if ((&dylanZdylan_visceraZCLS_symbol_HEAP == SLOT(L_temp.heapptr, heapptr_t, 0))) {
		    /* #line {Class <unknown-source-location>} */
		    L_value = (((descriptor_t *)L_args)[(L_index + 1)]);
		    if ((L_temp.heapptr == &SYM_pointer_HEAP)) {

			/* #line 386 "./condition.dylan" */
			if ((&dylanZdylan_visceraZCLS_raw_pointer_HEAP == SLOT(L_value.heapptr, heapptr_t, 0))) {
			    /* #line {Class <unknown-source-location>} */
			    L_pointer = L_value.dataword.ptr;
			    L_pointer_suppliedQUERY = TRUE;
			}
			else {

			    /* #line 389 "./condition.dylan" */
			    L_temp_2.heapptr = &networkZstr_ROOT;
			    L_temp_2.dataword.l = 0;
			    /* type-error-with-location */
			    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_value, &dylanZdylan_visceraZCLS_raw_pointer_HEAP, L_temp_2);
			    not_reached();
			}
		    }
		    /* #line {Class <unknown-source-location>} */
		    L_index = (L_index - 2);
		}
		else {

		    /* #line 389 "./condition.dylan" */
		    L_temp_3.heapptr = &networkZstr_ROOT;
		    L_temp_3.dataword.l = 0;
		    /* type-error-with-location */
		    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp, &dylanZdylan_visceraZCLS_symbol_HEAP, L_temp_3);
		    not_reached();
		}
	    }
	}
      block0:;
	/* #line {Class <unknown-source-location>} */
	orig_sp = L_args;
	/* maker for <fd-set> */
	L_result0 = networkZnetwork_internalZCLS_fd_set_MAKER_FUN(orig_sp, L_pointer, L_pointer_suppliedQUERY);
	L_temp_4.heapptr = networkZliteral_40.heapptr;
	L_temp_4.dataword.ptr = L_result0;
	orig_sp[0] = L_temp_4;
	return orig_sp + 1;
    }
    else {
	/* odd-number-of-keyword/value-arguments-error */
	dylanZdylan_visceraZodd_number_of_keywordSLASHvalue_arguments_error_FUN(orig_sp);
	not_reached();
    }
}


/* Define Sealed Domain make (singleton(<fd-set>)) */


/* {Implicit} Define Generic get-__fds-bits */

/* get-__fds-bits is get-__fds-bits */


/* Define Method get-__fds-bits{<fd-set>} */

extern struct heapobj networkZstr_ROOT_52;

/* get-__fds-bits{<fd-set>} */
void * networkZnetwork_internalZget_X_X_fds_bits_METH(descriptor_t *orig_sp, void * A_ptr /* ptr */, heapptr_t A1)
{
    descriptor_t *cluster_0_top;
    descriptor_t L_temp;
    descriptor_t L_temp_2;
    descriptor_t L_temp_3;
    descriptor_t L_temp_4; /* temp */
    int L_condition; /* condition */
    descriptor_t L_temp_5;
    descriptor_t L_temp_6; /* temp */
    descriptor_t L_temp_7;
    descriptor_t L_temp_8;


    /* #line 49 "./object.dylan" */
    L_temp.heapptr = networkZliteral_40.heapptr;
    L_temp.dataword.ptr = A_ptr;

    /* #line 324 "./melange.dylan" */

    /* #line 324 "./melange.dylan" */

    /* #line 324 "./melange.dylan" */
    L_temp_2.heapptr = SLOT(L_temp.heapptr, heapptr_t, 0);
    L_temp_2.dataword.l = 0;
    L_temp_3.heapptr = networkZliteral_6.heapptr;
    L_temp_3.dataword.ptr = ((void *)((char *)A_ptr + 0));
    orig_sp[0] = L_temp_2;
    orig_sp[1] = L_temp_3;
    /* as */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZas_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_temp_4 = orig_sp[0];

    /* #line 49 "./object.dylan" */

    /* #line 386 "./condition.dylan" */
    /* %subtype?{<class>, <class>} */
    L_condition = dylanZdylan_visceraZPCTsubtypeQUERY_METH(orig_sp, SLOT(L_temp_4.heapptr, heapptr_t, 0), &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP, &dylanZliteral_ROOT_2);
    if (L_condition) {

	/* #line 324 "./melange.dylan" */

	/* #line 1658 "./sockets-api.dylan" */
	L_temp_5.heapptr = &networkZnetwork_internalZCLS_X_X_fd_maskLESSX4032GREATER_HEAP;
	L_temp_5.dataword.l = 0;
	orig_sp[0] = L_temp_5;
	orig_sp[1] = L_temp_4;
	/* as */
	{
	  struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZas_HEAP, 2);
	  heapptr_t L_meth = L_temp.R0;
	  heapptr_t L_next_info = L_temp.R1;
	  cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
	}
	L_temp_6 = orig_sp[0];

	/* #line 386 "./condition.dylan" */
	if ((&networkZnetwork_internalZCLS_X_X_fd_maskLESSX4032GREATER_HEAP == SLOT(L_temp_6.heapptr, heapptr_t, 0))) {

	    /* #line 1658 "./sockets-api.dylan" */
	    return L_temp_6.dataword.ptr;
	}
	else {

	    /* #line 389 "./condition.dylan" */
	    L_temp_7.heapptr = &networkZstr_ROOT_52;
	    L_temp_7.dataword.l = 0;
	    /* type-error-with-location */
	    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp_6, &networkZnetwork_internalZCLS_X_X_fd_maskLESSX4032GREATER_HEAP, L_temp_7);
	    not_reached();
	}
    }
    else {
	L_temp_8.heapptr = &networkZstr_ROOT_5;
	L_temp_8.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp_4, &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP, L_temp_8);
	not_reached();
    }
}


/* Define Method pointer-value{<fd-set>} */

extern struct heapobj networkZstr_ROOT_53;

/* pointer-value{<fd-set>} */
void * networkZnetwork_internalZpointer_value_METH_30(descriptor_t *orig_sp, void * A_value /* value */, heapptr_t A_next_method_info /* next-method-info */, heapptr_t A_rest /* rest */, descriptor_t A_index /* index */)
{
    descriptor_t *cluster_0_top;
    descriptor_t L_temp;
    descriptor_t L_arg1; /* arg1 */
    descriptor_t L_temp_2;
    descriptor_t L_temp_3; /* temp */
    descriptor_t L_temp_4;

    /* #line {Class <unknown-source-location>} */

    /* #line 1662 "./sockets-api.dylan" */
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = 128;
    orig_sp[0] = A_index;
    orig_sp[1] = L_temp;
    /* * */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZV_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_arg1 = (orig_sp == cluster_0_top ? dylanZfalse : orig_sp[0]);

    /* #line 1662 "./sockets-api.dylan" */
    L_temp_2.heapptr = networkZliteral_40.heapptr;
    L_temp_2.dataword.ptr = A_value;
    orig_sp[0] = L_temp_2;
    orig_sp[1] = L_arg1;
    /* + */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZPLUS_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_temp_3 = (orig_sp == cluster_0_top ? dylanZfalse : orig_sp[0]);

    /* #line 386 "./condition.dylan" */
    if ((&networkZnetwork_internalZCLS_fd_set_HEAP == SLOT(L_temp_3.heapptr, heapptr_t, 0))) {

	/* #line 1662 "./sockets-api.dylan" */
	return L_temp_3.dataword.ptr;
    }
    else {

	/* #line 389 "./condition.dylan" */
	L_temp_4.heapptr = &networkZstr_ROOT_53;
	L_temp_4.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp_3, &networkZnetwork_internalZCLS_fd_set_HEAP, L_temp_4);
	not_reached();
    }
}

/* generic-entry for pointer-value{<fd-set>} */
descriptor_t * networkZnetwork_internalZpointer_value_METH_GENERIC_30(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    descriptor_t L_arg; /* arg */
    heapptr_t L_rest; /* rest */
    void * L_arg_2; /* arg */
    descriptor_t L_index; /* index */
    long L_index_2; /* index */
    descriptor_t L_key; /* key */
    descriptor_t L_value; /* value */
    void * L_result0; /* result0 */
    descriptor_t L_temp;

    /* #line {Class <unknown-source-location>} */
    L_args = ((void *)(orig_sp - A_nargs));
    L_arg = (((descriptor_t *)L_args)[0]);
    L_rest = dylanZdylan_visceraZmake_rest_arg_FUN(orig_sp, (descriptor_t *)L_args + 1, A_nargs - 1);
    L_arg_2 = L_arg.dataword.ptr;
    L_index.heapptr = networkZliteral_2.heapptr;
    L_index.dataword.l = 0;
    L_index_2 = (A_nargs - 2);
    while (1) {
	if ((L_index_2 < 1)) {
	    goto block0;
	}
	else {
	    L_key = (((descriptor_t *)L_args)[L_index_2]);
	    L_value = (((descriptor_t *)L_args)[(L_index_2 + 1)]);
	    if ((L_key.heapptr == &SYM_index_HEAP)) {
		L_index = L_value;
	    }
	    L_index_2 = (L_index_2 - 2);
	}
    }
  block0:;
    orig_sp = L_args;
    /* pointer-value{<fd-set>} */
    L_result0 = networkZnetwork_internalZpointer_value_METH_30(orig_sp, L_arg_2, A_next_method_info, L_rest, L_index);
    L_temp.heapptr = networkZliteral_40.heapptr;
    L_temp.dataword.ptr = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* Define Method content-size{subclass(<fd-set>)} */

/* content-size{subclass(<fd-set>)} */
long networkZnetwork_internalZcontent_size_METH_38(descriptor_t *orig_sp, heapptr_t A0, heapptr_t A1)
{

    return 128;
}

/* generic-entry for content-size{subclass(<fd-set>)} */
descriptor_t * networkZnetwork_internalZcontent_size_METH_GENERIC_38(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    long L_result0; /* result0 */
    descriptor_t L_temp;

    orig_sp = ((void *)(orig_sp - 1));
    /* content-size{subclass(<fd-set>)} */
    L_result0 = networkZnetwork_internalZcontent_size_METH_38(orig_sp, &networkZnetwork_internalZCLS_fd_set_HEAP, A_next_method_info);
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* Define Constant <fd-mask> */

/* <fd-mask> is <integer> */


/* Define Constant <__time-t> */

/* <__time-t> is <integer> */


/* Define Class <timeval> */

/* <timeval> is <timeval> */

extern struct heapobj networkZnetwork_internalZCLS_timeval_HEAP;

/* maker for <timeval> */
void * networkZnetwork_internalZCLS_timeval_MAKER_FUN(descriptor_t *orig_sp, void * A_pointer /* pointer */, int A_pointer_suppliedQUERY /* pointer-supplied? */)
{
    descriptor_t *cluster_0_top;


    /* #line 1673 "./sockets-api.dylan" */
    if (A_pointer_suppliedQUERY) {
	return A_pointer;
    }
    else {
	/* missing-required-init-keyword-error */
	dylanZdylan_visceraZmissing_required_init_keyword_error_FUN(orig_sp, &SYM_pointer_HEAP, &networkZnetwork_internalZCLS_timeval_HEAP);
	not_reached();
    }
}

extern descriptor_t networkZliteral_41;	/* proxy for <timeval> */

/* general-entry for maker for <timeval> */
descriptor_t * networkZnetwork_internalZCLS_timeval_MAKER_GENERAL(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    void * L_pointer; /* pointer */
    int L_pointer_suppliedQUERY; /* pointer-supplied? */
    long L_index; /* index */
    descriptor_t L_temp; /* temp */
    descriptor_t L_value; /* value */
    descriptor_t L_temp_2;
    descriptor_t L_temp_3;
    void * L_result0; /* result0 */
    descriptor_t L_temp_4;

    /* #line {Class <unknown-source-location>} */

    /* #line 126 "./cmp.dylan" */

    /* #line 209 "./num.dylan" */
    if (((A_nargs & 1) == 0)) {
	/* #line {Class <unknown-source-location>} */
	L_args = ((void *)(orig_sp - A_nargs));
	L_pointer = 0;
	L_pointer_suppliedQUERY = FALSE;
	L_index = (A_nargs - 2);
	while (1) {
	    if ((L_index < 0)) {
		goto block0;
	    }
	    else {
		L_temp = (((descriptor_t *)L_args)[L_index]);

		/* #line 386 "./condition.dylan" */
		if ((&dylanZdylan_visceraZCLS_symbol_HEAP == SLOT(L_temp.heapptr, heapptr_t, 0))) {
		    /* #line {Class <unknown-source-location>} */
		    L_value = (((descriptor_t *)L_args)[(L_index + 1)]);
		    if ((L_temp.heapptr == &SYM_pointer_HEAP)) {

			/* #line 386 "./condition.dylan" */
			if ((&dylanZdylan_visceraZCLS_raw_pointer_HEAP == SLOT(L_value.heapptr, heapptr_t, 0))) {
			    /* #line {Class <unknown-source-location>} */
			    L_pointer = L_value.dataword.ptr;
			    L_pointer_suppliedQUERY = TRUE;
			}
			else {

			    /* #line 389 "./condition.dylan" */
			    L_temp_2.heapptr = &networkZstr_ROOT;
			    L_temp_2.dataword.l = 0;
			    /* type-error-with-location */
			    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_value, &dylanZdylan_visceraZCLS_raw_pointer_HEAP, L_temp_2);
			    not_reached();
			}
		    }
		    /* #line {Class <unknown-source-location>} */
		    L_index = (L_index - 2);
		}
		else {

		    /* #line 389 "./condition.dylan" */
		    L_temp_3.heapptr = &networkZstr_ROOT;
		    L_temp_3.dataword.l = 0;
		    /* type-error-with-location */
		    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp, &dylanZdylan_visceraZCLS_symbol_HEAP, L_temp_3);
		    not_reached();
		}
	    }
	}
      block0:;
	/* #line {Class <unknown-source-location>} */
	orig_sp = L_args;
	/* maker for <timeval> */
	L_result0 = networkZnetwork_internalZCLS_timeval_MAKER_FUN(orig_sp, L_pointer, L_pointer_suppliedQUERY);
	L_temp_4.heapptr = networkZliteral_41.heapptr;
	L_temp_4.dataword.ptr = L_result0;
	orig_sp[0] = L_temp_4;
	return orig_sp + 1;
    }
    else {
	/* odd-number-of-keyword/value-arguments-error */
	dylanZdylan_visceraZodd_number_of_keywordSLASHvalue_arguments_error_FUN(orig_sp);
	not_reached();
    }
}


/* Define Sealed Domain make (singleton(<timeval>)) */


/* {Implicit} Define Generic get-tv-sec */

/* get-tv-sec is get-tv-sec */


/* Define Method get-tv-sec{<timeval>} */

/* get-tv-sec{<timeval>} */
long networkZnetwork_internalZget_tv_sec_METH(descriptor_t *orig_sp, void * A_ptr /* ptr */, heapptr_t A1)
{
    descriptor_t *cluster_0_top;


    /* #line 198 "./melange.dylan" */

    /* #line 91 "./rawptr.dylan" */
    return (*(long *)((char *)A_ptr + 0 ));
}


/* {Implicit} Define Generic get-tv-sec-setter */

/* get-tv-sec-setter is get-tv-sec-setter */


/* Define Method get-tv-sec-setter{<integer>, <timeval>} */

/* get-tv-sec-setter{<integer>, <timeval>} */
long networkZnetwork_internalZget_tv_sec_setter_METH(descriptor_t *orig_sp, long A_value /* value */, void * A_ptr /* ptr */, heapptr_t A2)
{
    descriptor_t *cluster_0_top;

    /* #line {Class <unknown-source-location>} */

    /* #line 97 "./rawptr.dylan" */
    *(long *)((char *)A_ptr + 0) = A_value;
    return A_value;
}


/* {Implicit} Define Generic get-tv-usec */

/* get-tv-usec is get-tv-usec */


/* Define Method get-tv-usec{<timeval>} */

/* get-tv-usec{<timeval>} */
long networkZnetwork_internalZget_tv_usec_METH(descriptor_t *orig_sp, void * A_ptr /* ptr */, heapptr_t A1)
{
    descriptor_t *cluster_0_top;

    /* #line {Class <unknown-source-location>} */

    /* #line 198 "./melange.dylan" */

    /* #line 91 "./rawptr.dylan" */
    return (*(long *)((char *)A_ptr + 4 ));
}


/* {Implicit} Define Generic get-tv-usec-setter */

/* get-tv-usec-setter is get-tv-usec-setter */


/* Define Method get-tv-usec-setter{<integer>, <timeval>} */

/* get-tv-usec-setter{<integer>, <timeval>} */
long networkZnetwork_internalZget_tv_usec_setter_METH(descriptor_t *orig_sp, long A_value /* value */, void * A_ptr /* ptr */, heapptr_t A2)
{
    descriptor_t *cluster_0_top;

    /* #line {Class <unknown-source-location>} */

    /* #line 97 "./rawptr.dylan" */
    *(long *)((char *)A_ptr + 4) = A_value;
    return A_value;
}


/* Define Method pointer-value{<timeval>} */

extern struct heapobj networkZstr_ROOT_54;

/* pointer-value{<timeval>} */
void * networkZnetwork_internalZpointer_value_METH_31(descriptor_t *orig_sp, void * A_value /* value */, heapptr_t A_next_method_info /* next-method-info */, heapptr_t A_rest /* rest */, descriptor_t A_index /* index */)
{
    descriptor_t *cluster_0_top;
    descriptor_t L_temp;
    descriptor_t L_arg1; /* arg1 */
    descriptor_t L_temp_2;
    descriptor_t L_temp_3; /* temp */
    descriptor_t L_temp_4;

    /* #line {Class <unknown-source-location>} */

    /* #line 1700 "./sockets-api.dylan" */
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = 8;
    orig_sp[0] = A_index;
    orig_sp[1] = L_temp;
    /* * */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZV_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_arg1 = (orig_sp == cluster_0_top ? dylanZfalse : orig_sp[0]);

    /* #line 1700 "./sockets-api.dylan" */
    L_temp_2.heapptr = networkZliteral_41.heapptr;
    L_temp_2.dataword.ptr = A_value;
    orig_sp[0] = L_temp_2;
    orig_sp[1] = L_arg1;
    /* + */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZPLUS_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_temp_3 = (orig_sp == cluster_0_top ? dylanZfalse : orig_sp[0]);

    /* #line 386 "./condition.dylan" */
    if ((&networkZnetwork_internalZCLS_timeval_HEAP == SLOT(L_temp_3.heapptr, heapptr_t, 0))) {

	/* #line 1700 "./sockets-api.dylan" */
	return L_temp_3.dataword.ptr;
    }
    else {

	/* #line 389 "./condition.dylan" */
	L_temp_4.heapptr = &networkZstr_ROOT_54;
	L_temp_4.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp_3, &networkZnetwork_internalZCLS_timeval_HEAP, L_temp_4);
	not_reached();
    }
}

/* generic-entry for pointer-value{<timeval>} */
descriptor_t * networkZnetwork_internalZpointer_value_METH_GENERIC_31(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    descriptor_t L_arg; /* arg */
    heapptr_t L_rest; /* rest */
    void * L_arg_2; /* arg */
    descriptor_t L_index; /* index */
    long L_index_2; /* index */
    descriptor_t L_key; /* key */
    descriptor_t L_value; /* value */
    void * L_result0; /* result0 */
    descriptor_t L_temp;

    /* #line {Class <unknown-source-location>} */
    L_args = ((void *)(orig_sp - A_nargs));
    L_arg = (((descriptor_t *)L_args)[0]);
    L_rest = dylanZdylan_visceraZmake_rest_arg_FUN(orig_sp, (descriptor_t *)L_args + 1, A_nargs - 1);
    L_arg_2 = L_arg.dataword.ptr;
    L_index.heapptr = networkZliteral_2.heapptr;
    L_index.dataword.l = 0;
    L_index_2 = (A_nargs - 2);
    while (1) {
	if ((L_index_2 < 1)) {
	    goto block0;
	}
	else {
	    L_key = (((descriptor_t *)L_args)[L_index_2]);
	    L_value = (((descriptor_t *)L_args)[(L_index_2 + 1)]);
	    if ((L_key.heapptr == &SYM_index_HEAP)) {
		L_index = L_value;
	    }
	    L_index_2 = (L_index_2 - 2);
	}
    }
  block0:;
    orig_sp = L_args;
    /* pointer-value{<timeval>} */
    L_result0 = networkZnetwork_internalZpointer_value_METH_31(orig_sp, L_arg_2, A_next_method_info, L_rest, L_index);
    L_temp.heapptr = networkZliteral_41.heapptr;
    L_temp.dataword.ptr = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* Define Method content-size{subclass(<timeval>)} */

/* content-size{subclass(<timeval>)} */
long networkZnetwork_internalZcontent_size_METH_39(descriptor_t *orig_sp, heapptr_t A0, heapptr_t A1)
{

    return 8;
}

/* generic-entry for content-size{subclass(<timeval>)} */
descriptor_t * networkZnetwork_internalZcontent_size_METH_GENERIC_39(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    long L_result0; /* result0 */
    descriptor_t L_temp;

    orig_sp = ((void *)(orig_sp - 1));
    /* content-size{subclass(<timeval>)} */
    L_result0 = networkZnetwork_internalZcontent_size_METH_39(orig_sp, &networkZnetwork_internalZCLS_timeval_HEAP, A_next_method_info);
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* {Implicit} Define Generic posix-select */

/* posix-select is posix-select */


/* Define Method posix-select{<integer>, <fd-set>, <fd-set>, <fd-set>, <timeval>} */

/* posix-select{<integer>, <fd-set>, <fd-set>, <fd-set>, <timeval>} */
long networkZnetwork_internalZposix_select_METH(descriptor_t *orig_sp, long A_arg1 /* arg1 */, void * A_arg2 /* arg2 */, void * A_arg3 /* arg3 */, void * A_arg4 /* arg4 */, void * A_arg5 /* arg5 */, heapptr_t A5)
{
    descriptor_t *cluster_0_top;
    long L_result_value; /* result-value */


    /* #line 1711 "./sockets-api.dylan" */

    /* #line 1711 "./sockets-api.dylan" */

    /* #line 1711 "./sockets-api.dylan" */

    /* #line 1711 "./sockets-api.dylan" */

    /* #line 735 "./macros.dylan" */
    L_result_value = select(A_arg1, A_arg2, A_arg3, A_arg4, A_arg5);
    return L_result_value;
}


/* Define Constant $_SYS-SELECT-H */

/* $_SYS-SELECT-H is 1 */


/* Define Constant $__NFDBITS */

/* $__NFDBITS is 32 */


/* Define Constant $FD-SETSIZE */

/* $FD-SETSIZE is 1024 */


/* Define Constant $NFDBITS */

/* $NFDBITS is 32 */


/* Define Constant $_STRUCT-TIMEVAL */

/* $_STRUCT-TIMEVAL is 1 */


/* Define Constant <__int8-t> */

/* <__int8-t> is <integer> */


/* Define Constant <__uint8-t> */

/* <__uint8-t> is <integer> */


/* Define Constant <__int16-t> */

/* <__int16-t> is <integer> */


/* Define Constant <__uint16-t> */

/* <__uint16-t> is <integer> */


/* Define Constant <__int32-t> */

/* <__int32-t> is <integer> */


/* Define Constant <__ino64-t> */

/* <__ino64-t> is <double-integer> */


/* Define Constant <__clock-t> */

/* <__clock-t> is <integer> */


/* Define Constant <__rlim-t> */

/* <__rlim-t> is <integer> */


/* Define Constant <__rlim64-t> */

/* <__rlim64-t> is <double-integer> */


/* Define Constant <__useconds-t> */

/* <__useconds-t> is <integer> */


/* Define Constant <__swblk-t> */

/* <__swblk-t> is <integer> */


/* Define Constant <__clockid-t> */

/* <__clockid-t> is <integer> */


/* Define Constant <__timer-t> */

/* <__timer-t> is <integer> */


/* Define Constant <__blksize-t> */

/* <__blksize-t> is <integer> */


/* Define Constant <__blkcnt64-t> */

/* <__blkcnt64-t> is <double-integer> */


/* Define Constant <__fsblkcnt64-t> */

/* <__fsblkcnt64-t> is <double-integer> */


/* Define Constant <__fsfilcnt64-t> */

/* <__fsfilcnt64-t> is <double-integer> */


/* Define Constant <__qaddr-t> */

/* <__qaddr-t> is <__quad-t> */


/* Define Constant <__intptr-t> */

/* <__intptr-t> is <integer> */


/* Define Constant $_BITS-TYPES-H */

/* $_BITS-TYPES-H is 1 */


/* Define Constant <__S16-TYPE> */

/* <__S16-TYPE> is <integer> */


/* Define Constant <__U16-TYPE> */

/* <__U16-TYPE> is <integer> */


/* Define Constant <__S32-TYPE> */

/* <__S32-TYPE> is <integer> */


/* Define Constant <__U32-TYPE> */

/* <__U32-TYPE> is <integer> */


/* Define Constant <__SLONGWORD-TYPE> */

/* <__SLONGWORD-TYPE> is <integer> */


/* Define Constant <__ULONGWORD-TYPE> */

/* <__ULONGWORD-TYPE> is <integer> */


/* Define Constant <__SQUAD-TYPE> */

/* <__SQUAD-TYPE> is <double-integer> */


/* Define Constant <__UQUAD-TYPE> */

/* <__UQUAD-TYPE> is <double-integer> */


/* Define Constant <__SWORD-TYPE> */

/* <__SWORD-TYPE> is <integer> */


/* Define Constant <__UWORD-TYPE> */

/* <__UWORD-TYPE> is <integer> */


/* Define Constant <__SLONG32-TYPE> */

/* <__SLONG32-TYPE> is <integer> */


/* Define Constant <__ULONG32-TYPE> */

/* <__ULONG32-TYPE> is <integer> */


/* Define Constant <__S64-TYPE> */

/* <__S64-TYPE> is <__quad-t> */


/* Define Constant <__U64-TYPE> */

/* <__U64-TYPE> is <__u-quad-t> */


/* Define Constant $_BITS-TYPESIZES-H */

/* $_BITS-TYPESIZES-H is 1 */


/* Define Constant <__DEV-T-TYPE> */

/* <__DEV-T-TYPE> is <double-integer> */


/* Define Constant <__UID-T-TYPE> */

/* <__UID-T-TYPE> is <integer> */


/* Define Constant <__GID-T-TYPE> */

/* <__GID-T-TYPE> is <integer> */


/* Define Constant <__INO-T-TYPE> */

/* <__INO-T-TYPE> is <integer> */


/* Define Constant <__INO64-T-TYPE> */

/* <__INO64-T-TYPE> is <double-integer> */


/* Define Constant <__MODE-T-TYPE> */

/* <__MODE-T-TYPE> is <integer> */


/* Define Constant <__NLINK-T-TYPE> */

/* <__NLINK-T-TYPE> is <integer> */


/* Define Constant <__OFF-T-TYPE> */

/* <__OFF-T-TYPE> is <integer> */


/* Define Constant <__OFF64-T-TYPE> */

/* <__OFF64-T-TYPE> is <double-integer> */


/* Define Constant <__PID-T-TYPE> */

/* <__PID-T-TYPE> is <integer> */


/* Define Constant <__RLIM-T-TYPE> */

/* <__RLIM-T-TYPE> is <integer> */


/* Define Constant <__RLIM64-T-TYPE> */

/* <__RLIM64-T-TYPE> is <double-integer> */


/* Define Constant <__BLKCNT-T-TYPE> */

/* <__BLKCNT-T-TYPE> is <integer> */


/* Define Constant <__BLKCNT64-T-TYPE> */

/* <__BLKCNT64-T-TYPE> is <double-integer> */


/* Define Constant <__FSBLKCNT-T-TYPE> */

/* <__FSBLKCNT-T-TYPE> is <integer> */


/* Define Constant <__FSBLKCNT64-T-TYPE> */

/* <__FSBLKCNT64-T-TYPE> is <double-integer> */


/* Define Constant <__FSFILCNT-T-TYPE> */

/* <__FSFILCNT-T-TYPE> is <integer> */


/* Define Constant <__FSFILCNT64-T-TYPE> */

/* <__FSFILCNT64-T-TYPE> is <double-integer> */


/* Define Constant <__ID-T-TYPE> */

/* <__ID-T-TYPE> is <integer> */


/* Define Constant <__CLOCK-T-TYPE> */

/* <__CLOCK-T-TYPE> is <integer> */


/* Define Constant <__TIME-T-TYPE> */

/* <__TIME-T-TYPE> is <integer> */


/* Define Constant <__USECONDS-T-TYPE> */

/* <__USECONDS-T-TYPE> is <integer> */


/* Define Constant <__SUSECONDS-T-TYPE> */

/* <__SUSECONDS-T-TYPE> is <integer> */


/* Define Constant <__DADDR-T-TYPE> */

/* <__DADDR-T-TYPE> is <integer> */


/* Define Constant <__SWBLK-T-TYPE> */

/* <__SWBLK-T-TYPE> is <integer> */


/* Define Constant <__KEY-T-TYPE> */

/* <__KEY-T-TYPE> is <integer> */


/* Define Constant <__CLOCKID-T-TYPE> */

/* <__CLOCKID-T-TYPE> is <integer> */


/* Define Constant <__TIMER-T-TYPE> */

/* <__TIMER-T-TYPE> is <integer> */


/* Define Constant <__BLKSIZE-T-TYPE> */

/* <__BLKSIZE-T-TYPE> is <integer> */


/* Define Constant $__FD-SETSIZE */

/* $__FD-SETSIZE is 1024 */


/* Define Constant <__SIZE-TYPE--> */

/* <__SIZE-TYPE--> is <integer> */


/* Define Constant $__WORDSIZE */

/* $__WORDSIZE is 32 */


/* Define Constant <time-t> */

/* <time-t> is <integer> */


/* Define Constant <clockid-t> */

/* <clockid-t> is <integer> */


/* Define Constant <timer-t> */

/* <timer-t> is <integer> */


/* Define Constant $__time-t-defined */

/* $__time-t-defined is 1 */


/* Define Constant $__clockid-t-defined */

/* $__clockid-t-defined is 1 */


/* Define Constant $__timer-t-defined */

/* $__timer-t-defined is 1 */


/* Define Class <timespec> */

/* <timespec> is <timespec> */

extern struct heapobj networkZnetwork_internalZCLS_timespec_HEAP;

/* maker for <timespec> */
void * networkZnetwork_internalZCLS_timespec_MAKER_FUN(descriptor_t *orig_sp, void * A_pointer /* pointer */, int A_pointer_suppliedQUERY /* pointer-supplied? */)
{
    descriptor_t *cluster_0_top;


    /* #line 1871 "./sockets-api.dylan" */
    if (A_pointer_suppliedQUERY) {
	return A_pointer;
    }
    else {
	/* missing-required-init-keyword-error */
	dylanZdylan_visceraZmissing_required_init_keyword_error_FUN(orig_sp, &SYM_pointer_HEAP, &networkZnetwork_internalZCLS_timespec_HEAP);
	not_reached();
    }
}

extern descriptor_t networkZliteral_42;	/* proxy for <timespec> */

/* general-entry for maker for <timespec> */
descriptor_t * networkZnetwork_internalZCLS_timespec_MAKER_GENERAL(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    void * L_pointer; /* pointer */
    int L_pointer_suppliedQUERY; /* pointer-supplied? */
    long L_index; /* index */
    descriptor_t L_temp; /* temp */
    descriptor_t L_value; /* value */
    descriptor_t L_temp_2;
    descriptor_t L_temp_3;
    void * L_result0; /* result0 */
    descriptor_t L_temp_4;

    /* #line {Class <unknown-source-location>} */

    /* #line 126 "./cmp.dylan" */

    /* #line 209 "./num.dylan" */
    if (((A_nargs & 1) == 0)) {
	/* #line {Class <unknown-source-location>} */
	L_args = ((void *)(orig_sp - A_nargs));
	L_pointer = 0;
	L_pointer_suppliedQUERY = FALSE;
	L_index = (A_nargs - 2);
	while (1) {
	    if ((L_index < 0)) {
		goto block0;
	    }
	    else {
		L_temp = (((descriptor_t *)L_args)[L_index]);

		/* #line 386 "./condition.dylan" */
		if ((&dylanZdylan_visceraZCLS_symbol_HEAP == SLOT(L_temp.heapptr, heapptr_t, 0))) {
		    /* #line {Class <unknown-source-location>} */
		    L_value = (((descriptor_t *)L_args)[(L_index + 1)]);
		    if ((L_temp.heapptr == &SYM_pointer_HEAP)) {

			/* #line 386 "./condition.dylan" */
			if ((&dylanZdylan_visceraZCLS_raw_pointer_HEAP == SLOT(L_value.heapptr, heapptr_t, 0))) {
			    /* #line {Class <unknown-source-location>} */
			    L_pointer = L_value.dataword.ptr;
			    L_pointer_suppliedQUERY = TRUE;
			}
			else {

			    /* #line 389 "./condition.dylan" */
			    L_temp_2.heapptr = &networkZstr_ROOT;
			    L_temp_2.dataword.l = 0;
			    /* type-error-with-location */
			    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_value, &dylanZdylan_visceraZCLS_raw_pointer_HEAP, L_temp_2);
			    not_reached();
			}
		    }
		    /* #line {Class <unknown-source-location>} */
		    L_index = (L_index - 2);
		}
		else {

		    /* #line 389 "./condition.dylan" */
		    L_temp_3.heapptr = &networkZstr_ROOT;
		    L_temp_3.dataword.l = 0;
		    /* type-error-with-location */
		    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp, &dylanZdylan_visceraZCLS_symbol_HEAP, L_temp_3);
		    not_reached();
		}
	    }
	}
      block0:;
	/* #line {Class <unknown-source-location>} */
	orig_sp = L_args;
	/* maker for <timespec> */
	L_result0 = networkZnetwork_internalZCLS_timespec_MAKER_FUN(orig_sp, L_pointer, L_pointer_suppliedQUERY);
	L_temp_4.heapptr = networkZliteral_42.heapptr;
	L_temp_4.dataword.ptr = L_result0;
	orig_sp[0] = L_temp_4;
	return orig_sp + 1;
    }
    else {
	/* odd-number-of-keyword/value-arguments-error */
	dylanZdylan_visceraZodd_number_of_keywordSLASHvalue_arguments_error_FUN(orig_sp);
	not_reached();
    }
}


/* Define Sealed Domain make (singleton(<timespec>)) */


/* Define Method get-tv-sec{<timespec>} */

/* get-tv-sec{<timespec>} */
long networkZnetwork_internalZget_tv_sec_METH_2(descriptor_t *orig_sp, void * A_ptr /* ptr */, heapptr_t A1)
{
    descriptor_t *cluster_0_top;


    /* #line 198 "./melange.dylan" */

    /* #line 91 "./rawptr.dylan" */
    return (*(long *)((char *)A_ptr + 0 ));
}


/* Define Method get-tv-sec-setter{<integer>, <timespec>} */

/* get-tv-sec-setter{<integer>, <timespec>} */
long networkZnetwork_internalZget_tv_sec_setter_METH_2(descriptor_t *orig_sp, long A_value /* value */, void * A_ptr /* ptr */, heapptr_t A2)
{
    descriptor_t *cluster_0_top;

    /* #line {Class <unknown-source-location>} */

    /* #line 97 "./rawptr.dylan" */
    *(long *)((char *)A_ptr + 0) = A_value;
    return A_value;
}


/* {Implicit} Define Generic get-tv-nsec */

/* get-tv-nsec is get-tv-nsec */


/* Define Method get-tv-nsec{<timespec>} */

/* get-tv-nsec{<timespec>} */
long networkZnetwork_internalZget_tv_nsec_METH(descriptor_t *orig_sp, void * A_ptr /* ptr */, heapptr_t A1)
{
    descriptor_t *cluster_0_top;

    /* #line {Class <unknown-source-location>} */

    /* #line 198 "./melange.dylan" */

    /* #line 91 "./rawptr.dylan" */
    return (*(long *)((char *)A_ptr + 4 ));
}


/* {Implicit} Define Generic get-tv-nsec-setter */

/* get-tv-nsec-setter is get-tv-nsec-setter */


/* Define Method get-tv-nsec-setter{<integer>, <timespec>} */

/* get-tv-nsec-setter{<integer>, <timespec>} */
long networkZnetwork_internalZget_tv_nsec_setter_METH(descriptor_t *orig_sp, long A_value /* value */, void * A_ptr /* ptr */, heapptr_t A2)
{
    descriptor_t *cluster_0_top;

    /* #line {Class <unknown-source-location>} */

    /* #line 97 "./rawptr.dylan" */
    *(long *)((char *)A_ptr + 4) = A_value;
    return A_value;
}


/* Define Method pointer-value{<timespec>} */

extern struct heapobj networkZstr_ROOT_55;

/* pointer-value{<timespec>} */
void * networkZnetwork_internalZpointer_value_METH_32(descriptor_t *orig_sp, void * A_value /* value */, heapptr_t A_next_method_info /* next-method-info */, heapptr_t A_rest /* rest */, descriptor_t A_index /* index */)
{
    descriptor_t *cluster_0_top;
    descriptor_t L_temp;
    descriptor_t L_arg1; /* arg1 */
    descriptor_t L_temp_2;
    descriptor_t L_temp_3; /* temp */
    descriptor_t L_temp_4;

    /* #line {Class <unknown-source-location>} */

    /* #line 1898 "./sockets-api.dylan" */
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = 8;
    orig_sp[0] = A_index;
    orig_sp[1] = L_temp;
    /* * */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZV_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_arg1 = (orig_sp == cluster_0_top ? dylanZfalse : orig_sp[0]);

    /* #line 1898 "./sockets-api.dylan" */
    L_temp_2.heapptr = networkZliteral_42.heapptr;
    L_temp_2.dataword.ptr = A_value;
    orig_sp[0] = L_temp_2;
    orig_sp[1] = L_arg1;
    /* + */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZPLUS_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_temp_3 = (orig_sp == cluster_0_top ? dylanZfalse : orig_sp[0]);

    /* #line 386 "./condition.dylan" */
    if ((&networkZnetwork_internalZCLS_timespec_HEAP == SLOT(L_temp_3.heapptr, heapptr_t, 0))) {

	/* #line 1898 "./sockets-api.dylan" */
	return L_temp_3.dataword.ptr;
    }
    else {

	/* #line 389 "./condition.dylan" */
	L_temp_4.heapptr = &networkZstr_ROOT_55;
	L_temp_4.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp_3, &networkZnetwork_internalZCLS_timespec_HEAP, L_temp_4);
	not_reached();
    }
}

/* generic-entry for pointer-value{<timespec>} */
descriptor_t * networkZnetwork_internalZpointer_value_METH_GENERIC_32(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    descriptor_t L_arg; /* arg */
    heapptr_t L_rest; /* rest */
    void * L_arg_2; /* arg */
    descriptor_t L_index; /* index */
    long L_index_2; /* index */
    descriptor_t L_key; /* key */
    descriptor_t L_value; /* value */
    void * L_result0; /* result0 */
    descriptor_t L_temp;

    /* #line {Class <unknown-source-location>} */
    L_args = ((void *)(orig_sp - A_nargs));
    L_arg = (((descriptor_t *)L_args)[0]);
    L_rest = dylanZdylan_visceraZmake_rest_arg_FUN(orig_sp, (descriptor_t *)L_args + 1, A_nargs - 1);
    L_arg_2 = L_arg.dataword.ptr;
    L_index.heapptr = networkZliteral_2.heapptr;
    L_index.dataword.l = 0;
    L_index_2 = (A_nargs - 2);
    while (1) {
	if ((L_index_2 < 1)) {
	    goto block0;
	}
	else {
	    L_key = (((descriptor_t *)L_args)[L_index_2]);
	    L_value = (((descriptor_t *)L_args)[(L_index_2 + 1)]);
	    if ((L_key.heapptr == &SYM_index_HEAP)) {
		L_index = L_value;
	    }
	    L_index_2 = (L_index_2 - 2);
	}
    }
  block0:;
    orig_sp = L_args;
    /* pointer-value{<timespec>} */
    L_result0 = networkZnetwork_internalZpointer_value_METH_32(orig_sp, L_arg_2, A_next_method_info, L_rest, L_index);
    L_temp.heapptr = networkZliteral_42.heapptr;
    L_temp.dataword.ptr = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* Define Method content-size{subclass(<timespec>)} */

/* content-size{subclass(<timespec>)} */
long networkZnetwork_internalZcontent_size_METH_40(descriptor_t *orig_sp, heapptr_t A0, heapptr_t A1)
{

    return 8;
}

/* generic-entry for content-size{subclass(<timespec>)} */
descriptor_t * networkZnetwork_internalZcontent_size_METH_GENERIC_40(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    long L_result0; /* result0 */
    descriptor_t L_temp;

    orig_sp = ((void *)(orig_sp - 1));
    /* content-size{subclass(<timespec>)} */
    L_result0 = networkZnetwork_internalZcontent_size_METH_40(orig_sp, &networkZnetwork_internalZCLS_timespec_HEAP, A_next_method_info);
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* Define Constant $__timespec-defined */

/* $__timespec-defined is 1 */


/* Define Constant <__sig-atomic-t> */

/* <__sig-atomic-t> is <integer> */


/* Define Constant $_SIGSET-H-types */

/* $_SIGSET-H-types is 1 */


/* Define Constant $_SIGSET-NWORDS */

/* $_SIGSET-NWORDS is 32 */


/* Define Constant $CHAR-BIT */

/* $CHAR-BIT is 8 */


/* Define Constant $MB-LEN-MAX */

/* $MB-LEN-MAX is 1 */


/* Define Constant $SCHAR-MIN */

/* $SCHAR-MIN is -128 */


/* Define Constant $SCHAR-MAX */

/* $SCHAR-MAX is 127 */


/* Define Constant $UCHAR-MAX */

/* $UCHAR-MAX is 255 */


/* Define Constant $CHAR-MIN */

/* $CHAR-MIN is -128 */


/* Define Constant $CHAR-MAX */

/* $CHAR-MAX is 127 */


/* Define Constant $__SHRT-MAX-- */

/* $__SHRT-MAX-- is 32767 */


/* Define Constant $SHRT-MIN */

/* $SHRT-MIN is -32768 */


/* Define Constant $SHRT-MAX */

/* $SHRT-MAX is 32767 */


/* Define Constant $__INT-MAX-- */

/* $__INT-MAX-- is 2147483647 */


/* Define Constant $INT-MIN */

/* $INT-MIN is -2147483648 */


/* Define Constant $INT-MAX */

/* $INT-MAX is 2147483647 */


/* Define Constant $USHRT-MAX */

/* $USHRT-MAX is 65535 */


/* Define Constant $UINT-MAX */

/* $UINT-MAX is -1 */


/* Define Constant $__LONG-MAX-- */

/* $__LONG-MAX-- is 2147483647 */


/* Define Constant $LONG-MIN */

/* $LONG-MIN is -2147483648 */


/* Define Constant $LONG-MAX */

/* $LONG-MAX is 2147483647 */


/* Define Constant $ULONG-MAX */

/* $ULONG-MAX is -1 */


/* Define Constant $__LONG-LONG-MAX-- */

/* $__LONG-LONG-MAX-- is #e9223372036854775807 */


/* {Implicit} Define Generic readv */

/* readv is readv */


/* Define Method readv{<integer>, <iovec>, <integer>} */

/* readv{<integer>, <iovec>, <integer>} */
long networkZnetwork_internalZreadv_METH(descriptor_t *orig_sp, long A_arg1 /* arg1 */, void * A_arg2 /* arg2 */, long A_arg3 /* arg3 */, heapptr_t A3)
{
    descriptor_t *cluster_0_top;
    long L_result_value; /* result-value */


    /* #line 1957 "./sockets-api.dylan" */

    /* #line 735 "./macros.dylan" */
    L_result_value = readv(A_arg1, A_arg2, A_arg3);
    return L_result_value;
}


/* {Implicit} Define Generic writev */

/* writev is writev */


/* Define Method writev{<integer>, <iovec>, <integer>} */

/* writev{<integer>, <iovec>, <integer>} */
long networkZnetwork_internalZwritev_METH(descriptor_t *orig_sp, long A_arg1 /* arg1 */, void * A_arg2 /* arg2 */, long A_arg3 /* arg3 */, heapptr_t A3)
{
    descriptor_t *cluster_0_top;
    long L_result_value; /* result-value */

    /* #line {Class <unknown-source-location>} */

    /* #line 1965 "./sockets-api.dylan" */

    /* #line 735 "./macros.dylan" */
    L_result_value = writev(A_arg1, A_arg2, A_arg3);
    return L_result_value;
}


/* Define Constant $_SYS-UIO-H */

/* $_SYS-UIO-H is 1 */


/* Define Constant $UIO-MAXIOV */

/* $UIO-MAXIOV is 1024 */


/* Define Constant <anonymous-4> */

/* <anonymous-4> allocated as networkZnetwork_internalZCLS_anonymous_4 */


/* Define Constant $IPPROTO-IP */

/* $IPPROTO-IP is 0 */


/* Define Constant $IPPROTO-HOPOPTS */

/* $IPPROTO-HOPOPTS is 0 */


/* Define Constant $IPPROTO-ICMP */

/* $IPPROTO-ICMP is 1 */


/* Define Constant $IPPROTO-IGMP */

/* $IPPROTO-IGMP is 2 */


/* Define Constant $IPPROTO-IPIP */

/* $IPPROTO-IPIP is 4 */


/* Define Constant $IPPROTO-TCP */

/* $IPPROTO-TCP is 6 */


/* Define Constant $IPPROTO-EGP */

/* $IPPROTO-EGP is 8 */


/* Define Constant $IPPROTO-PUP */

/* $IPPROTO-PUP is 12 */


/* Define Constant $IPPROTO-UDP */

/* $IPPROTO-UDP is 17 */


/* Define Constant $IPPROTO-IDP */

/* $IPPROTO-IDP is 22 */


/* Define Constant $IPPROTO-TP */

/* $IPPROTO-TP is 29 */


/* Define Constant $IPPROTO-IPV6 */

/* $IPPROTO-IPV6 is 41 */


/* Define Constant $IPPROTO-ROUTING */

/* $IPPROTO-ROUTING is 43 */


/* Define Constant $IPPROTO-FRAGMENT */

/* $IPPROTO-FRAGMENT is 44 */


/* Define Constant $IPPROTO-RSVP */

/* $IPPROTO-RSVP is 46 */


/* Define Constant $IPPROTO-GRE */

/* $IPPROTO-GRE is 47 */


/* Define Constant $IPPROTO-ESP */

/* $IPPROTO-ESP is 50 */


/* Define Constant $IPPROTO-AH */

/* $IPPROTO-AH is 51 */


/* Define Constant $IPPROTO-ICMPV6 */

/* $IPPROTO-ICMPV6 is 58 */


/* Define Constant $IPPROTO-NONE */

/* $IPPROTO-NONE is 59 */


/* Define Constant $IPPROTO-DSTOPTS */

/* $IPPROTO-DSTOPTS is 60 */


/* Define Constant $IPPROTO-MTP */

/* $IPPROTO-MTP is 92 */


/* Define Constant $IPPROTO-ENCAP */

/* $IPPROTO-ENCAP is 98 */


/* Define Constant $IPPROTO-PIM */

/* $IPPROTO-PIM is 103 */


/* Define Constant $IPPROTO-COMP */

/* $IPPROTO-COMP is 108 */


/* Define Constant $IPPROTO-RAW */

/* $IPPROTO-RAW is 255 */


/* Define Constant $IPPROTO-MAX */

/* $IPPROTO-MAX is 256 */


/* Define Constant <uint16-t> */

/* <uint16-t> is <integer> */


/* Define Constant <in-port-t> */

/* <in-port-t> is <integer> */


/* Define Constant <anonymous-5> */

/* <anonymous-5> allocated as networkZnetwork_internalZCLS_anonymous_5 */


/* Define Constant $IPPORT-ECHO */

/* $IPPORT-ECHO is 7 */


/* Define Constant $IPPORT-DISCARD */

/* $IPPORT-DISCARD is 9 */


/* Define Constant $IPPORT-SYSTAT */

/* $IPPORT-SYSTAT is 11 */


/* Define Constant $IPPORT-DAYTIME */

/* $IPPORT-DAYTIME is 13 */


/* Define Constant $IPPORT-NETSTAT */

/* $IPPORT-NETSTAT is 15 */


/* Define Constant $IPPORT-FTP */

/* $IPPORT-FTP is 21 */


/* Define Constant $IPPORT-TELNET */

/* $IPPORT-TELNET is 23 */


/* Define Constant $IPPORT-SMTP */

/* $IPPORT-SMTP is 25 */


/* Define Constant $IPPORT-TIMESERVER */

/* $IPPORT-TIMESERVER is 37 */


/* Define Constant $IPPORT-NAMESERVER */

/* $IPPORT-NAMESERVER is 42 */


/* Define Constant $IPPORT-WHOIS */

/* $IPPORT-WHOIS is 43 */


/* Define Constant $IPPORT-MTP */

/* $IPPORT-MTP is 57 */


/* Define Constant $IPPORT-TFTP */

/* $IPPORT-TFTP is 69 */


/* Define Constant $IPPORT-RJE */

/* $IPPORT-RJE is 77 */


/* Define Constant $IPPORT-FINGER */

/* $IPPORT-FINGER is 79 */


/* Define Constant $IPPORT-TTYLINK */

/* $IPPORT-TTYLINK is 87 */


/* Define Constant $IPPORT-SUPDUP */

/* $IPPORT-SUPDUP is 95 */


/* Define Constant $IPPORT-EXECSERVER */

/* $IPPORT-EXECSERVER is 512 */


/* Define Constant $IPPORT-LOGINSERVER */

/* $IPPORT-LOGINSERVER is 513 */


/* Define Constant $IPPORT-CMDSERVER */

/* $IPPORT-CMDSERVER is 514 */


/* Define Constant $IPPORT-EFSSERVER */

/* $IPPORT-EFSSERVER is 520 */


/* Define Constant $IPPORT-BIFFUDP */

/* $IPPORT-BIFFUDP is 512 */


/* Define Constant $IPPORT-WHOSERVER */

/* $IPPORT-WHOSERVER is 513 */


/* Define Constant $IPPORT-ROUTESERVER */

/* $IPPORT-ROUTESERVER is 520 */


/* Define Constant $IPPORT-RESERVED */

/* $IPPORT-RESERVED is 1024 */


/* Define Constant $IPPORT-USERRESERVED */

/* $IPPORT-USERRESERVED is 5000 */


/* Define Constant <uint32-t> */

/* <uint32-t> is <integer> */


/* Define Constant <in-addr-t> */

/* <in-addr-t> is <integer> */


/* Define Class <in-addr> */

/* <in-addr> is <in-addr> */

extern struct heapobj networkZnetwork_internalZCLS_in_addr_HEAP;

/* maker for <in-addr> */
void * networkZnetwork_internalZCLS_in_addr_MAKER_FUN(descriptor_t *orig_sp, void * A_pointer /* pointer */, int A_pointer_suppliedQUERY /* pointer-supplied? */)
{
    descriptor_t *cluster_0_top;


    /* #line 2038 "./sockets-api.dylan" */
    if (A_pointer_suppliedQUERY) {
	return A_pointer;
    }
    else {
	/* missing-required-init-keyword-error */
	dylanZdylan_visceraZmissing_required_init_keyword_error_FUN(orig_sp, &SYM_pointer_HEAP, &networkZnetwork_internalZCLS_in_addr_HEAP);
	not_reached();
    }
}

extern descriptor_t networkZliteral_43;	/* proxy for <in-addr> */

/* general-entry for maker for <in-addr> */
descriptor_t * networkZnetwork_internalZCLS_in_addr_MAKER_GENERAL(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    void * L_pointer; /* pointer */
    int L_pointer_suppliedQUERY; /* pointer-supplied? */
    long L_index; /* index */
    descriptor_t L_temp; /* temp */
    descriptor_t L_value; /* value */
    descriptor_t L_temp_2;
    descriptor_t L_temp_3;
    void * L_result0; /* result0 */
    descriptor_t L_temp_4;

    /* #line {Class <unknown-source-location>} */

    /* #line 126 "./cmp.dylan" */

    /* #line 209 "./num.dylan" */
    if (((A_nargs & 1) == 0)) {
	/* #line {Class <unknown-source-location>} */
	L_args = ((void *)(orig_sp - A_nargs));
	L_pointer = 0;
	L_pointer_suppliedQUERY = FALSE;
	L_index = (A_nargs - 2);
	while (1) {
	    if ((L_index < 0)) {
		goto block0;
	    }
	    else {
		L_temp = (((descriptor_t *)L_args)[L_index]);

		/* #line 386 "./condition.dylan" */
		if ((&dylanZdylan_visceraZCLS_symbol_HEAP == SLOT(L_temp.heapptr, heapptr_t, 0))) {
		    /* #line {Class <unknown-source-location>} */
		    L_value = (((descriptor_t *)L_args)[(L_index + 1)]);
		    if ((L_temp.heapptr == &SYM_pointer_HEAP)) {

			/* #line 386 "./condition.dylan" */
			if ((&dylanZdylan_visceraZCLS_raw_pointer_HEAP == SLOT(L_value.heapptr, heapptr_t, 0))) {
			    /* #line {Class <unknown-source-location>} */
			    L_pointer = L_value.dataword.ptr;
			    L_pointer_suppliedQUERY = TRUE;
			}
			else {

			    /* #line 389 "./condition.dylan" */
			    L_temp_2.heapptr = &networkZstr_ROOT;
			    L_temp_2.dataword.l = 0;
			    /* type-error-with-location */
			    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_value, &dylanZdylan_visceraZCLS_raw_pointer_HEAP, L_temp_2);
			    not_reached();
			}
		    }
		    /* #line {Class <unknown-source-location>} */
		    L_index = (L_index - 2);
		}
		else {

		    /* #line 389 "./condition.dylan" */
		    L_temp_3.heapptr = &networkZstr_ROOT;
		    L_temp_3.dataword.l = 0;
		    /* type-error-with-location */
		    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp, &dylanZdylan_visceraZCLS_symbol_HEAP, L_temp_3);
		    not_reached();
		}
	    }
	}
      block0:;
	/* #line {Class <unknown-source-location>} */
	orig_sp = L_args;
	/* maker for <in-addr> */
	L_result0 = networkZnetwork_internalZCLS_in_addr_MAKER_FUN(orig_sp, L_pointer, L_pointer_suppliedQUERY);
	L_temp_4.heapptr = networkZliteral_43.heapptr;
	L_temp_4.dataword.ptr = L_result0;
	orig_sp[0] = L_temp_4;
	return orig_sp + 1;
    }
    else {
	/* odd-number-of-keyword/value-arguments-error */
	dylanZdylan_visceraZodd_number_of_keywordSLASHvalue_arguments_error_FUN(orig_sp);
	not_reached();
    }
}


/* Define Sealed Domain make (singleton(<in-addr>)) */


/* {Implicit} Define Generic get-s-addr */

/* get-s-addr is get-s-addr */


/* Define Method get-s-addr{<in-addr>} */

/* get-s-addr{<in-addr>} */
long networkZnetwork_internalZget_s_addr_METH(descriptor_t *orig_sp, void * A_ptr /* ptr */, heapptr_t A1)
{
    descriptor_t *cluster_0_top;


    /* #line 211 "./melange.dylan" */

    /* #line 91 "./rawptr.dylan" */
    return (*(long *)((char *)A_ptr + 0 ));
}


/* {Implicit} Define Generic get-s-addr-setter */

/* get-s-addr-setter is get-s-addr-setter */


/* Define Method get-s-addr-setter{<integer>, <in-addr>} */

/* get-s-addr-setter{<integer>, <in-addr>} */
long networkZnetwork_internalZget_s_addr_setter_METH(descriptor_t *orig_sp, long A_value /* value */, void * A_ptr /* ptr */, heapptr_t A2)
{
    descriptor_t *cluster_0_top;

    /* #line {Class <unknown-source-location>} */

    /* #line 97 "./rawptr.dylan" */
    *(long *)((char *)A_ptr + 0) = A_value;
    return A_value;
}


/* Define Method pointer-value{<in-addr>} */

extern struct heapobj networkZstr_ROOT_56;

/* pointer-value{<in-addr>} */
void * networkZnetwork_internalZpointer_value_METH_33(descriptor_t *orig_sp, void * A_value /* value */, heapptr_t A_next_method_info /* next-method-info */, heapptr_t A_rest /* rest */, descriptor_t A_index /* index */)
{
    descriptor_t *cluster_0_top;
    descriptor_t L_temp;
    descriptor_t L_arg1; /* arg1 */
    descriptor_t L_temp_2;
    descriptor_t L_temp_3; /* temp */
    descriptor_t L_temp_4;

    /* #line {Class <unknown-source-location>} */

    /* #line 2054 "./sockets-api.dylan" */
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = 4;
    orig_sp[0] = A_index;
    orig_sp[1] = L_temp;
    /* * */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZV_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_arg1 = (orig_sp == cluster_0_top ? dylanZfalse : orig_sp[0]);

    /* #line 2054 "./sockets-api.dylan" */
    L_temp_2.heapptr = networkZliteral_43.heapptr;
    L_temp_2.dataword.ptr = A_value;
    orig_sp[0] = L_temp_2;
    orig_sp[1] = L_arg1;
    /* + */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZPLUS_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_temp_3 = (orig_sp == cluster_0_top ? dylanZfalse : orig_sp[0]);

    /* #line 386 "./condition.dylan" */
    if ((&networkZnetwork_internalZCLS_in_addr_HEAP == SLOT(L_temp_3.heapptr, heapptr_t, 0))) {

	/* #line 2054 "./sockets-api.dylan" */
	return L_temp_3.dataword.ptr;
    }
    else {

	/* #line 389 "./condition.dylan" */
	L_temp_4.heapptr = &networkZstr_ROOT_56;
	L_temp_4.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp_3, &networkZnetwork_internalZCLS_in_addr_HEAP, L_temp_4);
	not_reached();
    }
}

/* generic-entry for pointer-value{<in-addr>} */
descriptor_t * networkZnetwork_internalZpointer_value_METH_GENERIC_33(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    descriptor_t L_arg; /* arg */
    heapptr_t L_rest; /* rest */
    void * L_arg_2; /* arg */
    descriptor_t L_index; /* index */
    long L_index_2; /* index */
    descriptor_t L_key; /* key */
    descriptor_t L_value; /* value */
    void * L_result0; /* result0 */
    descriptor_t L_temp;

    /* #line {Class <unknown-source-location>} */
    L_args = ((void *)(orig_sp - A_nargs));
    L_arg = (((descriptor_t *)L_args)[0]);
    L_rest = dylanZdylan_visceraZmake_rest_arg_FUN(orig_sp, (descriptor_t *)L_args + 1, A_nargs - 1);
    L_arg_2 = L_arg.dataword.ptr;
    L_index.heapptr = networkZliteral_2.heapptr;
    L_index.dataword.l = 0;
    L_index_2 = (A_nargs - 2);
    while (1) {
	if ((L_index_2 < 1)) {
	    goto block0;
	}
	else {
	    L_key = (((descriptor_t *)L_args)[L_index_2]);
	    L_value = (((descriptor_t *)L_args)[(L_index_2 + 1)]);
	    if ((L_key.heapptr == &SYM_index_HEAP)) {
		L_index = L_value;
	    }
	    L_index_2 = (L_index_2 - 2);
	}
    }
  block0:;
    orig_sp = L_args;
    /* pointer-value{<in-addr>} */
    L_result0 = networkZnetwork_internalZpointer_value_METH_33(orig_sp, L_arg_2, A_next_method_info, L_rest, L_index);
    L_temp.heapptr = networkZliteral_43.heapptr;
    L_temp.dataword.ptr = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* Define Method content-size{subclass(<in-addr>)} */

/* content-size{subclass(<in-addr>)} */
long networkZnetwork_internalZcontent_size_METH_41(descriptor_t *orig_sp, heapptr_t A0, heapptr_t A1)
{

    return 4;
}

/* generic-entry for content-size{subclass(<in-addr>)} */
descriptor_t * networkZnetwork_internalZcontent_size_METH_GENERIC_41(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    long L_result0; /* result0 */
    descriptor_t L_temp;

    orig_sp = ((void *)(orig_sp - 1));
    /* content-size{subclass(<in-addr>)} */
    L_result0 = networkZnetwork_internalZcontent_size_METH_41(orig_sp, &networkZnetwork_internalZCLS_in_addr_HEAP, A_next_method_info);
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* Define Constant <uint8-t> */

/* <uint8-t> is <integer> */


/* Define Class <uint8-t*> */

/* <uint8-t*> is <uint8-t*> */

extern struct heapobj networkZnetwork_internalZCLS_uint8_tV_HEAP;

/* maker for <uint8-t*> */
void * networkZnetwork_internalZCLS_uint8_tV_MAKER_FUN(descriptor_t *orig_sp, void * A_pointer /* pointer */, int A_pointer_suppliedQUERY /* pointer-supplied? */)
{
    descriptor_t *cluster_0_top;


    /* #line 2063 "./sockets-api.dylan" */
    if (A_pointer_suppliedQUERY) {
	return A_pointer;
    }
    else {
	/* missing-required-init-keyword-error */
	dylanZdylan_visceraZmissing_required_init_keyword_error_FUN(orig_sp, &SYM_pointer_HEAP, &networkZnetwork_internalZCLS_uint8_tV_HEAP);
	not_reached();
    }
}

extern descriptor_t networkZliteral_44;	/* proxy for <uint8-t*> */

/* general-entry for maker for <uint8-t*> */
descriptor_t * networkZnetwork_internalZCLS_uint8_tV_MAKER_GENERAL(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    void * L_pointer; /* pointer */
    int L_pointer_suppliedQUERY; /* pointer-supplied? */
    long L_index; /* index */
    descriptor_t L_temp; /* temp */
    descriptor_t L_value; /* value */
    descriptor_t L_temp_2;
    descriptor_t L_temp_3;
    void * L_result0; /* result0 */
    descriptor_t L_temp_4;

    /* #line {Class <unknown-source-location>} */

    /* #line 126 "./cmp.dylan" */

    /* #line 209 "./num.dylan" */
    if (((A_nargs & 1) == 0)) {
	/* #line {Class <unknown-source-location>} */
	L_args = ((void *)(orig_sp - A_nargs));
	L_pointer = 0;
	L_pointer_suppliedQUERY = FALSE;
	L_index = (A_nargs - 2);
	while (1) {
	    if ((L_index < 0)) {
		goto block0;
	    }
	    else {
		L_temp = (((descriptor_t *)L_args)[L_index]);

		/* #line 386 "./condition.dylan" */
		if ((&dylanZdylan_visceraZCLS_symbol_HEAP == SLOT(L_temp.heapptr, heapptr_t, 0))) {
		    /* #line {Class <unknown-source-location>} */
		    L_value = (((descriptor_t *)L_args)[(L_index + 1)]);
		    if ((L_temp.heapptr == &SYM_pointer_HEAP)) {

			/* #line 386 "./condition.dylan" */
			if ((&dylanZdylan_visceraZCLS_raw_pointer_HEAP == SLOT(L_value.heapptr, heapptr_t, 0))) {
			    /* #line {Class <unknown-source-location>} */
			    L_pointer = L_value.dataword.ptr;
			    L_pointer_suppliedQUERY = TRUE;
			}
			else {

			    /* #line 389 "./condition.dylan" */
			    L_temp_2.heapptr = &networkZstr_ROOT;
			    L_temp_2.dataword.l = 0;
			    /* type-error-with-location */
			    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_value, &dylanZdylan_visceraZCLS_raw_pointer_HEAP, L_temp_2);
			    not_reached();
			}
		    }
		    /* #line {Class <unknown-source-location>} */
		    L_index = (L_index - 2);
		}
		else {

		    /* #line 389 "./condition.dylan" */
		    L_temp_3.heapptr = &networkZstr_ROOT;
		    L_temp_3.dataword.l = 0;
		    /* type-error-with-location */
		    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp, &dylanZdylan_visceraZCLS_symbol_HEAP, L_temp_3);
		    not_reached();
		}
	    }
	}
      block0:;
	/* #line {Class <unknown-source-location>} */
	orig_sp = L_args;
	/* maker for <uint8-t*> */
	L_result0 = networkZnetwork_internalZCLS_uint8_tV_MAKER_FUN(orig_sp, L_pointer, L_pointer_suppliedQUERY);
	L_temp_4.heapptr = networkZliteral_44.heapptr;
	L_temp_4.dataword.ptr = L_result0;
	orig_sp[0] = L_temp_4;
	return orig_sp + 1;
    }
    else {
	/* odd-number-of-keyword/value-arguments-error */
	dylanZdylan_visceraZodd_number_of_keywordSLASHvalue_arguments_error_FUN(orig_sp);
	not_reached();
    }
}


/* Define Sealed Domain make (singleton(<uint8-t*>)) */


/* Define Method pointer-value{<uint8-t*>} */

extern struct heapobj networkZstr_ROOT_57;

/* pointer-value{<uint8-t*>} */
long networkZnetwork_internalZpointer_value_METH_34(descriptor_t *orig_sp, descriptor_t A_ptr /* ptr */, heapptr_t A_next_method_info /* next-method-info */, heapptr_t A_rest /* rest */, descriptor_t A_index /* index */)
{
    descriptor_t *cluster_0_top;
    descriptor_t L_temp;
    descriptor_t L_arg2; /* arg2 */
    descriptor_t L_temp_2;


    /* #line 2070 "./sockets-api.dylan" */
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = 1;
    orig_sp[0] = A_index;
    orig_sp[1] = L_temp;
    /* * */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZV_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_arg2 = (orig_sp == cluster_0_top ? dylanZfalse : orig_sp[0]);

    /* #line 386 "./condition.dylan" */
    if ((&dylanZdylan_visceraZCLS_integer_HEAP == SLOT(L_arg2.heapptr, heapptr_t, 0))) {

	/* #line 2070 "./sockets-api.dylan" */

	/* #line 159 "./melange.dylan" */

	/* #line 91 "./rawptr.dylan" */
	return (*(unsigned char *)((char *)A_ptr.dataword.ptr + L_arg2.dataword.l ));
    }
    else {

	/* #line 389 "./condition.dylan" */
	L_temp_2.heapptr = &networkZstr_ROOT_57;
	L_temp_2.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_arg2, &dylanZdylan_visceraZCLS_integer_HEAP, L_temp_2);
	not_reached();
    }
}

/* generic-entry for pointer-value{<uint8-t*>} */
descriptor_t * networkZnetwork_internalZpointer_value_METH_GENERIC_34(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    descriptor_t L_arg; /* arg */
    heapptr_t L_rest; /* rest */
    descriptor_t L_arg_2; /* arg */
    descriptor_t L_index; /* index */
    long L_index_2; /* index */
    descriptor_t L_key; /* key */
    descriptor_t L_value; /* value */
    long L_result0; /* result0 */
    descriptor_t L_temp;

    /* #line {Class <unknown-source-location>} */
    L_args = ((void *)(orig_sp - A_nargs));
    L_arg = (((descriptor_t *)L_args)[0]);
    L_rest = dylanZdylan_visceraZmake_rest_arg_FUN(orig_sp, (descriptor_t *)L_args + 1, A_nargs - 1);
    L_arg_2 = L_arg;
    L_index.heapptr = networkZliteral_2.heapptr;
    L_index.dataword.l = 0;
    L_index_2 = (A_nargs - 2);
    while (1) {
	if ((L_index_2 < 1)) {
	    goto block0;
	}
	else {
	    L_key = (((descriptor_t *)L_args)[L_index_2]);
	    L_value = (((descriptor_t *)L_args)[(L_index_2 + 1)]);
	    if ((L_key.heapptr == &SYM_index_HEAP)) {
		L_index = L_value;
	    }
	    L_index_2 = (L_index_2 - 2);
	}
    }
  block0:;
    orig_sp = L_args;
    /* pointer-value{<uint8-t*>} */
    L_result0 = networkZnetwork_internalZpointer_value_METH_34(orig_sp, L_arg_2, A_next_method_info, L_rest, L_index);
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* Define Method pointer-value-setter{<integer>, <uint8-t*>} */

/* pointer-value-setter{<integer>, <uint8-t*>} */
long networkZnetwork_internalZpointer_value_setter_METH_9(descriptor_t *orig_sp, long A_value /* value */, descriptor_t A_ptr /* ptr */, heapptr_t A_next_method_info /* next-method-info */, heapptr_t A_rest /* rest */, descriptor_t A_index /* index */)
{
    descriptor_t *cluster_0_top;
    descriptor_t L_temp;
    descriptor_t L_arg3; /* arg3 */
    descriptor_t L_temp_2;


    /* #line 2076 "./sockets-api.dylan" */
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = 1;
    orig_sp[0] = A_index;
    orig_sp[1] = L_temp;
    /* * */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZV_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_arg3 = (orig_sp == cluster_0_top ? dylanZfalse : orig_sp[0]);

    /* #line 386 "./condition.dylan" */
    if ((&dylanZdylan_visceraZCLS_integer_HEAP == SLOT(L_arg3.heapptr, heapptr_t, 0))) {
	/* #line {Class <unknown-source-location>} */

	/* #line 97 "./rawptr.dylan" */
	*(unsigned char *)((char *)A_ptr.dataword.ptr + L_arg3.dataword.l) = A_value;
	return A_value;
    }
    else {

	/* #line 389 "./condition.dylan" */
	L_temp_2.heapptr = &networkZstr_ROOT;
	L_temp_2.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_arg3, &dylanZdylan_visceraZCLS_integer_HEAP, L_temp_2);
	not_reached();
    }
}

/* generic-entry for pointer-value-setter{<integer>, <uint8-t*>} */
descriptor_t * networkZnetwork_internalZpointer_value_setter_METH_GENERIC_9(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    descriptor_t L_arg; /* arg */
    descriptor_t L_arg_2; /* arg */
    heapptr_t L_rest; /* rest */
    long L_arg_3; /* arg */
    descriptor_t L_arg_4; /* arg */
    descriptor_t L_index; /* index */
    long L_index_2; /* index */
    descriptor_t L_key; /* key */
    descriptor_t L_value; /* value */
    long L_result0; /* result0 */
    descriptor_t L_temp;

    /* #line {Class <unknown-source-location>} */
    L_args = ((void *)(orig_sp - A_nargs));
    L_arg = (((descriptor_t *)L_args)[0]);
    L_arg_2 = (((descriptor_t *)L_args)[1]);
    L_rest = dylanZdylan_visceraZmake_rest_arg_FUN(orig_sp, (descriptor_t *)L_args + 2, A_nargs - 2);
    L_arg_3 = L_arg.dataword.l;
    L_arg_4 = L_arg_2;
    L_index.heapptr = networkZliteral_2.heapptr;
    L_index.dataword.l = 0;
    L_index_2 = (A_nargs - 2);
    while (1) {
	if ((L_index_2 < 2)) {
	    goto block0;
	}
	else {
	    L_key = (((descriptor_t *)L_args)[L_index_2]);
	    L_value = (((descriptor_t *)L_args)[(L_index_2 + 1)]);
	    if ((L_key.heapptr == &SYM_index_HEAP)) {
		L_index = L_value;
	    }
	    L_index_2 = (L_index_2 - 2);
	}
    }
  block0:;
    orig_sp = L_args;
    /* pointer-value-setter{<integer>, <uint8-t*>} */
    L_result0 = networkZnetwork_internalZpointer_value_setter_METH_9(orig_sp, L_arg_3, L_arg_4, A_next_method_info, L_rest, L_index);
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* Define Method content-size{subclass(<uint8-t*>)} */

/* content-size{subclass(<uint8-t*>)} */
long networkZnetwork_internalZcontent_size_METH_42(descriptor_t *orig_sp, heapptr_t A0, heapptr_t A1)
{

    return 1;
}

/* generic-entry for content-size{subclass(<uint8-t*>)} */
descriptor_t * networkZnetwork_internalZcontent_size_METH_GENERIC_42(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    descriptor_t L_arg; /* arg */
    heapptr_t L_arg_2; /* arg */
    long L_result0; /* result0 */
    descriptor_t L_temp;

    L_args = ((void *)(orig_sp - 1));
    L_arg = (((descriptor_t *)L_args)[0]);
    L_arg_2 = L_arg.heapptr;
    orig_sp = L_args;
    /* content-size{subclass(<uint8-t*>)} */
    L_result0 = networkZnetwork_internalZcontent_size_METH_42(orig_sp, L_arg_2, A_next_method_info);
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* Define Class <uint8-t<@16>> */

/* <uint8-t<@16>> is <uint8-t<@16>> */

extern struct heapobj networkZnetwork_internalZCLS_uint8_tLESSX4016GREATER_HEAP;

/* maker for <uint8-t<@16>> */
void * networkZnetwork_internalZCLS_uint8_tLESSX4016GREATER_MAKER_FUN(descriptor_t *orig_sp, void * A_pointer /* pointer */, int A_pointer_suppliedQUERY /* pointer-supplied? */)
{
    descriptor_t *cluster_0_top;


    /* #line 2084 "./sockets-api.dylan" */
    if (A_pointer_suppliedQUERY) {
	return A_pointer;
    }
    else {
	/* missing-required-init-keyword-error */
	dylanZdylan_visceraZmissing_required_init_keyword_error_FUN(orig_sp, &SYM_pointer_HEAP, &networkZnetwork_internalZCLS_uint8_tLESSX4016GREATER_HEAP);
	not_reached();
    }
}

extern descriptor_t networkZliteral_45;	/* proxy for <uint8-t<@16>> */

/* general-entry for maker for <uint8-t<@16>> */
descriptor_t * networkZnetwork_internalZCLS_uint8_tLESSX4016GREATER_MAKER_GENERAL(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    void * L_pointer; /* pointer */
    int L_pointer_suppliedQUERY; /* pointer-supplied? */
    long L_index; /* index */
    descriptor_t L_temp; /* temp */
    descriptor_t L_value; /* value */
    descriptor_t L_temp_2;
    descriptor_t L_temp_3;
    void * L_result0; /* result0 */
    descriptor_t L_temp_4;

    /* #line {Class <unknown-source-location>} */

    /* #line 126 "./cmp.dylan" */

    /* #line 209 "./num.dylan" */
    if (((A_nargs & 1) == 0)) {
	/* #line {Class <unknown-source-location>} */
	L_args = ((void *)(orig_sp - A_nargs));
	L_pointer = 0;
	L_pointer_suppliedQUERY = FALSE;
	L_index = (A_nargs - 2);
	while (1) {
	    if ((L_index < 0)) {
		goto block0;
	    }
	    else {
		L_temp = (((descriptor_t *)L_args)[L_index]);

		/* #line 386 "./condition.dylan" */
		if ((&dylanZdylan_visceraZCLS_symbol_HEAP == SLOT(L_temp.heapptr, heapptr_t, 0))) {
		    /* #line {Class <unknown-source-location>} */
		    L_value = (((descriptor_t *)L_args)[(L_index + 1)]);
		    if ((L_temp.heapptr == &SYM_pointer_HEAP)) {

			/* #line 386 "./condition.dylan" */
			if ((&dylanZdylan_visceraZCLS_raw_pointer_HEAP == SLOT(L_value.heapptr, heapptr_t, 0))) {
			    /* #line {Class <unknown-source-location>} */
			    L_pointer = L_value.dataword.ptr;
			    L_pointer_suppliedQUERY = TRUE;
			}
			else {

			    /* #line 389 "./condition.dylan" */
			    L_temp_2.heapptr = &networkZstr_ROOT;
			    L_temp_2.dataword.l = 0;
			    /* type-error-with-location */
			    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_value, &dylanZdylan_visceraZCLS_raw_pointer_HEAP, L_temp_2);
			    not_reached();
			}
		    }
		    /* #line {Class <unknown-source-location>} */
		    L_index = (L_index - 2);
		}
		else {

		    /* #line 389 "./condition.dylan" */
		    L_temp_3.heapptr = &networkZstr_ROOT;
		    L_temp_3.dataword.l = 0;
		    /* type-error-with-location */
		    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp, &dylanZdylan_visceraZCLS_symbol_HEAP, L_temp_3);
		    not_reached();
		}
	    }
	}
      block0:;
	/* #line {Class <unknown-source-location>} */
	orig_sp = L_args;
	/* maker for <uint8-t<@16>> */
	L_result0 = networkZnetwork_internalZCLS_uint8_tLESSX4016GREATER_MAKER_FUN(orig_sp, L_pointer, L_pointer_suppliedQUERY);
	L_temp_4.heapptr = networkZliteral_45.heapptr;
	L_temp_4.dataword.ptr = L_result0;
	orig_sp[0] = L_temp_4;
	return orig_sp + 1;
    }
    else {
	/* odd-number-of-keyword/value-arguments-error */
	dylanZdylan_visceraZodd_number_of_keywordSLASHvalue_arguments_error_FUN(orig_sp);
	not_reached();
    }
}


/* Define Sealed Domain make (singleton(<uint8-t<@16>>)) */


/* Define Method content-size{singleton(<uint8-t<@16>>)} */

/* content-size{singleton(<uint8-t<@16>>)} */
long networkZnetwork_internalZcontent_size_METH_43(descriptor_t *orig_sp, heapptr_t A0, heapptr_t A1)
{

    return 16;
}

/* generic-entry for content-size{singleton(<uint8-t<@16>>)} */
descriptor_t * networkZnetwork_internalZcontent_size_METH_GENERIC_43(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    long L_result0; /* result0 */
    descriptor_t L_temp;

    orig_sp = ((void *)(orig_sp - 1));
    /* content-size{singleton(<uint8-t<@16>>)} */
    L_result0 = networkZnetwork_internalZcontent_size_METH_43(orig_sp, &networkZnetwork_internalZCLS_uint8_tLESSX4016GREATER_HEAP, A_next_method_info);
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* Define Class <uint16-t*> */

/* <uint16-t*> is <uint16-t*> */

extern struct heapobj networkZnetwork_internalZCLS_uint16_tV_HEAP;

/* maker for <uint16-t*> */
void * networkZnetwork_internalZCLS_uint16_tV_MAKER_FUN(descriptor_t *orig_sp, void * A_pointer /* pointer */, int A_pointer_suppliedQUERY /* pointer-supplied? */)
{
    descriptor_t *cluster_0_top;


    /* #line 2092 "./sockets-api.dylan" */
    if (A_pointer_suppliedQUERY) {
	return A_pointer;
    }
    else {
	/* missing-required-init-keyword-error */
	dylanZdylan_visceraZmissing_required_init_keyword_error_FUN(orig_sp, &SYM_pointer_HEAP, &networkZnetwork_internalZCLS_uint16_tV_HEAP);
	not_reached();
    }
}

extern descriptor_t networkZliteral_46;	/* proxy for <uint16-t*> */

/* general-entry for maker for <uint16-t*> */
descriptor_t * networkZnetwork_internalZCLS_uint16_tV_MAKER_GENERAL(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    void * L_pointer; /* pointer */
    int L_pointer_suppliedQUERY; /* pointer-supplied? */
    long L_index; /* index */
    descriptor_t L_temp; /* temp */
    descriptor_t L_value; /* value */
    descriptor_t L_temp_2;
    descriptor_t L_temp_3;
    void * L_result0; /* result0 */
    descriptor_t L_temp_4;

    /* #line {Class <unknown-source-location>} */

    /* #line 126 "./cmp.dylan" */

    /* #line 209 "./num.dylan" */
    if (((A_nargs & 1) == 0)) {
	/* #line {Class <unknown-source-location>} */
	L_args = ((void *)(orig_sp - A_nargs));
	L_pointer = 0;
	L_pointer_suppliedQUERY = FALSE;
	L_index = (A_nargs - 2);
	while (1) {
	    if ((L_index < 0)) {
		goto block0;
	    }
	    else {
		L_temp = (((descriptor_t *)L_args)[L_index]);

		/* #line 386 "./condition.dylan" */
		if ((&dylanZdylan_visceraZCLS_symbol_HEAP == SLOT(L_temp.heapptr, heapptr_t, 0))) {
		    /* #line {Class <unknown-source-location>} */
		    L_value = (((descriptor_t *)L_args)[(L_index + 1)]);
		    if ((L_temp.heapptr == &SYM_pointer_HEAP)) {

			/* #line 386 "./condition.dylan" */
			if ((&dylanZdylan_visceraZCLS_raw_pointer_HEAP == SLOT(L_value.heapptr, heapptr_t, 0))) {
			    /* #line {Class <unknown-source-location>} */
			    L_pointer = L_value.dataword.ptr;
			    L_pointer_suppliedQUERY = TRUE;
			}
			else {

			    /* #line 389 "./condition.dylan" */
			    L_temp_2.heapptr = &networkZstr_ROOT;
			    L_temp_2.dataword.l = 0;
			    /* type-error-with-location */
			    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_value, &dylanZdylan_visceraZCLS_raw_pointer_HEAP, L_temp_2);
			    not_reached();
			}
		    }
		    /* #line {Class <unknown-source-location>} */
		    L_index = (L_index - 2);
		}
		else {

		    /* #line 389 "./condition.dylan" */
		    L_temp_3.heapptr = &networkZstr_ROOT;
		    L_temp_3.dataword.l = 0;
		    /* type-error-with-location */
		    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp, &dylanZdylan_visceraZCLS_symbol_HEAP, L_temp_3);
		    not_reached();
		}
	    }
	}
      block0:;
	/* #line {Class <unknown-source-location>} */
	orig_sp = L_args;
	/* maker for <uint16-t*> */
	L_result0 = networkZnetwork_internalZCLS_uint16_tV_MAKER_FUN(orig_sp, L_pointer, L_pointer_suppliedQUERY);
	L_temp_4.heapptr = networkZliteral_46.heapptr;
	L_temp_4.dataword.ptr = L_result0;
	orig_sp[0] = L_temp_4;
	return orig_sp + 1;
    }
    else {
	/* odd-number-of-keyword/value-arguments-error */
	dylanZdylan_visceraZodd_number_of_keywordSLASHvalue_arguments_error_FUN(orig_sp);
	not_reached();
    }
}


/* Define Sealed Domain make (singleton(<uint16-t*>)) */


/* Define Method pointer-value{<uint16-t*>} */

extern struct heapobj networkZstr_ROOT_58;

/* pointer-value{<uint16-t*>} */
long networkZnetwork_internalZpointer_value_METH_35(descriptor_t *orig_sp, descriptor_t A_ptr /* ptr */, heapptr_t A_next_method_info /* next-method-info */, heapptr_t A_rest /* rest */, descriptor_t A_index /* index */)
{
    descriptor_t *cluster_0_top;
    descriptor_t L_temp;
    descriptor_t L_arg2; /* arg2 */
    descriptor_t L_temp_2;


    /* #line 2099 "./sockets-api.dylan" */
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = 2;
    orig_sp[0] = A_index;
    orig_sp[1] = L_temp;
    /* * */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZV_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_arg2 = (orig_sp == cluster_0_top ? dylanZfalse : orig_sp[0]);

    /* #line 386 "./condition.dylan" */
    if ((&dylanZdylan_visceraZCLS_integer_HEAP == SLOT(L_arg2.heapptr, heapptr_t, 0))) {

	/* #line 2099 "./sockets-api.dylan" */

	/* #line 185 "./melange.dylan" */

	/* #line 91 "./rawptr.dylan" */
	return (*(unsigned short *)((char *)A_ptr.dataword.ptr + L_arg2.dataword.l ));
    }
    else {

	/* #line 389 "./condition.dylan" */
	L_temp_2.heapptr = &networkZstr_ROOT_58;
	L_temp_2.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_arg2, &dylanZdylan_visceraZCLS_integer_HEAP, L_temp_2);
	not_reached();
    }
}

/* generic-entry for pointer-value{<uint16-t*>} */
descriptor_t * networkZnetwork_internalZpointer_value_METH_GENERIC_35(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    descriptor_t L_arg; /* arg */
    heapptr_t L_rest; /* rest */
    descriptor_t L_arg_2; /* arg */
    descriptor_t L_index; /* index */
    long L_index_2; /* index */
    descriptor_t L_key; /* key */
    descriptor_t L_value; /* value */
    long L_result0; /* result0 */
    descriptor_t L_temp;

    /* #line {Class <unknown-source-location>} */
    L_args = ((void *)(orig_sp - A_nargs));
    L_arg = (((descriptor_t *)L_args)[0]);
    L_rest = dylanZdylan_visceraZmake_rest_arg_FUN(orig_sp, (descriptor_t *)L_args + 1, A_nargs - 1);
    L_arg_2 = L_arg;
    L_index.heapptr = networkZliteral_2.heapptr;
    L_index.dataword.l = 0;
    L_index_2 = (A_nargs - 2);
    while (1) {
	if ((L_index_2 < 1)) {
	    goto block0;
	}
	else {
	    L_key = (((descriptor_t *)L_args)[L_index_2]);
	    L_value = (((descriptor_t *)L_args)[(L_index_2 + 1)]);
	    if ((L_key.heapptr == &SYM_index_HEAP)) {
		L_index = L_value;
	    }
	    L_index_2 = (L_index_2 - 2);
	}
    }
  block0:;
    orig_sp = L_args;
    /* pointer-value{<uint16-t*>} */
    L_result0 = networkZnetwork_internalZpointer_value_METH_35(orig_sp, L_arg_2, A_next_method_info, L_rest, L_index);
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* Define Method pointer-value-setter{<integer>, <uint16-t*>} */

/* pointer-value-setter{<integer>, <uint16-t*>} */
long networkZnetwork_internalZpointer_value_setter_METH_10(descriptor_t *orig_sp, long A_value /* value */, descriptor_t A_ptr /* ptr */, heapptr_t A_next_method_info /* next-method-info */, heapptr_t A_rest /* rest */, descriptor_t A_index /* index */)
{
    descriptor_t *cluster_0_top;
    descriptor_t L_temp;
    descriptor_t L_arg3; /* arg3 */
    descriptor_t L_temp_2;


    /* #line 2105 "./sockets-api.dylan" */
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = 2;
    orig_sp[0] = A_index;
    orig_sp[1] = L_temp;
    /* * */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZV_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_arg3 = (orig_sp == cluster_0_top ? dylanZfalse : orig_sp[0]);

    /* #line 386 "./condition.dylan" */
    if ((&dylanZdylan_visceraZCLS_integer_HEAP == SLOT(L_arg3.heapptr, heapptr_t, 0))) {
	/* #line {Class <unknown-source-location>} */

	/* #line 97 "./rawptr.dylan" */
	*(unsigned short *)((char *)A_ptr.dataword.ptr + L_arg3.dataword.l) = A_value;
	return A_value;
    }
    else {

	/* #line 389 "./condition.dylan" */
	L_temp_2.heapptr = &networkZstr_ROOT;
	L_temp_2.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_arg3, &dylanZdylan_visceraZCLS_integer_HEAP, L_temp_2);
	not_reached();
    }
}

/* generic-entry for pointer-value-setter{<integer>, <uint16-t*>} */
descriptor_t * networkZnetwork_internalZpointer_value_setter_METH_GENERIC_10(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    descriptor_t L_arg; /* arg */
    descriptor_t L_arg_2; /* arg */
    heapptr_t L_rest; /* rest */
    long L_arg_3; /* arg */
    descriptor_t L_arg_4; /* arg */
    descriptor_t L_index; /* index */
    long L_index_2; /* index */
    descriptor_t L_key; /* key */
    descriptor_t L_value; /* value */
    long L_result0; /* result0 */
    descriptor_t L_temp;

    /* #line {Class <unknown-source-location>} */
    L_args = ((void *)(orig_sp - A_nargs));
    L_arg = (((descriptor_t *)L_args)[0]);
    L_arg_2 = (((descriptor_t *)L_args)[1]);
    L_rest = dylanZdylan_visceraZmake_rest_arg_FUN(orig_sp, (descriptor_t *)L_args + 2, A_nargs - 2);
    L_arg_3 = L_arg.dataword.l;
    L_arg_4 = L_arg_2;
    L_index.heapptr = networkZliteral_2.heapptr;
    L_index.dataword.l = 0;
    L_index_2 = (A_nargs - 2);
    while (1) {
	if ((L_index_2 < 2)) {
	    goto block0;
	}
	else {
	    L_key = (((descriptor_t *)L_args)[L_index_2]);
	    L_value = (((descriptor_t *)L_args)[(L_index_2 + 1)]);
	    if ((L_key.heapptr == &SYM_index_HEAP)) {
		L_index = L_value;
	    }
	    L_index_2 = (L_index_2 - 2);
	}
    }
  block0:;
    orig_sp = L_args;
    /* pointer-value-setter{<integer>, <uint16-t*>} */
    L_result0 = networkZnetwork_internalZpointer_value_setter_METH_10(orig_sp, L_arg_3, L_arg_4, A_next_method_info, L_rest, L_index);
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* Define Method content-size{subclass(<uint16-t*>)} */

/* content-size{subclass(<uint16-t*>)} */
long networkZnetwork_internalZcontent_size_METH_44(descriptor_t *orig_sp, heapptr_t A0, heapptr_t A1)
{

    return 2;
}

/* generic-entry for content-size{subclass(<uint16-t*>)} */
descriptor_t * networkZnetwork_internalZcontent_size_METH_GENERIC_44(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    descriptor_t L_arg; /* arg */
    heapptr_t L_arg_2; /* arg */
    long L_result0; /* result0 */
    descriptor_t L_temp;

    L_args = ((void *)(orig_sp - 1));
    L_arg = (((descriptor_t *)L_args)[0]);
    L_arg_2 = L_arg.heapptr;
    orig_sp = L_args;
    /* content-size{subclass(<uint16-t*>)} */
    L_result0 = networkZnetwork_internalZcontent_size_METH_44(orig_sp, L_arg_2, A_next_method_info);
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* Define Class <uint16-t<@8>> */

/* <uint16-t<@8>> is <uint16-t<@8>> */

extern struct heapobj networkZnetwork_internalZCLS_uint16_tLESSX408GREATER_HEAP;

/* maker for <uint16-t<@8>> */
void * networkZnetwork_internalZCLS_uint16_tLESSX408GREATER_MAKER_FUN(descriptor_t *orig_sp, void * A_pointer /* pointer */, int A_pointer_suppliedQUERY /* pointer-supplied? */)
{
    descriptor_t *cluster_0_top;


    /* #line 2113 "./sockets-api.dylan" */
    if (A_pointer_suppliedQUERY) {
	return A_pointer;
    }
    else {
	/* missing-required-init-keyword-error */
	dylanZdylan_visceraZmissing_required_init_keyword_error_FUN(orig_sp, &SYM_pointer_HEAP, &networkZnetwork_internalZCLS_uint16_tLESSX408GREATER_HEAP);
	not_reached();
    }
}

extern descriptor_t networkZliteral_47;	/* proxy for <uint16-t<@8>> */

/* general-entry for maker for <uint16-t<@8>> */
descriptor_t * networkZnetwork_internalZCLS_uint16_tLESSX408GREATER_MAKER_GENERAL(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    void * L_pointer; /* pointer */
    int L_pointer_suppliedQUERY; /* pointer-supplied? */
    long L_index; /* index */
    descriptor_t L_temp; /* temp */
    descriptor_t L_value; /* value */
    descriptor_t L_temp_2;
    descriptor_t L_temp_3;
    void * L_result0; /* result0 */
    descriptor_t L_temp_4;

    /* #line {Class <unknown-source-location>} */

    /* #line 126 "./cmp.dylan" */

    /* #line 209 "./num.dylan" */
    if (((A_nargs & 1) == 0)) {
	/* #line {Class <unknown-source-location>} */
	L_args = ((void *)(orig_sp - A_nargs));
	L_pointer = 0;
	L_pointer_suppliedQUERY = FALSE;
	L_index = (A_nargs - 2);
	while (1) {
	    if ((L_index < 0)) {
		goto block0;
	    }
	    else {
		L_temp = (((descriptor_t *)L_args)[L_index]);

		/* #line 386 "./condition.dylan" */
		if ((&dylanZdylan_visceraZCLS_symbol_HEAP == SLOT(L_temp.heapptr, heapptr_t, 0))) {
		    /* #line {Class <unknown-source-location>} */
		    L_value = (((descriptor_t *)L_args)[(L_index + 1)]);
		    if ((L_temp.heapptr == &SYM_pointer_HEAP)) {

			/* #line 386 "./condition.dylan" */
			if ((&dylanZdylan_visceraZCLS_raw_pointer_HEAP == SLOT(L_value.heapptr, heapptr_t, 0))) {
			    /* #line {Class <unknown-source-location>} */
			    L_pointer = L_value.dataword.ptr;
			    L_pointer_suppliedQUERY = TRUE;
			}
			else {

			    /* #line 389 "./condition.dylan" */
			    L_temp_2.heapptr = &networkZstr_ROOT;
			    L_temp_2.dataword.l = 0;
			    /* type-error-with-location */
			    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_value, &dylanZdylan_visceraZCLS_raw_pointer_HEAP, L_temp_2);
			    not_reached();
			}
		    }
		    /* #line {Class <unknown-source-location>} */
		    L_index = (L_index - 2);
		}
		else {

		    /* #line 389 "./condition.dylan" */
		    L_temp_3.heapptr = &networkZstr_ROOT;
		    L_temp_3.dataword.l = 0;
		    /* type-error-with-location */
		    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp, &dylanZdylan_visceraZCLS_symbol_HEAP, L_temp_3);
		    not_reached();
		}
	    }
	}
      block0:;
	/* #line {Class <unknown-source-location>} */
	orig_sp = L_args;
	/* maker for <uint16-t<@8>> */
	L_result0 = networkZnetwork_internalZCLS_uint16_tLESSX408GREATER_MAKER_FUN(orig_sp, L_pointer, L_pointer_suppliedQUERY);
	L_temp_4.heapptr = networkZliteral_47.heapptr;
	L_temp_4.dataword.ptr = L_result0;
	orig_sp[0] = L_temp_4;
	return orig_sp + 1;
    }
    else {
	/* odd-number-of-keyword/value-arguments-error */
	dylanZdylan_visceraZodd_number_of_keywordSLASHvalue_arguments_error_FUN(orig_sp);
	not_reached();
    }
}


/* Define Sealed Domain make (singleton(<uint16-t<@8>>)) */


/* Define Method content-size{singleton(<uint16-t<@8>>)} */

/* content-size{singleton(<uint16-t<@8>>)} */
long networkZnetwork_internalZcontent_size_METH_45(descriptor_t *orig_sp, heapptr_t A0, heapptr_t A1)
{

    return 8;
}

/* generic-entry for content-size{singleton(<uint16-t<@8>>)} */
descriptor_t * networkZnetwork_internalZcontent_size_METH_GENERIC_45(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    long L_result0; /* result0 */
    descriptor_t L_temp;

    orig_sp = ((void *)(orig_sp - 1));
    /* content-size{singleton(<uint16-t<@8>>)} */
    L_result0 = networkZnetwork_internalZcontent_size_METH_45(orig_sp, &networkZnetwork_internalZCLS_uint16_tLESSX408GREATER_HEAP, A_next_method_info);
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* Define Class <uint32-t*> */

/* <uint32-t*> is <uint32-t*> */

extern struct heapobj networkZnetwork_internalZCLS_uint32_tV_HEAP;

/* maker for <uint32-t*> */
void * networkZnetwork_internalZCLS_uint32_tV_MAKER_FUN(descriptor_t *orig_sp, void * A_pointer /* pointer */, int A_pointer_suppliedQUERY /* pointer-supplied? */)
{
    descriptor_t *cluster_0_top;


    /* #line 2121 "./sockets-api.dylan" */
    if (A_pointer_suppliedQUERY) {
	return A_pointer;
    }
    else {
	/* missing-required-init-keyword-error */
	dylanZdylan_visceraZmissing_required_init_keyword_error_FUN(orig_sp, &SYM_pointer_HEAP, &networkZnetwork_internalZCLS_uint32_tV_HEAP);
	not_reached();
    }
}

extern descriptor_t networkZliteral_48;	/* proxy for <uint32-t*> */

/* general-entry for maker for <uint32-t*> */
descriptor_t * networkZnetwork_internalZCLS_uint32_tV_MAKER_GENERAL(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    void * L_pointer; /* pointer */
    int L_pointer_suppliedQUERY; /* pointer-supplied? */
    long L_index; /* index */
    descriptor_t L_temp; /* temp */
    descriptor_t L_value; /* value */
    descriptor_t L_temp_2;
    descriptor_t L_temp_3;
    void * L_result0; /* result0 */
    descriptor_t L_temp_4;

    /* #line {Class <unknown-source-location>} */

    /* #line 126 "./cmp.dylan" */

    /* #line 209 "./num.dylan" */
    if (((A_nargs & 1) == 0)) {
	/* #line {Class <unknown-source-location>} */
	L_args = ((void *)(orig_sp - A_nargs));
	L_pointer = 0;
	L_pointer_suppliedQUERY = FALSE;
	L_index = (A_nargs - 2);
	while (1) {
	    if ((L_index < 0)) {
		goto block0;
	    }
	    else {
		L_temp = (((descriptor_t *)L_args)[L_index]);

		/* #line 386 "./condition.dylan" */
		if ((&dylanZdylan_visceraZCLS_symbol_HEAP == SLOT(L_temp.heapptr, heapptr_t, 0))) {
		    /* #line {Class <unknown-source-location>} */
		    L_value = (((descriptor_t *)L_args)[(L_index + 1)]);
		    if ((L_temp.heapptr == &SYM_pointer_HEAP)) {

			/* #line 386 "./condition.dylan" */
			if ((&dylanZdylan_visceraZCLS_raw_pointer_HEAP == SLOT(L_value.heapptr, heapptr_t, 0))) {
			    /* #line {Class <unknown-source-location>} */
			    L_pointer = L_value.dataword.ptr;
			    L_pointer_suppliedQUERY = TRUE;
			}
			else {

			    /* #line 389 "./condition.dylan" */
			    L_temp_2.heapptr = &networkZstr_ROOT;
			    L_temp_2.dataword.l = 0;
			    /* type-error-with-location */
			    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_value, &dylanZdylan_visceraZCLS_raw_pointer_HEAP, L_temp_2);
			    not_reached();
			}
		    }
		    /* #line {Class <unknown-source-location>} */
		    L_index = (L_index - 2);
		}
		else {

		    /* #line 389 "./condition.dylan" */
		    L_temp_3.heapptr = &networkZstr_ROOT;
		    L_temp_3.dataword.l = 0;
		    /* type-error-with-location */
		    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp, &dylanZdylan_visceraZCLS_symbol_HEAP, L_temp_3);
		    not_reached();
		}
	    }
	}
      block0:;
	/* #line {Class <unknown-source-location>} */
	orig_sp = L_args;
	/* maker for <uint32-t*> */
	L_result0 = networkZnetwork_internalZCLS_uint32_tV_MAKER_FUN(orig_sp, L_pointer, L_pointer_suppliedQUERY);
	L_temp_4.heapptr = networkZliteral_48.heapptr;
	L_temp_4.dataword.ptr = L_result0;
	orig_sp[0] = L_temp_4;
	return orig_sp + 1;
    }
    else {
	/* odd-number-of-keyword/value-arguments-error */
	dylanZdylan_visceraZodd_number_of_keywordSLASHvalue_arguments_error_FUN(orig_sp);
	not_reached();
    }
}


/* Define Sealed Domain make (singleton(<uint32-t*>)) */


/* Define Method pointer-value{<uint32-t*>} */

extern struct heapobj networkZstr_ROOT_59;

/* pointer-value{<uint32-t*>} */
long networkZnetwork_internalZpointer_value_METH_36(descriptor_t *orig_sp, descriptor_t A_ptr /* ptr */, heapptr_t A_next_method_info /* next-method-info */, heapptr_t A_rest /* rest */, descriptor_t A_index /* index */)
{
    descriptor_t *cluster_0_top;
    descriptor_t L_temp;
    descriptor_t L_arg2; /* arg2 */
    descriptor_t L_temp_2;


    /* #line 2128 "./sockets-api.dylan" */
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = 4;
    orig_sp[0] = A_index;
    orig_sp[1] = L_temp;
    /* * */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZV_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_arg2 = (orig_sp == cluster_0_top ? dylanZfalse : orig_sp[0]);

    /* #line 386 "./condition.dylan" */
    if ((&dylanZdylan_visceraZCLS_integer_HEAP == SLOT(L_arg2.heapptr, heapptr_t, 0))) {

	/* #line 2128 "./sockets-api.dylan" */

	/* #line 211 "./melange.dylan" */

	/* #line 91 "./rawptr.dylan" */
	return (*(long *)((char *)A_ptr.dataword.ptr + L_arg2.dataword.l ));
    }
    else {

	/* #line 389 "./condition.dylan" */
	L_temp_2.heapptr = &networkZstr_ROOT_59;
	L_temp_2.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_arg2, &dylanZdylan_visceraZCLS_integer_HEAP, L_temp_2);
	not_reached();
    }
}

/* generic-entry for pointer-value{<uint32-t*>} */
descriptor_t * networkZnetwork_internalZpointer_value_METH_GENERIC_36(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    descriptor_t L_arg; /* arg */
    heapptr_t L_rest; /* rest */
    descriptor_t L_arg_2; /* arg */
    descriptor_t L_index; /* index */
    long L_index_2; /* index */
    descriptor_t L_key; /* key */
    descriptor_t L_value; /* value */
    long L_result0; /* result0 */
    descriptor_t L_temp;

    /* #line {Class <unknown-source-location>} */
    L_args = ((void *)(orig_sp - A_nargs));
    L_arg = (((descriptor_t *)L_args)[0]);
    L_rest = dylanZdylan_visceraZmake_rest_arg_FUN(orig_sp, (descriptor_t *)L_args + 1, A_nargs - 1);
    L_arg_2 = L_arg;
    L_index.heapptr = networkZliteral_2.heapptr;
    L_index.dataword.l = 0;
    L_index_2 = (A_nargs - 2);
    while (1) {
	if ((L_index_2 < 1)) {
	    goto block0;
	}
	else {
	    L_key = (((descriptor_t *)L_args)[L_index_2]);
	    L_value = (((descriptor_t *)L_args)[(L_index_2 + 1)]);
	    if ((L_key.heapptr == &SYM_index_HEAP)) {
		L_index = L_value;
	    }
	    L_index_2 = (L_index_2 - 2);
	}
    }
  block0:;
    orig_sp = L_args;
    /* pointer-value{<uint32-t*>} */
    L_result0 = networkZnetwork_internalZpointer_value_METH_36(orig_sp, L_arg_2, A_next_method_info, L_rest, L_index);
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* Define Method pointer-value-setter{<integer>, <uint32-t*>} */

/* pointer-value-setter{<integer>, <uint32-t*>} */
long networkZnetwork_internalZpointer_value_setter_METH_11(descriptor_t *orig_sp, long A_value /* value */, descriptor_t A_ptr /* ptr */, heapptr_t A_next_method_info /* next-method-info */, heapptr_t A_rest /* rest */, descriptor_t A_index /* index */)
{
    descriptor_t *cluster_0_top;
    descriptor_t L_temp;
    descriptor_t L_arg3; /* arg3 */
    descriptor_t L_temp_2;


    /* #line 2134 "./sockets-api.dylan" */
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = 4;
    orig_sp[0] = A_index;
    orig_sp[1] = L_temp;
    /* * */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZV_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_arg3 = (orig_sp == cluster_0_top ? dylanZfalse : orig_sp[0]);

    /* #line 386 "./condition.dylan" */
    if ((&dylanZdylan_visceraZCLS_integer_HEAP == SLOT(L_arg3.heapptr, heapptr_t, 0))) {
	/* #line {Class <unknown-source-location>} */

	/* #line 97 "./rawptr.dylan" */
	*(long *)((char *)A_ptr.dataword.ptr + L_arg3.dataword.l) = A_value;
	return A_value;
    }
    else {

	/* #line 389 "./condition.dylan" */
	L_temp_2.heapptr = &networkZstr_ROOT;
	L_temp_2.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_arg3, &dylanZdylan_visceraZCLS_integer_HEAP, L_temp_2);
	not_reached();
    }
}

/* generic-entry for pointer-value-setter{<integer>, <uint32-t*>} */
descriptor_t * networkZnetwork_internalZpointer_value_setter_METH_GENERIC_11(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    descriptor_t L_arg; /* arg */
    descriptor_t L_arg_2; /* arg */
    heapptr_t L_rest; /* rest */
    long L_arg_3; /* arg */
    descriptor_t L_arg_4; /* arg */
    descriptor_t L_index; /* index */
    long L_index_2; /* index */
    descriptor_t L_key; /* key */
    descriptor_t L_value; /* value */
    long L_result0; /* result0 */
    descriptor_t L_temp;

    /* #line {Class <unknown-source-location>} */
    L_args = ((void *)(orig_sp - A_nargs));
    L_arg = (((descriptor_t *)L_args)[0]);
    L_arg_2 = (((descriptor_t *)L_args)[1]);
    L_rest = dylanZdylan_visceraZmake_rest_arg_FUN(orig_sp, (descriptor_t *)L_args + 2, A_nargs - 2);
    L_arg_3 = L_arg.dataword.l;
    L_arg_4 = L_arg_2;
    L_index.heapptr = networkZliteral_2.heapptr;
    L_index.dataword.l = 0;
    L_index_2 = (A_nargs - 2);
    while (1) {
	if ((L_index_2 < 2)) {
	    goto block0;
	}
	else {
	    L_key = (((descriptor_t *)L_args)[L_index_2]);
	    L_value = (((descriptor_t *)L_args)[(L_index_2 + 1)]);
	    if ((L_key.heapptr == &SYM_index_HEAP)) {
		L_index = L_value;
	    }
	    L_index_2 = (L_index_2 - 2);
	}
    }
  block0:;
    orig_sp = L_args;
    /* pointer-value-setter{<integer>, <uint32-t*>} */
    L_result0 = networkZnetwork_internalZpointer_value_setter_METH_11(orig_sp, L_arg_3, L_arg_4, A_next_method_info, L_rest, L_index);
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* Define Method content-size{subclass(<uint32-t*>)} */

/* content-size{subclass(<uint32-t*>)} */
long networkZnetwork_internalZcontent_size_METH_46(descriptor_t *orig_sp, heapptr_t A0, heapptr_t A1)
{

    return 4;
}

/* generic-entry for content-size{subclass(<uint32-t*>)} */
descriptor_t * networkZnetwork_internalZcontent_size_METH_GENERIC_46(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    descriptor_t L_arg; /* arg */
    heapptr_t L_arg_2; /* arg */
    long L_result0; /* result0 */
    descriptor_t L_temp;

    L_args = ((void *)(orig_sp - 1));
    L_arg = (((descriptor_t *)L_args)[0]);
    L_arg_2 = L_arg.heapptr;
    orig_sp = L_args;
    /* content-size{subclass(<uint32-t*>)} */
    L_result0 = networkZnetwork_internalZcontent_size_METH_46(orig_sp, L_arg_2, A_next_method_info);
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* Define Class <uint32-t<@4>> */

/* <uint32-t<@4>> is <uint32-t<@4>> */

extern struct heapobj networkZnetwork_internalZCLS_uint32_tLESSX404GREATER_HEAP;

/* maker for <uint32-t<@4>> */
void * networkZnetwork_internalZCLS_uint32_tLESSX404GREATER_MAKER_FUN(descriptor_t *orig_sp, void * A_pointer /* pointer */, int A_pointer_suppliedQUERY /* pointer-supplied? */)
{
    descriptor_t *cluster_0_top;


    /* #line 2142 "./sockets-api.dylan" */
    if (A_pointer_suppliedQUERY) {
	return A_pointer;
    }
    else {
	/* missing-required-init-keyword-error */
	dylanZdylan_visceraZmissing_required_init_keyword_error_FUN(orig_sp, &SYM_pointer_HEAP, &networkZnetwork_internalZCLS_uint32_tLESSX404GREATER_HEAP);
	not_reached();
    }
}

extern descriptor_t networkZliteral_49;	/* proxy for <uint32-t<@4>> */

/* general-entry for maker for <uint32-t<@4>> */
descriptor_t * networkZnetwork_internalZCLS_uint32_tLESSX404GREATER_MAKER_GENERAL(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    void * L_pointer; /* pointer */
    int L_pointer_suppliedQUERY; /* pointer-supplied? */
    long L_index; /* index */
    descriptor_t L_temp; /* temp */
    descriptor_t L_value; /* value */
    descriptor_t L_temp_2;
    descriptor_t L_temp_3;
    void * L_result0; /* result0 */
    descriptor_t L_temp_4;

    /* #line {Class <unknown-source-location>} */

    /* #line 126 "./cmp.dylan" */

    /* #line 209 "./num.dylan" */
    if (((A_nargs & 1) == 0)) {
	/* #line {Class <unknown-source-location>} */
	L_args = ((void *)(orig_sp - A_nargs));
	L_pointer = 0;
	L_pointer_suppliedQUERY = FALSE;
	L_index = (A_nargs - 2);
	while (1) {
	    if ((L_index < 0)) {
		goto block0;
	    }
	    else {
		L_temp = (((descriptor_t *)L_args)[L_index]);

		/* #line 386 "./condition.dylan" */
		if ((&dylanZdylan_visceraZCLS_symbol_HEAP == SLOT(L_temp.heapptr, heapptr_t, 0))) {
		    /* #line {Class <unknown-source-location>} */
		    L_value = (((descriptor_t *)L_args)[(L_index + 1)]);
		    if ((L_temp.heapptr == &SYM_pointer_HEAP)) {

			/* #line 386 "./condition.dylan" */
			if ((&dylanZdylan_visceraZCLS_raw_pointer_HEAP == SLOT(L_value.heapptr, heapptr_t, 0))) {
			    /* #line {Class <unknown-source-location>} */
			    L_pointer = L_value.dataword.ptr;
			    L_pointer_suppliedQUERY = TRUE;
			}
			else {

			    /* #line 389 "./condition.dylan" */
			    L_temp_2.heapptr = &networkZstr_ROOT;
			    L_temp_2.dataword.l = 0;
			    /* type-error-with-location */
			    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_value, &dylanZdylan_visceraZCLS_raw_pointer_HEAP, L_temp_2);
			    not_reached();
			}
		    }
		    /* #line {Class <unknown-source-location>} */
		    L_index = (L_index - 2);
		}
		else {

		    /* #line 389 "./condition.dylan" */
		    L_temp_3.heapptr = &networkZstr_ROOT;
		    L_temp_3.dataword.l = 0;
		    /* type-error-with-location */
		    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp, &dylanZdylan_visceraZCLS_symbol_HEAP, L_temp_3);
		    not_reached();
		}
	    }
	}
      block0:;
	/* #line {Class <unknown-source-location>} */
	orig_sp = L_args;
	/* maker for <uint32-t<@4>> */
	L_result0 = networkZnetwork_internalZCLS_uint32_tLESSX404GREATER_MAKER_FUN(orig_sp, L_pointer, L_pointer_suppliedQUERY);
	L_temp_4.heapptr = networkZliteral_49.heapptr;
	L_temp_4.dataword.ptr = L_result0;
	orig_sp[0] = L_temp_4;
	return orig_sp + 1;
    }
    else {
	/* odd-number-of-keyword/value-arguments-error */
	dylanZdylan_visceraZodd_number_of_keywordSLASHvalue_arguments_error_FUN(orig_sp);
	not_reached();
    }
}


/* Define Sealed Domain make (singleton(<uint32-t<@4>>)) */


/* Define Method content-size{singleton(<uint32-t<@4>>)} */

/* content-size{singleton(<uint32-t<@4>>)} */
long networkZnetwork_internalZcontent_size_METH_47(descriptor_t *orig_sp, heapptr_t A0, heapptr_t A1)
{

    return 4;
}

/* generic-entry for content-size{singleton(<uint32-t<@4>>)} */
descriptor_t * networkZnetwork_internalZcontent_size_METH_GENERIC_47(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    long L_result0; /* result0 */
    descriptor_t L_temp;

    orig_sp = ((void *)(orig_sp - 1));
    /* content-size{singleton(<uint32-t<@4>>)} */
    L_result0 = networkZnetwork_internalZcontent_size_METH_47(orig_sp, &networkZnetwork_internalZCLS_uint32_tLESSX404GREATER_HEAP, A_next_method_info);
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* Define Class <anonymous-6> */

/* <anonymous-6> is <anonymous-6> */

extern struct heapobj networkZnetwork_internalZCLS_anonymous_6_HEAP;

/* maker for <anonymous-6> */
void * networkZnetwork_internalZCLS_anonymous_6_MAKER_FUN(descriptor_t *orig_sp, void * A_pointer /* pointer */, int A_pointer_suppliedQUERY /* pointer-supplied? */)
{
    descriptor_t *cluster_0_top;


    /* #line 2150 "./sockets-api.dylan" */
    if (A_pointer_suppliedQUERY) {
	return A_pointer;
    }
    else {
	/* missing-required-init-keyword-error */
	dylanZdylan_visceraZmissing_required_init_keyword_error_FUN(orig_sp, &SYM_pointer_HEAP, &networkZnetwork_internalZCLS_anonymous_6_HEAP);
	not_reached();
    }
}

extern descriptor_t networkZliteral_50;	/* proxy for <anonymous-6> */

/* general-entry for maker for <anonymous-6> */
descriptor_t * networkZnetwork_internalZCLS_anonymous_6_MAKER_GENERAL(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    void * L_pointer; /* pointer */
    int L_pointer_suppliedQUERY; /* pointer-supplied? */
    long L_index; /* index */
    descriptor_t L_temp; /* temp */
    descriptor_t L_value; /* value */
    descriptor_t L_temp_2;
    descriptor_t L_temp_3;
    void * L_result0; /* result0 */
    descriptor_t L_temp_4;

    /* #line {Class <unknown-source-location>} */

    /* #line 126 "./cmp.dylan" */

    /* #line 209 "./num.dylan" */
    if (((A_nargs & 1) == 0)) {
	/* #line {Class <unknown-source-location>} */
	L_args = ((void *)(orig_sp - A_nargs));
	L_pointer = 0;
	L_pointer_suppliedQUERY = FALSE;
	L_index = (A_nargs - 2);
	while (1) {
	    if ((L_index < 0)) {
		goto block0;
	    }
	    else {
		L_temp = (((descriptor_t *)L_args)[L_index]);

		/* #line 386 "./condition.dylan" */
		if ((&dylanZdylan_visceraZCLS_symbol_HEAP == SLOT(L_temp.heapptr, heapptr_t, 0))) {
		    /* #line {Class <unknown-source-location>} */
		    L_value = (((descriptor_t *)L_args)[(L_index + 1)]);
		    if ((L_temp.heapptr == &SYM_pointer_HEAP)) {

			/* #line 386 "./condition.dylan" */
			if ((&dylanZdylan_visceraZCLS_raw_pointer_HEAP == SLOT(L_value.heapptr, heapptr_t, 0))) {
			    /* #line {Class <unknown-source-location>} */
			    L_pointer = L_value.dataword.ptr;
			    L_pointer_suppliedQUERY = TRUE;
			}
			else {

			    /* #line 389 "./condition.dylan" */
			    L_temp_2.heapptr = &networkZstr_ROOT;
			    L_temp_2.dataword.l = 0;
			    /* type-error-with-location */
			    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_value, &dylanZdylan_visceraZCLS_raw_pointer_HEAP, L_temp_2);
			    not_reached();
			}
		    }
		    /* #line {Class <unknown-source-location>} */
		    L_index = (L_index - 2);
		}
		else {

		    /* #line 389 "./condition.dylan" */
		    L_temp_3.heapptr = &networkZstr_ROOT;
		    L_temp_3.dataword.l = 0;
		    /* type-error-with-location */
		    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp, &dylanZdylan_visceraZCLS_symbol_HEAP, L_temp_3);
		    not_reached();
		}
	    }
	}
      block0:;
	/* #line {Class <unknown-source-location>} */
	orig_sp = L_args;
	/* maker for <anonymous-6> */
	L_result0 = networkZnetwork_internalZCLS_anonymous_6_MAKER_FUN(orig_sp, L_pointer, L_pointer_suppliedQUERY);
	L_temp_4.heapptr = networkZliteral_50.heapptr;
	L_temp_4.dataword.ptr = L_result0;
	orig_sp[0] = L_temp_4;
	return orig_sp + 1;
    }
    else {
	/* odd-number-of-keyword/value-arguments-error */
	dylanZdylan_visceraZodd_number_of_keywordSLASHvalue_arguments_error_FUN(orig_sp);
	not_reached();
    }
}


/* Define Sealed Domain make (singleton(<anonymous-6>)) */


/* {Implicit} Define Generic get-u6-addr8 */

/* get-u6-addr8 is get-u6-addr8 */


/* Define Method get-u6-addr8{<anonymous-6>} */

extern struct heapobj networkZstr_ROOT_60;

/* get-u6-addr8{<anonymous-6>} */
void * networkZnetwork_internalZget_u6_addr8_METH(descriptor_t *orig_sp, void * A_ptr /* ptr */, heapptr_t A1)
{
    descriptor_t *cluster_0_top;
    descriptor_t L_temp;
    descriptor_t L_temp_2;
    descriptor_t L_temp_3;
    descriptor_t L_temp_4; /* temp */
    int L_condition; /* condition */
    descriptor_t L_temp_5;
    descriptor_t L_temp_6; /* temp */
    descriptor_t L_temp_7;
    descriptor_t L_temp_8;


    /* #line 49 "./object.dylan" */
    L_temp.heapptr = networkZliteral_50.heapptr;
    L_temp.dataword.ptr = A_ptr;

    /* #line 324 "./melange.dylan" */

    /* #line 324 "./melange.dylan" */

    /* #line 324 "./melange.dylan" */
    L_temp_2.heapptr = SLOT(L_temp.heapptr, heapptr_t, 0);
    L_temp_2.dataword.l = 0;
    L_temp_3.heapptr = networkZliteral_6.heapptr;
    L_temp_3.dataword.ptr = ((void *)((char *)A_ptr + 0));
    orig_sp[0] = L_temp_2;
    orig_sp[1] = L_temp_3;
    /* as */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZas_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_temp_4 = orig_sp[0];

    /* #line 49 "./object.dylan" */

    /* #line 386 "./condition.dylan" */
    /* %subtype?{<class>, <class>} */
    L_condition = dylanZdylan_visceraZPCTsubtypeQUERY_METH(orig_sp, SLOT(L_temp_4.heapptr, heapptr_t, 0), &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP, &dylanZliteral_ROOT_2);
    if (L_condition) {

	/* #line 324 "./melange.dylan" */

	/* #line 2156 "./sockets-api.dylan" */
	L_temp_5.heapptr = &networkZnetwork_internalZCLS_uint8_tLESSX4016GREATER_HEAP;
	L_temp_5.dataword.l = 0;
	orig_sp[0] = L_temp_5;
	orig_sp[1] = L_temp_4;
	/* as */
	{
	  struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZas_HEAP, 2);
	  heapptr_t L_meth = L_temp.R0;
	  heapptr_t L_next_info = L_temp.R1;
	  cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
	}
	L_temp_6 = orig_sp[0];

	/* #line 386 "./condition.dylan" */
	if ((&networkZnetwork_internalZCLS_uint8_tLESSX4016GREATER_HEAP == SLOT(L_temp_6.heapptr, heapptr_t, 0))) {

	    /* #line 2156 "./sockets-api.dylan" */
	    return L_temp_6.dataword.ptr;
	}
	else {

	    /* #line 389 "./condition.dylan" */
	    L_temp_7.heapptr = &networkZstr_ROOT_60;
	    L_temp_7.dataword.l = 0;
	    /* type-error-with-location */
	    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp_6, &networkZnetwork_internalZCLS_uint8_tLESSX4016GREATER_HEAP, L_temp_7);
	    not_reached();
	}
    }
    else {
	L_temp_8.heapptr = &networkZstr_ROOT_5;
	L_temp_8.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp_4, &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP, L_temp_8);
	not_reached();
    }
}


/* {Implicit} Define Generic get-u6-addr16 */

/* get-u6-addr16 is get-u6-addr16 */


/* Define Method get-u6-addr16{<anonymous-6>} */

extern struct heapobj networkZstr_ROOT_61;

/* get-u6-addr16{<anonymous-6>} */
void * networkZnetwork_internalZget_u6_addr16_METH(descriptor_t *orig_sp, void * A_ptr /* ptr */, heapptr_t A1)
{
    descriptor_t *cluster_0_top;
    descriptor_t L_temp;
    descriptor_t L_temp_2;
    descriptor_t L_temp_3;
    descriptor_t L_temp_4; /* temp */
    int L_condition; /* condition */
    descriptor_t L_temp_5;
    descriptor_t L_temp_6; /* temp */
    descriptor_t L_temp_7;
    descriptor_t L_temp_8;

    /* #line {Class <unknown-source-location>} */

    /* #line 49 "./object.dylan" */
    L_temp.heapptr = networkZliteral_50.heapptr;
    L_temp.dataword.ptr = A_ptr;

    /* #line 324 "./melange.dylan" */

    /* #line 324 "./melange.dylan" */

    /* #line 324 "./melange.dylan" */
    L_temp_2.heapptr = SLOT(L_temp.heapptr, heapptr_t, 0);
    L_temp_2.dataword.l = 0;
    L_temp_3.heapptr = networkZliteral_6.heapptr;
    L_temp_3.dataword.ptr = ((void *)((char *)A_ptr + 0));
    orig_sp[0] = L_temp_2;
    orig_sp[1] = L_temp_3;
    /* as */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZas_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_temp_4 = orig_sp[0];

    /* #line 49 "./object.dylan" */

    /* #line 386 "./condition.dylan" */
    /* %subtype?{<class>, <class>} */
    L_condition = dylanZdylan_visceraZPCTsubtypeQUERY_METH(orig_sp, SLOT(L_temp_4.heapptr, heapptr_t, 0), &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP, &dylanZliteral_ROOT_2);
    if (L_condition) {

	/* #line 324 "./melange.dylan" */

	/* #line 2161 "./sockets-api.dylan" */
	L_temp_5.heapptr = &networkZnetwork_internalZCLS_uint16_tLESSX408GREATER_HEAP;
	L_temp_5.dataword.l = 0;
	orig_sp[0] = L_temp_5;
	orig_sp[1] = L_temp_4;
	/* as */
	{
	  struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZas_HEAP, 2);
	  heapptr_t L_meth = L_temp.R0;
	  heapptr_t L_next_info = L_temp.R1;
	  cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
	}
	L_temp_6 = orig_sp[0];

	/* #line 386 "./condition.dylan" */
	if ((&networkZnetwork_internalZCLS_uint16_tLESSX408GREATER_HEAP == SLOT(L_temp_6.heapptr, heapptr_t, 0))) {

	    /* #line 2161 "./sockets-api.dylan" */
	    return L_temp_6.dataword.ptr;
	}
	else {

	    /* #line 389 "./condition.dylan" */
	    L_temp_7.heapptr = &networkZstr_ROOT_61;
	    L_temp_7.dataword.l = 0;
	    /* type-error-with-location */
	    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp_6, &networkZnetwork_internalZCLS_uint16_tLESSX408GREATER_HEAP, L_temp_7);
	    not_reached();
	}
    }
    else {
	L_temp_8.heapptr = &networkZstr_ROOT_5;
	L_temp_8.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp_4, &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP, L_temp_8);
	not_reached();
    }
}


/* {Implicit} Define Generic get-u6-addr32 */

/* get-u6-addr32 is get-u6-addr32 */


/* Define Method get-u6-addr32{<anonymous-6>} */

extern struct heapobj networkZstr_ROOT_62;

/* get-u6-addr32{<anonymous-6>} */
void * networkZnetwork_internalZget_u6_addr32_METH(descriptor_t *orig_sp, void * A_ptr /* ptr */, heapptr_t A1)
{
    descriptor_t *cluster_0_top;
    descriptor_t L_temp;
    descriptor_t L_temp_2;
    descriptor_t L_temp_3;
    descriptor_t L_temp_4; /* temp */
    int L_condition; /* condition */
    descriptor_t L_temp_5;
    descriptor_t L_temp_6; /* temp */
    descriptor_t L_temp_7;
    descriptor_t L_temp_8;

    /* #line {Class <unknown-source-location>} */

    /* #line 49 "./object.dylan" */
    L_temp.heapptr = networkZliteral_50.heapptr;
    L_temp.dataword.ptr = A_ptr;

    /* #line 324 "./melange.dylan" */

    /* #line 324 "./melange.dylan" */

    /* #line 324 "./melange.dylan" */
    L_temp_2.heapptr = SLOT(L_temp.heapptr, heapptr_t, 0);
    L_temp_2.dataword.l = 0;
    L_temp_3.heapptr = networkZliteral_6.heapptr;
    L_temp_3.dataword.ptr = ((void *)((char *)A_ptr + 0));
    orig_sp[0] = L_temp_2;
    orig_sp[1] = L_temp_3;
    /* as */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZas_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_temp_4 = orig_sp[0];

    /* #line 49 "./object.dylan" */

    /* #line 386 "./condition.dylan" */
    /* %subtype?{<class>, <class>} */
    L_condition = dylanZdylan_visceraZPCTsubtypeQUERY_METH(orig_sp, SLOT(L_temp_4.heapptr, heapptr_t, 0), &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP, &dylanZliteral_ROOT_2);
    if (L_condition) {

	/* #line 324 "./melange.dylan" */

	/* #line 2166 "./sockets-api.dylan" */
	L_temp_5.heapptr = &networkZnetwork_internalZCLS_uint32_tLESSX404GREATER_HEAP;
	L_temp_5.dataword.l = 0;
	orig_sp[0] = L_temp_5;
	orig_sp[1] = L_temp_4;
	/* as */
	{
	  struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZas_HEAP, 2);
	  heapptr_t L_meth = L_temp.R0;
	  heapptr_t L_next_info = L_temp.R1;
	  cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
	}
	L_temp_6 = orig_sp[0];

	/* #line 386 "./condition.dylan" */
	if ((&networkZnetwork_internalZCLS_uint32_tLESSX404GREATER_HEAP == SLOT(L_temp_6.heapptr, heapptr_t, 0))) {

	    /* #line 2166 "./sockets-api.dylan" */
	    return L_temp_6.dataword.ptr;
	}
	else {

	    /* #line 389 "./condition.dylan" */
	    L_temp_7.heapptr = &networkZstr_ROOT_62;
	    L_temp_7.dataword.l = 0;
	    /* type-error-with-location */
	    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp_6, &networkZnetwork_internalZCLS_uint32_tLESSX404GREATER_HEAP, L_temp_7);
	    not_reached();
	}
    }
    else {
	L_temp_8.heapptr = &networkZstr_ROOT_5;
	L_temp_8.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp_4, &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP, L_temp_8);
	not_reached();
    }
}


/* Define Method pointer-value{<anonymous-6>} */

extern struct heapobj networkZstr_ROOT_63;

/* pointer-value{<anonymous-6>} */
void * networkZnetwork_internalZpointer_value_METH_37(descriptor_t *orig_sp, void * A_value /* value */, heapptr_t A_next_method_info /* next-method-info */, heapptr_t A_rest /* rest */, descriptor_t A_index /* index */)
{
    descriptor_t *cluster_0_top;
    descriptor_t L_temp;
    descriptor_t L_arg1; /* arg1 */
    descriptor_t L_temp_2;
    descriptor_t L_temp_3; /* temp */
    descriptor_t L_temp_4;

    /* #line {Class <unknown-source-location>} */

    /* #line 2170 "./sockets-api.dylan" */
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = 16;
    orig_sp[0] = A_index;
    orig_sp[1] = L_temp;
    /* * */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZV_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_arg1 = (orig_sp == cluster_0_top ? dylanZfalse : orig_sp[0]);

    /* #line 2170 "./sockets-api.dylan" */
    L_temp_2.heapptr = networkZliteral_50.heapptr;
    L_temp_2.dataword.ptr = A_value;
    orig_sp[0] = L_temp_2;
    orig_sp[1] = L_arg1;
    /* + */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZPLUS_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_temp_3 = (orig_sp == cluster_0_top ? dylanZfalse : orig_sp[0]);

    /* #line 386 "./condition.dylan" */
    if ((&networkZnetwork_internalZCLS_anonymous_6_HEAP == SLOT(L_temp_3.heapptr, heapptr_t, 0))) {

	/* #line 2170 "./sockets-api.dylan" */
	return L_temp_3.dataword.ptr;
    }
    else {

	/* #line 389 "./condition.dylan" */
	L_temp_4.heapptr = &networkZstr_ROOT_63;
	L_temp_4.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp_3, &networkZnetwork_internalZCLS_anonymous_6_HEAP, L_temp_4);
	not_reached();
    }
}

/* generic-entry for pointer-value{<anonymous-6>} */
descriptor_t * networkZnetwork_internalZpointer_value_METH_GENERIC_37(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    descriptor_t L_arg; /* arg */
    heapptr_t L_rest; /* rest */
    void * L_arg_2; /* arg */
    descriptor_t L_index; /* index */
    long L_index_2; /* index */
    descriptor_t L_key; /* key */
    descriptor_t L_value; /* value */
    void * L_result0; /* result0 */
    descriptor_t L_temp;

    /* #line {Class <unknown-source-location>} */
    L_args = ((void *)(orig_sp - A_nargs));
    L_arg = (((descriptor_t *)L_args)[0]);
    L_rest = dylanZdylan_visceraZmake_rest_arg_FUN(orig_sp, (descriptor_t *)L_args + 1, A_nargs - 1);
    L_arg_2 = L_arg.dataword.ptr;
    L_index.heapptr = networkZliteral_2.heapptr;
    L_index.dataword.l = 0;
    L_index_2 = (A_nargs - 2);
    while (1) {
	if ((L_index_2 < 1)) {
	    goto block0;
	}
	else {
	    L_key = (((descriptor_t *)L_args)[L_index_2]);
	    L_value = (((descriptor_t *)L_args)[(L_index_2 + 1)]);
	    if ((L_key.heapptr == &SYM_index_HEAP)) {
		L_index = L_value;
	    }
	    L_index_2 = (L_index_2 - 2);
	}
    }
  block0:;
    orig_sp = L_args;
    /* pointer-value{<anonymous-6>} */
    L_result0 = networkZnetwork_internalZpointer_value_METH_37(orig_sp, L_arg_2, A_next_method_info, L_rest, L_index);
    L_temp.heapptr = networkZliteral_50.heapptr;
    L_temp.dataword.ptr = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* Define Method content-size{subclass(<anonymous-6>)} */

/* content-size{subclass(<anonymous-6>)} */
long networkZnetwork_internalZcontent_size_METH_48(descriptor_t *orig_sp, heapptr_t A0, heapptr_t A1)
{

    return 16;
}

/* generic-entry for content-size{subclass(<anonymous-6>)} */
descriptor_t * networkZnetwork_internalZcontent_size_METH_GENERIC_48(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    long L_result0; /* result0 */
    descriptor_t L_temp;

    orig_sp = ((void *)(orig_sp - 1));
    /* content-size{subclass(<anonymous-6>)} */
    L_result0 = networkZnetwork_internalZcontent_size_METH_48(orig_sp, &networkZnetwork_internalZCLS_anonymous_6_HEAP, A_next_method_info);
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* Define Class <in6-addr> */

/* <in6-addr> is <in6-addr> */

extern struct heapobj networkZnetwork_internalZCLS_in6_addr_HEAP;

/* maker for <in6-addr> */
void * networkZnetwork_internalZCLS_in6_addr_MAKER_FUN(descriptor_t *orig_sp, void * A_pointer /* pointer */, int A_pointer_suppliedQUERY /* pointer-supplied? */)
{
    descriptor_t *cluster_0_top;


    /* #line 2177 "./sockets-api.dylan" */
    if (A_pointer_suppliedQUERY) {
	return A_pointer;
    }
    else {
	/* missing-required-init-keyword-error */
	dylanZdylan_visceraZmissing_required_init_keyword_error_FUN(orig_sp, &SYM_pointer_HEAP, &networkZnetwork_internalZCLS_in6_addr_HEAP);
	not_reached();
    }
}

extern descriptor_t networkZliteral_51;	/* proxy for <in6-addr> */

/* general-entry for maker for <in6-addr> */
descriptor_t * networkZnetwork_internalZCLS_in6_addr_MAKER_GENERAL(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    void * L_pointer; /* pointer */
    int L_pointer_suppliedQUERY; /* pointer-supplied? */
    long L_index; /* index */
    descriptor_t L_temp; /* temp */
    descriptor_t L_value; /* value */
    descriptor_t L_temp_2;
    descriptor_t L_temp_3;
    void * L_result0; /* result0 */
    descriptor_t L_temp_4;

    /* #line {Class <unknown-source-location>} */

    /* #line 126 "./cmp.dylan" */

    /* #line 209 "./num.dylan" */
    if (((A_nargs & 1) == 0)) {
	/* #line {Class <unknown-source-location>} */
	L_args = ((void *)(orig_sp - A_nargs));
	L_pointer = 0;
	L_pointer_suppliedQUERY = FALSE;
	L_index = (A_nargs - 2);
	while (1) {
	    if ((L_index < 0)) {
		goto block0;
	    }
	    else {
		L_temp = (((descriptor_t *)L_args)[L_index]);

		/* #line 386 "./condition.dylan" */
		if ((&dylanZdylan_visceraZCLS_symbol_HEAP == SLOT(L_temp.heapptr, heapptr_t, 0))) {
		    /* #line {Class <unknown-source-location>} */
		    L_value = (((descriptor_t *)L_args)[(L_index + 1)]);
		    if ((L_temp.heapptr == &SYM_pointer_HEAP)) {

			/* #line 386 "./condition.dylan" */
			if ((&dylanZdylan_visceraZCLS_raw_pointer_HEAP == SLOT(L_value.heapptr, heapptr_t, 0))) {
			    /* #line {Class <unknown-source-location>} */
			    L_pointer = L_value.dataword.ptr;
			    L_pointer_suppliedQUERY = TRUE;
			}
			else {

			    /* #line 389 "./condition.dylan" */
			    L_temp_2.heapptr = &networkZstr_ROOT;
			    L_temp_2.dataword.l = 0;
			    /* type-error-with-location */
			    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_value, &dylanZdylan_visceraZCLS_raw_pointer_HEAP, L_temp_2);
			    not_reached();
			}
		    }
		    /* #line {Class <unknown-source-location>} */
		    L_index = (L_index - 2);
		}
		else {

		    /* #line 389 "./condition.dylan" */
		    L_temp_3.heapptr = &networkZstr_ROOT;
		    L_temp_3.dataword.l = 0;
		    /* type-error-with-location */
		    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp, &dylanZdylan_visceraZCLS_symbol_HEAP, L_temp_3);
		    not_reached();
		}
	    }
	}
      block0:;
	/* #line {Class <unknown-source-location>} */
	orig_sp = L_args;
	/* maker for <in6-addr> */
	L_result0 = networkZnetwork_internalZCLS_in6_addr_MAKER_FUN(orig_sp, L_pointer, L_pointer_suppliedQUERY);
	L_temp_4.heapptr = networkZliteral_51.heapptr;
	L_temp_4.dataword.ptr = L_result0;
	orig_sp[0] = L_temp_4;
	return orig_sp + 1;
    }
    else {
	/* odd-number-of-keyword/value-arguments-error */
	dylanZdylan_visceraZodd_number_of_keywordSLASHvalue_arguments_error_FUN(orig_sp);
	not_reached();
    }
}


/* Define Sealed Domain make (singleton(<in6-addr>)) */


/* {Implicit} Define Generic get-in6-u */

/* get-in6-u is get-in6-u */


/* Define Method get-in6-u{<in6-addr>} */

extern struct heapobj networkZstr_ROOT_64;

/* get-in6-u{<in6-addr>} */
void * networkZnetwork_internalZget_in6_u_METH(descriptor_t *orig_sp, void * A_ptr /* ptr */, heapptr_t A1)
{
    descriptor_t *cluster_0_top;
    descriptor_t L_temp;
    descriptor_t L_temp_2;
    descriptor_t L_temp_3;
    descriptor_t L_temp_4; /* temp */
    int L_condition; /* condition */
    descriptor_t L_temp_5;
    descriptor_t L_temp_6; /* temp */
    descriptor_t L_temp_7;
    descriptor_t L_temp_8;


    /* #line 49 "./object.dylan" */
    L_temp.heapptr = networkZliteral_51.heapptr;
    L_temp.dataword.ptr = A_ptr;

    /* #line 324 "./melange.dylan" */

    /* #line 324 "./melange.dylan" */

    /* #line 324 "./melange.dylan" */
    L_temp_2.heapptr = SLOT(L_temp.heapptr, heapptr_t, 0);
    L_temp_2.dataword.l = 0;
    L_temp_3.heapptr = networkZliteral_6.heapptr;
    L_temp_3.dataword.ptr = ((void *)((char *)A_ptr + 0));
    orig_sp[0] = L_temp_2;
    orig_sp[1] = L_temp_3;
    /* as */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZas_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_temp_4 = orig_sp[0];

    /* #line 49 "./object.dylan" */

    /* #line 386 "./condition.dylan" */
    /* %subtype?{<class>, <class>} */
    L_condition = dylanZdylan_visceraZPCTsubtypeQUERY_METH(orig_sp, SLOT(L_temp_4.heapptr, heapptr_t, 0), &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP, &dylanZliteral_ROOT_2);
    if (L_condition) {

	/* #line 324 "./melange.dylan" */

	/* #line 2183 "./sockets-api.dylan" */
	L_temp_5.heapptr = &networkZnetwork_internalZCLS_anonymous_6_HEAP;
	L_temp_5.dataword.l = 0;
	orig_sp[0] = L_temp_5;
	orig_sp[1] = L_temp_4;
	/* as */
	{
	  struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZas_HEAP, 2);
	  heapptr_t L_meth = L_temp.R0;
	  heapptr_t L_next_info = L_temp.R1;
	  cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
	}
	L_temp_6 = orig_sp[0];

	/* #line 386 "./condition.dylan" */
	if ((&networkZnetwork_internalZCLS_anonymous_6_HEAP == SLOT(L_temp_6.heapptr, heapptr_t, 0))) {

	    /* #line 2183 "./sockets-api.dylan" */
	    return L_temp_6.dataword.ptr;
	}
	else {

	    /* #line 389 "./condition.dylan" */
	    L_temp_7.heapptr = &networkZstr_ROOT_64;
	    L_temp_7.dataword.l = 0;
	    /* type-error-with-location */
	    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp_6, &networkZnetwork_internalZCLS_anonymous_6_HEAP, L_temp_7);
	    not_reached();
	}
    }
    else {
	L_temp_8.heapptr = &networkZstr_ROOT_5;
	L_temp_8.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp_4, &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP, L_temp_8);
	not_reached();
    }
}


/* Define Method pointer-value{<in6-addr>} */

extern struct heapobj networkZstr_ROOT_65;

/* pointer-value{<in6-addr>} */
void * networkZnetwork_internalZpointer_value_METH_38(descriptor_t *orig_sp, void * A_value /* value */, heapptr_t A_next_method_info /* next-method-info */, heapptr_t A_rest /* rest */, descriptor_t A_index /* index */)
{
    descriptor_t *cluster_0_top;
    descriptor_t L_temp;
    descriptor_t L_arg1; /* arg1 */
    descriptor_t L_temp_2;
    descriptor_t L_temp_3; /* temp */
    descriptor_t L_temp_4;

    /* #line {Class <unknown-source-location>} */

    /* #line 2187 "./sockets-api.dylan" */
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = 16;
    orig_sp[0] = A_index;
    orig_sp[1] = L_temp;
    /* * */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZV_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_arg1 = (orig_sp == cluster_0_top ? dylanZfalse : orig_sp[0]);

    /* #line 2187 "./sockets-api.dylan" */
    L_temp_2.heapptr = networkZliteral_51.heapptr;
    L_temp_2.dataword.ptr = A_value;
    orig_sp[0] = L_temp_2;
    orig_sp[1] = L_arg1;
    /* + */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZPLUS_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_temp_3 = (orig_sp == cluster_0_top ? dylanZfalse : orig_sp[0]);

    /* #line 386 "./condition.dylan" */
    if ((&networkZnetwork_internalZCLS_in6_addr_HEAP == SLOT(L_temp_3.heapptr, heapptr_t, 0))) {

	/* #line 2187 "./sockets-api.dylan" */
	return L_temp_3.dataword.ptr;
    }
    else {

	/* #line 389 "./condition.dylan" */
	L_temp_4.heapptr = &networkZstr_ROOT_65;
	L_temp_4.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp_3, &networkZnetwork_internalZCLS_in6_addr_HEAP, L_temp_4);
	not_reached();
    }
}

/* generic-entry for pointer-value{<in6-addr>} */
descriptor_t * networkZnetwork_internalZpointer_value_METH_GENERIC_38(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    descriptor_t L_arg; /* arg */
    heapptr_t L_rest; /* rest */
    void * L_arg_2; /* arg */
    descriptor_t L_index; /* index */
    long L_index_2; /* index */
    descriptor_t L_key; /* key */
    descriptor_t L_value; /* value */
    void * L_result0; /* result0 */
    descriptor_t L_temp;

    /* #line {Class <unknown-source-location>} */
    L_args = ((void *)(orig_sp - A_nargs));
    L_arg = (((descriptor_t *)L_args)[0]);
    L_rest = dylanZdylan_visceraZmake_rest_arg_FUN(orig_sp, (descriptor_t *)L_args + 1, A_nargs - 1);
    L_arg_2 = L_arg.dataword.ptr;
    L_index.heapptr = networkZliteral_2.heapptr;
    L_index.dataword.l = 0;
    L_index_2 = (A_nargs - 2);
    while (1) {
	if ((L_index_2 < 1)) {
	    goto block0;
	}
	else {
	    L_key = (((descriptor_t *)L_args)[L_index_2]);
	    L_value = (((descriptor_t *)L_args)[(L_index_2 + 1)]);
	    if ((L_key.heapptr == &SYM_index_HEAP)) {
		L_index = L_value;
	    }
	    L_index_2 = (L_index_2 - 2);
	}
    }
  block0:;
    orig_sp = L_args;
    /* pointer-value{<in6-addr>} */
    L_result0 = networkZnetwork_internalZpointer_value_METH_38(orig_sp, L_arg_2, A_next_method_info, L_rest, L_index);
    L_temp.heapptr = networkZliteral_51.heapptr;
    L_temp.dataword.ptr = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* Define Method content-size{subclass(<in6-addr>)} */

/* content-size{subclass(<in6-addr>)} */
long networkZnetwork_internalZcontent_size_METH_49(descriptor_t *orig_sp, heapptr_t A0, heapptr_t A1)
{

    return 16;
}

/* generic-entry for content-size{subclass(<in6-addr>)} */
descriptor_t * networkZnetwork_internalZcontent_size_METH_GENERIC_49(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    long L_result0; /* result0 */
    descriptor_t L_temp;

    orig_sp = ((void *)(orig_sp - 1));
    /* content-size{subclass(<in6-addr>)} */
    L_result0 = networkZnetwork_internalZcontent_size_METH_49(orig_sp, &networkZnetwork_internalZCLS_in6_addr_HEAP, A_next_method_info);
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* {Implicit} Define Generic in6addr-any */

/* in6addr-any is in6addr-any */


/* Define Method in6addr-any{} */

extern struct heapobj networkZstr_ROOT_66;

/* in6addr-any{} */
void * networkZnetwork_internalZin6addr_any_METH(descriptor_t *orig_sp, heapptr_t A0)
{
    descriptor_t *cluster_0_top;
    void * L_arg1; /* arg1 */
    descriptor_t L_temp;
    descriptor_t L_temp_2;
    descriptor_t L_temp_3; /* temp */
    descriptor_t L_temp_4;


    /* #line 762 "./macros.dylan" */
    L_arg1 = &in6addr_any;

    /* #line 91 "./rawptr.dylan" */

    /* #line 2195 "./sockets-api.dylan" */
    L_temp.heapptr = &networkZnetwork_internalZCLS_in6_addr_HEAP;
    L_temp.dataword.l = 0;
    L_temp_2.heapptr = networkZliteral_6.heapptr;
    L_temp_2.dataword.ptr = (*(void * *)((char *)L_arg1 + 0 ));
    orig_sp[0] = L_temp;
    orig_sp[1] = L_temp_2;
    /* as */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZas_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_temp_3 = orig_sp[0];

    /* #line 386 "./condition.dylan" */
    if ((&networkZnetwork_internalZCLS_in6_addr_HEAP == SLOT(L_temp_3.heapptr, heapptr_t, 0))) {

	/* #line 2195 "./sockets-api.dylan" */
	return L_temp_3.dataword.ptr;
    }
    else {

	/* #line 389 "./condition.dylan" */
	L_temp_4.heapptr = &networkZstr_ROOT_66;
	L_temp_4.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp_3, &networkZnetwork_internalZCLS_in6_addr_HEAP, L_temp_4);
	not_reached();
    }
}


/* {Implicit} Define Generic in6addr-loopback */

/* in6addr-loopback is in6addr-loopback */


/* Define Method in6addr-loopback{} */

extern struct heapobj networkZstr_ROOT_67;

/* in6addr-loopback{} */
void * networkZnetwork_internalZin6addr_loopback_METH(descriptor_t *orig_sp, heapptr_t A0)
{
    descriptor_t *cluster_0_top;
    void * L_arg1; /* arg1 */
    descriptor_t L_temp;
    descriptor_t L_temp_2;
    descriptor_t L_temp_3; /* temp */
    descriptor_t L_temp_4;

    /* #line {Class <unknown-source-location>} */

    /* #line 762 "./macros.dylan" */
    L_arg1 = &in6addr_loopback;

    /* #line 91 "./rawptr.dylan" */

    /* #line 2199 "./sockets-api.dylan" */
    L_temp.heapptr = &networkZnetwork_internalZCLS_in6_addr_HEAP;
    L_temp.dataword.l = 0;
    L_temp_2.heapptr = networkZliteral_6.heapptr;
    L_temp_2.dataword.ptr = (*(void * *)((char *)L_arg1 + 0 ));
    orig_sp[0] = L_temp;
    orig_sp[1] = L_temp_2;
    /* as */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZas_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_temp_3 = orig_sp[0];

    /* #line 386 "./condition.dylan" */
    if ((&networkZnetwork_internalZCLS_in6_addr_HEAP == SLOT(L_temp_3.heapptr, heapptr_t, 0))) {

	/* #line 2199 "./sockets-api.dylan" */
	return L_temp_3.dataword.ptr;
    }
    else {

	/* #line 389 "./condition.dylan" */
	L_temp_4.heapptr = &networkZstr_ROOT_67;
	L_temp_4.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp_3, &networkZnetwork_internalZCLS_in6_addr_HEAP, L_temp_4);
	not_reached();
    }
}


/* Define Class <unsigned-char<@8>> */

/* <unsigned-char<@8>> is <unsigned-char<@8>> */

extern struct heapobj networkZnetwork_internalZCLS_unsigned_charLESSX408GREATER_HEAP;

/* maker for <unsigned-char<@8>> */
void * networkZnetwork_internalZCLS_unsigned_charLESSX408GREATER_MAKER_FUN(descriptor_t *orig_sp, void * A_pointer /* pointer */, int A_pointer_suppliedQUERY /* pointer-supplied? */)
{
    descriptor_t *cluster_0_top;


    /* #line 2202 "./sockets-api.dylan" */
    if (A_pointer_suppliedQUERY) {
	return A_pointer;
    }
    else {
	/* missing-required-init-keyword-error */
	dylanZdylan_visceraZmissing_required_init_keyword_error_FUN(orig_sp, &SYM_pointer_HEAP, &networkZnetwork_internalZCLS_unsigned_charLESSX408GREATER_HEAP);
	not_reached();
    }
}

extern descriptor_t networkZliteral_52;	/* proxy for <unsigned-char<@8>> */

/* general-entry for maker for <unsigned-char<@8>> */
descriptor_t * networkZnetwork_internalZCLS_unsigned_charLESSX408GREATER_MAKER_GENERAL(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    void * L_pointer; /* pointer */
    int L_pointer_suppliedQUERY; /* pointer-supplied? */
    long L_index; /* index */
    descriptor_t L_temp; /* temp */
    descriptor_t L_value; /* value */
    descriptor_t L_temp_2;
    descriptor_t L_temp_3;
    void * L_result0; /* result0 */
    descriptor_t L_temp_4;

    /* #line {Class <unknown-source-location>} */

    /* #line 126 "./cmp.dylan" */

    /* #line 209 "./num.dylan" */
    if (((A_nargs & 1) == 0)) {
	/* #line {Class <unknown-source-location>} */
	L_args = ((void *)(orig_sp - A_nargs));
	L_pointer = 0;
	L_pointer_suppliedQUERY = FALSE;
	L_index = (A_nargs - 2);
	while (1) {
	    if ((L_index < 0)) {
		goto block0;
	    }
	    else {
		L_temp = (((descriptor_t *)L_args)[L_index]);

		/* #line 386 "./condition.dylan" */
		if ((&dylanZdylan_visceraZCLS_symbol_HEAP == SLOT(L_temp.heapptr, heapptr_t, 0))) {
		    /* #line {Class <unknown-source-location>} */
		    L_value = (((descriptor_t *)L_args)[(L_index + 1)]);
		    if ((L_temp.heapptr == &SYM_pointer_HEAP)) {

			/* #line 386 "./condition.dylan" */
			if ((&dylanZdylan_visceraZCLS_raw_pointer_HEAP == SLOT(L_value.heapptr, heapptr_t, 0))) {
			    /* #line {Class <unknown-source-location>} */
			    L_pointer = L_value.dataword.ptr;
			    L_pointer_suppliedQUERY = TRUE;
			}
			else {

			    /* #line 389 "./condition.dylan" */
			    L_temp_2.heapptr = &networkZstr_ROOT;
			    L_temp_2.dataword.l = 0;
			    /* type-error-with-location */
			    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_value, &dylanZdylan_visceraZCLS_raw_pointer_HEAP, L_temp_2);
			    not_reached();
			}
		    }
		    /* #line {Class <unknown-source-location>} */
		    L_index = (L_index - 2);
		}
		else {

		    /* #line 389 "./condition.dylan" */
		    L_temp_3.heapptr = &networkZstr_ROOT;
		    L_temp_3.dataword.l = 0;
		    /* type-error-with-location */
		    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp, &dylanZdylan_visceraZCLS_symbol_HEAP, L_temp_3);
		    not_reached();
		}
	    }
	}
      block0:;
	/* #line {Class <unknown-source-location>} */
	orig_sp = L_args;
	/* maker for <unsigned-char<@8>> */
	L_result0 = networkZnetwork_internalZCLS_unsigned_charLESSX408GREATER_MAKER_FUN(orig_sp, L_pointer, L_pointer_suppliedQUERY);
	L_temp_4.heapptr = networkZliteral_52.heapptr;
	L_temp_4.dataword.ptr = L_result0;
	orig_sp[0] = L_temp_4;
	return orig_sp + 1;
    }
    else {
	/* odd-number-of-keyword/value-arguments-error */
	dylanZdylan_visceraZodd_number_of_keywordSLASHvalue_arguments_error_FUN(orig_sp);
	not_reached();
    }
}


/* Define Sealed Domain make (singleton(<unsigned-char<@8>>)) */


/* Define Method content-size{singleton(<unsigned-char<@8>>)} */

/* content-size{singleton(<unsigned-char<@8>>)} */
long networkZnetwork_internalZcontent_size_METH_50(descriptor_t *orig_sp, heapptr_t A0, heapptr_t A1)
{

    return 8;
}

/* generic-entry for content-size{singleton(<unsigned-char<@8>>)} */
descriptor_t * networkZnetwork_internalZcontent_size_METH_GENERIC_50(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    long L_result0; /* result0 */
    descriptor_t L_temp;

    orig_sp = ((void *)(orig_sp - 1));
    /* content-size{singleton(<unsigned-char<@8>>)} */
    L_result0 = networkZnetwork_internalZcontent_size_METH_50(orig_sp, &networkZnetwork_internalZCLS_unsigned_charLESSX408GREATER_HEAP, A_next_method_info);
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* Define Class <sockaddr-in> */

/* <sockaddr-in> is <sockaddr-in> */

/* maker for <sockaddr-in> */
void * networkZnetwork_internalZCLS_sockaddr_in_MAKER_FUN(descriptor_t *orig_sp, void * A_pointer /* pointer */, int A_pointer_suppliedQUERY /* pointer-supplied? */)
{
    descriptor_t *cluster_0_top;


    /* #line 2210 "./sockets-api.dylan" */
    if (A_pointer_suppliedQUERY) {
	return A_pointer;
    }
    else {
	/* missing-required-init-keyword-error */
	dylanZdylan_visceraZmissing_required_init_keyword_error_FUN(orig_sp, &SYM_pointer_HEAP, &networkZnetwork_internalZCLS_sockaddr_in_HEAP);
	not_reached();
    }
}

extern descriptor_t networkZliteral_53;	/* proxy for <sockaddr-in> */

/* general-entry for maker for <sockaddr-in> */
descriptor_t * networkZnetwork_internalZCLS_sockaddr_in_MAKER_GENERAL(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    void * L_pointer; /* pointer */
    int L_pointer_suppliedQUERY; /* pointer-supplied? */
    long L_index; /* index */
    descriptor_t L_temp; /* temp */
    descriptor_t L_value; /* value */
    descriptor_t L_temp_2;
    descriptor_t L_temp_3;
    void * L_result0; /* result0 */
    descriptor_t L_temp_4;

    /* #line {Class <unknown-source-location>} */

    /* #line 126 "./cmp.dylan" */

    /* #line 209 "./num.dylan" */
    if (((A_nargs & 1) == 0)) {
	/* #line {Class <unknown-source-location>} */
	L_args = ((void *)(orig_sp - A_nargs));
	L_pointer = 0;
	L_pointer_suppliedQUERY = FALSE;
	L_index = (A_nargs - 2);
	while (1) {
	    if ((L_index < 0)) {
		goto block0;
	    }
	    else {
		L_temp = (((descriptor_t *)L_args)[L_index]);

		/* #line 386 "./condition.dylan" */
		if ((&dylanZdylan_visceraZCLS_symbol_HEAP == SLOT(L_temp.heapptr, heapptr_t, 0))) {
		    /* #line {Class <unknown-source-location>} */
		    L_value = (((descriptor_t *)L_args)[(L_index + 1)]);
		    if ((L_temp.heapptr == &SYM_pointer_HEAP)) {

			/* #line 386 "./condition.dylan" */
			if ((&dylanZdylan_visceraZCLS_raw_pointer_HEAP == SLOT(L_value.heapptr, heapptr_t, 0))) {
			    /* #line {Class <unknown-source-location>} */
			    L_pointer = L_value.dataword.ptr;
			    L_pointer_suppliedQUERY = TRUE;
			}
			else {

			    /* #line 389 "./condition.dylan" */
			    L_temp_2.heapptr = &networkZstr_ROOT;
			    L_temp_2.dataword.l = 0;
			    /* type-error-with-location */
			    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_value, &dylanZdylan_visceraZCLS_raw_pointer_HEAP, L_temp_2);
			    not_reached();
			}
		    }
		    /* #line {Class <unknown-source-location>} */
		    L_index = (L_index - 2);
		}
		else {

		    /* #line 389 "./condition.dylan" */
		    L_temp_3.heapptr = &networkZstr_ROOT;
		    L_temp_3.dataword.l = 0;
		    /* type-error-with-location */
		    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp, &dylanZdylan_visceraZCLS_symbol_HEAP, L_temp_3);
		    not_reached();
		}
	    }
	}
      block0:;
	/* #line {Class <unknown-source-location>} */
	orig_sp = L_args;
	/* maker for <sockaddr-in> */
	L_result0 = networkZnetwork_internalZCLS_sockaddr_in_MAKER_FUN(orig_sp, L_pointer, L_pointer_suppliedQUERY);
	L_temp_4.heapptr = networkZliteral_53.heapptr;
	L_temp_4.dataword.ptr = L_result0;
	orig_sp[0] = L_temp_4;
	return orig_sp + 1;
    }
    else {
	/* odd-number-of-keyword/value-arguments-error */
	dylanZdylan_visceraZodd_number_of_keywordSLASHvalue_arguments_error_FUN(orig_sp);
	not_reached();
    }
}


/* Define Sealed Domain make (singleton(<sockaddr-in>)) */


/* {Implicit} Define Generic get-sin-family */

/* get-sin-family is get-sin-family */


/* Define Method get-sin-family{<sockaddr-in>} */

/* get-sin-family{<sockaddr-in>} */
long networkZnetwork_internalZget_sin_family_METH(descriptor_t *orig_sp, void * A_ptr /* ptr */, heapptr_t A1)
{
    descriptor_t *cluster_0_top;


    /* #line 185 "./melange.dylan" */

    /* #line 91 "./rawptr.dylan" */
    return (*(unsigned short *)((char *)A_ptr + 0 ));
}

/* generic-entry for get-sin-family{<sockaddr-in>} */
descriptor_t * networkZnetwork_internalZget_sin_family_METH_GENERIC(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    descriptor_t L_arg; /* arg */
    void * L_arg_2; /* arg */
    long L_result0; /* result0 */
    descriptor_t L_temp;

    /* #line {Class <unknown-source-location>} */
    L_args = ((void *)(orig_sp - 1));
    L_arg = (((descriptor_t *)L_args)[0]);
    L_arg_2 = L_arg.dataword.ptr;
    orig_sp = L_args;
    /* get-sin-family{<sockaddr-in>} */
    L_result0 = networkZnetwork_internalZget_sin_family_METH(orig_sp, L_arg_2, A_next_method_info);
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* {Implicit} Define Generic get-sin-family-setter */

/* get-sin-family-setter is get-sin-family-setter */


/* Define Method get-sin-family-setter{<integer>, <sockaddr-in>} */

/* get-sin-family-setter{<integer>, <sockaddr-in>} */
long networkZnetwork_internalZget_sin_family_setter_METH(descriptor_t *orig_sp, long A_value /* value */, void * A_ptr /* ptr */, heapptr_t A2)
{
    descriptor_t *cluster_0_top;


    /* #line 97 "./rawptr.dylan" */
    *(unsigned short *)((char *)A_ptr + 0) = A_value;
    return A_value;
}

/* generic-entry for get-sin-family-setter{<integer>, <sockaddr-in>} */
descriptor_t * networkZnetwork_internalZget_sin_family_setter_METH_GENERIC(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    descriptor_t L_arg; /* arg */
    descriptor_t L_arg_2; /* arg */
    long L_arg_3; /* arg */
    void * L_arg_4; /* arg */
    long L_result0; /* result0 */
    descriptor_t L_temp;

    /* #line {Class <unknown-source-location>} */
    L_args = ((void *)(orig_sp - 2));
    L_arg = (((descriptor_t *)L_args)[0]);
    L_arg_2 = (((descriptor_t *)L_args)[1]);
    L_arg_3 = L_arg.dataword.l;
    L_arg_4 = L_arg_2.dataword.ptr;
    orig_sp = L_args;
    /* get-sin-family-setter{<integer>, <sockaddr-in>} */
    L_result0 = networkZnetwork_internalZget_sin_family_setter_METH(orig_sp, L_arg_3, L_arg_4, A_next_method_info);
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* {Implicit} Define Generic get-sin-port */

/* get-sin-port is get-sin-port */


/* Define Method get-sin-port{<sockaddr-in>} */

/* get-sin-port{<sockaddr-in>} */
long networkZnetwork_internalZget_sin_port_METH(descriptor_t *orig_sp, void * A_ptr /* ptr */, heapptr_t A1)
{
    descriptor_t *cluster_0_top;


    /* #line 185 "./melange.dylan" */

    /* #line 91 "./rawptr.dylan" */
    return (*(unsigned short *)((char *)A_ptr + 2 ));
}

/* generic-entry for get-sin-port{<sockaddr-in>} */
descriptor_t * networkZnetwork_internalZget_sin_port_METH_GENERIC(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    descriptor_t L_arg; /* arg */
    void * L_arg_2; /* arg */
    long L_result0; /* result0 */
    descriptor_t L_temp;

    /* #line {Class <unknown-source-location>} */
    L_args = ((void *)(orig_sp - 1));
    L_arg = (((descriptor_t *)L_args)[0]);
    L_arg_2 = L_arg.dataword.ptr;
    orig_sp = L_args;
    /* get-sin-port{<sockaddr-in>} */
    L_result0 = networkZnetwork_internalZget_sin_port_METH(orig_sp, L_arg_2, A_next_method_info);
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* {Implicit} Define Generic get-sin-port-setter */

/* get-sin-port-setter is get-sin-port-setter */


/* Define Method get-sin-port-setter{<integer>, <sockaddr-in>} */

/* get-sin-port-setter{<integer>, <sockaddr-in>} */
long networkZnetwork_internalZget_sin_port_setter_METH(descriptor_t *orig_sp, long A_value /* value */, void * A_ptr /* ptr */, heapptr_t A2)
{
    descriptor_t *cluster_0_top;


    /* #line 97 "./rawptr.dylan" */
    *(unsigned short *)((char *)A_ptr + 2) = A_value;
    return A_value;
}

/* generic-entry for get-sin-port-setter{<integer>, <sockaddr-in>} */
descriptor_t * networkZnetwork_internalZget_sin_port_setter_METH_GENERIC(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    descriptor_t L_arg; /* arg */
    descriptor_t L_arg_2; /* arg */
    long L_arg_3; /* arg */
    void * L_arg_4; /* arg */
    long L_result0; /* result0 */
    descriptor_t L_temp;

    /* #line {Class <unknown-source-location>} */
    L_args = ((void *)(orig_sp - 2));
    L_arg = (((descriptor_t *)L_args)[0]);
    L_arg_2 = (((descriptor_t *)L_args)[1]);
    L_arg_3 = L_arg.dataword.l;
    L_arg_4 = L_arg_2.dataword.ptr;
    orig_sp = L_args;
    /* get-sin-port-setter{<integer>, <sockaddr-in>} */
    L_result0 = networkZnetwork_internalZget_sin_port_setter_METH(orig_sp, L_arg_3, L_arg_4, A_next_method_info);
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* {Implicit} Define Generic get-sin-addr */

/* get-sin-addr is get-sin-addr */


/* Define Method get-sin-addr{<sockaddr-in>} */

extern struct heapobj networkZstr_ROOT_68;

/* get-sin-addr{<sockaddr-in>} */
void * networkZnetwork_internalZget_sin_addr_METH(descriptor_t *orig_sp, void * A_ptr /* ptr */, heapptr_t A1)
{
    descriptor_t *cluster_0_top;
    descriptor_t L_temp;
    descriptor_t L_temp_2;
    descriptor_t L_temp_3;
    descriptor_t L_temp_4; /* temp */
    int L_condition; /* condition */
    descriptor_t L_temp_5;
    descriptor_t L_temp_6; /* temp */
    descriptor_t L_temp_7;
    descriptor_t L_temp_8;


    /* #line 49 "./object.dylan" */
    L_temp.heapptr = networkZliteral_53.heapptr;
    L_temp.dataword.ptr = A_ptr;

    /* #line 324 "./melange.dylan" */

    /* #line 324 "./melange.dylan" */

    /* #line 324 "./melange.dylan" */
    L_temp_2.heapptr = SLOT(L_temp.heapptr, heapptr_t, 0);
    L_temp_2.dataword.l = 0;
    L_temp_3.heapptr = networkZliteral_6.heapptr;
    L_temp_3.dataword.ptr = ((void *)((char *)A_ptr + 4));
    orig_sp[0] = L_temp_2;
    orig_sp[1] = L_temp_3;
    /* as */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZas_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_temp_4 = orig_sp[0];

    /* #line 49 "./object.dylan" */

    /* #line 386 "./condition.dylan" */
    /* %subtype?{<class>, <class>} */
    L_condition = dylanZdylan_visceraZPCTsubtypeQUERY_METH(orig_sp, SLOT(L_temp_4.heapptr, heapptr_t, 0), &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP, &dylanZliteral_ROOT_2);
    if (L_condition) {

	/* #line 324 "./melange.dylan" */

	/* #line 2238 "./sockets-api.dylan" */
	L_temp_5.heapptr = &networkZnetwork_internalZCLS_in_addr_HEAP;
	L_temp_5.dataword.l = 0;
	orig_sp[0] = L_temp_5;
	orig_sp[1] = L_temp_4;
	/* as */
	{
	  struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZas_HEAP, 2);
	  heapptr_t L_meth = L_temp.R0;
	  heapptr_t L_next_info = L_temp.R1;
	  cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
	}
	L_temp_6 = orig_sp[0];

	/* #line 386 "./condition.dylan" */
	if ((&networkZnetwork_internalZCLS_in_addr_HEAP == SLOT(L_temp_6.heapptr, heapptr_t, 0))) {

	    /* #line 2238 "./sockets-api.dylan" */
	    return L_temp_6.dataword.ptr;
	}
	else {

	    /* #line 389 "./condition.dylan" */
	    L_temp_7.heapptr = &networkZstr_ROOT_68;
	    L_temp_7.dataword.l = 0;
	    /* type-error-with-location */
	    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp_6, &networkZnetwork_internalZCLS_in_addr_HEAP, L_temp_7);
	    not_reached();
	}
    }
    else {
	L_temp_8.heapptr = &networkZstr_ROOT_5;
	L_temp_8.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp_4, &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP, L_temp_8);
	not_reached();
    }
}


/* {Implicit} Define Generic get-sin-zero */

/* get-sin-zero is get-sin-zero */


/* Define Method get-sin-zero{<sockaddr-in>} */

extern struct heapobj networkZstr_ROOT_69;

/* get-sin-zero{<sockaddr-in>} */
void * networkZnetwork_internalZget_sin_zero_METH(descriptor_t *orig_sp, void * A_ptr /* ptr */, heapptr_t A1)
{
    descriptor_t *cluster_0_top;
    descriptor_t L_temp;
    descriptor_t L_temp_2;
    descriptor_t L_temp_3;
    descriptor_t L_temp_4; /* temp */
    int L_condition; /* condition */
    descriptor_t L_temp_5;
    descriptor_t L_temp_6; /* temp */
    descriptor_t L_temp_7;
    descriptor_t L_temp_8;

    /* #line {Class <unknown-source-location>} */

    /* #line 49 "./object.dylan" */
    L_temp.heapptr = networkZliteral_53.heapptr;
    L_temp.dataword.ptr = A_ptr;

    /* #line 324 "./melange.dylan" */

    /* #line 324 "./melange.dylan" */

    /* #line 324 "./melange.dylan" */
    L_temp_2.heapptr = SLOT(L_temp.heapptr, heapptr_t, 0);
    L_temp_2.dataword.l = 0;
    L_temp_3.heapptr = networkZliteral_6.heapptr;
    L_temp_3.dataword.ptr = ((void *)((char *)A_ptr + 8));
    orig_sp[0] = L_temp_2;
    orig_sp[1] = L_temp_3;
    /* as */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZas_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_temp_4 = orig_sp[0];

    /* #line 49 "./object.dylan" */

    /* #line 386 "./condition.dylan" */
    /* %subtype?{<class>, <class>} */
    L_condition = dylanZdylan_visceraZPCTsubtypeQUERY_METH(orig_sp, SLOT(L_temp_4.heapptr, heapptr_t, 0), &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP, &dylanZliteral_ROOT_2);
    if (L_condition) {

	/* #line 324 "./melange.dylan" */

	/* #line 2243 "./sockets-api.dylan" */
	L_temp_5.heapptr = &networkZnetwork_internalZCLS_unsigned_charLESSX408GREATER_HEAP;
	L_temp_5.dataword.l = 0;
	orig_sp[0] = L_temp_5;
	orig_sp[1] = L_temp_4;
	/* as */
	{
	  struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZas_HEAP, 2);
	  heapptr_t L_meth = L_temp.R0;
	  heapptr_t L_next_info = L_temp.R1;
	  cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
	}
	L_temp_6 = orig_sp[0];

	/* #line 386 "./condition.dylan" */
	if ((&networkZnetwork_internalZCLS_unsigned_charLESSX408GREATER_HEAP == SLOT(L_temp_6.heapptr, heapptr_t, 0))) {

	    /* #line 2243 "./sockets-api.dylan" */
	    return L_temp_6.dataword.ptr;
	}
	else {

	    /* #line 389 "./condition.dylan" */
	    L_temp_7.heapptr = &networkZstr_ROOT_69;
	    L_temp_7.dataword.l = 0;
	    /* type-error-with-location */
	    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp_6, &networkZnetwork_internalZCLS_unsigned_charLESSX408GREATER_HEAP, L_temp_7);
	    not_reached();
	}
    }
    else {
	L_temp_8.heapptr = &networkZstr_ROOT_5;
	L_temp_8.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp_4, &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP, L_temp_8);
	not_reached();
    }
}


/* Define Method pointer-value{<sockaddr-in>} */

extern struct heapobj networkZstr_ROOT_70;

/* pointer-value{<sockaddr-in>} */
void * networkZnetwork_internalZpointer_value_METH_39(descriptor_t *orig_sp, void * A_value /* value */, heapptr_t A_next_method_info /* next-method-info */, heapptr_t A_rest /* rest */, descriptor_t A_index /* index */)
{
    descriptor_t *cluster_0_top;
    descriptor_t L_temp;
    descriptor_t L_arg1; /* arg1 */
    descriptor_t L_temp_2;
    descriptor_t L_temp_3; /* temp */
    descriptor_t L_temp_4;

    /* #line {Class <unknown-source-location>} */

    /* #line 2247 "./sockets-api.dylan" */
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = 16;
    orig_sp[0] = A_index;
    orig_sp[1] = L_temp;
    /* * */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZV_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_arg1 = (orig_sp == cluster_0_top ? dylanZfalse : orig_sp[0]);

    /* #line 2247 "./sockets-api.dylan" */
    L_temp_2.heapptr = networkZliteral_53.heapptr;
    L_temp_2.dataword.ptr = A_value;
    orig_sp[0] = L_temp_2;
    orig_sp[1] = L_arg1;
    /* + */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZPLUS_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_temp_3 = (orig_sp == cluster_0_top ? dylanZfalse : orig_sp[0]);

    /* #line 386 "./condition.dylan" */
    if ((&networkZnetwork_internalZCLS_sockaddr_in_HEAP == SLOT(L_temp_3.heapptr, heapptr_t, 0))) {

	/* #line 2247 "./sockets-api.dylan" */
	return L_temp_3.dataword.ptr;
    }
    else {

	/* #line 389 "./condition.dylan" */
	L_temp_4.heapptr = &networkZstr_ROOT_70;
	L_temp_4.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp_3, &networkZnetwork_internalZCLS_sockaddr_in_HEAP, L_temp_4);
	not_reached();
    }
}

/* generic-entry for pointer-value{<sockaddr-in>} */
descriptor_t * networkZnetwork_internalZpointer_value_METH_GENERIC_39(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    descriptor_t L_arg; /* arg */
    heapptr_t L_rest; /* rest */
    void * L_arg_2; /* arg */
    descriptor_t L_index; /* index */
    long L_index_2; /* index */
    descriptor_t L_key; /* key */
    descriptor_t L_value; /* value */
    void * L_result0; /* result0 */
    descriptor_t L_temp;

    /* #line {Class <unknown-source-location>} */
    L_args = ((void *)(orig_sp - A_nargs));
    L_arg = (((descriptor_t *)L_args)[0]);
    L_rest = dylanZdylan_visceraZmake_rest_arg_FUN(orig_sp, (descriptor_t *)L_args + 1, A_nargs - 1);
    L_arg_2 = L_arg.dataword.ptr;
    L_index.heapptr = networkZliteral_2.heapptr;
    L_index.dataword.l = 0;
    L_index_2 = (A_nargs - 2);
    while (1) {
	if ((L_index_2 < 1)) {
	    goto block0;
	}
	else {
	    L_key = (((descriptor_t *)L_args)[L_index_2]);
	    L_value = (((descriptor_t *)L_args)[(L_index_2 + 1)]);
	    if ((L_key.heapptr == &SYM_index_HEAP)) {
		L_index = L_value;
	    }
	    L_index_2 = (L_index_2 - 2);
	}
    }
  block0:;
    orig_sp = L_args;
    /* pointer-value{<sockaddr-in>} */
    L_result0 = networkZnetwork_internalZpointer_value_METH_39(orig_sp, L_arg_2, A_next_method_info, L_rest, L_index);
    L_temp.heapptr = networkZliteral_53.heapptr;
    L_temp.dataword.ptr = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* Define Method content-size{subclass(<sockaddr-in>)} */

/* content-size{subclass(<sockaddr-in>)} */
long networkZnetwork_internalZcontent_size_METH_51(descriptor_t *orig_sp, heapptr_t A0, heapptr_t A1)
{

    return 16;
}

/* generic-entry for content-size{subclass(<sockaddr-in>)} */
descriptor_t * networkZnetwork_internalZcontent_size_METH_GENERIC_51(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    long L_result0; /* result0 */
    descriptor_t L_temp;

    orig_sp = ((void *)(orig_sp - 1));
    /* content-size{subclass(<sockaddr-in>)} */
    L_result0 = networkZnetwork_internalZcontent_size_METH_51(orig_sp, &networkZnetwork_internalZCLS_sockaddr_in_HEAP, A_next_method_info);
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* Define Class <sockaddr-in6> */

/* <sockaddr-in6> is <sockaddr-in6> */

extern struct heapobj networkZnetwork_internalZCLS_sockaddr_in6_HEAP;

/* maker for <sockaddr-in6> */
void * networkZnetwork_internalZCLS_sockaddr_in6_MAKER_FUN(descriptor_t *orig_sp, void * A_pointer /* pointer */, int A_pointer_suppliedQUERY /* pointer-supplied? */)
{
    descriptor_t *cluster_0_top;


    /* #line 2254 "./sockets-api.dylan" */
    if (A_pointer_suppliedQUERY) {
	return A_pointer;
    }
    else {
	/* missing-required-init-keyword-error */
	dylanZdylan_visceraZmissing_required_init_keyword_error_FUN(orig_sp, &SYM_pointer_HEAP, &networkZnetwork_internalZCLS_sockaddr_in6_HEAP);
	not_reached();
    }
}

extern descriptor_t networkZliteral_54;	/* proxy for <sockaddr-in6> */

/* general-entry for maker for <sockaddr-in6> */
descriptor_t * networkZnetwork_internalZCLS_sockaddr_in6_MAKER_GENERAL(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    void * L_pointer; /* pointer */
    int L_pointer_suppliedQUERY; /* pointer-supplied? */
    long L_index; /* index */
    descriptor_t L_temp; /* temp */
    descriptor_t L_value; /* value */
    descriptor_t L_temp_2;
    descriptor_t L_temp_3;
    void * L_result0; /* result0 */
    descriptor_t L_temp_4;

    /* #line {Class <unknown-source-location>} */

    /* #line 126 "./cmp.dylan" */

    /* #line 209 "./num.dylan" */
    if (((A_nargs & 1) == 0)) {
	/* #line {Class <unknown-source-location>} */
	L_args = ((void *)(orig_sp - A_nargs));
	L_pointer = 0;
	L_pointer_suppliedQUERY = FALSE;
	L_index = (A_nargs - 2);
	while (1) {
	    if ((L_index < 0)) {
		goto block0;
	    }
	    else {
		L_temp = (((descriptor_t *)L_args)[L_index]);

		/* #line 386 "./condition.dylan" */
		if ((&dylanZdylan_visceraZCLS_symbol_HEAP == SLOT(L_temp.heapptr, heapptr_t, 0))) {
		    /* #line {Class <unknown-source-location>} */
		    L_value = (((descriptor_t *)L_args)[(L_index + 1)]);
		    if ((L_temp.heapptr == &SYM_pointer_HEAP)) {

			/* #line 386 "./condition.dylan" */
			if ((&dylanZdylan_visceraZCLS_raw_pointer_HEAP == SLOT(L_value.heapptr, heapptr_t, 0))) {
			    /* #line {Class <unknown-source-location>} */
			    L_pointer = L_value.dataword.ptr;
			    L_pointer_suppliedQUERY = TRUE;
			}
			else {

			    /* #line 389 "./condition.dylan" */
			    L_temp_2.heapptr = &networkZstr_ROOT;
			    L_temp_2.dataword.l = 0;
			    /* type-error-with-location */
			    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_value, &dylanZdylan_visceraZCLS_raw_pointer_HEAP, L_temp_2);
			    not_reached();
			}
		    }
		    /* #line {Class <unknown-source-location>} */
		    L_index = (L_index - 2);
		}
		else {

		    /* #line 389 "./condition.dylan" */
		    L_temp_3.heapptr = &networkZstr_ROOT;
		    L_temp_3.dataword.l = 0;
		    /* type-error-with-location */
		    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp, &dylanZdylan_visceraZCLS_symbol_HEAP, L_temp_3);
		    not_reached();
		}
	    }
	}
      block0:;
	/* #line {Class <unknown-source-location>} */
	orig_sp = L_args;
	/* maker for <sockaddr-in6> */
	L_result0 = networkZnetwork_internalZCLS_sockaddr_in6_MAKER_FUN(orig_sp, L_pointer, L_pointer_suppliedQUERY);
	L_temp_4.heapptr = networkZliteral_54.heapptr;
	L_temp_4.dataword.ptr = L_result0;
	orig_sp[0] = L_temp_4;
	return orig_sp + 1;
    }
    else {
	/* odd-number-of-keyword/value-arguments-error */
	dylanZdylan_visceraZodd_number_of_keywordSLASHvalue_arguments_error_FUN(orig_sp);
	not_reached();
    }
}


/* Define Sealed Domain make (singleton(<sockaddr-in6>)) */


/* {Implicit} Define Generic get-sin6-family */

/* get-sin6-family is get-sin6-family */


/* Define Method get-sin6-family{<sockaddr-in6>} */

/* get-sin6-family{<sockaddr-in6>} */
long networkZnetwork_internalZget_sin6_family_METH(descriptor_t *orig_sp, void * A_ptr /* ptr */, heapptr_t A1)
{
    descriptor_t *cluster_0_top;


    /* #line 185 "./melange.dylan" */

    /* #line 91 "./rawptr.dylan" */
    return (*(unsigned short *)((char *)A_ptr + 0 ));
}


/* {Implicit} Define Generic get-sin6-family-setter */

/* get-sin6-family-setter is get-sin6-family-setter */


/* Define Method get-sin6-family-setter{<integer>, <sockaddr-in6>} */

/* get-sin6-family-setter{<integer>, <sockaddr-in6>} */
long networkZnetwork_internalZget_sin6_family_setter_METH(descriptor_t *orig_sp, long A_value /* value */, void * A_ptr /* ptr */, heapptr_t A2)
{
    descriptor_t *cluster_0_top;

    /* #line {Class <unknown-source-location>} */

    /* #line 97 "./rawptr.dylan" */
    *(unsigned short *)((char *)A_ptr + 0) = A_value;
    return A_value;
}


/* {Implicit} Define Generic get-sin6-port */

/* get-sin6-port is get-sin6-port */


/* Define Method get-sin6-port{<sockaddr-in6>} */

/* get-sin6-port{<sockaddr-in6>} */
long networkZnetwork_internalZget_sin6_port_METH(descriptor_t *orig_sp, void * A_ptr /* ptr */, heapptr_t A1)
{
    descriptor_t *cluster_0_top;

    /* #line {Class <unknown-source-location>} */

    /* #line 185 "./melange.dylan" */

    /* #line 91 "./rawptr.dylan" */
    return (*(unsigned short *)((char *)A_ptr + 2 ));
}


/* {Implicit} Define Generic get-sin6-port-setter */

/* get-sin6-port-setter is get-sin6-port-setter */


/* Define Method get-sin6-port-setter{<integer>, <sockaddr-in6>} */

/* get-sin6-port-setter{<integer>, <sockaddr-in6>} */
long networkZnetwork_internalZget_sin6_port_setter_METH(descriptor_t *orig_sp, long A_value /* value */, void * A_ptr /* ptr */, heapptr_t A2)
{
    descriptor_t *cluster_0_top;

    /* #line {Class <unknown-source-location>} */

    /* #line 97 "./rawptr.dylan" */
    *(unsigned short *)((char *)A_ptr + 2) = A_value;
    return A_value;
}


/* {Implicit} Define Generic get-sin6-flowinfo */

/* get-sin6-flowinfo is get-sin6-flowinfo */


/* Define Method get-sin6-flowinfo{<sockaddr-in6>} */

/* get-sin6-flowinfo{<sockaddr-in6>} */
long networkZnetwork_internalZget_sin6_flowinfo_METH(descriptor_t *orig_sp, void * A_ptr /* ptr */, heapptr_t A1)
{
    descriptor_t *cluster_0_top;

    /* #line {Class <unknown-source-location>} */

    /* #line 211 "./melange.dylan" */

    /* #line 91 "./rawptr.dylan" */
    return (*(long *)((char *)A_ptr + 4 ));
}


/* {Implicit} Define Generic get-sin6-flowinfo-setter */

/* get-sin6-flowinfo-setter is get-sin6-flowinfo-setter */


/* Define Method get-sin6-flowinfo-setter{<integer>, <sockaddr-in6>} */

/* get-sin6-flowinfo-setter{<integer>, <sockaddr-in6>} */
long networkZnetwork_internalZget_sin6_flowinfo_setter_METH(descriptor_t *orig_sp, long A_value /* value */, void * A_ptr /* ptr */, heapptr_t A2)
{
    descriptor_t *cluster_0_top;

    /* #line {Class <unknown-source-location>} */

    /* #line 97 "./rawptr.dylan" */
    *(long *)((char *)A_ptr + 4) = A_value;
    return A_value;
}


/* {Implicit} Define Generic get-sin6-addr */

/* get-sin6-addr is get-sin6-addr */


/* Define Method get-sin6-addr{<sockaddr-in6>} */

extern struct heapobj networkZstr_ROOT_71;

/* get-sin6-addr{<sockaddr-in6>} */
void * networkZnetwork_internalZget_sin6_addr_METH(descriptor_t *orig_sp, void * A_ptr /* ptr */, heapptr_t A1)
{
    descriptor_t *cluster_0_top;
    descriptor_t L_temp;
    descriptor_t L_temp_2;
    descriptor_t L_temp_3;
    descriptor_t L_temp_4; /* temp */
    int L_condition; /* condition */
    descriptor_t L_temp_5;
    descriptor_t L_temp_6; /* temp */
    descriptor_t L_temp_7;
    descriptor_t L_temp_8;

    /* #line {Class <unknown-source-location>} */

    /* #line 49 "./object.dylan" */
    L_temp.heapptr = networkZliteral_54.heapptr;
    L_temp.dataword.ptr = A_ptr;

    /* #line 324 "./melange.dylan" */

    /* #line 324 "./melange.dylan" */

    /* #line 324 "./melange.dylan" */
    L_temp_2.heapptr = SLOT(L_temp.heapptr, heapptr_t, 0);
    L_temp_2.dataword.l = 0;
    L_temp_3.heapptr = networkZliteral_6.heapptr;
    L_temp_3.dataword.ptr = ((void *)((char *)A_ptr + 8));
    orig_sp[0] = L_temp_2;
    orig_sp[1] = L_temp_3;
    /* as */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZas_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_temp_4 = orig_sp[0];

    /* #line 49 "./object.dylan" */

    /* #line 386 "./condition.dylan" */
    /* %subtype?{<class>, <class>} */
    L_condition = dylanZdylan_visceraZPCTsubtypeQUERY_METH(orig_sp, SLOT(L_temp_4.heapptr, heapptr_t, 0), &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP, &dylanZliteral_ROOT_2);
    if (L_condition) {

	/* #line 324 "./melange.dylan" */

	/* #line 2293 "./sockets-api.dylan" */
	L_temp_5.heapptr = &networkZnetwork_internalZCLS_in6_addr_HEAP;
	L_temp_5.dataword.l = 0;
	orig_sp[0] = L_temp_5;
	orig_sp[1] = L_temp_4;
	/* as */
	{
	  struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZas_HEAP, 2);
	  heapptr_t L_meth = L_temp.R0;
	  heapptr_t L_next_info = L_temp.R1;
	  cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
	}
	L_temp_6 = orig_sp[0];

	/* #line 386 "./condition.dylan" */
	if ((&networkZnetwork_internalZCLS_in6_addr_HEAP == SLOT(L_temp_6.heapptr, heapptr_t, 0))) {

	    /* #line 2293 "./sockets-api.dylan" */
	    return L_temp_6.dataword.ptr;
	}
	else {

	    /* #line 389 "./condition.dylan" */
	    L_temp_7.heapptr = &networkZstr_ROOT_71;
	    L_temp_7.dataword.l = 0;
	    /* type-error-with-location */
	    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp_6, &networkZnetwork_internalZCLS_in6_addr_HEAP, L_temp_7);
	    not_reached();
	}
    }
    else {
	L_temp_8.heapptr = &networkZstr_ROOT_5;
	L_temp_8.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp_4, &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP, L_temp_8);
	not_reached();
    }
}


/* {Implicit} Define Generic get-sin6-scope-id */

/* get-sin6-scope-id is get-sin6-scope-id */


/* Define Method get-sin6-scope-id{<sockaddr-in6>} */

/* get-sin6-scope-id{<sockaddr-in6>} */
long networkZnetwork_internalZget_sin6_scope_id_METH(descriptor_t *orig_sp, void * A_ptr /* ptr */, heapptr_t A1)
{
    descriptor_t *cluster_0_top;

    /* #line {Class <unknown-source-location>} */

    /* #line 211 "./melange.dylan" */

    /* #line 91 "./rawptr.dylan" */
    return (*(long *)((char *)A_ptr + 24 ));
}


/* {Implicit} Define Generic get-sin6-scope-id-setter */

/* get-sin6-scope-id-setter is get-sin6-scope-id-setter */


/* Define Method get-sin6-scope-id-setter{<integer>, <sockaddr-in6>} */

/* get-sin6-scope-id-setter{<integer>, <sockaddr-in6>} */
long networkZnetwork_internalZget_sin6_scope_id_setter_METH(descriptor_t *orig_sp, long A_value /* value */, void * A_ptr /* ptr */, heapptr_t A2)
{
    descriptor_t *cluster_0_top;

    /* #line {Class <unknown-source-location>} */

    /* #line 97 "./rawptr.dylan" */
    *(long *)((char *)A_ptr + 24) = A_value;
    return A_value;
}


/* Define Method pointer-value{<sockaddr-in6>} */

extern struct heapobj networkZstr_ROOT_72;

/* pointer-value{<sockaddr-in6>} */
void * networkZnetwork_internalZpointer_value_METH_40(descriptor_t *orig_sp, void * A_value /* value */, heapptr_t A_next_method_info /* next-method-info */, heapptr_t A_rest /* rest */, descriptor_t A_index /* index */)
{
    descriptor_t *cluster_0_top;
    descriptor_t L_temp;
    descriptor_t L_arg1; /* arg1 */
    descriptor_t L_temp_2;
    descriptor_t L_temp_3; /* temp */
    descriptor_t L_temp_4;

    /* #line {Class <unknown-source-location>} */

    /* #line 2308 "./sockets-api.dylan" */
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = 28;
    orig_sp[0] = A_index;
    orig_sp[1] = L_temp;
    /* * */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZV_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_arg1 = (orig_sp == cluster_0_top ? dylanZfalse : orig_sp[0]);

    /* #line 2308 "./sockets-api.dylan" */
    L_temp_2.heapptr = networkZliteral_54.heapptr;
    L_temp_2.dataword.ptr = A_value;
    orig_sp[0] = L_temp_2;
    orig_sp[1] = L_arg1;
    /* + */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZPLUS_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_temp_3 = (orig_sp == cluster_0_top ? dylanZfalse : orig_sp[0]);

    /* #line 386 "./condition.dylan" */
    if ((&networkZnetwork_internalZCLS_sockaddr_in6_HEAP == SLOT(L_temp_3.heapptr, heapptr_t, 0))) {

	/* #line 2308 "./sockets-api.dylan" */
	return L_temp_3.dataword.ptr;
    }
    else {

	/* #line 389 "./condition.dylan" */
	L_temp_4.heapptr = &networkZstr_ROOT_72;
	L_temp_4.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp_3, &networkZnetwork_internalZCLS_sockaddr_in6_HEAP, L_temp_4);
	not_reached();
    }
}

/* generic-entry for pointer-value{<sockaddr-in6>} */
descriptor_t * networkZnetwork_internalZpointer_value_METH_GENERIC_40(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    descriptor_t L_arg; /* arg */
    heapptr_t L_rest; /* rest */
    void * L_arg_2; /* arg */
    descriptor_t L_index; /* index */
    long L_index_2; /* index */
    descriptor_t L_key; /* key */
    descriptor_t L_value; /* value */
    void * L_result0; /* result0 */
    descriptor_t L_temp;

    /* #line {Class <unknown-source-location>} */
    L_args = ((void *)(orig_sp - A_nargs));
    L_arg = (((descriptor_t *)L_args)[0]);
    L_rest = dylanZdylan_visceraZmake_rest_arg_FUN(orig_sp, (descriptor_t *)L_args + 1, A_nargs - 1);
    L_arg_2 = L_arg.dataword.ptr;
    L_index.heapptr = networkZliteral_2.heapptr;
    L_index.dataword.l = 0;
    L_index_2 = (A_nargs - 2);
    while (1) {
	if ((L_index_2 < 1)) {
	    goto block0;
	}
	else {
	    L_key = (((descriptor_t *)L_args)[L_index_2]);
	    L_value = (((descriptor_t *)L_args)[(L_index_2 + 1)]);
	    if ((L_key.heapptr == &SYM_index_HEAP)) {
		L_index = L_value;
	    }
	    L_index_2 = (L_index_2 - 2);
	}
    }
  block0:;
    orig_sp = L_args;
    /* pointer-value{<sockaddr-in6>} */
    L_result0 = networkZnetwork_internalZpointer_value_METH_40(orig_sp, L_arg_2, A_next_method_info, L_rest, L_index);
    L_temp.heapptr = networkZliteral_54.heapptr;
    L_temp.dataword.ptr = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* Define Method content-size{subclass(<sockaddr-in6>)} */

/* content-size{subclass(<sockaddr-in6>)} */
long networkZnetwork_internalZcontent_size_METH_52(descriptor_t *orig_sp, heapptr_t A0, heapptr_t A1)
{

    return 28;
}

/* generic-entry for content-size{subclass(<sockaddr-in6>)} */
descriptor_t * networkZnetwork_internalZcontent_size_METH_GENERIC_52(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    long L_result0; /* result0 */
    descriptor_t L_temp;

    orig_sp = ((void *)(orig_sp - 1));
    /* content-size{subclass(<sockaddr-in6>)} */
    L_result0 = networkZnetwork_internalZcontent_size_METH_52(orig_sp, &networkZnetwork_internalZCLS_sockaddr_in6_HEAP, A_next_method_info);
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* Define Class <ipv6-mreq> */

/* <ipv6-mreq> is <ipv6-mreq> */

extern struct heapobj networkZnetwork_internalZCLS_ipv6_mreq_HEAP;

/* maker for <ipv6-mreq> */
void * networkZnetwork_internalZCLS_ipv6_mreq_MAKER_FUN(descriptor_t *orig_sp, void * A_pointer /* pointer */, int A_pointer_suppliedQUERY /* pointer-supplied? */)
{
    descriptor_t *cluster_0_top;


    /* #line 2315 "./sockets-api.dylan" */
    if (A_pointer_suppliedQUERY) {
	return A_pointer;
    }
    else {
	/* missing-required-init-keyword-error */
	dylanZdylan_visceraZmissing_required_init_keyword_error_FUN(orig_sp, &SYM_pointer_HEAP, &networkZnetwork_internalZCLS_ipv6_mreq_HEAP);
	not_reached();
    }
}

extern descriptor_t networkZliteral_55;	/* proxy for <ipv6-mreq> */

/* general-entry for maker for <ipv6-mreq> */
descriptor_t * networkZnetwork_internalZCLS_ipv6_mreq_MAKER_GENERAL(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    void * L_pointer; /* pointer */
    int L_pointer_suppliedQUERY; /* pointer-supplied? */
    long L_index; /* index */
    descriptor_t L_temp; /* temp */
    descriptor_t L_value; /* value */
    descriptor_t L_temp_2;
    descriptor_t L_temp_3;
    void * L_result0; /* result0 */
    descriptor_t L_temp_4;

    /* #line {Class <unknown-source-location>} */

    /* #line 126 "./cmp.dylan" */

    /* #line 209 "./num.dylan" */
    if (((A_nargs & 1) == 0)) {
	/* #line {Class <unknown-source-location>} */
	L_args = ((void *)(orig_sp - A_nargs));
	L_pointer = 0;
	L_pointer_suppliedQUERY = FALSE;
	L_index = (A_nargs - 2);
	while (1) {
	    if ((L_index < 0)) {
		goto block0;
	    }
	    else {
		L_temp = (((descriptor_t *)L_args)[L_index]);

		/* #line 386 "./condition.dylan" */
		if ((&dylanZdylan_visceraZCLS_symbol_HEAP == SLOT(L_temp.heapptr, heapptr_t, 0))) {
		    /* #line {Class <unknown-source-location>} */
		    L_value = (((descriptor_t *)L_args)[(L_index + 1)]);
		    if ((L_temp.heapptr == &SYM_pointer_HEAP)) {

			/* #line 386 "./condition.dylan" */
			if ((&dylanZdylan_visceraZCLS_raw_pointer_HEAP == SLOT(L_value.heapptr, heapptr_t, 0))) {
			    /* #line {Class <unknown-source-location>} */
			    L_pointer = L_value.dataword.ptr;
			    L_pointer_suppliedQUERY = TRUE;
			}
			else {

			    /* #line 389 "./condition.dylan" */
			    L_temp_2.heapptr = &networkZstr_ROOT;
			    L_temp_2.dataword.l = 0;
			    /* type-error-with-location */
			    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_value, &dylanZdylan_visceraZCLS_raw_pointer_HEAP, L_temp_2);
			    not_reached();
			}
		    }
		    /* #line {Class <unknown-source-location>} */
		    L_index = (L_index - 2);
		}
		else {

		    /* #line 389 "./condition.dylan" */
		    L_temp_3.heapptr = &networkZstr_ROOT;
		    L_temp_3.dataword.l = 0;
		    /* type-error-with-location */
		    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp, &dylanZdylan_visceraZCLS_symbol_HEAP, L_temp_3);
		    not_reached();
		}
	    }
	}
      block0:;
	/* #line {Class <unknown-source-location>} */
	orig_sp = L_args;
	/* maker for <ipv6-mreq> */
	L_result0 = networkZnetwork_internalZCLS_ipv6_mreq_MAKER_FUN(orig_sp, L_pointer, L_pointer_suppliedQUERY);
	L_temp_4.heapptr = networkZliteral_55.heapptr;
	L_temp_4.dataword.ptr = L_result0;
	orig_sp[0] = L_temp_4;
	return orig_sp + 1;
    }
    else {
	/* odd-number-of-keyword/value-arguments-error */
	dylanZdylan_visceraZodd_number_of_keywordSLASHvalue_arguments_error_FUN(orig_sp);
	not_reached();
    }
}


/* Define Sealed Domain make (singleton(<ipv6-mreq>)) */


/* {Implicit} Define Generic get-ipv6mr-multiaddr */

/* get-ipv6mr-multiaddr is get-ipv6mr-multiaddr */


/* Define Method get-ipv6mr-multiaddr{<ipv6-mreq>} */

extern struct heapobj networkZstr_ROOT_73;

/* get-ipv6mr-multiaddr{<ipv6-mreq>} */
void * networkZnetwork_internalZget_ipv6mr_multiaddr_METH(descriptor_t *orig_sp, void * A_ptr /* ptr */, heapptr_t A1)
{
    descriptor_t *cluster_0_top;
    descriptor_t L_temp;
    descriptor_t L_temp_2;
    descriptor_t L_temp_3;
    descriptor_t L_temp_4; /* temp */
    int L_condition; /* condition */
    descriptor_t L_temp_5;
    descriptor_t L_temp_6; /* temp */
    descriptor_t L_temp_7;
    descriptor_t L_temp_8;


    /* #line 49 "./object.dylan" */
    L_temp.heapptr = networkZliteral_55.heapptr;
    L_temp.dataword.ptr = A_ptr;

    /* #line 324 "./melange.dylan" */

    /* #line 324 "./melange.dylan" */

    /* #line 324 "./melange.dylan" */
    L_temp_2.heapptr = SLOT(L_temp.heapptr, heapptr_t, 0);
    L_temp_2.dataword.l = 0;
    L_temp_3.heapptr = networkZliteral_6.heapptr;
    L_temp_3.dataword.ptr = ((void *)((char *)A_ptr + 0));
    orig_sp[0] = L_temp_2;
    orig_sp[1] = L_temp_3;
    /* as */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZas_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_temp_4 = orig_sp[0];

    /* #line 49 "./object.dylan" */

    /* #line 386 "./condition.dylan" */
    /* %subtype?{<class>, <class>} */
    L_condition = dylanZdylan_visceraZPCTsubtypeQUERY_METH(orig_sp, SLOT(L_temp_4.heapptr, heapptr_t, 0), &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP, &dylanZliteral_ROOT_2);
    if (L_condition) {

	/* #line 324 "./melange.dylan" */

	/* #line 2321 "./sockets-api.dylan" */
	L_temp_5.heapptr = &networkZnetwork_internalZCLS_in6_addr_HEAP;
	L_temp_5.dataword.l = 0;
	orig_sp[0] = L_temp_5;
	orig_sp[1] = L_temp_4;
	/* as */
	{
	  struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZas_HEAP, 2);
	  heapptr_t L_meth = L_temp.R0;
	  heapptr_t L_next_info = L_temp.R1;
	  cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
	}
	L_temp_6 = orig_sp[0];

	/* #line 386 "./condition.dylan" */
	if ((&networkZnetwork_internalZCLS_in6_addr_HEAP == SLOT(L_temp_6.heapptr, heapptr_t, 0))) {

	    /* #line 2321 "./sockets-api.dylan" */
	    return L_temp_6.dataword.ptr;
	}
	else {

	    /* #line 389 "./condition.dylan" */
	    L_temp_7.heapptr = &networkZstr_ROOT_73;
	    L_temp_7.dataword.l = 0;
	    /* type-error-with-location */
	    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp_6, &networkZnetwork_internalZCLS_in6_addr_HEAP, L_temp_7);
	    not_reached();
	}
    }
    else {
	L_temp_8.heapptr = &networkZstr_ROOT_5;
	L_temp_8.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp_4, &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP, L_temp_8);
	not_reached();
    }
}


/* {Implicit} Define Generic get-ipv6mr-interface */

/* get-ipv6mr-interface is get-ipv6mr-interface */


/* Define Method get-ipv6mr-interface{<ipv6-mreq>} */

/* get-ipv6mr-interface{<ipv6-mreq>} */
long networkZnetwork_internalZget_ipv6mr_interface_METH(descriptor_t *orig_sp, void * A_ptr /* ptr */, heapptr_t A1)
{
    descriptor_t *cluster_0_top;

    /* #line {Class <unknown-source-location>} */

    /* #line 211 "./melange.dylan" */

    /* #line 91 "./rawptr.dylan" */
    return (*(long *)((char *)A_ptr + 16 ));
}


/* {Implicit} Define Generic get-ipv6mr-interface-setter */

/* get-ipv6mr-interface-setter is get-ipv6mr-interface-setter */


/* Define Method get-ipv6mr-interface-setter{<integer>, <ipv6-mreq>} */

/* get-ipv6mr-interface-setter{<integer>, <ipv6-mreq>} */
long networkZnetwork_internalZget_ipv6mr_interface_setter_METH(descriptor_t *orig_sp, long A_value /* value */, void * A_ptr /* ptr */, heapptr_t A2)
{
    descriptor_t *cluster_0_top;

    /* #line {Class <unknown-source-location>} */

    /* #line 97 "./rawptr.dylan" */
    *(long *)((char *)A_ptr + 16) = A_value;
    return A_value;
}


/* Define Method pointer-value{<ipv6-mreq>} */

extern struct heapobj networkZstr_ROOT_74;

/* pointer-value{<ipv6-mreq>} */
void * networkZnetwork_internalZpointer_value_METH_41(descriptor_t *orig_sp, void * A_value /* value */, heapptr_t A_next_method_info /* next-method-info */, heapptr_t A_rest /* rest */, descriptor_t A_index /* index */)
{
    descriptor_t *cluster_0_top;
    descriptor_t L_temp;
    descriptor_t L_arg1; /* arg1 */
    descriptor_t L_temp_2;
    descriptor_t L_temp_3; /* temp */
    descriptor_t L_temp_4;

    /* #line {Class <unknown-source-location>} */

    /* #line 2336 "./sockets-api.dylan" */
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = 20;
    orig_sp[0] = A_index;
    orig_sp[1] = L_temp;
    /* * */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZV_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_arg1 = (orig_sp == cluster_0_top ? dylanZfalse : orig_sp[0]);

    /* #line 2336 "./sockets-api.dylan" */
    L_temp_2.heapptr = networkZliteral_55.heapptr;
    L_temp_2.dataword.ptr = A_value;
    orig_sp[0] = L_temp_2;
    orig_sp[1] = L_arg1;
    /* + */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZPLUS_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_temp_3 = (orig_sp == cluster_0_top ? dylanZfalse : orig_sp[0]);

    /* #line 386 "./condition.dylan" */
    if ((&networkZnetwork_internalZCLS_ipv6_mreq_HEAP == SLOT(L_temp_3.heapptr, heapptr_t, 0))) {

	/* #line 2336 "./sockets-api.dylan" */
	return L_temp_3.dataword.ptr;
    }
    else {

	/* #line 389 "./condition.dylan" */
	L_temp_4.heapptr = &networkZstr_ROOT_74;
	L_temp_4.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp_3, &networkZnetwork_internalZCLS_ipv6_mreq_HEAP, L_temp_4);
	not_reached();
    }
}

/* generic-entry for pointer-value{<ipv6-mreq>} */
descriptor_t * networkZnetwork_internalZpointer_value_METH_GENERIC_41(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    descriptor_t L_arg; /* arg */
    heapptr_t L_rest; /* rest */
    void * L_arg_2; /* arg */
    descriptor_t L_index; /* index */
    long L_index_2; /* index */
    descriptor_t L_key; /* key */
    descriptor_t L_value; /* value */
    void * L_result0; /* result0 */
    descriptor_t L_temp;

    /* #line {Class <unknown-source-location>} */
    L_args = ((void *)(orig_sp - A_nargs));
    L_arg = (((descriptor_t *)L_args)[0]);
    L_rest = dylanZdylan_visceraZmake_rest_arg_FUN(orig_sp, (descriptor_t *)L_args + 1, A_nargs - 1);
    L_arg_2 = L_arg.dataword.ptr;
    L_index.heapptr = networkZliteral_2.heapptr;
    L_index.dataword.l = 0;
    L_index_2 = (A_nargs - 2);
    while (1) {
	if ((L_index_2 < 1)) {
	    goto block0;
	}
	else {
	    L_key = (((descriptor_t *)L_args)[L_index_2]);
	    L_value = (((descriptor_t *)L_args)[(L_index_2 + 1)]);
	    if ((L_key.heapptr == &SYM_index_HEAP)) {
		L_index = L_value;
	    }
	    L_index_2 = (L_index_2 - 2);
	}
    }
  block0:;
    orig_sp = L_args;
    /* pointer-value{<ipv6-mreq>} */
    L_result0 = networkZnetwork_internalZpointer_value_METH_41(orig_sp, L_arg_2, A_next_method_info, L_rest, L_index);
    L_temp.heapptr = networkZliteral_55.heapptr;
    L_temp.dataword.ptr = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* Define Method content-size{subclass(<ipv6-mreq>)} */

/* content-size{subclass(<ipv6-mreq>)} */
long networkZnetwork_internalZcontent_size_METH_53(descriptor_t *orig_sp, heapptr_t A0, heapptr_t A1)
{

    return 20;
}

/* generic-entry for content-size{subclass(<ipv6-mreq>)} */
descriptor_t * networkZnetwork_internalZcontent_size_METH_GENERIC_53(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    long L_result0; /* result0 */
    descriptor_t L_temp;

    orig_sp = ((void *)(orig_sp - 1));
    /* content-size{subclass(<ipv6-mreq>)} */
    L_result0 = networkZnetwork_internalZcontent_size_METH_53(orig_sp, &networkZnetwork_internalZCLS_ipv6_mreq_HEAP, A_next_method_info);
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* {Implicit} Define Generic ntohl */

/* ntohl is ntohl */


/* Define Method ntohl{<integer>} */

/* ntohl{<integer>} */
long networkZnetwork_internalZntohl_METH(descriptor_t *orig_sp, long A_arg1 /* arg1 */, heapptr_t A1)
{
    descriptor_t *cluster_0_top;
    long L_result_value; /* result-value */


    /* #line 735 "./macros.dylan" */
    L_result_value = ntohl(A_arg1);
    return L_result_value;
}


/* {Implicit} Define Generic ntohs */

/* ntohs is ntohs */


/* Define Method ntohs{<integer>} */

/* ntohs{<integer>} */
long networkZnetwork_internalZntohs_METH(descriptor_t *orig_sp, long A_arg1 /* arg1 */, heapptr_t A1)
{
    descriptor_t *cluster_0_top;
    long L_result_value; /* result-value */

    /* #line {Class <unknown-source-location>} */

    /* #line 735 "./macros.dylan" */
    L_result_value = ntohs(A_arg1);
    return L_result_value;
}


/* {Implicit} Define Generic htonl */

/* htonl is htonl */


/* Define Method htonl{<integer>} */

/* htonl{<integer>} */
long networkZnetwork_internalZhtonl_METH(descriptor_t *orig_sp, long A_arg1 /* arg1 */, heapptr_t A1)
{
    descriptor_t *cluster_0_top;
    long L_result_value; /* result-value */

    /* #line {Class <unknown-source-location>} */

    /* #line 735 "./macros.dylan" */
    L_result_value = htonl(A_arg1);
    return L_result_value;
}


/* {Implicit} Define Generic htons */

/* htons is htons */


/* Define Method htons{<integer>} */

/* htons{<integer>} */
long networkZnetwork_internalZhtons_METH(descriptor_t *orig_sp, long A_arg1 /* arg1 */, heapptr_t A1)
{
    descriptor_t *cluster_0_top;
    long L_result_value; /* result-value */

    /* #line {Class <unknown-source-location>} */

    /* #line 735 "./macros.dylan" */
    L_result_value = htons(A_arg1);
    return L_result_value;
}

/* generic-entry for htons{<integer>} */
descriptor_t * networkZnetwork_internalZhtons_METH_GENERIC(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    descriptor_t L_arg; /* arg */
    long L_arg_2; /* arg */
    long L_result0; /* result0 */
    descriptor_t L_temp;

    /* #line {Class <unknown-source-location>} */
    L_args = ((void *)(orig_sp - 1));
    L_arg = (((descriptor_t *)L_args)[0]);
    L_arg_2 = L_arg.dataword.l;
    orig_sp = L_args;
    /* htons{<integer>} */
    L_result0 = networkZnetwork_internalZhtons_METH(orig_sp, L_arg_2, A_next_method_info);
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* {Implicit} Define Generic bindresvport */

/* bindresvport is bindresvport */


/* Define Method bindresvport{<integer>, <sockaddr-in>} */

/* bindresvport{<integer>, <sockaddr-in>} */
long networkZnetwork_internalZbindresvport_METH(descriptor_t *orig_sp, long A_arg1 /* arg1 */, void * A_arg2 /* arg2 */, heapptr_t A2)
{
    descriptor_t *cluster_0_top;
    long L_result_value; /* result-value */


    /* #line 2379 "./sockets-api.dylan" */

    /* #line 735 "./macros.dylan" */
    L_result_value = bindresvport(A_arg1, A_arg2);
    return L_result_value;
}


/* Define Class <in6-pktinfo> */

/* <in6-pktinfo> is <in6-pktinfo> */

extern struct heapobj networkZnetwork_internalZCLS_in6_pktinfo_HEAP;

/* maker for <in6-pktinfo> */
void * networkZnetwork_internalZCLS_in6_pktinfo_MAKER_FUN(descriptor_t *orig_sp, void * A_pointer /* pointer */, int A_pointer_suppliedQUERY /* pointer-supplied? */)
{
    descriptor_t *cluster_0_top;


    /* #line 2383 "./sockets-api.dylan" */
    if (A_pointer_suppliedQUERY) {
	return A_pointer;
    }
    else {
	/* missing-required-init-keyword-error */
	dylanZdylan_visceraZmissing_required_init_keyword_error_FUN(orig_sp, &SYM_pointer_HEAP, &networkZnetwork_internalZCLS_in6_pktinfo_HEAP);
	not_reached();
    }
}

extern descriptor_t networkZliteral_56;	/* proxy for <in6-pktinfo> */

/* general-entry for maker for <in6-pktinfo> */
descriptor_t * networkZnetwork_internalZCLS_in6_pktinfo_MAKER_GENERAL(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    void * L_pointer; /* pointer */
    int L_pointer_suppliedQUERY; /* pointer-supplied? */
    long L_index; /* index */
    descriptor_t L_temp; /* temp */
    descriptor_t L_value; /* value */
    descriptor_t L_temp_2;
    descriptor_t L_temp_3;
    void * L_result0; /* result0 */
    descriptor_t L_temp_4;

    /* #line {Class <unknown-source-location>} */

    /* #line 126 "./cmp.dylan" */

    /* #line 209 "./num.dylan" */
    if (((A_nargs & 1) == 0)) {
	/* #line {Class <unknown-source-location>} */
	L_args = ((void *)(orig_sp - A_nargs));
	L_pointer = 0;
	L_pointer_suppliedQUERY = FALSE;
	L_index = (A_nargs - 2);
	while (1) {
	    if ((L_index < 0)) {
		goto block0;
	    }
	    else {
		L_temp = (((descriptor_t *)L_args)[L_index]);

		/* #line 386 "./condition.dylan" */
		if ((&dylanZdylan_visceraZCLS_symbol_HEAP == SLOT(L_temp.heapptr, heapptr_t, 0))) {
		    /* #line {Class <unknown-source-location>} */
		    L_value = (((descriptor_t *)L_args)[(L_index + 1)]);
		    if ((L_temp.heapptr == &SYM_pointer_HEAP)) {

			/* #line 386 "./condition.dylan" */
			if ((&dylanZdylan_visceraZCLS_raw_pointer_HEAP == SLOT(L_value.heapptr, heapptr_t, 0))) {
			    /* #line {Class <unknown-source-location>} */
			    L_pointer = L_value.dataword.ptr;
			    L_pointer_suppliedQUERY = TRUE;
			}
			else {

			    /* #line 389 "./condition.dylan" */
			    L_temp_2.heapptr = &networkZstr_ROOT;
			    L_temp_2.dataword.l = 0;
			    /* type-error-with-location */
			    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_value, &dylanZdylan_visceraZCLS_raw_pointer_HEAP, L_temp_2);
			    not_reached();
			}
		    }
		    /* #line {Class <unknown-source-location>} */
		    L_index = (L_index - 2);
		}
		else {

		    /* #line 389 "./condition.dylan" */
		    L_temp_3.heapptr = &networkZstr_ROOT;
		    L_temp_3.dataword.l = 0;
		    /* type-error-with-location */
		    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp, &dylanZdylan_visceraZCLS_symbol_HEAP, L_temp_3);
		    not_reached();
		}
	    }
	}
      block0:;
	/* #line {Class <unknown-source-location>} */
	orig_sp = L_args;
	/* maker for <in6-pktinfo> */
	L_result0 = networkZnetwork_internalZCLS_in6_pktinfo_MAKER_FUN(orig_sp, L_pointer, L_pointer_suppliedQUERY);
	L_temp_4.heapptr = networkZliteral_56.heapptr;
	L_temp_4.dataword.ptr = L_result0;
	orig_sp[0] = L_temp_4;
	return orig_sp + 1;
    }
    else {
	/* odd-number-of-keyword/value-arguments-error */
	dylanZdylan_visceraZodd_number_of_keywordSLASHvalue_arguments_error_FUN(orig_sp);
	not_reached();
    }
}


/* Define Sealed Domain make (singleton(<in6-pktinfo>)) */


/* {Implicit} Define Generic get-ipi6-addr */

/* get-ipi6-addr is get-ipi6-addr */


/* Define Method get-ipi6-addr{<in6-pktinfo>} */

extern struct heapobj networkZstr_ROOT_75;

/* get-ipi6-addr{<in6-pktinfo>} */
void * networkZnetwork_internalZget_ipi6_addr_METH(descriptor_t *orig_sp, void * A_ptr /* ptr */, heapptr_t A1)
{
    descriptor_t *cluster_0_top;
    descriptor_t L_temp;
    descriptor_t L_temp_2;
    descriptor_t L_temp_3;
    descriptor_t L_temp_4; /* temp */
    int L_condition; /* condition */
    descriptor_t L_temp_5;
    descriptor_t L_temp_6; /* temp */
    descriptor_t L_temp_7;
    descriptor_t L_temp_8;


    /* #line 49 "./object.dylan" */
    L_temp.heapptr = networkZliteral_56.heapptr;
    L_temp.dataword.ptr = A_ptr;

    /* #line 324 "./melange.dylan" */

    /* #line 324 "./melange.dylan" */

    /* #line 324 "./melange.dylan" */
    L_temp_2.heapptr = SLOT(L_temp.heapptr, heapptr_t, 0);
    L_temp_2.dataword.l = 0;
    L_temp_3.heapptr = networkZliteral_6.heapptr;
    L_temp_3.dataword.ptr = ((void *)((char *)A_ptr + 0));
    orig_sp[0] = L_temp_2;
    orig_sp[1] = L_temp_3;
    /* as */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZas_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_temp_4 = orig_sp[0];

    /* #line 49 "./object.dylan" */

    /* #line 386 "./condition.dylan" */
    /* %subtype?{<class>, <class>} */
    L_condition = dylanZdylan_visceraZPCTsubtypeQUERY_METH(orig_sp, SLOT(L_temp_4.heapptr, heapptr_t, 0), &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP, &dylanZliteral_ROOT_2);
    if (L_condition) {

	/* #line 324 "./melange.dylan" */

	/* #line 2389 "./sockets-api.dylan" */
	L_temp_5.heapptr = &networkZnetwork_internalZCLS_in6_addr_HEAP;
	L_temp_5.dataword.l = 0;
	orig_sp[0] = L_temp_5;
	orig_sp[1] = L_temp_4;
	/* as */
	{
	  struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZas_HEAP, 2);
	  heapptr_t L_meth = L_temp.R0;
	  heapptr_t L_next_info = L_temp.R1;
	  cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
	}
	L_temp_6 = orig_sp[0];

	/* #line 386 "./condition.dylan" */
	if ((&networkZnetwork_internalZCLS_in6_addr_HEAP == SLOT(L_temp_6.heapptr, heapptr_t, 0))) {

	    /* #line 2389 "./sockets-api.dylan" */
	    return L_temp_6.dataword.ptr;
	}
	else {

	    /* #line 389 "./condition.dylan" */
	    L_temp_7.heapptr = &networkZstr_ROOT_75;
	    L_temp_7.dataword.l = 0;
	    /* type-error-with-location */
	    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp_6, &networkZnetwork_internalZCLS_in6_addr_HEAP, L_temp_7);
	    not_reached();
	}
    }
    else {
	L_temp_8.heapptr = &networkZstr_ROOT_5;
	L_temp_8.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp_4, &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP, L_temp_8);
	not_reached();
    }
}


/* {Implicit} Define Generic get-ipi6-ifindex */

/* get-ipi6-ifindex is get-ipi6-ifindex */


/* Define Method get-ipi6-ifindex{<in6-pktinfo>} */

/* get-ipi6-ifindex{<in6-pktinfo>} */
long networkZnetwork_internalZget_ipi6_ifindex_METH(descriptor_t *orig_sp, void * A_ptr /* ptr */, heapptr_t A1)
{
    descriptor_t *cluster_0_top;

    /* #line {Class <unknown-source-location>} */

    /* #line 211 "./melange.dylan" */

    /* #line 91 "./rawptr.dylan" */
    return (*(long *)((char *)A_ptr + 16 ));
}


/* {Implicit} Define Generic get-ipi6-ifindex-setter */

/* get-ipi6-ifindex-setter is get-ipi6-ifindex-setter */


/* Define Method get-ipi6-ifindex-setter{<integer>, <in6-pktinfo>} */

/* get-ipi6-ifindex-setter{<integer>, <in6-pktinfo>} */
long networkZnetwork_internalZget_ipi6_ifindex_setter_METH(descriptor_t *orig_sp, long A_value /* value */, void * A_ptr /* ptr */, heapptr_t A2)
{
    descriptor_t *cluster_0_top;

    /* #line {Class <unknown-source-location>} */

    /* #line 97 "./rawptr.dylan" */
    *(long *)((char *)A_ptr + 16) = A_value;
    return A_value;
}


/* Define Method pointer-value{<in6-pktinfo>} */

extern struct heapobj networkZstr_ROOT_76;

/* pointer-value{<in6-pktinfo>} */
void * networkZnetwork_internalZpointer_value_METH_42(descriptor_t *orig_sp, void * A_value /* value */, heapptr_t A_next_method_info /* next-method-info */, heapptr_t A_rest /* rest */, descriptor_t A_index /* index */)
{
    descriptor_t *cluster_0_top;
    descriptor_t L_temp;
    descriptor_t L_arg1; /* arg1 */
    descriptor_t L_temp_2;
    descriptor_t L_temp_3; /* temp */
    descriptor_t L_temp_4;

    /* #line {Class <unknown-source-location>} */

    /* #line 2404 "./sockets-api.dylan" */
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = 20;
    orig_sp[0] = A_index;
    orig_sp[1] = L_temp;
    /* * */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZV_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_arg1 = (orig_sp == cluster_0_top ? dylanZfalse : orig_sp[0]);

    /* #line 2404 "./sockets-api.dylan" */
    L_temp_2.heapptr = networkZliteral_56.heapptr;
    L_temp_2.dataword.ptr = A_value;
    orig_sp[0] = L_temp_2;
    orig_sp[1] = L_arg1;
    /* + */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZPLUS_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_temp_3 = (orig_sp == cluster_0_top ? dylanZfalse : orig_sp[0]);

    /* #line 386 "./condition.dylan" */
    if ((&networkZnetwork_internalZCLS_in6_pktinfo_HEAP == SLOT(L_temp_3.heapptr, heapptr_t, 0))) {

	/* #line 2404 "./sockets-api.dylan" */
	return L_temp_3.dataword.ptr;
    }
    else {

	/* #line 389 "./condition.dylan" */
	L_temp_4.heapptr = &networkZstr_ROOT_76;
	L_temp_4.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp_3, &networkZnetwork_internalZCLS_in6_pktinfo_HEAP, L_temp_4);
	not_reached();
    }
}

/* generic-entry for pointer-value{<in6-pktinfo>} */
descriptor_t * networkZnetwork_internalZpointer_value_METH_GENERIC_42(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    descriptor_t L_arg; /* arg */
    heapptr_t L_rest; /* rest */
    void * L_arg_2; /* arg */
    descriptor_t L_index; /* index */
    long L_index_2; /* index */
    descriptor_t L_key; /* key */
    descriptor_t L_value; /* value */
    void * L_result0; /* result0 */
    descriptor_t L_temp;

    /* #line {Class <unknown-source-location>} */
    L_args = ((void *)(orig_sp - A_nargs));
    L_arg = (((descriptor_t *)L_args)[0]);
    L_rest = dylanZdylan_visceraZmake_rest_arg_FUN(orig_sp, (descriptor_t *)L_args + 1, A_nargs - 1);
    L_arg_2 = L_arg.dataword.ptr;
    L_index.heapptr = networkZliteral_2.heapptr;
    L_index.dataword.l = 0;
    L_index_2 = (A_nargs - 2);
    while (1) {
	if ((L_index_2 < 1)) {
	    goto block0;
	}
	else {
	    L_key = (((descriptor_t *)L_args)[L_index_2]);
	    L_value = (((descriptor_t *)L_args)[(L_index_2 + 1)]);
	    if ((L_key.heapptr == &SYM_index_HEAP)) {
		L_index = L_value;
	    }
	    L_index_2 = (L_index_2 - 2);
	}
    }
  block0:;
    orig_sp = L_args;
    /* pointer-value{<in6-pktinfo>} */
    L_result0 = networkZnetwork_internalZpointer_value_METH_42(orig_sp, L_arg_2, A_next_method_info, L_rest, L_index);
    L_temp.heapptr = networkZliteral_56.heapptr;
    L_temp.dataword.ptr = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* Define Method content-size{subclass(<in6-pktinfo>)} */

/* content-size{subclass(<in6-pktinfo>)} */
long networkZnetwork_internalZcontent_size_METH_54(descriptor_t *orig_sp, heapptr_t A0, heapptr_t A1)
{

    return 20;
}

/* generic-entry for content-size{subclass(<in6-pktinfo>)} */
descriptor_t * networkZnetwork_internalZcontent_size_METH_GENERIC_54(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    long L_result0; /* result0 */
    descriptor_t L_temp;

    orig_sp = ((void *)(orig_sp - 1));
    /* content-size{subclass(<in6-pktinfo>)} */
    L_result0 = networkZnetwork_internalZcontent_size_METH_54(orig_sp, &networkZnetwork_internalZCLS_in6_pktinfo_HEAP, A_next_method_info);
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* Define Constant $_NETINET-IN-H */

/* $_NETINET-IN-H is 1 */


/* Define Constant $IN-CLASSA-NET */

/* $IN-CLASSA-NET is #e4278190080 */


/* Define Constant $IN-CLASSA-NSHIFT */

/* $IN-CLASSA-NSHIFT is 24 */


/* Define Constant $IN-CLASSA-HOST */

/* $IN-CLASSA-HOST is #e16777215 */


/* Define Constant $IN-CLASSA-MAX */

/* $IN-CLASSA-MAX is 128 */


/* Define Constant $IN-CLASSB-NET */

/* $IN-CLASSB-NET is #e4294901760 */


/* Define Constant $IN-CLASSB-NSHIFT */

/* $IN-CLASSB-NSHIFT is 16 */


/* Define Constant $IN-CLASSB-HOST */

/* $IN-CLASSB-HOST is #e65535 */


/* Define Constant $IN-CLASSB-MAX */

/* $IN-CLASSB-MAX is 65536 */


/* Define Constant $IN-CLASSC-NET */

/* $IN-CLASSC-NET is #e4294967040 */


/* Define Constant $IN-CLASSC-NSHIFT */

/* $IN-CLASSC-NSHIFT is 8 */


/* Define Constant $IN-CLASSC-HOST */

/* $IN-CLASSC-HOST is #e255 */


/* Define Constant $INADDR-ANY */

/* $INADDR-ANY is 0 */


/* Define Constant $INADDR-BROADCAST */

/* $INADDR-BROADCAST is #e4294967295 */


/* Define Constant $INADDR-NONE */

/* $INADDR-NONE is #e4294967295 */


/* Define Constant $IN-LOOPBACKNET */

/* $IN-LOOPBACKNET is 127 */


/* Define Constant $INADDR-LOOPBACK */

/* $INADDR-LOOPBACK is 2130706433 */


/* Define Constant $INADDR-UNSPEC-GROUP */

/* $INADDR-UNSPEC-GROUP is #e3758096384 */


/* Define Constant $INADDR-ALLHOSTS-GROUP */

/* $INADDR-ALLHOSTS-GROUP is #e3758096385 */


/* Define Constant $INADDR-ALLRTRS-GROUP */

/* $INADDR-ALLRTRS-GROUP is #e3758096386 */


/* Define Constant $INADDR-MAX-LOCAL-GROUP */

/* $INADDR-MAX-LOCAL-GROUP is #e3758096639 */


/* Define Constant $INET-ADDRSTRLEN */

/* $INET-ADDRSTRLEN is 16 */


/* Define Constant $INET6-ADDRSTRLEN */

/* $INET6-ADDRSTRLEN is 46 */


/* Define Constant $_BITS-BYTESWAP-H */

/* $_BITS-BYTESWAP-H is 1 */


/* Define Class <char<@40>> */

/* <char<@40>> is <char<@40>> */

extern struct heapobj networkZnetwork_internalZCLS_charLESSX4040GREATER_HEAP;

/* maker for <char<@40>> */
void * networkZnetwork_internalZCLS_charLESSX4040GREATER_MAKER_FUN(descriptor_t *orig_sp, void * A_pointer /* pointer */, int A_pointer_suppliedQUERY /* pointer-supplied? */)
{
    descriptor_t *cluster_0_top;


    /* #line 2459 "./sockets-api.dylan" */
    if (A_pointer_suppliedQUERY) {
	return A_pointer;
    }
    else {
	/* missing-required-init-keyword-error */
	dylanZdylan_visceraZmissing_required_init_keyword_error_FUN(orig_sp, &SYM_pointer_HEAP, &networkZnetwork_internalZCLS_charLESSX4040GREATER_HEAP);
	not_reached();
    }
}

extern descriptor_t networkZliteral_57;	/* proxy for <char<@40>> */

/* general-entry for maker for <char<@40>> */
descriptor_t * networkZnetwork_internalZCLS_charLESSX4040GREATER_MAKER_GENERAL(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    void * L_pointer; /* pointer */
    int L_pointer_suppliedQUERY; /* pointer-supplied? */
    long L_index; /* index */
    descriptor_t L_temp; /* temp */
    descriptor_t L_value; /* value */
    descriptor_t L_temp_2;
    descriptor_t L_temp_3;
    void * L_result0; /* result0 */
    descriptor_t L_temp_4;

    /* #line {Class <unknown-source-location>} */

    /* #line 126 "./cmp.dylan" */

    /* #line 209 "./num.dylan" */
    if (((A_nargs & 1) == 0)) {
	/* #line {Class <unknown-source-location>} */
	L_args = ((void *)(orig_sp - A_nargs));
	L_pointer = 0;
	L_pointer_suppliedQUERY = FALSE;
	L_index = (A_nargs - 2);
	while (1) {
	    if ((L_index < 0)) {
		goto block0;
	    }
	    else {
		L_temp = (((descriptor_t *)L_args)[L_index]);

		/* #line 386 "./condition.dylan" */
		if ((&dylanZdylan_visceraZCLS_symbol_HEAP == SLOT(L_temp.heapptr, heapptr_t, 0))) {
		    /* #line {Class <unknown-source-location>} */
		    L_value = (((descriptor_t *)L_args)[(L_index + 1)]);
		    if ((L_temp.heapptr == &SYM_pointer_HEAP)) {

			/* #line 386 "./condition.dylan" */
			if ((&dylanZdylan_visceraZCLS_raw_pointer_HEAP == SLOT(L_value.heapptr, heapptr_t, 0))) {
			    /* #line {Class <unknown-source-location>} */
			    L_pointer = L_value.dataword.ptr;
			    L_pointer_suppliedQUERY = TRUE;
			}
			else {

			    /* #line 389 "./condition.dylan" */
			    L_temp_2.heapptr = &networkZstr_ROOT;
			    L_temp_2.dataword.l = 0;
			    /* type-error-with-location */
			    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_value, &dylanZdylan_visceraZCLS_raw_pointer_HEAP, L_temp_2);
			    not_reached();
			}
		    }
		    /* #line {Class <unknown-source-location>} */
		    L_index = (L_index - 2);
		}
		else {

		    /* #line 389 "./condition.dylan" */
		    L_temp_3.heapptr = &networkZstr_ROOT;
		    L_temp_3.dataword.l = 0;
		    /* type-error-with-location */
		    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp, &dylanZdylan_visceraZCLS_symbol_HEAP, L_temp_3);
		    not_reached();
		}
	    }
	}
      block0:;
	/* #line {Class <unknown-source-location>} */
	orig_sp = L_args;
	/* maker for <char<@40>> */
	L_result0 = networkZnetwork_internalZCLS_charLESSX4040GREATER_MAKER_FUN(orig_sp, L_pointer, L_pointer_suppliedQUERY);
	L_temp_4.heapptr = networkZliteral_57.heapptr;
	L_temp_4.dataword.ptr = L_result0;
	orig_sp[0] = L_temp_4;
	return orig_sp + 1;
    }
    else {
	/* odd-number-of-keyword/value-arguments-error */
	dylanZdylan_visceraZodd_number_of_keywordSLASHvalue_arguments_error_FUN(orig_sp);
	not_reached();
    }
}


/* Define Sealed Domain make (singleton(<char<@40>>)) */


/* Define Method content-size{singleton(<char<@40>>)} */

/* content-size{singleton(<char<@40>>)} */
long networkZnetwork_internalZcontent_size_METH_55(descriptor_t *orig_sp, heapptr_t A0, heapptr_t A1)
{

    return 40;
}

/* generic-entry for content-size{singleton(<char<@40>>)} */
descriptor_t * networkZnetwork_internalZcontent_size_METH_GENERIC_55(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    long L_result0; /* result0 */
    descriptor_t L_temp;

    orig_sp = ((void *)(orig_sp - 1));
    /* content-size{singleton(<char<@40>>)} */
    L_result0 = networkZnetwork_internalZcontent_size_METH_55(orig_sp, &networkZnetwork_internalZCLS_charLESSX4040GREATER_HEAP, A_next_method_info);
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* Define Class <ip-opts> */

/* <ip-opts> is <ip-opts> */

extern struct heapobj networkZnetwork_internalZCLS_ip_opts_HEAP;

/* maker for <ip-opts> */
void * networkZnetwork_internalZCLS_ip_opts_MAKER_FUN(descriptor_t *orig_sp, void * A_pointer /* pointer */, int A_pointer_suppliedQUERY /* pointer-supplied? */)
{
    descriptor_t *cluster_0_top;


    /* #line 2467 "./sockets-api.dylan" */
    if (A_pointer_suppliedQUERY) {
	return A_pointer;
    }
    else {
	/* missing-required-init-keyword-error */
	dylanZdylan_visceraZmissing_required_init_keyword_error_FUN(orig_sp, &SYM_pointer_HEAP, &networkZnetwork_internalZCLS_ip_opts_HEAP);
	not_reached();
    }
}

extern descriptor_t networkZliteral_58;	/* proxy for <ip-opts> */

/* general-entry for maker for <ip-opts> */
descriptor_t * networkZnetwork_internalZCLS_ip_opts_MAKER_GENERAL(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    void * L_pointer; /* pointer */
    int L_pointer_suppliedQUERY; /* pointer-supplied? */
    long L_index; /* index */
    descriptor_t L_temp; /* temp */
    descriptor_t L_value; /* value */
    descriptor_t L_temp_2;
    descriptor_t L_temp_3;
    void * L_result0; /* result0 */
    descriptor_t L_temp_4;

    /* #line {Class <unknown-source-location>} */

    /* #line 126 "./cmp.dylan" */

    /* #line 209 "./num.dylan" */
    if (((A_nargs & 1) == 0)) {
	/* #line {Class <unknown-source-location>} */
	L_args = ((void *)(orig_sp - A_nargs));
	L_pointer = 0;
	L_pointer_suppliedQUERY = FALSE;
	L_index = (A_nargs - 2);
	while (1) {
	    if ((L_index < 0)) {
		goto block0;
	    }
	    else {
		L_temp = (((descriptor_t *)L_args)[L_index]);

		/* #line 386 "./condition.dylan" */
		if ((&dylanZdylan_visceraZCLS_symbol_HEAP == SLOT(L_temp.heapptr, heapptr_t, 0))) {
		    /* #line {Class <unknown-source-location>} */
		    L_value = (((descriptor_t *)L_args)[(L_index + 1)]);
		    if ((L_temp.heapptr == &SYM_pointer_HEAP)) {

			/* #line 386 "./condition.dylan" */
			if ((&dylanZdylan_visceraZCLS_raw_pointer_HEAP == SLOT(L_value.heapptr, heapptr_t, 0))) {
			    /* #line {Class <unknown-source-location>} */
			    L_pointer = L_value.dataword.ptr;
			    L_pointer_suppliedQUERY = TRUE;
			}
			else {

			    /* #line 389 "./condition.dylan" */
			    L_temp_2.heapptr = &networkZstr_ROOT;
			    L_temp_2.dataword.l = 0;
			    /* type-error-with-location */
			    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_value, &dylanZdylan_visceraZCLS_raw_pointer_HEAP, L_temp_2);
			    not_reached();
			}
		    }
		    /* #line {Class <unknown-source-location>} */
		    L_index = (L_index - 2);
		}
		else {

		    /* #line 389 "./condition.dylan" */
		    L_temp_3.heapptr = &networkZstr_ROOT;
		    L_temp_3.dataword.l = 0;
		    /* type-error-with-location */
		    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp, &dylanZdylan_visceraZCLS_symbol_HEAP, L_temp_3);
		    not_reached();
		}
	    }
	}
      block0:;
	/* #line {Class <unknown-source-location>} */
	orig_sp = L_args;
	/* maker for <ip-opts> */
	L_result0 = networkZnetwork_internalZCLS_ip_opts_MAKER_FUN(orig_sp, L_pointer, L_pointer_suppliedQUERY);
	L_temp_4.heapptr = networkZliteral_58.heapptr;
	L_temp_4.dataword.ptr = L_result0;
	orig_sp[0] = L_temp_4;
	return orig_sp + 1;
    }
    else {
	/* odd-number-of-keyword/value-arguments-error */
	dylanZdylan_visceraZodd_number_of_keywordSLASHvalue_arguments_error_FUN(orig_sp);
	not_reached();
    }
}


/* Define Sealed Domain make (singleton(<ip-opts>)) */


/* {Implicit} Define Generic get-ip-dst */

/* get-ip-dst is get-ip-dst */


/* Define Method get-ip-dst{<ip-opts>} */

extern struct heapobj networkZstr_ROOT_77;

/* get-ip-dst{<ip-opts>} */
void * networkZnetwork_internalZget_ip_dst_METH(descriptor_t *orig_sp, void * A_ptr /* ptr */, heapptr_t A1)
{
    descriptor_t *cluster_0_top;
    descriptor_t L_temp;
    descriptor_t L_temp_2;
    descriptor_t L_temp_3;
    descriptor_t L_temp_4; /* temp */
    int L_condition; /* condition */
    descriptor_t L_temp_5;
    descriptor_t L_temp_6; /* temp */
    descriptor_t L_temp_7;
    descriptor_t L_temp_8;


    /* #line 49 "./object.dylan" */
    L_temp.heapptr = networkZliteral_58.heapptr;
    L_temp.dataword.ptr = A_ptr;

    /* #line 324 "./melange.dylan" */

    /* #line 324 "./melange.dylan" */

    /* #line 324 "./melange.dylan" */
    L_temp_2.heapptr = SLOT(L_temp.heapptr, heapptr_t, 0);
    L_temp_2.dataword.l = 0;
    L_temp_3.heapptr = networkZliteral_6.heapptr;
    L_temp_3.dataword.ptr = ((void *)((char *)A_ptr + 0));
    orig_sp[0] = L_temp_2;
    orig_sp[1] = L_temp_3;
    /* as */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZas_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_temp_4 = orig_sp[0];

    /* #line 49 "./object.dylan" */

    /* #line 386 "./condition.dylan" */
    /* %subtype?{<class>, <class>} */
    L_condition = dylanZdylan_visceraZPCTsubtypeQUERY_METH(orig_sp, SLOT(L_temp_4.heapptr, heapptr_t, 0), &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP, &dylanZliteral_ROOT_2);
    if (L_condition) {

	/* #line 324 "./melange.dylan" */

	/* #line 2473 "./sockets-api.dylan" */
	L_temp_5.heapptr = &networkZnetwork_internalZCLS_in_addr_HEAP;
	L_temp_5.dataword.l = 0;
	orig_sp[0] = L_temp_5;
	orig_sp[1] = L_temp_4;
	/* as */
	{
	  struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZas_HEAP, 2);
	  heapptr_t L_meth = L_temp.R0;
	  heapptr_t L_next_info = L_temp.R1;
	  cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
	}
	L_temp_6 = orig_sp[0];

	/* #line 386 "./condition.dylan" */
	if ((&networkZnetwork_internalZCLS_in_addr_HEAP == SLOT(L_temp_6.heapptr, heapptr_t, 0))) {

	    /* #line 2473 "./sockets-api.dylan" */
	    return L_temp_6.dataword.ptr;
	}
	else {

	    /* #line 389 "./condition.dylan" */
	    L_temp_7.heapptr = &networkZstr_ROOT_77;
	    L_temp_7.dataword.l = 0;
	    /* type-error-with-location */
	    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp_6, &networkZnetwork_internalZCLS_in_addr_HEAP, L_temp_7);
	    not_reached();
	}
    }
    else {
	L_temp_8.heapptr = &networkZstr_ROOT_5;
	L_temp_8.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp_4, &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP, L_temp_8);
	not_reached();
    }
}


/* {Implicit} Define Generic get-ip-opts */

/* get-ip-opts is get-ip-opts */


/* Define Method get-ip-opts{<ip-opts>} */

extern struct heapobj networkZstr_ROOT_78;

/* get-ip-opts{<ip-opts>} */
void * networkZnetwork_internalZget_ip_opts_METH(descriptor_t *orig_sp, void * A_ptr /* ptr */, heapptr_t A1)
{
    descriptor_t *cluster_0_top;
    descriptor_t L_temp;
    descriptor_t L_temp_2;
    descriptor_t L_temp_3;
    descriptor_t L_temp_4; /* temp */
    int L_condition; /* condition */
    descriptor_t L_temp_5;
    descriptor_t L_temp_6; /* temp */
    descriptor_t L_temp_7;
    descriptor_t L_temp_8;

    /* #line {Class <unknown-source-location>} */

    /* #line 49 "./object.dylan" */
    L_temp.heapptr = networkZliteral_58.heapptr;
    L_temp.dataword.ptr = A_ptr;

    /* #line 324 "./melange.dylan" */

    /* #line 324 "./melange.dylan" */

    /* #line 324 "./melange.dylan" */
    L_temp_2.heapptr = SLOT(L_temp.heapptr, heapptr_t, 0);
    L_temp_2.dataword.l = 0;
    L_temp_3.heapptr = networkZliteral_6.heapptr;
    L_temp_3.dataword.ptr = ((void *)((char *)A_ptr + 4));
    orig_sp[0] = L_temp_2;
    orig_sp[1] = L_temp_3;
    /* as */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZas_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_temp_4 = orig_sp[0];

    /* #line 49 "./object.dylan" */

    /* #line 386 "./condition.dylan" */
    /* %subtype?{<class>, <class>} */
    L_condition = dylanZdylan_visceraZPCTsubtypeQUERY_METH(orig_sp, SLOT(L_temp_4.heapptr, heapptr_t, 0), &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP, &dylanZliteral_ROOT_2);
    if (L_condition) {

	/* #line 324 "./melange.dylan" */

	/* #line 2478 "./sockets-api.dylan" */
	L_temp_5.heapptr = &networkZnetwork_internalZCLS_charLESSX4040GREATER_HEAP;
	L_temp_5.dataword.l = 0;
	orig_sp[0] = L_temp_5;
	orig_sp[1] = L_temp_4;
	/* as */
	{
	  struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZas_HEAP, 2);
	  heapptr_t L_meth = L_temp.R0;
	  heapptr_t L_next_info = L_temp.R1;
	  cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
	}
	L_temp_6 = orig_sp[0];

	/* #line 386 "./condition.dylan" */
	if ((&networkZnetwork_internalZCLS_charLESSX4040GREATER_HEAP == SLOT(L_temp_6.heapptr, heapptr_t, 0))) {

	    /* #line 2478 "./sockets-api.dylan" */
	    return L_temp_6.dataword.ptr;
	}
	else {

	    /* #line 389 "./condition.dylan" */
	    L_temp_7.heapptr = &networkZstr_ROOT_78;
	    L_temp_7.dataword.l = 0;
	    /* type-error-with-location */
	    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp_6, &networkZnetwork_internalZCLS_charLESSX4040GREATER_HEAP, L_temp_7);
	    not_reached();
	}
    }
    else {
	L_temp_8.heapptr = &networkZstr_ROOT_5;
	L_temp_8.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp_4, &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP, L_temp_8);
	not_reached();
    }
}


/* Define Method pointer-value{<ip-opts>} */

extern struct heapobj networkZstr_ROOT_79;

/* pointer-value{<ip-opts>} */
void * networkZnetwork_internalZpointer_value_METH_43(descriptor_t *orig_sp, void * A_value /* value */, heapptr_t A_next_method_info /* next-method-info */, heapptr_t A_rest /* rest */, descriptor_t A_index /* index */)
{
    descriptor_t *cluster_0_top;
    descriptor_t L_temp;
    descriptor_t L_arg1; /* arg1 */
    descriptor_t L_temp_2;
    descriptor_t L_temp_3; /* temp */
    descriptor_t L_temp_4;

    /* #line {Class <unknown-source-location>} */

    /* #line 2482 "./sockets-api.dylan" */
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = 44;
    orig_sp[0] = A_index;
    orig_sp[1] = L_temp;
    /* * */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZV_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_arg1 = (orig_sp == cluster_0_top ? dylanZfalse : orig_sp[0]);

    /* #line 2482 "./sockets-api.dylan" */
    L_temp_2.heapptr = networkZliteral_58.heapptr;
    L_temp_2.dataword.ptr = A_value;
    orig_sp[0] = L_temp_2;
    orig_sp[1] = L_arg1;
    /* + */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZPLUS_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_temp_3 = (orig_sp == cluster_0_top ? dylanZfalse : orig_sp[0]);

    /* #line 386 "./condition.dylan" */
    if ((&networkZnetwork_internalZCLS_ip_opts_HEAP == SLOT(L_temp_3.heapptr, heapptr_t, 0))) {

	/* #line 2482 "./sockets-api.dylan" */
	return L_temp_3.dataword.ptr;
    }
    else {

	/* #line 389 "./condition.dylan" */
	L_temp_4.heapptr = &networkZstr_ROOT_79;
	L_temp_4.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp_3, &networkZnetwork_internalZCLS_ip_opts_HEAP, L_temp_4);
	not_reached();
    }
}

/* generic-entry for pointer-value{<ip-opts>} */
descriptor_t * networkZnetwork_internalZpointer_value_METH_GENERIC_43(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    descriptor_t L_arg; /* arg */
    heapptr_t L_rest; /* rest */
    void * L_arg_2; /* arg */
    descriptor_t L_index; /* index */
    long L_index_2; /* index */
    descriptor_t L_key; /* key */
    descriptor_t L_value; /* value */
    void * L_result0; /* result0 */
    descriptor_t L_temp;

    /* #line {Class <unknown-source-location>} */
    L_args = ((void *)(orig_sp - A_nargs));
    L_arg = (((descriptor_t *)L_args)[0]);
    L_rest = dylanZdylan_visceraZmake_rest_arg_FUN(orig_sp, (descriptor_t *)L_args + 1, A_nargs - 1);
    L_arg_2 = L_arg.dataword.ptr;
    L_index.heapptr = networkZliteral_2.heapptr;
    L_index.dataword.l = 0;
    L_index_2 = (A_nargs - 2);
    while (1) {
	if ((L_index_2 < 1)) {
	    goto block0;
	}
	else {
	    L_key = (((descriptor_t *)L_args)[L_index_2]);
	    L_value = (((descriptor_t *)L_args)[(L_index_2 + 1)]);
	    if ((L_key.heapptr == &SYM_index_HEAP)) {
		L_index = L_value;
	    }
	    L_index_2 = (L_index_2 - 2);
	}
    }
  block0:;
    orig_sp = L_args;
    /* pointer-value{<ip-opts>} */
    L_result0 = networkZnetwork_internalZpointer_value_METH_43(orig_sp, L_arg_2, A_next_method_info, L_rest, L_index);
    L_temp.heapptr = networkZliteral_58.heapptr;
    L_temp.dataword.ptr = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* Define Method content-size{subclass(<ip-opts>)} */

/* content-size{subclass(<ip-opts>)} */
long networkZnetwork_internalZcontent_size_METH_56(descriptor_t *orig_sp, heapptr_t A0, heapptr_t A1)
{

    return 44;
}

/* generic-entry for content-size{subclass(<ip-opts>)} */
descriptor_t * networkZnetwork_internalZcontent_size_METH_GENERIC_56(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    long L_result0; /* result0 */
    descriptor_t L_temp;

    orig_sp = ((void *)(orig_sp - 1));
    /* content-size{subclass(<ip-opts>)} */
    L_result0 = networkZnetwork_internalZcontent_size_METH_56(orig_sp, &networkZnetwork_internalZCLS_ip_opts_HEAP, A_next_method_info);
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* Define Class <ip-mreq> */

/* <ip-mreq> is <ip-mreq> */

extern struct heapobj networkZnetwork_internalZCLS_ip_mreq_HEAP;

/* maker for <ip-mreq> */
void * networkZnetwork_internalZCLS_ip_mreq_MAKER_FUN(descriptor_t *orig_sp, void * A_pointer /* pointer */, int A_pointer_suppliedQUERY /* pointer-supplied? */)
{
    descriptor_t *cluster_0_top;


    /* #line 2489 "./sockets-api.dylan" */
    if (A_pointer_suppliedQUERY) {
	return A_pointer;
    }
    else {
	/* missing-required-init-keyword-error */
	dylanZdylan_visceraZmissing_required_init_keyword_error_FUN(orig_sp, &SYM_pointer_HEAP, &networkZnetwork_internalZCLS_ip_mreq_HEAP);
	not_reached();
    }
}

extern descriptor_t networkZliteral_59;	/* proxy for <ip-mreq> */

/* general-entry for maker for <ip-mreq> */
descriptor_t * networkZnetwork_internalZCLS_ip_mreq_MAKER_GENERAL(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    void * L_pointer; /* pointer */
    int L_pointer_suppliedQUERY; /* pointer-supplied? */
    long L_index; /* index */
    descriptor_t L_temp; /* temp */
    descriptor_t L_value; /* value */
    descriptor_t L_temp_2;
    descriptor_t L_temp_3;
    void * L_result0; /* result0 */
    descriptor_t L_temp_4;

    /* #line {Class <unknown-source-location>} */

    /* #line 126 "./cmp.dylan" */

    /* #line 209 "./num.dylan" */
    if (((A_nargs & 1) == 0)) {
	/* #line {Class <unknown-source-location>} */
	L_args = ((void *)(orig_sp - A_nargs));
	L_pointer = 0;
	L_pointer_suppliedQUERY = FALSE;
	L_index = (A_nargs - 2);
	while (1) {
	    if ((L_index < 0)) {
		goto block0;
	    }
	    else {
		L_temp = (((descriptor_t *)L_args)[L_index]);

		/* #line 386 "./condition.dylan" */
		if ((&dylanZdylan_visceraZCLS_symbol_HEAP == SLOT(L_temp.heapptr, heapptr_t, 0))) {
		    /* #line {Class <unknown-source-location>} */
		    L_value = (((descriptor_t *)L_args)[(L_index + 1)]);
		    if ((L_temp.heapptr == &SYM_pointer_HEAP)) {

			/* #line 386 "./condition.dylan" */
			if ((&dylanZdylan_visceraZCLS_raw_pointer_HEAP == SLOT(L_value.heapptr, heapptr_t, 0))) {
			    /* #line {Class <unknown-source-location>} */
			    L_pointer = L_value.dataword.ptr;
			    L_pointer_suppliedQUERY = TRUE;
			}
			else {

			    /* #line 389 "./condition.dylan" */
			    L_temp_2.heapptr = &networkZstr_ROOT;
			    L_temp_2.dataword.l = 0;
			    /* type-error-with-location */
			    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_value, &dylanZdylan_visceraZCLS_raw_pointer_HEAP, L_temp_2);
			    not_reached();
			}
		    }
		    /* #line {Class <unknown-source-location>} */
		    L_index = (L_index - 2);
		}
		else {

		    /* #line 389 "./condition.dylan" */
		    L_temp_3.heapptr = &networkZstr_ROOT;
		    L_temp_3.dataword.l = 0;
		    /* type-error-with-location */
		    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp, &dylanZdylan_visceraZCLS_symbol_HEAP, L_temp_3);
		    not_reached();
		}
	    }
	}
      block0:;
	/* #line {Class <unknown-source-location>} */
	orig_sp = L_args;
	/* maker for <ip-mreq> */
	L_result0 = networkZnetwork_internalZCLS_ip_mreq_MAKER_FUN(orig_sp, L_pointer, L_pointer_suppliedQUERY);
	L_temp_4.heapptr = networkZliteral_59.heapptr;
	L_temp_4.dataword.ptr = L_result0;
	orig_sp[0] = L_temp_4;
	return orig_sp + 1;
    }
    else {
	/* odd-number-of-keyword/value-arguments-error */
	dylanZdylan_visceraZodd_number_of_keywordSLASHvalue_arguments_error_FUN(orig_sp);
	not_reached();
    }
}


/* Define Sealed Domain make (singleton(<ip-mreq>)) */


/* {Implicit} Define Generic get-imr-multiaddr */

/* get-imr-multiaddr is get-imr-multiaddr */


/* Define Method get-imr-multiaddr{<ip-mreq>} */

extern struct heapobj networkZstr_ROOT_80;

/* get-imr-multiaddr{<ip-mreq>} */
void * networkZnetwork_internalZget_imr_multiaddr_METH(descriptor_t *orig_sp, void * A_ptr /* ptr */, heapptr_t A1)
{
    descriptor_t *cluster_0_top;
    descriptor_t L_temp;
    descriptor_t L_temp_2;
    descriptor_t L_temp_3;
    descriptor_t L_temp_4; /* temp */
    int L_condition; /* condition */
    descriptor_t L_temp_5;
    descriptor_t L_temp_6; /* temp */
    descriptor_t L_temp_7;
    descriptor_t L_temp_8;


    /* #line 49 "./object.dylan" */
    L_temp.heapptr = networkZliteral_59.heapptr;
    L_temp.dataword.ptr = A_ptr;

    /* #line 324 "./melange.dylan" */

    /* #line 324 "./melange.dylan" */

    /* #line 324 "./melange.dylan" */
    L_temp_2.heapptr = SLOT(L_temp.heapptr, heapptr_t, 0);
    L_temp_2.dataword.l = 0;
    L_temp_3.heapptr = networkZliteral_6.heapptr;
    L_temp_3.dataword.ptr = ((void *)((char *)A_ptr + 0));
    orig_sp[0] = L_temp_2;
    orig_sp[1] = L_temp_3;
    /* as */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZas_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_temp_4 = orig_sp[0];

    /* #line 49 "./object.dylan" */

    /* #line 386 "./condition.dylan" */
    /* %subtype?{<class>, <class>} */
    L_condition = dylanZdylan_visceraZPCTsubtypeQUERY_METH(orig_sp, SLOT(L_temp_4.heapptr, heapptr_t, 0), &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP, &dylanZliteral_ROOT_2);
    if (L_condition) {

	/* #line 324 "./melange.dylan" */

	/* #line 2495 "./sockets-api.dylan" */
	L_temp_5.heapptr = &networkZnetwork_internalZCLS_in_addr_HEAP;
	L_temp_5.dataword.l = 0;
	orig_sp[0] = L_temp_5;
	orig_sp[1] = L_temp_4;
	/* as */
	{
	  struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZas_HEAP, 2);
	  heapptr_t L_meth = L_temp.R0;
	  heapptr_t L_next_info = L_temp.R1;
	  cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
	}
	L_temp_6 = orig_sp[0];

	/* #line 386 "./condition.dylan" */
	if ((&networkZnetwork_internalZCLS_in_addr_HEAP == SLOT(L_temp_6.heapptr, heapptr_t, 0))) {

	    /* #line 2495 "./sockets-api.dylan" */
	    return L_temp_6.dataword.ptr;
	}
	else {

	    /* #line 389 "./condition.dylan" */
	    L_temp_7.heapptr = &networkZstr_ROOT_80;
	    L_temp_7.dataword.l = 0;
	    /* type-error-with-location */
	    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp_6, &networkZnetwork_internalZCLS_in_addr_HEAP, L_temp_7);
	    not_reached();
	}
    }
    else {
	L_temp_8.heapptr = &networkZstr_ROOT_5;
	L_temp_8.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp_4, &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP, L_temp_8);
	not_reached();
    }
}


/* {Implicit} Define Generic get-imr-interface */

/* get-imr-interface is get-imr-interface */


/* Define Method get-imr-interface{<ip-mreq>} */

extern struct heapobj networkZstr_ROOT_81;

/* get-imr-interface{<ip-mreq>} */
void * networkZnetwork_internalZget_imr_interface_METH(descriptor_t *orig_sp, void * A_ptr /* ptr */, heapptr_t A1)
{
    descriptor_t *cluster_0_top;
    descriptor_t L_temp;
    descriptor_t L_temp_2;
    descriptor_t L_temp_3;
    descriptor_t L_temp_4; /* temp */
    int L_condition; /* condition */
    descriptor_t L_temp_5;
    descriptor_t L_temp_6; /* temp */
    descriptor_t L_temp_7;
    descriptor_t L_temp_8;

    /* #line {Class <unknown-source-location>} */

    /* #line 49 "./object.dylan" */
    L_temp.heapptr = networkZliteral_59.heapptr;
    L_temp.dataword.ptr = A_ptr;

    /* #line 324 "./melange.dylan" */

    /* #line 324 "./melange.dylan" */

    /* #line 324 "./melange.dylan" */
    L_temp_2.heapptr = SLOT(L_temp.heapptr, heapptr_t, 0);
    L_temp_2.dataword.l = 0;
    L_temp_3.heapptr = networkZliteral_6.heapptr;
    L_temp_3.dataword.ptr = ((void *)((char *)A_ptr + 4));
    orig_sp[0] = L_temp_2;
    orig_sp[1] = L_temp_3;
    /* as */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZas_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_temp_4 = orig_sp[0];

    /* #line 49 "./object.dylan" */

    /* #line 386 "./condition.dylan" */
    /* %subtype?{<class>, <class>} */
    L_condition = dylanZdylan_visceraZPCTsubtypeQUERY_METH(orig_sp, SLOT(L_temp_4.heapptr, heapptr_t, 0), &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP, &dylanZliteral_ROOT_2);
    if (L_condition) {

	/* #line 324 "./melange.dylan" */

	/* #line 2500 "./sockets-api.dylan" */
	L_temp_5.heapptr = &networkZnetwork_internalZCLS_in_addr_HEAP;
	L_temp_5.dataword.l = 0;
	orig_sp[0] = L_temp_5;
	orig_sp[1] = L_temp_4;
	/* as */
	{
	  struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZas_HEAP, 2);
	  heapptr_t L_meth = L_temp.R0;
	  heapptr_t L_next_info = L_temp.R1;
	  cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
	}
	L_temp_6 = orig_sp[0];

	/* #line 386 "./condition.dylan" */
	if ((&networkZnetwork_internalZCLS_in_addr_HEAP == SLOT(L_temp_6.heapptr, heapptr_t, 0))) {

	    /* #line 2500 "./sockets-api.dylan" */
	    return L_temp_6.dataword.ptr;
	}
	else {

	    /* #line 389 "./condition.dylan" */
	    L_temp_7.heapptr = &networkZstr_ROOT_81;
	    L_temp_7.dataword.l = 0;
	    /* type-error-with-location */
	    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp_6, &networkZnetwork_internalZCLS_in_addr_HEAP, L_temp_7);
	    not_reached();
	}
    }
    else {
	L_temp_8.heapptr = &networkZstr_ROOT_5;
	L_temp_8.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp_4, &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP, L_temp_8);
	not_reached();
    }
}


/* Define Method pointer-value{<ip-mreq>} */

extern struct heapobj networkZstr_ROOT_82;

/* pointer-value{<ip-mreq>} */
void * networkZnetwork_internalZpointer_value_METH_44(descriptor_t *orig_sp, void * A_value /* value */, heapptr_t A_next_method_info /* next-method-info */, heapptr_t A_rest /* rest */, descriptor_t A_index /* index */)
{
    descriptor_t *cluster_0_top;
    descriptor_t L_temp;
    descriptor_t L_arg1; /* arg1 */
    descriptor_t L_temp_2;
    descriptor_t L_temp_3; /* temp */
    descriptor_t L_temp_4;

    /* #line {Class <unknown-source-location>} */

    /* #line 2504 "./sockets-api.dylan" */
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = 8;
    orig_sp[0] = A_index;
    orig_sp[1] = L_temp;
    /* * */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZV_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_arg1 = (orig_sp == cluster_0_top ? dylanZfalse : orig_sp[0]);

    /* #line 2504 "./sockets-api.dylan" */
    L_temp_2.heapptr = networkZliteral_59.heapptr;
    L_temp_2.dataword.ptr = A_value;
    orig_sp[0] = L_temp_2;
    orig_sp[1] = L_arg1;
    /* + */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZPLUS_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_temp_3 = (orig_sp == cluster_0_top ? dylanZfalse : orig_sp[0]);

    /* #line 386 "./condition.dylan" */
    if ((&networkZnetwork_internalZCLS_ip_mreq_HEAP == SLOT(L_temp_3.heapptr, heapptr_t, 0))) {

	/* #line 2504 "./sockets-api.dylan" */
	return L_temp_3.dataword.ptr;
    }
    else {

	/* #line 389 "./condition.dylan" */
	L_temp_4.heapptr = &networkZstr_ROOT_82;
	L_temp_4.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp_3, &networkZnetwork_internalZCLS_ip_mreq_HEAP, L_temp_4);
	not_reached();
    }
}

/* generic-entry for pointer-value{<ip-mreq>} */
descriptor_t * networkZnetwork_internalZpointer_value_METH_GENERIC_44(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    descriptor_t L_arg; /* arg */
    heapptr_t L_rest; /* rest */
    void * L_arg_2; /* arg */
    descriptor_t L_index; /* index */
    long L_index_2; /* index */
    descriptor_t L_key; /* key */
    descriptor_t L_value; /* value */
    void * L_result0; /* result0 */
    descriptor_t L_temp;

    /* #line {Class <unknown-source-location>} */
    L_args = ((void *)(orig_sp - A_nargs));
    L_arg = (((descriptor_t *)L_args)[0]);
    L_rest = dylanZdylan_visceraZmake_rest_arg_FUN(orig_sp, (descriptor_t *)L_args + 1, A_nargs - 1);
    L_arg_2 = L_arg.dataword.ptr;
    L_index.heapptr = networkZliteral_2.heapptr;
    L_index.dataword.l = 0;
    L_index_2 = (A_nargs - 2);
    while (1) {
	if ((L_index_2 < 1)) {
	    goto block0;
	}
	else {
	    L_key = (((descriptor_t *)L_args)[L_index_2]);
	    L_value = (((descriptor_t *)L_args)[(L_index_2 + 1)]);
	    if ((L_key.heapptr == &SYM_index_HEAP)) {
		L_index = L_value;
	    }
	    L_index_2 = (L_index_2 - 2);
	}
    }
  block0:;
    orig_sp = L_args;
    /* pointer-value{<ip-mreq>} */
    L_result0 = networkZnetwork_internalZpointer_value_METH_44(orig_sp, L_arg_2, A_next_method_info, L_rest, L_index);
    L_temp.heapptr = networkZliteral_59.heapptr;
    L_temp.dataword.ptr = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* Define Method content-size{subclass(<ip-mreq>)} */

/* content-size{subclass(<ip-mreq>)} */
long networkZnetwork_internalZcontent_size_METH_57(descriptor_t *orig_sp, heapptr_t A0, heapptr_t A1)
{

    return 8;
}

/* generic-entry for content-size{subclass(<ip-mreq>)} */
descriptor_t * networkZnetwork_internalZcontent_size_METH_GENERIC_57(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    long L_result0; /* result0 */
    descriptor_t L_temp;

    orig_sp = ((void *)(orig_sp - 1));
    /* content-size{subclass(<ip-mreq>)} */
    L_result0 = networkZnetwork_internalZcontent_size_METH_57(orig_sp, &networkZnetwork_internalZCLS_ip_mreq_HEAP, A_next_method_info);
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* Define Class <ip-mreqn> */

/* <ip-mreqn> is <ip-mreqn> */

extern struct heapobj networkZnetwork_internalZCLS_ip_mreqn_HEAP;

/* maker for <ip-mreqn> */
void * networkZnetwork_internalZCLS_ip_mreqn_MAKER_FUN(descriptor_t *orig_sp, void * A_pointer /* pointer */, int A_pointer_suppliedQUERY /* pointer-supplied? */)
{
    descriptor_t *cluster_0_top;


    /* #line 2511 "./sockets-api.dylan" */
    if (A_pointer_suppliedQUERY) {
	return A_pointer;
    }
    else {
	/* missing-required-init-keyword-error */
	dylanZdylan_visceraZmissing_required_init_keyword_error_FUN(orig_sp, &SYM_pointer_HEAP, &networkZnetwork_internalZCLS_ip_mreqn_HEAP);
	not_reached();
    }
}

extern descriptor_t networkZliteral_60;	/* proxy for <ip-mreqn> */

/* general-entry for maker for <ip-mreqn> */
descriptor_t * networkZnetwork_internalZCLS_ip_mreqn_MAKER_GENERAL(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    void * L_pointer; /* pointer */
    int L_pointer_suppliedQUERY; /* pointer-supplied? */
    long L_index; /* index */
    descriptor_t L_temp; /* temp */
    descriptor_t L_value; /* value */
    descriptor_t L_temp_2;
    descriptor_t L_temp_3;
    void * L_result0; /* result0 */
    descriptor_t L_temp_4;

    /* #line {Class <unknown-source-location>} */

    /* #line 126 "./cmp.dylan" */

    /* #line 209 "./num.dylan" */
    if (((A_nargs & 1) == 0)) {
	/* #line {Class <unknown-source-location>} */
	L_args = ((void *)(orig_sp - A_nargs));
	L_pointer = 0;
	L_pointer_suppliedQUERY = FALSE;
	L_index = (A_nargs - 2);
	while (1) {
	    if ((L_index < 0)) {
		goto block0;
	    }
	    else {
		L_temp = (((descriptor_t *)L_args)[L_index]);

		/* #line 386 "./condition.dylan" */
		if ((&dylanZdylan_visceraZCLS_symbol_HEAP == SLOT(L_temp.heapptr, heapptr_t, 0))) {
		    /* #line {Class <unknown-source-location>} */
		    L_value = (((descriptor_t *)L_args)[(L_index + 1)]);
		    if ((L_temp.heapptr == &SYM_pointer_HEAP)) {

			/* #line 386 "./condition.dylan" */
			if ((&dylanZdylan_visceraZCLS_raw_pointer_HEAP == SLOT(L_value.heapptr, heapptr_t, 0))) {
			    /* #line {Class <unknown-source-location>} */
			    L_pointer = L_value.dataword.ptr;
			    L_pointer_suppliedQUERY = TRUE;
			}
			else {

			    /* #line 389 "./condition.dylan" */
			    L_temp_2.heapptr = &networkZstr_ROOT;
			    L_temp_2.dataword.l = 0;
			    /* type-error-with-location */
			    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_value, &dylanZdylan_visceraZCLS_raw_pointer_HEAP, L_temp_2);
			    not_reached();
			}
		    }
		    /* #line {Class <unknown-source-location>} */
		    L_index = (L_index - 2);
		}
		else {

		    /* #line 389 "./condition.dylan" */
		    L_temp_3.heapptr = &networkZstr_ROOT;
		    L_temp_3.dataword.l = 0;
		    /* type-error-with-location */
		    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp, &dylanZdylan_visceraZCLS_symbol_HEAP, L_temp_3);
		    not_reached();
		}
	    }
	}
      block0:;
	/* #line {Class <unknown-source-location>} */
	orig_sp = L_args;
	/* maker for <ip-mreqn> */
	L_result0 = networkZnetwork_internalZCLS_ip_mreqn_MAKER_FUN(orig_sp, L_pointer, L_pointer_suppliedQUERY);
	L_temp_4.heapptr = networkZliteral_60.heapptr;
	L_temp_4.dataword.ptr = L_result0;
	orig_sp[0] = L_temp_4;
	return orig_sp + 1;
    }
    else {
	/* odd-number-of-keyword/value-arguments-error */
	dylanZdylan_visceraZodd_number_of_keywordSLASHvalue_arguments_error_FUN(orig_sp);
	not_reached();
    }
}


/* Define Sealed Domain make (singleton(<ip-mreqn>)) */


/* Define Method get-imr-multiaddr{<ip-mreqn>} */

extern struct heapobj networkZstr_ROOT_83;

/* get-imr-multiaddr{<ip-mreqn>} */
void * networkZnetwork_internalZget_imr_multiaddr_METH_2(descriptor_t *orig_sp, void * A_ptr /* ptr */, heapptr_t A1)
{
    descriptor_t *cluster_0_top;
    descriptor_t L_temp;
    descriptor_t L_temp_2;
    descriptor_t L_temp_3;
    descriptor_t L_temp_4; /* temp */
    int L_condition; /* condition */
    descriptor_t L_temp_5;
    descriptor_t L_temp_6; /* temp */
    descriptor_t L_temp_7;
    descriptor_t L_temp_8;


    /* #line 49 "./object.dylan" */
    L_temp.heapptr = networkZliteral_60.heapptr;
    L_temp.dataword.ptr = A_ptr;

    /* #line 324 "./melange.dylan" */

    /* #line 324 "./melange.dylan" */

    /* #line 324 "./melange.dylan" */
    L_temp_2.heapptr = SLOT(L_temp.heapptr, heapptr_t, 0);
    L_temp_2.dataword.l = 0;
    L_temp_3.heapptr = networkZliteral_6.heapptr;
    L_temp_3.dataword.ptr = ((void *)((char *)A_ptr + 0));
    orig_sp[0] = L_temp_2;
    orig_sp[1] = L_temp_3;
    /* as */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZas_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_temp_4 = orig_sp[0];

    /* #line 49 "./object.dylan" */

    /* #line 386 "./condition.dylan" */
    /* %subtype?{<class>, <class>} */
    L_condition = dylanZdylan_visceraZPCTsubtypeQUERY_METH(orig_sp, SLOT(L_temp_4.heapptr, heapptr_t, 0), &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP, &dylanZliteral_ROOT_2);
    if (L_condition) {

	/* #line 324 "./melange.dylan" */

	/* #line 2517 "./sockets-api.dylan" */
	L_temp_5.heapptr = &networkZnetwork_internalZCLS_in_addr_HEAP;
	L_temp_5.dataword.l = 0;
	orig_sp[0] = L_temp_5;
	orig_sp[1] = L_temp_4;
	/* as */
	{
	  struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZas_HEAP, 2);
	  heapptr_t L_meth = L_temp.R0;
	  heapptr_t L_next_info = L_temp.R1;
	  cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
	}
	L_temp_6 = orig_sp[0];

	/* #line 386 "./condition.dylan" */
	if ((&networkZnetwork_internalZCLS_in_addr_HEAP == SLOT(L_temp_6.heapptr, heapptr_t, 0))) {

	    /* #line 2517 "./sockets-api.dylan" */
	    return L_temp_6.dataword.ptr;
	}
	else {

	    /* #line 389 "./condition.dylan" */
	    L_temp_7.heapptr = &networkZstr_ROOT_83;
	    L_temp_7.dataword.l = 0;
	    /* type-error-with-location */
	    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp_6, &networkZnetwork_internalZCLS_in_addr_HEAP, L_temp_7);
	    not_reached();
	}
    }
    else {
	L_temp_8.heapptr = &networkZstr_ROOT_5;
	L_temp_8.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp_4, &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP, L_temp_8);
	not_reached();
    }
}


/* {Implicit} Define Generic get-imr-address */

/* get-imr-address is get-imr-address */


/* Define Method get-imr-address{<ip-mreqn>} */

extern struct heapobj networkZstr_ROOT_84;

/* get-imr-address{<ip-mreqn>} */
void * networkZnetwork_internalZget_imr_address_METH(descriptor_t *orig_sp, void * A_ptr /* ptr */, heapptr_t A1)
{
    descriptor_t *cluster_0_top;
    descriptor_t L_temp;
    descriptor_t L_temp_2;
    descriptor_t L_temp_3;
    descriptor_t L_temp_4; /* temp */
    int L_condition; /* condition */
    descriptor_t L_temp_5;
    descriptor_t L_temp_6; /* temp */
    descriptor_t L_temp_7;
    descriptor_t L_temp_8;

    /* #line {Class <unknown-source-location>} */

    /* #line 49 "./object.dylan" */
    L_temp.heapptr = networkZliteral_60.heapptr;
    L_temp.dataword.ptr = A_ptr;

    /* #line 324 "./melange.dylan" */

    /* #line 324 "./melange.dylan" */

    /* #line 324 "./melange.dylan" */
    L_temp_2.heapptr = SLOT(L_temp.heapptr, heapptr_t, 0);
    L_temp_2.dataword.l = 0;
    L_temp_3.heapptr = networkZliteral_6.heapptr;
    L_temp_3.dataword.ptr = ((void *)((char *)A_ptr + 4));
    orig_sp[0] = L_temp_2;
    orig_sp[1] = L_temp_3;
    /* as */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZas_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_temp_4 = orig_sp[0];

    /* #line 49 "./object.dylan" */

    /* #line 386 "./condition.dylan" */
    /* %subtype?{<class>, <class>} */
    L_condition = dylanZdylan_visceraZPCTsubtypeQUERY_METH(orig_sp, SLOT(L_temp_4.heapptr, heapptr_t, 0), &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP, &dylanZliteral_ROOT_2);
    if (L_condition) {

	/* #line 324 "./melange.dylan" */

	/* #line 2522 "./sockets-api.dylan" */
	L_temp_5.heapptr = &networkZnetwork_internalZCLS_in_addr_HEAP;
	L_temp_5.dataword.l = 0;
	orig_sp[0] = L_temp_5;
	orig_sp[1] = L_temp_4;
	/* as */
	{
	  struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZas_HEAP, 2);
	  heapptr_t L_meth = L_temp.R0;
	  heapptr_t L_next_info = L_temp.R1;
	  cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
	}
	L_temp_6 = orig_sp[0];

	/* #line 386 "./condition.dylan" */
	if ((&networkZnetwork_internalZCLS_in_addr_HEAP == SLOT(L_temp_6.heapptr, heapptr_t, 0))) {

	    /* #line 2522 "./sockets-api.dylan" */
	    return L_temp_6.dataword.ptr;
	}
	else {

	    /* #line 389 "./condition.dylan" */
	    L_temp_7.heapptr = &networkZstr_ROOT_84;
	    L_temp_7.dataword.l = 0;
	    /* type-error-with-location */
	    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp_6, &networkZnetwork_internalZCLS_in_addr_HEAP, L_temp_7);
	    not_reached();
	}
    }
    else {
	L_temp_8.heapptr = &networkZstr_ROOT_5;
	L_temp_8.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp_4, &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP, L_temp_8);
	not_reached();
    }
}


/* {Implicit} Define Generic get-imr-ifindex */

/* get-imr-ifindex is get-imr-ifindex */


/* Define Method get-imr-ifindex{<ip-mreqn>} */

/* get-imr-ifindex{<ip-mreqn>} */
long networkZnetwork_internalZget_imr_ifindex_METH(descriptor_t *orig_sp, void * A_ptr /* ptr */, heapptr_t A1)
{
    descriptor_t *cluster_0_top;

    /* #line {Class <unknown-source-location>} */

    /* #line 198 "./melange.dylan" */

    /* #line 91 "./rawptr.dylan" */
    return (*(long *)((char *)A_ptr + 8 ));
}


/* {Implicit} Define Generic get-imr-ifindex-setter */

/* get-imr-ifindex-setter is get-imr-ifindex-setter */


/* Define Method get-imr-ifindex-setter{<integer>, <ip-mreqn>} */

/* get-imr-ifindex-setter{<integer>, <ip-mreqn>} */
long networkZnetwork_internalZget_imr_ifindex_setter_METH(descriptor_t *orig_sp, long A_value /* value */, void * A_ptr /* ptr */, heapptr_t A2)
{
    descriptor_t *cluster_0_top;

    /* #line {Class <unknown-source-location>} */

    /* #line 97 "./rawptr.dylan" */
    *(long *)((char *)A_ptr + 8) = A_value;
    return A_value;
}


/* Define Method pointer-value{<ip-mreqn>} */

extern struct heapobj networkZstr_ROOT_85;

/* pointer-value{<ip-mreqn>} */
void * networkZnetwork_internalZpointer_value_METH_45(descriptor_t *orig_sp, void * A_value /* value */, heapptr_t A_next_method_info /* next-method-info */, heapptr_t A_rest /* rest */, descriptor_t A_index /* index */)
{
    descriptor_t *cluster_0_top;
    descriptor_t L_temp;
    descriptor_t L_arg1; /* arg1 */
    descriptor_t L_temp_2;
    descriptor_t L_temp_3; /* temp */
    descriptor_t L_temp_4;

    /* #line {Class <unknown-source-location>} */

    /* #line 2537 "./sockets-api.dylan" */
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = 12;
    orig_sp[0] = A_index;
    orig_sp[1] = L_temp;
    /* * */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZV_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_arg1 = (orig_sp == cluster_0_top ? dylanZfalse : orig_sp[0]);

    /* #line 2537 "./sockets-api.dylan" */
    L_temp_2.heapptr = networkZliteral_60.heapptr;
    L_temp_2.dataword.ptr = A_value;
    orig_sp[0] = L_temp_2;
    orig_sp[1] = L_arg1;
    /* + */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZPLUS_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_temp_3 = (orig_sp == cluster_0_top ? dylanZfalse : orig_sp[0]);

    /* #line 386 "./condition.dylan" */
    if ((&networkZnetwork_internalZCLS_ip_mreqn_HEAP == SLOT(L_temp_3.heapptr, heapptr_t, 0))) {

	/* #line 2537 "./sockets-api.dylan" */
	return L_temp_3.dataword.ptr;
    }
    else {

	/* #line 389 "./condition.dylan" */
	L_temp_4.heapptr = &networkZstr_ROOT_85;
	L_temp_4.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp_3, &networkZnetwork_internalZCLS_ip_mreqn_HEAP, L_temp_4);
	not_reached();
    }
}

/* generic-entry for pointer-value{<ip-mreqn>} */
descriptor_t * networkZnetwork_internalZpointer_value_METH_GENERIC_45(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    descriptor_t L_arg; /* arg */
    heapptr_t L_rest; /* rest */
    void * L_arg_2; /* arg */
    descriptor_t L_index; /* index */
    long L_index_2; /* index */
    descriptor_t L_key; /* key */
    descriptor_t L_value; /* value */
    void * L_result0; /* result0 */
    descriptor_t L_temp;

    /* #line {Class <unknown-source-location>} */
    L_args = ((void *)(orig_sp - A_nargs));
    L_arg = (((descriptor_t *)L_args)[0]);
    L_rest = dylanZdylan_visceraZmake_rest_arg_FUN(orig_sp, (descriptor_t *)L_args + 1, A_nargs - 1);
    L_arg_2 = L_arg.dataword.ptr;
    L_index.heapptr = networkZliteral_2.heapptr;
    L_index.dataword.l = 0;
    L_index_2 = (A_nargs - 2);
    while (1) {
	if ((L_index_2 < 1)) {
	    goto block0;
	}
	else {
	    L_key = (((descriptor_t *)L_args)[L_index_2]);
	    L_value = (((descriptor_t *)L_args)[(L_index_2 + 1)]);
	    if ((L_key.heapptr == &SYM_index_HEAP)) {
		L_index = L_value;
	    }
	    L_index_2 = (L_index_2 - 2);
	}
    }
  block0:;
    orig_sp = L_args;
    /* pointer-value{<ip-mreqn>} */
    L_result0 = networkZnetwork_internalZpointer_value_METH_45(orig_sp, L_arg_2, A_next_method_info, L_rest, L_index);
    L_temp.heapptr = networkZliteral_60.heapptr;
    L_temp.dataword.ptr = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* Define Method content-size{subclass(<ip-mreqn>)} */

/* content-size{subclass(<ip-mreqn>)} */
long networkZnetwork_internalZcontent_size_METH_58(descriptor_t *orig_sp, heapptr_t A0, heapptr_t A1)
{

    return 12;
}

/* generic-entry for content-size{subclass(<ip-mreqn>)} */
descriptor_t * networkZnetwork_internalZcontent_size_METH_GENERIC_58(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    long L_result0; /* result0 */
    descriptor_t L_temp;

    orig_sp = ((void *)(orig_sp - 1));
    /* content-size{subclass(<ip-mreqn>)} */
    L_result0 = networkZnetwork_internalZcontent_size_METH_58(orig_sp, &networkZnetwork_internalZCLS_ip_mreqn_HEAP, A_next_method_info);
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* Define Class <in-pktinfo> */

/* <in-pktinfo> is <in-pktinfo> */

extern struct heapobj networkZnetwork_internalZCLS_in_pktinfo_HEAP;

/* maker for <in-pktinfo> */
void * networkZnetwork_internalZCLS_in_pktinfo_MAKER_FUN(descriptor_t *orig_sp, void * A_pointer /* pointer */, int A_pointer_suppliedQUERY /* pointer-supplied? */)
{
    descriptor_t *cluster_0_top;


    /* #line 2544 "./sockets-api.dylan" */
    if (A_pointer_suppliedQUERY) {
	return A_pointer;
    }
    else {
	/* missing-required-init-keyword-error */
	dylanZdylan_visceraZmissing_required_init_keyword_error_FUN(orig_sp, &SYM_pointer_HEAP, &networkZnetwork_internalZCLS_in_pktinfo_HEAP);
	not_reached();
    }
}

extern descriptor_t networkZliteral_61;	/* proxy for <in-pktinfo> */

/* general-entry for maker for <in-pktinfo> */
descriptor_t * networkZnetwork_internalZCLS_in_pktinfo_MAKER_GENERAL(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    void * L_pointer; /* pointer */
    int L_pointer_suppliedQUERY; /* pointer-supplied? */
    long L_index; /* index */
    descriptor_t L_temp; /* temp */
    descriptor_t L_value; /* value */
    descriptor_t L_temp_2;
    descriptor_t L_temp_3;
    void * L_result0; /* result0 */
    descriptor_t L_temp_4;

    /* #line {Class <unknown-source-location>} */

    /* #line 126 "./cmp.dylan" */

    /* #line 209 "./num.dylan" */
    if (((A_nargs & 1) == 0)) {
	/* #line {Class <unknown-source-location>} */
	L_args = ((void *)(orig_sp - A_nargs));
	L_pointer = 0;
	L_pointer_suppliedQUERY = FALSE;
	L_index = (A_nargs - 2);
	while (1) {
	    if ((L_index < 0)) {
		goto block0;
	    }
	    else {
		L_temp = (((descriptor_t *)L_args)[L_index]);

		/* #line 386 "./condition.dylan" */
		if ((&dylanZdylan_visceraZCLS_symbol_HEAP == SLOT(L_temp.heapptr, heapptr_t, 0))) {
		    /* #line {Class <unknown-source-location>} */
		    L_value = (((descriptor_t *)L_args)[(L_index + 1)]);
		    if ((L_temp.heapptr == &SYM_pointer_HEAP)) {

			/* #line 386 "./condition.dylan" */
			if ((&dylanZdylan_visceraZCLS_raw_pointer_HEAP == SLOT(L_value.heapptr, heapptr_t, 0))) {
			    /* #line {Class <unknown-source-location>} */
			    L_pointer = L_value.dataword.ptr;
			    L_pointer_suppliedQUERY = TRUE;
			}
			else {

			    /* #line 389 "./condition.dylan" */
			    L_temp_2.heapptr = &networkZstr_ROOT;
			    L_temp_2.dataword.l = 0;
			    /* type-error-with-location */
			    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_value, &dylanZdylan_visceraZCLS_raw_pointer_HEAP, L_temp_2);
			    not_reached();
			}
		    }
		    /* #line {Class <unknown-source-location>} */
		    L_index = (L_index - 2);
		}
		else {

		    /* #line 389 "./condition.dylan" */
		    L_temp_3.heapptr = &networkZstr_ROOT;
		    L_temp_3.dataword.l = 0;
		    /* type-error-with-location */
		    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp, &dylanZdylan_visceraZCLS_symbol_HEAP, L_temp_3);
		    not_reached();
		}
	    }
	}
      block0:;
	/* #line {Class <unknown-source-location>} */
	orig_sp = L_args;
	/* maker for <in-pktinfo> */
	L_result0 = networkZnetwork_internalZCLS_in_pktinfo_MAKER_FUN(orig_sp, L_pointer, L_pointer_suppliedQUERY);
	L_temp_4.heapptr = networkZliteral_61.heapptr;
	L_temp_4.dataword.ptr = L_result0;
	orig_sp[0] = L_temp_4;
	return orig_sp + 1;
    }
    else {
	/* odd-number-of-keyword/value-arguments-error */
	dylanZdylan_visceraZodd_number_of_keywordSLASHvalue_arguments_error_FUN(orig_sp);
	not_reached();
    }
}


/* Define Sealed Domain make (singleton(<in-pktinfo>)) */


/* {Implicit} Define Generic get-ipi-ifindex */

/* get-ipi-ifindex is get-ipi-ifindex */


/* Define Method get-ipi-ifindex{<in-pktinfo>} */

/* get-ipi-ifindex{<in-pktinfo>} */
long networkZnetwork_internalZget_ipi_ifindex_METH(descriptor_t *orig_sp, void * A_ptr /* ptr */, heapptr_t A1)
{
    descriptor_t *cluster_0_top;


    /* #line 198 "./melange.dylan" */

    /* #line 91 "./rawptr.dylan" */
    return (*(long *)((char *)A_ptr + 0 ));
}


/* {Implicit} Define Generic get-ipi-ifindex-setter */

/* get-ipi-ifindex-setter is get-ipi-ifindex-setter */


/* Define Method get-ipi-ifindex-setter{<integer>, <in-pktinfo>} */

/* get-ipi-ifindex-setter{<integer>, <in-pktinfo>} */
long networkZnetwork_internalZget_ipi_ifindex_setter_METH(descriptor_t *orig_sp, long A_value /* value */, void * A_ptr /* ptr */, heapptr_t A2)
{
    descriptor_t *cluster_0_top;

    /* #line {Class <unknown-source-location>} */

    /* #line 97 "./rawptr.dylan" */
    *(long *)((char *)A_ptr + 0) = A_value;
    return A_value;
}


/* {Implicit} Define Generic get-ipi-spec-dst */

/* get-ipi-spec-dst is get-ipi-spec-dst */


/* Define Method get-ipi-spec-dst{<in-pktinfo>} */

extern struct heapobj networkZstr_ROOT_86;

/* get-ipi-spec-dst{<in-pktinfo>} */
void * networkZnetwork_internalZget_ipi_spec_dst_METH(descriptor_t *orig_sp, void * A_ptr /* ptr */, heapptr_t A1)
{
    descriptor_t *cluster_0_top;
    descriptor_t L_temp;
    descriptor_t L_temp_2;
    descriptor_t L_temp_3;
    descriptor_t L_temp_4; /* temp */
    int L_condition; /* condition */
    descriptor_t L_temp_5;
    descriptor_t L_temp_6; /* temp */
    descriptor_t L_temp_7;
    descriptor_t L_temp_8;

    /* #line {Class <unknown-source-location>} */

    /* #line 49 "./object.dylan" */
    L_temp.heapptr = networkZliteral_61.heapptr;
    L_temp.dataword.ptr = A_ptr;

    /* #line 324 "./melange.dylan" */

    /* #line 324 "./melange.dylan" */

    /* #line 324 "./melange.dylan" */
    L_temp_2.heapptr = SLOT(L_temp.heapptr, heapptr_t, 0);
    L_temp_2.dataword.l = 0;
    L_temp_3.heapptr = networkZliteral_6.heapptr;
    L_temp_3.dataword.ptr = ((void *)((char *)A_ptr + 4));
    orig_sp[0] = L_temp_2;
    orig_sp[1] = L_temp_3;
    /* as */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZas_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_temp_4 = orig_sp[0];

    /* #line 49 "./object.dylan" */

    /* #line 386 "./condition.dylan" */
    /* %subtype?{<class>, <class>} */
    L_condition = dylanZdylan_visceraZPCTsubtypeQUERY_METH(orig_sp, SLOT(L_temp_4.heapptr, heapptr_t, 0), &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP, &dylanZliteral_ROOT_2);
    if (L_condition) {

	/* #line 324 "./melange.dylan" */

	/* #line 2561 "./sockets-api.dylan" */
	L_temp_5.heapptr = &networkZnetwork_internalZCLS_in_addr_HEAP;
	L_temp_5.dataword.l = 0;
	orig_sp[0] = L_temp_5;
	orig_sp[1] = L_temp_4;
	/* as */
	{
	  struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZas_HEAP, 2);
	  heapptr_t L_meth = L_temp.R0;
	  heapptr_t L_next_info = L_temp.R1;
	  cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
	}
	L_temp_6 = orig_sp[0];

	/* #line 386 "./condition.dylan" */
	if ((&networkZnetwork_internalZCLS_in_addr_HEAP == SLOT(L_temp_6.heapptr, heapptr_t, 0))) {

	    /* #line 2561 "./sockets-api.dylan" */
	    return L_temp_6.dataword.ptr;
	}
	else {

	    /* #line 389 "./condition.dylan" */
	    L_temp_7.heapptr = &networkZstr_ROOT_86;
	    L_temp_7.dataword.l = 0;
	    /* type-error-with-location */
	    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp_6, &networkZnetwork_internalZCLS_in_addr_HEAP, L_temp_7);
	    not_reached();
	}
    }
    else {
	L_temp_8.heapptr = &networkZstr_ROOT_5;
	L_temp_8.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp_4, &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP, L_temp_8);
	not_reached();
    }
}


/* {Implicit} Define Generic get-ipi-addr */

/* get-ipi-addr is get-ipi-addr */


/* Define Method get-ipi-addr{<in-pktinfo>} */

extern struct heapobj networkZstr_ROOT_87;

/* get-ipi-addr{<in-pktinfo>} */
void * networkZnetwork_internalZget_ipi_addr_METH(descriptor_t *orig_sp, void * A_ptr /* ptr */, heapptr_t A1)
{
    descriptor_t *cluster_0_top;
    descriptor_t L_temp;
    descriptor_t L_temp_2;
    descriptor_t L_temp_3;
    descriptor_t L_temp_4; /* temp */
    int L_condition; /* condition */
    descriptor_t L_temp_5;
    descriptor_t L_temp_6; /* temp */
    descriptor_t L_temp_7;
    descriptor_t L_temp_8;

    /* #line {Class <unknown-source-location>} */

    /* #line 49 "./object.dylan" */
    L_temp.heapptr = networkZliteral_61.heapptr;
    L_temp.dataword.ptr = A_ptr;

    /* #line 324 "./melange.dylan" */

    /* #line 324 "./melange.dylan" */

    /* #line 324 "./melange.dylan" */
    L_temp_2.heapptr = SLOT(L_temp.heapptr, heapptr_t, 0);
    L_temp_2.dataword.l = 0;
    L_temp_3.heapptr = networkZliteral_6.heapptr;
    L_temp_3.dataword.ptr = ((void *)((char *)A_ptr + 8));
    orig_sp[0] = L_temp_2;
    orig_sp[1] = L_temp_3;
    /* as */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZas_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_temp_4 = orig_sp[0];

    /* #line 49 "./object.dylan" */

    /* #line 386 "./condition.dylan" */
    /* %subtype?{<class>, <class>} */
    L_condition = dylanZdylan_visceraZPCTsubtypeQUERY_METH(orig_sp, SLOT(L_temp_4.heapptr, heapptr_t, 0), &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP, &dylanZliteral_ROOT_2);
    if (L_condition) {

	/* #line 324 "./melange.dylan" */

	/* #line 2566 "./sockets-api.dylan" */
	L_temp_5.heapptr = &networkZnetwork_internalZCLS_in_addr_HEAP;
	L_temp_5.dataword.l = 0;
	orig_sp[0] = L_temp_5;
	orig_sp[1] = L_temp_4;
	/* as */
	{
	  struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZas_HEAP, 2);
	  heapptr_t L_meth = L_temp.R0;
	  heapptr_t L_next_info = L_temp.R1;
	  cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
	}
	L_temp_6 = orig_sp[0];

	/* #line 386 "./condition.dylan" */
	if ((&networkZnetwork_internalZCLS_in_addr_HEAP == SLOT(L_temp_6.heapptr, heapptr_t, 0))) {

	    /* #line 2566 "./sockets-api.dylan" */
	    return L_temp_6.dataword.ptr;
	}
	else {

	    /* #line 389 "./condition.dylan" */
	    L_temp_7.heapptr = &networkZstr_ROOT_87;
	    L_temp_7.dataword.l = 0;
	    /* type-error-with-location */
	    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp_6, &networkZnetwork_internalZCLS_in_addr_HEAP, L_temp_7);
	    not_reached();
	}
    }
    else {
	L_temp_8.heapptr = &networkZstr_ROOT_5;
	L_temp_8.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp_4, &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP, L_temp_8);
	not_reached();
    }
}


/* Define Method pointer-value{<in-pktinfo>} */

extern struct heapobj networkZstr_ROOT_88;

/* pointer-value{<in-pktinfo>} */
void * networkZnetwork_internalZpointer_value_METH_46(descriptor_t *orig_sp, void * A_value /* value */, heapptr_t A_next_method_info /* next-method-info */, heapptr_t A_rest /* rest */, descriptor_t A_index /* index */)
{
    descriptor_t *cluster_0_top;
    descriptor_t L_temp;
    descriptor_t L_arg1; /* arg1 */
    descriptor_t L_temp_2;
    descriptor_t L_temp_3; /* temp */
    descriptor_t L_temp_4;

    /* #line {Class <unknown-source-location>} */

    /* #line 2570 "./sockets-api.dylan" */
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = 12;
    orig_sp[0] = A_index;
    orig_sp[1] = L_temp;
    /* * */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZV_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_arg1 = (orig_sp == cluster_0_top ? dylanZfalse : orig_sp[0]);

    /* #line 2570 "./sockets-api.dylan" */
    L_temp_2.heapptr = networkZliteral_61.heapptr;
    L_temp_2.dataword.ptr = A_value;
    orig_sp[0] = L_temp_2;
    orig_sp[1] = L_arg1;
    /* + */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZPLUS_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_temp_3 = (orig_sp == cluster_0_top ? dylanZfalse : orig_sp[0]);

    /* #line 386 "./condition.dylan" */
    if ((&networkZnetwork_internalZCLS_in_pktinfo_HEAP == SLOT(L_temp_3.heapptr, heapptr_t, 0))) {

	/* #line 2570 "./sockets-api.dylan" */
	return L_temp_3.dataword.ptr;
    }
    else {

	/* #line 389 "./condition.dylan" */
	L_temp_4.heapptr = &networkZstr_ROOT_88;
	L_temp_4.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp_3, &networkZnetwork_internalZCLS_in_pktinfo_HEAP, L_temp_4);
	not_reached();
    }
}

/* generic-entry for pointer-value{<in-pktinfo>} */
descriptor_t * networkZnetwork_internalZpointer_value_METH_GENERIC_46(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    descriptor_t L_arg; /* arg */
    heapptr_t L_rest; /* rest */
    void * L_arg_2; /* arg */
    descriptor_t L_index; /* index */
    long L_index_2; /* index */
    descriptor_t L_key; /* key */
    descriptor_t L_value; /* value */
    void * L_result0; /* result0 */
    descriptor_t L_temp;

    /* #line {Class <unknown-source-location>} */
    L_args = ((void *)(orig_sp - A_nargs));
    L_arg = (((descriptor_t *)L_args)[0]);
    L_rest = dylanZdylan_visceraZmake_rest_arg_FUN(orig_sp, (descriptor_t *)L_args + 1, A_nargs - 1);
    L_arg_2 = L_arg.dataword.ptr;
    L_index.heapptr = networkZliteral_2.heapptr;
    L_index.dataword.l = 0;
    L_index_2 = (A_nargs - 2);
    while (1) {
	if ((L_index_2 < 1)) {
	    goto block0;
	}
	else {
	    L_key = (((descriptor_t *)L_args)[L_index_2]);
	    L_value = (((descriptor_t *)L_args)[(L_index_2 + 1)]);
	    if ((L_key.heapptr == &SYM_index_HEAP)) {
		L_index = L_value;
	    }
	    L_index_2 = (L_index_2 - 2);
	}
    }
  block0:;
    orig_sp = L_args;
    /* pointer-value{<in-pktinfo>} */
    L_result0 = networkZnetwork_internalZpointer_value_METH_46(orig_sp, L_arg_2, A_next_method_info, L_rest, L_index);
    L_temp.heapptr = networkZliteral_61.heapptr;
    L_temp.dataword.ptr = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* Define Method content-size{subclass(<in-pktinfo>)} */

/* content-size{subclass(<in-pktinfo>)} */
long networkZnetwork_internalZcontent_size_METH_59(descriptor_t *orig_sp, heapptr_t A0, heapptr_t A1)
{

    return 12;
}

/* generic-entry for content-size{subclass(<in-pktinfo>)} */
descriptor_t * networkZnetwork_internalZcontent_size_METH_GENERIC_59(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    long L_result0; /* result0 */
    descriptor_t L_temp;

    orig_sp = ((void *)(orig_sp - 1));
    /* content-size{subclass(<in-pktinfo>)} */
    L_result0 = networkZnetwork_internalZcontent_size_METH_59(orig_sp, &networkZnetwork_internalZCLS_in_pktinfo_HEAP, A_next_method_info);
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* Define Constant $IP-TOS */

/* $IP-TOS is 1 */


/* Define Constant $IP-TTL */

/* $IP-TTL is 2 */


/* Define Constant $IP-HDRINCL */

/* $IP-HDRINCL is 3 */


/* Define Constant $IP-OPTIONS */

/* $IP-OPTIONS is 4 */


/* Define Constant $IP-ROUTER-ALERT */

/* $IP-ROUTER-ALERT is 5 */


/* Define Constant $IP-RECVOPTS */

/* $IP-RECVOPTS is 6 */


/* Define Constant $IP-RETOPTS */

/* $IP-RETOPTS is 7 */


/* Define Constant $IP-PKTINFO */

/* $IP-PKTINFO is 8 */


/* Define Constant $IP-PKTOPTIONS */

/* $IP-PKTOPTIONS is 9 */


/* Define Constant $IP-PMTUDISC */

/* $IP-PMTUDISC is 10 */


/* Define Constant $IP-MTU-DISCOVER */

/* $IP-MTU-DISCOVER is 10 */


/* Define Constant $IP-RECVERR */

/* $IP-RECVERR is 11 */


/* Define Constant $IP-RECVTTL */

/* $IP-RECVTTL is 12 */


/* Define Constant $IP-RECVTOS */

/* $IP-RECVTOS is 13 */


/* Define Constant $IP-MULTICAST-IF */

/* $IP-MULTICAST-IF is 32 */


/* Define Constant $IP-MULTICAST-TTL */

/* $IP-MULTICAST-TTL is 33 */


/* Define Constant $IP-MULTICAST-LOOP */

/* $IP-MULTICAST-LOOP is 34 */


/* Define Constant $IP-ADD-MEMBERSHIP */

/* $IP-ADD-MEMBERSHIP is 35 */


/* Define Constant $IP-DROP-MEMBERSHIP */

/* $IP-DROP-MEMBERSHIP is 36 */


/* Define Constant $IP-RECVRETOPTS */

/* $IP-RECVRETOPTS is 7 */


/* Define Constant $IP-PMTUDISC-DONT */

/* $IP-PMTUDISC-DONT is 0 */


/* Define Constant $IP-PMTUDISC-WANT */

/* $IP-PMTUDISC-WANT is 1 */


/* Define Constant $IP-PMTUDISC-DO */

/* $IP-PMTUDISC-DO is 2 */


/* Define Constant $SOL-IP */

/* $SOL-IP is 0 */


/* Define Constant $IP-DEFAULT-MULTICAST-TTL */

/* $IP-DEFAULT-MULTICAST-TTL is 1 */


/* Define Constant $IP-DEFAULT-MULTICAST-LOOP */

/* $IP-DEFAULT-MULTICAST-LOOP is 1 */


/* Define Constant $IP-MAX-MEMBERSHIPS */

/* $IP-MAX-MEMBERSHIPS is 20 */


/* Define Constant $IPV6-ADDRFORM */

/* $IPV6-ADDRFORM is 1 */


/* Define Constant $IPV6-PKTINFO */

/* $IPV6-PKTINFO is 2 */


/* Define Constant $IPV6-HOPOPTS */

/* $IPV6-HOPOPTS is 3 */


/* Define Constant $IPV6-DSTOPTS */

/* $IPV6-DSTOPTS is 4 */


/* Define Constant $IPV6-RTHDR */

/* $IPV6-RTHDR is 5 */


/* Define Constant $IPV6-PKTOPTIONS */

/* $IPV6-PKTOPTIONS is 6 */


/* Define Constant $IPV6-CHECKSUM */

/* $IPV6-CHECKSUM is 7 */


/* Define Constant $IPV6-HOPLIMIT */

/* $IPV6-HOPLIMIT is 8 */


/* Define Constant $IPV6-NEXTHOP */

/* $IPV6-NEXTHOP is 9 */


/* Define Constant $IPV6-AUTHHDR */

/* $IPV6-AUTHHDR is 10 */


/* Define Constant $IPV6-UNICAST-HOPS */

/* $IPV6-UNICAST-HOPS is 16 */


/* Define Constant $IPV6-MULTICAST-IF */

/* $IPV6-MULTICAST-IF is 17 */


/* Define Constant $IPV6-MULTICAST-HOPS */

/* $IPV6-MULTICAST-HOPS is 18 */


/* Define Constant $IPV6-MULTICAST-LOOP */

/* $IPV6-MULTICAST-LOOP is 19 */


/* Define Constant $IPV6-JOIN-GROUP */

/* $IPV6-JOIN-GROUP is 20 */


/* Define Constant $IPV6-LEAVE-GROUP */

/* $IPV6-LEAVE-GROUP is 21 */


/* Define Constant $IPV6-ROUTER-ALERT */

/* $IPV6-ROUTER-ALERT is 22 */


/* Define Constant $IPV6-MTU-DISCOVER */

/* $IPV6-MTU-DISCOVER is 23 */


/* Define Constant $IPV6-MTU */

/* $IPV6-MTU is 24 */


/* Define Constant $IPV6-RECVERR */

/* $IPV6-RECVERR is 25 */


/* Define Constant $IPV6-RXHOPOPTS */

/* $IPV6-RXHOPOPTS is 3 */


/* Define Constant $IPV6-RXDSTOPTS */

/* $IPV6-RXDSTOPTS is 4 */


/* Define Constant $IPV6-ADD-MEMBERSHIP */

/* $IPV6-ADD-MEMBERSHIP is 20 */


/* Define Constant $IPV6-DROP-MEMBERSHIP */

/* $IPV6-DROP-MEMBERSHIP is 21 */


/* Define Constant $IPV6-PMTUDISC-DONT */

/* $IPV6-PMTUDISC-DONT is 0 */


/* Define Constant $IPV6-PMTUDISC-WANT */

/* $IPV6-PMTUDISC-WANT is 1 */


/* Define Constant $IPV6-PMTUDISC-DO */

/* $IPV6-PMTUDISC-DO is 2 */


/* Define Constant $SOL-IPV6 */

/* $SOL-IPV6 is 41 */


/* Define Constant $SOL-ICMPV6 */

/* $SOL-ICMPV6 is 58 */


/* Define Constant $IPV6-RTHDR-LOOSE */

/* $IPV6-RTHDR-LOOSE is 0 */


/* Define Constant $IPV6-RTHDR-STRICT */

/* $IPV6-RTHDR-STRICT is 1 */


/* Define Constant $IPV6-RTHDR-TYPE-0 */

/* $IPV6-RTHDR-TYPE-0 is 0 */


/* Define Constant <int8-t> */

/* <int8-t> is <integer> */


/* Define Constant <int16-t> */

/* <int16-t> is <integer> */


/* Define Constant <int32-t> */

/* <int32-t> is <integer> */


/* Define Constant <int64-t> */

/* <int64-t> is <double-integer> */


/* Define Constant <uint64-t> */

/* <uint64-t> is <double-integer> */


/* Define Constant <int-least8-t> */

/* <int-least8-t> is <integer> */


/* Define Constant <int-least16-t> */

/* <int-least16-t> is <integer> */


/* Define Constant <int-least32-t> */

/* <int-least32-t> is <integer> */


/* Define Constant <int-least64-t> */

/* <int-least64-t> is <double-integer> */


/* Define Constant <uint-least8-t> */

/* <uint-least8-t> is <integer> */


/* Define Constant <uint-least16-t> */

/* <uint-least16-t> is <integer> */


/* Define Constant <uint-least32-t> */

/* <uint-least32-t> is <integer> */


/* Define Constant <uint-least64-t> */

/* <uint-least64-t> is <double-integer> */


/* Define Constant <int-fast8-t> */

/* <int-fast8-t> is <integer> */


/* Define Constant <int-fast16-t> */

/* <int-fast16-t> is <integer> */


/* Define Constant <int-fast32-t> */

/* <int-fast32-t> is <integer> */


/* Define Constant <int-fast64-t> */

/* <int-fast64-t> is <double-integer> */


/* Define Constant <uint-fast8-t> */

/* <uint-fast8-t> is <integer> */


/* Define Constant <uint-fast16-t> */

/* <uint-fast16-t> is <integer> */


/* Define Constant <uint-fast32-t> */

/* <uint-fast32-t> is <integer> */


/* Define Constant <uint-fast64-t> */

/* <uint-fast64-t> is <double-integer> */


/* Define Constant <intptr-t> */

/* <intptr-t> is <integer> */


/* Define Constant <uintptr-t> */

/* <uintptr-t> is <integer> */


/* Define Constant <intmax-t> */

/* <intmax-t> is <double-integer> */


/* Define Constant <uintmax-t> */

/* <uintmax-t> is <double-integer> */


/* Define Constant $_STDINT-H */

/* $_STDINT-H is 1 */


/* Define Constant $INT8-MIN */

/* $INT8-MIN is -128 */


/* Define Constant $INT16-MIN */

/* $INT16-MIN is -32768 */


/* Define Constant $INT32-MIN */

/* $INT32-MIN is -2147483648 */


/* Define Constant $INT64-MIN */

/* $INT64-MIN is #e-9223372036854775808 */


/* Define Constant $INT8-MAX */

/* $INT8-MAX is 127 */


/* Define Constant $INT16-MAX */

/* $INT16-MAX is 32767 */


/* Define Constant $INT32-MAX */

/* $INT32-MAX is 2147483647 */


/* Define Constant $INT64-MAX */

/* $INT64-MAX is #e9223372036854775807 */


/* Define Constant $UINT8-MAX */

/* $UINT8-MAX is 255 */


/* Define Constant $UINT16-MAX */

/* $UINT16-MAX is 65535 */


/* Define Constant $UINT32-MAX */

/* $UINT32-MAX is #e4294967295 */


/* Define Constant $UINT64-MAX */

/* $UINT64-MAX is #e18446744073709551615 */


/* Define Constant $INT-LEAST8-MIN */

/* $INT-LEAST8-MIN is -128 */


/* Define Constant $INT-LEAST16-MIN */

/* $INT-LEAST16-MIN is -32768 */


/* Define Constant $INT-LEAST32-MIN */

/* $INT-LEAST32-MIN is -2147483648 */


/* Define Constant $INT-LEAST64-MIN */

/* $INT-LEAST64-MIN is #e-9223372036854775808 */


/* Define Constant $INT-LEAST8-MAX */

/* $INT-LEAST8-MAX is 127 */


/* Define Constant $INT-LEAST16-MAX */

/* $INT-LEAST16-MAX is 32767 */


/* Define Constant $INT-LEAST32-MAX */

/* $INT-LEAST32-MAX is 2147483647 */


/* Define Constant $INT-LEAST64-MAX */

/* $INT-LEAST64-MAX is #e9223372036854775807 */


/* Define Constant $UINT-LEAST8-MAX */

/* $UINT-LEAST8-MAX is 255 */


/* Define Constant $UINT-LEAST16-MAX */

/* $UINT-LEAST16-MAX is 65535 */


/* Define Constant $UINT-LEAST32-MAX */

/* $UINT-LEAST32-MAX is #e4294967295 */


/* Define Constant $UINT-LEAST64-MAX */

/* $UINT-LEAST64-MAX is #e18446744073709551615 */


/* Define Constant $INT-FAST8-MIN */

/* $INT-FAST8-MIN is -128 */


/* Define Constant $INT-FAST16-MIN */

/* $INT-FAST16-MIN is -2147483648 */


/* Define Constant $INT-FAST32-MIN */

/* $INT-FAST32-MIN is -2147483648 */


/* Define Constant $INT-FAST64-MIN */

/* $INT-FAST64-MIN is #e-9223372036854775808 */


/* Define Constant $INT-FAST8-MAX */

/* $INT-FAST8-MAX is 127 */


/* Define Constant $INT-FAST16-MAX */

/* $INT-FAST16-MAX is 2147483647 */


/* Define Constant $INT-FAST32-MAX */

/* $INT-FAST32-MAX is 2147483647 */


/* Define Constant $INT-FAST64-MAX */

/* $INT-FAST64-MAX is #e9223372036854775807 */


/* Define Constant $UINT-FAST8-MAX */

/* $UINT-FAST8-MAX is 255 */


/* Define Constant $UINT-FAST16-MAX */

/* $UINT-FAST16-MAX is #e4294967295 */


/* Define Constant $UINT-FAST32-MAX */

/* $UINT-FAST32-MAX is #e4294967295 */


/* Define Constant $UINT-FAST64-MAX */

/* $UINT-FAST64-MAX is #e18446744073709551615 */


/* Define Constant $INTPTR-MIN */

/* $INTPTR-MIN is -2147483648 */


/* Define Constant $INTPTR-MAX */

/* $INTPTR-MAX is 2147483647 */


/* Define Constant $UINTPTR-MAX */

/* $UINTPTR-MAX is #e4294967295 */


/* Define Constant $INTMAX-MIN */

/* $INTMAX-MIN is #e-9223372036854775808 */


/* Define Constant $INTMAX-MAX */

/* $INTMAX-MAX is #e9223372036854775807 */


/* Define Constant $UINTMAX-MAX */

/* $UINTMAX-MAX is #e18446744073709551615 */


/* Define Constant $PTRDIFF-MIN */

/* $PTRDIFF-MIN is -2147483648 */


/* Define Constant $PTRDIFF-MAX */

/* $PTRDIFF-MAX is 2147483647 */


/* Define Constant $SIG-ATOMIC-MIN */

/* $SIG-ATOMIC-MIN is -2147483648 */


/* Define Constant $SIG-ATOMIC-MAX */

/* $SIG-ATOMIC-MAX is 2147483647 */


/* Define Constant $SIZE-MAX */

/* $SIZE-MAX is #e4294967295 */


/* Define Constant $WCHAR-MIN */

/* $WCHAR-MIN is -2147483648 */


/* Define Constant $WCHAR-MAX */

/* $WCHAR-MAX is 2147483647 */


/* Define Constant $WINT-MIN */

/* $WINT-MIN is 0 */


/* Define Constant $WINT-MAX */

/* $WINT-MAX is #e4294967295 */


/* Define Constant $_BITS-WCHAR-H */

/* $_BITS-WCHAR-H is 1 */


/* Define Constant $__WCHAR-MIN */

/* $__WCHAR-MIN is -2147483648 */


/* Define Constant $__WCHAR-MAX */

/* $__WCHAR-MAX is 2147483647 */


/* {Implicit} Define Generic __h-errno-location */

/* __h-errno-location is __h-errno-location */


/* Define Method __h-errno-location{} */

extern struct heapobj networkZstr_ROOT_89;

/* __h-errno-location{} */
descriptor_t networkZnetwork_internalZX_X_h_errno_location_METH(descriptor_t *orig_sp, heapptr_t A0)
{
    descriptor_t *cluster_0_top;
    void * L_result_value; /* result-value */
    heapptr_t L_instance; /* instance */
    descriptor_t L_temp;
    descriptor_t L_temp_2;
    descriptor_t L_temp_3;
    descriptor_t L_result_value_2; /* result-value */
    heapptr_t L_PCTobject_class; /* %object-class */
    int L_temp_4; /* temp */
    descriptor_t L_temp_5;


    /* #line 735 "./macros.dylan" */
    L_result_value = __h_errno_location();

    /* #line 2860 "./sockets-api.dylan" */
    /* maker for <simple-object-vector> */
    L_instance = dylanZdylan_visceraZCLS_simple_object_vector_MAKER_FUN(orig_sp, 2, dylanZfalse);
    L_temp.heapptr = &SYM_pointer_HEAP;
    L_temp.dataword.l = 0;
    SLOT(L_instance, descriptor_t, 8 + 0 * sizeof(descriptor_t)) = L_temp;
    L_temp_2.heapptr = networkZliteral_6.heapptr;
    L_temp_2.dataword.ptr = L_result_value;
    SLOT(L_instance, descriptor_t, 8 + 1 * sizeof(descriptor_t)) = L_temp_2;
    L_temp_3.heapptr = networkZliteral_6.heapptr;
    L_temp_3.dataword.ptr = L_result_value;
    /* make{subclass(<statically-typed-pointer>)} */
    L_result_value_2 = melange_supportZmelange_supportZmake_METH(orig_sp, &networkZnetwork_internalZCLS_intV_HEAP, &networkZliteral_ROOT, L_instance, 0, L_temp_3, 1);

    /* #line 386 "./condition.dylan" */
    L_PCTobject_class = SLOT(L_result_value_2.heapptr, heapptr_t, 0);
    if ((&networkZnetwork_internalZCLS_intLESSX402GREATER_HEAP == L_PCTobject_class)) {
	L_temp_4 = TRUE;
    }
    else {
	L_temp_4 = (&networkZnetwork_internalZCLS_intV_HEAP == L_PCTobject_class);
    }
    if (L_temp_4) {

	/* #line 2861 "./sockets-api.dylan" */
	return L_result_value_2;
    }
    else {

	/* #line 389 "./condition.dylan" */
	L_temp_5.heapptr = &networkZstr_ROOT_89;
	L_temp_5.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_result_value_2, &networkZnetwork_internalZCLS_intV_HEAP, L_temp_5);
	not_reached();
    }
}


/* {Implicit} Define Generic herror */

/* herror is herror */


/* Define Method herror{<c-char-vector>} */

/* herror{<c-char-vector>} */
void networkZnetwork_internalZherror_METH(descriptor_t *orig_sp, descriptor_t A_arg1 /* arg1 */, heapptr_t A1)
{
    descriptor_t *cluster_0_top;

    /* #line {Class <unknown-source-location>} */

    /* #line 2867 "./sockets-api.dylan" */

    /* #line 735 "./macros.dylan" */
    herror(A_arg1.dataword.ptr);
    return;
}


/* {Implicit} Define Generic hstrerror */

/* hstrerror is hstrerror */


/* Define Method hstrerror{<integer>} */

extern struct heapobj networkZstr_ROOT_90;

/* hstrerror{<integer>} */
descriptor_t networkZnetwork_internalZhstrerror_METH(descriptor_t *orig_sp, long A_arg1 /* arg1 */, heapptr_t A1)
{
    descriptor_t *cluster_0_top;
    void * L_result_value; /* result-value */
    heapptr_t L_instance; /* instance */
    descriptor_t L_temp;
    descriptor_t L_temp_2;
    descriptor_t L_temp_3;
    descriptor_t L_result_value_2; /* result-value */
    heapptr_t L_PCTobject_class; /* %object-class */
    int L_temp_4; /* temp */
    descriptor_t L_temp_5;

    /* #line {Class <unknown-source-location>} */

    /* #line 735 "./macros.dylan" */
    L_result_value = hstrerror(A_arg1);

    /* #line 2876 "./sockets-api.dylan" */
    /* maker for <simple-object-vector> */
    L_instance = dylanZdylan_visceraZCLS_simple_object_vector_MAKER_FUN(orig_sp, 2, dylanZfalse);
    L_temp.heapptr = &SYM_pointer_HEAP;
    L_temp.dataword.l = 0;
    SLOT(L_instance, descriptor_t, 8 + 0 * sizeof(descriptor_t)) = L_temp;
    L_temp_2.heapptr = networkZliteral_6.heapptr;
    L_temp_2.dataword.ptr = L_result_value;
    SLOT(L_instance, descriptor_t, 8 + 1 * sizeof(descriptor_t)) = L_temp_2;
    L_temp_3.heapptr = networkZliteral_6.heapptr;
    L_temp_3.dataword.ptr = L_result_value;
    /* make{subclass(<statically-typed-pointer>)} */
    L_result_value_2 = melange_supportZmelange_supportZmake_METH(orig_sp, &networkZnetwork_internalZCLS_c_char_vector_HEAP, &networkZliteral_ROOT, L_instance, 0, L_temp_3, 1);

    /* #line 386 "./condition.dylan" */
    L_PCTobject_class = SLOT(L_result_value_2.heapptr, heapptr_t, 0);
    if ((&networkZnetwork_internalZCLS_charLESSX4040GREATER_HEAP == L_PCTobject_class)) {
	L_temp_4 = TRUE;
    }
    else if ((&networkZnetwork_internalZCLS_charLESSX40120GREATER_HEAP == L_PCTobject_class)) {
	L_temp_4 = TRUE;
    }
    else if ((&networkZnetwork_internalZCLS_charLESSX4014GREATER_HEAP == L_PCTobject_class)) {
	L_temp_4 = TRUE;
    }
    else {
	L_temp_4 = (&networkZnetwork_internalZCLS_c_char_vector_HEAP == L_PCTobject_class);
    }
    if (L_temp_4) {

	/* #line 2877 "./sockets-api.dylan" */
	return L_result_value_2;
    }
    else {

	/* #line 389 "./condition.dylan" */
	L_temp_5.heapptr = &networkZstr_ROOT_90;
	L_temp_5.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_result_value_2, &networkZnetwork_internalZCLS_c_char_vector_HEAP, L_temp_5);
	not_reached();
    }
}


/* Define Class <c-char-pointer-vector> */

/* <c-char-pointer-vector> is <c-char-pointer-vector> */

extern struct heapobj networkZnetwork_internalZCLS_c_char_pointer_vector_HEAP;

/* maker for <c-char-pointer-vector> */
void * networkZnetwork_internalZCLS_c_char_pointer_vector_MAKER_FUN(descriptor_t *orig_sp, void * A_pointer /* pointer */, int A_pointer_suppliedQUERY /* pointer-supplied? */)
{
    descriptor_t *cluster_0_top;


    /* #line 2880 "./sockets-api.dylan" */
    if (A_pointer_suppliedQUERY) {
	return A_pointer;
    }
    else {
	/* missing-required-init-keyword-error */
	dylanZdylan_visceraZmissing_required_init_keyword_error_FUN(orig_sp, &SYM_pointer_HEAP, &networkZnetwork_internalZCLS_c_char_pointer_vector_HEAP);
	not_reached();
    }
}

extern descriptor_t networkZliteral_62;	/* proxy for <c-char-pointer-vector> */

/* general-entry for maker for <c-char-pointer-vector> */
descriptor_t * networkZnetwork_internalZCLS_c_char_pointer_vector_MAKER_GENERAL(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    void * L_pointer; /* pointer */
    int L_pointer_suppliedQUERY; /* pointer-supplied? */
    long L_index; /* index */
    descriptor_t L_temp; /* temp */
    descriptor_t L_value; /* value */
    descriptor_t L_temp_2;
    descriptor_t L_temp_3;
    void * L_result0; /* result0 */
    descriptor_t L_temp_4;

    /* #line {Class <unknown-source-location>} */

    /* #line 126 "./cmp.dylan" */

    /* #line 209 "./num.dylan" */
    if (((A_nargs & 1) == 0)) {
	/* #line {Class <unknown-source-location>} */
	L_args = ((void *)(orig_sp - A_nargs));
	L_pointer = 0;
	L_pointer_suppliedQUERY = FALSE;
	L_index = (A_nargs - 2);
	while (1) {
	    if ((L_index < 0)) {
		goto block0;
	    }
	    else {
		L_temp = (((descriptor_t *)L_args)[L_index]);

		/* #line 386 "./condition.dylan" */
		if ((&dylanZdylan_visceraZCLS_symbol_HEAP == SLOT(L_temp.heapptr, heapptr_t, 0))) {
		    /* #line {Class <unknown-source-location>} */
		    L_value = (((descriptor_t *)L_args)[(L_index + 1)]);
		    if ((L_temp.heapptr == &SYM_pointer_HEAP)) {

			/* #line 386 "./condition.dylan" */
			if ((&dylanZdylan_visceraZCLS_raw_pointer_HEAP == SLOT(L_value.heapptr, heapptr_t, 0))) {
			    /* #line {Class <unknown-source-location>} */
			    L_pointer = L_value.dataword.ptr;
			    L_pointer_suppliedQUERY = TRUE;
			}
			else {

			    /* #line 389 "./condition.dylan" */
			    L_temp_2.heapptr = &networkZstr_ROOT;
			    L_temp_2.dataword.l = 0;
			    /* type-error-with-location */
			    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_value, &dylanZdylan_visceraZCLS_raw_pointer_HEAP, L_temp_2);
			    not_reached();
			}
		    }
		    /* #line {Class <unknown-source-location>} */
		    L_index = (L_index - 2);
		}
		else {

		    /* #line 389 "./condition.dylan" */
		    L_temp_3.heapptr = &networkZstr_ROOT;
		    L_temp_3.dataword.l = 0;
		    /* type-error-with-location */
		    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp, &dylanZdylan_visceraZCLS_symbol_HEAP, L_temp_3);
		    not_reached();
		}
	    }
	}
      block0:;
	/* #line {Class <unknown-source-location>} */
	orig_sp = L_args;
	/* maker for <c-char-pointer-vector> */
	L_result0 = networkZnetwork_internalZCLS_c_char_pointer_vector_MAKER_FUN(orig_sp, L_pointer, L_pointer_suppliedQUERY);
	L_temp_4.heapptr = networkZliteral_62.heapptr;
	L_temp_4.dataword.ptr = L_result0;
	orig_sp[0] = L_temp_4;
	return orig_sp + 1;
    }
    else {
	/* odd-number-of-keyword/value-arguments-error */
	dylanZdylan_visceraZodd_number_of_keywordSLASHvalue_arguments_error_FUN(orig_sp);
	not_reached();
    }
}


/* Define Sealed Domain make (singleton(<c-char-pointer-vector>)) */


/* Define Method pointer-value{<c-char-pointer-vector>} */

extern struct heapobj networkZstr_ROOT_91;

/* pointer-value{<c-char-pointer-vector>} */
descriptor_t networkZnetwork_internalZpointer_value_METH_47(descriptor_t *orig_sp, void * A_ptr /* ptr */, heapptr_t A_next_method_info /* next-method-info */, heapptr_t A_rest /* rest */, descriptor_t A_index /* index */)
{
    descriptor_t *cluster_0_top;
    descriptor_t L_temp;
    descriptor_t L_arg2; /* arg2 */
    descriptor_t L_temp_2;
    descriptor_t L_temp_3;
    descriptor_t L_temp_4; /* temp */
    int L_condition; /* condition */
    descriptor_t L_result; /* result */
    heapptr_t L_PCTobject_class; /* %object-class */
    int L_temp_5; /* temp */
    descriptor_t L_temp_6;
    descriptor_t L_temp_7;
    descriptor_t L_temp_8;


    /* #line 2887 "./sockets-api.dylan" */
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = 4;
    orig_sp[0] = A_index;
    orig_sp[1] = L_temp;
    /* * */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZV_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_arg2 = (orig_sp == cluster_0_top ? dylanZfalse : orig_sp[0]);

    /* #line 386 "./condition.dylan" */
    if ((&dylanZdylan_visceraZCLS_integer_HEAP == SLOT(L_arg2.heapptr, heapptr_t, 0))) {

	/* #line 2887 "./sockets-api.dylan" */

	/* #line 290 "./melange.dylan" */

	/* #line 91 "./rawptr.dylan" */

	/* #line 290 "./melange.dylan" */
	L_temp_2.heapptr = &networkZnetwork_internalZCLS_c_char_vector_HEAP;
	L_temp_2.dataword.l = 0;
	L_temp_3.heapptr = networkZliteral_6.heapptr;
	L_temp_3.dataword.ptr = (*(void * *)((char *)A_ptr + L_arg2.dataword.l ));
	orig_sp[0] = L_temp_2;
	orig_sp[1] = L_temp_3;
	/* as */
	{
	  struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZas_HEAP, 2);
	  heapptr_t L_meth = L_temp.R0;
	  heapptr_t L_next_info = L_temp.R1;
	  cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
	}
	L_temp_4 = orig_sp[0];

	/* #line 49 "./object.dylan" */

	/* #line 386 "./condition.dylan" */
	/* %subtype?{<class>, <class>} */
	L_condition = dylanZdylan_visceraZPCTsubtypeQUERY_METH(orig_sp, SLOT(L_temp_4.heapptr, heapptr_t, 0), &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP, &dylanZliteral_ROOT_2);
	if (L_condition) {

	    /* #line 290 "./melange.dylan" */
	    L_result = L_temp_4;

	    /* #line 386 "./condition.dylan" */
	    L_PCTobject_class = SLOT(L_result.heapptr, heapptr_t, 0);
	    if ((&networkZnetwork_internalZCLS_charLESSX4040GREATER_HEAP == L_PCTobject_class)) {
		L_temp_5 = TRUE;
	    }
	    else if ((&networkZnetwork_internalZCLS_charLESSX40120GREATER_HEAP == L_PCTobject_class)) {
		L_temp_5 = TRUE;
	    }
	    else if ((&networkZnetwork_internalZCLS_charLESSX4014GREATER_HEAP == L_PCTobject_class)) {
		L_temp_5 = TRUE;
	    }
	    else {
		L_temp_5 = (&networkZnetwork_internalZCLS_c_char_vector_HEAP == L_PCTobject_class);
	    }
	    if (L_temp_5) {

		/* #line 2887 "./sockets-api.dylan" */
		return L_result;
	    }
	    else {

		/* #line 389 "./condition.dylan" */
		L_temp_6.heapptr = &networkZstr_ROOT_91;
		L_temp_6.dataword.l = 0;
		/* type-error-with-location */
		dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_result, &networkZnetwork_internalZCLS_c_char_vector_HEAP, L_temp_6);
		not_reached();
	    }
	}
	else {
	    L_temp_7.heapptr = &networkZstr_ROOT_14;
	    L_temp_7.dataword.l = 0;
	    /* type-error-with-location */
	    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp_4, &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP, L_temp_7);
	    not_reached();
	}
    }
    else {
	L_temp_8.heapptr = &networkZstr_ROOT_91;
	L_temp_8.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_arg2, &dylanZdylan_visceraZCLS_integer_HEAP, L_temp_8);
	not_reached();
    }
}

/* generic-entry for pointer-value{<c-char-pointer-vector>} */
descriptor_t * networkZnetwork_internalZpointer_value_METH_GENERIC_47(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    descriptor_t L_arg; /* arg */
    heapptr_t L_rest; /* rest */
    void * L_arg_2; /* arg */
    descriptor_t L_index; /* index */
    long L_index_2; /* index */
    descriptor_t L_key; /* key */
    descriptor_t L_value; /* value */
    descriptor_t L_result0; /* result0 */

    /* #line {Class <unknown-source-location>} */
    L_args = ((void *)(orig_sp - A_nargs));
    L_arg = (((descriptor_t *)L_args)[0]);
    L_rest = dylanZdylan_visceraZmake_rest_arg_FUN(orig_sp, (descriptor_t *)L_args + 1, A_nargs - 1);
    L_arg_2 = L_arg.dataword.ptr;
    L_index.heapptr = networkZliteral_2.heapptr;
    L_index.dataword.l = 0;
    L_index_2 = (A_nargs - 2);
    while (1) {
	if ((L_index_2 < 1)) {
	    goto block0;
	}
	else {
	    L_key = (((descriptor_t *)L_args)[L_index_2]);
	    L_value = (((descriptor_t *)L_args)[(L_index_2 + 1)]);
	    if ((L_key.heapptr == &SYM_index_HEAP)) {
		L_index = L_value;
	    }
	    L_index_2 = (L_index_2 - 2);
	}
    }
  block0:;
    orig_sp = L_args;
    /* pointer-value{<c-char-pointer-vector>} */
    L_result0 = networkZnetwork_internalZpointer_value_METH_47(orig_sp, L_arg_2, A_next_method_info, L_rest, L_index);
    orig_sp[0] = L_result0;
    return orig_sp + 1;
}


/* Define Method pointer-value-setter{<c-char-vector>, <c-char-pointer-vector>} */

/* pointer-value-setter{<c-char-vector>, <c-char-pointer-vector>} */
descriptor_t networkZnetwork_internalZpointer_value_setter_METH_12(descriptor_t *orig_sp, descriptor_t A_value /* value */, void * A_ptr /* ptr */, heapptr_t A_next_method_info /* next-method-info */, heapptr_t A_rest /* rest */, descriptor_t A_index /* index */)
{
    descriptor_t *cluster_0_top;
    descriptor_t L_temp;
    descriptor_t L_arg3; /* arg3 */
    descriptor_t L_temp_2;


    /* #line 2893 "./sockets-api.dylan" */
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = 4;
    orig_sp[0] = A_index;
    orig_sp[1] = L_temp;
    /* * */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZV_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_arg3 = (orig_sp == cluster_0_top ? dylanZfalse : orig_sp[0]);

    /* #line 386 "./condition.dylan" */
    if ((&dylanZdylan_visceraZCLS_integer_HEAP == SLOT(L_arg3.heapptr, heapptr_t, 0))) {
	/* #line {Class <unknown-source-location>} */

	/* #line 299 "./melange.dylan" */
	/* #line {Class <unknown-source-location>} */

	/* #line 97 "./rawptr.dylan" */
	*(void * *)((char *)A_ptr + L_arg3.dataword.l) = A_value.dataword.ptr;
	return A_value;
    }
    else {

	/* #line 389 "./condition.dylan" */
	L_temp_2.heapptr = &networkZstr_ROOT;
	L_temp_2.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_arg3, &dylanZdylan_visceraZCLS_integer_HEAP, L_temp_2);
	not_reached();
    }
}

/* generic-entry for pointer-value-setter{<c-char-vector>, <c-char-pointer-vector>} */
descriptor_t * networkZnetwork_internalZpointer_value_setter_METH_GENERIC_12(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    descriptor_t L_arg; /* arg */
    descriptor_t L_arg_2; /* arg */
    heapptr_t L_rest; /* rest */
    descriptor_t L_arg_3; /* arg */
    void * L_arg_4; /* arg */
    descriptor_t L_index; /* index */
    long L_index_2; /* index */
    descriptor_t L_key; /* key */
    descriptor_t L_value; /* value */
    descriptor_t L_result0; /* result0 */

    /* #line {Class <unknown-source-location>} */
    L_args = ((void *)(orig_sp - A_nargs));
    L_arg = (((descriptor_t *)L_args)[0]);
    L_arg_2 = (((descriptor_t *)L_args)[1]);
    L_rest = dylanZdylan_visceraZmake_rest_arg_FUN(orig_sp, (descriptor_t *)L_args + 2, A_nargs - 2);
    L_arg_3 = L_arg;
    L_arg_4 = L_arg_2.dataword.ptr;
    L_index.heapptr = networkZliteral_2.heapptr;
    L_index.dataword.l = 0;
    L_index_2 = (A_nargs - 2);
    while (1) {
	if ((L_index_2 < 2)) {
	    goto block0;
	}
	else {
	    L_key = (((descriptor_t *)L_args)[L_index_2]);
	    L_value = (((descriptor_t *)L_args)[(L_index_2 + 1)]);
	    if ((L_key.heapptr == &SYM_index_HEAP)) {
		L_index = L_value;
	    }
	    L_index_2 = (L_index_2 - 2);
	}
    }
  block0:;
    orig_sp = L_args;
    /* pointer-value-setter{<c-char-vector>, <c-char-pointer-vector>} */
    L_result0 = networkZnetwork_internalZpointer_value_setter_METH_12(orig_sp, L_arg_3, L_arg_4, A_next_method_info, L_rest, L_index);
    orig_sp[0] = L_result0;
    return orig_sp + 1;
}


/* Define Method content-size{subclass(<c-char-pointer-vector>)} */

/* content-size{subclass(<c-char-pointer-vector>)} */
long networkZnetwork_internalZcontent_size_METH_60(descriptor_t *orig_sp, heapptr_t A0, heapptr_t A1)
{

    return 4;
}

/* generic-entry for content-size{subclass(<c-char-pointer-vector>)} */
descriptor_t * networkZnetwork_internalZcontent_size_METH_GENERIC_60(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    long L_result0; /* result0 */
    descriptor_t L_temp;

    orig_sp = ((void *)(orig_sp - 1));
    /* content-size{subclass(<c-char-pointer-vector>)} */
    L_result0 = networkZnetwork_internalZcontent_size_METH_60(orig_sp, &networkZnetwork_internalZCLS_c_char_pointer_vector_HEAP, A_next_method_info);
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* Define Class <hostent> */

/* <hostent> is <hostent> */

extern struct heapobj networkZnetwork_internalZCLS_hostent_HEAP;

/* maker for <hostent> */
void * networkZnetwork_internalZCLS_hostent_MAKER_FUN(descriptor_t *orig_sp, void * A_pointer /* pointer */, int A_pointer_suppliedQUERY /* pointer-supplied? */)
{
    descriptor_t *cluster_0_top;


    /* #line 2901 "./sockets-api.dylan" */
    if (A_pointer_suppliedQUERY) {
	return A_pointer;
    }
    else {
	/* missing-required-init-keyword-error */
	dylanZdylan_visceraZmissing_required_init_keyword_error_FUN(orig_sp, &SYM_pointer_HEAP, &networkZnetwork_internalZCLS_hostent_HEAP);
	not_reached();
    }
}

extern descriptor_t networkZliteral_63;	/* proxy for <hostent> */

/* general-entry for maker for <hostent> */
descriptor_t * networkZnetwork_internalZCLS_hostent_MAKER_GENERAL(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    void * L_pointer; /* pointer */
    int L_pointer_suppliedQUERY; /* pointer-supplied? */
    long L_index; /* index */
    descriptor_t L_temp; /* temp */
    descriptor_t L_value; /* value */
    descriptor_t L_temp_2;
    descriptor_t L_temp_3;
    void * L_result0; /* result0 */
    descriptor_t L_temp_4;

    /* #line {Class <unknown-source-location>} */

    /* #line 126 "./cmp.dylan" */

    /* #line 209 "./num.dylan" */
    if (((A_nargs & 1) == 0)) {
	/* #line {Class <unknown-source-location>} */
	L_args = ((void *)(orig_sp - A_nargs));
	L_pointer = 0;
	L_pointer_suppliedQUERY = FALSE;
	L_index = (A_nargs - 2);
	while (1) {
	    if ((L_index < 0)) {
		goto block0;
	    }
	    else {
		L_temp = (((descriptor_t *)L_args)[L_index]);

		/* #line 386 "./condition.dylan" */
		if ((&dylanZdylan_visceraZCLS_symbol_HEAP == SLOT(L_temp.heapptr, heapptr_t, 0))) {
		    /* #line {Class <unknown-source-location>} */
		    L_value = (((descriptor_t *)L_args)[(L_index + 1)]);
		    if ((L_temp.heapptr == &SYM_pointer_HEAP)) {

			/* #line 386 "./condition.dylan" */
			if ((&dylanZdylan_visceraZCLS_raw_pointer_HEAP == SLOT(L_value.heapptr, heapptr_t, 0))) {
			    /* #line {Class <unknown-source-location>} */
			    L_pointer = L_value.dataword.ptr;
			    L_pointer_suppliedQUERY = TRUE;
			}
			else {

			    /* #line 389 "./condition.dylan" */
			    L_temp_2.heapptr = &networkZstr_ROOT;
			    L_temp_2.dataword.l = 0;
			    /* type-error-with-location */
			    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_value, &dylanZdylan_visceraZCLS_raw_pointer_HEAP, L_temp_2);
			    not_reached();
			}
		    }
		    /* #line {Class <unknown-source-location>} */
		    L_index = (L_index - 2);
		}
		else {

		    /* #line 389 "./condition.dylan" */
		    L_temp_3.heapptr = &networkZstr_ROOT;
		    L_temp_3.dataword.l = 0;
		    /* type-error-with-location */
		    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp, &dylanZdylan_visceraZCLS_symbol_HEAP, L_temp_3);
		    not_reached();
		}
	    }
	}
      block0:;
	/* #line {Class <unknown-source-location>} */
	orig_sp = L_args;
	/* maker for <hostent> */
	L_result0 = networkZnetwork_internalZCLS_hostent_MAKER_FUN(orig_sp, L_pointer, L_pointer_suppliedQUERY);
	L_temp_4.heapptr = networkZliteral_63.heapptr;
	L_temp_4.dataword.ptr = L_result0;
	orig_sp[0] = L_temp_4;
	return orig_sp + 1;
    }
    else {
	/* odd-number-of-keyword/value-arguments-error */
	dylanZdylan_visceraZodd_number_of_keywordSLASHvalue_arguments_error_FUN(orig_sp);
	not_reached();
    }
}


/* Define Sealed Domain make (singleton(<hostent>)) */


/* {Implicit} Define Generic get-h-name */

/* get-h-name is get-h-name */


/* Define Method get-h-name{<hostent>} */

extern struct heapobj networkZstr_ROOT_92;

/* get-h-name{<hostent>} */
descriptor_t networkZnetwork_internalZget_h_name_METH(descriptor_t *orig_sp, void * A_ptr /* ptr */, heapptr_t A1)
{
    descriptor_t *cluster_0_top;
    descriptor_t L_temp;
    descriptor_t L_temp_2;
    descriptor_t L_temp_3; /* temp */
    int L_condition; /* condition */
    descriptor_t L_result; /* result */
    heapptr_t L_PCTobject_class; /* %object-class */
    int L_temp_4; /* temp */
    descriptor_t L_temp_5;
    descriptor_t L_temp_6;


    /* #line 290 "./melange.dylan" */

    /* #line 91 "./rawptr.dylan" */

    /* #line 290 "./melange.dylan" */
    L_temp.heapptr = &networkZnetwork_internalZCLS_c_char_vector_HEAP;
    L_temp.dataword.l = 0;
    L_temp_2.heapptr = networkZliteral_6.heapptr;
    L_temp_2.dataword.ptr = (*(void * *)((char *)A_ptr + 0 ));
    orig_sp[0] = L_temp;
    orig_sp[1] = L_temp_2;
    /* as */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZas_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_temp_3 = orig_sp[0];

    /* #line 49 "./object.dylan" */

    /* #line 386 "./condition.dylan" */
    /* %subtype?{<class>, <class>} */
    L_condition = dylanZdylan_visceraZPCTsubtypeQUERY_METH(orig_sp, SLOT(L_temp_3.heapptr, heapptr_t, 0), &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP, &dylanZliteral_ROOT_2);
    if (L_condition) {

	/* #line 290 "./melange.dylan" */
	L_result = L_temp_3;

	/* #line 386 "./condition.dylan" */
	L_PCTobject_class = SLOT(L_result.heapptr, heapptr_t, 0);
	if ((&networkZnetwork_internalZCLS_charLESSX4040GREATER_HEAP == L_PCTobject_class)) {
	    L_temp_4 = TRUE;
	}
	else if ((&networkZnetwork_internalZCLS_charLESSX40120GREATER_HEAP == L_PCTobject_class)) {
	    L_temp_4 = TRUE;
	}
	else if ((&networkZnetwork_internalZCLS_charLESSX4014GREATER_HEAP == L_PCTobject_class)) {
	    L_temp_4 = TRUE;
	}
	else {
	    L_temp_4 = (&networkZnetwork_internalZCLS_c_char_vector_HEAP == L_PCTobject_class);
	}
	if (L_temp_4) {

	    /* #line 2907 "./sockets-api.dylan" */
	    return L_result;
	}
	else {

	    /* #line 389 "./condition.dylan" */
	    L_temp_5.heapptr = &networkZstr_ROOT_92;
	    L_temp_5.dataword.l = 0;
	    /* type-error-with-location */
	    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_result, &networkZnetwork_internalZCLS_c_char_vector_HEAP, L_temp_5);
	    not_reached();
	}
    }
    else {
	L_temp_6.heapptr = &networkZstr_ROOT_14;
	L_temp_6.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp_3, &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP, L_temp_6);
	not_reached();
    }
}


/* {Implicit} Define Generic get-h-name-setter */

/* get-h-name-setter is get-h-name-setter */


/* Define Method get-h-name-setter{<c-char-vector>, <hostent>} */

/* get-h-name-setter{<c-char-vector>, <hostent>} */
descriptor_t networkZnetwork_internalZget_h_name_setter_METH(descriptor_t *orig_sp, descriptor_t A_value /* value */, void * A_ptr /* ptr */, heapptr_t A2)
{
    descriptor_t *cluster_0_top;

    /* #line {Class <unknown-source-location>} */

    /* #line 299 "./melange.dylan" */
    /* #line {Class <unknown-source-location>} */

    /* #line 97 "./rawptr.dylan" */
    *(void * *)((char *)A_ptr + 0) = A_value.dataword.ptr;
    return A_value;
}


/* {Implicit} Define Generic get-h-aliases */

/* get-h-aliases is get-h-aliases */


/* Define Method get-h-aliases{<hostent>} */

extern struct heapobj networkZstr_ROOT_93;

/* get-h-aliases{<hostent>} */
void * networkZnetwork_internalZget_h_aliases_METH(descriptor_t *orig_sp, void * A_ptr /* ptr */, heapptr_t A1)
{
    descriptor_t *cluster_0_top;
    descriptor_t L_temp;
    descriptor_t L_temp_2;
    descriptor_t L_temp_3; /* temp */
    int L_condition; /* condition */
    descriptor_t L_result; /* result */
    descriptor_t L_temp_4;
    descriptor_t L_temp_5;

    /* #line {Class <unknown-source-location>} */

    /* #line 290 "./melange.dylan" */

    /* #line 91 "./rawptr.dylan" */

    /* #line 290 "./melange.dylan" */
    L_temp.heapptr = &networkZnetwork_internalZCLS_c_char_pointer_vector_HEAP;
    L_temp.dataword.l = 0;
    L_temp_2.heapptr = networkZliteral_6.heapptr;
    L_temp_2.dataword.ptr = (*(void * *)((char *)A_ptr + 4 ));
    orig_sp[0] = L_temp;
    orig_sp[1] = L_temp_2;
    /* as */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZas_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_temp_3 = orig_sp[0];

    /* #line 49 "./object.dylan" */

    /* #line 386 "./condition.dylan" */
    /* %subtype?{<class>, <class>} */
    L_condition = dylanZdylan_visceraZPCTsubtypeQUERY_METH(orig_sp, SLOT(L_temp_3.heapptr, heapptr_t, 0), &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP, &dylanZliteral_ROOT_2);
    if (L_condition) {

	/* #line 290 "./melange.dylan" */
	L_result = L_temp_3;

	/* #line 386 "./condition.dylan" */
	if ((&networkZnetwork_internalZCLS_c_char_pointer_vector_HEAP == SLOT(L_result.heapptr, heapptr_t, 0))) {

	    /* #line 2918 "./sockets-api.dylan" */
	    return L_result.dataword.ptr;
	}
	else {

	    /* #line 389 "./condition.dylan" */
	    L_temp_4.heapptr = &networkZstr_ROOT_93;
	    L_temp_4.dataword.l = 0;
	    /* type-error-with-location */
	    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_result, &networkZnetwork_internalZCLS_c_char_pointer_vector_HEAP, L_temp_4);
	    not_reached();
	}
    }
    else {
	L_temp_5.heapptr = &networkZstr_ROOT_14;
	L_temp_5.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp_3, &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP, L_temp_5);
	not_reached();
    }
}


/* {Implicit} Define Generic get-h-aliases-setter */

/* get-h-aliases-setter is get-h-aliases-setter */


/* Define Method get-h-aliases-setter{<c-char-pointer-vector>, <hostent>} */

/* get-h-aliases-setter{<c-char-pointer-vector>, <hostent>} */
void * networkZnetwork_internalZget_h_aliases_setter_METH(descriptor_t *orig_sp, void * A_value /* value */, void * A_ptr /* ptr */, heapptr_t A2)
{
    descriptor_t *cluster_0_top;

    /* #line {Class <unknown-source-location>} */

    /* #line 299 "./melange.dylan" */
    /* #line {Class <unknown-source-location>} */

    /* #line 97 "./rawptr.dylan" */
    *(void * *)((char *)A_ptr + 4) = A_value;
    return A_value;
}


/* {Implicit} Define Generic get-h-addrtype */

/* get-h-addrtype is get-h-addrtype */


/* Define Method get-h-addrtype{<hostent>} */

/* get-h-addrtype{<hostent>} */
long networkZnetwork_internalZget_h_addrtype_METH(descriptor_t *orig_sp, void * A_ptr /* ptr */, heapptr_t A1)
{
    descriptor_t *cluster_0_top;

    /* #line {Class <unknown-source-location>} */

    /* #line 198 "./melange.dylan" */

    /* #line 91 "./rawptr.dylan" */
    return (*(long *)((char *)A_ptr + 8 ));
}

/* generic-entry for get-h-addrtype{<hostent>} */
descriptor_t * networkZnetwork_internalZget_h_addrtype_METH_GENERIC(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    descriptor_t L_arg; /* arg */
    void * L_arg_2; /* arg */
    long L_result0; /* result0 */
    descriptor_t L_temp;

    /* #line {Class <unknown-source-location>} */
    L_args = ((void *)(orig_sp - 1));
    L_arg = (((descriptor_t *)L_args)[0]);
    L_arg_2 = L_arg.dataword.ptr;
    orig_sp = L_args;
    /* get-h-addrtype{<hostent>} */
    L_result0 = networkZnetwork_internalZget_h_addrtype_METH(orig_sp, L_arg_2, A_next_method_info);
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* {Implicit} Define Generic get-h-addrtype-setter */

/* get-h-addrtype-setter is get-h-addrtype-setter */


/* Define Method get-h-addrtype-setter{<integer>, <hostent>} */

/* get-h-addrtype-setter{<integer>, <hostent>} */
long networkZnetwork_internalZget_h_addrtype_setter_METH(descriptor_t *orig_sp, long A_value /* value */, void * A_ptr /* ptr */, heapptr_t A2)
{
    descriptor_t *cluster_0_top;


    /* #line 97 "./rawptr.dylan" */
    *(long *)((char *)A_ptr + 8) = A_value;
    return A_value;
}


/* {Implicit} Define Generic get-h-length */

/* get-h-length is get-h-length */


/* Define Method get-h-length{<hostent>} */

/* get-h-length{<hostent>} */
long networkZnetwork_internalZget_h_length_METH(descriptor_t *orig_sp, void * A_ptr /* ptr */, heapptr_t A1)
{
    descriptor_t *cluster_0_top;

    /* #line {Class <unknown-source-location>} */

    /* #line 198 "./melange.dylan" */

    /* #line 91 "./rawptr.dylan" */
    return (*(long *)((char *)A_ptr + 12 ));
}

/* generic-entry for get-h-length{<hostent>} */
descriptor_t * networkZnetwork_internalZget_h_length_METH_GENERIC(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    descriptor_t L_arg; /* arg */
    void * L_arg_2; /* arg */
    long L_result0; /* result0 */
    descriptor_t L_temp;

    /* #line {Class <unknown-source-location>} */
    L_args = ((void *)(orig_sp - 1));
    L_arg = (((descriptor_t *)L_args)[0]);
    L_arg_2 = L_arg.dataword.ptr;
    orig_sp = L_args;
    /* get-h-length{<hostent>} */
    L_result0 = networkZnetwork_internalZget_h_length_METH(orig_sp, L_arg_2, A_next_method_info);
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* {Implicit} Define Generic get-h-length-setter */

/* get-h-length-setter is get-h-length-setter */


/* Define Method get-h-length-setter{<integer>, <hostent>} */

/* get-h-length-setter{<integer>, <hostent>} */
long networkZnetwork_internalZget_h_length_setter_METH(descriptor_t *orig_sp, long A_value /* value */, void * A_ptr /* ptr */, heapptr_t A2)
{
    descriptor_t *cluster_0_top;


    /* #line 97 "./rawptr.dylan" */
    *(long *)((char *)A_ptr + 12) = A_value;
    return A_value;
}


/* {Implicit} Define Generic get-h-addr-list */

/* get-h-addr-list is get-h-addr-list */


/* Define Method get-h-addr-list{<hostent>} */

extern struct heapobj networkZstr_ROOT_94;

/* get-h-addr-list{<hostent>} */
void * networkZnetwork_internalZget_h_addr_list_METH(descriptor_t *orig_sp, void * A_ptr /* ptr */, heapptr_t A1)
{
    descriptor_t *cluster_0_top;
    descriptor_t L_temp;
    descriptor_t L_temp_2;
    descriptor_t L_temp_3; /* temp */
    int L_condition; /* condition */
    descriptor_t L_result; /* result */
    descriptor_t L_temp_4;
    descriptor_t L_temp_5;

    /* #line {Class <unknown-source-location>} */

    /* #line 290 "./melange.dylan" */

    /* #line 91 "./rawptr.dylan" */

    /* #line 290 "./melange.dylan" */
    L_temp.heapptr = &networkZnetwork_internalZCLS_c_char_pointer_vector_HEAP;
    L_temp.dataword.l = 0;
    L_temp_2.heapptr = networkZliteral_6.heapptr;
    L_temp_2.dataword.ptr = (*(void * *)((char *)A_ptr + 16 ));
    orig_sp[0] = L_temp;
    orig_sp[1] = L_temp_2;
    /* as */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZas_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_temp_3 = orig_sp[0];

    /* #line 49 "./object.dylan" */

    /* #line 386 "./condition.dylan" */
    /* %subtype?{<class>, <class>} */
    L_condition = dylanZdylan_visceraZPCTsubtypeQUERY_METH(orig_sp, SLOT(L_temp_3.heapptr, heapptr_t, 0), &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP, &dylanZliteral_ROOT_2);
    if (L_condition) {

	/* #line 290 "./melange.dylan" */
	L_result = L_temp_3;

	/* #line 386 "./condition.dylan" */
	if ((&networkZnetwork_internalZCLS_c_char_pointer_vector_HEAP == SLOT(L_result.heapptr, heapptr_t, 0))) {

	    /* #line 2951 "./sockets-api.dylan" */
	    return L_result.dataword.ptr;
	}
	else {

	    /* #line 389 "./condition.dylan" */
	    L_temp_4.heapptr = &networkZstr_ROOT_94;
	    L_temp_4.dataword.l = 0;
	    /* type-error-with-location */
	    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_result, &networkZnetwork_internalZCLS_c_char_pointer_vector_HEAP, L_temp_4);
	    not_reached();
	}
    }
    else {
	L_temp_5.heapptr = &networkZstr_ROOT_14;
	L_temp_5.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp_3, &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP, L_temp_5);
	not_reached();
    }
}

/* generic-entry for get-h-addr-list{<hostent>} */
descriptor_t * networkZnetwork_internalZget_h_addr_list_METH_GENERIC(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    descriptor_t L_arg; /* arg */
    void * L_arg_2; /* arg */
    void * L_result0; /* result0 */
    descriptor_t L_temp;

    /* #line {Class <unknown-source-location>} */
    L_args = ((void *)(orig_sp - 1));
    L_arg = (((descriptor_t *)L_args)[0]);
    L_arg_2 = L_arg.dataword.ptr;
    orig_sp = L_args;
    /* get-h-addr-list{<hostent>} */
    L_result0 = networkZnetwork_internalZget_h_addr_list_METH(orig_sp, L_arg_2, A_next_method_info);
    L_temp.heapptr = networkZliteral_62.heapptr;
    L_temp.dataword.ptr = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* {Implicit} Define Generic get-h-addr-list-setter */

/* get-h-addr-list-setter is get-h-addr-list-setter */


/* Define Method get-h-addr-list-setter{<c-char-pointer-vector>, <hostent>} */

/* get-h-addr-list-setter{<c-char-pointer-vector>, <hostent>} */
void * networkZnetwork_internalZget_h_addr_list_setter_METH(descriptor_t *orig_sp, void * A_value /* value */, void * A_ptr /* ptr */, heapptr_t A2)
{
    descriptor_t *cluster_0_top;


    /* #line 299 "./melange.dylan" */
    /* #line {Class <unknown-source-location>} */

    /* #line 97 "./rawptr.dylan" */
    *(void * *)((char *)A_ptr + 16) = A_value;
    return A_value;
}


/* Define Method pointer-value{<hostent>} */

extern struct heapobj networkZstr_ROOT_95;

/* pointer-value{<hostent>} */
void * networkZnetwork_internalZpointer_value_METH_48(descriptor_t *orig_sp, void * A_value /* value */, heapptr_t A_next_method_info /* next-method-info */, heapptr_t A_rest /* rest */, descriptor_t A_index /* index */)
{
    descriptor_t *cluster_0_top;
    descriptor_t L_temp;
    descriptor_t L_arg1; /* arg1 */
    descriptor_t L_temp_2;
    descriptor_t L_temp_3; /* temp */
    descriptor_t L_temp_4;

    /* #line {Class <unknown-source-location>} */

    /* #line 2961 "./sockets-api.dylan" */
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = 20;
    orig_sp[0] = A_index;
    orig_sp[1] = L_temp;
    /* * */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZV_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_arg1 = (orig_sp == cluster_0_top ? dylanZfalse : orig_sp[0]);

    /* #line 2961 "./sockets-api.dylan" */
    L_temp_2.heapptr = networkZliteral_63.heapptr;
    L_temp_2.dataword.ptr = A_value;
    orig_sp[0] = L_temp_2;
    orig_sp[1] = L_arg1;
    /* + */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZPLUS_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_temp_3 = (orig_sp == cluster_0_top ? dylanZfalse : orig_sp[0]);

    /* #line 386 "./condition.dylan" */
    if ((&networkZnetwork_internalZCLS_hostent_HEAP == SLOT(L_temp_3.heapptr, heapptr_t, 0))) {

	/* #line 2961 "./sockets-api.dylan" */
	return L_temp_3.dataword.ptr;
    }
    else {

	/* #line 389 "./condition.dylan" */
	L_temp_4.heapptr = &networkZstr_ROOT_95;
	L_temp_4.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp_3, &networkZnetwork_internalZCLS_hostent_HEAP, L_temp_4);
	not_reached();
    }
}

/* generic-entry for pointer-value{<hostent>} */
descriptor_t * networkZnetwork_internalZpointer_value_METH_GENERIC_48(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    descriptor_t L_arg; /* arg */
    heapptr_t L_rest; /* rest */
    void * L_arg_2; /* arg */
    descriptor_t L_index; /* index */
    long L_index_2; /* index */
    descriptor_t L_key; /* key */
    descriptor_t L_value; /* value */
    void * L_result0; /* result0 */
    descriptor_t L_temp;

    /* #line {Class <unknown-source-location>} */
    L_args = ((void *)(orig_sp - A_nargs));
    L_arg = (((descriptor_t *)L_args)[0]);
    L_rest = dylanZdylan_visceraZmake_rest_arg_FUN(orig_sp, (descriptor_t *)L_args + 1, A_nargs - 1);
    L_arg_2 = L_arg.dataword.ptr;
    L_index.heapptr = networkZliteral_2.heapptr;
    L_index.dataword.l = 0;
    L_index_2 = (A_nargs - 2);
    while (1) {
	if ((L_index_2 < 1)) {
	    goto block0;
	}
	else {
	    L_key = (((descriptor_t *)L_args)[L_index_2]);
	    L_value = (((descriptor_t *)L_args)[(L_index_2 + 1)]);
	    if ((L_key.heapptr == &SYM_index_HEAP)) {
		L_index = L_value;
	    }
	    L_index_2 = (L_index_2 - 2);
	}
    }
  block0:;
    orig_sp = L_args;
    /* pointer-value{<hostent>} */
    L_result0 = networkZnetwork_internalZpointer_value_METH_48(orig_sp, L_arg_2, A_next_method_info, L_rest, L_index);
    L_temp.heapptr = networkZliteral_63.heapptr;
    L_temp.dataword.ptr = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* Define Method content-size{subclass(<hostent>)} */

/* content-size{subclass(<hostent>)} */
long networkZnetwork_internalZcontent_size_METH_61(descriptor_t *orig_sp, heapptr_t A0, heapptr_t A1)
{

    return 20;
}

/* generic-entry for content-size{subclass(<hostent>)} */
descriptor_t * networkZnetwork_internalZcontent_size_METH_GENERIC_61(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    long L_result0; /* result0 */
    descriptor_t L_temp;

    orig_sp = ((void *)(orig_sp - 1));
    /* content-size{subclass(<hostent>)} */
    L_result0 = networkZnetwork_internalZcontent_size_METH_61(orig_sp, &networkZnetwork_internalZCLS_hostent_HEAP, A_next_method_info);
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* {Implicit} Define Generic sethostent */

/* sethostent is sethostent */


/* Define Method sethostent{<integer>} */

/* sethostent{<integer>} */
void networkZnetwork_internalZsethostent_METH(descriptor_t *orig_sp, long A_arg1 /* arg1 */, heapptr_t A1)
{
    descriptor_t *cluster_0_top;


    /* #line 735 "./macros.dylan" */
    sethostent(A_arg1);
    return;
}


/* {Implicit} Define Generic endhostent */

/* endhostent is endhostent */


/* Define Method endhostent{} */

/* endhostent{} */
void networkZnetwork_internalZendhostent_METH(descriptor_t *orig_sp, heapptr_t A0)
{
    descriptor_t *cluster_0_top;

    /* #line {Class <unknown-source-location>} */

    /* #line 735 "./macros.dylan" */
    endhostent();
    return;
}


/* {Implicit} Define Generic gethostent */

/* gethostent is gethostent */


/* Define Method gethostent{} */

extern struct heapobj networkZstr_ROOT_96;

/* gethostent{} */
void * networkZnetwork_internalZgethostent_METH(descriptor_t *orig_sp, heapptr_t A0)
{
    descriptor_t *cluster_0_top;
    void * L_result_value; /* result-value */
    heapptr_t L_instance; /* instance */
    descriptor_t L_temp;
    descriptor_t L_temp_2;
    descriptor_t L_temp_3;
    descriptor_t L_result_value_2; /* result-value */
    descriptor_t L_temp_4;

    /* #line {Class <unknown-source-location>} */

    /* #line 735 "./macros.dylan" */
    L_result_value = gethostent();

    /* #line 2987 "./sockets-api.dylan" */
    /* maker for <simple-object-vector> */
    L_instance = dylanZdylan_visceraZCLS_simple_object_vector_MAKER_FUN(orig_sp, 2, dylanZfalse);
    L_temp.heapptr = &SYM_pointer_HEAP;
    L_temp.dataword.l = 0;
    SLOT(L_instance, descriptor_t, 8 + 0 * sizeof(descriptor_t)) = L_temp;
    L_temp_2.heapptr = networkZliteral_6.heapptr;
    L_temp_2.dataword.ptr = L_result_value;
    SLOT(L_instance, descriptor_t, 8 + 1 * sizeof(descriptor_t)) = L_temp_2;
    L_temp_3.heapptr = networkZliteral_6.heapptr;
    L_temp_3.dataword.ptr = L_result_value;
    /* make{subclass(<statically-typed-pointer>)} */
    L_result_value_2 = melange_supportZmelange_supportZmake_METH(orig_sp, &networkZnetwork_internalZCLS_hostent_HEAP, &networkZliteral_ROOT, L_instance, 0, L_temp_3, 1);

    /* #line 386 "./condition.dylan" */
    if ((&networkZnetwork_internalZCLS_hostent_HEAP == SLOT(L_result_value_2.heapptr, heapptr_t, 0))) {

	/* #line 2988 "./sockets-api.dylan" */
	return L_result_value_2.dataword.ptr;
    }
    else {

	/* #line 389 "./condition.dylan" */
	L_temp_4.heapptr = &networkZstr_ROOT_96;
	L_temp_4.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_result_value_2, &networkZnetwork_internalZCLS_hostent_HEAP, L_temp_4);
	not_reached();
    }
}


/* {Implicit} Define Generic gethostbyaddr */

/* gethostbyaddr is gethostbyaddr */


/* Define Method gethostbyaddr{<machine-pointer>, <integer>, <integer>} */

extern struct heapobj networkZstr_ROOT_97;

/* gethostbyaddr{<machine-pointer>, <integer>, <integer>} */
void * networkZnetwork_internalZgethostbyaddr_METH(descriptor_t *orig_sp, void * A_arg1 /* arg1 */, long A_arg2 /* arg2 */, long A_arg3 /* arg3 */, heapptr_t A3)
{
    descriptor_t *cluster_0_top;
    void * L_result_value; /* result-value */
    heapptr_t L_instance; /* instance */
    descriptor_t L_temp;
    descriptor_t L_temp_2;
    descriptor_t L_temp_3;
    descriptor_t L_result_value_2; /* result-value */
    descriptor_t L_temp_4;

    /* #line {Class <unknown-source-location>} */

    /* #line 2995 "./sockets-api.dylan" */

    /* #line 735 "./macros.dylan" */
    L_result_value = gethostbyaddr(A_arg1, A_arg2, A_arg3);

    /* #line 2996 "./sockets-api.dylan" */
    /* maker for <simple-object-vector> */
    L_instance = dylanZdylan_visceraZCLS_simple_object_vector_MAKER_FUN(orig_sp, 2, dylanZfalse);
    L_temp.heapptr = &SYM_pointer_HEAP;
    L_temp.dataword.l = 0;
    SLOT(L_instance, descriptor_t, 8 + 0 * sizeof(descriptor_t)) = L_temp;
    L_temp_2.heapptr = networkZliteral_6.heapptr;
    L_temp_2.dataword.ptr = L_result_value;
    SLOT(L_instance, descriptor_t, 8 + 1 * sizeof(descriptor_t)) = L_temp_2;
    L_temp_3.heapptr = networkZliteral_6.heapptr;
    L_temp_3.dataword.ptr = L_result_value;
    /* make{subclass(<statically-typed-pointer>)} */
    L_result_value_2 = melange_supportZmelange_supportZmake_METH(orig_sp, &networkZnetwork_internalZCLS_hostent_HEAP, &networkZliteral_ROOT, L_instance, 0, L_temp_3, 1);

    /* #line 386 "./condition.dylan" */
    if ((&networkZnetwork_internalZCLS_hostent_HEAP == SLOT(L_result_value_2.heapptr, heapptr_t, 0))) {

	/* #line 2997 "./sockets-api.dylan" */
	return L_result_value_2.dataword.ptr;
    }
    else {

	/* #line 389 "./condition.dylan" */
	L_temp_4.heapptr = &networkZstr_ROOT_97;
	L_temp_4.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_result_value_2, &networkZnetwork_internalZCLS_hostent_HEAP, L_temp_4);
	not_reached();
    }
}


/* {Implicit} Define Generic gethostbyname */

/* gethostbyname is gethostbyname */


/* Define Method gethostbyname{<byte-string>} */

extern struct heapobj networkZstr_ROOT_98;

extern struct heapobj networkZstr_ROOT_99;

/* gethostbyname{<byte-string>} */
void * networkZnetwork_internalZgethostbyname_METH(descriptor_t *orig_sp, heapptr_t A_arg1 /* arg1 */, heapptr_t A1)
{
    descriptor_t *cluster_0_top;
    descriptor_t L_temp;
    descriptor_t L_temp_2;
    descriptor_t L_argument; /* argument */
    int L_condition; /* condition */
    void * L_result_value; /* result-value */
    heapptr_t L_instance; /* instance */
    descriptor_t L_temp_3;
    descriptor_t L_temp_4;
    descriptor_t L_temp_5;
    descriptor_t L_result_value_2; /* result-value */
    descriptor_t L_temp_6;
    descriptor_t L_temp_7;

    /* #line {Class <unknown-source-location>} */

    /* #line 3004 "./sockets-api.dylan" */
    L_temp.heapptr = &melange_supportZmelange_supportZCLS_c_string_HEAP;
    L_temp.dataword.l = 0;
    L_temp_2.heapptr = A_arg1;
    L_temp_2.dataword.l = 0;
    orig_sp[0] = L_temp;
    orig_sp[1] = L_temp_2;
    /* export-value */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &melange_supportZmelange_supportZexport_value_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_argument = orig_sp[0];

    /* #line 49 "./object.dylan" */

    /* #line 386 "./condition.dylan" */
    /* %subtype?{<class>, <class>} */
    L_condition = dylanZdylan_visceraZPCTsubtypeQUERY_METH(orig_sp, SLOT(L_argument.heapptr, heapptr_t, 0), &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP, &dylanZliteral_ROOT_2);
    if (L_condition) {

	/* #line 3004 "./sockets-api.dylan" */

	/* #line 735 "./macros.dylan" */
	L_result_value = gethostbyname(L_argument.dataword.ptr);

	/* #line 3005 "./sockets-api.dylan" */
	/* maker for <simple-object-vector> */
	L_instance = dylanZdylan_visceraZCLS_simple_object_vector_MAKER_FUN(orig_sp, 2, dylanZfalse);
	L_temp_3.heapptr = &SYM_pointer_HEAP;
	L_temp_3.dataword.l = 0;
	SLOT(L_instance, descriptor_t, 8 + 0 * sizeof(descriptor_t)) = L_temp_3;
	L_temp_4.heapptr = networkZliteral_6.heapptr;
	L_temp_4.dataword.ptr = L_result_value;
	SLOT(L_instance, descriptor_t, 8 + 1 * sizeof(descriptor_t)) = L_temp_4;
	L_temp_5.heapptr = networkZliteral_6.heapptr;
	L_temp_5.dataword.ptr = L_result_value;
	/* make{subclass(<statically-typed-pointer>)} */
	L_result_value_2 = melange_supportZmelange_supportZmake_METH(orig_sp, &networkZnetwork_internalZCLS_hostent_HEAP, &networkZliteral_ROOT, L_instance, 0, L_temp_5, 1);

	/* #line 386 "./condition.dylan" */
	if ((&networkZnetwork_internalZCLS_hostent_HEAP == SLOT(L_result_value_2.heapptr, heapptr_t, 0))) {

	    /* #line 3006 "./sockets-api.dylan" */
	    return L_result_value_2.dataword.ptr;
	}
	else {

	    /* #line 389 "./condition.dylan" */
	    L_temp_6.heapptr = &networkZstr_ROOT_98;
	    L_temp_6.dataword.l = 0;
	    /* type-error-with-location */
	    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_result_value_2, &networkZnetwork_internalZCLS_hostent_HEAP, L_temp_6);
	    not_reached();
	}
    }
    else {
	L_temp_7.heapptr = &networkZstr_ROOT_99;
	L_temp_7.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_argument, &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP, L_temp_7);
	not_reached();
    }
}

/* generic-entry for gethostbyname{<byte-string>} */
descriptor_t * networkZnetwork_internalZgethostbyname_METH_GENERIC(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    descriptor_t L_arg; /* arg */
    heapptr_t L_arg_2; /* arg */
    void * L_result0; /* result0 */
    descriptor_t L_temp;

    /* #line {Class <unknown-source-location>} */
    L_args = ((void *)(orig_sp - 1));
    L_arg = (((descriptor_t *)L_args)[0]);
    L_arg_2 = L_arg.heapptr;
    orig_sp = L_args;
    /* gethostbyname{<byte-string>} */
    L_result0 = networkZnetwork_internalZgethostbyname_METH(orig_sp, L_arg_2, A_next_method_info);
    L_temp.heapptr = networkZliteral_63.heapptr;
    L_temp.dataword.ptr = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* {Implicit} Define Generic gethostbyname2 */

/* gethostbyname2 is gethostbyname2 */


/* Define Method gethostbyname2{<c-char-vector>, <integer>} */

extern struct heapobj networkZstr_ROOT_100;

/* gethostbyname2{<c-char-vector>, <integer>} */
void * networkZnetwork_internalZgethostbyname2_METH(descriptor_t *orig_sp, descriptor_t A_arg1 /* arg1 */, long A_arg2 /* arg2 */, heapptr_t A2)
{
    descriptor_t *cluster_0_top;
    void * L_result_value; /* result-value */
    heapptr_t L_instance; /* instance */
    descriptor_t L_temp;
    descriptor_t L_temp_2;
    descriptor_t L_temp_3;
    descriptor_t L_result_value_2; /* result-value */
    descriptor_t L_temp_4;


    /* #line 3013 "./sockets-api.dylan" */

    /* #line 735 "./macros.dylan" */
    L_result_value = gethostbyname2(A_arg1.dataword.ptr, A_arg2);

    /* #line 3014 "./sockets-api.dylan" */
    /* maker for <simple-object-vector> */
    L_instance = dylanZdylan_visceraZCLS_simple_object_vector_MAKER_FUN(orig_sp, 2, dylanZfalse);
    L_temp.heapptr = &SYM_pointer_HEAP;
    L_temp.dataword.l = 0;
    SLOT(L_instance, descriptor_t, 8 + 0 * sizeof(descriptor_t)) = L_temp;
    L_temp_2.heapptr = networkZliteral_6.heapptr;
    L_temp_2.dataword.ptr = L_result_value;
    SLOT(L_instance, descriptor_t, 8 + 1 * sizeof(descriptor_t)) = L_temp_2;
    L_temp_3.heapptr = networkZliteral_6.heapptr;
    L_temp_3.dataword.ptr = L_result_value;
    /* make{subclass(<statically-typed-pointer>)} */
    L_result_value_2 = melange_supportZmelange_supportZmake_METH(orig_sp, &networkZnetwork_internalZCLS_hostent_HEAP, &networkZliteral_ROOT, L_instance, 0, L_temp_3, 1);

    /* #line 386 "./condition.dylan" */
    if ((&networkZnetwork_internalZCLS_hostent_HEAP == SLOT(L_result_value_2.heapptr, heapptr_t, 0))) {

	/* #line 3015 "./sockets-api.dylan" */
	return L_result_value_2.dataword.ptr;
    }
    else {

	/* #line 389 "./condition.dylan" */
	L_temp_4.heapptr = &networkZstr_ROOT_100;
	L_temp_4.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_result_value_2, &networkZnetwork_internalZCLS_hostent_HEAP, L_temp_4);
	not_reached();
    }
}


/* Define Class <hostent*> */

/* <hostent*> is <hostent*> */

extern struct heapobj networkZnetwork_internalZCLS_hostentV_HEAP;

/* maker for <hostent*> */
void * networkZnetwork_internalZCLS_hostentV_MAKER_FUN(descriptor_t *orig_sp, void * A_pointer /* pointer */, int A_pointer_suppliedQUERY /* pointer-supplied? */)
{
    descriptor_t *cluster_0_top;


    /* #line 3018 "./sockets-api.dylan" */
    if (A_pointer_suppliedQUERY) {
	return A_pointer;
    }
    else {
	/* missing-required-init-keyword-error */
	dylanZdylan_visceraZmissing_required_init_keyword_error_FUN(orig_sp, &SYM_pointer_HEAP, &networkZnetwork_internalZCLS_hostentV_HEAP);
	not_reached();
    }
}

extern descriptor_t networkZliteral_64;	/* proxy for <hostent*> */

/* general-entry for maker for <hostent*> */
descriptor_t * networkZnetwork_internalZCLS_hostentV_MAKER_GENERAL(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    void * L_pointer; /* pointer */
    int L_pointer_suppliedQUERY; /* pointer-supplied? */
    long L_index; /* index */
    descriptor_t L_temp; /* temp */
    descriptor_t L_value; /* value */
    descriptor_t L_temp_2;
    descriptor_t L_temp_3;
    void * L_result0; /* result0 */
    descriptor_t L_temp_4;

    /* #line {Class <unknown-source-location>} */

    /* #line 126 "./cmp.dylan" */

    /* #line 209 "./num.dylan" */
    if (((A_nargs & 1) == 0)) {
	/* #line {Class <unknown-source-location>} */
	L_args = ((void *)(orig_sp - A_nargs));
	L_pointer = 0;
	L_pointer_suppliedQUERY = FALSE;
	L_index = (A_nargs - 2);
	while (1) {
	    if ((L_index < 0)) {
		goto block0;
	    }
	    else {
		L_temp = (((descriptor_t *)L_args)[L_index]);

		/* #line 386 "./condition.dylan" */
		if ((&dylanZdylan_visceraZCLS_symbol_HEAP == SLOT(L_temp.heapptr, heapptr_t, 0))) {
		    /* #line {Class <unknown-source-location>} */
		    L_value = (((descriptor_t *)L_args)[(L_index + 1)]);
		    if ((L_temp.heapptr == &SYM_pointer_HEAP)) {

			/* #line 386 "./condition.dylan" */
			if ((&dylanZdylan_visceraZCLS_raw_pointer_HEAP == SLOT(L_value.heapptr, heapptr_t, 0))) {
			    /* #line {Class <unknown-source-location>} */
			    L_pointer = L_value.dataword.ptr;
			    L_pointer_suppliedQUERY = TRUE;
			}
			else {

			    /* #line 389 "./condition.dylan" */
			    L_temp_2.heapptr = &networkZstr_ROOT;
			    L_temp_2.dataword.l = 0;
			    /* type-error-with-location */
			    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_value, &dylanZdylan_visceraZCLS_raw_pointer_HEAP, L_temp_2);
			    not_reached();
			}
		    }
		    /* #line {Class <unknown-source-location>} */
		    L_index = (L_index - 2);
		}
		else {

		    /* #line 389 "./condition.dylan" */
		    L_temp_3.heapptr = &networkZstr_ROOT;
		    L_temp_3.dataword.l = 0;
		    /* type-error-with-location */
		    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp, &dylanZdylan_visceraZCLS_symbol_HEAP, L_temp_3);
		    not_reached();
		}
	    }
	}
      block0:;
	/* #line {Class <unknown-source-location>} */
	orig_sp = L_args;
	/* maker for <hostent*> */
	L_result0 = networkZnetwork_internalZCLS_hostentV_MAKER_FUN(orig_sp, L_pointer, L_pointer_suppliedQUERY);
	L_temp_4.heapptr = networkZliteral_64.heapptr;
	L_temp_4.dataword.ptr = L_result0;
	orig_sp[0] = L_temp_4;
	return orig_sp + 1;
    }
    else {
	/* odd-number-of-keyword/value-arguments-error */
	dylanZdylan_visceraZodd_number_of_keywordSLASHvalue_arguments_error_FUN(orig_sp);
	not_reached();
    }
}


/* Define Sealed Domain make (singleton(<hostent*>)) */


/* Define Method pointer-value{<hostent*>} */

extern struct heapobj networkZstr_ROOT_101;

/* pointer-value{<hostent*>} */
void * networkZnetwork_internalZpointer_value_METH_49(descriptor_t *orig_sp, void * A_ptr /* ptr */, heapptr_t A_next_method_info /* next-method-info */, heapptr_t A_rest /* rest */, descriptor_t A_index /* index */)
{
    descriptor_t *cluster_0_top;
    descriptor_t L_temp;
    descriptor_t L_arg2; /* arg2 */
    descriptor_t L_temp_2;
    descriptor_t L_temp_3;
    descriptor_t L_temp_4; /* temp */
    int L_condition; /* condition */
    descriptor_t L_result; /* result */
    descriptor_t L_temp_5;
    descriptor_t L_temp_6;
    descriptor_t L_temp_7;


    /* #line 3025 "./sockets-api.dylan" */
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = 4;
    orig_sp[0] = A_index;
    orig_sp[1] = L_temp;
    /* * */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZV_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_arg2 = (orig_sp == cluster_0_top ? dylanZfalse : orig_sp[0]);

    /* #line 386 "./condition.dylan" */
    if ((&dylanZdylan_visceraZCLS_integer_HEAP == SLOT(L_arg2.heapptr, heapptr_t, 0))) {

	/* #line 3025 "./sockets-api.dylan" */

	/* #line 290 "./melange.dylan" */

	/* #line 91 "./rawptr.dylan" */

	/* #line 290 "./melange.dylan" */
	L_temp_2.heapptr = &networkZnetwork_internalZCLS_hostent_HEAP;
	L_temp_2.dataword.l = 0;
	L_temp_3.heapptr = networkZliteral_6.heapptr;
	L_temp_3.dataword.ptr = (*(void * *)((char *)A_ptr + L_arg2.dataword.l ));
	orig_sp[0] = L_temp_2;
	orig_sp[1] = L_temp_3;
	/* as */
	{
	  struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZas_HEAP, 2);
	  heapptr_t L_meth = L_temp.R0;
	  heapptr_t L_next_info = L_temp.R1;
	  cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
	}
	L_temp_4 = orig_sp[0];

	/* #line 49 "./object.dylan" */

	/* #line 386 "./condition.dylan" */
	/* %subtype?{<class>, <class>} */
	L_condition = dylanZdylan_visceraZPCTsubtypeQUERY_METH(orig_sp, SLOT(L_temp_4.heapptr, heapptr_t, 0), &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP, &dylanZliteral_ROOT_2);
	if (L_condition) {

	    /* #line 290 "./melange.dylan" */
	    L_result = L_temp_4;

	    /* #line 386 "./condition.dylan" */
	    if ((&networkZnetwork_internalZCLS_hostent_HEAP == SLOT(L_result.heapptr, heapptr_t, 0))) {

		/* #line 3025 "./sockets-api.dylan" */
		return L_result.dataword.ptr;
	    }
	    else {

		/* #line 389 "./condition.dylan" */
		L_temp_5.heapptr = &networkZstr_ROOT_101;
		L_temp_5.dataword.l = 0;
		/* type-error-with-location */
		dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_result, &networkZnetwork_internalZCLS_hostent_HEAP, L_temp_5);
		not_reached();
	    }
	}
	else {
	    L_temp_6.heapptr = &networkZstr_ROOT_14;
	    L_temp_6.dataword.l = 0;
	    /* type-error-with-location */
	    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp_4, &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP, L_temp_6);
	    not_reached();
	}
    }
    else {
	L_temp_7.heapptr = &networkZstr_ROOT_101;
	L_temp_7.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_arg2, &dylanZdylan_visceraZCLS_integer_HEAP, L_temp_7);
	not_reached();
    }
}

/* generic-entry for pointer-value{<hostent*>} */
descriptor_t * networkZnetwork_internalZpointer_value_METH_GENERIC_49(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    descriptor_t L_arg; /* arg */
    heapptr_t L_rest; /* rest */
    void * L_arg_2; /* arg */
    descriptor_t L_index; /* index */
    long L_index_2; /* index */
    descriptor_t L_key; /* key */
    descriptor_t L_value; /* value */
    void * L_result0; /* result0 */
    descriptor_t L_temp;

    /* #line {Class <unknown-source-location>} */
    L_args = ((void *)(orig_sp - A_nargs));
    L_arg = (((descriptor_t *)L_args)[0]);
    L_rest = dylanZdylan_visceraZmake_rest_arg_FUN(orig_sp, (descriptor_t *)L_args + 1, A_nargs - 1);
    L_arg_2 = L_arg.dataword.ptr;
    L_index.heapptr = networkZliteral_2.heapptr;
    L_index.dataword.l = 0;
    L_index_2 = (A_nargs - 2);
    while (1) {
	if ((L_index_2 < 1)) {
	    goto block0;
	}
	else {
	    L_key = (((descriptor_t *)L_args)[L_index_2]);
	    L_value = (((descriptor_t *)L_args)[(L_index_2 + 1)]);
	    if ((L_key.heapptr == &SYM_index_HEAP)) {
		L_index = L_value;
	    }
	    L_index_2 = (L_index_2 - 2);
	}
    }
  block0:;
    orig_sp = L_args;
    /* pointer-value{<hostent*>} */
    L_result0 = networkZnetwork_internalZpointer_value_METH_49(orig_sp, L_arg_2, A_next_method_info, L_rest, L_index);
    L_temp.heapptr = networkZliteral_63.heapptr;
    L_temp.dataword.ptr = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* Define Method pointer-value-setter{<hostent>, <hostent*>} */

/* pointer-value-setter{<hostent>, <hostent*>} */
void * networkZnetwork_internalZpointer_value_setter_METH_13(descriptor_t *orig_sp, void * A_value /* value */, void * A_ptr /* ptr */, heapptr_t A_next_method_info /* next-method-info */, heapptr_t A_rest /* rest */, descriptor_t A_index /* index */)
{
    descriptor_t *cluster_0_top;
    descriptor_t L_temp;
    descriptor_t L_arg3; /* arg3 */
    descriptor_t L_temp_2;


    /* #line 3031 "./sockets-api.dylan" */
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = 4;
    orig_sp[0] = A_index;
    orig_sp[1] = L_temp;
    /* * */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZV_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_arg3 = (orig_sp == cluster_0_top ? dylanZfalse : orig_sp[0]);

    /* #line 386 "./condition.dylan" */
    if ((&dylanZdylan_visceraZCLS_integer_HEAP == SLOT(L_arg3.heapptr, heapptr_t, 0))) {
	/* #line {Class <unknown-source-location>} */

	/* #line 299 "./melange.dylan" */
	/* #line {Class <unknown-source-location>} */

	/* #line 97 "./rawptr.dylan" */
	*(void * *)((char *)A_ptr + L_arg3.dataword.l) = A_value;
	return A_value;
    }
    else {

	/* #line 389 "./condition.dylan" */
	L_temp_2.heapptr = &networkZstr_ROOT;
	L_temp_2.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_arg3, &dylanZdylan_visceraZCLS_integer_HEAP, L_temp_2);
	not_reached();
    }
}

/* generic-entry for pointer-value-setter{<hostent>, <hostent*>} */
descriptor_t * networkZnetwork_internalZpointer_value_setter_METH_GENERIC_13(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    descriptor_t L_arg; /* arg */
    descriptor_t L_arg_2; /* arg */
    heapptr_t L_rest; /* rest */
    void * L_arg_3; /* arg */
    void * L_arg_4; /* arg */
    descriptor_t L_index; /* index */
    long L_index_2; /* index */
    descriptor_t L_key; /* key */
    descriptor_t L_value; /* value */
    void * L_result0; /* result0 */
    descriptor_t L_temp;

    /* #line {Class <unknown-source-location>} */
    L_args = ((void *)(orig_sp - A_nargs));
    L_arg = (((descriptor_t *)L_args)[0]);
    L_arg_2 = (((descriptor_t *)L_args)[1]);
    L_rest = dylanZdylan_visceraZmake_rest_arg_FUN(orig_sp, (descriptor_t *)L_args + 2, A_nargs - 2);
    L_arg_3 = L_arg.dataword.ptr;
    L_arg_4 = L_arg_2.dataword.ptr;
    L_index.heapptr = networkZliteral_2.heapptr;
    L_index.dataword.l = 0;
    L_index_2 = (A_nargs - 2);
    while (1) {
	if ((L_index_2 < 2)) {
	    goto block0;
	}
	else {
	    L_key = (((descriptor_t *)L_args)[L_index_2]);
	    L_value = (((descriptor_t *)L_args)[(L_index_2 + 1)]);
	    if ((L_key.heapptr == &SYM_index_HEAP)) {
		L_index = L_value;
	    }
	    L_index_2 = (L_index_2 - 2);
	}
    }
  block0:;
    orig_sp = L_args;
    /* pointer-value-setter{<hostent>, <hostent*>} */
    L_result0 = networkZnetwork_internalZpointer_value_setter_METH_13(orig_sp, L_arg_3, L_arg_4, A_next_method_info, L_rest, L_index);
    L_temp.heapptr = networkZliteral_63.heapptr;
    L_temp.dataword.ptr = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* Define Method content-size{subclass(<hostent*>)} */

/* content-size{subclass(<hostent*>)} */
long networkZnetwork_internalZcontent_size_METH_62(descriptor_t *orig_sp, heapptr_t A0, heapptr_t A1)
{

    return 4;
}

/* generic-entry for content-size{subclass(<hostent*>)} */
descriptor_t * networkZnetwork_internalZcontent_size_METH_GENERIC_62(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    long L_result0; /* result0 */
    descriptor_t L_temp;

    orig_sp = ((void *)(orig_sp - 1));
    /* content-size{subclass(<hostent*>)} */
    L_result0 = networkZnetwork_internalZcontent_size_METH_62(orig_sp, &networkZnetwork_internalZCLS_hostentV_HEAP, A_next_method_info);
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* {Implicit} Define Generic gethostent-r */

/* gethostent-r is gethostent-r */


/* Define Method gethostent-r{<hostent>, <c-char-vector>, <integer>, <hostent*>, <int*>} */

/* gethostent-r{<hostent>, <c-char-vector>, <integer>, <hostent*>, <int*>} */
long networkZnetwork_internalZgethostent_r_METH(descriptor_t *orig_sp, void * A_arg1 /* arg1 */, descriptor_t A_arg2 /* arg2 */, long A_arg3 /* arg3 */, void * A_arg4 /* arg4 */, descriptor_t A_arg5 /* arg5 */, heapptr_t A5)
{
    descriptor_t *cluster_0_top;
    long L_result_value; /* result-value */


    /* #line 3043 "./sockets-api.dylan" */

    /* #line 3043 "./sockets-api.dylan" */

    /* #line 3043 "./sockets-api.dylan" */

    /* #line 3043 "./sockets-api.dylan" */

    /* #line 735 "./macros.dylan" */
    L_result_value = gethostent_r(A_arg1, A_arg2.dataword.ptr, A_arg3, A_arg4, A_arg5.dataword.ptr);
    return L_result_value;
}


/* {Implicit} Define Generic gethostbyaddr-r */

/* gethostbyaddr-r is gethostbyaddr-r */


/* Define Method gethostbyaddr-r{<machine-pointer>, <integer>, <integer>, <hostent>, <c-char-vector>, <integer>, <hostent*>, <int*>} */

/* gethostbyaddr-r{<machine-pointer>, <integer>, <integer>, <hostent>, <c-char-vector>, <integer>, <hostent*>, <int*>} */
long networkZnetwork_internalZgethostbyaddr_r_METH(descriptor_t *orig_sp, void * A_arg1 /* arg1 */, long A_arg2 /* arg2 */, long A_arg3 /* arg3 */, void * A_arg4 /* arg4 */, descriptor_t A_arg5 /* arg5 */, long A_arg6 /* arg6 */, void * A_arg7 /* arg7 */, descriptor_t A_arg8 /* arg8 */, heapptr_t A8)
{
    descriptor_t *cluster_0_top;
    long L_result_value; /* result-value */

    /* #line {Class <unknown-source-location>} */

    /* #line 3051 "./sockets-api.dylan" */

    /* #line 3051 "./sockets-api.dylan" */

    /* #line 3051 "./sockets-api.dylan" */

    /* #line 3051 "./sockets-api.dylan" */

    /* #line 3051 "./sockets-api.dylan" */

    /* #line 735 "./macros.dylan" */
    L_result_value = gethostbyaddr_r(A_arg1, A_arg2, A_arg3, A_arg4, A_arg5.dataword.ptr, A_arg6, A_arg7, A_arg8.dataword.ptr);
    return L_result_value;
}


/* {Implicit} Define Generic gethostbyname-r */

/* gethostbyname-r is gethostbyname-r */


/* Define Method gethostbyname-r{<c-char-vector>, <hostent>, <c-char-vector>, <integer>, <hostent*>, <int*>} */

/* gethostbyname-r{<c-char-vector>, <hostent>, <c-char-vector>, <integer>, <hostent*>, <int*>} */
long networkZnetwork_internalZgethostbyname_r_METH(descriptor_t *orig_sp, descriptor_t A_arg1 /* arg1 */, void * A_arg2 /* arg2 */, descriptor_t A_arg3 /* arg3 */, long A_arg4 /* arg4 */, void * A_arg5 /* arg5 */, descriptor_t A_arg6 /* arg6 */, heapptr_t A6)
{
    descriptor_t *cluster_0_top;
    long L_result_value; /* result-value */

    /* #line {Class <unknown-source-location>} */

    /* #line 3059 "./sockets-api.dylan" */

    /* #line 3059 "./sockets-api.dylan" */

    /* #line 3059 "./sockets-api.dylan" */

    /* #line 3059 "./sockets-api.dylan" */

    /* #line 3059 "./sockets-api.dylan" */

    /* #line 735 "./macros.dylan" */
    L_result_value = gethostbyname_r(A_arg1.dataword.ptr, A_arg2, A_arg3.dataword.ptr, A_arg4, A_arg5, A_arg6.dataword.ptr);
    return L_result_value;
}


/* {Implicit} Define Generic gethostbyname2-r */

/* gethostbyname2-r is gethostbyname2-r */


/* Define Method gethostbyname2-r{<c-char-vector>, <integer>, <hostent>, <c-char-vector>, <integer>, <hostent*>, <int*>} */

/* gethostbyname2-r{<c-char-vector>, <integer>, <hostent>, <c-char-vector>, <integer>, <hostent*>, <int*>} */
long networkZnetwork_internalZgethostbyname2_r_METH(descriptor_t *orig_sp, descriptor_t A_arg1 /* arg1 */, long A_arg2 /* arg2 */, void * A_arg3 /* arg3 */, descriptor_t A_arg4 /* arg4 */, long A_arg5 /* arg5 */, void * A_arg6 /* arg6 */, descriptor_t A_arg7 /* arg7 */, heapptr_t A7)
{
    descriptor_t *cluster_0_top;
    long L_result_value; /* result-value */

    /* #line {Class <unknown-source-location>} */

    /* #line 3067 "./sockets-api.dylan" */

    /* #line 3067 "./sockets-api.dylan" */

    /* #line 3067 "./sockets-api.dylan" */

    /* #line 3067 "./sockets-api.dylan" */

    /* #line 3067 "./sockets-api.dylan" */

    /* #line 735 "./macros.dylan" */
    L_result_value = gethostbyname2_r(A_arg1.dataword.ptr, A_arg2, A_arg3, A_arg4.dataword.ptr, A_arg5, A_arg6, A_arg7.dataword.ptr);
    return L_result_value;
}


/* {Implicit} Define Generic setnetent */

/* setnetent is setnetent */


/* Define Method setnetent{<integer>} */

/* setnetent{<integer>} */
void networkZnetwork_internalZsetnetent_METH(descriptor_t *orig_sp, long A_arg1 /* arg1 */, heapptr_t A1)
{
    descriptor_t *cluster_0_top;

    /* #line {Class <unknown-source-location>} */

    /* #line 735 "./macros.dylan" */
    setnetent(A_arg1);
    return;
}


/* {Implicit} Define Generic endnetent */

/* endnetent is endnetent */


/* Define Method endnetent{} */

/* endnetent{} */
void networkZnetwork_internalZendnetent_METH(descriptor_t *orig_sp, heapptr_t A0)
{
    descriptor_t *cluster_0_top;

    /* #line {Class <unknown-source-location>} */

    /* #line 735 "./macros.dylan" */
    endnetent();
    return;
}


/* Define Class <netent> */

/* <netent> is <netent> */

extern struct heapobj networkZnetwork_internalZCLS_netent_HEAP;

/* maker for <netent> */
void * networkZnetwork_internalZCLS_netent_MAKER_FUN(descriptor_t *orig_sp, void * A_pointer /* pointer */, int A_pointer_suppliedQUERY /* pointer-supplied? */)
{
    descriptor_t *cluster_0_top;


    /* #line 3085 "./sockets-api.dylan" */
    if (A_pointer_suppliedQUERY) {
	return A_pointer;
    }
    else {
	/* missing-required-init-keyword-error */
	dylanZdylan_visceraZmissing_required_init_keyword_error_FUN(orig_sp, &SYM_pointer_HEAP, &networkZnetwork_internalZCLS_netent_HEAP);
	not_reached();
    }
}

extern descriptor_t networkZliteral_65;	/* proxy for <netent> */

/* general-entry for maker for <netent> */
descriptor_t * networkZnetwork_internalZCLS_netent_MAKER_GENERAL(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    void * L_pointer; /* pointer */
    int L_pointer_suppliedQUERY; /* pointer-supplied? */
    long L_index; /* index */
    descriptor_t L_temp; /* temp */
    descriptor_t L_value; /* value */
    descriptor_t L_temp_2;
    descriptor_t L_temp_3;
    void * L_result0; /* result0 */
    descriptor_t L_temp_4;

    /* #line {Class <unknown-source-location>} */

    /* #line 126 "./cmp.dylan" */

    /* #line 209 "./num.dylan" */
    if (((A_nargs & 1) == 0)) {
	/* #line {Class <unknown-source-location>} */
	L_args = ((void *)(orig_sp - A_nargs));
	L_pointer = 0;
	L_pointer_suppliedQUERY = FALSE;
	L_index = (A_nargs - 2);
	while (1) {
	    if ((L_index < 0)) {
		goto block0;
	    }
	    else {
		L_temp = (((descriptor_t *)L_args)[L_index]);

		/* #line 386 "./condition.dylan" */
		if ((&dylanZdylan_visceraZCLS_symbol_HEAP == SLOT(L_temp.heapptr, heapptr_t, 0))) {
		    /* #line {Class <unknown-source-location>} */
		    L_value = (((descriptor_t *)L_args)[(L_index + 1)]);
		    if ((L_temp.heapptr == &SYM_pointer_HEAP)) {

			/* #line 386 "./condition.dylan" */
			if ((&dylanZdylan_visceraZCLS_raw_pointer_HEAP == SLOT(L_value.heapptr, heapptr_t, 0))) {
			    /* #line {Class <unknown-source-location>} */
			    L_pointer = L_value.dataword.ptr;
			    L_pointer_suppliedQUERY = TRUE;
			}
			else {

			    /* #line 389 "./condition.dylan" */
			    L_temp_2.heapptr = &networkZstr_ROOT;
			    L_temp_2.dataword.l = 0;
			    /* type-error-with-location */
			    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_value, &dylanZdylan_visceraZCLS_raw_pointer_HEAP, L_temp_2);
			    not_reached();
			}
		    }
		    /* #line {Class <unknown-source-location>} */
		    L_index = (L_index - 2);
		}
		else {

		    /* #line 389 "./condition.dylan" */
		    L_temp_3.heapptr = &networkZstr_ROOT;
		    L_temp_3.dataword.l = 0;
		    /* type-error-with-location */
		    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp, &dylanZdylan_visceraZCLS_symbol_HEAP, L_temp_3);
		    not_reached();
		}
	    }
	}
      block0:;
	/* #line {Class <unknown-source-location>} */
	orig_sp = L_args;
	/* maker for <netent> */
	L_result0 = networkZnetwork_internalZCLS_netent_MAKER_FUN(orig_sp, L_pointer, L_pointer_suppliedQUERY);
	L_temp_4.heapptr = networkZliteral_65.heapptr;
	L_temp_4.dataword.ptr = L_result0;
	orig_sp[0] = L_temp_4;
	return orig_sp + 1;
    }
    else {
	/* odd-number-of-keyword/value-arguments-error */
	dylanZdylan_visceraZodd_number_of_keywordSLASHvalue_arguments_error_FUN(orig_sp);
	not_reached();
    }
}


/* Define Sealed Domain make (singleton(<netent>)) */


/* {Implicit} Define Generic get-n-name */

/* get-n-name is get-n-name */


/* Define Method get-n-name{<netent>} */

extern struct heapobj networkZstr_ROOT_102;

/* get-n-name{<netent>} */
descriptor_t networkZnetwork_internalZget_n_name_METH(descriptor_t *orig_sp, void * A_ptr /* ptr */, heapptr_t A1)
{
    descriptor_t *cluster_0_top;
    descriptor_t L_temp;
    descriptor_t L_temp_2;
    descriptor_t L_temp_3; /* temp */
    int L_condition; /* condition */
    descriptor_t L_result; /* result */
    heapptr_t L_PCTobject_class; /* %object-class */
    int L_temp_4; /* temp */
    descriptor_t L_temp_5;
    descriptor_t L_temp_6;


    /* #line 290 "./melange.dylan" */

    /* #line 91 "./rawptr.dylan" */

    /* #line 290 "./melange.dylan" */
    L_temp.heapptr = &networkZnetwork_internalZCLS_c_char_vector_HEAP;
    L_temp.dataword.l = 0;
    L_temp_2.heapptr = networkZliteral_6.heapptr;
    L_temp_2.dataword.ptr = (*(void * *)((char *)A_ptr + 0 ));
    orig_sp[0] = L_temp;
    orig_sp[1] = L_temp_2;
    /* as */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZas_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_temp_3 = orig_sp[0];

    /* #line 49 "./object.dylan" */

    /* #line 386 "./condition.dylan" */
    /* %subtype?{<class>, <class>} */
    L_condition = dylanZdylan_visceraZPCTsubtypeQUERY_METH(orig_sp, SLOT(L_temp_3.heapptr, heapptr_t, 0), &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP, &dylanZliteral_ROOT_2);
    if (L_condition) {

	/* #line 290 "./melange.dylan" */
	L_result = L_temp_3;

	/* #line 386 "./condition.dylan" */
	L_PCTobject_class = SLOT(L_result.heapptr, heapptr_t, 0);
	if ((&networkZnetwork_internalZCLS_charLESSX4040GREATER_HEAP == L_PCTobject_class)) {
	    L_temp_4 = TRUE;
	}
	else if ((&networkZnetwork_internalZCLS_charLESSX40120GREATER_HEAP == L_PCTobject_class)) {
	    L_temp_4 = TRUE;
	}
	else if ((&networkZnetwork_internalZCLS_charLESSX4014GREATER_HEAP == L_PCTobject_class)) {
	    L_temp_4 = TRUE;
	}
	else {
	    L_temp_4 = (&networkZnetwork_internalZCLS_c_char_vector_HEAP == L_PCTobject_class);
	}
	if (L_temp_4) {

	    /* #line 3091 "./sockets-api.dylan" */
	    return L_result;
	}
	else {

	    /* #line 389 "./condition.dylan" */
	    L_temp_5.heapptr = &networkZstr_ROOT_102;
	    L_temp_5.dataword.l = 0;
	    /* type-error-with-location */
	    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_result, &networkZnetwork_internalZCLS_c_char_vector_HEAP, L_temp_5);
	    not_reached();
	}
    }
    else {
	L_temp_6.heapptr = &networkZstr_ROOT_14;
	L_temp_6.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp_3, &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP, L_temp_6);
	not_reached();
    }
}


/* {Implicit} Define Generic get-n-name-setter */

/* get-n-name-setter is get-n-name-setter */


/* Define Method get-n-name-setter{<c-char-vector>, <netent>} */

/* get-n-name-setter{<c-char-vector>, <netent>} */
descriptor_t networkZnetwork_internalZget_n_name_setter_METH(descriptor_t *orig_sp, descriptor_t A_value /* value */, void * A_ptr /* ptr */, heapptr_t A2)
{
    descriptor_t *cluster_0_top;

    /* #line {Class <unknown-source-location>} */

    /* #line 299 "./melange.dylan" */
    /* #line {Class <unknown-source-location>} */

    /* #line 97 "./rawptr.dylan" */
    *(void * *)((char *)A_ptr + 0) = A_value.dataword.ptr;
    return A_value;
}


/* {Implicit} Define Generic get-n-aliases */

/* get-n-aliases is get-n-aliases */


/* Define Method get-n-aliases{<netent>} */

extern struct heapobj networkZstr_ROOT_103;

/* get-n-aliases{<netent>} */
void * networkZnetwork_internalZget_n_aliases_METH(descriptor_t *orig_sp, void * A_ptr /* ptr */, heapptr_t A1)
{
    descriptor_t *cluster_0_top;
    descriptor_t L_temp;
    descriptor_t L_temp_2;
    descriptor_t L_temp_3; /* temp */
    int L_condition; /* condition */
    descriptor_t L_result; /* result */
    descriptor_t L_temp_4;
    descriptor_t L_temp_5;

    /* #line {Class <unknown-source-location>} */

    /* #line 290 "./melange.dylan" */

    /* #line 91 "./rawptr.dylan" */

    /* #line 290 "./melange.dylan" */
    L_temp.heapptr = &networkZnetwork_internalZCLS_c_char_pointer_vector_HEAP;
    L_temp.dataword.l = 0;
    L_temp_2.heapptr = networkZliteral_6.heapptr;
    L_temp_2.dataword.ptr = (*(void * *)((char *)A_ptr + 4 ));
    orig_sp[0] = L_temp;
    orig_sp[1] = L_temp_2;
    /* as */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZas_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_temp_3 = orig_sp[0];

    /* #line 49 "./object.dylan" */

    /* #line 386 "./condition.dylan" */
    /* %subtype?{<class>, <class>} */
    L_condition = dylanZdylan_visceraZPCTsubtypeQUERY_METH(orig_sp, SLOT(L_temp_3.heapptr, heapptr_t, 0), &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP, &dylanZliteral_ROOT_2);
    if (L_condition) {

	/* #line 290 "./melange.dylan" */
	L_result = L_temp_3;

	/* #line 386 "./condition.dylan" */
	if ((&networkZnetwork_internalZCLS_c_char_pointer_vector_HEAP == SLOT(L_result.heapptr, heapptr_t, 0))) {

	    /* #line 3102 "./sockets-api.dylan" */
	    return L_result.dataword.ptr;
	}
	else {

	    /* #line 389 "./condition.dylan" */
	    L_temp_4.heapptr = &networkZstr_ROOT_103;
	    L_temp_4.dataword.l = 0;
	    /* type-error-with-location */
	    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_result, &networkZnetwork_internalZCLS_c_char_pointer_vector_HEAP, L_temp_4);
	    not_reached();
	}
    }
    else {
	L_temp_5.heapptr = &networkZstr_ROOT_14;
	L_temp_5.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp_3, &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP, L_temp_5);
	not_reached();
    }
}


/* {Implicit} Define Generic get-n-aliases-setter */

/* get-n-aliases-setter is get-n-aliases-setter */


/* Define Method get-n-aliases-setter{<c-char-pointer-vector>, <netent>} */

/* get-n-aliases-setter{<c-char-pointer-vector>, <netent>} */
void * networkZnetwork_internalZget_n_aliases_setter_METH(descriptor_t *orig_sp, void * A_value /* value */, void * A_ptr /* ptr */, heapptr_t A2)
{
    descriptor_t *cluster_0_top;

    /* #line {Class <unknown-source-location>} */

    /* #line 299 "./melange.dylan" */
    /* #line {Class <unknown-source-location>} */

    /* #line 97 "./rawptr.dylan" */
    *(void * *)((char *)A_ptr + 4) = A_value;
    return A_value;
}


/* {Implicit} Define Generic get-n-addrtype */

/* get-n-addrtype is get-n-addrtype */


/* Define Method get-n-addrtype{<netent>} */

/* get-n-addrtype{<netent>} */
long networkZnetwork_internalZget_n_addrtype_METH(descriptor_t *orig_sp, void * A_ptr /* ptr */, heapptr_t A1)
{
    descriptor_t *cluster_0_top;

    /* #line {Class <unknown-source-location>} */

    /* #line 198 "./melange.dylan" */

    /* #line 91 "./rawptr.dylan" */
    return (*(long *)((char *)A_ptr + 8 ));
}


/* {Implicit} Define Generic get-n-addrtype-setter */

/* get-n-addrtype-setter is get-n-addrtype-setter */


/* Define Method get-n-addrtype-setter{<integer>, <netent>} */

/* get-n-addrtype-setter{<integer>, <netent>} */
long networkZnetwork_internalZget_n_addrtype_setter_METH(descriptor_t *orig_sp, long A_value /* value */, void * A_ptr /* ptr */, heapptr_t A2)
{
    descriptor_t *cluster_0_top;

    /* #line {Class <unknown-source-location>} */

    /* #line 97 "./rawptr.dylan" */
    *(long *)((char *)A_ptr + 8) = A_value;
    return A_value;
}


/* {Implicit} Define Generic get-n-net */

/* get-n-net is get-n-net */


/* Define Method get-n-net{<netent>} */

/* get-n-net{<netent>} */
long networkZnetwork_internalZget_n_net_METH(descriptor_t *orig_sp, void * A_ptr /* ptr */, heapptr_t A1)
{
    descriptor_t *cluster_0_top;

    /* #line {Class <unknown-source-location>} */

    /* #line 211 "./melange.dylan" */

    /* #line 91 "./rawptr.dylan" */
    return (*(long *)((char *)A_ptr + 12 ));
}


/* {Implicit} Define Generic get-n-net-setter */

/* get-n-net-setter is get-n-net-setter */


/* Define Method get-n-net-setter{<integer>, <netent>} */

/* get-n-net-setter{<integer>, <netent>} */
long networkZnetwork_internalZget_n_net_setter_METH(descriptor_t *orig_sp, long A_value /* value */, void * A_ptr /* ptr */, heapptr_t A2)
{
    descriptor_t *cluster_0_top;

    /* #line {Class <unknown-source-location>} */

    /* #line 97 "./rawptr.dylan" */
    *(long *)((char *)A_ptr + 12) = A_value;
    return A_value;
}


/* Define Method pointer-value{<netent>} */

extern struct heapobj networkZstr_ROOT_104;

/* pointer-value{<netent>} */
void * networkZnetwork_internalZpointer_value_METH_50(descriptor_t *orig_sp, void * A_value /* value */, heapptr_t A_next_method_info /* next-method-info */, heapptr_t A_rest /* rest */, descriptor_t A_index /* index */)
{
    descriptor_t *cluster_0_top;
    descriptor_t L_temp;
    descriptor_t L_arg1; /* arg1 */
    descriptor_t L_temp_2;
    descriptor_t L_temp_3; /* temp */
    descriptor_t L_temp_4;

    /* #line {Class <unknown-source-location>} */

    /* #line 3134 "./sockets-api.dylan" */
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = 16;
    orig_sp[0] = A_index;
    orig_sp[1] = L_temp;
    /* * */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZV_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_arg1 = (orig_sp == cluster_0_top ? dylanZfalse : orig_sp[0]);

    /* #line 3134 "./sockets-api.dylan" */
    L_temp_2.heapptr = networkZliteral_65.heapptr;
    L_temp_2.dataword.ptr = A_value;
    orig_sp[0] = L_temp_2;
    orig_sp[1] = L_arg1;
    /* + */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZPLUS_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_temp_3 = (orig_sp == cluster_0_top ? dylanZfalse : orig_sp[0]);

    /* #line 386 "./condition.dylan" */
    if ((&networkZnetwork_internalZCLS_netent_HEAP == SLOT(L_temp_3.heapptr, heapptr_t, 0))) {

	/* #line 3134 "./sockets-api.dylan" */
	return L_temp_3.dataword.ptr;
    }
    else {

	/* #line 389 "./condition.dylan" */
	L_temp_4.heapptr = &networkZstr_ROOT_104;
	L_temp_4.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp_3, &networkZnetwork_internalZCLS_netent_HEAP, L_temp_4);
	not_reached();
    }
}

/* generic-entry for pointer-value{<netent>} */
descriptor_t * networkZnetwork_internalZpointer_value_METH_GENERIC_50(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    descriptor_t L_arg; /* arg */
    heapptr_t L_rest; /* rest */
    void * L_arg_2; /* arg */
    descriptor_t L_index; /* index */
    long L_index_2; /* index */
    descriptor_t L_key; /* key */
    descriptor_t L_value; /* value */
    void * L_result0; /* result0 */
    descriptor_t L_temp;

    /* #line {Class <unknown-source-location>} */
    L_args = ((void *)(orig_sp - A_nargs));
    L_arg = (((descriptor_t *)L_args)[0]);
    L_rest = dylanZdylan_visceraZmake_rest_arg_FUN(orig_sp, (descriptor_t *)L_args + 1, A_nargs - 1);
    L_arg_2 = L_arg.dataword.ptr;
    L_index.heapptr = networkZliteral_2.heapptr;
    L_index.dataword.l = 0;
    L_index_2 = (A_nargs - 2);
    while (1) {
	if ((L_index_2 < 1)) {
	    goto block0;
	}
	else {
	    L_key = (((descriptor_t *)L_args)[L_index_2]);
	    L_value = (((descriptor_t *)L_args)[(L_index_2 + 1)]);
	    if ((L_key.heapptr == &SYM_index_HEAP)) {
		L_index = L_value;
	    }
	    L_index_2 = (L_index_2 - 2);
	}
    }
  block0:;
    orig_sp = L_args;
    /* pointer-value{<netent>} */
    L_result0 = networkZnetwork_internalZpointer_value_METH_50(orig_sp, L_arg_2, A_next_method_info, L_rest, L_index);
    L_temp.heapptr = networkZliteral_65.heapptr;
    L_temp.dataword.ptr = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* Define Method content-size{subclass(<netent>)} */

/* content-size{subclass(<netent>)} */
long networkZnetwork_internalZcontent_size_METH_63(descriptor_t *orig_sp, heapptr_t A0, heapptr_t A1)
{

    return 16;
}

/* generic-entry for content-size{subclass(<netent>)} */
descriptor_t * networkZnetwork_internalZcontent_size_METH_GENERIC_63(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    long L_result0; /* result0 */
    descriptor_t L_temp;

    orig_sp = ((void *)(orig_sp - 1));
    /* content-size{subclass(<netent>)} */
    L_result0 = networkZnetwork_internalZcontent_size_METH_63(orig_sp, &networkZnetwork_internalZCLS_netent_HEAP, A_next_method_info);
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* {Implicit} Define Generic getnetent */

/* getnetent is getnetent */


/* Define Method getnetent{} */

extern struct heapobj networkZstr_ROOT_105;

/* getnetent{} */
void * networkZnetwork_internalZgetnetent_METH(descriptor_t *orig_sp, heapptr_t A0)
{
    descriptor_t *cluster_0_top;
    void * L_result_value; /* result-value */
    heapptr_t L_instance; /* instance */
    descriptor_t L_temp;
    descriptor_t L_temp_2;
    descriptor_t L_temp_3;
    descriptor_t L_result_value_2; /* result-value */
    descriptor_t L_temp_4;


    /* #line 735 "./macros.dylan" */
    L_result_value = getnetent();

    /* #line 3146 "./sockets-api.dylan" */
    /* maker for <simple-object-vector> */
    L_instance = dylanZdylan_visceraZCLS_simple_object_vector_MAKER_FUN(orig_sp, 2, dylanZfalse);
    L_temp.heapptr = &SYM_pointer_HEAP;
    L_temp.dataword.l = 0;
    SLOT(L_instance, descriptor_t, 8 + 0 * sizeof(descriptor_t)) = L_temp;
    L_temp_2.heapptr = networkZliteral_6.heapptr;
    L_temp_2.dataword.ptr = L_result_value;
    SLOT(L_instance, descriptor_t, 8 + 1 * sizeof(descriptor_t)) = L_temp_2;
    L_temp_3.heapptr = networkZliteral_6.heapptr;
    L_temp_3.dataword.ptr = L_result_value;
    /* make{subclass(<statically-typed-pointer>)} */
    L_result_value_2 = melange_supportZmelange_supportZmake_METH(orig_sp, &networkZnetwork_internalZCLS_netent_HEAP, &networkZliteral_ROOT, L_instance, 0, L_temp_3, 1);

    /* #line 386 "./condition.dylan" */
    if ((&networkZnetwork_internalZCLS_netent_HEAP == SLOT(L_result_value_2.heapptr, heapptr_t, 0))) {

	/* #line 3147 "./sockets-api.dylan" */
	return L_result_value_2.dataword.ptr;
    }
    else {

	/* #line 389 "./condition.dylan" */
	L_temp_4.heapptr = &networkZstr_ROOT_105;
	L_temp_4.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_result_value_2, &networkZnetwork_internalZCLS_netent_HEAP, L_temp_4);
	not_reached();
    }
}


/* {Implicit} Define Generic getnetbyaddr */

/* getnetbyaddr is getnetbyaddr */


/* Define Method getnetbyaddr{<integer>, <integer>} */

extern struct heapobj networkZstr_ROOT_106;

/* getnetbyaddr{<integer>, <integer>} */
void * networkZnetwork_internalZgetnetbyaddr_METH(descriptor_t *orig_sp, long A_arg1 /* arg1 */, long A_arg2 /* arg2 */, heapptr_t A2)
{
    descriptor_t *cluster_0_top;
    void * L_result_value; /* result-value */
    heapptr_t L_instance; /* instance */
    descriptor_t L_temp;
    descriptor_t L_temp_2;
    descriptor_t L_temp_3;
    descriptor_t L_result_value_2; /* result-value */
    descriptor_t L_temp_4;

    /* #line {Class <unknown-source-location>} */

    /* #line 735 "./macros.dylan" */
    L_result_value = getnetbyaddr(A_arg1, A_arg2);

    /* #line 3155 "./sockets-api.dylan" */
    /* maker for <simple-object-vector> */
    L_instance = dylanZdylan_visceraZCLS_simple_object_vector_MAKER_FUN(orig_sp, 2, dylanZfalse);
    L_temp.heapptr = &SYM_pointer_HEAP;
    L_temp.dataword.l = 0;
    SLOT(L_instance, descriptor_t, 8 + 0 * sizeof(descriptor_t)) = L_temp;
    L_temp_2.heapptr = networkZliteral_6.heapptr;
    L_temp_2.dataword.ptr = L_result_value;
    SLOT(L_instance, descriptor_t, 8 + 1 * sizeof(descriptor_t)) = L_temp_2;
    L_temp_3.heapptr = networkZliteral_6.heapptr;
    L_temp_3.dataword.ptr = L_result_value;
    /* make{subclass(<statically-typed-pointer>)} */
    L_result_value_2 = melange_supportZmelange_supportZmake_METH(orig_sp, &networkZnetwork_internalZCLS_netent_HEAP, &networkZliteral_ROOT, L_instance, 0, L_temp_3, 1);

    /* #line 386 "./condition.dylan" */
    if ((&networkZnetwork_internalZCLS_netent_HEAP == SLOT(L_result_value_2.heapptr, heapptr_t, 0))) {

	/* #line 3156 "./sockets-api.dylan" */
	return L_result_value_2.dataword.ptr;
    }
    else {

	/* #line 389 "./condition.dylan" */
	L_temp_4.heapptr = &networkZstr_ROOT_106;
	L_temp_4.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_result_value_2, &networkZnetwork_internalZCLS_netent_HEAP, L_temp_4);
	not_reached();
    }
}


/* {Implicit} Define Generic getnetbyname */

/* getnetbyname is getnetbyname */


/* Define Method getnetbyname{<c-char-vector>} */

extern struct heapobj networkZstr_ROOT_107;

/* getnetbyname{<c-char-vector>} */
void * networkZnetwork_internalZgetnetbyname_METH(descriptor_t *orig_sp, descriptor_t A_arg1 /* arg1 */, heapptr_t A1)
{
    descriptor_t *cluster_0_top;
    void * L_result_value; /* result-value */
    heapptr_t L_instance; /* instance */
    descriptor_t L_temp;
    descriptor_t L_temp_2;
    descriptor_t L_temp_3;
    descriptor_t L_result_value_2; /* result-value */
    descriptor_t L_temp_4;

    /* #line {Class <unknown-source-location>} */

    /* #line 3163 "./sockets-api.dylan" */

    /* #line 735 "./macros.dylan" */
    L_result_value = getnetbyname(A_arg1.dataword.ptr);

    /* #line 3164 "./sockets-api.dylan" */
    /* maker for <simple-object-vector> */
    L_instance = dylanZdylan_visceraZCLS_simple_object_vector_MAKER_FUN(orig_sp, 2, dylanZfalse);
    L_temp.heapptr = &SYM_pointer_HEAP;
    L_temp.dataword.l = 0;
    SLOT(L_instance, descriptor_t, 8 + 0 * sizeof(descriptor_t)) = L_temp;
    L_temp_2.heapptr = networkZliteral_6.heapptr;
    L_temp_2.dataword.ptr = L_result_value;
    SLOT(L_instance, descriptor_t, 8 + 1 * sizeof(descriptor_t)) = L_temp_2;
    L_temp_3.heapptr = networkZliteral_6.heapptr;
    L_temp_3.dataword.ptr = L_result_value;
    /* make{subclass(<statically-typed-pointer>)} */
    L_result_value_2 = melange_supportZmelange_supportZmake_METH(orig_sp, &networkZnetwork_internalZCLS_netent_HEAP, &networkZliteral_ROOT, L_instance, 0, L_temp_3, 1);

    /* #line 386 "./condition.dylan" */
    if ((&networkZnetwork_internalZCLS_netent_HEAP == SLOT(L_result_value_2.heapptr, heapptr_t, 0))) {

	/* #line 3165 "./sockets-api.dylan" */
	return L_result_value_2.dataword.ptr;
    }
    else {

	/* #line 389 "./condition.dylan" */
	L_temp_4.heapptr = &networkZstr_ROOT_107;
	L_temp_4.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_result_value_2, &networkZnetwork_internalZCLS_netent_HEAP, L_temp_4);
	not_reached();
    }
}


/* Define Class <netent*> */

/* <netent*> is <netent*> */

extern struct heapobj networkZnetwork_internalZCLS_netentV_HEAP;

/* maker for <netent*> */
void * networkZnetwork_internalZCLS_netentV_MAKER_FUN(descriptor_t *orig_sp, void * A_pointer /* pointer */, int A_pointer_suppliedQUERY /* pointer-supplied? */)
{
    descriptor_t *cluster_0_top;


    /* #line 3168 "./sockets-api.dylan" */
    if (A_pointer_suppliedQUERY) {
	return A_pointer;
    }
    else {
	/* missing-required-init-keyword-error */
	dylanZdylan_visceraZmissing_required_init_keyword_error_FUN(orig_sp, &SYM_pointer_HEAP, &networkZnetwork_internalZCLS_netentV_HEAP);
	not_reached();
    }
}

extern descriptor_t networkZliteral_66;	/* proxy for <netent*> */

/* general-entry for maker for <netent*> */
descriptor_t * networkZnetwork_internalZCLS_netentV_MAKER_GENERAL(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    void * L_pointer; /* pointer */
    int L_pointer_suppliedQUERY; /* pointer-supplied? */
    long L_index; /* index */
    descriptor_t L_temp; /* temp */
    descriptor_t L_value; /* value */
    descriptor_t L_temp_2;
    descriptor_t L_temp_3;
    void * L_result0; /* result0 */
    descriptor_t L_temp_4;

    /* #line {Class <unknown-source-location>} */

    /* #line 126 "./cmp.dylan" */

    /* #line 209 "./num.dylan" */
    if (((A_nargs & 1) == 0)) {
	/* #line {Class <unknown-source-location>} */
	L_args = ((void *)(orig_sp - A_nargs));
	L_pointer = 0;
	L_pointer_suppliedQUERY = FALSE;
	L_index = (A_nargs - 2);
	while (1) {
	    if ((L_index < 0)) {
		goto block0;
	    }
	    else {
		L_temp = (((descriptor_t *)L_args)[L_index]);

		/* #line 386 "./condition.dylan" */
		if ((&dylanZdylan_visceraZCLS_symbol_HEAP == SLOT(L_temp.heapptr, heapptr_t, 0))) {
		    /* #line {Class <unknown-source-location>} */
		    L_value = (((descriptor_t *)L_args)[(L_index + 1)]);
		    if ((L_temp.heapptr == &SYM_pointer_HEAP)) {

			/* #line 386 "./condition.dylan" */
			if ((&dylanZdylan_visceraZCLS_raw_pointer_HEAP == SLOT(L_value.heapptr, heapptr_t, 0))) {
			    /* #line {Class <unknown-source-location>} */
			    L_pointer = L_value.dataword.ptr;
			    L_pointer_suppliedQUERY = TRUE;
			}
			else {

			    /* #line 389 "./condition.dylan" */
			    L_temp_2.heapptr = &networkZstr_ROOT;
			    L_temp_2.dataword.l = 0;
			    /* type-error-with-location */
			    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_value, &dylanZdylan_visceraZCLS_raw_pointer_HEAP, L_temp_2);
			    not_reached();
			}
		    }
		    /* #line {Class <unknown-source-location>} */
		    L_index = (L_index - 2);
		}
		else {

		    /* #line 389 "./condition.dylan" */
		    L_temp_3.heapptr = &networkZstr_ROOT;
		    L_temp_3.dataword.l = 0;
		    /* type-error-with-location */
		    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp, &dylanZdylan_visceraZCLS_symbol_HEAP, L_temp_3);
		    not_reached();
		}
	    }
	}
      block0:;
	/* #line {Class <unknown-source-location>} */
	orig_sp = L_args;
	/* maker for <netent*> */
	L_result0 = networkZnetwork_internalZCLS_netentV_MAKER_FUN(orig_sp, L_pointer, L_pointer_suppliedQUERY);
	L_temp_4.heapptr = networkZliteral_66.heapptr;
	L_temp_4.dataword.ptr = L_result0;
	orig_sp[0] = L_temp_4;
	return orig_sp + 1;
    }
    else {
	/* odd-number-of-keyword/value-arguments-error */
	dylanZdylan_visceraZodd_number_of_keywordSLASHvalue_arguments_error_FUN(orig_sp);
	not_reached();
    }
}


/* Define Sealed Domain make (singleton(<netent*>)) */


/* Define Method pointer-value{<netent*>} */

extern struct heapobj networkZstr_ROOT_108;

/* pointer-value{<netent*>} */
void * networkZnetwork_internalZpointer_value_METH_51(descriptor_t *orig_sp, void * A_ptr /* ptr */, heapptr_t A_next_method_info /* next-method-info */, heapptr_t A_rest /* rest */, descriptor_t A_index /* index */)
{
    descriptor_t *cluster_0_top;
    descriptor_t L_temp;
    descriptor_t L_arg2; /* arg2 */
    descriptor_t L_temp_2;
    descriptor_t L_temp_3;
    descriptor_t L_temp_4; /* temp */
    int L_condition; /* condition */
    descriptor_t L_result; /* result */
    descriptor_t L_temp_5;
    descriptor_t L_temp_6;
    descriptor_t L_temp_7;


    /* #line 3175 "./sockets-api.dylan" */
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = 4;
    orig_sp[0] = A_index;
    orig_sp[1] = L_temp;
    /* * */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZV_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_arg2 = (orig_sp == cluster_0_top ? dylanZfalse : orig_sp[0]);

    /* #line 386 "./condition.dylan" */
    if ((&dylanZdylan_visceraZCLS_integer_HEAP == SLOT(L_arg2.heapptr, heapptr_t, 0))) {

	/* #line 3175 "./sockets-api.dylan" */

	/* #line 290 "./melange.dylan" */

	/* #line 91 "./rawptr.dylan" */

	/* #line 290 "./melange.dylan" */
	L_temp_2.heapptr = &networkZnetwork_internalZCLS_netent_HEAP;
	L_temp_2.dataword.l = 0;
	L_temp_3.heapptr = networkZliteral_6.heapptr;
	L_temp_3.dataword.ptr = (*(void * *)((char *)A_ptr + L_arg2.dataword.l ));
	orig_sp[0] = L_temp_2;
	orig_sp[1] = L_temp_3;
	/* as */
	{
	  struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZas_HEAP, 2);
	  heapptr_t L_meth = L_temp.R0;
	  heapptr_t L_next_info = L_temp.R1;
	  cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
	}
	L_temp_4 = orig_sp[0];

	/* #line 49 "./object.dylan" */

	/* #line 386 "./condition.dylan" */
	/* %subtype?{<class>, <class>} */
	L_condition = dylanZdylan_visceraZPCTsubtypeQUERY_METH(orig_sp, SLOT(L_temp_4.heapptr, heapptr_t, 0), &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP, &dylanZliteral_ROOT_2);
	if (L_condition) {

	    /* #line 290 "./melange.dylan" */
	    L_result = L_temp_4;

	    /* #line 386 "./condition.dylan" */
	    if ((&networkZnetwork_internalZCLS_netent_HEAP == SLOT(L_result.heapptr, heapptr_t, 0))) {

		/* #line 3175 "./sockets-api.dylan" */
		return L_result.dataword.ptr;
	    }
	    else {

		/* #line 389 "./condition.dylan" */
		L_temp_5.heapptr = &networkZstr_ROOT_108;
		L_temp_5.dataword.l = 0;
		/* type-error-with-location */
		dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_result, &networkZnetwork_internalZCLS_netent_HEAP, L_temp_5);
		not_reached();
	    }
	}
	else {
	    L_temp_6.heapptr = &networkZstr_ROOT_14;
	    L_temp_6.dataword.l = 0;
	    /* type-error-with-location */
	    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp_4, &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP, L_temp_6);
	    not_reached();
	}
    }
    else {
	L_temp_7.heapptr = &networkZstr_ROOT_108;
	L_temp_7.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_arg2, &dylanZdylan_visceraZCLS_integer_HEAP, L_temp_7);
	not_reached();
    }
}

/* generic-entry for pointer-value{<netent*>} */
descriptor_t * networkZnetwork_internalZpointer_value_METH_GENERIC_51(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    descriptor_t L_arg; /* arg */
    heapptr_t L_rest; /* rest */
    void * L_arg_2; /* arg */
    descriptor_t L_index; /* index */
    long L_index_2; /* index */
    descriptor_t L_key; /* key */
    descriptor_t L_value; /* value */
    void * L_result0; /* result0 */
    descriptor_t L_temp;

    /* #line {Class <unknown-source-location>} */
    L_args = ((void *)(orig_sp - A_nargs));
    L_arg = (((descriptor_t *)L_args)[0]);
    L_rest = dylanZdylan_visceraZmake_rest_arg_FUN(orig_sp, (descriptor_t *)L_args + 1, A_nargs - 1);
    L_arg_2 = L_arg.dataword.ptr;
    L_index.heapptr = networkZliteral_2.heapptr;
    L_index.dataword.l = 0;
    L_index_2 = (A_nargs - 2);
    while (1) {
	if ((L_index_2 < 1)) {
	    goto block0;
	}
	else {
	    L_key = (((descriptor_t *)L_args)[L_index_2]);
	    L_value = (((descriptor_t *)L_args)[(L_index_2 + 1)]);
	    if ((L_key.heapptr == &SYM_index_HEAP)) {
		L_index = L_value;
	    }
	    L_index_2 = (L_index_2 - 2);
	}
    }
  block0:;
    orig_sp = L_args;
    /* pointer-value{<netent*>} */
    L_result0 = networkZnetwork_internalZpointer_value_METH_51(orig_sp, L_arg_2, A_next_method_info, L_rest, L_index);
    L_temp.heapptr = networkZliteral_65.heapptr;
    L_temp.dataword.ptr = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* Define Method pointer-value-setter{<netent>, <netent*>} */

/* pointer-value-setter{<netent>, <netent*>} */
void * networkZnetwork_internalZpointer_value_setter_METH_14(descriptor_t *orig_sp, void * A_value /* value */, void * A_ptr /* ptr */, heapptr_t A_next_method_info /* next-method-info */, heapptr_t A_rest /* rest */, descriptor_t A_index /* index */)
{
    descriptor_t *cluster_0_top;
    descriptor_t L_temp;
    descriptor_t L_arg3; /* arg3 */
    descriptor_t L_temp_2;


    /* #line 3181 "./sockets-api.dylan" */
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = 4;
    orig_sp[0] = A_index;
    orig_sp[1] = L_temp;
    /* * */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZV_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_arg3 = (orig_sp == cluster_0_top ? dylanZfalse : orig_sp[0]);

    /* #line 386 "./condition.dylan" */
    if ((&dylanZdylan_visceraZCLS_integer_HEAP == SLOT(L_arg3.heapptr, heapptr_t, 0))) {
	/* #line {Class <unknown-source-location>} */

	/* #line 299 "./melange.dylan" */
	/* #line {Class <unknown-source-location>} */

	/* #line 97 "./rawptr.dylan" */
	*(void * *)((char *)A_ptr + L_arg3.dataword.l) = A_value;
	return A_value;
    }
    else {

	/* #line 389 "./condition.dylan" */
	L_temp_2.heapptr = &networkZstr_ROOT;
	L_temp_2.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_arg3, &dylanZdylan_visceraZCLS_integer_HEAP, L_temp_2);
	not_reached();
    }
}

/* generic-entry for pointer-value-setter{<netent>, <netent*>} */
descriptor_t * networkZnetwork_internalZpointer_value_setter_METH_GENERIC_14(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    descriptor_t L_arg; /* arg */
    descriptor_t L_arg_2; /* arg */
    heapptr_t L_rest; /* rest */
    void * L_arg_3; /* arg */
    void * L_arg_4; /* arg */
    descriptor_t L_index; /* index */
    long L_index_2; /* index */
    descriptor_t L_key; /* key */
    descriptor_t L_value; /* value */
    void * L_result0; /* result0 */
    descriptor_t L_temp;

    /* #line {Class <unknown-source-location>} */
    L_args = ((void *)(orig_sp - A_nargs));
    L_arg = (((descriptor_t *)L_args)[0]);
    L_arg_2 = (((descriptor_t *)L_args)[1]);
    L_rest = dylanZdylan_visceraZmake_rest_arg_FUN(orig_sp, (descriptor_t *)L_args + 2, A_nargs - 2);
    L_arg_3 = L_arg.dataword.ptr;
    L_arg_4 = L_arg_2.dataword.ptr;
    L_index.heapptr = networkZliteral_2.heapptr;
    L_index.dataword.l = 0;
    L_index_2 = (A_nargs - 2);
    while (1) {
	if ((L_index_2 < 2)) {
	    goto block0;
	}
	else {
	    L_key = (((descriptor_t *)L_args)[L_index_2]);
	    L_value = (((descriptor_t *)L_args)[(L_index_2 + 1)]);
	    if ((L_key.heapptr == &SYM_index_HEAP)) {
		L_index = L_value;
	    }
	    L_index_2 = (L_index_2 - 2);
	}
    }
  block0:;
    orig_sp = L_args;
    /* pointer-value-setter{<netent>, <netent*>} */
    L_result0 = networkZnetwork_internalZpointer_value_setter_METH_14(orig_sp, L_arg_3, L_arg_4, A_next_method_info, L_rest, L_index);
    L_temp.heapptr = networkZliteral_65.heapptr;
    L_temp.dataword.ptr = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* Define Method content-size{subclass(<netent*>)} */

/* content-size{subclass(<netent*>)} */
long networkZnetwork_internalZcontent_size_METH_64(descriptor_t *orig_sp, heapptr_t A0, heapptr_t A1)
{

    return 4;
}

/* generic-entry for content-size{subclass(<netent*>)} */
descriptor_t * networkZnetwork_internalZcontent_size_METH_GENERIC_64(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    long L_result0; /* result0 */
    descriptor_t L_temp;

    orig_sp = ((void *)(orig_sp - 1));
    /* content-size{subclass(<netent*>)} */
    L_result0 = networkZnetwork_internalZcontent_size_METH_64(orig_sp, &networkZnetwork_internalZCLS_netentV_HEAP, A_next_method_info);
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* {Implicit} Define Generic getnetent-r */

/* getnetent-r is getnetent-r */


/* Define Method getnetent-r{<netent>, <c-char-vector>, <integer>, <netent*>, <int*>} */

/* getnetent-r{<netent>, <c-char-vector>, <integer>, <netent*>, <int*>} */
long networkZnetwork_internalZgetnetent_r_METH(descriptor_t *orig_sp, void * A_arg1 /* arg1 */, descriptor_t A_arg2 /* arg2 */, long A_arg3 /* arg3 */, void * A_arg4 /* arg4 */, descriptor_t A_arg5 /* arg5 */, heapptr_t A5)
{
    descriptor_t *cluster_0_top;
    long L_result_value; /* result-value */


    /* #line 3193 "./sockets-api.dylan" */

    /* #line 3193 "./sockets-api.dylan" */

    /* #line 3193 "./sockets-api.dylan" */

    /* #line 3193 "./sockets-api.dylan" */

    /* #line 735 "./macros.dylan" */
    L_result_value = getnetent_r(A_arg1, A_arg2.dataword.ptr, A_arg3, A_arg4, A_arg5.dataword.ptr);
    return L_result_value;
}


/* {Implicit} Define Generic getnetbyaddr-r */

/* getnetbyaddr-r is getnetbyaddr-r */


/* Define Method getnetbyaddr-r{<integer>, <integer>, <netent>, <c-char-vector>, <integer>, <netent*>, <int*>} */

/* getnetbyaddr-r{<integer>, <integer>, <netent>, <c-char-vector>, <integer>, <netent*>, <int*>} */
long networkZnetwork_internalZgetnetbyaddr_r_METH(descriptor_t *orig_sp, long A_arg1 /* arg1 */, long A_arg2 /* arg2 */, void * A_arg3 /* arg3 */, descriptor_t A_arg4 /* arg4 */, long A_arg5 /* arg5 */, void * A_arg6 /* arg6 */, descriptor_t A_arg7 /* arg7 */, heapptr_t A7)
{
    descriptor_t *cluster_0_top;
    long L_result_value; /* result-value */

    /* #line {Class <unknown-source-location>} */

    /* #line 3201 "./sockets-api.dylan" */

    /* #line 3201 "./sockets-api.dylan" */

    /* #line 3201 "./sockets-api.dylan" */

    /* #line 3201 "./sockets-api.dylan" */

    /* #line 735 "./macros.dylan" */
    L_result_value = getnetbyaddr_r(A_arg1, A_arg2, A_arg3, A_arg4.dataword.ptr, A_arg5, A_arg6, A_arg7.dataword.ptr);
    return L_result_value;
}


/* {Implicit} Define Generic getnetbyname-r */

/* getnetbyname-r is getnetbyname-r */


/* Define Method getnetbyname-r{<c-char-vector>, <netent>, <c-char-vector>, <integer>, <netent*>, <int*>} */

/* getnetbyname-r{<c-char-vector>, <netent>, <c-char-vector>, <integer>, <netent*>, <int*>} */
long networkZnetwork_internalZgetnetbyname_r_METH(descriptor_t *orig_sp, descriptor_t A_arg1 /* arg1 */, void * A_arg2 /* arg2 */, descriptor_t A_arg3 /* arg3 */, long A_arg4 /* arg4 */, void * A_arg5 /* arg5 */, descriptor_t A_arg6 /* arg6 */, heapptr_t A6)
{
    descriptor_t *cluster_0_top;
    long L_result_value; /* result-value */

    /* #line {Class <unknown-source-location>} */

    /* #line 3209 "./sockets-api.dylan" */

    /* #line 3209 "./sockets-api.dylan" */

    /* #line 3209 "./sockets-api.dylan" */

    /* #line 3209 "./sockets-api.dylan" */

    /* #line 3209 "./sockets-api.dylan" */

    /* #line 735 "./macros.dylan" */
    L_result_value = getnetbyname_r(A_arg1.dataword.ptr, A_arg2, A_arg3.dataword.ptr, A_arg4, A_arg5, A_arg6.dataword.ptr);
    return L_result_value;
}


/* Define Class <servent> */

/* <servent> is <servent> */

extern struct heapobj networkZnetwork_internalZCLS_servent_HEAP;

/* maker for <servent> */
void * networkZnetwork_internalZCLS_servent_MAKER_FUN(descriptor_t *orig_sp, void * A_pointer /* pointer */, int A_pointer_suppliedQUERY /* pointer-supplied? */)
{
    descriptor_t *cluster_0_top;


    /* #line 3213 "./sockets-api.dylan" */
    if (A_pointer_suppliedQUERY) {
	return A_pointer;
    }
    else {
	/* missing-required-init-keyword-error */
	dylanZdylan_visceraZmissing_required_init_keyword_error_FUN(orig_sp, &SYM_pointer_HEAP, &networkZnetwork_internalZCLS_servent_HEAP);
	not_reached();
    }
}

extern descriptor_t networkZliteral_67;	/* proxy for <servent> */

/* general-entry for maker for <servent> */
descriptor_t * networkZnetwork_internalZCLS_servent_MAKER_GENERAL(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    void * L_pointer; /* pointer */
    int L_pointer_suppliedQUERY; /* pointer-supplied? */
    long L_index; /* index */
    descriptor_t L_temp; /* temp */
    descriptor_t L_value; /* value */
    descriptor_t L_temp_2;
    descriptor_t L_temp_3;
    void * L_result0; /* result0 */
    descriptor_t L_temp_4;

    /* #line {Class <unknown-source-location>} */

    /* #line 126 "./cmp.dylan" */

    /* #line 209 "./num.dylan" */
    if (((A_nargs & 1) == 0)) {
	/* #line {Class <unknown-source-location>} */
	L_args = ((void *)(orig_sp - A_nargs));
	L_pointer = 0;
	L_pointer_suppliedQUERY = FALSE;
	L_index = (A_nargs - 2);
	while (1) {
	    if ((L_index < 0)) {
		goto block0;
	    }
	    else {
		L_temp = (((descriptor_t *)L_args)[L_index]);

		/* #line 386 "./condition.dylan" */
		if ((&dylanZdylan_visceraZCLS_symbol_HEAP == SLOT(L_temp.heapptr, heapptr_t, 0))) {
		    /* #line {Class <unknown-source-location>} */
		    L_value = (((descriptor_t *)L_args)[(L_index + 1)]);
		    if ((L_temp.heapptr == &SYM_pointer_HEAP)) {

			/* #line 386 "./condition.dylan" */
			if ((&dylanZdylan_visceraZCLS_raw_pointer_HEAP == SLOT(L_value.heapptr, heapptr_t, 0))) {
			    /* #line {Class <unknown-source-location>} */
			    L_pointer = L_value.dataword.ptr;
			    L_pointer_suppliedQUERY = TRUE;
			}
			else {

			    /* #line 389 "./condition.dylan" */
			    L_temp_2.heapptr = &networkZstr_ROOT;
			    L_temp_2.dataword.l = 0;
			    /* type-error-with-location */
			    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_value, &dylanZdylan_visceraZCLS_raw_pointer_HEAP, L_temp_2);
			    not_reached();
			}
		    }
		    /* #line {Class <unknown-source-location>} */
		    L_index = (L_index - 2);
		}
		else {

		    /* #line 389 "./condition.dylan" */
		    L_temp_3.heapptr = &networkZstr_ROOT;
		    L_temp_3.dataword.l = 0;
		    /* type-error-with-location */
		    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp, &dylanZdylan_visceraZCLS_symbol_HEAP, L_temp_3);
		    not_reached();
		}
	    }
	}
      block0:;
	/* #line {Class <unknown-source-location>} */
	orig_sp = L_args;
	/* maker for <servent> */
	L_result0 = networkZnetwork_internalZCLS_servent_MAKER_FUN(orig_sp, L_pointer, L_pointer_suppliedQUERY);
	L_temp_4.heapptr = networkZliteral_67.heapptr;
	L_temp_4.dataword.ptr = L_result0;
	orig_sp[0] = L_temp_4;
	return orig_sp + 1;
    }
    else {
	/* odd-number-of-keyword/value-arguments-error */
	dylanZdylan_visceraZodd_number_of_keywordSLASHvalue_arguments_error_FUN(orig_sp);
	not_reached();
    }
}


/* Define Sealed Domain make (singleton(<servent>)) */


/* {Implicit} Define Generic get-s-name */

/* get-s-name is get-s-name */


/* Define Method get-s-name{<servent>} */

extern struct heapobj networkZstr_ROOT_109;

/* get-s-name{<servent>} */
descriptor_t networkZnetwork_internalZget_s_name_METH(descriptor_t *orig_sp, void * A_ptr /* ptr */, heapptr_t A1)
{
    descriptor_t *cluster_0_top;
    descriptor_t L_temp;
    descriptor_t L_temp_2;
    descriptor_t L_temp_3; /* temp */
    int L_condition; /* condition */
    descriptor_t L_result; /* result */
    heapptr_t L_PCTobject_class; /* %object-class */
    int L_temp_4; /* temp */
    descriptor_t L_temp_5;
    descriptor_t L_temp_6;


    /* #line 290 "./melange.dylan" */

    /* #line 91 "./rawptr.dylan" */

    /* #line 290 "./melange.dylan" */
    L_temp.heapptr = &networkZnetwork_internalZCLS_c_char_vector_HEAP;
    L_temp.dataword.l = 0;
    L_temp_2.heapptr = networkZliteral_6.heapptr;
    L_temp_2.dataword.ptr = (*(void * *)((char *)A_ptr + 0 ));
    orig_sp[0] = L_temp;
    orig_sp[1] = L_temp_2;
    /* as */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZas_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_temp_3 = orig_sp[0];

    /* #line 49 "./object.dylan" */

    /* #line 386 "./condition.dylan" */
    /* %subtype?{<class>, <class>} */
    L_condition = dylanZdylan_visceraZPCTsubtypeQUERY_METH(orig_sp, SLOT(L_temp_3.heapptr, heapptr_t, 0), &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP, &dylanZliteral_ROOT_2);
    if (L_condition) {

	/* #line 290 "./melange.dylan" */
	L_result = L_temp_3;

	/* #line 386 "./condition.dylan" */
	L_PCTobject_class = SLOT(L_result.heapptr, heapptr_t, 0);
	if ((&networkZnetwork_internalZCLS_charLESSX4040GREATER_HEAP == L_PCTobject_class)) {
	    L_temp_4 = TRUE;
	}
	else if ((&networkZnetwork_internalZCLS_charLESSX40120GREATER_HEAP == L_PCTobject_class)) {
	    L_temp_4 = TRUE;
	}
	else if ((&networkZnetwork_internalZCLS_charLESSX4014GREATER_HEAP == L_PCTobject_class)) {
	    L_temp_4 = TRUE;
	}
	else {
	    L_temp_4 = (&networkZnetwork_internalZCLS_c_char_vector_HEAP == L_PCTobject_class);
	}
	if (L_temp_4) {

	    /* #line 3219 "./sockets-api.dylan" */
	    return L_result;
	}
	else {

	    /* #line 389 "./condition.dylan" */
	    L_temp_5.heapptr = &networkZstr_ROOT_109;
	    L_temp_5.dataword.l = 0;
	    /* type-error-with-location */
	    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_result, &networkZnetwork_internalZCLS_c_char_vector_HEAP, L_temp_5);
	    not_reached();
	}
    }
    else {
	L_temp_6.heapptr = &networkZstr_ROOT_14;
	L_temp_6.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp_3, &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP, L_temp_6);
	not_reached();
    }
}


/* {Implicit} Define Generic get-s-name-setter */

/* get-s-name-setter is get-s-name-setter */


/* Define Method get-s-name-setter{<c-char-vector>, <servent>} */

/* get-s-name-setter{<c-char-vector>, <servent>} */
descriptor_t networkZnetwork_internalZget_s_name_setter_METH(descriptor_t *orig_sp, descriptor_t A_value /* value */, void * A_ptr /* ptr */, heapptr_t A2)
{
    descriptor_t *cluster_0_top;

    /* #line {Class <unknown-source-location>} */

    /* #line 299 "./melange.dylan" */
    /* #line {Class <unknown-source-location>} */

    /* #line 97 "./rawptr.dylan" */
    *(void * *)((char *)A_ptr + 0) = A_value.dataword.ptr;
    return A_value;
}


/* {Implicit} Define Generic get-s-aliases */

/* get-s-aliases is get-s-aliases */


/* Define Method get-s-aliases{<servent>} */

extern struct heapobj networkZstr_ROOT_110;

/* get-s-aliases{<servent>} */
void * networkZnetwork_internalZget_s_aliases_METH(descriptor_t *orig_sp, void * A_ptr /* ptr */, heapptr_t A1)
{
    descriptor_t *cluster_0_top;
    descriptor_t L_temp;
    descriptor_t L_temp_2;
    descriptor_t L_temp_3; /* temp */
    int L_condition; /* condition */
    descriptor_t L_result; /* result */
    descriptor_t L_temp_4;
    descriptor_t L_temp_5;

    /* #line {Class <unknown-source-location>} */

    /* #line 290 "./melange.dylan" */

    /* #line 91 "./rawptr.dylan" */

    /* #line 290 "./melange.dylan" */
    L_temp.heapptr = &networkZnetwork_internalZCLS_c_char_pointer_vector_HEAP;
    L_temp.dataword.l = 0;
    L_temp_2.heapptr = networkZliteral_6.heapptr;
    L_temp_2.dataword.ptr = (*(void * *)((char *)A_ptr + 4 ));
    orig_sp[0] = L_temp;
    orig_sp[1] = L_temp_2;
    /* as */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZas_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_temp_3 = orig_sp[0];

    /* #line 49 "./object.dylan" */

    /* #line 386 "./condition.dylan" */
    /* %subtype?{<class>, <class>} */
    L_condition = dylanZdylan_visceraZPCTsubtypeQUERY_METH(orig_sp, SLOT(L_temp_3.heapptr, heapptr_t, 0), &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP, &dylanZliteral_ROOT_2);
    if (L_condition) {

	/* #line 290 "./melange.dylan" */
	L_result = L_temp_3;

	/* #line 386 "./condition.dylan" */
	if ((&networkZnetwork_internalZCLS_c_char_pointer_vector_HEAP == SLOT(L_result.heapptr, heapptr_t, 0))) {

	    /* #line 3230 "./sockets-api.dylan" */
	    return L_result.dataword.ptr;
	}
	else {

	    /* #line 389 "./condition.dylan" */
	    L_temp_4.heapptr = &networkZstr_ROOT_110;
	    L_temp_4.dataword.l = 0;
	    /* type-error-with-location */
	    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_result, &networkZnetwork_internalZCLS_c_char_pointer_vector_HEAP, L_temp_4);
	    not_reached();
	}
    }
    else {
	L_temp_5.heapptr = &networkZstr_ROOT_14;
	L_temp_5.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp_3, &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP, L_temp_5);
	not_reached();
    }
}


/* {Implicit} Define Generic get-s-aliases-setter */

/* get-s-aliases-setter is get-s-aliases-setter */


/* Define Method get-s-aliases-setter{<c-char-pointer-vector>, <servent>} */

/* get-s-aliases-setter{<c-char-pointer-vector>, <servent>} */
void * networkZnetwork_internalZget_s_aliases_setter_METH(descriptor_t *orig_sp, void * A_value /* value */, void * A_ptr /* ptr */, heapptr_t A2)
{
    descriptor_t *cluster_0_top;

    /* #line {Class <unknown-source-location>} */

    /* #line 299 "./melange.dylan" */
    /* #line {Class <unknown-source-location>} */

    /* #line 97 "./rawptr.dylan" */
    *(void * *)((char *)A_ptr + 4) = A_value;
    return A_value;
}


/* {Implicit} Define Generic get-s-port */

/* get-s-port is get-s-port */


/* Define Method get-s-port{<servent>} */

/* get-s-port{<servent>} */
long networkZnetwork_internalZget_s_port_METH(descriptor_t *orig_sp, void * A_ptr /* ptr */, heapptr_t A1)
{
    descriptor_t *cluster_0_top;

    /* #line {Class <unknown-source-location>} */

    /* #line 198 "./melange.dylan" */

    /* #line 91 "./rawptr.dylan" */
    return (*(long *)((char *)A_ptr + 8 ));
}


/* {Implicit} Define Generic get-s-port-setter */

/* get-s-port-setter is get-s-port-setter */


/* Define Method get-s-port-setter{<integer>, <servent>} */

/* get-s-port-setter{<integer>, <servent>} */
long networkZnetwork_internalZget_s_port_setter_METH(descriptor_t *orig_sp, long A_value /* value */, void * A_ptr /* ptr */, heapptr_t A2)
{
    descriptor_t *cluster_0_top;

    /* #line {Class <unknown-source-location>} */

    /* #line 97 "./rawptr.dylan" */
    *(long *)((char *)A_ptr + 8) = A_value;
    return A_value;
}


/* {Implicit} Define Generic get-s-proto */

/* get-s-proto is get-s-proto */


/* Define Method get-s-proto{<servent>} */

extern struct heapobj networkZstr_ROOT_111;

/* get-s-proto{<servent>} */
descriptor_t networkZnetwork_internalZget_s_proto_METH(descriptor_t *orig_sp, void * A_ptr /* ptr */, heapptr_t A1)
{
    descriptor_t *cluster_0_top;
    descriptor_t L_temp;
    descriptor_t L_temp_2;
    descriptor_t L_temp_3; /* temp */
    int L_condition; /* condition */
    descriptor_t L_result; /* result */
    heapptr_t L_PCTobject_class; /* %object-class */
    int L_temp_4; /* temp */
    descriptor_t L_temp_5;
    descriptor_t L_temp_6;

    /* #line {Class <unknown-source-location>} */

    /* #line 290 "./melange.dylan" */

    /* #line 91 "./rawptr.dylan" */

    /* #line 290 "./melange.dylan" */
    L_temp.heapptr = &networkZnetwork_internalZCLS_c_char_vector_HEAP;
    L_temp.dataword.l = 0;
    L_temp_2.heapptr = networkZliteral_6.heapptr;
    L_temp_2.dataword.ptr = (*(void * *)((char *)A_ptr + 12 ));
    orig_sp[0] = L_temp;
    orig_sp[1] = L_temp_2;
    /* as */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZas_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_temp_3 = orig_sp[0];

    /* #line 49 "./object.dylan" */

    /* #line 386 "./condition.dylan" */
    /* %subtype?{<class>, <class>} */
    L_condition = dylanZdylan_visceraZPCTsubtypeQUERY_METH(orig_sp, SLOT(L_temp_3.heapptr, heapptr_t, 0), &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP, &dylanZliteral_ROOT_2);
    if (L_condition) {

	/* #line 290 "./melange.dylan" */
	L_result = L_temp_3;

	/* #line 386 "./condition.dylan" */
	L_PCTobject_class = SLOT(L_result.heapptr, heapptr_t, 0);
	if ((&networkZnetwork_internalZCLS_charLESSX4040GREATER_HEAP == L_PCTobject_class)) {
	    L_temp_4 = TRUE;
	}
	else if ((&networkZnetwork_internalZCLS_charLESSX40120GREATER_HEAP == L_PCTobject_class)) {
	    L_temp_4 = TRUE;
	}
	else if ((&networkZnetwork_internalZCLS_charLESSX4014GREATER_HEAP == L_PCTobject_class)) {
	    L_temp_4 = TRUE;
	}
	else {
	    L_temp_4 = (&networkZnetwork_internalZCLS_c_char_vector_HEAP == L_PCTobject_class);
	}
	if (L_temp_4) {

	    /* #line 3252 "./sockets-api.dylan" */
	    return L_result;
	}
	else {

	    /* #line 389 "./condition.dylan" */
	    L_temp_5.heapptr = &networkZstr_ROOT_111;
	    L_temp_5.dataword.l = 0;
	    /* type-error-with-location */
	    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_result, &networkZnetwork_internalZCLS_c_char_vector_HEAP, L_temp_5);
	    not_reached();
	}
    }
    else {
	L_temp_6.heapptr = &networkZstr_ROOT_14;
	L_temp_6.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp_3, &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP, L_temp_6);
	not_reached();
    }
}


/* {Implicit} Define Generic get-s-proto-setter */

/* get-s-proto-setter is get-s-proto-setter */


/* Define Method get-s-proto-setter{<c-char-vector>, <servent>} */

/* get-s-proto-setter{<c-char-vector>, <servent>} */
descriptor_t networkZnetwork_internalZget_s_proto_setter_METH(descriptor_t *orig_sp, descriptor_t A_value /* value */, void * A_ptr /* ptr */, heapptr_t A2)
{
    descriptor_t *cluster_0_top;

    /* #line {Class <unknown-source-location>} */

    /* #line 299 "./melange.dylan" */
    /* #line {Class <unknown-source-location>} */

    /* #line 97 "./rawptr.dylan" */
    *(void * *)((char *)A_ptr + 12) = A_value.dataword.ptr;
    return A_value;
}


/* Define Method pointer-value{<servent>} */

extern struct heapobj networkZstr_ROOT_112;

/* pointer-value{<servent>} */
void * networkZnetwork_internalZpointer_value_METH_52(descriptor_t *orig_sp, void * A_value /* value */, heapptr_t A_next_method_info /* next-method-info */, heapptr_t A_rest /* rest */, descriptor_t A_index /* index */)
{
    descriptor_t *cluster_0_top;
    descriptor_t L_temp;
    descriptor_t L_arg1; /* arg1 */
    descriptor_t L_temp_2;
    descriptor_t L_temp_3; /* temp */
    descriptor_t L_temp_4;

    /* #line {Class <unknown-source-location>} */

    /* #line 3262 "./sockets-api.dylan" */
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = 16;
    orig_sp[0] = A_index;
    orig_sp[1] = L_temp;
    /* * */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZV_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_arg1 = (orig_sp == cluster_0_top ? dylanZfalse : orig_sp[0]);

    /* #line 3262 "./sockets-api.dylan" */
    L_temp_2.heapptr = networkZliteral_67.heapptr;
    L_temp_2.dataword.ptr = A_value;
    orig_sp[0] = L_temp_2;
    orig_sp[1] = L_arg1;
    /* + */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZPLUS_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_temp_3 = (orig_sp == cluster_0_top ? dylanZfalse : orig_sp[0]);

    /* #line 386 "./condition.dylan" */
    if ((&networkZnetwork_internalZCLS_servent_HEAP == SLOT(L_temp_3.heapptr, heapptr_t, 0))) {

	/* #line 3262 "./sockets-api.dylan" */
	return L_temp_3.dataword.ptr;
    }
    else {

	/* #line 389 "./condition.dylan" */
	L_temp_4.heapptr = &networkZstr_ROOT_112;
	L_temp_4.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp_3, &networkZnetwork_internalZCLS_servent_HEAP, L_temp_4);
	not_reached();
    }
}

/* generic-entry for pointer-value{<servent>} */
descriptor_t * networkZnetwork_internalZpointer_value_METH_GENERIC_52(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    descriptor_t L_arg; /* arg */
    heapptr_t L_rest; /* rest */
    void * L_arg_2; /* arg */
    descriptor_t L_index; /* index */
    long L_index_2; /* index */
    descriptor_t L_key; /* key */
    descriptor_t L_value; /* value */
    void * L_result0; /* result0 */
    descriptor_t L_temp;

    /* #line {Class <unknown-source-location>} */
    L_args = ((void *)(orig_sp - A_nargs));
    L_arg = (((descriptor_t *)L_args)[0]);
    L_rest = dylanZdylan_visceraZmake_rest_arg_FUN(orig_sp, (descriptor_t *)L_args + 1, A_nargs - 1);
    L_arg_2 = L_arg.dataword.ptr;
    L_index.heapptr = networkZliteral_2.heapptr;
    L_index.dataword.l = 0;
    L_index_2 = (A_nargs - 2);
    while (1) {
	if ((L_index_2 < 1)) {
	    goto block0;
	}
	else {
	    L_key = (((descriptor_t *)L_args)[L_index_2]);
	    L_value = (((descriptor_t *)L_args)[(L_index_2 + 1)]);
	    if ((L_key.heapptr == &SYM_index_HEAP)) {
		L_index = L_value;
	    }
	    L_index_2 = (L_index_2 - 2);
	}
    }
  block0:;
    orig_sp = L_args;
    /* pointer-value{<servent>} */
    L_result0 = networkZnetwork_internalZpointer_value_METH_52(orig_sp, L_arg_2, A_next_method_info, L_rest, L_index);
    L_temp.heapptr = networkZliteral_67.heapptr;
    L_temp.dataword.ptr = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* Define Method content-size{subclass(<servent>)} */

/* content-size{subclass(<servent>)} */
long networkZnetwork_internalZcontent_size_METH_65(descriptor_t *orig_sp, heapptr_t A0, heapptr_t A1)
{

    return 16;
}

/* generic-entry for content-size{subclass(<servent>)} */
descriptor_t * networkZnetwork_internalZcontent_size_METH_GENERIC_65(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    long L_result0; /* result0 */
    descriptor_t L_temp;

    orig_sp = ((void *)(orig_sp - 1));
    /* content-size{subclass(<servent>)} */
    L_result0 = networkZnetwork_internalZcontent_size_METH_65(orig_sp, &networkZnetwork_internalZCLS_servent_HEAP, A_next_method_info);
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* {Implicit} Define Generic setservent */

/* setservent is setservent */


/* Define Method setservent{<integer>} */

/* setservent{<integer>} */
void networkZnetwork_internalZsetservent_METH(descriptor_t *orig_sp, long A_arg1 /* arg1 */, heapptr_t A1)
{
    descriptor_t *cluster_0_top;


    /* #line 735 "./macros.dylan" */
    setservent(A_arg1);
    return;
}


/* {Implicit} Define Generic endservent */

/* endservent is endservent */


/* Define Method endservent{} */

/* endservent{} */
void networkZnetwork_internalZendservent_METH(descriptor_t *orig_sp, heapptr_t A0)
{
    descriptor_t *cluster_0_top;

    /* #line {Class <unknown-source-location>} */

    /* #line 735 "./macros.dylan" */
    endservent();
    return;
}


/* {Implicit} Define Generic getservent */

/* getservent is getservent */


/* Define Method getservent{} */

extern struct heapobj networkZstr_ROOT_113;

/* getservent{} */
void * networkZnetwork_internalZgetservent_METH(descriptor_t *orig_sp, heapptr_t A0)
{
    descriptor_t *cluster_0_top;
    void * L_result_value; /* result-value */
    heapptr_t L_instance; /* instance */
    descriptor_t L_temp;
    descriptor_t L_temp_2;
    descriptor_t L_temp_3;
    descriptor_t L_result_value_2; /* result-value */
    descriptor_t L_temp_4;

    /* #line {Class <unknown-source-location>} */

    /* #line 735 "./macros.dylan" */
    L_result_value = getservent();

    /* #line 3288 "./sockets-api.dylan" */
    /* maker for <simple-object-vector> */
    L_instance = dylanZdylan_visceraZCLS_simple_object_vector_MAKER_FUN(orig_sp, 2, dylanZfalse);
    L_temp.heapptr = &SYM_pointer_HEAP;
    L_temp.dataword.l = 0;
    SLOT(L_instance, descriptor_t, 8 + 0 * sizeof(descriptor_t)) = L_temp;
    L_temp_2.heapptr = networkZliteral_6.heapptr;
    L_temp_2.dataword.ptr = L_result_value;
    SLOT(L_instance, descriptor_t, 8 + 1 * sizeof(descriptor_t)) = L_temp_2;
    L_temp_3.heapptr = networkZliteral_6.heapptr;
    L_temp_3.dataword.ptr = L_result_value;
    /* make{subclass(<statically-typed-pointer>)} */
    L_result_value_2 = melange_supportZmelange_supportZmake_METH(orig_sp, &networkZnetwork_internalZCLS_servent_HEAP, &networkZliteral_ROOT, L_instance, 0, L_temp_3, 1);

    /* #line 386 "./condition.dylan" */
    if ((&networkZnetwork_internalZCLS_servent_HEAP == SLOT(L_result_value_2.heapptr, heapptr_t, 0))) {

	/* #line 3289 "./sockets-api.dylan" */
	return L_result_value_2.dataword.ptr;
    }
    else {

	/* #line 389 "./condition.dylan" */
	L_temp_4.heapptr = &networkZstr_ROOT_113;
	L_temp_4.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_result_value_2, &networkZnetwork_internalZCLS_servent_HEAP, L_temp_4);
	not_reached();
    }
}


/* {Implicit} Define Generic getservbyname */

/* getservbyname is getservbyname */


/* Define Method getservbyname{<c-char-vector>, <c-char-vector>} */

extern struct heapobj networkZstr_ROOT_114;

/* getservbyname{<c-char-vector>, <c-char-vector>} */
void * networkZnetwork_internalZgetservbyname_METH(descriptor_t *orig_sp, descriptor_t A_arg1 /* arg1 */, descriptor_t A_arg2 /* arg2 */, heapptr_t A2)
{
    descriptor_t *cluster_0_top;
    void * L_result_value; /* result-value */
    heapptr_t L_instance; /* instance */
    descriptor_t L_temp;
    descriptor_t L_temp_2;
    descriptor_t L_temp_3;
    descriptor_t L_result_value_2; /* result-value */
    descriptor_t L_temp_4;

    /* #line {Class <unknown-source-location>} */

    /* #line 3296 "./sockets-api.dylan" */

    /* #line 3296 "./sockets-api.dylan" */

    /* #line 735 "./macros.dylan" */
    L_result_value = getservbyname(A_arg1.dataword.ptr, A_arg2.dataword.ptr);

    /* #line 3297 "./sockets-api.dylan" */
    /* maker for <simple-object-vector> */
    L_instance = dylanZdylan_visceraZCLS_simple_object_vector_MAKER_FUN(orig_sp, 2, dylanZfalse);
    L_temp.heapptr = &SYM_pointer_HEAP;
    L_temp.dataword.l = 0;
    SLOT(L_instance, descriptor_t, 8 + 0 * sizeof(descriptor_t)) = L_temp;
    L_temp_2.heapptr = networkZliteral_6.heapptr;
    L_temp_2.dataword.ptr = L_result_value;
    SLOT(L_instance, descriptor_t, 8 + 1 * sizeof(descriptor_t)) = L_temp_2;
    L_temp_3.heapptr = networkZliteral_6.heapptr;
    L_temp_3.dataword.ptr = L_result_value;
    /* make{subclass(<statically-typed-pointer>)} */
    L_result_value_2 = melange_supportZmelange_supportZmake_METH(orig_sp, &networkZnetwork_internalZCLS_servent_HEAP, &networkZliteral_ROOT, L_instance, 0, L_temp_3, 1);

    /* #line 386 "./condition.dylan" */
    if ((&networkZnetwork_internalZCLS_servent_HEAP == SLOT(L_result_value_2.heapptr, heapptr_t, 0))) {

	/* #line 3298 "./sockets-api.dylan" */
	return L_result_value_2.dataword.ptr;
    }
    else {

	/* #line 389 "./condition.dylan" */
	L_temp_4.heapptr = &networkZstr_ROOT_114;
	L_temp_4.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_result_value_2, &networkZnetwork_internalZCLS_servent_HEAP, L_temp_4);
	not_reached();
    }
}


/* {Implicit} Define Generic getservbyport */

/* getservbyport is getservbyport */


/* Define Method getservbyport{<integer>, <c-char-vector>} */

extern struct heapobj networkZstr_ROOT_115;

/* getservbyport{<integer>, <c-char-vector>} */
void * networkZnetwork_internalZgetservbyport_METH(descriptor_t *orig_sp, long A_arg1 /* arg1 */, descriptor_t A_arg2 /* arg2 */, heapptr_t A2)
{
    descriptor_t *cluster_0_top;
    void * L_result_value; /* result-value */
    heapptr_t L_instance; /* instance */
    descriptor_t L_temp;
    descriptor_t L_temp_2;
    descriptor_t L_temp_3;
    descriptor_t L_result_value_2; /* result-value */
    descriptor_t L_temp_4;

    /* #line {Class <unknown-source-location>} */

    /* #line 3305 "./sockets-api.dylan" */

    /* #line 735 "./macros.dylan" */
    L_result_value = getservbyport(A_arg1, A_arg2.dataword.ptr);

    /* #line 3306 "./sockets-api.dylan" */
    /* maker for <simple-object-vector> */
    L_instance = dylanZdylan_visceraZCLS_simple_object_vector_MAKER_FUN(orig_sp, 2, dylanZfalse);
    L_temp.heapptr = &SYM_pointer_HEAP;
    L_temp.dataword.l = 0;
    SLOT(L_instance, descriptor_t, 8 + 0 * sizeof(descriptor_t)) = L_temp;
    L_temp_2.heapptr = networkZliteral_6.heapptr;
    L_temp_2.dataword.ptr = L_result_value;
    SLOT(L_instance, descriptor_t, 8 + 1 * sizeof(descriptor_t)) = L_temp_2;
    L_temp_3.heapptr = networkZliteral_6.heapptr;
    L_temp_3.dataword.ptr = L_result_value;
    /* make{subclass(<statically-typed-pointer>)} */
    L_result_value_2 = melange_supportZmelange_supportZmake_METH(orig_sp, &networkZnetwork_internalZCLS_servent_HEAP, &networkZliteral_ROOT, L_instance, 0, L_temp_3, 1);

    /* #line 386 "./condition.dylan" */
    if ((&networkZnetwork_internalZCLS_servent_HEAP == SLOT(L_result_value_2.heapptr, heapptr_t, 0))) {

	/* #line 3307 "./sockets-api.dylan" */
	return L_result_value_2.dataword.ptr;
    }
    else {

	/* #line 389 "./condition.dylan" */
	L_temp_4.heapptr = &networkZstr_ROOT_115;
	L_temp_4.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_result_value_2, &networkZnetwork_internalZCLS_servent_HEAP, L_temp_4);
	not_reached();
    }
}


/* Define Class <servent*> */

/* <servent*> is <servent*> */

extern struct heapobj networkZnetwork_internalZCLS_serventV_HEAP;

/* maker for <servent*> */
void * networkZnetwork_internalZCLS_serventV_MAKER_FUN(descriptor_t *orig_sp, void * A_pointer /* pointer */, int A_pointer_suppliedQUERY /* pointer-supplied? */)
{
    descriptor_t *cluster_0_top;


    /* #line 3310 "./sockets-api.dylan" */
    if (A_pointer_suppliedQUERY) {
	return A_pointer;
    }
    else {
	/* missing-required-init-keyword-error */
	dylanZdylan_visceraZmissing_required_init_keyword_error_FUN(orig_sp, &SYM_pointer_HEAP, &networkZnetwork_internalZCLS_serventV_HEAP);
	not_reached();
    }
}

extern descriptor_t networkZliteral_68;	/* proxy for <servent*> */

/* general-entry for maker for <servent*> */
descriptor_t * networkZnetwork_internalZCLS_serventV_MAKER_GENERAL(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    void * L_pointer; /* pointer */
    int L_pointer_suppliedQUERY; /* pointer-supplied? */
    long L_index; /* index */
    descriptor_t L_temp; /* temp */
    descriptor_t L_value; /* value */
    descriptor_t L_temp_2;
    descriptor_t L_temp_3;
    void * L_result0; /* result0 */
    descriptor_t L_temp_4;

    /* #line {Class <unknown-source-location>} */

    /* #line 126 "./cmp.dylan" */

    /* #line 209 "./num.dylan" */
    if (((A_nargs & 1) == 0)) {
	/* #line {Class <unknown-source-location>} */
	L_args = ((void *)(orig_sp - A_nargs));
	L_pointer = 0;
	L_pointer_suppliedQUERY = FALSE;
	L_index = (A_nargs - 2);
	while (1) {
	    if ((L_index < 0)) {
		goto block0;
	    }
	    else {
		L_temp = (((descriptor_t *)L_args)[L_index]);

		/* #line 386 "./condition.dylan" */
		if ((&dylanZdylan_visceraZCLS_symbol_HEAP == SLOT(L_temp.heapptr, heapptr_t, 0))) {
		    /* #line {Class <unknown-source-location>} */
		    L_value = (((descriptor_t *)L_args)[(L_index + 1)]);
		    if ((L_temp.heapptr == &SYM_pointer_HEAP)) {

			/* #line 386 "./condition.dylan" */
			if ((&dylanZdylan_visceraZCLS_raw_pointer_HEAP == SLOT(L_value.heapptr, heapptr_t, 0))) {
			    /* #line {Class <unknown-source-location>} */
			    L_pointer = L_value.dataword.ptr;
			    L_pointer_suppliedQUERY = TRUE;
			}
			else {

			    /* #line 389 "./condition.dylan" */
			    L_temp_2.heapptr = &networkZstr_ROOT;
			    L_temp_2.dataword.l = 0;
			    /* type-error-with-location */
			    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_value, &dylanZdylan_visceraZCLS_raw_pointer_HEAP, L_temp_2);
			    not_reached();
			}
		    }
		    /* #line {Class <unknown-source-location>} */
		    L_index = (L_index - 2);
		}
		else {

		    /* #line 389 "./condition.dylan" */
		    L_temp_3.heapptr = &networkZstr_ROOT;
		    L_temp_3.dataword.l = 0;
		    /* type-error-with-location */
		    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp, &dylanZdylan_visceraZCLS_symbol_HEAP, L_temp_3);
		    not_reached();
		}
	    }
	}
      block0:;
	/* #line {Class <unknown-source-location>} */
	orig_sp = L_args;
	/* maker for <servent*> */
	L_result0 = networkZnetwork_internalZCLS_serventV_MAKER_FUN(orig_sp, L_pointer, L_pointer_suppliedQUERY);
	L_temp_4.heapptr = networkZliteral_68.heapptr;
	L_temp_4.dataword.ptr = L_result0;
	orig_sp[0] = L_temp_4;
	return orig_sp + 1;
    }
    else {
	/* odd-number-of-keyword/value-arguments-error */
	dylanZdylan_visceraZodd_number_of_keywordSLASHvalue_arguments_error_FUN(orig_sp);
	not_reached();
    }
}


/* Define Sealed Domain make (singleton(<servent*>)) */


/* Define Method pointer-value{<servent*>} */

extern struct heapobj networkZstr_ROOT_116;

/* pointer-value{<servent*>} */
void * networkZnetwork_internalZpointer_value_METH_53(descriptor_t *orig_sp, void * A_ptr /* ptr */, heapptr_t A_next_method_info /* next-method-info */, heapptr_t A_rest /* rest */, descriptor_t A_index /* index */)
{
    descriptor_t *cluster_0_top;
    descriptor_t L_temp;
    descriptor_t L_arg2; /* arg2 */
    descriptor_t L_temp_2;
    descriptor_t L_temp_3;
    descriptor_t L_temp_4; /* temp */
    int L_condition; /* condition */
    descriptor_t L_result; /* result */
    descriptor_t L_temp_5;
    descriptor_t L_temp_6;
    descriptor_t L_temp_7;


    /* #line 3317 "./sockets-api.dylan" */
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = 4;
    orig_sp[0] = A_index;
    orig_sp[1] = L_temp;
    /* * */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZV_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_arg2 = (orig_sp == cluster_0_top ? dylanZfalse : orig_sp[0]);

    /* #line 386 "./condition.dylan" */
    if ((&dylanZdylan_visceraZCLS_integer_HEAP == SLOT(L_arg2.heapptr, heapptr_t, 0))) {

	/* #line 3317 "./sockets-api.dylan" */

	/* #line 290 "./melange.dylan" */

	/* #line 91 "./rawptr.dylan" */

	/* #line 290 "./melange.dylan" */
	L_temp_2.heapptr = &networkZnetwork_internalZCLS_servent_HEAP;
	L_temp_2.dataword.l = 0;
	L_temp_3.heapptr = networkZliteral_6.heapptr;
	L_temp_3.dataword.ptr = (*(void * *)((char *)A_ptr + L_arg2.dataword.l ));
	orig_sp[0] = L_temp_2;
	orig_sp[1] = L_temp_3;
	/* as */
	{
	  struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZas_HEAP, 2);
	  heapptr_t L_meth = L_temp.R0;
	  heapptr_t L_next_info = L_temp.R1;
	  cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
	}
	L_temp_4 = orig_sp[0];

	/* #line 49 "./object.dylan" */

	/* #line 386 "./condition.dylan" */
	/* %subtype?{<class>, <class>} */
	L_condition = dylanZdylan_visceraZPCTsubtypeQUERY_METH(orig_sp, SLOT(L_temp_4.heapptr, heapptr_t, 0), &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP, &dylanZliteral_ROOT_2);
	if (L_condition) {

	    /* #line 290 "./melange.dylan" */
	    L_result = L_temp_4;

	    /* #line 386 "./condition.dylan" */
	    if ((&networkZnetwork_internalZCLS_servent_HEAP == SLOT(L_result.heapptr, heapptr_t, 0))) {

		/* #line 3317 "./sockets-api.dylan" */
		return L_result.dataword.ptr;
	    }
	    else {

		/* #line 389 "./condition.dylan" */
		L_temp_5.heapptr = &networkZstr_ROOT_116;
		L_temp_5.dataword.l = 0;
		/* type-error-with-location */
		dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_result, &networkZnetwork_internalZCLS_servent_HEAP, L_temp_5);
		not_reached();
	    }
	}
	else {
	    L_temp_6.heapptr = &networkZstr_ROOT_14;
	    L_temp_6.dataword.l = 0;
	    /* type-error-with-location */
	    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp_4, &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP, L_temp_6);
	    not_reached();
	}
    }
    else {
	L_temp_7.heapptr = &networkZstr_ROOT_116;
	L_temp_7.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_arg2, &dylanZdylan_visceraZCLS_integer_HEAP, L_temp_7);
	not_reached();
    }
}

/* generic-entry for pointer-value{<servent*>} */
descriptor_t * networkZnetwork_internalZpointer_value_METH_GENERIC_53(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    descriptor_t L_arg; /* arg */
    heapptr_t L_rest; /* rest */
    void * L_arg_2; /* arg */
    descriptor_t L_index; /* index */
    long L_index_2; /* index */
    descriptor_t L_key; /* key */
    descriptor_t L_value; /* value */
    void * L_result0; /* result0 */
    descriptor_t L_temp;

    /* #line {Class <unknown-source-location>} */
    L_args = ((void *)(orig_sp - A_nargs));
    L_arg = (((descriptor_t *)L_args)[0]);
    L_rest = dylanZdylan_visceraZmake_rest_arg_FUN(orig_sp, (descriptor_t *)L_args + 1, A_nargs - 1);
    L_arg_2 = L_arg.dataword.ptr;
    L_index.heapptr = networkZliteral_2.heapptr;
    L_index.dataword.l = 0;
    L_index_2 = (A_nargs - 2);
    while (1) {
	if ((L_index_2 < 1)) {
	    goto block0;
	}
	else {
	    L_key = (((descriptor_t *)L_args)[L_index_2]);
	    L_value = (((descriptor_t *)L_args)[(L_index_2 + 1)]);
	    if ((L_key.heapptr == &SYM_index_HEAP)) {
		L_index = L_value;
	    }
	    L_index_2 = (L_index_2 - 2);
	}
    }
  block0:;
    orig_sp = L_args;
    /* pointer-value{<servent*>} */
    L_result0 = networkZnetwork_internalZpointer_value_METH_53(orig_sp, L_arg_2, A_next_method_info, L_rest, L_index);
    L_temp.heapptr = networkZliteral_67.heapptr;
    L_temp.dataword.ptr = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* Define Method pointer-value-setter{<servent>, <servent*>} */

/* pointer-value-setter{<servent>, <servent*>} */
void * networkZnetwork_internalZpointer_value_setter_METH_15(descriptor_t *orig_sp, void * A_value /* value */, void * A_ptr /* ptr */, heapptr_t A_next_method_info /* next-method-info */, heapptr_t A_rest /* rest */, descriptor_t A_index /* index */)
{
    descriptor_t *cluster_0_top;
    descriptor_t L_temp;
    descriptor_t L_arg3; /* arg3 */
    descriptor_t L_temp_2;


    /* #line 3323 "./sockets-api.dylan" */
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = 4;
    orig_sp[0] = A_index;
    orig_sp[1] = L_temp;
    /* * */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZV_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_arg3 = (orig_sp == cluster_0_top ? dylanZfalse : orig_sp[0]);

    /* #line 386 "./condition.dylan" */
    if ((&dylanZdylan_visceraZCLS_integer_HEAP == SLOT(L_arg3.heapptr, heapptr_t, 0))) {
	/* #line {Class <unknown-source-location>} */

	/* #line 299 "./melange.dylan" */
	/* #line {Class <unknown-source-location>} */

	/* #line 97 "./rawptr.dylan" */
	*(void * *)((char *)A_ptr + L_arg3.dataword.l) = A_value;
	return A_value;
    }
    else {

	/* #line 389 "./condition.dylan" */
	L_temp_2.heapptr = &networkZstr_ROOT;
	L_temp_2.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_arg3, &dylanZdylan_visceraZCLS_integer_HEAP, L_temp_2);
	not_reached();
    }
}

/* generic-entry for pointer-value-setter{<servent>, <servent*>} */
descriptor_t * networkZnetwork_internalZpointer_value_setter_METH_GENERIC_15(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    descriptor_t L_arg; /* arg */
    descriptor_t L_arg_2; /* arg */
    heapptr_t L_rest; /* rest */
    void * L_arg_3; /* arg */
    void * L_arg_4; /* arg */
    descriptor_t L_index; /* index */
    long L_index_2; /* index */
    descriptor_t L_key; /* key */
    descriptor_t L_value; /* value */
    void * L_result0; /* result0 */
    descriptor_t L_temp;

    /* #line {Class <unknown-source-location>} */
    L_args = ((void *)(orig_sp - A_nargs));
    L_arg = (((descriptor_t *)L_args)[0]);
    L_arg_2 = (((descriptor_t *)L_args)[1]);
    L_rest = dylanZdylan_visceraZmake_rest_arg_FUN(orig_sp, (descriptor_t *)L_args + 2, A_nargs - 2);
    L_arg_3 = L_arg.dataword.ptr;
    L_arg_4 = L_arg_2.dataword.ptr;
    L_index.heapptr = networkZliteral_2.heapptr;
    L_index.dataword.l = 0;
    L_index_2 = (A_nargs - 2);
    while (1) {
	if ((L_index_2 < 2)) {
	    goto block0;
	}
	else {
	    L_key = (((descriptor_t *)L_args)[L_index_2]);
	    L_value = (((descriptor_t *)L_args)[(L_index_2 + 1)]);
	    if ((L_key.heapptr == &SYM_index_HEAP)) {
		L_index = L_value;
	    }
	    L_index_2 = (L_index_2 - 2);
	}
    }
  block0:;
    orig_sp = L_args;
    /* pointer-value-setter{<servent>, <servent*>} */
    L_result0 = networkZnetwork_internalZpointer_value_setter_METH_15(orig_sp, L_arg_3, L_arg_4, A_next_method_info, L_rest, L_index);
    L_temp.heapptr = networkZliteral_67.heapptr;
    L_temp.dataword.ptr = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* Define Method content-size{subclass(<servent*>)} */

/* content-size{subclass(<servent*>)} */
long networkZnetwork_internalZcontent_size_METH_66(descriptor_t *orig_sp, heapptr_t A0, heapptr_t A1)
{

    return 4;
}

/* generic-entry for content-size{subclass(<servent*>)} */
descriptor_t * networkZnetwork_internalZcontent_size_METH_GENERIC_66(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    long L_result0; /* result0 */
    descriptor_t L_temp;

    orig_sp = ((void *)(orig_sp - 1));
    /* content-size{subclass(<servent*>)} */
    L_result0 = networkZnetwork_internalZcontent_size_METH_66(orig_sp, &networkZnetwork_internalZCLS_serventV_HEAP, A_next_method_info);
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* {Implicit} Define Generic getservent-r */

/* getservent-r is getservent-r */


/* Define Method getservent-r{<servent>, <c-char-vector>, <integer>, <servent*>} */

/* getservent-r{<servent>, <c-char-vector>, <integer>, <servent*>} */
long networkZnetwork_internalZgetservent_r_METH(descriptor_t *orig_sp, void * A_arg1 /* arg1 */, descriptor_t A_arg2 /* arg2 */, long A_arg3 /* arg3 */, void * A_arg4 /* arg4 */, heapptr_t A4)
{
    descriptor_t *cluster_0_top;
    long L_result_value; /* result-value */


    /* #line 3335 "./sockets-api.dylan" */

    /* #line 3335 "./sockets-api.dylan" */

    /* #line 3335 "./sockets-api.dylan" */

    /* #line 735 "./macros.dylan" */
    L_result_value = getservent_r(A_arg1, A_arg2.dataword.ptr, A_arg3, A_arg4);
    return L_result_value;
}


/* {Implicit} Define Generic getservbyname-r */

/* getservbyname-r is getservbyname-r */


/* Define Method getservbyname-r{<c-char-vector>, <c-char-vector>, <servent>, <c-char-vector>, <integer>, <servent*>} */

/* getservbyname-r{<c-char-vector>, <c-char-vector>, <servent>, <c-char-vector>, <integer>, <servent*>} */
long networkZnetwork_internalZgetservbyname_r_METH(descriptor_t *orig_sp, descriptor_t A_arg1 /* arg1 */, descriptor_t A_arg2 /* arg2 */, void * A_arg3 /* arg3 */, descriptor_t A_arg4 /* arg4 */, long A_arg5 /* arg5 */, void * A_arg6 /* arg6 */, heapptr_t A6)
{
    descriptor_t *cluster_0_top;
    long L_result_value; /* result-value */

    /* #line {Class <unknown-source-location>} */

    /* #line 3343 "./sockets-api.dylan" */

    /* #line 3343 "./sockets-api.dylan" */

    /* #line 3343 "./sockets-api.dylan" */

    /* #line 3343 "./sockets-api.dylan" */

    /* #line 3343 "./sockets-api.dylan" */

    /* #line 735 "./macros.dylan" */
    L_result_value = getservbyname_r(A_arg1.dataword.ptr, A_arg2.dataword.ptr, A_arg3, A_arg4.dataword.ptr, A_arg5, A_arg6);
    return L_result_value;
}


/* {Implicit} Define Generic getservbyport-r */

/* getservbyport-r is getservbyport-r */


/* Define Method getservbyport-r{<integer>, <c-char-vector>, <servent>, <c-char-vector>, <integer>, <servent*>} */

/* getservbyport-r{<integer>, <c-char-vector>, <servent>, <c-char-vector>, <integer>, <servent*>} */
long networkZnetwork_internalZgetservbyport_r_METH(descriptor_t *orig_sp, long A_arg1 /* arg1 */, descriptor_t A_arg2 /* arg2 */, void * A_arg3 /* arg3 */, descriptor_t A_arg4 /* arg4 */, long A_arg5 /* arg5 */, void * A_arg6 /* arg6 */, heapptr_t A6)
{
    descriptor_t *cluster_0_top;
    long L_result_value; /* result-value */

    /* #line {Class <unknown-source-location>} */

    /* #line 3351 "./sockets-api.dylan" */

    /* #line 3351 "./sockets-api.dylan" */

    /* #line 3351 "./sockets-api.dylan" */

    /* #line 3351 "./sockets-api.dylan" */

    /* #line 735 "./macros.dylan" */
    L_result_value = getservbyport_r(A_arg1, A_arg2.dataword.ptr, A_arg3, A_arg4.dataword.ptr, A_arg5, A_arg6);
    return L_result_value;
}


/* Define Class <protoent> */

/* <protoent> is <protoent> */

extern struct heapobj networkZnetwork_internalZCLS_protoent_HEAP;

/* maker for <protoent> */
void * networkZnetwork_internalZCLS_protoent_MAKER_FUN(descriptor_t *orig_sp, void * A_pointer /* pointer */, int A_pointer_suppliedQUERY /* pointer-supplied? */)
{
    descriptor_t *cluster_0_top;


    /* #line 3355 "./sockets-api.dylan" */
    if (A_pointer_suppliedQUERY) {
	return A_pointer;
    }
    else {
	/* missing-required-init-keyword-error */
	dylanZdylan_visceraZmissing_required_init_keyword_error_FUN(orig_sp, &SYM_pointer_HEAP, &networkZnetwork_internalZCLS_protoent_HEAP);
	not_reached();
    }
}

extern descriptor_t networkZliteral_69;	/* proxy for <protoent> */

/* general-entry for maker for <protoent> */
descriptor_t * networkZnetwork_internalZCLS_protoent_MAKER_GENERAL(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    void * L_pointer; /* pointer */
    int L_pointer_suppliedQUERY; /* pointer-supplied? */
    long L_index; /* index */
    descriptor_t L_temp; /* temp */
    descriptor_t L_value; /* value */
    descriptor_t L_temp_2;
    descriptor_t L_temp_3;
    void * L_result0; /* result0 */
    descriptor_t L_temp_4;

    /* #line {Class <unknown-source-location>} */

    /* #line 126 "./cmp.dylan" */

    /* #line 209 "./num.dylan" */
    if (((A_nargs & 1) == 0)) {
	/* #line {Class <unknown-source-location>} */
	L_args = ((void *)(orig_sp - A_nargs));
	L_pointer = 0;
	L_pointer_suppliedQUERY = FALSE;
	L_index = (A_nargs - 2);
	while (1) {
	    if ((L_index < 0)) {
		goto block0;
	    }
	    else {
		L_temp = (((descriptor_t *)L_args)[L_index]);

		/* #line 386 "./condition.dylan" */
		if ((&dylanZdylan_visceraZCLS_symbol_HEAP == SLOT(L_temp.heapptr, heapptr_t, 0))) {
		    /* #line {Class <unknown-source-location>} */
		    L_value = (((descriptor_t *)L_args)[(L_index + 1)]);
		    if ((L_temp.heapptr == &SYM_pointer_HEAP)) {

			/* #line 386 "./condition.dylan" */
			if ((&dylanZdylan_visceraZCLS_raw_pointer_HEAP == SLOT(L_value.heapptr, heapptr_t, 0))) {
			    /* #line {Class <unknown-source-location>} */
			    L_pointer = L_value.dataword.ptr;
			    L_pointer_suppliedQUERY = TRUE;
			}
			else {

			    /* #line 389 "./condition.dylan" */
			    L_temp_2.heapptr = &networkZstr_ROOT;
			    L_temp_2.dataword.l = 0;
			    /* type-error-with-location */
			    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_value, &dylanZdylan_visceraZCLS_raw_pointer_HEAP, L_temp_2);
			    not_reached();
			}
		    }
		    /* #line {Class <unknown-source-location>} */
		    L_index = (L_index - 2);
		}
		else {

		    /* #line 389 "./condition.dylan" */
		    L_temp_3.heapptr = &networkZstr_ROOT;
		    L_temp_3.dataword.l = 0;
		    /* type-error-with-location */
		    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp, &dylanZdylan_visceraZCLS_symbol_HEAP, L_temp_3);
		    not_reached();
		}
	    }
	}
      block0:;
	/* #line {Class <unknown-source-location>} */
	orig_sp = L_args;
	/* maker for <protoent> */
	L_result0 = networkZnetwork_internalZCLS_protoent_MAKER_FUN(orig_sp, L_pointer, L_pointer_suppliedQUERY);
	L_temp_4.heapptr = networkZliteral_69.heapptr;
	L_temp_4.dataword.ptr = L_result0;
	orig_sp[0] = L_temp_4;
	return orig_sp + 1;
    }
    else {
	/* odd-number-of-keyword/value-arguments-error */
	dylanZdylan_visceraZodd_number_of_keywordSLASHvalue_arguments_error_FUN(orig_sp);
	not_reached();
    }
}


/* Define Sealed Domain make (singleton(<protoent>)) */


/* {Implicit} Define Generic get-p-name */

/* get-p-name is get-p-name */


/* Define Method get-p-name{<protoent>} */

extern struct heapobj networkZstr_ROOT_117;

/* get-p-name{<protoent>} */
descriptor_t networkZnetwork_internalZget_p_name_METH(descriptor_t *orig_sp, void * A_ptr /* ptr */, heapptr_t A1)
{
    descriptor_t *cluster_0_top;
    descriptor_t L_temp;
    descriptor_t L_temp_2;
    descriptor_t L_temp_3; /* temp */
    int L_condition; /* condition */
    descriptor_t L_result; /* result */
    heapptr_t L_PCTobject_class; /* %object-class */
    int L_temp_4; /* temp */
    descriptor_t L_temp_5;
    descriptor_t L_temp_6;


    /* #line 290 "./melange.dylan" */

    /* #line 91 "./rawptr.dylan" */

    /* #line 290 "./melange.dylan" */
    L_temp.heapptr = &networkZnetwork_internalZCLS_c_char_vector_HEAP;
    L_temp.dataword.l = 0;
    L_temp_2.heapptr = networkZliteral_6.heapptr;
    L_temp_2.dataword.ptr = (*(void * *)((char *)A_ptr + 0 ));
    orig_sp[0] = L_temp;
    orig_sp[1] = L_temp_2;
    /* as */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZas_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_temp_3 = orig_sp[0];

    /* #line 49 "./object.dylan" */

    /* #line 386 "./condition.dylan" */
    /* %subtype?{<class>, <class>} */
    L_condition = dylanZdylan_visceraZPCTsubtypeQUERY_METH(orig_sp, SLOT(L_temp_3.heapptr, heapptr_t, 0), &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP, &dylanZliteral_ROOT_2);
    if (L_condition) {

	/* #line 290 "./melange.dylan" */
	L_result = L_temp_3;

	/* #line 386 "./condition.dylan" */
	L_PCTobject_class = SLOT(L_result.heapptr, heapptr_t, 0);
	if ((&networkZnetwork_internalZCLS_charLESSX4040GREATER_HEAP == L_PCTobject_class)) {
	    L_temp_4 = TRUE;
	}
	else if ((&networkZnetwork_internalZCLS_charLESSX40120GREATER_HEAP == L_PCTobject_class)) {
	    L_temp_4 = TRUE;
	}
	else if ((&networkZnetwork_internalZCLS_charLESSX4014GREATER_HEAP == L_PCTobject_class)) {
	    L_temp_4 = TRUE;
	}
	else {
	    L_temp_4 = (&networkZnetwork_internalZCLS_c_char_vector_HEAP == L_PCTobject_class);
	}
	if (L_temp_4) {

	    /* #line 3361 "./sockets-api.dylan" */
	    return L_result;
	}
	else {

	    /* #line 389 "./condition.dylan" */
	    L_temp_5.heapptr = &networkZstr_ROOT_117;
	    L_temp_5.dataword.l = 0;
	    /* type-error-with-location */
	    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_result, &networkZnetwork_internalZCLS_c_char_vector_HEAP, L_temp_5);
	    not_reached();
	}
    }
    else {
	L_temp_6.heapptr = &networkZstr_ROOT_14;
	L_temp_6.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp_3, &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP, L_temp_6);
	not_reached();
    }
}


/* {Implicit} Define Generic get-p-name-setter */

/* get-p-name-setter is get-p-name-setter */


/* Define Method get-p-name-setter{<c-char-vector>, <protoent>} */

/* get-p-name-setter{<c-char-vector>, <protoent>} */
descriptor_t networkZnetwork_internalZget_p_name_setter_METH(descriptor_t *orig_sp, descriptor_t A_value /* value */, void * A_ptr /* ptr */, heapptr_t A2)
{
    descriptor_t *cluster_0_top;

    /* #line {Class <unknown-source-location>} */

    /* #line 299 "./melange.dylan" */
    /* #line {Class <unknown-source-location>} */

    /* #line 97 "./rawptr.dylan" */
    *(void * *)((char *)A_ptr + 0) = A_value.dataword.ptr;
    return A_value;
}


/* {Implicit} Define Generic get-p-aliases */

/* get-p-aliases is get-p-aliases */


/* Define Method get-p-aliases{<protoent>} */

extern struct heapobj networkZstr_ROOT_118;

/* get-p-aliases{<protoent>} */
void * networkZnetwork_internalZget_p_aliases_METH(descriptor_t *orig_sp, void * A_ptr /* ptr */, heapptr_t A1)
{
    descriptor_t *cluster_0_top;
    descriptor_t L_temp;
    descriptor_t L_temp_2;
    descriptor_t L_temp_3; /* temp */
    int L_condition; /* condition */
    descriptor_t L_result; /* result */
    descriptor_t L_temp_4;
    descriptor_t L_temp_5;

    /* #line {Class <unknown-source-location>} */

    /* #line 290 "./melange.dylan" */

    /* #line 91 "./rawptr.dylan" */

    /* #line 290 "./melange.dylan" */
    L_temp.heapptr = &networkZnetwork_internalZCLS_c_char_pointer_vector_HEAP;
    L_temp.dataword.l = 0;
    L_temp_2.heapptr = networkZliteral_6.heapptr;
    L_temp_2.dataword.ptr = (*(void * *)((char *)A_ptr + 4 ));
    orig_sp[0] = L_temp;
    orig_sp[1] = L_temp_2;
    /* as */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZas_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_temp_3 = orig_sp[0];

    /* #line 49 "./object.dylan" */

    /* #line 386 "./condition.dylan" */
    /* %subtype?{<class>, <class>} */
    L_condition = dylanZdylan_visceraZPCTsubtypeQUERY_METH(orig_sp, SLOT(L_temp_3.heapptr, heapptr_t, 0), &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP, &dylanZliteral_ROOT_2);
    if (L_condition) {

	/* #line 290 "./melange.dylan" */
	L_result = L_temp_3;

	/* #line 386 "./condition.dylan" */
	if ((&networkZnetwork_internalZCLS_c_char_pointer_vector_HEAP == SLOT(L_result.heapptr, heapptr_t, 0))) {

	    /* #line 3372 "./sockets-api.dylan" */
	    return L_result.dataword.ptr;
	}
	else {

	    /* #line 389 "./condition.dylan" */
	    L_temp_4.heapptr = &networkZstr_ROOT_118;
	    L_temp_4.dataword.l = 0;
	    /* type-error-with-location */
	    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_result, &networkZnetwork_internalZCLS_c_char_pointer_vector_HEAP, L_temp_4);
	    not_reached();
	}
    }
    else {
	L_temp_5.heapptr = &networkZstr_ROOT_14;
	L_temp_5.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp_3, &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP, L_temp_5);
	not_reached();
    }
}


/* {Implicit} Define Generic get-p-aliases-setter */

/* get-p-aliases-setter is get-p-aliases-setter */


/* Define Method get-p-aliases-setter{<c-char-pointer-vector>, <protoent>} */

/* get-p-aliases-setter{<c-char-pointer-vector>, <protoent>} */
void * networkZnetwork_internalZget_p_aliases_setter_METH(descriptor_t *orig_sp, void * A_value /* value */, void * A_ptr /* ptr */, heapptr_t A2)
{
    descriptor_t *cluster_0_top;

    /* #line {Class <unknown-source-location>} */

    /* #line 299 "./melange.dylan" */
    /* #line {Class <unknown-source-location>} */

    /* #line 97 "./rawptr.dylan" */
    *(void * *)((char *)A_ptr + 4) = A_value;
    return A_value;
}


/* {Implicit} Define Generic get-p-proto */

/* get-p-proto is get-p-proto */


/* Define Method get-p-proto{<protoent>} */

/* get-p-proto{<protoent>} */
long networkZnetwork_internalZget_p_proto_METH(descriptor_t *orig_sp, void * A_ptr /* ptr */, heapptr_t A1)
{
    descriptor_t *cluster_0_top;

    /* #line {Class <unknown-source-location>} */

    /* #line 198 "./melange.dylan" */

    /* #line 91 "./rawptr.dylan" */
    return (*(long *)((char *)A_ptr + 8 ));
}

/* generic-entry for get-p-proto{<protoent>} */
descriptor_t * networkZnetwork_internalZget_p_proto_METH_GENERIC(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    descriptor_t L_arg; /* arg */
    void * L_arg_2; /* arg */
    long L_result0; /* result0 */
    descriptor_t L_temp;

    /* #line {Class <unknown-source-location>} */
    L_args = ((void *)(orig_sp - 1));
    L_arg = (((descriptor_t *)L_args)[0]);
    L_arg_2 = L_arg.dataword.ptr;
    orig_sp = L_args;
    /* get-p-proto{<protoent>} */
    L_result0 = networkZnetwork_internalZget_p_proto_METH(orig_sp, L_arg_2, A_next_method_info);
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* {Implicit} Define Generic get-p-proto-setter */

/* get-p-proto-setter is get-p-proto-setter */


/* Define Method get-p-proto-setter{<integer>, <protoent>} */

/* get-p-proto-setter{<integer>, <protoent>} */
long networkZnetwork_internalZget_p_proto_setter_METH(descriptor_t *orig_sp, long A_value /* value */, void * A_ptr /* ptr */, heapptr_t A2)
{
    descriptor_t *cluster_0_top;


    /* #line 97 "./rawptr.dylan" */
    *(long *)((char *)A_ptr + 8) = A_value;
    return A_value;
}


/* Define Method pointer-value{<protoent>} */

extern struct heapobj networkZstr_ROOT_119;

/* pointer-value{<protoent>} */
void * networkZnetwork_internalZpointer_value_METH_54(descriptor_t *orig_sp, void * A_value /* value */, heapptr_t A_next_method_info /* next-method-info */, heapptr_t A_rest /* rest */, descriptor_t A_index /* index */)
{
    descriptor_t *cluster_0_top;
    descriptor_t L_temp;
    descriptor_t L_arg1; /* arg1 */
    descriptor_t L_temp_2;
    descriptor_t L_temp_3; /* temp */
    descriptor_t L_temp_4;

    /* #line {Class <unknown-source-location>} */

    /* #line 3393 "./sockets-api.dylan" */
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = 12;
    orig_sp[0] = A_index;
    orig_sp[1] = L_temp;
    /* * */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZV_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_arg1 = (orig_sp == cluster_0_top ? dylanZfalse : orig_sp[0]);

    /* #line 3393 "./sockets-api.dylan" */
    L_temp_2.heapptr = networkZliteral_69.heapptr;
    L_temp_2.dataword.ptr = A_value;
    orig_sp[0] = L_temp_2;
    orig_sp[1] = L_arg1;
    /* + */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZPLUS_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_temp_3 = (orig_sp == cluster_0_top ? dylanZfalse : orig_sp[0]);

    /* #line 386 "./condition.dylan" */
    if ((&networkZnetwork_internalZCLS_protoent_HEAP == SLOT(L_temp_3.heapptr, heapptr_t, 0))) {

	/* #line 3393 "./sockets-api.dylan" */
	return L_temp_3.dataword.ptr;
    }
    else {

	/* #line 389 "./condition.dylan" */
	L_temp_4.heapptr = &networkZstr_ROOT_119;
	L_temp_4.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp_3, &networkZnetwork_internalZCLS_protoent_HEAP, L_temp_4);
	not_reached();
    }
}

/* generic-entry for pointer-value{<protoent>} */
descriptor_t * networkZnetwork_internalZpointer_value_METH_GENERIC_54(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    descriptor_t L_arg; /* arg */
    heapptr_t L_rest; /* rest */
    void * L_arg_2; /* arg */
    descriptor_t L_index; /* index */
    long L_index_2; /* index */
    descriptor_t L_key; /* key */
    descriptor_t L_value; /* value */
    void * L_result0; /* result0 */
    descriptor_t L_temp;

    /* #line {Class <unknown-source-location>} */
    L_args = ((void *)(orig_sp - A_nargs));
    L_arg = (((descriptor_t *)L_args)[0]);
    L_rest = dylanZdylan_visceraZmake_rest_arg_FUN(orig_sp, (descriptor_t *)L_args + 1, A_nargs - 1);
    L_arg_2 = L_arg.dataword.ptr;
    L_index.heapptr = networkZliteral_2.heapptr;
    L_index.dataword.l = 0;
    L_index_2 = (A_nargs - 2);
    while (1) {
	if ((L_index_2 < 1)) {
	    goto block0;
	}
	else {
	    L_key = (((descriptor_t *)L_args)[L_index_2]);
	    L_value = (((descriptor_t *)L_args)[(L_index_2 + 1)]);
	    if ((L_key.heapptr == &SYM_index_HEAP)) {
		L_index = L_value;
	    }
	    L_index_2 = (L_index_2 - 2);
	}
    }
  block0:;
    orig_sp = L_args;
    /* pointer-value{<protoent>} */
    L_result0 = networkZnetwork_internalZpointer_value_METH_54(orig_sp, L_arg_2, A_next_method_info, L_rest, L_index);
    L_temp.heapptr = networkZliteral_69.heapptr;
    L_temp.dataword.ptr = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* Define Method content-size{subclass(<protoent>)} */

/* content-size{subclass(<protoent>)} */
long networkZnetwork_internalZcontent_size_METH_67(descriptor_t *orig_sp, heapptr_t A0, heapptr_t A1)
{

    return 12;
}

/* generic-entry for content-size{subclass(<protoent>)} */
descriptor_t * networkZnetwork_internalZcontent_size_METH_GENERIC_67(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    long L_result0; /* result0 */
    descriptor_t L_temp;

    orig_sp = ((void *)(orig_sp - 1));
    /* content-size{subclass(<protoent>)} */
    L_result0 = networkZnetwork_internalZcontent_size_METH_67(orig_sp, &networkZnetwork_internalZCLS_protoent_HEAP, A_next_method_info);
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* {Implicit} Define Generic setprotoent */

/* setprotoent is setprotoent */


/* Define Method setprotoent{<integer>} */

/* setprotoent{<integer>} */
void networkZnetwork_internalZsetprotoent_METH(descriptor_t *orig_sp, long A_arg1 /* arg1 */, heapptr_t A1)
{
    descriptor_t *cluster_0_top;


    /* #line 735 "./macros.dylan" */
    setprotoent(A_arg1);
    return;
}


/* {Implicit} Define Generic endprotoent */

/* endprotoent is endprotoent */


/* Define Method endprotoent{} */

/* endprotoent{} */
void networkZnetwork_internalZendprotoent_METH(descriptor_t *orig_sp, heapptr_t A0)
{
    descriptor_t *cluster_0_top;

    /* #line {Class <unknown-source-location>} */

    /* #line 735 "./macros.dylan" */
    endprotoent();
    return;
}


/* {Implicit} Define Generic getprotoent */

/* getprotoent is getprotoent */


/* Define Method getprotoent{} */

extern struct heapobj networkZstr_ROOT_120;

/* getprotoent{} */
void * networkZnetwork_internalZgetprotoent_METH(descriptor_t *orig_sp, heapptr_t A0)
{
    descriptor_t *cluster_0_top;
    void * L_result_value; /* result-value */
    heapptr_t L_instance; /* instance */
    descriptor_t L_temp;
    descriptor_t L_temp_2;
    descriptor_t L_temp_3;
    descriptor_t L_result_value_2; /* result-value */
    descriptor_t L_temp_4;

    /* #line {Class <unknown-source-location>} */

    /* #line 735 "./macros.dylan" */
    L_result_value = getprotoent();

    /* #line 3419 "./sockets-api.dylan" */
    /* maker for <simple-object-vector> */
    L_instance = dylanZdylan_visceraZCLS_simple_object_vector_MAKER_FUN(orig_sp, 2, dylanZfalse);
    L_temp.heapptr = &SYM_pointer_HEAP;
    L_temp.dataword.l = 0;
    SLOT(L_instance, descriptor_t, 8 + 0 * sizeof(descriptor_t)) = L_temp;
    L_temp_2.heapptr = networkZliteral_6.heapptr;
    L_temp_2.dataword.ptr = L_result_value;
    SLOT(L_instance, descriptor_t, 8 + 1 * sizeof(descriptor_t)) = L_temp_2;
    L_temp_3.heapptr = networkZliteral_6.heapptr;
    L_temp_3.dataword.ptr = L_result_value;
    /* make{subclass(<statically-typed-pointer>)} */
    L_result_value_2 = melange_supportZmelange_supportZmake_METH(orig_sp, &networkZnetwork_internalZCLS_protoent_HEAP, &networkZliteral_ROOT, L_instance, 0, L_temp_3, 1);

    /* #line 386 "./condition.dylan" */
    if ((&networkZnetwork_internalZCLS_protoent_HEAP == SLOT(L_result_value_2.heapptr, heapptr_t, 0))) {

	/* #line 3420 "./sockets-api.dylan" */
	return L_result_value_2.dataword.ptr;
    }
    else {

	/* #line 389 "./condition.dylan" */
	L_temp_4.heapptr = &networkZstr_ROOT_120;
	L_temp_4.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_result_value_2, &networkZnetwork_internalZCLS_protoent_HEAP, L_temp_4);
	not_reached();
    }
}


/* {Implicit} Define Generic getprotobyname */

/* getprotobyname is getprotobyname */


/* Define Method getprotobyname{<byte-string>} */

extern struct heapobj networkZstr_ROOT_121;

extern struct heapobj networkZstr_ROOT_122;

/* getprotobyname{<byte-string>} */
void * networkZnetwork_internalZgetprotobyname_METH(descriptor_t *orig_sp, heapptr_t A_arg1 /* arg1 */, heapptr_t A1)
{
    descriptor_t *cluster_0_top;
    descriptor_t L_temp;
    descriptor_t L_temp_2;
    descriptor_t L_argument; /* argument */
    int L_condition; /* condition */
    void * L_result_value; /* result-value */
    heapptr_t L_instance; /* instance */
    descriptor_t L_temp_3;
    descriptor_t L_temp_4;
    descriptor_t L_temp_5;
    descriptor_t L_result_value_2; /* result-value */
    descriptor_t L_temp_6;
    descriptor_t L_temp_7;

    /* #line {Class <unknown-source-location>} */

    /* #line 3427 "./sockets-api.dylan" */
    L_temp.heapptr = &melange_supportZmelange_supportZCLS_c_string_HEAP;
    L_temp.dataword.l = 0;
    L_temp_2.heapptr = A_arg1;
    L_temp_2.dataword.l = 0;
    orig_sp[0] = L_temp;
    orig_sp[1] = L_temp_2;
    /* export-value */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &melange_supportZmelange_supportZexport_value_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_argument = orig_sp[0];

    /* #line 49 "./object.dylan" */

    /* #line 386 "./condition.dylan" */
    /* %subtype?{<class>, <class>} */
    L_condition = dylanZdylan_visceraZPCTsubtypeQUERY_METH(orig_sp, SLOT(L_argument.heapptr, heapptr_t, 0), &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP, &dylanZliteral_ROOT_2);
    if (L_condition) {

	/* #line 3427 "./sockets-api.dylan" */

	/* #line 735 "./macros.dylan" */
	L_result_value = getprotobyname(L_argument.dataword.ptr);

	/* #line 3428 "./sockets-api.dylan" */
	/* maker for <simple-object-vector> */
	L_instance = dylanZdylan_visceraZCLS_simple_object_vector_MAKER_FUN(orig_sp, 2, dylanZfalse);
	L_temp_3.heapptr = &SYM_pointer_HEAP;
	L_temp_3.dataword.l = 0;
	SLOT(L_instance, descriptor_t, 8 + 0 * sizeof(descriptor_t)) = L_temp_3;
	L_temp_4.heapptr = networkZliteral_6.heapptr;
	L_temp_4.dataword.ptr = L_result_value;
	SLOT(L_instance, descriptor_t, 8 + 1 * sizeof(descriptor_t)) = L_temp_4;
	L_temp_5.heapptr = networkZliteral_6.heapptr;
	L_temp_5.dataword.ptr = L_result_value;
	/* make{subclass(<statically-typed-pointer>)} */
	L_result_value_2 = melange_supportZmelange_supportZmake_METH(orig_sp, &networkZnetwork_internalZCLS_protoent_HEAP, &networkZliteral_ROOT, L_instance, 0, L_temp_5, 1);

	/* #line 386 "./condition.dylan" */
	if ((&networkZnetwork_internalZCLS_protoent_HEAP == SLOT(L_result_value_2.heapptr, heapptr_t, 0))) {

	    /* #line 3429 "./sockets-api.dylan" */
	    return L_result_value_2.dataword.ptr;
	}
	else {

	    /* #line 389 "./condition.dylan" */
	    L_temp_6.heapptr = &networkZstr_ROOT_121;
	    L_temp_6.dataword.l = 0;
	    /* type-error-with-location */
	    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_result_value_2, &networkZnetwork_internalZCLS_protoent_HEAP, L_temp_6);
	    not_reached();
	}
    }
    else {
	L_temp_7.heapptr = &networkZstr_ROOT_122;
	L_temp_7.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_argument, &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP, L_temp_7);
	not_reached();
    }
}

/* generic-entry for getprotobyname{<byte-string>} */
descriptor_t * networkZnetwork_internalZgetprotobyname_METH_GENERIC(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    descriptor_t L_arg; /* arg */
    heapptr_t L_arg_2; /* arg */
    void * L_result0; /* result0 */
    descriptor_t L_temp;

    /* #line {Class <unknown-source-location>} */
    L_args = ((void *)(orig_sp - 1));
    L_arg = (((descriptor_t *)L_args)[0]);
    L_arg_2 = L_arg.heapptr;
    orig_sp = L_args;
    /* getprotobyname{<byte-string>} */
    L_result0 = networkZnetwork_internalZgetprotobyname_METH(orig_sp, L_arg_2, A_next_method_info);
    L_temp.heapptr = networkZliteral_69.heapptr;
    L_temp.dataword.ptr = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* {Implicit} Define Generic getprotobynumber */

/* getprotobynumber is getprotobynumber */


/* Define Method getprotobynumber{<integer>} */

extern struct heapobj networkZstr_ROOT_123;

/* getprotobynumber{<integer>} */
void * networkZnetwork_internalZgetprotobynumber_METH(descriptor_t *orig_sp, long A_arg1 /* arg1 */, heapptr_t A1)
{
    descriptor_t *cluster_0_top;
    void * L_result_value; /* result-value */
    heapptr_t L_instance; /* instance */
    descriptor_t L_temp;
    descriptor_t L_temp_2;
    descriptor_t L_temp_3;
    descriptor_t L_result_value_2; /* result-value */
    descriptor_t L_temp_4;


    /* #line 735 "./macros.dylan" */
    L_result_value = getprotobynumber(A_arg1);

    /* #line 3437 "./sockets-api.dylan" */
    /* maker for <simple-object-vector> */
    L_instance = dylanZdylan_visceraZCLS_simple_object_vector_MAKER_FUN(orig_sp, 2, dylanZfalse);
    L_temp.heapptr = &SYM_pointer_HEAP;
    L_temp.dataword.l = 0;
    SLOT(L_instance, descriptor_t, 8 + 0 * sizeof(descriptor_t)) = L_temp;
    L_temp_2.heapptr = networkZliteral_6.heapptr;
    L_temp_2.dataword.ptr = L_result_value;
    SLOT(L_instance, descriptor_t, 8 + 1 * sizeof(descriptor_t)) = L_temp_2;
    L_temp_3.heapptr = networkZliteral_6.heapptr;
    L_temp_3.dataword.ptr = L_result_value;
    /* make{subclass(<statically-typed-pointer>)} */
    L_result_value_2 = melange_supportZmelange_supportZmake_METH(orig_sp, &networkZnetwork_internalZCLS_protoent_HEAP, &networkZliteral_ROOT, L_instance, 0, L_temp_3, 1);

    /* #line 386 "./condition.dylan" */
    if ((&networkZnetwork_internalZCLS_protoent_HEAP == SLOT(L_result_value_2.heapptr, heapptr_t, 0))) {

	/* #line 3438 "./sockets-api.dylan" */
	return L_result_value_2.dataword.ptr;
    }
    else {

	/* #line 389 "./condition.dylan" */
	L_temp_4.heapptr = &networkZstr_ROOT_123;
	L_temp_4.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_result_value_2, &networkZnetwork_internalZCLS_protoent_HEAP, L_temp_4);
	not_reached();
    }
}


/* Define Class <protoent*> */

/* <protoent*> is <protoent*> */

extern struct heapobj networkZnetwork_internalZCLS_protoentV_HEAP;

/* maker for <protoent*> */
void * networkZnetwork_internalZCLS_protoentV_MAKER_FUN(descriptor_t *orig_sp, void * A_pointer /* pointer */, int A_pointer_suppliedQUERY /* pointer-supplied? */)
{
    descriptor_t *cluster_0_top;


    /* #line 3441 "./sockets-api.dylan" */
    if (A_pointer_suppliedQUERY) {
	return A_pointer;
    }
    else {
	/* missing-required-init-keyword-error */
	dylanZdylan_visceraZmissing_required_init_keyword_error_FUN(orig_sp, &SYM_pointer_HEAP, &networkZnetwork_internalZCLS_protoentV_HEAP);
	not_reached();
    }
}

extern descriptor_t networkZliteral_70;	/* proxy for <protoent*> */

/* general-entry for maker for <protoent*> */
descriptor_t * networkZnetwork_internalZCLS_protoentV_MAKER_GENERAL(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    void * L_pointer; /* pointer */
    int L_pointer_suppliedQUERY; /* pointer-supplied? */
    long L_index; /* index */
    descriptor_t L_temp; /* temp */
    descriptor_t L_value; /* value */
    descriptor_t L_temp_2;
    descriptor_t L_temp_3;
    void * L_result0; /* result0 */
    descriptor_t L_temp_4;

    /* #line {Class <unknown-source-location>} */

    /* #line 126 "./cmp.dylan" */

    /* #line 209 "./num.dylan" */
    if (((A_nargs & 1) == 0)) {
	/* #line {Class <unknown-source-location>} */
	L_args = ((void *)(orig_sp - A_nargs));
	L_pointer = 0;
	L_pointer_suppliedQUERY = FALSE;
	L_index = (A_nargs - 2);
	while (1) {
	    if ((L_index < 0)) {
		goto block0;
	    }
	    else {
		L_temp = (((descriptor_t *)L_args)[L_index]);

		/* #line 386 "./condition.dylan" */
		if ((&dylanZdylan_visceraZCLS_symbol_HEAP == SLOT(L_temp.heapptr, heapptr_t, 0))) {
		    /* #line {Class <unknown-source-location>} */
		    L_value = (((descriptor_t *)L_args)[(L_index + 1)]);
		    if ((L_temp.heapptr == &SYM_pointer_HEAP)) {

			/* #line 386 "./condition.dylan" */
			if ((&dylanZdylan_visceraZCLS_raw_pointer_HEAP == SLOT(L_value.heapptr, heapptr_t, 0))) {
			    /* #line {Class <unknown-source-location>} */
			    L_pointer = L_value.dataword.ptr;
			    L_pointer_suppliedQUERY = TRUE;
			}
			else {

			    /* #line 389 "./condition.dylan" */
			    L_temp_2.heapptr = &networkZstr_ROOT;
			    L_temp_2.dataword.l = 0;
			    /* type-error-with-location */
			    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_value, &dylanZdylan_visceraZCLS_raw_pointer_HEAP, L_temp_2);
			    not_reached();
			}
		    }
		    /* #line {Class <unknown-source-location>} */
		    L_index = (L_index - 2);
		}
		else {

		    /* #line 389 "./condition.dylan" */
		    L_temp_3.heapptr = &networkZstr_ROOT;
		    L_temp_3.dataword.l = 0;
		    /* type-error-with-location */
		    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp, &dylanZdylan_visceraZCLS_symbol_HEAP, L_temp_3);
		    not_reached();
		}
	    }
	}
      block0:;
	/* #line {Class <unknown-source-location>} */
	orig_sp = L_args;
	/* maker for <protoent*> */
	L_result0 = networkZnetwork_internalZCLS_protoentV_MAKER_FUN(orig_sp, L_pointer, L_pointer_suppliedQUERY);
	L_temp_4.heapptr = networkZliteral_70.heapptr;
	L_temp_4.dataword.ptr = L_result0;
	orig_sp[0] = L_temp_4;
	return orig_sp + 1;
    }
    else {
	/* odd-number-of-keyword/value-arguments-error */
	dylanZdylan_visceraZodd_number_of_keywordSLASHvalue_arguments_error_FUN(orig_sp);
	not_reached();
    }
}


/* Define Sealed Domain make (singleton(<protoent*>)) */


/* Define Method pointer-value{<protoent*>} */

extern struct heapobj networkZstr_ROOT_124;

/* pointer-value{<protoent*>} */
void * networkZnetwork_internalZpointer_value_METH_55(descriptor_t *orig_sp, void * A_ptr /* ptr */, heapptr_t A_next_method_info /* next-method-info */, heapptr_t A_rest /* rest */, descriptor_t A_index /* index */)
{
    descriptor_t *cluster_0_top;
    descriptor_t L_temp;
    descriptor_t L_arg2; /* arg2 */
    descriptor_t L_temp_2;
    descriptor_t L_temp_3;
    descriptor_t L_temp_4; /* temp */
    int L_condition; /* condition */
    descriptor_t L_result; /* result */
    descriptor_t L_temp_5;
    descriptor_t L_temp_6;
    descriptor_t L_temp_7;


    /* #line 3448 "./sockets-api.dylan" */
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = 4;
    orig_sp[0] = A_index;
    orig_sp[1] = L_temp;
    /* * */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZV_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_arg2 = (orig_sp == cluster_0_top ? dylanZfalse : orig_sp[0]);

    /* #line 386 "./condition.dylan" */
    if ((&dylanZdylan_visceraZCLS_integer_HEAP == SLOT(L_arg2.heapptr, heapptr_t, 0))) {

	/* #line 3448 "./sockets-api.dylan" */

	/* #line 290 "./melange.dylan" */

	/* #line 91 "./rawptr.dylan" */

	/* #line 290 "./melange.dylan" */
	L_temp_2.heapptr = &networkZnetwork_internalZCLS_protoent_HEAP;
	L_temp_2.dataword.l = 0;
	L_temp_3.heapptr = networkZliteral_6.heapptr;
	L_temp_3.dataword.ptr = (*(void * *)((char *)A_ptr + L_arg2.dataword.l ));
	orig_sp[0] = L_temp_2;
	orig_sp[1] = L_temp_3;
	/* as */
	{
	  struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZas_HEAP, 2);
	  heapptr_t L_meth = L_temp.R0;
	  heapptr_t L_next_info = L_temp.R1;
	  cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
	}
	L_temp_4 = orig_sp[0];

	/* #line 49 "./object.dylan" */

	/* #line 386 "./condition.dylan" */
	/* %subtype?{<class>, <class>} */
	L_condition = dylanZdylan_visceraZPCTsubtypeQUERY_METH(orig_sp, SLOT(L_temp_4.heapptr, heapptr_t, 0), &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP, &dylanZliteral_ROOT_2);
	if (L_condition) {

	    /* #line 290 "./melange.dylan" */
	    L_result = L_temp_4;

	    /* #line 386 "./condition.dylan" */
	    if ((&networkZnetwork_internalZCLS_protoent_HEAP == SLOT(L_result.heapptr, heapptr_t, 0))) {

		/* #line 3448 "./sockets-api.dylan" */
		return L_result.dataword.ptr;
	    }
	    else {

		/* #line 389 "./condition.dylan" */
		L_temp_5.heapptr = &networkZstr_ROOT_124;
		L_temp_5.dataword.l = 0;
		/* type-error-with-location */
		dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_result, &networkZnetwork_internalZCLS_protoent_HEAP, L_temp_5);
		not_reached();
	    }
	}
	else {
	    L_temp_6.heapptr = &networkZstr_ROOT_14;
	    L_temp_6.dataword.l = 0;
	    /* type-error-with-location */
	    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp_4, &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP, L_temp_6);
	    not_reached();
	}
    }
    else {
	L_temp_7.heapptr = &networkZstr_ROOT_124;
	L_temp_7.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_arg2, &dylanZdylan_visceraZCLS_integer_HEAP, L_temp_7);
	not_reached();
    }
}

/* generic-entry for pointer-value{<protoent*>} */
descriptor_t * networkZnetwork_internalZpointer_value_METH_GENERIC_55(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    descriptor_t L_arg; /* arg */
    heapptr_t L_rest; /* rest */
    void * L_arg_2; /* arg */
    descriptor_t L_index; /* index */
    long L_index_2; /* index */
    descriptor_t L_key; /* key */
    descriptor_t L_value; /* value */
    void * L_result0; /* result0 */
    descriptor_t L_temp;

    /* #line {Class <unknown-source-location>} */
    L_args = ((void *)(orig_sp - A_nargs));
    L_arg = (((descriptor_t *)L_args)[0]);
    L_rest = dylanZdylan_visceraZmake_rest_arg_FUN(orig_sp, (descriptor_t *)L_args + 1, A_nargs - 1);
    L_arg_2 = L_arg.dataword.ptr;
    L_index.heapptr = networkZliteral_2.heapptr;
    L_index.dataword.l = 0;
    L_index_2 = (A_nargs - 2);
    while (1) {
	if ((L_index_2 < 1)) {
	    goto block0;
	}
	else {
	    L_key = (((descriptor_t *)L_args)[L_index_2]);
	    L_value = (((descriptor_t *)L_args)[(L_index_2 + 1)]);
	    if ((L_key.heapptr == &SYM_index_HEAP)) {
		L_index = L_value;
	    }
	    L_index_2 = (L_index_2 - 2);
	}
    }
  block0:;
    orig_sp = L_args;
    /* pointer-value{<protoent*>} */
    L_result0 = networkZnetwork_internalZpointer_value_METH_55(orig_sp, L_arg_2, A_next_method_info, L_rest, L_index);
    L_temp.heapptr = networkZliteral_69.heapptr;
    L_temp.dataword.ptr = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* Define Method pointer-value-setter{<protoent>, <protoent*>} */

/* pointer-value-setter{<protoent>, <protoent*>} */
void * networkZnetwork_internalZpointer_value_setter_METH_16(descriptor_t *orig_sp, void * A_value /* value */, void * A_ptr /* ptr */, heapptr_t A_next_method_info /* next-method-info */, heapptr_t A_rest /* rest */, descriptor_t A_index /* index */)
{
    descriptor_t *cluster_0_top;
    descriptor_t L_temp;
    descriptor_t L_arg3; /* arg3 */
    descriptor_t L_temp_2;


    /* #line 3454 "./sockets-api.dylan" */
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = 4;
    orig_sp[0] = A_index;
    orig_sp[1] = L_temp;
    /* * */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZV_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_arg3 = (orig_sp == cluster_0_top ? dylanZfalse : orig_sp[0]);

    /* #line 386 "./condition.dylan" */
    if ((&dylanZdylan_visceraZCLS_integer_HEAP == SLOT(L_arg3.heapptr, heapptr_t, 0))) {
	/* #line {Class <unknown-source-location>} */

	/* #line 299 "./melange.dylan" */
	/* #line {Class <unknown-source-location>} */

	/* #line 97 "./rawptr.dylan" */
	*(void * *)((char *)A_ptr + L_arg3.dataword.l) = A_value;
	return A_value;
    }
    else {

	/* #line 389 "./condition.dylan" */
	L_temp_2.heapptr = &networkZstr_ROOT;
	L_temp_2.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_arg3, &dylanZdylan_visceraZCLS_integer_HEAP, L_temp_2);
	not_reached();
    }
}

/* generic-entry for pointer-value-setter{<protoent>, <protoent*>} */
descriptor_t * networkZnetwork_internalZpointer_value_setter_METH_GENERIC_16(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    descriptor_t L_arg; /* arg */
    descriptor_t L_arg_2; /* arg */
    heapptr_t L_rest; /* rest */
    void * L_arg_3; /* arg */
    void * L_arg_4; /* arg */
    descriptor_t L_index; /* index */
    long L_index_2; /* index */
    descriptor_t L_key; /* key */
    descriptor_t L_value; /* value */
    void * L_result0; /* result0 */
    descriptor_t L_temp;

    /* #line {Class <unknown-source-location>} */
    L_args = ((void *)(orig_sp - A_nargs));
    L_arg = (((descriptor_t *)L_args)[0]);
    L_arg_2 = (((descriptor_t *)L_args)[1]);
    L_rest = dylanZdylan_visceraZmake_rest_arg_FUN(orig_sp, (descriptor_t *)L_args + 2, A_nargs - 2);
    L_arg_3 = L_arg.dataword.ptr;
    L_arg_4 = L_arg_2.dataword.ptr;
    L_index.heapptr = networkZliteral_2.heapptr;
    L_index.dataword.l = 0;
    L_index_2 = (A_nargs - 2);
    while (1) {
	if ((L_index_2 < 2)) {
	    goto block0;
	}
	else {
	    L_key = (((descriptor_t *)L_args)[L_index_2]);
	    L_value = (((descriptor_t *)L_args)[(L_index_2 + 1)]);
	    if ((L_key.heapptr == &SYM_index_HEAP)) {
		L_index = L_value;
	    }
	    L_index_2 = (L_index_2 - 2);
	}
    }
  block0:;
    orig_sp = L_args;
    /* pointer-value-setter{<protoent>, <protoent*>} */
    L_result0 = networkZnetwork_internalZpointer_value_setter_METH_16(orig_sp, L_arg_3, L_arg_4, A_next_method_info, L_rest, L_index);
    L_temp.heapptr = networkZliteral_69.heapptr;
    L_temp.dataword.ptr = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* Define Method content-size{subclass(<protoent*>)} */

/* content-size{subclass(<protoent*>)} */
long networkZnetwork_internalZcontent_size_METH_68(descriptor_t *orig_sp, heapptr_t A0, heapptr_t A1)
{

    return 4;
}

/* generic-entry for content-size{subclass(<protoent*>)} */
descriptor_t * networkZnetwork_internalZcontent_size_METH_GENERIC_68(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    long L_result0; /* result0 */
    descriptor_t L_temp;

    orig_sp = ((void *)(orig_sp - 1));
    /* content-size{subclass(<protoent*>)} */
    L_result0 = networkZnetwork_internalZcontent_size_METH_68(orig_sp, &networkZnetwork_internalZCLS_protoentV_HEAP, A_next_method_info);
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* {Implicit} Define Generic getprotoent-r */

/* getprotoent-r is getprotoent-r */


/* Define Method getprotoent-r{<protoent>, <c-char-vector>, <integer>, <protoent*>} */

/* getprotoent-r{<protoent>, <c-char-vector>, <integer>, <protoent*>} */
long networkZnetwork_internalZgetprotoent_r_METH(descriptor_t *orig_sp, void * A_arg1 /* arg1 */, descriptor_t A_arg2 /* arg2 */, long A_arg3 /* arg3 */, void * A_arg4 /* arg4 */, heapptr_t A4)
{
    descriptor_t *cluster_0_top;
    long L_result_value; /* result-value */


    /* #line 3466 "./sockets-api.dylan" */

    /* #line 3466 "./sockets-api.dylan" */

    /* #line 3466 "./sockets-api.dylan" */

    /* #line 735 "./macros.dylan" */
    L_result_value = getprotoent_r(A_arg1, A_arg2.dataword.ptr, A_arg3, A_arg4);
    return L_result_value;
}


/* {Implicit} Define Generic getprotobyname-r */

/* getprotobyname-r is getprotobyname-r */


/* Define Method getprotobyname-r{<c-char-vector>, <protoent>, <c-char-vector>, <integer>, <protoent*>} */

/* getprotobyname-r{<c-char-vector>, <protoent>, <c-char-vector>, <integer>, <protoent*>} */
long networkZnetwork_internalZgetprotobyname_r_METH(descriptor_t *orig_sp, descriptor_t A_arg1 /* arg1 */, void * A_arg2 /* arg2 */, descriptor_t A_arg3 /* arg3 */, long A_arg4 /* arg4 */, void * A_arg5 /* arg5 */, heapptr_t A5)
{
    descriptor_t *cluster_0_top;
    long L_result_value; /* result-value */

    /* #line {Class <unknown-source-location>} */

    /* #line 3474 "./sockets-api.dylan" */

    /* #line 3474 "./sockets-api.dylan" */

    /* #line 3474 "./sockets-api.dylan" */

    /* #line 3474 "./sockets-api.dylan" */

    /* #line 735 "./macros.dylan" */
    L_result_value = getprotobyname_r(A_arg1.dataword.ptr, A_arg2, A_arg3.dataword.ptr, A_arg4, A_arg5);
    return L_result_value;
}


/* {Implicit} Define Generic getprotobynumber-r */

/* getprotobynumber-r is getprotobynumber-r */


/* Define Method getprotobynumber-r{<integer>, <protoent>, <c-char-vector>, <integer>, <protoent*>} */

/* getprotobynumber-r{<integer>, <protoent>, <c-char-vector>, <integer>, <protoent*>} */
long networkZnetwork_internalZgetprotobynumber_r_METH(descriptor_t *orig_sp, long A_arg1 /* arg1 */, void * A_arg2 /* arg2 */, descriptor_t A_arg3 /* arg3 */, long A_arg4 /* arg4 */, void * A_arg5 /* arg5 */, heapptr_t A5)
{
    descriptor_t *cluster_0_top;
    long L_result_value; /* result-value */

    /* #line {Class <unknown-source-location>} */

    /* #line 3482 "./sockets-api.dylan" */

    /* #line 3482 "./sockets-api.dylan" */

    /* #line 3482 "./sockets-api.dylan" */

    /* #line 735 "./macros.dylan" */
    L_result_value = getprotobynumber_r(A_arg1, A_arg2, A_arg3.dataword.ptr, A_arg4, A_arg5);
    return L_result_value;
}


/* {Implicit} Define Generic setnetgrent */

/* setnetgrent is setnetgrent */


/* Define Method setnetgrent{<c-char-vector>} */

/* setnetgrent{<c-char-vector>} */
long networkZnetwork_internalZsetnetgrent_METH(descriptor_t *orig_sp, descriptor_t A_arg1 /* arg1 */, heapptr_t A1)
{
    descriptor_t *cluster_0_top;
    long L_result_value; /* result-value */

    /* #line {Class <unknown-source-location>} */

    /* #line 3490 "./sockets-api.dylan" */

    /* #line 735 "./macros.dylan" */
    L_result_value = setnetgrent(A_arg1.dataword.ptr);
    return L_result_value;
}


/* {Implicit} Define Generic endnetgrent */

/* endnetgrent is endnetgrent */


/* Define Method endnetgrent{} */

/* endnetgrent{} */
void networkZnetwork_internalZendnetgrent_METH(descriptor_t *orig_sp, heapptr_t A0)
{
    descriptor_t *cluster_0_top;

    /* #line {Class <unknown-source-location>} */

    /* #line 735 "./macros.dylan" */
    endnetgrent();
    return;
}


/* {Implicit} Define Generic getnetgrent */

/* getnetgrent is getnetgrent */


/* Define Method getnetgrent{<c-char-pointer-vector>, <c-char-pointer-vector>, <c-char-pointer-vector>} */

/* getnetgrent{<c-char-pointer-vector>, <c-char-pointer-vector>, <c-char-pointer-vector>} */
long networkZnetwork_internalZgetnetgrent_METH(descriptor_t *orig_sp, void * A_arg1 /* arg1 */, void * A_arg2 /* arg2 */, void * A_arg3 /* arg3 */, heapptr_t A3)
{
    descriptor_t *cluster_0_top;
    long L_result_value; /* result-value */

    /* #line {Class <unknown-source-location>} */

    /* #line 3505 "./sockets-api.dylan" */

    /* #line 3505 "./sockets-api.dylan" */

    /* #line 3505 "./sockets-api.dylan" */

    /* #line 735 "./macros.dylan" */
    L_result_value = getnetgrent(A_arg1, A_arg2, A_arg3);
    return L_result_value;
}


/* {Implicit} Define Generic innetgr */

/* innetgr is innetgr */


/* Define Method innetgr{<c-char-vector>, <c-char-vector>, <c-char-vector>, <c-char-vector>} */

/* innetgr{<c-char-vector>, <c-char-vector>, <c-char-vector>, <c-char-vector>} */
long networkZnetwork_internalZinnetgr_METH(descriptor_t *orig_sp, descriptor_t A_arg1 /* arg1 */, descriptor_t A_arg2 /* arg2 */, descriptor_t A_arg3 /* arg3 */, descriptor_t A_arg4 /* arg4 */, heapptr_t A4)
{
    descriptor_t *cluster_0_top;
    long L_result_value; /* result-value */

    /* #line {Class <unknown-source-location>} */

    /* #line 3513 "./sockets-api.dylan" */

    /* #line 3513 "./sockets-api.dylan" */

    /* #line 3513 "./sockets-api.dylan" */

    /* #line 3513 "./sockets-api.dylan" */

    /* #line 735 "./macros.dylan" */
    L_result_value = innetgr(A_arg1.dataword.ptr, A_arg2.dataword.ptr, A_arg3.dataword.ptr, A_arg4.dataword.ptr);
    return L_result_value;
}


/* {Implicit} Define Generic getnetgrent-r */

/* getnetgrent-r is getnetgrent-r */


/* Define Method getnetgrent-r{<c-char-pointer-vector>, <c-char-pointer-vector>, <c-char-pointer-vector>, <c-char-vector>, <integer>} */

/* getnetgrent-r{<c-char-pointer-vector>, <c-char-pointer-vector>, <c-char-pointer-vector>, <c-char-vector>, <integer>} */
long networkZnetwork_internalZgetnetgrent_r_METH(descriptor_t *orig_sp, void * A_arg1 /* arg1 */, void * A_arg2 /* arg2 */, void * A_arg3 /* arg3 */, descriptor_t A_arg4 /* arg4 */, long A_arg5 /* arg5 */, heapptr_t A5)
{
    descriptor_t *cluster_0_top;
    long L_result_value; /* result-value */

    /* #line {Class <unknown-source-location>} */

    /* #line 3521 "./sockets-api.dylan" */

    /* #line 3521 "./sockets-api.dylan" */

    /* #line 3521 "./sockets-api.dylan" */

    /* #line 3521 "./sockets-api.dylan" */

    /* #line 735 "./macros.dylan" */
    L_result_value = getnetgrent_r(A_arg1, A_arg2, A_arg3, A_arg4.dataword.ptr, A_arg5);
    return L_result_value;
}


/* {Implicit} Define Generic rcmd */

/* rcmd is rcmd */


/* Define Method rcmd{<c-char-pointer-vector>, <integer>, <c-char-vector>, <c-char-vector>, <c-char-vector>, <int*>} */

/* rcmd{<c-char-pointer-vector>, <integer>, <c-char-vector>, <c-char-vector>, <c-char-vector>, <int*>} */
long networkZnetwork_internalZrcmd_METH(descriptor_t *orig_sp, void * A_arg1 /* arg1 */, long A_arg2 /* arg2 */, descriptor_t A_arg3 /* arg3 */, descriptor_t A_arg4 /* arg4 */, descriptor_t A_arg5 /* arg5 */, descriptor_t A_arg6 /* arg6 */, heapptr_t A6)
{
    descriptor_t *cluster_0_top;
    long L_result_value; /* result-value */

    /* #line {Class <unknown-source-location>} */

    /* #line 3529 "./sockets-api.dylan" */

    /* #line 3529 "./sockets-api.dylan" */

    /* #line 3529 "./sockets-api.dylan" */

    /* #line 3529 "./sockets-api.dylan" */

    /* #line 3529 "./sockets-api.dylan" */

    /* #line 735 "./macros.dylan" */
    L_result_value = rcmd(A_arg1, A_arg2, A_arg3.dataword.ptr, A_arg4.dataword.ptr, A_arg5.dataword.ptr, A_arg6.dataword.ptr);
    return L_result_value;
}


/* {Implicit} Define Generic rcmd-af */

/* rcmd-af is rcmd-af */


/* Define Method rcmd-af{<c-char-pointer-vector>, <integer>, <c-char-vector>, <c-char-vector>, <c-char-vector>, <int*>, <integer>} */

/* rcmd-af{<c-char-pointer-vector>, <integer>, <c-char-vector>, <c-char-vector>, <c-char-vector>, <int*>, <integer>} */
long networkZnetwork_internalZrcmd_af_METH(descriptor_t *orig_sp, void * A_arg1 /* arg1 */, long A_arg2 /* arg2 */, descriptor_t A_arg3 /* arg3 */, descriptor_t A_arg4 /* arg4 */, descriptor_t A_arg5 /* arg5 */, descriptor_t A_arg6 /* arg6 */, long A_arg7 /* arg7 */, heapptr_t A7)
{
    descriptor_t *cluster_0_top;
    long L_result_value; /* result-value */

    /* #line {Class <unknown-source-location>} */

    /* #line 3537 "./sockets-api.dylan" */

    /* #line 3537 "./sockets-api.dylan" */

    /* #line 3537 "./sockets-api.dylan" */

    /* #line 3537 "./sockets-api.dylan" */

    /* #line 3537 "./sockets-api.dylan" */

    /* #line 735 "./macros.dylan" */
    L_result_value = rcmd_af(A_arg1, A_arg2, A_arg3.dataword.ptr, A_arg4.dataword.ptr, A_arg5.dataword.ptr, A_arg6.dataword.ptr, A_arg7);
    return L_result_value;
}


/* {Implicit} Define Generic rexec */

/* rexec is rexec */


/* Define Method rexec{<c-char-pointer-vector>, <integer>, <c-char-vector>, <c-char-vector>, <c-char-vector>, <int*>} */

/* rexec{<c-char-pointer-vector>, <integer>, <c-char-vector>, <c-char-vector>, <c-char-vector>, <int*>} */
long networkZnetwork_internalZrexec_METH(descriptor_t *orig_sp, void * A_arg1 /* arg1 */, long A_arg2 /* arg2 */, descriptor_t A_arg3 /* arg3 */, descriptor_t A_arg4 /* arg4 */, descriptor_t A_arg5 /* arg5 */, descriptor_t A_arg6 /* arg6 */, heapptr_t A6)
{
    descriptor_t *cluster_0_top;
    long L_result_value; /* result-value */

    /* #line {Class <unknown-source-location>} */

    /* #line 3545 "./sockets-api.dylan" */

    /* #line 3545 "./sockets-api.dylan" */

    /* #line 3545 "./sockets-api.dylan" */

    /* #line 3545 "./sockets-api.dylan" */

    /* #line 3545 "./sockets-api.dylan" */

    /* #line 735 "./macros.dylan" */
    L_result_value = rexec(A_arg1, A_arg2, A_arg3.dataword.ptr, A_arg4.dataword.ptr, A_arg5.dataword.ptr, A_arg6.dataword.ptr);
    return L_result_value;
}


/* {Implicit} Define Generic rexec-af */

/* rexec-af is rexec-af */


/* Define Method rexec-af{<c-char-pointer-vector>, <integer>, <c-char-vector>, <c-char-vector>, <c-char-vector>, <int*>, <integer>} */

/* rexec-af{<c-char-pointer-vector>, <integer>, <c-char-vector>, <c-char-vector>, <c-char-vector>, <int*>, <integer>} */
long networkZnetwork_internalZrexec_af_METH(descriptor_t *orig_sp, void * A_arg1 /* arg1 */, long A_arg2 /* arg2 */, descriptor_t A_arg3 /* arg3 */, descriptor_t A_arg4 /* arg4 */, descriptor_t A_arg5 /* arg5 */, descriptor_t A_arg6 /* arg6 */, long A_arg7 /* arg7 */, heapptr_t A7)
{
    descriptor_t *cluster_0_top;
    long L_result_value; /* result-value */

    /* #line {Class <unknown-source-location>} */

    /* #line 3553 "./sockets-api.dylan" */

    /* #line 3553 "./sockets-api.dylan" */

    /* #line 3553 "./sockets-api.dylan" */

    /* #line 3553 "./sockets-api.dylan" */

    /* #line 3553 "./sockets-api.dylan" */

    /* #line 735 "./macros.dylan" */
    L_result_value = rexec_af(A_arg1, A_arg2, A_arg3.dataword.ptr, A_arg4.dataword.ptr, A_arg5.dataword.ptr, A_arg6.dataword.ptr, A_arg7);
    return L_result_value;
}


/* {Implicit} Define Generic ruserok */

/* ruserok is ruserok */


/* Define Method ruserok{<c-char-vector>, <integer>, <c-char-vector>, <c-char-vector>} */

/* ruserok{<c-char-vector>, <integer>, <c-char-vector>, <c-char-vector>} */
long networkZnetwork_internalZruserok_METH(descriptor_t *orig_sp, descriptor_t A_arg1 /* arg1 */, long A_arg2 /* arg2 */, descriptor_t A_arg3 /* arg3 */, descriptor_t A_arg4 /* arg4 */, heapptr_t A4)
{
    descriptor_t *cluster_0_top;
    long L_result_value; /* result-value */

    /* #line {Class <unknown-source-location>} */

    /* #line 3561 "./sockets-api.dylan" */

    /* #line 3561 "./sockets-api.dylan" */

    /* #line 3561 "./sockets-api.dylan" */

    /* #line 735 "./macros.dylan" */
    L_result_value = ruserok(A_arg1.dataword.ptr, A_arg2, A_arg3.dataword.ptr, A_arg4.dataword.ptr);
    return L_result_value;
}


/* {Implicit} Define Generic ruserok-af */

/* ruserok-af is ruserok-af */


/* Define Method ruserok-af{<c-char-vector>, <integer>, <c-char-vector>, <c-char-vector>, <integer>} */

/* ruserok-af{<c-char-vector>, <integer>, <c-char-vector>, <c-char-vector>, <integer>} */
long networkZnetwork_internalZruserok_af_METH(descriptor_t *orig_sp, descriptor_t A_arg1 /* arg1 */, long A_arg2 /* arg2 */, descriptor_t A_arg3 /* arg3 */, descriptor_t A_arg4 /* arg4 */, long A_arg5 /* arg5 */, heapptr_t A5)
{
    descriptor_t *cluster_0_top;
    long L_result_value; /* result-value */

    /* #line {Class <unknown-source-location>} */

    /* #line 3569 "./sockets-api.dylan" */

    /* #line 3569 "./sockets-api.dylan" */

    /* #line 3569 "./sockets-api.dylan" */

    /* #line 735 "./macros.dylan" */
    L_result_value = ruserok_af(A_arg1.dataword.ptr, A_arg2, A_arg3.dataword.ptr, A_arg4.dataword.ptr, A_arg5);
    return L_result_value;
}


/* {Implicit} Define Generic rresvport */

/* rresvport is rresvport */


/* Define Method rresvport{<int*>} */

/* rresvport{<int*>} */
long networkZnetwork_internalZrresvport_METH(descriptor_t *orig_sp, descriptor_t A_arg1 /* arg1 */, heapptr_t A1)
{
    descriptor_t *cluster_0_top;
    long L_result_value; /* result-value */

    /* #line {Class <unknown-source-location>} */

    /* #line 3577 "./sockets-api.dylan" */

    /* #line 735 "./macros.dylan" */
    L_result_value = rresvport(A_arg1.dataword.ptr);
    return L_result_value;
}


/* {Implicit} Define Generic rresvport-af */

/* rresvport-af is rresvport-af */


/* Define Method rresvport-af{<int*>, <integer>} */

/* rresvport-af{<int*>, <integer>} */
long networkZnetwork_internalZrresvport_af_METH(descriptor_t *orig_sp, descriptor_t A_arg1 /* arg1 */, long A_arg2 /* arg2 */, heapptr_t A2)
{
    descriptor_t *cluster_0_top;
    long L_result_value; /* result-value */

    /* #line {Class <unknown-source-location>} */

    /* #line 3585 "./sockets-api.dylan" */

    /* #line 735 "./macros.dylan" */
    L_result_value = rresvport_af(A_arg1.dataword.ptr, A_arg2);
    return L_result_value;
}


/* Define Class <addrinfo> */

/* <addrinfo> is <addrinfo> */

extern struct heapobj networkZnetwork_internalZCLS_addrinfo_HEAP;

/* maker for <addrinfo> */
void * networkZnetwork_internalZCLS_addrinfo_MAKER_FUN(descriptor_t *orig_sp, void * A_pointer /* pointer */, int A_pointer_suppliedQUERY /* pointer-supplied? */)
{
    descriptor_t *cluster_0_top;


    /* #line 3589 "./sockets-api.dylan" */
    if (A_pointer_suppliedQUERY) {
	return A_pointer;
    }
    else {
	/* missing-required-init-keyword-error */
	dylanZdylan_visceraZmissing_required_init_keyword_error_FUN(orig_sp, &SYM_pointer_HEAP, &networkZnetwork_internalZCLS_addrinfo_HEAP);
	not_reached();
    }
}

extern descriptor_t networkZliteral_71;	/* proxy for <addrinfo> */

/* general-entry for maker for <addrinfo> */
descriptor_t * networkZnetwork_internalZCLS_addrinfo_MAKER_GENERAL(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    void * L_pointer; /* pointer */
    int L_pointer_suppliedQUERY; /* pointer-supplied? */
    long L_index; /* index */
    descriptor_t L_temp; /* temp */
    descriptor_t L_value; /* value */
    descriptor_t L_temp_2;
    descriptor_t L_temp_3;
    void * L_result0; /* result0 */
    descriptor_t L_temp_4;

    /* #line {Class <unknown-source-location>} */

    /* #line 126 "./cmp.dylan" */

    /* #line 209 "./num.dylan" */
    if (((A_nargs & 1) == 0)) {
	/* #line {Class <unknown-source-location>} */
	L_args = ((void *)(orig_sp - A_nargs));
	L_pointer = 0;
	L_pointer_suppliedQUERY = FALSE;
	L_index = (A_nargs - 2);
	while (1) {
	    if ((L_index < 0)) {
		goto block0;
	    }
	    else {
		L_temp = (((descriptor_t *)L_args)[L_index]);

		/* #line 386 "./condition.dylan" */
		if ((&dylanZdylan_visceraZCLS_symbol_HEAP == SLOT(L_temp.heapptr, heapptr_t, 0))) {
		    /* #line {Class <unknown-source-location>} */
		    L_value = (((descriptor_t *)L_args)[(L_index + 1)]);
		    if ((L_temp.heapptr == &SYM_pointer_HEAP)) {

			/* #line 386 "./condition.dylan" */
			if ((&dylanZdylan_visceraZCLS_raw_pointer_HEAP == SLOT(L_value.heapptr, heapptr_t, 0))) {
			    /* #line {Class <unknown-source-location>} */
			    L_pointer = L_value.dataword.ptr;
			    L_pointer_suppliedQUERY = TRUE;
			}
			else {

			    /* #line 389 "./condition.dylan" */
			    L_temp_2.heapptr = &networkZstr_ROOT;
			    L_temp_2.dataword.l = 0;
			    /* type-error-with-location */
			    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_value, &dylanZdylan_visceraZCLS_raw_pointer_HEAP, L_temp_2);
			    not_reached();
			}
		    }
		    /* #line {Class <unknown-source-location>} */
		    L_index = (L_index - 2);
		}
		else {

		    /* #line 389 "./condition.dylan" */
		    L_temp_3.heapptr = &networkZstr_ROOT;
		    L_temp_3.dataword.l = 0;
		    /* type-error-with-location */
		    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp, &dylanZdylan_visceraZCLS_symbol_HEAP, L_temp_3);
		    not_reached();
		}
	    }
	}
      block0:;
	/* #line {Class <unknown-source-location>} */
	orig_sp = L_args;
	/* maker for <addrinfo> */
	L_result0 = networkZnetwork_internalZCLS_addrinfo_MAKER_FUN(orig_sp, L_pointer, L_pointer_suppliedQUERY);
	L_temp_4.heapptr = networkZliteral_71.heapptr;
	L_temp_4.dataword.ptr = L_result0;
	orig_sp[0] = L_temp_4;
	return orig_sp + 1;
    }
    else {
	/* odd-number-of-keyword/value-arguments-error */
	dylanZdylan_visceraZodd_number_of_keywordSLASHvalue_arguments_error_FUN(orig_sp);
	not_reached();
    }
}


/* Define Sealed Domain make (singleton(<addrinfo>)) */


/* {Implicit} Define Generic get-ai-flags */

/* get-ai-flags is get-ai-flags */


/* Define Method get-ai-flags{<addrinfo>} */

/* get-ai-flags{<addrinfo>} */
long networkZnetwork_internalZget_ai_flags_METH(descriptor_t *orig_sp, void * A_ptr /* ptr */, heapptr_t A1)
{
    descriptor_t *cluster_0_top;


    /* #line 198 "./melange.dylan" */

    /* #line 91 "./rawptr.dylan" */
    return (*(long *)((char *)A_ptr + 0 ));
}

/* generic-entry for get-ai-flags{<addrinfo>} */
descriptor_t * networkZnetwork_internalZget_ai_flags_METH_GENERIC(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    descriptor_t L_arg; /* arg */
    void * L_arg_2; /* arg */
    long L_result0; /* result0 */
    descriptor_t L_temp;

    /* #line {Class <unknown-source-location>} */
    L_args = ((void *)(orig_sp - 1));
    L_arg = (((descriptor_t *)L_args)[0]);
    L_arg_2 = L_arg.dataword.ptr;
    orig_sp = L_args;
    /* get-ai-flags{<addrinfo>} */
    L_result0 = networkZnetwork_internalZget_ai_flags_METH(orig_sp, L_arg_2, A_next_method_info);
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* {Implicit} Define Generic get-ai-flags-setter */

/* get-ai-flags-setter is get-ai-flags-setter */


/* Define Method get-ai-flags-setter{<integer>, <addrinfo>} */

/* get-ai-flags-setter{<integer>, <addrinfo>} */
long networkZnetwork_internalZget_ai_flags_setter_METH(descriptor_t *orig_sp, long A_value /* value */, void * A_ptr /* ptr */, heapptr_t A2)
{
    descriptor_t *cluster_0_top;


    /* #line 97 "./rawptr.dylan" */
    *(long *)((char *)A_ptr + 0) = A_value;
    return A_value;
}


/* {Implicit} Define Generic get-ai-family */

/* get-ai-family is get-ai-family */


/* Define Method get-ai-family{<addrinfo>} */

/* get-ai-family{<addrinfo>} */
long networkZnetwork_internalZget_ai_family_METH(descriptor_t *orig_sp, void * A_ptr /* ptr */, heapptr_t A1)
{
    descriptor_t *cluster_0_top;

    /* #line {Class <unknown-source-location>} */

    /* #line 198 "./melange.dylan" */

    /* #line 91 "./rawptr.dylan" */
    return (*(long *)((char *)A_ptr + 4 ));
}

/* generic-entry for get-ai-family{<addrinfo>} */
descriptor_t * networkZnetwork_internalZget_ai_family_METH_GENERIC(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    descriptor_t L_arg; /* arg */
    void * L_arg_2; /* arg */
    long L_result0; /* result0 */
    descriptor_t L_temp;

    /* #line {Class <unknown-source-location>} */
    L_args = ((void *)(orig_sp - 1));
    L_arg = (((descriptor_t *)L_args)[0]);
    L_arg_2 = L_arg.dataword.ptr;
    orig_sp = L_args;
    /* get-ai-family{<addrinfo>} */
    L_result0 = networkZnetwork_internalZget_ai_family_METH(orig_sp, L_arg_2, A_next_method_info);
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* {Implicit} Define Generic get-ai-family-setter */

/* get-ai-family-setter is get-ai-family-setter */


/* Define Method get-ai-family-setter{<integer>, <addrinfo>} */

/* get-ai-family-setter{<integer>, <addrinfo>} */
long networkZnetwork_internalZget_ai_family_setter_METH(descriptor_t *orig_sp, long A_value /* value */, void * A_ptr /* ptr */, heapptr_t A2)
{
    descriptor_t *cluster_0_top;


    /* #line 97 "./rawptr.dylan" */
    *(long *)((char *)A_ptr + 4) = A_value;
    return A_value;
}


/* {Implicit} Define Generic get-ai-socktype */

/* get-ai-socktype is get-ai-socktype */


/* Define Method get-ai-socktype{<addrinfo>} */

/* get-ai-socktype{<addrinfo>} */
long networkZnetwork_internalZget_ai_socktype_METH(descriptor_t *orig_sp, void * A_ptr /* ptr */, heapptr_t A1)
{
    descriptor_t *cluster_0_top;

    /* #line {Class <unknown-source-location>} */

    /* #line 198 "./melange.dylan" */

    /* #line 91 "./rawptr.dylan" */
    return (*(long *)((char *)A_ptr + 8 ));
}

/* generic-entry for get-ai-socktype{<addrinfo>} */
descriptor_t * networkZnetwork_internalZget_ai_socktype_METH_GENERIC(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    descriptor_t L_arg; /* arg */
    void * L_arg_2; /* arg */
    long L_result0; /* result0 */
    descriptor_t L_temp;

    /* #line {Class <unknown-source-location>} */
    L_args = ((void *)(orig_sp - 1));
    L_arg = (((descriptor_t *)L_args)[0]);
    L_arg_2 = L_arg.dataword.ptr;
    orig_sp = L_args;
    /* get-ai-socktype{<addrinfo>} */
    L_result0 = networkZnetwork_internalZget_ai_socktype_METH(orig_sp, L_arg_2, A_next_method_info);
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* {Implicit} Define Generic get-ai-socktype-setter */

/* get-ai-socktype-setter is get-ai-socktype-setter */


/* Define Method get-ai-socktype-setter{<integer>, <addrinfo>} */

/* get-ai-socktype-setter{<integer>, <addrinfo>} */
long networkZnetwork_internalZget_ai_socktype_setter_METH(descriptor_t *orig_sp, long A_value /* value */, void * A_ptr /* ptr */, heapptr_t A2)
{
    descriptor_t *cluster_0_top;


    /* #line 97 "./rawptr.dylan" */
    *(long *)((char *)A_ptr + 8) = A_value;
    return A_value;
}


/* {Implicit} Define Generic get-ai-protocol */

/* get-ai-protocol is get-ai-protocol */


/* Define Method get-ai-protocol{<addrinfo>} */

/* get-ai-protocol{<addrinfo>} */
long networkZnetwork_internalZget_ai_protocol_METH(descriptor_t *orig_sp, void * A_ptr /* ptr */, heapptr_t A1)
{
    descriptor_t *cluster_0_top;

    /* #line {Class <unknown-source-location>} */

    /* #line 198 "./melange.dylan" */

    /* #line 91 "./rawptr.dylan" */
    return (*(long *)((char *)A_ptr + 12 ));
}

/* generic-entry for get-ai-protocol{<addrinfo>} */
descriptor_t * networkZnetwork_internalZget_ai_protocol_METH_GENERIC(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    descriptor_t L_arg; /* arg */
    void * L_arg_2; /* arg */
    long L_result0; /* result0 */
    descriptor_t L_temp;

    /* #line {Class <unknown-source-location>} */
    L_args = ((void *)(orig_sp - 1));
    L_arg = (((descriptor_t *)L_args)[0]);
    L_arg_2 = L_arg.dataword.ptr;
    orig_sp = L_args;
    /* get-ai-protocol{<addrinfo>} */
    L_result0 = networkZnetwork_internalZget_ai_protocol_METH(orig_sp, L_arg_2, A_next_method_info);
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* {Implicit} Define Generic get-ai-protocol-setter */

/* get-ai-protocol-setter is get-ai-protocol-setter */


/* Define Method get-ai-protocol-setter{<integer>, <addrinfo>} */

/* get-ai-protocol-setter{<integer>, <addrinfo>} */
long networkZnetwork_internalZget_ai_protocol_setter_METH(descriptor_t *orig_sp, long A_value /* value */, void * A_ptr /* ptr */, heapptr_t A2)
{
    descriptor_t *cluster_0_top;


    /* #line 97 "./rawptr.dylan" */
    *(long *)((char *)A_ptr + 12) = A_value;
    return A_value;
}


/* {Implicit} Define Generic get-ai-addrlen */

/* get-ai-addrlen is get-ai-addrlen */


/* Define Method get-ai-addrlen{<addrinfo>} */

/* get-ai-addrlen{<addrinfo>} */
long networkZnetwork_internalZget_ai_addrlen_METH(descriptor_t *orig_sp, void * A_ptr /* ptr */, heapptr_t A1)
{
    descriptor_t *cluster_0_top;

    /* #line {Class <unknown-source-location>} */

    /* #line 211 "./melange.dylan" */

    /* #line 91 "./rawptr.dylan" */
    return (*(long *)((char *)A_ptr + 16 ));
}

/* generic-entry for get-ai-addrlen{<addrinfo>} */
descriptor_t * networkZnetwork_internalZget_ai_addrlen_METH_GENERIC(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    descriptor_t L_arg; /* arg */
    void * L_arg_2; /* arg */
    long L_result0; /* result0 */
    descriptor_t L_temp;

    /* #line {Class <unknown-source-location>} */
    L_args = ((void *)(orig_sp - 1));
    L_arg = (((descriptor_t *)L_args)[0]);
    L_arg_2 = L_arg.dataword.ptr;
    orig_sp = L_args;
    /* get-ai-addrlen{<addrinfo>} */
    L_result0 = networkZnetwork_internalZget_ai_addrlen_METH(orig_sp, L_arg_2, A_next_method_info);
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* {Implicit} Define Generic get-ai-addrlen-setter */

/* get-ai-addrlen-setter is get-ai-addrlen-setter */


/* Define Method get-ai-addrlen-setter{<integer>, <addrinfo>} */

/* get-ai-addrlen-setter{<integer>, <addrinfo>} */
long networkZnetwork_internalZget_ai_addrlen_setter_METH(descriptor_t *orig_sp, long A_value /* value */, void * A_ptr /* ptr */, heapptr_t A2)
{
    descriptor_t *cluster_0_top;


    /* #line 97 "./rawptr.dylan" */
    *(long *)((char *)A_ptr + 16) = A_value;
    return A_value;
}


/* {Implicit} Define Generic get-ai-addr */

/* get-ai-addr is get-ai-addr */


/* Define Method get-ai-addr{<addrinfo>} */

extern struct heapobj networkZstr_ROOT_125;

/* get-ai-addr{<addrinfo>} */
descriptor_t networkZnetwork_internalZget_ai_addr_METH(descriptor_t *orig_sp, void * A_ptr /* ptr */, heapptr_t A1)
{
    descriptor_t *cluster_0_top;
    descriptor_t L_temp;
    descriptor_t L_temp_2;
    descriptor_t L_temp_3; /* temp */
    int L_condition; /* condition */
    descriptor_t L_result; /* result */
    heapptr_t L_PCTobject_class; /* %object-class */
    int L_temp_4; /* temp */
    descriptor_t L_temp_5;
    descriptor_t L_temp_6;

    /* #line {Class <unknown-source-location>} */

    /* #line 290 "./melange.dylan" */

    /* #line 91 "./rawptr.dylan" */

    /* #line 290 "./melange.dylan" */
    L_temp.heapptr = &networkZnetwork_internalZCLS_sockaddr_HEAP;
    L_temp.dataword.l = 0;
    L_temp_2.heapptr = networkZliteral_6.heapptr;
    L_temp_2.dataword.ptr = (*(void * *)((char *)A_ptr + 20 ));
    orig_sp[0] = L_temp;
    orig_sp[1] = L_temp_2;
    /* as */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZas_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_temp_3 = orig_sp[0];

    /* #line 49 "./object.dylan" */

    /* #line 386 "./condition.dylan" */
    /* %subtype?{<class>, <class>} */
    L_condition = dylanZdylan_visceraZPCTsubtypeQUERY_METH(orig_sp, SLOT(L_temp_3.heapptr, heapptr_t, 0), &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP, &dylanZliteral_ROOT_2);
    if (L_condition) {

	/* #line 290 "./melange.dylan" */
	L_result = L_temp_3;

	/* #line 386 "./condition.dylan" */
	L_PCTobject_class = SLOT(L_result.heapptr, heapptr_t, 0);
	if ((&networkZnetwork_internalZCLS_sockaddr_in_HEAP == L_PCTobject_class)) {
	    L_temp_4 = TRUE;
	}
	else {
	    L_temp_4 = (&networkZnetwork_internalZCLS_sockaddr_HEAP == L_PCTobject_class);
	}
	if (L_temp_4) {

	    /* #line 3650 "./sockets-api.dylan" */
	    return L_result;
	}
	else {

	    /* #line 389 "./condition.dylan" */
	    L_temp_5.heapptr = &networkZstr_ROOT_125;
	    L_temp_5.dataword.l = 0;
	    /* type-error-with-location */
	    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_result, &networkZnetwork_internalZCLS_sockaddr_HEAP, L_temp_5);
	    not_reached();
	}
    }
    else {
	L_temp_6.heapptr = &networkZstr_ROOT_14;
	L_temp_6.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp_3, &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP, L_temp_6);
	not_reached();
    }
}

/* generic-entry for get-ai-addr{<addrinfo>} */
descriptor_t * networkZnetwork_internalZget_ai_addr_METH_GENERIC(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    descriptor_t L_arg; /* arg */
    void * L_arg_2; /* arg */
    descriptor_t L_result0; /* result0 */

    /* #line {Class <unknown-source-location>} */
    L_args = ((void *)(orig_sp - 1));
    L_arg = (((descriptor_t *)L_args)[0]);
    L_arg_2 = L_arg.dataword.ptr;
    orig_sp = L_args;
    /* get-ai-addr{<addrinfo>} */
    L_result0 = networkZnetwork_internalZget_ai_addr_METH(orig_sp, L_arg_2, A_next_method_info);
    orig_sp[0] = L_result0;
    return orig_sp + 1;
}


/* {Implicit} Define Generic get-ai-addr-setter */

/* get-ai-addr-setter is get-ai-addr-setter */


/* Define Method get-ai-addr-setter{<sockaddr>, <addrinfo>} */

/* get-ai-addr-setter{<sockaddr>, <addrinfo>} */
descriptor_t networkZnetwork_internalZget_ai_addr_setter_METH(descriptor_t *orig_sp, descriptor_t A_value /* value */, void * A_ptr /* ptr */, heapptr_t A2)
{
    descriptor_t *cluster_0_top;


    /* #line 299 "./melange.dylan" */
    /* #line {Class <unknown-source-location>} */

    /* #line 97 "./rawptr.dylan" */
    *(void * *)((char *)A_ptr + 20) = A_value.dataword.ptr;
    return A_value;
}


/* {Implicit} Define Generic get-ai-canonname */

/* get-ai-canonname is get-ai-canonname */


/* Define Method get-ai-canonname{<addrinfo>} */

extern struct heapobj networkZstr_ROOT_126;

/* get-ai-canonname{<addrinfo>} */
descriptor_t networkZnetwork_internalZget_ai_canonname_METH(descriptor_t *orig_sp, void * A_ptr /* ptr */, heapptr_t A1)
{
    descriptor_t *cluster_0_top;
    descriptor_t L_temp;
    descriptor_t L_temp_2;
    descriptor_t L_temp_3; /* temp */
    int L_condition; /* condition */
    descriptor_t L_result; /* result */
    heapptr_t L_PCTobject_class; /* %object-class */
    int L_temp_4; /* temp */
    descriptor_t L_temp_5;
    descriptor_t L_temp_6;

    /* #line {Class <unknown-source-location>} */

    /* #line 290 "./melange.dylan" */

    /* #line 91 "./rawptr.dylan" */

    /* #line 290 "./melange.dylan" */
    L_temp.heapptr = &networkZnetwork_internalZCLS_c_char_vector_HEAP;
    L_temp.dataword.l = 0;
    L_temp_2.heapptr = networkZliteral_6.heapptr;
    L_temp_2.dataword.ptr = (*(void * *)((char *)A_ptr + 24 ));
    orig_sp[0] = L_temp;
    orig_sp[1] = L_temp_2;
    /* as */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZas_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_temp_3 = orig_sp[0];

    /* #line 49 "./object.dylan" */

    /* #line 386 "./condition.dylan" */
    /* %subtype?{<class>, <class>} */
    L_condition = dylanZdylan_visceraZPCTsubtypeQUERY_METH(orig_sp, SLOT(L_temp_3.heapptr, heapptr_t, 0), &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP, &dylanZliteral_ROOT_2);
    if (L_condition) {

	/* #line 290 "./melange.dylan" */
	L_result = L_temp_3;

	/* #line 386 "./condition.dylan" */
	L_PCTobject_class = SLOT(L_result.heapptr, heapptr_t, 0);
	if ((&networkZnetwork_internalZCLS_charLESSX4040GREATER_HEAP == L_PCTobject_class)) {
	    L_temp_4 = TRUE;
	}
	else if ((&networkZnetwork_internalZCLS_charLESSX40120GREATER_HEAP == L_PCTobject_class)) {
	    L_temp_4 = TRUE;
	}
	else if ((&networkZnetwork_internalZCLS_charLESSX4014GREATER_HEAP == L_PCTobject_class)) {
	    L_temp_4 = TRUE;
	}
	else {
	    L_temp_4 = (&networkZnetwork_internalZCLS_c_char_vector_HEAP == L_PCTobject_class);
	}
	if (L_temp_4) {

	    /* #line 3661 "./sockets-api.dylan" */
	    return L_result;
	}
	else {

	    /* #line 389 "./condition.dylan" */
	    L_temp_5.heapptr = &networkZstr_ROOT_126;
	    L_temp_5.dataword.l = 0;
	    /* type-error-with-location */
	    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_result, &networkZnetwork_internalZCLS_c_char_vector_HEAP, L_temp_5);
	    not_reached();
	}
    }
    else {
	L_temp_6.heapptr = &networkZstr_ROOT_14;
	L_temp_6.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp_3, &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP, L_temp_6);
	not_reached();
    }
}

/* generic-entry for get-ai-canonname{<addrinfo>} */
descriptor_t * networkZnetwork_internalZget_ai_canonname_METH_GENERIC(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    descriptor_t L_arg; /* arg */
    void * L_arg_2; /* arg */
    descriptor_t L_result0; /* result0 */

    /* #line {Class <unknown-source-location>} */
    L_args = ((void *)(orig_sp - 1));
    L_arg = (((descriptor_t *)L_args)[0]);
    L_arg_2 = L_arg.dataword.ptr;
    orig_sp = L_args;
    /* get-ai-canonname{<addrinfo>} */
    L_result0 = networkZnetwork_internalZget_ai_canonname_METH(orig_sp, L_arg_2, A_next_method_info);
    orig_sp[0] = L_result0;
    return orig_sp + 1;
}


/* {Implicit} Define Generic get-ai-canonname-setter */

/* get-ai-canonname-setter is get-ai-canonname-setter */


/* Define Method get-ai-canonname-setter{<c-char-vector>, <addrinfo>} */

/* get-ai-canonname-setter{<c-char-vector>, <addrinfo>} */
descriptor_t networkZnetwork_internalZget_ai_canonname_setter_METH(descriptor_t *orig_sp, descriptor_t A_value /* value */, void * A_ptr /* ptr */, heapptr_t A2)
{
    descriptor_t *cluster_0_top;


    /* #line 299 "./melange.dylan" */
    /* #line {Class <unknown-source-location>} */

    /* #line 97 "./rawptr.dylan" */
    *(void * *)((char *)A_ptr + 24) = A_value.dataword.ptr;
    return A_value;
}


/* {Implicit} Define Generic get-ai-next */

/* get-ai-next is get-ai-next */


/* Define Method get-ai-next{<addrinfo>} */

extern struct heapobj networkZstr_ROOT_127;

/* get-ai-next{<addrinfo>} */
void * networkZnetwork_internalZget_ai_next_METH(descriptor_t *orig_sp, void * A_ptr /* ptr */, heapptr_t A1)
{
    descriptor_t *cluster_0_top;
    descriptor_t L_temp;
    descriptor_t L_temp_2;
    descriptor_t L_temp_3; /* temp */
    int L_condition; /* condition */
    descriptor_t L_result; /* result */
    descriptor_t L_temp_4;
    descriptor_t L_temp_5;

    /* #line {Class <unknown-source-location>} */

    /* #line 290 "./melange.dylan" */

    /* #line 91 "./rawptr.dylan" */

    /* #line 290 "./melange.dylan" */
    L_temp.heapptr = &networkZnetwork_internalZCLS_addrinfo_HEAP;
    L_temp.dataword.l = 0;
    L_temp_2.heapptr = networkZliteral_6.heapptr;
    L_temp_2.dataword.ptr = (*(void * *)((char *)A_ptr + 28 ));
    orig_sp[0] = L_temp;
    orig_sp[1] = L_temp_2;
    /* as */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZas_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_temp_3 = orig_sp[0];

    /* #line 49 "./object.dylan" */

    /* #line 386 "./condition.dylan" */
    /* %subtype?{<class>, <class>} */
    L_condition = dylanZdylan_visceraZPCTsubtypeQUERY_METH(orig_sp, SLOT(L_temp_3.heapptr, heapptr_t, 0), &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP, &dylanZliteral_ROOT_2);
    if (L_condition) {

	/* #line 290 "./melange.dylan" */
	L_result = L_temp_3;

	/* #line 386 "./condition.dylan" */
	if ((&networkZnetwork_internalZCLS_addrinfo_HEAP == SLOT(L_result.heapptr, heapptr_t, 0))) {

	    /* #line 3672 "./sockets-api.dylan" */
	    return L_result.dataword.ptr;
	}
	else {

	    /* #line 389 "./condition.dylan" */
	    L_temp_4.heapptr = &networkZstr_ROOT_127;
	    L_temp_4.dataword.l = 0;
	    /* type-error-with-location */
	    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_result, &networkZnetwork_internalZCLS_addrinfo_HEAP, L_temp_4);
	    not_reached();
	}
    }
    else {
	L_temp_5.heapptr = &networkZstr_ROOT_14;
	L_temp_5.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp_3, &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP, L_temp_5);
	not_reached();
    }
}

/* generic-entry for get-ai-next{<addrinfo>} */
descriptor_t * networkZnetwork_internalZget_ai_next_METH_GENERIC(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    descriptor_t L_arg; /* arg */
    void * L_arg_2; /* arg */
    void * L_result0; /* result0 */
    descriptor_t L_temp;

    /* #line {Class <unknown-source-location>} */
    L_args = ((void *)(orig_sp - 1));
    L_arg = (((descriptor_t *)L_args)[0]);
    L_arg_2 = L_arg.dataword.ptr;
    orig_sp = L_args;
    /* get-ai-next{<addrinfo>} */
    L_result0 = networkZnetwork_internalZget_ai_next_METH(orig_sp, L_arg_2, A_next_method_info);
    L_temp.heapptr = networkZliteral_71.heapptr;
    L_temp.dataword.ptr = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* {Implicit} Define Generic get-ai-next-setter */

/* get-ai-next-setter is get-ai-next-setter */


/* Define Method get-ai-next-setter{<addrinfo>, <addrinfo>} */

/* get-ai-next-setter{<addrinfo>, <addrinfo>} */
void * networkZnetwork_internalZget_ai_next_setter_METH(descriptor_t *orig_sp, void * A_value /* value */, void * A_ptr /* ptr */, heapptr_t A2)
{
    descriptor_t *cluster_0_top;


    /* #line 299 "./melange.dylan" */
    /* #line {Class <unknown-source-location>} */

    /* #line 97 "./rawptr.dylan" */
    *(void * *)((char *)A_ptr + 28) = A_value;
    return A_value;
}


/* Define Method pointer-value{<addrinfo>} */

extern struct heapobj networkZstr_ROOT_128;

/* pointer-value{<addrinfo>} */
void * networkZnetwork_internalZpointer_value_METH_56(descriptor_t *orig_sp, void * A_value /* value */, heapptr_t A_next_method_info /* next-method-info */, heapptr_t A_rest /* rest */, descriptor_t A_index /* index */)
{
    descriptor_t *cluster_0_top;
    descriptor_t L_temp;
    descriptor_t L_arg1; /* arg1 */
    descriptor_t L_temp_2;
    descriptor_t L_temp_3; /* temp */
    descriptor_t L_temp_4;

    /* #line {Class <unknown-source-location>} */

    /* #line 3682 "./sockets-api.dylan" */
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = 32;
    orig_sp[0] = A_index;
    orig_sp[1] = L_temp;
    /* * */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZV_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_arg1 = (orig_sp == cluster_0_top ? dylanZfalse : orig_sp[0]);

    /* #line 3682 "./sockets-api.dylan" */
    L_temp_2.heapptr = networkZliteral_71.heapptr;
    L_temp_2.dataword.ptr = A_value;
    orig_sp[0] = L_temp_2;
    orig_sp[1] = L_arg1;
    /* + */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZPLUS_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_temp_3 = (orig_sp == cluster_0_top ? dylanZfalse : orig_sp[0]);

    /* #line 386 "./condition.dylan" */
    if ((&networkZnetwork_internalZCLS_addrinfo_HEAP == SLOT(L_temp_3.heapptr, heapptr_t, 0))) {

	/* #line 3682 "./sockets-api.dylan" */
	return L_temp_3.dataword.ptr;
    }
    else {

	/* #line 389 "./condition.dylan" */
	L_temp_4.heapptr = &networkZstr_ROOT_128;
	L_temp_4.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp_3, &networkZnetwork_internalZCLS_addrinfo_HEAP, L_temp_4);
	not_reached();
    }
}

/* generic-entry for pointer-value{<addrinfo>} */
descriptor_t * networkZnetwork_internalZpointer_value_METH_GENERIC_56(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    descriptor_t L_arg; /* arg */
    heapptr_t L_rest; /* rest */
    void * L_arg_2; /* arg */
    descriptor_t L_index; /* index */
    long L_index_2; /* index */
    descriptor_t L_key; /* key */
    descriptor_t L_value; /* value */
    void * L_result0; /* result0 */
    descriptor_t L_temp;

    /* #line {Class <unknown-source-location>} */
    L_args = ((void *)(orig_sp - A_nargs));
    L_arg = (((descriptor_t *)L_args)[0]);
    L_rest = dylanZdylan_visceraZmake_rest_arg_FUN(orig_sp, (descriptor_t *)L_args + 1, A_nargs - 1);
    L_arg_2 = L_arg.dataword.ptr;
    L_index.heapptr = networkZliteral_2.heapptr;
    L_index.dataword.l = 0;
    L_index_2 = (A_nargs - 2);
    while (1) {
	if ((L_index_2 < 1)) {
	    goto block0;
	}
	else {
	    L_key = (((descriptor_t *)L_args)[L_index_2]);
	    L_value = (((descriptor_t *)L_args)[(L_index_2 + 1)]);
	    if ((L_key.heapptr == &SYM_index_HEAP)) {
		L_index = L_value;
	    }
	    L_index_2 = (L_index_2 - 2);
	}
    }
  block0:;
    orig_sp = L_args;
    /* pointer-value{<addrinfo>} */
    L_result0 = networkZnetwork_internalZpointer_value_METH_56(orig_sp, L_arg_2, A_next_method_info, L_rest, L_index);
    L_temp.heapptr = networkZliteral_71.heapptr;
    L_temp.dataword.ptr = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* Define Method content-size{subclass(<addrinfo>)} */

/* content-size{subclass(<addrinfo>)} */
long networkZnetwork_internalZcontent_size_METH_69(descriptor_t *orig_sp, heapptr_t A0, heapptr_t A1)
{

    return 32;
}

/* generic-entry for content-size{subclass(<addrinfo>)} */
descriptor_t * networkZnetwork_internalZcontent_size_METH_GENERIC_69(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    long L_result0; /* result0 */
    descriptor_t L_temp;

    orig_sp = ((void *)(orig_sp - 1));
    /* content-size{subclass(<addrinfo>)} */
    L_result0 = networkZnetwork_internalZcontent_size_METH_69(orig_sp, &networkZnetwork_internalZCLS_addrinfo_HEAP, A_next_method_info);
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* Define Class <addrinfo*> */

/* <addrinfo*> is <addrinfo*> */

extern struct heapobj networkZnetwork_internalZCLS_addrinfoV_HEAP;

/* maker for <addrinfo*> */
void * networkZnetwork_internalZCLS_addrinfoV_MAKER_FUN(descriptor_t *orig_sp, void * A_pointer /* pointer */, int A_pointer_suppliedQUERY /* pointer-supplied? */)
{
    descriptor_t *cluster_0_top;


    /* #line 3689 "./sockets-api.dylan" */
    if (A_pointer_suppliedQUERY) {
	return A_pointer;
    }
    else {
	/* missing-required-init-keyword-error */
	dylanZdylan_visceraZmissing_required_init_keyword_error_FUN(orig_sp, &SYM_pointer_HEAP, &networkZnetwork_internalZCLS_addrinfoV_HEAP);
	not_reached();
    }
}

extern descriptor_t networkZliteral_72;	/* proxy for <addrinfo*> */

/* general-entry for maker for <addrinfo*> */
descriptor_t * networkZnetwork_internalZCLS_addrinfoV_MAKER_GENERAL(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    void * L_pointer; /* pointer */
    int L_pointer_suppliedQUERY; /* pointer-supplied? */
    long L_index; /* index */
    descriptor_t L_temp; /* temp */
    descriptor_t L_value; /* value */
    descriptor_t L_temp_2;
    descriptor_t L_temp_3;
    void * L_result0; /* result0 */
    descriptor_t L_temp_4;

    /* #line {Class <unknown-source-location>} */

    /* #line 126 "./cmp.dylan" */

    /* #line 209 "./num.dylan" */
    if (((A_nargs & 1) == 0)) {
	/* #line {Class <unknown-source-location>} */
	L_args = ((void *)(orig_sp - A_nargs));
	L_pointer = 0;
	L_pointer_suppliedQUERY = FALSE;
	L_index = (A_nargs - 2);
	while (1) {
	    if ((L_index < 0)) {
		goto block0;
	    }
	    else {
		L_temp = (((descriptor_t *)L_args)[L_index]);

		/* #line 386 "./condition.dylan" */
		if ((&dylanZdylan_visceraZCLS_symbol_HEAP == SLOT(L_temp.heapptr, heapptr_t, 0))) {
		    /* #line {Class <unknown-source-location>} */
		    L_value = (((descriptor_t *)L_args)[(L_index + 1)]);
		    if ((L_temp.heapptr == &SYM_pointer_HEAP)) {

			/* #line 386 "./condition.dylan" */
			if ((&dylanZdylan_visceraZCLS_raw_pointer_HEAP == SLOT(L_value.heapptr, heapptr_t, 0))) {
			    /* #line {Class <unknown-source-location>} */
			    L_pointer = L_value.dataword.ptr;
			    L_pointer_suppliedQUERY = TRUE;
			}
			else {

			    /* #line 389 "./condition.dylan" */
			    L_temp_2.heapptr = &networkZstr_ROOT;
			    L_temp_2.dataword.l = 0;
			    /* type-error-with-location */
			    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_value, &dylanZdylan_visceraZCLS_raw_pointer_HEAP, L_temp_2);
			    not_reached();
			}
		    }
		    /* #line {Class <unknown-source-location>} */
		    L_index = (L_index - 2);
		}
		else {

		    /* #line 389 "./condition.dylan" */
		    L_temp_3.heapptr = &networkZstr_ROOT;
		    L_temp_3.dataword.l = 0;
		    /* type-error-with-location */
		    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp, &dylanZdylan_visceraZCLS_symbol_HEAP, L_temp_3);
		    not_reached();
		}
	    }
	}
      block0:;
	/* #line {Class <unknown-source-location>} */
	orig_sp = L_args;
	/* maker for <addrinfo*> */
	L_result0 = networkZnetwork_internalZCLS_addrinfoV_MAKER_FUN(orig_sp, L_pointer, L_pointer_suppliedQUERY);
	L_temp_4.heapptr = networkZliteral_72.heapptr;
	L_temp_4.dataword.ptr = L_result0;
	orig_sp[0] = L_temp_4;
	return orig_sp + 1;
    }
    else {
	/* odd-number-of-keyword/value-arguments-error */
	dylanZdylan_visceraZodd_number_of_keywordSLASHvalue_arguments_error_FUN(orig_sp);
	not_reached();
    }
}


/* Define Sealed Domain make (singleton(<addrinfo*>)) */


/* Define Method pointer-value{<addrinfo*>} */

extern struct heapobj networkZstr_ROOT_129;

/* pointer-value{<addrinfo*>} */
void * networkZnetwork_internalZpointer_value_METH_57(descriptor_t *orig_sp, void * A_ptr /* ptr */, heapptr_t A_next_method_info /* next-method-info */, heapptr_t A_rest /* rest */, descriptor_t A_index /* index */)
{
    descriptor_t *cluster_0_top;
    descriptor_t L_temp;
    descriptor_t L_arg2; /* arg2 */
    descriptor_t L_temp_2;
    descriptor_t L_temp_3;
    descriptor_t L_temp_4; /* temp */
    int L_condition; /* condition */
    descriptor_t L_result; /* result */
    descriptor_t L_temp_5;
    descriptor_t L_temp_6;
    descriptor_t L_temp_7;


    /* #line 3696 "./sockets-api.dylan" */
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = 4;
    orig_sp[0] = A_index;
    orig_sp[1] = L_temp;
    /* * */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZV_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_arg2 = (orig_sp == cluster_0_top ? dylanZfalse : orig_sp[0]);

    /* #line 386 "./condition.dylan" */
    if ((&dylanZdylan_visceraZCLS_integer_HEAP == SLOT(L_arg2.heapptr, heapptr_t, 0))) {

	/* #line 3696 "./sockets-api.dylan" */

	/* #line 290 "./melange.dylan" */

	/* #line 91 "./rawptr.dylan" */

	/* #line 290 "./melange.dylan" */
	L_temp_2.heapptr = &networkZnetwork_internalZCLS_addrinfo_HEAP;
	L_temp_2.dataword.l = 0;
	L_temp_3.heapptr = networkZliteral_6.heapptr;
	L_temp_3.dataword.ptr = (*(void * *)((char *)A_ptr + L_arg2.dataword.l ));
	orig_sp[0] = L_temp_2;
	orig_sp[1] = L_temp_3;
	/* as */
	{
	  struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZas_HEAP, 2);
	  heapptr_t L_meth = L_temp.R0;
	  heapptr_t L_next_info = L_temp.R1;
	  cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
	}
	L_temp_4 = orig_sp[0];

	/* #line 49 "./object.dylan" */

	/* #line 386 "./condition.dylan" */
	/* %subtype?{<class>, <class>} */
	L_condition = dylanZdylan_visceraZPCTsubtypeQUERY_METH(orig_sp, SLOT(L_temp_4.heapptr, heapptr_t, 0), &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP, &dylanZliteral_ROOT_2);
	if (L_condition) {

	    /* #line 290 "./melange.dylan" */
	    L_result = L_temp_4;

	    /* #line 386 "./condition.dylan" */
	    if ((&networkZnetwork_internalZCLS_addrinfo_HEAP == SLOT(L_result.heapptr, heapptr_t, 0))) {

		/* #line 3696 "./sockets-api.dylan" */
		return L_result.dataword.ptr;
	    }
	    else {

		/* #line 389 "./condition.dylan" */
		L_temp_5.heapptr = &networkZstr_ROOT_129;
		L_temp_5.dataword.l = 0;
		/* type-error-with-location */
		dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_result, &networkZnetwork_internalZCLS_addrinfo_HEAP, L_temp_5);
		not_reached();
	    }
	}
	else {
	    L_temp_6.heapptr = &networkZstr_ROOT_14;
	    L_temp_6.dataword.l = 0;
	    /* type-error-with-location */
	    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp_4, &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP, L_temp_6);
	    not_reached();
	}
    }
    else {
	L_temp_7.heapptr = &networkZstr_ROOT_129;
	L_temp_7.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_arg2, &dylanZdylan_visceraZCLS_integer_HEAP, L_temp_7);
	not_reached();
    }
}

/* generic-entry for pointer-value{<addrinfo*>} */
descriptor_t * networkZnetwork_internalZpointer_value_METH_GENERIC_57(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    descriptor_t L_arg; /* arg */
    heapptr_t L_rest; /* rest */
    void * L_arg_2; /* arg */
    descriptor_t L_index; /* index */
    long L_index_2; /* index */
    descriptor_t L_key; /* key */
    descriptor_t L_value; /* value */
    void * L_result0; /* result0 */
    descriptor_t L_temp;

    /* #line {Class <unknown-source-location>} */
    L_args = ((void *)(orig_sp - A_nargs));
    L_arg = (((descriptor_t *)L_args)[0]);
    L_rest = dylanZdylan_visceraZmake_rest_arg_FUN(orig_sp, (descriptor_t *)L_args + 1, A_nargs - 1);
    L_arg_2 = L_arg.dataword.ptr;
    L_index.heapptr = networkZliteral_2.heapptr;
    L_index.dataword.l = 0;
    L_index_2 = (A_nargs - 2);
    while (1) {
	if ((L_index_2 < 1)) {
	    goto block0;
	}
	else {
	    L_key = (((descriptor_t *)L_args)[L_index_2]);
	    L_value = (((descriptor_t *)L_args)[(L_index_2 + 1)]);
	    if ((L_key.heapptr == &SYM_index_HEAP)) {
		L_index = L_value;
	    }
	    L_index_2 = (L_index_2 - 2);
	}
    }
  block0:;
    orig_sp = L_args;
    /* pointer-value{<addrinfo*>} */
    L_result0 = networkZnetwork_internalZpointer_value_METH_57(orig_sp, L_arg_2, A_next_method_info, L_rest, L_index);
    L_temp.heapptr = networkZliteral_71.heapptr;
    L_temp.dataword.ptr = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* Define Method pointer-value-setter{<addrinfo>, <addrinfo*>} */

/* pointer-value-setter{<addrinfo>, <addrinfo*>} */
void * networkZnetwork_internalZpointer_value_setter_METH_17(descriptor_t *orig_sp, void * A_value /* value */, void * A_ptr /* ptr */, heapptr_t A_next_method_info /* next-method-info */, heapptr_t A_rest /* rest */, descriptor_t A_index /* index */)
{
    descriptor_t *cluster_0_top;
    descriptor_t L_temp;
    descriptor_t L_arg3; /* arg3 */
    descriptor_t L_temp_2;


    /* #line 3702 "./sockets-api.dylan" */
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = 4;
    orig_sp[0] = A_index;
    orig_sp[1] = L_temp;
    /* * */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZV_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_arg3 = (orig_sp == cluster_0_top ? dylanZfalse : orig_sp[0]);

    /* #line 386 "./condition.dylan" */
    if ((&dylanZdylan_visceraZCLS_integer_HEAP == SLOT(L_arg3.heapptr, heapptr_t, 0))) {
	/* #line {Class <unknown-source-location>} */

	/* #line 299 "./melange.dylan" */
	/* #line {Class <unknown-source-location>} */

	/* #line 97 "./rawptr.dylan" */
	*(void * *)((char *)A_ptr + L_arg3.dataword.l) = A_value;
	return A_value;
    }
    else {

	/* #line 389 "./condition.dylan" */
	L_temp_2.heapptr = &networkZstr_ROOT;
	L_temp_2.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_arg3, &dylanZdylan_visceraZCLS_integer_HEAP, L_temp_2);
	not_reached();
    }
}

/* generic-entry for pointer-value-setter{<addrinfo>, <addrinfo*>} */
descriptor_t * networkZnetwork_internalZpointer_value_setter_METH_GENERIC_17(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    descriptor_t L_arg; /* arg */
    descriptor_t L_arg_2; /* arg */
    heapptr_t L_rest; /* rest */
    void * L_arg_3; /* arg */
    void * L_arg_4; /* arg */
    descriptor_t L_index; /* index */
    long L_index_2; /* index */
    descriptor_t L_key; /* key */
    descriptor_t L_value; /* value */
    void * L_result0; /* result0 */
    descriptor_t L_temp;

    /* #line {Class <unknown-source-location>} */
    L_args = ((void *)(orig_sp - A_nargs));
    L_arg = (((descriptor_t *)L_args)[0]);
    L_arg_2 = (((descriptor_t *)L_args)[1]);
    L_rest = dylanZdylan_visceraZmake_rest_arg_FUN(orig_sp, (descriptor_t *)L_args + 2, A_nargs - 2);
    L_arg_3 = L_arg.dataword.ptr;
    L_arg_4 = L_arg_2.dataword.ptr;
    L_index.heapptr = networkZliteral_2.heapptr;
    L_index.dataword.l = 0;
    L_index_2 = (A_nargs - 2);
    while (1) {
	if ((L_index_2 < 2)) {
	    goto block0;
	}
	else {
	    L_key = (((descriptor_t *)L_args)[L_index_2]);
	    L_value = (((descriptor_t *)L_args)[(L_index_2 + 1)]);
	    if ((L_key.heapptr == &SYM_index_HEAP)) {
		L_index = L_value;
	    }
	    L_index_2 = (L_index_2 - 2);
	}
    }
  block0:;
    orig_sp = L_args;
    /* pointer-value-setter{<addrinfo>, <addrinfo*>} */
    L_result0 = networkZnetwork_internalZpointer_value_setter_METH_17(orig_sp, L_arg_3, L_arg_4, A_next_method_info, L_rest, L_index);
    L_temp.heapptr = networkZliteral_71.heapptr;
    L_temp.dataword.ptr = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* Define Method content-size{subclass(<addrinfo*>)} */

/* content-size{subclass(<addrinfo*>)} */
long networkZnetwork_internalZcontent_size_METH_70(descriptor_t *orig_sp, heapptr_t A0, heapptr_t A1)
{

    return 4;
}

/* generic-entry for content-size{subclass(<addrinfo*>)} */
descriptor_t * networkZnetwork_internalZcontent_size_METH_GENERIC_70(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    long L_result0; /* result0 */
    descriptor_t L_temp;

    orig_sp = ((void *)(orig_sp - 1));
    /* content-size{subclass(<addrinfo*>)} */
    L_result0 = networkZnetwork_internalZcontent_size_METH_70(orig_sp, &networkZnetwork_internalZCLS_addrinfoV_HEAP, A_next_method_info);
    L_temp.heapptr = networkZliteral_2.heapptr;
    L_temp.dataword.l = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* {Implicit} Define Generic getaddrinfo */

/* getaddrinfo is getaddrinfo */


/* Define Method getaddrinfo{<byte-string>, <byte-string>, <addrinfo>} */

extern struct heapobj melange_supportZmelange_supportZpointer_value_HEAP;

extern void melange_supportZmelange_supportZdestroy_METH(descriptor_t *orig_sp, descriptor_t A0, heapptr_t A1);	/* destroy{<statically-typed-pointer>} */

extern struct heapobj dylanZempty_list_ROOT;

struct mv_result_1 {
    long R0;
    void * R1;
};

extern struct heapobj networkZstr_ROOT_130;

extern struct heapobj networkZstr_ROOT_131;

extern struct heapobj networkZstr_ROOT_132;

/* getaddrinfo{<byte-string>, <byte-string>, <addrinfo>} */
struct mv_result_1 networkZnetwork_internalZgetaddrinfo_METH(descriptor_t *orig_sp, heapptr_t A_arg1 /* arg1 */, heapptr_t A_arg2 /* arg2 */, void * A_arg3 /* arg3 */, heapptr_t A3)
{
    descriptor_t *cluster_0_top;
    heapptr_t L_instance; /* instance */
    descriptor_t L_arg4_ptr; /* arg4-ptr */
    descriptor_t L_temp;
    descriptor_t L_temp_2;
    descriptor_t L_argument; /* argument */
    int L_condition; /* condition */
    descriptor_t L_temp_3;
    descriptor_t L_temp_4;
    void * L_raw_value; /* raw-value */
    descriptor_t L_argument_2; /* argument */
    int L_condition_2; /* condition */
    long L_result_value; /* result-value */
    descriptor_t L_arg4_value; /* arg4-value */
    struct mv_result_1 L_temp_5;
    descriptor_t L_temp_6;
    descriptor_t L_temp_7;
    descriptor_t L_temp_8;


    /* #line 3713 "./sockets-api.dylan" */
    /* maker for <simple-object-vector> */
    L_instance = dylanZdylan_visceraZCLS_simple_object_vector_MAKER_FUN(orig_sp, 0, dylanZfalse);
    /* make{subclass(<statically-typed-pointer>)} */
    L_arg4_ptr = melange_supportZmelange_supportZmake_METH(orig_sp, &networkZnetwork_internalZCLS_addrinfoV_HEAP, &networkZliteral_ROOT, L_instance, 0, dylanZfalse, 1);

    /* #line 3715 "./sockets-api.dylan" */
    L_temp.heapptr = &melange_supportZmelange_supportZCLS_c_string_HEAP;
    L_temp.dataword.l = 0;
    L_temp_2.heapptr = A_arg1;
    L_temp_2.dataword.l = 0;
    orig_sp[0] = L_temp;
    orig_sp[1] = L_temp_2;
    /* export-value */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &melange_supportZmelange_supportZexport_value_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_argument = orig_sp[0];

    /* #line 49 "./object.dylan" */

    /* #line 386 "./condition.dylan" */
    /* %subtype?{<class>, <class>} */
    L_condition = dylanZdylan_visceraZPCTsubtypeQUERY_METH(orig_sp, SLOT(L_argument.heapptr, heapptr_t, 0), &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP, &dylanZliteral_ROOT_2);
    if (L_condition) {

	/* #line 3715 "./sockets-api.dylan" */

	/* #line 3715 "./sockets-api.dylan" */
	L_temp_3.heapptr = &melange_supportZmelange_supportZCLS_c_string_HEAP;
	L_temp_3.dataword.l = 0;
	L_temp_4.heapptr = A_arg2;
	L_temp_4.dataword.l = 0;
	orig_sp[0] = L_temp_3;
	orig_sp[1] = L_temp_4;
	L_raw_value = L_argument.dataword.ptr;
	/* export-value */
	{
	  struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &melange_supportZmelange_supportZexport_value_HEAP, 2);
	  heapptr_t L_meth = L_temp.R0;
	  heapptr_t L_next_info = L_temp.R1;
	  cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
	}
	L_argument_2 = orig_sp[0];

	/* #line 49 "./object.dylan" */

	/* #line 386 "./condition.dylan" */
	/* %subtype?{<class>, <class>} */
	L_condition_2 = dylanZdylan_visceraZPCTsubtypeQUERY_METH(orig_sp, SLOT(L_argument_2.heapptr, heapptr_t, 0), &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP, &dylanZliteral_ROOT_2);
	if (L_condition_2) {

	    /* #line 3715 "./sockets-api.dylan" */

	    /* #line 3715 "./sockets-api.dylan" */

	    /* #line 3715 "./sockets-api.dylan" */

	    /* #line 735 "./macros.dylan" */
	    L_result_value = getaddrinfo(L_raw_value, L_argument_2.dataword.ptr, A_arg3, L_arg4_ptr.dataword.ptr);

	    /* #line 3716 "./sockets-api.dylan" */
	    orig_sp[0] = L_arg4_ptr;
	    /* pointer-value */
	    {
	      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 1, &melange_supportZmelange_supportZpointer_value_HEAP, 1);
	      heapptr_t L_meth = L_temp.R0;
	      heapptr_t L_next_info = L_temp.R1;
	      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 1, L_meth, 1, L_next_info);
	    }
	    L_arg4_value = (orig_sp == cluster_0_top ? dylanZfalse : orig_sp[0]);

	    /* #line 3717 "./sockets-api.dylan" */
	    /* destroy{<statically-typed-pointer>} */
	    melange_supportZmelange_supportZdestroy_METH(orig_sp, L_arg4_ptr, &dylanZempty_list_ROOT);

	    /* #line 386 "./condition.dylan" */
	    if ((&networkZnetwork_internalZCLS_addrinfo_HEAP == SLOT(L_arg4_value.heapptr, heapptr_t, 0))) {

		/* #line 3718 "./sockets-api.dylan" */
		L_temp_5.R0 = L_result_value;
		L_temp_5.R1 = L_arg4_value.dataword.ptr;
		return L_temp_5;
	    }
	    else {

		/* #line 389 "./condition.dylan" */
		L_temp_6.heapptr = &networkZstr_ROOT_130;
		L_temp_6.dataword.l = 0;
		/* type-error-with-location */
		dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_arg4_value, &networkZnetwork_internalZCLS_addrinfo_HEAP, L_temp_6);
		not_reached();
	    }
	}
	else {
	    L_temp_7.heapptr = &networkZstr_ROOT_131;
	    L_temp_7.dataword.l = 0;
	    /* type-error-with-location */
	    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_argument_2, &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP, L_temp_7);
	    not_reached();
	}
    }
    else {
	L_temp_8.heapptr = &networkZstr_ROOT_132;
	L_temp_8.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_argument, &melange_supportZmelange_supportZCLS_statically_typed_pointer_HEAP, L_temp_8);
	not_reached();
    }
}

/* generic-entry for getaddrinfo{<byte-string>, <byte-string>, <addrinfo>} */
descriptor_t * networkZnetwork_internalZgetaddrinfo_METH_GENERIC(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    descriptor_t L_arg; /* arg */
    descriptor_t L_arg_2; /* arg */
    descriptor_t L_arg_3; /* arg */
    heapptr_t L_arg_4; /* arg */
    heapptr_t L_arg_5; /* arg */
    void * L_arg_6; /* arg */
    struct mv_result_1 L_temp;
    long L_result0; /* result0 */
    void * L_result1; /* result1 */
    descriptor_t L_temp_2;
    descriptor_t L_temp_3;

    /* #line {Class <unknown-source-location>} */
    L_args = ((void *)(orig_sp - 3));
    L_arg = (((descriptor_t *)L_args)[0]);
    L_arg_2 = (((descriptor_t *)L_args)[1]);
    L_arg_3 = (((descriptor_t *)L_args)[2]);
    L_arg_4 = L_arg.heapptr;
    L_arg_5 = L_arg_2.heapptr;
    L_arg_6 = L_arg_3.dataword.ptr;
    orig_sp = L_args;
    /* getaddrinfo{<byte-string>, <byte-string>, <addrinfo>} */
    L_temp = networkZnetwork_internalZgetaddrinfo_METH(orig_sp, L_arg_4, L_arg_5, L_arg_6, A_next_method_info);
    L_result0 = L_temp.R0;
    L_result1 = L_temp.R1;
    L_temp_2.heapptr = networkZliteral_2.heapptr;
    L_temp_2.dataword.l = L_result0;
    orig_sp[0] = L_temp_2;
    L_temp_3.heapptr = networkZliteral_71.heapptr;
    L_temp_3.dataword.ptr = L_result1;
    orig_sp[1] = L_temp_3;
    return orig_sp + 2;
}


/* {Implicit} Define Generic freeaddrinfo */

/* freeaddrinfo is freeaddrinfo */


/* Define Method freeaddrinfo{<addrinfo>} */

/* freeaddrinfo{<addrinfo>} */
void networkZnetwork_internalZfreeaddrinfo_METH(descriptor_t *orig_sp, void * A_arg1 /* arg1 */, heapptr_t A1)
{
    descriptor_t *cluster_0_top;


    /* #line 3724 "./sockets-api.dylan" */

    /* #line 735 "./macros.dylan" */
    freeaddrinfo(A_arg1);
    return;
}

/* generic-entry for freeaddrinfo{<addrinfo>} */
descriptor_t * networkZnetwork_internalZfreeaddrinfo_METH_GENERIC(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    descriptor_t L_arg; /* arg */
    void * L_arg_2; /* arg */

    /* #line {Class <unknown-source-location>} */
    L_args = ((void *)(orig_sp - 1));
    L_arg = (((descriptor_t *)L_args)[0]);
    L_arg_2 = L_arg.dataword.ptr;
    orig_sp = L_args;
    /* freeaddrinfo{<addrinfo>} */
    networkZnetwork_internalZfreeaddrinfo_METH(orig_sp, L_arg_2, A_next_method_info);
    return orig_sp + 0;
}


/* {Implicit} Define Generic gai-strerror */

/* gai-strerror is gai-strerror */


/* Define Method gai-strerror{<integer>} */

extern struct heapobj dylanZdylan_visceraZCLS_byte_string_HEAP;

extern struct heapobj melange_supportZmelange_supportZimport_value_HEAP;

extern struct heapobj networkZstr_ROOT_133;

/* gai-strerror{<integer>} */
heapptr_t networkZnetwork_internalZgai_strerror_METH(descriptor_t *orig_sp, long A_arg1 /* arg1 */, heapptr_t A1)
{
    descriptor_t *cluster_0_top;
    void * L_result_value; /* result-value */
    heapptr_t L_instance; /* instance */
    descriptor_t L_temp;
    descriptor_t L_temp_2;
    descriptor_t L_temp_3;
    descriptor_t L_result_value_2; /* result-value */
    descriptor_t L_temp_4;
    descriptor_t L_arg0; /* arg0 */
    descriptor_t L_temp_5;


    /* #line 735 "./macros.dylan" */
    L_result_value = gai_strerror(A_arg1);

    /* #line 3733 "./sockets-api.dylan" */
    /* maker for <simple-object-vector> */
    L_instance = dylanZdylan_visceraZCLS_simple_object_vector_MAKER_FUN(orig_sp, 2, dylanZfalse);
    L_temp.heapptr = &SYM_pointer_HEAP;
    L_temp.dataword.l = 0;
    SLOT(L_instance, descriptor_t, 8 + 0 * sizeof(descriptor_t)) = L_temp;
    L_temp_2.heapptr = networkZliteral_6.heapptr;
    L_temp_2.dataword.ptr = L_result_value;
    SLOT(L_instance, descriptor_t, 8 + 1 * sizeof(descriptor_t)) = L_temp_2;
    L_temp_3.heapptr = networkZliteral_6.heapptr;
    L_temp_3.dataword.ptr = L_result_value;
    /* make{subclass(<statically-typed-pointer>)} */
    L_result_value_2 = melange_supportZmelange_supportZmake_METH(orig_sp, &networkZnetwork_internalZCLS_c_char_vector_HEAP, &networkZliteral_ROOT, L_instance, 0, L_temp_3, 1);

    /* #line 3734 "./sockets-api.dylan" */
    L_temp_4.heapptr = &dylanZdylan_visceraZCLS_byte_string_HEAP;
    L_temp_4.dataword.l = 0;
    orig_sp[0] = L_temp_4;
    orig_sp[1] = L_result_value_2;
    /* import-value */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &melange_supportZmelange_supportZimport_value_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_arg0 = orig_sp[0];

    /* #line 386 "./condition.dylan" */
    if ((&dylanZdylan_visceraZCLS_byte_string_HEAP == SLOT(L_arg0.heapptr, heapptr_t, 0))) {

	/* #line 3734 "./sockets-api.dylan" */
	return L_arg0.heapptr;
    }
    else {

	/* #line 389 "./condition.dylan" */
	L_temp_5.heapptr = &networkZstr_ROOT_133;
	L_temp_5.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_arg0, &dylanZdylan_visceraZCLS_byte_string_HEAP, L_temp_5);
	not_reached();
    }
}

/* generic-entry for gai-strerror{<integer>} */
descriptor_t * networkZnetwork_internalZgai_strerror_METH_GENERIC(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    descriptor_t L_arg; /* arg */
    long L_arg_2; /* arg */
    heapptr_t L_result0; /* result0 */
    descriptor_t L_temp;

    /* #line {Class <unknown-source-location>} */
    L_args = ((void *)(orig_sp - 1));
    L_arg = (((descriptor_t *)L_args)[0]);
    L_arg_2 = L_arg.dataword.l;
    orig_sp = L_args;
    /* gai-strerror{<integer>} */
    L_result0 = networkZnetwork_internalZgai_strerror_METH(orig_sp, L_arg_2, A_next_method_info);
    L_temp.heapptr = L_result0;
    L_temp.dataword.l = 0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* {Implicit} Define Generic getnameinfo */

/* getnameinfo is getnameinfo */


/* Define Method getnameinfo{<sockaddr>, <integer>, <c-char-vector>, <integer>, <c-char-vector>, <integer>, <integer>} */

/* getnameinfo{<sockaddr>, <integer>, <c-char-vector>, <integer>, <c-char-vector>, <integer>, <integer>} */
long networkZnetwork_internalZgetnameinfo_METH(descriptor_t *orig_sp, descriptor_t A_arg1 /* arg1 */, long A_arg2 /* arg2 */, descriptor_t A_arg3 /* arg3 */, long A_arg4 /* arg4 */, descriptor_t A_arg5 /* arg5 */, long A_arg6 /* arg6 */, long A_arg7 /* arg7 */, heapptr_t A7)
{
    descriptor_t *cluster_0_top;
    long L_result_value; /* result-value */


    /* #line 3741 "./sockets-api.dylan" */

    /* #line 3741 "./sockets-api.dylan" */

    /* #line 3741 "./sockets-api.dylan" */

    /* #line 735 "./macros.dylan" */
    L_result_value = getnameinfo(A_arg1.dataword.ptr, A_arg2, A_arg3.dataword.ptr, A_arg4, A_arg5.dataword.ptr, A_arg6, A_arg7);
    return L_result_value;
}


/* Define Constant $_NETDB-H */

/* $_NETDB-H is 1 */


/* Define Constant $_PATH-HEQUIV */

/* $_PATH-HEQUIV allocated as networkZnetwork_internalZCX_path_hequiv */


/* Define Constant $_PATH-HOSTS */

/* $_PATH-HOSTS allocated as networkZnetwork_internalZCX_path_hosts */


/* Define Constant $_PATH-NETWORKS */

/* $_PATH-NETWORKS allocated as networkZnetwork_internalZCX_path_networks */


/* Define Constant $_PATH-NSSWITCH-CONF */

/* $_PATH-NSSWITCH-CONF allocated as networkZnetwork_internalZCX_path_nsswitch_conf */


/* Define Constant $_PATH-PROTOCOLS */

/* $_PATH-PROTOCOLS allocated as networkZnetwork_internalZCX_path_protocols */


/* Define Constant $_PATH-SERVICES */

/* $_PATH-SERVICES allocated as networkZnetwork_internalZCX_path_services */


/* Define Constant $NETDB-INTERNAL */

/* $NETDB-INTERNAL is -1 */


/* Define Constant $NETDB-SUCCESS */

/* $NETDB-SUCCESS is 0 */


/* Define Constant $HOST-NOT-FOUND */

/* $HOST-NOT-FOUND is 1 */


/* Define Constant $TRY-AGAIN */

/* $TRY-AGAIN is 2 */


/* Define Constant $NO-RECOVERY */

/* $NO-RECOVERY is 3 */


/* Define Constant $NO-DATA */

/* $NO-DATA is 4 */


/* Define Constant $NO-ADDRESS */

/* $NO-ADDRESS is 4 */


/* Define Constant $AI-PASSIVE */

/* $AI-PASSIVE is 1 */


/* Define Constant $AI-CANONNAME */

/* $AI-CANONNAME is 2 */


/* Define Constant $AI-NUMERICHOST */

/* $AI-NUMERICHOST is 4 */


/* Define Constant $EAI-BADFLAGS */

/* $EAI-BADFLAGS is -1 */


/* Define Constant $EAI-NONAME */

/* $EAI-NONAME is -2 */


/* Define Constant $EAI-AGAIN */

/* $EAI-AGAIN is -3 */


/* Define Constant $EAI-FAIL */

/* $EAI-FAIL is -4 */


/* Define Constant $EAI-NODATA */

/* $EAI-NODATA is -5 */


/* Define Constant $EAI-FAMILY */

/* $EAI-F