#include <stddef.h>

#include <stdlib.h>

#define GD_HAVE_LONG_LONG
#include "runtime.h"

#include <math.h>

extern descriptor_t dylanZtrue;	/* #t */

#define obj_True dylanZtrue.heapptr
extern descriptor_t dylanZfalse;	/* #f */

#define obj_False dylanZfalse.heapptr

#define GENERAL_ENTRY(func) \
    ((entry_t)SLOT(func, void *, 8))
#define GENERIC_ENTRY(func) \
    ((entry_t)SLOT(func, void *, 32))

#define GD_CTASSERT(name, x) \
    typedef char gd_assert_ ## name[(x) ? 1 : -1];
#define GD_VERIFY_SIZE_ASSUMPTION(name, type, size)\
    GD_CTASSERT(size_ ## name, sizeof(type) == (size))
#define GD_VERIFY_ALIGN_ASSUMPTION(name, type, align)\
    typedef struct { char c; type x; } \
      gd_align_ ## name; \
    GD_CTASSERT(align_ ## name, offsetof(gd_align_ ## name, x) == (align))

GD_VERIFY_SIZE_ASSUMPTION(general, descriptor_t, 8);
GD_VERIFY_ALIGN_ASSUMPTION(general, descriptor_t, 4);
GD_VERIFY_SIZE_ASSUMPTION(heap, heapptr_t, 4);
GD_VERIFY_ALIGN_ASSUMPTION(heap, heapptr_t, 4);
GD_VERIFY_SIZE_ASSUMPTION(boolean, int, 4);
GD_VERIFY_ALIGN_ASSUMPTION(boolean, int, 4);
GD_VERIFY_SIZE_ASSUMPTION(long_long, long long, 8);
GD_VERIFY_ALIGN_ASSUMPTION(long_long, long long, 4);
GD_VERIFY_SIZE_ASSUMPTION(long, long, 4);
GD_VERIFY_ALIGN_ASSUMPTION(long, long, 4);
GD_VERIFY_SIZE_ASSUMPTION(int, int, 4);
GD_VERIFY_ALIGN_ASSUMPTION(int, int, 4);
GD_VERIFY_SIZE_ASSUMPTION(uint, unsigned int, 4);
GD_VERIFY_ALIGN_ASSUMPTION(uint, unsigned int, 4);
GD_VERIFY_SIZE_ASSUMPTION(short, short, 2);
GD_VERIFY_ALIGN_ASSUMPTION(short, short, 2);
GD_VERIFY_SIZE_ASSUMPTION(ushort, unsigned short, 2);
GD_VERIFY_ALIGN_ASSUMPTION(ushort, unsigned short, 2);
GD_VERIFY_SIZE_ASSUMPTION(float, float, 4);
GD_VERIFY_ALIGN_ASSUMPTION(float, float, 4);
GD_VERIFY_SIZE_ASSUMPTION(double, double, 8);
GD_VERIFY_ALIGN_ASSUMPTION(double, double, 4);
GD_VERIFY_SIZE_ASSUMPTION(long_double, long double, 12);
GD_VERIFY_ALIGN_ASSUMPTION(long_double, long double, 4);
GD_VERIFY_SIZE_ASSUMPTION(ptr, void *, 4);
GD_VERIFY_ALIGN_ASSUMPTION(ptr, void *, 4);

/* Top level form. */

#include "/usr/include/sys/time.h"

/* form at {<known-source-location> 0x08b9eb18,
   source: {<source-file> 0x0891d840, name: "macros.dylan"},
   start-line: 743,
   start-column: 54,
   end-line: 743,
   end-column: 64} */
void network_testZLINE_743(descriptor_t *orig_sp)
{
    descriptor_t *cluster_0_top;


    /* #line 743 "./macros.dylan" */
    return;
}


/* Define Class <timezone> */

/* <timezone> is <timezone> */

extern void dylanZdylan_visceraZmissing_required_init_keyword_error_FUN(descriptor_t *orig_sp, heapptr_t A0, heapptr_t A1);	/* missing-required-init-keyword-error */

extern struct heapobj SYM_pointer_HEAP;

extern struct heapobj network_testZnetwork_testZCLS_timezone_HEAP;

/* maker for <timezone> */
void * network_testZnetwork_testZCLS_timezone_MAKER_FUN(descriptor_t *orig_sp, void * A_pointer /* pointer */, int A_pointer_suppliedQUERY /* pointer-supplied? */)
{
    descriptor_t *cluster_0_top;


    /* #line 5 "./gettimeofday.dylan" */
    if (A_pointer_suppliedQUERY) {
	return A_pointer;
    }
    else {
	/* missing-required-init-keyword-error */
	dylanZdylan_visceraZmissing_required_init_keyword_error_FUN(orig_sp, &SYM_pointer_HEAP, &network_testZnetwork_testZCLS_timezone_HEAP);
	not_reached();
    }
}

extern struct heapobj dylanZdylan_visceraZCLS_symbol_HEAP;

extern struct heapobj dylanZdylan_visceraZCLS_raw_pointer_HEAP;

extern void dylanZdylan_visceraZtype_error_with_location_FUN(descriptor_t *orig_sp, descriptor_t A0, heapptr_t A1, descriptor_t A2);	/* type-error-with-location */

extern struct heapobj network_testZstr_ROOT;

extern descriptor_t network_testZliteral;	/* proxy for <timezone> */

extern void dylanZdylan_visceraZodd_number_of_keywordSLASHvalue_arguments_error_FUN(descriptor_t *orig_sp);	/* odd-number-of-keyword/value-arguments-error */

/* general-entry for maker for <timezone> */
descriptor_t * network_testZnetwork_testZCLS_timezone_MAKER_GENERAL(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    void * L_pointer; /* pointer */
    int L_pointer_suppliedQUERY; /* pointer-supplied? */
    long L_index; /* index */
    descriptor_t L_temp; /* temp */
    descriptor_t L_value; /* value */
    descriptor_t L_temp_2;
    descriptor_t L_temp_3;
    void * L_result0; /* result0 */
    descriptor_t L_temp_4;

    /* #line {Class <unknown-source-location>} */

    /* #line 126 "./cmp.dylan" */

    /* #line 209 "./num.dylan" */
    if (((A_nargs & 1) == 0)) {
	/* #line {Class <unknown-source-location>} */
	L_args = ((void *)(orig_sp - A_nargs));
	L_pointer = 0;
	L_pointer_suppliedQUERY = FALSE;
	L_index = (A_nargs - 2);
	while (1) {
	    if ((L_index < 0)) {
		goto block0;
	    }
	    else {
		L_temp = (((descriptor_t *)L_args)[L_index]);

		/* #line 386 "./condition.dylan" */
		if ((&dylanZdylan_visceraZCLS_symbol_HEAP == SLOT(L_temp.heapptr, heapptr_t, 0))) {
		    /* #line {Class <unknown-source-location>} */
		    L_value = (((descriptor_t *)L_args)[(L_index + 1)]);
		    if ((L_temp.heapptr == &SYM_pointer_HEAP)) {

			/* #line 386 "./condition.dylan" */
			if ((&dylanZdylan_visceraZCLS_raw_pointer_HEAP == SLOT(L_value.heapptr, heapptr_t, 0))) {
			    /* #line {Class <unknown-source-location>} */
			    L_pointer = L_value.dataword.ptr;
			    L_pointer_suppliedQUERY = TRUE;
			}
			else {

			    /* #line 389 "./condition.dylan" */
			    L_temp_2.heapptr = &network_testZstr_ROOT;
			    L_temp_2.dataword.l = 0;
			    /* type-error-with-location */
			    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_value, &dylanZdylan_visceraZCLS_raw_pointer_HEAP, L_temp_2);
			    not_reached();
			}
		    }
		    /* #line {Class <unknown-source-location>} */
		    L_index = (L_index - 2);
		}
		else {

		    /* #line 389 "./condition.dylan" */
		    L_temp_3.heapptr = &network_testZstr_ROOT;
		    L_temp_3.dataword.l = 0;
		    /* type-error-with-location */
		    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp, &dylanZdylan_visceraZCLS_symbol_HEAP, L_temp_3);
		    not_reached();
		}
	    }
	}
      block0:;
	/* #line {Class <unknown-source-location>} */
	orig_sp = L_args;
	/* maker for <timezone> */
	L_result0 = network_testZnetwork_testZCLS_timezone_MAKER_FUN(orig_sp, L_pointer, L_pointer_suppliedQUERY);
	L_temp_4.heapptr = network_testZliteral.heapptr;
	L_temp_4.dataword.ptr = L_result0;
	orig_sp[0] = L_temp_4;
	return orig_sp + 1;
    }
    else {
	/* odd-number-of-keyword/value-arguments-error */
	dylanZdylan_visceraZodd_number_of_keywordSLASHvalue_arguments_error_FUN(orig_sp);
	not_reached();
    }
}


/* Define Sealed Domain make (singleton(<timezone>)) */


/* {Implicit} Define Generic get-tz-minuteswest */

/* get-tz-minuteswest is get-tz-minuteswest */


/* Define Method get-tz-minuteswest{<timezone>} */

/* get-tz-minuteswest{<timezone>} */
long network_testZnetwork_testZget_tz_minuteswest_METH(descriptor_t *orig_sp, void * A_ptr /* ptr */, heapptr_t A1)
{
    descriptor_t *cluster_0_top;


    /* #line 198 "./melange.dylan" */

    /* #line 91 "./rawptr.dylan" */
    return (*(long *)((char *)A_ptr + 0 ));
}


/* {Implicit} Define Generic get-tz-minuteswest-setter */

/* get-tz-minuteswest-setter is get-tz-minuteswest-setter */


/* Define Method get-tz-minuteswest-setter{<integer>, <timezone>} */

/* get-tz-minuteswest-setter{<integer>, <timezone>} */
long network_testZnetwork_testZget_tz_minuteswest_setter_METH(descriptor_t *orig_sp, long A_value /* value */, void * A_ptr /* ptr */, heapptr_t A2)
{
    descriptor_t *cluster_0_top;

    /* #line {Class <unknown-source-location>} */

    /* #line 97 "./rawptr.dylan" */
    *(long *)((char *)A_ptr + 0) = A_value;
    return A_value;
}


/* {Implicit} Define Generic get-tz-dsttime */

/* get-tz-dsttime is get-tz-dsttime */


/* Define Method get-tz-dsttime{<timezone>} */

/* get-tz-dsttime{<timezone>} */
long network_testZnetwork_testZget_tz_dsttime_METH(descriptor_t *orig_sp, void * A_ptr /* ptr */, heapptr_t A1)
{
    descriptor_t *cluster_0_top;

    /* #line {Class <unknown-source-location>} */

    /* #line 198 "./melange.dylan" */

    /* #line 91 "./rawptr.dylan" */
    return (*(long *)((char *)A_ptr + 4 ));
}


/* {Implicit} Define Generic get-tz-dsttime-setter */

/* get-tz-dsttime-setter is get-tz-dsttime-setter */


/* Define Method get-tz-dsttime-setter{<integer>, <timezone>} */

/* get-tz-dsttime-setter{<integer>, <timezone>} */
long network_testZnetwork_testZget_tz_dsttime_setter_METH(descriptor_t *orig_sp, long A_value /* value */, void * A_ptr /* ptr */, heapptr_t A2)
{
    descriptor_t *cluster_0_top;

    /* #line {Class <unknown-source-location>} */

    /* #line 97 "./rawptr.dylan" */
    *(long *)((char *)A_ptr + 4) = A_value;
    return A_value;
}


/* Define Method pointer-value{<timezone>} */

extern descriptor_t network_testZliteral_2;	/* proxy for <integer> */

extern descriptor_t * dylanZdylan_visceraZgf_call_FUN(descriptor_t *orig_sp, heapptr_t A0, long A1);	/* gf-call */

extern struct heapobj dylanZdylan_visceraZV_HEAP;

struct mv_result_0 {
    heapptr_t R0;
    heapptr_t R1;
};

extern struct mv_result_0 dylanZdylan_visceraZgf_call_lookup_FUN(descriptor_t *orig_sp, heapptr_t A0, long A1);	/* gf-call-lookup */

extern struct heapobj dylanZdylan_visceraZPLUS_HEAP;

extern struct heapobj network_testZstr_ROOT_2;

/* pointer-value{<timezone>} */
void * network_testZnetwork_testZpointer_value_METH(descriptor_t *orig_sp, void * A_value /* value */, heapptr_t A_next_method_info /* next-method-info */, heapptr_t A_rest /* rest */, descriptor_t A_index /* index */)
{
    descriptor_t *cluster_0_top;
    descriptor_t L_temp;
    descriptor_t L_arg1; /* arg1 */
    descriptor_t L_temp_2;
    descriptor_t L_temp_3; /* temp */
    descriptor_t L_temp_4;

    /* #line {Class <unknown-source-location>} */

    /* #line 32 "./gettimeofday.dylan" */
    L_temp.heapptr = network_testZliteral_2.heapptr;
    L_temp.dataword.l = 8;
    orig_sp[0] = A_index;
    orig_sp[1] = L_temp;
    /* * */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZV_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_arg1 = (orig_sp == cluster_0_top ? dylanZfalse : orig_sp[0]);

    /* #line 32 "./gettimeofday.dylan" */
    L_temp_2.heapptr = network_testZliteral.heapptr;
    L_temp_2.dataword.ptr = A_value;
    orig_sp[0] = L_temp_2;
    orig_sp[1] = L_arg1;
    /* + */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZPLUS_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_temp_3 = (orig_sp == cluster_0_top ? dylanZfalse : orig_sp[0]);

    /* #line 386 "./condition.dylan" */
    if ((&network_testZnetwork_testZCLS_timezone_HEAP == SLOT(L_temp_3.heapptr, heapptr_t, 0))) {

	/* #line 32 "./gettimeofday.dylan" */
	return L_temp_3.dataword.ptr;
    }
    else {

	/* #line 389 "./condition.dylan" */
	L_temp_4.heapptr = &network_testZstr_ROOT_2;
	L_temp_4.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp_3, &network_testZnetwork_testZCLS_timezone_HEAP, L_temp_4);
	not_reached();
    }
}

extern heapptr_t dylanZdylan_visceraZmake_rest_arg_FUN(descriptor_t *orig_sp, void * A0, long A1);	/* make-rest-arg */

extern struct heapobj SYM_index_HEAP;

/* generic-entry for pointer-value{<timezone>} */
descriptor_t * network_testZnetwork_testZpointer_value_METH_GENERIC(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    descriptor_t L_arg; /* arg */
    heapptr_t L_rest; /* rest */
    void * L_arg_2; /* arg */
    descriptor_t L_index; /* index */
    long L_index_2; /* index */
    descriptor_t L_key; /* key */
    descriptor_t L_value; /* value */
    void * L_result0; /* result0 */
    descriptor_t L_temp;

    /* #line {Class <unknown-source-location>} */
    L_args = ((void *)(orig_sp - A_nargs));
    L_arg = (((descriptor_t *)L_args)[0]);
    L_rest = dylanZdylan_visceraZmake_rest_arg_FUN(orig_sp, (descriptor_t *)L_args + 1, A_nargs - 1);
    L_arg_2 = L_arg.dataword.ptr;
    L_index.heapptr = network_testZliteral_2.heapptr;
    L_index.dataword.l = 0;
    L_index_2 = (A_nargs - 2);
    while (1) {
	if ((L_index_2 < 1)) {
	    goto block0;
	}
	else {
	    L_key = (((descriptor_t *)L_args)[L_index_2]);
	    L_value = (((descriptor_t *)L_args)[(L_index_2 + 1)]);
	    if ((L_key.heapptr == &SYM_index_HEAP)) {
		L_index = L_value;
	    }
	    L_index_2 = (L_index_2 - 2);
	}
    }
  block0:;
    orig_sp = L_args;
    /* pointer-value{<timezone>} */
    L_result0 = network_testZnetwork_testZpointer_value_METH(orig_sp, L_arg_2, A_next_method_info, L_rest, L_index);
    L_temp.heapptr = network_testZliteral.heapptr;
    L_temp.dataword.ptr = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* Define Method content-size{subclass(<timezone>)} */

/* content-size{subclass(<timezone>)} */
long network_testZnetwork_testZcontent_size_METH(descriptor_t *orig_sp, heapptr_t A0, heapptr_t A1)
{

    return 8;
}

/* generic-entry for content-size{subclass(<timezone>)} */
descriptor_t * network_testZnetwork_testZcontent_size_METH_GENERIC(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    long L_result0; /* result0 */
    descriptor_t L_temp;

    orig_sp = ((void *)(orig_sp - 1));
    /* content-size{subclass(<timezone>)} */
    L_result0 = network_testZnetwork_testZcontent_size_METH(orig_sp, &network_testZnetwork_testZCLS_timezone_HEAP, A_next_method_info);
    L_temp.heapptr = network_testZliteral_2.heapptr;
    L_temp.dataword.l = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* Define Constant <__time-t> */

/* <__time-t> is <integer> */


/* Define Constant <__suseconds-t> */

/* <__suseconds-t> is <integer> */


/* Define Class <timeval> */

/* <timeval> is <timeval> */

extern struct heapobj network_testZnetwork_testZCLS_timeval_HEAP;

/* maker for <timeval> */
void * network_testZnetwork_testZCLS_timeval_MAKER_FUN(descriptor_t *orig_sp, void * A_pointer /* pointer */, int A_pointer_suppliedQUERY /* pointer-supplied? */)
{
    descriptor_t *cluster_0_top;


    /* #line 43 "./gettimeofday.dylan" */
    if (A_pointer_suppliedQUERY) {
	return A_pointer;
    }
    else {
	/* missing-required-init-keyword-error */
	dylanZdylan_visceraZmissing_required_init_keyword_error_FUN(orig_sp, &SYM_pointer_HEAP, &network_testZnetwork_testZCLS_timeval_HEAP);
	not_reached();
    }
}

extern descriptor_t network_testZliteral_3;	/* proxy for <timeval> */

/* general-entry for maker for <timeval> */
descriptor_t * network_testZnetwork_testZCLS_timeval_MAKER_GENERAL(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    void * L_pointer; /* pointer */
    int L_pointer_suppliedQUERY; /* pointer-supplied? */
    long L_index; /* index */
    descriptor_t L_temp; /* temp */
    descriptor_t L_value; /* value */
    descriptor_t L_temp_2;
    descriptor_t L_temp_3;
    void * L_result0; /* result0 */
    descriptor_t L_temp_4;

    /* #line {Class <unknown-source-location>} */

    /* #line 126 "./cmp.dylan" */

    /* #line 209 "./num.dylan" */
    if (((A_nargs & 1) == 0)) {
	/* #line {Class <unknown-source-location>} */
	L_args = ((void *)(orig_sp - A_nargs));
	L_pointer = 0;
	L_pointer_suppliedQUERY = FALSE;
	L_index = (A_nargs - 2);
	while (1) {
	    if ((L_index < 0)) {
		goto block0;
	    }
	    else {
		L_temp = (((descriptor_t *)L_args)[L_index]);

		/* #line 386 "./condition.dylan" */
		if ((&dylanZdylan_visceraZCLS_symbol_HEAP == SLOT(L_temp.heapptr, heapptr_t, 0))) {
		    /* #line {Class <unknown-source-location>} */
		    L_value = (((descriptor_t *)L_args)[(L_index + 1)]);
		    if ((L_temp.heapptr == &SYM_pointer_HEAP)) {

			/* #line 386 "./condition.dylan" */
			if ((&dylanZdylan_visceraZCLS_raw_pointer_HEAP == SLOT(L_value.heapptr, heapptr_t, 0))) {
			    /* #line {Class <unknown-source-location>} */
			    L_pointer = L_value.dataword.ptr;
			    L_pointer_suppliedQUERY = TRUE;
			}
			else {

			    /* #line 389 "./condition.dylan" */
			    L_temp_2.heapptr = &network_testZstr_ROOT;
			    L_temp_2.dataword.l = 0;
			    /* type-error-with-location */
			    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_value, &dylanZdylan_visceraZCLS_raw_pointer_HEAP, L_temp_2);
			    not_reached();
			}
		    }
		    /* #line {Class <unknown-source-location>} */
		    L_index = (L_index - 2);
		}
		else {

		    /* #line 389 "./condition.dylan" */
		    L_temp_3.heapptr = &network_testZstr_ROOT;
		    L_temp_3.dataword.l = 0;
		    /* type-error-with-location */
		    dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp, &dylanZdylan_visceraZCLS_symbol_HEAP, L_temp_3);
		    not_reached();
		}
	    }
	}
      block0:;
	/* #line {Class <unknown-source-location>} */
	orig_sp = L_args;
	/* maker for <timeval> */
	L_result0 = network_testZnetwork_testZCLS_timeval_MAKER_FUN(orig_sp, L_pointer, L_pointer_suppliedQUERY);
	L_temp_4.heapptr = network_testZliteral_3.heapptr;
	L_temp_4.dataword.ptr = L_result0;
	orig_sp[0] = L_temp_4;
	return orig_sp + 1;
    }
    else {
	/* odd-number-of-keyword/value-arguments-error */
	dylanZdylan_visceraZodd_number_of_keywordSLASHvalue_arguments_error_FUN(orig_sp);
	not_reached();
    }
}


/* Define Sealed Domain make (singleton(<timeval>)) */


/* {Implicit} Define Generic get-tv-sec */

/* get-tv-sec is get-tv-sec */


/* Define Method get-tv-sec{<timeval>} */

/* get-tv-sec{<timeval>} */
long network_testZnetwork_testZget_tv_sec_METH(descriptor_t *orig_sp, void * A_ptr /* ptr */, heapptr_t A1)
{
    descriptor_t *cluster_0_top;


    /* #line 198 "./melange.dylan" */

    /* #line 91 "./rawptr.dylan" */
    return (*(long *)((char *)A_ptr + 0 ));
}


/* {Implicit} Define Generic get-tv-sec-setter */

/* get-tv-sec-setter is get-tv-sec-setter */


/* Define Method get-tv-sec-setter{<integer>, <timeval>} */

/* get-tv-sec-setter{<integer>, <timeval>} */
long network_testZnetwork_testZget_tv_sec_setter_METH(descriptor_t *orig_sp, long A_value /* value */, void * A_ptr /* ptr */, heapptr_t A2)
{
    descriptor_t *cluster_0_top;

    /* #line {Class <unknown-source-location>} */

    /* #line 97 "./rawptr.dylan" */
    *(long *)((char *)A_ptr + 0) = A_value;
    return A_value;
}


/* {Implicit} Define Generic get-tv-usec */

/* get-tv-usec is get-tv-usec */


/* Define Method get-tv-usec{<timeval>} */

/* get-tv-usec{<timeval>} */
long network_testZnetwork_testZget_tv_usec_METH(descriptor_t *orig_sp, void * A_ptr /* ptr */, heapptr_t A1)
{
    descriptor_t *cluster_0_top;

    /* #line {Class <unknown-source-location>} */

    /* #line 198 "./melange.dylan" */

    /* #line 91 "./rawptr.dylan" */
    return (*(long *)((char *)A_ptr + 4 ));
}


/* {Implicit} Define Generic get-tv-usec-setter */

/* get-tv-usec-setter is get-tv-usec-setter */


/* Define Method get-tv-usec-setter{<integer>, <timeval>} */

/* get-tv-usec-setter{<integer>, <timeval>} */
long network_testZnetwork_testZget_tv_usec_setter_METH(descriptor_t *orig_sp, long A_value /* value */, void * A_ptr /* ptr */, heapptr_t A2)
{
    descriptor_t *cluster_0_top;

    /* #line {Class <unknown-source-location>} */

    /* #line 97 "./rawptr.dylan" */
    *(long *)((char *)A_ptr + 4) = A_value;
    return A_value;
}


/* Define Method pointer-value{<timeval>} */

extern struct heapobj network_testZstr_ROOT_3;

/* pointer-value{<timeval>} */
void * network_testZnetwork_testZpointer_value_METH_2(descriptor_t *orig_sp, void * A_value /* value */, heapptr_t A_next_method_info /* next-method-info */, heapptr_t A_rest /* rest */, descriptor_t A_index /* index */)
{
    descriptor_t *cluster_0_top;
    descriptor_t L_temp;
    descriptor_t L_arg1; /* arg1 */
    descriptor_t L_temp_2;
    descriptor_t L_temp_3; /* temp */
    descriptor_t L_temp_4;

    /* #line {Class <unknown-source-location>} */

    /* #line 70 "./gettimeofday.dylan" */
    L_temp.heapptr = network_testZliteral_2.heapptr;
    L_temp.dataword.l = 8;
    orig_sp[0] = A_index;
    orig_sp[1] = L_temp;
    /* * */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZV_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_arg1 = (orig_sp == cluster_0_top ? dylanZfalse : orig_sp[0]);

    /* #line 70 "./gettimeofday.dylan" */
    L_temp_2.heapptr = network_testZliteral_3.heapptr;
    L_temp_2.dataword.ptr = A_value;
    orig_sp[0] = L_temp_2;
    orig_sp[1] = L_arg1;
    /* + */
    {
      struct mv_result_0 L_temp = dylanZdylan_visceraZgf_call_lookup_FUN(orig_sp + 2, &dylanZdylan_visceraZPLUS_HEAP, 2);
      heapptr_t L_meth = L_temp.R0;
      heapptr_t L_next_info = L_temp.R1;
      cluster_0_top = GENERIC_ENTRY(L_meth)(orig_sp + 2, L_meth, 2, L_next_info);
    }
    L_temp_3 = (orig_sp == cluster_0_top ? dylanZfalse : orig_sp[0]);

    /* #line 386 "./condition.dylan" */
    if ((&network_testZnetwork_testZCLS_timeval_HEAP == SLOT(L_temp_3.heapptr, heapptr_t, 0))) {

	/* #line 70 "./gettimeofday.dylan" */
	return L_temp_3.dataword.ptr;
    }
    else {

	/* #line 389 "./condition.dylan" */
	L_temp_4.heapptr = &network_testZstr_ROOT_3;
	L_temp_4.dataword.l = 0;
	/* type-error-with-location */
	dylanZdylan_visceraZtype_error_with_location_FUN(orig_sp, L_temp_3, &network_testZnetwork_testZCLS_timeval_HEAP, L_temp_4);
	not_reached();
    }
}

/* generic-entry for pointer-value{<timeval>} */
descriptor_t * network_testZnetwork_testZpointer_value_METH_GENERIC_2(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    void * L_args; /* args */
    descriptor_t L_arg; /* arg */
    heapptr_t L_rest; /* rest */
    void * L_arg_2; /* arg */
    descriptor_t L_index; /* index */
    long L_index_2; /* index */
    descriptor_t L_key; /* key */
    descriptor_t L_value; /* value */
    void * L_result0; /* result0 */
    descriptor_t L_temp;

    /* #line {Class <unknown-source-location>} */
    L_args = ((void *)(orig_sp - A_nargs));
    L_arg = (((descriptor_t *)L_args)[0]);
    L_rest = dylanZdylan_visceraZmake_rest_arg_FUN(orig_sp, (descriptor_t *)L_args + 1, A_nargs - 1);
    L_arg_2 = L_arg.dataword.ptr;
    L_index.heapptr = network_testZliteral_2.heapptr;
    L_index.dataword.l = 0;
    L_index_2 = (A_nargs - 2);
    while (1) {
	if ((L_index_2 < 1)) {
	    goto block0;
	}
	else {
	    L_key = (((descriptor_t *)L_args)[L_index_2]);
	    L_value = (((descriptor_t *)L_args)[(L_index_2 + 1)]);
	    if ((L_key.heapptr == &SYM_index_HEAP)) {
		L_index = L_value;
	    }
	    L_index_2 = (L_index_2 - 2);
	}
    }
  block0:;
    orig_sp = L_args;
    /* pointer-value{<timeval>} */
    L_result0 = network_testZnetwork_testZpointer_value_METH_2(orig_sp, L_arg_2, A_next_method_info, L_rest, L_index);
    L_temp.heapptr = network_testZliteral_3.heapptr;
    L_temp.dataword.ptr = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* Define Method content-size{subclass(<timeval>)} */

/* content-size{subclass(<timeval>)} */
long network_testZnetwork_testZcontent_size_METH_2(descriptor_t *orig_sp, heapptr_t A0, heapptr_t A1)
{

    return 8;
}

/* generic-entry for content-size{subclass(<timeval>)} */
descriptor_t * network_testZnetwork_testZcontent_size_METH_GENERIC_2(descriptor_t *orig_sp, heapptr_t A_self /* self */, long A_nargs /* nargs */, heapptr_t A_next_method_info /* next-method-info */)
{
    descriptor_t *cluster_0_top;
    long L_result0; /* result0 */
    descriptor_t L_temp;

    orig_sp = ((void *)(orig_sp - 1));
    /* content-size{subclass(<timeval>)} */
    L_result0 = network_testZnetwork_testZcontent_size_METH_2(orig_sp, &network_testZnetwork_testZCLS_timeval_HEAP, A_next_method_info);
    L_temp.heapptr = network_testZliteral_2.heapptr;
    L_temp.dataword.l = L_result0;
    orig_sp[0] = L_temp;
    return orig_sp + 1;
}


/* Define Constant <__timezone-ptr-t> */

/* <__timezone-ptr-t> is <timezone> */


/* {Implicit} Define Generic gettimeofday */

/* gettimeofday is gettimeofday */


/* Define Method gettimeofday{<timeval>, <timezone>} */

/* gettimeofday{<timeval>, <timezone>} */
long network_testZnetwork_testZgettimeofday_METH(descriptor_t *orig_sp, void * A_arg1 /* arg1 */, void * A_arg2 /* arg2 */, heapptr_t A2)
{
    descriptor_t *cluster_0_top;
    long L_result_value; /* result-value */


    /* #line 83 "./gettimeofday.dylan" */

    /* #line 83 "./gettimeofday.dylan" */

    /* #line 735 "./macros.dylan" */
    L_result_value = gettimeofday(A_arg1, A_arg2);
    return L_result_value;
}

