/*  GWhere.
 *  Copyright (C) 2000  Sbastien LECACHEUR
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#include "gwsupport.h"
#include "gwcatalogstats.h"

#include <gtk/gtk.h>

#include <stdlib.h> /* strtol */
#include <string.h> /* strlen strncmp */

#include "data/gwdata.h"

#include "gwapplicationmanager.h"
#include "gwguimanager.h"


gint gw_catalog_get_total_disks ( GtkCTree *ctree, GtkCTreeNode *node)
{
	GtkCTreeNode *child = NULL;
	gint n = 0;


#ifdef GW_DEBUG_MODE
	gw_application_manager_log_msg ( 0, __FILE__, __LINE__, __PRETTY_FUNCTION__, NULL);
#endif

	child = GTK_CTREE_ROW ( node)->children;
	while ( child != NULL )
	{
		n++;
		child = GTK_CTREE_ROW ( child)->sibling;
	}

	return n;
}


gint gw_catalog_get_total_folders ( GtkCTree *ctree, GtkCTreeNode *node)
{
	GtkCTreeNode *child = NULL;
	int n = 0;


#ifdef GW_DEBUG_MODE
	gw_application_manager_log_msg ( 0, __FILE__, __LINE__, __PRETTY_FUNCTION__, NULL);
#endif

	child = GTK_CTREE_ROW( node)->children;
	while ( child != NULL )
	{
		/* Counts the number of files for each disk. */
		n = n + gw_disk_get_total_folders ( ctree, child);
		child = GTK_CTREE_ROW ( child)->sibling;
	}

	return n;
}


gint gw_catalog_get_total_files ( GtkCTree *ctree, GtkCTreeNode *node)
{
	GtkCTreeNode *child = NULL;
	int n = 0;


#ifdef GW_DEBUG_MODE
	gw_application_manager_log_msg ( 0, __FILE__, __LINE__, __PRETTY_FUNCTION__, NULL);
#endif

	child = GTK_CTREE_ROW( node)->children;
	while ( child != NULL )
	{
		/* Counts the number of folders for each disk. */
		n = n + gw_disk_get_total_files ( ctree, child);
		child = GTK_CTREE_ROW ( child)->sibling;
	}

	return n;
}


long double gw_catalog_get_total_capacity ( GtkCTree *ctree, GtkCTreeNode *node)
{
	GtkCTreeNode *child = NULL;
	long double n = 0;


#ifdef GW_DEBUG_MODE
	gw_application_manager_log_msg ( 0, __FILE__, __LINE__, __PRETTY_FUNCTION__, NULL);
#endif

	child = GTK_CTREE_ROW( node)->children;
	while ( child != NULL )
	{
		/* Counts the size of each disk. */
		n = n + disk_info_get_full ( disk_data_get_info ( gtk_ctree_node_get_row_data( ctree, child))) + disk_info_get_free ( disk_data_get_info ( gtk_ctree_node_get_row_data( ctree, child)));
		child = GTK_CTREE_ROW ( child)->sibling;
	}

	return n;
}


long double gw_catalog_get_total_used_space ( GtkCTree *ctree, GtkCTreeNode *node)
{
	GtkCTreeNode *child = NULL;
	long double n = 0;


#ifdef GW_DEBUG_MODE
	gw_application_manager_log_msg ( 0, __FILE__, __LINE__, __PRETTY_FUNCTION__, NULL);
#endif

	child = GTK_CTREE_ROW( node)->children;
	while ( child != NULL )
	{
		/* Counts the used space of each disk. */
		n = n + disk_info_get_full ( disk_data_get_info ( gtk_ctree_node_get_row_data( ctree, child)));
		child = GTK_CTREE_ROW ( child)->sibling;
	}

	return n;
}


long double gw_catalog_get_total_free_space ( GtkCTree *ctree, GtkCTreeNode *node)
{
	GtkCTreeNode *child = NULL;
	long double n = 0;


#ifdef GW_DEBUG_MODE
	gw_application_manager_log_msg ( 0, __FILE__, __LINE__, __PRETTY_FUNCTION__, NULL);
#endif

	child = GTK_CTREE_ROW( node)->children;
	while ( child != NULL )
	{
		/* Counts the free space of each disk. */
		n = n + disk_info_get_free ( disk_data_get_info ( gtk_ctree_node_get_row_data( ctree, child)));
		child = GTK_CTREE_ROW ( child)->sibling;
	}

	return n;
}


gint gw_catalog_get_num_disk_with_type ( GtkCTree *ctree, GtkCTreeNode *node, gchar *type)
{
	GtkCTreeNode *child = NULL;
	struct disk_info *disk_info;
	gint n = 0;


#ifdef GW_DEBUG_MODE
	gw_application_manager_log_msg ( 0, __FILE__, __LINE__, __PRETTY_FUNCTION__, NULL);
#endif

	child = GTK_CTREE_ROW ( node)->children;
	while ( child != NULL )
	{
		if ( (disk_info = disk_data_get_info ( gtk_ctree_node_get_row_data ( ctree, child))) == NULL )
		{
			disk_info = NULL;
			child = GTK_CTREE_ROW ( child)->sibling;
			continue;
		}

		/* Checks the disk type. */
		if ( strncmp ( type, disk_info_get_type ( disk_info), strlen ( type)) == 0 )
		{
			if ( strncmp ( type, "iso9660", 7) == 0 )
			{
				n++;
			}
		}
		else { if ( strncmp ( type, disk_info_get_fsname ( disk_info), strlen ( type)) == 0 )
		{
			if ( strncmp ( type, "/dev/fd", 7) == 0 )
			{
				n++;
			}
			else { if ( strncmp ( type, "/dev/zip", 8) == 0 )
			{
				n++;
			}
			else { if ( strncmp ( type, "/dev/hd", 7) == 0 )
			{
				n++;
			}}}
		}
		else { if ( strncmp ( disk_info_get_type ( disk_info), "ntfs", 4) == 0 )
		{
			if ( strncmp ( type, "/dev/hd", 7) == 0 )
			{
				n++;
			}
		}
		else { if ( strncmp ( disk_info_get_type ( disk_info), "cdfs", 4) == 0 )
		{
			if ( strncmp ( type, "iso9660", 7) == 0 )
			{
				n++;
			}
		}
		else { if ( strncmp ( disk_info_get_dir ( disk_info), "A", 1) == 0 )
		{
			if ( strncmp ( type, "/dev/fd", 7) == 0 )
			{
				n++;
			}
		}
		else { if ( strncmp ( disk_info_get_dir ( disk_info), "B", 1) == 0 )
		{
			if ( strncmp ( type, "/dev/fd", 7) == 0 )
			{
				n++;
			}
		}
		else { if ( strncmp ( type, "Other", 5) == 0 )
		{
			n++;
			if ( strncmp ( "iso9660", disk_info_get_type ( disk_info ), 7) == 0 )
			{
				n--;
			}
			else { if ( strncmp ( disk_info_get_fsname ( disk_info), "/dev/fd", 7) == 0 )
			{
				n--;
			}
			else { if ( strncmp ( disk_info_get_fsname ( disk_info), "/dev/zip", 8) == 0 )
			{
				n--;
			}
			else { if ( strncmp ( disk_info_get_fsname ( disk_info), "/dev/hd", 7) == 0 )
			{
				n--;
			}}}}
		}}}}}}}

/*		if ( strncmp ( type, disk_info_get_type ( disk_data_get_info ( gtk_ctree_node_get_row_data ( ctree, child))), strlen ( type)) == 0 )
		{
			n++;
		}
*/
		disk_info = NULL;
		child = GTK_CTREE_ROW ( child)->sibling;
	}

	return n;
}


gint gw_disk_get_total_folders ( GtkCTree *ctree, GtkCTreeNode *node)
{
	GtkCTreeNode *child = NULL;
	int n = 0;


#ifdef GW_DEBUG_MODE
	gw_application_manager_log_msg ( 0, __FILE__, __LINE__, __PRETTY_FUNCTION__, NULL);
#endif

	child = GTK_CTREE_ROW( node)->children;
	while ( child != NULL )
	{
		n++;
		n = n + gw_disk_get_total_folders ( ctree, child);
		child = GTK_CTREE_ROW ( child)->sibling;
	}

	return n;
}


gint gw_disk_get_total_files ( GtkCTree *ctree, GtkCTreeNode *node)
{
	GtkCTreeNode *child = NULL;
	int n = 0;


#ifdef GW_DEBUG_MODE
	gw_application_manager_log_msg ( 0, __FILE__, __LINE__, __PRETTY_FUNCTION__, NULL);
#endif

	/* Counts the folder's number of files. */
	n = dir_data_get_num_file ( gtk_ctree_node_get_row_data ( ctree, node));

	child = GTK_CTREE_ROW( node)->children;
	while ( child != NULL )
	{
		/* Does the same thing for each subfolder. */
		n = n + gw_disk_get_total_files ( ctree, child);
		child = GTK_CTREE_ROW ( child)->sibling;
	}

	return n;
}


gint gw_disk_get_max_num ( GtkCTree *ctree, GtkCTreeNode *root)
{
	gint max = 0;
	GtkCTreeNode *node = NULL;


#ifdef GW_DEBUG_MODE
	gw_application_manager_log_msg ( 0, __FILE__, __LINE__, __PRETTY_FUNCTION__, NULL);
#endif

	/* Checks if a catalog is opened. */
	if ( root != NULL )
	{
		node = GTK_CTREE_ROW ( root)->children;

		/* Checks if there are some disk. */
		while ( node != NULL )
		{
			if ( disk_info_get_num ( disk_data_get_info ( gtk_ctree_node_get_row_data ( ctree, node))) > max )
			{
				max = disk_info_get_num ( disk_data_get_info ( gtk_ctree_node_get_row_data ( ctree, node)));
			}

			/* Goes to the next branch (ie. the next disk). */
			node = GTK_CTREE_ROW ( node)->sibling;
		}
	}
	else
	{
		/* If no opened disk. */
		return 0;
	}

	return max;
}


gboolean gw_disk_name_is_exist ( gchar *name)
{
	GtkCTreeNode *node = NULL;
	GtkCTree *ctree = NULL;
	GtkCTreeNode *root = NULL;


#ifdef GW_DEBUG_MODE
	gw_application_manager_log_msg ( 0, __FILE__, __LINE__, __PRETTY_FUNCTION__, NULL);
#endif

	ctree = gw_gui_manager_main_interface_get_tree ( );
	root = gw_gui_manager_main_interface_get_tree_root ( );

	/* Checks if a catalog is opened. */
	if ( root != NULL )
	{
		node = GTK_CTREE_ROW ( root)->children;
		while ( node != NULL )
		{
			if ( strcmp ( disk_info_get_name ( disk_data_get_info ( gtk_ctree_node_get_row_data ( ctree, node))), name) == 0 )
			{
				return TRUE;
			}

			/* Goes to the next branch (ie. the next disk). */
			node = GTK_CTREE_ROW ( node)->sibling;
		}
	}
	else
	{
		/* If no opened disk. */
		return FALSE;
	}

	return FALSE;
}


gboolean gw_disk_num_is_exist ( gint num)
{
	GtkCTreeNode *node = NULL;
	GtkCTree *ctree = NULL;
	GtkCTreeNode *root = NULL;


#ifdef GW_DEBUG_MODE
	gw_application_manager_log_msg ( 0, __FILE__, __LINE__, __PRETTY_FUNCTION__, NULL);
#endif

	ctree = gw_gui_manager_main_interface_get_tree ( );
	root = gw_gui_manager_main_interface_get_tree_root ( );

	/* Checks if a catalog is opened. */
	if ( root != NULL )
	{
		node = GTK_CTREE_ROW ( root)->children;
		while ( node != NULL )
		{
			if ( disk_info_get_num ( disk_data_get_info ( gtk_ctree_node_get_row_data ( ctree, node))) == num )
			{
				return TRUE;
			}

			/* Goes to the next branch (ie. the next disk). */
			node = GTK_CTREE_ROW ( node)->sibling;
		}
	}
	else
	{
		/* If no opened disk. */
		return FALSE;
	}

	return FALSE;
}


GtkCTreeNode * gw_folder_get_catalog ( GtkCTree *ctree, GtkCTreeNode *node)
{
	GtkCTreeNode *parent = NULL;


#ifdef GW_DEBUG_MODE
	gw_application_manager_log_msg ( 0, __FILE__, __LINE__, __PRETTY_FUNCTION__, NULL);
#endif

	parent = GTK_CTREE_ROW ( node)->parent;
	while ( GTK_CTREE_ROW ( parent)->parent != NULL )
	{
		parent = GTK_CTREE_ROW ( parent)->parent;
	}

	return parent;
}


GtkCTreeNode * gw_folder_get_disk ( GtkCTree *ctree, GtkCTreeNode *node)
{
	GtkCTreeNode *parent = NULL;
	GtkCTreeNode *root = NULL;


#ifdef GW_DEBUG_MODE
	gw_application_manager_log_msg ( 0, __FILE__, __LINE__, __PRETTY_FUNCTION__, NULL);
#endif

	root = gw_gui_manager_main_interface_get_tree_root ( );

	if ( GTK_CTREE_ROW ( node)->parent == root)
	{
		return node;
	}

	parent = GTK_CTREE_ROW ( node)->parent;

	while ( GTK_CTREE_ROW ( GTK_CTREE_ROW ( parent)->parent)->parent != NULL )
	{
		parent = GTK_CTREE_ROW ( parent)->parent;
	}

	return parent;
}


gchar * gw_folder_get_disk_name ( GtkCTree *ctree, GtkCTreeNode *node)
{
	GtkCTreeNode *parent = NULL;
	GtkCTreeNode *root = NULL;
	gchar *disk_name = NULL;


#ifdef GW_DEBUG_MODE
	gw_application_manager_log_msg ( 0, __FILE__, __LINE__, __PRETTY_FUNCTION__, NULL);
#endif

	root = gw_gui_manager_main_interface_get_tree_root ( );

	if ( GTK_CTREE_ROW ( node)->parent == root )
	{
		return g_strdup ( disk_info_get_name ( disk_data_get_info ( gtk_ctree_node_get_row_data ( ctree, node))));
	}

	parent = GTK_CTREE_ROW ( node)->parent;
	while ( GTK_CTREE_ROW ( GTK_CTREE_ROW ( parent)->parent)->parent != NULL )
	{
		parent = GTK_CTREE_ROW ( parent)->parent;
	}

	if ( (parent != NULL) && (gtk_ctree_node_get_row_data ( ctree, parent) != NULL) && (disk_data_get_info ( gtk_ctree_node_get_row_data ( ctree, parent)) != NULL) && (disk_info_get_name ( disk_data_get_info ( gtk_ctree_node_get_row_data ( ctree, parent))) != NULL))
	{
		disk_name = g_strdup ( disk_info_get_name ( disk_data_get_info ( gtk_ctree_node_get_row_data ( ctree, parent))));
	}

	return disk_name;
}


gchar * gw_folder_get_disk_type ( GtkCTree *ctree, GtkCTreeNode *node)
{
	GtkCTreeNode *parent = NULL;
	gchar *disk_type = NULL;


#ifdef GW_DEBUG_MODE
	gw_application_manager_log_msg ( 0, __FILE__, __LINE__, __PRETTY_FUNCTION__, NULL);
#endif

	parent = GTK_CTREE_ROW ( node)->parent;
	while ( GTK_CTREE_ROW ( GTK_CTREE_ROW ( parent)->parent)->parent != NULL )
	{
		parent = GTK_CTREE_ROW ( parent)->parent;
	}

	if ( (parent != NULL) && (gtk_ctree_node_get_row_data ( ctree, parent) != NULL) && (disk_data_get_info ( gtk_ctree_node_get_row_data ( ctree, parent)) != NULL) && (disk_info_get_type ( disk_data_get_info ( gtk_ctree_node_get_row_data ( ctree, parent))) != NULL))
	{
		disk_type = g_strdup ( disk_info_get_type ( disk_data_get_info ( gtk_ctree_node_get_row_data ( ctree, parent))));
	}

	return disk_type;
}


gchar * gw_folder_get_location_on_disk ( GtkCTree *ctree, GtkCTreeNode *node)
{
	GtkCTreeNode *parent = NULL;
	GtkCTreeNode *root = NULL;
	gchar *text = NULL;
	gchar *tmp = NULL;


#ifdef GW_DEBUG_MODE
	gw_application_manager_log_msg ( 0, __FILE__, __LINE__, __PRETTY_FUNCTION__, NULL);
#endif

	root = gw_gui_manager_main_interface_get_tree_root ( );

	if ( GTK_CTREE_ROW ( node)->parent == root )
	{
		text = g_strdup ( G_DIR_SEPARATOR_S);
		return text;
	}

	tmp = text = g_strconcat ( G_DIR_SEPARATOR_S, file_info_get_name ( dir_data_get_info ( gtk_ctree_node_get_row_data ( ctree, node))), NULL);

	parent = GTK_CTREE_ROW ( node)->parent;
	while ( GTK_CTREE_ROW ( GTK_CTREE_ROW ( parent)->parent)->parent != NULL )
	{
		text = g_strconcat ( G_DIR_SEPARATOR_S, file_info_get_name ( dir_data_get_info ( gtk_ctree_node_get_row_data ( ctree, parent))), text, NULL);
		g_free ( tmp);
		tmp = text;
		parent = GTK_CTREE_ROW ( parent)->parent;
	}

	return text;
}


gint gw_disk_get_num_archive ( gchar *num)
{
	GtkCTree *ctree = NULL;
	GtkCTreeNode *root = NULL;


#ifdef GW_DEBUG_MODE
	gw_application_manager_log_msg ( 0, __FILE__, __LINE__, __PRETTY_FUNCTION__, NULL);
#endif

	ctree = gw_gui_manager_main_interface_get_tree ( );
	root = gw_gui_manager_main_interface_get_tree_root ( );

	if ( strcmp ( num, "") == 0 )
	{
		/* If number archive no filled. */
		return gw_disk_get_max_num ( ctree, root) + 1;
	}
	else { if ( gw_disk_num_is_exist ( strtol ( num, NULL, 10)) )
	{
		/* If the filled archive number exists. */
		return gw_disk_get_max_num ( ctree, root) + 1;
	}
	else
	{
		/* If the filled archive number is valid. */
		return strtol ( num, NULL, 10);
	}}
}


gchar * gw_disk_get_name ( gchar *name) {
	gchar *tmp_name = NULL;
	gint i = 2;


#ifdef GW_DEBUG_MODE
	gw_application_manager_log_msg ( 0, __FILE__, __LINE__, __PRETTY_FUNCTION__, NULL);
#endif

	if ( name!=NULL) {
		tmp_name = g_strdup ( name);

		while ( gw_disk_name_is_exist ( tmp_name) ) {
			g_free ( tmp_name);
			tmp_name = g_strdup_printf ( "%s (%d)", name, i++);
		}
	}

	return tmp_name;
}



gboolean gw_folder_name_is_exist ( GtkCTreeNode *folder, gchar *name)
{
	GtkCTree *ctree = NULL;
	GtkCTreeNode *root = NULL;
	GtkCTreeNode *parent = NULL;
	GtkCTreeNode *node = NULL;


#ifdef GW_DEBUG_MODE
	gw_application_manager_log_msg ( 0, __FILE__, __LINE__, __PRETTY_FUNCTION__, NULL);
#endif

	ctree = gw_gui_manager_main_interface_get_tree ( );
	root = gw_gui_manager_main_interface_get_tree_root ( );

	/* Checks if a catalog is opened. */
	if ( root!=NULL && folder!=NULL )
	{
		parent = GTK_CTREE_ROW ( folder)->parent;
		node = GTK_CTREE_ROW ( parent)->children;
		while ( node != NULL )
		{
			if ( (node != folder) && strcmp ( file_info_get_name ( dir_data_get_info ( gtk_ctree_node_get_row_data ( ctree, node))), name) == 0 )
			{
				return TRUE;
			}

			/* Goes to the next branch (ie. the next folder). */
			node = GTK_CTREE_ROW ( node)->sibling;
		}
	}
	else
	{
		/* If no opened disk. */
		return FALSE;
	}

	if ( dir_data_get_child_named ( gtk_ctree_node_get_row_data ( ctree, parent), name) != NULL )
	{
		return TRUE;
	}

	return FALSE;
}
