/*  GWhere.
 *  Copyright (C) 2000  Sbastien LECACHEUR
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#include "../gwsupport.h"
#include "gwnotebookcatalogcallback.h"

#include <string.h> /* strcmp strlen */

#include "tools/gwtools.h"
#include "res/gwres.h"
#include "data/gwdata.h"

#include "gwstatusbar.h"
#include "gwstatusbarcallback.h"
#include "gwnotebookcatalog.h"
#include "gwnotebooksearch.h"
#include "gwnotebookmanagmentcallback.h"
#include "gwmenupopup.h"

#include "../gwapplicationmanager.h"
#include "../gwguimanager.h"
#include "../gwcatalogmanager.h"


gint gw_catalog_compare_disk_int ( GtkCList *clist, const gpointer ptr1, const gpointer ptr2)
{
	struct disk_info *disk_info1 = NULL, *disk_info2 = NULL;
	int nb1 = -1, nb2 = -1;


#ifdef GW_DEBUG_GUI_CALLBACK_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( (ptr1!=NULL) && (ptr2!=NULL) )
	{
		disk_info1 = (struct disk_info*)(((GtkCListRow *)ptr1)->data);
		disk_info2 = (struct disk_info*)(((GtkCListRow *)ptr2)->data);

		if ( (disk_info1!=NULL) && (disk_info2!=NULL) )
		{
			switch ( clist->sort_column)
			{
				case GW_VALUE_APP_EXPLORER_DISK_COLUMN_NBARCHIVE_POSITION_DEFAULT:	nb1 = disk_info_get_num ( disk_info1);
													nb2 = disk_info_get_num ( disk_info2);
													break;
			}
		}
	}

	return nb1 - nb2;
}


gint gw_catalog_compare_disk_gulong ( GtkCList *clist, const gpointer ptr1, const gpointer ptr2)
{
	struct disk_info *disk_info1 = NULL, *disk_info2 = NULL;
	gulong nb1 = 0, nb2 = 0;


#ifdef GW_DEBUG_GUI_CALLBACK_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( (ptr1!=NULL) && (ptr2!=NULL) )
	{
		disk_info1 = (struct disk_info*)(((GtkCListRow *)ptr1)->data);
		disk_info2 = (struct disk_info*)(((GtkCListRow *)ptr2)->data);

		if ( (disk_info1!=NULL) && (disk_info2!=NULL) )
		{
			switch ( clist->sort_column)
			{
				case GW_VALUE_APP_EXPLORER_DISK_COLUMN_DATE_POSITION_DEFAULT:	nb1 = disk_info_get_date ( disk_info1);
												nb2 = disk_info_get_date ( disk_info2);
												break;
			}
		}
	}

	return nb1 - nb2;
}


gint gw_catalog_compare_disk_guint64 ( GtkCList *clist, const gpointer ptr1, const gpointer ptr2)
{
	struct disk_info *disk_info1 = NULL, *disk_info2 = NULL;
	guint64 nb1 = -1, nb2 = -1;


#ifdef GW_DEBUG_GUI_CALLBACK_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( (ptr1!=NULL) && (ptr2!=NULL) )
	{
		disk_info1 = (struct disk_info*)(((GtkCListRow *)ptr1)->data);
		disk_info2 = (struct disk_info*)(((GtkCListRow *)ptr2)->data);

		if ( (disk_info1!=NULL) && (disk_info2!=NULL) )
		{
			switch ( clist->sort_column)
			{
				case GW_VALUE_APP_EXPLORER_DISK_COLUMN_CAPACITY_POSITION_DEFAULT:	nb1 = disk_info_get_full ( disk_info1);
													nb2 = disk_info_get_full ( disk_info2);
													break;

				case GW_VALUE_APP_EXPLORER_DISK_COLUMN_FREE_POSITION_DEFAULT:		nb1 = disk_info_get_free ( disk_info1);
													nb2 = disk_info_get_free ( disk_info2);
													break;
			}
		}
	}

	return nb1 - nb2;
}


gint gw_catalog_compare_disk_str ( GtkCList *clist, const gpointer ptr1, const gpointer ptr2)
{
	struct disk_info *disk_info1 = NULL, *disk_info2 = NULL;
	gchar *str1 = NULL, *str2 = NULL;
	gint result = 0;


#ifdef GW_DEBUG_GUI_CALLBACK_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( (ptr1!=NULL) && (ptr2!=NULL) )
	{
		disk_info1 = (struct disk_info*)(((GtkCListRow *)ptr1)->data);
		disk_info2 = (struct disk_info*)(((GtkCListRow *)ptr2)->data);

		if ( (disk_info1!=NULL) && (disk_info2!=NULL) )
		{
			switch ( clist->sort_column)
			{
				case GW_VALUE_APP_EXPLORER_DISK_COLUMN_NAME_POSITION_DEFAULT:		str1 = disk_info_get_name ( disk_info1);
													str2 = disk_info_get_name ( disk_info2);
													break;

				case GW_VALUE_APP_EXPLORER_DISK_COLUMN_FSNAME_POSITION_DEFAULT:		str1 = disk_info_get_fsname ( disk_info1);
													str2 = disk_info_get_fsname ( disk_info2);
													break;

				case GW_VALUE_APP_EXPLORER_DISK_COLUMN_PATH_POSITION_DEFAULT:		str1 = disk_info_get_dir ( disk_info1);
													str2 = disk_info_get_dir ( disk_info2);
													break;

				case GW_VALUE_APP_EXPLORER_DISK_COLUMN_TYPE_POSITION_DEFAULT:		str1 = disk_info_get_type ( disk_info1);
													str2 = disk_info_get_type ( disk_info2);
													break;

				case GW_VALUE_APP_EXPLORER_DISK_COLUMN_VOLUME_POSITION_DEFAULT:		str1 = disk_info_get_volume ( disk_info1);
													str2 = disk_info_get_volume ( disk_info2);
													break;

				case GW_VALUE_APP_EXPLORER_DISK_COLUMN_SERIAL_POSITION_DEFAULT:		str1 = disk_info_get_serial ( disk_info1);
													str2 = disk_info_get_serial ( disk_info2);
													break;

				case GW_VALUE_APP_EXPLORER_DISK_COLUMN_CATEGORY_POSITION_DEFAULT:	str1 = disk_info_get_category_name ( disk_info1);
													str2 = disk_info_get_category_name ( disk_info2);
													break;

				case GW_VALUE_APP_EXPLORER_DISK_COLUMN_DESCRIPTION_POSITION_DEFAULT:	str1 = disk_info_get_description ( disk_info1);
													str2 = disk_info_get_description ( disk_info2);
													break;
			}

			if ( (str1!=NULL) && (str2!=NULL) )
			{
				if ( gw_application_manager_get_settings_tol ( GW_VALUE_APP_EXPLORER_SORT_CASE_SENSITIVE) == 1 )
				{
					result = strcmp ( str1, str2);
				}
				else
				{
					result = strcasecmp ( str1, str2);
				}
			}
		}
	}

	return result;
}


gint gw_catalog_compare_file_glong ( GtkCList *clist, const gpointer ptr1, const gpointer ptr2)
{
	struct file_info *file_info1 = NULL, *file_info2 = NULL;
	glong nb1 = -1, nb2 = -1;
	gboolean isfolder1 = FALSE, isfolder2 = FALSE;
	gchar *str_name1 = NULL, *str_name2 = NULL;
	gint result = 0;


#ifdef GW_DEBUG_GUI_CALLBACK_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( (ptr1!=NULL) && (ptr2!=NULL) )
	{
		file_info1 = (struct file_info*)(((GtkCListRow *)ptr1)->data);
		file_info2 = (struct file_info*)(((GtkCListRow *)ptr2)->data);

		if ( (file_info1!=NULL) && (file_info2!=NULL) )
		{
			str_name1 = file_info_get_name ( file_info1);
			str_name2 = file_info_get_name ( file_info2);
			isfolder1 = file_info_get_isdirectory ( file_info1);
			isfolder2 = file_info_get_isdirectory ( file_info2);

			switch ( clist->sort_column)
			{
				case GW_VALUE_APP_EXPLORER_FILE_COLUMN_INODE_POSITION_DEFAULT:	nb1 = file_info_get_inode ( file_info1);
												nb2 = file_info_get_inode ( file_info2);
												break;
			}

			if ( (str_name1!=NULL) && (str_name2!=NULL) )
			{
				if ( (strlen ( str_name1) == 2) && (strncmp ( str_name1, "..", 2) == 0) )
				{
					result = (clist->sort_type==GTK_SORT_ASCENDING?-2:2);
				}
				else
				{
					if ( (strlen ( str_name2) == 2) && (strncmp ( str_name2, "..", 2) == 0) )
					{
						result = (clist->sort_type==GTK_SORT_ASCENDING?2:-2);
					}
					else
					{
						result = (((gw_application_manager_get_settings_tol ( GW_VALUE_APP_EXPLORER_SORT_BY_FOLDER)==0)||(isfolder1==isfolder2))?(nb1-nb2):(isfolder2-isfolder1));
					}
				}
			}
		}
	}

	return result;
}


gint gw_catalog_compare_file_gulong ( GtkCList *clist, const gpointer ptr1, const gpointer ptr2)
{
	struct file_info *file_info1 = NULL, *file_info2 = NULL;
	gulong nb1 = 0, nb2 = 0;
	gboolean isfolder1 = FALSE, isfolder2 = FALSE;
	gchar *str_name1 = NULL, *str_name2 = NULL;
	gint result = 0;


#ifdef GW_DEBUG_GUI_CALLBACK_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( (ptr1!=NULL) && (ptr2!=NULL) )
	{
		file_info1 = (struct file_info*)(((GtkCListRow *)ptr1)->data);
		file_info2 = (struct file_info*)(((GtkCListRow *)ptr2)->data);

		if ( (file_info1!=NULL) && (file_info2!=NULL) )
		{
			str_name1 = file_info_get_name ( file_info1);
			str_name2 = file_info_get_name ( file_info2);
			isfolder1 = file_info_get_isdirectory ( file_info1);
			isfolder2 = file_info_get_isdirectory ( file_info2);

			switch ( clist->sort_column)
			{
				case GW_VALUE_APP_EXPLORER_FILE_COLUMN_CDATE_POSITION_DEFAULT:	nb1 = file_info_get_cdate ( file_info1);
												nb2 = file_info_get_cdate ( file_info2);
												break;

				case GW_VALUE_APP_EXPLORER_FILE_COLUMN_ADATE_POSITION_DEFAULT:	nb1 = file_info_get_adate ( file_info1);
												nb2 = file_info_get_adate ( file_info2);
												break;

				case GW_VALUE_APP_EXPLORER_FILE_COLUMN_MDATE_POSITION_DEFAULT:	nb1 = file_info_get_mdate ( file_info1);
												nb2 = file_info_get_mdate ( file_info2);
												break;
			}

			if ( (str_name1!=NULL) && (str_name2!=NULL) )
			{
				if ( (strlen ( str_name1) == 2) && (strncmp ( str_name1, "..", 2) == 0) )
				{
					result = (clist->sort_type==GTK_SORT_ASCENDING?-2:2);
				}
				else
				{
					if ( (strlen ( str_name2) == 2) && (strncmp ( str_name2, "..", 2) == 0) )
					{
						result = (clist->sort_type==GTK_SORT_ASCENDING?2:-2);
					}
					else
					{
						result = (((gw_application_manager_get_settings_tol ( GW_VALUE_APP_EXPLORER_SORT_BY_FOLDER)==0)||(isfolder1==isfolder2))?(nb1-nb2):(isfolder2-isfolder1));
					}
				}
			}
		}
	}

	return result;
}


gint gw_catalog_compare_file_guint64 ( GtkCList *clist, const gpointer ptr1, const gpointer ptr2)
{
	struct file_info *file_info1 = NULL, *file_info2 = NULL;
	guint64 nb1 = 0, nb2 = 0;
	gboolean isfolder1 = FALSE, isfolder2 = FALSE;
	gchar *str_name1 = NULL, *str_name2 = NULL;
	gint result = 0;


#ifdef GW_DEBUG_GUI_CALLBACK_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( (ptr1!=NULL) && (ptr2!=NULL) )
	{
		file_info1 = (struct file_info*)(((GtkCListRow *)ptr1)->data);
		file_info2 = (struct file_info*)(((GtkCListRow *)ptr2)->data);

		if ( (file_info1!=NULL) && (file_info2!=NULL) )
		{
			str_name1 = file_info_get_name ( file_info1);
			str_name2 = file_info_get_name ( file_info2);
			isfolder1 = file_info_get_isdirectory ( file_info1);
			isfolder2 = file_info_get_isdirectory ( file_info2);

			switch ( clist->sort_column)
			{
				case GW_VALUE_APP_EXPLORER_FILE_COLUMN_SIZE_POSITION_DEFAULT:	nb1 = file_info_get_size ( file_info1);
												nb2 = file_info_get_size ( file_info2);
												break;
			}

			if ( (str_name1!=NULL) && (str_name2!=NULL) )
			{
				if ( (strlen ( str_name1) == 2) && (strncmp ( str_name1, "..", 2) == 0) )
				{
					result = (clist->sort_type==GTK_SORT_ASCENDING?-2:2);
				}
				else
				{
					if ( (strlen ( str_name2) == 2) && (strncmp ( str_name2, "..", 2) == 0) )
					{
						result = (clist->sort_type==GTK_SORT_ASCENDING?2:-2);
					}
					else
					{
						result = (((gw_application_manager_get_settings_tol ( GW_VALUE_APP_EXPLORER_SORT_BY_FOLDER)==0)||(isfolder1==isfolder2))?(nb1-nb2):(isfolder2-isfolder1));
					}
				}
			}
		}
	}

	return result;
}


gint gw_catalog_compare_file_str ( GtkCList *clist, const gpointer ptr1, const gpointer ptr2)
{
	struct file_info *file_info1 = NULL, *file_info2 = NULL;
	gchar *str_name1 = NULL, *str_name2 = NULL;
	gchar *str1 = NULL, *str2 = NULL;
	gboolean isfolder1 = FALSE, isfolder2 = FALSE;
	gint result = 0;


#ifdef GW_DEBUG_GUI_CALLBACK_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( (ptr1!=NULL) && (ptr2!=NULL) )
	{
		file_info1 = (struct file_info*)(((GtkCListRow *)ptr1)->data);
		file_info2 = (struct file_info*)(((GtkCListRow *)ptr2)->data);

		if ( (file_info1!=NULL) && (file_info2!=NULL) )
		{
			str_name1 = file_info_get_name ( file_info1);
			str_name2 = file_info_get_name ( file_info2);
			isfolder1 = file_info_get_isdirectory ( file_info1);
			isfolder2 = file_info_get_isdirectory ( file_info2);

			switch ( clist->sort_column)
			{
				case GW_VALUE_APP_EXPLORER_FILE_COLUMN_NAME_POSITION_DEFAULT:		str1 = str_name1;
													str2 = str_name2;
													break;

				case GW_VALUE_APP_EXPLORER_FILE_COLUMN_RIGHTS_POSITION_DEFAULT:		str1 = file_info_get_rights_to_gchar ( file_info1);
													str2 = file_info_get_rights_to_gchar ( file_info2);
													break;

				case GW_VALUE_APP_EXPLORER_FILE_COLUMN_OWNER_POSITION_DEFAULT:		str1 = file_info_get_owner ( file_info1);
													str2 = file_info_get_owner ( file_info2);
													break;

				case GW_VALUE_APP_EXPLORER_FILE_COLUMN_GROUP_POSITION_DEFAULT:		str1 = file_info_get_group ( file_info1);
													str2 = file_info_get_group ( file_info2);
													break;

				case GW_VALUE_APP_EXPLORER_FILE_COLUMN_CATEGORY_POSITION_DEFAULT:	str1 = file_info_get_category_name ( file_info1);
													str2 = file_info_get_category_name ( file_info2);
													break;

				case GW_VALUE_APP_EXPLORER_FILE_COLUMN_DESCRIPTION_POSITION_DEFAULT:	str1 = file_info_get_description ( file_info1);
													str2 = file_info_get_description ( file_info2);
													break;
			}

			if ( (str_name1!=NULL) && (str_name2!=NULL) && (str1!=NULL) && (str2!=NULL) )
			{
				if ( (strlen ( str_name1) == 2) && (strncmp ( str_name1, "..", 2) == 0) )
				{
					result = (clist->sort_type==GTK_SORT_ASCENDING?-2:2);
				}
				else
				{
					if ( (strlen ( str_name2) == 2) && (strncmp ( str_name2, "..", 2) == 0) )
					{
						result = (clist->sort_type==GTK_SORT_ASCENDING?2:-2);
					}
					else
					{
						if ( gw_application_manager_get_settings_tol ( GW_VALUE_APP_EXPLORER_SORT_CASE_SENSITIVE) == 1 )
						{
							result = (((gw_application_manager_get_settings_tol ( GW_VALUE_APP_EXPLORER_SORT_BY_FOLDER)==0)||(isfolder1==isfolder2))?strcmp ( str1, str2):(isfolder2-isfolder1));
						}
						else
						{
							result = (((gw_application_manager_get_settings_tol ( GW_VALUE_APP_EXPLORER_SORT_BY_FOLDER)==0)||(isfolder1==isfolder2))?strcasecmp ( str1, str2):(isfolder2-isfolder1));
						}
					}
				}
			}

			if ( clist->sort_column == GW_VALUE_APP_EXPLORER_FILE_COLUMN_RIGHTS_POSITION_DEFAULT )
			{
				if ( str1 != NULL )
				{
					g_free ( str1);
				}

				if ( str2 != NULL )
				{
					g_free ( str2);
				}
			}
		}
	}

	return result;
}


gint gw_notebook_catalog_set_column_sort ( GtkCList *clist, gint column)
{
	GtkCTree *ctree = NULL;
	GtkCTreeNode *selection = NULL;
	gint result = -1;


#ifdef GW_DEBUG_GUI_CALLBACK_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( (clist!=NULL) && (column>-1) )
	{
		/* Gets the selected item in the tree. */
		if ( (ctree = gw_gui_manager_main_interface_get_tree ( )) != NULL )
		{
			if ( (GTK_CLIST ( ctree)->selection != NULL) && ((selection = GTK_CTREE_NODE ( GTK_CLIST ( ctree)->selection->data)) != NULL) )
			{
				if ( GTK_CTREE_ROW ( selection)->parent == NULL )
				{
					/* User is in the catalog : this is a list of disks. */
					switch ( column)
					{
						case GW_VALUE_APP_EXPLORER_DISK_COLUMN_NAME_POSITION_DEFAULT:		gtk_clist_set_compare_func ( clist, (GtkCListCompareFunc)gw_catalog_compare_disk_str);
															break;

						case GW_VALUE_APP_EXPLORER_DISK_COLUMN_FSNAME_POSITION_DEFAULT:		gtk_clist_set_compare_func ( clist, (GtkCListCompareFunc)gw_catalog_compare_disk_str);
															break;

						case GW_VALUE_APP_EXPLORER_DISK_COLUMN_PATH_POSITION_DEFAULT:		gtk_clist_set_compare_func ( clist, (GtkCListCompareFunc)gw_catalog_compare_disk_str);
															break;

						case GW_VALUE_APP_EXPLORER_DISK_COLUMN_NBARCHIVE_POSITION_DEFAULT:	gtk_clist_set_compare_func ( clist, (GtkCListCompareFunc)gw_catalog_compare_disk_int);
															break;

						case GW_VALUE_APP_EXPLORER_DISK_COLUMN_TYPE_POSITION_DEFAULT:		gtk_clist_set_compare_func ( clist, (GtkCListCompareFunc)gw_catalog_compare_disk_str);
															break;

						case GW_VALUE_APP_EXPLORER_DISK_COLUMN_VOLUME_POSITION_DEFAULT:		gtk_clist_set_compare_func ( clist, (GtkCListCompareFunc)gw_catalog_compare_disk_str);
															break;

						case GW_VALUE_APP_EXPLORER_DISK_COLUMN_CAPACITY_POSITION_DEFAULT:	gtk_clist_set_compare_func ( clist, (GtkCListCompareFunc)gw_catalog_compare_disk_guint64);
															break;

						case GW_VALUE_APP_EXPLORER_DISK_COLUMN_FREE_POSITION_DEFAULT:		gtk_clist_set_compare_func ( clist, (GtkCListCompareFunc)gw_catalog_compare_disk_guint64);
															break;

						case GW_VALUE_APP_EXPLORER_DISK_COLUMN_DATE_POSITION_DEFAULT:		gtk_clist_set_compare_func ( clist, (GtkCListCompareFunc)gw_catalog_compare_disk_gulong);
															break;

						case GW_VALUE_APP_EXPLORER_DISK_COLUMN_SERIAL_POSITION_DEFAULT:		gtk_clist_set_compare_func ( clist, (GtkCListCompareFunc)gw_catalog_compare_disk_str);
															break;

						case GW_VALUE_APP_EXPLORER_DISK_COLUMN_CATEGORY_POSITION_DEFAULT:	gtk_clist_set_compare_func ( clist, (GtkCListCompareFunc)gw_catalog_compare_disk_str);
															break;

						case GW_VALUE_APP_EXPLORER_DISK_COLUMN_DESCRIPTION_POSITION_DEFAULT:	gtk_clist_set_compare_func ( clist, (GtkCListCompareFunc)gw_catalog_compare_disk_str);
															break;

						default:								gtk_clist_set_compare_func ( clist, NULL);
															break;
					}
				}
				else
				{
					/* User is in a disk or a folder : this is a list of files. */
					switch ( column)
					{
						case GW_VALUE_APP_EXPLORER_FILE_COLUMN_NAME_POSITION_DEFAULT:		gtk_clist_set_compare_func ( clist, (GtkCListCompareFunc)gw_catalog_compare_file_str);
															break;

						case GW_VALUE_APP_EXPLORER_FILE_COLUMN_RIGHTS_POSITION_DEFAULT:		gtk_clist_set_compare_func ( clist, (GtkCListCompareFunc)gw_catalog_compare_file_str);
															break;

						case GW_VALUE_APP_EXPLORER_FILE_COLUMN_OWNER_POSITION_DEFAULT:		gtk_clist_set_compare_func ( clist, (GtkCListCompareFunc)gw_catalog_compare_file_str);
															break;

						case GW_VALUE_APP_EXPLORER_FILE_COLUMN_GROUP_POSITION_DEFAULT:		gtk_clist_set_compare_func ( clist, (GtkCListCompareFunc)gw_catalog_compare_file_str);
															break;

						case GW_VALUE_APP_EXPLORER_FILE_COLUMN_SIZE_POSITION_DEFAULT:		gtk_clist_set_compare_func ( clist, (GtkCListCompareFunc)gw_catalog_compare_file_guint64);
															break;

						case GW_VALUE_APP_EXPLORER_FILE_COLUMN_INODE_POSITION_DEFAULT:		gtk_clist_set_compare_func ( clist, (GtkCListCompareFunc)gw_catalog_compare_file_glong);
															break;

						case GW_VALUE_APP_EXPLORER_FILE_COLUMN_ADATE_POSITION_DEFAULT:		gtk_clist_set_compare_func ( clist, (GtkCListCompareFunc)gw_catalog_compare_file_gulong);
															break;

						case GW_VALUE_APP_EXPLORER_FILE_COLUMN_CDATE_POSITION_DEFAULT:		gtk_clist_set_compare_func ( clist, (GtkCListCompareFunc)gw_catalog_compare_file_gulong);
															break;

						case GW_VALUE_APP_EXPLORER_FILE_COLUMN_MDATE_POSITION_DEFAULT:		gtk_clist_set_compare_func ( clist, (GtkCListCompareFunc)gw_catalog_compare_file_gulong);
															break;

						case GW_VALUE_APP_EXPLORER_FILE_COLUMN_CATEGORY_POSITION_DEFAULT:	gtk_clist_set_compare_func ( clist, (GtkCListCompareFunc)gw_catalog_compare_file_str);
															break;

						case GW_VALUE_APP_EXPLORER_FILE_COLUMN_DESCRIPTION_POSITION_DEFAULT:	gtk_clist_set_compare_func ( clist, (GtkCListCompareFunc)gw_catalog_compare_file_str);
															break;

						default:								gtk_clist_set_compare_func ( clist, NULL);
															break;
					}
				}
			}
		}

		result = 0;
	}

	return result;
}


gboolean gw_notebook_catalog_column_sort ( GtkCList *clist, gint column, gpointer data)
{
	gboolean result = FALSE;


#ifdef GW_DEBUG_GUI_CALLBACK_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s() : column=%d data=%d\n", __FILE__, __LINE__, __PRETTY_FUNCTION__, column, GPOINTER_TO_INT ( data));
#endif

	if ( clist != NULL )
	{
		if ( GPOINTER_TO_INT ( data) != -1 )
		{
			if ( column == clist->sort_column )
			{
				if ( clist->sort_type == GTK_SORT_ASCENDING )
				{
					clist->sort_type = GTK_SORT_DESCENDING;
				}
				else
				{
					clist->sort_type = GTK_SORT_ASCENDING;
				}
			}
			else
			{
				gtk_clist_set_sort_column ( clist, column);
			}
		}

		gw_notebook_catalog_set_column_sort ( clist, column);

		if ( GPOINTER_TO_INT ( data) != -1 )
		{
		gtk_clist_sort ( clist);
		}

		result = TRUE;
	}

	return result;
}


gboolean gw_notebook_catalog_clist_button_press_event ( GtkWidget *w, GdkEventButton *event)
{
	GtkCList *clist_info = NULL;
	GtkCTreeNode *selection = NULL, *node = NULL, *child = NULL;
	struct disk_info *disk_info = NULL;
	struct file_info *file_info = NULL;
	GdkEventButton *bev = ( GdkEventButton *)event;
	gint row,col;
	GtkWindow *window = NULL;
	GtkCTree *ctree = NULL;
	GtkCTreeNode *root = NULL;
	gchar *tmp_date = NULL;


#ifdef GW_DEBUG_GUI_CALLBACK_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	/* Gets all needs references. */
	window = gw_gui_manager_main_interface_get_main_window ( );
	ctree = gw_gui_manager_main_interface_get_tree ( );
	root = gw_gui_manager_main_interface_get_tree_root ( );
	clist_info = gw_notebook_catalog_get_clist_explorer ( window);

	if ( root == NULL )
	{
		/* If no one opened catalog. */
		return FALSE;
	}

	/* Ignores clicks on scrollbars. */
	if ( event->window != GTK_CLIST ( clist_info)->clist_window )
	{
		return FALSE;
	}

	/* Gets the selected item in the tree. */
	selection = GTK_CTREE_NODE ( GTK_CLIST ( ctree)->selection->data);

	/* Gets the selected item in the list. */
	gtk_clist_get_selection_info ( clist_info, event->x, event->y, &row, &col);

	/* Stops the signal during the process. */
	/* If uncomment this line, the item will not be selected.
	gtk_signal_emit_stop_by_name ( GTK_OBJECT ( clist_info), "button_press_event");
	*/

	/* Checks if it's a double click. */
	if ( event->type == GDK_2BUTTON_PRESS )
	{
#ifdef GW_DEBUG_GUI_CALLBACK_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s() : user make a double click\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

		/* If it's a double click. */
		if ( event->button == 1 )
		{
#ifdef GW_DEBUG_GUI_CALLBACK_COMPONENT
			g_print ( "*** GW - %s (%d) :: %s() : user make a left double click\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

			/* If it's a double left click. */

			/* To prevent that double click generates a signal in excess. */
			gdk_event_get ( );

			if ( GTK_CTREE_ROW ( selection)->parent == NULL )
			{
				/* User is in the catalog : he clicked on a disk. */

				/* Gets informations attached to the line. */
				if ( (disk_info = (struct disk_info*)gtk_clist_get_row_data ( clist_info, row)) == NULL )
				{
					/* If user clicked in empty space. */

					return TRUE;
				}
				else
				{
					/* Else if user clicked on a disk. */

					if ( !GTK_CTREE_ROW ( selection)->expanded )
					{
						gtk_ctree_expand ( ctree, selection);
					}

					/* Searches in the tree where is the selected disk. */
					child = GTK_CTREE_ROW ( selection)->children;
					while ( child != NULL )
					{
						if ( strcmp ( disk_info_get_name ( disk_data_get_info ( gtk_ctree_node_get_row_data ( ctree, child))), disk_info_get_name ( disk_info)) == 0 )
						{
							gtk_ctree_select ( ctree, child);

							return TRUE;
						}

						child = GTK_CTREE_NODE_NEXT( child);
					}

					return TRUE;
				}
			}
			else
			{
				/* Else if user clicked on a folder or a file. */

				/* Gets informations attached to the line. */
				if ( (file_info = (struct file_info*)gtk_clist_get_row_data ( clist_info, row)) == NULL )
				{
					/* If user clicked in empty space. */

					return TRUE;
				}
				else
				{
					/* Else if user clicked on an item. */

					if ( file_info_get_isdirectory ( file_info) )
					{
						/* If it's a folder. */

						if ( (strlen ( file_info_get_name ( file_info)) == 2) && (strncmp ( file_info_get_name ( file_info), "..", 2) == 0) )
						{
							/* If it's the parent folder. */

							child = GTK_CTREE_ROW ( selection)->parent;

							if ( child != root )
							{
								gtk_ctree_select ( ctree, child);
							}

							return TRUE;
						}
						else
						{
							/* Else if it's an unspecified folder. */

							if ( !GTK_CTREE_ROW ( selection)->expanded )
							{
								gtk_ctree_expand ( ctree, selection);
							}

							/* Searches in the tree where is the selected folder. */
							child = GTK_CTREE_ROW ( selection)->children;
							while ( child != NULL )
							{
								if ( strcmp ( file_info_get_name ( dir_data_get_info ( gtk_ctree_node_get_row_data ( ctree, child))), file_info_get_name ( file_info)) == 0 )
								{
									gtk_ctree_select ( ctree, child);

									return TRUE;
								}

								child = GTK_CTREE_NODE_NEXT ( child);
							}

							return TRUE;
						}
					}
					else
					{
						/* If it's a file. */
						tmp_date = file_info_get_cdate_to_gchar ( file_info);
						gw_status_bar_put_msg_file ( window,
									file_info_get_name ( file_info),
									file_info_get_size ( file_info),
									tmp_date,
									1);
						g_free ( tmp_date);

						return TRUE;
					}
				}
			}
		}
	}
	else { if ( event->type == GDK_BUTTON_PRESS )
	{
#ifdef GW_DEBUG_GUI_CALLBACK_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s() : user make a single click\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

		/* If it's a single click. */
		if ( event->button == 1 )
		{
#ifdef GW_DEBUG_GUI_CALLBACK_COMPONENT
			g_print ( "*** GW - %s (%d) :: %s() : user make a left single click\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

			if ( GTK_CTREE_ROW ( selection)->parent == NULL )
			{
				/* User is in the catalog : he clicked on a disk. */

				/* Gets informations attached to the line. */
				if ( (disk_info = (struct disk_info*)gtk_clist_get_row_data ( clist_info, row)) == NULL )
				{
					/* If user clicked on a empty space. */

					return TRUE;
				}
				else
				{
					/* Else if user clicked on a disk. */

					/* Searches in the tree the selected disk. */
					node = gw_notebook_catalog_ctree_node_get_child ( GTK_CTREE_NODE ( GTK_CLIST ( ctree)->selection->data), disk_info_get_name ( disk_info));
					disk_info = disk_data_get_info ( gtk_ctree_node_get_row_data ( ctree, node));

					/* Updates the status bar. */
					gw_status_bar_put_msg_disk ( window,
								disk_info_get_name ( disk_info),
								disk_info_get_type ( disk_info),
								disk_info_get_capacity ( disk_info),
								disk_info_get_free ( disk_info),
								(long double)disk_info_get_full ( disk_info),
								0);

					return TRUE;
				}
			}
			else
			{
				/* If user clicked on a folder or a file. */

				/* Gets informations attached to the line. */
				if ( (file_info = (struct file_info*)gtk_clist_get_row_data ( GTK_CLIST( clist_info), row)) == NULL )
				{
					/* User clicked on a empty space. */

					return TRUE;
				}
				else
				{
					/* If user clicked on an item. */

					if ( file_info_get_isdirectory ( file_info) )
					{
						/* If it's a folder. */

						if ( (strlen ( file_info_get_name ( file_info)) == 2) && (strncmp ( file_info_get_name ( file_info), "..", 2) == 0) )
						{
							/* If it's the parent folder. */

							/* Updates the status bar. */
							tmp_date = file_info_get_cdate_to_gchar ( file_info);
							gw_status_bar_put_msg_file ( window,
										file_info_get_name ( file_info),
										file_info_get_size ( file_info),
										tmp_date,
										1);
							g_free ( tmp_date);
							/* Must return FALSE to show the selected item with GTK+ 2.x (with bleu background) */

							return FALSE;
						}
						else
						{
							/* If it's an unspecified folder. */

							/* Searches in the tree where is the selected folder. */
							node = gw_notebook_catalog_ctree_node_get_child ( GTK_CTREE_NODE ( GTK_CLIST ( ctree)->selection->data), file_info_get_name ( file_info));
							file_info = dir_data_get_info ( gtk_ctree_node_get_row_data ( ctree, node));

							/* Updates the status bar. */
							gw_status_bar_put_msg_dir ( window,
										file_info_get_name ( file_info),
										file_info_get_size ( file_info),
										dir_data_get_num_file ( gtk_ctree_node_get_row_data ( ctree, node)) - 1,
										gw_notebook_catalog_ctree_node_get_num_children ( node),
										0);
							/* Must return FALSE to show the selected item with GTK+ 2.x (with bleu background) */

							return FALSE;
						}
					}
					else
					{
						/* If it's a file. */

						/* Updates a the status bar. */
						tmp_date = file_info_get_cdate_to_gchar ( file_info);
						gw_status_bar_put_msg_file ( window,
									file_info_get_name ( file_info),
									file_info_get_size ( file_info),
									tmp_date,
									1);
						g_free ( tmp_date);

						return FALSE;
					}
				}
			}
		}
		else { if ( event->button == 3 )
		{
#ifdef GW_DEBUG_GUI_CALLBACK_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s() : user make a right single click\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

			/* If it's a right click : displays the popup menu. */


			if ( GTK_CTREE_ROW ( selection)->parent == NULL )
			{
				/* User is in the catalog : he clicked on a disk. */

				/* Gets informations attached to the line. */
				if ( (disk_info = (struct disk_info*)gtk_clist_get_row_data ( clist_info, row)) == NULL )
				{
					/* User clicked on empty space. */

					return TRUE;
				}
				else
				{
					/* Else if user clicked on a disk. */

					/* Searches in the tree where is the selected disk. */
					node = gw_notebook_catalog_ctree_node_get_child ( GTK_CTREE_NODE( GTK_CLIST( ctree)->selection->data), disk_info_get_name ( disk_info));

					/* Displays the popup menu. */
					gtk_menu_popup ( gw_menu_popup_disk_create_and_show ( node, window), NULL, NULL, NULL, NULL, bev->button, bev->time);

					return TRUE;
				}
			}
			else
			{
				/* User clicked on a folder or a file. */

				/* Gets informations attached to the line. */
				if ( (file_info = (struct file_info*)gtk_clist_get_row_data ( GTK_CLIST( clist_info), row)) == NULL )
				{
					/* If user clicked on empty space. */

					return TRUE;
				}
				else
				{
					/* Else if user clicked on an item. */

					if ( file_info_get_isdirectory ( file_info) )
					{
						/* If it's a folder. */

						if ( (strlen ( file_info_get_name ( file_info)) == 2) && (strncmp ( file_info_get_name ( file_info), "..", 2) == 0) )
						{
							/* If it's the parent folder. */

							return TRUE;
						}
						else
						{
							/* Else if it's an unspecified folder. */

							/* Searches in the tree where is the selected folder. */
							node = gw_notebook_catalog_ctree_node_get_child ( GTK_CTREE_NODE ( GTK_CLIST ( ctree)->selection->data), file_info_get_name ( file_info));

							/* Displays the popup menu. */
							gtk_menu_popup ( gw_menu_popup_dir_create_and_show ( node, window), NULL, NULL, NULL, NULL, bev->button, bev->time);

							return TRUE;
						}
					}
					else
					{
						/* If it's a file which is selected. */

						/* Displays the popup menu. */
						gtk_menu_popup ( gw_menu_popup_file_create_and_show ( GINT_TO_POINTER ( row), window), NULL, NULL, NULL, NULL, bev->button, bev->time);

						return TRUE;
					}
				}
			}
		}}
	}}

	return FALSE;
}


gint gw_notebook_catalog_clist_column_resized ( GtkCList *clist, gint column, gint width, gpointer user_data)
{
	GtkCTreeNode *root = gw_gui_manager_main_interface_get_tree_root ( );
	GtkCTree *ctree = NULL;
	GtkCTreeNode *selection = NULL;
	gint result = -1;
	gint autoresize = -1;


#ifdef GW_DEBUG_GUI_CALLBACK_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( (root!=NULL) && (clist!=NULL) && (column>-1) )
	{
		if ( (autoresize = gw_application_manager_get_settings_tol ( GW_VALUE_APP_EXPLORER_COLUMN_AUTORESIZE)) == -1 )
		{
			autoresize = GW_VALUE_APP_EXPLORER_COLUMN_AUTORESIZE_DEFAULT;
		}

		/* Saves the column width only if the autoresize mode is desactivated. */
		if ( autoresize == FALSE )
		{
			/* Gets the selected item in the tree. */
			if ( (ctree = gw_gui_manager_main_interface_get_tree ( )) != NULL )
			{
				if ( (GTK_CLIST ( ctree)->selection != NULL) && ((selection = GTK_CTREE_NODE ( GTK_CLIST ( ctree)->selection->data)) != NULL) )
				{
					if ( GTK_CTREE_ROW ( selection)->parent == NULL )
					{
						/* User is in the catalog : this is a list of disks. */
						switch ( column)
						{
							case GW_VALUE_APP_EXPLORER_DISK_COLUMN_NAME_POSITION_DEFAULT:		gw_application_manager_set_settings ( GW_VALUE_APP_EXPLORER_DISK_COLUMN_NAME_SIZE, g_strdup_printf ( "%d", width));
																break;

							case GW_VALUE_APP_EXPLORER_DISK_COLUMN_FSNAME_POSITION_DEFAULT:		gw_application_manager_set_settings ( GW_VALUE_APP_EXPLORER_DISK_COLUMN_FSNAME_SIZE, g_strdup_printf ( "%d", width));
																break;

							case GW_VALUE_APP_EXPLORER_DISK_COLUMN_PATH_POSITION_DEFAULT:		gw_application_manager_set_settings ( GW_VALUE_APP_EXPLORER_DISK_COLUMN_PATH_SIZE, g_strdup_printf ( "%d", width));
																break;

							case GW_VALUE_APP_EXPLORER_DISK_COLUMN_NBARCHIVE_POSITION_DEFAULT:	gw_application_manager_set_settings ( GW_VALUE_APP_EXPLORER_DISK_COLUMN_NBARCHIVE_SIZE, g_strdup_printf ( "%d", width));
																break;

							case GW_VALUE_APP_EXPLORER_DISK_COLUMN_TYPE_POSITION_DEFAULT:		gw_application_manager_set_settings ( GW_VALUE_APP_EXPLORER_DISK_COLUMN_TYPE_SIZE, g_strdup_printf ( "%d", width));
																break;

							case GW_VALUE_APP_EXPLORER_DISK_COLUMN_VOLUME_POSITION_DEFAULT:		gw_application_manager_set_settings ( GW_VALUE_APP_EXPLORER_DISK_COLUMN_VOLUME_SIZE, g_strdup_printf ( "%d", width));
																break;

							case GW_VALUE_APP_EXPLORER_DISK_COLUMN_CAPACITY_POSITION_DEFAULT:	gw_application_manager_set_settings ( GW_VALUE_APP_EXPLORER_DISK_COLUMN_CAPACITY_SIZE, g_strdup_printf ( "%d", width));
																break;

							case GW_VALUE_APP_EXPLORER_DISK_COLUMN_FREE_POSITION_DEFAULT:		gw_application_manager_set_settings ( GW_VALUE_APP_EXPLORER_DISK_COLUMN_FREE_SIZE, g_strdup_printf ( "%d", width));
																break;

							case GW_VALUE_APP_EXPLORER_DISK_COLUMN_DATE_POSITION_DEFAULT:		gw_application_manager_set_settings ( GW_VALUE_APP_EXPLORER_DISK_COLUMN_DATE_SIZE, g_strdup_printf ( "%d", width));
																break;

							case GW_VALUE_APP_EXPLORER_DISK_COLUMN_SERIAL_POSITION_DEFAULT:		gw_application_manager_set_settings ( GW_VALUE_APP_EXPLORER_DISK_COLUMN_SERIAL_SIZE, g_strdup_printf ( "%d", width));
																break;

							case GW_VALUE_APP_EXPLORER_DISK_COLUMN_CATEGORY_POSITION_DEFAULT:	gw_application_manager_set_settings ( GW_VALUE_APP_EXPLORER_DISK_COLUMN_CATEGORY_SIZE, g_strdup_printf ( "%d", width));
																break;

							case GW_VALUE_APP_EXPLORER_DISK_COLUMN_DESCRIPTION_POSITION_DEFAULT:	gw_application_manager_set_settings ( GW_VALUE_APP_EXPLORER_DISK_COLUMN_DESCRIPTION_SIZE, g_strdup_printf ( "%d", width));
																break;

							default:								break;
						}

						result = 0;
					}
					else
					{
						/* User is in a disk or a folder : this is a list of files. */
						switch ( column)
						{
							case GW_VALUE_APP_EXPLORER_FILE_COLUMN_NAME_POSITION_DEFAULT:		gw_application_manager_set_settings ( GW_VALUE_APP_EXPLORER_FILE_COLUMN_NAME_SIZE, g_strdup_printf ( "%d", width));
																break;

							case GW_VALUE_APP_EXPLORER_FILE_COLUMN_RIGHTS_POSITION_DEFAULT:		gw_application_manager_set_settings ( GW_VALUE_APP_EXPLORER_FILE_COLUMN_RIGHTS_SIZE, g_strdup_printf ( "%d", width));
																break;

							case GW_VALUE_APP_EXPLORER_FILE_COLUMN_OWNER_POSITION_DEFAULT:		gw_application_manager_set_settings ( GW_VALUE_APP_EXPLORER_FILE_COLUMN_OWNER_SIZE, g_strdup_printf ( "%d", width));
																break;

							case GW_VALUE_APP_EXPLORER_FILE_COLUMN_GROUP_POSITION_DEFAULT:		gw_application_manager_set_settings ( GW_VALUE_APP_EXPLORER_FILE_COLUMN_GROUP_SIZE, g_strdup_printf ( "%d", width));
																break;

							case GW_VALUE_APP_EXPLORER_FILE_COLUMN_SIZE_POSITION_DEFAULT:		gw_application_manager_set_settings ( GW_VALUE_APP_EXPLORER_FILE_COLUMN_SIZE_SIZE, g_strdup_printf ( "%d", width));
																break;

							case GW_VALUE_APP_EXPLORER_FILE_COLUMN_INODE_POSITION_DEFAULT:		gw_application_manager_set_settings ( GW_VALUE_APP_EXPLORER_FILE_COLUMN_INODE_SIZE, g_strdup_printf ( "%d", width));
																break;

							case GW_VALUE_APP_EXPLORER_FILE_COLUMN_ADATE_POSITION_DEFAULT:		gw_application_manager_set_settings ( GW_VALUE_APP_EXPLORER_FILE_COLUMN_ADATE_SIZE, g_strdup_printf ( "%d", width));
																break;

							case GW_VALUE_APP_EXPLORER_FILE_COLUMN_CDATE_POSITION_DEFAULT:		gw_application_manager_set_settings ( GW_VALUE_APP_EXPLORER_FILE_COLUMN_CDATE_SIZE, g_strdup_printf ( "%d", width));
																break;

							case GW_VALUE_APP_EXPLORER_FILE_COLUMN_MDATE_POSITION_DEFAULT:		gw_application_manager_set_settings ( GW_VALUE_APP_EXPLORER_FILE_COLUMN_MDATE_SIZE, g_strdup_printf ( "%d", width));
																break;

							case GW_VALUE_APP_EXPLORER_FILE_COLUMN_CATEGORY_POSITION_DEFAULT:	gw_application_manager_set_settings ( GW_VALUE_APP_EXPLORER_FILE_COLUMN_CATEGORY_SIZE, g_strdup_printf ( "%d", width));
																break;

							case GW_VALUE_APP_EXPLORER_FILE_COLUMN_DESCRIPTION_POSITION_DEFAULT:	gw_application_manager_set_settings ( GW_VALUE_APP_EXPLORER_FILE_COLUMN_DESCRIPTION_SIZE, g_strdup_printf ( "%d", width));
																break;

							default:								break;
						}

						result = 0;
					}
				}
				else
				{
				}
			}
			else
			{
			}
		}
	}

	return result;
}


gboolean gw_notebook_catalog_ctree_button_press_event ( GtkWidget *w, GdkEventButton *event)
{
	GtkCList *clist;
	GtkCTreeNode *node;
	gint row, col;
	GdkEventButton *bev = NULL;
	GtkCTree *ctree = NULL;
	GtkWindow *window = NULL;


#ifdef GW_DEBUG_GUI_CALLBACK_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	bev = ( GdkEventButton *)event;
	ctree = gw_gui_manager_main_interface_get_tree ( );
	window = gw_gui_manager_main_interface_get_main_window ( );
	clist = GTK_CLIST ( w);

	/* Ignores clicks on scrollbars. */
	if ( event->window != GTK_CLIST ( clist)->clist_window )
	{
		return TRUE;
	}

	gtk_clist_get_selection_info ( GTK_CLIST ( clist), event->x, event->y, &row, &col);
	node = GTK_CTREE_NODE ( g_list_nth ( clist->row_list, row));

	/* Stops the signal during the process, except for single left click in order expand or
	   collapse node with click on the cross node. */
	if ( !((event->type == GDK_BUTTON_PRESS) && (event->button == 1)) )
	{
		gtk_signal_emit_stop_by_name ( GTK_OBJECT ( ctree), "button_press_event");
	}

	/* Checks if it's a double click. */
	if ( event->type == GDK_2BUTTON_PRESS )
	{
		/* Checks if it's a left click. */
		if ( event->button == 1 )
		{
			/* Prevents from double click to generate too many signals. */
			gdk_event_get ( );

			/* Checks if user didn't click in the empty space. */
			if ( node != NULL )
			{
				/* Opens or closes the node. */
				if ( GTK_CTREE_ROW ( node)->expanded )
				{
					gtk_ctree_collapse ( ctree, node);
				}
				else
				{
					gtk_ctree_expand ( ctree, node);
				}

				gtk_ctree_select ( ctree, node);
			}

			return TRUE;
		}
	}
	/* Checks if it's a single click. */
	else { if ( event->type == GDK_BUTTON_PRESS )
	{
		/* Checks if it's a left click. */
		if ( event->button == 1 )
		{
			if ( node != NULL )
			{
				/* If user didn't click in the empty space : select the row. */
				gtk_ctree_select ( ctree, node);
			}

			return FALSE;
		}
		/* Checks if it's a right click. */
		else { if ( event->button == 3 )
		{
			/* Displays the popup menu. */
			if ( node == NULL )
			{
				/* If user clicked in the empty space. */
				gtk_menu_popup ( gw_menu_popup_create_and_show ( window), NULL, NULL, NULL, NULL, bev->button, bev->time);

				return TRUE;
			}
			else
			{
				/* Selects the item for more user visibility. */
				gtk_ctree_select ( ctree, node);
				gw_gui_manager_main_interface_refresh ( );

				if ( GTK_CTREE_ROW ( node)->parent == NULL )
				{
					/* If user clicked on a catalog. */
					gtk_menu_popup ( gw_menu_popup_catalog_create_and_show ( node, window), NULL, NULL, NULL, NULL, bev->button, bev->time);

					return TRUE;
				}
				else { if ( GTK_CTREE_ROW ( GTK_CTREE_ROW ( node)->parent)->parent == NULL )
				{
					/* If user clicked on a disk. */
					gtk_menu_popup ( gw_menu_popup_disk_create_and_show ( node, window), NULL, NULL, NULL, NULL, bev->button, bev->time);

					return TRUE;
				}
				else
				{
					/* If user clicked on a folder. */
					gtk_menu_popup ( gw_menu_popup_dir_create_and_show ( node, window), NULL, NULL, NULL, NULL, bev->button, bev->time);

					return TRUE;
				}}
			}

			return TRUE;
		}}
	}}

	return FALSE;
}


gboolean gw_notebook_catalog_ctree_select_row ( GtkCTree *ctree, GtkCTreeNode *node, gint column, gpointer g)
{
        GtkCList *clist_info = NULL;
        struct disk_info *disk_info = NULL;
        gchar *info[12];
        gint i, row, compt = 0, compt_file = 0;
        double size = 0;
        GtkCTreeNode *tmp = NULL;
        struct file_info *file_info = NULL;
        struct dir_data *dir_data = NULL;
        struct disk_data *disk_data = NULL;
        GList *files_data = NULL;
        GtkWindow *window = NULL;
        GtkCTreeNode *root = NULL;
        gchar *text_utf8 = NULL;
        gchar *tmp_date = NULL;


#ifdef GW_DEBUG_GUI_CALLBACK_COMPONENT
        g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

        window = gw_gui_manager_main_interface_get_main_window ( );
        root = gw_gui_manager_main_interface_get_tree_root ( );
        clist_info = gw_notebook_catalog_get_clist_explorer ( window);

        /* Stop the signal during the process. */
        gtk_signal_emit_stop_by_name ( GTK_OBJECT ( ctree), "tree_select_row");

        /* Freezes informations table */
        gtk_clist_freeze ( clist_info);
        gtk_clist_clear ( clist_info);

        /* Updates list */
#ifdef GW_DEBUG_GUI_CALLBACK_COMPONENT
        g_print ( "*** GW - %s (%d) :: %s() : updates list\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

        if ( node == root )
        {
#ifdef GW_DEBUG_GUI_CALLBACK_COMPONENT
                g_print ( "*** GW - %s (%d) :: %s() : catalog selected\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

                /* If a catalog is selected, must to display disk list */
                gw_notebook_catalog_clist_explorer_set_column_title_disk ( );
                node = GTK_CTREE_ROW ( GTK_CTREE_NODE ( GTK_CLIST ( ctree)->selection->data))->children;

                while ( node != NULL )
                {
                        compt++;
						disk_info = disk_data_get_info ( gtk_ctree_node_get_row_data ( ctree, node));
						size = size + disk_info_get_full ( disk_info);

                        g_strdup_to_gtk_text ( disk_info_get_name ( disk_info), info[GW_VALUE_APP_EXPLORER_DISK_COLUMN_NAME_POSITION_DEFAULT]);
                        g_strdup_to_gtk_text ( disk_info_get_fsname ( disk_info), info[GW_VALUE_APP_EXPLORER_DISK_COLUMN_FSNAME_POSITION_DEFAULT]);
                        g_strdup_to_gtk_text ( disk_info_get_dir ( disk_info), info[GW_VALUE_APP_EXPLORER_DISK_COLUMN_PATH_POSITION_DEFAULT]);
                        text_utf8 = g_strdup_printf ( "%d", disk_info_get_num ( disk_info));
                        g_strdup_to_gtk_text ( text_utf8, info[GW_VALUE_APP_EXPLORER_DISK_COLUMN_NBARCHIVE_POSITION_DEFAULT]);
                        g_free ( text_utf8);
                        g_strdup_to_gtk_text ( disk_info_get_type ( disk_info), info[GW_VALUE_APP_EXPLORER_DISK_COLUMN_TYPE_POSITION_DEFAULT]);
                        g_strdup_to_gtk_text ( disk_info_get_volume ( disk_info), info[GW_VALUE_APP_EXPLORER_DISK_COLUMN_VOLUME_POSITION_DEFAULT]);
                        text_utf8 = gw_ui64_byte_to_str_format ( disk_info_get_capacity ( disk_info));
                        g_strdup_to_gtk_text ( text_utf8, info[GW_VALUE_APP_EXPLORER_DISK_COLUMN_CAPACITY_POSITION_DEFAULT]);
                        g_free ( text_utf8);
                        text_utf8 = gw_ui64_byte_to_str_format ( disk_info_get_free ( disk_info));
                        g_strdup_to_gtk_text ( text_utf8, info[GW_VALUE_APP_EXPLORER_DISK_COLUMN_FREE_POSITION_DEFAULT]);
                        g_free ( text_utf8);
                        tmp_date = disk_info_get_date_to_gchar ( disk_info);
                        g_strdup_to_gtk_text ( tmp_date, info[GW_VALUE_APP_EXPLORER_DISK_COLUMN_DATE_POSITION_DEFAULT]);
                        g_free ( tmp_date);
                        g_strdup_to_gtk_text ( disk_info_get_serial ( disk_info), info[GW_VALUE_APP_EXPLORER_DISK_COLUMN_SERIAL_POSITION_DEFAULT]);
                        g_strdup_to_gtk_text ( disk_info_get_category_name ( disk_info), info[GW_VALUE_APP_EXPLORER_DISK_COLUMN_CATEGORY_POSITION_DEFAULT]);
                        g_strdup_to_gtk_text ( disk_info_get_description ( disk_info), info[GW_VALUE_APP_EXPLORER_DISK_COLUMN_DESCRIPTION_POSITION_DEFAULT]);
                        gw_str_replace_char ( info[GW_VALUE_APP_EXPLORER_DISK_COLUMN_DESCRIPTION_POSITION_DEFAULT], '\n', ' ');

                        row = gtk_clist_append ( clist_info, info);

                        /* Note that doesn't give the data destroy function, because that will destroy the database. */
                        gtk_clist_set_row_data_full ( clist_info, row, disk_info, NULL);
                        gtk_clist_set_pixtext ( clist_info, row, 0, info[0], 5, disk_info_get_pixmap ( disk_info), disk_info_get_bitmap ( disk_info));

                        /* Frees memory used by info. */
                        for ( i = 0; i < 11; i++)
                        {
                                g_free ( info[i]);
                        }

                        node = GTK_CTREE_ROW ( node)->sibling;
                }

                /* Displays in the status bar the informations about the selected item. */
                gw_status_bar_put_msg_catalog ( window, ctree, root, compt, size);

                /* Updates the list of disk. */
		gtk_clist_sort ( clist_info);
                gtk_clist_thaw ( clist_info);

		return TRUE;
        }
        else { if ( GTK_CTREE_ROW ( node)->parent == root )
        {
#ifdef GW_DEBUG_GUI_CALLBACK_COMPONENT
                g_print ( "*** GW - %s (%d) :: %s() : disk selected\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

                /* If a disk is selected, must to display folders and files list */
                gw_notebook_catalog_clist_explorer_set_column_title_file ( );
                tmp = node;

                /* Folders displaying. */
                node = GTK_CTREE_ROW ( node)->children;
                while ( node != NULL )
                {
                        compt++;
                        file_info = dir_data_get_info ( gtk_ctree_node_get_row_data ( ctree, node));
                        size = size + file_info_get_size ( file_info);
                        g_strdup_to_gtk_text ( file_info_get_name ( file_info), info[GW_VALUE_APP_EXPLORER_FILE_COLUMN_NAME_POSITION_DEFAULT]);
			tmp_date = file_info_get_rights_to_gchar ( file_info);
                        g_strdup_to_gtk_text ( tmp_date, info[GW_VALUE_APP_EXPLORER_FILE_COLUMN_RIGHTS_POSITION_DEFAULT]);
			g_free ( tmp_date);
                        if ( strlen ( file_info_get_owner ( file_info)) != 0 )
                        {
                                g_strdup_to_gtk_text ( file_info_get_owner ( file_info), info[GW_VALUE_APP_EXPLORER_FILE_COLUMN_OWNER_POSITION_DEFAULT]);
                        }
                        else
                        {
                                g_strdup_to_gtk_text ( _( "unknown owner"), info[GW_VALUE_APP_EXPLORER_FILE_COLUMN_OWNER_POSITION_DEFAULT]);
                        }
                        if ( strlen ( file_info_get_group ( file_info)) != 0 )
                        {
                                g_strdup_to_gtk_text ( file_info_get_group ( file_info), info[GW_VALUE_APP_EXPLORER_FILE_COLUMN_GROUP_POSITION_DEFAULT]);
                        }
                        else
                        {
                                g_strdup_to_gtk_text ( _( "unknown group"), info[GW_VALUE_APP_EXPLORER_FILE_COLUMN_GROUP_POSITION_DEFAULT]);
                        }
                        text_utf8 = gw_ui64_byte_to_str_format ( file_info_get_size ( file_info));
                        g_strdup_to_gtk_text ( text_utf8, info[GW_VALUE_APP_EXPLORER_FILE_COLUMN_SIZE_POSITION_DEFAULT]);
                        g_free ( text_utf8);
                        text_utf8 = g_strdup_printf ( "%ld", file_info_get_inode ( file_info));
                        g_strdup_to_gtk_text ( text_utf8, info[GW_VALUE_APP_EXPLORER_FILE_COLUMN_INODE_POSITION_DEFAULT]);
                        g_free ( text_utf8);
                        tmp_date = file_info_get_cdate_to_gchar ( file_info);
                        g_strdup_to_gtk_text ( tmp_date, info[GW_VALUE_APP_EXPLORER_FILE_COLUMN_CDATE_POSITION_DEFAULT]);
                        g_free ( tmp_date);
                        tmp_date = file_info_get_mdate_to_gchar ( file_info);
                        g_strdup_to_gtk_text ( tmp_date, info[GW_VALUE_APP_EXPLORER_FILE_COLUMN_MDATE_POSITION_DEFAULT]);
                        g_free ( tmp_date);
                        tmp_date = file_info_get_adate_to_gchar ( file_info);
                        g_strdup_to_gtk_text ( tmp_date, info[GW_VALUE_APP_EXPLORER_FILE_COLUMN_ADATE_POSITION_DEFAULT]);
                        g_free ( tmp_date);
                        g_strdup_to_gtk_text ( file_info_get_category_name ( file_info), info[GW_VALUE_APP_EXPLORER_FILE_COLUMN_CATEGORY_POSITION_DEFAULT]);
                        g_strdup_to_gtk_text ( file_info_get_description ( file_info), info[GW_VALUE_APP_EXPLORER_FILE_COLUMN_DESCRIPTION_POSITION_DEFAULT]);
                        gw_str_replace_char ( info[GW_VALUE_APP_EXPLORER_FILE_COLUMN_DESCRIPTION_POSITION_DEFAULT], '\n', ' ');
                        g_strdup_to_gtk_text ( NULL, info[11]);

                        row = gtk_clist_append ( clist_info, info);

                        /* Note that doesn't give the data destroy function, because that will destroy the database. */
                        gtk_clist_set_row_data_full ( clist_info, row, file_info, NULL);
			if ( dir_data_get_num_file ( gtk_ctree_node_get_row_data ( ctree, node))==0 && GTK_CTREE_ROW ( node)->children==NULL) {
                        	gtk_clist_set_pixtext ( clist_info, row, 0, info[GW_VALUE_APP_EXPLORER_FILE_COLUMN_NAME_POSITION_DEFAULT], 5, PixLockedFolder, MskLockedFolder);
			} else {
                        	gtk_clist_set_pixtext ( clist_info, row, 0, info[GW_VALUE_APP_EXPLORER_FILE_COLUMN_NAME_POSITION_DEFAULT], 5, PixFolder, MskFolder);
			}

                        /* Frees memory used by info. */
                        for ( i = 0; i < 11; i++)
                        {
                                g_free ( info[i]);
                        }

                        node = GTK_CTREE_ROW ( node)->sibling;
                }

                /* Files displaying. */
                node = tmp;
                disk_data = gtk_ctree_node_get_row_data ( ctree, node);
                files_data = g_list_first ( disk_data_get_child ( disk_data));

                if ( files_data != NULL)
                {
                	/* Warning : on win32 systems, there's no "." and ".." files. */

			/* Skips the file which should be the "." file. */
			if ( (file_info_get_name ( files_data->data) != NULL) && (strcmp ( file_info_get_name ( files_data->data), ".") == 0) )
			{
				files_data = g_list_next ( files_data);
			}

                        do
                        {
                                compt++;
                                compt_file++;
                                size = size + file_info_get_size ( files_data->data);
                                g_strdup_to_gtk_text ( file_info_get_name ( files_data->data), info[GW_VALUE_APP_EXPLORER_FILE_COLUMN_NAME_POSITION_DEFAULT]);
								tmp_date = file_info_get_rights_to_gchar ( files_data->data);
                                g_strdup_to_gtk_text ( tmp_date, info[GW_VALUE_APP_EXPLORER_FILE_COLUMN_RIGHTS_POSITION_DEFAULT]);
								g_free ( tmp_date);
                                if ( strlen ( file_info_get_owner ( files_data->data)) != 0 )
                                {
                                        g_strdup_to_gtk_text ( file_info_get_owner ( files_data->data), info[GW_VALUE_APP_EXPLORER_FILE_COLUMN_OWNER_POSITION_DEFAULT]);
                                }
                                else
                                {
                                        g_strdup_to_gtk_text ( _ ( "unknown owner"), info[GW_VALUE_APP_EXPLORER_FILE_COLUMN_OWNER_POSITION_DEFAULT]);
                                }
                                if ( strlen ( file_info_get_group ( files_data->data)) != 0 )
                                {
                                        g_strdup_to_gtk_text ( file_info_get_group ( files_data->data), info[GW_VALUE_APP_EXPLORER_FILE_COLUMN_GROUP_POSITION_DEFAULT]);
                                }
                                else
                                {
                                        g_strdup_to_gtk_text ( _( "unknown group"), info[GW_VALUE_APP_EXPLORER_FILE_COLUMN_GROUP_POSITION_DEFAULT]);
                                }
                                text_utf8 = gw_ui64_byte_to_str_format ( file_info_get_size ( files_data->data));
                                g_strdup_to_gtk_text ( text_utf8, info[GW_VALUE_APP_EXPLORER_FILE_COLUMN_SIZE_POSITION_DEFAULT]);
                                g_free ( text_utf8);
                                text_utf8 = g_strdup_printf ( "%ld", file_info_get_inode ( files_data->data));
                                g_strdup_to_gtk_text ( text_utf8, info[GW_VALUE_APP_EXPLORER_FILE_COLUMN_INODE_POSITION_DEFAULT]);
                                g_free ( text_utf8);
                                tmp_date = file_info_get_cdate_to_gchar ( files_data->data);
                                g_strdup_to_gtk_text ( tmp_date, info[GW_VALUE_APP_EXPLORER_FILE_COLUMN_CDATE_POSITION_DEFAULT]);
                                g_free ( tmp_date);
                                tmp_date = file_info_get_mdate_to_gchar ( files_data->data);
                                g_strdup_to_gtk_text ( tmp_date, info[GW_VALUE_APP_EXPLORER_FILE_COLUMN_MDATE_POSITION_DEFAULT]);
                                g_free ( tmp_date);
                                tmp_date = file_info_get_adate_to_gchar ( files_data->data);
                                g_strdup_to_gtk_text ( tmp_date, info[GW_VALUE_APP_EXPLORER_FILE_COLUMN_ADATE_POSITION_DEFAULT]);
                                g_free ( tmp_date);
                                g_strdup_to_gtk_text ( file_info_get_category_name ( files_data->data), info[GW_VALUE_APP_EXPLORER_FILE_COLUMN_CATEGORY_POSITION_DEFAULT]);
                                g_strdup_to_gtk_text ( file_info_get_description ( files_data->data), info[GW_VALUE_APP_EXPLORER_FILE_COLUMN_DESCRIPTION_POSITION_DEFAULT]);
	                     		gw_str_replace_char ( info[GW_VALUE_APP_EXPLORER_FILE_COLUMN_DESCRIPTION_POSITION_DEFAULT], '\n', ' ');
                                g_strdup_to_gtk_text ( NULL, info[11]);

                                if ( (strlen ( file_info_get_name ( files_data->data)) == 2) && (strncmp ( file_info_get_name ( files_data->data), "..", 2) == 0) )
                                {
                                        row = gtk_clist_prepend ( clist_info, info);

                                        /* Note that doesn't give the data destroy function, because that will destroy the database. */
                                        gtk_clist_set_row_data_full ( clist_info, row, (struct file_info*)files_data->data, NULL);
                                        gtk_clist_set_pixtext ( clist_info, row, 0, info[GW_VALUE_APP_EXPLORER_FILE_COLUMN_NAME_POSITION_DEFAULT], 5, PixParentFolder, MskParentFolder);
                                }
                                else
                                {
                                        row = gtk_clist_append ( clist_info, info);

                                        /* Note that doesn't give the data destroy function, because that will destroy the database. */
                                        gtk_clist_set_row_data_full ( clist_info, row, (struct file_info*)files_data->data, NULL);
                                        gtk_clist_set_pixtext ( clist_info, row, 0, info[GW_VALUE_APP_EXPLORER_FILE_COLUMN_NAME_POSITION_DEFAULT], 5, PixFile, MskFile);
                                }

                                files_data = g_list_next ( files_data);

                                /* Frees memory used by info. */
                                for ( i = 0; i < 11; i++)
                                {
                                        g_free ( info[i]);
                                }
                        }
                        while ( files_data != g_list_first ( files_data));
                }

		if ( disk_data!=NULL) {
			/* Displays in the status bar the informations about the selected item. */
			gw_status_bar_put_msg_disk ( window,
						disk_info_get_name ( disk_data_get_info ( disk_data)),
						disk_info_get_type ( disk_data_get_info ( disk_data)),
						disk_info_get_capacity ( disk_data_get_info ( disk_data)),
						disk_info_get_free ( disk_data_get_info ( disk_data)),
						size,
						compt - 1);
		} else {
#ifdef GW_DEBUG_GUI_CALLBACK_COMPONENT
                	g_print ( "*** GW - %s (%d) :: %s() : warning!! disk_data\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif
		}

                /* Updates the list of folders and files. */
		gtk_clist_sort ( clist_info);
                gtk_clist_thaw ( clist_info);

                return TRUE;
        }
        else
        {
#ifdef GW_DEBUG_GUI_CALLBACK_COMPONENT
                g_print ( "*** GW - %s (%d) :: %s() : folder selected\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

                /* If a folder is selected, must to display folders and files list */
                gw_notebook_catalog_clist_explorer_set_column_title_file ( );
                tmp = node;

                /* Displays folders. */
                node = GTK_CTREE_ROW ( node)->children;
                while ( node != NULL )
                {
                        compt++;
                        file_info = dir_data_get_info ( gtk_ctree_node_get_row_data ( ctree, node));
                        size = size + file_info_get_size ( file_info);
                        g_strdup_to_gtk_text ( file_info_get_name ( file_info), info[GW_VALUE_APP_EXPLORER_FILE_COLUMN_NAME_POSITION_DEFAULT]);
			tmp_date = file_info_get_rights_to_gchar ( file_info);
                        g_strdup_to_gtk_text ( tmp_date, info[GW_VALUE_APP_EXPLORER_FILE_COLUMN_RIGHTS_POSITION_DEFAULT]);
			g_free ( tmp_date);
                        if ( strlen ( file_info_get_owner ( file_info)) != 0 )
                        {
                                g_strdup_to_gtk_text ( file_info_get_owner ( file_info), info[GW_VALUE_APP_EXPLORER_FILE_COLUMN_OWNER_POSITION_DEFAULT]);
                        }
                        else
                        {
                                g_strdup_to_gtk_text ( _ ( "unknown owner"), info[GW_VALUE_APP_EXPLORER_FILE_COLUMN_OWNER_POSITION_DEFAULT]);
                        }
                        if ( strlen ( file_info_get_group ( file_info)) != 0 )
                        {
                                g_strdup_to_gtk_text ( file_info_get_group ( file_info), info[GW_VALUE_APP_EXPLORER_FILE_COLUMN_GROUP_POSITION_DEFAULT]);
                        }
                        else
                        {
                                g_strdup_to_gtk_text ( _( "unknown group"), info[GW_VALUE_APP_EXPLORER_FILE_COLUMN_GROUP_POSITION_DEFAULT]);
                        }
                        text_utf8 = gw_ui64_byte_to_str_format ( file_info_get_size ( file_info));
                        g_strdup_to_gtk_text ( text_utf8, info[GW_VALUE_APP_EXPLORER_FILE_COLUMN_SIZE_POSITION_DEFAULT]);
                        g_free ( text_utf8);
                        text_utf8 = g_strdup_printf ( "%ld", file_info_get_inode ( file_info));
                        g_strdup_to_gtk_text ( text_utf8, info[GW_VALUE_APP_EXPLORER_FILE_COLUMN_INODE_POSITION_DEFAULT]);
                        g_free ( text_utf8);
                        tmp_date = file_info_get_cdate_to_gchar ( file_info);
                        g_strdup_to_gtk_text ( tmp_date, info[GW_VALUE_APP_EXPLORER_FILE_COLUMN_CDATE_POSITION_DEFAULT]);
                        g_free ( tmp_date);
                        tmp_date = file_info_get_mdate_to_gchar ( file_info);
                        g_strdup_to_gtk_text ( tmp_date, info[GW_VALUE_APP_EXPLORER_FILE_COLUMN_MDATE_POSITION_DEFAULT]);
                        g_free ( tmp_date);
                        tmp_date = file_info_get_adate_to_gchar ( file_info);
                        g_strdup_to_gtk_text ( tmp_date, info[GW_VALUE_APP_EXPLORER_FILE_COLUMN_ADATE_POSITION_DEFAULT]);
                        g_free ( tmp_date);
                        g_strdup_to_gtk_text ( file_info_get_category_name ( file_info), info[GW_VALUE_APP_EXPLORER_FILE_COLUMN_CATEGORY_POSITION_DEFAULT]);
                        g_strdup_to_gtk_text ( file_info_get_description ( file_info), info[GW_VALUE_APP_EXPLORER_FILE_COLUMN_DESCRIPTION_POSITION_DEFAULT]);
                        gw_str_replace_char ( info[GW_VALUE_APP_EXPLORER_FILE_COLUMN_DESCRIPTION_POSITION_DEFAULT], '\n', ' ');
                        g_strdup_to_gtk_text ( NULL, info[11]);

                        row = gtk_clist_append ( clist_info, info);

                        /* Note that doesn't give the data destroy function, because that will destroy the database. */
                        gtk_clist_set_row_data_full ( clist_info, row, file_info, NULL);
			if ( dir_data_get_num_file ( gtk_ctree_node_get_row_data ( ctree, node))==0 && GTK_CTREE_ROW ( node)->children==NULL) {
                        	gtk_clist_set_pixtext ( clist_info, row, 0, info[GW_VALUE_APP_EXPLORER_FILE_COLUMN_NAME_POSITION_DEFAULT], 5, PixLockedFolder, MskLockedFolder);
			} else {
                        	gtk_clist_set_pixtext ( clist_info, row, 0, info[GW_VALUE_APP_EXPLORER_FILE_COLUMN_NAME_POSITION_DEFAULT], 5, PixFolder, MskFolder);
			}

                        /* Frees memory used by info. */
                        for ( i = 0; i < 11; i++)
                        {
                                g_free ( info[i]);
                        }

                        node = GTK_CTREE_ROW ( node)->sibling;
                }

                /* Displays files */
                node = tmp;
                dir_data = gtk_ctree_node_get_row_data ( ctree, node);
                files_data = g_list_first ( dir_data_get_child ( dir_data));
                files_data = g_list_next ( files_data);

                while ( files_data != g_list_first ( files_data))
                {
                        compt++;
                        compt_file++;
                        size = size + file_info_get_size ( files_data->data);
                        g_strdup_to_gtk_text ( file_info_get_name ( files_data->data), info[GW_VALUE_APP_EXPLORER_FILE_COLUMN_NAME_POSITION_DEFAULT]);
						tmp_date = file_info_get_rights_to_gchar ( files_data->data);
                        g_strdup_to_gtk_text ( tmp_date, info[GW_VALUE_APP_EXPLORER_FILE_COLUMN_RIGHTS_POSITION_DEFAULT]);
						g_free ( tmp_date);
                        if ( strlen ( file_info_get_owner ( files_data->data)) != 0 )
                        {
                                g_strdup_to_gtk_text ( file_info_get_owner ( files_data->data), info[GW_VALUE_APP_EXPLORER_FILE_COLUMN_OWNER_POSITION_DEFAULT]);
                        }
                        else
                        {
                                g_strdup_to_gtk_text ( _( "unknown owner"), info[GW_VALUE_APP_EXPLORER_FILE_COLUMN_OWNER_POSITION_DEFAULT]);
                        }
                        if ( strlen ( file_info_get_group ( files_data->data)) != 0 )
                        {
                                g_strdup_to_gtk_text ( file_info_get_group ( files_data->data), info[GW_VALUE_APP_EXPLORER_FILE_COLUMN_GROUP_POSITION_DEFAULT]);
                        }
                        else
                        {
                                g_strdup_to_gtk_text ( _( "unknown group"), info[GW_VALUE_APP_EXPLORER_FILE_COLUMN_GROUP_POSITION_DEFAULT]);
                        }
                        text_utf8 = g_strdup_printf ( "%ld", file_info_get_inode ( files_data->data));
                        g_strdup_to_gtk_text ( text_utf8, info[GW_VALUE_APP_EXPLORER_FILE_COLUMN_INODE_POSITION_DEFAULT]);
                        g_free ( text_utf8);
                        text_utf8 = gw_ui64_byte_to_str_format ( file_info_get_size ( files_data->data));
                        g_strdup_to_gtk_text ( text_utf8, info[GW_VALUE_APP_EXPLORER_FILE_COLUMN_SIZE_POSITION_DEFAULT]);
                        g_free ( text_utf8);
                        tmp_date = file_info_get_cdate_to_gchar ( files_data->data);
                        g_strdup_to_gtk_text ( tmp_date, info[GW_VALUE_APP_EXPLORER_FILE_COLUMN_CDATE_POSITION_DEFAULT]);
                        g_free ( tmp_date);
                        tmp_date = file_info_get_mdate_to_gchar ( files_data->data);
                        g_strdup_to_gtk_text ( tmp_date, info[GW_VALUE_APP_EXPLORER_FILE_COLUMN_MDATE_POSITION_DEFAULT]);
                        g_free ( tmp_date);
                        tmp_date = file_info_get_adate_to_gchar ( files_data->data);
                        g_strdup_to_gtk_text ( tmp_date, info[GW_VALUE_APP_EXPLORER_FILE_COLUMN_ADATE_POSITION_DEFAULT]);
                        g_free ( tmp_date);
                        g_strdup_to_gtk_text ( file_info_get_category_name ( files_data->data), info[GW_VALUE_APP_EXPLORER_FILE_COLUMN_CATEGORY_POSITION_DEFAULT]);
                        g_strdup_to_gtk_text ( file_info_get_description ( files_data->data), info[GW_VALUE_APP_EXPLORER_FILE_COLUMN_DESCRIPTION_POSITION_DEFAULT]);
                        gw_str_replace_char ( info[GW_VALUE_APP_EXPLORER_FILE_COLUMN_DESCRIPTION_POSITION_DEFAULT], '\n', ' ');
                        g_strdup_to_gtk_text ( NULL, info[11]);

                        if ( ( strlen ( file_info_get_name ( files_data->data)) == 2) && (strncmp ( file_info_get_name ( files_data->data), "..", 2) == 0) )
                        {
                                row = gtk_clist_prepend ( clist_info, info);

                                /* Note that doesn't give the data destroy function, because that will destroy the database. */
                                gtk_clist_set_row_data_full ( clist_info, row, (struct file_info*)files_data->data, NULL);
                                gtk_clist_set_pixtext ( clist_info, row, 0, info[GW_VALUE_APP_EXPLORER_FILE_COLUMN_NAME_POSITION_DEFAULT], 5, PixParentFolder, MskParentFolder);
                        }
                        else
                        {
                                row = gtk_clist_append ( clist_info, info);

                                /* Note that doesn't give the data destroy function, because that will destroy the database. */
                                gtk_clist_set_row_data_full ( clist_info, row, (struct file_info*)files_data->data, NULL);
                                gtk_clist_set_pixtext ( clist_info, row, 0, info[GW_VALUE_APP_EXPLORER_FILE_COLUMN_NAME_POSITION_DEFAULT], 5, PixFile, MskFile);
                        }

                        files_data = g_list_next ( files_data);

                        /* Frees memory used by info. */
                        for ( i = 0; i < 11; i++)
                        {
                                g_free ( info[i]);
                        }
                }

		if ( dir_data!=NULL) {
			/* Displays in the status bar the informations about the selected item. */
			gw_status_bar_put_msg_dir ( window,
						file_info_get_name ( dir_data_get_info ( dir_data)),
						size,
						compt_file - 1,
						compt - compt_file,
						compt - 1);
		} else {
#ifdef GW_DEBUG_GUI_CALLBACK_COMPONENT
                	g_print ( "*** GW - %s (%d) :: %s() : warning!! dir_data\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif
		}

                /* Updates the list of folders and files. */
		gtk_clist_sort ( clist_info);
                gtk_clist_thaw ( clist_info);

                return TRUE;
        }}

	gtk_clist_thaw ( clist_info);

        return FALSE;
}


gulong gw_notebook_catalog_ctree_node_get_folder_size ( GtkCTree *ctree, GtkCTreeNode *node)
{
	/* Bug to fix : gulong seems be too short. It should be better to use guint64. */
	GtkCTreeNode *child = NULL;
	struct dir_data *dir_data = NULL;
	GList *files = NULL;
	gulong size = 0;
	gulong result = 0;
	GtkCTreeNode *root = NULL;


#ifdef GW_DEBUG_GUI_CALLBACK_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( (ctree != NULL) && (node != NULL ) )
	{
		root = gw_gui_manager_main_interface_get_tree_root ( );

		/* Lists all subfolders. */
		child = GTK_CTREE_ROW ( node)->children;

		while ( child != NULL )
		{
			/* Recursive call of the function gw_notebook_catalog_ctree_node_get_folder_size. */
			size = size + gw_notebook_catalog_ctree_node_get_folder_size ( ctree, child);
		}

		/* Gets the size of all files which are in the folder. */
		dir_data = gtk_ctree_node_get_row_data ( ctree, node);
		files = g_list_first ( dir_data_get_child ( dir_data));
		files = g_list_next ( files);

		if ( (GTK_CTREE_ROW ( node)->parent) == root )
		{
			files = g_list_next ( files);
		}

		while ( files != g_list_first ( files))
		{
			size = size + file_info_get_size ( files->data);
			files = g_list_next ( files);
		}

		result = size;
	}

	return result;
}
