/***************************************************************************
 *   Copyright (C) 2003-2007 by Spiros Georgaras <sng@hellug.gr>           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.         *
 ***************************************************************************/


#include <kapplication.h>
#include <kaboutdata.h>
#include <kcmdlineargs.h>
#include <klocale.h>

#include <kcmdlineargs.h>
#include <kaboutdata.h>
#include <kmessagebox.h>
#include <qstring.h>
#include "rename.h"
#include "filesdata.h"
#include "dirsdata.h"
#include "iconload.h"
#include "main.h"

filesData f;
dirsData g;
bool InitiatedRename=FALSE;
QString tFormatBefore;
QString tFormatDate;
QString tFormatAfter;
GwenRename* gwen;
KAboutData * ab;
bool noProfiles=FALSE;


static const char description[] =
    I18N_NOOP("A tool for renaming files");

static const char version[] = "1.1-beta1";

static KCmdLineOptions options[] ={
  {"disableProfiles",I18N_NOOP("Disable profiles"), 0},
	{ "+file(s)", I18N_NOOP("File(s) to be renamed"), 0 }
	//  { 0, 0, 0 }
  // INSERT YOUR COMMANDLINE OPTIONS HERE
};

int main(int argc, char **argv){
  KAboutData aboutData("gwenrename", I18N_NOOP("GwenRename"), version, description,
	KAboutData::License_GPL, "(C) 2003-2007 Spiros Georgaras", 0, "http://members.hellug.gr/sng/gwenrename/", "sng@hellu.gr");
  aboutData.addAuthor( "Spiros Georgaras", 0, "sng@hellu.gr" );
  ab=&aboutData;
  KCmdLineArgs::init(argc, argv, &aboutData);
  KCmdLineArgs::addCmdLineOptions( options );
  KApplication app;
//  gwenrename *mainWin = 0;

//   if (app.isRestored()){
//         RESTORE(gwen);
//   }else{
	  // no session.. just start up normally
		if(argc<2){
			KMessageBox::error(0,i18n("No input files specified..."),0);
		}else{
			//filesData f;
			KCmdLineArgs *args = KCmdLineArgs::parsedArgs();
			if(args->isSet("disableProfiles")){
				noProfiles=TRUE;
			}
			if(args->count()==0){
				KMessageBox::error(0,i18n("No input files specified..."),0);
				return 0;
			}
			if(f.setItems(args->count())==-1){
				KMessageBox::error(0,i18n("Memory allocation error\n\nThe program could not allocate memory needed for its execution. Close some applications and try again"),0);
				return 0;
			}
    
    	for(int i=0;i<args->count();i++) f.files[i].setFile(args->url(i).path());
			if(!f.canRename()){
				for(int y=0;y<f.numOfFiles;y++){
					if(!f.files[y].exists()){
						QString m;
						m=QString(i18n("File '%1' does not exist\nPlease check your selection and try again")).arg( f.files[y].filePath() );
						KMessageBox::error(0,m,QString::null,KMessageBox::AllowLink);
						args->clear();
						return 0;
					}
					if(!f.files[y].isWritable()){
						QString m;
						m=QString(i18n("File '%1' can not be renamed\nYou don't have write permission to this file")).arg( f.files[y].filePath() );
						KMessageBox::error(0,m,QString::null,KMessageBox::AllowLink);
						args->clear();
						return 0;
					}
				}
			}
   		f.getType();
			if(f.Type==0){
					KMessageBox::error(0,i18n("Invalid file type selected\nYou can rename normal files or directories"),0);
					args->clear();
					return 0;
			}else if(f.Type==-1){
					KMessageBox::error(0,i18n("Invalid selection\nYou can not mix files and directoriesin the same renaming function"),0);
					args->clear();
					return 0;
			}
			if(!f.samePath()){
				KMessageBox::error(0,i18n("Invalid selection\nThe files must be in the same directory"),0);
				args->clear();
				return 0;
			}
			if(f.Type==2){
					for(int i=0;i<f.items();i++){
						if((f.files[i].filePath()==f.files[i].dirPath()+"/.") || (f.files[i].filePath()==f.files[i].dirPath()+"/..")){
						KMessageBox::error(0,i18n("Invalid selection\nYou can't rename the current or parent directory"),0);
						args->clear();
						return 0;                    
						}
					}
			}
   		args->clear();
   		QString spec="*";
			/*
				if(f.typeExtension.isEmpty()){
					spec=QString("*");
				}else{
					spec=f.typeExtension;
					spec.prepend("*.");
					spec+=" *.";
					spec+=f.typeExtension.upper();
				}
			*/
			int iSpec;
			if(f.Type==1){
					iSpec=QDir::Files | QDir::NoSymLinks;
			}else if(f.Type==2){
					iSpec=QDir::Dirs | QDir::NoSymLinks;
			}else{
					iSpec=QDir::Readable | QDir::Writable | QDir::NoSymLinks;
			}
			iSpec=QDir::Dirs | QDir::Files;
			g.setPath(f.files[0].dirPath(),spec,iSpec); 
			if(g.setLink(&f)==-1){
					KMessageBox::error(0,i18n("Memory allocation error\n\nThe program could not allocate memory needed for its execution. Close some applications and try again"),0);
					return 0;   
			} 
	  	GwenRename *gwen = new GwenRename();
// 			gwen = gwenrename;
			app.setMainWidget(gwen);
			gwen->show();
			return app.exec();
		}	
//   }
}
