/***************************************************************************
                          filesdata.cpp  -  description
                             -------------------
    begin                : ??? ??? 9 2003
    copyright            : (C) 2003 by Spiros Georgaras
    email                : sngeorgaras@otenet.gr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include <qregexp.h>
#include <qfileinfo.h>
#include "filesdata.h"
//================================
filesData::filesData(){
  mItems=-1;
}
//================================
filesData::~filesData(){
  delete [] files;
}
//================================
int filesData::setItems(int items){
  numOfFiles= items;
  files=new QFileInfo[items];
  if(files==NULL) return -1;
  for(int i=0;i<items;i++) files[i].setCaching(FALSE);
  mItems=items;
  return 0;
}
//================================
int filesData::items(void){
  return mItems;  
}
//================================
int filesData::getType(){
  int first;
  //if(numOfFiles == 1)
  first=whatType(0);
  if(first==0){
    Type=first;
    return first;
  }
  for(int i=1;i<numOfFiles;i++){
    if((whatType(i))!=first){
      if(first==0){
        Type=first;
        return first;
      }else{
        Type=-1;
        return -1;
      }
    }
  }
  Type=first;
  if(first==1){
    bool same=TRUE;
    QString fExt=files[0].extension(FALSE).lower();
    for(int i=1;i<numOfFiles && same;i++)
      if((files[i].extension(FALSE).lower())!=fExt) same=FALSE;
    if(same) typeExtension=fExt.lower();
  }
  return first;  
}
//================================
bool filesData::canRename(){
  for(int i=0;i<numOfFiles;i++)
    if( !files[i].isWritable() ) return FALSE;
  return TRUE;
}
//================================
bool filesData::samePath(void){
  for(int i=1;i<numOfFiles;i++)
      if(files[0].dirPath()!=files[i].dirPath()) return FALSE;
  return TRUE;  
}
//================================
int filesData::whatType(int item){
  if(files[item].isFile())
    return 1;
  else if(files[item].isDir())
    return 2;
  else
    return 0;
}




