#! /usr/bin/env python
# -*- coding: latin-1 -*-
'''
wxPython GUI for GvR
see ABOUT_TEXT in version.py for more info
'''
import sys
OrgSysPath = sys.path[0]# wxCrapware changes the sys.path !!
try:
    import wxversion     # if multiple versions are installed
    wxversion.select("2.5")
except Exception, info:
    print info
    print "Can not import wxversion and/or select version 2.5"
    print "Will attempt to import existing version of wxPython."
import wx

from wxPython.wx import *
#wxlocale = wx.Locale(wx.LANGUAGE_DEFAULT)

from wxPython.lib.dialogs import wxScrolledMessageDialog

sys.path[0] = OrgSysPath # reset path to original
from utils import *
from version import ABOUT_TEXT
import ConfigParser,os,shutil

# Does our .gvrrc exist yet?
gvrrcExists = os.path.exists(os.path.expanduser('~/.gvrrc'))
setUpUnixRC()

GVRREDIRECT = 0# redirect stderr and stdout to files (see out.py)
# This redirecting of streams is only used on the non-linux platforms
# to capture messages from the app when running in a console-less way.
# (mainly .exe)
if os.name == 'nt' and GVRREDIRECT:
    try:
        import out
    except ImportError,info:
        print >> sys.stderr,info
    else:
        print >> sys.stderr,"Redirect sys.stderr"
        print "Redirect sys.stdout"

# This stuff must be called before importing worldMap,world and guiWorld
def SetLocale(lang=None):
    global LocaleLang,LocaleMesg
    try:
        cp = ConfigParser.ConfigParser()
        cp.read(RCFILE)
        LocaleLang = cp.get("default", "lang")
    except Exception,info:
        print >> sys.stderr,info,"Setting language to systems default." 
        LocaleLang  = 'system'# let "set_locale" decide what next
    #This will set the locale used by gvr and returns the tuple (txt,loc)
    # txt is a error message, if any else it will be an empty string.
    # loc is a string with the locale country code set for gvr, this can be
    # different from the systems locale.
    LocaleMesg = set_locale(LocaleLang)
        
SetLocale()

import Text
Text.set_summary(LocaleMesg[1])# needed to set summary file used to the current locale

import worldMap
import world
import stepper
import guiWorld
import WorldDisplay
from Editorwindows import WorldEditorWindow, CodeEditorWindow
import gvrparser
import webbrowser

import WorldBuilder

GVRDEBUG = 0# set to 0 before release

ID_RESET   = wxNewId()
ID_STEP     = wxNewId()
ID_EXECUTE  = wxNewId()
ID_ABORT    = wxNewId()

def setRcEntry(option,value):
    try:
        cp = ConfigParser.ConfigParser()
        cp.read(RCFILE)
        cp.set("default", option,value)
        rcfile = open(RCFILE,'w')
        rcfile.write(Text.gvrrcHeader)
        cp.write(rcfile)
        rcfile.close()
    except Exception,info:
        txt = "Failed to write the configuration to disk.\n" 
        print >> sys.stderr,txt,info
        wxMessageBox(txt+str(info))
    else:
        # This text sucks, please refrase this (stas)
        txt = L2U(_("Written the new configuration to disk\nYou have to restart GvR to see the effect"))
        wxMessageBox(txt)

def setIcon(window):
    if os.name == 'nt':
        gvrIcon = wxIcon(os.path.join(get_rootdir(),'bitmaps','gvrIcon.ico'), wxBITMAP_TYPE_ICO)
    else:
        mybmp = wxBitmap(os.path.join(get_rootdir(),'bitmaps','gvrIcon.bmp'), wxBITMAP_TYPE_BMP)
        gvrIcon = wxIcon("",0)
        gvrIcon.CopyFromBitmap(mybmp)
    window.SetIcon(gvrIcon)

class Breakpoint(Exception): pass

class StatusBar:
    def __init__(self, parent):
        self.parent = parent
        parent.CreateStatusBar(2)

    def update(self, world):
        # Update part 0
        if not world:
            self.parent.SetStatusText('', 0)
        elif world.unlimitedBeepers:
            self.parent.SetStatusText(L2U(_("Robot has unlimited beepers")),0)
        else:
            self.parent.SetStatusText(L2U(_("Robot has %d beepers")) % world.robotBeepers,0)
        # Update part 1
        if not world:
            self.parent.SetStatusText('', 1)
        else:
            self.parent.SetStatusText(L2U(_("Next to %d beepers")) % world.beepers.get(world.robot, 0), 1)

class Application(wxFrame):
    def __init__(self, parent, ID, title, worldFile, programFile):
        wxFrame.__init__(self, parent, ID, title,
                     wxDefaultPosition, wxSize(1,1))
        self.codeFile = ''
        self.worldFile = ''
        #L = Latin2Uni()# used to convert extended ascii to unicode   
        #L2U =  L.latin2unicode # for usage see self.addMenuEvent
        
        self.worldDisplay = WorldDisplay.WorldDisplay(self)

        self.makeToolbar()
        self.world_loaded = 0
        self.code_available = 0
        self.statusBar = StatusBar(self)
        
        self.splashBitmap = wxBitmap(os.path.join(get_rootdir(),'bitmaps','gvr-splash.bmp'), wxBITMAP_TYPE_BMP)
        setIcon(self)
                
        self.myStepper = None
                
        self.SleepDict = {L2U(_('Instant')):5, L2U(_('Fast')):50, L2U(_('Medium')):150, L2U(_('Slow')):500}
        self.sleepHighlight = 1
        self.setSpeed(L2U(_('Medium')))

        file   = wxMenu()
        self.addMenuEvent(file, self.menuNewWorld,\
                            L2U(_("New World")),\
                            L2U(_("Create a new blank world")))
        self.addMenuEvent(file, self.menuOpenWorld,\
                            L2U(_("Open World...")),\
                            L2U(_("Open a world for Guido to explore")))
        self.addMenuEvent(file, self.menuNewProgram,\
                            L2U(_("New Program")),\
                            L2U(_("Create a new blank program")))
        self.addMenuEvent(file, self.menuOpenProgram,\
                            L2U(_("Open Program...")),\
                            L2U(_("Open a Guido program")))
        file.AppendSeparator()
        self.addMenuEvent(file, self.menuExit,\
                            L2U(_("E&xit")),\
                            L2U(_("Terminate the program")))

        window = wxMenu()
        self.codewindowmenu = self.addMenuEvent(window, self.menuProgramWindow,\
                                L2U(_("&Program Window")),\
                                L2U(_("Show/Hide the Program Window")), 1)
        self.worldwindowmenu = self.addMenuEvent(window, self.menuWorldWindow,\
                                L2U(_("&World Window")),\
                                L2U(_("Show/Hide the World Window")), 1)
        self.worldbuildermenu = self.addMenuEvent(window, self.menuWorldBuilder,\
                                L2U(_("&World Builder")),\
                                L2U(_("Show/Hide the World Builder")), 1)
        setup  = wxMenu()
        self.addMenuEvent(setup, self.menuSetSpeed, 
          L2U(_("Set S&peed...")), L2U(_("Change the time Guido pauses between moves")))
        # we use this only on windows, other platforms must edit the gvrrc file
        # located in the users home directory
        if os.name == 'nt':
            self.addMenuEvent(setup, self.menuSetLanguage, 
                L2U(_("Set Language...")), L2U(_("Change the language used")))
        
        help   = wxMenu()
        self.addMenuEvent(help, self.menuGvrLessons,\
                                L2U(_("GvR Lessons")),\
                                L2U(_("GvR Lessons in HTML format")))
        self.addMenuEvent(help, self.menuGvrLanguageReference,\
                                L2U(_("GvR Reference")),\
                                L2U(_("GvR language reference")))
        help.AppendSeparator()
        self.addMenuEvent(help, self.menuAbout,\
                            L2U(_("&About")),\
                            L2U(_("About this program")))

        menuBar = wxMenuBar()
        menuBar.Append(file, L2U(_("&File")))
        menuBar.Append(window, L2U(_("&Window")))
        menuBar.Append(setup, L2U(_("&Setup")))
        menuBar.Append(help, L2U(_("&Help")))
        self.SetMenuBar(menuBar)
        
        self.codeEditorWindow = None
        self.worldEditorWindow = None
        self.worldBuilder = None
        
        EVT_PAINT(self, self.OnPaint)
        EVT_ERASE_BACKGROUND(self, self.DoNothing)
        EVT_MOVE(self, self.Move)
        EVT_SIZE(self, self.Size)
        EVT_CLOSE(self, self.menuExit)
        
        timerId = wxNewId()
        self.Mytimer = wxTimer(self,timerId)
        EVT_TIMER(self,timerId,self.stepThruNextInstruction)
        self.timer = None
        
        self.SetClientSize((self.splashBitmap.GetWidth(), self.splashBitmap.GetHeight()))

        if worldFile:
            if self.menuNewWorld():
                self.worldFile = self.worldEditorWindow.OpenWithFile(\
                                    title=self.L2U_(("Choose a world to open")),\
                                    file = worldFile)
        if programFile:
            if self.menuNewProgram():
                self.codeFile = self.codeEditorWindow.OpenWithFile(\
                                    title=L2U(_("Choose a program to open")),\
                                    file = programFile)            

    def OnDestroy(self, *args):
        print "ondestroy"
        wxMessageBox(L2U(_("Please use the 'quit' option in the 'file' menu")))
    
    def addMenuEvent(self, menu, callbackMethod, label, tooltip, checked=0):
        id = wxNewId()
        EVT_MENU(self, id, callbackMethod)
        item = wxMenuItem(menu, id, \
                        label,\
                        tooltip,\
                        checked)
        menu.AppendItem(item) 
        return item

    def menuNewProgram(self, *args):
        if not self.codeEditorWindow:
            self.codeEditorWindow = CodeEditorWindow(self)
            self.StuffAvailable("codewindow",1)
            return 1
        else:
            if self.codeEditorWindow.TimeToQuit():
                self.codeEditorWindow = CodeEditorWindow(self)# get a new one
                self.StuffAvailable("codewindow", 1)
                return 1
            return 0
            
    def menuOpenProgram(self, *args):
        if self.menuNewProgram():
            self.codeFile = self.codeEditorWindow.OpenWithFile(\
                                title=L2U(_("Choose a program to open")))

    def menuNewWorld(self, *args):
        if not self.worldEditorWindow:
            self.worldEditorWindow = WorldEditorWindow(self)
            return 1
        else:
            if self.worldEditorWindow.TimeToQuit():
                self.worldEditorWindow = WorldEditorWindow(self)# get a new one
                return 1
            return 0
    
    def menuOpenWorld(self, *args):
        if self.menuNewWorld():
            self.worldFile = self.worldEditorWindow.OpenWithFile(\
                                title=L2U(_("Choose a world to open")))
    def menuExit(self, *args):
        # The "NoRefresh" arg is to tell the editorwindows object NOT to
        # call ResetEditorWindows which will cause the gui to be updated,
        # which leads to the loading of a new world file.
        # All this is not what we want on exit.
        if self.worldEditorWindow:
            self.worldEditorWindow.TimeToQuit('NoRefresh')
        if self.codeEditorWindow:
            self.codeEditorWindow.TimeToQuit('NoRefresh')
        if self.worldBuilder:
            self.worldBuilder.Quit()
        self.Destroy()
        sys.exit(0)        
        
    def menuProgramWindow(self, *args):
        if not self.codeEditorWindow:
            self.menuNewProgram()
        if self.codewindowmenu.IsChecked():
            self.codeEditorWindow.show_me()
        else:
            self.codeEditorWindow.hide_me()

    def menuWorldWindow(self, *args):
        if not self.worldEditorWindow:
            self.menuNewWorld()
        if self.worldwindowmenu.IsChecked():
            self.worldEditorWindow.show_me()
        else:
            self.worldEditorWindow.hide_me()
            
    def menuWorldBuilder(self,*args):
        if not self.worldBuilder:
            self.worldBuilder = WorldBuilder.GUI(None,self)
            
    
    def ResetEditorWindows(self,name):   
        """Called from the editorwindows"""
        if name == "codewindow":
            self.codeEditorWindow = 0
        else:
            self.worldEditorWindow = 0
        self.StuffAvailable(name,0)
        
    def menuSetSpeed(self, event):
        dlg = wxSingleChoiceDialog(self, L2U(_('Set Robot Speed')),\
                                            L2U(_('Robot Speed')),\
                                [L2U(_('Instant')),L2U(_('Fast')),\
                                L2U(_('Medium')), L2U(_('Slow'))],\
                                            wxOK|wxCANCEL)
        dlg.SetSelection(self.sleepHighlight)
        if dlg.ShowModal() == wxID_OK:
            try:
                self.setSpeed(dlg.GetStringSelection())
                self.sleepHighlight = dlg.GetSelection()
            except:
                wxMessageBox(L2U(_('Invalid input'))+'\n'+str(info))
        dlg.Destroy()
    
    def menuSetLanguage(self,*args):
        """Set the language used in GvR.
        This menu option is only available on windows."""
        dlg = wxSingleChoiceDialog(self, L2U(_('Language to use')),\
                                    L2U(_('Language used')), \
                                    ['Catalan','Dutch','French','Romanian','English','Spanish'],\
                                    wxOK|wxCANCEL)
        dlg.SetSelection(self.sleepHighlight)
        if dlg.ShowModal() == wxID_OK:
            try:
                selectionstr = (dlg.GetStringSelection())
                localelang = {0:'ca',1:'nl',2:'fr',3:'ro',4:'en',5:'es'}[dlg.GetSelection()]
            except Exception,info:
                wxMessageBox(L2U(_('Invalid input'))+'\n'+str(info))
                dlg.Destroy()
            else:
                print "selectionstr",selectionstr
                print "localelang",localelang
                dlg.Destroy()
                setRcEntry('lang',localelang)
        else:
            dlg.Destroy()
    
    def menuGvrLessons(self,*args):
        """Display the GvR lessons in the default browser.
        This only works if the gvr lessons package version 0.2 is installed."""
        file = os.path.join(get_rootdir(),'docs','lessons','html','index.html')
        if os.path.exists(file):
            try:
                webbrowser.open(file,new=0)
            except webbrowser.Error,info:
                txt = str(info)+ '\n'+ "Be sure to set your env. variable 'BROWSER' to your preffered browser."
                wxMessageBox(txt)
        else: 
            wxMessageBox(L2U(_("Can't find the lessons.\nMake sure you have installed the GvR-Lessons package.\nCheck the GvR website for the lessons package.\nhttp://gvr.sf.net")),"Can't open the GvR lessons")
    
    def menuGvrLanguageReference(self,*args):
        """ Display a messagebox with the language reference"""
        dlg = TextWindow(self,Text.OnRefText,\
                                            Text.OnRefTitle,\
                                            Text.InfoFooter)
        dlg.ShowMe()
    
    def menuAbout(self, *args):
        dlg = wxMessageDialog(self, ABOUT_TEXT, "About",
            wxOK | wxICON_INFORMATION)
        dlg.ShowModal()
        dlg.Destroy()

    def setLine(self, line):
        self.codeEditorWindow.selectLine(line)

    def makeToolbarButton(self, callback, id, name, tooltip):
        if GVRDEBUG: print "button strings => name,tooltip",name,tooltip
        button = wxButton(self.tb, id, name, (0,0))
        button.SetToolTipString(tooltip)
        self.tb.AddControl(button)
        EVT_BUTTON(self, id, callback)
        button.Enable(0)
        return button

    def makeToolbar(self):
        self.tb = self.CreateToolBar(wxTB_HORIZONTAL)
        #self.tb.SetToolBitmapSize((80,20))
        self.restartButton = self.makeToolbarButton(self.Reset, ID_RESET,\
                                        L2U(_("Reset")),\
                                        L2U(_("Reset World")))
        self.stepButton = self.makeToolbarButton(self.Step, ID_STEP,\
                                        L2U(_("Step")),\
                                L2U(_("Step through one instruction")))
        self.executeButton = self.makeToolbarButton(self.Execute, ID_EXECUTE,\
                                L2U(_("Execute")),\
                                L2U(_("Execute the GvR program")))
        self.abortButton = self.makeToolbarButton(self.Abort, ID_ABORT,\
                                L2U(_("Abort")), 
                                L2U(_("Abort")))
        self.tb.Realize()
    
    ##### RUN GUIDO AROUND IN HIS LITTLE WORLD!
    def Reset(self, *args):
        self.StuffAvailable("worldwindow",1)
        self.abortButton.Enable(0)

    def Execute(self, event):
        self.oneStepAtATime = False
        self.abortButton.Enable(1)
        try:
            self.stepThruNextInstruction()
        except Exception,info:
            if GVRDEBUG: trace_error()
            wxMessageBox(L2U(_("There was an error in the program\n%s")) % info)
            return
            
    def Step(self, *event):
        self.oneStepAtATime = True
        self.stepThruNextInstruction()

    def Abort(self, *event):
        self.stopTimer()# needed for win32
        self.debug(L2U(_('User aborted program'))+'\n'+self.myStepper.stackTrace())
        self.stopRobot()

    def beginProgram(self):
        if not self.world_loaded or not self.code_available:
            wxMessageBox(L2U(_("Please load a world and program before executing.")))
            return
        if self.reloadWorldIntoGui():
            self.myGuiWorld = guiWorld.GuiWorld(self, self.myWorld)
            gvrCode = self.codeEditorWindow.getText()
            try:
                self.myStepper = stepper.Stepper(gvrCode, self.myGuiWorld, self)
            except gvrparser.BadCommand, e:
                self.setLine(e.line)
                wxMessageBox(str(e))
                return
            except gvrparser.ParseError, e:
                wxMessageBox(str(e))
                return
            self.executeButton.Enable(1)
            self.abortButton.Enable(1)
            self.stepButton.Enable(1)

    def stepThruNextInstruction(self,*args):
        if not self.myStepper:
            self.beginProgram()
            if not self.myStepper:
                return
        try:
            self.myStepper.step()
            # this should fix the Linux refresh problem
            # leave it like this until it's properly tested on win and Linux
            if os.name == 'nt':
                self.refresh()
            self.statusBar.update(self.myWorld)
            if self.oneStepAtATime:
                self.stopTimer()
            else:
                self.startTimer()
        except guiWorld.TurnedOffException:
            self.stopRobot()
            self.debug(L2U(_('Robot turned off')))
        except (guiWorld.GuiWorldException,stepper.OutOfInstructionsException),e:
            self.stopRobot()
            self.debug(str(e))
        except Breakpoint:
            ## XXX This doesn't work properly
            ## the timer stops, but the robots walks further
            self.debug(L2U(_('Hit execute to resume')))
            self.stopTimer()
        except stepper.InfiniteLoopException,info:
            # special message, don't translate
            txt="What are you doing Dave...\n\nI've just executed %s commands for you.\n\nI wonder... could we perhaps be living in an infinite loop??\n\nHit Yes to stop this madness or\nHit No to test if you can blow up your PC.\n" % info
            dlg = wxMessageDialog(self,txt,"", wxYES_NO)
            choice = dlg.ShowModal()
            dlg.Destroy()
            if choice == wxID_YES:
                self.stopRobot()
            elif choice == wxID_NO:
                pass
        return 1
        
    def breakpoint(self):
        raise Breakpoint()

    def startTimer(self):
        self.Mytimer.Start(self.SleepTime)
        self.timer = 1

    def stopTimer(self):
        if self.timer:
            self.Mytimer.Stop()
            self.timer = None

    def stopRobot(self):
        self.myStepper = None
        self.stopTimer()
        self.executeButton.Enable(0)
        self.stepButton.Enable(0)
        self.abortButton.Enable(0)
        self.restartButton.Enable(1)
       
    def setSpeed(self, speed):
        self.SleepTime = self.SleepDict[speed]
    
    def StuffAvailable(self, name, isAvailable):
        """Called when the editor windows content status changes."""
        if name == "codewindow":
            self.code_available = isAvailable
            world = None
        else:
            self.world_loaded = isAvailable
            world = True
        if isAvailable and world: 
            # If either a new world or new code is becoming
            # available, we must reload the world.
            # In particular, as soon as we have new code,
            # you need to start the robot at the beginning of
            # the program again; we don't have any kind of 
            # incremental compile capability.
            self.reloadWorldIntoGui()
        self.refresh()
        for button in (self.executeButton, self.stepButton):
            button.Enable(self.world_loaded and self.code_available)

    ########### REDRAWING CODE ##################
    # These methods are more or less in top-down order.

    def refresh(self):
        if self.world_loaded:
            self.statusBar.update(self.myWorld)
        else:
            self.statusBar.update(None)
        self.Refresh()

    def DoNothing(self, *args):
        pass

    def OnPaint(self, *args):
        dc = wxPaintDC(self)
        dc.BeginDrawing()
        if self.world_loaded:
            try:
                self.worldDisplay.onPaint(dc)
            except AttributeError,info:
                pass
        else:
            self.DrawOpening(dc)
            #Fix the problem where it craps when you stretch too big
        dc.EndDrawing()

    def Move(self, event):
        if self.worldDisplay:
            self.worldDisplay.move()

    def Size(self, event):
        if self.world_loaded:
            self.worldDisplay.reSize(self.myWorld)
        self.refresh()

    def updateWorldBitmapAfterMove(self, oldCoords=None):
        self.worldDisplay.updateWorldBitmapAfterMove(self.myWorld, oldCoords)

    ########## RELOAD/RESET METHODS

    def Reset(self, *args):
        self.abortButton.Enable(0)
        self.StuffAvailable("worldwindow",1)
        
    def debug(self, message, title="Debug"):
        wxMessageBox(message, parent=self )

    def reloadWorldIntoGui(self):
        try:
            lines = self.worldEditorWindow.textctrl.GetText().split('\n')
        except AttributeError,info:
            self.refresh()
            wxMessageBox(L2U(_("Please open a 'world' file first.\nThe world will now be reset to a empty world.")))  
            lines = [NULL_WORLD]
            self.menuNewWorld()#This will create a worldeditor object
            self.worldEditorWindow.textctrl.SetText(NULL_WORLD+'\n')
        self.myWorld = world.World()
        try:
            worldSize = worldMap.readWorld(lines, self.myWorld)
        except worldMap.WorldMapException, e:
            self.StuffAvailable("worldwindow",0)
            self.worldEditorWindow.selectLine(e.line-1)
            self.refresh()
            wxMessageBox(str(e))
            return             
        except IOError:
            self.StuffAvailable("worldwindow",0)
            self.refresh()
            wxMessageBox(L2U(_("The world file, %s, is not readable.")) % self.worldFile)    
            return
        self.restartButton.Enable(1)
        if worldSize:
            avenues, streets = worldSize
            self.SetClientSize(
                self.worldDisplay.getScreenSize(avenues, streets))
        self.worldDisplay.reset(self.myWorld)
        self.refresh()
        self.myStepper = None
        self.stopTimer()
        return 1

    #### FLUFF :)

    def DrawOpening(self, dc):
        adjy = self.worldDisplay.yAdj()
        dc.SetBackground(wxWHITE_BRUSH)
        dc.Clear()
        dc.DrawBitmap(self.splashBitmap, 0, adjy, 0)
    

class TextWindow(wxFrame):
    def __init__(self, parent,msg, title,footer=""):
        if footer:
            msg = "%s\n%s" % (msg,footer)
        self.dlg = wxScrolledMessageDialog(parent, msg, title)
 
    def ShowMe(self):
        self.dlg.Show(true)

    def HideMe(self):
        self.dlg.Show(false)

def setUpUnixDirs():
    if not os.path.exists(os.path.expanduser('~/GvR/')):
        choice = wxMessageDialog(None, L2U(_('Would you like to create default directories for your worlds and programs? '))+'(~/GvR)', 'GvR-Question', wxYES_NO)
        if choice.ShowModal() == wxID_YES:
            choice.Destroy()
            try:
                # This would have been a lot less confusing if
                # made the user's directory called ~/GvR/examples
                destdir = os.path.expanduser('~/GvR')
                os.mkdir(destdir)
                shutil.copytree('/usr/local/GvR/examples',os.path.join(destdir,'examples'))
            except Exception,info:
                wxMessageBox(L2U(_("Can't make the default directory.\n The error message was: %s")) % info,"GvR-ERROR")   
    
##class MyApp(wxApp):
##    """Not longer used, see 'if __name__ ==....etc.'"""
##    def __init__(self, foo, worldFile, programFile):
##        self.worldFile = worldFile
##        self.programFile = programFile
##        wxApp.__init__(self, foo)
##
##    def OnInit(self):
##        # XXX do we need this OnInit stuff anymore ?? Stas Z
##        pass
##        return true

if __name__ == '__main__':
    try:
        worldFile = sys.argv[1]
        programFile = sys.argv[2]
    except:
        worldFile = None
        programFile = None
    try:
        #app = MyApp(0, worldFile, programFile)
        app = wxPySimpleApp() 
        gvrWindow = Application(NULL, -1, "Guido van Robot", worldFile, programFile)
        # If .gvrrc exists, don't ask us if we want to make GvR dirs again
        # (since we've clearly run once before and been asked)
        if os.name == 'posix' and not isOsX() and not gvrrcExists: setUpUnixDirs()
        if LocaleMesg[0]: wxMessageBox(LocaleMesg[0],"GvR info")
        gvrWindow.Centre()
        gvrWindow.Show(true)
        app.MainLoop()
    except Exception,info:
        print >> sys.stderr,"ERROR while executing GvR\n", "info:",info,"\n",trace_error()
        if str(sys.exc_info()[0]) == "exceptions.TypeError":
            txt = "\nOops, perhaps you need a unicode wxPython version ?\n"
            print >> sys.stderr,txt
