# -*- coding: latin-1 -*-

# Copyright (c) 2005 Stas Zykiewicz <stasz@linux.isbeter.nl>
#
#           WorldBuilder.py
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Library General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

## TODO
## 
##
##Wall 1 1 N
##Wall 2 1 N
##Wall 3 1 N
##into
##Wall 1 1 N 3

DEBUG = 0# set this to 1 for extra messages to stdout
import sys
from utils import set_locale
import rur_misc
try:
    import wxversion     # if multiple versions are installed
    wxversion.select("2.5")
    rur_misc.WX_VERSION = 2.5
except Exception, info:
    print info
    print "Can not import wxversion"
    print "Will attempt to import existing version of wxPython."
    #most likely only version 2.4 (or earlier) installed
    rur_misc.WX_VERSION = 2 # placeholder for some other version

import wx
from wxPython.wx import *

## This is needed to get some image handlers working before we use them in
## RUR_RobotFactory etc.
## Another piece of evidence that it helps to be braindead before you use the
## hackerish crap that's called wxPython.
if __name__ == '__main__':
    app = wxPySimpleApp() 

from rur_world_display import WorldGUI
import Rwld2Gwld,version
import rur_dialogs

set_locale()

# toolbar id's
ID_RESET   = wxNewId()
ID_IMPORT  = wxNewId()
ID_EXPORT  = wx.ID_SAVE
ID_QUIT    = wxNewId()
ID_HELP    = wxNewId()
ID_ABOUT   = wxNewId()

# Custom event
# The functions and class are needed to create everything needed for our custom
# wxPython event with the extra ability to include extra data.
# See class MyWorldGUI.UpdateWorld how to use it with extra data.
# Every object that wants to update the statusbar should call SendCustomEvent()
StatusBarEvent = wxNewEventType() 
def EVT_StatusBarChanged(window,function): 
    """See class StatusBarChangedEvent and class StatusBar""" 
    window.Connect(-1, -1,StatusBarEvent,function)
    
def SendCustomEvent(parent,*args):
    """Use this to emit a event which is received by the statusbar class.
    parent must be a valid wxPython window.
    args is a optional tuple which is passed to the receiving object."""
    event = StatusBarChangedEvent(parent.GetId(),args) 
    parent.GetEventHandler().AddPendingEvent(event) 
    
class StatusBarChangedEvent(wxPyCommandEvent): 
    """Custom event used to notify the statusbar.
    This event can be used everywere but here we let the statusbar handle it."""
    eventType = StatusBarEvent
    def __init__(self, id,data):
        self.data = data
        wxPyCommandEvent.__init__(self, self.eventType, id) 
    def Clone(self): 
        self.__class__(self.GetId())     

# some constants
GUISIZE = (540,540)

HELPMESSAGE = \
"""
Editing world:
    Left mouse button : Add or remove walls 
    Right mouse button: Put beepers at intersection
    Lower case s      : Resize world
    Lower case b      : Set the number of beepers
    
Robot actions:
    Up arrow:     move robot forward
    Left arrow:   turn robot left

Buttons:
    Save    : Save your world to a file
    Export  : Export your world to a GvR world editor,
              use the 'Reset' button in GvR to display you world
    Help    : This message
    About   : Some useless information.
    Quit    : Quit the worldbuilder, *not* GvR.
    """

class MyWorldGUI(WorldGUI):
    """This is just a wrapper used to override WorldGUI and to be able to use
    rur stuff with WorldBuilder.
    """
    def __init__(self,parent,id,size=wxDefaultSize):
        WorldGUI.__init__(self,parent,id,size)
        self.parent = parent
        # this is needed because the rur_dialogs expect a reference to WorldGUI
        # which is hardcoded and called 'WorldDisplay'.
        self.WorldDisplay = self
        # Add a robot
        self.world.addOneRobot(name='robot')
        # create a backup copy that will be used to "reset" the world
        self.backup_dict = {}
        self.backup_dict['avenues'] = self.world.av
        self.backup_dict['streets'] = self.world.st
        self.backup_dict['beepers'] = {}
        self.backup_dict['walls'] = []
        self.backup_dict['robot'] = self.world.robot_dict['robot']._getInfoTuple()
    def UpdateWorld(self,*args):
        """Called by the beepers dialog.
        We only use it to update the statusbar."""
        if DEBUG:
            print __name__
            print args
            print self.world.robot_dict['robot']._beeper_bag 
        SendCustomEvent(self,args[0])
    def MyKeys(self,event):
        """Override the MyKeys method from RUR.
        Some keybindings are taken from RUR, but there are some unique to Worldbuilder."""
        code = event.KeyCode()
        if code == WXK_UP: # up arrow
            if 'robot' in self.world.robot_dict:
                try:
                    self.world.MoveRobot('robot') # may raise an exception
                    self.scrollWorld('robot')
                except rur_dialogs.HitWallException, mesg:
                    rur_dialogs.DialogHitWallError(mesg)
        elif code == WXK_LEFT: # left arrow
            self.world.TurnRobotLeft('robot')
        elif code == WXK_F5:
            rur_dialogs.rurMessageDialog(HELPMESSAGE, "Help")
        elif code == 115: # s - lower case
            # Change world's dimensions
            win = rur_dialogs.ResizeWorldDialog(self, -1, "Resize world",\
                                            pos=wxDefaultPosition,\
                                            size=wxDefaultSize,\
                                            style=wxDEFAULT_DIALOG_STYLE,)
            # Don't call win.Show, the 'if' block at the bottom takes care of that
        elif code == 101:# e - lower case
            if self.world.editWalls:
                self.world.editWalls = False
                self.world.DoDrawing()
            else:
                self.world.editWalls = True
                self.world.DoDrawing()
        elif code == 98: # b - set beepers
            win = rur_dialogs.RobotBeeperDialog(self, -1, "Set number of beepers",\
                            pos=wxDefaultPosition,
                            size=wxDefaultSize, style=wxDEFAULT_DIALOG_STYLE)
            #self.UpdateWorld()
        if self.world.updateImage:
            # This will update everything including popups.
            self.drawImage()
            self.Refresh()
        self.parent.SetFocus()
            
class SimpleDialog(wxMessageDialog):
    def __init__(self,parent,txt,title):
        wxMessageDialog.__init__(self,parent,txt,title,wxOK | wxICON_INFORMATION)
        self.ShowModal()
        parent.wgui.SetFocus()
        
class event:
    """class to fake a wxPython event.
    This is used by the GUI class when a call to RUR_WorldDisplay.MyKeys() is done
    it expects to be called with a wxPython event object as argument."""
    def __init__(self,wxkey):
        """wxkey must be a real wxPython key constant."""
        self.wxkey = wxkey
    def KeyCode(self):
        return self.wxkey

class ToolBar:
    def __init__(self,parent):
        self.parent = parent
        self.tb = self.parent.CreateToolBar()

        self.saveButton = self._makeToolbarButton(
                            self.Save, wxNewId(), _("Save"), \
                            _("Save your world map into a GvR format"))
        self.exportButton = self._makeToolbarButton(
                            self.Export, wxNewId(), _("Export"), \
                            _("Export your world map into a GvR format"))
        self.helpButton = self._makeToolbarButton(
                            self.Help, wxNewId(), _("Help"),\
                            _("Get some help about usage"))
        self.aboutButton = self._makeToolbarButton(
                            self.WBAbout, wxNewId(), _("About"),\
                            _("General info about this application"))
        self.quitButton = self._makeToolbarButton(
                            self.WBQuit, wxNewId(), _("Quit"),\
                            _("Quit the WorldBuilder"))
        self.tb.CenterOnParent()
        self.tb.Realize()

    def _makeToolbarButton(self, callback, id, name, tooltip):
        if DEBUG: print __name__,"button strings => \nname,tooltip",name,tooltip
        button = wxButton(self.tb, id, name, (0,0))
        button.SetToolTipString(tooltip)
        self.tb.AddControl(button)
        EVT_BUTTON(self.parent, id, callback)
        if id == ID_IMPORT or id == ID_RESET:
            button.Enable(0)# disable buttons
        else:
            button.Enable(1)
        return button
    # These buttons callbacks launch dialogs which will grep the focus.
    # We have to give to focus back to the world 'canvas' to be able to
    # receive keyboard events. The SimpleDialog class will reset the focus.
    # Anything else must use the call: self.parent.wgui.SetFocus()
    def Save(self,*args):
        if DEBUG: print "save event",args
        cvrt = Rwld2Gwld.Rur2Gvr(self.parent.world)
        lines = cvrt.Convert()
        cvrt.SaveTextAs(lines)
        self.parent.wgui.SetFocus()
    def Export(self,*args):
        if DEBUG: print "export event",args
        cvrt = Rwld2Gwld.Rur2Gvr(self.parent.world)
        lines = cvrt.Convert()
        self.parent.gvrapp.menuNewWorld()
        self.parent.gvrapp.worldEditorWindow.textctrl.SetText(" ".join(lines))
        self.parent.wgui.SetFocus()
    def WBQuit(self,*args):
        if DEBUG: print "quit event",args
        dlg = wxMessageDialog(self.parent,\
            _("Do you really want to quit?\nAll your changes will be lost."),\
            _("WorldBuilder question"),wxYES_NO)
        choice = dlg.ShowModal()
        if choice == wxID_YES:
            self.parent.Destroy()
        self.parent.wgui.SetFocus()
    def Help(self,*args):
        if DEBUG: print "help event",args
        e = event(WXK_F5)#fake a key event
        self.parent.MyKeys(e)   
    def WBAbout(self,*args):
        if DEBUG: print "about event",args
        SimpleDialog(self.parent,version.WBABOUT_TEXT,_("About WorldBuilder"))

class StatusBar:
    def __init__(self,parent):
        self.sb = parent.CreateStatusBar()
        self.sb.SetStatusText("Robot has 0 beepers, hit 'b' to change it.")
        EVT_StatusBarChanged(parent, self.UpdateText)
    def UpdateText(self,*args):
        if DEBUG: print "statusbar event received",args[0].data
        b = args[0].data[0]
        self.sb.SetStatusText("Robot has %s beepers" % b)
        
class GUI(wxFrame):
    def __init__(self,parent,gvrapp):
        self.gvrapp = gvrapp# used by export button to set a editorwindow
        # Construct GUI
        wxFrame.__init__(self, parent, -1, _("GvR World builder"), size=GUISIZE)
        self.tb = ToolBar(self)
        self.stb = StatusBar(self)
        panel = wxPanel(self)
        
        self.wgui = MyWorldGUI(panel, -1,size=GUISIZE)
        panel.Layout()
        
        self.world = self.wgui.world
        self.MyKeys = self.wgui.MyKeys
        self.world.DoDrawing() # redraw to include robot on canvas
        self.wgui.drawImage()   # redraw to include robot on buffer
        e = event(101)# switch to editmode (we fake a keyboard event)
        self.MyKeys(e) 
        self.Show(True)
        self.Refresh()
    def Quit(self,*args):
        self.tb.WBQuit()
        
if __name__ == '__main__':
    import traceback
    try:
        GUI(None)
        app.MainLoop()
    except Exception,mesg:
        info = sys.exc_info()# print a stacktrace to stdout
        traceback.print_exception(info[0],info[1],info[2],file)
        rur_dialogs.rurMessageDialog(str(mesg),"Error")
    
    
    
    
