/****************************************************************************
** Created: Sat Feb 24 23:35:01 2001
****************************************************************************/
#include "SearchResults.h"
#include <stdio.h>
#include <qstrlist.h>

#include "gutenbrowser.h"
#include "LibraryDialog.h"
#include  <qclipboard.h>

#include <qlistbox.h>
#include <qpushbutton.h>
#include <qlayout.h>
#include <qvariant.h>
#include <qtooltip.h>
#include <qwhatsthis.h>

SearchResultsDlg::SearchResultsDlg( QWidget* parent, const char* name, bool modal, WFlags fl, QStringList stringList)
        : QDialog( parent, name, modal, fl ) {
    if ( !name )
        setName( "SearchResultsDlg" );
    resize( 500, 600 );

#if defined(Q_WS_WIN)

    QString local_library = (QDir::homeDirPath ()) +"/.gutenbrowser/";
    this->setIcon(QPixmap(local_library+"pix/gutenbrowser.png"));
#else
    //    this->setIcon(QPixmap("/usr/share/gutenbrowser/pix/gutenbrowser.png"));
#endif
#ifdef Q_WS_QWS

    QString local_library = (QDir::homeDirPath ()) +"/gutenbrowser/";
#else
#endif

    QGridLayout *Layout1 = new QGridLayout( this);
    Layout1->setSpacing(2);
    Layout1->setMargin(6);
//Layout1->setAutoAdd(true);
    outPutLabel = new QLabel( this, "outPutLabel" );
    statusLabel = new QLabel( this, "StatusLabel" );

    Layout1->addMultiCellWidget( statusLabel, 0, 0, 0, 6);
    statusLabel->setText( "Double click a title to begin downloading.");
    
	 ListBox1 = new QListBox( this, "ListBox1" );
    ListBox1->setSelectionMode( QListBox::Single );
    ListBox1->setMultiSelection(true);

    Layout1->addMultiCellWidget( ListBox1, 1, 6, 0, 6);

    //    QSpacerItem* spacer = new QSpacerItem(0,0,QSizePolicy::Expanding,QSizePolicy::Expanding );
    //    hbox->addItem( spacer);

    setCaption( tr( "Search Results"));
    setSizeGripEnabled( true );
    Layout1->addMultiCellWidget( outPutLabel, 7, 7, 0, 6);

    hbox = new QHBoxLayout(this);
    hbox->setSpacing(6);
    hbox->setMargin(0);

    buttonOk = new QPushButton(this,"buttonOk");
    buttonCancel = new QPushButton(this,"buttonCancel");
    buttonOk->setText( tr( "&Download"));
    buttonOk->setAutoDefault( true);

    buttonCancel->setText( tr( "&Cancel"));
    buttonCancel->setAutoDefault( true);
    buttonOk->setDefault( true);

    hbox->addWidget( buttonCancel);
    hbox->addWidget( buttonOk );

    Layout1->addLayout(hbox,8,6);

    // signals and slots connections
    connect(buttonOk,SIGNAL(clicked()),this,SLOT(dwnLd()));
    connect(buttonCancel,SIGNAL(clicked()),this,SLOT(reject()));
    connect(ListBox1,SIGNAL(doubleClicked(QListBoxItem *)),SLOT(slotListClicked(QListBoxItem *)));

    ListBox1->insertStringList( stringList);
    numListItems = ListBox1->numRows();
    QString strOut;

    outPutLabel->setText( "Number of results: "+ strOut.sprintf("%d", numListItems) );

}

SearchResultsDlg::~SearchResultsDlg() {}

void SearchResultsDlg::slotListClicked(QListBoxItem *it) {
    resultsList.append(it->text() );
    selText = ListBox1->currentText();
    accept();
}

void SearchResultsDlg::dwnLd() {

    for(unsigned int ji=0; ji< ListBox1->count() ; ji++ ) {
        if( ListBox1->isSelected( ji) )
            resultsList.append(ListBox1->text( ji));
    }
    accept();
}

void SearchResultsDlg::downloadButtonSlot() {}
