/****************************************************************************
** Created: Tue Aug 29 11:45:00 2000**/
#include "SearchDialog.h"
#include "SearchResults.h"

#include <qlabel.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qlayout.h>
#include <qvariant.h>
#include <qtooltip.h>
#include <qwhatsthis.h>
#include <qmessagebox.h>
/*This is just a single text entry dialog */
SearchDialog::SearchDialog( QWidget* parent,  const char* name, bool modal, WFlags fl )
    : QDialog( parent, name, modal, fl )
{
    if ( !name )
  setName( "SearchDialog" );
  //  Gutenbrowser * ptrGutenWind;
    resize( 403, 130 );
 //   setCaption( tr( "Search"  ) );
    setSizeGripEnabled( TRUE );

    QWidget* Layout1 = new QWidget( this, "Layout1" );
    Layout1->setGeometry( QRect( 0, 90, 400, 33 ) );
    hbox = new QHBoxLayout( Layout1 );
    hbox->setSpacing( 6 );
    hbox->setMargin( 0 );
    QSpacerItem* spacer = new QSpacerItem( 226, 20, QSizePolicy::Expanding, QSizePolicy::Fixed );
    hbox->addItem( spacer );

    buttonOk = new QPushButton( Layout1, "buttonOk" );
    buttonOk->setText( tr( "Sea&rch"  ) );
    buttonOk->setAutoDefault( TRUE );
    buttonOk->setToggleButton( TRUE);
    buttonOk->setDefault( TRUE );
    hbox->addWidget( buttonOk );

    buttonCancel = new QPushButton( Layout1, "buttonCancel" );
    buttonCancel->setText( tr( "&Cancel"  ) );
    buttonCancel->setAutoDefault( TRUE );
    hbox->addWidget( buttonCancel );

    SearchLineEdit = new QLineEdit( this, "SearchLineEdit" );
    SearchLineEdit->setGeometry( QRect( 10, 40, 380, 22 ) );

    TextLabel1 = new QLabel( this, "TextLabel1" );
    TextLabel1->setGeometry( QRect( 10, 10, 381, 20 ) );
    label1Str= "Enter text to search for. " ;
    TextLabel1->setText( tr( label1Str) );

QLabel *TextLabel2;
    TextLabel2 = new QLabel( this, "TextLabel2" );
    TextLabel2->setGeometry( QRect( 10, 65, 381, 20 ) );
    
    TextLabel2->setText( tr( "Search is case sensitive. ") );

    // signals and slots connections
    connect( buttonOk, SIGNAL( clicked() ), this, SLOT( byeBye() ) );
    connect( buttonCancel, SIGNAL( clicked() ), this, SLOT( closed() ) );
    SearchLineEdit->setFocus();
}

/*
 *  Destroys the object and frees any allocated resources
 */
SearchDialog::~SearchDialog()
{
    // no need to delete child widgets, Qt does it all for us
}

QString SearchDialog::get_text() {
  return SearchLineEdit->text();
}

bool SearchDialog::get_direction() {
  return false; //search forward
}

bool SearchDialog::case_sensitive() {
  return true;
}

bool SearchDialog::forward_search() {
  return true;
}

void SearchDialog::byeBye()
{
QString thisName=name();
if( thisName.find("Library Search", 0, TRUE) != -1) {
  //  searchString = SearchLineEdit->text();
   accept();
    } else {
    buttonOk->setDown(TRUE);
    
    searchString = SearchLineEdit->text();
    emit search_signal();
    buttonOk->setDown(FALSE);       
        }
}

void SearchDialog::closed() {
  emit search_done_signal();
  //this->reject();
 this->hide();
}


void SearchDialog::setLabel(QString labelText)
{
    TextLabel1->setText( tr( label1Str+labelText) );

}
