/* dial.h - Prototypes for functions in dial.c

   Copyright (C) 2000  Henning Kulander <hennikul@ifi.uio.no>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <gnome.h>

typedef struct _Dial Dial;

struct _Dial {
	GtkWidget *canvas;
	GdkBitmap *shape;
	GnomeCanvasGroup *group;
	GnomeCanvasItem *pointer;
	GnomeCanvasItem *text_value;
	GnomeCanvasItem *circle;
	GnomeCanvasPoints *points;
	gfloat max, min;
	gfloat value, radius, center_x, center_y;
	gchar *format;
	guint32 color;
};

gboolean 
dial_area_mark( Dial *dial, guint32 color, 
		gdouble s_value, gdouble b_value );

gboolean 
dial_value_set( Dial *dial, gdouble value );

gboolean 
dial_make( Dial *dial, GtkWidget *canvas, char *label, gchar *format, 
	   gchar *fontname, guint32 color, gint labels[]);

