%define  ver     0.40.3
%define  RELEASE 1
%define  rel     %{?CUSTOM_RELEASE} %{!?CUSTOM_RELEASE:%RELEASE}
%define  prefix  /usr

Summary: GNOME Data Analysis and Visualization.
Name: Guppi
Version: %ver
Release: %rel
Copyright: GPL
Group: Applications/Engineering
Source: ftp://ftp.gnome.org/pub/guppi/%{name}-%{ver}.tar.gz
Url: http://www.gnome.org/guppi
BuildRoot: /var/tmp/%{name}-%{ver}-root
Requires: libglade, gnome-print >= 0.28
Requires: oaf, ORBit, gal >= 0.8, gtk+ >= 1.2.0, glib, libxml
Requires: gnome-libs, bonobo >= 1.0.8, gdk-pixbuf >= 0.11.0
#BuildPrereq: gnumeric-devel >= 1.0.1
BuildPrereq: libglade-devel, gal-devel, ORBit-devel, oaf-devel
BuildPrereq: docbook-utils, docbook-dtd31-sgml, gtk+-devel, glib-devel
BuildPrereq: perl >= 5, gnome-libs-devel, bonobo-devel, gdk-pixbuf-devel

%description
Guppi is a GNOME-based data analysis and visualization system.

Install this package if you want to use Guppi.

%package devel
Summary: Libraries and include files to develop Guppi-based applications
Group: Development/Libraries

%description devel
The Guppi-devel package includes the static libraries and header files
for the Guppi package.

Install Guppi-devel if you want to develop programs which will use the
Guppi libraries.

%prep
%setup -q

%build

if [ ! -f configure ]; then
CFLAGS="$RPM_OPT_FLAGS" ./autogen.sh --prefix=%prefix $MYARCH_FLAGS --sysconfdir=/etc
else
./configure --prefix=%prefix $MYARCH_FLAGS --sysconfdir=/etc
fi

if [ "$SMP" != "" ]; then
  (make "MAKE=make -k -j $SMP"; exit 0)
  make
else
  make
fi

%install
rm -rf $RPM_BUILD_ROOT
%makeinstall

echo "%defattr(-, root, root)" > guppi.files
find $RPM_BUILD_ROOT/%{prefix}/lib/guppi/plug-ins/%{ver} -type f | \
	grep -v '\.la$' | sed "s,$RPM_BUILD_ROOT,,g" >> guppi.files
find $RPM_BUILD_ROOT/%{prefix}/lib/guppi/plug-ins/%{ver} -type d | \
	grep -v '\.la$' | sed "s,$RPM_BUILD_ROOT,%dir ,g" >> guppi.files

echo "%defattr(-, root, root)" > guppi-devel.files
find $RPM_BUILD_ROOT/%{prefix}/lib/guppi/plug-ins/%{ver} -type f | \
	grep '\.la$' | sed "s,$RPM_BUILD_ROOT,,g" >> guppi-devel.files
find $RPM_BUILD_ROOT/%{prefix}/lib/guppi/plug-ins/%{ver} -type d | \
	grep -v '\.la$' | sed "s,$RPM_BUILD_ROOT,%dir ,g" >> guppi-devel.files

%clean
rm -rf $RPM_BUILD_ROOT

%files -f guppi.files
%defattr(-, root, root)

%doc AUTHORS BIBLIOGRAPHY NEWS README
%attr(755,root,root) %{prefix}/bin/*
%{prefix}/lib/lib*.so.*
%{prefix}/lib/guppi/
%{prefix}/share/gnome/help/guppi/C/*.*
%{prefix}/share/locale/*/LC_MESSAGES/*.mo
%{prefix}/share/gnome/help/*
%{prefix}/share/oaf/*.oaf
%{prefix}/share/pixmaps/guppi/*
%{prefix}/share/guppi/scripts/*
%{prefix}/share/guppi/glade/*
%{prefix}/share/pixmaps/gnome-guppi.png

%files devel -f guppi-devel.files
%defattr(-, root, root)

%{prefix}/include/gnome-1.0/*
%{prefix}/lib/lib*.so
%{prefix}/lib/lib*a
%{prefix}/lib/*.sh
%{prefix}/share/aclocal/libguppi.m4

%changelog

* Wed Jan 16 2002 Jon Trowbridge <trow@gnu.org>

- Updated for 0.40.3.
- Merged in changes from a .spec created by Roy-Mange Mo.

* Mon Jan  7 2002 Jonathan Blandford <jrb@redhat.com>

- Update to new version.  Remove non-existent files from globs

* Mon Apr 04 2001 John Gotts <jgotts@linuxsavvy.com>

- Vastly improved spec file.

* Sat Mar 04 2000 Jon Trowbridge <trow@gnu.org>

- Converted Guppi.spec to Guppi.spec.in.
- Tweaked the language in the summary & description.

* Mon Feb 28 2000 Jon Trowbridge <trow@gnu.org>

- Changed version to 0.34.3.

* Wed Feb 23 2000 Jon Trowbridge <trow@gnu.org>

- Updated to 0.34.2.

* Mon Feb 22 2000 Kenny Graunke <graunke@teleport.com>

- Updated to 0.34.1 (using repackaged source, ugh), spec file rewrite
- This 0.34.1 source disables readline due to broken libguilereadline.so
  problems in every guile 1.3.4 x86 RPM I've seen...

* Wed Jan 26 2000 Conrad Steenberg <conrad@srl.caltech.edu>

- Some Alpha fixes for configure
- Remove some unneeded stripping foo and just do a 'make install-strip' instead.
- Move this changelog to the bottom of the file :-)

* Mon Jan 24 2000 Kenny Graunke <graunke@teleport.com>

- First Guppi RPM
