//$Id: dialog-res.h,v 1.25 2006/10/06 22:35:40 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001-2006 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef GUIKACHU_DIALOG_RES_H
#define GUIKACHU_DIALOG_RES_H

#include "resource.h"
#include "resource-ref.h"

#include <vector>

namespace Guikachu
{
    namespace Resources
    {
	class Dialog: public Resource
	{
	public:
	    enum DialogType
	    {
		TYPE_INFORMATION,
		TYPE_CONFIRMATION,
		TYPE_WARNING,
		TYPE_ERROR
	    };
	    
	    Dialog (ResourceManager *manager, const std::string &id, serial_t serial);
	    
	    Type get_type () const { return RESOURCE_DIALOG; };
	    void apply_visitor (ResourceVisitor &visitor) { visitor.visit_resource (this); };

	    Property<std::string>               title;
	    Property<std::string>               text;
	    Property<DialogType>                dialog_type;
	    Property<std::vector<std::string> > buttons;
	    Property<unsigned int>              default_button;
	    Properties::ResourceRef             help_id;
	};
    };
};

#endif /* !GUIKACHU_DIALOG_RES_H */
