/*
 * Guifications - The end all, be all, toaster popup plugin
 * Copyright (C) 2003-2004 Gary Kramlich
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#ifndef GF_GTK_UTILS_H
#define GF_GTK_UTILS_H

#include <gdk/gdk.h>
#include <gtk/gtk.h>
#include <pango/pango.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

/* Color stuff */
guint32 gf_gtk_color_pixel_from_gdk(const GdkColor *color);
void gf_gtk_color_pango_from_gdk(PangoColor *pango, const GdkColor *gdk);
void gf_gtk_color_gdk_from_pango(GdkColor *gdk, const PangoColor *pango);

/* Gtk Theme Stuff */
void gf_gtk_theme_get_bg_color(GdkColor *color);
void gf_gtk_theme_get_fg_color(GdkColor *color);
GdkPixmap *gf_gtk_theme_get_bg_pixmap();
PangoFontDescription *gf_gtk_theme_get_font();

/* Pixbuf Stuff */
void gf_gtk_pixbuf_tile(GdkPixbuf *dest, const GdkPixbuf *tile);
void gf_gtk_pixbuf_clip_composite(const GdkPixbuf *src, gint x, gint y, GdkPixbuf *dest);

/* Subsystem */
void gf_gtk_utils_init();
void gf_gtk_utils_uninit();

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* GF_GTK_UTILS_H */
