#
# gaim_major_ver and gaim_minor_ver should be defined to match the minimum
# Gaim API version _required_ to build Guifications
# Due to the way Gaim checks plugin versions, we need to also ensure that
# the correct minimum version of Gaim is Require:'d based on what version of
# the Gaim headers we actually build with.
#
# This allows --define 'gaimver 1' to be used to build an rpm for Gaim 1.x
# default is to build for Gaim 2.x
%{!?gaimver: %{expand: %%define gaimver 2}}
%define gaim_major_ver %{gaimver}
%define gaim_minor_ver 0
%define gaim_next_major_ver %(echo $((%{gaim_major_ver}+1)))
%define gaim_build_minor_ver %(pkg-config --modversion gaim | awk -F. '{ print $2 }')

Summary:    Guifications Plugin for Gaim
Name:       gaim-guifications
Version:    2.13beta6
Release:    0%{?gaimdist:.%{gaimdist}}
License:    GPL
Group:      Applications/Internet
Url:        http://gaim.guifications.org
Source:     http://downloads.guifications.org/gaim-plugins/Guifications2/%{name}-%{version}.tar.gz
BuildRoot:  %{_tmppath}/%{name}-%{version}-root

Requires:   gaim >= 1:%{gaim_major_ver}.%{gaim_build_minor_ver}, gaim < 1:%{gaim_next_major_ver}

BuildRequires: pkgconfig, libtool, gettext
BuildRequires: gaim-devel >= 1:%{gaim_major_ver}.%{gaim_minor_ver}, gaim-devel < 1:%{gaim_next_major_ver}
%if "%{_vendor}" == "MandrakeSoft"
BuildRequires: libgtk+2.0_0-devel
%else
BuildRequires: gtk2-devel
%endif

%description
Guifications is a graphical notification plugin for the open source instant messaging client Gaim

To rebuild for a specific Gaim version:
rpmbuild --rebuild %{name}-%{version}-%{release}.src.rpm --define 'gaimdist %{!?gaimdist:fc1}%{?gaimdist:%{gaimdist}}'

%prep
%setup -q

%build
%configure
make %{?_smp_mflags}

%install
rm -rf $RPM_BUILD_ROOT
make DESTDIR="$RPM_BUILD_ROOT" install

%if "%{_vendor}" == "MandrakeSoft"
mv -f $RPM_BUILD_ROOT%{_libdir}/gaim/guifications $RPM_BUILD_ROOT%{_libdir}/gaim/guifications.so || :
%endif

strip $RPM_BUILD_ROOT%{_libdir}/gaim/*.so || :
rm -f $RPM_BUILD_ROOT%{_libdir}/gaim/*.la $RPM_BUILD_ROOT%{_libdir}/gaim/*.a

%find_lang guifications

%clean
rm -rf $RPM_BUILD_ROOT

%files -f guifications.lang
%defattr(-, root, root)
%doc AUTHORS ChangeLog COPYING README doc/flow.png doc/flow.dia doc/QUOTES
%{_libdir}/gaim/*.so
%{_datadir}/pixmaps/gaim/guifications

%changelog
* Tue Dec 5 2006 John Bailey <rekkanoryo@rekkanoryo.org>
- Fix the source URL to point to our new download location

* Thu Oct 19 2006 Stu Tomlinson <stu@nosnilmot.com>
- Fix finding the translations

* Thu Nov  3 2005 Stu Tomlinson <stu@nosnilmot.com>
- Default to building for Gaim 2.x with a bit of trickery to optionally
  build for Gaim 1.x

* Fri Apr  8 2005 Stu Tomlinson <stu@nosnilmot.com>
- spec file cleanup, build vs. install dependency fixes, use %%find_lang,
  tidy up release version, fix directory ownership

* Fri Dec 17 2004 Stu Tomlinson <stu@nosnilmot.com>
- Tweaks to the Gaim version dependencies

* Sat Oct  9 2004 Stu Tomlinson <stu@nosnilmot.com>
- Add Gaim version checks to match new Gaim versioning

* Wed Jun 30 2004 Stu Tomlinson <stu@nosnilmot.com>
- Initial spec file for Guifications 2
