#!/usr/bin/env python
# GUI For ufw (Uncomplicated FireWall) - Version 0.20.6
# Web: http://gufw.tuxfamily.org
# Licenced by GPL 3 or (at your option) any later version.
# Copyright (C) 2008 Marcos Alvarez Costales

# Gufw is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public Licence as published
# by the Free Software Foundation; either version 3 of the Licence,
# or (at your option) any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.


# Imports
import gtk
from   gtk           import glade

from initializations          import link_connects,alias,create_header_rules,set_initial_values_combo_box
from set_window               import set_window_values,show_window
from checks                   import check_gufw_root,check_ufw_exist
from general_rutines          import refresh_gufw_log,set_text_advanced_ip,recovery_gufw_preferences
from tray_icon                import create_tray_icon

from variables_paths_messages import *
 



# Gufw initializations
def initializations(gufw):
    
    # Alias	
    alias(gufw)
    
    # Connects
    link_connects(gufw)

    # Run as root?
    if not check_gufw_root():
        sys.exit()

    # Exist ufw?
    if not check_ufw_exist():
        sys.exit()	

    # Recovery Gufw preferences after installation
    recovery_gufw_preferences()
    
    # Refresh Gufw file log
    refresh_gufw_log(path_gufw_log)

    # Tray icon
    create_tray_icon(gufw)
    
    # Rules	
    create_header_rules(gufw)

    # Values by default
    set_initial_values_combo_box(gufw)

    # Text any entry
    set_text_advanced_ip(gufw)


# Init program
def init_gufw(gufw):

    # Initializations
    initializations(gufw)

    # Set Window
    set_window_values(gufw,c_not_working,c_disabled)

    # View or not window
    show_window(gufw)

   
       
# INITIALIZATION
if __name__ == "__main__":

    gufw = glade.XML(path_gufw_glade)
    Gufw = init_gufw(gufw)
    gtk.main()
    
