#include "ScanBag.h"

using namespace std;

void ScanBag::add(const Scan* scan) throw ()
{
	iterator i = find(scan->name());

	if (i == end())
	{
		if (const DefaultScan* s = dynamic_cast<const DefaultScan*>(scan))
		{
			//insert(pair<string, set<string> >(scan->name(), set<string>()));
			defaultProfile = s->name();
		} else {
			set<string> v;
			v.insert(scan->signature());
			insert(pair<string, set<string> >(scan->name(), v));
		}
	}
	else
	{
		i->second.insert(scan->signature());
	}

	scans.push_back(scan);
}

vector<string> ScanBag::notify(const Scan* scan) throw ()
{
	// For every candidate profile, check the signatures.  If one matches with
	// `scan', remove it.  If no signature matches for a candidate, remove the
	// candidate.  Return the list of candidates left.
	//defaultProfile = "";
	
	vector<string> res;
	string sig = scan->signature();
	for (iterator i = begin(); i != end(); )
	{
		set<string>::iterator j = i->second.find(sig);
		if (j == i->second.end())
		{
			// If no signature matches for a candidate, remove the candidate
			iterator k = i;
			k++;
			erase(i);
			i=k;
		}
		else
		{
			// If a profile has a signature matching with `scan', remove it
			i->second.erase(j);
			res.push_back(i->first);
			i++;
		}
	}
	return res;
}

string ScanBag::getLessSpecific() const throw ()
{
	//if (defaultProfile.size() > 0)
		return defaultProfile;

/* Disabled, as it would be called in an ambiguous case, and returning the
 * default is a better option

	string cand;
	int count = -1;
	for (const_iterator i = begin(); i != end(); i++)
	{
		if (count == -1 || (signed)i->second.size() < count)
		{
			count = i->second.size();
			cand = i->first;
		}
	}
	return cand;
*/
}

void ScanBag::dump() const throw ()
{
	for (const_iterator i = begin(); i != end(); i++)
	{
		printf("%.*s: ", PFSTR(i->first));
		for (set<string>::const_iterator j = i->second.begin(); j != i->second.end(); j++)
			if (j == i->second.begin())
				printf("%.*s", PFSTR(*j));
			else
				printf(", %.*s", PFSTR(*j));
		printf("\n");
	}
}

// vim:set ts=3 sw=3:
