import sys
import itertools
import pytest

blacklist = ["test_dtm.py", # Requires hnswlib
             "test_knn.py", # Requires pykeops
             "test_representations.py", # Look into this
             "test_wasserstein_distance.py::test_wasserstein_distance_pot", # Requires eagerpy.
             "test_wasserstein_distance.py::test_wasserstein_distance_grad" # Requires eagerpy.
            ] 

print("Blacklist: %s" %(str(blacklist)))

testdir = sys.argv[1]

deselect_args = list(itertools.chain.from_iterable([["--deselect", "%s/%s" %(testdir, exclude)] for exclude in blacklist]))

exitcode = pytest.main([testdir] + deselect_args)
exit(exitcode)
