#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <time.h>
#include <libxml/parser.h>
#include <libxml/tree.h>
#include <glib.h>


GList * gl_list()
{
	gchar *string = NULL;
	GList *list = NULL;
	xmlDocPtr list_doc;
	xmlNodePtr list_root,cur;
	string = g_strdup_printf("%s/.gtodo/list", g_getenv("HOME"));
	if(!g_file_test(string, G_FILE_TEST_EXISTS))
	{
		g_free(string);
		return NULL;	
	}	
	list_doc = xmlParseFile(string);
	if(list_doc == NULL)
	{
		return NULL;
	}
	list_root = xmlDocGetRootElement(list_doc);
	cur = list_root->xmlChildrenNode;
	while(cur != NULL)
	{
		if(xmlStrEqual(cur->name,(const xmlChar *) "task_list"))
		{
			xmlChar *temp = xmlGetProp(cur, (const xmlChar *)"file");
			list = g_list_append(list, g_strdup((gchar *)temp));
			xmlFree(temp);                                           	
		}
		cur = cur->next;
	}
	xmlFreeDoc(list_doc);
	xmlCleanupParser();
	g_free(string);	
	return g_list_first(list);
}


void gl_update(gchar *file)
{
	gchar *string = NULL;
	xmlDocPtr list_doc;
	xmlNodePtr list_root,cur;
	int found = FALSE;
	string = g_strdup_printf("%s/.gtodo/", g_getenv("HOME"));
	if(!g_file_test(string, G_FILE_TEST_IS_DIR))
	{
		g_mkdir(string,0755);
	}
	g_free(string);	
	string = g_strdup_printf("%s/.gtodo/list", g_getenv("HOME"));
	if(g_file_test(string, G_FILE_TEST_EXISTS))
	{
		list_doc = xmlParseFile(string);
		if(list_doc == NULL)
		{
			return;
		}
		list_root = xmlDocGetRootElement(list_doc);
	}
	else
	{
		list_doc = xmlNewDoc((xmlChar *)"1.0");
		list_root = xmlNewDocNode(list_doc, NULL, (xmlChar *)"tl", NULL);		
		xmlDocSetRootElement(list_doc, list_root);
	}
	cur = list_root->xmlChildrenNode;
	while(cur != NULL)
	{
		if(xmlStrEqual(cur->name, (const xmlChar *)"task_list"))
		{
			xmlChar *temp = xmlGetProp(cur, (const xmlChar *)"file");
			if(xmlStrEqual(temp, (const xmlChar *)file))
			{
				found = TRUE;
			}
			xmlFree(temp);
		}
		cur = cur->next;
	}
	if(!found)
	{
		xmlNodePtr new = xmlNewChild(list_root, NULL, (const xmlChar *)"task_list", NULL);
		xmlSetProp(new, (const xmlChar *)"file", (const xmlChar *)file);
	}
	printf("saving\n");
	xmlSaveFormatFile(string,list_doc,1);	
	g_free(string);
	xmlFreeDoc(list_doc);
	xmlCleanupParser();
}



