#include <gtk/gtk.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <getopt.h>
#include <gconf/gconf.h>
#include "main.h"

void parse_command (int argc, char **argv);
void make_home_dir(gchar *path);
void load_config();
void check_xml();
gint xsize=-1, ysize=-1, xpos=-1, ypos=-1, last_category = -1;
gboolean do_hide = FALSE;

/* settings struct */
sets settings;

#include <gconf/gconf.h>

GConfEngine* gconf_engine_get_default (void); 

int main(int argc, char **argv){
    
    bindtextdomain(GETTEXT_PACKAGE, LOCALEDIR);
    bind_textdomain_codeset(GETTEXT_PACKAGE, "UTF-8");
    textdomain(GETTEXT_PACKAGE);
    setlocale(LC_ALL,"");

    parse_command (argc, argv);

    gtk_init(&argc, &argv);
    



	/* set default settings */
	settings.lastid= 0;
	/* Enable tray by default..  user won't know if he/she doesnt have tray */
	/* this is just for people who don't want it in there tray */
	settings.do_tray = TRUE;
	settings.place = TRUE;
	settings.size = TRUE;
	settings.ask_delete_category 	= TRUE;
	settings.show_date_column 	= TRUE;
	/* this is kinda (thanks gtk :-/) buggy.. gtk need fix first */
	settings.list_tooltip		= FALSE;
	/* auto purge is default on.. */
	settings.auto_purge		= TRUE;
	/* set default auto purge to a week */	
	settings.purge_days		= 7;
	/* check xml and load it*/
	check_xml();
 

	/* load the config file settings .. */
	load_config();

	/* create the main window */
 	gui_create_main_window();
    

    if(settings.auto_purge) get_all_past_purge();
    /* this is for the popup of the tray icon. */
    /* I am not sure it I want to do it every 5 seconds or only when things changed */
    g_timeout_add(5000, (GSourceFunc)get_all_due_dates, NULL);
    
    if(xsize != -1 && ysize != -1 && settings.size) gtk_window_resize(GTK_WINDOW(mw.window), xsize, ysize);
    if(xpos != -1 && ypos != -1 && settings.place)     gtk_window_move(GTK_WINDOW(mw.window), xpos, ypos);
    
    
    
    /* read the categorys */
    read_categorys();

    if(last_category != -1 && last_category < categorys+3) gtk_option_menu_set_history(GTK_OPTION_MENU(mw.option), last_category);
    /* nasty thing to fix the tooltip in the list */
    if(settings.list_tooltip) gtk_tree_view_set_headers_visible(GTK_TREE_VIEW(mw.treeview), FALSE);			

    if(do_hide) hidden = 1;
    else gtk_widget_show_all(mw.window);
        
    gtk_main();
    return 0;
}


/************************
 save the xml file and quit 
 ************************/
void quit_program(){
    save_xml();
    gtk_main_quit();
}


void make_home_dir(gchar *path)
    {
      if (mkdir (path, 0755) < 0) g_error (_("gtodo: failed to create: %s"), path);
    }


/* save some settings in between the <config> brackets */
/* this are attributs..  f.e. the lastid user */

void load_config()
    {
    xmlNodePtr cur = root->xmlChildrenNode;
    while(cur != NULL)
	{
        if(xmlStrEqual(cur->name, "config"))
	    {
	    xmlChar *temp;
	    /* load lastid */
	    temp = xmlGetProp(cur,"lastid");
	    if(temp != NULL)
		{
		settings.lastid= atoi(temp);
		xmlFree(temp);
		}
	    temp = xmlGetProp(cur,"do_tray");
	    if(temp != NULL)
		{
		settings.do_tray = atoi(temp);
		xmlFree(temp);
		}	
		    /* load lastid */
	    temp = xmlGetProp(cur,"xsize");
	    if(temp != NULL)
		{
		xsize = atoi(temp);
		xmlFree(temp);
		}
	    temp = xmlGetProp(cur,"ysize");
	    if(temp != NULL)
		{
		ysize = atoi(temp);
		xmlFree(temp);
		}
	    temp = xmlGetProp(cur,"xpos");
	    if(temp != NULL)
		{
		xpos = atoi(temp);
		xmlFree(temp);
		}
	    temp = xmlGetProp(cur,"ypos");
	    if(temp != NULL)
		{
		ypos = atoi(temp);
		xmlFree(temp);
		}	
	    temp = xmlGetProp(cur,"save_size");
	    if(temp != NULL)
		{
		settings.size = atoi(temp);
		xmlFree(temp);
		}
	    temp = xmlGetProp(cur,"save_place");
	    if(temp != NULL)
		{
		settings.place = atoi(temp);
		xmlFree(temp);
		}	
	    temp = xmlGetProp(cur,"show_date_column");
	    if(temp != NULL)
		{
		settings.show_date_column = atoi(temp);
		xmlFree(temp);
		}	
	    temp = xmlGetProp(cur,"list_tooltip");
	    if(temp != NULL)
		{
		settings.list_tooltip = atoi(temp);
		xmlFree(temp);
		}	
	    temp = xmlGetProp(cur,"last_category");
	    if(temp != NULL)
		{
		last_category = atoi(temp);
		xmlFree(temp);
		}	
	/* get auto purge */
	    temp = xmlGetProp(cur,"auto_purge");
	    if(temp != NULL)
		{
		settings.auto_purge = atoi(temp);
		xmlFree(temp);
		}
	/* get the n of days after completion it should purge */
	    temp = xmlGetProp(cur,"purge_days");
	    if(temp != NULL)
		{
		settings.purge_days = atoi(temp);
		xmlFree(temp);
		}
	    }
	cur = cur->next;
	}
    }

void save_xml()
    {
    xmlNodePtr cur = root->xmlChildrenNode;
    gchar *base_path = g_strdup_printf("%s/.gtodo/todos", g_getenv("HOME"));    
    int saved = 0;

    gtk_window_get_size(GTK_WINDOW(mw.window), &xsize, &ysize);
    gtk_window_get_position(GTK_WINDOW(mw.window), &xpos, &ypos);
    
    while(cur != NULL)
	{
        if(xmlStrEqual(cur->name, "config"))
	    {
	    gchar *tstr;
	    saved = 1;
	    /** save last id (so every new item has unique id**/
	    tstr = g_strdup_printf("%i", settings.lastid);
	    xmlSetProp(cur,"lastid", tstr);
	    g_free(tstr);
	    
	    /** save do_tray **/
	    tstr = g_strdup_printf("%i", settings.do_tray);
	    xmlSetProp(cur, "do_tray", tstr);
	    g_free(tstr);
	    /** save save_size**/
  	    tstr = g_strdup_printf("%i", settings.size);
	    xmlSetProp(cur, "save_size", tstr);
	    g_free(tstr);
	    
	    /** save save_place**/
  	    tstr = g_strdup_printf("%i", settings.place);
	    xmlSetProp(cur, "save_place", tstr);
	    g_free(tstr);


	    /** save start_hidden**/
  	    tstr = g_strdup_printf("%i", settings.show_date_column);
	    xmlSetProp(cur, "show_date_column", tstr);
	    g_free(tstr);

  	    tstr = g_strdup_printf("%i", settings.list_tooltip);
	    xmlSetProp(cur, "list_tooltip", tstr);
	    g_free(tstr);

  	    tstr = g_strdup_printf("%i", gtk_option_menu_get_history(GTK_OPTION_MENU(mw.option)));
	    xmlSetProp(cur, "last_category", tstr);
	    g_free(tstr);
	    
	    /* auto purge */
      	    tstr = g_strdup_printf("%i", settings.auto_purge);
	    xmlSetProp(cur, "auto_purge", tstr);
	    g_free(tstr);

  	    tstr = g_strdup_printf("%i", settings.purge_days);
	    xmlSetProp(cur, "purge_days", tstr);
	    g_free(tstr);
	    	    
	    	    
	    if(hidden == 0){
	    tstr = g_strdup_printf("%i", xpos);
	    xmlSetProp(cur,"xpos", tstr);
	    g_free(tstr);
	    tstr = g_strdup_printf("%i", ypos);
	    xmlSetProp(cur,"ypos", tstr);
	    g_free(tstr);
	    tstr = g_strdup_printf("%i", xsize);
	    xmlSetProp(cur,"xsize", tstr);
	    g_free(tstr);
	    tstr = g_strdup_printf("%i", ysize);
	    xmlSetProp(cur,"ysize", tstr);
	    g_free(tstr);
	    }	    
	    }
	cur = cur->next;
	}
    /* check if there is a config entry.. (and is saved) if not.. save it now */
    if(cur == NULL && saved == 0)
	{
		xmlNodePtr newn;
		gchar *tstr;
		cur = root;
		newn = xmlNewChild(cur, NULL, "config", NULL);
		tstr = g_strdup_printf("%i", settings.lastid);
		xmlSetProp(newn, "lastid", tstr);
		g_free(tstr);
		tstr = g_strdup_printf("%i", settings.do_tray);
		xmlSetProp(newn, "do_tray", tstr);
		g_free(tstr);
    	}


    xmlSaveFormatFile(base_path, my_xml_tree, 1);
    g_free(base_path);
    }
    
void check_xml()
	{
	  gchar *base_path = g_strdup_printf("%s/.gtodo/", g_getenv("HOME"));
		/* test if the homedir exists and if not create it */
		/* this just to make sure nothing messes up.. */
 		if(!g_file_test(base_path, G_FILE_TEST_IS_DIR)) make_home_dir(base_path);
    		g_free(base_path);
    
    
		/* create a string that contains the location of the xml file. */
		base_path = g_strdup_printf("%s/.gtodo/todos", g_getenv("HOME"));
    
		/* check if the file exists.. if so.. open it.. if not.. create a new xmlDoc */
 		if(g_file_test(base_path, G_FILE_TEST_EXISTS))
			{
        		my_xml_tree = xmlParseFile (base_path);    
			}
    		else{
			xmlNodePtr newn;
	 		my_xml_tree = xmlNewDoc("1.0");
	 		root = xmlNewDocNode(my_xml_tree, NULL, "gtodo", NULL);	 
	 		xmlDocSetRootElement(my_xml_tree, root);
			newn = xmlNewTextChild(root, NULL, "category", NULL);	
		    	xmlNewProp(newn, "title", _("Personal"));
			newn = xmlNewTextChild(root, NULL, "category", NULL);	
		    	xmlNewProp(newn, "title", _("Business"));
			newn = xmlNewTextChild(root, NULL, "category", NULL);	
		    	xmlNewProp(newn, "title", _("Unfiled"));
	 		}

    		/* get root element.. this "root" is used in the while program */    
    		root = xmlDocGetRootElement(my_xml_tree);
    
    		/* check if the name of the root file is ok.. just to make sure :) */
    		if(!xmlStrEqual(root->name, (const xmlChar *)"gtodo"))
			{
			  g_error(_("invalid xml file\n"));
	 		}
	 
	 		g_free(base_path);
	 }




void parse_command (int argc, char **argv) 
    {
    int i;
    if(argc < 2) return;
    for(i=1; i< argc; i++) 
	{
	  if(!strncmp(argv[i], "-h", 2) || !strncmp(argv[i], "--hide", 6)
	     || !strncmp(argv[i], _("--hide"), strlen(_("--hide")))) do_hide = TRUE;
	  else if(!strncmp(argv[i], "-?", 2) || !strncmp(argv[i], "--help", 6) || !strncmp(argv[i], _("--help"), strlen(_("--help"))))
		{
		  printf(_("gtodo v%s\ngtodo has to following commandline options:\n-h	--hide	Hide the main window on startup.\n		This bypasses the check for a notification tray.\n		so only use it when you have one.\n-?	--help	This Message.\n"), VERSION);
			exit(1);
		}
	else{
	  printf(_("gtodo v%s\nRun with -? or --help to see the availible commandline options\n"), VERSION);
		exit(1);
		}
	}
   }
