
#ifndef VFS_UNIXTREE_H
#define VFS_UNIXTREE_H

#include "vfs.h"

/* create a vfs based on the standard unix tree.
 * If root is given, a special kind of tree is created which doesn't
 * support symlinks. This mode is called symlinktree as symbolic links
 * are used internally to support linking across filesystem boundaries
 * (storing files by reference).
 * If you want the normal unixtree, set root to NULL */
vfs_filesystem *vfs_unixtree_create(char *root);

/* change the root of the unixtree symlink fs. */
void vfs_unixtree_setroot(vfs_filesystem *fs,const char *root);

#endif // VFS_UNIXTREE_H
