/* tracktype for all unidentified raw data files */

#ifndef STDFILETRACK_H
#define STDFILETRACK_H

#include "tracks.h"
#include "varman.h"
#include "rterm.h"
#include "vfs.h"

#ifdef HAVE_PTHREADS
#include <pthread.h>
#endif

#define STDFILETRACK_MAXTRACKTYPES 30

typedef struct 
{
        char *uri;
	int  filedes;             /* file descriptor pointing to the file if open,otherwise -1 */
	char *suffix;             /* convenience pointer to the filenames suffix */
	int  convpid;             /* pid and pipe of the converter process */
	int  filterpid;           /* containing the gtoaster internal filters pid */
	int  tracksize;           /* cache for tracksize */
	
	/* the rterm info is used if in debugging mode only (#define DEBUG in
	 * stdfiletrack.c */						     
	rterm_pipeinfo *debugfilter;
	int  errp;
	
} stdfiletrack_info;   

extern varman_database *stdfiletrack_tracktypes;
/* the getpos function is used by isotrack.c as well,so we need to export 
 * the corresponding buffer so's isotrack.c can set it up properly */
extern char outbuf[16384];

#ifdef HAVE_PTHREADS
extern pthread_mutex_t outbuf_mutex;
#define OUTBUF_LOCK   pthread_mutex_lock(&outbuf_mutex)
#define OUTBUF_UNLOCK pthread_mutex_unlock(&outbuf_mutex)
#else
#define OUTBUF_LOCK
#define OUTBUF_UNLOCK
#endif

/* maybe we should move this functions to another file on the long run.
 * wouldnt piping.c seem quite appropriate ? */
void stdfiletrack_byteswap(int cstdin,int cstdout,int cstderr,gpointer data);

tracks_trackinfo *stdfiletrack_create(char *uri);
void stdfiletrack_init();

#endif // STDFILETRACK_H
