#ifndef MAIN_H
#define MAIN_H

#include "config.h"
#include <gtk/gtk.h>

#include "vfs_unixtree.h"

/* uncomment to see debug messages */
/* #define DEBUG */

/* uncomment to print out all open instructions */
/* #define WATCHFD */

#define INITSIZE_X 640
#define INITSIZE_Y 480

#ifdef WATCHFD
extern int main_filedescriptor;
# define open(something,onemorething) main_filedescriptor=open(something,onemorething);printf("opened fd=%i in line %i of %s\n",main_filedescriptor,__LINE__,__FILE__)
#endif

extern char *execname;
extern GtkWidget *window;
extern char *CRLF;
extern GtkWidget *destination;   /* a "Notebook" for the "destinations" */
extern GtkWidget *surroundings;  /* thats where we dock the menubar 
				  * in the gtk version  */
extern GtkWidget *downbox;
extern GtkTooltips *tooltips;

/* The unixtree is global. Can be used from anywhere */
extern vfs_filesystem *unixtree;

#define main_settip(widget,text) gtk_tooltips_set_tip(tooltips,widget,text,NULL)

void main_quit();

#endif // MAIN_H
