/* remember layout configuration of gnometoaster's windows,esp.
 * the size of the main window */

#include <gtk/gtk.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "layoutconfig.h"
#include "defaultentries.h"
#include "configfile.h"
#include "varman.h"
#include "preferences.h"

/* uncomment for debugging */
/* #define DEBUG */

#define LAYOUTCONFIG_CONFIGSECTION "[Layout]"

typedef struct 
  {
     GtkWidget *w;
     char name[255];
     char value[255];
  }
layoutconfig_widgetentry;

GList *layoutconfig_widgets=NULL;

/* temporary buffer for the following function */
char layoutconfig_getvalue_copy[255];
/* return a specific definition within a widget entry */
char *layoutconfig_getstring(char *settings,char *name)
{
   char *result;
   #ifdef DEBUG
   printf ("layoutconfig_getstring: scanning %s for %s\n",
	   settings,name);
   #endif
   strcpy(layoutconfig_getvalue_copy,settings);
   result=strstr(layoutconfig_getvalue_copy,name);
   if ((result!=NULL)&&(*(result+strlen(name))=='='))
     {	
	/* position after '=' */
	result+=(strlen(name)+1);
	/* terminate with 0 */
	if (strchr(result,',')!=NULL)
	  *strchr(result,',')=0;
     };
   #ifdef DEBUG
   printf ("layoutconfig_getstring: result=%s\n",result);
   #endif
   return result;
};
int layoutconfig_getvalue(char *settings,char *name)
{
   char *string;
   int result;
   string=layoutconfig_getstring(settings,name);
   if (string!=NULL)
     {	
	sscanf(string,"%d",&result);
     }
   else
     result=0;
   return result;
};

/* update a widget with the values stored in value */
void layoutconfig_updatewidget(GtkWidget *w,char *value)
{
   if (w!=NULL)
     {
	if ((w->window!=NULL)
	    &&(layoutconfig_getvalue(value,"xpos")!=0)
	    &&(layoutconfig_getvalue(value,"ypos")!=0)
	    &&(layoutconfig_getvalue(value,"width")!=0)
	    &&(layoutconfig_getvalue(value,"height")!=0))
	  {	     
	     /* go lowlevel here ?!? */
	     gdk_window_move_resize(w->window,
				    layoutconfig_getvalue(value,"xpos"),
				    layoutconfig_getvalue(value,"ypos"),
				    layoutconfig_getvalue(value,"width"),
				    layoutconfig_getvalue(value,"height"));
	  };
     };
}; 

/* store informations about widget w in value */
void layoutconfig_getwidgetinfo(GtkWidget *w,char *value)
{
   int x,y,width,height;
   if (w!=NULL)
     {	
	gdk_window_get_position(w->window,&x,&y);	
	gdk_window_get_size(w->window,&width,&height);
	strcpy(value,"");
	sprintf(value,"width=%d,height=%d,xpos=%d,ypos=%d",
		width,height,x,y);
     };
};
   

layoutconfig_widgetentry *layoutconfig_findentry(const char *name)
{
   GList *current;
   layoutconfig_widgetentry *result=NULL;
   
   for (current=layoutconfig_widgets;
	current!=NULL;
	current=current->next)
     {
	if (!strcasecmp(((layoutconfig_widgetentry*)current->data)->name,
			name))
	  result=(layoutconfig_widgetentry*)current->data;
     };
   return result;
};

void layoutconfig_loaddatabase(gchar *filename)
{
   FILE *f;
   layoutconfig_widgetentry *e;
   char name[255];
   char value[255];
   
   f=fopen(filename,"r");
      
   /* if config file exists */
   if (f!=NULL)
     {	
	/* if layout definitions exist */   
	if (configfile_seeksection(f,LAYOUTCONFIG_CONFIGSECTION))
	  {
	     do
	       {
		  configfile_getnextentry(f,name,value);
		  if (strlen(name)>0)
		    {		  
		       e=layoutconfig_findentry(name);
		       if (e==NULL)
			 {
			    e=(layoutconfig_widgetentry*)malloc(sizeof(layoutconfig_widgetentry));
			    layoutconfig_widgets=g_list_append(layoutconfig_widgets,
							       (gpointer)e);
			    strcpy(e->name,name);
			    e->w=NULL;
			 };
		       /* update widget properties *
			* in case there's already a widget registered with this name */
		       strcpy(e->value,value);
		       layoutconfig_updatewidget(e->w,value);
		    };
	       }
	     while (strlen(name)>0);
	  };
	/* close config file only if it could be opened successfully */
	fclose(f);
     };
};

/* default window sizes are set this way */ 
void layoutconfig_widget_setvalue(const char *name, 
				  const char *value)
{
   layoutconfig_widgetentry *entry=layoutconfig_findentry(name);
   if (!entry)
     {
	entry=(layoutconfig_widgetentry*)malloc(sizeof(layoutconfig_widgetentry));
	strcpy(entry->name,name);
	entry->w=NULL;
	layoutconfig_widgets=g_list_append(layoutconfig_widgets,
					   (gpointer)entry);	
     };
   strcpy(entry->value,value);
};

/* save callback. gets called whenever the config file is saved 
 * updates all widget settings and writes them into the config file */
void layoutconfig_save(FILE *f,gpointer data)
{
   GList *current;
   layoutconfig_widgetentry *e;
   
   for (current=layoutconfig_widgets;
	current!=NULL;
	current=current->next)
     {
	e=(layoutconfig_widgetentry*)current->data;
	layoutconfig_getwidgetinfo(e->w,e->value);
	fprintf(f,"%s=%s\n",e->name,e->value);	
     };
};
   
  
/* initialize layoutconfig,register configfile entry */
void layoutconfig_init()
{
   /* Initialize to default values */
   layoutconfig_widget_setvalue("mainwindow",DEFAULTENTRIES_LAYOUT_MAINWINDOW);
   layoutconfig_widget_setvalue("preferences",DEFAULTENTRIES_LAYOUT_PREFERENCES);
   layoutconfig_widget_setvalue("blankingprogressdialog",DEFAULTENTRIES_LAYOUT_BLANKINGPROGRESSDIALOG);
   layoutconfig_widget_setvalue("addfilesdialog",DEFAULTENTRIES_LAYOUT_ADDFILESDIALOG);
   layoutconfig_widget_setvalue("recordprogressdialog",DEFAULTENTRIES_LAYOUT_RECORDPROGRESSDIALOG);
   layoutconfig_widget_setvalue("datacopydialog",DEFAULTENTRIES_LAYOUT_DATACOPYDIALOG);
   
   layoutconfig_loaddatabase(varman_replacevars_copy(dynamic_defs,
						     "$HOME/.gtoasterrc"));
   configfile_registersection(LAYOUTCONFIG_CONFIGSECTION,
			      layoutconfig_save,
			      NULL);
};

/* use this instead of gtk_widget_show() for widgets that should remember
 * their layout */
void layoutconfig_widget_show(GtkWidget *w,
			      gchar *name)
{
   layoutconfig_widgetentry *e;

   gtk_widget_show(w);
   e=layoutconfig_findentry(name);
   if (e==NULL)
     {		  
	e=(layoutconfig_widgetentry*)malloc(sizeof(layoutconfig_widgetentry));
	layoutconfig_widgets=g_list_append(layoutconfig_widgets,
					   (gpointer)e);
	strcpy(e->name,name);
	layoutconfig_getwidgetinfo(w,e->value);
     }
   else
     layoutconfig_updatewidget(w,e->value);
   e->w=w;
};

/* use this instead of gtk_widget_hide() for widgets that should remember
 * their layout */
void layoutconfig_widget_hide(GtkWidget *w,
			      gchar *name)
{
   layoutconfig_widgetentry *e;

   e=layoutconfig_findentry(name);
   /* store widget's layout informations if corresponding entry was found */
   if (e!=NULL)
     {	
	layoutconfig_getwidgetinfo(w,e->value);
	e->w=NULL;
     };
   gtk_widget_hide(w);
};


