/* This file is responsible for handling compilations, that is
 * the current layout of a CD. It will handle both filesystems and tracklists
 * and can load them as well as store them.
 * Respective handlers have to install themselves by specifying their
 * data structures. Only one data structure of a certain type can be registered
 * at a particular time. */
#ifndef COMPILATION_H
#define COMPILATION_H

#include "xml.h" /* Compilations are being stored in XML.
		  * So use our homemade xml parser here */

/* called whenever an operation initiated below is finished
 * (all functions that will take a longer time are 
 * asynchronous to allow for display updates to be done without
 * having to enter local message loops etc.).
 * Status is 0 for success, any other result specifies an error */
typedef void(*compilation_callback_t)(int status,void*data);
  
/* load a compilation, callback may be NULL */
void compilation_load(const char *filename,compilation_callback_t,void*data);

#define COMPILATION_FILESYSTEM "filesystem"
#define COMPILATION_TRACKLIST  "tracklist"

/* register a compilation component */
void compilation_registercomponent(const char *section,
				   xml_itemhandler_t handler,
				   void *data);

#endif // COMPILATION_H
