#ifndef INCLUDE_THEMES_H
#define INCLUDE_THEMES_H
/* ----------------------------------------------------------------------------
 * themes.h
 * prototypes and definitions for themes.c.
 *
 * Copyright 2002 Matthias Grimm (joker@cymes.de).
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version
 * 2 of the License, or (at your option) any later version.
 * ----------------------------------------------------------------------------*/

#include <gtk/gtk.h>

#define GLOBAL			0 /* general options, no popup */
#define BRIGHTNESS		1
#define VOLUME			2
#define MUTE			3
#define MOUSE			4
#define BATTERY			5
#define SLEEP			6
#define NOAUDIO			7
#define KBDILLU			8
#define CDROM			9

#define POPUPS			9
#define POPUP_BRIGHTNESS	(BRIGHTNESS-1)
#define POPUP_VOLUME		(VOLUME-1)
#define POPUP_MUTE		(MUTE-1)
#define POPUP_NOAUDIO		(NOAUDIO-1)
#define POPUP_MOUSE		(MOUSE-1)
#define POPUP_BATTERY		(BATTERY-1)
#define POPUP_SLEEP		(SLEEP-1)
#define POPUP_KBDILLU		(KBDILLU-1)
#define POPUP_CDROM		(CDROM-1)

#define POPUP_TYPE_PROGRESS	0
#define POPUP_TYPE_MESSAGE	1
#define POPUP_TYPE_IMAGE	2

#define VOLUME_MAX		100
#define BACKLIGHT_MAX		15
#define KBDILLU_MAX		15

#define TIMEOUT_MIN		2
#define TIMEOUT_LEVER		7	/* in 10th of a second */
#define TIMEOUT_NOTICE		15

struct theme {
	char		name[30];
	int		bgtype;
	GtkWidget	*bgimage;
	int		bgalpha;
	int		popup_active[POPUPS];
	int		popup_time[POPUPS];
	struct sample	*volsound;
	struct sample	*warnsound;
	int		havesound;
	int		(*layout_init)();   /* load layout resources, etc. */
	int		(*layout_attach)();  /* attach a wdget tree to a given window */
	void		(*layout_cleanup)(); /* free mem, etc. */
	void		(*layout_update)(struct theme *td, GtkWidget *window, int popup, ...);
	void		*user_data;
};

struct themeoption {
	int	popup;
	char	*option;
	int	(*process)();
	void	*data;
};

struct layoutengine {
	char	*name;
	int	(*layout_init)();  /* load layout resources, etc. */
	int	(*layout_attach)();  /* attach a wdget tree to a given window */
	void	(*layout_cleanup)(); /* free mem, etc. */
	void	(*layout_update)(struct theme *td, GtkWidget *window, int popup, ...);
};

/* public prototypes */
struct theme *theme_init (char *name);
void theme_exit (struct theme *td);
int is_theme (char *name);

int theme_load_data (struct theme *td, struct themeoption *tab, int tablen);
int theme_bool (struct theme *td, char *arg, int *data);
int theme_int (struct theme *td, char *arg, int *data);
int theme_layout (struct theme *td, char *arg, int *data);
int theme_bgtype (struct theme *td, char *arg, int *data);
int theme_image (struct theme *td, char *arg, GtkWidget **data);
int theme_sound (struct theme *td, char *arg, struct sample **data);

/* gtk+ layout theme engine */
int layout_classic_init (struct theme *td);
void layout_classic_exit (struct theme *td);
int layout_classic_attach (struct theme *td, GtkWidget *window);
void layout_classic_update (struct theme *td, GtkWidget *window, int popup, ...);

/* macosx layout theme engine */
int layout_macosx_init (struct theme *td);
void layout_macosx_exit (struct theme *td);
int layout_macosx_attach (struct theme *td, GtkWidget *window);
void layout_macosx_update (struct theme *td, GtkWidget *window, int popup, ...);

#endif    /* INCLUDE_THEMES_H */
