#ifndef INCLUDE_AUDIO_H
#define INCLUDE_AUDIO_H
/* ----------------------------------------------------------------------------
 * audio.h
 * prototypes and definitions for audio.c.
 *
 * Copyright 2002 Matthias Grimm (joker@cymes.de).
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version
 * 2 of the License, or (at your option) any later version.
 * ----------------------------------------------------------------------------*/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <audiofile.h>

#define DEFAULT_AUDIO	"/dev/dsp"

struct dspdata {
	int	active;       /* =1, if sound system is active */
	char *audiodev;
	int maxblocksize;
	int playbeep;
	pthread_mutex_t mutex;
	pthread_cond_t cond;
	pthread_t thread;
	struct sample *sample;   /* sound to play */
};

struct sample {
	char *audiodata;
	int audiodatalen;
	int format;
	int stereo;
	int speed;
};

/* prototypes */
struct sample* load_sample (char *samplename);

void cleanup_audio(struct dspdata *dsp);
void *play_sample (void *arg);

void trigger_beep(struct dspdata *dsp, struct sample *sample);
int init_sound_thread(struct dspdata *dsp);

#endif    /* INCLUDE_AUDIO_H */
