// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GDKMM_GL_CONTEXT_H
#define _GDKMM_GL_CONTEXT_H

#include <glibmm.h>

// -*- C++ -*-
/* gdkglextmm - C++ Wrapper for GdkGLExt
 * Copyright (C) 2002-2003  Naofumi Yasufuku
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA.
 */

#include <gdkmm/gl/defs.h>
#include <gdkmm/gl/tokens.h>
#include <gdkmm/gl/config.h>
#include <gdkmm/gl/drawable.h>

#include <GL/gl.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GdkGLContext GdkGLContext;
typedef struct _GdkGLContextClass GdkGLContextClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gdk
{

namespace GL
{ class Context_Class; } // namespace GL

} // namespace Gdk
namespace Gdk
{
namespace GL
{

class Drawable;

  /** OpenGL rendering context.
   *
   *
   */


class Context : public Glib::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Context CppObjectType;
  typedef Context_Class CppClassType;
  typedef GdkGLContext BaseObjectType;
  typedef GdkGLContextClass BaseClassType;

private:  friend class Context_Class;
  static CppClassType context_class_;

private:
  // noncopyable
  Context(const Context&);
  Context& operator=(const Context&);

protected:
  explicit Context(const Glib::ConstructParams& construct_params);
  explicit Context(GdkGLContext* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~Context();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GdkGLContext*       gobj()       { return reinterpret_cast<GdkGLContext*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GdkGLContext* gobj() const { return reinterpret_cast<GdkGLContext*>(gobject_); }

  GdkGLContext* gobj_copy();

private:


protected:

  Context(const Glib::RefPtr<const Drawable>& gldrawable,
          const Glib::RefPtr<const Context>& share_list,
          bool direct = true,
          int render_type = RGBA_TYPE);

  explicit Context(const Glib::RefPtr<const Drawable>& gldrawable,
                   bool direct = true,
                   int render_type = RGBA_TYPE);

public:

  /** Create a new OpenGL rendering context.
   *
   * @param gldrawable   a Gdk::GL::Drawable.
   * @param share_list   the Gdk::GL::Context which to share display lists.
   * @param direct       whether rendering is to be done with a direct
   *                     connection to the graphics system.
   * @param render_type  Gdk::GL::RGBA_TYPE or Gdk::GL::COLOR_INDEX_TYPE
   *                     (currently not used).
   * @return  the new Gdk::GL::Context.
   */
  static Glib::RefPtr<Context> create(const Glib::RefPtr<const Drawable>& gldrawable,
                                      const Glib::RefPtr<const Context>& share_list,
                                      bool direct = true,
                                      int render_type = RGBA_TYPE);

  /** Create a new OpenGL rendering context.
   *
   * @param gldrawable   a Gdk::GL::Drawable.
   * @param direct       whether rendering is to be done with a direct
   *                     connection to the graphics system.
   * @param render_type  Gdk::GL::RGBA_TYPE or Gdk::GL::COLOR_INDEX_TYPE
   *                     (currently not used).
   * @return  the new Gdk::GL::Context.
   */
  static Glib::RefPtr<Context> create(const Glib::RefPtr<const Drawable>& gldrawable,
                                      bool direct = true,
                                      int render_type = RGBA_TYPE);

public:

  /** Copy state from one rendering context to another.
   *
   * @a mask contains the bitwise-OR of the same symbolic names that
   * are passed to the glPushAttrib() function. You can use
   * GL_ALL_ATTRIB_BITS to copy all the rendering state information.
   *
   * @param src   the source context.
   * @param mask  which portions of @a src state are to be copied.
   * @return  <tt>false</tt> if it fails, <tt>true</tt> otherwise.
   */
  bool copy(const Glib::RefPtr<const Context>& src,
            unsigned long mask = GL_ALL_ATTRIB_BITS);

  
  /** Gets Gdk::GLDrawable to which the @a glcontext  is bound.
   * @return The Gdk::GLDrawable or <tt>0</tt> if no Gdk::GLDrawable is bound.
   */
  Glib::RefPtr<Drawable> get_gl_drawable();
  
  /** Gets Gdk::GLDrawable to which the @a glcontext  is bound.
   * @return The Gdk::GLDrawable or <tt>0</tt> if no Gdk::GLDrawable is bound.
   */
  Glib::RefPtr<const Drawable> get_gl_drawable() const;

  
  /** Gets Gdk::GLConfig with which the @a glcontext  is configured.
   * @return The Gdk::GLConfig.
   */
  Glib::RefPtr<Config> get_gl_config();
  
  /** Gets Gdk::GLConfig with which the @a glcontext  is configured.
   * @return The Gdk::GLConfig.
   */
  Glib::RefPtr<const Config> get_gl_config() const;

  
  /** Gets Gdk::GLContext with which the @a glcontext  shares the display lists and
   * texture objects.
   * @return The Gdk::GLContext.
   */
  Glib::RefPtr<Context> get_share_list();
  
  /** Gets Gdk::GLContext with which the @a glcontext  shares the display lists and
   * texture objects.
   * @return The Gdk::GLContext.
   */
  Glib::RefPtr<const Context> get_share_list() const;

  
  /** Returns whether the @a glcontext  is a direct rendering context.
   * @return <tt>true</tt> if the @a glcontext  is a direct rendering contest.
   */
  bool is_direct() const;

  
  /** Gets render_type of the @a glcontext .
   * @return GDK_GL_RGBA_TYPE or GDK_GL_COLOR_INDEX_TYPE.
   */
  int get_render_type() const;

  
  /** Returns the current Gdk::GLContext.
   * @return The current Gdk::GLContext or <tt>0</tt> if there is no current
   * context.
   */
  static Glib::RefPtr<Context> get_current();


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} // namespace GL
} // namespace Gdk


namespace Glib
{
  /** @relates Gdk::GL::Context */
  Glib::RefPtr<Gdk::GL::Context> wrap(GdkGLContext* object, bool take_copy = false);
}


#endif /* _GDKMM_GL_CONTEXT_H */

