/* follow_focus.c
 * For use with GTKeyboard
 * by Patrick Gallot <patrick.gallot@cimlinc.com>
 *
 * This file handles the foreign window tracking.  The last window that
 * had the focus will be the window that all redirect actions go into.
 */
/* GTKeyboard - A Graphical Keyboard For X
 * Copyright (C) 1999, 2000
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 */

#define FOLLOW_FOCUS_C
#include "master.h"

gint track_focus(gpointer data)
{
     Window winFocus;
     Window wfcopy;
     int revert_to_return;
     char *winName;

     /* find out which window currently has focus */
     XGetInputFocus(GDK_DISPLAY(), &winFocus, &revert_to_return);
     wfcopy = winFocus;

     /* Return if the window is the same or if it's the program
      * window or if we can't redirect to that window.
      *
      * If there was a previous window that was any good, stick to
      * that one.
      */
     if(winFocus == options.redirect_window ||
	winFocus == GUI.xwindow             ||
	winFocus == None                    ||
	winFocus == PointerRoot)
     {
#if defined(FOLLOW_FOCUS_DEBUGGING)
	  if(winFocus == options.redirect_window)
	       chocolate("Invalid window.  (redirect)\n");
	  else if(winFocus == GUI.xwindow)
	       chocolate("Invalid window.  (xwindow).\n");
	  else if(winFocus == None)
	       chocolate("Invalid window.  None.\n");
	  else if(winFocus == PointerRoot)
	       chocolate("Invalid window.  Root.\n");
#endif /* FOLLOW_FOCUS_DEBUGGING */

	  return TRUE;
     } /* End if */
     
     /* At this point, we know the window is "good" and that we want
      * it's name.  We're going to use it as the redirect from now on.
      */
     
     /* set up error trapping, in case we get a BadWindow error */
     gdk_error_trap_push();
     
     /* this could generate the error */
     XFetchName(GDK_DISPLAY(), winFocus, &winName);
     
     gdk_flush();

     if(gdk_error_trap_pop())
     {  
	  /* Oops...error.  Probably BadWindow */
	  CONDFREE(options.redirect_window_name);

	  options.redirect_window = None; /* reset focus window */
	  options.other           = None;
	  
	  chocolate("There was an error finding a valid redirect window.\n");
	  return TRUE;  /* better luck next time */
     } /* End if */
     
     /* since we made it this far, update the window_name */
     if(winName && !strstr(winName,"gtkeyboard") && !strstr(winName,APPNAME))
     {  
	  CONDFREE(options.redirect_window_name);

	  /* Grab the window definition */
	  options.redirect_window = wfcopy;
	  options.other           = wfcopy;
	  
	  options.redirect_window_name = g_strdup_(winName);
	  chocolate("Found new redirect window name (implicit):  \"");
	  chocolate(options.redirect_window_name);
	  chocolate("\"\n");
     } /* End if */
#ifdef FOLLOW_FOCUS_DEBUGGING
     else 
     {
	  if(winName)
	  {
	       chocolate("Sorry, but ");
	       chocolate(winName);
	       chocolate(" won't work.\n");
	  } /* End if */
     } /* End else */
#endif /* FOLLOW_FOCUS_DEBUGGING */

     return TRUE;	
} /* End track_focus */
