/* Example to print the X modifier table mapping.
 * Written by David Allen <s2mdalle@titan.vcu.edu>
 * Released under the the terms of the GNU General Public License
 *
 * Run this standalone program with no arguments.  Output to stdout.
 */

#include <stdio.h>
#include <stdlib.h>
#include <X11/Xlib.h>
#include <X11/X.h>
#include <X11/keysymdef.h>
#include <string.h>

#define Q stderr

void x_print_mapping(Display *dpy)
{
     XModifierKeymap *map = XGetModifierMapping(dpy);
     int x=0, y=0;
     KeySym sym=(KeySym)NULL;
     KeyCode c;
     char *txt=(char*)NULL;
     char *strs[8] = { "ShiftMask",
                       "LockMask",
                       "ControlMask",
                       "Mod1Mask",
                       "Mod2Mask",
                       "Mod3Mask",
                       "Mod4Mask",
                       "Mod5Mask" };
                       
     

     for(x=0; x<8; x++) {
          fprintf(Q,"====== SET #%d Name: %s Mask (Hex/Dec): 0x%lx %ld\n", 
                  x, strs[x], (unsigned long)(1<<x),
                  (unsigned long)(1<<x));
          
          for(y=0; y<map->max_keypermod; y++) { 
               c = map->modifiermap[x*map->max_keypermod+y];
               sym = XKeycodeToKeysym(dpy, c, 0);
               txt = XKeysymToString(sym);

               if(c != 0) /* Only print valid entries */
               {
                    fprintf(Q, "Modifier: code %d sym %ld string \"%s\"\n",
                            c, (long)sym, 
                            txt ? txt : "*null*");
               } /* End if */
          } /* End for */
     } /* End while */

     fflush(Q);
     XFreeModifiermap(map);
} /* End x_print_mapping() */

int main(int argc, char *argv[]) 
{
     Display *dpy = XOpenDisplay((char *)NULL);
     
     /* Gotta love the lack of error checking */
     x_print_mapping(dpy);
     XCloseDisplay(dpy);

     return 0;
} /* End main() */
