/* RANDOM_XPM.c
 *
 * Written by David Allen, s2mdalle@titan.vcu.edu
 * http://opop.nols.com/
 *
 * For use with GTKeyboard, or as a standalone app with 
 * NEED_RANDOM_XPM_MAIN defined.  If you would like a perl version of this
 * file, email me, and I'll send it to you.  This is a C rewrite of what
 * was originally a small perl script that has a bit more flexibility than
 * this does at the moment.
 *
 * Creates a random xpm image of a specified height/width/color number
 * and writes it to a user-specified file.
 *
 * This program is released under the terms of the GNU General Public License.
 * See COPYING that came with this distribution or http://www.gnu.org/
 * for more details.
 */

/* Include-fu */
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>
#include <time.h>
/* #include <glib.h> */

/* Change this to whatever you want - they seem like reasonable defaults. */
#define DEFAULT_WIDTH                    50
#define DEFAULT_HEIGHT                   50
#define DEFAULT_COLORS                   50

long SIXTEEN_TO_THE_6TH = 16777216;

/* If NEED_RANDOM_XPM_MAIN is defined, which will be done through the 
 * Makefile, this file will compile into a standalone program which will
 * generate random xpm images.  If it's not defined, then it will be 
 * compilable as object code into GTKeyboard without all the functions 
 * needed for the standalone
 */

#ifdef NEED_RANDOM_XPM_MAIN
static void usage(const char *progname);
static void xpmgen(const char *filename, const long height, const long width,
		   const int colors);

int main(int argc, char *argv[])
{
     long height = DEFAULT_HEIGHT;
     long width  = DEFAULT_WIDTH;
     int colors  = DEFAULT_COLORS;
     
     if(argc<2)
     {
	  usage(argv[0]);
	  exit(0);
     }
     if(argc<3)
     {
	  printf("Using HEIGHT=%ld WIDTH=%ld COLORS=%d...\n",height, width,
		 colors);
	  xpmgen(argv[1], height, width, colors);
	  exit(0);
     }
     else if(argc<4)
     {
	  printf("Using HEIGHT=%ld WIDTH=%ld COLORS=%d...\n",atol(argv[2]), 
		 width, colors);
	  xpmgen(argv[1], atol(argv[2]), width, colors);
	  exit(0);
     }
     else if(argc<5)
     {
	  printf("Using HEIGHT=%ld WIDTH=%ld COLORS=%d...\n",atol(argv[2]), 
		 atol(argv[3]), colors);
	  xpmgen(argv[1], atol(argv[2]), atol(argv[3]), colors);
	  exit(0);
     }
     else
     {
	  printf("Using HEIGHT=%ld WIDTH=%ld COLORS=%d...\n",atol(argv[2]),
		 atol(argv[3]), atoi(argv[4]));
	  xpmgen(argv[1], atol(argv[2]), atol(argv[3]), atoi(argv[4]));
	  exit(0);
     }
     exit(0);
}

static void usage(const char *progname)
{
     printf("%s:  Copyright (C) 1999 David Allen <s2mdalle@titan.vcu.edu>\n",
	    progname);
     printf("Usage:  %s filename height width colors\n",progname);
     exit(0);
}

static void xpmgen(const char *filename, const long height, const long width,
		   const int colors)
{
     FILE *fp;
     register int x, y;
     /* I am hoping that other machines don't choke on the octal characters.
      * It probably depends on your image viewer...I plead ignorance.  It 
      * works on my machine.
      */
     char charset[] = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890!@#$%^&*()_+-=`~<>.,'?/;: \\[]{}|\200\201\202\203\204\205\206\207\208\209\210\211\212\213\214\215\216\217\218\219\220";
     
     if(colors > strlen(charset))
     {
	  fprintf(stderr,"Sorry, I don't support that many colors.\n");
	  fprintf(stderr,"I can handle a maximum of %d\n",strlen(charset));
	  fprintf(stderr,"Do you *really* need more than that?\n");
	  return;
     }

     if((fp = fopen(filename,"w")) ==NULL)
     {
	  fprintf(stderr,"Can't open %s for writing: %s\n",filename,
		  strerror(errno));
	  return;
     } /* End if */

     srand(time((time_t *)NULL) + getpid() + (getpid() << 15));

     fprintf(fp,"/* XPM */\n");
     fprintf(fp,"static char * %s[] = {\n",filename);
     fprintf(fp,"\"%ld %ld %d 1\",\n",width, height, colors);

     for(x=0; x<colors; x++)
     {
	  fprintf(fp,"\"%c   c #%lX\",\n",charset[x],
		  (rand() % SIXTEEN_TO_THE_6TH));

     }

     for(x=0; x<height; x++)
     {
	  fprintf(fp,"\"");
	  for(y=0; y<width; y++)
	  {
	       fprintf(fp,"%c",(charset[(rand() % colors)]));
	  } /* End for */
	  fprintf(fp,"\",\n");
     } /* End for */

     fprintf(fp,"};");
     fflush(fp);
     fclose(fp);
     
     printf("Done creating %s.\n",filename);
     return;
} /* End xpmgen */
#endif /* NEED_RANDOM_XPM_MAIN */


