/* 
** attributes.c: Handles the attributes of widgets
** copyright: (c) 2003 by Lszl Pere
** email: pipas@linux.pte.hu
**
** This program is free software; you can redistribute it and/or 
** modify  it under the terms of the GNU General Public License as
** published by the Free Software Foundation; either version 2 of
** the License, or (at your option) any later version.
*/
#include <glib/gmem.h>

#include "gtkdialog.h"
#include "memory.h"

void *pip_malloc(size_t size, const char *caller)
{
	void *memory;
#ifdef MEMORY_DEBUG
	fprintf(stderr, "%s(): allocating %Zd bytes for '%s()'\n", 
			__func__, size, caller);
	fflush(stderr);
#endif
	memory = g_malloc(size);
	if (memory == NULL) {
		fprintf(stderr, "%s(): Unable to get memory for %s.\n",
			__func__, caller);
		exit(EXIT_FAILURE);
	}
	return memory;
}

void pip_free(void *memory, const char *caller){
#ifdef MEMORY_DEBUG
	fprintf(stderr, "%s(): freeing for '%s()'\n", __func__, caller);
	fflush(stderr);
#endif
	g_free(memory);
}

