#ifndef AUTOMATON_H
#define AUTOMATON_H

#define _GN_SOURCE
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>

#include "gtkdialog.h"
#include "stack.h"
#include "attributes.h"
#include "stringman.h"
#include "main.h"

extern char   *program_src;
extern int    source;
extern int    charsreaded;
extern FILE   *sourcefile;
extern int    debug;
char *wtitle;

typedef int token;

typedef struct _instruction {
	token      command;
	char      *argument;
	tag_attr  *tag_attributes;
} instruction;

typedef struct actioncommand {
  GtkWidget   *source_widget;
  char        *destination_name;
} actioncommand;

/*                                -- Type of widget      */
/*                              xxxxxxxx                 */
#define WIDGET_TYPE           0x00FF0000
#define WIDGET_LABEL          0x00010000
#define WIDGET_ENTRY          0x00020000
#define WIDGET_EDIT           0x00030000
#define WIDGET_BUTTON         0x00040000
#define WIDGET_CHECKBOX       0x00050000
#define WIDGET_RADIO          0x00060000
#define WIDGET_LIST           0x00070000
#define WIDGET_TABLE          0x00080000
#define WIDGET_COMBO          0x00090000
#define WIDGET_OKBUTTON       0x000A0000
#define WIDGET_CANCELBUTTON   0x000B0000
#define WIDGET_HELPBUTTON     0x000C0000
#define WIDGET_NOBUTTON       0x000D0000
#define WIDGET_YESBUTTON      0x000E0000
#define WIDGET_SCROLLEDW      0x000F0000
#define WIDGET_VBOX           0x00100000
#define WIDGET_HBOX           0x00200000
#define WIDGET_FRAME          0x00300000
#define WIDGET_NOTEBOOK       0x00310000
#define WIDGET_WINDOW         0x00400000
#define WIDGET_PIXMAP         0x00500000
#define WIDGET_MENUBAR        0x00600000
#define WIDGET_MENU           0x00700000
#define WIDGET_MENUITEM       0x00800000
#define WIDGET_GVIM           0x00900000
#define WIDGET_TREE           0x00A00000
#define WIDGET_CHOOSER        0x00A10000

/*                                   - Widget subtype    */
/*                              xxxxxxxx                 */
#define WIDGET_SUBTYPE        0x00000F00
/*                                  - Command            */
/*                              xxxxxxxx                 */
#define COMMAND               0x0000F000
#define PUSH                  0x00001000
#define SUM                   0x00002000
#define SET                   0x00003000
/*                                    -- Attribute           */
/*                              xxxxxxxx                 */
#define ATTRIBUTE             0x000000ff
#define ATTR_LABEL            0x00000001
#define ATTR_DEFAULT          0x00000002
#define ATTR_VARIABLE         0x00000003
#define ATTR_HEIGHT           0x00000004
#define ATTR_WIDTH            0x00000005
#define ATTR_INPUT            0x00000006
#define ATTR_VISIBLE          0x00000007
#define ATTR_ACTION           0x00000008
#define ATTR_ITEM             0x00000009
#define ATTR_OUTPUT           0x0000000A
#define ATTR_SOCKET           0x0000000B

/*                               - Sub attribute         */
/*                              xxxxxxxx                 */
#define SUB_ATTRIBUTE         0x0F000000
#define SUB_ATTR_SHELL        0x01000000
#define SUB_ATTR_FILE         0x02000000
#define SUB_ATTR_CLEAR        0x03000000
#define SUB_ATTR_APPEND       0x04000000
#define SUB_ATTR_FILESEL      0x0A000000
#define SUB_ATTR_REMOVE       0x0B000000
#define SUB_ATTR_REFRESH      0x0C000000
#define SUB_ATTR_LAUNCH       0x0D000000

/*
** Functions in the automaton.c
*/
stackelement _sum( stackelement a, stackelement b);
void fileselection_made( GtkWidget *w, actioncommand *action );

void fill_text_by_file( GtkTextBuffer *buffer, char *filename );
void fill_list_by_glist( GtkWidget *list, GList *glist );
void fill_clist_by_glist( GtkWidget *list, int col, GList *glist );
void fill_list_by_command( GtkWidget *list, char *command );
void fill_entry_by_command( GtkWidget *entry, char *command);
void fill_table_by_command( GtkWidget *list, char *command );
void window_title(char *string);
void button_pressed(GtkWidget *, gpointer);

int token_store(token command);
int token_store_attr(token command, tag_attr *attributes);
int token_store_with_argument_attr(token command, const char *argument, tag_attr *attributes);
int token_store_with_argument( token command, const char *argument);


#endif
